package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConvertFee invokes the companyreg.ConvertFee API synchronously
func (client *Client) ConvertFee(request *ConvertFeeRequest) (response *ConvertFeeResponse, err error) {
	response = CreateConvertFeeResponse()
	err = client.DoAction(request, response)
	return
}

// ConvertFeeWithChan invokes the companyreg.ConvertFee API asynchronously
func (client *Client) ConvertFeeWithChan(request *ConvertFeeRequest) (<-chan *ConvertFeeResponse, <-chan error) {
	responseChan := make(chan *ConvertFeeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConvertFee(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConvertFeeWithCallback invokes the companyreg.ConvertFee API asynchronously
func (client *Client) ConvertFeeWithCallback(request *ConvertFeeRequest, callback func(response *ConvertFeeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConvertFeeResponse
		var err error
		defer close(result)
		response, err = client.ConvertFee(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConvertFeeRequest is the request struct for api ConvertFee
type ConvertFeeRequest struct {
	*requests.RpcRequest
	Kind      string           `position:"Query" name:"Kind"`
	Use       string           `position:"Query" name:"Use"`
	Payer     string           `position:"Query" name:"Payer"`
	PayMethod string           `position:"Query" name:"PayMethod"`
	BizId     string           `position:"Query" name:"BizId"`
	Id        requests.Integer `position:"Query" name:"Id"`
}

// ConvertFeeResponse is the response struct for api ConvertFee
type ConvertFeeResponse struct {
	*responses.BaseResponse
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConvertFeeRequest creates a request to invoke ConvertFee API
func CreateConvertFeeRequest() (request *ConvertFeeRequest) {
	request = &ConvertFeeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "ConvertFee", "", "")
	request.Method = requests.POST
	return
}

// CreateConvertFeeResponse creates a response to parse from ConvertFee response
func CreateConvertFeeResponse() (response *ConvertFeeResponse) {
	response = &ConvertFeeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
