package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckSavePayrollDetail invokes the companyreg.CheckSavePayrollDetail API synchronously
func (client *Client) CheckSavePayrollDetail(request *CheckSavePayrollDetailRequest) (response *CheckSavePayrollDetailResponse, err error) {
	response = CreateCheckSavePayrollDetailResponse()
	err = client.DoAction(request, response)
	return
}

// CheckSavePayrollDetailWithChan invokes the companyreg.CheckSavePayrollDetail API asynchronously
func (client *Client) CheckSavePayrollDetailWithChan(request *CheckSavePayrollDetailRequest) (<-chan *CheckSavePayrollDetailResponse, <-chan error) {
	responseChan := make(chan *CheckSavePayrollDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckSavePayrollDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckSavePayrollDetailWithCallback invokes the companyreg.CheckSavePayrollDetail API asynchronously
func (client *Client) CheckSavePayrollDetailWithCallback(request *CheckSavePayrollDetailRequest, callback func(response *CheckSavePayrollDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckSavePayrollDetailResponse
		var err error
		defer close(result)
		response, err = client.CheckSavePayrollDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckSavePayrollDetailRequest is the request struct for api CheckSavePayrollDetail
type CheckSavePayrollDetailRequest struct {
	*requests.RpcRequest
	Income                           string           `position:"Query" name:"Income"`
	CorporateHousingAccumulationFund string           `position:"Query" name:"CorporateHousingAccumulationFund"`
	PersonHousingAccumulationFund    string           `position:"Query" name:"PersonHousingAccumulationFund"`
	PersMedicalInsurance             string           `position:"Query" name:"PersMedicalInsurance"`
	CorpUnemploymentInsurance        string           `position:"Query" name:"CorpUnemploymentInsurance"`
	Id                               requests.Integer `position:"Query" name:"Id"`
	PersonSocialInsurance            string           `position:"Query" name:"PersonSocialInsurance"`
	Period                           string           `position:"Query" name:"Period"`
	CorporateSocialInsurance         string           `position:"Query" name:"CorporateSocialInsurance"`
	CorpInjuryInsurance              string           `position:"Query" name:"CorpInjuryInsurance"`
	PersPension                      string           `position:"Query" name:"PersPension"`
	CorpMedicalInsurance             string           `position:"Query" name:"CorpMedicalInsurance"`
	IdNo                             string           `position:"Query" name:"IdNo"`
	EmployeeTime                     string           `position:"Query" name:"EmployeeTime"`
	UpdateEmployeeFlag               requests.Boolean `position:"Query" name:"UpdateEmployeeFlag"`
	Phone                            string           `position:"Query" name:"Phone"`
	PersUnemploymentInsurance        string           `position:"Query" name:"PersUnemploymentInsurance"`
	BizId                            string           `position:"Query" name:"BizId"`
	Name                             string           `position:"Query" name:"Name"`
	CorpPension                      string           `position:"Query" name:"CorpPension"`
	CorpMaternityInsurance           string           `position:"Query" name:"CorpMaternityInsurance"`
}

// CheckSavePayrollDetailResponse is the response struct for api CheckSavePayrollDetail
type CheckSavePayrollDetailResponse struct {
	*responses.BaseResponse
	IsExists  bool   `json:"IsExists" xml:"IsExists"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateCheckSavePayrollDetailRequest creates a request to invoke CheckSavePayrollDetail API
func CreateCheckSavePayrollDetailRequest() (request *CheckSavePayrollDetailRequest) {
	request = &CheckSavePayrollDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "CheckSavePayrollDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckSavePayrollDetailResponse creates a response to parse from CheckSavePayrollDetail response
func CreateCheckSavePayrollDetailResponse() (response *CheckSavePayrollDetailResponse) {
	response = &CheckSavePayrollDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
