package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AcceptBookkeepingDetailStatusChange invokes the companyreg.AcceptBookkeepingDetailStatusChange API synchronously
func (client *Client) AcceptBookkeepingDetailStatusChange(request *AcceptBookkeepingDetailStatusChangeRequest) (response *AcceptBookkeepingDetailStatusChangeResponse, err error) {
	response = CreateAcceptBookkeepingDetailStatusChangeResponse()
	err = client.DoAction(request, response)
	return
}

// AcceptBookkeepingDetailStatusChangeWithChan invokes the companyreg.AcceptBookkeepingDetailStatusChange API asynchronously
func (client *Client) AcceptBookkeepingDetailStatusChangeWithChan(request *AcceptBookkeepingDetailStatusChangeRequest) (<-chan *AcceptBookkeepingDetailStatusChangeResponse, <-chan error) {
	responseChan := make(chan *AcceptBookkeepingDetailStatusChangeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AcceptBookkeepingDetailStatusChange(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AcceptBookkeepingDetailStatusChangeWithCallback invokes the companyreg.AcceptBookkeepingDetailStatusChange API asynchronously
func (client *Client) AcceptBookkeepingDetailStatusChangeWithCallback(request *AcceptBookkeepingDetailStatusChangeRequest, callback func(response *AcceptBookkeepingDetailStatusChangeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AcceptBookkeepingDetailStatusChangeResponse
		var err error
		defer close(result)
		response, err = client.AcceptBookkeepingDetailStatusChange(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AcceptBookkeepingDetailStatusChangeRequest is the request struct for api AcceptBookkeepingDetailStatusChange
type AcceptBookkeepingDetailStatusChangeRequest struct {
	*requests.RpcRequest
	BizId     string           `position:"Query" name:"BizId"`
	TaxAmount string           `position:"Query" name:"TaxAmount"`
	Status    requests.Integer `position:"Query" name:"Status"`
}

// AcceptBookkeepingDetailStatusChangeResponse is the response struct for api AcceptBookkeepingDetailStatusChange
type AcceptBookkeepingDetailStatusChangeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAcceptBookkeepingDetailStatusChangeRequest creates a request to invoke AcceptBookkeepingDetailStatusChange API
func CreateAcceptBookkeepingDetailStatusChangeRequest() (request *AcceptBookkeepingDetailStatusChangeRequest) {
	request = &AcceptBookkeepingDetailStatusChangeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "AcceptBookkeepingDetailStatusChange", "", "")
	request.Method = requests.POST
	return
}

// CreateAcceptBookkeepingDetailStatusChangeResponse creates a response to parse from AcceptBookkeepingDetailStatusChange response
func CreateAcceptBookkeepingDetailStatusChangeResponse() (response *AcceptBookkeepingDetailStatusChangeResponse) {
	response = &AcceptBookkeepingDetailStatusChangeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
