package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutLogMonitor invokes the cms.PutLogMonitor API synchronously
func (client *Client) PutLogMonitor(request *PutLogMonitorRequest) (response *PutLogMonitorResponse, err error) {
	response = CreatePutLogMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// PutLogMonitorWithChan invokes the cms.PutLogMonitor API asynchronously
func (client *Client) PutLogMonitorWithChan(request *PutLogMonitorRequest) (<-chan *PutLogMonitorResponse, <-chan error) {
	responseChan := make(chan *PutLogMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutLogMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutLogMonitorWithCallback invokes the cms.PutLogMonitor API asynchronously
func (client *Client) PutLogMonitorWithCallback(request *PutLogMonitorRequest, callback func(response *PutLogMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutLogMonitorResponse
		var err error
		defer close(result)
		response, err = client.PutLogMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutLogMonitorRequest is the request struct for api PutLogMonitor
type PutLogMonitorRequest struct {
	*requests.RpcRequest
	SlsLogstore         string                      `position:"Query" name:"SlsLogstore"`
	SlsProject          string                      `position:"Query" name:"SlsProject"`
	ValueFilter         *[]PutLogMonitorValueFilter `position:"Query" name:"ValueFilter"  type:"Repeated"`
	MetricExpress       string                      `position:"Query" name:"MetricExpress"`
	SlsRegionId         string                      `position:"Query" name:"SlsRegionId"`
	MetricName          string                      `position:"Query" name:"MetricName"`
	GroupId             string                      `position:"Query" name:"GroupId"`
	Tumblingwindows     string                      `position:"Query" name:"Tumblingwindows"`
	GroupBy             string                      `position:"Query" name:"GroupBy"`
	ValueFilterRelation string                      `position:"Query" name:"ValueFilterRelation"`
	Unit                string                      `position:"Query" name:"Unit"`
	Groupbys            *[]PutLogMonitorGroupbys    `position:"Query" name:"Groupbys"  type:"Repeated"`
	LogId               string                      `position:"Query" name:"LogId"`
	Aggregates          *[]PutLogMonitorAggregates  `position:"Query" name:"Aggregates"  type:"Repeated"`
}

// PutLogMonitorValueFilter is a repeated param struct in PutLogMonitorRequest
type PutLogMonitorValueFilter struct {
	Value    string `name:"Value"`
	Key      string `name:"Key"`
	Operator string `name:"Operator"`
}

// PutLogMonitorGroupbys is a repeated param struct in PutLogMonitorRequest
type PutLogMonitorGroupbys struct {
	FieldName string `name:"FieldName"`
	Alias     string `name:"Alias"`
}

// PutLogMonitorAggregates is a repeated param struct in PutLogMonitorRequest
type PutLogMonitorAggregates struct {
	FieldName string `name:"FieldName"`
	Function  string `name:"Function"`
	Alias     string `name:"Alias"`
}

// PutLogMonitorResponse is the response struct for api PutLogMonitor
type PutLogMonitorResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	LogId     string `json:"LogId" xml:"LogId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreatePutLogMonitorRequest creates a request to invoke PutLogMonitor API
func CreatePutLogMonitorRequest() (request *PutLogMonitorRequest) {
	request = &PutLogMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "PutLogMonitor", "Cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePutLogMonitorResponse creates a response to parse from PutLogMonitor response
func CreatePutLogMonitorResponse() (response *PutLogMonitorResponse) {
	response = &PutLogMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
