package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SavePortalTemplate invokes the cloudwf.SavePortalTemplate API synchronously
// api document: https://help.aliyun.com/api/cloudwf/saveportaltemplate.html
func (client *Client) SavePortalTemplate(request *SavePortalTemplateRequest) (response *SavePortalTemplateResponse, err error) {
	response = CreateSavePortalTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// SavePortalTemplateWithChan invokes the cloudwf.SavePortalTemplate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveportaltemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SavePortalTemplateWithChan(request *SavePortalTemplateRequest) (<-chan *SavePortalTemplateResponse, <-chan error) {
	responseChan := make(chan *SavePortalTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SavePortalTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SavePortalTemplateWithCallback invokes the cloudwf.SavePortalTemplate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveportaltemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SavePortalTemplateWithCallback(request *SavePortalTemplateRequest, callback func(response *SavePortalTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SavePortalTemplateResponse
		var err error
		defer close(result)
		response, err = client.SavePortalTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SavePortalTemplateRequest is the request struct for api SavePortalTemplate
type SavePortalTemplateRequest struct {
	*requests.RpcRequest
	TextContent string           `position:"Query" name:"TextContent"`
	TempName    string           `position:"Query" name:"TempName"`
	TextAlign   string           `position:"Query" name:"TextAlign"`
	TextColor   string           `position:"Query" name:"TextColor"`
	Id          requests.Integer `position:"Query" name:"Id"`
	OssFileId   requests.Integer `position:"Query" name:"OssFileId"`
}

// SavePortalTemplateResponse is the response struct for api SavePortalTemplate
type SavePortalTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateSavePortalTemplateRequest creates a request to invoke SavePortalTemplate API
func CreateSavePortalTemplateRequest() (request *SavePortalTemplateRequest) {
	request = &SavePortalTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "SavePortalTemplate", "cloudwf", "openAPI")
	return
}

// CreateSavePortalTemplateResponse creates a response to parse from SavePortalTemplate response
func CreateSavePortalTemplateResponse() (response *SavePortalTemplateResponse) {
	response = &SavePortalTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
