package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApUpgrade invokes the cloudwf.ListApUpgrade API synchronously
// api document: https://help.aliyun.com/api/cloudwf/listapupgrade.html
func (client *Client) ListApUpgrade(request *ListApUpgradeRequest) (response *ListApUpgradeResponse, err error) {
	response = CreateListApUpgradeResponse()
	err = client.DoAction(request, response)
	return
}

// ListApUpgradeWithChan invokes the cloudwf.ListApUpgrade API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listapupgrade.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListApUpgradeWithChan(request *ListApUpgradeRequest) (<-chan *ListApUpgradeResponse, <-chan error) {
	responseChan := make(chan *ListApUpgradeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApUpgrade(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApUpgradeWithCallback invokes the cloudwf.ListApUpgrade API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listapupgrade.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListApUpgradeWithCallback(request *ListApUpgradeRequest, callback func(response *ListApUpgradeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApUpgradeResponse
		var err error
		defer close(result)
		response, err = client.ListApUpgrade(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApUpgradeRequest is the request struct for api ListApUpgrade
type ListApUpgradeRequest struct {
	*requests.RpcRequest
	OrderCol          string           `position:"Query" name:"OrderCol"`
	SearchName        string           `position:"Query" name:"SearchName"`
	SearchApModelName string           `position:"Query" name:"SearchApModelName"`
	Length            requests.Integer `position:"Query" name:"Length"`
	SearchMac         string           `position:"Query" name:"SearchMac"`
	PageIndex         requests.Integer `position:"Query" name:"PageIndex"`
	OrderDir          string           `position:"Query" name:"OrderDir"`
}

// ListApUpgradeResponse is the response struct for api ListApUpgrade
type ListApUpgradeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateListApUpgradeRequest creates a request to invoke ListApUpgrade API
func CreateListApUpgradeRequest() (request *ListApUpgradeRequest) {
	request = &ListApUpgradeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ListApUpgrade", "cloudwf", "openAPI")
	return
}

// CreateListApUpgradeResponse creates a response to parse from ListApUpgrade response
func CreateListApUpgradeResponse() (response *ListApUpgradeResponse) {
	response = &ListApUpgradeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
