package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApPositionStatus invokes the cloudwf.ListApPositionStatus API synchronously
// api document: https://help.aliyun.com/api/cloudwf/listappositionstatus.html
func (client *Client) ListApPositionStatus(request *ListApPositionStatusRequest) (response *ListApPositionStatusResponse, err error) {
	response = CreateListApPositionStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ListApPositionStatusWithChan invokes the cloudwf.ListApPositionStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listappositionstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListApPositionStatusWithChan(request *ListApPositionStatusRequest) (<-chan *ListApPositionStatusResponse, <-chan error) {
	responseChan := make(chan *ListApPositionStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApPositionStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApPositionStatusWithCallback invokes the cloudwf.ListApPositionStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listappositionstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListApPositionStatusWithCallback(request *ListApPositionStatusRequest, callback func(response *ListApPositionStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApPositionStatusResponse
		var err error
		defer close(result)
		response, err = client.ListApPositionStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApPositionStatusRequest is the request struct for api ListApPositionStatus
type ListApPositionStatusRequest struct {
	*requests.RpcRequest
	JsonData string `position:"Query" name:"JsonData"`
}

// ListApPositionStatusResponse is the response struct for api ListApPositionStatus
type ListApPositionStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateListApPositionStatusRequest creates a request to invoke ListApPositionStatus API
func CreateListApPositionStatusRequest() (request *ListApPositionStatusRequest) {
	request = &ListApPositionStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ListApPositionStatus", "cloudwf", "openAPI")
	return
}

// CreateListApPositionStatusResponse creates a response to parse from ListApPositionStatus response
func CreateListApPositionStatusResponse() (response *ListApPositionStatusResponse) {
	response = &ListApPositionStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
