package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetProbeDataSubscriberConfig invokes the cloudwf.GetProbeDataSubscriberConfig API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getprobedatasubscriberconfig.html
func (client *Client) GetProbeDataSubscriberConfig(request *GetProbeDataSubscriberConfigRequest) (response *GetProbeDataSubscriberConfigResponse, err error) {
	response = CreateGetProbeDataSubscriberConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetProbeDataSubscriberConfigWithChan invokes the cloudwf.GetProbeDataSubscriberConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getprobedatasubscriberconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProbeDataSubscriberConfigWithChan(request *GetProbeDataSubscriberConfigRequest) (<-chan *GetProbeDataSubscriberConfigResponse, <-chan error) {
	responseChan := make(chan *GetProbeDataSubscriberConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetProbeDataSubscriberConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetProbeDataSubscriberConfigWithCallback invokes the cloudwf.GetProbeDataSubscriberConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getprobedatasubscriberconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProbeDataSubscriberConfigWithCallback(request *GetProbeDataSubscriberConfigRequest, callback func(response *GetProbeDataSubscriberConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetProbeDataSubscriberConfigResponse
		var err error
		defer close(result)
		response, err = client.GetProbeDataSubscriberConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetProbeDataSubscriberConfigRequest is the request struct for api GetProbeDataSubscriberConfig
type GetProbeDataSubscriberConfigRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// GetProbeDataSubscriberConfigResponse is the response struct for api GetProbeDataSubscriberConfig
type GetProbeDataSubscriberConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetProbeDataSubscriberConfigRequest creates a request to invoke GetProbeDataSubscriberConfig API
func CreateGetProbeDataSubscriberConfigRequest() (request *GetProbeDataSubscriberConfigRequest) {
	request = &GetProbeDataSubscriberConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetProbeDataSubscriberConfig", "cloudwf", "openAPI")
	return
}

// CreateGetProbeDataSubscriberConfigResponse creates a response to parse from GetProbeDataSubscriberConfig response
func CreateGetProbeDataSubscriberConfigResponse() (response *GetProbeDataSubscriberConfigResponse) {
	response = &GetProbeDataSubscriberConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
