package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAllActiveShopByGroup invokes the cloudwf.GetAllActiveShopByGroup API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getallactiveshopbygroup.html
func (client *Client) GetAllActiveShopByGroup(request *GetAllActiveShopByGroupRequest) (response *GetAllActiveShopByGroupResponse, err error) {
	response = CreateGetAllActiveShopByGroupResponse()
	err = client.DoAction(request, response)
	return
}

// GetAllActiveShopByGroupWithChan invokes the cloudwf.GetAllActiveShopByGroup API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getallactiveshopbygroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAllActiveShopByGroupWithChan(request *GetAllActiveShopByGroupRequest) (<-chan *GetAllActiveShopByGroupResponse, <-chan error) {
	responseChan := make(chan *GetAllActiveShopByGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAllActiveShopByGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAllActiveShopByGroupWithCallback invokes the cloudwf.GetAllActiveShopByGroup API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getallactiveshopbygroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAllActiveShopByGroupWithCallback(request *GetAllActiveShopByGroupRequest, callback func(response *GetAllActiveShopByGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAllActiveShopByGroupResponse
		var err error
		defer close(result)
		response, err = client.GetAllActiveShopByGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAllActiveShopByGroupRequest is the request struct for api GetAllActiveShopByGroup
type GetAllActiveShopByGroupRequest struct {
	*requests.RpcRequest
	Gids *[]string        `position:"Query" name:"Gids"  type:"Repeated"`
	Bid  requests.Integer `position:"Query" name:"Bid"`
}

// GetAllActiveShopByGroupResponse is the response struct for api GetAllActiveShopByGroup
type GetAllActiveShopByGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetAllActiveShopByGroupRequest creates a request to invoke GetAllActiveShopByGroup API
func CreateGetAllActiveShopByGroupRequest() (request *GetAllActiveShopByGroupRequest) {
	request = &GetAllActiveShopByGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetAllActiveShopByGroup", "cloudwf", "openAPI")
	return
}

// CreateGetAllActiveShopByGroupResponse creates a response to parse from GetAllActiveShopByGroup response
func CreateGetAllActiveShopByGroupResponse() (response *GetAllActiveShopByGroupResponse) {
	response = &GetAllActiveShopByGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
