package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeviceDelete invokes the cloudwf.DeviceDelete API synchronously
// api document: https://help.aliyun.com/api/cloudwf/devicedelete.html
func (client *Client) DeviceDelete(request *DeviceDeleteRequest) (response *DeviceDeleteResponse, err error) {
	response = CreateDeviceDeleteResponse()
	err = client.DoAction(request, response)
	return
}

// DeviceDeleteWithChan invokes the cloudwf.DeviceDelete API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/devicedelete.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeviceDeleteWithChan(request *DeviceDeleteRequest) (<-chan *DeviceDeleteResponse, <-chan error) {
	responseChan := make(chan *DeviceDeleteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeviceDelete(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeviceDeleteWithCallback invokes the cloudwf.DeviceDelete API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/devicedelete.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeviceDeleteWithCallback(request *DeviceDeleteRequest, callback func(response *DeviceDeleteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeviceDeleteResponse
		var err error
		defer close(result)
		response, err = client.DeviceDelete(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeviceDeleteRequest is the request struct for api DeviceDelete
type DeviceDeleteRequest struct {
	*requests.RpcRequest
	Did requests.Integer `position:"Query" name:"Did"`
	Mac string           `position:"Query" name:"Mac"`
}

// DeviceDeleteResponse is the response struct for api DeviceDelete
type DeviceDeleteResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateDeviceDeleteRequest creates a request to invoke DeviceDelete API
func CreateDeviceDeleteRequest() (request *DeviceDeleteRequest) {
	request = &DeviceDeleteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "DeviceDelete", "cloudwf", "openAPI")
	return
}

// CreateDeviceDeleteResponse creates a response to parse from DeviceDelete response
func CreateDeviceDeleteResponse() (response *DeviceDeleteResponse) {
	response = &DeviceDeleteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
