package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DelUmengPagePermission4Root invokes the cloudwf.DelUmengPagePermission4Root API synchronously
// api document: https://help.aliyun.com/api/cloudwf/delumengpagepermission4root.html
func (client *Client) DelUmengPagePermission4Root(request *DelUmengPagePermission4RootRequest) (response *DelUmengPagePermission4RootResponse, err error) {
	response = CreateDelUmengPagePermission4RootResponse()
	err = client.DoAction(request, response)
	return
}

// DelUmengPagePermission4RootWithChan invokes the cloudwf.DelUmengPagePermission4Root API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/delumengpagepermission4root.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DelUmengPagePermission4RootWithChan(request *DelUmengPagePermission4RootRequest) (<-chan *DelUmengPagePermission4RootResponse, <-chan error) {
	responseChan := make(chan *DelUmengPagePermission4RootResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DelUmengPagePermission4Root(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DelUmengPagePermission4RootWithCallback invokes the cloudwf.DelUmengPagePermission4Root API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/delumengpagepermission4root.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DelUmengPagePermission4RootWithCallback(request *DelUmengPagePermission4RootRequest, callback func(response *DelUmengPagePermission4RootResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DelUmengPagePermission4RootResponse
		var err error
		defer close(result)
		response, err = client.DelUmengPagePermission4Root(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DelUmengPagePermission4RootRequest is the request struct for api DelUmengPagePermission4Root
type DelUmengPagePermission4RootRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// DelUmengPagePermission4RootResponse is the response struct for api DelUmengPagePermission4Root
type DelUmengPagePermission4RootResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateDelUmengPagePermission4RootRequest creates a request to invoke DelUmengPagePermission4Root API
func CreateDelUmengPagePermission4RootRequest() (request *DelUmengPagePermission4RootRequest) {
	request = &DelUmengPagePermission4RootRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "DelUmengPagePermission4Root", "cloudwf", "openAPI")
	return
}

// CreateDelUmengPagePermission4RootResponse creates a response to parse from DelUmengPagePermission4Root response
func CreateDelUmengPagePermission4RootResponse() (response *DelUmengPagePermission4RootResponse) {
	response = &DelUmengPagePermission4RootResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
