package cloudphoto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPhotosByMd5s invokes the cloudphoto.GetPhotosByMd5s API synchronously
// api document: https://help.aliyun.com/api/cloudphoto/getphotosbymd5s.html
func (client *Client) GetPhotosByMd5s(request *GetPhotosByMd5sRequest) (response *GetPhotosByMd5sResponse, err error) {
	response = CreateGetPhotosByMd5sResponse()
	err = client.DoAction(request, response)
	return
}

// GetPhotosByMd5sWithChan invokes the cloudphoto.GetPhotosByMd5s API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/getphotosbymd5s.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPhotosByMd5sWithChan(request *GetPhotosByMd5sRequest) (<-chan *GetPhotosByMd5sResponse, <-chan error) {
	responseChan := make(chan *GetPhotosByMd5sResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPhotosByMd5s(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPhotosByMd5sWithCallback invokes the cloudphoto.GetPhotosByMd5s API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/getphotosbymd5s.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPhotosByMd5sWithCallback(request *GetPhotosByMd5sRequest, callback func(response *GetPhotosByMd5sResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPhotosByMd5sResponse
		var err error
		defer close(result)
		response, err = client.GetPhotosByMd5s(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPhotosByMd5sRequest is the request struct for api GetPhotosByMd5s
type GetPhotosByMd5sRequest struct {
	*requests.RpcRequest
	LibraryId string    `position:"Query" name:"LibraryId"`
	StoreName string    `position:"Query" name:"StoreName"`
	State     string    `position:"Query" name:"State"`
	Md5       *[]string `position:"Query" name:"Md5"  type:"Repeated"`
}

// GetPhotosByMd5sResponse is the response struct for api GetPhotosByMd5s
type GetPhotosByMd5sResponse struct {
	*responses.BaseResponse
	Code      string  `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Action    string  `json:"Action" xml:"Action"`
	Photos    []Photo `json:"Photos" xml:"Photos"`
}

// CreateGetPhotosByMd5sRequest creates a request to invoke GetPhotosByMd5s API
func CreateGetPhotosByMd5sRequest() (request *GetPhotosByMd5sRequest) {
	request = &GetPhotosByMd5sRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudPhoto", "2017-07-11", "GetPhotosByMd5s", "cloudphoto", "openAPI")
	return
}

// CreateGetPhotosByMd5sResponse creates a response to parse from GetPhotosByMd5s response
func CreateGetPhotosByMd5sResponse() (response *GetPhotosByMd5sResponse) {
	response = &GetPhotosByMd5sResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
