package cloudgameapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetItem invokes the cloudgameapi.GetItem API synchronously
func (client *Client) GetItem(request *GetItemRequest) (response *GetItemResponse, err error) {
	response = CreateGetItemResponse()
	err = client.DoAction(request, response)
	return
}

// GetItemWithChan invokes the cloudgameapi.GetItem API asynchronously
func (client *Client) GetItemWithChan(request *GetItemRequest) (<-chan *GetItemResponse, <-chan error) {
	responseChan := make(chan *GetItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetItemWithCallback invokes the cloudgameapi.GetItem API asynchronously
func (client *Client) GetItemWithCallback(request *GetItemRequest, callback func(response *GetItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetItemResponse
		var err error
		defer close(result)
		response, err = client.GetItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetItemRequest is the request struct for api GetItem
type GetItemRequest struct {
	*requests.RpcRequest
	ItemId string `position:"Query" name:"ItemId"`
}

// GetItemResponse is the response struct for api GetItem
type GetItemResponse struct {
	*responses.BaseResponse
	RequestId string        `json:"RequestId" xml:"RequestId"`
	Data      DataInGetItem `json:"Data" xml:"Data"`
}

// CreateGetItemRequest creates a request to invoke GetItem API
func CreateGetItemRequest() (request *GetItemRequest) {
	request = &GetItemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudGameAPI", "2020-07-28", "GetItem", "", "")
	request.Method = requests.POST
	return
}

// CreateGetItemResponse creates a response to parse from GetItem response
func CreateGetItemResponse() (response *GetItemResponse) {
	response = &GetItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
