package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// List400PicLink invokes the cloudcallcenter.List400PicLink API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/list400piclink.html
func (client *Client) List400PicLink(request *List400PicLinkRequest) (response *List400PicLinkResponse, err error) {
	response = CreateList400PicLinkResponse()
	err = client.DoAction(request, response)
	return
}

// List400PicLinkWithChan invokes the cloudcallcenter.List400PicLink API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/list400piclink.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) List400PicLinkWithChan(request *List400PicLinkRequest) (<-chan *List400PicLinkResponse, <-chan error) {
	responseChan := make(chan *List400PicLinkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.List400PicLink(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// List400PicLinkWithCallback invokes the cloudcallcenter.List400PicLink API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/list400piclink.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) List400PicLinkWithCallback(request *List400PicLinkRequest, callback func(response *List400PicLinkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *List400PicLinkResponse
		var err error
		defer close(result)
		response, err = client.List400PicLink(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// List400PicLinkRequest is the request struct for api List400PicLink
type List400PicLinkRequest struct {
	*requests.RpcRequest
	Pics string `position:"Query" name:"Pics"`
}

// List400PicLinkResponse is the response struct for api List400PicLink
type List400PicLinkResponse struct {
	*responses.BaseResponse
	RequestId      string               `json:"RequestId" xml:"RequestId"`
	Success        bool                 `json:"Success" xml:"Success"`
	Code           string               `json:"Code" xml:"Code"`
	Message        string               `json:"Message" xml:"Message"`
	HttpStatusCode int                  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           DataInList400PicLink `json:"Data" xml:"Data"`
}

// CreateList400PicLinkRequest creates a request to invoke List400PicLink API
func CreateList400PicLinkRequest() (request *List400PicLinkRequest) {
	request = &List400PicLinkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "List400PicLink", "", "")
	request.Method = requests.POST
	return
}

// CreateList400PicLinkResponse creates a response to parse from List400PicLink response
func CreateList400PicLinkResponse() (response *List400PicLinkResponse) {
	response = &List400PicLinkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
