package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Get400OrderNumberList invokes the cloudcallcenter.Get400OrderNumberList API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/get400ordernumberlist.html
func (client *Client) Get400OrderNumberList(request *Get400OrderNumberListRequest) (response *Get400OrderNumberListResponse, err error) {
	response = CreateGet400OrderNumberListResponse()
	err = client.DoAction(request, response)
	return
}

// Get400OrderNumberListWithChan invokes the cloudcallcenter.Get400OrderNumberList API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/get400ordernumberlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) Get400OrderNumberListWithChan(request *Get400OrderNumberListRequest) (<-chan *Get400OrderNumberListResponse, <-chan error) {
	responseChan := make(chan *Get400OrderNumberListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Get400OrderNumberList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// Get400OrderNumberListWithCallback invokes the cloudcallcenter.Get400OrderNumberList API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/get400ordernumberlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) Get400OrderNumberListWithCallback(request *Get400OrderNumberListRequest, callback func(response *Get400OrderNumberListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *Get400OrderNumberListResponse
		var err error
		defer close(result)
		response, err = client.Get400OrderNumberList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// Get400OrderNumberListRequest is the request struct for api Get400OrderNumberList
type Get400OrderNumberListRequest struct {
	*requests.RpcRequest
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
}

// Get400OrderNumberListResponse is the response struct for api Get400OrderNumberList
type Get400OrderNumberListResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGet400OrderNumberListRequest creates a request to invoke Get400OrderNumberList API
func CreateGet400OrderNumberListRequest() (request *Get400OrderNumberListRequest) {
	request = &Get400OrderNumberListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "Get400OrderNumberList", "", "")
	request.Method = requests.POST
	return
}

// CreateGet400OrderNumberListResponse creates a response to parse from Get400OrderNumberList response
func CreateGet400OrderNumberListResponse() (response *Get400OrderNumberListResponse) {
	response = &Get400OrderNumberListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
