package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateBasicStatisticsReport invokes the cloudcallcenter.GenerateBasicStatisticsReport API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/generatebasicstatisticsreport.html
func (client *Client) GenerateBasicStatisticsReport(request *GenerateBasicStatisticsReportRequest) (response *GenerateBasicStatisticsReportResponse, err error) {
	response = CreateGenerateBasicStatisticsReportResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateBasicStatisticsReportWithChan invokes the cloudcallcenter.GenerateBasicStatisticsReport API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/generatebasicstatisticsreport.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GenerateBasicStatisticsReportWithChan(request *GenerateBasicStatisticsReportRequest) (<-chan *GenerateBasicStatisticsReportResponse, <-chan error) {
	responseChan := make(chan *GenerateBasicStatisticsReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateBasicStatisticsReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateBasicStatisticsReportWithCallback invokes the cloudcallcenter.GenerateBasicStatisticsReport API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/generatebasicstatisticsreport.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GenerateBasicStatisticsReportWithCallback(request *GenerateBasicStatisticsReportRequest, callback func(response *GenerateBasicStatisticsReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateBasicStatisticsReportResponse
		var err error
		defer close(result)
		response, err = client.GenerateBasicStatisticsReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateBasicStatisticsReportRequest is the request struct for api GenerateBasicStatisticsReport
type GenerateBasicStatisticsReportRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	JobGroupId string `position:"Query" name:"JobGroupId"`
}

// GenerateBasicStatisticsReportResponse is the response struct for api GenerateBasicStatisticsReport
type GenerateBasicStatisticsReportResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Report         Report `json:"Report" xml:"Report"`
}

// CreateGenerateBasicStatisticsReportRequest creates a request to invoke GenerateBasicStatisticsReport API
func CreateGenerateBasicStatisticsReportRequest() (request *GenerateBasicStatisticsReportRequest) {
	request = &GenerateBasicStatisticsReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GenerateBasicStatisticsReport", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateBasicStatisticsReportResponse creates a response to parse from GenerateBasicStatisticsReport response
func CreateGenerateBasicStatisticsReportResponse() (response *GenerateBasicStatisticsReportResponse) {
	response = &GenerateBasicStatisticsReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
