package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DoPhysicalDeleteResource invokes the cloudcallcenter.DoPhysicalDeleteResource API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/dophysicaldeleteresource.html
func (client *Client) DoPhysicalDeleteResource(request *DoPhysicalDeleteResourceRequest) (response *DoPhysicalDeleteResourceResponse, err error) {
	response = CreateDoPhysicalDeleteResourceResponse()
	err = client.DoAction(request, response)
	return
}

// DoPhysicalDeleteResourceWithChan invokes the cloudcallcenter.DoPhysicalDeleteResource API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/dophysicaldeleteresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DoPhysicalDeleteResourceWithChan(request *DoPhysicalDeleteResourceRequest) (<-chan *DoPhysicalDeleteResourceResponse, <-chan error) {
	responseChan := make(chan *DoPhysicalDeleteResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DoPhysicalDeleteResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DoPhysicalDeleteResourceWithCallback invokes the cloudcallcenter.DoPhysicalDeleteResource API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/dophysicaldeleteresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DoPhysicalDeleteResourceWithCallback(request *DoPhysicalDeleteResourceRequest, callback func(response *DoPhysicalDeleteResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DoPhysicalDeleteResourceResponse
		var err error
		defer close(result)
		response, err = client.DoPhysicalDeleteResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DoPhysicalDeleteResourceRequest is the request struct for api DoPhysicalDeleteResource
type DoPhysicalDeleteResourceRequest struct {
	*requests.RpcRequest
	Country        string           `position:"Query" name:"Country"`
	Hid            requests.Integer `position:"Query" name:"Hid"`
	Invoker        string           `position:"Query" name:"Invoker"`
	Message        string           `position:"Query" name:"Message"`
	Success        requests.Boolean `position:"Query" name:"Success"`
	Interrupt      requests.Boolean `position:"Query" name:"Interrupt"`
	GmtWakeup      string           `position:"Query" name:"GmtWakeup"`
	Pk             string           `position:"Query" name:"Pk"`
	Bid            string           `position:"Query" name:"Bid"`
	TaskExtraData  string           `position:"Query" name:"TaskExtraData"`
	TaskIdentifier string           `position:"Query" name:"TaskIdentifier"`
}

// DoPhysicalDeleteResourceResponse is the response struct for api DoPhysicalDeleteResource
type DoPhysicalDeleteResourceResponse struct {
	*responses.BaseResponse
	Interrupt      bool   `json:"Interrupt" xml:"Interrupt"`
	Invoker        string `json:"Invoker" xml:"Invoker"`
	Pk             string `json:"Pk" xml:"Pk"`
	Bid            string `json:"Bid" xml:"Bid"`
	Hid            int64  `json:"Hid" xml:"Hid"`
	Country        string `json:"Country" xml:"Country"`
	TaskIdentifier string `json:"TaskIdentifier" xml:"TaskIdentifier"`
	TaskExtraData  string `json:"TaskExtraData" xml:"TaskExtraData"`
	GmtWakeup      string `json:"GmtWakeup" xml:"GmtWakeup"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
}

// CreateDoPhysicalDeleteResourceRequest creates a request to invoke DoPhysicalDeleteResource API
func CreateDoPhysicalDeleteResourceRequest() (request *DoPhysicalDeleteResourceRequest) {
	request = &DoPhysicalDeleteResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DoPhysicalDeleteResource", "", "")
	request.Method = requests.POST
	return
}

// CreateDoPhysicalDeleteResourceResponse creates a response to parse from DoPhysicalDeleteResource response
func CreateDoPhysicalDeleteResourceResponse() (response *DoPhysicalDeleteResourceResponse) {
	response = &DoPhysicalDeleteResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
