package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCdrsMonitorList invokes the cdrs.GetCdrsMonitorList API synchronously
func (client *Client) GetCdrsMonitorList(request *GetCdrsMonitorListRequest) (response *GetCdrsMonitorListResponse, err error) {
	response = CreateGetCdrsMonitorListResponse()
	err = client.DoAction(request, response)
	return
}

// GetCdrsMonitorListWithChan invokes the cdrs.GetCdrsMonitorList API asynchronously
func (client *Client) GetCdrsMonitorListWithChan(request *GetCdrsMonitorListRequest) (<-chan *GetCdrsMonitorListResponse, <-chan error) {
	responseChan := make(chan *GetCdrsMonitorListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCdrsMonitorList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCdrsMonitorListWithCallback invokes the cdrs.GetCdrsMonitorList API asynchronously
func (client *Client) GetCdrsMonitorListWithCallback(request *GetCdrsMonitorListRequest, callback func(response *GetCdrsMonitorListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCdrsMonitorListResponse
		var err error
		defer close(result)
		response, err = client.GetCdrsMonitorList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCdrsMonitorListRequest is the request struct for api GetCdrsMonitorList
type GetCdrsMonitorListRequest struct {
	*requests.RpcRequest
	CorpId   string           `position:"Body" name:"CorpId"`
	PageNo   requests.Integer `position:"Body" name:"PageNo"`
	PageSize requests.Integer `position:"Body" name:"PageSize"`
	BizId    string           `position:"Body" name:"BizId"`
}

// GetCdrsMonitorListResponse is the response struct for api GetCdrsMonitorList
type GetCdrsMonitorListResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetCdrsMonitorListRequest creates a request to invoke GetCdrsMonitorList API
func CreateGetCdrsMonitorListRequest() (request *GetCdrsMonitorListRequest) {
	request = &GetCdrsMonitorListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "GetCdrsMonitorList", "", "")
	request.Method = requests.POST
	return
}

// CreateGetCdrsMonitorListResponse creates a response to parse from GetCdrsMonitorList response
func CreateGetCdrsMonitorListResponse() (response *GetCdrsMonitorListResponse) {
	response = &GetCdrsMonitorListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
