package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResumePredictiveJobs invokes the ccc.ResumePredictiveJobs API synchronously
func (client *Client) ResumePredictiveJobs(request *ResumePredictiveJobsRequest) (response *ResumePredictiveJobsResponse, err error) {
	response = CreateResumePredictiveJobsResponse()
	err = client.DoAction(request, response)
	return
}

// ResumePredictiveJobsWithChan invokes the ccc.ResumePredictiveJobs API asynchronously
func (client *Client) ResumePredictiveJobsWithChan(request *ResumePredictiveJobsRequest) (<-chan *ResumePredictiveJobsResponse, <-chan error) {
	responseChan := make(chan *ResumePredictiveJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResumePredictiveJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResumePredictiveJobsWithCallback invokes the ccc.ResumePredictiveJobs API asynchronously
func (client *Client) ResumePredictiveJobsWithCallback(request *ResumePredictiveJobsRequest, callback func(response *ResumePredictiveJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResumePredictiveJobsResponse
		var err error
		defer close(result)
		response, err = client.ResumePredictiveJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResumePredictiveJobsRequest is the request struct for api ResumePredictiveJobs
type ResumePredictiveJobsRequest struct {
	*requests.RpcRequest
	All          requests.Boolean `position:"Query" name:"All"`
	JobId        *[]string        `position:"Query" name:"JobId"  type:"Repeated"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
	SkillGroupId string           `position:"Query" name:"SkillGroupId"`
	JobGroupId   string           `position:"Query" name:"JobGroupId"`
}

// ResumePredictiveJobsResponse is the response struct for api ResumePredictiveJobs
type ResumePredictiveJobsResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateResumePredictiveJobsRequest creates a request to invoke ResumePredictiveJobs API
func CreateResumePredictiveJobsRequest() (request *ResumePredictiveJobsRequest) {
	request = &ResumePredictiveJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "ResumePredictiveJobs", "", "")
	request.Method = requests.POST
	return
}

// CreateResumePredictiveJobsResponse creates a response to parse from ResumePredictiveJobs response
func CreateResumePredictiveJobsResponse() (response *ResumePredictiveJobsResponse) {
	response = &ResumePredictiveJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
