package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PublishSurvey invokes the ccc.PublishSurvey API synchronously
func (client *Client) PublishSurvey(request *PublishSurveyRequest) (response *PublishSurveyResponse, err error) {
	response = CreatePublishSurveyResponse()
	err = client.DoAction(request, response)
	return
}

// PublishSurveyWithChan invokes the ccc.PublishSurvey API asynchronously
func (client *Client) PublishSurveyWithChan(request *PublishSurveyRequest) (<-chan *PublishSurveyResponse, <-chan error) {
	responseChan := make(chan *PublishSurveyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PublishSurvey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PublishSurveyWithCallback invokes the ccc.PublishSurvey API asynchronously
func (client *Client) PublishSurveyWithCallback(request *PublishSurveyRequest, callback func(response *PublishSurveyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PublishSurveyResponse
		var err error
		defer close(result)
		response, err = client.PublishSurvey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PublishSurveyRequest is the request struct for api PublishSurvey
type PublishSurveyRequest struct {
	*requests.RpcRequest
	SurveyId   string `position:"Query" name:"SurveyId"`
	InstanceId string `position:"Query" name:"InstanceId"`
	ScenarioId string `position:"Query" name:"ScenarioId"`
}

// PublishSurveyResponse is the response struct for api PublishSurvey
type PublishSurveyResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreatePublishSurveyRequest creates a request to invoke PublishSurvey API
func CreatePublishSurveyRequest() (request *PublishSurveyRequest) {
	request = &PublishSurveyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "PublishSurvey", "", "")
	request.Method = requests.POST
	return
}

// CreatePublishSurveyResponse creates a response to parse from PublishSurvey response
func CreatePublishSurveyResponse() (response *PublishSurveyResponse) {
	response = &PublishSurveyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
