package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PickLocalNumber invokes the ccc.PickLocalNumber API synchronously
func (client *Client) PickLocalNumber(request *PickLocalNumberRequest) (response *PickLocalNumberResponse, err error) {
	response = CreatePickLocalNumberResponse()
	err = client.DoAction(request, response)
	return
}

// PickLocalNumberWithChan invokes the ccc.PickLocalNumber API asynchronously
func (client *Client) PickLocalNumberWithChan(request *PickLocalNumberRequest) (<-chan *PickLocalNumberResponse, <-chan error) {
	responseChan := make(chan *PickLocalNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PickLocalNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PickLocalNumberWithCallback invokes the ccc.PickLocalNumber API asynchronously
func (client *Client) PickLocalNumberWithCallback(request *PickLocalNumberRequest, callback func(response *PickLocalNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PickLocalNumberResponse
		var err error
		defer close(result)
		response, err = client.PickLocalNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PickLocalNumberRequest is the request struct for api PickLocalNumber
type PickLocalNumberRequest struct {
	*requests.RpcRequest
	InstanceId      string    `position:"Query" name:"InstanceId"`
	CandidateNumber *[]string `position:"Query" name:"CandidateNumber"  type:"Repeated"`
	CalleeNumber    string    `position:"Query" name:"CalleeNumber"`
}

// PickLocalNumberResponse is the response struct for api PickLocalNumber
type PickLocalNumberResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreatePickLocalNumberRequest creates a request to invoke PickLocalNumber API
func CreatePickLocalNumberRequest() (request *PickLocalNumberRequest) {
	request = &PickLocalNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "PickLocalNumber", "", "")
	request.Method = requests.POST
	return
}

// CreatePickLocalNumberResponse creates a response to parse from PickLocalNumber response
func CreatePickLocalNumberResponse() (response *PickLocalNumberResponse) {
	response = &PickLocalNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
