package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAgentStateLogs invokes the ccc.ListAgentStateLogs API synchronously
func (client *Client) ListAgentStateLogs(request *ListAgentStateLogsRequest) (response *ListAgentStateLogsResponse, err error) {
	response = CreateListAgentStateLogsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAgentStateLogsWithChan invokes the ccc.ListAgentStateLogs API asynchronously
func (client *Client) ListAgentStateLogsWithChan(request *ListAgentStateLogsRequest) (<-chan *ListAgentStateLogsResponse, <-chan error) {
	responseChan := make(chan *ListAgentStateLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAgentStateLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAgentStateLogsWithCallback invokes the ccc.ListAgentStateLogs API asynchronously
func (client *Client) ListAgentStateLogsWithCallback(request *ListAgentStateLogsRequest, callback func(response *ListAgentStateLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAgentStateLogsResponse
		var err error
		defer close(result)
		response, err = client.ListAgentStateLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAgentStateLogsRequest is the request struct for api ListAgentStateLogs
type ListAgentStateLogsRequest struct {
	*requests.RpcRequest
	EndTime    requests.Integer `position:"Query" name:"EndTime"`
	StartTime  requests.Integer `position:"Query" name:"StartTime"`
	RamId      requests.Integer `position:"Query" name:"RamId"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListAgentStateLogsResponse is the response struct for api ListAgentStateLogs
type ListAgentStateLogsResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	Success           bool              `json:"Success" xml:"Success"`
	Code              string            `json:"Code" xml:"Code"`
	Message           string            `json:"Message" xml:"Message"`
	HttpStatusCode    int               `json:"HttpStatusCode" xml:"HttpStatusCode"`
	AgentStateLogPage AgentStateLogPage `json:"AgentStateLogPage" xml:"AgentStateLogPage"`
}

// CreateListAgentStateLogsRequest creates a request to invoke ListAgentStateLogs API
func CreateListAgentStateLogsRequest() (request *ListAgentStateLogsRequest) {
	request = &ListAgentStateLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "ListAgentStateLogs", "", "")
	request.Method = requests.POST
	return
}

// CreateListAgentStateLogsResponse creates a response to parse from ListAgentStateLogs response
func CreateListAgentStateLogsResponse() (response *ListAgentStateLogsResponse) {
	response = &ListAgentStateLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
