package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPredictiveTaskData invokes the ccc.GetPredictiveTaskData API synchronously
func (client *Client) GetPredictiveTaskData(request *GetPredictiveTaskDataRequest) (response *GetPredictiveTaskDataResponse, err error) {
	response = CreateGetPredictiveTaskDataResponse()
	err = client.DoAction(request, response)
	return
}

// GetPredictiveTaskDataWithChan invokes the ccc.GetPredictiveTaskData API asynchronously
func (client *Client) GetPredictiveTaskDataWithChan(request *GetPredictiveTaskDataRequest) (<-chan *GetPredictiveTaskDataResponse, <-chan error) {
	responseChan := make(chan *GetPredictiveTaskDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPredictiveTaskData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPredictiveTaskDataWithCallback invokes the ccc.GetPredictiveTaskData API asynchronously
func (client *Client) GetPredictiveTaskDataWithCallback(request *GetPredictiveTaskDataRequest, callback func(response *GetPredictiveTaskDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPredictiveTaskDataResponse
		var err error
		defer close(result)
		response, err = client.GetPredictiveTaskData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPredictiveTaskDataRequest is the request struct for api GetPredictiveTaskData
type GetPredictiveTaskDataRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Query" name:"InstanceId"`
	SkillGroupId string `position:"Query" name:"SkillGroupId"`
	TaskId       string `position:"Query" name:"TaskId"`
}

// GetPredictiveTaskDataResponse is the response struct for api GetPredictiveTaskData
type GetPredictiveTaskDataResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	Success        string `json:"Success" xml:"Success"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetPredictiveTaskDataRequest creates a request to invoke GetPredictiveTaskData API
func CreateGetPredictiveTaskDataRequest() (request *GetPredictiveTaskDataRequest) {
	request = &GetPredictiveTaskDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "GetPredictiveTaskData", "", "")
	request.Method = requests.GET
	return
}

// CreateGetPredictiveTaskDataResponse creates a response to parse from GetPredictiveTaskData response
func CreateGetPredictiveTaskDataResponse() (response *GetPredictiveTaskDataResponse) {
	response = &GetPredictiveTaskDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
