package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJobGroup invokes the ccc.GetJobGroup API synchronously
func (client *Client) GetJobGroup(request *GetJobGroupRequest) (response *GetJobGroupResponse, err error) {
	response = CreateGetJobGroupResponse()
	err = client.DoAction(request, response)
	return
}

// GetJobGroupWithChan invokes the ccc.GetJobGroup API asynchronously
func (client *Client) GetJobGroupWithChan(request *GetJobGroupRequest) (<-chan *GetJobGroupResponse, <-chan error) {
	responseChan := make(chan *GetJobGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJobGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJobGroupWithCallback invokes the ccc.GetJobGroup API asynchronously
func (client *Client) GetJobGroupWithCallback(request *GetJobGroupRequest, callback func(response *GetJobGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJobGroupResponse
		var err error
		defer close(result)
		response, err = client.GetJobGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJobGroupRequest is the request struct for api GetJobGroup
type GetJobGroupRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	JobGroupId string `position:"Query" name:"JobGroupId"`
}

// GetJobGroupResponse is the response struct for api GetJobGroup
type GetJobGroupResponse struct {
	*responses.BaseResponse
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Success        bool     `json:"Success" xml:"Success"`
	Code           string   `json:"Code" xml:"Code"`
	Message        string   `json:"Message" xml:"Message"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	JobGroup       JobGroup `json:"JobGroup" xml:"JobGroup"`
}

// CreateGetJobGroupRequest creates a request to invoke GetJobGroup API
func CreateGetJobGroupRequest() (request *GetJobGroupRequest) {
	request = &GetJobGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "GetJobGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateGetJobGroupResponse creates a response to parse from GetJobGroup response
func CreateGetJobGroupResponse() (response *GetJobGroupResponse) {
	response = &GetJobGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
