package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FindUsers invokes the ccc.FindUsers API synchronously
func (client *Client) FindUsers(request *FindUsersRequest) (response *FindUsersResponse, err error) {
	response = CreateFindUsersResponse()
	err = client.DoAction(request, response)
	return
}

// FindUsersWithChan invokes the ccc.FindUsers API asynchronously
func (client *Client) FindUsersWithChan(request *FindUsersRequest) (<-chan *FindUsersResponse, <-chan error) {
	responseChan := make(chan *FindUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FindUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FindUsersWithCallback invokes the ccc.FindUsers API asynchronously
func (client *Client) FindUsersWithCallback(request *FindUsersRequest, callback func(response *FindUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FindUsersResponse
		var err error
		defer close(result)
		response, err = client.FindUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FindUsersRequest is the request struct for api FindUsers
type FindUsersRequest struct {
	*requests.RpcRequest
	Criteria   string           `position:"Query" name:"Criteria"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// FindUsersResponse is the response struct for api FindUsers
type FindUsersResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Users          Users  `json:"Users" xml:"Users"`
}

// CreateFindUsersRequest creates a request to invoke FindUsers API
func CreateFindUsersRequest() (request *FindUsersRequest) {
	request = &FindUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "FindUsers", "", "")
	request.Method = requests.POST
	return
}

// CreateFindUsersResponse creates a response to parse from FindUsers response
func CreateFindUsersResponse() (response *FindUsersResponse) {
	response = &FindUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
