package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePhoneTags invokes the ccc.DeletePhoneTags API synchronously
func (client *Client) DeletePhoneTags(request *DeletePhoneTagsRequest) (response *DeletePhoneTagsResponse, err error) {
	response = CreateDeletePhoneTagsResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePhoneTagsWithChan invokes the ccc.DeletePhoneTags API asynchronously
func (client *Client) DeletePhoneTagsWithChan(request *DeletePhoneTagsRequest) (<-chan *DeletePhoneTagsResponse, <-chan error) {
	responseChan := make(chan *DeletePhoneTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePhoneTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePhoneTagsWithCallback invokes the ccc.DeletePhoneTags API asynchronously
func (client *Client) DeletePhoneTagsWithCallback(request *DeletePhoneTagsRequest, callback func(response *DeletePhoneTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePhoneTagsResponse
		var err error
		defer close(result)
		response, err = client.DeletePhoneTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePhoneTagsRequest is the request struct for api DeletePhoneTags
type DeletePhoneTagsRequest struct {
	*requests.RpcRequest
	InstanceId      string    `position:"Query" name:"InstanceId"`
	PhoneNumberList *[]string `position:"Query" name:"PhoneNumberList"  type:"Repeated"`
}

// DeletePhoneTagsResponse is the response struct for api DeletePhoneTags
type DeletePhoneTagsResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateDeletePhoneTagsRequest creates a request to invoke DeletePhoneTags API
func CreateDeletePhoneTagsRequest() (request *DeletePhoneTagsRequest) {
	request = &DeletePhoneTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "DeletePhoneTags", "", "")
	request.Method = requests.POST
	return
}

// CreateDeletePhoneTagsResponse creates a response to parse from DeletePhoneTags response
func CreateDeletePhoneTagsResponse() (response *DeletePhoneTagsResponse) {
	response = &DeletePhoneTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
