package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckNumberAvaliable invokes the ccc.CheckNumberAvaliable API synchronously
func (client *Client) CheckNumberAvaliable(request *CheckNumberAvaliableRequest) (response *CheckNumberAvaliableResponse, err error) {
	response = CreateCheckNumberAvaliableResponse()
	err = client.DoAction(request, response)
	return
}

// CheckNumberAvaliableWithChan invokes the ccc.CheckNumberAvaliable API asynchronously
func (client *Client) CheckNumberAvaliableWithChan(request *CheckNumberAvaliableRequest) (<-chan *CheckNumberAvaliableResponse, <-chan error) {
	responseChan := make(chan *CheckNumberAvaliableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckNumberAvaliable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckNumberAvaliableWithCallback invokes the ccc.CheckNumberAvaliable API asynchronously
func (client *Client) CheckNumberAvaliableWithCallback(request *CheckNumberAvaliableRequest, callback func(response *CheckNumberAvaliableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckNumberAvaliableResponse
		var err error
		defer close(result)
		response, err = client.CheckNumberAvaliable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckNumberAvaliableRequest is the request struct for api CheckNumberAvaliable
type CheckNumberAvaliableRequest struct {
	*requests.RpcRequest
	Caller     string `position:"Query" name:"Caller"`
	InstanceId string `position:"Query" name:"InstanceId"`
	Callee     string `position:"Query" name:"Callee"`
}

// CheckNumberAvaliableResponse is the response struct for api CheckNumberAvaliable
type CheckNumberAvaliableResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	Success         bool            `json:"Success" xml:"Success"`
	Code            string          `json:"Code" xml:"Code"`
	Message         string          `json:"Message" xml:"Message"`
	HttpStatusCode  int             `json:"HttpStatusCode" xml:"HttpStatusCode"`
	CallerAvaliable CallerAvaliable `json:"CallerAvaliable" xml:"CallerAvaliable"`
	CalleeAvaliable CalleeAvaliable `json:"CalleeAvaliable" xml:"CalleeAvaliable"`
}

// CreateCheckNumberAvaliableRequest creates a request to invoke CheckNumberAvaliable API
func CreateCheckNumberAvaliableRequest() (request *CheckNumberAvaliableRequest) {
	request = &CheckNumberAvaliableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "CheckNumberAvaliable", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckNumberAvaliableResponse creates a response to parse from CheckNumberAvaliable response
func CreateCheckNumberAvaliableResponse() (response *CheckNumberAvaliableResponse) {
	response = &CheckNumberAvaliableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
