package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTransitRouterRouteTable invokes the cbn.CreateTransitRouterRouteTable API synchronously
func (client *Client) CreateTransitRouterRouteTable(request *CreateTransitRouterRouteTableRequest) (response *CreateTransitRouterRouteTableResponse, err error) {
	response = CreateCreateTransitRouterRouteTableResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTransitRouterRouteTableWithChan invokes the cbn.CreateTransitRouterRouteTable API asynchronously
func (client *Client) CreateTransitRouterRouteTableWithChan(request *CreateTransitRouterRouteTableRequest) (<-chan *CreateTransitRouterRouteTableResponse, <-chan error) {
	responseChan := make(chan *CreateTransitRouterRouteTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTransitRouterRouteTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTransitRouterRouteTableWithCallback invokes the cbn.CreateTransitRouterRouteTable API asynchronously
func (client *Client) CreateTransitRouterRouteTableWithCallback(request *CreateTransitRouterRouteTableRequest, callback func(response *CreateTransitRouterRouteTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTransitRouterRouteTableResponse
		var err error
		defer close(result)
		response, err = client.CreateTransitRouterRouteTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTransitRouterRouteTableRequest is the request struct for api CreateTransitRouterRouteTable
type CreateTransitRouterRouteTableRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                    requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                        string           `position:"Query" name:"ClientToken"`
	TransitRouterRouteTableDescription string           `position:"Query" name:"TransitRouterRouteTableDescription"`
	DryRun                             requests.Boolean `position:"Query" name:"DryRun"`
	TransitRouterRouteTableName        string           `position:"Query" name:"TransitRouterRouteTableName"`
	ResourceOwnerAccount               string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                       string           `position:"Query" name:"OwnerAccount"`
	OwnerId                            requests.Integer `position:"Query" name:"OwnerId"`
	TransitRouterId                    string           `position:"Query" name:"TransitRouterId"`
}

// CreateTransitRouterRouteTableResponse is the response struct for api CreateTransitRouterRouteTable
type CreateTransitRouterRouteTableResponse struct {
	*responses.BaseResponse
	TransitRouterRouteTableId string `json:"TransitRouterRouteTableId" xml:"TransitRouterRouteTableId"`
	RequestId                 string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateTransitRouterRouteTableRequest creates a request to invoke CreateTransitRouterRouteTable API
func CreateCreateTransitRouterRouteTableRequest() (request *CreateTransitRouterRouteTableRequest) {
	request = &CreateTransitRouterRouteTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "CreateTransitRouterRouteTable", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateTransitRouterRouteTableResponse creates a response to parse from CreateTransitRouterRouteTable response
func CreateCreateTransitRouterRouteTableResponse() (response *CreateTransitRouterRouteTableResponse) {
	response = &CreateTransitRouterRouteTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
