package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyAccountRelation invokes the bssopenapi.ModifyAccountRelation API synchronously
func (client *Client) ModifyAccountRelation(request *ModifyAccountRelationRequest) (response *ModifyAccountRelationResponse, err error) {
	response = CreateModifyAccountRelationResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyAccountRelationWithChan invokes the bssopenapi.ModifyAccountRelation API asynchronously
func (client *Client) ModifyAccountRelationWithChan(request *ModifyAccountRelationRequest) (<-chan *ModifyAccountRelationResponse, <-chan error) {
	responseChan := make(chan *ModifyAccountRelationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyAccountRelation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyAccountRelationWithCallback invokes the bssopenapi.ModifyAccountRelation API asynchronously
func (client *Client) ModifyAccountRelationWithCallback(request *ModifyAccountRelationRequest, callback func(response *ModifyAccountRelationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyAccountRelationResponse
		var err error
		defer close(result)
		response, err = client.ModifyAccountRelation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyAccountRelationRequest is the request struct for api ModifyAccountRelation
type ModifyAccountRelationRequest struct {
	*requests.RpcRequest
	ChildNick         string           `position:"Query" name:"ChildNick"`
	RelationOperation string           `position:"Query" name:"RelationOperation"`
	RelationType      string           `position:"Query" name:"RelationType"`
	ParentUserId      requests.Integer `position:"Query" name:"ParentUserId"`
	ChildUserId       requests.Integer `position:"Query" name:"ChildUserId"`
	RequestId         string           `position:"Query" name:"RequestId"`
	PermissionCodes   *[]string        `position:"Query" name:"PermissionCodes"  type:"Repeated"`
	RoleCodes         *[]string        `position:"Query" name:"RoleCodes"  type:"Repeated"`
}

// ModifyAccountRelationResponse is the response struct for api ModifyAccountRelation
type ModifyAccountRelationResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateModifyAccountRelationRequest creates a request to invoke ModifyAccountRelation API
func CreateModifyAccountRelationRequest() (request *ModifyAccountRelationRequest) {
	request = &ModifyAccountRelationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "ModifyAccountRelation", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyAccountRelationResponse creates a response to parse from ModifyAccountRelation response
func CreateModifyAccountRelationResponse() (response *ModifyAccountRelationResponse) {
	response = &ModifyAccountRelationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
