package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAntChainMembers invokes the baas.DescribeAntChainMembers API synchronously
// api document: https://help.aliyun.com/api/baas/describeantchainmembers.html
func (client *Client) DescribeAntChainMembers(request *DescribeAntChainMembersRequest) (response *DescribeAntChainMembersResponse, err error) {
	response = CreateDescribeAntChainMembersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAntChainMembersWithChan invokes the baas.DescribeAntChainMembers API asynchronously
// api document: https://help.aliyun.com/api/baas/describeantchainmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAntChainMembersWithChan(request *DescribeAntChainMembersRequest) (<-chan *DescribeAntChainMembersResponse, <-chan error) {
	responseChan := make(chan *DescribeAntChainMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAntChainMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAntChainMembersWithCallback invokes the baas.DescribeAntChainMembers API asynchronously
// api document: https://help.aliyun.com/api/baas/describeantchainmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAntChainMembersWithCallback(request *DescribeAntChainMembersRequest, callback func(response *DescribeAntChainMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAntChainMembersResponse
		var err error
		defer close(result)
		response, err = client.DescribeAntChainMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAntChainMembersRequest is the request struct for api DescribeAntChainMembers
type DescribeAntChainMembersRequest struct {
	*requests.RpcRequest
	PageNumber   requests.Integer `position:"Body" name:"PageNumber"`
	PageSize     requests.Integer `position:"Body" name:"PageSize"`
	ConsortiumId string           `position:"Body" name:"ConsortiumId"`
}

// DescribeAntChainMembersResponse is the response struct for api DescribeAntChainMembers
type DescribeAntChainMembersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeAntChainMembersRequest creates a request to invoke DescribeAntChainMembers API
func CreateDescribeAntChainMembersRequest() (request *DescribeAntChainMembersRequest) {
	request = &DescribeAntChainMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeAntChainMembers", "baas", "openAPI")
	return
}

// CreateDescribeAntChainMembersResponse creates a response to parse from DescribeAntChainMembers response
func CreateDescribeAntChainMembersResponse() (response *DescribeAntChainMembersResponse) {
	response = &DescribeAntChainMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
