package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchAlertRules invokes the arms.SearchAlertRules API synchronously
func (client *Client) SearchAlertRules(request *SearchAlertRulesRequest) (response *SearchAlertRulesResponse, err error) {
	response = CreateSearchAlertRulesResponse()
	err = client.DoAction(request, response)
	return
}

// SearchAlertRulesWithChan invokes the arms.SearchAlertRules API asynchronously
func (client *Client) SearchAlertRulesWithChan(request *SearchAlertRulesRequest) (<-chan *SearchAlertRulesResponse, <-chan error) {
	responseChan := make(chan *SearchAlertRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchAlertRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchAlertRulesWithCallback invokes the arms.SearchAlertRules API asynchronously
func (client *Client) SearchAlertRulesWithCallback(request *SearchAlertRulesRequest, callback func(response *SearchAlertRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchAlertRulesResponse
		var err error
		defer close(result)
		response, err = client.SearchAlertRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchAlertRulesRequest is the request struct for api SearchAlertRules
type SearchAlertRulesRequest struct {
	*requests.RpcRequest
	AppType        string           `position:"Query" name:"AppType"`
	CurrentPage    requests.Integer `position:"Query" name:"CurrentPage"`
	Pid            string           `position:"Query" name:"Pid"`
	SystemRegionId string           `position:"Query" name:"SystemRegionId"`
	ProxyUserId    string           `position:"Query" name:"ProxyUserId"`
	Title          string           `position:"Query" name:"Title"`
	Type           string           `position:"Query" name:"Type"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
}

// SearchAlertRulesResponse is the response struct for api SearchAlertRules
type SearchAlertRulesResponse struct {
	*responses.BaseResponse
	RequestId string                     `json:"RequestId" xml:"RequestId"`
	PageBean  PageBeanInSearchAlertRules `json:"PageBean" xml:"PageBean"`
}

// CreateSearchAlertRulesRequest creates a request to invoke SearchAlertRules API
func CreateSearchAlertRulesRequest() (request *SearchAlertRulesRequest) {
	request = &SearchAlertRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "SearchAlertRules", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSearchAlertRulesResponse creates a response to parse from SearchAlertRules response
func CreateSearchAlertRulesResponse() (response *SearchAlertRulesResponse) {
	response = &SearchAlertRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
