package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDispatchRule invokes the arms.DeleteDispatchRule API synchronously
func (client *Client) DeleteDispatchRule(request *DeleteDispatchRuleRequest) (response *DeleteDispatchRuleResponse, err error) {
	response = CreateDeleteDispatchRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDispatchRuleWithChan invokes the arms.DeleteDispatchRule API asynchronously
func (client *Client) DeleteDispatchRuleWithChan(request *DeleteDispatchRuleRequest) (<-chan *DeleteDispatchRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteDispatchRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDispatchRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDispatchRuleWithCallback invokes the arms.DeleteDispatchRule API asynchronously
func (client *Client) DeleteDispatchRuleWithCallback(request *DeleteDispatchRuleRequest, callback func(response *DeleteDispatchRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDispatchRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteDispatchRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDispatchRuleRequest is the request struct for api DeleteDispatchRule
type DeleteDispatchRuleRequest struct {
	*requests.RpcRequest
	Id          string `position:"Query" name:"Id"`
	ProxyUserId string `position:"Query" name:"ProxyUserId"`
}

// DeleteDispatchRuleResponse is the response struct for api DeleteDispatchRule
type DeleteDispatchRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteDispatchRuleRequest creates a request to invoke DeleteDispatchRule API
func CreateDeleteDispatchRuleRequest() (request *DeleteDispatchRuleRequest) {
	request = &DeleteDispatchRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "DeleteDispatchRule", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDispatchRuleResponse creates a response to parse from DeleteDispatchRule response
func CreateDeleteDispatchRuleResponse() (response *DeleteDispatchRuleResponse) {
	response = &DeleteDispatchRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
