package aliyuncvc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMeeting invokes the aliyuncvc.DeleteMeeting API synchronously
func (client *Client) DeleteMeeting(request *DeleteMeetingRequest) (response *DeleteMeetingResponse, err error) {
	response = CreateDeleteMeetingResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMeetingWithChan invokes the aliyuncvc.DeleteMeeting API asynchronously
func (client *Client) DeleteMeetingWithChan(request *DeleteMeetingRequest) (<-chan *DeleteMeetingResponse, <-chan error) {
	responseChan := make(chan *DeleteMeetingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMeeting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMeetingWithCallback invokes the aliyuncvc.DeleteMeeting API asynchronously
func (client *Client) DeleteMeetingWithCallback(request *DeleteMeetingRequest, callback func(response *DeleteMeetingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMeetingResponse
		var err error
		defer close(result)
		response, err = client.DeleteMeeting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMeetingRequest is the request struct for api DeleteMeeting
type DeleteMeetingRequest struct {
	*requests.RpcRequest
	MeetingUUID string `position:"Body" name:"MeetingUUID"`
}

// DeleteMeetingResponse is the response struct for api DeleteMeeting
type DeleteMeetingResponse struct {
	*responses.BaseResponse
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteMeetingRequest creates a request to invoke DeleteMeeting API
func CreateDeleteMeetingRequest() (request *DeleteMeetingRequest) {
	request = &DeleteMeetingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aliyuncvc", "2019-10-30", "DeleteMeeting", "aliyuncvc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteMeetingResponse creates a response to parse from DeleteMeeting response
func CreateDeleteMeetingResponse() (response *DeleteMeetingResponse) {
	response = &DeleteMeetingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
