package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetListenerHealthStatus invokes the alb.GetListenerHealthStatus API synchronously
func (client *Client) GetListenerHealthStatus(request *GetListenerHealthStatusRequest) (response *GetListenerHealthStatusResponse, err error) {
	response = CreateGetListenerHealthStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetListenerHealthStatusWithChan invokes the alb.GetListenerHealthStatus API asynchronously
func (client *Client) GetListenerHealthStatusWithChan(request *GetListenerHealthStatusRequest) (<-chan *GetListenerHealthStatusResponse, <-chan error) {
	responseChan := make(chan *GetListenerHealthStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetListenerHealthStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetListenerHealthStatusWithCallback invokes the alb.GetListenerHealthStatus API asynchronously
func (client *Client) GetListenerHealthStatusWithCallback(request *GetListenerHealthStatusRequest, callback func(response *GetListenerHealthStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetListenerHealthStatusResponse
		var err error
		defer close(result)
		response, err = client.GetListenerHealthStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetListenerHealthStatusRequest is the request struct for api GetListenerHealthStatus
type GetListenerHealthStatusRequest struct {
	*requests.RpcRequest
	IncludeRule requests.Boolean `position:"Query" name:"IncludeRule"`
	ListenerId  string           `position:"Query" name:"ListenerId"`
	NextToken   string           `position:"Query" name:"NextToken"`
	MaxResults  requests.Integer `position:"Query" name:"MaxResults"`
}

// GetListenerHealthStatusResponse is the response struct for api GetListenerHealthStatus
type GetListenerHealthStatusResponse struct {
	*responses.BaseResponse
	RequestId            string                      `json:"RequestId" xml:"RequestId"`
	NextToken            string                      `json:"NextToken" xml:"NextToken"`
	ListenerHealthStatus []ListenerHealthStatusModel `json:"ListenerHealthStatus" xml:"ListenerHealthStatus"`
	RuleHealthStatus     []RuleHealthStatusModel     `json:"RuleHealthStatus" xml:"RuleHealthStatus"`
}

// CreateGetListenerHealthStatusRequest creates a request to invoke GetListenerHealthStatus API
func CreateGetListenerHealthStatusRequest() (request *GetListenerHealthStatusRequest) {
	request = &GetListenerHealthStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "GetListenerHealthStatus", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetListenerHealthStatusResponse creates a response to parse from GetListenerHealthStatus response
func CreateGetListenerHealthStatusResponse() (response *GetListenerHealthStatusResponse) {
	response = &GetListenerHealthStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
