package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLogs invokes the airec.ListLogs API synchronously
func (client *Client) ListLogs(request *ListLogsRequest) (response *ListLogsResponse, err error) {
	response = CreateListLogsResponse()
	err = client.DoAction(request, response)
	return
}

// ListLogsWithChan invokes the airec.ListLogs API asynchronously
func (client *Client) ListLogsWithChan(request *ListLogsRequest) (<-chan *ListLogsResponse, <-chan error) {
	responseChan := make(chan *ListLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLogsWithCallback invokes the airec.ListLogs API asynchronously
func (client *Client) ListLogsWithCallback(request *ListLogsRequest, callback func(response *ListLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLogsResponse
		var err error
		defer close(result)
		response, err = client.ListLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLogsRequest is the request struct for api ListLogs
type ListLogsRequest struct {
	*requests.RoaRequest
	InstanceId  string           `position:"Path" name:"instanceId"`
	Size        requests.Integer `position:"Query" name:"size"`
	QueryParams string           `position:"Query" name:"queryParams"`
	EndTime     requests.Integer `position:"Query" name:"endTime"`
	StartTime   requests.Integer `position:"Query" name:"startTime"`
	Page        requests.Integer `position:"Query" name:"page"`
}

// ListLogsResponse is the response struct for api ListLogs
type ListLogsResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"requestId" xml:"requestId"`
	Code      string                   `json:"code" xml:"code"`
	Message   string                   `json:"message" xml:"message"`
	Result    []map[string]interface{} `json:"result" xml:"result"`
	Headers   Headers                  `json:"headers" xml:"headers"`
}

// CreateListLogsRequest creates a request to invoke ListLogs API
func CreateListLogsRequest() (request *ListLogsRequest) {
	request = &ListLogsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "ListLogs", "/v2/openapi/instances/[instanceId]/logs", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListLogsResponse creates a response to parse from ListLogs response
func CreateListLogsResponse() (response *ListLogsResponse) {
	response = &ListLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
