package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeExperiment invokes the airec.DescribeExperiment API synchronously
func (client *Client) DescribeExperiment(request *DescribeExperimentRequest) (response *DescribeExperimentResponse, err error) {
	response = CreateDescribeExperimentResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeExperimentWithChan invokes the airec.DescribeExperiment API asynchronously
func (client *Client) DescribeExperimentWithChan(request *DescribeExperimentRequest) (<-chan *DescribeExperimentResponse, <-chan error) {
	responseChan := make(chan *DescribeExperimentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeExperiment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeExperimentWithCallback invokes the airec.DescribeExperiment API asynchronously
func (client *Client) DescribeExperimentWithCallback(request *DescribeExperimentRequest, callback func(response *DescribeExperimentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeExperimentResponse
		var err error
		defer close(result)
		response, err = client.DescribeExperiment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeExperimentRequest is the request struct for api DescribeExperiment
type DescribeExperimentRequest struct {
	*requests.RoaRequest
	InstanceId   string `position:"Path" name:"instanceId"`
	SceneId      string `position:"Path" name:"sceneId"`
	ExperimentId string `position:"Path" name:"experimentId"`
}

// DescribeExperimentResponse is the response struct for api DescribeExperiment
type DescribeExperimentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    Result `json:"result" xml:"result"`
}

// CreateDescribeExperimentRequest creates a request to invoke DescribeExperiment API
func CreateDescribeExperimentRequest() (request *DescribeExperimentRequest) {
	request = &DescribeExperimentRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "DescribeExperiment", "/v2/openapi/instances/[instanceId]/scenes/[sceneId]/experiments/[experimentId]", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeExperimentResponse creates a response to parse from DescribeExperiment response
func CreateDescribeExperimentResponse() (response *DescribeExperimentResponse) {
	response = &DescribeExperimentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
