package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScreenOperateInfo invokes the aegis.DescribeScreenOperateInfo API synchronously
// api document: https://help.aliyun.com/api/aegis/describescreenoperateinfo.html
func (client *Client) DescribeScreenOperateInfo(request *DescribeScreenOperateInfoRequest) (response *DescribeScreenOperateInfoResponse, err error) {
	response = CreateDescribeScreenOperateInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScreenOperateInfoWithChan invokes the aegis.DescribeScreenOperateInfo API asynchronously
// api document: https://help.aliyun.com/api/aegis/describescreenoperateinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScreenOperateInfoWithChan(request *DescribeScreenOperateInfoRequest) (<-chan *DescribeScreenOperateInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeScreenOperateInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScreenOperateInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScreenOperateInfoWithCallback invokes the aegis.DescribeScreenOperateInfo API asynchronously
// api document: https://help.aliyun.com/api/aegis/describescreenoperateinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScreenOperateInfoWithCallback(request *DescribeScreenOperateInfoRequest, callback func(response *DescribeScreenOperateInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScreenOperateInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeScreenOperateInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScreenOperateInfoRequest is the request struct for api DescribeScreenOperateInfo
type DescribeScreenOperateInfoRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeScreenOperateInfoResponse is the response struct for api DescribeScreenOperateInfo
type DescribeScreenOperateInfoResponse struct {
	*responses.BaseResponse
	RequestId                string   `json:"RequestId" xml:"RequestId"`
	HealthCheckDealedCount   int      `json:"HealthCheckDealedCount" xml:"HealthCheckDealedCount"`
	SecurityEventDealedCount int      `json:"SecurityEventDealedCount" xml:"SecurityEventDealedCount"`
	VulnerabilityDealedCount int      `json:"VulnerabilityDealedCount" xml:"VulnerabilityDealedCount"`
	Success                  bool     `json:"Success" xml:"Success"`
	SuspEventValueArray      []string `json:"SuspEventValueArray" xml:"SuspEventValueArray"`
	VulValueArray            []string `json:"VulValueArray" xml:"VulValueArray"`
	DateArray                []string `json:"DateArray" xml:"DateArray"`
	HealthCheckValueArray    []string `json:"HealthCheckValueArray" xml:"HealthCheckValueArray"`
}

// CreateDescribeScreenOperateInfoRequest creates a request to invoke DescribeScreenOperateInfo API
func CreateDescribeScreenOperateInfoRequest() (request *DescribeScreenOperateInfoRequest) {
	request = &DescribeScreenOperateInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeScreenOperateInfo", "vipaegis", "openAPI")
	return
}

// CreateDescribeScreenOperateInfoResponse creates a response to parse from DescribeScreenOperateInfo response
func CreateDescribeScreenOperateInfoResponse() (response *DescribeScreenOperateInfoResponse) {
	response = &DescribeScreenOperateInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
