package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CanTrySas invokes the aegis.CanTrySas API synchronously
// api document: https://help.aliyun.com/api/aegis/cantrysas.html
func (client *Client) CanTrySas(request *CanTrySasRequest) (response *CanTrySasResponse, err error) {
	response = CreateCanTrySasResponse()
	err = client.DoAction(request, response)
	return
}

// CanTrySasWithChan invokes the aegis.CanTrySas API asynchronously
// api document: https://help.aliyun.com/api/aegis/cantrysas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CanTrySasWithChan(request *CanTrySasRequest) (<-chan *CanTrySasResponse, <-chan error) {
	responseChan := make(chan *CanTrySasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CanTrySas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CanTrySasWithCallback invokes the aegis.CanTrySas API asynchronously
// api document: https://help.aliyun.com/api/aegis/cantrysas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CanTrySasWithCallback(request *CanTrySasRequest, callback func(response *CanTrySasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CanTrySasResponse
		var err error
		defer close(result)
		response, err = client.CanTrySas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CanTrySasRequest is the request struct for api CanTrySas
type CanTrySasRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// CanTrySasResponse is the response struct for api CanTrySas
type CanTrySasResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	CanTry    int    `json:"CanTry" xml:"CanTry"`
}

// CreateCanTrySasRequest creates a request to invoke CanTrySas API
func CreateCanTrySasRequest() (request *CanTrySasRequest) {
	request = &CanTrySasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "CanTrySas", "vipaegis", "openAPI")
	return
}

// CreateCanTrySasResponse creates a response to parse from CanTrySas response
func CreateCanTrySasResponse() (response *CanTrySasResponse) {
	response = &CanTrySasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
