// Code generated by running "go generate" in golang.org/x/text. DO NOT EDIT.

//go:build go1.16
// +build go1.16

package runenames

// UnicodeVersion is the Unicode version from which the tables in this package are derived.
const UnicodeVersion = "13.0.0"

type entry uint64

func (e entry) startRune() int32 {
	return int32((e >> 43) & 0x1fffff)
}

func (e entry) numRunes() int {
	return int((e >> 27) & 0xffff)
}

func (e entry) index() int {
	return int((e >> 11) & 0xffff)
}

func (e entry) base() int {
	return int((e >> 5) & 0x3f)
}

func (e entry) direct() bool {
	const bit = 1 << 4
	return e&bit == bit
}

var entries = []entry{ // 700 elements
	// Entry 0 - 1F
	0x00000001000c8130, 0x00010002f8000000, 0x0003f801080c8130, 0x00050016c002f800,
	0x001bd0003019b800, 0x001c20003819e800, 0x001c6000081a2000, 0x001c7000a01a2800,
	0x001d180c681ac800, 0x0029880130273000, 0x002ac80190286000, 0x002c68001829f000,
	0x002c8801b82a0800, 0x002e8000d82bc000, 0x002f7800302c9800, 0x00300000e82cc800,
	0x0030f007802db000, 0x00387801e0353000, 0x003a680328371000, 0x003e0001d83a3800,
	0x003fe801883c1000, 0x00418000783d9800, 0x00420000e03e1000, 0x0042f000083ef000,
	0x00430000583ef800, 0x00450000a83f5000, 0x0045b000903ff800, 0x0046980588408800,
	0x004c280040461000, 0x004c780010465000, 0x004c9800b0466000, 0x004d500038471000,
	// Entry 20 - 3F
	0x004d900008474800, 0x004db00020475000, 0x004de00048477000, 0x004e38001047b800,
	0x004e58002047c800, 0x004eb8000847e800, 0x004ee0001047f000, 0x004ef80028480000,
	0x004f3000c8482800, 0x005008001848f000, 0x0050280030490800, 0x0050780010493800,
	0x00509800b0494800, 0x005150003849f800, 0x00519000104a3000, 0x0051a800104a4000,
	0x0051c000104a5000, 0x0051e000084a6000, 0x0051f000284a6800, 0x00523800104a9000,
	0x00525800184aa000, 0x00528800084ab800, 0x0052c800204ac000, 0x0052f000084ae000,
	0x00533000504ae800, 0x00538000384b3820, 0x00540800184b7020, 0x00542800484b8820,
	0x00547800184bd020, 0x00549800b04be820, 0x00555000384c9820, 0x00559000104cd020,
	// Entry 40 - 5F
	0x0055a800284ce020, 0x0055e000504d0820, 0x00563800184d5820, 0x00565800184d7020,
	0x00568000084d8820, 0x00570000204d9020, 0x00573000604db020, 0x0057c800384e1020,
	0x00580800184e4820, 0x00582800404e6020, 0x00587800104ea020, 0x00589800b04eb020,
	0x00595000384f6020, 0x00599000104f9820, 0x0059a800284fa820, 0x0059e000484fd020,
	0x005a380010501820, 0x005a580018502820, 0x005aa80018504020, 0x005ae00010505820,
	0x005af80028506820, 0x005b300090509020, 0x005c100010512020, 0x005c280030513020,
	0x005c700018516020, 0x005c900020517820, 0x005cc80010519820, 0x005ce0000851a820,
	0x005cf0001051b020, 0x005d18001051c020, 0x005d40001851d020, 0x005d70006051e820,
	// Entry 60 - 7F
	0x005df00028524820, 0x005e300018527020, 0x005e500020528820, 0x005e80000852a820,
	0x005eb8000852b020, 0x005f3000a852b820, 0x0060000068536020, 0x006070001853c820,
	0x00609000b853e020, 0x0061500080549820, 0x0061e80040551820, 0x0062300018555820,
	0x0062500020557020, 0x0062a80010559020, 0x0062c0001855a020, 0x006300002055b820,
	0x006330005055d820, 0x0063b800b0562820, 0x006470001856d820, 0x00649000b856f020,
	0x006550005057a820, 0x0065a8002857f820, 0x0065e00048582020, 0x0066300018586820,
	0x0066500020588020, 0x0066a8001058a020, 0x0066f0000858b020, 0x006700002058b820,
	0x006730005058d820, 0x0067880010592820, 0x0068000068593820, 0x006870001859a020,
	// Entry 80 - 9F
	0x006890019859b820, 0x006a3000185b5020, 0x006a5000305b6820, 0x006aa000805b9820,
	0x006b3000d05c1820, 0x006c0800185ce820, 0x006c2800905d0020, 0x006cd000c05d9020,
	0x006d9800485e5020, 0x006de800085e9820, 0x006e0000385ea020, 0x006e5000085ed820,
	0x006e7800305ee020, 0x006eb000085f1020, 0x006ec000405f1820, 0x006f3000505f5820,
	0x006f9000185fa820, 0x00700801d05fc020, 0x0071f800e8619020, 0x0074080010627820,
	0x0074200008628820, 0x0074300028629020, 0x00746000c062b820, 0x0075280008637820,
	0x00753800b8638020, 0x0076000028643820, 0x0076300008646020, 0x0076400030646820,
	0x0076800050649820, 0x0076e0002064e820, 0x0078000240650820, 0x007a480120674820,
	// Entry A0 - BF
	0x007b880138686820, 0x007cc8012069a020, 0x007df000786ac020, 0x007e7000686b3820,
	0x00800006306ba020, 0x008638000871d020, 0x008668000871d820, 0x0086800bc871e020,
	0x00925000207da820, 0x00928000387dc820, 0x0092c000087e0020, 0x0092d000207e0820,
	0x00930001487e2820, 0x00945000207f7020, 0x00948001087f9020, 0x0095900020809820,
	0x0095c0003880b820, 0x009600000880f020, 0x009610002080f820, 0x0096400078811820,
	0x0096c001c8819020, 0x0098900020835820, 0x0098c00218837820, 0x009ae80100859020,
	0x009c0000d0869020, 0x009d0002b0876020, 0x009fc000308a1020, 0x00a00014e88a4020,
	0x00b50002c89f2820, 0x00b8000068a1f020, 0x00b8700038a25820, 0x00b9000098a29020,
	// Entry C0 - DF
	0x00b9980020a32840, 0x00ba0000a0a34840, 0x00bb000068a3e840, 0x00bb700018a45040,
	0x00bb900010a46840, 0x00bc0002f0a47840, 0x00bf000050a76840, 0x00bf800050a7b840,
	0x00c0000078a80840, 0x00c0800050a88040, 0x00c10002c8a8d040, 0x00c4000158ab9840,
	0x00c5800230acf040, 0x00c80000f8af2040, 0x00c9000060b01840, 0x00c9800060b07840,
	0x00ca000008b0d840, 0x00ca200150b0e040, 0x00cb800028b23040, 0x00cc000160b25840,
	0x00cd8000d0b3b840, 0x00ce800058b48840, 0x00cef001f0b4e040, 0x00d0f00208b6d040,
	0x00d30000e8b8d840, 0x00d3f80058b9c040, 0x00d4800050ba1840, 0x00d5000070ba6840,
	0x00d5800088bad840, 0x00d8000260bb6040, 0x00da800168bdc040, 0x00dc0003a0bf2840,
	// Entry E0 - FF
	0x00dfe001e0c2c840, 0x00e1d80078c4a840, 0x00e26801e0c52040, 0x00e4800158c70040,
	0x00e5e80058c85840, 0x00e6800158c8b040, 0x00e80007d0ca0840, 0x00efd808d8d1d840,
	0x00f8c00030dab040, 0x00f9000130dae040, 0x00fa400030dc1040, 0x00fa800040dc4040,
	0x00fac80008dc8040, 0x00fad80008dc8840, 0x00fae80008dc9040, 0x00faf800f8dc9840,
	0x00fc0001a8dd9040, 0x00fdb00078df3840, 0x00fe300070dfb040, 0x00feb00030e02040,
	0x00fee80098e05040, 0x00ff900018e0e840, 0x00ffb00048e10040, 0x0100000328e14840,
	0x0103300060e47040, 0x0103a000d8e4d040, 0x0104800068e5a840, 0x0105000100e61040,
	0x0106800108e71040, 0x0108000460e81840, 0x010c800098ec7840, 0x010d181420ed1060,
	// Entry 100 - 11F
	0x0122000059013060, 0x0123003851018860, 0x015b50005139d880, 0x015bb001013a2880,
	0x015cb804c13b2880, 0x01618001793fe880, 0x01630004a1416080, 0x0167c80169460080,
	0x0169380009476880, 0x0169680009477080, 0x01698001c1477880, 0x016b780011493880,
	0x016bf800c1494880, 0x016d0000394a0880, 0x016d4000394a4080, 0x016d8000394a7880,
	0x016dc000394ab080, 0x016e0000394ae880, 0x016e4000394b2080, 0x016e8000394b5880,
	0x016ec000394b9080, 0x016f0003994bc880, 0x01740000d14f6080, 0x0174d802c9503080,
	0x01780006b152f880, 0x017f80006159a880, 0x01800002015a0880, 0x01820802b15c0880,
	0x0184c803395eb880, 0x018828015961f080, 0x01898802f1634880, 0x018c8002a1663880,
	// Entry 120 - 13F
	0x018f80017968d880, 0x0191000f016a5080, 0x01a000ce00000370, 0x026e000201795080,
	0x0270028fe805e9f0, 0x05000020597b5080, 0x05205804119ba8a0, 0x05248001b99fb8a0,
	0x0526800ae1a170a0, 0x05320005c1ac50a0, 0x0538000601b210a0, 0x053e100049b810a0,
	0x053fa801c1b858a0, 0x0541800051ba18a0, 0x05420001c1ba68a0, 0x0544000231bc28a0,
	0x0546700061be58a0, 0x05470003a1beb8a0, 0x054af800f1c258a0, 0x054c000271c348a0,
	0x054e780059c5b8a0, 0x054ef00109c610a0, 0x05500001b9c718a0, 0x0552000071c8d0a0,
	0x0552800051c940a0, 0x0552e00339c990a0, 0x0556d800e1ccc8a0, 0x0558080031cda8a0,
	0x0558480031cdd8a0, 0x0558880031ce08a0, 0x0559000039ce38a0, 0x0559400039ce70a0,
	// Entry 140 - 15F
	0x05598001e1cea8a0, 0x055b8003f1d088a0, 0x055f800051d478a0, 0x0560015d20066230,
	0x06bd8000b9d4c8a0, 0x06be580189d580a0, 0x06c0001c00076410, 0x06dc00040009c390,
	0x06e000200006e9f0, 0x070000c8000aa1b0, 0x07c8000b71d708a0, 0x07d3800351e278a0,
	0x07d8000039e5c8a0, 0x07d8980029e600a0, 0x07d8e800d1e628a0, 0x07d9c00029e6f8a0,
	0x07d9f00009e720a0, 0x07da000011e728a0, 0x07da180011e738a0, 0x07da3003e1e748a0,
	0x07de980189eb28a0, 0x07e02009e1ecb0c0, 0x07ea800201f690c0, 0x07ec9001b1f890c0,
	0x07ef800071fa40c0, 0x07f00000d1fab0c0, 0x07f1000199fb80c0, 0x07f2a00099fd18c0,
	0x07f3400021fdb0c0, 0x07f3800029fdd0c0, 0x07f3b00439fdf8c0, 0x07f7f8000a0230c0,
	// Entry 160 - 17F
	0x07f80805f20238c0, 0x07fe1000320828c0, 0x07fe5000320858c0, 0x07fe9000320888c0,
	0x07fed0001a08b8c0, 0x07ff00003a08d0c0, 0x07ff40003a0908c0, 0x07ffc8002a0940c0,
	0x08000000620968c0, 0x08006800d209c8c0, 0x080140009a0a98c0, 0x0801e000120b30c0,
	0x0801f8007a0b40c0, 0x08028000720bb8c0, 0x08040003da0c28c0, 0x080800001a1000c0,
	0x080838016a1018c0, 0x0809b802c21180c0, 0x080c80006a1440c0, 0x080d00000a14a8c0,
	0x080e80017214b0c0, 0x08140000ea1620c0, 0x081500018a1708c0, 0x08170000e21890c0,
	0x08180001221970c0, 0x08196800f21a90c0, 0x081a80015a1b80c0, 0x081c0000f21cd8c0,
	0x081cf8012a1dc8c0, 0x081e4000721ef0c0, 0x08200004f21f60c0, 0x08250000522450c0,
	// Entry 180 - 19F
	0x082580012224a0c0, 0x0826c0012225c0c0, 0x082800014226e0c0, 0x08298001a22820c0,
	0x082b78000a29c0c0, 0x08300009ba29c8c0, 0x083a0000b23380c0, 0x083b0000423430c0,
	0x08400000323470c0, 0x084040000a34a0c0, 0x084050005a34a8c0, 0x0840a8010a3500e0,
	0x0841b800123608e0, 0x0841e0000a3618e0, 0x0841f800ba3620e0, 0x0842b8024236d8e0,
	0x084538004a3918e0, 0x084700009a3960e0, 0x0847a0001239f8e0, 0x0847d8010a3a08e0,
	0x0848f800da3b10e0, 0x0849f8000a3be8e0, 0x084c0001c23bf0e0, 0x084de000a23db0e0,
	0x084e9001923e50e0, 0x08502800123fe0e0, 0x08506000423ff0e0, 0x0850a8001a4030e0,
	0x0850c800ea4048e0, 0x0851c0001a4130e0, 0x0851f800524148e0, 0x085280004a4198e0,
	// Entry 1A0 - 1BF
	0x085300020241e0e0, 0x085600013a43e0e0, 0x08575800624518e0, 0x08580001b24578e0,
	0x0859c800ea4728e0, 0x085ac000da4810e0, 0x085bc000d248e8e0, 0x085cc8002249b8e0,
	0x085d48003a49d8e0, 0x086000024a4a10e0, 0x086400019a4c58e0, 0x086600019a4df0e0,
	0x0867d001724f88e0, 0x086980005250f8e0, 0x08730000fa5148e0, 0x08740001525240e0,
	0x087558001a5390e0, 0x087580001253a8e0, 0x087800014253b8e0, 0x087980015254f8e0,
	0x087d8000e25648e0, 0x087f0000ba5728e0, 0x088000027257e0e0, 0x08829000f25a50e0,
	0x0883f8021a5b40e0, 0x088668000a5d58e0, 0x08868000ca5d60e0, 0x08878000525e28e0,
	0x08880001aa5e78e0, 0x0889b000926020e0, 0x088a80013a60b0e0, 0x088c00030261e8e0,
	// Entry 1C0 - 1DF
	0x088f0800a264e8e0, 0x08900000926588e0, 0x08909801626618e0, 0x089400003a6778e0,
	0x089440000a67b0e0, 0x089450002267b8e0, 0x089478007a67d8e0, 0x0894f8005a6850e0,
	0x08958001da68a8e0, 0x08978000526a80e0, 0x08980000226ad0e0, 0x08982800426af0e0,
	0x08987800126b30e0, 0x08989800b26b40e0, 0x089950003a6bf0e0, 0x08999000126c28e0,
	0x0899a8002a6c38e0, 0x0899d800526c60e0, 0x089a3800126cb0e0, 0x089a58001a6cc0e0,
	0x089a80000a6cd8e0, 0x089ab8000a6ce0e0, 0x089ae8003a6ce8e0, 0x089b30003a6d20e0,
	0x089b80002a6d58e0, 0x08a00002e26d80e0, 0x08a2e8002a7060e0, 0x08a40002427088e0,
	0x08a680005272c8e0, 0x08ac0001b27318e0, 0x08adc0013274c8e0, 0x08b000022a75f8e0,
	// Entry 1E0 - 1FF
	0x08b28000527820e0, 0x08b300006a7870e0, 0x08b40001ca78d8e0, 0x08b60000527aa0e0,
	0x08b80000da7af0e0, 0x08b8e8007a7bc8e0, 0x08b98000827c40e0, 0x08c00001e27cc0e0,
	0x08c500029a7ea0e0, 0x08c7f800428138e0, 0x08c848000a8178e0, 0x08c86000428180e0,
	0x08c8a8001281c0e0, 0x08c8c000f281d0e0, 0x08c9b8001282c0e0, 0x08c9d8006282d0e0,
	0x08ca8000528330e0, 0x08cd0000428380e0, 0x08cd50017283c0e0, 0x08ced0005a8530e0,
	0x08d00002428588e0, 0x08d280029a87c8e0, 0x08d60001ca8a60e0, 0x08e000004a8c28e0,
	0x08e050016a8c70e0, 0x08e1c000728dd8e0, 0x08e28000ea8e48e0, 0x08e38000c28f30e0,
	0x08e44000428ff100, 0x08e49000b2903100, 0x08e548007290e100, 0x08e800003a915100,
	// Entry 200 - 21F
	0x08e8400012918900, 0x08e8580162919900, 0x08e9d0000a92f900, 0x08e9e00012930100,
	0x08e9f8004a931100, 0x08ea800052935900, 0x08eb00003293a900, 0x08eb38001293d900,
	0x08eb50012a93e900, 0x08ec800012951100, 0x08ec980032952100, 0x08ed000052955100,
	0x08f70000ca95a100, 0x08fd80000a966900, 0x08fe000192967100, 0x08fff81cda980100,
	0x092000037ab4d900, 0x092380002ab85100, 0x0924000622b87900, 0x0980001f72be9900,
	0x099f70020ade0920, 0x09a180004ae01120, 0x0a2000123ae05920, 0x0b400011caf29120,
	0x0b520000fb045920, 0x0b53000053055120, 0x0b5370001305a120, 0x0b568000f305b120,
	0x0b5780003306a120, 0x0b5800023306d120, 0x0b5a800053090120, 0x0b5ad8003b095120,
	// Entry 220 - 23F
	0x0b5b1800ab098920, 0x0b5be8009b0a3120, 0x0b720002db0ac920, 0x0b7800025b0da120,
	0x0b7a7801cb0ff920, 0x0b7c78008b11c120, 0x0b7f00002b124920, 0x0b7f800013127120,
	0x0b8000bfc00bf250, 0x0c40001fd3128120, 0x0c5fd006e3325140, 0x0c680000480b0bb0,
	0x0d800008fb393140, 0x0d8a80001b422940, 0x0d8b200023424140, 0x0d8b800c63426140,
	0x0de000035b4ec140, 0x0de380006b521940, 0x0de400004b528140, 0x0de480005352c940,
	0x0de4e00043531940, 0x0e800007b3535940, 0x0e8800013b5b0940, 0x0e894806035c4140,
	0x0e90000233624140, 0x0e970000a3647140, 0x0e980002bb651140, 0x0e9b0000cb67c940,
	0x0ea00002ab689140, 0x0ea2b0023b6b3940, 0x0ea4f000136d7140, 0x0ea510000b6d8140,
	// Entry 240 - 25F
	0x0ea52800136d8940, 0x0ea54800236d9940, 0x0ea57000636db940, 0x0ea5d8000b6e1940,
	0x0ea5e8003b6e2140, 0x0ea628020b6e5940, 0x0ea8380023706140, 0x0ea8680043708140,
	0x0ea8b0003b70c140, 0x0ea8f000e370f940, 0x0ea9d8002371d940, 0x0eaa00002b71f940,
	0x0eaa30000b722140, 0x0eaa50003b722940, 0x0eaa90070b726140, 0x0eb198039b796960,
	0x0eb54009237d0160, 0x0ebe7015f3862160, 0x0ed4d8002b9c1160, 0x0ed508007b9c3960,
	0x0f0000003b9cb160, 0x0f0040008b9ce960, 0x0f00d8003b9d7160, 0x0f011800139da960,
	0x0f0130002b9db960, 0x0f0800016b9de160, 0x0f098000739f4960, 0x0f0a0000539fb960,
	0x0f0a700013a00960, 0x0f160001d3a01960, 0x0f17f8000ba1e960, 0x0f4000062ba1f160,
	// Entry 260 - 27F
	0x0f46380083a81960, 0x0f48000263a89960, 0x0f4a800053aaf960, 0x0f4af00013ab4960,
	0x0f63880223ab5960, 0x0f680801ebad7960, 0x0f70000023af6160, 0x0f702800dbaf8160,
	0x0f71080013b05960, 0x0f7120000bb06960, 0x0f7138000bb07160, 0x0f71480053b07960,
	0x0f71a00023b0c960, 0x0f71c8000bb0e960, 0x0f71d8000bb0f160, 0x0f7210000bb0f960,
	0x0f7238000bb10160, 0x0f7248000bb10960, 0x0f7258000bb11160, 0x0f7268001bb11960,
	0x0f72880013b13160, 0x0f72a0000bb14160, 0x0f72b8000bb14960, 0x0f72c8000bb15160,
	0x0f72d8000bb15960, 0x0f72e8000bb16160, 0x0f72f8000bb16960, 0x0f73080013b17160,
	0x0f7320000bb18160, 0x0f73380023b18960, 0x0f7360003bb1a960, 0x0f73a00023b1e160,
	// Entry 280 - 29F
	0x0f73c80023b20160, 0x0f73f0000bb22160, 0x0f74000053b22960, 0x0f7458008bb27960,
	0x0f7508001bb30160, 0x0f7528002bb31960, 0x0f75580023b34160, 0x0f7578006bb36180,
	0x0f77800013b3c980, 0x0f80000163b3d980, 0x0f81800323b53980, 0x0f8500007bb85980,
	0x0f8588007bb8d180, 0x0f8608007bb94980, 0x0f8688012bb9c180, 0x0f88000573bae980,
	0x0f8f3000ebc05980, 0x0f90800163c14180, 0x0f9200004bc2a180, 0x0f92800013c2e980,
	0x0f93000033c2f980, 0x0f98001ec3c32980, 0x0fb700006be1e980, 0x0fb780006be25180,
	0x0fb80003a3e2b980, 0x0fbc0002cbe65980, 0x0fbf000063e92180, 0x0fc0000063e98180,
	0x0fc08001c3e9e180, 0x0fc2800053eba180, 0x0fc3000143ebf180, 0x0fc48000f3ed3180,
	// Entry 2A0 - 2BF
	0x0fc5800013ee2180, 0x0fc80003cbee3180, 0x0fcbd00293f1f980, 0x0fce68043bf48980,
	0x0fd3000073f8c180, 0x0fd380002bf93180, 0x0fd3c0001bf95980, 0x0fd400003bf97180,
	0x0fd48000cbf9a980, 0x0fd580003bfa7180, 0x0fd600001bfaa980, 0x0fd680003bfac180,
	0x0fd800049bfaf980, 0x0fdca001bbff9180, 0x0fdf800054014980, 0x10000536f000db70,
	0x15380081a801b370, 0x15ba0006f0028b70, 0x15c100b410036370, 0x167580e988043b70,
	0x17c000078c019980, 0x17c788096c0921a0, 0x1800009a58051370, 0x700008000c1289a0,
	0x70010003041291a0, 0x70080007841591a0, 0x780007fff00862d0, 0x800007fff00912d0,
} // Size: 5624 bytes

var index = []uint16{ // 33699 elements
	// Entry 0 - 3F
	0x0000, 0x0005, 0x0015, 0x0023, 0x002e, 0x0039, 0x0045, 0x004e,
	0x0058, 0x0068, 0x0079, 0x0081, 0x008a, 0x008f, 0x009b, 0x00a4,
	0x00ab, 0x00b5, 0x00be, 0x00c7, 0x00d2, 0x00dc, 0x00e6, 0x00ef,
	0x00fa, 0x0105, 0x010f, 0x0114, 0x011d, 0x012b, 0x0136, 0x0147,
	0x0154, 0x0161, 0x0177, 0x018d, 0x01a3, 0x01b9, 0x01cf, 0x01e5,
	0x01fb, 0x0211, 0x0227, 0x023d, 0x0253, 0x0269, 0x027f, 0x0295,
	0x02ab, 0x02c1, 0x02d7, 0x02ed, 0x0303, 0x0319, 0x032f, 0x0345,
	0x035b, 0x0371, 0x0387, 0x039d, 0x03b0, 0x03bf, 0x03d3, 0x03e4,
	// Entry 40 - 7F
	0x03ec, 0x03f8, 0x040c, 0x0420, 0x0434, 0x0448, 0x045c, 0x0470,
	0x0484, 0x0498, 0x04ac, 0x04c0, 0x04d4, 0x04e8, 0x04fc, 0x0510,
	0x0524, 0x0538, 0x054c, 0x0560, 0x0574, 0x0588, 0x059c, 0x05b0,
	0x05c4, 0x05d8, 0x05ec, 0x0600, 0x0612, 0x061f, 0x0632, 0x0637,
	0x0645, 0x065e, 0x0667, 0x0671, 0x067e, 0x0686, 0x0690, 0x069c,
	0x06a5, 0x06b3, 0x06cd, 0x06f6, 0x06fe, 0x0709, 0x0718, 0x071e,
	0x0729, 0x0738, 0x0747, 0x0758, 0x0764, 0x076e, 0x077a, 0x0784,
	0x078b, 0x079a, 0x07b5, 0x07df, 0x07fa, 0x0812, 0x0830, 0x0846,
	// Entry 80 - BF
	0x0867, 0x0888, 0x08ae, 0x08cf, 0x08f4, 0x091a, 0x0931, 0x0954,
	0x0975, 0x0996, 0x09bc, 0x09e1, 0x0a02, 0x0a23, 0x0a49, 0x0a6e,
	0x0a86, 0x0aa7, 0x0ac8, 0x0ae9, 0x0b0f, 0x0b30, 0x0b55, 0x0b68,
	0x0b8a, 0x0bab, 0x0bcc, 0x0bf2, 0x0c17, 0x0c38, 0x0c52, 0x0c6c,
	0x0c8b, 0x0caa, 0x0cce, 0x0ced, 0x0d10, 0x0d34, 0x0d49, 0x0d6a,
	0x0d89, 0x0da8, 0x0dcc, 0x0def, 0x0e0e, 0x0e2d, 0x0e51, 0x0e74,
	0x0e8a, 0x0ea9, 0x0ec8, 0x0ee7, 0x0f0b, 0x0f2a, 0x0f4d, 0x0f5a,
	0x0f7a, 0x0f99, 0x0fb8, 0x0fdc, 0x0fff, 0x101e, 0x1036, 0x1059,
	// Entry C0 - FF
	0x107b, 0x109b, 0x10bc, 0x10db, 0x10fd, 0x111d, 0x113e, 0x115d,
	0x1183, 0x11a7, 0x11cc, 0x11ef, 0x1210, 0x122f, 0x1250, 0x126f,
	0x1291, 0x12b1, 0x12d3, 0x12f3, 0x1314, 0x1333, 0x1358, 0x137b,
	0x139d, 0x13bd, 0x13de, 0x13fd, 0x1423, 0x1447, 0x1468, 0x1487,
	0x14ac, 0x14cf, 0x14f2, 0x1513, 0x1539, 0x155d, 0x157f, 0x159f,
	0x15c0, 0x15df, 0x1601, 0x1621, 0x1642, 0x1661, 0x1683, 0x16a3,
	0x16c8, 0x16e4, 0x16fd, 0x1714, 0x173a, 0x175e, 0x1781, 0x17a2,
	0x17b8, 0x17d9, 0x17f8, 0x181b, 0x183c, 0x185d, 0x187c, 0x18a2,
	// Entry 100 - 13F
	0x18c6, 0x18e8, 0x1908, 0x1929, 0x1948, 0x196b, 0x198c, 0x19ad,
	0x19cc, 0x19f7, 0x1a0f, 0x1a25, 0x1a47, 0x1a67, 0x1a88, 0x1aa7,
	0x1acf, 0x1af5, 0x1b0e, 0x1b25, 0x1b46, 0x1b65, 0x1b88, 0x1ba9,
	0x1bca, 0x1be9, 0x1c0a, 0x1c29, 0x1c4f, 0x1c73, 0x1c96, 0x1cb7,
	0x1cd8, 0x1cf7, 0x1d1a, 0x1d3b, 0x1d5c, 0x1d7b, 0x1d9d, 0x1dbd,
	0x1dde, 0x1dfd, 0x1e1f, 0x1e3f, 0x1e60, 0x1e7f, 0x1ea5, 0x1ec9,
	0x1ef1, 0x1f17, 0x1f39, 0x1f59, 0x1f7f, 0x1fa3, 0x1fc9, 0x1fed,
	0x2012, 0x2033, 0x2052, 0x2077, 0x209a, 0x20bb, 0x20da, 0x20f3,
	// Entry 140 - 17F
	0x2113, 0x2133, 0x2155, 0x2175, 0x2192, 0x21ad, 0x21c8, 0x21e8,
	0x2206, 0x2224, 0x2244, 0x2266, 0x2286, 0x22a5, 0x22c4, 0x22de,
	0x22f9, 0x2319, 0x2337, 0x2357, 0x2371, 0x2386, 0x239f, 0x23c1,
	0x23e1, 0x23ff, 0x241c, 0x2441, 0x245e, 0x2483, 0x24ab, 0x24d3,
	0x24f3, 0x2511, 0x2528, 0x253d, 0x255d, 0x257b, 0x258a, 0x25a7,
	0x25c2, 0x25da, 0x25f8, 0x261e, 0x263e, 0x265c, 0x2686, 0x26a6,
	0x26c4, 0x26e0, 0x2700, 0x2720, 0x273e, 0x2760, 0x2780, 0x2798,
	0x27b9, 0x27d8, 0x27f8, 0x2814, 0x2832, 0x284e, 0x287c, 0x288d,
	// Entry 180 - 1BF
	0x28a6, 0x28c0, 0x28db, 0x28f7, 0x2919, 0x294e, 0x296e, 0x2985,
	0x29af, 0x29c4, 0x29db, 0x2a05, 0x2a1a, 0x2a3b, 0x2a5a, 0x2a7b,
	0x2a9a, 0x2abb, 0x2ada, 0x2afb, 0x2b1a, 0x2b4a, 0x2b78, 0x2ba7,
	0x2bd4, 0x2c03, 0x2c30, 0x2c5f, 0x2c8c, 0x2ca7, 0x2cd7, 0x2d05,
	0x2d35, 0x2d63, 0x2d86, 0x2da7, 0x2dc9, 0x2de9, 0x2e0a, 0x2e29,
	0x2e4a, 0x2e69, 0x2e8b, 0x2eab, 0x2ed8, 0x2f03, 0x2f26, 0x2f47,
	0x2f66, 0x2f7d, 0x2fa7, 0x2fbc, 0x2fdd, 0x2ffc, 0x3016, 0x302f,
	0x3050, 0x306f, 0x309f, 0x30cd, 0x30ef, 0x310f, 0x313b, 0x3165,
	// Entry 1C0 - 1FF
	0x318d, 0x31b3, 0x31dd, 0x3205, 0x322d, 0x3253, 0x327d, 0x32a5,
	0x32cd, 0x32f3, 0x331d, 0x3345, 0x336d, 0x3393, 0x33bd, 0x33e5,
	0x340d, 0x3433, 0x345d, 0x3485, 0x34ad, 0x34d3, 0x34fd, 0x3525,
	0x354c, 0x3571, 0x3598, 0x35bd, 0x35d6, 0x35ed, 0x360e, 0x362d,
	0x3657, 0x3675, 0x368c, 0x36a1, 0x36c1, 0x36df, 0x3704, 0x3727,
	0x374a, 0x376b, 0x379b, 0x37c9, 0x37f5, 0x381f, 0x3844, 0x3867,
	0x3897, 0x38c5, 0x38e7, 0x3907, 0x3925, 0x3943, 0x3961, 0x397d,
	0x399a, 0x39b7, 0x39d9, 0x39fb, 0x3a1b, 0x3a3a, 0x3a65, 0x3a89,
	// Entry 200 - 23F
	0x3aad, 0x3ace, 0x3aed, 0x3b0f, 0x3b29, 0x3b46, 0x3b68, 0x3b88,
	0x3baa, 0x3bca, 0x3bf5, 0x3c18, 0x3c3a, 0x3c5a, 0x3c7c, 0x3c9c,
	0x3cb7, 0x3ccf, 0x3cee, 0x3d0c, 0x3d25, 0x3d43, 0x3d61, 0x3d7f,
	0x3d9c, 0x3db4, 0x3dd6, 0x3def, 0x3e11, 0x3e3d, 0x3e66, 0x3e8e,
	0x3eac, 0x3ec7, 0x3ee3, 0x3efb, 0x3f17, 0x3f32, 0x3f50, 0x3f71,
	0x3f91, 0x3fa8, 0x3fc4, 0x3fea, 0x4008, 0x4030, 0x4047, 0x4062,
	0x408b, 0x40a9, 0x40cc, 0x40f4, 0x4110, 0x412b, 0x4148, 0x4167,
	0x417d, 0x4198, 0x41c1, 0x41e6, 0x4208, 0x4226, 0x4248, 0x4273,
	// Entry 240 - 27F
	0x428f, 0x42b4, 0x42d2, 0x42e8, 0x4319, 0x433e, 0x435e, 0x4379,
	0x43a1, 0x43b9, 0x43d3, 0x43f1, 0x440c, 0x4427, 0x4442, 0x445e,
	0x4486, 0x44a4, 0x44ba, 0x44da, 0x44f3, 0x451b, 0x453d, 0x4555,
	0x4570, 0x458c, 0x45ac, 0x45d2, 0x45ee, 0x4614, 0x462f, 0x464b,
	0x4669, 0x468e, 0x46bc, 0x46d9, 0x46f8, 0x471f, 0x473c, 0x475b,
	0x4782, 0x47a1, 0x47be, 0x47db, 0x47fb, 0x481b, 0x4844, 0x4876,
	0x488d, 0x48ae, 0x48c5, 0x48dc, 0x48fa, 0x4922, 0x494a, 0x4961,
	0x4978, 0x498d, 0x49a9, 0x49c5, 0x49df, 0x49fd, 0x4a1c, 0x4a3a,
	// Entry 280 - 2BF
	0x4a56, 0x4a7b, 0x4a99, 0x4ab8, 0x4ad4, 0x4af2, 0x4b13, 0x4b18,
	0x4b35, 0x4b4b, 0x4b67, 0x4b83, 0x4ba4, 0x4bbe, 0x4bde, 0x4bfe,
	0x4c1e, 0x4c43, 0x4c6a, 0x4c90, 0x4ca7, 0x4cc0, 0x4cd9, 0x4cf3,
	0x4cf8, 0x4d01, 0x4d0b, 0x4d11, 0x4d1c, 0x4d2f, 0x4d4a, 0x4d66,
	0x4d81, 0x4d98, 0x4daf, 0x4dc6, 0x4df1, 0x4e14, 0x4e31, 0x4e4d,
	0x4e69, 0x4e8b, 0x4eb2, 0x4eda, 0x4ef1, 0x4f0c, 0x4f2d, 0x4f4f,
	0x4f6f, 0x4f91, 0x4fb4, 0x4fcc, 0x4fef, 0x5019, 0x5043, 0x505c,
	0x5078, 0x5097, 0x50b4, 0x50d2, 0x50ee, 0x5103, 0x511d, 0x513b,
	// Entry 2C0 - 2FF
	0x5151, 0x5167, 0x5182, 0x5191, 0x51a1, 0x51b3, 0x51c2, 0x51d5,
	0x51e8, 0x51fc, 0x5210, 0x522d, 0x523c, 0x5259, 0x527d, 0x529a,
	0x52af, 0x52c7, 0x52e3, 0x52f8, 0x5316, 0x5331, 0x534d, 0x5369,
	0x5382, 0x539c, 0x53b6, 0x53c4, 0x53e2, 0x53f9, 0x5412, 0x542b,
	0x5445, 0x5465, 0x5483, 0x5496, 0x54af, 0x54c3, 0x54d8, 0x54e9,
	0x54f9, 0x5516, 0x552c, 0x5550, 0x5565, 0x5586, 0x559b, 0x55b9,
	0x55ce, 0x55e4, 0x55f6, 0x560f, 0x5626, 0x5644, 0x5661, 0x5680,
	0x569e, 0x56bd, 0x56dc, 0x56f2, 0x5709, 0x571a, 0x5732, 0x574b,
	// Entry 300 - 33F
	0x5764, 0x577d, 0x5798, 0x57af, 0x57ce, 0x57eb, 0x5801, 0x581c,
	0x5840, 0x585a, 0x5873, 0x588d, 0x58ac, 0x58cc, 0x58e9, 0x5902,
	0x5921, 0x593f, 0x5950, 0x5961, 0x597f, 0x599e, 0x59ce, 0x59ed,
	0x5a06, 0x5a1e, 0x5a39, 0x5a4f, 0x5a6b, 0x5a81, 0x5a98, 0x5ab5,
	0x5acb, 0x5aea, 0x5b11, 0x5b2f, 0x5b4d, 0x5b6b, 0x5b89, 0x5ba7,
	0x5bc5, 0x5be3, 0x5c01, 0x5c1f, 0x5c3d, 0x5c5b, 0x5c79, 0x5c97,
	0x5cb0, 0x5cc7, 0x5ce9, 0x5d09, 0x5d1b, 0x5d33, 0x5d5a, 0x5d7f,
	0x5d92, 0x5dba, 0x5de0, 0x5e0f, 0x5e22, 0x5e3a, 0x5e45, 0x5e5a,
	// Entry 340 - 37F
	0x5e7f, 0x5e8f, 0x5eb6, 0x5ed9, 0x5efd, 0x5f24, 0x5f4b, 0x5f70,
	0x5fa0, 0x5fba, 0x5fd3, 0x5fed, 0x6007, 0x6023, 0x603c, 0x6054,
	0x606e, 0x6087, 0x60a1, 0x60bb, 0x60d2, 0x60e9, 0x6100, 0x611c,
	0x6133, 0x614b, 0x6165, 0x617d, 0x6199, 0x61b1, 0x61c9, 0x61e1,
	0x61fb, 0x6223, 0x624e, 0x6271, 0x6296, 0x62b7, 0x62d9, 0x630c,
	0x6324, 0x633b, 0x6353, 0x636b, 0x6385, 0x639c, 0x63b2, 0x63ca,
	0x63e1, 0x63f9, 0x6411, 0x6426, 0x643b, 0x6450, 0x646a, 0x647f,
	0x6495, 0x64b3, 0x64cb, 0x64e1, 0x64fb, 0x6511, 0x6527, 0x653d,
	// Entry 380 - 3BF
	0x6555, 0x657b, 0x65a4, 0x65c9, 0x65ee, 0x6611, 0x6629, 0x663a,
	0x664c, 0x666a, 0x6692, 0x66be, 0x66ce, 0x66dd, 0x66ed, 0x6707,
	0x6727, 0x673a, 0x6753, 0x6767, 0x6781, 0x6793, 0x67ab, 0x67bd,
	0x67d5, 0x67ef, 0x6807, 0x6820, 0x6837, 0x6851, 0x6869, 0x6883,
	0x689b, 0x68b7, 0x68d1, 0x68ec, 0x6905, 0x691e, 0x6935, 0x6947,
	0x6957, 0x6970, 0x6980, 0x699a, 0x69b5, 0x69d9, 0x69f1, 0x6a07,
	0x6a28, 0x6a40, 0x6a56, 0x6a72, 0x6a9c, 0x6ac4, 0x6af5, 0x6b1a,
	0x6b34, 0x6b4f, 0x6b6a, 0x6b8e, 0x6ba9, 0x6bd9, 0x6bf3, 0x6c0d,
	// Entry 3C0 - 3FF
	0x6c28, 0x6c43, 0x6c5f, 0x6c7a, 0x6c9e, 0x6cbd, 0x6cd9, 0x6cf2,
	0x6d0c, 0x6d26, 0x6d41, 0x6d5b, 0x6d75, 0x6d90, 0x6daa, 0x6dc3,
	0x6de2, 0x6dfc, 0x6e16, 0x6e30, 0x6e4a, 0x6e63, 0x6e7d, 0x6e97,
	0x6eb1, 0x6ecb, 0x6ee4, 0x6efe, 0x6f18, 0x6f33, 0x6f4e, 0x6f69,
	0x6f86, 0x6fa7, 0x6fc3, 0x6fe4, 0x6ffd, 0x7017, 0x7031, 0x7048,
	0x7060, 0x7078, 0x7091, 0x70a9, 0x70c1, 0x70da, 0x70f2, 0x7109,
	0x7126, 0x713e, 0x7156, 0x716e, 0x7186, 0x719d, 0x71b5, 0x71cd,
	0x71e5, 0x71fd, 0x7214, 0x722c, 0x7244, 0x725d, 0x7276, 0x728f,
	// Entry 400 - 43F
	0x72aa, 0x72c9, 0x72e3, 0x7302, 0x7319, 0x7331, 0x7349, 0x736c,
	0x7384, 0x739d, 0x73b6, 0x73d8, 0x73f1, 0x741f, 0x7437, 0x744f,
	0x7468, 0x7481, 0x749b, 0x74b4, 0x74d6, 0x74f3, 0x750d, 0x752a,
	0x7545, 0x7560, 0x7579, 0x759b, 0x75bb, 0x75dd, 0x75fd, 0x7628,
	0x7651, 0x7670, 0x768d, 0x76b5, 0x76db, 0x76f6, 0x770f, 0x772a,
	0x7743, 0x775f, 0x7779, 0x7798, 0x77b5, 0x77ed, 0x7823, 0x783d,
	0x7855, 0x7878, 0x7899, 0x78c1, 0x78e7, 0x7901, 0x7919, 0x7936,
	0x7951, 0x7968, 0x7980, 0x79a1, 0x79c2, 0x79e3, 0x79fe, 0x7a27,
	// Entry 440 - 47F
	0x7a47, 0x7a70, 0x7a97, 0x7abc, 0x7adf, 0x7b03, 0x7b25, 0x7b4c,
	0x7b71, 0x7b98, 0x7bbd, 0x7be9, 0x7c13, 0x7c3d, 0x7c65, 0x7c8e,
	0x7cb5, 0x7cde, 0x7d05, 0x7d34, 0x7d61, 0x7d87, 0x7dab, 0x7dcd,
	0x7ded, 0x7e16, 0x7e3d, 0x7e5d, 0x7e7b, 0x7ea6, 0x7ecf, 0x7ef3,
	0x7f15, 0x7f3e, 0x7f65, 0x7f8e, 0x7fb5, 0x7fd7, 0x7ff7, 0x8025,
	0x8051, 0x807a, 0x80a1, 0x80c1, 0x80df, 0x8109, 0x8131, 0x8161,
	0x818f, 0x81ab, 0x81c5, 0x81ea, 0x820d, 0x8241, 0x8273, 0x828b,
	0x82b1, 0x82d5, 0x82f9, 0x831b, 0x833f, 0x8361, 0x8385, 0x83a7,
	// Entry 480 - 4BF
	0x83cb, 0x83ed, 0x8413, 0x8437, 0x845b, 0x847d, 0x849b, 0x84bf,
	0x84e1, 0x8509, 0x852f, 0x854d, 0x8569, 0x858e, 0x85b1, 0x85ce,
	0x85e9, 0x8615, 0x863f, 0x8669, 0x8691, 0x86ba, 0x86e1, 0x8706,
	0x8729, 0x874e, 0x8771, 0x8799, 0x87bf, 0x87e7, 0x880d, 0x882d,
	0x884b, 0x887a, 0x88a7, 0x88cf, 0x88f5, 0x891a, 0x893d, 0x8965,
	0x898b, 0x89b6, 0x89df, 0x8a09, 0x8a31, 0x8a5b, 0x8a83, 0x8aae,
	0x8ad7, 0x8b07, 0x8b35, 0x8b59, 0x8b7b, 0x8ba1, 0x8bc5, 0x8be4,
	0x8c01, 0x8c21, 0x8c3f, 0x8c5f, 0x8c7d, 0x8c9e, 0x8cbd, 0x8cdd,
	// Entry 4C0 - 4FF
	0x8cfb, 0x8d1b, 0x8d39, 0x8d59, 0x8d77, 0x8d97, 0x8db5, 0x8dd8,
	0x8df9, 0x8e1d, 0x8e3f, 0x8e5a, 0x8e73, 0x8e8e, 0x8ea7, 0x8ec2,
	0x8edb, 0x8ef5, 0x8f0d, 0x8f27, 0x8f3f, 0x8f5f, 0x8f7d, 0x8fa8,
	0x8fd1, 0x8ffc, 0x9025, 0x904e, 0x9075, 0x90a0, 0x90c9, 0x90f2,
	0x9119, 0x9136, 0x9151, 0x916d, 0x9187, 0x91b0, 0x91d7, 0x91f2,
	0x920d, 0x9228, 0x9242, 0x925d, 0x9277, 0x9291, 0x92ab, 0x92c5,
	0x92e0, 0x92fb, 0x9317, 0x9332, 0x934c, 0x9367, 0x9381, 0x939b,
	0x93b7, 0x93d3, 0x93ee, 0x9408, 0x9423, 0x943e, 0x9458, 0x9473,
	// Entry 500 - 53F
	0x948e, 0x94aa, 0x94c4, 0x94df, 0x94fa, 0x9516, 0x9531, 0x954b,
	0x9567, 0x9583, 0x959e, 0x95b8, 0x95d3, 0x95fa, 0x960d, 0x9623,
	0x963c, 0x964a, 0x9660, 0x967a, 0x969a, 0x96b3, 0x96cc, 0x96e5,
	0x96fd, 0x9716, 0x972e, 0x9746, 0x975e, 0x9776, 0x978f, 0x97a8,
	0x97c2, 0x97db, 0x97f3, 0x980c, 0x9824, 0x983c, 0x9856, 0x9870,
	0x9889, 0x98a1, 0x98ba, 0x98d3, 0x98eb, 0x9904, 0x991d, 0x9937,
	0x994f, 0x9968, 0x9981, 0x999b, 0x99b4, 0x99cc, 0x99e6, 0x9a00,
	0x9a19, 0x9a31, 0x9a4a, 0x9a6a, 0x9a8e, 0x9aa0, 0x9aaf, 0x9ad2,
	// Entry 540 - 57F
	0x9af4, 0x9b06, 0x9b1b, 0x9b2e, 0x9b46, 0x9b5f, 0x9b78, 0x9b8c,
	0x9b9f, 0x9bb2, 0x9bc6, 0x9bd9, 0x9bec, 0x9c00, 0x9c1b, 0x9c32,
	0x9c4b, 0x9c67, 0x9c7a, 0x9c94, 0x9ca7, 0x9cbd, 0x9cd1, 0x9cec,
	0x9cff, 0x9d12, 0x9d2e, 0x9d4a, 0x9d5b, 0x9d6d, 0x9d7f, 0x9d92,
	0x9dab, 0x9dbd, 0x9dd5, 0x9ded, 0x9e06, 0x9e18, 0x9e2a, 0x9e3c,
	0x9e4e, 0x9e61, 0x9e73, 0x9e93, 0x9ea6, 0x9ec2, 0x9ed4, 0x9eec,
	0x9efd, 0x9f15, 0x9f2a, 0x9f3e, 0x9f5a, 0x9f6f, 0x9f84, 0x9fa2,
	0x9fbb, 0x9fcd, 0x9fde, 0x9ff1, 0xa004, 0xa014, 0xa025, 0xa038,
	// Entry 580 - 5BF
	0xa049, 0xa05a, 0xa06b, 0xa082, 0xa093, 0xa0a6, 0xa0bd, 0xa0ce,
	0xa0e5, 0xa0f6, 0xa10a, 0xa11c, 0xa132, 0xa142, 0xa15b, 0xa16e,
	0xa17f, 0xa191, 0xa1a3, 0xa1b4, 0xa1c7, 0xa1e9, 0xa208, 0xa22a,
	0xa243, 0xa25f, 0xa271, 0xa282, 0xa298, 0xa2a9, 0xa2bb, 0xa2d3,
	0xa2e9, 0xa301, 0xa30b, 0xa326, 0xa348, 0xa354, 0xa360, 0xa375,
	0xa38d, 0xa39e, 0xa3c6, 0xa3e1, 0xa3ff, 0xa41c, 0xa431, 0xa446,
	0xa477, 0xa48d, 0xa49f, 0xa4b1, 0xa4c3, 0xa4d3, 0xa4e5, 0xa507,
	0xa51b, 0xa535, 0xa548, 0xa56b, 0xa58e, 0xa5b0, 0xa5d3, 0xa5f5,
	// Entry 5C0 - 5FF
	0xa607, 0xa618, 0xa631, 0xa642, 0xa654, 0xa666, 0xa677, 0xa689,
	0xa69a, 0xa6ac, 0xa6bd, 0xa6cf, 0xa6e1, 0xa6f4, 0xa705, 0xa716,
	0xa727, 0xa738, 0xa749, 0xa75c, 0xa783, 0xa7ac, 0xa7d3, 0xa7fe,
	0xa82b, 0xa839, 0xa84a, 0xa85b, 0xa86c, 0xa87d, 0xa88f, 0xa8a1,
	0xa8b2, 0xa8c3, 0xa8dd, 0xa8ee, 0xa8fd, 0xa90c, 0xa91b, 0xa927,
	0xa933, 0xa93f, 0xa94c, 0xa958, 0xa96b, 0xa97d, 0xa98f, 0xa9a4,
	0xa9b9, 0xa9d0, 0xa9df, 0xa9fe, 0xaa26, 0xaa41, 0xaa56, 0xaa70,
	0xaa87, 0xaa9e, 0xaab4, 0xaaca, 0xaae2, 0xaaf9, 0xab10, 0xab26,
	// Entry 600 - 63F
	0xab3e, 0xab56, 0xab6d, 0xab80, 0xab98, 0xabb2, 0xabca, 0xabe3,
	0xabfc, 0xac1a, 0xac32, 0xac5a, 0xac82, 0xac9a, 0xacb7, 0xacd3,
	0xacf3, 0xad0f, 0xad21, 0xad35, 0xad47, 0xad62, 0xad93, 0xada4,
	0xadb7, 0xadca, 0xadec, 0xae1a, 0xae2c, 0xae3e, 0xae65, 0xae78,
	0xae8d, 0xae9f, 0xaeba, 0xaeda, 0xaf08, 0xaf1b, 0xaf2f, 0xaf40,
	0xaf71, 0xaf97, 0xafa9, 0xafc7, 0xafe2, 0xb002, 0xb026, 0xb054,
	0xb079, 0xb08a, 0xb0b0, 0xb0df, 0xb107, 0xb144, 0xb169, 0xb190,
	0xb1b7, 0xb1de, 0xb1f7, 0xb21d, 0xb23d, 0xb24e, 0xb275, 0xb288,
	// Entry 640 - 67F
	0xb2a8, 0xb2cf, 0xb2e2, 0xb2f9, 0xb314, 0xb334, 0xb344, 0xb36b,
	0xb37c, 0xb397, 0xb3aa, 0xb3cf, 0xb3e1, 0xb408, 0xb426, 0xb446,
	0xb46d, 0xb494, 0xb4b5, 0xb4ce, 0xb4e1, 0xb4fd, 0xb525, 0xb542,
	0xb564, 0xb584, 0xb59a, 0xb5c1, 0xb5df, 0xb5fa, 0xb612, 0xb622,
	0xb631, 0xb641, 0xb659, 0xb67e, 0xb68e, 0xb6a5, 0xb6c0, 0xb6de,
	0xb6fe, 0xb70d, 0xb734, 0xb74c, 0xb775, 0xb785, 0xb795, 0xb7ce,
	0xb807, 0xb82a, 0xb844, 0xb85a, 0xb876, 0xb88c, 0xb89e, 0xb8b9,
	0xb8d7, 0xb901, 0xb927, 0xb94b, 0xb960, 0xb977, 0xb987, 0xb997,
	// Entry 680 - 6BF
	0xb9ac, 0xb9c2, 0xb9d8, 0xb9f4, 0xba11, 0xba3c, 0xba51, 0xba72,
	0xba93, 0xbab3, 0xbad2, 0xbaf1, 0xbb12, 0xbb32, 0xbb52, 0xbb71,
	0xbb92, 0xbbb3, 0xbbd3, 0xbbf5, 0xbc15, 0xbc37, 0xbc53, 0xbc76,
	0xbc97, 0xbcae, 0xbcca, 0xbce4, 0xbcfc, 0xbd12, 0xbd29, 0xbd41,
	0xbd5a, 0xbd7e, 0xbda1, 0xbdb3, 0xbdc9, 0xbde2, 0xbdfc, 0xbe14,
	0xbe27, 0xbe46, 0xbe58, 0xbe6b, 0xbe87, 0xbe9b, 0xbebc, 0xbecc,
	0xbedd, 0xbeef, 0xbf01, 0xbf13, 0xbf2e, 0xbf40, 0xbf55, 0xbf67,
	0xbf7b, 0xbf8c, 0xbf9d, 0xbfb2, 0xbfcd, 0xbfdc, 0xbfec, 0xc005,
	// Entry 6C0 - 6FF
	0xc018, 0xc02a, 0xc03c, 0xc04e, 0xc05f, 0xc07a, 0xc096, 0xc0b3,
	0xc0c6, 0xc0d9, 0xc0ed, 0xc100, 0xc113, 0xc127, 0xc139, 0xc14b,
	0xc169, 0xc184, 0xc196, 0xc1a8, 0xc1c1, 0xc1d3, 0xc1e5, 0xc1f1,
	0xc204, 0xc214, 0xc223, 0xc241, 0xc25f, 0xc276, 0xc28d, 0xc2a6,
	0xc2bf, 0xc2cb, 0xc2d9, 0xc2f4, 0xc30f, 0xc327, 0xc35b, 0xc390,
	0xc3c8, 0xc413, 0xc446, 0xc473, 0xc491, 0xc4b6, 0xc4ee, 0xc52c,
	0xc559, 0xc576, 0xc59d, 0xc5c2, 0xc5fc, 0xc62c, 0xc651, 0xc689,
	0xc6ab, 0xc6d4, 0xc70e, 0xc72f, 0xc750, 0xc776, 0xc797, 0xc7b6,
	// Entry 700 - 73F
	0xc7d0, 0xc800, 0xc822, 0xc853, 0xc887, 0xc8c2, 0xc8fe, 0xc939,
	0xc96d, 0xc9aa, 0xc9e9, 0xca2b, 0xca6f, 0xcab2, 0xcaee, 0xcb2c,
	0xcb6f, 0xcbb4, 0xcbf1, 0xcc2f, 0xcc51, 0xcc76, 0xcc87, 0xcc9e,
	0xccb1, 0xccc2, 0xccd3, 0xccea, 0xccfd, 0xcd10, 0xcd23, 0xcd36,
	0xcd49, 0xcd5d, 0xcd6f, 0xcd82, 0xcd95, 0xcdac, 0xcdbf, 0xcdd5,
	0xcdeb, 0xce01, 0xce12, 0xce28, 0xce3e, 0xce55, 0xce67, 0xce79,
	0xce8b, 0xce9f, 0xceb0, 0xcec4, 0xced8, 0xceec, 0xcefc, 0xcf0c,
	0xcf1e, 0xcf32, 0xcf45, 0xcf58, 0xcf66, 0xcf76, 0xcf84, 0xcf94,
	// Entry 740 - 77F
	0xcfa2, 0xcfb2, 0xcfc0, 0xcfd0, 0xcfde, 0xcfee, 0xcffa, 0xd00b,
	0xd019, 0xd026, 0xd033, 0xd042, 0xd050, 0xd05e, 0xd06b, 0xd07a,
	0xd089, 0xd097, 0xd0a3, 0xd0b0, 0xd0bc, 0xd0c8, 0xd0d4, 0xd0e1,
	0xd0ed, 0xd102, 0xd10e, 0xd11b, 0xd128, 0xd135, 0xd142, 0xd150,
	0xd15d, 0xd16a, 0xd178, 0xd185, 0xd193, 0xd1a0, 0xd1ad, 0xd1ba,
	0xd1ce, 0xd1db, 0xd1e9, 0xd1f6, 0xd203, 0xd210, 0xd21d, 0xd232,
	0xd244, 0xd257, 0xd269, 0xd286, 0xd2a2, 0xd2c1, 0xd2e3, 0xd2ff,
	0xd31a, 0xd338, 0xd357, 0xd375, 0xd38d, 0xd3a4, 0xd3b8, 0xd3cd,
	// Entry 780 - 7BF
	0xd3d6, 0xd3ea, 0xd3f8, 0xd406, 0xd415, 0xd423, 0xd438, 0xd44c,
	0xd462, 0xd478, 0xd48b, 0xd49f, 0xd4b3, 0xd4c6, 0xd4da, 0xd4ee,
	0xd503, 0xd519, 0xd52d, 0xd541, 0xd559, 0xd56c, 0xd57f, 0xd597,
	0xd5ab, 0xd5c0, 0xd5d5, 0xd5ea, 0xd5fb, 0xd611, 0xd629, 0xd63e,
	0xd666, 0xd683, 0xd69e, 0xd6b4, 0xd6d4, 0xd6f0, 0xd707, 0xd726,
	0xd741, 0xd757, 0xd778, 0xd794, 0xd7af, 0xd7c5, 0xd7e0, 0xd7fb,
	0xd811, 0xd827, 0xd841, 0xd857, 0xd874, 0xd890, 0xd8ab, 0xd8c4,
	0xd8e0, 0xd900, 0xd91b, 0xd93e, 0xd959, 0xd974, 0xd98e, 0xd9a8,
	// Entry 7C0 - 7FF
	0xd9c5, 0xd9e7, 0xda03, 0xda17, 0xda28, 0xda39, 0xda4a, 0xda5b,
	0xda71, 0xda82, 0xda93, 0xdaa5, 0xdab8, 0xdac9, 0xdada, 0xdaeb,
	0xdafc, 0xdb0d, 0xdb1e, 0xdb2f, 0xdb41, 0xdb52, 0xdb63, 0xdb75,
	0xdb86, 0xdb9d, 0xdbaf, 0xdbc1, 0xdbd9, 0xdbf2, 0xdc09, 0xdc1c,
	0xdc37, 0xdc51, 0xdc6c, 0xdc87, 0xdca2, 0xdcbe, 0xdcd9, 0xdcf3,
	0xdd0e, 0xdd2a, 0xdd45, 0xdd69, 0xdd8b, 0xddb1, 0xddd6, 0xde0b,
	0xde2b, 0xde4c, 0xde74, 0xdea9, 0xdedc, 0xdef7, 0xdf18, 0xdf32,
	0xdf48, 0xdf6f, 0xdf96, 0xdfbc, 0xdfd6, 0xdffe, 0xe025, 0xe045,
	// Entry 800 - 83F
	0xe06c, 0xe093, 0xe0b9, 0xe0e0, 0xe11a, 0xe133, 0xe14c, 0xe166,
	0xe184, 0xe1a2, 0xe1c1, 0xe1e1, 0xe201, 0xe22a, 0xe259, 0xe281,
	0xe2a9, 0xe2dd, 0xe2f1, 0xe30e, 0xe323, 0xe338, 0xe34d, 0xe36e,
	0xe38e, 0xe3b1, 0xe3d0, 0xe3ee, 0xe40a, 0xe424, 0xe440, 0xe461,
	0xe47d, 0xe498, 0xe4b1, 0xe4c3, 0xe4d5, 0xe4e7, 0xe4fc, 0xe511,
	0xe526, 0xe53f, 0xe559, 0xe56f, 0xe588, 0xe5a2, 0xe5b8, 0xe5cc,
	0xe5e0, 0xe5f4, 0xe609, 0xe61f, 0xe63a, 0xe655, 0xe670, 0xe68c,
	0xe6a7, 0xe6c3, 0xe6e6, 0xe712, 0xe737, 0xe74c, 0xe76c, 0xe790,
	// Entry 840 - 87F
	0xe7ab, 0xe7c3, 0xe7da, 0xe7f3, 0xe806, 0xe81a, 0xe82d, 0xe841,
	0xe854, 0xe868, 0xe883, 0xe89e, 0xe8b8, 0xe8d1, 0xe8e4, 0xe8f8,
	0xe912, 0xe92b, 0xe93e, 0xe952, 0xe966, 0xe97b, 0xe98f, 0xe9a4,
	0xe9b9, 0xe9cd, 0xe9e2, 0xe9f6, 0xea0b, 0xea20, 0xea35, 0xea4b,
	0xea60, 0xea76, 0xea8b, 0xea9f, 0xeab4, 0xeac8, 0xeadd, 0xeaf1,
	0xeb07, 0xeb1b, 0xeb30, 0xeb44, 0xeb59, 0xeb6d, 0xeb81, 0xeb95,
	0xebaa, 0xebbe, 0xebd3, 0xebe9, 0xebfd, 0xec12, 0xec27, 0xec3b,
	0xec4f, 0xec67, 0xec80, 0xec95, 0xecad, 0xecc5, 0xecdc, 0xecf4,
	// Entry 880 - 8BF
	0xed0b, 0xed23, 0xed42, 0xed62, 0xed80, 0xed9d, 0xedb4, 0xedcc,
	0xedea, 0xee07, 0xee1e, 0xee36, 0xee4c, 0xee71, 0xee89, 0xee96,
	0xeeb3, 0xeed2, 0xeee9, 0xef00, 0xef23, 0xef3b, 0xef54, 0xef68,
	0xef7e, 0xef94, 0xefa8, 0xefbf, 0xefd4, 0xefe8, 0xeffd, 0xf019,
	0xf035, 0xf054, 0xf074, 0xf084, 0xf09b, 0xf0b0, 0xf0c4, 0xf0d8,
	0xf0ee, 0xf103, 0xf118, 0xf12c, 0xf142, 0xf158, 0xf16d, 0xf189,
	0xf1a9, 0xf1c3, 0xf1d7, 0xf1ec, 0xf200, 0xf214, 0xf229, 0xf246,
	0xf25b, 0xf275, 0xf28a, 0xf29f, 0xf2bd, 0xf2d3, 0xf2e8, 0xf2f4,
	// Entry 8C0 - 8FF
	0xf30c, 0xf321, 0xf335, 0xf345, 0xf356, 0xf366, 0xf377, 0xf387,
	0xf398, 0xf3b0, 0xf3c8, 0xf3d8, 0xf3e9, 0xf3f9, 0xf40a, 0xf41b,
	0xf42d, 0xf43e, 0xf450, 0xf462, 0xf473, 0xf485, 0xf496, 0xf4a8,
	0xf4ba, 0xf4cc, 0xf4df, 0xf4f1, 0xf504, 0xf516, 0xf527, 0xf539,
	0xf54a, 0xf55c, 0xf56d, 0xf57e, 0xf590, 0xf5a1, 0xf5b3, 0xf5c4,
	0xf5d5, 0xf5e6, 0xf5f7, 0xf609, 0xf61b, 0xf62c, 0xf63d, 0xf64f,
	0xf664, 0xf679, 0xf68d, 0xf6a2, 0xf6b6, 0xf6cb, 0xf6e7, 0xf704,
	0xf718, 0xf72d, 0xf741, 0xf756, 0xf769, 0xf781, 0xf797, 0xf7a9,
	// Entry 900 - 93F
	0xf7bb, 0xf7cd, 0xf7e6, 0xf7ff, 0xf81b, 0xf838, 0xf84a, 0xf85b,
	0xf86c, 0xf87f, 0xf891, 0xf8a3, 0xf8b4, 0xf8c7, 0xf8da, 0xf8ec,
	0xf912, 0xf937, 0xf949, 0xf95b, 0xf979, 0xf997, 0xf9b7, 0xf9d6,
	0xfa0e, 0xfa32, 0xfa40, 0xfa52, 0xfa6f, 0xfa88, 0xfa9b, 0xfab3,
	0xfac6, 0xfadb, 0xfaec, 0xfafe, 0xfb0f, 0xfb21, 0xfb32, 0xfb44,
	0xfb56, 0xfb68, 0xfb7a, 0xfb8c, 0xfb9e, 0xfbb1, 0xfbc3, 0xfbd6,
	0xfbe9, 0xfbfb, 0xfc0e, 0xfc20, 0xfc33, 0xfc46, 0xfc59, 0xfc6d,
	0xfc80, 0xfc94, 0xfca7, 0xfcb9, 0xfccc, 0xfcde, 0xfcf1, 0xfd03,
	// Entry 940 - 97F
	0xfd15, 0xfd28, 0xfd3a, 0xfd4d, 0xfd5f, 0xfd71, 0xfd83, 0xfd95,
	0xfda8, 0xfdba, 0xfdcd, 0xfddf, 0xfdf1, 0xfe04, 0xfe1a, 0xfe2f,
	0xfe45, 0xfe5a, 0xfe70, 0xfe86, 0xfe9c, 0xfeb2, 0xfec8, 0xfedc,
	0xfeef, 0xff03, 0xff17, 0xff29, 0xff3c, 0xff4e, 0xff61, 0xff73,
	0xff85, 0xff99, 0xffac, 0xffbf, 0xffd1, 0xffe5, 0xfff9, 0x000c,
	0x001a, 0x0028, 0x0034, 0x0040, 0x0051, 0x0065, 0x007f, 0x0098,
	0x00ae, 0x00c3, 0x00d4, 0x00e6, 0x00f7, 0x0109, 0x011a, 0x012c,
	0x0145, 0x015e, 0x0175, 0x0186, 0x0198, 0x01af, 0x01c0, 0x01d2,
	// Entry 980 - 9BF
	0x01e4, 0x01f7, 0x0209, 0x021c, 0x022f, 0x0241, 0x0254, 0x0266,
	0x0279, 0x028c, 0x029f, 0x02b3, 0x02c6, 0x02da, 0x02ed, 0x02ff,
	0x0312, 0x0324, 0x0337, 0x0349, 0x035b, 0x036e, 0x0380, 0x0393,
	0x03a5, 0x03b7, 0x03c9, 0x03db, 0x03ee, 0x0400, 0x0413, 0x0426,
	0x0438, 0x044a, 0x045d, 0x0473, 0x0489, 0x049e, 0x04b4, 0x04c9,
	0x04df, 0x04fc, 0x051a, 0x0536, 0x054b, 0x0561, 0x057d, 0x0592,
	0x05a8, 0x05bc, 0x05c7, 0x05e1, 0x05fb, 0x0618, 0x0636, 0x0649,
	0x065b, 0x066d, 0x0681, 0x0694, 0x06a7, 0x06b9, 0x06cd, 0x06e1,
	// Entry 9C0 - 9FF
	0x06f4, 0x070e, 0x0721, 0x0734, 0x0747, 0x075b, 0x076f, 0x0792,
	0x07b2, 0x07d6, 0x07ec, 0x07ff, 0x0811, 0x081f, 0x082e, 0x083c,
	0x084b, 0x0859, 0x0868, 0x087e, 0x0894, 0x08a2, 0x08b1, 0x08bf,
	0x08ce, 0x08dd, 0x08ed, 0x08fc, 0x090c, 0x091c, 0x092b, 0x093b,
	0x094a, 0x095a, 0x096a, 0x097a, 0x098b, 0x099b, 0x09ac, 0x09bc,
	0x09cb, 0x09db, 0x09ea, 0x09fa, 0x0a09, 0x0a18, 0x0a28, 0x0a37,
	0x0a47, 0x0a56, 0x0a65, 0x0a74, 0x0a83, 0x0a93, 0x0aa2, 0x0ab2,
	0x0ac2, 0x0ad1, 0x0ae0, 0x0af0, 0x0b03, 0x0b16, 0x0b28, 0x0b3b,
	// Entry A00 - A3F
	0x0b4d, 0x0b60, 0x0b7a, 0x0b95, 0x0ba7, 0x0bba, 0x0bcc, 0x0bdf,
	0x0bf0, 0x0c03, 0x0c17, 0x0c2b, 0x0c3b, 0x0c4b, 0x0c5b, 0x0c72,
	0x0c89, 0x0ca3, 0x0cbe, 0x0cce, 0x0cdd, 0x0cec, 0x0cfd, 0x0d0d,
	0x0d1d, 0x0d2c, 0x0d3d, 0x0d4e, 0x0d5e, 0x0d6a, 0x0d79, 0x0d93,
	0x0daa, 0x0dc7, 0x0de3, 0x0dfc, 0x0e1b, 0x0e2e, 0x0e40, 0x0e4e,
	0x0e5d, 0x0e6b, 0x0e7a, 0x0e88, 0x0e97, 0x0ea5, 0x0eb4, 0x0ec3,
	0x0ed1, 0x0ee0, 0x0eef, 0x0efe, 0x0f0e, 0x0f1d, 0x0f2c, 0x0f3c,
	0x0f4c, 0x0f5c, 0x0f6b, 0x0f7a, 0x0f8b, 0x0f9a, 0x0fa9, 0x0fb8,
	// Entry A40 - A7F
	0x0fc7, 0x0fd7, 0x0fe6, 0x0ff6, 0x1007, 0x1016, 0x1026, 0x1036,
	0x1045, 0x1054, 0x1067, 0x1079, 0x108c, 0x109e, 0x10b1, 0x10c3,
	0x10d6, 0x10e9, 0x10fb, 0x110e, 0x1121, 0x1132, 0x113a, 0x114e,
	0x115e, 0x116d, 0x117c, 0x118d, 0x119d, 0x11ad, 0x11bc, 0x11cd,
	0x11de, 0x11ee, 0x11fe, 0x1216, 0x122f, 0x123d, 0x124d, 0x125c,
	0x126c, 0x127d, 0x1290, 0x12a0, 0x12b1, 0x12d8, 0x12ef, 0x1303,
	0x1316, 0x133a, 0x1349, 0x1359, 0x1368, 0x1378, 0x1387, 0x1397,
	0x13ae, 0x13c5, 0x13d4, 0x13e4, 0x13f4, 0x1403, 0x1413, 0x1423,
	// Entry A80 - ABF
	0x1433, 0x1444, 0x1454, 0x1465, 0x1476, 0x1486, 0x1497, 0x14a7,
	0x14b8, 0x14c9, 0x14da, 0x14ec, 0x14fd, 0x150f, 0x1520, 0x1530,
	0x1541, 0x1551, 0x1562, 0x1572, 0x1582, 0x1593, 0x15a3, 0x15b4,
	0x15c4, 0x15d4, 0x15e4, 0x15f5, 0x1605, 0x1616, 0x1628, 0x1638,
	0x1649, 0x165a, 0x166a, 0x167a, 0x168e, 0x16a2, 0x16b5, 0x16c9,
	0x16dc, 0x16f0, 0x170b, 0x1727, 0x173a, 0x174e, 0x1762, 0x1775,
	0x1789, 0x179d, 0x17af, 0x17c1, 0x17d6, 0x17e7, 0x17f8, 0x180a,
	0x1822, 0x183a, 0x1855, 0x1871, 0x1882, 0x1892, 0x18a2, 0x18b4,
	// Entry AC0 - AFF
	0x18c5, 0x18d6, 0x18e6, 0x18f8, 0x190a, 0x191b, 0x192e, 0x195f,
	0x198f, 0x19bf, 0x19f1, 0x1a22, 0x1a53, 0x1a86, 0x1a97, 0x1ab7,
	0x1acf, 0x1ae4, 0x1af8, 0x1b0c, 0x1b1c, 0x1b2d, 0x1b3d, 0x1b4e,
	0x1b5e, 0x1b6f, 0x1b87, 0x1b9f, 0x1baf, 0x1bc0, 0x1bd1, 0x1be1,
	0x1bf2, 0x1c03, 0x1c14, 0x1c26, 0x1c37, 0x1c49, 0x1c5b, 0x1c6c,
	0x1c7e, 0x1c8f, 0x1ca1, 0x1cb3, 0x1cc5, 0x1cd8, 0x1cea, 0x1cfd,
	0x1d0f, 0x1d20, 0x1d32, 0x1d43, 0x1d55, 0x1d66, 0x1d77, 0x1d89,
	0x1d9a, 0x1dac, 0x1dbd, 0x1dce, 0x1ddf, 0x1df1, 0x1e02, 0x1e14,
	// Entry B00 - B3F
	0x1e25, 0x1e37, 0x1e49, 0x1e5a, 0x1e6b, 0x1e7d, 0x1e92, 0x1ea7,
	0x1ebb, 0x1ed0, 0x1ee4, 0x1ef9, 0x1f15, 0x1f32, 0x1f46, 0x1f5b,
	0x1f70, 0x1f84, 0x1f99, 0x1fae, 0x1fc1, 0x1fd4, 0x1fea, 0x1ffb,
	0x2014, 0x202d, 0x2049, 0x2066, 0x2078, 0x2089, 0x209a, 0x20ad,
	0x20bf, 0x20d1, 0x20e2, 0x20f5, 0x2108, 0x211a, 0x2132, 0x214a,
	0x2171, 0x218b, 0x21a2, 0x21b8, 0x21d7, 0x21e9, 0x21fc, 0x220e,
	0x2221, 0x2233, 0x2246, 0x2260, 0x227a, 0x228c, 0x229f, 0x22b2,
	0x22c4, 0x22d7, 0x22ea, 0x22fd, 0x2311, 0x2324, 0x2338, 0x234c,
	// Entry B40 - B7F
	0x235f, 0x2373, 0x2386, 0x239a, 0x23ae, 0x23c2, 0x23d7, 0x23eb,
	0x2400, 0x2414, 0x2427, 0x243b, 0x244e, 0x2462, 0x2475, 0x248a,
	0x249d, 0x24b1, 0x24c4, 0x24d8, 0x24eb, 0x24fe, 0x2511, 0x2525,
	0x2538, 0x254c, 0x2561, 0x2574, 0x2588, 0x259c, 0x25af, 0x25c2,
	0x25d7, 0x25f9, 0x2617, 0x262e, 0x2645, 0x265b, 0x2672, 0x2688,
	0x269f, 0x26bd, 0x26dc, 0x26f2, 0x2709, 0x2720, 0x2736, 0x274d,
	0x2764, 0x2779, 0x2792, 0x27a5, 0x27be, 0x27d7, 0x27f2, 0x280a,
	0x2839, 0x2858, 0x287b, 0x289b, 0x28b7, 0x28da, 0x28f6, 0x2911,
	// Entry B80 - BBF
	0x292c, 0x2947, 0x2965, 0x2984, 0x2998, 0x29ab, 0x29be, 0x29d3,
	0x29e7, 0x29fb, 0x2a0e, 0x2a23, 0x2a38, 0x2a4c, 0x2a60, 0x2a7c,
	0x2a99, 0x2ab7, 0x2ad2, 0x2af3, 0x2b13, 0x2b30, 0x2b53, 0x2b66,
	0x2b80, 0x2b99, 0x2bb3, 0x2bcc, 0x2be6, 0x2bff, 0x2c17, 0x2c2e,
	0x2c44, 0x2c59, 0x2c6f, 0x2c85, 0x2c9c, 0x2cb1, 0x2cc7, 0x2cdc,
	0x2cf2, 0x2d09, 0x2d21, 0x2d38, 0x2d50, 0x2d65, 0x2d7b, 0x2d91,
	0x2da6, 0x2dbc, 0x2dd2, 0x2df3, 0x2e15, 0x2e36, 0x2e58, 0x2e79,
	0x2e97, 0x2eb8, 0x2eda, 0x2efb, 0x2f1d, 0x2f3e, 0x2f69, 0x2f87,
	// Entry BC0 - BFF
	0x2fa9, 0x2fcc, 0x2fee, 0x3011, 0x3031, 0x3050, 0x3071, 0x3093,
	0x30b4, 0x30d6, 0x30f4, 0x3112, 0x3133, 0x3155, 0x3176, 0x3198,
	0x31ae, 0x31c9, 0x31df, 0x31f5, 0x3213, 0x3229, 0x3247, 0x3267,
	0x3285, 0x329b, 0x32bb, 0x32d1, 0x32e7, 0x3304, 0x3327, 0x3349,
	0x336a, 0x338a, 0x33ac, 0x33cd, 0x33ec, 0x3406, 0x3425, 0x3442,
	0x346b, 0x3499, 0x34c3, 0x34e1, 0x34f8, 0x350e, 0x3524, 0x353c,
	0x3553, 0x356a, 0x3580, 0x3598, 0x35b0, 0x35c7, 0x35eb, 0x360e,
	0x362c, 0x3641, 0x3658, 0x3670, 0x3688, 0x369f, 0x36b9, 0x36cf,
	// Entry C00 - C3F
	0x36e6, 0x36fe, 0x3716, 0x372a, 0x3741, 0x3757, 0x376e, 0x3785,
	0x379c, 0x37b9, 0x37d3, 0x37e8, 0x37fd, 0x3812, 0x382a, 0x3843,
	0x385b, 0x386f, 0x3887, 0x389c, 0x38b4, 0x38c8, 0x38df, 0x38f4,
	0x390e, 0x3922, 0x3937, 0x394c, 0x395d, 0x3973, 0x3984, 0x399a,
	0x39b0, 0x39c6, 0x39db, 0x39f0, 0x3a07, 0x3a1b, 0x3a33, 0x3a4b,
	0x3a60, 0x3a7b, 0x3a91, 0x3aa7, 0x3abc, 0x3ad2, 0x3ae8, 0x3aff,
	0x3b14, 0x3b2a, 0x3b40, 0x3b59, 0x3b6e, 0x3b84, 0x3b99, 0x3bb7,
	0x3bd6, 0x3bf0, 0x3c07, 0x3c1f, 0x3c34, 0x3c4a, 0x3c60, 0x3c7b,
	// Entry C40 - C7F
	0x3c95, 0x3cac, 0x3cc3, 0x3cd9, 0x3ce8, 0x3cf6, 0x3d04, 0x3d14,
	0x3d23, 0x3d32, 0x3d40, 0x3d50, 0x3d60, 0x3d6f, 0x3d88, 0x3d9d,
	0x3daa, 0x3dbd, 0x3dcf, 0x3de2, 0x3df0, 0x3dfd, 0x3e10, 0x3e21,
	0x3e34, 0x3e42, 0x3e55, 0x3e68, 0x3e7c, 0x3e8f, 0x3ea3, 0x3eb6,
	0x3ec3, 0x3ed0, 0x3ee3, 0x3ef5, 0x3f08, 0x3f15, 0x3f22, 0x3f2f,
	0x3f42, 0x3f53, 0x3f65, 0x3f77, 0x3f8a, 0x3f97, 0x3fa4, 0x3fb6,
	0x3fc8, 0x3fd5, 0x3fec, 0x4003, 0x4015, 0x4027, 0x403a, 0x4046,
	0x4057, 0x4063, 0x4073, 0x4089, 0x409a, 0x40ab, 0x40bb, 0x40cc,
	// Entry C80 - CBF
	0x40dc, 0x40ed, 0x40fd, 0x410e, 0x4122, 0x4138, 0x414d, 0x4163,
	0x4173, 0x4184, 0x4194, 0x41a5, 0x41b6, 0x41bf, 0x41ce, 0x41de,
	0x41ed, 0x4200, 0x4215, 0x4222, 0x4230, 0x423d, 0x424a, 0x4259,
	0x4267, 0x4275, 0x4282, 0x4291, 0x42a0, 0x42ae, 0x42b7, 0x42c0,
	0x42d2, 0x42e5, 0x42f8, 0x431d, 0x4347, 0x4372, 0x4396, 0x43ba,
	0x43e1, 0x4403, 0x441a, 0x4434, 0x4452, 0x4472, 0x4494, 0x44a5,
	0x44bb, 0x44d2, 0x44ee, 0x450f, 0x452a, 0x4554, 0x456b, 0x458b,
	0x45ab, 0x45da, 0x45fd, 0x4623, 0x463e, 0x465a, 0x4675, 0x468f,
	// Entry CC0 - CFF
	0x46aa, 0x46c9, 0x46db, 0x46ec, 0x46fd, 0x4710, 0x4722, 0x4734,
	0x4745, 0x4758, 0x476b, 0x477d, 0x4793, 0x47a9, 0x47c1, 0x47d8,
	0x47ef, 0x4805, 0x481d, 0x4835, 0x484c, 0x4863, 0x487b, 0x489a,
	0x48c5, 0x48e7, 0x48fb, 0x4911, 0x492c, 0x4947, 0x4962, 0x497d,
	0x4993, 0x49a9, 0x49ba, 0x49cc, 0x49dd, 0x49ef, 0x4a01, 0x4a12,
	0x4a24, 0x4a35, 0x4a47, 0x4a59, 0x4a6c, 0x4a7e, 0x4a91, 0x4aa3,
	0x4ab4, 0x4ac6, 0x4ad7, 0x4ae9, 0x4afa, 0x4b0b, 0x4b1d, 0x4b2e,
	0x4b40, 0x4b51, 0x4b63, 0x4b76, 0x4b88, 0x4b9b, 0x4bac, 0x4bbe,
	// Entry D00 - D3F
	0x4bcf, 0x4be0, 0x4bf1, 0x4c02, 0x4c13, 0x4c25, 0x4c37, 0x4c48,
	0x4c59, 0x4c69, 0x4c7c, 0x4c98, 0x4caa, 0x4cbc, 0x4cd1, 0x4ce5,
	0x4cfa, 0x4d0e, 0x4d23, 0x4d3f, 0x4d5c, 0x4d78, 0x4d95, 0x4da9,
	0x4dbe, 0x4dd2, 0x4de7, 0x4e02, 0x4e18, 0x4e35, 0x4e53, 0x4e6e,
	0x4e83, 0x4e97, 0x4eaa, 0x4ec0, 0x4ed7, 0x4eef, 0x4f04, 0x4f20,
	0x4f3c, 0x4f5a, 0x4f7c, 0x4f9b, 0x4fc3, 0x4fde, 0x4ffa, 0x5015,
	0x5031, 0x504d, 0x5068, 0x5084, 0x509f, 0x50bb, 0x50d7, 0x50f4,
	0x5110, 0x512d, 0x5149, 0x5164, 0x5180, 0x519b, 0x51b7, 0x51d2,
	// Entry D40 - D7F
	0x51ed, 0x5209, 0x5224, 0x5240, 0x525b, 0x5277, 0x5294, 0x52b0,
	0x52cd, 0x52e8, 0x5304, 0x531f, 0x533a, 0x5355, 0x5370, 0x538b,
	0x53a7, 0x53c3, 0x53de, 0x53f9, 0x5413, 0x5430, 0x5456, 0x547c,
	0x54a2, 0x54b3, 0x54d1, 0x54f5, 0x5519, 0x553c, 0x5560, 0x5576,
	0x558c, 0x55a5, 0x55c5, 0x55db, 0x55f0, 0x5611, 0x5632, 0x5653,
	0x5672, 0x568c, 0x56b0, 0x56d3, 0x56ea, 0x571a, 0x574a, 0x5762,
	0x5779, 0x579b, 0x57bc, 0x57dc, 0x57fd, 0x580e, 0x5820, 0x5831,
	0x5843, 0x5855, 0x5866, 0x5878, 0x5889, 0x589b, 0x58ad, 0x58c0,
	// Entry D80 - DBF
	0x58d2, 0x58e5, 0x58f7, 0x590a, 0x591c, 0x592d, 0x593f, 0x5950,
	0x5962, 0x5973, 0x5984, 0x5996, 0x59a7, 0x59b9, 0x59ca, 0x59db,
	0x59ec, 0x59fd, 0x5a0e, 0x5a1f, 0x5a30, 0x5a42, 0x5a52, 0x5a67,
	0x5a77, 0x5a88, 0x5a98, 0x5aa9, 0x5ab9, 0x5acd, 0x5add, 0x5aee,
	0x5b08, 0x5b1d, 0x5b31, 0x5b46, 0x5b5a, 0x5b6f, 0x5b83, 0x5b98,
	0x5bb1, 0x5bc9, 0x5be3, 0x5bf8, 0x5c0e, 0x5c22, 0x5c35, 0x5c46,
	0x5c66, 0x5c86, 0x5ca6, 0x5cc6, 0x5cdd, 0x5cef, 0x5d00, 0x5d11,
	0x5d24, 0x5d36, 0x5d48, 0x5d59, 0x5d6c, 0x5d7f, 0x5d91, 0x5dac,
	// Entry DC0 - DFF
	0x5dc0, 0x5dd7, 0x5def, 0x5e0c, 0x5e23, 0x5e35, 0x5e47, 0x5e5f,
	0x5e78, 0x5e90, 0x5ea9, 0x5ec5, 0x5ee2, 0x5efe, 0x5f1b, 0x5f31,
	0x5f47, 0x5f5d, 0x5f73, 0x5f97, 0x5fbb, 0x5fdf, 0x5ffc, 0x601c,
	0x603e, 0x6061, 0x6085, 0x60a9, 0x60d0, 0x60f7, 0x611c, 0x6141,
	0x6166, 0x618b, 0x61b0, 0x61d4, 0x61f8, 0x621d, 0x623c, 0x6257,
	0x6271, 0x628c, 0x62a2, 0x62b9, 0x62cf, 0x62e5, 0x62fb, 0x6312,
	0x6328, 0x633e, 0x6355, 0x636b, 0x6381, 0x6398, 0x63ae, 0x63d3,
	0x63ed, 0x6406, 0x6425, 0x6444, 0x645c, 0x6474, 0x648c, 0x64a4,
	// Entry E00 - E3F
	0x64c4, 0x64e4, 0x650b, 0x652a, 0x654b, 0x6562, 0x6578, 0x658e,
	0x65a6, 0x65bd, 0x65d4, 0x65ea, 0x6602, 0x661a, 0x6631, 0x664b,
	0x6665, 0x667f, 0x669a, 0x66b1, 0x66d0, 0x66ea, 0x6705, 0x6720,
	0x673b, 0x6755, 0x6770, 0x678b, 0x67a6, 0x67c0, 0x67db, 0x67f6,
	0x6811, 0x682c, 0x6846, 0x6861, 0x687d, 0x6898, 0x68b3, 0x68ce,
	0x68e8, 0x6904, 0x6920, 0x693c, 0x6957, 0x6973, 0x698f, 0x69aa,
	0x69c5, 0x69e0, 0x69fc, 0x6a17, 0x6a33, 0x6a4e, 0x6a68, 0x6a83,
	0x6a9d, 0x6ab8, 0x6ad3, 0x6aed, 0x6b08, 0x6b1a, 0x6b2d, 0x6b40,
	// Entry E40 - E7F
	0x6b53, 0x6b65, 0x6b78, 0x6b8b, 0x6b9e, 0x6bb0, 0x6bc3, 0x6bd6,
	0x6be9, 0x6bfc, 0x6c0e, 0x6c21, 0x6c35, 0x6c48, 0x6c5b, 0x6c6e,
	0x6c80, 0x6c94, 0x6ca8, 0x6cbc, 0x6ccf, 0x6ce3, 0x6cf7, 0x6d0a,
	0x6d1d, 0x6d30, 0x6d44, 0x6d57, 0x6d6b, 0x6d7e, 0x6d90, 0x6da3,
	0x6db5, 0x6dc8, 0x6ddb, 0x6ded, 0x6dff, 0x6e14, 0x6e2e, 0x6e41,
	0x6e5d, 0x6e79, 0x6e8c, 0x6ea5, 0x6ec0, 0x6ed6, 0x6ef1, 0x6f06,
	0x6f1c, 0x6f37, 0x6f4c, 0x6f61, 0x6f76, 0x6f90, 0x6fa4, 0x6fbd,
	0x6fd2, 0x6fe7, 0x7001, 0x7018, 0x702f, 0x7046, 0x705d, 0x7072,
	// Entry E80 - EBF
	0x708e, 0x70a8, 0x70c4, 0x70df, 0x70fc, 0x7117, 0x7131, 0x714c,
	0x7169, 0x7184, 0x71a1, 0x71bd, 0x71d8, 0x71f4, 0x720e, 0x722f,
	0x7250, 0x7270, 0x728f, 0x72af, 0x72ca, 0x72e7, 0x7304, 0x7321,
	0x733e, 0x7360, 0x737b, 0x7395, 0x73b0, 0x73ca, 0x73e4, 0x73fe,
	0x741f, 0x743d, 0x7457, 0x7471, 0x748d, 0x74a9, 0x74c5, 0x74e1,
	0x74fb, 0x7517, 0x7538, 0x7557, 0x757b, 0x7592, 0x75ae, 0x75ca,
	0x75e5, 0x7600, 0x761a, 0x7637, 0x7651, 0x766c, 0x7689, 0x76a6,
	0x76c3, 0x76db, 0x76f6, 0x7713, 0x7735, 0x7755, 0x777a, 0x7799,
	// Entry EC0 - EFF
	0x77b6, 0x77d5, 0x77f7, 0x7814, 0x7833, 0x784d, 0x7868, 0x7885,
	0x789f, 0x78ba, 0x78d5, 0x78f1, 0x7907, 0x791e, 0x7930, 0x7943,
	0x7956, 0x796a, 0x797d, 0x798f, 0x79a3, 0x79b6, 0x79c8, 0x79db,
	0x79ef, 0x7a02, 0x7a15, 0x7a27, 0x7a3b, 0x7a4e, 0x7a61, 0x7a74,
	0x7a87, 0x7a9a, 0x7aac, 0x7ac0, 0x7ad4, 0x7ae9, 0x7aff, 0x7b14,
	0x7b29, 0x7b3f, 0x7b55, 0x7b6b, 0x7b80, 0x7b94, 0x7ba9, 0x7bbd,
	0x7bd1, 0x7be7, 0x7bfe, 0x7c15, 0x7c2a, 0x7c3f, 0x7c53, 0x7c68,
	0x7c80, 0x7c95, 0x7ca9, 0x7cbe, 0x7cd4, 0x7ce9, 0x7d00, 0x7d16,
	// Entry F00 - F3F
	0x7d2b, 0x7d40, 0x7d55, 0x7d6b, 0x7d80, 0x7d94, 0x7da9, 0x7dbd,
	0x7dd1, 0x7de6, 0x7dfe, 0x7e14, 0x7e2d, 0x7e45, 0x7e5d, 0x7e78,
	0x7e8d, 0x7ea2, 0x7eb9, 0x7ece, 0x7ee4, 0x7efb, 0x7f17, 0x7f33,
	0x7f49, 0x7f65, 0x7f81, 0x7f98, 0x7fae, 0x7fcb, 0x7fe7, 0x8003,
	0x801e, 0x803c, 0x805a, 0x8076, 0x808c, 0x80a2, 0x80bd, 0x80d2,
	0x80ec, 0x8102, 0x8118, 0x8130, 0x8148, 0x8160, 0x8178, 0x818e,
	0x81ab, 0x81ce, 0x81eb, 0x8208, 0x8223, 0x8241, 0x825f, 0x827d,
	0x829a, 0x82bc, 0x82d8, 0x82f5, 0x8318, 0x8333, 0x8356, 0x8377,
	// Entry F40 - F7F
	0x8398, 0x83ba, 0x83de, 0x83fe, 0x841c, 0x843a, 0x845c, 0x8479,
	0x8495, 0x84b1, 0x84cc, 0x84ec, 0x850a, 0x8528, 0x8544, 0x8562,
	0x857e, 0x859c, 0x85b8, 0x85d6, 0x85f2, 0x860e, 0x8629, 0x8644,
	0x865c, 0x8679, 0x869b, 0x86b6, 0x86d4, 0x86ed, 0x870b, 0x872c,
	0x874a, 0x876a, 0x8786, 0x87a2, 0x87be, 0x87da, 0x87f6, 0x8813,
	0x8830, 0x884f, 0x886e, 0x888b, 0x88a6, 0x88ba, 0x88ce, 0x88e2,
	0x88f7, 0x890c, 0x8920, 0x8934, 0x8949, 0x895d, 0x8971, 0x8985,
	0x899a, 0x89af, 0x89c3, 0x89d7, 0x89ec, 0x8a01, 0x8a16, 0x8a2b,
	// Entry F80 - FBF
	0x8a41, 0x8a57, 0x8a6c, 0x8a81, 0x8a97, 0x8aab, 0x8abf, 0x8ad3,
	0x8ae8, 0x8afd, 0x8b11, 0x8b25, 0x8b3a, 0x8b4f, 0x8b64, 0x8b79,
	0x8b8f, 0x8ba5, 0x8bba, 0x8bcf, 0x8be5, 0x8bf9, 0x8c0d, 0x8c21,
	0x8c36, 0x8c4b, 0x8c5f, 0x8c73, 0x8c88, 0x8c9c, 0x8cb0, 0x8cc4,
	0x8cd9, 0x8cee, 0x8d02, 0x8d16, 0x8d2b, 0x8d40, 0x8d55, 0x8d6a,
	0x8d80, 0x8d96, 0x8dab, 0x8dc0, 0x8dd6, 0x8dea, 0x8dfe, 0x8e12,
	0x8e27, 0x8e3c, 0x8e50, 0x8e64, 0x8e79, 0x8e8e, 0x8ea3, 0x8eb9,
	0x8ecf, 0x8ee4, 0x8ef9, 0x8f0e, 0x8f23, 0x8f39, 0x8f4f, 0x8f64,
	// Entry FC0 - FFF
	0x8f79, 0x8f8f, 0x8fa5, 0x8fbc, 0x8fd3, 0x8fe9, 0x8ffd, 0x9011,
	0x9025, 0x903a, 0x904f, 0x9063, 0x9077, 0x908c, 0x90a0, 0x90b4,
	0x90c8, 0x90dd, 0x90f2, 0x9106, 0x911a, 0x912f, 0x9143, 0x9157,
	0x916b, 0x9180, 0x9195, 0x91a9, 0x91bd, 0x91d2, 0x91e6, 0x91fa,
	0x920e, 0x9223, 0x9238, 0x924c, 0x9260, 0x9275, 0x9289, 0x929d,
	0x92b1, 0x92c6, 0x92db, 0x92ef, 0x9303, 0x9318, 0x932d, 0x9342,
	0x9358, 0x936e, 0x9383, 0x9397, 0x93ab, 0x93bf, 0x93d4, 0x93e9,
	0x93fd, 0x9411, 0x9426, 0x943b, 0x9450, 0x9465, 0x947b, 0x9491,
	// Entry 1000 - 103F
	0x94a6, 0x94bb, 0x94d1, 0x94ec, 0x9507, 0x9522, 0x953e, 0x955a,
	0x9575, 0x9590, 0x95ac, 0x95c0, 0x95d4, 0x95e8, 0x95fd, 0x9612,
	0x9626, 0x963a, 0x964f, 0x9664, 0x9679, 0x968f, 0x96a5, 0x96ba,
	0x96cf, 0x96e4, 0x96f9, 0x970f, 0x9725, 0x973a, 0x974f, 0x9765,
	0x977b, 0x9792, 0x97a9, 0x97bf, 0x97d3, 0x97e7, 0x97fb, 0x9810,
	0x9825, 0x9839, 0x984d, 0x9862, 0x9880, 0x989e, 0x98bc, 0x98db,
	0x98fa, 0x9918, 0x9936, 0x994a, 0x995e, 0x9972, 0x9987, 0x999c,
	0x99b0, 0x99c4, 0x99d9, 0x99ee, 0x9a03, 0x9a18, 0x9a2e, 0x9a44,
	// Entry 1040 - 107F
	0x9a59, 0x9a6e, 0x9a84, 0x9a98, 0x9aac, 0x9ac0, 0x9ad5, 0x9aea,
	0x9afe, 0x9b12, 0x9b27, 0x9b3b, 0x9b4f, 0x9b63, 0x9b78, 0x9b8d,
	0x9ba1, 0x9bb5, 0x9bca, 0x9bdf, 0x9bf4, 0x9c09, 0x9c1f, 0x9c35,
	0x9c4a, 0x9c5f, 0x9c75, 0x9c89, 0x9c9d, 0x9cb1, 0x9cc6, 0x9cdb,
	0x9cef, 0x9d03, 0x9d18, 0x9d2c, 0x9d40, 0x9d54, 0x9d69, 0x9d7e,
	0x9d92, 0x9da6, 0x9dbb, 0x9dd0, 0x9de5, 0x9dfb, 0x9e11, 0x9e26,
	0x9e3b, 0x9e50, 0x9e65, 0x9e7b, 0x9e91, 0x9ea6, 0x9ebb, 0x9ed2,
	0x9ee7, 0x9efc, 0x9f11, 0x9f27, 0x9f3d, 0x9f52, 0x9f67, 0x9f7d,
	// Entry 1080 - 10BF
	0x9f92, 0x9fa7, 0x9fbc, 0x9fd2, 0x9fe8, 0x9ffd, 0xa012, 0xa028,
	0xa03d, 0xa052, 0xa067, 0xa07d, 0xa093, 0xa0a8, 0xa0bd, 0xa0d3,
	0xa0e8, 0xa0fd, 0xa112, 0xa128, 0xa13e, 0xa153, 0xa168, 0xa17e,
	0xa193, 0xa1a8, 0xa1bd, 0xa1d3, 0xa1e9, 0xa1fe, 0xa213, 0xa229,
	0xa23d, 0xa251, 0xa265, 0xa27a, 0xa28f, 0xa2a3, 0xa2b7, 0xa2cc,
	0xa2e0, 0xa2f4, 0xa308, 0xa31d, 0xa332, 0xa346, 0xa35a, 0xa36f,
	0xa384, 0xa399, 0xa3ae, 0xa3e1, 0xa405, 0xa427, 0xa43c, 0xa44e,
	0xa460, 0xa46e, 0xa480, 0xa48e, 0xa4a4, 0xa4ba, 0xa4d6, 0xa4e8,
	// Entry 10C0 - 10FF
	0xa4fa, 0xa50e, 0xa521, 0xa534, 0xa546, 0xa55a, 0xa56e, 0xa581,
	0xa594, 0xa5aa, 0xa5c0, 0xa5d5, 0xa5ea, 0xa5ff, 0xa616, 0xa62c,
	0xa642, 0xa659, 0xa675, 0xa694, 0xa6a9, 0xa6bf, 0xa6d4, 0xa6f3,
	0xa708, 0xa71e, 0xa733, 0xa752, 0xa767, 0xa77d, 0xa792, 0xa7b1,
	0xa7c6, 0xa7dc, 0xa7f1, 0xa80a, 0xa823, 0xa83d, 0xa85d, 0xa876,
	0xa88f, 0xa8a9, 0xa8c2, 0xa8e1, 0xa8f9, 0xa90a, 0xa91b, 0xa92c,
	0xa93d, 0xa94e, 0xa95f, 0xa971, 0xa983, 0xa995, 0xa9a7, 0xa9b9,
	0xa9cb, 0xa9dd, 0xa9ef, 0xaa01, 0xaa13, 0xaa25, 0xaa37, 0xaa49,
	// Entry 1100 - 113F
	0xaa5b, 0xaa6d, 0xaa7f, 0xaa91, 0xaaa3, 0xaab5, 0xaac7, 0xaad9,
	0xaaeb, 0xaafd, 0xab0f, 0xab21, 0xab34, 0xab47, 0xab59, 0xab6b,
	0xab7d, 0xab8f, 0xaba1, 0xabb4, 0xabc7, 0xabda, 0xabed, 0xac00,
	0xac13, 0xac25, 0xac36, 0xac48, 0xac5a, 0xac6c, 0xac7e, 0xac90,
	0xaca2, 0xacb4, 0xacc6, 0xacd8, 0xacea, 0xacfc, 0xad0e, 0xad20,
	0xad32, 0xad45, 0xad58, 0xad6b, 0xad7e, 0xad91, 0xada4, 0xadb7,
	0xadca, 0xaddd, 0xadf0, 0xae03, 0xae16, 0xae29, 0xae3b, 0xae4d,
	0xae5f, 0xae71, 0xae83, 0xae95, 0xaea7, 0xaeb9, 0xaecb, 0xaedd,
	// Entry 1140 - 117F
	0xaeef, 0xaf01, 0xaf13, 0xaf2b, 0xaf43, 0xaf5b, 0xaf73, 0xaf8b,
	0xafa3, 0xafbc, 0xafd0, 0xafe6, 0xaffa, 0xb00f, 0xb023, 0xb038,
	0xb054, 0xb071, 0xb08d, 0xb0a1, 0xb0b6, 0xb0cb, 0xb0ea, 0xb0ff,
	0xb11e, 0xb134, 0xb154, 0xb169, 0xb188, 0xb19e, 0xb1be, 0xb1dc,
	0xb1f1, 0xb210, 0xb226, 0xb246, 0xb264, 0xb279, 0xb294, 0xb2b3,
	0xb2d1, 0xb2ef, 0xb318, 0xb33e, 0xb366, 0xb383, 0xb3a8, 0xb3de,
	0xb401, 0xb431, 0xb44e, 0xb470, 0xb485, 0xb49a, 0xb4af, 0xb4c4,
	0xb4d9, 0xb4f0, 0xb505, 0xb51b, 0xb530, 0xb546, 0xb563, 0xb581,
	// Entry 1180 - 11BF
	0xb59e, 0xb5b3, 0xb5c9, 0xb5df, 0xb5ff, 0xb615, 0xb635, 0xb64c,
	0xb66d, 0xb683, 0xb6a3, 0xb6ba, 0xb6db, 0xb6f1, 0xb711, 0xb728,
	0xb749, 0xb767, 0xb77b, 0xb799, 0xb7b5, 0xb7ca, 0xb7e1, 0xb7f6,
	0xb80c, 0xb821, 0xb837, 0xb854, 0xb872, 0xb88f, 0xb8a4, 0xb8ba,
	0xb8d0, 0xb8f0, 0xb906, 0xb926, 0xb93d, 0xb95e, 0xb974, 0xb994,
	0xb9ab, 0xb9cc, 0xb9e2, 0xba02, 0xba19, 0xba3a, 0xba59, 0xba6d,
	0xba83, 0xba99, 0xbaaf, 0xbac5, 0xbada, 0xbaf1, 0xbb06, 0xbb1c,
	0xbb31, 0xbb47, 0xbb64, 0xbb79, 0xbb8f, 0xbba5, 0xbbc5, 0xbbdb,
	// Entry 11C0 - 11FF
	0xbbfb, 0xbc12, 0xbc33, 0xbc49, 0xbc69, 0xbc80, 0xbca1, 0xbcb7,
	0xbcd7, 0xbcee, 0xbd0f, 0xbd2e, 0xbd42, 0xbd57, 0xbd7a, 0xbd9d,
	0xbdc0, 0xbde3, 0xbdf8, 0xbe0f, 0xbe24, 0xbe3a, 0xbe4f, 0xbe65,
	0xbe82, 0xbe97, 0xbead, 0xbec3, 0xbee3, 0xbef9, 0xbf19, 0xbf30,
	0xbf51, 0xbf67, 0xbf87, 0xbf9e, 0xbfbf, 0xbfd5, 0xbff5, 0xc00c,
	0xc02d, 0xc04c, 0xc060, 0xc07c, 0xc091, 0xc0a8, 0xc0bd, 0xc0d3,
	0xc0e8, 0xc0fe, 0xc11b, 0xc130, 0xc146, 0xc15c, 0xc17c, 0xc192,
	0xc1b2, 0xc1c9, 0xc1ea, 0xc200, 0xc220, 0xc237, 0xc258, 0xc26e,
	// Entry 1200 - 123F
	0xc28e, 0xc2a5, 0xc2c6, 0xc2e5, 0xc2f9, 0xc317, 0xc32c, 0xc34b,
	0xc366, 0xc37b, 0xc392, 0xc3a7, 0xc3bd, 0xc3d2, 0xc3e8, 0xc405,
	0xc41a, 0xc430, 0xc446, 0xc466, 0xc47c, 0xc49c, 0xc4b3, 0xc4d4,
	0xc4f3, 0xc507, 0xc524, 0xc539, 0xc54e, 0xc565, 0xc57a, 0xc590,
	0xc5a5, 0xc5bb, 0xc5d8, 0xc5ed, 0xc603, 0xc619, 0xc639, 0xc64f,
	0xc66f, 0xc686, 0xc6a7, 0xc6bd, 0xc6dd, 0xc6f4, 0xc715, 0xc72b,
	0xc74b, 0xc762, 0xc783, 0xc797, 0xc7b5, 0xc7d0, 0xc7e5, 0xc7fc,
	0xc811, 0xc827, 0xc83c, 0xc852, 0xc86f, 0xc884, 0xc89a, 0xc8b0,
	// Entry 1240 - 127F
	0xc8d0, 0xc8e6, 0xc906, 0xc91d, 0xc93e, 0xc954, 0xc974, 0xc98b,
	0xc9ac, 0xc9c2, 0xc9e2, 0xc9f9, 0xca1a, 0xca39, 0xca4d, 0xca6c,
	0xca81, 0xca9f, 0xcabf, 0xcadd, 0xcafb, 0xcb1a, 0xcb39, 0xcb58,
	0xcb77, 0xcb8d, 0xcba3, 0xcbba, 0xcbd0, 0xcbe7, 0xcbfd, 0xcc14,
	0xcc2b, 0xcc4c, 0xcc63, 0xcc84, 0xcc9c, 0xccbe, 0xccd5, 0xccf6,
	0xcd0e, 0xcd30, 0xcd47, 0xcd68, 0xcd80, 0xcda2, 0xcdb7, 0xcdcc,
	0xcde3, 0xcdf8, 0xce0e, 0xce23, 0xce39, 0xce56, 0xce6b, 0xce81,
	0xce97, 0xceb7, 0xcecd, 0xceed, 0xcf04, 0xcf25, 0xcf3b, 0xcf5b,
	// Entry 1280 - 12BF
	0xcf72, 0xcf93, 0xcfa9, 0xcfc9, 0xcfe0, 0xd001, 0xd020, 0xd034,
	0xd053, 0xd071, 0xd08d, 0xd0a2, 0xd0be, 0xd0dd, 0xd0f4, 0xd109,
	0xd11f, 0xd134, 0xd14a, 0xd169, 0xd17e, 0xd194, 0xd1b3, 0xd1ca,
	0xd1eb, 0xd1ff, 0xd21d, 0xd238, 0xd24d, 0xd264, 0xd279, 0xd28f,
	0xd2a4, 0xd2ba, 0xd2cf, 0xd2e5, 0xd2fc, 0xd31d, 0xd331, 0xd347,
	0xd364, 0xd37a, 0xd397, 0xd3ae, 0xd3cc, 0xd3e2, 0xd3f9, 0xd40f,
	0xd426, 0xd43e, 0xd460, 0xd475, 0xd48c, 0xd4a3, 0xd4ba, 0xd4d1,
	0xd4e7, 0xd4fd, 0xd513, 0xd529, 0xd53f, 0xd55c, 0xd579, 0xd597,
	// Entry 12C0 - 12FF
	0xd5b4, 0xd5d2, 0xd5ef, 0xd60d, 0xd629, 0xd645, 0xd65a, 0xd671,
	0xd686, 0xd69c, 0xd6b1, 0xd6c7, 0xd6dc, 0xd6f2, 0xd706, 0xd71d,
	0xd734, 0xd74b, 0xd762, 0xd781, 0xd7a0, 0xd7bf, 0xd7de, 0xd7f6,
	0xd80c, 0xd823, 0xd839, 0xd850, 0xd866, 0xd87d, 0xd892, 0xd8a8,
	0xd8c5, 0xd8e2, 0xd8ff, 0xd91c, 0xd93d, 0xd95e, 0xd97f, 0xd9a0,
	0xd9c0, 0xd9d6, 0xd9ed, 0xda03, 0xda1a, 0xda30, 0xda47, 0xda5c,
	0xda7a, 0xda98, 0xdab7, 0xdad5, 0xdaf4, 0xdb12, 0xdb31, 0xdb4e,
	0xdb6a, 0xdb88, 0xdba6, 0xdbc4, 0xdbe2, 0xdc01, 0xdc20, 0xdc3f,
	// Entry 1300 - 133F
	0xdc5e, 0xdc7d, 0xdc9c, 0xdcbb, 0xdcda, 0xdcf9, 0xdd18, 0xdd37,
	0xdd56, 0xdd72, 0xdd8e, 0xddaa, 0xddc6, 0xdde4, 0xde02, 0xde20,
	0xde3f, 0xde5d, 0xde7b, 0xde98, 0xdeb5, 0xded2, 0xdef0, 0xdf0d,
	0xdf2a, 0xdf47, 0xdf64, 0xdf81, 0xdf9f, 0xdfbc, 0xdfd9, 0xdff7,
	0xe015, 0xe033, 0xe052, 0xe070, 0xe08e, 0xe0ac, 0xe0ca, 0xe0e8,
	0xe107, 0xe125, 0xe143, 0xe161, 0xe17f, 0xe19d, 0xe1bc, 0xe1da,
	0xe1f8, 0xe215, 0xe232, 0xe24f, 0xe26d, 0xe28a, 0xe2a7, 0xe2c3,
	0xe2e0, 0xe2fd, 0xe31a, 0xe338, 0xe355, 0xe372, 0xe390, 0xe3ae,
	// Entry 1340 - 137F
	0xe3cc, 0xe3eb, 0xe409, 0xe427, 0xe445, 0xe463, 0xe481, 0xe4a0,
	0xe4be, 0xe4dc, 0xe4f9, 0xe516, 0xe533, 0xe550, 0xe56e, 0xe58b,
	0xe5a8, 0xe5c5, 0xe5e2, 0xe5ff, 0xe61d, 0xe63a, 0xe657, 0xe674,
	0xe691, 0xe6ae, 0xe6cc, 0xe6e9, 0xe706, 0xe723, 0xe73f, 0xe75c,
	0xe779, 0xe797, 0xe7b4, 0xe7d0, 0xe7ed, 0xe80b, 0xe829, 0xe847,
	0xe866, 0xe884, 0xe8a2, 0xe8bf, 0xe8dc, 0xe8f9, 0xe917, 0xe934,
	0xe951, 0xe96f, 0xe98d, 0xe9ab, 0xe9ca, 0xe9e8, 0xea06, 0xea24,
	0xea42, 0xea60, 0xea7f, 0xea9d, 0xeabb, 0xeada, 0xeaf9, 0xeb18,
	// Entry 1380 - 13BF
	0xeb38, 0xeb57, 0xeb76, 0xeb94, 0xebb2, 0xebd0, 0xebef, 0xec0d,
	0xec2b, 0xec48, 0xec65, 0xec82, 0xeca0, 0xecbd, 0xecda, 0xecf6,
	0xed1a, 0xed38, 0xed56, 0xed74, 0xed93, 0xedb1, 0xedcf, 0xedec,
	0xee09, 0xee26, 0xee44, 0xee61, 0xee7e, 0xee9c, 0xeeba, 0xeed8,
	0xeef7, 0xef15, 0xef33, 0xef50, 0xef6e, 0xef8c, 0xefaa, 0xefc9,
	0xefe7, 0xf005, 0xf023, 0xf041, 0xf05f, 0xf07e, 0xf09c, 0xf0ba,
	0xf0d9, 0xf0f8, 0xf117, 0xf137, 0xf156, 0xf175, 0xf190, 0xf1ac,
	0xf1c2, 0xf1d9, 0xf1f0, 0xf208, 0xf21f, 0xf237, 0xf24e, 0xf266,
	// Entry 13C0 - 13FF
	0xf289, 0xf2ab, 0xf2ce, 0xf2f0, 0xf313, 0xf335, 0xf358, 0xf37e,
	0xf39c, 0xf3ac, 0xf3be, 0xf3cf, 0xf3e1, 0xf3f2, 0xf403, 0xf414,
	0xf425, 0xf437, 0xf448, 0xf45a, 0xf46b, 0xf47c, 0xf490, 0xf4a3,
	0xf4b4, 0xf4c5, 0xf4d5, 0xf4e4, 0xf4f8, 0xf50c, 0xf520, 0xf52f,
	0xf544, 0xf555, 0xf56d, 0xf57f, 0xf591, 0xf5ac, 0xf5c7, 0xf5d5,
	0xf5eb, 0xf5fa, 0xf608, 0xf616, 0xf637, 0xf647, 0xf65b, 0xf66c,
	0xf67d, 0xf68e, 0xf6ac, 0xf6c9, 0xf6d7, 0xf6e6, 0xf6f5, 0xf712,
	0xf724, 0xf734, 0xf747, 0xf755, 0xf765, 0xf77d, 0xf78d, 0xf7a6,
	// Entry 1400 - 143F
	0xf7bb, 0xf7cf, 0xf7f0, 0xf810, 0xf82e, 0xf84c, 0xf861, 0xf87b,
	0xf889, 0xf89d, 0xf8ad, 0xf8cb, 0xf8e7, 0xf8fc, 0xf918, 0xf930,
	0xf945, 0xf969, 0xf986, 0xf994, 0xf9a2, 0xf9be, 0xf9db, 0xf9e9,
	0xfa0e, 0xfa2f, 0xfa44, 0xfa57, 0xfa6e, 0xfa87, 0xfaa6, 0xfac4,
	0xfae3, 0xfaf8, 0xfb0b, 0xfb1b, 0xfb34, 0xfb50, 0xfb60, 0xfb70,
	0xfb84, 0xfb95, 0xfba7, 0xfbb8, 0xfbd3, 0xfbed, 0xfc06, 0xfc14,
	0xfc22, 0xfc3a, 0xfc54, 0xfc6b, 0xfc7e, 0xfc93, 0xfca8, 0xfcb6,
	0xfcc5, 0xfcd4, 0xfcf1, 0xfd0e, 0xfd2b, 0xfd48, 0xfd67, 0xfd77,
	// Entry 1440 - 147F
	0xfd87, 0xfd97, 0xfda8, 0xfdb9, 0xfdcb, 0xfddc, 0xfded, 0xfdfe,
	0xfe0f, 0xfe20, 0xfe31, 0xfe42, 0xfe53, 0xfe64, 0xfe75, 0xfe86,
	0xfe9a, 0xfeae, 0xfec1, 0xfed1, 0xfee1, 0xfef1, 0xff02, 0xff13,
	0xff25, 0xff36, 0xff47, 0xff58, 0xff69, 0xff7a, 0xff8b, 0xff9c,
	0xffad, 0xffbe, 0xffcf, 0xffe0, 0xfff1, 0x0005, 0x0019, 0x002e,
	0x004b, 0x0068, 0x0076, 0x0084, 0x0092, 0x00a1, 0x00b0, 0x00c0,
	0x00cf, 0x00de, 0x00ed, 0x00fc, 0x010b, 0x011a, 0x0129, 0x0138,
	0x0147, 0x0156, 0x0165, 0x0174, 0x0186, 0x0198, 0x01a9, 0x01ba,
	// Entry 1480 - 14BF
	0x01cb, 0x01dd, 0x01ef, 0x0202, 0x0214, 0x0226, 0x0238, 0x024a,
	0x025c, 0x026e, 0x0280, 0x0292, 0x02a4, 0x02b6, 0x02cb, 0x02e0,
	0x02ef, 0x02ff, 0x030e, 0x031e, 0x032e, 0x033d, 0x034d, 0x035c,
	0x036c, 0x037c, 0x038b, 0x039c, 0x03ab, 0x03bc, 0x03cc, 0x03db,
	0x03eb, 0x03fa, 0x040a, 0x0419, 0x0428, 0x0438, 0x0447, 0x0457,
	0x0466, 0x0475, 0x0484, 0x0493, 0x04a2, 0x04b2, 0x04c2, 0x04d1,
	0x04e0, 0x04ef, 0x04fe, 0x0519, 0x0534, 0x054e, 0x0569, 0x0583,
	0x059e, 0x05b9, 0x05d5, 0x05ef, 0x060a, 0x0624, 0x063f, 0x0659,
	// Entry 14C0 - 14FF
	0x0674, 0x0698, 0x06bc, 0x06d7, 0x06ee, 0x0705, 0x0718, 0x072a,
	0x073d, 0x074f, 0x0762, 0x0774, 0x0787, 0x079a, 0x07ad, 0x07c0,
	0x07d3, 0x07e5, 0x07f8, 0x080b, 0x081e, 0x0831, 0x0843, 0x0855,
	0x086d, 0x0883, 0x0895, 0x08a6, 0x08b6, 0x08cc, 0x08de, 0x08ee,
	0x0906, 0x0917, 0x0927, 0x093c, 0x094b, 0x0960, 0x097a, 0x098c,
	0x099d, 0x09b3, 0x09c5, 0x09df, 0x09f7, 0x0a0a, 0x0a1a, 0x0a29,
	0x0a38, 0x0a49, 0x0a59, 0x0a69, 0x0a78, 0x0a89, 0x0a9a, 0x0aaa,
	0x0ac4, 0x0adf, 0x0af9, 0x0b13, 0x0b2e, 0x0b49, 0x0b69, 0x0b88,
	// Entry 1500 - 153F
	0x0ba7, 0x0bc7, 0x0bd6, 0x0be8, 0x0bf7, 0x0c0a, 0x0c19, 0x0c2c,
	0x0c46, 0x0c6d, 0x0c83, 0x0c9d, 0x0cad, 0x0cd2, 0x0cf7, 0x0d1e,
	0x0d37, 0x0d4b, 0x0d5e, 0x0d71, 0x0d86, 0x0d9a, 0x0dae, 0x0dc1,
	0x0dd6, 0x0deb, 0x0dff, 0x0e11, 0x0e23, 0x0e35, 0x0e47, 0x0e59,
	0x0e6c, 0x0e7f, 0x0e92, 0x0ea5, 0x0eb9, 0x0ecc, 0x0edf, 0x0ef2,
	0x0f05, 0x0f18, 0x0f2b, 0x0f3e, 0x0f52, 0x0f65, 0x0f78, 0x0f8c,
	0x0f9f, 0x0fb2, 0x0fc5, 0x0fd8, 0x0feb, 0x0ffe, 0x1012, 0x1026,
	0x1039, 0x104d, 0x1061, 0x1075, 0x1089, 0x109d, 0x10c2, 0x10d9,
	// Entry 1540 - 157F
	0x10f0, 0x1107, 0x111e, 0x1136, 0x114e, 0x1167, 0x117f, 0x1197,
	0x11af, 0x11c7, 0x11df, 0x11f7, 0x120f, 0x1228, 0x1240, 0x1259,
	0x1271, 0x1289, 0x12a1, 0x12ba, 0x12d3, 0x12ec, 0x1305, 0x131e,
	0x1335, 0x134c, 0x1364, 0x137c, 0x1393, 0x13ac, 0x13c4, 0x13dc,
	0x13f4, 0x140c, 0x1425, 0x143d, 0x1455, 0x146d, 0x1485, 0x149e,
	0x14b7, 0x14d0, 0x14e8, 0x1501, 0x151a, 0x1533, 0x154c, 0x1566,
	0x1580, 0x159a, 0x15b5, 0x15d7, 0x15fd, 0x1622, 0x1642, 0x1663,
	0x168d, 0x16ad, 0x16d3, 0x16ee, 0x1709, 0x1725, 0x1742, 0x175e,
	// Entry 1580 - 15BF
	0x177b, 0x1799, 0x17b6, 0x17d3, 0x17ef, 0x180b, 0x1827, 0x1844,
	0x1861, 0x187e, 0x189a, 0x18b6, 0x18d7, 0x18f9, 0x191d, 0x1941,
	0x1964, 0x1988, 0x19ac, 0x19d1, 0x19f4, 0x1a18, 0x1a3c, 0x1a60,
	0x1a84, 0x1aa7, 0x1ac7, 0x1ae8, 0x1b0c, 0x1b2d, 0x1b51, 0x1b66,
	0x1b7b, 0x1b91, 0x1ba7, 0x1bbd, 0x1bd3, 0x1bea, 0x1c00, 0x1c16,
	0x1c2d, 0x1c43, 0x1c59, 0x1c6f, 0x1c85, 0x1c9b, 0x1cb1, 0x1cc8,
	0x1cdf, 0x1cf7, 0x1d0d, 0x1d23, 0x1d39, 0x1d4f, 0x1d6d, 0x1d84,
	0x1da3, 0x1db9, 0x1dd7, 0x1dee, 0x1e0d, 0x1e24, 0x1e3a, 0x1e51,
	// Entry 15C0 - 15FF
	0x1e67, 0x1e7e, 0x1e94, 0x1eb0, 0x1ecc, 0x1ee8, 0x1f04, 0x1f20,
	0x1f3c, 0x1f58, 0x1f75, 0x1f91, 0x1fad, 0x1fd0, 0x1ff3, 0x2010,
	0x2030, 0x2050, 0x2067, 0x207e, 0x2096, 0x20ae, 0x20c6, 0x20de,
	0x20f6, 0x2114, 0x2132, 0x214f, 0x216d, 0x2190, 0x21ae, 0x21cc,
	0x21e9, 0x2207, 0x2227, 0x2247, 0x226a, 0x2284, 0x2293, 0x22a3,
	0x22b2, 0x22c2, 0x22d2, 0x22e1, 0x22f1, 0x2300, 0x2310, 0x2320,
	0x232f, 0x233f, 0x234e, 0x235e, 0x236d, 0x237c, 0x238c, 0x239b,
	0x23ab, 0x23ba, 0x23c9, 0x23d8, 0x23e7, 0x23f6, 0x2406, 0x2416,
	// Entry 1600 - 163F
	0x2425, 0x2434, 0x2445, 0x2455, 0x2467, 0x2479, 0x248b, 0x249e,
	0x24b1, 0x24c4, 0x24d7, 0x24e9, 0x24fb, 0x2514, 0x252d, 0x2546,
	0x255b, 0x2571, 0x258c, 0x25a1, 0x25b6, 0x25cb, 0x25e0, 0x25f5,
	0x260a, 0x261e, 0x2632, 0x2641, 0x264f, 0x2665, 0x2678, 0x2688,
	0x2697, 0x26a6, 0x26b7, 0x26c7, 0x26d7, 0x26e6, 0x26f7, 0x2708,
	0x2718, 0x2728, 0x2738, 0x2749, 0x275a, 0x276a, 0x277a, 0x278a,
	0x279b, 0x27ab, 0x27bb, 0x27cc, 0x27dc, 0x27ec, 0x27fc, 0x280c,
	0x281c, 0x282d, 0x283f, 0x284f, 0x285e, 0x286d, 0x287d, 0x288d,
	// Entry 1640 - 167F
	0x289c, 0x28ac, 0x28bb, 0x28cb, 0x28da, 0x28eb, 0x28fb, 0x290f,
	0x2923, 0x2937, 0x294b, 0x295f, 0x2979, 0x2992, 0x29ac, 0x29c6,
	0x29e1, 0x29fa, 0x2a13, 0x2a2d, 0x2a48, 0x2a62, 0x2a7c, 0x2a96,
	0x2aaf, 0x2ac8, 0x2ae2, 0x2afd, 0x2b17, 0x2b30, 0x2b4a, 0x2b63,
	0x2b7d, 0x2b98, 0x2bb2, 0x2bcb, 0x2be5, 0x2bfe, 0x2c18, 0x2c32,
	0x2c4c, 0x2c65, 0x2c7e, 0x2c97, 0x2cb1, 0x2ccb, 0x2ce5, 0x2cfe,
	0x2d17, 0x2d30, 0x2d4b, 0x2d66, 0x2d80, 0x2d9a, 0x2db5, 0x2dcf,
	0x2df5, 0x2e0e, 0x2e27, 0x2e3f, 0x2e58, 0x2e70, 0x2e89, 0x2ea1,
	// Entry 1680 - 16BF
	0x2eba, 0x2ed3, 0x2eec, 0x2f06, 0x2f1f, 0x2f38, 0x2f52, 0x2f6c,
	0x2f85, 0x2f9f, 0x2fba, 0x2fd4, 0x2fee, 0x3008, 0x3022, 0x303c,
	0x3053, 0x306a, 0x3080, 0x3095, 0x30aa, 0x30c1, 0x30d7, 0x30ed,
	0x3102, 0x3119, 0x3130, 0x3146, 0x3160, 0x3174, 0x3189, 0x31a0,
	0x31b6, 0x31cb, 0x31e0, 0x31f6, 0x320c, 0x3227, 0x3241, 0x325b,
	0x3276, 0x328b, 0x32a5, 0x32be, 0x32d7, 0x32f1, 0x330b, 0x3321,
	0x3336, 0x334a, 0x335e, 0x3373, 0x3388, 0x33a2, 0x33bb, 0x33d4,
	0x33ee, 0x3402, 0x341b, 0x3433, 0x344b, 0x3464, 0x347d, 0x348f,
	// Entry 16C0 - 16FF
	0x34a1, 0x34b4, 0x34c8, 0x34da, 0x34ec, 0x34fe, 0x3511, 0x3523,
	0x3535, 0x3547, 0x355a, 0x356c, 0x357e, 0x3591, 0x35a5, 0x35b7,
	0x35c9, 0x35db, 0x35ed, 0x35ff, 0x3610, 0x3622, 0x3637, 0x364c,
	0x3661, 0x3676, 0x368c, 0x369c, 0x36b3, 0x36ca, 0x36e2, 0x36fa,
	0x3710, 0x3727, 0x373e, 0x3751, 0x3768, 0x3780, 0x3796, 0x37ac,
	0x37c3, 0x37d6, 0x37ea, 0x3804, 0x3816, 0x382f, 0x3843, 0x385a,
	0x3872, 0x3888, 0x389f, 0x38b1, 0x38c3, 0x38da, 0x38f2, 0x3909,
	0x391f, 0x3935, 0x394c, 0x395e, 0x3974, 0x398b, 0x399d, 0x39b0,
	// Entry 1700 - 173F
	0x39c2, 0x39d5, 0x39e7, 0x39ff, 0x3a17, 0x3a2e, 0x3a45, 0x3a58,
	0x3a69, 0x3a7f, 0x3a90, 0x3aa2, 0x3ab3, 0x3ac5, 0x3ad7, 0x3ae9,
	0x3afc, 0x3b14, 0x3b35, 0x3b56, 0x3b79, 0x3b93, 0x3bb4, 0x3bd2,
	0x3bfe, 0x3c18, 0x3c32, 0x3c4c, 0x3c5f, 0x3c74, 0x3c8f, 0x3ca5,
	0x3cc0, 0x3cd5, 0x3ceb, 0x3d01, 0x3d18, 0x3d2d, 0x3d43, 0x3d58,
	0x3d74, 0x3d8a, 0x3d9f, 0x3db5, 0x3dcb, 0x3de1, 0x3dfc, 0x3e18,
	0x3e2e, 0x3e42, 0x3e56, 0x3e70, 0x3e8a, 0x3ea4, 0x3eb9, 0x3ece,
	0x3eeb, 0x3f0f, 0x3f27, 0x3f3e, 0x3f55, 0x3f6e, 0x3f86, 0x3f9e,
	// Entry 1740 - 177F
	0x3fb5, 0x3fce, 0x3fe7, 0x3fff, 0x4017, 0x402e, 0x4045, 0x405e,
	0x4076, 0x408e, 0x40a5, 0x40be, 0x40d7, 0x40ef, 0x4102, 0x4119,
	0x412c, 0x413e, 0x414f, 0x4163, 0x4186, 0x419d, 0x41af, 0x41c4,
	0x41d9, 0x41f1, 0x4203, 0x4216, 0x4239, 0x4251, 0x4263, 0x427c,
	0x4290, 0x42a3, 0x42be, 0x42d7, 0x42f7, 0x4322, 0x434e, 0x4369,
	0x438b, 0x43a6, 0x43c3, 0x43e7, 0x4412, 0x4429, 0x4441, 0x4454,
	0x4468, 0x447b, 0x4490, 0x44ac, 0x44c1, 0x44dd, 0x44f2, 0x450e,
	0x4525, 0x4543, 0x455b, 0x457a, 0x458f, 0x45a5, 0x45ba, 0x45d6,
	// Entry 1780 - 17BF
	0x45e8, 0x4604, 0x4616, 0x462d, 0x4640, 0x4652, 0x4669, 0x467b,
	0x4692, 0x46a5, 0x46bd, 0x46df, 0x4701, 0x4723, 0x473c, 0x474e,
	0x4765, 0x4777, 0x478e, 0x47a0, 0x47b2, 0x47ca, 0x47dc, 0x47f6,
	0x4808, 0x481a, 0x482c, 0x483e, 0x4850, 0x4867, 0x487e, 0x4890,
	0x48a2, 0x48b7, 0x48d1, 0x48e8, 0x4904, 0x491c, 0x4939, 0x4954,
	0x4976, 0x4992, 0x49b5, 0x49cf, 0x49ee, 0x4a0f, 0x4a35, 0x4a4e,
	0x4a6e, 0x4a80, 0x4a99, 0x4ab3, 0x4acd, 0x4ae5, 0x4afd, 0x4b16,
	0x4b32, 0x4b45, 0x4b57, 0x4b69, 0x4b7d, 0x4b90, 0x4ba3, 0x4bb5,
	// Entry 17C0 - 17FF
	0x4bc9, 0x4bdd, 0x4bf0, 0x4bfe, 0x4c0d, 0x4c1b, 0x4c33, 0x4c46,
	0x4c5c, 0x4c6d, 0x4c89, 0x4ca5, 0x4cc1, 0x4cdd, 0x4d00, 0x4d1c,
	0x4d39, 0x4d56, 0x4d73, 0x4d94, 0x4dbb, 0x4de2, 0x4e0a, 0x4e32,
	0x4e5b, 0x4e90, 0x4ec5, 0x4eec, 0x4f12, 0x4f3d, 0x4f68, 0x4f95,
	0x4fc2, 0x4fed, 0x5018, 0x5045, 0x5072, 0x509d, 0x50b4, 0x50cc,
	0x50e4, 0x50f6, 0x5108, 0x511a, 0x512d, 0x513f, 0x5151, 0x5164,
	0x5177, 0x518a, 0x519d, 0x51b1, 0x51c4, 0x51d7, 0x51ea, 0x51fe,
	0x5211, 0x5224, 0x5237, 0x524a, 0x525d, 0x5270, 0x5283, 0x5296,
	// Entry 1800 - 183F
	0x52a9, 0x52bc, 0x52cf, 0x52e2, 0x52f5, 0x5308, 0x531b, 0x533d,
	0x535e, 0x537e, 0x539b, 0x53b7, 0x53d6, 0x53f3, 0x540f, 0x542e,
	0x5444, 0x5459, 0x547d, 0x54a1, 0x54b5, 0x54c9, 0x54dd, 0x54f0,
	0x5503, 0x5518, 0x552c, 0x5540, 0x5553, 0x5568, 0x557d, 0x5591,
	0x55a3, 0x55b7, 0x55cb, 0x55df, 0x55f7, 0x560f, 0x561d, 0x5636,
	0x5645, 0x565f, 0x5679, 0x5688, 0x569c, 0x56ab, 0x56c5, 0x56d4,
	0x56ee, 0x56fd, 0x5717, 0x572d, 0x573c, 0x5756, 0x5765, 0x5774,
	0x5783, 0x579d, 0x57ac, 0x57c6, 0x57de, 0x57f6, 0x5805, 0x581f,
	// Entry 1840 - 187F
	0x5839, 0x5848, 0x5862, 0x5872, 0x5881, 0x589b, 0x58ab, 0x58ba,
	0x58ca, 0x58da, 0x58e8, 0x58f6, 0x5906, 0x5918, 0x5931, 0x5944,
	0x5956, 0x596d, 0x597f, 0x5996, 0x59a8, 0x59cc, 0x59e3, 0x59f9,
	0x5a07, 0x5a17, 0x5a32, 0x5a4f, 0x5a67, 0x5a82, 0x5a92, 0x5aa3,
	0x5ab4, 0x5ac4, 0x5ad5, 0x5ae6, 0x5af6, 0x5b07, 0x5b17, 0x5b28,
	0x5b38, 0x5b49, 0x5b59, 0x5b69, 0x5b79, 0x5b8a, 0x5b9b, 0x5bab,
	0x5bbc, 0x5bcc, 0x5bdd, 0x5bed, 0x5bfe, 0x5c0f, 0x5c21, 0x5c32,
	0x5c42, 0x5c52, 0x5c62, 0x5c72, 0x5c83, 0x5c93, 0x5ca3, 0x5cb4,
	// Entry 1880 - 18BF
	0x5cc4, 0x5cd3, 0x5ced, 0x5d07, 0x5d1b, 0x5d2e, 0x5d41, 0x5d55,
	0x5d68, 0x5d7c, 0x5d8f, 0x5da6, 0x5dbd, 0x5dd4, 0x5deb, 0x5e02,
	0x5e19, 0x5e30, 0x5e4d, 0x5e67, 0x5e76, 0x5e87, 0x5ea0, 0x5ec5,
	0x5ede, 0x5efe, 0x5f17, 0x5f28, 0x5f38, 0x5f48, 0x5f5a, 0x5f6b,
	0x5f7c, 0x5f8c, 0x5f9e, 0x5fb0, 0x5fc1, 0x5fd2, 0x5fe4, 0x5ff5,
	0x6008, 0x601a, 0x602c, 0x6040, 0x6053, 0x6066, 0x6078, 0x608c,
	0x60a0, 0x60b3, 0x60c5, 0x60d7, 0x60e9, 0x60fc, 0x610e, 0x6121,
	0x6134, 0x6147, 0x615a, 0x616d, 0x617f, 0x6191, 0x61a3, 0x61b6,
	// Entry 18C0 - 18FF
	0x61c8, 0x61da, 0x61ec, 0x61fe, 0x6211, 0x6223, 0x6235, 0x6247,
	0x625a, 0x626c, 0x627f, 0x6291, 0x62a4, 0x62b6, 0x62c8, 0x62da,
	0x62ed, 0x6306, 0x6322, 0x6330, 0x6341, 0x634e, 0x6369, 0x638b,
	0x63ab, 0x63cf, 0x63ed, 0x640a, 0x6427, 0x644c, 0x6470, 0x648e,
	0x64b0, 0x64d3, 0x64f7, 0x651b, 0x653f, 0x6562, 0x6586, 0x65aa,
	0x65ce, 0x65f1, 0x6615, 0x6639, 0x665d, 0x6681, 0x66a4, 0x66c8,
	0x66ed, 0x6711, 0x6735, 0x6759, 0x677c, 0x67a1, 0x67c6, 0x67eb,
	0x680f, 0x6834, 0x6859, 0x687d, 0x68a1, 0x68c5, 0x68ea, 0x690e,
	// Entry 1900 - 193F
	0x6933, 0x6957, 0x697a, 0x699e, 0x69c1, 0x69e5, 0x6a09, 0x6a2c,
	0x6a4f, 0x6a75, 0x6aa0, 0x6ac4, 0x6ae8, 0x6b12, 0x6b3e, 0x6b5f,
	0x6b83, 0x6ba6, 0x6bc7, 0x6bee, 0x6c14, 0x6c3a, 0x6c60, 0x6c73,
	0x6c83, 0x6c95, 0x6ca9, 0x6cce, 0x6d02, 0x6d2b, 0x6d5c, 0x6d73,
	0x6dae, 0x6dc7, 0x6de0, 0x6dfb, 0x6e0f, 0x6e28, 0x6e43, 0x6e73,
	0x6e9e, 0x6eb8, 0x6ed1, 0x6ef3, 0x6f0e, 0x6f32, 0x6f55, 0x6f7a,
	0x6f9a, 0x6fba, 0x6fd9, 0x7002, 0x7013, 0x7034, 0x704c, 0x706b,
	0x708d, 0x70a4, 0x70c3, 0x70da, 0x70f0, 0x7106, 0x7119, 0x712e,
	// Entry 1940 - 197F
	0x714a, 0x7171, 0x718d, 0x71aa, 0x71c6, 0x71e9, 0x7205, 0x7221,
	0x723f, 0x725b, 0x727b, 0x7296, 0x72b2, 0x72ce, 0x72f6, 0x7312,
	0x7337, 0x7353, 0x7374, 0x7391, 0x73b3, 0x73dc, 0x73f8, 0x7415,
	0x7432, 0x7452, 0x746e, 0x7493, 0x74b6, 0x74d2, 0x74ee, 0x750b,
	0x7534, 0x7558, 0x7574, 0x7590, 0x75ac, 0x75ca, 0x75ef, 0x75ff,
	0x761f, 0x763f, 0x765c, 0x767a, 0x7698, 0x76b8, 0x76d1, 0x76eb,
	0x7704, 0x7724, 0x773d, 0x7756, 0x7778, 0x7791, 0x77aa, 0x77c3,
	0x77dc, 0x77f5, 0x780e, 0x7827, 0x7840, 0x7862, 0x787b, 0x7895,
	// Entry 1980 - 19BF
	0x78ae, 0x78c7, 0x78e0, 0x78f9, 0x7912, 0x7929, 0x7947, 0x7962,
	0x7981, 0x7998, 0x79af, 0x79c6, 0x79e1, 0x79fd, 0x7a20, 0x7a37,
	0x7a55, 0x7a6c, 0x7a83, 0x7a9c, 0x7ab3, 0x7acf, 0x7aef, 0x7b12,
	0x7b29, 0x7b40, 0x7b57, 0x7b77, 0x7b95, 0x7bac, 0x7bc5, 0x7bdf,
	0x7c00, 0x7c1b, 0x7c3a, 0x7c53, 0x7c71, 0x7c8f, 0x7cad, 0x7ccb,
	0x7cec, 0x7d0e, 0x7d2e, 0x7d4e, 0x7d6e, 0x7d83, 0x7da9, 0x7dcf,
	0x7df5, 0x7e1b, 0x7e41, 0x7e67, 0x7e8d, 0x7ec0, 0x7ee6, 0x7f0c,
	0x7f32, 0x7f4d, 0x7f68, 0x7f84, 0x7fac, 0x7fd4, 0x7ff7, 0x8017,
	// Entry 19C0 - 19FF
	0x803f, 0x8065, 0x808b, 0x80b1, 0x80d7, 0x80fd, 0x8123, 0x8149,
	0x816f, 0x8195, 0x81bb, 0x81e1, 0x8207, 0x822f, 0x8255, 0x827b,
	0x82a1, 0x82c9, 0x82f5, 0x831c, 0x8344, 0x8371, 0x83a7, 0x83d3,
	0x83fb, 0x8428, 0x8452, 0x847a, 0x84a4, 0x84c6, 0x84dd, 0x84fe,
	0x8517, 0x853c, 0x8553, 0x857e, 0x859c, 0x85ba, 0x85dd, 0x85f7,
	0x8616, 0x8641, 0x866a, 0x8695, 0x86be, 0x86dd, 0x86fe, 0x872a,
	0x8750, 0x877b, 0x879a, 0x87b8, 0x87d1, 0x87f2, 0x880b, 0x8834,
	0x884f, 0x886c, 0x888b, 0x88ac, 0x88ca, 0x88e1, 0x890c, 0x892d,
	// Entry 1A00 - 1A3F
	0x8946, 0x8961, 0x897e, 0x899b, 0x89b0, 0x89c9, 0x89df, 0x89f5,
	0x8a0b, 0x8a21, 0x8a3c, 0x8a57, 0x8a7b, 0x8a91, 0x8aa7, 0x8ac8,
	0x8ade, 0x8af4, 0x8b06, 0x8b18, 0x8b2a, 0x8b5d, 0x8b7c, 0x8b9b,
	0x8bba, 0x8be0, 0x8c06, 0x8c26, 0x8c44, 0x8c6a, 0x8c88, 0x8ca6,
	0x8ccc, 0x8cf2, 0x8d10, 0x8d36, 0x8d5c, 0x8d82, 0x8da0, 0x8dc3,
	0x8de1, 0x8e03, 0x8e21, 0x8e42, 0x8e64, 0x8e82, 0x8eb9, 0x8ef8,
	0x8f16, 0x8f36, 0x8f75, 0x8f93, 0x8fc0, 0x8fed, 0x901a, 0x9031,
	0x904d, 0x9068, 0x9080, 0x90a4, 0x90bb, 0x90e0, 0x90ff, 0x911d,
	// Entry 1A40 - 1A7F
	0x914f, 0x9175, 0x9199, 0x91be, 0x91e1, 0x9206, 0x9229, 0x924f,
	0x9273, 0x92a0, 0x92cb, 0x92f0, 0x9313, 0x9338, 0x935b, 0x9381,
	0x93a5, 0x93c8, 0x93e9, 0x9415, 0x943f, 0x946b, 0x9495, 0x94c1,
	0x94eb, 0x9517, 0x9541, 0x9568, 0x958d, 0x95ba, 0x95e5, 0x960a,
	0x962d, 0x964f, 0x966f, 0x9694, 0x96b7, 0x96dc, 0x96ff, 0x9724,
	0x9747, 0x976a, 0x978b, 0x97b2, 0x97d7, 0x97fe, 0x9823, 0x9852,
	0x987f, 0x98a0, 0x98bf, 0x98e4, 0x9907, 0x992d, 0x9951, 0x9976,
	0x9999, 0x99c9, 0x99f7, 0x9a1d, 0x9a41, 0x9a6d, 0x9a97, 0x9ab8,
	// Entry 1A80 - 1ABF
	0x9ad7, 0x9afc, 0x9b1f, 0x9b44, 0x9b67, 0x9b8c, 0x9baf, 0x9bd4,
	0x9bf7, 0x9c1d, 0x9c41, 0x9c6d, 0x9c97, 0x9cc2, 0x9ceb, 0x9d1a,
	0x9d47, 0x9d73, 0x9d9d, 0x9dc9, 0x9df3, 0x9e14, 0x9e33, 0x9e58,
	0x9e7b, 0x9ea0, 0x9ec3, 0x9ee8, 0x9f0b, 0x9f3b, 0x9f69, 0x9f8f,
	0x9fb3, 0x9fd8, 0x9ffb, 0xa020, 0xa043, 0xa072, 0xa09f, 0xa0ce,
	0xa0fb, 0xa12e, 0xa15f, 0xa184, 0xa1a7, 0xa1cc, 0xa1ef, 0xa215,
	0xa239, 0xa265, 0xa28f, 0xa2ba, 0xa2e3, 0xa30a, 0xa32f, 0xa35b,
	0xa385, 0xa3b0, 0xa3d9, 0xa409, 0xa437, 0xa458, 0xa477, 0xa49c,
	// Entry 1AC0 - 1AFF
	0xa4bf, 0xa4e0, 0xa4ff, 0xa520, 0xa53f, 0xa564, 0xa587, 0xa5ac,
	0xa5cf, 0xa5f4, 0xa617, 0xa63c, 0xa65f, 0xa684, 0xa6a7, 0xa6cc,
	0xa6ef, 0xa715, 0xa739, 0xa75e, 0xa781, 0xa7a7, 0xa7cb, 0xa7ef,
	0xa812, 0xa836, 0xa85a, 0xa883, 0xa8ab, 0xa8d9, 0xa903, 0xa91f,
	0xa937, 0xa95c, 0xa97f, 0xa9a5, 0xa9c9, 0xa9f9, 0xaa27, 0xaa57,
	0xaa85, 0xaaba, 0xaaed, 0xab1d, 0xab4b, 0xab7f, 0xabb1, 0xabdc,
	0xac05, 0xac30, 0xac59, 0xac89, 0xacb7, 0xace2, 0xad0b, 0xad3a,
	0xad67, 0xad8c, 0xadaf, 0xadd5, 0xadf9, 0xae1a, 0xae39, 0xae69,
	// Entry 1B00 - 1B3F
	0xae97, 0xaec7, 0xaef5, 0xaf2a, 0xaf5d, 0xaf8d, 0xafbb, 0xafef,
	0xb021, 0xb047, 0xb06b, 0xb090, 0xb0b3, 0xb0d8, 0xb0fb, 0xb121,
	0xb145, 0xb175, 0xb1a3, 0xb1d3, 0xb201, 0xb236, 0xb269, 0xb299,
	0xb2c7, 0xb2fb, 0xb32d, 0xb357, 0xb37f, 0xb3a9, 0xb3d1, 0xb400,
	0xb42d, 0xb457, 0xb47f, 0xb4ad, 0xb4d9, 0xb4fe, 0xb521, 0xb547,
	0xb56b, 0xb595, 0xb5bd, 0xb5e7, 0xb60f, 0xb63e, 0xb66b, 0xb695,
	0xb6bd, 0xb6eb, 0xb717, 0xb738, 0xb757, 0xb77c, 0xb79f, 0xb7c5,
	0xb7e9, 0xb80a, 0xb829, 0xb84d, 0xb86f, 0xb892, 0xb8b3, 0xb8d3,
	// Entry 1B40 - 1B7F
	0xb8f1, 0xb914, 0xb937, 0xb964, 0xb991, 0xb9bd, 0xb9e9, 0xba1c,
	0xba4f, 0xba74, 0xba99, 0xbac8, 0xbaf7, 0xbb25, 0xbb53, 0xbb88,
	0xbbbd, 0xbbe2, 0xbc07, 0xbc36, 0xbc65, 0xbc93, 0xbcc1, 0xbce8,
	0xbd0f, 0xbd40, 0xbd71, 0xbda1, 0xbdd1, 0xbdf2, 0xbe13, 0xbe3e,
	0xbe69, 0xbe93, 0xbebd, 0xbeee, 0xbf1f, 0xbf42, 0xbf65, 0xbf92,
	0xbfbf, 0xbfeb, 0xc017, 0xc04a, 0xc07d, 0xc09f, 0xc0c1, 0xc0ed,
	0xc119, 0xc144, 0xc16f, 0xc1a1, 0xc1d3, 0xc1f7, 0xc21b, 0xc249,
	0xc277, 0xc2a4, 0xc2d1, 0xc305, 0xc339, 0xc35e, 0xc383, 0xc3b2,
	// Entry 1B80 - 1BBF
	0xc3e1, 0xc40f, 0xc43d, 0xc464, 0xc48b, 0xc4bc, 0xc4ed, 0xc51d,
	0xc54d, 0xc572, 0xc597, 0xc5c6, 0xc5f5, 0xc623, 0xc651, 0xc686,
	0xc6bb, 0xc6e2, 0xc713, 0xc743, 0xc77a, 0xc79d, 0xc7c0, 0xc7ed,
	0xc81a, 0xc846, 0xc872, 0xc8a5, 0xc8d8, 0xc8fd, 0xc922, 0xc951,
	0xc980, 0xc9ae, 0xc9dc, 0xca11, 0xca46, 0xca69, 0xca8b, 0xcab0,
	0xcad4, 0xcaf5, 0xcb15, 0xcb37, 0xcb58, 0xcb7d, 0xcba1, 0xcbc6,
	0xcbea, 0xcc0d, 0xcc2f, 0xcc64, 0xcc99, 0xccd8, 0xcd17, 0xcd55,
	0xcd93, 0xcdd8, 0xce1d, 0xce55, 0xce8d, 0xcecf, 0xcf11, 0xcf52,
	// Entry 1BC0 - 1BFF
	0xcf93, 0xcfdb, 0xd023, 0xd056, 0xd089, 0xd0c6, 0xd103, 0xd13f,
	0xd17b, 0xd1be, 0xd201, 0xd237, 0xd26d, 0xd2ad, 0xd2ed, 0xd32c,
	0xd36b, 0xd3b1, 0xd3f7, 0xd42c, 0xd461, 0xd4a0, 0xd4df, 0xd51d,
	0xd55b, 0xd5a0, 0xd5e5, 0xd61d, 0xd655, 0xd697, 0xd6d9, 0xd71a,
	0xd75b, 0xd7a3, 0xd7eb, 0xd80f, 0xd833, 0xd868, 0xd893, 0xd8c7,
	0xd8f0, 0xd92b, 0xd951, 0xd977, 0xd99c, 0xd9c0, 0xd9ee, 0xd9fb,
	0xda0f, 0xda1a, 0xda2b, 0xda4a, 0xda7d, 0xdaa6, 0xdad8, 0xdaff,
	0xdb38, 0xdb5f, 0xdb85, 0xdba8, 0xdbca, 0xdbf6, 0xdc0b, 0xdc1f,
	// Entry 1C00 - 1C3F
	0xdc3a, 0xdc5d, 0xdc80, 0xdcb0, 0xdcdf, 0xdd07, 0xdd3d, 0xdd62,
	0xdd87, 0xddab, 0xddce, 0xdde3, 0xddf7, 0xde12, 0xde38, 0xde5e,
	0xde91, 0xdec3, 0xdee4, 0xdf05, 0xdf30, 0xdf69, 0xdf91, 0xdfb9,
	0xdfe0, 0xe006, 0xe029, 0xe042, 0xe05a, 0xe065, 0xe09a, 0xe0c5,
	0xe0f9, 0xe122, 0xe15d, 0xe184, 0xe1aa, 0xe1cf, 0xe1f3, 0xe221,
	0xe22b, 0xe236, 0xe23d, 0xe244, 0xe24c, 0xe254, 0xe266, 0xe277,
	0xe287, 0xe293, 0xe2a4, 0xe2ae, 0xe2b8, 0xe2c8, 0xe2dd, 0xe2ee,
	0xe300, 0xe312, 0xe318, 0xe32b, 0xe336, 0xe33d, 0xe344, 0xe352,
	// Entry 1C40 - 1C7F
	0xe366, 0xe375, 0xe38f, 0xe3aa, 0xe3c5, 0xe3ea, 0xe404, 0xe41f,
	0xe43a, 0xe45f, 0xe465, 0xe472, 0xe478, 0xe489, 0xe497, 0xe4a5,
	0xe4b8, 0xe4c9, 0xe4d7, 0xe4ea, 0xe501, 0xe518, 0xe532, 0xe548,
	0xe55e, 0xe573, 0xe581, 0xe596, 0xe59b, 0xe5a7, 0xe5b3, 0xe5c1,
	0xe5d6, 0xe5eb, 0xe5f0, 0xe619, 0xe643, 0xe651, 0xe668, 0xe673,
	0xe67b, 0xe683, 0xe690, 0xe6a5, 0xe6ad, 0xe6ba, 0xe6c8, 0xe6e6,
	0xe705, 0xe719, 0xe732, 0xe74b, 0xe75b, 0xe770, 0xe786, 0xe79d,
	0xe7a9, 0xe7bb, 0xe7c3, 0xe7e3, 0xe7f8, 0xe802, 0xe813, 0xe82a,
	// Entry 1C80 - 1CBF
	0xe83f, 0xe84e, 0xe862, 0xe876, 0xe889, 0xe896, 0xe8a2, 0xe8aa,
	0xe8bc, 0xe8d5, 0xe8e0, 0xe8f4, 0xe903, 0xe916, 0xe924, 0xe939,
	0xe94e, 0xe962, 0xe979, 0xe993, 0xe9ae, 0xe9c9, 0xe9e5, 0xe9fa,
	0xea0e, 0xea1e, 0xea3e, 0xea4e, 0xea5e, 0xea6d, 0xea7e, 0xea8f,
	0xea9f, 0xeab4, 0xeac5, 0xeadc, 0xeaf8, 0xeb15, 0xeb35, 0xeb43,
	0xeb50, 0xeb5d, 0xeb6c, 0xeb7a, 0xeb88, 0xeb95, 0xeba4, 0xebb3,
	0xebc1, 0xebd4, 0xebe3, 0xebf8, 0xec12, 0xec2d, 0xec4b, 0xec69,
	0xec87, 0xeca5, 0xecc7, 0xece5, 0xed03, 0xed21, 0xed3f, 0xed5d,
	// Entry 1CC0 - 1CFF
	0xed7b, 0xed99, 0xedb7, 0xedc9, 0xedd3, 0xede0, 0xedf1, 0xedfa,
	0xee03, 0xee0d, 0xee18, 0xee22, 0xee2a, 0xee39, 0xee42, 0xee4b,
	0xee53, 0xee5e, 0xee6a, 0xee7b, 0xee84, 0xee90, 0xee9c, 0xeea8,
	0xeeb1, 0xeec4, 0xeed1, 0xeedb, 0xeeec, 0xeefd, 0xef0d, 0xef17,
	0xef21, 0xef2a, 0xef36, 0xef52, 0xef6f, 0xef93, 0xefb8, 0xefdb,
	0xeffa, 0xf014, 0xf02f, 0xf045, 0xf065, 0xf089, 0xf0a3, 0xf0bc,
	0xf0d6, 0xf0f0, 0xf10b, 0xf12f, 0xf14f, 0xf169, 0xf183, 0xf1af,
	0xf1d0, 0xf1f8, 0xf210, 0xf229, 0xf244, 0xf265, 0xf28a, 0xf2ba,
	// Entry 1D00 - 1D3F
	0xf2e9, 0xf303, 0xf31e, 0xf336, 0xf340, 0xf358, 0xf36f, 0xf37d,
	0xf38f, 0xf396, 0xf39e, 0xf3ac, 0xf3b3, 0xf3c4, 0xf3d2, 0xf3e2,
	0xf3f8, 0xf40f, 0xf41e, 0xf439, 0xf449, 0xf45f, 0xf46f, 0xf47d,
	0xf48b, 0xf4a2, 0xf4ad, 0xf4c6, 0xf4d6, 0xf4ed, 0xf504, 0xf514,
	0xf52a, 0xf541, 0xf552, 0xf55a, 0xf566, 0xf574, 0xf583, 0xf58b,
	0xf5a2, 0xf5ac, 0xf5b4, 0xf5c5, 0xf5db, 0xf5f9, 0xf604, 0xf611,
	0xf621, 0xf637, 0xf647, 0xf655, 0xf665, 0xf675, 0xf685, 0xf695,
	0xf6a3, 0xf6ae, 0xf6b8, 0xf6c4, 0xf6d0, 0xf6e2, 0xf6f3, 0xf701,
	// Entry 1D40 - 1D7F
	0xf717, 0xf730, 0xf74b, 0xf763, 0xf780, 0xf79b, 0xf7b6, 0xf7d3,
	0xf7ee, 0xf80c, 0xf828, 0xf844, 0xf860, 0xf87c, 0xf889, 0xf899,
	0xf8a1, 0xf8ad, 0xf8bb, 0xf8d6, 0xf8f1, 0xf90a, 0xf923, 0xf93c,
	0xf956, 0xf96f, 0xf989, 0xf9a5, 0xf9c0, 0xf9d9, 0xf9f4, 0xfa0e,
	0xfa2b, 0xfa47, 0xfa64, 0xfa7a, 0xfa8b, 0xfa9c, 0xfaaf, 0xfac1,
	0xfad3, 0xfae4, 0xfaf7, 0xfb0a, 0xfb1c, 0xfb2d, 0xfb41, 0xfb55,
	0xfb68, 0xfb81, 0xfb9b, 0xfbb5, 0xfbcc, 0xfbe3, 0xfbfc, 0xfc14,
	0xfc2c, 0xfc43, 0xfc5c, 0xfc75, 0xfc8d, 0xfca4, 0xfcbe, 0xfcd8,
	// Entry 1D80 - 1DBF
	0xfcf1, 0xfd10, 0xfd30, 0xfd50, 0xfd6e, 0xfd89, 0xfda3, 0xfdc5,
	0xfde2, 0xfdfd, 0xfe1b, 0xfe37, 0xfe59, 0xfe74, 0xfe84, 0xfe96,
	0xfea5, 0xfeb2, 0xfec2, 0xfed1, 0xfee1, 0xfeee, 0xfefe, 0xff0e,
	0xff1e, 0xff2e, 0xff49, 0xff65, 0xff79, 0xff8e, 0xffa8, 0xffc0,
	0xffdb, 0xfff5, 0x000e, 0x0028, 0x0040, 0x0056, 0x006f, 0x0087,
	0x009e, 0x00b7, 0x00d1, 0x00ea, 0x0104, 0x0119, 0x0135, 0x014b,
	0x016b, 0x018c, 0x01ae, 0x01d1, 0x01f7, 0x021c, 0x023e, 0x025c,
	0x0278, 0x02ab, 0x02ca, 0x02e5, 0x0308, 0x032d, 0x0351, 0x0374,
	// Entry 1DC0 - 1DFF
	0x0398, 0x03be, 0x03e4, 0x0409, 0x042e, 0x0458, 0x047d, 0x0494,
	0x04a9, 0x04c1, 0x04d8, 0x0501, 0x052a, 0x054c, 0x056f, 0x0592,
	0x05a8, 0x05bc, 0x05d3, 0x05e9, 0x0600, 0x0614, 0x062b, 0x0642,
	0x0659, 0x0670, 0x0686, 0x069d, 0x06b5, 0x06ce, 0x06ee, 0x0710,
	0x0726, 0x073a, 0x0751, 0x0767, 0x077d, 0x0794, 0x07a9, 0x07bc,
	0x07d2, 0x07e7, 0x0803, 0x0822, 0x0855, 0x0886, 0x08a0, 0x08c6,
	0x08e6, 0x0900, 0x091a, 0x092d, 0x094a, 0x0974, 0x098b, 0x09af,
	0x09d4, 0x09f9, 0x0a24, 0x0a50, 0x0a7c, 0x0a97, 0x0ab3, 0x0acf,
	// Entry 1E00 - 1E3F
	0x0ad6, 0x0ae0, 0x0af4, 0x0b00, 0x0b14, 0x0b1d, 0x0b26, 0x0b2b,
	0x0b35, 0x0b46, 0x0b56, 0x0b68, 0x0b82, 0x0b9a, 0x0ba6, 0x0bb3,
	0x0bc2, 0x0bd1, 0x0bdb, 0x0bed, 0x0bf5, 0x0c03, 0x0c0c, 0x0c1d,
	0x0c2a, 0x0c39, 0x0c44, 0x0c4d, 0x0c58, 0x0c67, 0x0c6f, 0x0c7a,
	0x0c7f, 0x0c8d, 0x0c9c, 0x0ca3, 0x0cb2, 0x0cbd, 0x0ccc, 0x0cd7,
	0x0ce1, 0x0ced, 0x0cf2, 0x0cfa, 0x0d09, 0x0d18, 0x0d28, 0x0d38,
	0x0d47, 0x0d59, 0x0d73, 0x0d91, 0x0d9a, 0x0da1, 0x0da6, 0x0db0,
	0x0db9, 0x0dbf, 0x0dd3, 0x0ddd, 0x0deb, 0x0df9, 0x0e08, 0x0e11,
	// Entry 1E40 - 1E7F
	0x0e1f, 0x0e28, 0x0e33, 0x0e4a, 0x0e65, 0x0e7b, 0x0ea2, 0x0ecd,
	0x0edc, 0x0eef, 0x0f07, 0x0f13, 0x0f1f, 0x0f2c, 0x0f47, 0x0f59,
	0x0f6d, 0x0f83, 0x0fa9, 0x0fcb, 0x0fd7, 0x0fe3, 0x0ff3, 0x1000,
	0x100e, 0x1017, 0x1025, 0x1030, 0x103e, 0x1054, 0x105f, 0x1072,
	0x107e, 0x108a, 0x109a, 0x10b0, 0x10c5, 0x10dd, 0x10f4, 0x110e,
	0x1128, 0x1145, 0x1153, 0x1164, 0x116b, 0x117c, 0x1189, 0x1199,
	0x11b7, 0x11d8, 0x11f2, 0x120f, 0x1232, 0x1258, 0x1271, 0x128a,
	0x12ac, 0x12ce, 0x12d6, 0x12de, 0x12f2, 0x1306, 0x131f, 0x1338,
	// Entry 1E80 - 1EBF
	0x1348, 0x1358, 0x1361, 0x136c, 0x137b, 0x138c, 0x13a1, 0x13b8,
	0x13d8, 0x13fa, 0x1415, 0x1432, 0x143a, 0x1451, 0x145f, 0x146e,
	0x1480, 0x149b, 0x14b9, 0x14c3, 0x14cd, 0x14d9, 0x14e6, 0x14f3,
	0x1509, 0x151d, 0x1532, 0x154b, 0x1559, 0x1565, 0x1571, 0x157e,
	0x158b, 0x159f, 0x15a9, 0x15b2, 0x15bb, 0x15c2, 0x15cb, 0x15d1,
	0x15d5, 0x15db, 0x15fe, 0x1628, 0x1636, 0x163e, 0x164c, 0x167e,
	0x1695, 0x16ac, 0x16be, 0x16d9, 0x16f7, 0x171e, 0x1729, 0x1731,
	0x1739, 0x1753, 0x175e, 0x1761, 0x1765, 0x1768, 0x177c, 0x178a,
	// Entry 1EC0 - 1EFF
	0x179b, 0x17ab, 0x17bd, 0x17c8, 0x17d8, 0x17e4, 0x17f1, 0x17ff,
	0x1805, 0x182a, 0x1850, 0x1867, 0x187f, 0x1894, 0x18a4, 0x18b5,
	0x18c2, 0x18d1, 0x18e4, 0x18f0, 0x18f9, 0x190e, 0x1920, 0x1935,
	0x1948, 0x195e, 0x1980, 0x19a2, 0x19b7, 0x19cf, 0x19e3, 0x19f7,
	0x1a10, 0x1a29, 0x1a48, 0x1a6a, 0x1a89, 0x1aab, 0x1aca, 0x1aec,
	0x1b0a, 0x1b28, 0x1b3e, 0x1b61, 0x1b83, 0x1baf, 0x1bc0, 0x1bdb,
	0x1bf5, 0x1c11, 0x1c37, 0x1c6f, 0x1cad, 0x1cc6, 0x1cdd, 0x1cfa,
	0x1d12, 0x1d38, 0x1d5c, 0x1d92, 0x1dce, 0x1de3, 0x1dfe, 0x1e17,
	// Entry 1F00 - 1F3F
	0x1e24, 0x1e32, 0x1e37, 0x1e43, 0x1e51, 0x1e5b, 0x1e66, 0x1e6f,
	0x1e7b, 0x1e88, 0x1e92, 0x1e9d, 0x1eae, 0x1ebe, 0x1ecc, 0x1ed9,
	0x1eea, 0x1ef8, 0x1efb, 0x1f02, 0x1f08, 0x1f1a, 0x1f2c, 0x1f3b,
	0x1f51, 0x1f60, 0x1f65, 0x1f6e, 0x1f7d, 0x1f8d, 0x1f9f, 0x1fb2,
	0x1fc3, 0x1fd7, 0x1fdc, 0x1fe1, 0x2009, 0x2013, 0x2025, 0x2039,
	0x2041, 0x205c, 0x2078, 0x2089, 0x2095, 0x20a1, 0x20b3, 0x20bb,
	0x20c7, 0x20d7, 0x20e4, 0x20e9, 0x20f4, 0x20ff, 0x211b, 0x213c,
	0x215c, 0x217d, 0x219f, 0x21bd, 0x21de, 0x2200, 0x2220, 0x223f,
	// Entry 1F40 - 1F7F
	0x2262, 0x2282, 0x22a6, 0x22ca, 0x22f1, 0x2315, 0x233a, 0x2364,
	0x238f, 0x23b5, 0x23dd, 0x23fe, 0x2423, 0x2443, 0x2466, 0x2488,
	0x24b0, 0x24d5, 0x24f4, 0x2517, 0x2535, 0x2556, 0x257a, 0x25a4,
	0x25c8, 0x25ec, 0x2612, 0x2634, 0x2659, 0x267a, 0x269a, 0x26bb,
	0x26db, 0x2702, 0x2725, 0x2749, 0x276c, 0x2792, 0x27b7, 0x27dc,
	0x2801, 0x282d, 0x284c, 0x286b, 0x2886, 0x28a7, 0x28cf, 0x28f3,
	0x2916, 0x293c, 0x2960, 0x297a, 0x2993, 0x29ae, 0x29d2, 0x29f8,
	0x2a1b, 0x2a3f, 0x2a5a, 0x2a68, 0x2a8f, 0x2aa2, 0x2aad, 0x2aca,
	// Entry 1F80 - 1FBF
	0x2ada, 0x2af5, 0x2b13, 0x2b22, 0x2b34, 0x2b5a, 0x2b66, 0x2b7c,
	0x2b87, 0x2ba8, 0x2bbd, 0x2bdf, 0x2bea, 0x2bfb, 0x2c0c, 0x2c2d,
	0x2c4e, 0x2c6d, 0x2c8a, 0x2ca8, 0x2cc0, 0x2cda, 0x2cf6, 0x2d03,
	0x2d0c, 0x2d1f, 0x2d32, 0x2d4d, 0x2d67, 0x2d82, 0x2d9e, 0x2db9,
	0x2dd5, 0x2df5, 0x2e12, 0x2e32, 0x2e53, 0x2e71, 0x2e92, 0x2eaf,
	0x2ece, 0x2eeb, 0x2f02, 0x2f20, 0x2f40, 0x2f5e, 0x2f70, 0x2f89,
	0x2fb8, 0x2fe7, 0x2ff4, 0x3004, 0x3016, 0x302b, 0x3058, 0x306d,
	0x3083, 0x309a, 0x30b0, 0x30c6, 0x30dc, 0x30f2, 0x311f, 0x314f,
	// Entry 1FC0 - 1FFF
	0x317a, 0x31b0, 0x31e4, 0x3211, 0x3249, 0x327f, 0x32a7, 0x32db,
	0x330d, 0x3337, 0x335f, 0x338b, 0x33ba, 0x33c5, 0x33d2, 0x33de,
	0x33f5, 0x3403, 0x341b, 0x3433, 0x3450, 0x346d, 0x3487, 0x3497,
	0x34a9, 0x34bb, 0x34c7, 0x34cb, 0x34da, 0x34ec, 0x34fd, 0x3511,
	0x352b, 0x3548, 0x3557, 0x356f, 0x357b, 0x3583, 0x358d, 0x35a4,
	0x35bb, 0x35df, 0x3602, 0x3623, 0x3646, 0x367c, 0x36b1, 0x36e7,
	0x36f2, 0x36fb, 0x3706, 0x3721, 0x3744, 0x3768, 0x3789, 0x37ac,
	0x37bf, 0x37d4, 0x37eb, 0x37f7, 0x380a, 0x3819, 0x382b, 0x383e,
	// Entry 2000 - 203F
	0x384d, 0x3868, 0x3880, 0x3896, 0x38b4, 0x38c6, 0x38dc, 0x38eb,
	0x38ff, 0x391f, 0x3933, 0x3951, 0x3965, 0x397f, 0x3993, 0x39a6,
	0x39c1, 0x39de, 0x39fb, 0x3a1a, 0x3a38, 0x3a57, 0x3a72, 0x3a96,
	0x3aa7, 0x3abf, 0x3ad4, 0x3ae5, 0x3afe, 0x3b18, 0x3b33, 0x3b4c,
	0x3b5c, 0x3b6d, 0x3b79, 0x3b81, 0x3b93, 0x3bad, 0x3bcb, 0x3bd3,
	0x3bdc, 0x3be4, 0x3bf5, 0x3c04, 0x3c0f, 0x3c2d, 0x3c40, 0x3c48,
	0x3c63, 0x3c77, 0x3c88, 0x3c99, 0x3cac, 0x3cbe, 0x3cd0, 0x3ce1,
	0x3cf4, 0x3d07, 0x3d19, 0x3d2b, 0x3d40, 0x3d55, 0x3d6c, 0x3d83,
	// Entry 2040 - 207F
	0x3d99, 0x3daf, 0x3dc7, 0x3dde, 0x3df5, 0x3e0a, 0x3e21, 0x3e38,
	0x3e51, 0x3e69, 0x3e81, 0x3e98, 0x3eb1, 0x3eca, 0x3ee2, 0x3efa,
	0x3f15, 0x3f30, 0x3f4d, 0x3f6a, 0x3f86, 0x3fa2, 0x3fc0, 0x3fdd,
	0x3ffa, 0x4015, 0x4028, 0x403b, 0x4050, 0x4064, 0x4078, 0x408b,
	0x40a0, 0x40b5, 0x40c9, 0x40dd, 0x40f4, 0x410b, 0x4124, 0x413d,
	0x4155, 0x416d, 0x4187, 0x41a0, 0x41b9, 0x41d0, 0x41f2, 0x4214,
	0x4236, 0x4258, 0x427a, 0x429c, 0x42be, 0x42e0, 0x4302, 0x4324,
	0x4346, 0x4368, 0x438a, 0x43ac, 0x43ce, 0x43f0, 0x4412, 0x4434,
	// Entry 2080 - 20BF
	0x4456, 0x4478, 0x449a, 0x44bc, 0x44de, 0x4500, 0x4522, 0x4544,
	0x4562, 0x4580, 0x459e, 0x45bc, 0x45da, 0x45f8, 0x4616, 0x4634,
	0x4652, 0x4670, 0x468e, 0x46ac, 0x46ca, 0x46e8, 0x4706, 0x4724,
	0x4742, 0x4760, 0x477e, 0x479c, 0x47ba, 0x47d8, 0x47f6, 0x4814,
	0x4832, 0x4850, 0x486c, 0x4888, 0x48a4, 0x48c0, 0x48dc, 0x48f8,
	0x4914, 0x4930, 0x494c, 0x4968, 0x4984, 0x49a0, 0x49bc, 0x49d8,
	0x49f4, 0x4a10, 0x4a2c, 0x4a48, 0x4a64, 0x4a80, 0x4a9c, 0x4ab8,
	0x4ad4, 0x4af0, 0x4b0c, 0x4b28, 0x4b3a, 0x4b58, 0x4b76, 0x4b96,
	// Entry 20C0 - 20FF
	0x4bb6, 0x4bd5, 0x4bf4, 0x4c15, 0x4c35, 0x4c55, 0x4c73, 0x4c8b,
	0x4ca3, 0x4cbd, 0x4cd6, 0x4cef, 0x4d07, 0x4d21, 0x4d3b, 0x4d54,
	0x4d6d, 0x4d88, 0x4da5, 0x4dc2, 0x4ddd, 0x4df8, 0x4e21, 0x4e4a,
	0x4e71, 0x4e98, 0x4ec4, 0x4ef0, 0x4f1a, 0x4f44, 0x4f65, 0x4f8c,
	0x4fb3, 0x4fd4, 0x4ff4, 0x501a, 0x5040, 0x5060, 0x507f, 0x50a4,
	0x50c9, 0x50e8, 0x5106, 0x512a, 0x514e, 0x516c, 0x5191, 0x51bc,
	0x51e6, 0x5210, 0x523b, 0x5265, 0x528f, 0x52b4, 0x52d8, 0x5302,
	0x532b, 0x5354, 0x537e, 0x53a7, 0x53d0, 0x53f4, 0x541a, 0x5446,
	// Entry 2100 - 213F
	0x5472, 0x549e, 0x54ca, 0x54f6, 0x5522, 0x5548, 0x556c, 0x5596,
	0x55c0, 0x55ea, 0x5614, 0x563e, 0x5668, 0x568c, 0x56b6, 0x56e6,
	0x5716, 0x5746, 0x5775, 0x57a4, 0x57d4, 0x5803, 0x5832, 0x5861,
	0x5890, 0x58bf, 0x58ee, 0x591e, 0x594e, 0x5978, 0x59a1, 0x59ca,
	0x59f1, 0x5a18, 0x5a36, 0x5a52, 0x5a7b, 0x5aa4, 0x5ac6, 0x5aee,
	0x5b16, 0x5b37, 0x5b5e, 0x5b85, 0x5ba5, 0x5bcb, 0x5bf1, 0x5c10,
	0x5c3d, 0x5c6a, 0x5c90, 0x5cbc, 0x5ce8, 0x5d0d, 0x5d3b, 0x5d69,
	0x5d90, 0x5dbc, 0x5de8, 0x5e0d, 0x5e3f, 0x5e71, 0x5e9c, 0x5ec1,
	// Entry 2140 - 217F
	0x5ee5, 0x5f07, 0x5f2a, 0x5f5f, 0x5f94, 0x5fb5, 0x5fcc, 0x5fe1,
	0x5ff9, 0x6010, 0x6027, 0x603c, 0x6054, 0x606b, 0x6092, 0x60b6,
	0x60dd, 0x6101, 0x6111, 0x6127, 0x613e, 0x6157, 0x6167, 0x617f,
	0x6199, 0x61b2, 0x61bc, 0x61d4, 0x61ed, 0x6204, 0x6213, 0x622b,
	0x6241, 0x6256, 0x6266, 0x6271, 0x627d, 0x6287, 0x629d, 0x62b3,
	0x62c6, 0x62da, 0x62ed, 0x631f, 0x6342, 0x6374, 0x63a7, 0x63bb,
	0x63de, 0x6411, 0x641d, 0x6429, 0x644a, 0x6474, 0x648f, 0x64a8,
	0x64ce, 0x64f8, 0x6522, 0x6546, 0x6558, 0x656a, 0x6579, 0x6588,
	// Entry 2180 - 21BF
	0x65a0, 0x65b8, 0x65cb, 0x65de, 0x65f8, 0x6612, 0x6632, 0x6652,
	0x666f, 0x668c, 0x66af, 0x66d2, 0x66ee, 0x670a, 0x6726, 0x6742,
	0x6764, 0x6786, 0x67a2, 0x67be, 0x67e0, 0x6802, 0x681d, 0x6838,
	0x6845, 0x6852, 0x687e, 0x6885, 0x688c, 0x6898, 0x68a5, 0x68be,
	0x68c6, 0x68d2, 0x68ed, 0x6909, 0x6925, 0x6941, 0x6967, 0x6994,
	0x69aa, 0x69c1, 0x69cf, 0x69e3, 0x6a02, 0x6a21, 0x6a41, 0x6a62,
	0x6a83, 0x6aa3, 0x6ab4, 0x6ac5, 0x6adf, 0x6af8, 0x6b11, 0x6b2b,
	0x6b37, 0x6b52, 0x6b6e, 0x6b98, 0x6bc3, 0x6bec, 0x6c0f, 0x6c38,
	// Entry 21C0 - 21FF
	0x6c62, 0x6c6e, 0x6c93, 0x6cb8, 0x6cde, 0x6d04, 0x6d29, 0x6d4e,
	0x6d74, 0x6d9a, 0x6dad, 0x6dc1, 0x6dd4, 0x6de7, 0x6dfa, 0x6e13,
	0x6e2c, 0x6e40, 0x6e53, 0x6e58, 0x6e60, 0x6e67, 0x6e6c, 0x6e76,
	0x6e80, 0x6e89, 0x6e95, 0x6e98, 0x6ea6, 0x6eb5, 0x6ec0, 0x6eca,
	0x6ed9, 0x6ee8, 0x6ef2, 0x6f07, 0x6f18, 0x6f1f, 0x6f37, 0x6f43,
	0x6f54, 0x6f65, 0x6f6d, 0x6f91, 0x6faa, 0x6fc4, 0x6fdd, 0x6ff4,
	0x700e, 0x7027, 0x703b, 0x7047, 0x7057, 0x7065, 0x706d, 0x7071,
	0x707f, 0x7086, 0x7097, 0x70a9, 0x70ba, 0x70c6, 0x70d0, 0x70e1,
	// Entry 2200 - 223F
	0x70ed, 0x70f5, 0x7107, 0x7117, 0x7127, 0x713a, 0x714a, 0x715b,
	0x716f, 0x7180, 0x718f, 0x71a2, 0x71b4, 0x71c6, 0x71d9, 0x71eb,
	0x71fc, 0x7203, 0x720e, 0x7213, 0x721c, 0x7223, 0x7229, 0x722f,
	0x7236, 0x723b, 0x7240, 0x7246, 0x724c, 0x7252, 0x7255, 0x725a,
	0x725f, 0x7267, 0x7272, 0x727b, 0x7283, 0x7289, 0x7299, 0x72aa,
	0x72ba, 0x72cc, 0x72de, 0x72ee, 0x72fe, 0x730f, 0x731f, 0x7331,
	0x7343, 0x7353, 0x7363, 0x7373, 0x7385, 0x7394, 0x73a4, 0x73b4,
	0x73c6, 0x73d5, 0x73e0, 0x73ec, 0x73f7, 0x740a, 0x7420, 0x742f,
	// Entry 2240 - 227F
	0x7441, 0x7451, 0x7462, 0x7473, 0x748d, 0x74b1, 0x74d5, 0x74f9,
	0x751d, 0x7541, 0x7565, 0x7589, 0x75af, 0x75cf, 0x75e4, 0x7603,
	0x7617, 0x7628, 0x7632, 0x763c, 0x7646, 0x7650, 0x765a, 0x7664,
	0x767f, 0x7699, 0x76ba, 0x76da, 0x76eb, 0x76fb, 0x7712, 0x7727,
	0x773d, 0x7753, 0x775d, 0x7767, 0x7776, 0x777c, 0x778a, 0x779e,
	0x77a4, 0x77ab, 0x77b1, 0x77b5, 0x77c4, 0x77cf, 0x77db, 0x77ee,
	0x780a, 0x7825, 0x7831, 0x7842, 0x7855, 0x7866, 0x7886, 0x789a,
	0x78af, 0x78d8, 0x78f6, 0x7916, 0x7929, 0x793c, 0x7955, 0x7964,
	// Entry 2280 - 22BF
	0x7972, 0x798e, 0x7994, 0x799f, 0x79a5, 0x79aa, 0x79b0, 0x79b4,
	0x79b9, 0x79bf, 0x79d0, 0x79d7, 0x79e2, 0x79ea, 0x79f8, 0x7a03,
	0x7a0b, 0x7a16, 0x7a28, 0x7a3b, 0x7a4d, 0x7a60, 0x7a74, 0x7a84,
	0x7a88, 0x7a95, 0x7aab, 0x7ac3, 0x7adb, 0x7af2, 0x7b00, 0x7b0c,
	0x7b15, 0x7b19, 0x7b24, 0x7b3b, 0x7b51, 0x7b57, 0x7b5f, 0x7b81,
	0x7b9f, 0x7bbd, 0x7bd2, 0x7be7, 0x7bf6, 0x7c18, 0x7c29, 0x7c38,
	0x7c68, 0x7c73, 0x7c8a, 0x7ca1, 0x7cbf, 0x7cea, 0x7cf3, 0x7d14,
	0x7d34, 0x7d46, 0x7d5b, 0x7d68, 0x7d6e, 0x7d74, 0x7d81, 0x7d91,
	// Entry 22C0 - 22FF
	0x7da2, 0x7dbb, 0x7dc3, 0x7dd5, 0x7ddd, 0x7de9, 0x7dee, 0x7df6,
	0x7e09, 0x7e0e, 0x7e17, 0x7e27, 0x7e2b, 0x7e3f, 0x7e59, 0x7e62,
	0x7e75, 0x7ea3, 0x7eb8, 0x7ecc, 0x7eda, 0x7eee, 0x7efc, 0x7f12,
	0x7f29, 0x7f33, 0x7f3b, 0x7f43, 0x7f4e, 0x7f59, 0x7f65, 0x7f71,
	0x7f83, 0x7f89, 0x7f9b, 0x7fa4, 0x7fad, 0x7fb7, 0x7fc7, 0x7fd7,
	0x7fed, 0x7ff5, 0x8003, 0x8017, 0x8028, 0x8039, 0x8050, 0x805b,
	0x8075, 0x8089, 0x8096, 0x80a3, 0x80c0, 0x80dc, 0x80fe, 0x8117,
	0x812e, 0x8145, 0x814d, 0x8167, 0x8179, 0x818f, 0x81a6, 0x81b9,
	// Entry 2300 - 233F
	0x81d2, 0x81df, 0x81f2, 0x8200, 0x8214, 0x8229, 0x8241, 0x825c,
	0x8272, 0x8296, 0x82c0, 0x82d9, 0x82f1, 0x8309, 0x832d, 0x834b,
	0x8370, 0x837e, 0x838c, 0x83b2, 0x83d8, 0x83ff, 0x8408, 0x8422,
	0x8439, 0x8440, 0x844d, 0x8464, 0x848c, 0x84ba, 0x84c4, 0x84d9,
	0x84f4, 0x851a, 0x8540, 0x8561, 0x8582, 0x859e, 0x85ba, 0x85d9,
	0x85f4, 0x8611, 0x8623, 0x8636, 0x8648, 0x8679, 0x86a3, 0x86d4,
	0x86fe, 0x872c, 0x875a, 0x877d, 0x879c, 0x87c1, 0x87d2, 0x87f2,
	0x87fe, 0x8819, 0x8839, 0x885a, 0x8884, 0x88af, 0x88da, 0x8906,
	// Entry 2340 - 237F
	0x8937, 0x8969, 0x8993, 0x89be, 0x89e8, 0x8a13, 0x8a35, 0x8a58,
	0x8a7a, 0x8a9c, 0x8ac0, 0x8ae3, 0x8b06, 0x8b28, 0x8b4c, 0x8b70,
	0x8b93, 0x8bb6, 0x8bda, 0x8bfe, 0x8c24, 0x8c49, 0x8c6e, 0x8c92,
	0x8cb8, 0x8cde, 0x8d03, 0x8d28, 0x8d55, 0x8d82, 0x8db1, 0x8ddf,
	0x8e0d, 0x8e3a, 0x8e69, 0x8e98, 0x8ec6, 0x8ef4, 0x8f16, 0x8f25,
	0x8f35, 0x8f48, 0x8f5e, 0x8f74, 0x8f8a, 0x8fa9, 0x8fcc, 0x8fec,
	0x9012, 0x9039, 0x9066, 0x907c, 0x90a4, 0x90cf, 0x90e9, 0x911a,
	0x9149, 0x9165, 0x9191, 0x91b4, 0x91d6, 0x9201, 0x922d, 0x925e,
	// Entry 2380 - 23BF
	0x928f, 0x92c2, 0x92cc, 0x92ff, 0x9323, 0x9343, 0x9363, 0x9383,
	0x93a3, 0x93c9, 0x93ef, 0x9415, 0x9435, 0x945c, 0x9479, 0x949c,
	0x94ba, 0x94cb, 0x94e2, 0x9510, 0x951d, 0x9528, 0x9535, 0x9550,
	0x956c, 0x957e, 0x959e, 0x95b8, 0x95db, 0x95f7, 0x9604, 0x9621,
	0x9634, 0x9646, 0x9664, 0x9670, 0x968a, 0x96a5, 0x96bf, 0x96ce,
	0x96de, 0x96ed, 0x96fa, 0x9709, 0x9728, 0x973b, 0x9748, 0x9757,
	0x9765, 0x977e, 0x97a0, 0x97bb, 0x97ea, 0x981a, 0x983a, 0x985b,
	0x9881, 0x98a8, 0x98c7, 0x98e7, 0x990d, 0x9934, 0x9962, 0x9991,
	// Entry 23C0 - 23FF
	0x99b8, 0x99e0, 0x99f7, 0x9a10, 0x9a31, 0x9a4e, 0x9a6b, 0x9a7f,
	0x9a94, 0x9aa9, 0x9ac4, 0x9ae0, 0x9afc, 0x9b19, 0x9b37, 0x9b5b,
	0x9b80, 0x9b9e, 0x9bb3, 0x9bc9, 0x9bdf, 0x9bf6, 0x9c0c, 0x9c23,
	0x9c3a, 0x9c52, 0x9c68, 0x9c7f, 0x9c96, 0x9cae, 0x9cc5, 0x9cdd,
	0x9cf5, 0x9d0e, 0x9d24, 0x9d3b, 0x9d52, 0x9d6a, 0x9d81, 0x9d99,
	0x9db1, 0x9dca, 0x9de1, 0x9df9, 0x9e11, 0x9e2a, 0x9e42, 0x9e5b,
	0x9e74, 0x9e8e, 0x9ea4, 0x9ebb, 0x9ed2, 0x9eea, 0x9f01, 0x9f19,
	0x9f31, 0x9f4a, 0x9f61, 0x9f79, 0x9f91, 0x9faa, 0x9fc2, 0x9fdb,
	// Entry 2400 - 243F
	0x9ff4, 0xa00e, 0xa025, 0xa03d, 0xa055, 0xa06e, 0xa086, 0xa09f,
	0xa0b8, 0xa0d2, 0xa0ea, 0xa103, 0xa11c, 0xa136, 0xa14f, 0xa169,
	0xa183, 0xa19e, 0xa1b4, 0xa1cb, 0xa1e2, 0xa1fa, 0xa211, 0xa229,
	0xa241, 0xa25a, 0xa271, 0xa289, 0xa2a1, 0xa2ba, 0xa2d2, 0xa2eb,
	0xa304, 0xa31e, 0xa335, 0xa34d, 0xa365, 0xa37e, 0xa396, 0xa3af,
	0xa3c8, 0xa3e2, 0xa3fa, 0xa413, 0xa42c, 0xa446, 0xa45f, 0xa479,
	0xa493, 0xa4ae, 0xa4c5, 0xa4dd, 0xa4f5, 0xa50e, 0xa526, 0xa53f,
	0xa558, 0xa572, 0xa58a, 0xa5a3, 0xa5bc, 0xa5d6, 0xa5ef, 0xa609,
	// Entry 2440 - 247F
	0xa623, 0xa63e, 0xa656, 0xa66f, 0xa688, 0xa6a2, 0xa6bb, 0xa6d5,
	0xa6ef, 0xa70a, 0xa723, 0xa73d, 0xa757, 0xa772, 0xa78c, 0xa7a7,
	0xa7c2, 0xa7de, 0xa7f4, 0xa80b, 0xa822, 0xa83a, 0xa851, 0xa869,
	0xa881, 0xa89a, 0xa8b1, 0xa8c9, 0xa8e1, 0xa8fa, 0xa912, 0xa92b,
	0xa944, 0xa95e, 0xa975, 0xa98d, 0xa9a5, 0xa9be, 0xa9d6, 0xa9ef,
	0xaa08, 0xaa22, 0xaa3a, 0xaa53, 0xaa6c, 0xaa86, 0xaa9f, 0xaab9,
	0xaad3, 0xaaee, 0xab05, 0xab1d, 0xab35, 0xab4e, 0xab66, 0xab7f,
	0xab98, 0xabb2, 0xabca, 0xabe3, 0xabfc, 0xac16, 0xac2f, 0xac49,
	// Entry 2480 - 24BF
	0xac63, 0xac7e, 0xac96, 0xacaf, 0xacc8, 0xace2, 0xacfb, 0xad15,
	0xad2f, 0xad4a, 0xad63, 0xad7d, 0xad97, 0xadb2, 0xadcc, 0xade7,
	0xae02, 0xae1e, 0xae35, 0xae4d, 0xae65, 0xae7e, 0xae96, 0xaeaf,
	0xaec8, 0xaee2, 0xaefa, 0xaf13, 0xaf2c, 0xaf46, 0xaf5f, 0xaf79,
	0xaf93, 0xafae, 0xafc6, 0xafdf, 0xaff8, 0xb012, 0xb02b, 0xb045,
	0xb05f, 0xb07a, 0xb093, 0xb0ad, 0xb0c7, 0xb0e2, 0xb0fc, 0xb117,
	0xb132, 0xb14e, 0xb166, 0xb17f, 0xb198, 0xb1b2, 0xb1cb, 0xb1e5,
	0xb1ff, 0xb21a, 0xb233, 0xb24d, 0xb267, 0xb282, 0xb29c, 0xb2b7,
	// Entry 24C0 - 24FF
	0xb2d2, 0xb2ee, 0xb307, 0xb321, 0xb33b, 0xb356, 0xb370, 0xb38b,
	0xb3a6, 0xb3c2, 0xb3dc, 0xb3f7, 0xb412, 0xb42e, 0xb449, 0xb465,
	0xb481, 0xb49e, 0xb4ce, 0xb505, 0xb530, 0xb55c, 0xb588, 0xb5ac,
	0xb5cb, 0xb5eb, 0xb611, 0xb635, 0xb649, 0xb65f, 0xb67a, 0xb696,
	0xb6b1, 0xb6cd, 0xb6f4, 0xb715, 0xb729, 0xb73f, 0xb76e, 0xb7a4,
	0xb7c9, 0xb803, 0xb844, 0xb858, 0xb86d, 0xb888, 0xb8a4, 0xb8c4,
	0xb8e5, 0xb90e, 0xb938, 0xb957, 0xb976, 0xb990, 0xb9aa, 0xb9c4,
	0xb9de, 0xba03, 0xba28, 0xba4d, 0xba72, 0xba9b, 0xbac4, 0xbaee,
	// Entry 2500 - 253F
	0xbb18, 0xbb42, 0xbb6b, 0xbb95, 0xbbbf, 0xbbe1, 0xbc0f, 0xbc3f,
	0xbc6e, 0xbc9e, 0xbcbc, 0xbcdd, 0xbcf8, 0xbd16, 0xbd38, 0xbd5d,
	0xbd85, 0xbdb0, 0xbdd1, 0xbdee, 0xbe1a, 0xbe46, 0xbe72, 0xbe92,
	0xbeb1, 0xbecb, 0xbef0, 0xbf1a, 0xbf3e, 0xbf62, 0xbf86, 0xbfaa,
	0xbfcc, 0xbff1, 0xc017, 0xc03a, 0xc05f, 0xc085, 0xc0ab, 0xc0d3,
	0xc0fa, 0xc122, 0xc147, 0xc16e, 0xc195, 0xc1bd, 0xc1e5, 0xc20f,
	0xc238, 0xc262, 0xc289, 0xc2b2, 0xc2f7, 0xc33c, 0xc383, 0xc3cc,
	0xc410, 0xc458, 0xc49c, 0xc4e4, 0xc512, 0xc542, 0xc571, 0xc5a2,
	// Entry 2540 - 257F
	0xc5e9, 0xc630, 0xc654, 0xc676, 0xc69b, 0xc6bf, 0xc6e4, 0xc70a,
	0xc729, 0xc74a, 0xc76d, 0xc78a, 0xc7a8, 0xc7c6, 0xc7d4, 0xc7e3,
	0xc7ef, 0xc7fd, 0xc81a, 0xc829, 0xc83e, 0xc856, 0xc86f, 0xc885,
	0xc89c, 0xc8b9, 0xc8d7, 0xc8f6, 0xc916, 0xc937, 0xc959, 0xc984,
	0xc9b3, 0xc9e1, 0xca0d, 0xca28, 0xca44, 0xca5e, 0xca7c, 0xcaa0,
	0xcac2, 0xcae3, 0xcb05, 0xcb11, 0xcb25, 0xcb40, 0xcb5f, 0xcb7c,
	0xcb8f, 0xcb9a, 0xcbb6, 0xcbd0, 0xcbdc, 0xcbea, 0xcbfd, 0xcc19,
	0xcc31, 0xcc4b, 0xcc8d, 0xccce, 0xcd12, 0xcd55, 0xcd97, 0xcdd8,
	// Entry 2580 - 25BF
	0xce1c, 0xce5f, 0xce71, 0xce87, 0xcea8, 0xcec8, 0xcee7, 0xcf01,
	0xcf15, 0xcf25, 0xcf3c, 0xcf51, 0xcf96, 0xcfb0, 0xcfdb, 0xcff2,
	0xd006, 0xd014, 0xd025, 0xd039, 0xd05e, 0xd08d, 0xd0aa, 0xd0c8,
	0xd0d8, 0xd0ec, 0xd0fa, 0xd10c, 0xd123, 0xd139, 0xd146, 0xd164,
	0xd186, 0xd1a7, 0xd1c9, 0xd1e4, 0xd200, 0xd20c, 0xd226, 0xd241,
	0xd250, 0xd25f, 0xd270, 0xd282, 0xd29a, 0xd2b3, 0xd2c6, 0xd2d7,
	0xd2f9, 0xd30e, 0xd32b, 0xd337, 0xd346, 0xd366, 0xd397, 0xd3b8,
	0xd3c4, 0xd3d1, 0xd3fc, 0xd428, 0xd445, 0xd452, 0xd46e, 0xd48a,
	// Entry 25C0 - 25FF
	0xd4a3, 0xd4bc, 0xd4d6, 0xd4f0, 0xd509, 0xd522, 0xd52e, 0xd546,
	0xd55a, 0xd580, 0xd58b, 0xd59e, 0xd5a9, 0xd5b4, 0xd5d6, 0xd5f9,
	0xd5fd, 0xd601, 0xd61b, 0xd636, 0xd652, 0xd66f, 0xd68d, 0xd6af,
	0xd6ca, 0xd6e2, 0xd6f9, 0xd70d, 0xd71b, 0xd732, 0xd74d, 0xd761,
	0xd77c, 0xd797, 0xd7ab, 0xd7c4, 0xd7f6, 0xd829, 0xd850, 0xd870,
	0xd88c, 0xd8b3, 0xd8cb, 0xd8e5, 0xd8f8, 0xd90d, 0xd923, 0xd927,
	0xd943, 0xd960, 0xd978, 0xd994, 0xd9b5, 0xd9db, 0xd9f5, 0xda0d,
	0xda27, 0xda43, 0xda60, 0xda7b, 0xda94, 0xdab0, 0xdacb, 0xdae8,
	// Entry 2600 - 263F
	0xdb06, 0xdb1d, 0xdb3f, 0xdb60, 0xdb85, 0xdb92, 0xdbb9, 0xdbe1,
	0xdc13, 0xdc37, 0xdc4c, 0xdc61, 0xdc77, 0xdc96, 0xdca6, 0xdcc0,
	0xdce1, 0xdcfa, 0xdd0f, 0xdd24, 0xdd36, 0xdd4f, 0xdd6c, 0xdd81,
	0xdd99, 0xddb1, 0xddd3, 0xddf5, 0xde17, 0xde47, 0xde5f, 0xde7e,
	0xde98, 0xdeab, 0xded5, 0xdeef, 0xdf08, 0xdf1a, 0xdf2b, 0xdf47,
	0xdf62, 0xdf72, 0xdf83, 0xdfa5, 0xdfc1, 0xdfdc, 0xdffc, 0xe01b,
	0xe03a, 0xe053, 0xe073, 0xe08a, 0xe0a8, 0xe0c7, 0xe0e8, 0xe108,
	0xe122, 0xe13a, 0xe16b, 0xe19c, 0xe1b9, 0xe1d8, 0xe1ed, 0xe205,
	// Entry 2640 - 267F
	0xe219, 0xe23f, 0xe25e, 0xe279, 0xe294, 0xe2b4, 0xe2c6, 0xe2e2,
	0xe300, 0xe332, 0xe351, 0xe36d, 0xe38c, 0xe3ae, 0xe3d3, 0xe3f0,
	0xe410, 0xe43d, 0xe46d, 0xe499, 0xe4c8, 0xe4fa, 0xe52e, 0xe546,
	0xe561, 0xe587, 0xe5b0, 0xe5cd, 0xe5ed, 0xe621, 0xe655, 0xe675,
	0xe698, 0xe6c2, 0xe6ec, 0xe720, 0xe754, 0xe798, 0xe7dc, 0xe7f9,
	0xe819, 0xe846, 0xe876, 0xe897, 0xe8bb, 0xe8e4, 0xe910, 0xe924,
	0xe93b, 0xe964, 0xe990, 0xe9a7, 0xe9c1, 0xe9e6, 0xea08, 0xea25,
	0xea3e, 0xea5a, 0xea87, 0xeab7, 0xeac3, 0xeace, 0xeae6, 0xeafd,
	// Entry 2680 - 26BF
	0xeb19, 0xeb3f, 0xeb65, 0xeb8c, 0xebb3, 0xebcd, 0xebe7, 0xec02,
	0xec1d, 0xec3b, 0xec59, 0xec7b, 0xec9d, 0xecac, 0xecbb, 0xecca,
	0xecdb, 0xecf6, 0xed13, 0xed38, 0xed5f, 0xed83, 0xeda9, 0xedc4,
	0xede1, 0xedff, 0xee1f, 0xee3e, 0xee5f, 0xee7b, 0xee99, 0xeeb6,
	0xeed4, 0xeee1, 0xeef0, 0xef09, 0xef24, 0xef39, 0xef4e, 0xef61,
	0xef78, 0xef8e, 0xefbc, 0xefd8, 0xefee, 0xf006, 0xf00d, 0xf017,
	0xf026, 0xf035, 0xf042, 0xf056, 0xf079, 0xf09b, 0xf0bd, 0xf0e6,
	0xf113, 0xf12f, 0xf14a, 0xf16d, 0xf17d, 0xf18b, 0xf1a1, 0xf1c0,
	// Entry 26C0 - 26FF
	0xf1ec, 0xf20b, 0xf22a, 0xf245, 0xf264, 0xf280, 0xf2a3, 0xf2cd,
	0xf2e2, 0xf2f9, 0xf313, 0xf33c, 0xf368, 0xf386, 0xf3a8, 0xf3bf,
	0xf3d1, 0xf3e9, 0xf3ff, 0xf415, 0xf42b, 0xf441, 0xf457, 0xf46c,
	0xf47f, 0xf494, 0xf4aa, 0xf4c0, 0xf4d6, 0xf4ec, 0xf502, 0xf515,
	0xf538, 0xf559, 0xf57b, 0xf59b, 0xf5b5, 0xf5d2, 0xf5fd, 0xf627,
	0xf643, 0xf660, 0xf67b, 0xf699, 0xf6a6, 0xf6b8, 0xf6ca, 0xf6e1,
	0xf6f8, 0xf706, 0xf714, 0xf721, 0xf72e, 0xf746, 0xf758, 0xf76c,
	0xf780, 0xf794, 0xf7a8, 0xf7bb, 0xf7ce, 0xf7e1, 0xf7f9, 0xf811,
	// Entry 2700 - 273F
	0xf827, 0xf83d, 0xf859, 0xf86f, 0xf88b, 0xf8a8, 0xf8d7, 0xf90d,
	0xf930, 0xf956, 0xf976, 0xf9a4, 0xf9d9, 0xf9fd, 0xfa36, 0xfa76,
	0xfa8f, 0xfab0, 0xfad1, 0xfafd, 0xfb2a, 0xfb4f, 0xfb70, 0xfb89,
	0xfba3, 0xfbd0, 0xfbfe, 0xfc22, 0xfc47, 0xfc73, 0xfca0, 0xfcc6,
	0xfcdf, 0xfcfc, 0xfd0d, 0xfd1d, 0xfd2d, 0xfd4a, 0xfd67, 0xfd79,
	0xfd94, 0xfdb3, 0xfdbf, 0xfdd4, 0xfdf8, 0xfe20, 0xfe48, 0xfe74,
	0xfea1, 0xfed4, 0xfef3, 0xff10, 0xff30, 0xff4f, 0xff6f, 0xff8c,
	0xffac, 0xffcc, 0xffec, 0x000c, 0x0032, 0x0056, 0x007d, 0x00a3,
	// Entry 2740 - 277F
	0x00ce, 0x00fd, 0x0123, 0x0147, 0x016e, 0x0194, 0x01bb, 0x01e2,
	0x0209, 0x0230, 0x026d, 0x02a8, 0x02e6, 0x0323, 0x0335, 0x0345,
	0x038a, 0x03d4, 0x0419, 0x0463, 0x048a, 0x04af, 0x04d7, 0x04fe,
	0x0521, 0x0542, 0x0566, 0x0589, 0x05bb, 0x05ee, 0x061f, 0x064f,
	0x065a, 0x0666, 0x0672, 0x067f, 0x06a8, 0x06be, 0x06db, 0x070e,
	0x0741, 0x0775, 0x07a9, 0x07ce, 0x07f1, 0x0817, 0x083c, 0x0873,
	0x08ab, 0x08e0, 0x0916, 0x094b, 0x0981, 0x09b8, 0x09f0, 0x0a1a,
	0x0a45, 0x0a6d, 0x0a96, 0x0abe, 0x0ae7, 0x0b11, 0x0b3c, 0x0b52,
	// Entry 2780 - 27BF
	0x0b69, 0x0b7d, 0x0b92, 0x0ba6, 0x0bbb, 0x0bd1, 0x0be8, 0x0c18,
	0x0c37, 0x0c50, 0x0c73, 0x0c8c, 0x0ca3, 0x0cac, 0x0cba, 0x0cce,
	0x0ce3, 0x0cf8, 0x0d10, 0x0d1d, 0x0d46, 0x0d71, 0x0d9c, 0x0dc8,
	0x0dd8, 0x0ded, 0x0e05, 0x0e22, 0x0e47, 0x0e5e, 0x0e7d, 0x0e96,
	0x0ea6, 0x0eb0, 0x0ebe, 0x0ece, 0x0edd, 0x0eec, 0x0ef6, 0x0f00,
	0x0f07, 0x0f0d, 0x0f13, 0x0f19, 0x0f2a, 0x0f40, 0x0f54, 0x0f5a,
	0x0f5f, 0x0f63, 0x0f69, 0x0f70, 0x0f77, 0x0f7f, 0x0f87, 0x0f9b,
	0x0fb0, 0x0fc9, 0x0fe3, 0x1016, 0x1047, 0x107b, 0x10ae, 0x10bb,
	// Entry 27C0 - 27FF
	0x10c8, 0x10cd, 0x10f2, 0x1114, 0x1138, 0x115c, 0x1180, 0x11a5,
	0x11c4, 0x11d1, 0x11e1, 0x11ef, 0x11fc, 0x1210, 0x122a, 0x1247,
	0x1265, 0x1283, 0x12a4, 0x12c3, 0x12e2, 0x1303, 0x1322, 0x1342,
	0x1360, 0x1386, 0x13a1, 0x13c1, 0x13df, 0x1400, 0x1421, 0x1440,
	0x145d, 0x147d, 0x149c, 0x14bb, 0x14db, 0x14f8, 0x1517, 0x1535,
	0x1552, 0x156e, 0x158c, 0x15a9, 0x15c9, 0x15e6, 0x1604, 0x1622,
	0x1640, 0x1664, 0x1680, 0x16a3, 0x16d0, 0x16ec, 0x1717, 0x1738,
	0x1761, 0x177f, 0x17a0, 0x17c1, 0x17e7, 0x1811, 0x182c, 0x1848,
	// Entry 2800 - 283F
	0x1864, 0x1883, 0x18a0, 0x18bd, 0x18dc, 0x18f9, 0x1917, 0x1933,
	0x1957, 0x1970, 0x198e, 0x19aa, 0x19c9, 0x19e8, 0x1a05, 0x1a20,
	0x1a3e, 0x1a5b, 0x1a78, 0x1a96, 0x1ab1, 0x1ace, 0x1aea, 0x1b05,
	0x1b1f, 0x1b3b, 0x1b56, 0x1b74, 0x1b8f, 0x1bab, 0x1bc7, 0x1be3,
	0x1c05, 0x1c1f, 0x1c40, 0x1c6b, 0x1c85, 0x1cae, 0x1ccd, 0x1cf4,
	0x1d10, 0x1d2f, 0x1d4e, 0x1d72, 0x1d9a, 0x1dc0, 0x1de4, 0x1e0c,
	0x1e2e, 0x1e4e, 0x1e6e, 0x1e97, 0x1ebc, 0x1edf, 0x1f04, 0x1f27,
	0x1f4c, 0x1f6f, 0x1f89, 0x1fa9, 0x1fc6, 0x1fe7, 0x200b, 0x202b,
	// Entry 2840 - 287F
	0x2049, 0x2067, 0x2082, 0x209b, 0x20ba, 0x20d9, 0x20fe, 0x2127,
	0x214a, 0x2168, 0x2181, 0x21a7, 0x21cd, 0x21e7, 0x21ff, 0x2219,
	0x2231, 0x224c, 0x2265, 0x2280, 0x2299, 0x22b2, 0x22c9, 0x22e2,
	0x22f9, 0x2313, 0x232b, 0x2345, 0x235d, 0x2379, 0x2393, 0x23ae,
	0x23c7, 0x23e1, 0x23f9, 0x2414, 0x242d, 0x2445, 0x245b, 0x2473,
	0x2489, 0x24a2, 0x24b9, 0x24d0, 0x24e5, 0x24fd, 0x2513, 0x252b,
	0x2541, 0x255b, 0x2573, 0x258c, 0x25a3, 0x25bb, 0x25d1, 0x25e9,
	0x25ff, 0x2618, 0x262f, 0x2648, 0x265f, 0x2678, 0x268f, 0x26b3,
	// Entry 2880 - 28BF
	0x26d5, 0x26f9, 0x271b, 0x2742, 0x2767, 0x278b, 0x27ad, 0x27cf,
	0x27ef, 0x2815, 0x2839, 0x285d, 0x287f, 0x289a, 0x28b3, 0x28d5,
	0x28f5, 0x291a, 0x293d, 0x2961, 0x2983, 0x29a6, 0x29c7, 0x29eb,
	0x2a0d, 0x2a32, 0x2a55, 0x2a78, 0x2a99, 0x2aba, 0x2ad9, 0x2afd,
	0x2b1f, 0x2b43, 0x2b65, 0x2b8c, 0x2bb1, 0x2bd5, 0x2bf7, 0x2c1d,
	0x2c41, 0x2c67, 0x2c8b, 0x2caf, 0x2cd1, 0x2cf5, 0x2d17, 0x2d3b,
	0x2d5d, 0x2d6e, 0x2d81, 0x2d94, 0x2da9, 0x2dbd, 0x2dd1, 0x2de9,
	0x2e11, 0x2e37, 0x2e61, 0x2e89, 0x2ea2, 0x2ec1, 0x2ee0, 0x2f03,
	// Entry 28C0 - 28FF
	0x2f24, 0x2f3f, 0x2f65, 0x2f8d, 0x2fac, 0x2fc4, 0x2fd4, 0x2ff0,
	0x3008, 0x3021, 0x303a, 0x3053, 0x306b, 0x3084, 0x309d, 0x30b6,
	0x30ce, 0x30e7, 0x3100, 0x3119, 0x3132, 0x314a, 0x3163, 0x317d,
	0x3196, 0x31af, 0x31c8, 0x31e0, 0x31fa, 0x3214, 0x322e, 0x3247,
	0x3261, 0x327b, 0x3294, 0x32ad, 0x32c6, 0x32e0, 0x32f9, 0x3313,
	0x332c, 0x3344, 0x335d, 0x3375, 0x338e, 0x33a7, 0x33bf, 0x33d8,
	0x33ea, 0x33fd, 0x3411, 0x3424, 0x3439, 0x345b, 0x346e, 0x3481,
	0x3495, 0x34a9, 0x34be, 0x34d1, 0x34e4, 0x34f7, 0x3511, 0x3526,
	// Entry 2900 - 293F
	0x3539, 0x355b, 0x3575, 0x3589, 0x359c, 0x35b0, 0x35cb, 0x35de,
	0x35f8, 0x360a, 0x361e, 0x363a, 0x3655, 0x3668, 0x367b, 0x368e,
	0x36a9, 0x36c4, 0x36d7, 0x36e9, 0x36fc, 0x3710, 0x3724, 0x373f,
	0x3758, 0x376b, 0x377f, 0x3793, 0x37a6, 0x37ba, 0x37ce, 0x37e2,
	0x37f5, 0x3808, 0x381b, 0x382e, 0x384c, 0x3860, 0x3872, 0x3884,
	0x38af, 0x38c6, 0x38df, 0x38f4, 0x3909, 0x391e, 0x3933, 0x3949,
	0x395e, 0x3973, 0x3988, 0x399d, 0x39b3, 0x39cf, 0x39e4, 0x39f9,
	0x3a0f, 0x3a24, 0x3a3a, 0x3a50, 0x3a66, 0x3a7b, 0x3a91, 0x3aa7,
	// Entry 2940 - 297F
	0x3abe, 0x3ad4, 0x3ae9, 0x3afe, 0x3b13, 0x3b29, 0x3b3f, 0x3b54,
	0x3b69, 0x3b7e, 0x3b93, 0x3ba8, 0x3bbe, 0x3bd4, 0x3be9, 0x3bfe,
	0x3c13, 0x3c28, 0x3c3d, 0x3c53, 0x3c69, 0x3c7e, 0x3c93, 0x3ca9,
	0x3cbf, 0x3cd5, 0x3cec, 0x3d03, 0x3d19, 0x3d2f, 0x3d44, 0x3d59,
	0x3d6e, 0x3d84, 0x3d9a, 0x3daf, 0x3dc4, 0x3dd9, 0x3dee, 0x3e03,
	0x3e19, 0x3e2f, 0x3e44, 0x3e59, 0x3e6e, 0x3e83, 0x3e98, 0x3eae,
	0x3ec4, 0x3ed9, 0x3eee, 0x3f03, 0x3f18, 0x3f2d, 0x3f43, 0x3f59,
	0x3f6e, 0x3f83, 0x3f9f, 0x3fbb, 0x3fd8, 0x3ff4, 0x4011, 0x402d,
	// Entry 2980 - 29BF
	0x4049, 0x4065, 0x4081, 0x409d, 0x40b8, 0x40d4, 0x40f0, 0x410c,
	0x4128, 0x4144, 0x4161, 0x417e, 0x419b, 0x41ba, 0x41d8, 0x41f7,
	0x4212, 0x422e, 0x424d, 0x4273, 0x4290, 0x42ac, 0x42d0, 0x42f4,
	0x4315, 0x433f, 0x435e, 0x4384, 0x439d, 0x43b7, 0x43d7, 0x43f8,
	0x4413, 0x4435, 0x4450, 0x446a, 0x4485, 0x4492, 0x44ae, 0x44cb,
	0x44dc, 0x44e7, 0x44f9, 0x4514, 0x4520, 0x452d, 0x453d, 0x454b,
	0x4566, 0x457b, 0x458f, 0x459a, 0x45af, 0x45c4, 0x45df, 0x45fb,
	0x460f, 0x4623, 0x463f, 0x465c, 0x4671, 0x4687, 0x469f, 0x46b8,
	// Entry 29C0 - 29FF
	0x46cf, 0x46e7, 0x46fe, 0x4716, 0x4737, 0x4758, 0x4774, 0x4781,
	0x4797, 0x47a5, 0x47af, 0x47c8, 0x47d4, 0x47de, 0x47ea, 0x47fa,
	0x4810, 0x4827, 0x4834, 0x4849, 0x4854, 0x4861, 0x4877, 0x4888,
	0x489c, 0x48a5, 0x48b2, 0x48c0, 0x48e4, 0x48f9, 0x490f, 0x4922,
	0x4947, 0x4951, 0x4964, 0x4978, 0x4986, 0x4993, 0x49a1, 0x49b1,
	0x49c6, 0x49db, 0x49fa, 0x4a18, 0x4a30, 0x4a42, 0x4a53, 0x4a69,
	0x4a7f, 0x4a97, 0x4aa9, 0x4ab8, 0x4ac9, 0x4ade, 0x4af3, 0x4b09,
	0x4b19, 0x4b2e, 0x4b43, 0x4b57, 0x4b6b, 0x4b81, 0x4b96, 0x4ba7,
	// Entry 2A00 - 2A3F
	0x4bb9, 0x4bce, 0x4be3, 0x4bf8, 0x4c0d, 0x4c1d, 0x4c2c, 0x4c3d,
	0x4c4c, 0x4c5c, 0x4c6d, 0x4c7f, 0x4c93, 0x4ca8, 0x4cbd, 0x4ccd,
	0x4ce0, 0x4cf3, 0x4d19, 0x4d28, 0x4d37, 0x4d47, 0x4d60, 0x4d6f,
	0x4d85, 0x4d9b, 0x4dad, 0x4dbd, 0x4dda, 0x4ded, 0x4e00, 0x4e15,
	0x4e29, 0x4e39, 0x4e4a, 0x4e59, 0x4e68, 0x4e77, 0x4e8c, 0x4ea1,
	0x4eb1, 0x4ec3, 0x4ed8, 0x4eed, 0x4f04, 0x4f15, 0x4f28, 0x4f3c,
	0x4f50, 0x4f6c, 0x4f87, 0x4f97, 0x4fb6, 0x4fd4, 0x4fe4, 0x5001,
	0x501c, 0x5030, 0x5044, 0x5054, 0x5071, 0x5085, 0x5099, 0x50b6,
	// Entry 2A40 - 2A7F
	0x50d3, 0x50e8, 0x50fd, 0x510d, 0x511d, 0x5144, 0x5161, 0x517e,
	0x519a, 0x51ad, 0x51c0, 0x51d5, 0x51f1, 0x5201, 0x521f, 0x522f,
	0x5240, 0x525d, 0x527a, 0x5297, 0x52b3, 0x52d0, 0x52ed, 0x530a,
	0x5327, 0x5345, 0x5363, 0x5382, 0x53a1, 0x53b3, 0x53d2, 0x53f1,
	0x5403, 0x5416, 0x5428, 0x543c, 0x5451, 0x5464, 0x5476, 0x5488,
	0x549a, 0x54ad, 0x54c1, 0x54d5, 0x54ec, 0x5500, 0x5512, 0x5526,
	0x553d, 0x5551, 0x5565, 0x5578, 0x558c, 0x55a9, 0x55c8, 0x55da,
	0x55f3, 0x5606, 0x561a, 0x5630, 0x5644, 0x5658, 0x5670, 0x5684,
	// Entry 2A80 - 2ABF
	0x569a, 0x56ab, 0x56c3, 0x56d9, 0x56eb, 0x56ff, 0x5713, 0x5726,
	0x5739, 0x574d, 0x5760, 0x5775, 0x578a, 0x57a1, 0x57b5, 0x57c8,
	0x57de, 0x57f3, 0x5805, 0x5820, 0x583b, 0x5855, 0x586d, 0x5881,
	0x5893, 0x58a7, 0x58bd, 0x58d0, 0x58e4, 0x58fa, 0x590d, 0x5920,
	0x5935, 0x5947, 0x595c, 0x5971, 0x5983, 0x5998, 0x59aa, 0x59bc,
	0x59ce, 0x59e1, 0x59f4, 0x5a07, 0x5a1a, 0x5a2e, 0x5a43, 0x5a58,
	0x5a6e, 0x5a80, 0x5a93, 0x5aa7, 0x5abb, 0x5ace, 0x5ae1, 0x5af6,
	0x5b0d, 0x5b2b, 0x5b3f, 0x5b52, 0x5b64, 0x5b76, 0x5b8d, 0x5ba0,
	// Entry 2AC0 - 2AFF
	0x5bb4, 0x5bc7, 0x5bdb, 0x5bee, 0x5c00, 0x5c14, 0x5c30, 0x5c47,
	0x5c61, 0x5c75, 0x5c88, 0x5c9b, 0x5cad, 0x5cc1, 0x5cd5, 0x5ce9,
	0x5cfe, 0x5d12, 0x5d26, 0x5d39, 0x5d4d, 0x5d62, 0x5d75, 0x5d88,
	0x5d9a, 0x5dac, 0x5dc0, 0x5dd6, 0x5de8, 0x5dfa, 0x5e0d, 0x5e1f,
	0x5e33, 0x5e46, 0x5e5d, 0x5e70, 0x5e85, 0x5e9a, 0x5eaf, 0x5ec4,
	0x5ed7, 0x5eee, 0x5f02, 0x5f16, 0x5f2a, 0x5f3f, 0x5f53, 0x5f70,
	0x5f86, 0x5f99, 0x5fab, 0x5fbe, 0x5fd3, 0x5fe8, 0x5ffb, 0x600d,
	0x6022, 0x6036, 0x6048, 0x605a, 0x606d, 0x6080, 0x6093, 0x60a8,
	// Entry 2B00 - 2B3F
	0x60be, 0x60d1, 0x60e4, 0x60f7, 0x6111, 0x6127, 0x613a, 0x614d,
	0x6160, 0x6174, 0x6188, 0x61a8, 0x61bb, 0x61ce, 0x61e2, 0x61f5,
	0x620b, 0x6228, 0x623b, 0x624f, 0x6262, 0x6275, 0x6287, 0x6299,
	0x62ac, 0x62c3, 0x62d7, 0x62ea, 0x62fd, 0x6310, 0x6324, 0x6343,
	0x635a, 0x636e, 0x6381, 0x6394, 0x63a7, 0x63ba, 0x63ce, 0x63e1,
	0x63f6, 0x640b, 0x641f, 0x6438, 0x644b, 0x6460, 0x6473, 0x6485,
	0x6498, 0x64ab, 0x64bf, 0x64d4, 0x64e9, 0x64fd, 0x652c, 0x655c,
	0x6596, 0x65d1, 0x6600, 0x6635, 0x666a, 0x669e, 0x66d8, 0x6713,
	// Entry 2B40 - 2B7F
	0x674d, 0x6777, 0x6788, 0x6799, 0x67ae, 0x67b8, 0x67db, 0x67f5,
	0x680d, 0x6824, 0x6836, 0x6849, 0x6862, 0x687c, 0x688f, 0x68a3,
	0x68bc, 0x68d6, 0x68f3, 0x6911, 0x691c, 0x6925, 0x6940, 0x695c,
	0x6979, 0x6997, 0x69b8, 0x69da, 0x69f3, 0x6a0d, 0x6a16, 0x6a3a,
	0x6a55, 0x6a74, 0x6a84, 0x6a98, 0x6aac, 0x6ac2, 0x6ad7, 0x6aec,
	0x6b00, 0x6b16, 0x6b2c, 0x6b41, 0x6b5c, 0x6b78, 0x6b97, 0x6bb5,
	0x6bd0, 0x6beb, 0x6bf4, 0x6c0d, 0x6c38, 0x6c5c, 0x6c92, 0x6cb6,
	0x6cc9, 0x6cf9, 0x6d0d, 0x6d24, 0x6d3b, 0x6d5e, 0x6d67, 0x6d7c,
	// Entry 2B80 - 2BBF
	0x6d9b, 0x6db6, 0x6dcd, 0x6dde, 0x6df5, 0x6e06, 0x6e1d, 0x6e2e,
	0x6e45, 0x6e56, 0x6e6d, 0x6e7e, 0x6e90, 0x6ea2, 0x6eb4, 0x6ec6,
	0x6ed8, 0x6eea, 0x6efc, 0x6f0e, 0x6f20, 0x6f32, 0x6f44, 0x6f56,
	0x6f68, 0x6f7a, 0x6f8c, 0x6f9e, 0x6fb0, 0x6fc2, 0x6fd4, 0x6fe6,
	0x6ff8, 0x700a, 0x701c, 0x702e, 0x7046, 0x7058, 0x706a, 0x707c,
	0x708e, 0x70a0, 0x70b2, 0x70c4, 0x70d6, 0x70e8, 0x70fa, 0x710c,
	0x711e, 0x7130, 0x7142, 0x7154, 0x7166, 0x7178, 0x718a, 0x719c,
	0x71ae, 0x71c0, 0x71d2, 0x71e4, 0x71f6, 0x7208, 0x721a, 0x722c,
	// Entry 2BC0 - 2BFF
	0x723e, 0x7250, 0x7262, 0x7274, 0x728c, 0x729e, 0x72b6, 0x72c8,
	0x72e0, 0x72f2, 0x7304, 0x7316, 0x7328, 0x733a, 0x734c, 0x7364,
	0x7376, 0x7388, 0x739a, 0x73ac, 0x73bd, 0x73cf, 0x73e7, 0x73ff,
	0x742c, 0x745e, 0x7481, 0x74a9, 0x74c0, 0x74de, 0x74f3, 0x7512,
	0x7529, 0x753a, 0x7551, 0x7562, 0x7579, 0x758a, 0x75a1, 0x75b2,
	0x75c9, 0x75da, 0x75ec, 0x75fe, 0x7610, 0x7622, 0x7634, 0x7646,
	0x7658, 0x766a, 0x767c, 0x768e, 0x76a0, 0x76b2, 0x76c4, 0x76d6,
	0x76e8, 0x76fa, 0x770c, 0x771e, 0x7730, 0x7742, 0x7754, 0x7766,
	// Entry 2C00 - 2C3F
	0x7778, 0x778a, 0x77a2, 0x77b4, 0x77c6, 0x77d8, 0x77ea, 0x77fc,
	0x780e, 0x7820, 0x7832, 0x7844, 0x7856, 0x7868, 0x787a, 0x788c,
	0x789e, 0x78b0, 0x78c2, 0x78d4, 0x78e6, 0x78f8, 0x790a, 0x791c,
	0x792e, 0x7940, 0x7952, 0x7964, 0x7976, 0x7988, 0x799a, 0x79ac,
	0x79be, 0x79d0, 0x79e8, 0x79fa, 0x7a12, 0x7a24, 0x7a3c, 0x7a4e,
	0x7a60, 0x7a72, 0x7a84, 0x7a96, 0x7aa8, 0x7ac0, 0x7ad2, 0x7ae4,
	0x7af6, 0x7b08, 0x7b19, 0x7b2b, 0x7b43, 0x7b5b, 0x7b6d, 0x7b7f,
	0x7b91, 0x7ba3, 0x7bb6, 0x7bdc, 0x7bf3, 0x7c11, 0x7c26, 0x7c37,
	// Entry 2C40 - 2C7F
	0x7c48, 0x7c59, 0x7c6a, 0x7c7b, 0x7c8c, 0x7c9d, 0x7cae, 0x7cbf,
	0x7cd0, 0x7ce1, 0x7cf2, 0x7d03, 0x7d14, 0x7d26, 0x7d38, 0x7d4a,
	0x7d5b, 0x7d6c, 0x7d7d, 0x7d8e, 0x7d9f, 0x7db0, 0x7dc1, 0x7dd3,
	0x7de5, 0x7df7, 0x7e09, 0x7e1b, 0x7e2d, 0x7e3f, 0x7e52, 0x7e65,
	0x7e77, 0x7e88, 0x7e99, 0x7eab, 0x7ebc, 0x7ece, 0x7ee0, 0x7ef2,
	0x7f12, 0x7f24, 0x7f38, 0x7f51, 0x7f6a, 0x7f7d, 0x7f96, 0x7faf,
	0x7fc3, 0x7fdc, 0x7fef, 0x8009, 0x8022, 0x803b, 0x8053, 0x806e,
	0x8089, 0x80a2, 0x80b5, 0x80c8, 0x80e0, 0x80f8, 0x810a, 0x8121,
	// Entry 2C80 - 2CBF
	0x8134, 0x8147, 0x815f, 0x8174, 0x8189, 0x819e, 0x81b3, 0x81c6,
	0x81d5, 0x81e5, 0x81f5, 0x8206, 0x8216, 0x8225, 0x8236, 0x8246,
	0x8255, 0x8265, 0x8276, 0x8286, 0x8296, 0x82a5, 0x82b6, 0x82c6,
	0x82d6, 0x82e6, 0x82f6, 0x8306, 0x8315, 0x8322, 0x833a, 0x8354,
	0x836c, 0x8387, 0x83a6, 0x83c0, 0x83de, 0x83f9, 0x8418, 0x8431,
	0x8449, 0x8464, 0x847f, 0x8499, 0x84b3, 0x84d2, 0x84f1, 0x850a,
	0x8525, 0x8540, 0x8560, 0x8579, 0x8591, 0x85aa, 0x85c2, 0x85da,
	0x85ef, 0x8607, 0x861d, 0x8638, 0x8656, 0x8673, 0x868b, 0x86a4,
	// Entry 2CC0 - 2CFF
	0x86b7, 0x86cb, 0x86dd, 0x86f1, 0x8704, 0x8716, 0x8729, 0x873d,
	0x8760, 0x8783, 0x87a2, 0x87c1, 0x87e2, 0x8802, 0x8821, 0x8843,
	0x8865, 0x8886, 0x88a8, 0x88c9, 0x88eb, 0x890d, 0x892e, 0x894d,
	0x895f, 0x8971, 0x8983, 0x8995, 0x89a7, 0x89ba, 0x89cc, 0x89df,
	0x89f1, 0x8a04, 0x8a17, 0x8a2a, 0x8a3c, 0x8a4f, 0x8a63, 0x8a77,
	0x8a89, 0x8a9b, 0x8aae, 0x8ac2, 0x8ad9, 0x8af0, 0x8b07, 0x8b1e,
	0x8b30, 0x8b42, 0x8b54, 0x8b6b, 0x8b7d, 0x8b8f, 0x8ba1, 0x8bb3,
	0x8bbf, 0x8bcc, 0x8bd9, 0x8be7, 0x8bf4, 0x8c02, 0x8c10, 0x8c1d,
	// Entry 2D00 - 2D3F
	0x8c2c, 0x8c3b, 0x8c49, 0x8c58, 0x8c67, 0x8c75, 0x8c84, 0x8c90,
	0x8c9c, 0x8ca8, 0x8cb4, 0x8cc1, 0x8ccd, 0x8cda, 0x8ce7, 0x8cf4,
	0x8d02, 0x8d0f, 0x8d1c, 0x8d29, 0x8d36, 0x8d43, 0x8d51, 0x8d5f,
	0x8d6e, 0x8d7e, 0x8d8b, 0x8d97, 0x8daf, 0x8dc7, 0x8ddf, 0x8df7,
	0x8e0f, 0x8e27, 0x8e3f, 0x8e57, 0x8e6f, 0x8e87, 0x8e9f, 0x8eb7,
	0x8ecf, 0x8ee7, 0x8eff, 0x8f17, 0x8f32, 0x8f4c, 0x8f67, 0x8f81,
	0x8f9b, 0x8fb5, 0x8fce, 0x8fe8, 0x9002, 0x901e, 0x903a, 0x9056,
	0x9072, 0x908c, 0x90a9, 0x90c5, 0x90e2, 0x90fe, 0x911a, 0x9136,
	// Entry 2D40 - 2D7F
	0x9151, 0x916d, 0x9189, 0x91a7, 0x91c5, 0x91e3, 0x9201, 0x921d,
	0x9239, 0x925d, 0x9280, 0x929b, 0x92b6, 0x92d3, 0x92ef, 0x930b,
	0x9326, 0x9343, 0x9360, 0x937c, 0x9397, 0x93b3, 0x93cf, 0x93ec,
	0x9408, 0x9425, 0x9442, 0x945d, 0x947a, 0x9496, 0x94b5, 0x94d1,
	0x94f0, 0x9511, 0x9537, 0x9554, 0x9575, 0x9591, 0x95ae, 0x95cf,
	0x95f1, 0x9611, 0x9631, 0x9651, 0x966d, 0x9689, 0x96a6, 0x96c0,
	0x96de, 0x96f6, 0x970c, 0x972e, 0x9753, 0x9778, 0x979c, 0x97c0,
	0x97e4, 0x980a, 0x982f, 0x983f, 0x9858, 0x9871, 0x988c, 0x98a6,
	// Entry 2D80 - 2DBF
	0x98c0, 0x98d9, 0x98f4, 0x990f, 0x9929, 0x993e, 0x9957, 0x9970,
	0x998b, 0x99a5, 0x99bf, 0x99d4, 0x99e8, 0x99fd, 0x9a11, 0x9a25,
	0x9a39, 0x9a4c, 0x9a60, 0x9a74, 0x9a8a, 0x9aa0, 0x9ab6, 0x9acc,
	0x9ae0, 0x9af7, 0x9b0d, 0x9b24, 0x9b3a, 0x9b50, 0x9b66, 0x9b7b,
	0x9b91, 0x9ba7, 0x9bbf, 0x9bd7, 0x9bef, 0x9c07, 0x9c1d, 0x9c3c,
	0x9c5a, 0x9c70, 0x9c86, 0x9c9b, 0x9cb0, 0x9cc7, 0x9cdd, 0x9cf3,
	0x9d08, 0x9d1f, 0x9d36, 0x9d4c, 0x9d61, 0x9d77, 0x9d8d, 0x9da4,
	0x9dba, 0x9dd1, 0x9de8, 0x9dfd, 0x9e14, 0x9e2a, 0x9e43, 0x9e59,
	// Entry 2DC0 - 2DFF
	0x9e72, 0x9e8d, 0x9ead, 0x9ec4, 0x9edc, 0x9ef2, 0x9f0a, 0x9f24,
	0x9f3f, 0x9f56, 0x9f71, 0x9f87, 0x9f9d, 0x9fb3, 0x9fcc, 0x9fe2,
	0x9ffa, 0xa00f, 0xa025, 0xa03c, 0xa056, 0xa070, 0xa087, 0xa0a2,
	0xa0be, 0xa0d8, 0xa0f2, 0xa109, 0xa122, 0xa13d, 0xa158, 0xa172,
	0xa186, 0xa19e, 0xa1b6, 0xa1d0, 0xa1e9, 0xa202, 0xa21a, 0xa234,
	0xa24e, 0xa267, 0xa27b, 0xa2a3, 0xa2cc, 0xa2f2, 0xa318, 0xa33c,
	0xa361, 0xa386, 0xa3ad, 0xa3d7, 0xa3ff, 0xa428, 0xa451, 0xa45a,
	0xa464, 0xa46d, 0xa483, 0xa495, 0xa4a7, 0xa4b9, 0xa4cb, 0xa4dd,
	// Entry 2E00 - 2E3F
	0xa4f0, 0xa503, 0xa516, 0xa529, 0xa53c, 0xa54f, 0xa562, 0xa575,
	0xa588, 0xa59b, 0xa5ae, 0xa5c1, 0xa5d4, 0xa5e7, 0xa5fa, 0xa60d,
	0xa620, 0xa633, 0xa646, 0xa659, 0xa66c, 0xa67f, 0xa692, 0xa6a5,
	0xa6b8, 0xa6cb, 0xa6de, 0xa6f1, 0xa704, 0xa717, 0xa72a, 0xa73d,
	0xa750, 0xa763, 0xa776, 0xa789, 0xa79c, 0xa7af, 0xa7c2, 0xa7d5,
	0xa7e8, 0xa7fb, 0xa810, 0xa81d, 0xa82a, 0xa836, 0xa841, 0xa84e,
	0xa859, 0xa863, 0xa872, 0xa87e, 0xa889, 0xa894, 0xa8a0, 0xa8ae,
	0xa8bc, 0xa8c8, 0xa8d4, 0xa8df, 0xa8eb, 0xa8f8, 0xa906, 0xa911,
	// Entry 2E40 - 2E7F
	0xa922, 0xa934, 0xa944, 0xa951, 0xa961, 0xa971, 0xa97f, 0xa98b,
	0xa998, 0xa9a4, 0xa9b2, 0xa9c1, 0xa9cf, 0xa9db, 0xa9e7, 0xa9f3,
	0xa9fe, 0xaa09, 0xaa13, 0xaa1e, 0xaa2a, 0xaa36, 0xaa45, 0xaa51,
	0xaa5f, 0xaa6f, 0xaa7c, 0xaa87, 0xaa92, 0xaaa1, 0xaaae, 0xaabd,
	0xaac9, 0xaad9, 0xaae4, 0xaaf1, 0xaafe, 0xab0a, 0xab16, 0xab22,
	0xab2f, 0xab3c, 0xab46, 0xab52, 0xab5e, 0xab69, 0xab77, 0xab83,
	0xab8f, 0xab9c, 0xabaa, 0xabb8, 0xabc3, 0xabd3, 0xabde, 0xabec,
	0xabfa, 0xac06, 0xac12, 0xac1d, 0xac2b, 0xac36, 0xac42, 0xac50,
	// Entry 2E80 - 2EBF
	0xac5b, 0xac6a, 0xac76, 0xaca0, 0xacc9, 0xacf2, 0xad1d, 0xad47,
	0xad71, 0xad9a, 0xadc5, 0xadf0, 0xae1a, 0xae43, 0xae6f, 0xae9b,
	0xaec9, 0xaef7, 0xaf24, 0xaf51, 0xaf80, 0xafae, 0xafdc, 0xb008,
	0xb038, 0xb068, 0xb09a, 0xb0cb, 0xb0d5, 0xb0de, 0xb0e7, 0xb0f1,
	0xb0fa, 0xb103, 0xb10c, 0xb11d, 0xb12c, 0xb135, 0xb14b, 0xb161,
	0xb178, 0xb18d, 0xb19f, 0xb1ad, 0xb1b6, 0xb1c1, 0xb1ca, 0xb1d3,
	0xb1dc, 0xb1e5, 0xb1ee, 0xb1f8, 0xb203, 0xb20c, 0xb215, 0xb220,
	0xb22b, 0xb234, 0xb23d, 0xb246, 0xb250, 0xb25a, 0xb264, 0xb26e,
	// Entry 2EC0 - 2EFF
	0xb279, 0xb282, 0xb28b, 0xb294, 0xb29d, 0xb2a6, 0xb2b1, 0xb2ba,
	0xb2c3, 0xb2cc, 0xb2dd, 0xb2ee, 0xb2fe, 0xb30f, 0xb31e, 0xb32d,
	0xb33b, 0xb34a, 0xb359, 0xb370, 0xb379, 0xb383, 0xb38d, 0xb397,
	0xb3a1, 0xb3b2, 0xb3cb, 0xb3d4, 0xb3dd, 0xb3e8, 0xb3f1, 0xb3fa,
	0xb403, 0xb40e, 0xb417, 0xb420, 0xb42e, 0xb437, 0xb440, 0xb44b,
	0xb454, 0xb45d, 0xb46b, 0xb477, 0xb483, 0xb48c, 0xb495, 0xb49e,
	0xb4a7, 0xb4b7, 0xb4c0, 0xb4c9, 0xb4d2, 0xb4db, 0xb4e4, 0xb4ed,
	0xb4f6, 0xb507, 0xb510, 0xb519, 0xb522, 0xb52c, 0xb535, 0xb544,
	// Entry 2F00 - 2F3F
	0xb54e, 0xb558, 0xb561, 0xb56a, 0xb574, 0xb57d, 0xb586, 0xb58f,
	0xb598, 0xb5a7, 0xb5b6, 0xb5de, 0xb606, 0xb630, 0xb659, 0xb682,
	0xb6aa, 0xb6d4, 0xb6fe, 0xb727, 0xb74f, 0xb77a, 0xb7a5, 0xb7d2,
	0xb7ff, 0xb82b, 0xb857, 0xb885, 0xb8b2, 0xb8df, 0xb90a, 0xb939,
	0xb968, 0xb999, 0xb9c9, 0xb9f9, 0xba28, 0xba59, 0xba8a, 0xbaba,
	0xbae5, 0xbb14, 0xbb1e, 0xbb3e, 0xbb5e, 0xbb86, 0xbba1, 0xbbb5,
	0xbbca, 0xbbdf, 0xbbfc, 0xbc15, 0xbc2a, 0xbc3c, 0xbc53, 0xbc6a,
	0xbc87, 0xbc9b, 0xbcb2, 0xbcc8, 0xbce8, 0xbcfd, 0xbd17, 0xbd32,
	// Entry 2F40 - 2F7F
	0xbd44, 0xbd60, 0xbd73, 0xbd89, 0xbda2, 0xbdbc, 0xbddc, 0xbdfa,
	0xbe18, 0xbe2e, 0xbe43, 0xbe57, 0xbe6f, 0xbe84, 0xbea7, 0xbebe,
	0xbed5, 0xbeed, 0xbf05, 0xbf1a, 0xbf2f, 0xbf48, 0xbf63, 0xbf82,
	0xbf9d, 0xbfb4, 0xbfc9, 0xbfe0, 0xbff9, 0xc01a, 0xc041, 0xc059,
	0xc079, 0xc08f, 0xc0a8, 0xc0c4, 0xc0e0, 0xc0f7, 0xc10e, 0xc126,
	0xc146, 0xc163, 0xc181, 0xc18f, 0xc19d, 0xc1aa, 0xc1b8, 0xc1c7,
	0xc1d6, 0xc1e4, 0xc1f3, 0xc201, 0xc20f, 0xc21c, 0xc22a, 0xc239,
	0xc247, 0xc256, 0xc264, 0xc272, 0xc27f, 0xc28d, 0xc29b, 0xc2a8,
	// Entry 2F80 - 2FBF
	0xc2b6, 0xc2c5, 0xc2d4, 0xc2e2, 0xc2f1, 0xc301, 0xc311, 0xc320,
	0xc330, 0xc33f, 0xc34e, 0xc35c, 0xc36b, 0xc37b, 0xc38a, 0xc39a,
	0xc3a9, 0xc3b8, 0xc3c6, 0xc3d5, 0xc3e4, 0xc3f2, 0xc401, 0xc410,
	0xc41f, 0xc42d, 0xc43c, 0xc44c, 0xc45b, 0xc46a, 0xc479, 0xc487,
	0xc496, 0xc4a6, 0xc4b5, 0xc4c4, 0xc4d3, 0xc4e1, 0xc4f0, 0xc500,
	0xc50f, 0xc51f, 0xc52e, 0xc53d, 0xc54b, 0xc55a, 0xc56a, 0xc579,
	0xc589, 0xc598, 0xc5a7, 0xc5b5, 0xc5c4, 0xc5d3, 0xc5e2, 0xc5f0,
	0xc5ff, 0xc60f, 0xc61e, 0xc62d, 0xc63c, 0xc64a, 0xc659, 0xc669,
	// Entry 2FC0 - 2FFF
	0xc678, 0xc688, 0xc698, 0xc6a7, 0xc6b7, 0xc6c8, 0xc6d9, 0xc6e9,
	0xc6fa, 0xc70a, 0xc71a, 0xc729, 0xc739, 0xc74a, 0xc75a, 0xc76b,
	0xc77b, 0xc78b, 0xc79a, 0xc7aa, 0xc7ba, 0xc7c9, 0xc7d9, 0xc7e9,
	0xc7f9, 0xc808, 0xc818, 0xc829, 0xc839, 0xc849, 0xc859, 0xc868,
	0xc878, 0xc888, 0xc898, 0xc8a7, 0xc8b7, 0xc8c8, 0xc8d8, 0xc8e9,
	0xc8f9, 0xc909, 0xc918, 0xc928, 0xc938, 0xc948, 0xc957, 0xc967,
	0xc977, 0xc987, 0xc996, 0xc9a6, 0xc9b7, 0xc9c7, 0xc9d7, 0xc9e7,
	0xc9f6, 0xca06, 0xca17, 0xca27, 0xca37, 0xca47, 0xca56, 0xca66,
	// Entry 3000 - 303F
	0xca77, 0xca87, 0xca98, 0xcaa8, 0xcab8, 0xcac7, 0xcad7, 0xcae8,
	0xcaf8, 0xcb09, 0xcb19, 0xcb29, 0xcb38, 0xcb48, 0xcb58, 0xcb68,
	0xcb77, 0xcb87, 0xcb98, 0xcba8, 0xcbb8, 0xcbc7, 0xcbd7, 0xcbe8,
	0xcbf8, 0xcc07, 0xcc16, 0xcc24, 0xcc33, 0xcc43, 0xcc52, 0xcc62,
	0xcc71, 0xcc80, 0xcc8e, 0xcc9d, 0xccad, 0xccbd, 0xcccc, 0xccdc,
	0xcceb, 0xccfa, 0xcd08, 0xcd17, 0xcd26, 0xcd34, 0xcd43, 0xcd52,
	0xcd60, 0xcd6f, 0xcd7f, 0xcd8e, 0xcd9d, 0xcdac, 0xcdba, 0xcdc9,
	0xcdd8, 0xcde7, 0xcdf5, 0xce04, 0xce13, 0xce22, 0xce30, 0xce3f,
	// Entry 3040 - 307F
	0xce4e, 0xce5c, 0xce6b, 0xce7a, 0xce89, 0xce97, 0xcea6, 0xceb6,
	0xcec5, 0xced4, 0xcee3, 0xcef1, 0xcf00, 0xcf0f, 0xcf1e, 0xcf2c,
	0xcf3b, 0xcf4b, 0xcf5b, 0xcf6a, 0xcf7a, 0xcf89, 0xcf98, 0xcfa6,
	0xcfb5, 0xcfc4, 0xcfd3, 0xcfe1, 0xcff0, 0xcfff, 0xd00e, 0xd01d,
	0xd02c, 0xd03a, 0xd049, 0xd059, 0xd068, 0xd077, 0xd086, 0xd094,
	0xd0a3, 0xd0b3, 0xd0c2, 0xd0d1, 0xd0e0, 0xd0ee, 0xd0fd, 0xd10d,
	0xd11c, 0xd12c, 0xd13b, 0xd14a, 0xd158, 0xd167, 0xd177, 0xd186,
	0xd195, 0xd1a4, 0xd1b2, 0xd1c1, 0xd1d0, 0xd1de, 0xd1ed, 0xd1fc,
	// Entry 3080 - 30BF
	0xd20b, 0xd219, 0xd228, 0xd238, 0xd247, 0xd256, 0xd265, 0xd273,
	0xd282, 0xd292, 0xd2a1, 0xd2b1, 0xd2c0, 0xd2cf, 0xd2dd, 0xd2ec,
	0xd2fc, 0xd30c, 0xd31b, 0xd32b, 0xd33a, 0xd349, 0xd357, 0xd366,
	0xd375, 0xd383, 0xd392, 0xd3a1, 0xd3b0, 0xd3be, 0xd3cd, 0xd3dd,
	0xd3ec, 0xd3fc, 0xd40c, 0xd41b, 0xd42b, 0xd43c, 0xd44c, 0xd45d,
	0xd46d, 0xd47d, 0xd48c, 0xd49c, 0xd4ad, 0xd4bd, 0xd4ce, 0xd4de,
	0xd4ee, 0xd4fd, 0xd50d, 0xd51d, 0xd52c, 0xd53c, 0xd54c, 0xd55c,
	0xd56b, 0xd57b, 0xd58c, 0xd59c, 0xd5ac, 0xd5bc, 0xd5cb, 0xd5db,
	// Entry 30C0 - 30FF
	0xd5ec, 0xd5fc, 0xd60c, 0xd61c, 0xd62b, 0xd63b, 0xd64b, 0xd65b,
	0xd66a, 0xd67a, 0xd68a, 0xd699, 0xd6a9, 0xd6b9, 0xd6c9, 0xd6d8,
	0xd6e8, 0xd6f9, 0xd709, 0xd719, 0xd729, 0xd738, 0xd748, 0xd759,
	0xd76a, 0xd77a, 0xd78b, 0xd79b, 0xd7ab, 0xd7ba, 0xd7ca, 0xd7db,
	0xd7eb, 0xd7fb, 0xd80b, 0xd81b, 0xd82b, 0xd83a, 0xd84a, 0xd85a,
	0xd869, 0xd878, 0xd886, 0xd895, 0xd8a5, 0xd8b4, 0xd8c4, 0xd8d3,
	0xd8e1, 0xd8f0, 0xd900, 0xd90f, 0xd91f, 0xd92e, 0xd93d, 0xd94b,
	0xd95a, 0xd969, 0xd977, 0xd986, 0xd995, 0xd9a4, 0xd9b2, 0xd9c1,
	// Entry 3100 - 313F
	0xd9d1, 0xd9e0, 0xd9f0, 0xda00, 0xda0f, 0xda1f, 0xda30, 0xda40,
	0xda51, 0xda61, 0xda71, 0xda80, 0xda90, 0xdaa1, 0xdab1, 0xdac2,
	0xdad2, 0xdae1, 0xdaf1, 0xdb01, 0xdb10, 0xdb20, 0xdb30, 0xdb40,
	0xdb4f, 0xdb5f, 0xdb70, 0xdb80, 0xdb90, 0xdba0, 0xdbaf, 0xdbbf,
	0xdbd0, 0xdbe0, 0xdbef, 0xdbfe, 0xdc0c, 0xdc1b, 0xdc2b, 0xdc3b,
	0xdc4a, 0xdc5a, 0xdc69, 0xdc78, 0xdc86, 0xdc95, 0xdca5, 0xdcb5,
	0xdcc4, 0xdcd4, 0xdce3, 0xdcf2, 0xdd00, 0xdd0f, 0xdd1e, 0xdd2c,
	0xdd3b, 0xdd4a, 0xdd59, 0xdd67, 0xdd76, 0xdd86, 0xdd95, 0xdda4,
	// Entry 3140 - 317F
	0xddb3, 0xddc1, 0xddd0, 0xdde0, 0xddef, 0xddfe, 0xde0d, 0xde1b,
	0xde2a, 0xde3a, 0xde4a, 0xde59, 0xde69, 0xde78, 0xde87, 0xde95,
	0xdea4, 0xdeb4, 0xdec4, 0xded3, 0xdee3, 0xdef2, 0xdf01, 0xdf0f,
	0xdf1e, 0xdf2d, 0xdf3c, 0xdf4a, 0xdf59, 0xdf68, 0xdf77, 0xdf85,
	0xdf94, 0xdfa4, 0xdfb3, 0xdfc2, 0xdfd1, 0xdfdf, 0xdfee, 0xdffe,
	0xe00d, 0xe01d, 0xe02c, 0xe03b, 0xe049, 0xe058, 0xe068, 0xe077,
	0xe087, 0xe096, 0xe0a5, 0xe0b3, 0xe0c2, 0xe0d1, 0xe0e0, 0xe0ee,
	0xe0fd, 0xe10c, 0xe11b, 0xe129, 0xe138, 0xe148, 0xe157, 0xe167,
	// Entry 3180 - 31BF
	0xe177, 0xe186, 0xe197, 0xe1a7, 0xe1b8, 0xe1c8, 0xe1d8, 0xe1e7,
	0xe1f7, 0xe208, 0xe219, 0xe229, 0xe23a, 0xe24a, 0xe25a, 0xe269,
	0xe279, 0xe289, 0xe299, 0xe2a8, 0xe2b8, 0xe2c8, 0xe2d8, 0xe2e7,
	0xe2f7, 0xe308, 0xe318, 0xe329, 0xe339, 0xe349, 0xe359, 0xe368,
	0xe378, 0xe389, 0xe399, 0xe3aa, 0xe3ba, 0xe3ca, 0xe3d9, 0xe3e9,
	0xe3f9, 0xe408, 0xe418, 0xe428, 0xe438, 0xe447, 0xe457, 0xe468,
	0xe478, 0xe488, 0xe498, 0xe4a7, 0xe4b7, 0xe4c8, 0xe4d9, 0xe4e9,
	0xe4fa, 0xe50a, 0xe51a, 0xe529, 0xe539, 0xe54a, 0xe55b, 0xe56b,
	// Entry 31C0 - 31FF
	0xe57c, 0xe58c, 0xe59c, 0xe5ab, 0xe5bb, 0xe5cb, 0xe5da, 0xe5ea,
	0xe5fb, 0xe60b, 0xe61c, 0xe62c, 0xe63c, 0xe64b, 0xe65b, 0xe66c,
	0xe67d, 0xe68d, 0xe69d, 0xe6ad, 0xe6bc, 0xe6cc, 0xe6dc, 0xe6eb,
	0xe6fb, 0xe70a, 0xe71a, 0xe729, 0xe738, 0xe747, 0xe755, 0xe764,
	0xe774, 0xe784, 0xe793, 0xe7a3, 0xe7b2, 0xe7c1, 0xe7cf, 0xe7de,
	0xe7ed, 0xe7fb, 0xe80a, 0xe819, 0xe828, 0xe836, 0xe845, 0xe855,
	0xe864, 0xe874, 0xe883, 0xe891, 0xe8a0, 0xe8af, 0xe8bd, 0xe8cc,
	0xe8db, 0xe8ea, 0xe8f8, 0xe907, 0xe917, 0xe926, 0xe936, 0xe945,
	// Entry 3200 - 323F
	0xe954, 0xe962, 0xe971, 0xe981, 0xe990, 0xe9a0, 0xe9af, 0xe9be,
	0xe9cc, 0xe9db, 0xe9ea, 0xe9f8, 0xea07, 0xea16, 0xea25, 0xea33,
	0xea42, 0xea52, 0xea61, 0xea70, 0xea7f, 0xea8d, 0xea9c, 0xeaac,
	0xeabb, 0xeaca, 0xead9, 0xeae7, 0xeaf6, 0xeb06, 0xeb16, 0xeb25,
	0xeb35, 0xeb44, 0xeb53, 0xeb61, 0xeb70, 0xeb80, 0xeb8f, 0xeb9f,
	0xebae, 0xebbd, 0xebcb, 0xebda, 0xebe9, 0xebf7, 0xec06, 0xec15,
	0xec24, 0xec32, 0xec41, 0xec51, 0xec60, 0xec6f, 0xec7e, 0xec8c,
	0xec9b, 0xecab, 0xecba, 0xecca, 0xecda, 0xece9, 0xecf9, 0xed0a,
	// Entry 3240 - 327F
	0xed1b, 0xed2b, 0xed3c, 0xed4c, 0xed5c, 0xed6b, 0xed7b, 0xed8b,
	0xed9a, 0xedaa, 0xedba, 0xedc9, 0xedd9, 0xede9, 0xedf8, 0xee08,
	0xee19, 0xee29, 0xee39, 0xee49, 0xee58, 0xee68, 0xee79, 0xee89,
	0xee99, 0xeea9, 0xeeb8, 0xeec8, 0xeed9, 0xeee9, 0xeefa, 0xef0a,
	0xef1a, 0xef29, 0xef39, 0xef4a, 0xef5a, 0xef6a, 0xef7a, 0xef8a,
	0xef99, 0xefa9, 0xefb8, 0xefc8, 0xefd9, 0xefe9, 0xeff9, 0xf009,
	0xf018, 0xf028, 0xf039, 0xf049, 0xf058, 0xf067, 0xf075, 0xf084,
	0xf094, 0xf0a3, 0xf0b3, 0xf0c2, 0xf0d1, 0xf0df, 0xf0ee, 0xf0fe,
	// Entry 3280 - 32BF
	0xf10d, 0xf11d, 0xf12c, 0xf13b, 0xf149, 0xf158, 0xf167, 0xf175,
	0xf184, 0xf193, 0xf1a2, 0xf1b0, 0xf1bf, 0xf1cf, 0xf1de, 0xf1ed,
	0xf1fc, 0xf20a, 0xf219, 0xf229, 0xf238, 0xf248, 0xf258, 0xf267,
	0xf277, 0xf288, 0xf298, 0xf2a9, 0xf2b9, 0xf2c9, 0xf2d8, 0xf2e8,
	0xf2f8, 0xf308, 0xf317, 0xf327, 0xf337, 0xf346, 0xf356, 0xf366,
	0xf376, 0xf385, 0xf395, 0xf3a5, 0xf3b5, 0xf3c4, 0xf3d4, 0xf3e5,
	0xf3f5, 0xf405, 0xf415, 0xf424, 0xf434, 0xf445, 0xf455, 0xf466,
	0xf476, 0xf486, 0xf495, 0xf4a5, 0xf4b5, 0xf4c5, 0xf4d4, 0xf4e4,
	// Entry 32C0 - 32FF
	0xf4f4, 0xf504, 0xf513, 0xf523, 0xf534, 0xf544, 0xf554, 0xf564,
	0xf573, 0xf583, 0xf594, 0xf5a4, 0xf5b4, 0xf5c4, 0xf5d3, 0xf5e3,
	0xf5f4, 0xf605, 0xf615, 0xf626, 0xf636, 0xf646, 0xf655, 0xf665,
	0xf675, 0xf685, 0xf694, 0xf6a4, 0xf6b4, 0xf6c3, 0xf6d3, 0xf6e4,
	0xf6f4, 0xf704, 0xf714, 0xf723, 0xf733, 0xf744, 0xf754, 0xf764,
	0xf773, 0xf784, 0xf794, 0xf7a4, 0xf7b4, 0xf7c3, 0xf7d3, 0xf7e3,
	0xf7f3, 0xf802, 0xf812, 0xf822, 0xf832, 0xf841, 0xf851, 0xf862,
	0xf872, 0xf882, 0xf892, 0xf8a1, 0xf8b1, 0xf8c2, 0xf8d2, 0xf8e2,
	// Entry 3300 - 333F
	0xf8f2, 0xf901, 0xf911, 0xf921, 0xf930, 0xf940, 0xf950, 0xf960,
	0xf96f, 0xf97f, 0xf98f, 0xf99f, 0xf9ae, 0xf9be, 0xf9cf, 0xf9df,
	0xf9ef, 0xf9ff, 0xfa0e, 0xfa1e, 0xfa2f, 0xfa3f, 0xfa4f, 0xfa5f,
	0xfa6e, 0xfa7e, 0xfa8f, 0xfa9f, 0xfab0, 0xfac0, 0xfad0, 0xfadf,
	0xfaef, 0xfaff, 0xfb0f, 0xfb1e, 0xfb2e, 0xfb3e, 0xfb4e, 0xfb5d,
	0xfb6d, 0xfb7e, 0xfb8e, 0xfb9e, 0xfbae, 0xfbbd, 0xfbcd, 0xfbde,
	0xfbee, 0xfbfd, 0xfc0c, 0xfc1a, 0xfc29, 0xfc39, 0xfc48, 0xfc58,
	0xfc67, 0xfc76, 0xfc84, 0xfc93, 0xfca2, 0xfcb0, 0xfcbf, 0xfcce,
	// Entry 3340 - 337F
	0xfcdd, 0xfceb, 0xfcfa, 0xfd0a, 0xfd19, 0xfd28, 0xfd37, 0xfd45,
	0xfd54, 0xfd64, 0xfd73, 0xfd82, 0xfd91, 0xfd9f, 0xfdae, 0xfdbe,
	0xfdce, 0xfddd, 0xfded, 0xfdfd, 0xfe0d, 0xfe1c, 0xfe2c, 0xfe3b,
	0xfe4a, 0xfe58, 0xfe67, 0xfe76, 0xfe85, 0xfe93, 0xfea2, 0xfeb2,
	0xfec1, 0xfed0, 0xfedf, 0xfeed, 0xfefc, 0xff0c, 0xff1b, 0xff2a,
	0xff39, 0xff47, 0xff56, 0xff66, 0xff76, 0xff85, 0xff95, 0xffa5,
	0xffb5, 0xffc4, 0xffd4, 0xffe3, 0xfff2, 0x0000, 0x000f, 0x001e,
	0x002d, 0x003b, 0x004a, 0x005a, 0x0069, 0x0078, 0x0087, 0x0095,
	// Entry 3380 - 33BF
	0x00a4, 0x00b4, 0x00c3, 0x00d3, 0x00e3, 0x00f2, 0x0102, 0x0113,
	0x0124, 0x0134, 0x0145, 0x0156, 0x0166, 0x0177, 0x0187, 0x0197,
	0x01a6, 0x01b6, 0x01c6, 0x01d6, 0x01e5, 0x01f5, 0x0206, 0x0216,
	0x0226, 0x0236, 0x0245, 0x0255, 0x0265, 0x0275, 0x0284, 0x0294,
	0x02a5, 0x02b6, 0x02c6, 0x02d7, 0x02e8, 0x02f8, 0x0308, 0x0318,
	0x0327, 0x0337, 0x0347, 0x0356, 0x0366, 0x0377, 0x0387, 0x0397,
	0x03a7, 0x03b6, 0x03c6, 0x03d7, 0x03e7, 0x03f7, 0x0407, 0x0416,
	0x0426, 0x0437, 0x0448, 0x0458, 0x0469, 0x047a, 0x048a, 0x049b,
	// Entry 33C0 - 33FF
	0x04ab, 0x04bb, 0x04ca, 0x04da, 0x04ea, 0x04fa, 0x0509, 0x0519,
	0x0528, 0x0537, 0x0545, 0x0554, 0x0564, 0x0574, 0x0583, 0x0593,
	0x05a3, 0x05b2, 0x05c1, 0x05d0, 0x05de, 0x05ed, 0x05fc, 0x060b,
	0x0619, 0x0628, 0x0638, 0x0647, 0x0656, 0x0665, 0x0673, 0x0682,
	0x0692, 0x06a2, 0x06b1, 0x06c1, 0x06d1, 0x06e1, 0x06f0, 0x0700,
	0x070f, 0x071e, 0x072c, 0x073b, 0x074a, 0x0759, 0x0767, 0x0776,
	0x0786, 0x0795, 0x07a4, 0x07b3, 0x07c1, 0x07d0, 0x07e0, 0x07ef,
	0x07fd, 0x080a, 0x0818, 0x0827, 0x0835, 0x0843, 0x0852, 0x0860,
	// Entry 3400 - 343F
	0x086d, 0x087c, 0x088a, 0x0899, 0x08a7, 0x08b4, 0x08c2, 0x08d1,
	0x08df, 0x08ec, 0x08fa, 0x0908, 0x0917, 0x0925, 0x0934, 0x0943,
	0x0950, 0x095d, 0x096c, 0x097a, 0x0988, 0x0996, 0x09a4, 0x09b2,
	0x09c0, 0x09ce, 0x09db, 0x09e8, 0x09f7, 0x0a05, 0x0a13, 0x0a22,
	0x0a2f, 0x0a3c, 0x0a4b, 0x0a59, 0x0a66, 0x0a75, 0x0a83, 0x0a92,
	0x0aa1, 0x0aaf, 0x0abe, 0x0acc, 0x0adc, 0x0aeb, 0x0af8, 0x0b06,
	0x0b14, 0x0b23, 0x0b31, 0x0b3f, 0x0b4e, 0x0b5c, 0x0b6a, 0x0b79,
	0x0b87, 0x0b95, 0x0ba4, 0x0bb3, 0x0bc2, 0x0bd2, 0x0be0, 0x0bee,
	// Entry 3440 - 347F
	0x0bfc, 0x0c0a, 0x0c19, 0x0c27, 0x0c36, 0x0c44, 0x0c52, 0x0c61,
	0x0c6f, 0x0c7d, 0x0c8c, 0x0c9a, 0x0ca9, 0x0cb6, 0x0cc4, 0x0cd1,
	0x0cdf, 0x0cec, 0x0cf9, 0x0d06, 0x0d14, 0x0d22, 0x0d30, 0x0d47,
	0x0d5d, 0x0d75, 0x0d8c, 0x0da3, 0x0dbb, 0x0dd1, 0x0deb, 0x0dfa,
	0x0e0a, 0x0e1a, 0x0e2a, 0x0e3b, 0x0e4b, 0x0e5c, 0x0e6c, 0x0e7d,
	0x0e8e, 0x0ea0, 0x0eb1, 0x0ec1, 0x0ed1, 0x0ee1, 0x0ef2, 0x0f03,
	0x0f15, 0x0f25, 0x0f35, 0x0f45, 0x0f56, 0x0f66, 0x0f77, 0x0f87,
	0x0f98, 0x0fa8, 0x0fb8, 0x0fc9, 0x0fd9, 0x0fe9, 0x0ffb, 0x100b,
	// Entry 3480 - 34BF
	0x101b, 0x102b, 0x103c, 0x104a, 0x1059, 0x1068, 0x1078, 0x1087,
	0x1097, 0x10a6, 0x10b6, 0x10c5, 0x10d5, 0x10e5, 0x10f6, 0x1106,
	0x1115, 0x1124, 0x1133, 0x1143, 0x1153, 0x1164, 0x1173, 0x1182,
	0x1191, 0x11a1, 0x11b0, 0x11c0, 0x11cf, 0x11df, 0x11ee, 0x11fd,
	0x120d, 0x121c, 0x122b, 0x123c, 0x124b, 0x125a, 0x1269, 0x1279,
	0x1287, 0x1296, 0x12a7, 0x12b6, 0x12c6, 0x12d5, 0x12e5, 0x12f4,
	0x1304, 0x1313, 0x1323, 0x1333, 0x1344, 0x1355, 0x1365, 0x1374,
	0x1383, 0x1392, 0x13a2, 0x13b2, 0x13c3, 0x13d2, 0x13e1, 0x13f0,
	// Entry 34C0 - 34FF
	0x1400, 0x140f, 0x141f, 0x142e, 0x143e, 0x144d, 0x145c, 0x146c,
	0x147b, 0x148a, 0x149a, 0x14ab, 0x14ba, 0x14c9, 0x14d8, 0x14e8,
	0x14f7, 0x1507, 0x1517, 0x1527, 0x1538, 0x1548, 0x1559, 0x1569,
	0x157a, 0x158b, 0x159d, 0x15ae, 0x15be, 0x15ce, 0x15de, 0x15ef,
	0x1600, 0x1612, 0x1622, 0x1632, 0x1642, 0x1653, 0x1663, 0x1674,
	0x1684, 0x1695, 0x16a5, 0x16b5, 0x16c6, 0x16d6, 0x16e6, 0x16f8,
	0x1708, 0x1718, 0x1728, 0x1739, 0x1747, 0x1756, 0x1765, 0x1775,
	0x1784, 0x1794, 0x17a3, 0x17b3, 0x17c2, 0x17d2, 0x17e2, 0x17f3,
	// Entry 3500 - 353F
	0x1803, 0x1812, 0x1821, 0x1830, 0x1840, 0x1850, 0x1861, 0x1870,
	0x187f, 0x188e, 0x189e, 0x18ad, 0x18bd, 0x18cc, 0x18dc, 0x18eb,
	0x18fa, 0x190a, 0x1919, 0x1928, 0x1939, 0x1948, 0x1957, 0x1966,
	0x1976, 0x1984, 0x1993, 0x19a4, 0x19b3, 0x19c3, 0x19d2, 0x19e2,
	0x19f1, 0x1a01, 0x1a10, 0x1a20, 0x1a30, 0x1a41, 0x1a51, 0x1a62,
	0x1a71, 0x1a80, 0x1a8f, 0x1a9f, 0x1aaf, 0x1ac0, 0x1acf, 0x1ade,
	0x1aed, 0x1afd, 0x1b0c, 0x1b1c, 0x1b2b, 0x1b3b, 0x1b4a, 0x1b59,
	0x1b69, 0x1b78, 0x1b87, 0x1b98, 0x1ba7, 0x1bb6, 0x1bc5, 0x1bd5,
	// Entry 3540 - 357F
	0x1be3, 0x1bf2, 0x1c03, 0x1c12, 0x1c22, 0x1c31, 0x1c41, 0x1c50,
	0x1c60, 0x1c6f, 0x1c7f, 0x1c8f, 0x1ca0, 0x1cb1, 0x1cc1, 0x1cd2,
	0x1ce1, 0x1cf0, 0x1cff, 0x1d0f, 0x1d1f, 0x1d30, 0x1d3f, 0x1d4e,
	0x1d5d, 0x1d6d, 0x1d7c, 0x1d8c, 0x1d9b, 0x1dab, 0x1dba, 0x1dc9,
	0x1dd9, 0x1de8, 0x1df7, 0x1e08, 0x1e1a, 0x1e29, 0x1e39, 0x1e48,
	0x1e57, 0x1e67, 0x1e76, 0x1e8d, 0x1e96, 0x1ea3, 0x1eb4, 0x1ec9,
	0x1ede, 0x1ef4, 0x1f04, 0x1f14, 0x1f23, 0x1f31, 0x1f40, 0x1f4e,
	0x1f5c, 0x1f6b, 0x1f7b, 0x1f8a, 0x1f99, 0x1fa8, 0x1fb7, 0x1fc5,
	// Entry 3580 - 35BF
	0x1fd2, 0x1fdf, 0x1fee, 0x1ffc, 0x200a, 0x2017, 0x2026, 0x2035,
	0x2043, 0x2058, 0x206d, 0x208b, 0x20a7, 0x20c4, 0x20df, 0x2103,
	0x2125, 0x2141, 0x215b, 0x2178, 0x2193, 0x21b7, 0x21d9, 0x21fc,
	0x221d, 0x2240, 0x2261, 0x228b, 0x22b3, 0x22d7, 0x22f9, 0x231c,
	0x233d, 0x235f, 0x237f, 0x23a8, 0x23cf, 0x23f2, 0x2413, 0x2445,
	0x2475, 0x248f, 0x24a7, 0x24cb, 0x24ed, 0x250c, 0x2529, 0x2548,
	0x2565, 0x2584, 0x25a1, 0x25c4, 0x25e5, 0x2608, 0x2629, 0x2653,
	0x267b, 0x2698, 0x26b0, 0x26d4, 0x26fc, 0x2725, 0x2736, 0x275c,
	// Entry 35C0 - 35FF
	0x2777, 0x2793, 0x27ae, 0x27d1, 0x27ef, 0x2812, 0x2831, 0x284a,
	0x2864, 0x2873, 0x2883, 0x289e, 0x28b7, 0x28d3, 0x28ed, 0x2909,
	0x2923, 0x293f, 0x2959, 0x2975, 0x298f, 0x29ba, 0x29e3, 0x29fe,
	0x2a17, 0x2a33, 0x2a4d, 0x2a69, 0x2a83, 0x2a9f, 0x2ab9, 0x2ad4,
	0x2aed, 0x2b09, 0x2b23, 0x2b43, 0x2b61, 0x2b82, 0x2ba1, 0x2bc3,
	0x2be5, 0x2c01, 0x2c25, 0x2c33, 0x2c42, 0x2c50, 0x2c5f, 0x2c6e,
	0x2c7e, 0x2c8e, 0x2c9c, 0x2cac, 0x2cba, 0x2cc9, 0x2cd8, 0x2ce8,
	0x2cf9, 0x2d0b, 0x2d1d, 0x2d2d, 0x2d3e, 0x2d50, 0x2d5e, 0x2d6e,
	// Entry 3600 - 363F
	0x2d7d, 0x2d8e, 0x2d9d, 0x2daf, 0x2dc0, 0x2dd1, 0x2de1, 0x2df2,
	0x2e01, 0x2e13, 0x2e23, 0x2e33, 0x2e43, 0x2e52, 0x2e63, 0x2e74,
	0x2e85, 0x2e96, 0x2ea7, 0x2eb7, 0x2ec7, 0x2ed7, 0x2ee7, 0x2ef6,
	0x2f05, 0x2f14, 0x2f23, 0x2f34, 0x2f44, 0x2f54, 0x2f68, 0x2f79,
	0x2f89, 0x2f99, 0x2faa, 0x2fb9, 0x2fc9, 0x2fd8, 0x2fe7, 0x2ff6,
	0x3005, 0x3015, 0x3024, 0x3035, 0x3045, 0x3055, 0x3064, 0x3073,
	0x3082, 0x3091, 0x30a2, 0x30b2, 0x30c2, 0x30d2, 0x30e3, 0x30f5,
	0x3108, 0x311a, 0x312d, 0x3149, 0x3167, 0x3174, 0x3183, 0x318e,
	// Entry 3640 - 367F
	0x3199, 0x31a8, 0x31bb, 0x31e0, 0x3206, 0x322c, 0x3253, 0x3276,
	0x329a, 0x32bd, 0x32e1, 0x330b, 0x332f, 0x3352, 0x3375, 0x339e,
	0x33d2, 0x3400, 0x342d, 0x345a, 0x348d, 0x34ba, 0x34e1, 0x3507,
	0x352d, 0x3559, 0x3579, 0x3592, 0x35b4, 0x35dc, 0x35fb, 0x361c,
	0x3643, 0x3673, 0x36a0, 0x36c4, 0x36e7, 0x370e, 0x3733, 0x3759,
	0x377d, 0x3796, 0x37ad, 0x37c4, 0x37d9, 0x37f6, 0x3811, 0x382f,
	0x384b, 0x3874, 0x389b, 0x38b7, 0x38d3, 0x38ea, 0x38ff, 0x3916,
	0x392b, 0x3942, 0x3957, 0x396e, 0x3983, 0x39ae, 0x39d7, 0x39ee,
	// Entry 3680 - 36BF
	0x3a03, 0x3a2b, 0x3a51, 0x3a73, 0x3a93, 0x3abe, 0x3ae7, 0x3b1d,
	0x3b51, 0x3b6e, 0x3b89, 0x3bb0, 0x3bd5, 0x3c04, 0x3c31, 0x3c51,
	0x3c6f, 0x3c86, 0x3c9b, 0x3ccf, 0x3d01, 0x3d25, 0x3d47, 0x3d70,
	0x3d97, 0x3dcb, 0x3dfd, 0x3e28, 0x3e51, 0x3e6f, 0x3e8b, 0x3eab,
	0x3ec9, 0x3ef4, 0x3f1d, 0x3f34, 0x3f49, 0x3f6a, 0x3f89, 0x3faf,
	0x3fd3, 0x400b, 0x4041, 0x405a, 0x4071, 0x4088, 0x409d, 0x40b4,
	0x40c9, 0x40e1, 0x40f7, 0x4109, 0x411f, 0x4135, 0x414b, 0x4161,
	0x4177, 0x4195, 0x41ab, 0x41c0, 0x41de, 0x41fa, 0x4218, 0x4234,
	// Entry 36C0 - 36FF
	0x4252, 0x4277, 0x429a, 0x42b7, 0x42d2, 0x42f0, 0x430c, 0x432a,
	0x4346, 0x4364, 0x4380, 0x43a5, 0x43ba, 0x43db, 0x43f8, 0x4413,
	0x4430, 0x4461, 0x447d, 0x44a2, 0x44c5, 0x44e4, 0x4501, 0x4527,
	0x454d, 0x4571, 0x4593, 0x45b5, 0x45d5, 0x45f4, 0x4611, 0x4630,
	0x464d, 0x466c, 0x4689, 0x46b3, 0x46db, 0x4705, 0x472d, 0x4757,
	0x477f, 0x47a9, 0x47d1, 0x47fb, 0x4823, 0x4843, 0x4867, 0x4884,
	0x48a4, 0x48c8, 0x48e4, 0x4901, 0x491e, 0x4946, 0x495e, 0x4977,
	0x498e, 0x49a8, 0x49c0, 0x49e2, 0x4a02, 0x4a20, 0x4a3c, 0x4a5a,
	// Entry 3700 - 373F
	0x4a76, 0x4a94, 0x4ab0, 0x4ad0, 0x4aee, 0x4b16, 0x4b36, 0x4b5e,
	0x4b8e, 0x4bbc, 0x4bec, 0x4c1a, 0x4c3e, 0x4c60, 0x4c82, 0x4ca7,
	0x4cc8, 0x4ceb, 0x4d0d, 0x4d2f, 0x4d51, 0x4d70, 0x4d91, 0x4da6,
	0x4dbb, 0x4dd5, 0x4dea, 0x4dff, 0x4e14, 0x4e2d, 0x4e43, 0x4e5a,
	0x4e70, 0x4e87, 0x4ea1, 0x4eb7, 0x4ece, 0x4ee4, 0x4efb, 0x4f12,
	0x4f2a, 0x4f41, 0x4f59, 0x4f6f, 0x4f86, 0x4f9c, 0x4fb3, 0x4fc9,
	0x4fdf, 0x4ff6, 0x500c, 0x5023, 0x5039, 0x504f, 0x5065, 0x507c,
	0x5092, 0x50a8, 0x50c1, 0x50da, 0x50f3, 0x510c, 0x5126, 0x5140,
	// Entry 3740 - 377F
	0x515a, 0x5174, 0x518e, 0x51b1, 0x51d1, 0x51ee, 0x5211, 0x5233,
	0x5252, 0x5277, 0x528f, 0x52ab, 0x52c1, 0x52da, 0x52ec, 0x52ff,
	0x5311, 0x5324, 0x5336, 0x5349, 0x535b, 0x536e, 0x5380, 0x5393,
	0x53a5, 0x53b7, 0x53c9, 0x53dc, 0x53ee, 0x5400, 0x5413, 0x5427,
	0x543a, 0x544c, 0x545f, 0x5471, 0x5488, 0x549a, 0x54ac, 0x54be,
	0x54d1, 0x54e3, 0x54f5, 0x5506, 0x5517, 0x5528, 0x5539, 0x554a,
	0x555c, 0x556e, 0x5580, 0x5593, 0x55a5, 0x55c1, 0x55dd, 0x55f0,
	0x5604, 0x5617, 0x562a, 0x5646, 0x5663, 0x567c, 0x5698, 0x56b4,
	// Entry 3780 - 37BF
	0x56d1, 0x56ec, 0x5705, 0x571e, 0x5730, 0x5749, 0x5761, 0x5778,
	0x578b, 0x579f, 0x57b2, 0x57c6, 0x57d9, 0x57ed, 0x5808, 0x5824,
	0x583f, 0x585b, 0x586e, 0x5882, 0x5896, 0x58a9, 0x58bd, 0x58d1,
	0x58e5, 0x58fa, 0x590e, 0x5923, 0x5938, 0x594c, 0x5961, 0x5975,
	0x598a, 0x599f, 0x59b4, 0x59ca, 0x59df, 0x59f5, 0x5a0a, 0x5a1e,
	0x5a33, 0x5a47, 0x5a5c, 0x5a70, 0x5a84, 0x5a99, 0x5aad, 0x5ac2,
	0x5ad6, 0x5aea, 0x5afe, 0x5b12, 0x5b26, 0x5b3b, 0x5b50, 0x5b64,
	0x5b78, 0x5b8d, 0x5bac, 0x5bc4, 0x5bdb, 0x5bf3, 0x5c0a, 0x5c22,
	// Entry 37C0 - 37FF
	0x5c41, 0x5c61, 0x5c80, 0x5ca0, 0x5cb7, 0x5ccf, 0x5ce7, 0x5cfe,
	0x5d16, 0x5d2e, 0x5d44, 0x5d5f, 0x5d6f, 0x5d86, 0x5d9b, 0x5daf,
	0x5dc3, 0x5dd9, 0x5dee, 0x5e03, 0x5e17, 0x5e2d, 0x5e43, 0x5e58,
	0x5e77, 0x5e95, 0x5eb3, 0x5ed3, 0x5ef2, 0x5f11, 0x5f2f, 0x5f4f,
	0x5f6f, 0x5f8e, 0x5fab, 0x5fc8, 0x5fe6, 0x6004, 0x6022, 0x6040,
	0x605e, 0x6080, 0x60a3, 0x60c5, 0x60ee, 0x610d, 0x612e, 0x6152,
	0x616a, 0x617f, 0x618f, 0x61a4, 0x61bb, 0x61cd, 0x61e1, 0x61f9,
	0x620c, 0x621e, 0x6230, 0x6244, 0x6257, 0x626a, 0x627c, 0x6290,
	// Entry 3800 - 383F
	0x62a4, 0x62b7, 0x62c9, 0x62dc, 0x62ee, 0x6301, 0x6313, 0x6326,
	0x6338, 0x634b, 0x635d, 0x6370, 0x6382, 0x6394, 0x63a7, 0x63b9,
	0x63cb, 0x63dd, 0x63ef, 0x6401, 0x6413, 0x6425, 0x6438, 0x644a,
	0x645c, 0x646e, 0x647f, 0x6491, 0x64a2, 0x64b4, 0x64c5, 0x64d5,
	0x64e5, 0x64f6, 0x6506, 0x651a, 0x652d, 0x6547, 0x6558, 0x656a,
	0x657a, 0x658a, 0x659b, 0x65ab, 0x65bb, 0x65cb, 0x65db, 0x65eb,
	0x65fb, 0x660b, 0x661b, 0x662c, 0x663c, 0x664c, 0x665c, 0x666c,
	0x667c, 0x668c, 0x669d, 0x66af, 0x66c0, 0x66d2, 0x66e1, 0x66f4,
	// Entry 3840 - 387F
	0x6707, 0x671a, 0x672e, 0x6741, 0x6755, 0x6769, 0x677d, 0x6795,
	0x67ac, 0x67c3, 0x67da, 0x67e7, 0x67fa, 0x6816, 0x6832, 0x684d,
	0x6869, 0x6885, 0x68a6, 0x68c2, 0x68e3, 0x68fe, 0x6919, 0x6939,
	0x695c, 0x6976, 0x6991, 0x69ae, 0x69ca, 0x69e6, 0x6a00, 0x6a22,
	0x6a3f, 0x6a5a, 0x6a79, 0x6a94, 0x6aaf, 0x6acf, 0x6aeb, 0x6b08,
	0x6b22, 0x6b42, 0x6b59, 0x6b6c, 0x6b7f, 0x6b94, 0x6ba5, 0x6bbb,
	0x6bcc, 0x6bde, 0x6bef, 0x6c07, 0x6c20, 0x6c41, 0x6c52, 0x6c64,
	0x6c75, 0x6c87, 0x6c9f, 0x6cb7, 0x6cc9, 0x6ce1, 0x6cf4, 0x6d06,
	// Entry 3880 - 38BF
	0x6d1e, 0x6d30, 0x6d49, 0x6d65, 0x6d78, 0x6d8b, 0x6da8, 0x6dbb,
	0x6dd8, 0x6df0, 0x6e02, 0x6e1a, 0x6e2c, 0x6e48, 0x6e5a, 0x6e6c,
	0x6e84, 0x6e96, 0x6eae, 0x6ec0, 0x6ed2, 0x6ee4, 0x6efc, 0x6f0e,
	0x6f20, 0x6f38, 0x6f54, 0x6f66, 0x6f78, 0x6f90, 0x6faa, 0x6fc4,
	0x6fdc, 0x6ffa, 0x7012, 0x7031, 0x704b, 0x7069, 0x7082, 0x709f,
	0x70be, 0x70db, 0x70eb, 0x7102, 0x711a, 0x712d, 0x7140, 0x7153,
	0x7166, 0x717b, 0x718f, 0x71a3, 0x71b5, 0x71cc, 0x71e1, 0x71fd,
	0x7211, 0x7224, 0x7236, 0x7248, 0x725c, 0x726f, 0x7282, 0x7294,
	// Entry 38C0 - 38FF
	0x72a8, 0x72bc, 0x72cf, 0x72ea, 0x7301, 0x7318, 0x732f, 0x7346,
	0x735d, 0x7374, 0x7389, 0x73b3, 0x73cf, 0x73ea, 0x7405, 0x7421,
	0x743c, 0x7458, 0x7474, 0x7491, 0x74ad, 0x74c9, 0x74e4, 0x74ff,
	0x751c, 0x7538, 0x7554, 0x756f, 0x758c, 0x75a9, 0x75c5, 0x75e1,
	0x75fc, 0x7618, 0x7633, 0x764f, 0x765c, 0x7669, 0x7676, 0x7683,
	0x7691, 0x769e, 0x76ac, 0x76bb, 0x76c9, 0x76d8, 0x76e8, 0x76f7,
	0x7706, 0x7716, 0x7724, 0x7733, 0x7743, 0x7752, 0x7762, 0x7770,
	0x777f, 0x778d, 0x779c, 0x77ab, 0x77b9, 0x77c8, 0x77d6, 0x77e5,
	// Entry 3900 - 393F
	0x77f4, 0x7802, 0x7811, 0x7820, 0x782e, 0x783d, 0x784b, 0x7859,
	0x7867, 0x7875, 0x7884, 0x7892, 0x78a0, 0x78b2, 0x78c3, 0x78d5,
	0x78e7, 0x78f8, 0x790a, 0x791b, 0x792d, 0x793f, 0x7951, 0x7967,
	0x797d, 0x7993, 0x79a9, 0x79bc, 0x79cf, 0x79e3, 0x79ff, 0x7a13,
	0x7a26, 0x7a39, 0x7a4c, 0x7a5f, 0x7a72, 0x7a85, 0x7a99, 0x7ab4,
	0x7acf, 0x7ade, 0x7aec, 0x7afa, 0x7b0a, 0x7b19, 0x7b28, 0x7b36,
	0x7b46, 0x7b56, 0x7b65, 0x7b7c, 0x7b92, 0x7baf, 0x7bcc, 0x7be4,
	0x7bfc, 0x7c15, 0x7c2d, 0x7c46, 0x7c5f, 0x7c78, 0x7c92, 0x7cab,
	// Entry 3940 - 397F
	0x7cc5, 0x7cde, 0x7cf6, 0x7d0e, 0x7d26, 0x7d3f, 0x7d57, 0x7d83,
	0x7d9b, 0x7db3, 0x7dcb, 0x7de6, 0x7e00, 0x7e1a, 0x7e3a, 0x7e52,
	0x7e6a, 0x7e81, 0x7e9c, 0x7eb9, 0x7ed6, 0x7ef5, 0x7f14, 0x7f2a,
	0x7f41, 0x7f58, 0x7f70, 0x7f88, 0x7fa1, 0x7fb7, 0x7fce, 0x7fe5,
	0x7ffd, 0x8013, 0x802a, 0x8041, 0x8059, 0x806f, 0x8086, 0x809d,
	0x80b5, 0x80cb, 0x80e2, 0x80f8, 0x810f, 0x8126, 0x813e, 0x8154,
	0x816b, 0x8181, 0x8198, 0x81ae, 0x81c5, 0x81dc, 0x81f4, 0x820a,
	0x8221, 0x8237, 0x824e, 0x8264, 0x827b, 0x8291, 0x82a8, 0x82be,
	// Entry 3980 - 39BF
	0x82d5, 0x82eb, 0x8302, 0x8318, 0x832f, 0x8344, 0x835a, 0x836b,
	0x837c, 0x838c, 0x839d, 0x83ad, 0x83bd, 0x83cd, 0x83de, 0x83ef,
	0x8401, 0x8412, 0x8424, 0x8435, 0x8446, 0x8457, 0x846b, 0x8482,
	0x8497, 0x84ad, 0x84c0, 0x84d5, 0x84e8, 0x84fe, 0x8515, 0x852a,
	0x853f, 0x8556, 0x856d, 0x8584, 0x859c, 0x85b3, 0x85cb, 0x85e2,
	0x85f9, 0x8610, 0x862a, 0x8644, 0x865f, 0x8679, 0x8694, 0x86a9,
	0x86c2, 0x86d3, 0x86f8, 0x8719, 0x8738, 0x874b, 0x8761, 0x8777,
	0x878e, 0x87a5, 0x87bb, 0x87d1, 0x87e7, 0x87fd, 0x8814, 0x882b,
	// Entry 39C0 - 39FF
	0x8841, 0x8857, 0x886c, 0x8881, 0x8897, 0x88ad, 0x88c2, 0x88d7,
	0x88ee, 0x8905, 0x891c, 0x8934, 0x894c, 0x8963, 0x897a, 0x898f,
	0x89a4, 0x89b9, 0x89cf, 0x89e5, 0x89fa, 0x8a0f, 0x8a2e, 0x8a51,
	0x8a71, 0x8a8c, 0x8aae, 0x8ac8, 0x8af5, 0x8b1e, 0x8b4b, 0x8b70,
	0x8b96, 0x8bbc, 0x8be4, 0x8c04, 0x8c30, 0x8c55, 0x8c73, 0x8c9b,
	0x8cce, 0x8cf0, 0x8d1e, 0x8d3a, 0x8d65, 0x8d88, 0x8da3, 0x8dc9,
	0x8df6, 0x8e11, 0x8e36, 0x8e55, 0x8e7e, 0x8eab, 0x8ec0, 0x8edc,
	0x8eff, 0x8f15, 0x8f3f, 0x8f69, 0x8f91, 0x8fb8, 0x8ff2, 0x9024,
	// Entry 3A00 - 3A3F
	0x904d, 0x906f, 0x9089, 0x90b5, 0x90de, 0x9104, 0x9120, 0x913d,
	0x9157, 0x916c, 0x918d, 0x91ad, 0x91de, 0x920f, 0x923c, 0x925a,
	0x9273, 0x928d, 0x92a4, 0x92bb, 0x92d2, 0x92e9, 0x9300, 0x9317,
	0x932f, 0x9347, 0x935f, 0x9377, 0x938f, 0x93a7, 0x93bf, 0x93d7,
	0x93ef, 0x9407, 0x941f, 0x9437, 0x944f, 0x9467, 0x947f, 0x9497,
	0x94af, 0x94c7, 0x94df, 0x94f7, 0x950f, 0x9527, 0x953f, 0x9557,
	0x956f, 0x9588, 0x95a1, 0x95b9, 0x95d1, 0x95e9, 0x9601, 0x9619,
	0x9632, 0x964b, 0x9664, 0x967d, 0x9696, 0x96af, 0x96c7, 0x96de,
	// Entry 3A40 - 3A7F
	0x96f6, 0x970e, 0x9726, 0x973e, 0x9756, 0x976e, 0x9786, 0x979e,
	0x97b6, 0x97ce, 0x97e6, 0x97fe, 0x9816, 0x982e, 0x9847, 0x9860,
	0x9879, 0x9892, 0x98ab, 0x98c4, 0x98dd, 0x98f6, 0x990f, 0x9928,
	0x9941, 0x995a, 0x9973, 0x998b, 0x99a3, 0x99bb, 0x99d3, 0x99eb,
	0x9a03, 0x9a1b, 0x9a32, 0x9a49, 0x9a60, 0x9a77, 0x9a8d, 0x9aa3,
	0x9abb, 0x9ad2, 0x9aea, 0x9b02, 0x9b1a, 0x9b31, 0x9b49, 0x9b60,
	0x9b76, 0x9b8b, 0x9ba3, 0x9bbc, 0x9bd3, 0x9beb, 0x9c02, 0x9c18,
	0x9c2f, 0x9c46, 0x9c5e, 0x9c76, 0x9c8e, 0x9cac, 0x9cca, 0x9ce8,
	// Entry 3A80 - 3ABF
	0x9d05, 0x9d22, 0x9d40, 0x9d5f, 0x9d7b, 0x9d97, 0x9db3, 0x9dcf,
	0x9dec, 0x9e0a, 0x9e26, 0x9e45, 0x9e61, 0x9e76, 0x9e8b, 0x9ea1,
	0x9eb8, 0x9ece, 0x9ee4, 0x9efc, 0x9f13, 0x9f2a, 0x9f40, 0x9f58,
	0x9f70, 0x9f87, 0x9f9d, 0x9fb3, 0x9fc8, 0x9fde, 0x9ff4, 0xa00a,
	0xa020, 0xa036, 0xa04b, 0xa060, 0xa076, 0xa08b, 0xa0a0, 0xa0b7,
	0xa0cd, 0xa0e3, 0xa0f8, 0xa10e, 0xa123, 0xa138, 0xa14c, 0xa164,
	0xa17c, 0xa198, 0xa1b6, 0xa1d2, 0xa1f4, 0xa211, 0xa22d, 0xa250,
	0xa26d, 0xa28c, 0xa2ab, 0xa2cd, 0xa2f0, 0xa313, 0xa335, 0xa358,
	// Entry 3AC0 - 3AFF
	0xa37c, 0xa39b, 0xa3c3, 0xa3e1, 0xa3fd, 0xa41e, 0xa439, 0xa45a,
	0xa476, 0xa493, 0xa4b7, 0xa4d3, 0xa4ee, 0xa510, 0xa52c, 0xa54a,
	0xa565, 0xa588, 0xa5a9, 0xa5ca, 0xa5e7, 0xa602, 0xa61f, 0xa63c,
	0xa657, 0xa675, 0xa69b, 0xa6ba, 0xa6d9, 0xa6f5, 0xa716, 0xa731,
	0xa74e, 0xa76e, 0xa78e, 0xa7ae, 0xa7ce, 0xa7ee, 0xa80e, 0xa82e,
	0xa84e, 0xa86e, 0xa88e, 0xa8ae, 0xa8ce, 0xa8ee, 0xa90e, 0xa92e,
	0xa94e, 0xa96e, 0xa98e, 0xa9ae, 0xa9ce, 0xa9ee, 0xaa0e, 0xaa2e,
	0xaa4e, 0xaa6e, 0xaa8e, 0xaaae, 0xaace, 0xaaee, 0xab0e, 0xab2e,
	// Entry 3B00 - 3B3F
	0xab4e, 0xab6e, 0xab8e, 0xabae, 0xabce, 0xabee, 0xac0e, 0xac2e,
	0xac4e, 0xac6e, 0xac8e, 0xacae, 0xacce, 0xacee, 0xad0e, 0xad2e,
	0xad4e, 0xad6e, 0xad8e, 0xadae, 0xadce, 0xadee, 0xae0e, 0xae2e,
	0xae4e, 0xae6e, 0xae8e, 0xaeae, 0xaece, 0xaeee, 0xaf0e, 0xaf2e,
	0xaf4e, 0xaf6e, 0xaf8e, 0xafae, 0xafce, 0xafee, 0xb00e, 0xb02e,
	0xb04e, 0xb06e, 0xb08e, 0xb0ae, 0xb0ce, 0xb0ee, 0xb10e, 0xb12e,
	0xb14e, 0xb16e, 0xb18e, 0xb1ae, 0xb1ce, 0xb1ee, 0xb20e, 0xb22e,
	0xb24e, 0xb26e, 0xb28e, 0xb2ae, 0xb2ce, 0xb2ee, 0xb30e, 0xb32e,
	// Entry 3B40 - 3B7F
	0xb34e, 0xb36e, 0xb38e, 0xb3ae, 0xb3ce, 0xb3ee, 0xb40e, 0xb42e,
	0xb44e, 0xb46e, 0xb48e, 0xb4ae, 0xb4ce, 0xb4ee, 0xb50e, 0xb52e,
	0xb54e, 0xb56e, 0xb58e, 0xb5ae, 0xb5ce, 0xb5ee, 0xb60e, 0xb62e,
	0xb64e, 0xb66e, 0xb68e, 0xb6ae, 0xb6ce, 0xb6ee, 0xb70e, 0xb72e,
	0xb74e, 0xb76e, 0xb78e, 0xb7ae, 0xb7ce, 0xb7ee, 0xb80e, 0xb82e,
	0xb84e, 0xb86e, 0xb88e, 0xb8ae, 0xb8ce, 0xb8ee, 0xb90e, 0xb92e,
	0xb94e, 0xb96e, 0xb98e, 0xb9ae, 0xb9ce, 0xb9ee, 0xba0e, 0xba2e,
	0xba4e, 0xba6e, 0xba8e, 0xbaae, 0xbace, 0xbaee, 0xbb0e, 0xbb2e,
	// Entry 3B80 - 3BBF
	0xbb4e, 0xbb6e, 0xbb8e, 0xbbae, 0xbbce, 0xbbee, 0xbc0e, 0xbc2e,
	0xbc4e, 0xbc6e, 0xbc8e, 0xbcae, 0xbcce, 0xbcee, 0xbd0e, 0xbd2e,
	0xbd4e, 0xbd6e, 0xbd8e, 0xbdae, 0xbdce, 0xbdee, 0xbe0e, 0xbe2e,
	0xbe4e, 0xbe6e, 0xbe8e, 0xbeae, 0xbece, 0xbeee, 0xbf0e, 0xbf2e,
	0xbf4e, 0xbf6e, 0xbf8e, 0xbfae, 0xbfce, 0xbfee, 0xc00e, 0xc02e,
	0xc04e, 0xc06e, 0xc08e, 0xc0ae, 0xc0ce, 0xc0ee, 0xc10e, 0xc12e,
	0xc14e, 0xc16e, 0xc18e, 0xc1ae, 0xc1ce, 0xc1ee, 0xc20e, 0xc22e,
	0xc24e, 0xc26e, 0xc28e, 0xc2ae, 0xc2ce, 0xc2ee, 0xc30e, 0xc32e,
	// Entry 3BC0 - 3BFF
	0xc34e, 0xc36e, 0xc38e, 0xc3ae, 0xc3ce, 0xc3ee, 0xc40e, 0xc42e,
	0xc44e, 0xc46e, 0xc48e, 0xc4ae, 0xc4ce, 0xc4ee, 0xc50e, 0xc52e,
	0xc54e, 0xc56e, 0xc58e, 0xc5ae, 0xc5ce, 0xc5ee, 0xc60e, 0xc62e,
	0xc64e, 0xc66e, 0xc68e, 0xc6ae, 0xc6ce, 0xc6ee, 0xc70e, 0xc72e,
	0xc74e, 0xc76e, 0xc78e, 0xc7ae, 0xc7ce, 0xc7ee, 0xc80e, 0xc82e,
	0xc84e, 0xc86e, 0xc88e, 0xc8ae, 0xc8ce, 0xc8ee, 0xc90e, 0xc92e,
	0xc94e, 0xc96e, 0xc98e, 0xc9ae, 0xc9ce, 0xc9ee, 0xca0e, 0xca2e,
	0xca4e, 0xca6e, 0xca8e, 0xcaae, 0xcace, 0xcaee, 0xcb0e, 0xcb2e,
	// Entry 3C00 - 3C3F
	0xcb4e, 0xcb6e, 0xcb8e, 0xcbae, 0xcbce, 0xcbee, 0xcc0e, 0xcc2e,
	0xcc4e, 0xcc6e, 0xcc8e, 0xccae, 0xccce, 0xccee, 0xcd0e, 0xcd2e,
	0xcd4e, 0xcd6e, 0xcd8e, 0xcdae, 0xcdce, 0xcdee, 0xce0e, 0xce2e,
	0xce4e, 0xce6e, 0xce8e, 0xceae, 0xcece, 0xceee, 0xcf0e, 0xcf2e,
	0xcf4e, 0xcf6e, 0xcf8e, 0xcfae, 0xcfce, 0xcfee, 0xd00e, 0xd02e,
	0xd04e, 0xd06e, 0xd08e, 0xd0ae, 0xd0ce, 0xd0ee, 0xd10e, 0xd12e,
	0xd14e, 0xd16e, 0xd18e, 0xd1ae, 0xd1ce, 0xd1ee, 0xd20e, 0xd22e,
	0xd24e, 0xd26e, 0xd28e, 0xd2ae, 0xd2ce, 0xd2ee, 0xd30e, 0xd32e,
	// Entry 3C40 - 3C7F
	0xd34e, 0xd36e, 0xd38e, 0xd3ae, 0xd3ce, 0xd3ee, 0xd40e, 0xd42e,
	0xd44e, 0xd46e, 0xd48e, 0xd4ae, 0xd4ce, 0xd4ee, 0xd50e, 0xd52e,
	0xd54e, 0xd56e, 0xd58e, 0xd5ae, 0xd5ce, 0xd5ee, 0xd60e, 0xd62e,
	0xd64e, 0xd66e, 0xd68e, 0xd6ae, 0xd6ce, 0xd6ee, 0xd70e, 0xd72e,
	0xd74e, 0xd76e, 0xd78e, 0xd7ae, 0xd7ce, 0xd7ee, 0xd80e, 0xd82e,
	0xd84e, 0xd86e, 0xd88e, 0xd8ae, 0xd8ce, 0xd8ee, 0xd90e, 0xd92e,
	0xd94e, 0xd96e, 0xd98e, 0xd9ae, 0xd9ce, 0xd9ee, 0xda0e, 0xda2e,
	0xda4e, 0xda6e, 0xda8e, 0xdaae, 0xdace, 0xdaee, 0xdb0e, 0xdb2e,
	// Entry 3C80 - 3CBF
	0xdb4e, 0xdb6e, 0xdb8e, 0xdbae, 0xdbce, 0xdbee, 0xdc0e, 0xdc2e,
	0xdc4e, 0xdc6e, 0xdc8e, 0xdcae, 0xdcce, 0xdcee, 0xdd0e, 0xdd2e,
	0xdd4e, 0xdd6e, 0xdd8e, 0xddae, 0xddce, 0xddee, 0xde0e, 0xde2e,
	0xde4e, 0xde6e, 0xde8e, 0xdeae, 0xdece, 0xdeee, 0xdf0e, 0xdf2e,
	0xdf4e, 0xdf6e, 0xdf8e, 0xdfae, 0xdfce, 0xdfee, 0xe00e, 0xe02e,
	0xe04e, 0xe06e, 0xe08e, 0xe0ae, 0xe0ce, 0xe0ee, 0xe10e, 0xe12e,
	0xe14e, 0xe16e, 0xe18e, 0xe1ae, 0xe1ce, 0xe1ee, 0xe20e, 0xe22e,
	0xe24e, 0xe26e, 0xe285, 0xe29c, 0xe2b3, 0xe2cb, 0xe2e3, 0xe300,
	// Entry 3CC0 - 3CFF
	0xe317, 0xe336, 0xe355, 0xe374, 0xe393, 0xe3b2, 0xe3ce, 0xe3ef,
	0xe414, 0xe432, 0xe449, 0xe461, 0xe476, 0xe48c, 0xe4a4, 0xe4c0,
	0xe4d7, 0xe4ed, 0xe510, 0xe530, 0xe54f, 0xe57a, 0xe5a4, 0xe5c1,
	0xe5df, 0xe5fc, 0xe619, 0xe638, 0xe657, 0xe672, 0xe68f, 0xe6ae,
	0xe6cb, 0xe6e8, 0xe70b, 0xe728, 0xe747, 0xe764, 0xe781, 0xe7a1,
	0xe7c3, 0xe7df, 0xe7fe, 0xe81b, 0xe839, 0xe857, 0xe874, 0xe890,
	0xe8ab, 0xe8c6, 0xe8e0, 0xe8fa, 0xe920, 0xe943, 0xe963, 0xe980,
	0xe99f, 0xe9bd, 0xe9dc, 0xe9f8, 0xea16, 0xea33, 0xea54, 0xea72,
	// Entry 3D00 - 3D3F
	0xea92, 0xeab1, 0xead3, 0xeaf2, 0xeb13, 0xeb33, 0xeb54, 0xeb72,
	0xeb92, 0xebb1, 0xebd1, 0xebee, 0xec0d, 0xec2b, 0xec4a, 0xec66,
	0xec84, 0xeca1, 0xecc2, 0xece0, 0xed00, 0xed1f, 0xed3f, 0xed5c,
	0xed7b, 0xed99, 0xedb9, 0xedd6, 0xedf5, 0xee13, 0xee34, 0xee52,
	0xee72, 0xee91, 0xeeb4, 0xeed4, 0xeef6, 0xef17, 0xef39, 0xef58,
	0xef79, 0xef97, 0xefb6, 0xefd2, 0xeff2, 0xf00f, 0xf02e, 0xf04a,
	0xf06a, 0xf087, 0xf0a8, 0xf0c6, 0xf0e6, 0xf105, 0xf124, 0xf140,
	0xf15e, 0xf17b, 0xf19b, 0xf1b8, 0xf1d7, 0xf1f5, 0xf216, 0xf234,
	// Entry 3D40 - 3D7F
	0xf254, 0xf273, 0xf29a, 0xf2be, 0xf2df, 0xf2fd, 0xf31d, 0xf33c,
	0xf36a, 0xf395, 0xf3b9, 0xf3da, 0xf3fd, 0xf41f, 0xf44a, 0xf472,
	0xf49c, 0xf4c5, 0xf4eb, 0xf50e, 0xf545, 0xf579, 0xf590, 0xf5a7,
	0xf5c3, 0xf5df, 0xf5fd, 0xf61b, 0xf64c, 0xf67d, 0xf69a, 0xf6b7,
	0xf6de, 0xf705, 0xf72c, 0xf73e, 0xf75b, 0xf778, 0xf796, 0xf7b1,
	0xf7ce, 0xf7ea, 0xf807, 0xf821, 0xf83f, 0xf85a, 0xf878, 0xf893,
	0xf8c1, 0xf8df, 0xf8fa, 0xf920, 0xf943, 0xf969, 0xf98c, 0xf9a9,
	0xf9c3, 0xf9df, 0xf9fa, 0xfa37, 0xfa73, 0xfaaf, 0xfae8, 0xfb22,
	// Entry 3D80 - 3DBF
	0xfb59, 0xfb94, 0xfbcc, 0xfc05, 0xfc3b, 0xfc75, 0xfcac, 0xfce6,
	0xfd1d, 0xfd56, 0xfd8c, 0xfdc4, 0xfe17, 0xfe67, 0xfeb9, 0xfede,
	0xff00, 0xff24, 0xff47, 0xff83, 0xffbe, 0xfffa, 0x003e, 0x0079,
	0x00a4, 0x00ce, 0x00f9, 0x0124, 0x0157, 0x0181, 0x01ac, 0x01d6,
	0x0201, 0x022c, 0x025f, 0x0289, 0x02b5, 0x02e1, 0x0315, 0x0340,
	0x036b, 0x0397, 0x03c2, 0x03ed, 0x0419, 0x0444, 0x0470, 0x049c,
	0x04c7, 0x04f3, 0x051f, 0x0549, 0x0574, 0x059f, 0x05c9, 0x05f4,
	0x061f, 0x0649, 0x0674, 0x069f, 0x06ca, 0x06f5, 0x0722, 0x074f,
	// Entry 3DC0 - 3DFF
	0x077a, 0x07a4, 0x07cf, 0x07fa, 0x082d, 0x0857, 0x0881, 0x08ac,
	0x08df, 0x0909, 0x0934, 0x095f, 0x0989, 0x09b4, 0x09de, 0x0a09,
	0x0a3c, 0x0a66, 0x0a91, 0x0abb, 0x0ae6, 0x0b11, 0x0b44, 0x0b6e,
	0x0b9a, 0x0bc5, 0x0bf1, 0x0c1d, 0x0c51, 0x0c7c, 0x0ca8, 0x0cd3,
	0x0cff, 0x0d2b, 0x0d5f, 0x0d8a, 0x0db5, 0x0de0, 0x0e13, 0x0e3d,
	0x0e68, 0x0e92, 0x0ebd, 0x0ee8, 0x0f1b, 0x0f45, 0x0f7d, 0x0fb4,
	0x0ff4, 0x1026, 0x1058, 0x1087, 0x10b6, 0x10e5, 0x111f, 0x1157,
	0x1190, 0x11c9, 0x1202, 0x1243, 0x127b, 0x12a2, 0x12ca, 0x12f2,
	// Entry 3E00 - 3E3F
	0x131a, 0x134a, 0x1371, 0x1398, 0x13c0, 0x13e8, 0x1410, 0x1440,
	0x1467, 0x148f, 0x14b8, 0x14e1, 0x150a, 0x153b, 0x1563, 0x1593,
	0x15ba, 0x15ea, 0x1611, 0x1639, 0x1660, 0x1688, 0x16b8, 0x16df,
	0x1707, 0x1737, 0x175e, 0x1787, 0x17b0, 0x17d8, 0x1801, 0x182a,
	0x1853, 0x1884, 0x18ac, 0x18e9, 0x1910, 0x1938, 0x1960, 0x1988,
	0x19b8, 0x19df, 0x1a1a, 0x1a54, 0x1a8f, 0x1aca, 0x1b04, 0x1b2e,
	0x1b57, 0x1b81, 0x1bab, 0x1bd4, 0x1bfe, 0x1c27, 0x1c51, 0x1c7b,
	0x1ca4, 0x1ccf, 0x1cf9, 0x1d24, 0x1d4e, 0x1d78, 0x1da3, 0x1dce,
	// Entry 3E40 - 3E7F
	0x1df9, 0x1e23, 0x1e4e, 0x1e79, 0x1ea2, 0x1ecc, 0x1ef6, 0x1f20,
	0x1f49, 0x1f73, 0x1f9d, 0x1fc6, 0x1ff0, 0x201a, 0x2044, 0x2070,
	0x209c, 0x20c6, 0x20ef, 0x2119, 0x2143, 0x216c, 0x2196, 0x21c0,
	0x21e9, 0x2213, 0x223c, 0x2266, 0x2290, 0x22b9, 0x22e3, 0x230d,
	0x2336, 0x2361, 0x238b, 0x23b6, 0x23e1, 0x240c, 0x2436, 0x2461,
	0x248c, 0x24b6, 0x24e0, 0x250a, 0x2540, 0x256a, 0x2593, 0x25bd,
	0x25e7, 0x2610, 0x264a, 0x2683, 0x26ac, 0x26d4, 0x26fd, 0x2725,
	0x274f, 0x2778, 0x27a2, 0x27cb, 0x27f6, 0x2820, 0x2848, 0x2871,
	// Entry 3E80 - 3EBF
	0x289a, 0x28c4, 0x28ed, 0x2916, 0x293e, 0x296b, 0x2998, 0x29c5,
	0x29f8, 0x2a22, 0x2a55, 0x2a7f, 0x2ab4, 0x2ae0, 0x2b14, 0x2b3f,
	0x2b74, 0x2ba0, 0x2bd3, 0x2bfd, 0x2c31, 0x2c5c, 0x2c90, 0x2cbb,
	0x2cee, 0x2d18, 0x2d4b, 0x2d75, 0x2da2, 0x2dce, 0x2dfb, 0x2e28,
	0x2e54, 0x2e7f, 0x2ea9, 0x2ed3, 0x2f03, 0x2f2a, 0x2f5a, 0x2f81,
	0x2fb3, 0x2fdc, 0x300d, 0x3035, 0x3067, 0x3090, 0x30c0, 0x30e7,
	0x3118, 0x3140, 0x3171, 0x3199, 0x31c9, 0x31f0, 0x3220, 0x3247,
	0x3271, 0x329a, 0x32c4, 0x32ee, 0x3317, 0x333f, 0x3366, 0x338d,
	// Entry 3EC0 - 3EFF
	0x33b9, 0x33e4, 0x3410, 0x343c, 0x3466, 0x3491, 0x34bb, 0x34e5,
	0x350e, 0x3538, 0x3563, 0x358d, 0x35b8, 0x35e1, 0x360a, 0x3637,
	0x3667, 0x367e, 0x3696, 0x36ca, 0x36fb, 0x372e, 0x3761, 0x3795,
	0x37c9, 0x37fc, 0x3830, 0x3862, 0x3896, 0x38c7, 0x3901, 0x3935,
	0x3969, 0x39a4, 0x39d6, 0x3a0a, 0x3a3f, 0x3a72, 0x3aa7, 0x3ad7,
	0x3b09, 0x3b3b, 0x3b6e, 0x3ba3, 0x3bd6, 0x3c0a, 0x3c40, 0x3c74,
	0x3caa, 0x3ce3, 0x3d15, 0x3d49, 0x3d7a, 0x3dad, 0x3de1, 0x3e12,
	0x3e44, 0x3e76, 0x3eaa, 0x3ee4, 0x3f18, 0x3f4b, 0x3f87, 0x3fb9,
	// Entry 3F00 - 3F3F
	0x3fed, 0x401e, 0x4050, 0x4081, 0x40b1, 0x40ea, 0x411e, 0x4150,
	0x4182, 0x41b6, 0x41e7, 0x421a, 0x424e, 0x4282, 0x42b3, 0x42e7,
	0x431c, 0x4351, 0x4386, 0x43bb, 0x43ef, 0x4423, 0x4457, 0x4491,
	0x44c4, 0x44f9, 0x4534, 0x4566, 0x45a1, 0x45d3, 0x4607, 0x4638,
	0x4669, 0x46a3, 0x46d4, 0x470e, 0x473f, 0x4779, 0x47ab, 0x47e5,
	0x4820, 0x485b, 0x488b, 0x48bd, 0x48ed, 0x491e, 0x494f, 0x497f,
	0x49b0, 0x49e1, 0x4a13, 0x4a44, 0x4a75, 0x4aa8, 0x4adb, 0x4b0c,
	0x4b3d, 0x4b71, 0x4ba3, 0x4bd7, 0x4c09, 0x4c3b, 0x4c6d, 0x4c9e,
	// Entry 3F40 - 3F7F
	0x4ccf, 0x4d01, 0x4d32, 0x4d62, 0x4d96, 0x4dca, 0x4dfe, 0x4e30,
	0x4e62, 0x4e9f, 0x4edb, 0x4efe, 0x4f21, 0x4f47, 0x4f6a, 0x4f8e,
	0x4fb2, 0x4fd8, 0x4ffb, 0x5026, 0x5045, 0x504e, 0x507b, 0x508f,
	0x50a3, 0x50b7, 0x50cb, 0x50df, 0x50f3, 0x5107, 0x511b, 0x512f,
	0x5144, 0x5159, 0x516e, 0x5183, 0x5198, 0x51ad, 0x51c2, 0x51e6,
	0x5216, 0x524a, 0x526e, 0x5296, 0x52c5, 0x52f1, 0x532d, 0x536a,
	0x539c, 0x53b8, 0x53d5, 0x53f5, 0x5416, 0x5430, 0x544b, 0x5466,
	0x5488, 0x54ab, 0x54ca, 0x54ea, 0x550a, 0x552b, 0x554c, 0x556e,
	// Entry 3F80 - 3FBF
	0x5591, 0x55be, 0x55e4, 0x560a, 0x5631, 0x565d, 0x568c, 0x56bc,
	0x56ed, 0x571f, 0x5759, 0x5794, 0x57d0, 0x580d, 0x5845, 0x587e,
	0x58af, 0x58e1, 0x5913, 0x5946, 0x597e, 0x59b7, 0x59c1, 0x59d1,
	0x5a03, 0x5a36, 0x5a45, 0x5a58, 0x5a65, 0x5a79, 0x5a88, 0x5a9b,
	0x5aa8, 0x5ab3, 0x5aca, 0x5ad9, 0x5ae8, 0x5af3, 0x5b06, 0x5b1c,
	0x5b29, 0x5b3f, 0x5b56, 0x5b6e, 0x5b87, 0x5ba8, 0x5bca, 0x5bdb,
	0x5bea, 0x5bf8, 0x5c07, 0x5c19, 0x5c2d, 0x5c44, 0x5c55, 0x5c6a,
	0x5c7b, 0x5c8d, 0x5ca0, 0x5cbd, 0x5cdf, 0x5cfc, 0x5d10, 0x5d2d,
	// Entry 3FC0 - 3FFF
	0x5d47, 0x5d5f, 0x5d79, 0x5d91, 0x5dab, 0x5dc3, 0x5dde, 0x5df7,
	0x5e11, 0x5e29, 0x5e4a, 0x5e7b, 0x5ea9, 0x5eda, 0x5f08, 0x5f38,
	0x5f65, 0x5f96, 0x5fc4, 0x5ff4, 0x6021, 0x6050, 0x607e, 0x609e,
	0x60bb, 0x60da, 0x60f6, 0x6114, 0x6131, 0x6158, 0x617c, 0x619b,
	0x61b7, 0x61d5, 0x61f2, 0x6212, 0x622f, 0x624e, 0x626c, 0x628c,
	0x62a9, 0x62c8, 0x62e6, 0x6305, 0x6321, 0x633f, 0x635c, 0x637c,
	0x6399, 0x63b8, 0x63d6, 0x63f5, 0x6411, 0x6431, 0x644e, 0x646d,
	0x6489, 0x64a9, 0x64c6, 0x64e6, 0x6503, 0x6522, 0x6540, 0x6561,
	// Entry 4000 - 403F
	0x657f, 0x659f, 0x65be, 0x65dd, 0x65f9, 0x6617, 0x6634, 0x6653,
	0x666f, 0x668d, 0x66aa, 0x66c9, 0x66e5, 0x6703, 0x6720, 0x673f,
	0x675b, 0x6779, 0x6796, 0x67b5, 0x67d1, 0x67ef, 0x680c, 0x682d,
	0x684b, 0x686b, 0x688a, 0x68a9, 0x68c5, 0x68e3, 0x6900, 0x691f,
	0x693b, 0x6959, 0x6976, 0x6995, 0x69b1, 0x69cf, 0x69ec, 0x6a0b,
	0x6a27, 0x6a45, 0x6a62, 0x6a82, 0x6a9f, 0x6abe, 0x6adc, 0x6afc,
	0x6b19, 0x6b38, 0x6b56, 0x6b75, 0x6b91, 0x6baf, 0x6bcc, 0x6beb,
	0x6c07, 0x6c2f, 0x6c54, 0x6c73, 0x6c8f, 0x6cad, 0x6cca, 0x6d06,
	// Entry 4040 - 407F
	0x6d3f, 0x6d7b, 0x6db4, 0x6df0, 0x6e29, 0x6e54, 0x6e7c, 0x6e95,
	0x6eaf, 0x6ec7, 0x6edc, 0x6ef1, 0x6f07, 0x6f1a, 0x6f2e, 0x6f48,
	0x6f63, 0x6f75, 0x6f88, 0x6f97, 0x6fad, 0x6fc0, 0x6fd1, 0x6fe5,
	0x6ff8, 0x700b, 0x7020, 0x7034, 0x7048, 0x705b, 0x7070, 0x7085,
	0x7099, 0x70a8, 0x70bb, 0x70d3, 0x70e8, 0x7103, 0x711a, 0x7131,
	0x7151, 0x7171, 0x7191, 0x71b1, 0x71d1, 0x71f1, 0x7211, 0x7231,
	0x7251, 0x7271, 0x7291, 0x72b1, 0x72d1, 0x72f1, 0x7311, 0x7331,
	0x7351, 0x7371, 0x7391, 0x73b1, 0x73d1, 0x73f1, 0x7411, 0x7431,
	// Entry 4080 - 40BF
	0x7451, 0x7471, 0x748e, 0x74a7, 0x74c5, 0x74e0, 0x74f2, 0x7508,
	0x7526, 0x7544, 0x7562, 0x7580, 0x759e, 0x75bc, 0x75da, 0x75f8,
	0x7616, 0x7634, 0x7652, 0x7670, 0x768e, 0x76ac, 0x76ca, 0x76e8,
	0x7706, 0x7724, 0x7742, 0x7760, 0x777e, 0x779c, 0x77ba, 0x77d8,
	0x77f6, 0x7814, 0x7830, 0x7847, 0x7864, 0x7873, 0x7893, 0x78b4,
	0x78d3, 0x78f0, 0x790e, 0x7929, 0x7946, 0x7962, 0x7983, 0x79a4,
	0x79c5, 0x79e6, 0x7a07, 0x7a29, 0x7a4b, 0x7a6d, 0x7a8f, 0x7abf,
	0x7ada, 0x7af5, 0x7b10, 0x7b2b, 0x7b46, 0x7b62, 0x7b7e, 0x7b9a,
	// Entry 40C0 - 40FF
	0x7bb6, 0x7bd2, 0x7bee, 0x7c0a, 0x7c26, 0x7c42, 0x7c5e, 0x7c7a,
	0x7c96, 0x7cb2, 0x7cce, 0x7cea, 0x7d06, 0x7d22, 0x7d3e, 0x7d5a,
	0x7d76, 0x7d92, 0x7dae, 0x7dca, 0x7de6, 0x7e02, 0x7e1e, 0x7e3a,
	0x7e56, 0x7e72, 0x7e8e, 0x7eaa, 0x7ec6, 0x7ee2, 0x7efe, 0x7f1a,
	0x7f36, 0x7f52, 0x7f6e, 0x7f8a, 0x7fa5, 0x7fc9, 0x7ff2, 0x8009,
	0x8027, 0x804a, 0x806d, 0x808a, 0x80ad, 0x80d0, 0x80ee, 0x8111,
	0x812e, 0x8152, 0x8175, 0x8198, 0x81ba, 0x81df, 0x8204, 0x8227,
	0x8244, 0x8261, 0x8283, 0x82a5, 0x82c1, 0x82e2, 0x82ff, 0x831c,
	// Entry 4100 - 413F
	0x833e, 0x835d, 0x837c, 0x839b, 0x83ba, 0x83d7, 0x83f0, 0x840a,
	0x8424, 0x843f, 0x8459, 0x8472, 0x848d, 0x84a7, 0x84c0, 0x84da,
	0x84f5, 0x850f, 0x8529, 0x8542, 0x855d, 0x8577, 0x8591, 0x85ab,
	0x85c5, 0x85df, 0x85f8, 0x860b, 0x861f, 0x8631, 0x8641, 0x8655,
	0x8667, 0x8679, 0x8697, 0x86b0, 0x86c7, 0x86e1, 0x86fa, 0x8710,
	0x8726, 0x8743, 0x8763, 0x8784, 0x87a0, 0x87b5, 0x87cd, 0x87e5,
	0x87fd, 0x8815, 0x882d, 0x8846, 0x885f, 0x8878, 0x8891, 0x88aa,
	0x88c3, 0x88dc, 0x88f5, 0x890e, 0x8927, 0x8940, 0x8959, 0x8972,
	// Entry 4140 - 417F
	0x898b, 0x89a4, 0x89bd, 0x89d6, 0x89ef, 0x8a08, 0x8a21, 0x8a3a,
	0x8a53, 0x8a6c, 0x8a85, 0x8a9e, 0x8ab7, 0x8ad0, 0x8ae9, 0x8b02,
	0x8b1b, 0x8b34, 0x8b4d, 0x8b66, 0x8b7f, 0x8b98, 0x8bb1, 0x8bca,
	0x8be3, 0x8bfc, 0x8c15, 0x8c2e, 0x8c47, 0x8c60, 0x8c79, 0x8c92,
	0x8cab, 0x8cc4, 0x8cdd, 0x8cf6, 0x8d0f, 0x8d28, 0x8d41, 0x8d5a,
	0x8d73, 0x8d8c, 0x8da5, 0x8dbe, 0x8dd7, 0x8df1, 0x8e0b, 0x8e25,
	0x8e3f, 0x8e59, 0x8e73, 0x8e8d, 0x8ea7, 0x8ec1, 0x8edb, 0x8ef5,
	0x8f09, 0x8f1d, 0x8f31, 0x8f45, 0x8f59, 0x8f6d, 0x8f81, 0x8f95,
	// Entry 4180 - 41BF
	0x8fa9, 0x8fbd, 0x8fd1, 0x8fe5, 0x8ff9, 0x900d, 0x9027, 0x9043,
	0x905e, 0x907a, 0x9096, 0x90b6, 0x90d1, 0x90ec, 0x910c, 0x912b,
	0x9146, 0x9162, 0x917d, 0x9199, 0x91b5, 0x91d2, 0x91ee, 0x920a,
	0x9228, 0x9243, 0x9260, 0x927a, 0x9295, 0x92ab, 0x92c7, 0x92e2,
	0x92ff, 0x931a, 0x9330, 0x934b, 0x9361, 0x9377, 0x9392, 0x93a8,
	0x93be, 0x93d4, 0x93f0, 0x9406, 0x941c, 0x9438, 0x944e, 0x9464,
	0x9482, 0x949f, 0x94b5, 0x94cb, 0x94e1, 0x94f7, 0x950d, 0x9523,
	0x9539, 0x954f, 0x9565, 0x9581, 0x9597, 0x95b2, 0x95c8, 0x95de,
	// Entry 41C0 - 41FF
	0x95f4, 0x960a, 0x9620, 0x9636, 0x964c, 0x9662, 0x9678, 0x968e,
	0x96a4, 0x96c1, 0x96e1, 0x96ff, 0x971b, 0x9737, 0x974d, 0x9769,
	0x977f, 0x9795, 0x97bb, 0x97d9, 0x97fd, 0x9819, 0x982f, 0x9845,
	0x9861, 0x9877, 0x988d, 0x98a3, 0x98b9, 0x98cf, 0x98ea, 0x9900,
	0x9916, 0x992c, 0x9942, 0x9958, 0x9975, 0x9992, 0x99af, 0x99cc,
	0x99e9, 0x9a06, 0x9a23, 0x9a40, 0x9a5d, 0x9a7a, 0x9a97, 0x9ab4,
	0x9ad1, 0x9aee, 0x9b0b, 0x9b28, 0x9b45, 0x9b62, 0x9b7f, 0x9b9c,
	0x9bb9, 0x9bd6, 0x9bf3, 0x9c10, 0x9c2d, 0x9c4a, 0x9c67, 0x9c84,
	// Entry 4200 - 423F
	0x9ca1, 0x9cbb, 0x9cd4, 0x9ce5, 0x9cf6, 0x9d07, 0x9d1a, 0x9d2c,
	0x9d3e, 0x9d4f, 0x9d62, 0x9d75, 0x9d87, 0x9d98, 0x9dac, 0x9dc0,
	0x9dd3, 0x9de6, 0x9df9, 0x9e0e, 0x9e22, 0x9e36, 0x9e4f, 0x9e68,
	0x9e83, 0x9e9d, 0x9eb7, 0x9ed0, 0x9eeb, 0x9f06, 0x9f20, 0x9f3a,
	0x9f54, 0x9f70, 0x9f8b, 0x9fa6, 0x9fc0, 0x9fdc, 0x9ff8, 0xa013,
	0xa02d, 0xa04a, 0xa067, 0xa083, 0xa09f, 0xa0bb, 0xa0d9, 0xa0f6,
	0xa113, 0xa12a, 0xa145, 0xa161, 0xa17c, 0xa198, 0xa1b8, 0xa1db,
	0xa1f8, 0xa214, 0xa236, 0xa255, 0xa277, 0xa292, 0xa2ae, 0xa2d1,
	// Entry 4240 - 427F
	0xa2f5, 0xa31a, 0xa33d, 0xa35f, 0xa383, 0xa3ad, 0xa3d8, 0xa403,
	0xa42f, 0xa452, 0xa474, 0xa498, 0xa4c2, 0xa4ed, 0xa518, 0xa543,
	0xa570, 0xa58f, 0xa5b4, 0xa5d1, 0xa5f0, 0xa60f, 0xa62c, 0xa652,
	0xa67a, 0xa69a, 0xa6b9, 0xa6e7, 0xa706, 0xa724, 0xa741, 0xa761,
	0xa782, 0xa7b2, 0xa7d3, 0xa7f2, 0xa817, 0xa83e, 0xa866, 0xa88e,
	0xa8b4, 0xa8db, 0xa8ff, 0xa925, 0xa94c, 0xa96e, 0xa992, 0xa9a5,
	0xa9c7, 0xa9dc, 0xa9f5, 0xaa04, 0xaa15, 0xaa27, 0xaa36, 0xaa4a,
	0xaa60, 0xaa75, 0xaa8a, 0xaa9d, 0xaab4, 0xaac4, 0xaad5, 0xaae6,
	// Entry 4280 - 42BF
	0xaaf7, 0xab08, 0xab19, 0xab31, 0xab40, 0xab56, 0xab69, 0xab7d,
	0xab89, 0xab9b, 0xabab, 0xabbe, 0xabd0, 0xabea, 0xabfc, 0xac0f,
	0xac23, 0xac38, 0xac4c, 0xac59, 0xac6d, 0xac79, 0xac8d, 0xacaa,
	0xacc8, 0xace8, 0xad02, 0xad1a, 0xad32, 0xad4b, 0xad66, 0xad7e,
	0xad96, 0xadac, 0xadc5, 0xaddc, 0xadf7, 0xae11, 0xae27, 0xae3d,
	0xae59, 0xae7b, 0xae94, 0xaeab, 0xaec3, 0xaedc, 0xaef6, 0xaf0d,
	0xaf24, 0xaf3b, 0xaf57, 0xaf6d, 0xaf83, 0xaf9b, 0xafb2, 0xafca,
	0xafe0, 0xaffd, 0xb014, 0xb02e, 0xb048, 0xb05f, 0xb079, 0xb091,
	// Entry 42C0 - 42FF
	0xb0aa, 0xb0c5, 0xb0e1, 0xb0fd, 0xb128, 0xb137, 0xb146, 0xb155,
	0xb165, 0xb174, 0xb183, 0xb192, 0xb1a1, 0xb1b0, 0xb1c0, 0xb1cf,
	0xb1de, 0xb1ed, 0xb1fc, 0xb20b, 0xb21a, 0xb22a, 0xb23a, 0xb249,
	0xb258, 0xb268, 0xb277, 0xb286, 0xb295, 0xb2a5, 0xb2b5, 0xb2c5,
	0xb2d4, 0xb2e3, 0xb2f2, 0xb302, 0xb311, 0xb320, 0xb331, 0xb340,
	0xb350, 0xb360, 0xb36f, 0xb37e, 0xb38d, 0xb39c, 0xb3ac, 0xb3bb,
	0xb3cb, 0xb3dc, 0xb3eb, 0xb3fd, 0xb40c, 0xb41c, 0xb42b, 0xb43a,
	0xb44b, 0xb45a, 0xb46a, 0xb479, 0xb488, 0xb49a, 0xb4a9, 0xb4b9,
	// Entry 4300 - 433F
	0xb4c9, 0xb4d9, 0xb4e8, 0xb4f8, 0xb508, 0xb519, 0xb529, 0xb539,
	0xb54b, 0xb55b, 0xb56d, 0xb57d, 0xb58d, 0xb59e, 0xb5af, 0xb5c0,
	0xb5d1, 0xb5e1, 0xb5f3, 0xb60e, 0xb624, 0xb63a, 0xb652, 0xb669,
	0xb680, 0xb696, 0xb6ae, 0xb6c6, 0xb6dd, 0xb6f4, 0xb70e, 0xb728,
	0xb741, 0xb75a, 0xb773, 0xb78e, 0xb7a8, 0xb7c2, 0xb7e1, 0xb800,
	0xb821, 0xb841, 0xb861, 0xb880, 0xb8a1, 0xb8c2, 0xb8e2, 0xb8f5,
	0xb909, 0xb91d, 0xb931, 0xb944, 0xb958, 0xb96c, 0xb980, 0xb995,
	0xb9a8, 0xb9bc, 0xb9d0, 0xb9e4, 0xb9f8, 0xba0d, 0xba20, 0xba34,
	// Entry 4340 - 437F
	0xba49, 0xba5d, 0xba71, 0xba85, 0xba99, 0xbaac, 0xbac1, 0xbad6,
	0xbaeb, 0xbaff, 0xbb14, 0xbb29, 0xbb3d, 0xbb51, 0xbb66, 0xbb7c,
	0xbb93, 0xbba9, 0xbbc1, 0xbbd5, 0xbbf3, 0xbc11, 0xbc23, 0xbc38,
	0xbc4a, 0xbc5c, 0xbc70, 0xbc86, 0xbc98, 0xbcaa, 0xbcbe, 0xbccf,
	0xbce2, 0xbcf5, 0xbd08, 0xbd1c, 0xbd2d, 0xbd3f, 0xbd55, 0xbd69,
	0xbd7c, 0xbd8f, 0xbda2, 0xbdb5, 0xbdc8, 0xbddb, 0xbdee, 0xbe01,
	0xbe1b, 0xbe2f, 0xbe44, 0xbe59, 0xbe6e, 0xbe81, 0xbe97, 0xbeae,
	0xbec4, 0xbedb, 0xbeee, 0xbf04, 0xbf19, 0xbf30, 0xbf47, 0xbf5d,
	// Entry 4380 - 43BF
	0xbf73, 0xbf88, 0xbf9d, 0xbfb2, 0xbfc5, 0xbfdc, 0xbff3, 0xc00c,
	0xc021, 0xc037, 0xc04a, 0xc05e, 0xc072, 0xc086, 0xc09c, 0xc0b1,
	0xc0c6, 0xc0dc, 0xc0f1, 0xc105, 0xc119, 0xc12d, 0xc141, 0xc15f,
	0xc17e, 0xc19e, 0xc1bf, 0xc1de, 0xc1f2, 0xc206, 0xc21b, 0xc22e,
	0xc243, 0xc255, 0xc267, 0xc27b, 0xc28f, 0xc2a2, 0xc2b5, 0xc2c8,
	0xc2dc, 0xc2f1, 0xc304, 0xc318, 0xc32b, 0xc33d, 0xc352, 0xc365,
	0xc377, 0xc38b, 0xc39f, 0xc3b4, 0xc3ca, 0xc3df, 0xc3f1, 0xc402,
	0xc413, 0xc426, 0xc43b, 0xc44d, 0xc45f, 0xc471, 0xc484, 0xc497,
	// Entry 43C0 - 43FF
	0xc4aa, 0xc4bd, 0xc4d0, 0xc4e3, 0xc4f6, 0xc509, 0xc51c, 0xc52f,
	0xc542, 0xc555, 0xc568, 0xc57c, 0xc58f, 0xc5a2, 0xc5b5, 0xc5c8,
	0xc5db, 0xc5ee, 0xc601, 0xc614, 0xc627, 0xc63a, 0xc64d, 0xc660,
	0xc673, 0xc686, 0xc699, 0xc6ac, 0xc6c0, 0xc6d4, 0xc6e7, 0xc702,
	0xc71f, 0xc73c, 0xc759, 0xc773, 0xc78f, 0xc7a4, 0xc7bc, 0xc7d4,
	0xc7ea, 0xc800, 0xc816, 0xc82f, 0xc849, 0xc866, 0xc883, 0xc8a0,
	0xc8be, 0xc8db, 0xc8f9, 0xc917, 0xc935, 0xc953, 0xc972, 0xc990,
	0xc9af, 0xc9c8, 0xc9e1, 0xc9fa, 0xca14, 0xca2c, 0xca46, 0xca60,
	// Entry 4400 - 443F
	0xca7a, 0xca94, 0xcaaf, 0xcac9, 0xcae3, 0xcafd, 0xcb16, 0xcb30,
	0xcb4a, 0xcb65, 0xcb7e, 0xcb98, 0xcbb2, 0xcbcd, 0xcbe6, 0xcbff,
	0xcc18, 0xcc31, 0xcc4b, 0xcc64, 0xcc7d, 0xcc98, 0xccb3, 0xccce,
	0xccea, 0xcd05, 0xcd21, 0xcd3d, 0xcd59, 0xcd75, 0xcd92, 0xcdae,
	0xcdcb, 0xcde2, 0xcdf9, 0xce10, 0xce28, 0xce3e, 0xce56, 0xce6e,
	0xce86, 0xce9e, 0xceb7, 0xcecf, 0xcee7, 0xceff, 0xcf16, 0xcf2e,
	0xcf46, 0xcf5f, 0xcf76, 0xcf8e, 0xcfa6, 0xcfbf, 0xcfd6, 0xcfed,
	0xd004, 0xd01b, 0xd033, 0xd04a, 0xd061, 0xd074, 0xd086, 0xd099,
	// Entry 4440 - 447F
	0xd0ab, 0xd0bf, 0xd0d0, 0xd0e3, 0xd0f8, 0xd10a, 0xd11d, 0xd12f,
	0xd142, 0xd154, 0xd166, 0xd179, 0xd18b, 0xd1a1, 0xd1b5, 0xd1c7,
	0xd1db, 0xd1ee, 0xd201, 0xd212, 0xd224, 0xd236, 0xd248, 0xd259,
	0xd26c, 0xd27e, 0xd28f, 0xd2a2, 0xd2b4, 0xd2c6, 0xd2d8, 0xd2ea,
	0xd2fb, 0xd30d, 0xd320, 0xd332, 0xd344, 0xd356, 0xd367, 0xd379,
	0xd38b, 0xd39f, 0xd3b1, 0xd3c3, 0xd3d5, 0xd3e8, 0xd3f9, 0xd40a,
	0xd41b, 0xd42c, 0xd43e, 0xd451, 0xd462, 0xd473, 0xd487, 0xd499,
	0xd4ac, 0xd4bd, 0xd4ce, 0xd4e1, 0xd4f4, 0xd507, 0xd51a, 0xd52d,
	// Entry 4480 - 44BF
	0xd53f, 0xd550, 0xd561, 0xd571, 0xd581, 0xd591, 0xd5a1, 0xd5b1,
	0xd5c2, 0xd5d3, 0xd5e4, 0xd5f6, 0xd607, 0xd618, 0xd62b, 0xd63d,
	0xd64f, 0xd660, 0xd673, 0xd686, 0xd698, 0xd6ae, 0xd6c5, 0xd6dd,
	0xd6f4, 0xd70c, 0xd724, 0xd73e, 0xd754, 0xd76c, 0xd783, 0xd79b,
	0xd7b1, 0xd7c8, 0xd7e1, 0xd7f9, 0xd810, 0xd827, 0xd83e, 0xd854,
	0xd86c, 0xd883, 0xd89c, 0xd8b3, 0xd8cb, 0xd8e2, 0xd8fb, 0xd913,
	0xd92d, 0xd946, 0xd95e, 0xd974, 0xd98b, 0xd9a3, 0xd9bb, 0xd9d2,
	0xd9ea, 0xd9fe, 0xda13, 0xda29, 0xda3e, 0xda54, 0xda6a, 0xda82,
	// Entry 44C0 - 44FF
	0xda96, 0xdaac, 0xdac1, 0xdad7, 0xdaeb, 0xdb00, 0xdb17, 0xdb2d,
	0xdb42, 0xdb57, 0xdb6c, 0xdb80, 0xdb96, 0xdbab, 0xdbc2, 0xdbd7,
	0xdbed, 0xdc02, 0xdc19, 0xdc2f, 0xdc47, 0xdc5e, 0xdc74, 0xdc88,
	0xdc9d, 0xdcb3, 0xdcc9, 0xdcde, 0xdcf4, 0xdd04, 0xdd15, 0xdd26,
	0xdd38, 0xdd49, 0xdd5b, 0xdd6d, 0xdd7e, 0xdd8e, 0xdd9f, 0xddb0,
	0xddc2, 0xddd3, 0xdde3, 0xddf4, 0xde05, 0xde16, 0xde28, 0xde39,
	0xde4a, 0xde5b, 0xde6d, 0xde7d, 0xde8e, 0xde9f, 0xdeb0, 0xdec2,
	0xded3, 0xdee5, 0xdef6, 0xdf08, 0xdf18, 0xdf29, 0xdf3a, 0xdf4a,
	// Entry 4500 - 453F
	0xdf5b, 0xdf6d, 0xdf7f, 0xdf94, 0xdfa6, 0xdfc3, 0xdfe0, 0xdffd,
	0xe01a, 0xe036, 0xe054, 0xe071, 0xe08f, 0xe0ac, 0xe0c9, 0xe0e7,
	0xe104, 0xe121, 0xe13e, 0xe15b, 0xe179, 0xe197, 0xe1b5, 0xe1d2,
	0xe1f0, 0xe20d, 0xe22b, 0xe249, 0xe266, 0xe283, 0xe2a1, 0xe2be,
	0xe2dc, 0xe2f9, 0xe316, 0xe334, 0xe353, 0xe371, 0xe38f, 0xe3ab,
	0xe3c9, 0xe3e6, 0xe404, 0xe422, 0xe43f, 0xe45e, 0xe47b, 0xe499,
	0xe4b7, 0xe4d5, 0xe4f3, 0xe510, 0xe52e, 0xe54c, 0xe56a, 0xe588,
	0xe5a5, 0xe5c5, 0xe5d8, 0xe5eb, 0xe5fe, 0xe611, 0xe624, 0xe637,
	// Entry 4540 - 457F
	0xe64a, 0xe65d, 0xe670, 0xe683, 0xe696, 0xe6a9, 0xe6bc, 0xe6cf,
	0xe6e2, 0xe6f5, 0xe709, 0xe71d, 0xe730, 0xe744, 0xe758, 0xe76b,
	0xe77f, 0xe792, 0xe7a5, 0xe7b8, 0xe7cb, 0xe7de, 0xe7f1, 0xe804,
	0xe817, 0xe82a, 0xe83d, 0xe850, 0xe863, 0xe876, 0xe889, 0xe89c,
	0xe8af, 0xe8c2, 0xe8d5, 0xe8e8, 0xe8fb, 0xe90e, 0xe921, 0xe934,
	0xe947, 0xe95a, 0xe96d, 0xe980, 0xe993, 0xe9a6, 0xe9b9, 0xe9cc,
	0xe9df, 0xe9f2, 0xea05, 0xea18, 0xea2b, 0xea3e, 0xea51, 0xea64,
	0xea77, 0xea8a, 0xea9d, 0xeab0, 0xeac3, 0xead6, 0xeae9, 0xeafc,
	// Entry 4580 - 45BF
	0xeb0f, 0xeb25, 0xeb38, 0xeb4b, 0xeb5e, 0xeb71, 0xeb84, 0xeb98,
	0xebac, 0xebbf, 0xebd2, 0xebe5, 0xebf8, 0xec0b, 0xec1e, 0xec30,
	0xec42, 0xec54, 0xec66, 0xec78, 0xec8a, 0xec9c, 0xecae, 0xecc1,
	0xecd4, 0xece7, 0xecf9, 0xed0b, 0xed1d, 0xed30, 0xed43, 0xed56,
	0xed68, 0xed7a, 0xed8c, 0xed9e, 0xedb0, 0xedc2, 0xedd4, 0xede6,
	0xedf8, 0xee0a, 0xee1c, 0xee2e, 0xee40, 0xee52, 0xee64, 0xee76,
	0xee88, 0xee9a, 0xeeac, 0xeebe, 0xeed0, 0xeee2, 0xeef4, 0xef06,
	0xef18, 0xef2a, 0xef3c, 0xef4e, 0xef60, 0xef72, 0xef84, 0xef96,
	// Entry 45C0 - 45FF
	0xefa8, 0xefba, 0xefcc, 0xefde, 0xeff0, 0xf002, 0xf014, 0xf026,
	0xf038, 0xf04a, 0xf05c, 0xf06e, 0xf080, 0xf092, 0xf0a4, 0xf0b6,
	0xf0c8, 0xf0da, 0xf0ec, 0xf0fe, 0xf110, 0xf122, 0xf134, 0xf146,
	0xf158, 0xf16a, 0xf180, 0xf196, 0xf1ac, 0xf1c2, 0xf1d8, 0xf1ee,
	0xf204, 0xf21a, 0xf230, 0xf246, 0xf25c, 0xf272, 0xf288, 0xf29e,
	0xf2b4, 0xf2ca, 0xf2e0, 0xf2f6, 0xf30c, 0xf31e, 0xf330, 0xf342,
	0xf354, 0xf366, 0xf378, 0xf38a, 0xf39c, 0xf3ae, 0xf3c0, 0xf3d2,
	0xf3e4, 0xf3f6, 0xf408, 0xf41a, 0xf42c, 0xf43e, 0xf450, 0xf462,
	// Entry 4600 - 463F
	0xf474, 0xf486, 0xf498, 0xf4aa, 0xf4bc, 0xf4ce, 0xf4e0, 0xf4f2,
	0xf504, 0xf516, 0xf528, 0xf53a, 0xf54c, 0xf55e, 0xf570, 0xf582,
	0xf594, 0xf5a6, 0xf5b8, 0xf5ca, 0xf5dc, 0xf5ee, 0xf600, 0xf612,
	0xf624, 0xf636, 0xf648, 0xf65a, 0xf66c, 0xf67e, 0xf690, 0xf6a2,
	0xf6b4, 0xf6c6, 0xf6d8, 0xf6ea, 0xf6fc, 0xf70e, 0xf720, 0xf732,
	0xf744, 0xf756, 0xf768, 0xf77a, 0xf78c, 0xf79e, 0xf7b0, 0xf7c2,
	0xf7d4, 0xf7e6, 0xf7f8, 0xf80a, 0xf81c, 0xf82e, 0xf840, 0xf852,
	0xf864, 0xf876, 0xf888, 0xf89a, 0xf8ac, 0xf8be, 0xf8d0, 0xf8e2,
	// Entry 4640 - 467F
	0xf8f4, 0xf906, 0xf918, 0xf92a, 0xf93c, 0xf94e, 0xf960, 0xf972,
	0xf984, 0xf996, 0xf9a8, 0xf9ba, 0xf9cc, 0xf9de, 0xf9f0, 0xfa02,
	0xfa14, 0xfa26, 0xfa38, 0xfa4a, 0xfa5c, 0xfa6e, 0xfa80, 0xfa92,
	0xfaa4, 0xfab6, 0xfac8, 0xfada, 0xfaec, 0xfafe, 0xfb10, 0xfb22,
	0xfb34, 0xfb46, 0xfb58, 0xfb6a, 0xfb7c, 0xfb8e, 0xfba0, 0xfbb2,
	0xfbc4, 0xfbd6, 0xfbe8, 0xfbfa, 0xfc0c, 0xfc1e, 0xfc30, 0xfc42,
	0xfc54, 0xfc68, 0xfc7c, 0xfc90, 0xfca4, 0xfcb8, 0xfccc, 0xfce0,
	0xfcf4, 0xfd08, 0xfd1f, 0xfd36, 0xfd4d, 0xfd64, 0xfd78, 0xfd8c,
	// Entry 4680 - 46BF
	0xfda0, 0xfdb8, 0xfdce, 0xfde3, 0xfdf8, 0xfe0f, 0xfe24, 0xfe36,
	0xfe48, 0xfe5a, 0xfe6c, 0xfe7e, 0xfe90, 0xfea2, 0xfeb4, 0xfec6,
	0xfed8, 0xfeea, 0xfefc, 0xff0e, 0xff21, 0xff34, 0xff47, 0xff5a,
	0xff6d, 0xff80, 0xff93, 0xffa6, 0xffb9, 0xffcc, 0xffdf, 0xfff2,
	0x0005, 0x0018, 0x002b, 0x003e, 0x0051, 0x0064, 0x0077, 0x008a,
	0x009d, 0x00b0, 0x00c3, 0x00d6, 0x00e9, 0x00fc, 0x010f, 0x0122,
	0x0135, 0x0148, 0x015b, 0x016e, 0x0181, 0x0194, 0x01a7, 0x01ba,
	0x01cd, 0x01e0, 0x01f3, 0x0206, 0x0219, 0x022c, 0x023f, 0x0252,
	// Entry 46C0 - 46FF
	0x0265, 0x0278, 0x028b, 0x029e, 0x02b1, 0x02c4, 0x02e1, 0x02fd,
	0x031a, 0x0338, 0x0352, 0x036d, 0x038a, 0x03a6, 0x03c2, 0x03de,
	0x03fa, 0x0418, 0x0433, 0x044e, 0x046c, 0x0488, 0x04a2, 0x04bf,
	0x04db, 0x04f7, 0x0513, 0x052e, 0x054b, 0x0566, 0x0581, 0x059e,
	0x05b9, 0x05d7, 0x05fa, 0x061e, 0x0642, 0x0658, 0x066d, 0x0683,
	0x069a, 0x06ad, 0x06c1, 0x06d7, 0x06ec, 0x0701, 0x0716, 0x072b,
	0x0742, 0x0756, 0x0770, 0x0784, 0x079b, 0x07b0, 0x07c3, 0x07d9,
	0x07ee, 0x0803, 0x0818, 0x082c, 0x084b, 0x086b, 0x087f, 0x0893,
	// Entry 4700 - 473F
	0x08a9, 0x08be, 0x08d3, 0x08e7, 0x08fe, 0x091a, 0x0930, 0x094b,
	0x0960, 0x0976, 0x098d, 0x09a6, 0x09b9, 0x09cd, 0x09e3, 0x09f8,
	0x0a0d, 0x0a28, 0x0a3d, 0x0a58, 0x0a6d, 0x0a8a, 0x0aa1, 0x0abb,
	0x0acf, 0x0ae9, 0x0afd, 0x0b14, 0x0b29, 0x0b3c, 0x0b52, 0x0b67,
	0x0b7c, 0x0b97, 0x0bac, 0x0bc0, 0x0bd4, 0x0be8, 0x0bfe, 0x0c13,
	0x0c32, 0x0c47, 0x0c5b, 0x0c72, 0x0c8e, 0x0ca1, 0x0cb3, 0x0cc6,
	0x0cdf, 0x0cef, 0x0d00, 0x0d12, 0x0d24, 0x0d36, 0x0d48, 0x0d5a,
	0x0d6e, 0x0d7f, 0x0d90, 0x0da4, 0x0db5, 0x0dc5, 0x0dd8, 0x0dea,
	// Entry 4740 - 477F
	0x0dfc, 0x0e0d, 0x0e1e, 0x0e30, 0x0e41, 0x0e55, 0x0e6e, 0x0e83,
	0x0e98, 0x0eae, 0x0ec4, 0x0ed8, 0x0eed, 0x0f02, 0x0f17, 0x0f2c,
	0x0f41, 0x0f56, 0x0f6c, 0x0f81, 0x0f96, 0x0fac, 0x0fc1, 0x0fd5,
	0x0feb, 0x1000, 0x1016, 0x102c, 0x1041, 0x1056, 0x106b, 0x1083,
	0x10a0, 0x10b5, 0x10cc, 0x10e5, 0x10f4, 0x1103, 0x1112, 0x1121,
	0x1130, 0x113f, 0x114e, 0x115d, 0x116c, 0x117b, 0x118a, 0x1199,
	0x11a8, 0x11b7, 0x11c7, 0x11d6, 0x11e5, 0x11f4, 0x1203, 0x1212,
	0x1222, 0x1232, 0x1242, 0x1252, 0x1262, 0x1271, 0x1287, 0x12a5,
	// Entry 4780 - 47BF
	0x12c3, 0x12e1, 0x12ff, 0x131e, 0x133d, 0x135c, 0x137d, 0x139c,
	0x13bb, 0x13da, 0x13fb, 0x141a, 0x143b, 0x145a, 0x147b, 0x149a,
	0x14ba, 0x14da, 0x14f9, 0x151a, 0x1539, 0x1558, 0x1577, 0x1596,
	0x15b7, 0x15d6, 0x15f7, 0x1616, 0x1635, 0x1656, 0x1679, 0x1692,
	0x16ab, 0x16c4, 0x16dd, 0x16f7, 0x1711, 0x172b, 0x1745, 0x175f,
	0x1779, 0x1793, 0x17ad, 0x17c7, 0x17e2, 0x17fd, 0x1817, 0x1839,
	0x1853, 0x186d, 0x1887, 0x18a1, 0x18bb, 0x18d5, 0x18ef, 0x1918,
	0x193a, 0x1957, 0x1974, 0x198f, 0x19aa, 0x19c7, 0x19e3, 0x19ff,
	// Entry 47C0 - 47FF
	0x1a1a, 0x1a37, 0x1a54, 0x1a70, 0x1a8b, 0x1aa9, 0x1ac7, 0x1ae4,
	0x1b01, 0x1b1e, 0x1b3d, 0x1b60, 0x1b83, 0x1ba8, 0x1bcc, 0x1bf0,
	0x1c13, 0x1c38, 0x1c5d, 0x1c81, 0x1ca5, 0x1cc9, 0x1cef, 0x1d14,
	0x1d39, 0x1d5d, 0x1d83, 0x1da9, 0x1dce, 0x1df2, 0x1e19, 0x1e40,
	0x1e66, 0x1e8c, 0x1eb2, 0x1eda, 0x1f01, 0x1f28, 0x1f54, 0x1f80,
	0x1fae, 0x1fdb, 0x2008, 0x2034, 0x2062, 0x2090, 0x20bd, 0x20e2,
	0x2108, 0x2130, 0x2157, 0x217e, 0x21a4, 0x21cc, 0x21f4, 0x221b,
	0x2241, 0x2254, 0x226b, 0x2282, 0x22a1, 0x22b8, 0x22cf, 0x22eb,
	// Entry 4800 - 483F
	0x230c, 0x2324, 0x233b, 0x234f, 0x2364, 0x2378, 0x238d, 0x23a1,
	0x23b6, 0x23ca, 0x23df, 0x23f4, 0x240a, 0x241f, 0x2435, 0x244a,
	0x245e, 0x2473, 0x2487, 0x249c, 0x24b0, 0x24c4, 0x24d9, 0x24ed,
	0x2502, 0x2516, 0x252a, 0x253e, 0x2552, 0x2566, 0x257b, 0x2590,
	0x25a4, 0x25b8, 0x25cc, 0x25e1, 0x25f8, 0x260e, 0x2623, 0x263c,
	0x2651, 0x266a, 0x267b, 0x268f, 0x26a3, 0x26b9, 0x26ce, 0x26e3,
	0x26fb, 0x2718, 0x2736, 0x2752, 0x276c, 0x278f, 0x27ac, 0x27cf,
	0x27ee, 0x280a, 0x2826, 0x2849, 0x2865, 0x2880, 0x289f, 0x28bc,
	// Entry 4840 - 487F
	0x28d8, 0x28f5, 0x2911, 0x292e, 0x294b, 0x2968, 0x2984, 0x29a0,
	0x29bd, 0x29d9, 0x29f7, 0x2a15, 0x2a34, 0x2a4f, 0x2a6c, 0x2a88,
	0x2aa7, 0x2ac5, 0x2ae4, 0x2b02, 0x2b1f, 0x2b3c, 0x2b5c, 0x2b79,
	0x2b96, 0x2bb4, 0x2bd0, 0x2bee, 0x2c11, 0x2c2d, 0x2c49, 0x2c65,
	0x2c82, 0x2c9e, 0x2cba, 0x2cd7, 0x2cf3, 0x2d0f, 0x2d2b, 0x2d48,
	0x2d64, 0x2d81, 0x2d9e, 0x2dba, 0x2dd7, 0x2df3, 0x2e10, 0x2e2c,
	0x2e48, 0x2e65, 0x2e81, 0x2e9f, 0x2ebb, 0x2ed8, 0x2ef5, 0x2f11,
	0x2f2e, 0x2f4a, 0x2f66, 0x2f82, 0x2fa1, 0x2fb8, 0x2fce, 0x2fe5,
	// Entry 4880 - 48BF
	0x2ffc, 0x3014, 0x302c, 0x3040, 0x3055, 0x3067, 0x307e, 0x3096,
	0x30ad, 0x30c5, 0x30db, 0x30f1, 0x3107, 0x311d, 0x3133, 0x314a,
	0x3162, 0x317b, 0x3194, 0x31a9, 0x31be, 0x31d6, 0x31ec, 0x3203,
	0x3217, 0x322b, 0x3242, 0x3258, 0x326e, 0x3285, 0x329b, 0x32b1,
	0x32c8, 0x32dd, 0x32ff, 0x3321, 0x3336, 0x334c, 0x3361, 0x3379,
	0x3396, 0x33b1, 0x33cf, 0x33fb, 0x3420, 0x343a, 0x3459, 0x347b,
	0x348b, 0x349c, 0x34ad, 0x34bf, 0x34d0, 0x34e2, 0x34f3, 0x3505,
	0x3515, 0x3526, 0x3536, 0x3547, 0x3557, 0x3568, 0x3578, 0x3589,
	// Entry 48C0 - 48FF
	0x359a, 0x35ab, 0x35bd, 0x35cf, 0x35e0, 0x35f2, 0x3604, 0x3615,
	0x3626, 0x3637, 0x3649, 0x365a, 0x366c, 0x367e, 0x368f, 0x36a0,
	0x36b1, 0x36c3, 0x36d5, 0x36e8, 0x36fb, 0x370c, 0x371e, 0x3730,
	0x3741, 0x3753, 0x3765, 0x3776, 0x3787, 0x3798, 0x37a9, 0x37ba,
	0x37cb, 0x37dd, 0x37ef, 0x3802, 0x3815, 0x3826, 0x383f, 0x3865,
	0x388c, 0x38b3, 0x38da, 0x3903, 0x392c, 0x394f, 0x3971, 0x3994,
	0x39b8, 0x39d8, 0x39f9, 0x3a1c, 0x3a3e, 0x3a60, 0x3a82, 0x3aa4,
	0x3ac8, 0x3ae9, 0x3b0a, 0x3b2e, 0x3b50, 0x3b70, 0x3b93, 0x3bb5,
	// Entry 4900 - 493F
	0x3bd7, 0x3bf9, 0x3c1a, 0x3c3b, 0x3c5c, 0x3c7f, 0x3ca1, 0x3cc2,
	0x3ce6, 0x3d0f, 0x3d39, 0x3d5b, 0x3d7c, 0x3d9e, 0x3dc1, 0x3de0,
	0x3e0a, 0x3e2c, 0x3e4d, 0x3e6e, 0x3e8f, 0x3eb0, 0x3ed3, 0x3ef8,
	0x3f18, 0x3f3b, 0x3f5a, 0x3f7c, 0x3f9d, 0x3fbd, 0x3fdd, 0x3ffd,
	0x401f, 0x4040, 0x4060, 0x4083, 0x40ab, 0x40d4, 0x40f0, 0x410b,
	0x4127, 0x4144, 0x415d, 0x4181, 0x419d, 0x41b8, 0x41d3, 0x41ee,
	0x420b, 0x422a, 0x4244, 0x4261, 0x427a, 0x4296, 0x42b1, 0x42cb,
	0x42e7, 0x430a, 0x432e, 0x4350, 0x436a, 0x4384, 0x43a0, 0x43bb,
	// Entry 4940 - 497F
	0x43d5, 0x43f2, 0x4414, 0x442e, 0x4449, 0x4465, 0x447f, 0x449a,
	0x44b5, 0x44cf, 0x44ea, 0x4506, 0x4521, 0x453d, 0x4559, 0x4576,
	0x4591, 0x45ad, 0x45c9, 0x45e6, 0x4601, 0x461d, 0x4639, 0x4654,
	0x4670, 0x468b, 0x46a7, 0x46c3, 0x46e0, 0x46fc, 0x4719, 0x4735,
	0x4752, 0x476d, 0x4789, 0x47a5, 0x47c1, 0x47dc, 0x47f7, 0x4813,
	0x4830, 0x484c, 0x4869, 0x4885, 0x48a2, 0x48be, 0x48db, 0x48f8,
	0x4914, 0x4932, 0x494d, 0x4968, 0x4983, 0x499e, 0x49ba, 0x49d5,
	0x49f1, 0x4a0c, 0x4a28, 0x4a43, 0x4a5f, 0x4a7a, 0x4a96, 0x4ab2,
	// Entry 4980 - 49BF
	0x4acd, 0x4ae9, 0x4b05, 0x4b22, 0x4b3e, 0x4b5b, 0x4b76, 0x4b92,
	0x4bae, 0x4bcb, 0x4be6, 0x4c03, 0x4c21, 0x4c40, 0x4c5f, 0x4c7f,
	0x4c9e, 0x4cbe, 0x4cde, 0x4cfd, 0x4d1d, 0x4d3b, 0x4d5f, 0x4d7e,
	0x4d9d, 0x4dbc, 0x4ddc, 0x4dfb, 0x4e19, 0x4e38, 0x4e57, 0x4e76,
	0x4e95, 0x4eb5, 0x4ed4, 0x4ef4, 0x4f13, 0x4f32, 0x4f52, 0x4f70,
	0x4f8f, 0x4fb9, 0x4fe2, 0x5002, 0x5021, 0x5041, 0x5060, 0x5085,
	0x50a4, 0x50c4, 0x50e3, 0x5103, 0x5123, 0x5143, 0x5161, 0x5180,
	0x51aa, 0x51d3, 0x51f2, 0x5211, 0x5231, 0x525d, 0x527c, 0x5298,
	// Entry 49C0 - 49FF
	0x52b5, 0x52d2, 0x52f0, 0x530d, 0x532b, 0x5349, 0x5366, 0x5384,
	0x53a0, 0x53c2, 0x53df, 0x53fc, 0x5419, 0x5437, 0x5454, 0x5470,
	0x548d, 0x54aa, 0x54c7, 0x54e4, 0x5502, 0x551f, 0x553d, 0x555a,
	0x5577, 0x5595, 0x55b1, 0x55ce, 0x55f6, 0x561d, 0x563b, 0x5658,
	0x5676, 0x5693, 0x56b6, 0x56d3, 0x56f1, 0x570e, 0x572c, 0x574a,
	0x5768, 0x5784, 0x57a1, 0x57c9, 0x57f0, 0x580d, 0x582a, 0x5848,
	0x5872, 0x588f, 0x58a7, 0x58c0, 0x58d8, 0x58f2, 0x5912, 0x5933,
	0x594b, 0x5964, 0x597d, 0x5996, 0x59b0, 0x59c9, 0x59e2, 0x59fb,
	// Entry 4A00 - 4A3F
	0x5a15, 0x5a2e, 0x5a47, 0x5a61, 0x5a7a, 0x5a94, 0x5aad, 0x5ac6,
	0x5ae0, 0x5af9, 0x5b12, 0x5b2b, 0x5b44, 0x5b5d, 0x5b76, 0x5b95,
	0x5bae, 0x5bcd, 0x5be7, 0x5c01, 0x5c1a, 0x5c31, 0x5c48, 0x5c5f,
	0x5c76, 0x5c8d, 0x5ca7, 0x5cc5, 0x5ce2, 0x5cfd, 0x5d16, 0x5d30,
	0x5d4a, 0x5d63, 0x5d7c, 0x5d97, 0x5db1, 0x5dcb, 0x5de4, 0x5dff,
	0x5e1a, 0x5e34, 0x5e42, 0x5e50, 0x5e60, 0x5e6f, 0x5e7e, 0x5e8c,
	0x5e9c, 0x5eac, 0x5ebb, 0x5eca, 0x5edc, 0x5eee, 0x5eff, 0x5f10,
	0x5f21, 0x5f34, 0x5f46, 0x5f58, 0x5f6f, 0x5f86, 0x5f9f, 0x5fb7,
	// Entry 4A40 - 4A7F
	0x5fcf, 0x5fe6, 0x5fff, 0x6018, 0x6030, 0x6046, 0x605f, 0x6076,
	0x608e, 0x60a0, 0x60b0, 0x60c0, 0x60d1, 0x60e2, 0x60f2, 0x6103,
	0x6115, 0x6128, 0x6139, 0x6149, 0x615a, 0x616b, 0x617b, 0x618c,
	0x619c, 0x61ac, 0x61bd, 0x61cf, 0x61e0, 0x61f1, 0x6201, 0x6211,
	0x6222, 0x6235, 0x6245, 0x6255, 0x6274, 0x6285, 0x6296, 0x62a8,
	0x62b9, 0x62ca, 0x62db, 0x62ec, 0x62fc, 0x630d, 0x631d, 0x632d,
	0x633e, 0x634f, 0x635f, 0x637a, 0x6395, 0x63ac, 0x63cc, 0x63f3,
	0x640b, 0x6429, 0x6440, 0x645d, 0x6475, 0x648a, 0x64a5, 0x64bb,
	// Entry 4A80 - 4ABF
	0x64d3, 0x64ea, 0x6501, 0x6518, 0x6531, 0x6547, 0x655d, 0x6579,
	0x65a8, 0x65c1, 0x65d8, 0x65f9, 0x660e, 0x6626, 0x6644, 0x6675,
	0x6698, 0x66af, 0x66c5, 0x66e1, 0x6710, 0x6726, 0x673c, 0x6754,
	0x676b, 0x6782, 0x6798, 0x67b1, 0x67ca, 0x67e8, 0x6805, 0x6825,
	0x6839, 0x684c, 0x6860, 0x6871, 0x6883, 0x6897, 0x68aa, 0x68bd,
	0x68d0, 0x68e5, 0x68f7, 0x6909, 0x691e, 0x6931, 0x6942, 0x6956,
	0x696e, 0x6981, 0x6993, 0x69a6, 0x69b9, 0x69d1, 0x69ec, 0x6a0c,
	0x6a27, 0x6a47, 0x6a64, 0x6a81, 0x6a9d, 0x6ab9, 0x6ada, 0x6af6,
	// Entry 4AC0 - 4AFF
	0x6b14, 0x6b26, 0x6b38, 0x6b4d, 0x6b67, 0x6b8c, 0x6bbb, 0x6bde,
	0x6c07, 0x6c2f, 0x6c46, 0x6c63, 0x6c79, 0x6c90, 0x6ca8, 0x6cbc,
	0x6cd1, 0x6ced, 0x6d04, 0x6d1a, 0x6d30, 0x6d46, 0x6d5e, 0x6d73,
	0x6d88, 0x6da0, 0x6db6, 0x6dca, 0x6de0, 0x6df6, 0x6e0b, 0x6e20,
	0x6e35, 0x6e4c, 0x6e62, 0x6e77, 0x6e8f, 0x6eac, 0x6ec0, 0x6ed3,
	0x6ee7, 0x6efc, 0x6f0d, 0x6f1f, 0x6f33, 0x6f46, 0x6f59, 0x6f6c,
	0x6f7f, 0x6f94, 0x6fa6, 0x6fb8, 0x6fcd, 0x6fe0, 0x6ff1, 0x7005,
	0x7018, 0x702b, 0x703e, 0x7050, 0x706b, 0x7082, 0x7096, 0x70a9,
	// Entry 4B00 - 4B3F
	0x70c0, 0x70d7, 0x70e6, 0x70f6, 0x7105, 0x7115, 0x7124, 0x7134,
	0x714b, 0x7163, 0x717a, 0x7192, 0x71a1, 0x71b1, 0x71c0, 0x71d0,
	0x71e0, 0x71f1, 0x7201, 0x7212, 0x7223, 0x7233, 0x7244, 0x7254,
	0x7265, 0x7276, 0x7287, 0x7299, 0x72aa, 0x72bc, 0x72cd, 0x72dd,
	0x72ee, 0x72fe, 0x730f, 0x731f, 0x732f, 0x7340, 0x7350, 0x7361,
	0x7371, 0x7381, 0x7391, 0x73a1, 0x73b1, 0x73c2, 0x73d3, 0x73e3,
	0x73f3, 0x7404, 0x7420, 0x743b, 0x7457, 0x746b, 0x748b, 0x749e,
	0x74b2, 0x74c5, 0x74d9, 0x74f4, 0x7510, 0x752b, 0x7547, 0x755a,
	// Entry 4B40 - 4B7F
	0x756e, 0x7581, 0x7595, 0x75a2, 0x75ae, 0x75c1, 0x75d7, 0x75f4,
	0x760b, 0x762a, 0x7642, 0x7653, 0x7664, 0x7677, 0x7689, 0x769b,
	0x76ac, 0x76bf, 0x76d2, 0x76e4, 0x76f5, 0x7709, 0x771d, 0x7730,
	0x7743, 0x7756, 0x776b, 0x777f, 0x7793, 0x77ac, 0x77c6, 0x77d7,
	0x77e7, 0x77f7, 0x7809, 0x781a, 0x782b, 0x783b, 0x784d, 0x785f,
	0x7870, 0x7884, 0x789b, 0x78af, 0x78c2, 0x78d1, 0x78e1, 0x78f0,
	0x7900, 0x790f, 0x791f, 0x792e, 0x793e, 0x794d, 0x795d, 0x796d,
	0x797e, 0x798e, 0x799f, 0x79b0, 0x79c0, 0x79d1, 0x79e1, 0x79f2,
	// Entry 4B80 - 4BBF
	0x7a03, 0x7a14, 0x7a26, 0x7a37, 0x7a4a, 0x7a5c, 0x7a6d, 0x7a7e,
	0x7a8e, 0x7a9f, 0x7aaf, 0x7ac0, 0x7ad0, 0x7ae0, 0x7af1, 0x7b01,
	0x7b12, 0x7b22, 0x7b32, 0x7b42, 0x7b52, 0x7b62, 0x7b73, 0x7b84,
	0x7b94, 0x7ba4, 0x7bb8, 0x7bcb, 0x7bdf, 0x7bf2, 0x7c06, 0x7c19,
	0x7c2d, 0x7c40, 0x7c54, 0x7c66, 0x7c77, 0x7c8f, 0x7ca6, 0x7cb8,
	0x7ccb, 0x7ce5, 0x7cf1, 0x7d04, 0x7d1c, 0x7d33, 0x7d4a, 0x7d61,
	0x7d78, 0x7d8f, 0x7da6, 0x7dbd, 0x7dd5, 0x7dec, 0x7e03, 0x7e1a,
	0x7e31, 0x7e48, 0x7e5f, 0x7e76, 0x7e8d, 0x7ea4, 0x7ebc, 0x7ed2,
	// Entry 4BC0 - 4BFF
	0x7ee9, 0x7eff, 0x7f15, 0x7f2b, 0x7f41, 0x7f58, 0x7f6f, 0x7f85,
	0x7f9b, 0x7fb3, 0x7fca, 0x7fe1, 0x7ff7, 0x800f, 0x8027, 0x803e,
	0x8055, 0x8069, 0x807c, 0x808c, 0x809b, 0x80aa, 0x80b9, 0x80ca,
	0x80dc, 0x80ed, 0x80ff, 0x8111, 0x8122, 0x8134, 0x8145, 0x8157,
	0x8169, 0x817b, 0x818e, 0x81a0, 0x81b3, 0x81c5, 0x81d6, 0x81e8,
	0x81f9, 0x820b, 0x821c, 0x822d, 0x823f, 0x8250, 0x8262, 0x8273,
	0x8285, 0x8296, 0x82a7, 0x82b8, 0x82c9, 0x82da, 0x82eb, 0x82fe,
	0x8311, 0x8325, 0x8338, 0x834c, 0x835f, 0x8373, 0x8386, 0x839a,
	// Entry 4C00 - 4C3F
	0x83ae, 0x83bb, 0x83c9, 0x83d6, 0x83e4, 0x83f5, 0x8405, 0x8415,
	0x8427, 0x8438, 0x8449, 0x8459, 0x846b, 0x847d, 0x848e, 0x84a1,
	0x84ad, 0x84c0, 0x84d4, 0x84e6, 0x84fa, 0x850e, 0x851f, 0x8530,
	0x8541, 0x8552, 0x8563, 0x8574, 0x8586, 0x8599, 0x85ab, 0x85be,
	0x85d0, 0x85e3, 0x85f5, 0x8608, 0x861b, 0x862e, 0x8642, 0x8655,
	0x8669, 0x867c, 0x868e, 0x86a1, 0x86b3, 0x86c6, 0x86d8, 0x86ea,
	0x86fd, 0x870f, 0x8722, 0x8734, 0x8746, 0x8758, 0x876a, 0x877c,
	0x878e, 0x87a1, 0x87b4, 0x87ce, 0x87e3, 0x87f9, 0x8811, 0x8826,
	// Entry 4C40 - 4C7F
	0x883a, 0x884a, 0x885b, 0x886b, 0x887c, 0x888c, 0x889d, 0x88b5,
	0x88ce, 0x88e6, 0x88ff, 0x890f, 0x8920, 0x8930, 0x8941, 0x8952,
	0x8964, 0x8975, 0x8987, 0x8999, 0x89aa, 0x89bc, 0x89cd, 0x89df,
	0x89f1, 0x8a03, 0x8a16, 0x8a28, 0x8a3b, 0x8a4d, 0x8a5e, 0x8a70,
	0x8a81, 0x8a93, 0x8aa4, 0x8ab5, 0x8ac7, 0x8ad8, 0x8aea, 0x8afb,
	0x8b0c, 0x8b1d, 0x8b2e, 0x8b40, 0x8b51, 0x8b63, 0x8b75, 0x8b86,
	0x8b97, 0x8bac, 0x8bc0, 0x8bd5, 0x8be9, 0x8bfe, 0x8c1a, 0x8c37,
	0x8c53, 0x8c70, 0x8c84, 0x8c99, 0x8cad, 0x8cc2, 0x8cd5, 0x8cea,
	// Entry 4C80 - 4CBF
	0x8d02, 0x8d1a, 0x8d24, 0x8d31, 0x8d45, 0x8d5e, 0x8d6f, 0x8d82,
	0x8d94, 0x8daf, 0x8dcd, 0x8ddf, 0x8e01, 0x8e22, 0x8e34, 0x8e45,
	0x8e56, 0x8e69, 0x8e7b, 0x8e8d, 0x8e9e, 0x8eb1, 0x8ec4, 0x8ed6,
	0x8ee2, 0x8ef6, 0x8f08, 0x8f21, 0x8f37, 0x8f4d, 0x8f66, 0x8f7f,
	0x8f9a, 0x8fb4, 0x8fce, 0x8fe7, 0x9002, 0x901d, 0x9037, 0x9051,
	0x906e, 0x908b, 0x90a7, 0x90c3, 0x90df, 0x90fd, 0x911a, 0x9137,
	0x9159, 0x917c, 0x918b, 0x919b, 0x91aa, 0x91b9, 0x91c8, 0x91d8,
	0x91e7, 0x91f7, 0x9207, 0x9218, 0x9228, 0x9239, 0x924a, 0x925b,
	// Entry 4CC0 - 4CFF
	0x926b, 0x927c, 0x928c, 0x929d, 0x92ae, 0x92bf, 0x92d1, 0x92e2,
	0x92f4, 0x9305, 0x9315, 0x9326, 0x9336, 0x9348, 0x9359, 0x9369,
	0x9379, 0x938a, 0x939a, 0x93ab, 0x93bc, 0x93cc, 0x93dc, 0x93ec,
	0x93fc, 0x940c, 0x941c, 0x942c, 0x943d, 0x9451, 0x9464, 0x9478,
	0x948b, 0x949e, 0x94b2, 0x94c5, 0x94d9, 0x94ed, 0x94ff, 0x9510,
	0x9522, 0x952e, 0x9541, 0x9556, 0x9569, 0x9583, 0x959b, 0x95ac,
	0x95bc, 0x95cc, 0x95dc, 0x95ec, 0x95fd, 0x960f, 0x9620, 0x9632,
	0x9643, 0x9655, 0x9666, 0x9678, 0x968a, 0x969c, 0x96af, 0x96c1,
	// Entry 4D00 - 4D3F
	0x96d4, 0x96e7, 0x96f9, 0x970a, 0x971c, 0x972d, 0x973f, 0x9750,
	0x9761, 0x9773, 0x9784, 0x9796, 0x97a7, 0x97b8, 0x97c9, 0x97da,
	0x97eb, 0x97fc, 0x980d, 0x981f, 0x9831, 0x9845, 0x9857, 0x986a,
	0x987c, 0x988f, 0x98a1, 0x98b4, 0x98c6, 0x98d9, 0x98eb, 0x98fe,
	0x9911, 0x9925, 0x9938, 0x994c, 0x9960, 0x9974, 0x9987, 0x999b,
	0x99ae, 0x99c2, 0x99d6, 0x99ea, 0x99fe, 0x9a13, 0x9a27, 0x9a3c,
	0x9a50, 0x9a65, 0x9a79, 0x9a8c, 0x9aa0, 0x9ab3, 0x9ac7, 0x9ada,
	0x9aed, 0x9b01, 0x9b14, 0x9b28, 0x9b3c, 0x9b4f, 0x9b62, 0x9b75,
	// Entry 4D40 - 4D7F
	0x9b88, 0x9b9b, 0x9baf, 0x9bc2, 0x9bd5, 0x9bec, 0x9c03, 0x9c19,
	0x9c30, 0x9c46, 0x9c5d, 0x9c73, 0x9c8a, 0x9ca0, 0x9cb7, 0x9ccb,
	0x9ce0, 0x9cf4, 0x9d07, 0x9d1a, 0x9d2f, 0x9d43, 0x9d57, 0x9d6a,
	0x9d7f, 0x9d94, 0x9da8, 0x9dcd, 0x9de5, 0x9dfa, 0x9e0e, 0x9e1e,
	0x9e2f, 0x9e3f, 0x9e50, 0x9e60, 0x9e71, 0x9e89, 0x9ea1, 0x9eb2,
	0x9ec3, 0x9ed4, 0x9ee5, 0x9ef6, 0x9f08, 0x9f19, 0x9f2b, 0x9f3d,
	0x9f4e, 0x9f60, 0x9f71, 0x9f83, 0x9f95, 0x9fa7, 0x9fba, 0x9fcc,
	0x9fdf, 0x9ff1, 0xa002, 0xa014, 0xa025, 0xa037, 0xa048, 0xa059,
	// Entry 4D80 - 4DBF
	0xa06b, 0xa07c, 0xa08e, 0xa09f, 0xa0b0, 0xa0c1, 0xa0d2, 0xa0e4,
	0xa0f5, 0xa107, 0xa119, 0xa12a, 0xa13b, 0xa150, 0xa162, 0xa177,
	0xa18c, 0xa1a0, 0xa1b5, 0xa1c9, 0xa1de, 0xa1fa, 0xa217, 0xa22c,
	0xa241, 0xa256, 0xa26b, 0xa27e, 0xa288, 0xa29e, 0xa2b0, 0xa2cd,
	0xa2f1, 0xa30a, 0xa323, 0xa33f, 0xa35c, 0xa378, 0xa393, 0xa3ae,
	0xa3cb, 0xa3e7, 0xa403, 0xa41e, 0xa438, 0xa453, 0xa46e, 0xa489,
	0xa4a4, 0xa4b1, 0xa4bf, 0xa4cc, 0xa4da, 0xa4e7, 0xa4f5, 0xa50a,
	0xa520, 0xa535, 0xa54b, 0xa558, 0xa566, 0xa573, 0xa581, 0xa58f,
	// Entry 4DC0 - 4DFF
	0xa59e, 0xa5ac, 0xa5bb, 0xa5ca, 0xa5da, 0xa5e8, 0xa5f7, 0xa605,
	0xa614, 0xa623, 0xa633, 0xa642, 0xa652, 0xa661, 0xa671, 0xa680,
	0xa68e, 0xa69d, 0xa6ab, 0xa6ba, 0xa6c8, 0xa6d7, 0xa6e5, 0xa6f4,
	0xa702, 0xa711, 0xa71f, 0xa72e, 0xa73c, 0xa74a, 0xa759, 0xa767,
	0xa776, 0xa784, 0xa793, 0xa7a2, 0xa7b0, 0xa7be, 0xa7d0, 0xa7e1,
	0xa7f3, 0xa804, 0xa816, 0xa82f, 0xa849, 0xa862, 0xa87c, 0xa88d,
	0xa89f, 0xa8b0, 0xa8c2, 0xa8d2, 0xa8e7, 0xa8f9, 0xa90a, 0xa919,
	0xa92b, 0xa943, 0xa94a, 0xa955, 0xa95f, 0xa970, 0xa97a, 0xa989,
	// Entry 4E00 - 4E3F
	0xa99f, 0xa9ae, 0xa9bc, 0xa9ca, 0xa9da, 0xa9e9, 0xa9f8, 0xaa06,
	0xaa16, 0xaa26, 0xaa35, 0xaa46, 0xaa5b, 0xaa6e, 0xaa7e, 0xaa98,
	0xaaad, 0xaac2, 0xaace, 0xaade, 0xaaef, 0xaaff, 0xab10, 0xab20,
	0xab31, 0xab49, 0xab62, 0xab7a, 0xab93, 0xaba3, 0xabb4, 0xabc4,
	0xabd5, 0xabe6, 0xabf8, 0xac09, 0xac1b, 0xac2d, 0xac3e, 0xac50,
	0xac61, 0xac73, 0xac85, 0xac97, 0xacaa, 0xacbc, 0xaccf, 0xace1,
	0xacf2, 0xad04, 0xad15, 0xad27, 0xad38, 0xad49, 0xad5b, 0xad6c,
	0xad7e, 0xad8f, 0xada0, 0xadb1, 0xadc2, 0xadd3, 0xade5, 0xadf7,
	// Entry 4E40 - 4E7F
	0xae08, 0xae19, 0xae2e, 0xae42, 0xae57, 0xae6b, 0xae80, 0xae9c,
	0xaeb9, 0xaed5, 0xaef2, 0xaf06, 0xaf20, 0xaf35, 0xaf49, 0xaf63,
	0xaf78, 0xaf90, 0xafa5, 0xafb9, 0xafcc, 0xafde, 0xaff3, 0xb000,
	0xb019, 0xb023, 0xb035, 0xb046, 0xb057, 0xb06a, 0xb07c, 0xb08e,
	0xb09f, 0xb0b2, 0xb0c5, 0xb0d7, 0xb0e7, 0xb0f8, 0xb108, 0xb119,
	0xb129, 0xb13a, 0xb152, 0xb16b, 0xb183, 0xb19c, 0xb1ac, 0xb1bd,
	0xb1cd, 0xb1de, 0xb1ef, 0xb201, 0xb212, 0xb224, 0xb236, 0xb247,
	0xb259, 0xb26a, 0xb27c, 0xb28e, 0xb2a0, 0xb2b3, 0xb2c5, 0xb2d8,
	// Entry 4E80 - 4EBF
	0xb2ea, 0xb2fb, 0xb30d, 0xb31e, 0xb330, 0xb341, 0xb352, 0xb364,
	0xb375, 0xb387, 0xb398, 0xb3a9, 0xb3ba, 0xb3cb, 0xb3dc, 0xb3ee,
	0xb400, 0xb411, 0xb422, 0xb437, 0xb44b, 0xb460, 0xb474, 0xb489,
	0xb4a5, 0xb4c2, 0xb4d6, 0xb4eb, 0xb4ff, 0xb514, 0xb52c, 0xb541,
	0xb555, 0xb568, 0xb57a, 0xb58e, 0xb59b, 0xb5af, 0xb5c4, 0xb5d9,
	0xb5f2, 0xb60b, 0xb624, 0xb63c, 0xb674, 0xb6aa, 0xb6dd, 0xb717,
	0xb751, 0xb771, 0xb79b, 0xb7c5, 0xb7ef, 0xb81c, 0xb848, 0xb872,
	0xb8a6, 0xb8db, 0xb902, 0xb927, 0xb94d, 0xb967, 0xb985, 0xb9a4,
	// Entry 4EC0 - 4EFF
	0xb9b1, 0xb9bf, 0xb9cc, 0xb9da, 0xb9e7, 0xb9f5, 0xba0a, 0xba20,
	0xba35, 0xba4b, 0xba58, 0xba66, 0xba73, 0xba81, 0xba8f, 0xba9e,
	0xbaac, 0xbabb, 0xbaca, 0xbad8, 0xbae7, 0xbaf5, 0xbb04, 0xbb13,
	0xbb22, 0xbb32, 0xbb41, 0xbb51, 0xbb60, 0xbb6e, 0xbb7d, 0xbb8b,
	0xbb9a, 0xbba8, 0xbbb6, 0xbbc5, 0xbbd3, 0xbbe2, 0xbbf0, 0xbbfe,
	0xbc0c, 0xbc1a, 0xbc28, 0xbc37, 0xbc46, 0xbc54, 0xbc62, 0xbc71,
	0xbc83, 0xbc94, 0xbca6, 0xbcb7, 0xbcc9, 0xbce2, 0xbcfc, 0xbd15,
	0xbd2f, 0xbd40, 0xbd52, 0xbd63, 0xbd75, 0xbd87, 0xbd98, 0xbda8,
	// Entry 4F00 - 4F3F
	0xbdbd, 0xbdc7, 0xbdd8, 0xbdee, 0xbdfc, 0xbe0b, 0xbe19, 0xbe27,
	0xbe37, 0xbe46, 0xbe55, 0xbe63, 0xbe73, 0xbe83, 0xbe92, 0xbeaf,
	0xbec6, 0xbeea, 0xbf0e, 0xbf32, 0xbf57, 0xbf83, 0xbf9b, 0xbfc8,
	0xbfdd, 0xc000, 0xc02a, 0xc05b, 0xc069, 0xc078, 0xc086, 0xc095,
	0xc0a3, 0xc0b2, 0xc0c0, 0xc0cf, 0xc0dd, 0xc0ec, 0xc0fb, 0xc10b,
	0xc11a, 0xc12a, 0xc13a, 0xc149, 0xc159, 0xc168, 0xc178, 0xc188,
	0xc198, 0xc1a9, 0xc1b9, 0xc1ca, 0xc1da, 0xc1e9, 0xc1f9, 0xc208,
	0xc218, 0xc227, 0xc236, 0xc246, 0xc255, 0xc265, 0xc274, 0xc283,
	// Entry 4F40 - 4F7F
	0xc292, 0xc2a1, 0xc2b0, 0xc2c0, 0xc2cf, 0xc2de, 0xc2ee, 0xc301,
	0xc313, 0xc326, 0xc338, 0xc34b, 0xc35d, 0xc370, 0xc382, 0xc395,
	0xc3a7, 0xc3ba, 0xc3cb, 0xc3db, 0xc3f3, 0xc403, 0xc412, 0xc421,
	0xc432, 0xc442, 0xc452, 0xc461, 0xc472, 0xc483, 0xc493, 0xc4a1,
	0xc4b0, 0xc4bf, 0xc4cd, 0xc4db, 0xc4f3, 0xc501, 0xc510, 0xc51e,
	0xc52c, 0xc53a, 0xc549, 0xc558, 0xc566, 0xc574, 0xc582, 0xc591,
	0xc59f, 0xc5ac, 0xc5ba, 0xc5c9, 0xc5d7, 0xc5ef, 0xc5fe, 0xc60d,
	0xc61c, 0xc634, 0xc651, 0xc66e, 0xc694, 0xc6a5, 0xc6b7, 0xc6c8,
	// Entry 4F80 - 4FBF
	0xc6da, 0xc6eb, 0xc6fd, 0xc70e, 0xc720, 0xc731, 0xc743, 0xc755,
	0xc765, 0xc774, 0xc782, 0xc790, 0xc7a0, 0xc7af, 0xc7be, 0xc7cc,
	0xc7dc, 0xc7ec, 0xc7fb, 0xc80a, 0xc81c, 0xc833, 0xc844, 0xc853,
	0xc861, 0xc86f, 0xc87e, 0xc88c, 0xc89b, 0xc8a9, 0xc8b8, 0xc8c6,
	0xc8d5, 0xc8e3, 0xc8f2, 0xc901, 0xc911, 0xc920, 0xc930, 0xc940,
	0xc94f, 0xc95f, 0xc96e, 0xc97e, 0xc98e, 0xc99e, 0xc9af, 0xc9bf,
	0xc9d0, 0xc9e0, 0xc9ef, 0xc9ff, 0xca0e, 0xca1e, 0xca2d, 0xca3c,
	0xca4c, 0xca5b, 0xca6b, 0xca7a, 0xca89, 0xca98, 0xcaa7, 0xcab6,
	// Entry 4FC0 - 4FFF
	0xcac6, 0xcad6, 0xcae5, 0xcaf4, 0xcb04, 0xcb17, 0xcb29, 0xcb3c,
	0xcb4e, 0xcb61, 0xcb7b, 0xcb96, 0xcba8, 0xcbbb, 0xcbcd, 0xcbe0,
	0xcbf3, 0xcc05, 0xcc16, 0xcc26, 0xcc3d, 0xcc5c, 0xcc78, 0xcc95,
	0xccb2, 0xcccf, 0xccec, 0xcd09, 0xcd26, 0xcd42, 0xcd5e, 0xcd7c,
	0xcd99, 0xcdb6, 0xcdd4, 0xcdf2, 0xce0f, 0xce2d, 0xce4b, 0xce69,
	0xce88, 0xcea5, 0xcec2, 0xcedf, 0xcefc, 0xcf19, 0xcf38, 0xcf57,
	0xcf76, 0xcf94, 0xcfb3, 0xcfd1, 0xcff0, 0xd00d, 0xd027, 0xd042,
	0xd05d, 0xd078, 0xd093, 0xd0ae, 0xd0c9, 0xd0e3, 0xd0fd, 0xd119,
	// Entry 5000 - 503F
	0xd134, 0xd14f, 0xd16b, 0xd187, 0xd1a2, 0xd1be, 0xd1da, 0xd1f6,
	0xd213, 0xd22e, 0xd249, 0xd264, 0xd27f, 0xd29a, 0xd2b7, 0xd2d4,
	0xd2f1, 0xd30d, 0xd32a, 0xd346, 0xd363, 0xd379, 0xd38e, 0xd3a3,
	0xd3ba, 0xd3d0, 0xd3e6, 0xd3fb, 0xd412, 0xd429, 0xd43f, 0xd455,
	0xd46e, 0xd487, 0xd49f, 0xd4b7, 0xd4cf, 0xd4e9, 0xd502, 0xd51b,
	0xd529, 0xd53d, 0xd552, 0xd566, 0xd57b, 0xd58f, 0xd5a4, 0xd5b8,
	0xd5cc, 0xd5e1, 0xd5f7, 0xd60c, 0xd622, 0xd638, 0xd64d, 0xd663,
	0xd678, 0xd68e, 0xd6a4, 0xd6ba, 0xd6d1, 0xd6e7, 0xd6fc, 0xd712,
	// Entry 5040 - 507F
	0xd727, 0xd73d, 0xd752, 0xd767, 0xd77d, 0xd792, 0xd7a8, 0xd7bd,
	0xd7d2, 0xd7e8, 0xd7fd, 0xd812, 0xd827, 0xd83d, 0xd853, 0xd868,
	0xd87d, 0xd893, 0xd8a8, 0xd8c1, 0xd8d9, 0xd8f2, 0xd90a, 0xd923,
	0xd93b, 0xd954, 0xd96c, 0xd985, 0xd9a1, 0xd9b9, 0xd9cb, 0xd9ea,
	0xd9ff, 0xda15, 0xda2a, 0xda40, 0xda58, 0xda6e, 0xda8a, 0xdaa0,
	0xdab5, 0xdaca, 0xdae1, 0xdaf7, 0xdb0d, 0xdb22, 0xdb39, 0xdb50,
	0xdb66, 0xdb7a, 0xdb8f, 0xdba3, 0xdbb8, 0xdbcc, 0xdbe1, 0xdbfd,
	0xdc1a, 0xdc2e, 0xdc43, 0xdc57, 0xdc6c, 0xdc81, 0xdc97, 0xdcac,
	// Entry 5080 - 50BF
	0xdcc2, 0xdcd8, 0xdced, 0xdd03, 0xdd18, 0xdd2e, 0xdd44, 0xdd5a,
	0xdd71, 0xdd87, 0xdd9e, 0xddb4, 0xddc9, 0xdddf, 0xddf4, 0xde0a,
	0xde1f, 0xde34, 0xde4a, 0xde5f, 0xde75, 0xde8a, 0xde9f, 0xdeb4,
	0xdec9, 0xdede, 0xdef4, 0xdf0a, 0xdf1f, 0xdf34, 0xdf4a, 0xdf60,
	0xdf79, 0xdf91, 0xdfaa, 0xdfc2, 0xdfdb, 0xdffb, 0xe01c, 0xe034,
	0xe04d, 0xe065, 0xe07e, 0xe097, 0xe0af, 0xe0c6, 0xe0df, 0xe0f7,
	0xe10d, 0xe133, 0xe14c, 0xe169, 0xe187, 0xe1a4, 0xe1c1, 0xe1df,
	0xe1fc, 0xe21a, 0xe238, 0xe25e, 0xe280, 0xe29a, 0xe2b5, 0xe2cf,
	// Entry 50C0 - 50FF
	0xe2ea, 0xe305, 0xe31f, 0xe33a, 0xe354, 0xe36f, 0xe38a, 0xe3a6,
	0xe3c1, 0xe3dd, 0xe3f8, 0xe412, 0xe42d, 0xe447, 0xe462, 0xe47c,
	0xe496, 0xe4b1, 0xe4cb, 0xe4e6, 0xe500, 0xe51b, 0xe537, 0xe552,
	0xe56e, 0xe589, 0xe5a3, 0xe5bd, 0xe5d7, 0xe5f1, 0xe60b, 0xe625,
	0xe640, 0xe65b, 0xe675, 0xe68f, 0xe6ab, 0xe6d0, 0xe6ec, 0xe70d,
	0xe73c, 0xe766, 0xe784, 0xe7a1, 0xe7cb, 0xe7f3, 0xe81b, 0xe843,
	0xe86b, 0xe88d, 0xe8af, 0xe8ca, 0xe8e4, 0xe905, 0xe925, 0xe954,
	0xe983, 0xe99d, 0xe9ad, 0xe9c1, 0xe9d6, 0xe9ea, 0xe9fe, 0xea12,
	// Entry 5100 - 513F
	0xea27, 0xea3c, 0xea51, 0xea6d, 0xea89, 0xeaa2, 0xeab3, 0xeac5,
	0xead6, 0xeae8, 0xeafa, 0xeb0b, 0xeb1d, 0xeb2e, 0xeb40, 0xeb52,
	0xeb64, 0xeb77, 0xeb89, 0xeb9c, 0xebae, 0xebbf, 0xebd1, 0xebe2,
	0xebf4, 0xec05, 0xec16, 0xec28, 0xec39, 0xec4b, 0xec5c, 0xec6e,
	0xec81, 0xec93, 0xeca5, 0xecb6, 0xecc7, 0xecd8, 0xece9, 0xecfa,
	0xed0b, 0xed1d, 0xed2f, 0xed40, 0xed51, 0xed64, 0xed7c, 0xed94,
	0xedb5, 0xedd6, 0xedf8, 0xee19, 0xee37, 0xee55, 0xee74, 0xee92,
	0xeeb0, 0xeece, 0xeeec, 0xef0a, 0xef28, 0xef47, 0xef65, 0xef84,
	// Entry 5140 - 517F
	0xef99, 0xefad, 0xefc4, 0xefd5, 0xefe7, 0xeff8, 0xf010, 0xf022,
	0xf056, 0xf083, 0xf0a6, 0xf0bd, 0xf0d4, 0xf0e9, 0xf0fe, 0xf113,
	0xf128, 0xf13d, 0xf152, 0xf167, 0xf17d, 0xf192, 0xf1a7, 0xf1bd,
	0xf1d2, 0xf1e7, 0xf1fc, 0xf211, 0xf227, 0xf23c, 0xf252, 0xf267,
	0xf27c, 0xf292, 0xf2a6, 0xf2ba, 0xf2ce, 0xf2e2, 0xf2f6, 0xf30b,
	0xf320, 0xf33a, 0xf354, 0xf36e, 0xf388, 0xf3a2, 0xf3bc, 0xf3d6,
	0xf3f1, 0xf40b, 0xf427, 0xf43e, 0xf45d, 0xf47f, 0xf49c, 0xf4c1,
	0xf4dd, 0xf4f4, 0xf516, 0xf533, 0xf54d, 0xf56d, 0xf592, 0xf5b2,
	// Entry 5180 - 51BF
	0xf5d3, 0xf5ef, 0xf607, 0xf62e, 0xf650, 0xf66e, 0xf680, 0xf693,
	0xf6a5, 0xf6b8, 0xf6ca, 0xf6dd, 0xf6f7, 0xf712, 0xf72c, 0xf73e,
	0xf751, 0xf763, 0xf776, 0xf789, 0xf79d, 0xf7b0, 0xf7c4, 0xf7d8,
	0xf7eb, 0xf7ff, 0xf812, 0xf826, 0xf83a, 0xf84e, 0xf863, 0xf877,
	0xf88c, 0xf8a0, 0xf8b3, 0xf8c7, 0xf8da, 0xf8ee, 0xf901, 0xf914,
	0xf928, 0xf93b, 0xf94f, 0xf962, 0xf975, 0xf988, 0xf99b, 0xf9ae,
	0xf9c2, 0xf9d6, 0xf9e9, 0xf9fc, 0xfa13, 0xfa29, 0xfa40, 0xfa56,
	0xfa6d, 0xfa8b, 0xfaaa, 0xfac8, 0xfade, 0xfaf5, 0xfb0b, 0xfb22,
	// Entry 51C0 - 51FF
	0xfb3c, 0xfb53, 0xfb69, 0xfb7e, 0xfb95, 0xfba4, 0xfbba, 0xfbd2,
	0xfbe8, 0xfbfe, 0xfc12, 0xfc25, 0xfc38, 0xfc4d, 0xfc61, 0xfc75,
	0xfc88, 0xfc9d, 0xfcb2, 0xfcc6, 0xfcda, 0xfcee, 0xfd04, 0xfd19,
	0xfd2e, 0xfd42, 0xfd58, 0xfd6e, 0xfd83, 0xfd97, 0xfdae, 0xfdc5,
	0xfddb, 0xfdf1, 0xfe07, 0xfe1f, 0xfe36, 0xfe4d, 0xfe69, 0xfe7a,
	0xfe8b, 0xfe9c, 0xfeae, 0xfebf, 0xfed1, 0xfee2, 0xfef4, 0xff05,
	0xff17, 0xff28, 0xff3a, 0xff4b, 0xff5c, 0xff6d, 0xff7f, 0xff90,
	0xffa1, 0xffb3, 0xffc6, 0xffd8, 0xffe9, 0xfffb, 0x000c, 0x001d,
	// Entry 5200 - 523F
	0x002e, 0x003f, 0x0050, 0x0062, 0x0073, 0x0084, 0x0094, 0x00af,
	0x00cb, 0x00e6, 0x0102, 0x011d, 0x0139, 0x0154, 0x0170, 0x018b,
	0x01a7, 0x01c2, 0x01dd, 0x01f8, 0x0214, 0x022f, 0x024a, 0x0266,
	0x0283, 0x029f, 0x02ba, 0x02d6, 0x02f1, 0x030c, 0x0327, 0x0342,
	0x035e, 0x0379, 0x0394, 0x03ae, 0x03c3, 0x03d7, 0x03eb, 0x03ff,
	0x0413, 0x0428, 0x0440, 0x0456, 0x046d, 0x0483, 0x049a, 0x04b0,
	0x04c7, 0x04dd, 0x04f4, 0x050a, 0x0521, 0x0538, 0x0550, 0x0567,
	0x057f, 0x0597, 0x05ae, 0x05c6, 0x05dd, 0x05f5, 0x060d, 0x0625,
	// Entry 5240 - 527F
	0x063e, 0x0656, 0x066f, 0x0687, 0x069e, 0x06b6, 0x06cd, 0x06e5,
	0x06fc, 0x0713, 0x072b, 0x0742, 0x075a, 0x0771, 0x0788, 0x079f,
	0x07b6, 0x07cd, 0x07e5, 0x07fd, 0x0814, 0x082b, 0x0843, 0x085c,
	0x0875, 0x088d, 0x08a8, 0x08c2, 0x08dd, 0x08f7, 0x0912, 0x0934,
	0x094e, 0x0969, 0x0983, 0x099e, 0x09b9, 0x09d3, 0x09eb, 0x0a04,
	0x0a1e, 0x0a32, 0x0a45, 0x0a5a, 0x0a72, 0x0a89, 0x0aa0, 0x0ab9,
	0x0ad1, 0x0ae9, 0x0b00, 0x0b19, 0x0b32, 0x0b4a, 0x0b60, 0x0b77,
	0x0b8d, 0x0ba4, 0x0bba, 0x0bd1, 0x0be8, 0x0bff, 0x0c16, 0x0c2d,
	// Entry 5280 - 52BF
	0x0c44, 0x0c5b, 0x0c72, 0x0c8a, 0x0ca1, 0x0cb8, 0x0cd0, 0x0ce7,
	0x0cff, 0x0d16, 0x0d2d, 0x0d45, 0x0d5c, 0x0d74, 0x0d8b, 0x0da2,
	0x0dba, 0x0dd2, 0x0deb, 0x0e03, 0x0e1a, 0x0e32, 0x0e4a, 0x0e63,
	0x0e7b, 0x0e92, 0x0eaa, 0x0ec1, 0x0ed8, 0x0eef, 0x0f0a, 0x0f24,
	0x0f3f, 0x0f59, 0x0f74, 0x0f8f, 0x0faa, 0x0fc5, 0x0fe0, 0x0ffb,
	0x1015, 0x1029, 0x1039, 0x1051, 0x1068, 0x107f, 0x1098, 0x10b0,
	0x10c8, 0x10df, 0x10f8, 0x1111, 0x1129, 0x113a, 0x114b, 0x115d,
	0x116e, 0x117f, 0x1190, 0x11a1, 0x11b2, 0x11c3, 0x11d4, 0x11e5,
	// Entry 52C0 - 52FF
	0x11f7, 0x1208, 0x1219, 0x122a, 0x123b, 0x124c, 0x125c, 0x1269,
	0x127d, 0x1291, 0x12a5, 0x12b9, 0x12cb, 0x12e1, 0x12f0, 0x131e,
	0x1349, 0x1365, 0x1384, 0x139f, 0x13bf, 0x13de, 0x1400, 0x141c,
	0x143a, 0x1458, 0x1470, 0x1489, 0x14a8, 0x14c7, 0x14df, 0x14f9,
	0x1512, 0x152b, 0x1548, 0x156f, 0x157d, 0x158e, 0x15a2, 0x15b4,
	0x15ca, 0x15db, 0x15ee, 0x1602, 0x1612, 0x1622, 0x1630, 0x1643,
	0x1654, 0x1664, 0x1673, 0x168d, 0x16a7, 0x16b6, 0x16c9, 0x16e6,
	0x1703, 0x1715, 0x1727, 0x1737, 0x1747, 0x175f, 0x1777, 0x178b,
	// Entry 5300 - 533F
	0x17a0, 0x17bd, 0x17cd, 0x17e5, 0x17ff, 0x181f, 0x1838, 0x1852,
	0x1873, 0x188e, 0x18a8, 0x18b9, 0x18ca, 0x18e6, 0x1907, 0x1922,
	0x1943, 0x195d, 0x197d, 0x1999, 0x19b6, 0x19d3, 0x19fa, 0x1a10,
	0x1a22, 0x1a40, 0x1a62, 0x1a85, 0x1aa2, 0x1abf, 0x1ad0, 0x1ae1,
	0x1afe, 0x1b25, 0x1b36, 0x1b50, 0x1b6c, 0x1b88, 0x1ba2, 0x1bbe,
	0x1bd8, 0x1bf3, 0x1c0e, 0x1c21, 0x1c35, 0x1c48, 0x1c65, 0x1c76,
	0x1c8f, 0x1cac, 0x1cdd, 0x1d00, 0x1d14, 0x1d27, 0x1d3a, 0x1d57,
	0x1d6b, 0x1d7f, 0x1d91, 0x1dad, 0x1dc9, 0x1e06, 0x1e2a, 0x1e6d,
	// Entry 5340 - 537F
	0x1e80, 0x1e95, 0x1ea6, 0x1eb8, 0x1ecb, 0x1ee0, 0x1ef2, 0x1f0d,
	0x1f21, 0x1f33, 0x1f47, 0x1f58, 0x1f71, 0x1f8c, 0x1fac, 0x1fbd,
	0x1fd9, 0x1ff5, 0x2012, 0x2026, 0x2045, 0x2057, 0x206a, 0x207b,
	0x208d, 0x20b8, 0x20dc, 0x2101, 0x2123, 0x2145, 0x2171, 0x2193,
	0x21b7, 0x21da, 0x21fc, 0x221e, 0x2248, 0x226b, 0x228d, 0x22af,
	0x22dc, 0x22ff, 0x2321, 0x234d, 0x236f, 0x2393, 0x23bf, 0x23e2,
	0x23f4, 0x2406, 0x241a, 0x242e, 0x243f, 0x2451, 0x2463, 0x247f,
	0x2492, 0x24a4, 0x24c9, 0x24dc, 0x24ed, 0x2506, 0x251c, 0x2535,
	// Entry 5380 - 53BF
	0x2547, 0x2564, 0x2577, 0x2589, 0x259d, 0x25af, 0x25c1, 0x25d4,
	0x25ec, 0x2609, 0x261c, 0x262f, 0x263f, 0x2659, 0x267d, 0x268e,
	0x26b7, 0x26d2, 0x26ec, 0x2707, 0x2722, 0x273b, 0x274e, 0x2761,
	0x2772, 0x2783, 0x279f, 0x27c0, 0x27da, 0x27f7, 0x2814, 0x282d,
	0x2840, 0x2854, 0x2867, 0x287a, 0x2895, 0x28b9, 0x28e7, 0x2903,
	0x2920, 0x2943, 0x296b, 0x2987, 0x29a8, 0x29ca, 0x29ea, 0x2a12,
	0x2a2f, 0x2a4b, 0x2a72, 0x2a8e, 0x2aaa, 0x2ac6, 0x2ae2, 0x2af3,
	0x2b09, 0x2b1b, 0x2b45, 0x2b67, 0x2b8a, 0x2bb4, 0x2bcf, 0x2beb,
	// Entry 53C0 - 53FF
	0x2c11, 0x2c2d, 0x2c51, 0x2c6d, 0x2c91, 0x2cac, 0x2cc7, 0x2ced,
	0x2d09, 0x2d24, 0x2d47, 0x2d62, 0x2d8d, 0x2daf, 0x2dcb, 0x2de6,
	0x2e02, 0x2e25, 0x2e4a, 0x2e77, 0x2e93, 0x2eb7, 0x2eda, 0x2ef7,
	0x2f18, 0x2f45, 0x2f61, 0x2f80, 0x2f9c, 0x2fc1, 0x2fe5, 0x3000,
	0x3023, 0x303e, 0x305a, 0x307f, 0x309a, 0x30b6, 0x30d2, 0x30ee,
	0x3113, 0x3130, 0x314c, 0x3169, 0x3183, 0x319e, 0x31c1, 0x31dc,
	0x31ef, 0x3210, 0x3222, 0x324a, 0x325c, 0x3288, 0x329c, 0x32ae,
	0x32c0, 0x32d3, 0x32eb, 0x3308, 0x3329, 0x333b, 0x334e, 0x3363,
	// Entry 5400 - 543F
	0x3379, 0x3399, 0x33aa, 0x33c3, 0x33dc, 0x33f9, 0x340b, 0x3426,
	0x3445, 0x3459, 0x346c, 0x3484, 0x3497, 0x34bb, 0x34de, 0x34fb,
	0x3520, 0x353c, 0x3550, 0x3563, 0x3584, 0x35a1, 0x35bf, 0x35d7,
	0x35e8, 0x3605, 0x3617, 0x3633, 0x365e, 0x367a, 0x36a0, 0x36b7,
	0x36c9, 0x36ec, 0x3708, 0x3729, 0x373b, 0x374d, 0x3769, 0x377b,
	0x378e, 0x37a2, 0x37b7, 0x37c8, 0x37de, 0x37f4, 0x3806, 0x3817,
	0x3832, 0x384e, 0x3869, 0x3885, 0x38a0, 0x38bb, 0x38d6, 0x38f1,
	0x390a, 0x391b, 0x392e, 0x394a, 0x3967, 0x3987, 0x39a5, 0x39c1,
	// Entry 5440 - 547F
	0x39d4, 0x39e4, 0x39f6, 0x3a07, 0x3a1a, 0x3a3b, 0x3a60, 0x3a71,
	0x3a83, 0x3a99, 0x3aae, 0x3ae3, 0x3afa, 0x3b0b, 0x3b2c, 0x3b3e,
	0x3b4f, 0x3b6b, 0x3b88, 0x3ba5, 0x3bbe, 0x3bd1, 0x3be2, 0x3bf3,
	0x3c05, 0x3c16, 0x3c2f, 0x3c49, 0x3c6c, 0x3c88, 0x3ca3, 0x3cc0,
	0x3cdb, 0x3cf5, 0x3d12, 0x3d2e, 0x3d48, 0x3d63, 0x3d84, 0x3d9f,
	0x3dcb, 0x3de5, 0x3e01, 0x3e26, 0x3e50, 0x3e6a, 0x3e86, 0x3ea1,
	0x3ebb, 0x3ed6, 0x3ef0, 0x3f0b, 0x3f25, 0x3f3f, 0x3f59, 0x3f7b,
	0x3f9d, 0x3fbf, 0x3fd9, 0x3ffe, 0x4018, 0x4033, 0x404d, 0x4067,
	// Entry 5480 - 54BF
	0x4081, 0x409c, 0x40b7, 0x40d2, 0x40ee, 0x4109, 0x4124, 0x4141,
	0x415c, 0x4175, 0x418f, 0x41a9, 0x41ce, 0x41e9, 0x4203, 0x4215,
	0x4234, 0x4246, 0x4259, 0x426c, 0x427f, 0x4292, 0x42af, 0x42c1,
	0x42e2, 0x42f4, 0x4310, 0x432f, 0x4342, 0x4355, 0x436a, 0x43a0,
	0x43e2, 0x43f6, 0x4407, 0x4422, 0x443b, 0x4455, 0x4467, 0x4479,
	0x448d, 0x44a0, 0x44b5, 0x44d6, 0x44e7, 0x4521, 0x4533, 0x4545,
	0x4564, 0x4576, 0x4588, 0x459f, 0x45b1, 0x45c3, 0x45e2, 0x45f7,
	0x460c, 0x461d, 0x4631, 0x464d, 0x4679, 0x469e, 0x46c3, 0x46e0,
	// Entry 54C0 - 54FF
	0x46fd, 0x4725, 0x4743, 0x4760, 0x477e, 0x479b, 0x47b8, 0x47d6,
	0x47f4, 0x481b, 0x4838, 0x4856, 0x487d, 0x48a0, 0x48bd, 0x48e2,
	0x4907, 0x4924, 0x4942, 0x4960, 0x497e, 0x49ab, 0x49cb, 0x49ea,
	0x4a07, 0x4a25, 0x4a42, 0x4a67, 0x4a86, 0x4aa3, 0x4aca, 0x4aff,
	0x4b2e, 0x4b4d, 0x4b76, 0x4b94, 0x4bb2, 0x4bd1, 0x4c05, 0x4c21,
	0x4c44, 0x4c6e, 0x4c94, 0x4cb1, 0x4ccf, 0x4ceb, 0x4cff, 0x4d1d,
	0x4d44, 0x4d5d, 0x4d8a, 0x4d9f, 0x4db1, 0x4dcd, 0x4ddf, 0x4dfb,
	0x4e1f, 0x4e30, 0x4e42, 0x4e57, 0x4e6a, 0x4e7b, 0x4e96, 0x4ea8,
	// Entry 5500 - 553F
	0x4ec3, 0x4edf, 0x4efc, 0x4f1e, 0x4f40, 0x4f65, 0x4f80, 0x4f9d,
	0x4fba, 0x4fe0, 0x4ffb, 0x501f, 0x503d, 0x5060, 0x507b, 0x5096,
	0x50ba, 0x50df, 0x50fc, 0x5113, 0x5132, 0x5151, 0x516b, 0x5185,
	0x5197, 0x51ab, 0x51ca, 0x51ed, 0x5209, 0x521b, 0x522d, 0x523f,
	0x525a, 0x5282, 0x5293, 0x52af, 0x52c5, 0x52d7, 0x52e9, 0x52fb,
	0x530e, 0x5322, 0x5333, 0x5345, 0x5356, 0x5368, 0x5379, 0x5392,
	0x53a4, 0x53bb, 0x53d0, 0x53e5, 0x53f8, 0x5413, 0x5430, 0x544c,
	0x5469, 0x5496, 0x54b7, 0x54cb, 0x54e7, 0x550b, 0x5528, 0x5541,
	// Entry 5540 - 557F
	0x5552, 0x5564, 0x5577, 0x5593, 0x55b5, 0x55d6, 0x55ea, 0x5604,
	0x5616, 0x5629, 0x563a, 0x5653, 0x566d, 0x5686, 0x5697, 0x56b0,
	0x56c2, 0x56d4, 0x56f6, 0x5721, 0x5736, 0x5754, 0x5773, 0x579b,
	0x57ba, 0x57e7, 0x5805, 0x5824, 0x5843, 0x586c, 0x5894, 0x58c5,
	0x58ec, 0x590b, 0x591f, 0x5930, 0x5943, 0x5955, 0x5977, 0x599a,
	0x59bc, 0x59f7, 0x5a19, 0x5a30, 0x5a4b, 0x5a6a, 0x5a9a, 0x5aae,
	0x5ad3, 0x5af4, 0x5b16, 0x5b38, 0x5b5f, 0x5b82, 0x5ba3, 0x5bc4,
	0x5be8, 0x5c09, 0x5c2d, 0x5c53, 0x5c64, 0x5c76, 0x5c88, 0x5c9a,
	// Entry 5580 - 55BF
	0x5cae, 0x5cbf, 0x5cd8, 0x5cf2, 0x5d0c, 0x5d26, 0x5d3f, 0x5d58,
	0x5d72, 0x5d8b, 0x5da5, 0x5dc2, 0x5dd6, 0x5df4, 0x5e11, 0x5e2e,
	0x5e51, 0x5e62, 0x5e74, 0x5e85, 0x5e96, 0x5ea7, 0x5ec1, 0x5ed3,
	0x5eed, 0x5f08, 0x5f24, 0x5f3f, 0x5f5b, 0x5f77, 0x5f93, 0x5fae,
	0x5fca, 0x5fe6, 0x6003, 0x601f, 0x603a, 0x6055, 0x6070, 0x608b,
	0x60a7, 0x60c2, 0x60d9, 0x60eb, 0x610e, 0x6123, 0x6135, 0x6147,
	0x615a, 0x6175, 0x6192, 0x61b0, 0x61cc, 0x61ea, 0x6207, 0x6222,
	0x6244, 0x6257, 0x626b, 0x627f, 0x6291, 0x62a6, 0x62db, 0x6310,
	// Entry 55C0 - 55FF
	0x6324, 0x6337, 0x634b, 0x6360, 0x6377, 0x638a, 0x63a5, 0x63c1,
	0x63d4, 0x63ef, 0x640c, 0x642b, 0x6448, 0x6465, 0x6482, 0x64a4,
	0x64c4, 0x64e1, 0x64fe, 0x651b, 0x6530, 0x6543, 0x655b, 0x6585,
	0x6599, 0x65ab, 0x65cf, 0x65e2, 0x65f7, 0x6608, 0x661e, 0x6630,
	0x6643, 0x6665, 0x6678, 0x668c, 0x669d, 0x66b6, 0x66c8, 0x66db,
	0x66ef, 0x6701, 0x6716, 0x6728, 0x673b, 0x674c, 0x6766, 0x6780,
	0x679a, 0x67b0, 0x67c2, 0x67f7, 0x6811, 0x6823, 0x683e, 0x685a,
	0x6876, 0x6892, 0x68af, 0x68ca, 0x68dd, 0x68ef, 0x6900, 0x6916,
	// Entry 5600 - 563F
	0x6927, 0x693d, 0x694f, 0x6961, 0x697e, 0x6999, 0x69ce, 0x69df,
	0x69f2, 0x6a04, 0x6a16, 0x6a28, 0x6a4e, 0x6a5e, 0x6a72, 0x6a86,
	0x6ab5, 0x6ad9, 0x6b0b, 0x6b1c, 0x6b2d, 0x6b3e, 0x6b56, 0x6b71,
	0x6b8b, 0x6bb2, 0x6bde, 0x6bf4, 0x6c0d, 0x6c30, 0x6c43, 0x6c54,
	0x6c71, 0x6c93, 0x6caf, 0x6cc8, 0x6cdc, 0x6cef, 0x6d0f, 0x6d2b,
	0x6d3c, 0x6d52, 0x6d63, 0x6d80, 0x6d99, 0x6dab, 0x6dcd, 0x6def,
	0x6e0a, 0x6e25, 0x6e41, 0x6e5c, 0x6e80, 0x6ea3, 0x6eb5, 0x6ec7,
	0x6eda, 0x6eec, 0x6f06, 0x6f25, 0x6f41, 0x6f5d, 0x6f78, 0x6f94,
	// Entry 5640 - 567F
	0x6fb6, 0x6fd2, 0x6fed, 0x7008, 0x7024, 0x703f, 0x705b, 0x7076,
	0x7092, 0x70ae, 0x70c9, 0x70e5, 0x7102, 0x711d, 0x7140, 0x715b,
	0x7179, 0x718d, 0x71a9, 0x71bb, 0x71d5, 0x71f0, 0x720c, 0x7229,
	0x723c, 0x724f, 0x7264, 0x7278, 0x728a, 0x72a9, 0x72bb, 0x72cc,
	0x72e2, 0x7305, 0x7317, 0x732a, 0x733c, 0x734d, 0x7366, 0x7378,
	0x738a, 0x73a6, 0x73b8, 0x73cb, 0x73dc, 0x73ee, 0x7408, 0x741c,
	0x742e, 0x7448, 0x7463, 0x747d, 0x749a, 0x74c6, 0x74d9, 0x74f5,
	0x7511, 0x752e, 0x754b, 0x7576, 0x7593, 0x75a6, 0x75b8, 0x75cb,
	// Entry 5680 - 56BF
	0x75e8, 0x7604, 0x7620, 0x763b, 0x7660, 0x767b, 0x7695, 0x76b1,
	0x76cb, 0x76e6, 0x7703, 0x7727, 0x774d, 0x7769, 0x777c, 0x7799,
	0x77ab, 0x77bd, 0x77d0, 0x77ef, 0x780d, 0x7837, 0x7854, 0x7867,
	0x7888, 0x789a, 0x78b4, 0x78c6, 0x78e4, 0x7904, 0x7923, 0x7942,
	0x7960, 0x7980, 0x79a0, 0x79bf, 0x79e0, 0x7a00, 0x7a20, 0x7a3f,
	0x7a60, 0x7a81, 0x7aa1, 0x7abe, 0x7adb, 0x7af7, 0x7b15, 0x7b33,
	0x7b50, 0x7b70, 0x7b90, 0x7bb2, 0x7bd3, 0x7bf4, 0x7c14, 0x7c36,
	0x7c58, 0x7c79, 0x7c99, 0x7cb9, 0x7cdb, 0x7cfc, 0x7d1d, 0x7d3d,
	// Entry 56C0 - 56FF
	0x7d5f, 0x7d8e, 0x7daf, 0x7dd0, 0x7df0, 0x7e12, 0x7e34, 0x7e55,
	0x7e75, 0x7e95, 0x7eb7, 0x7ee6, 0x7f07, 0x7f28, 0x7f58, 0x7f87,
	0x7fa6, 0x7fc5, 0x7fe6, 0x8014, 0x8034, 0x8054, 0x8083, 0x80b2,
	0x80e0, 0x810f, 0x813f, 0x816f, 0x819b, 0x81ca, 0x81fa, 0x822a,
	0x8258, 0x8287, 0x82b6, 0x82e6, 0x8316, 0x8347, 0x836a, 0x838f,
	0x83b3, 0x83d7, 0x83fa, 0x8419, 0x8438, 0x8459, 0x8479, 0x84a6,
	0x84c6, 0x84f3, 0x8513, 0x8533, 0x8553, 0x8573, 0x8598, 0x85be,
	0x85e5, 0x8614, 0x8644, 0x8669, 0x868f, 0x86bc, 0x86eb, 0x8711,
	// Entry 5700 - 573F
	0x8734, 0x875c, 0x8785, 0x87a9, 0x87cd, 0x87f7, 0x8821, 0x884a,
	0x8875, 0x88a0, 0x88ca, 0x88fe, 0x8927, 0x8950, 0x897c, 0x89a9,
	0x89c9, 0x89e5, 0x8a01, 0x8a23, 0x8a42, 0x8a60, 0x8a7e, 0x8aa1,
	0x8abd, 0x8ad9, 0x8af5, 0x8b13, 0x8b2f, 0x8b4d, 0x8b69, 0x8b8d,
	0x8ba9, 0x8bc5, 0x8be3, 0x8bfe, 0x8c19, 0x8c3b, 0x8c58, 0x8c73,
	0x8c8e, 0x8caf, 0x8cce, 0x8cea, 0x8d09, 0x8d34, 0x8d54, 0x8d70,
	0x8d96, 0x8dbc, 0x8dd9, 0x8df5, 0x8e10, 0x8e2b, 0x8e46, 0x8e62,
	0x8e82, 0x8e9d, 0x8eb8, 0x8ece, 0x8eef, 0x8f14, 0x8f38, 0x8f62,
	// Entry 5740 - 577F
	0x8f86, 0x8fab, 0x8fcf, 0x8ff4, 0x9018, 0x9034, 0x9053, 0x9074,
	0x909f, 0x90c8, 0x90e5, 0x9100, 0x9124, 0x9148, 0x916a, 0x9195,
	0x91b1, 0x91d7, 0x91f3, 0x9210, 0x922b, 0x924e, 0x9271, 0x928e,
	0x92ab, 0x92d5, 0x92f3, 0x931f, 0x9340, 0x9367, 0x9382, 0x93af,
	0x93c9, 0x93e3, 0x9400, 0x941a, 0x943f, 0x9455, 0x946b, 0x9481,
	0x9497, 0x94ad, 0x94c3, 0x94d9, 0x9501, 0x9517, 0x953a, 0x9550,
	0x9566, 0x957c, 0x9592, 0x95a8, 0x95be, 0x95d4, 0x95ea, 0x9600,
	0x9616, 0x962c, 0x9642, 0x9658, 0x966e, 0x9684, 0x969a, 0x96b0,
	// Entry 5780 - 57BF
	0x96c6, 0x96dc, 0x96fb, 0x971b, 0x9744, 0x9776, 0x979d, 0x97b3,
	0x97c9, 0x97df, 0x97f5, 0x980b, 0x9821, 0x9837, 0x984d, 0x9863,
	0x9879, 0x988f, 0x98af, 0x98cf, 0x98fa, 0x991a, 0x9939, 0x9959,
	0x9978, 0x9997, 0x99b6, 0x99d8, 0x99ee, 0x9a04, 0x9a24, 0x9a43,
	0x9a63, 0x9a88, 0x9aa7, 0x9ad9, 0x9b03, 0x9b22, 0x9b44, 0x9b5a,
	0x9b70, 0x9b91, 0x9bae, 0x9bca, 0x9be6, 0x9c14, 0x9c31, 0x9c4b,
	0x9c71, 0x9c98, 0x9cbc, 0x9cdc, 0x9cfb, 0x9d19, 0x9d3a, 0x9d5d,
	0x9d7d, 0x9da5, 0x9dc2, 0x9de6, 0x9e07, 0x9e27, 0x9e42, 0x9e66,
	// Entry 57C0 - 57FF
	0x9e83, 0x9e9b, 0x9eb6, 0x9ed2, 0x9eee, 0x9f09, 0x9f2e, 0x9f52,
	0x9f6e, 0x9f8a, 0x9fac, 0x9fcf, 0x9fea, 0xa005, 0xa023, 0xa043,
	0xa05f, 0xa071, 0xa093, 0xa0bb, 0xa0d3, 0xa0eb, 0xa103, 0xa11b,
	0xa133, 0xa14c, 0xa164, 0xa17d, 0xa196, 0xa1ae, 0xa1c6, 0xa1de,
	0xa1f6, 0xa20e, 0xa226, 0xa23e, 0xa256, 0xa26f, 0xa287, 0xa29f,
	0xa2b7, 0xa2d0, 0xa2e8, 0xa300, 0xa318, 0xa330, 0xa348, 0xa360,
	0xa378, 0xa390, 0xa3a8, 0xa3c0, 0xa3d8, 0xa3f0, 0xa408, 0xa420,
	0xa438, 0xa451, 0xa469, 0xa481, 0xa499, 0xa4b1, 0xa4c9, 0xa4e1,
	// Entry 5800 - 583F
	0xa4f9, 0xa511, 0xa52a, 0xa542, 0xa55a, 0xa573, 0xa58b, 0xa5a4,
	0xa5bc, 0xa5d4, 0xa5ed, 0xa605, 0xa61d, 0xa635, 0xa64d, 0xa665,
	0xa67d, 0xa695, 0xa6ad, 0xa6c5, 0xa6dd, 0xa6f5, 0xa70d, 0xa725,
	0xa73d, 0xa755, 0xa76d, 0xa785, 0xa79d, 0xa7b5, 0xa7cd, 0xa7e5,
	0xa7fd, 0xa815, 0xa82d, 0xa845, 0xa85d, 0xa875, 0xa88d, 0xa8a5,
	0xa8bd, 0xa8d6, 0xa8ee, 0xa906, 0xa91e, 0xa936, 0xa94e, 0xa966,
	0xa97f, 0xa998, 0xa9b1, 0xa9c9, 0xa9e1, 0xa9f9, 0xaa11, 0xaa29,
	0xaa41, 0xaa59, 0xaa71, 0xaa8a, 0xaaa2, 0xaaba, 0xaad2, 0xaaea,
	// Entry 5840 - 587F
	0xab02, 0xab1a, 0xab32, 0xab4a, 0xab62, 0xab7a, 0xab92, 0xabaa,
	0xabc2, 0xabda, 0xabf2, 0xac0a, 0xac22, 0xac3a, 0xac52, 0xac6a,
	0xac82, 0xac9a, 0xacb3, 0xaccb, 0xace3, 0xacfb, 0xad13, 0xad2b,
	0xad43, 0xad5b, 0xad73, 0xad8b, 0xada3, 0xadbb, 0xadd3, 0xadeb,
	0xae03, 0xae1b, 0xae33, 0xae4b, 0xae63, 0xae7b, 0xae94, 0xaeac,
	0xaec4, 0xaedc, 0xaef4, 0xaf0d, 0xaf25, 0xaf3d, 0xaf55, 0xaf6e,
	0xaf86, 0xaf9e, 0xafb6, 0xafce, 0xafe6, 0xaffe, 0xb016, 0xb02e,
	0xb046, 0xb05e, 0xb076, 0xb08e, 0xb0a7, 0xb0bf, 0xb0d7, 0xb0f0,
	// Entry 5880 - 58BF
	0xb108, 0xb120, 0xb139, 0xb152, 0xb16b, 0xb184, 0xb19d, 0xb1b6,
	0xb1cf, 0xb1e8, 0xb201, 0xb219, 0xb231, 0xb24a, 0xb262, 0xb27a,
	0xb293, 0xb2ab, 0xb2c3, 0xb2db, 0xb2f3, 0xb30b, 0xb323, 0xb33b,
	0xb353, 0xb36b, 0xb383, 0xb39b, 0xb3b3, 0xb3cb, 0xb3e4, 0xb3fd,
	0xb416, 0xb42f, 0xb448, 0xb461, 0xb47a, 0xb493, 0xb4ab, 0xb4c3,
	0xb4db, 0xb4f3, 0xb50b, 0xb523, 0xb53b, 0xb553, 0xb56c, 0xb584,
	0xb59d, 0xb5b5, 0xb5cd, 0xb5e5, 0xb5fd, 0xb615, 0xb62d, 0xb645,
	0xb65e, 0xb676, 0xb68f, 0xb6a7, 0xb6bf, 0xb6d7, 0xb6f0, 0xb708,
	// Entry 58C0 - 58FF
	0xb720, 0xb738, 0xb750, 0xb768, 0xb780, 0xb798, 0xb7b0, 0xb7c9,
	0xb7e1, 0xb7f9, 0xb811, 0xb829, 0xb841, 0xb859, 0xb872, 0xb88a,
	0xb8a2, 0xb8ba, 0xb8d2, 0xb8eb, 0xb903, 0xb91b, 0xb933, 0xb94b,
	0xb963, 0xb97b, 0xb993, 0xb9ab, 0xb9c3, 0xb9db, 0xb9f3, 0xba0b,
	0xba24, 0xba3c, 0xba54, 0xba6c, 0xba84, 0xba9c, 0xbab4, 0xbacc,
	0xbae4, 0xbafd, 0xbb15, 0xbb2d, 0xbb45, 0xbb5d, 0xbb75, 0xbb8d,
	0xbba5, 0xbbbd, 0xbbd5, 0xbbed, 0xbc06, 0xbc1e, 0xbc36, 0xbc4e,
	0xbc66, 0xbc7e, 0xbc96, 0xbcaf, 0xbcc7, 0xbce0, 0xbcf8, 0xbd10,
	// Entry 5900 - 593F
	0xbd28, 0xbd40, 0xbd58, 0xbd70, 0xbd88, 0xbda1, 0xbdb9, 0xbdd2,
	0xbdea, 0xbe03, 0xbe1b, 0xbe33, 0xbe4b, 0xbe63, 0xbe7c, 0xbe95,
	0xbeae, 0xbec6, 0xbede, 0xbef6, 0xbf0e, 0xbf26, 0xbf3e, 0xbf56,
	0xbf6e, 0xbf87, 0xbf9f, 0xbfb8, 0xbfd1, 0xbfe9, 0xc001, 0xc019,
	0xc031, 0xc04a, 0xc062, 0xc07a, 0xc092, 0xc0aa, 0xc0c2, 0xc0da,
	0xc0f2, 0xc10a, 0xc122, 0xc13b, 0xc153, 0xc16b, 0xc183, 0xc19b,
	0xc1b3, 0xc1cb, 0xc1e4, 0xc1fc, 0xc214, 0xc22c, 0xc244, 0xc25c,
	0xc274, 0xc28c, 0xc2a4, 0xc2bc, 0xc2d4, 0xc2ed, 0xc305, 0xc31e,
	// Entry 5940 - 597F
	0xc336, 0xc34e, 0xc366, 0xc37e, 0xc396, 0xc3ae, 0xc3c7, 0xc3df,
	0xc3f7, 0xc410, 0xc428, 0xc440, 0xc458, 0xc470, 0xc488, 0xc4a0,
	0xc4b8, 0xc4d0, 0xc4e8, 0xc500, 0xc518, 0xc530, 0xc548, 0xc560,
	0xc578, 0xc591, 0xc5a9, 0xc5c1, 0xc5d9, 0xc5f1, 0xc609, 0xc621,
	0xc639, 0xc652, 0xc66a, 0xc682, 0xc69a, 0xc6b2, 0xc6cb, 0xc6e3,
	0xc6fc, 0xc714, 0xc72d, 0xc745, 0xc75d, 0xc775, 0xc78d, 0xc7a5,
	0xc7bd, 0xc7d5, 0xc7ed, 0xc805, 0xc81d, 0xc835, 0xc84d, 0xc865,
	0xc87d, 0xc896, 0xc8ae, 0xc8c6, 0xc8de, 0xc8f6, 0xc90f, 0xc927,
	// Entry 5980 - 59BF
	0xc93f, 0xc957, 0xc970, 0xc989, 0xc9a1, 0xc9b9, 0xc9d2, 0xc9ea,
	0xca02, 0xca1a, 0xca32, 0xca4a, 0xca62, 0xca7a, 0xca93, 0xcaab,
	0xcac3, 0xcadc, 0xcaf5, 0xcb0e, 0xcb27, 0xcb40, 0xcb59, 0xcb72,
	0xcb8b, 0xcba3, 0xcbbb, 0xcbd3, 0xcbec, 0xcc04, 0xcc1d, 0xcc35,
	0xcc4e, 0xcc66, 0xcc7e, 0xcc96, 0xccae, 0xccc6, 0xccdf, 0xccf7,
	0xcd0f, 0xcd28, 0xcd40, 0xcd58, 0xcd70, 0xcd88, 0xcda1, 0xcdb9,
	0xcdd1, 0xcde9, 0xce02, 0xce1a, 0xce32, 0xce4b, 0xce64, 0xce7c,
	0xce94, 0xceac, 0xcec4, 0xcedc, 0xcef4, 0xcf0c, 0xcf25, 0xcf3d,
	// Entry 59C0 - 59FF
	0xcf55, 0xcf6d, 0xcf85, 0xcf9d, 0xcfb5, 0xcfcd, 0xcfe5, 0xcffd,
	0xd015, 0xd02d, 0xd045, 0xd05d, 0xd075, 0xd08d, 0xd0a5, 0xd0bd,
	0xd0d5, 0xd0ed, 0xd105, 0xd11d, 0xd135, 0xd14e, 0xd167, 0xd17f,
	0xd197, 0xd1af, 0xd1c7, 0xd1df, 0xd1f7, 0xd20f, 0xd228, 0xd240,
	0xd258, 0xd270, 0xd288, 0xd2a0, 0xd2b8, 0xd2d0, 0xd2e8, 0xd301,
	0xd319, 0xd332, 0xd34a, 0xd363, 0xd37b, 0xd393, 0xd3ac, 0xd3c4,
	0xd3dc, 0xd3f4, 0xd40c, 0xd424, 0xd43d, 0xd456, 0xd46f, 0xd488,
	0xd4a1, 0xd4bb, 0xd4d4, 0xd4ed, 0xd506, 0xd51f, 0xd538, 0xd551,
	// Entry 5A00 - 5A3F
	0xd56a, 0xd583, 0xd59c, 0xd5b5, 0xd5ce, 0xd5e7, 0xd601, 0xd61a,
	0xd633, 0xd64c, 0xd665, 0xd67e, 0xd697, 0xd6b0, 0xd6c9, 0xd6e2,
	0xd6fb, 0xd714, 0xd72d, 0xd746, 0xd760, 0xd779, 0xd793, 0xd7ac,
	0xd7c5, 0xd7de, 0xd7f7, 0xd810, 0xd829, 0xd842, 0xd85c, 0xd875,
	0xd88e, 0xd8a7, 0xd8c0, 0xd8da, 0xd8f2, 0xd90b, 0xd923, 0xd93b,
	0xd953, 0xd96b, 0xd984, 0xd99c, 0xd9b5, 0xd9ce, 0xd9e7, 0xda00,
	0xda19, 0xda32, 0xda4a, 0xda62, 0xda7a, 0xda92, 0xdaab, 0xdac4,
	0xdadd, 0xdaf5, 0xdb0d, 0xdb25, 0xdb3d, 0xdb55, 0xdb6d, 0xdb85,
	// Entry 5A40 - 5A7F
	0xdb9d, 0xdbb5, 0xdbce, 0xdbe6, 0xdbff, 0xdc17, 0xdc2f, 0xdc47,
	0xdc5f, 0xdc78, 0xdc90, 0xdca9, 0xdcc1, 0xdcd9, 0xdcf1, 0xdd09,
	0xdd22, 0xdd3a, 0xdd53, 0xdd6b, 0xdd83, 0xdd9b, 0xddb4, 0xddcc,
	0xdde4, 0xddfc, 0xde15, 0xde2e, 0xde47, 0xde60, 0xde78, 0xde90,
	0xdea8, 0xdec0, 0xded8, 0xdef0, 0xdf08, 0xdf20, 0xdf38, 0xdf50,
	0xdf68, 0xdf80, 0xdf98, 0xdfb0, 0xdfc9, 0xdfe2, 0xdffa, 0xe012,
	0xe02b, 0xe043, 0xe05b, 0xe074, 0xe08c, 0xe0a4, 0xe0bc, 0xe0d4,
	0xe0ec, 0xe104, 0xe11c, 0xe134, 0xe14c, 0xe164, 0xe17c, 0xe194,
	// Entry 5A80 - 5ABF
	0xe1ac, 0xe1c4, 0xe1dc, 0xe1f4, 0xe20c, 0xe225, 0xe23d, 0xe256,
	0xe26f, 0xe287, 0xe29f, 0xe2b7, 0xe2cf, 0xe2e7, 0xe2ff, 0xe317,
	0xe330, 0xe348, 0xe360, 0xe378, 0xe390, 0xe3a8, 0xe3c0, 0xe3d9,
	0xe3f1, 0xe409, 0xe421, 0xe439, 0xe451, 0xe469, 0xe481, 0xe499,
	0xe4b1, 0xe4c9, 0xe4e1, 0xe4f9, 0xe511, 0xe529, 0xe541, 0xe55a,
	0xe572, 0xe58a, 0xe5a2, 0xe5ba, 0xe5d3, 0xe5eb, 0xe603, 0xe61b,
	0xe633, 0xe64b, 0xe663, 0xe67b, 0xe693, 0xe6ac, 0xe6c5, 0xe6dd,
	0xe6f5, 0xe70d, 0xe726, 0xe73e, 0xe756, 0xe76e, 0xe786, 0xe79e,
	// Entry 5AC0 - 5AFF
	0xe7b6, 0xe7ce, 0xe7e6, 0xe7fe, 0xe817, 0xe830, 0xe848, 0xe860,
	0xe878, 0xe890, 0xe8a8, 0xe8c0, 0xe8d8, 0xe8f0, 0xe908, 0xe921,
	0xe939, 0xe951, 0xe969, 0xe981, 0xe999, 0xe9b1, 0xe9c9, 0xe9e1,
	0xe9f9, 0xea11, 0xea29, 0xea41, 0xea59, 0xea71, 0xea8a, 0xeaa2,
	0xeaba, 0xead2, 0xeaea, 0xeb03, 0xeb1b, 0xeb34, 0xeb4c, 0xeb65,
	0xeb7d, 0xeb95, 0xebae, 0xebc6, 0xebde, 0xebf6, 0xec0e, 0xec26,
	0xec3f, 0xec57, 0xec6f, 0xec87, 0xec9f, 0xecb7, 0xeccf, 0xece7,
	0xecff, 0xed17, 0xed2f, 0xed47, 0xed5f, 0xed77, 0xed8f, 0xeda7,
	// Entry 5B00 - 5B3F
	0xedbf, 0xedd8, 0xedf0, 0xee09, 0xee21, 0xee39, 0xee51, 0xee69,
	0xee81, 0xee99, 0xeeb1, 0xeec9, 0xeee1, 0xeefa, 0xef13, 0xef2b,
	0xef43, 0xef5b, 0xef73, 0xef8b, 0xefa3, 0xefbb, 0xefd3, 0xefeb,
	0xf003, 0xf01b, 0xf033, 0xf04b, 0xf063, 0xf07b, 0xf093, 0xf0ab,
	0xf0c4, 0xf0dc, 0xf0f4, 0xf10c, 0xf124, 0xf13c, 0xf154, 0xf16d,
	0xf185, 0xf19d, 0xf1b5, 0xf1ce, 0xf1e6, 0xf1fe, 0xf216, 0xf22e,
	0xf246, 0xf25e, 0xf276, 0xf28e, 0xf2a6, 0xf2be, 0xf2d6, 0xf2ef,
	0xf308, 0xf321, 0xf33a, 0xf353, 0xf36c, 0xf385, 0xf39e, 0xf3b7,
	// Entry 5B40 - 5B7F
	0xf3cf, 0xf3e8, 0xf400, 0xf418, 0xf430, 0xf448, 0xf460, 0xf479,
	0xf492, 0xf4aa, 0xf4c2, 0xf4da, 0xf4f2, 0xf50b, 0xf524, 0xf53d,
	0xf555, 0xf56e, 0xf587, 0xf59f, 0xf5b7, 0xf5cf, 0xf5e7, 0xf5ff,
	0xf617, 0xf62f, 0xf647, 0xf660, 0xf679, 0xf692, 0xf6ab, 0xf6c4,
	0xf6dd, 0xf6f6, 0xf70f, 0xf728, 0xf741, 0xf75a, 0xf773, 0xf78b,
	0xf7a3, 0xf7bb, 0xf7d4, 0xf7ec, 0xf804, 0xf81c, 0xf834, 0xf84c,
	0xf865, 0xf87d, 0xf896, 0xf8ae, 0xf8c7, 0xf8df, 0xf8f8, 0xf910,
	0xf928, 0xf941, 0xf959, 0xf971, 0xf989, 0xf9a1, 0xf9ba, 0xf9d2,
	// Entry 5B80 - 5BBF
	0xf9ea, 0xfa02, 0xfa1b, 0xfa33, 0xfa4b, 0xfa63, 0xfa7c, 0xfa94,
	0xfaac, 0xfac4, 0xfadc, 0xfaf4, 0xfb0c, 0xfb25, 0xfb3d, 0xfb56,
	0xfb6e, 0xfb86, 0xfb9e, 0xfbb6, 0xfbcf, 0xfbe7, 0xfbff, 0xfc17,
	0xfc30, 0xfc48, 0xfc61, 0xfc79, 0xfc91, 0xfca9, 0xfcc1, 0xfcd9,
	0xfcf1, 0xfd0a, 0xfd22, 0xfd3a, 0xfd52, 0xfd6a, 0xfd82, 0xfd9b,
	0xfdb4, 0xfdcc, 0xfde4, 0xfdfd, 0xfe15, 0xfe2d, 0xfe46, 0xfe5e,
	0xfe77, 0xfe8f, 0xfea7, 0xfebf, 0xfed7, 0xfeef, 0xff07, 0xff1f,
	0xff37, 0xff4f, 0xff68, 0xff81, 0xff9a, 0xffb3, 0xffcb, 0xffe4,
	// Entry 5BC0 - 5BFF
	0xfffd, 0x0015, 0x002e, 0x0046, 0x005f, 0x0077, 0x008f, 0x00a7,
	0x00bf, 0x00d7, 0x00ef, 0x0107, 0x011f, 0x0137, 0x014f, 0x0168,
	0x0181, 0x019a, 0x01b3, 0x01cc, 0x01e5, 0x01fe, 0x0217, 0x0230,
	0x0248, 0x0261, 0x027a, 0x0293, 0x02ac, 0x02c5, 0x02de, 0x02f7,
	0x0310, 0x0329, 0x0342, 0x035b, 0x0374, 0x038d, 0x03a6, 0x03bf,
	0x03d9, 0x03f3, 0x040c, 0x0425, 0x043e, 0x0457, 0x0470, 0x0489,
	0x04a2, 0x04bb, 0x04d4, 0x04ed, 0x0506, 0x051f, 0x0538, 0x0551,
	0x056a, 0x0583, 0x059c, 0x05b5, 0x05ce, 0x05e7, 0x0600, 0x0619,
	// Entry 5C00 - 5C3F
	0x0632, 0x064b, 0x0664, 0x0687, 0x06ac, 0x06d3, 0x06fd, 0x0722,
	0x074a, 0x076c, 0x078d, 0x07ac, 0x07c5, 0x07de, 0x07f7, 0x0810,
	0x0829, 0x0842, 0x085b, 0x0874, 0x088d, 0x08a6, 0x08c0, 0x08d9,
	0x08f2, 0x090b, 0x0924, 0x093d, 0x0956, 0x096f, 0x0988, 0x09a1,
	0x09ba, 0x09d3, 0x09ec, 0x0a05, 0x0a1e, 0x0a37, 0x0a50, 0x0a6a,
	0x0a83, 0x0a9c, 0x0ab5, 0x0ace, 0x0ae7, 0x0b00, 0x0b19, 0x0b32,
	0x0b4b, 0x0b64, 0x0b7d, 0x0b96, 0x0baf, 0x0bc9, 0x0be2, 0x0bfb,
	0x0c15, 0x0c2e, 0x0c47, 0x0c60, 0x0c79, 0x0c93, 0x0cac, 0x0cc6,
	// Entry 5C40 - 5C7F
	0x0ce0, 0x0cf9, 0x0d12, 0x0d2b, 0x0d44, 0x0d5d, 0x0d76, 0x0d8f,
	0x0da8, 0x0dc1, 0x0dda, 0x0df3, 0x0e0c, 0x0e25, 0x0e3e, 0x0e57,
	0x0e70, 0x0e89, 0x0ea2, 0x0ebb, 0x0ed4, 0x0eee, 0x0f08, 0x0f22,
	0x0f3b, 0x0f54, 0x0f6d, 0x0f86, 0x0f9f, 0x0fb8, 0x0fd1, 0x0fea,
	0x1003, 0x101c, 0x1035, 0x104e, 0x1067, 0x1080, 0x1099, 0x10b2,
	0x10cb, 0x10e4, 0x10fd, 0x1116, 0x112f, 0x1148, 0x1161, 0x117a,
	0x1193, 0x11ac, 0x11c5, 0x11de, 0x11f7, 0x1210, 0x1229, 0x1243,
	0x125c, 0x1276, 0x128f, 0x12a8, 0x12c2, 0x12db, 0x12f5, 0x130e,
	// Entry 5C80 - 5CBF
	0x1328, 0x1341, 0x135a, 0x1374, 0x138e, 0x13a8, 0x13c1, 0x13db,
	0x13f5, 0x140e, 0x1427, 0x1441, 0x145b, 0x1475, 0x148e, 0x14a7,
	0x14c0, 0x14da, 0x14f4, 0x150d, 0x1526, 0x153f, 0x1558, 0x1571,
	0x158b, 0x15a4, 0x15bd, 0x15d6, 0x15ef, 0x1608, 0x1621, 0x163a,
	0x1653, 0x166c, 0x1685, 0x169f, 0x16b8, 0x16d1, 0x16ea, 0x1703,
	0x171c, 0x1735, 0x174e, 0x1767, 0x1780, 0x1799, 0x17b3, 0x17cc,
	0x17e5, 0x17fe, 0x1817, 0x1830, 0x1849, 0x1862, 0x187b, 0x1894,
	0x18ad, 0x18c6, 0x18df, 0x18f8, 0x1911, 0x192a, 0x1943, 0x195c,
	// Entry 5CC0 - 5CFF
	0x1975, 0x198e, 0x19a7, 0x19c0, 0x19d9, 0x19f2, 0x1a0b, 0x1a24,
	0x1a3d, 0x1a56, 0x1a6f, 0x1a88, 0x1aa1, 0x1aba, 0x1ad3, 0x1aec,
	0x1b05, 0x1b1e, 0x1b37, 0x1b50, 0x1b69, 0x1b82, 0x1b9b, 0x1bb4,
	0x1bcd, 0x1be6, 0x1bff, 0x1c18, 0x1c31, 0x1c4a, 0x1c63, 0x1c7c,
	0x1c95, 0x1cae, 0x1cc7, 0x1ce0, 0x1cf9, 0x1d12, 0x1d2b, 0x1d44,
	0x1d5d, 0x1d76, 0x1d8f, 0x1da8, 0x1dc1, 0x1dda, 0x1df3, 0x1e0c,
	0x1e25, 0x1e3e, 0x1e58, 0x1e72, 0x1e8b, 0x1ea4, 0x1ebd, 0x1ed6,
	0x1eef, 0x1f09, 0x1f22, 0x1f3b, 0x1f55, 0x1f6e, 0x1f87, 0x1fa0,
	// Entry 5D00 - 5D3F
	0x1fb9, 0x1fd2, 0x1feb, 0x2005, 0x201e, 0x2038, 0x2051, 0x206a,
	0x2083, 0x209c, 0x20b5, 0x20ce, 0x20e7, 0x2100, 0x2119, 0x2132,
	0x214b, 0x2165, 0x217e, 0x2197, 0x21b0, 0x21c9, 0x21e2, 0x21fb,
	0x2214, 0x222d, 0x2246, 0x225f, 0x2278, 0x2291, 0x22aa, 0x22c3,
	0x22dc, 0x22f5, 0x230e, 0x2327, 0x2340, 0x2359, 0x2372, 0x238b,
	0x23a4, 0x23bd, 0x23d6, 0x23ef, 0x2408, 0x2421, 0x243a, 0x2453,
	0x246c, 0x2485, 0x249e, 0x24b7, 0x24d0, 0x24e9, 0x2502, 0x251b,
	0x2534, 0x254d, 0x2567, 0x2580, 0x2599, 0x25b2, 0x25cb, 0x25e4,
	// Entry 5D40 - 5D7F
	0x25fd, 0x2616, 0x262f, 0x2648, 0x2661, 0x267a, 0x2693, 0x26ac,
	0x26c5, 0x26de, 0x26f7, 0x2710, 0x2729, 0x2742, 0x275b, 0x2774,
	0x278d, 0x27a7, 0x27c0, 0x27d9, 0x27f2, 0x280b, 0x2824, 0x283e,
	0x2857, 0x2870, 0x2889, 0x28a2, 0x28bb, 0x28d5, 0x28ee, 0x2907,
	0x2920, 0x2939, 0x2952, 0x296b, 0x2984, 0x299d, 0x29b6, 0x29cf,
	0x29e9, 0x2a02, 0x2a1b, 0x2a34, 0x2a4d, 0x2a66, 0x2a7f, 0x2a98,
	0x2ab1, 0x2aca, 0x2ae3, 0x2afc, 0x2b15, 0x2b2e, 0x2b47, 0x2b60,
	0x2b79, 0x2b92, 0x2bab, 0x2bc4, 0x2bdd, 0x2bf7, 0x2c10, 0x2c29,
	// Entry 5D80 - 5DBF
	0x2c43, 0x2c5d, 0x2c77, 0x2c90, 0x2ca9, 0x2cc2, 0x2cdb, 0x2cf5,
	0x2d0f, 0x2d29, 0x2d42, 0x2d5b, 0x2d74, 0x2d8d, 0x2da6, 0x2dbf,
	0x2dd8, 0x2df1, 0x2e0a, 0x2e23, 0x2e3c, 0x2e55, 0x2e6e, 0x2e87,
	0x2ea0, 0x2eb9, 0x2ed2, 0x2eeb, 0x2f04, 0x2f1d, 0x2f36, 0x2f4f,
	0x2f68, 0x2f82, 0x2f9b, 0x2fb4, 0x2fcd, 0x2fe6, 0x2fff, 0x3019,
	0x3032, 0x304b, 0x3064, 0x307d, 0x3097, 0x30b0, 0x30c9, 0x30e2,
	0x30fc, 0x3115, 0x312e, 0x3147, 0x3160, 0x3179, 0x3192, 0x31ab,
	0x31c4, 0x31dd, 0x31f6, 0x3210, 0x3229, 0x324b, 0x3265, 0x327e,
	// Entry 5DC0 - 5DFF
	0x3297, 0x32b0, 0x32ca, 0x32e3, 0x32fc, 0x3315, 0x332e, 0x3347,
	0x3360, 0x337f, 0x3398, 0x33b1, 0x33ca, 0x33e3, 0x33fc, 0x3415,
	0x342e, 0x3447, 0x3460, 0x3479, 0x3492, 0x34ab, 0x34c4, 0x34dd,
	0x34f6, 0x350f, 0x353c, 0x3568, 0x3581, 0x359a, 0x35b3, 0x35cc,
	0x35e5, 0x35fe, 0x3617, 0x3630, 0x3649, 0x3662, 0x367b, 0x3694,
	0x36ad, 0x36c6, 0x36df, 0x36f8, 0x3711, 0x372a, 0x3743, 0x375c,
	0x3775, 0x378e, 0x37a7, 0x37c0, 0x37d9, 0x37f2, 0x380b, 0x3824,
	0x383d, 0x3856, 0x386f, 0x3888, 0x38a1, 0x38ba, 0x38d3, 0x38ec,
	// Entry 5E00 - 5E3F
	0x3905, 0x391e, 0x3937, 0x3950, 0x396a, 0x3983, 0x399c, 0x39b5,
	0x39ce, 0x39e7, 0x3a00, 0x3a19, 0x3a33, 0x3a4c, 0x3a65, 0x3a7e,
	0x3a97, 0x3ab0, 0x3ac9, 0x3ae2, 0x3afb, 0x3b14, 0x3b2d, 0x3b46,
	0x3b5f, 0x3b78, 0x3b91, 0x3baa, 0x3bc3, 0x3bdc, 0x3bf5, 0x3c0e,
	0x3c27, 0x3c40, 0x3c59, 0x3c72, 0x3c8b, 0x3ca4, 0x3cbd, 0x3cd6,
	0x3cef, 0x3d08, 0x3d21, 0x3d3a, 0x3d53, 0x3d6c, 0x3d85, 0x3d9e,
	0x3db7, 0x3dd0, 0x3de9, 0x3e02, 0x3e1b, 0x3e34, 0x3e4d, 0x3e66,
	0x3e7f, 0x3e98, 0x3eb1, 0x3eca, 0x3ee3, 0x3efc, 0x3f15, 0x3f2e,
	// Entry 5E40 - 5E7F
	0x3f47, 0x3f60, 0x3f79, 0x3f92, 0x3fab, 0x3fc4, 0x3fdd, 0x3ff6,
	0x400f, 0x4028, 0x4041, 0x405a, 0x4073, 0x408c, 0x40a5, 0x40be,
	0x40d7, 0x40f0, 0x4109, 0x4128, 0x4146, 0x416f, 0x4195, 0x41b2,
	0x41d1, 0x41ef, 0x420c, 0x422e, 0x4259, 0x4281, 0x42a0, 0x42be,
	0x42d9, 0x42f6, 0x4312, 0x4331, 0x434d, 0x4369, 0x4388, 0x43a3,
	0x43bb, 0x43da, 0x43f4, 0x4410, 0x442e, 0x444a, 0x4465, 0x4483,
	0x449f, 0x44c0, 0x44de, 0x44fc, 0x451d, 0x453b, 0x4554, 0x456f,
	0x4590, 0x45ac, 0x45c5, 0x45e5, 0x4606, 0x461e, 0x463b, 0x4654,
	// Entry 5E80 - 5EBF
	0x466c, 0x4686, 0x46a0, 0x46bb, 0x46d9, 0x46f4, 0x470c, 0x472d,
	0x4746, 0x4762, 0x477b, 0x4796, 0x47af, 0x47c7, 0x47e0, 0x47f8,
	0x4816, 0x4831, 0x484a, 0x486d, 0x4891, 0x48ac, 0x48c8, 0x48e4,
	0x48fe, 0x4918, 0x4931, 0x494c, 0x4965, 0x4980, 0x4998, 0x49b1,
	0x49cc, 0x49e5, 0x49fd, 0x4a15, 0x4a2e, 0x4a46, 0x4a5d, 0x4a75,
	0x4a8d, 0x4aa6, 0x4ac1, 0x4ae2, 0x4afb, 0x4b16, 0x4b34, 0x4b53,
	0x4b6d, 0x4b88, 0x4ba4, 0x4bbc, 0x4bd7, 0x4bf9, 0x4c1c, 0x4c3d,
	0x4c5a, 0x4c7a, 0x4c92, 0x4caf, 0x4ccd, 0x4ceb, 0x4d0b, 0x4d2c,
	// Entry 5EC0 - 5EFF
	0x4d4a, 0x4d65, 0x4d82, 0x4d9e, 0x4db9, 0x4dd3, 0x4dec, 0x4e0d,
	0x4e2b, 0x4e45, 0x4e61, 0x4e7a, 0x4e93, 0x4eae, 0x4ecf, 0x4eea,
	0x4f02, 0x4f1d, 0x4f3a, 0x4f56, 0x4f72, 0x4f92, 0x4fab, 0x4fc5,
	0x4fdd, 0x4ff8, 0x5018, 0x5035, 0x504d, 0x5068, 0x5081, 0x5098,
	0x50b0, 0x50c9, 0x50ea, 0x5102, 0x511a, 0x5137, 0x5151, 0x516f,
	0x5189, 0x51a4, 0x51c1, 0x51db, 0x5201, 0x521e, 0x5238, 0x5254,
	0x526f, 0x5295, 0x52b4, 0x52cd, 0x52e8, 0x5306, 0x5320, 0x5339,
	0x5355, 0x536e, 0x5387, 0x53a2, 0x53ba, 0x53d3, 0x53ed, 0x5409,
	// Entry 5F00 - 5F3F
	0x5423, 0x5440, 0x545a, 0x547b, 0x5494, 0x54b1, 0x54d0, 0x54e9,
	0x5504, 0x551c, 0x5539, 0x5555, 0x5572, 0x558e, 0x55a8, 0x55c0,
	0x55da, 0x55f2, 0x560c, 0x5625, 0x5642, 0x565d, 0x5674, 0x568e,
	0x56a6, 0x56c2, 0x56e1, 0x56fc, 0x5714, 0x572d, 0x5747, 0x5762,
	0x5779, 0x5791, 0x57aa, 0x57c3, 0x57db, 0x57f7, 0x5810, 0x5829,
	0x584a, 0x5863, 0x587c, 0x5899, 0x58b1, 0x58ca, 0x58e4, 0x58ff,
	0x5917, 0x5932, 0x594d, 0x5969, 0x5983, 0x599c, 0x59bc, 0x59d6,
	0x59f0, 0x5a09, 0x5a22, 0x5a3b, 0x5a57, 0x5a77, 0x5a90, 0x5aa8,
	// Entry 5F40 - 5F7F
	0x5ac0, 0x5ad8, 0x5af0, 0x5b08, 0x5b21, 0x5b39, 0x5b51, 0x5b6a,
	0x5b84, 0x5b9d, 0x5bb7, 0x5bd1, 0x5bee, 0x5c07, 0x5c21, 0x5c3b,
	0x5c54, 0x5c6e, 0x5c8d, 0x5ca6, 0x5cc1, 0x5cda, 0x5cf2, 0x5d0a,
	0x5d26, 0x5d3f, 0x5d57, 0x5d71, 0x5d8b, 0x5da7, 0x5dc0, 0x5ddb,
	0x5df3, 0x5e0f, 0x5e2f, 0x5e4b, 0x5e62, 0x5e7b, 0x5e96, 0x5eb4,
	0x5ecd, 0x5ee9, 0x5f04, 0x5f1d, 0x5f36, 0x5f51, 0x5f6a, 0x5f85,
	0x5f9d, 0x5fb5, 0x5fd0, 0x5fe9, 0x6003, 0x601c, 0x6037, 0x604f,
	0x6069, 0x6082, 0x609b, 0x60b5, 0x60d2, 0x60ed, 0x6108, 0x6121,
	// Entry 5F80 - 5FBF
	0x6139, 0x6154, 0x616d, 0x6185, 0x61a0, 0x61ba, 0x61d6, 0x61ef,
	0x6207, 0x6220, 0x6239, 0x6253, 0x626c, 0x6284, 0x629f, 0x62ba,
	0x62d3, 0x62ec, 0x6304, 0x631d, 0x6336, 0x6352, 0x636c, 0x6385,
	0x63a0, 0x63ba, 0x63d4, 0x63ef, 0x6406, 0x6422, 0x643a, 0x6452,
	0x646a, 0x6482, 0x649c, 0x64b6, 0x64cc, 0x64e4, 0x64fb, 0x6514,
	0x652e, 0x6547, 0x655e, 0x6576, 0x658f, 0x65a7, 0x65be, 0x65d7,
	0x65ef, 0x6608, 0x6620, 0x663d, 0x6654, 0x666d, 0x668c, 0x66a4,
	0x66bc, 0x66d5, 0x66ee, 0x6708, 0x6720, 0x6738, 0x6751, 0x6769,
	// Entry 5FC0 - 5FFF
	0x6781, 0x6799, 0x67b4, 0x67cd, 0x67e6, 0x67fe, 0x6817, 0x6831,
	0x6849, 0x6861, 0x687e, 0x6897, 0x68af, 0x68c8, 0x68e0, 0x68fb,
	0x6914, 0x692d, 0x6948, 0x6961, 0x697b, 0x6996, 0x69b0, 0x69c9,
	0x69e1, 0x69fd, 0x6a16, 0x6a30, 0x6a4d, 0x6a69, 0x6a81, 0x6a9a,
	0x6ab6, 0x6acf, 0x6aee, 0x6b06, 0x6b1e, 0x6b40, 0x6b64, 0x6b7d,
	0x6b97, 0x6bb0, 0x6bca, 0x6be1, 0x6bfb, 0x6c15, 0x6c2f, 0x6c4a,
	0x6c64, 0x6c7d, 0x6c96, 0x6cad, 0x6cc6, 0x6ce2, 0x6cff, 0x6d1b,
	0x6d35, 0x6d4e, 0x6d67, 0x6d80, 0x6d99, 0x6db1, 0x6dca, 0x6de2,
	// Entry 6000 - 603F
	0x6e02, 0x6e1a, 0x6e34, 0x6e4e, 0x6e68, 0x6e81, 0x6e9c, 0x6eb4,
	0x6ece, 0x6ee8, 0x6f00, 0x6f18, 0x6f34, 0x6f4d, 0x6f64, 0x6f7d,
	0x6f96, 0x6faf, 0x6fcb, 0x6feb, 0x7004, 0x701d, 0x7036, 0x704f,
	0x7067, 0x7080, 0x709b, 0x70b4, 0x70cc, 0x70e5, 0x70ff, 0x7117,
	0x7130, 0x7149, 0x7164, 0x717e, 0x719c, 0x71b8, 0x71d0, 0x71e9,
	0x71ff, 0x7217, 0x722d, 0x7243, 0x725b, 0x7279, 0x7291, 0x72a9,
	0x72cb, 0x72e4, 0x72fd, 0x7317, 0x7331, 0x7352, 0x7370, 0x7388,
	0x73a0, 0x73b9, 0x73d2, 0x73f1, 0x7409, 0x7421, 0x7439, 0x7451,
	// Entry 6040 - 607F
	0x7468, 0x747f, 0x7498, 0x74b0, 0x74cb, 0x74e3, 0x74fb, 0x7514,
	0x7532, 0x7549, 0x7560, 0x7578, 0x758f, 0x75a7, 0x75be, 0x75d6,
	0x75ee, 0x7605, 0x761d, 0x7635, 0x764d, 0x7666, 0x767d, 0x7693,
	0x76aa, 0x76c1, 0x76d9, 0x76f1, 0x7709, 0x7720, 0x7738, 0x7751,
	0x776b, 0x7783, 0x779c, 0x77b6, 0x77cc, 0x77e4, 0x77fd, 0x7814,
	0x782d, 0x7846, 0x785e, 0x7877, 0x788e, 0x78a8, 0x78c0, 0x78d8,
	0x78ef, 0x7908, 0x7921, 0x793a, 0x7952, 0x796a, 0x7981, 0x7998,
	0x79b1, 0x79c9, 0x79e5, 0x79fe, 0x7a16, 0x7a2f, 0x7a47, 0x7a5e,
	// Entry 6080 - 60BF
	0x7a75, 0x7a8d, 0x7aa4, 0x7abd, 0x7ad5, 0x7aec, 0x7b03, 0x7b1c,
	0x7b34, 0x7b4c, 0x7b66, 0x7b7f, 0x7b8c, 0x7b9a, 0x7ba7, 0x7bb5,
	0x7bc2, 0x7bcf, 0x7bdb, 0x7be9, 0x7bf8, 0x7c06, 0x7c14, 0x7c22,
	0x7c32, 0x7c3f, 0x7c4e, 0x7c5c, 0x7c69, 0x7c76, 0x7c82, 0x7c8f,
	0x7c9d, 0x7cac, 0x7cb9, 0x7cc6, 0x7cd2, 0x7cdf, 0x7ced, 0x7cfa,
	0x7d08, 0x7d15, 0x7d23, 0x7d31, 0x7d3e, 0x7d4b, 0x7d5a, 0x7d68,
	0x7d76, 0x7d83, 0x7d92, 0x7da1, 0x7daf, 0x7db8, 0x7dc8, 0x7ddd,
	0x7df0, 0x7e03, 0x7e16, 0x7e2a, 0x7e3e, 0x7e52, 0x7e67, 0x7e7c,
	// Entry 60C0 - 60FF
	0x7e8f, 0x7ea4, 0x7eb7, 0x7eca, 0x7ede, 0x7ef1, 0x7f04, 0x7f18,
	0x7f2b, 0x7f3e, 0x7f51, 0x7f66, 0x7f79, 0x7f8f, 0x7fa1, 0x7fb3,
	0x7fc6, 0x7fd8, 0x7feb, 0x7ffd, 0x800f, 0x802c, 0x8048, 0x8064,
	0x8084, 0x80a5, 0x80b8, 0x80cf, 0x80e6, 0x80fc, 0x8112, 0x8129,
	0x8140, 0x8156, 0x816c, 0x8182, 0x8198, 0x81af, 0x81c6, 0x81dd,
	0x81f4, 0x820b, 0x8222, 0x8239, 0x8250, 0x8266, 0x827c, 0x8293,
	0x82aa, 0x82c0, 0x82d6, 0x82ec, 0x8302, 0x8319, 0x8330, 0x834a,
	0x8366, 0x8380, 0x839a, 0x83b5, 0x83cf, 0x83ea, 0x8405, 0x841f,
	// Entry 6100 - 613F
	0x843a, 0x8454, 0x846f, 0x848b, 0x84a6, 0x84c2, 0x84de, 0x84f8,
	0x8511, 0x852b, 0x8545, 0x855e, 0x8576, 0x858f, 0x85a9, 0x85c3,
	0x85dc, 0x85f6, 0x8610, 0x8630, 0x864b, 0x8666, 0x8680, 0x869d,
	0x86b8, 0x86d3, 0x86ef, 0x8709, 0x8724, 0x873e, 0x8756, 0x876c,
	0x878a, 0x87a1, 0x87b7, 0x87cd, 0x87e5, 0x87fc, 0x8813, 0x8829,
	0x8841, 0x8859, 0x8870, 0x8888, 0x88a4, 0x88c5, 0x88e1, 0x8905,
	0x8925, 0x8942, 0x895b, 0x8971, 0x8986, 0x89a7, 0x89c1, 0x89d7,
	0x89ed, 0x8a03, 0x8a19, 0x8a2d, 0x8a4a, 0x8a66, 0x8a7b, 0x8a90,
	// Entry 6140 - 617F
	0x8aa5, 0x8acd, 0x8aee, 0x8b08, 0x8b27, 0x8b45, 0x8b63, 0x8b80,
	0x8b9b, 0x8bb5, 0x8bd0, 0x8bec, 0x8c06, 0x8c21, 0x8c3c, 0x8c57,
	0x8c72, 0x8c8d, 0x8ca8, 0x8cc2, 0x8cdc, 0x8cf6, 0x8d10, 0x8d2b,
	0x8d45, 0x8d5f, 0x8d7b, 0x8d97, 0x8db3, 0x8dcf, 0x8dee, 0x8e0a,
	0x8e27, 0x8e43, 0x8e5f, 0x8e7b, 0x8e97, 0x8eb3, 0x8ecf, 0x8eeb,
	0x8f07, 0x8f23, 0x8f3f, 0x8f5b, 0x8f77, 0x8f94, 0x8fb0, 0x8fcc,
	0x8fe9, 0x9006, 0x9022, 0x903e, 0x905b, 0x9077, 0x9093, 0x90af,
	0x90cc, 0x90e8, 0x9102, 0x911c, 0x9136, 0x9150, 0x916d, 0x9187,
	// Entry 6180 - 61BF
	0x91a2, 0x91bc, 0x91d6, 0x91f0, 0x920a, 0x9224, 0x923e, 0x9258,
	0x9272, 0x928c, 0x92a6, 0x92c0, 0x92da, 0x92f5, 0x930f, 0x9329,
	0x9344, 0x935f, 0x9379, 0x9393, 0x93ae, 0x93c8, 0x93e2, 0x93fc,
	0x9417, 0x9431, 0x9447, 0x945c, 0x9471, 0x9488, 0x949e, 0x94b4,
	0x94c9, 0x94e0, 0x94f7, 0x950d, 0x9523, 0x953c, 0x9555, 0x9570,
	0x958b, 0x95a5, 0x95bf, 0x95db, 0x95f6, 0x9611, 0x9635, 0x9659,
	0x967f, 0x9690, 0x96a5, 0x96bc, 0x96d6, 0x96e4, 0x96f2, 0x9703,
	0x9712, 0x9720, 0x972f, 0x9745, 0x9753, 0x9761, 0x9770, 0x977e,
	// Entry 61C0 - 61FF
	0x978c, 0x979e, 0x97af, 0x97be, 0x97cd, 0x97db, 0x97ea, 0x97fc,
	0x9812, 0x9821, 0x9831, 0x983f, 0x984e, 0x985d, 0x986d, 0x987d,
	0x988d, 0x989e, 0x98af, 0x98bd, 0x98cb, 0x98dc, 0x98ea, 0x98f9,
	0x9908, 0x9918, 0x992f, 0x993d, 0x994b, 0x995a, 0x996a, 0x997a,
	0x998a, 0x9999, 0x99a9, 0x99b9, 0x99c9, 0x99dc, 0x99ef, 0x9a08,
	0x9a17, 0x9a26, 0x9a35, 0x9a45, 0x9a54, 0x9a63, 0x9a75, 0x9a83,
	0x9a91, 0x9aa0, 0x9aaf, 0x9abf, 0x9ad6, 0x9ae6, 0x9af7, 0x9b05,
	0x9b13, 0x9b22, 0x9b31, 0x9b40, 0x9b50, 0x9b5e, 0x9b6d, 0x9b7c,
	// Entry 6200 - 623F
	0x9b9c, 0x9bb4, 0x9bc8, 0x9be2, 0x9bff, 0x9c10, 0x9c22, 0x9c35,
	0x9c47, 0x9c5a, 0x9c6b, 0x9c7d, 0x9c8f, 0x9ca0, 0x9cb1, 0x9cc3,
	0x9cd6, 0x9ce9, 0x9cfa, 0x9d0c, 0x9d1f, 0x9d33, 0x9d45, 0x9d57,
	0x9d69, 0x9d7b, 0x9d8e, 0x9d9f, 0x9db1, 0x9dc4, 0x9dd8, 0x9dea,
	0x9dfd, 0x9e10, 0x9e21, 0x9e33, 0x9e45, 0x9e58, 0x9e6b, 0x9e86,
	0x9e98, 0x9eb2, 0x9ec4, 0x9ed6, 0x9ee8, 0x9efa, 0x9f0b, 0x9f1d,
	0x9f30, 0x9f43, 0x9f55, 0x9f68, 0x9f7a, 0x9f8c, 0x9f9e, 0x9fb2,
	0x9fc4, 0x9fd3, 0x9fe6, 0x9ff5, 0xa004, 0xa016, 0xa028, 0xa03a,
	// Entry 6240 - 627F
	0xa04c, 0xa05e, 0xa070, 0xa082, 0xa09d, 0xa0b8, 0xa0d3, 0xa0ee,
	0xa109, 0xa124, 0xa139, 0xa14d, 0xa162, 0xa17c, 0xa196, 0xa1ba,
	0xa1e0, 0xa1f4, 0xa208, 0xa21c, 0xa230, 0xa244, 0xa258, 0xa26c,
	0xa280, 0xa294, 0xa2a8, 0xa2bc, 0xa2d0, 0xa2e4, 0xa2f8, 0xa30c,
	0xa320, 0xa334, 0xa348, 0xa35c, 0xa370, 0xa384, 0xa398, 0xa3ac,
	0xa3c0, 0xa3d4, 0xa3e8, 0xa3fc, 0xa410, 0xa424, 0xa438, 0xa44c,
	0xa460, 0xa474, 0xa488, 0xa49c, 0xa4b0, 0xa4c4, 0xa4d8, 0xa4ec,
	0xa500, 0xa514, 0xa528, 0xa53c, 0xa550, 0xa564, 0xa578, 0xa58c,
	// Entry 6280 - 62BF
	0xa5a0, 0xa5b4, 0xa5c8, 0xa5dc, 0xa5f0, 0xa604, 0xa618, 0xa62c,
	0xa640, 0xa654, 0xa668, 0xa67c, 0xa690, 0xa6a4, 0xa6b8, 0xa6cc,
	0xa6e0, 0xa6f4, 0xa708, 0xa71c, 0xa730, 0xa744, 0xa758, 0xa76c,
	0xa780, 0xa794, 0xa7a8, 0xa7bc, 0xa7d0, 0xa7e4, 0xa7f8, 0xa80c,
	0xa820, 0xa834, 0xa848, 0xa85c, 0xa870, 0xa884, 0xa898, 0xa8ac,
	0xa8c0, 0xa8d4, 0xa8e8, 0xa8fc, 0xa910, 0xa924, 0xa938, 0xa94c,
	0xa960, 0xa974, 0xa988, 0xa99c, 0xa9b0, 0xa9c4, 0xa9d8, 0xa9ec,
	0xaa00, 0xaa14, 0xaa28, 0xaa3c, 0xaa50, 0xaa64, 0xaa78, 0xaa8c,
	// Entry 62C0 - 62FF
	0xaaa0, 0xaab4, 0xaac8, 0xaadc, 0xaaf0, 0xab04, 0xab18, 0xab2c,
	0xab40, 0xab54, 0xab68, 0xab7c, 0xab90, 0xaba4, 0xabb8, 0xabcc,
	0xabe0, 0xabf4, 0xac08, 0xac1c, 0xac30, 0xac44, 0xac58, 0xac6c,
	0xac80, 0xac94, 0xaca8, 0xacbc, 0xacd0, 0xace4, 0xacf8, 0xad0c,
	0xad20, 0xad34, 0xad48, 0xad5c, 0xad70, 0xad84, 0xad98, 0xadac,
	0xadc0, 0xadd4, 0xade8, 0xadfc, 0xae10, 0xae24, 0xae38, 0xae4c,
	0xae60, 0xae74, 0xae88, 0xae9c, 0xaeb0, 0xaec4, 0xaed8, 0xaeec,
	0xaf00, 0xaf14, 0xaf28, 0xaf3c, 0xaf50, 0xaf64, 0xaf78, 0xaf8c,
	// Entry 6300 - 633F
	0xafa0, 0xafb4, 0xafc8, 0xafdc, 0xaff0, 0xb004, 0xb018, 0xb02c,
	0xb040, 0xb054, 0xb068, 0xb07c, 0xb090, 0xb0a4, 0xb0b8, 0xb0cc,
	0xb0e0, 0xb0f4, 0xb108, 0xb11c, 0xb130, 0xb144, 0xb158, 0xb16c,
	0xb180, 0xb194, 0xb1a8, 0xb1bc, 0xb1d0, 0xb1e4, 0xb1f8, 0xb20c,
	0xb220, 0xb234, 0xb248, 0xb25c, 0xb270, 0xb284, 0xb298, 0xb2ac,
	0xb2c0, 0xb2d4, 0xb2e8, 0xb2fc, 0xb310, 0xb324, 0xb338, 0xb34c,
	0xb360, 0xb374, 0xb388, 0xb39c, 0xb3b0, 0xb3c4, 0xb3d8, 0xb3ec,
	0xb400, 0xb414, 0xb428, 0xb43c, 0xb450, 0xb464, 0xb478, 0xb48c,
	// Entry 6340 - 637F
	0xb4a0, 0xb4b4, 0xb4c8, 0xb4dc, 0xb4f0, 0xb504, 0xb518, 0xb52c,
	0xb540, 0xb554, 0xb568, 0xb57c, 0xb590, 0xb5a4, 0xb5b8, 0xb5cc,
	0xb5e0, 0xb5f4, 0xb608, 0xb61c, 0xb630, 0xb644, 0xb658, 0xb66c,
	0xb680, 0xb694, 0xb6a8, 0xb6bc, 0xb6d0, 0xb6e4, 0xb6f8, 0xb70c,
	0xb720, 0xb734, 0xb748, 0xb75c, 0xb770, 0xb784, 0xb798, 0xb7ac,
	0xb7c0, 0xb7d4, 0xb7e8, 0xb7fc, 0xb810, 0xb824, 0xb838, 0xb84c,
	0xb860, 0xb874, 0xb888, 0xb89c, 0xb8b0, 0xb8c4, 0xb8d8, 0xb8ec,
	0xb900, 0xb914, 0xb928, 0xb93c, 0xb950, 0xb964, 0xb978, 0xb98c,
	// Entry 6380 - 63BF
	0xb9a0, 0xb9b4, 0xb9c8, 0xb9dc, 0xb9f0, 0xba04, 0xba18, 0xba2c,
	0xba40, 0xba54, 0xba68, 0xba7c, 0xba90, 0xbaa4, 0xbab8, 0xbacc,
	0xbae0, 0xbaf4, 0xbb08, 0xbb1c, 0xbb30, 0xbb44, 0xbb58, 0xbb6c,
	0xbb80, 0xbb94, 0xbba8, 0xbbbc, 0xbbd0, 0xbbe4, 0xbbf8, 0xbc0c,
	0xbc20, 0xbc34, 0xbc48, 0xbc5c, 0xbc70, 0xbc84, 0xbc98, 0xbcac,
	0xbcc0, 0xbcd4, 0xbce8, 0xbcfc, 0xbd10, 0xbd24, 0xbd38, 0xbd4c,
	0xbd60, 0xbd74, 0xbd88, 0xbd9c, 0xbdb0, 0xbdc4, 0xbdd8, 0xbdec,
	0xbe00, 0xbe14, 0xbe28, 0xbe3c, 0xbe50, 0xbe64, 0xbe78, 0xbe8c,
	// Entry 63C0 - 63FF
	0xbea0, 0xbeb4, 0xbec8, 0xbedc, 0xbef0, 0xbf04, 0xbf18, 0xbf2c,
	0xbf40, 0xbf54, 0xbf68, 0xbf7c, 0xbf90, 0xbfa4, 0xbfb8, 0xbfcc,
	0xbfe0, 0xbff4, 0xc008, 0xc01c, 0xc030, 0xc044, 0xc058, 0xc06c,
	0xc080, 0xc094, 0xc0a8, 0xc0bc, 0xc0d0, 0xc0e4, 0xc0f8, 0xc10c,
	0xc120, 0xc134, 0xc148, 0xc15c, 0xc170, 0xc184, 0xc198, 0xc1ac,
	0xc1c0, 0xc1d4, 0xc1e8, 0xc1fc, 0xc210, 0xc224, 0xc238, 0xc24c,
	0xc260, 0xc274, 0xc288, 0xc29c, 0xc2b0, 0xc2c4, 0xc2d8, 0xc2ec,
	0xc300, 0xc314, 0xc328, 0xc33c, 0xc350, 0xc364, 0xc378, 0xc38c,
	// Entry 6400 - 643F
	0xc3a0, 0xc3b4, 0xc3c8, 0xc3dc, 0xc3f0, 0xc404, 0xc418, 0xc42c,
	0xc440, 0xc454, 0xc468, 0xc47c, 0xc490, 0xc4a4, 0xc4b8, 0xc4cc,
	0xc4e0, 0xc4f4, 0xc508, 0xc51c, 0xc530, 0xc544, 0xc558, 0xc56c,
	0xc580, 0xc594, 0xc5a8, 0xc5bc, 0xc5d0, 0xc5e4, 0xc5f8, 0xc60c,
	0xc620, 0xc634, 0xc648, 0xc65c, 0xc670, 0xc684, 0xc698, 0xc6ac,
	0xc6c0, 0xc6d4, 0xc6e8, 0xc6fc, 0xc710, 0xc724, 0xc738, 0xc74c,
	0xc760, 0xc774, 0xc788, 0xc79c, 0xc7b0, 0xc7c4, 0xc7d8, 0xc7ec,
	0xc800, 0xc814, 0xc828, 0xc83c, 0xc850, 0xc864, 0xc878, 0xc88c,
	// Entry 6440 - 647F
	0xc8a0, 0xc8b4, 0xc8c8, 0xc8dc, 0xc8f0, 0xc904, 0xc918, 0xc92c,
	0xc940, 0xc954, 0xc968, 0xc97c, 0xc990, 0xc9a4, 0xc9b8, 0xc9cc,
	0xc9e0, 0xc9f4, 0xca08, 0xca1c, 0xca30, 0xca44, 0xca58, 0xca6c,
	0xca80, 0xca94, 0xcaa8, 0xcabc, 0xcad0, 0xcae4, 0xcaf8, 0xcb0c,
	0xcb20, 0xcb34, 0xcb48, 0xcb5c, 0xcb70, 0xcb84, 0xcb98, 0xcbac,
	0xcbc0, 0xcbd4, 0xcbe8, 0xcbfc, 0xcc10, 0xcc24, 0xcc38, 0xcc4c,
	0xcc60, 0xcc74, 0xcc88, 0xcc9c, 0xccb0, 0xccc4, 0xccd8, 0xccec,
	0xcd00, 0xcd14, 0xcd28, 0xcd3c, 0xcd50, 0xcd64, 0xcd78, 0xcd8c,
	// Entry 6480 - 64BF
	0xcda0, 0xcdb4, 0xcdc8, 0xcddc, 0xcdf0, 0xce04, 0xce18, 0xce2c,
	0xce40, 0xce54, 0xce68, 0xce7c, 0xce90, 0xcea4, 0xceb8, 0xcecc,
	0xcee0, 0xcef4, 0xcf08, 0xcf1c, 0xcf30, 0xcf44, 0xcf58, 0xcf6c,
	0xcf80, 0xcf94, 0xcfa8, 0xcfbc, 0xcfd0, 0xcfe4, 0xcff8, 0xd00c,
	0xd020, 0xd034, 0xd048, 0xd05c, 0xd070, 0xd084, 0xd098, 0xd0ac,
	0xd0c0, 0xd0d4, 0xd0e8, 0xd0fc, 0xd110, 0xd124, 0xd138, 0xd14c,
	0xd160, 0xd174, 0xd188, 0xd19c, 0xd1b0, 0xd1c4, 0xd1d8, 0xd1ec,
	0xd200, 0xd214, 0xd228, 0xd23c, 0xd250, 0xd264, 0xd278, 0xd28c,
	// Entry 64C0 - 64FF
	0xd2a0, 0xd2b4, 0xd2c8, 0xd2dc, 0xd2f0, 0xd304, 0xd318, 0xd32c,
	0xd340, 0xd354, 0xd368, 0xd37c, 0xd390, 0xd3a4, 0xd3b8, 0xd3cc,
	0xd3e0, 0xd3f4, 0xd408, 0xd41c, 0xd430, 0xd444, 0xd458, 0xd46c,
	0xd480, 0xd494, 0xd4a8, 0xd4bc, 0xd4d0, 0xd4e4, 0xd4f8, 0xd50c,
	0xd520, 0xd534, 0xd548, 0xd55c, 0xd570, 0xd584, 0xd598, 0xd5ac,
	0xd5c0, 0xd5d4, 0xd5e8, 0xd5fc, 0xd610, 0xd624, 0xd638, 0xd64c,
	0xd660, 0xd674, 0xd688, 0xd69c, 0xd6b0, 0xd6c4, 0xd6d8, 0xd6ec,
	0xd700, 0xd714, 0xd728, 0xd73c, 0xd750, 0xd764, 0xd778, 0xd78c,
	// Entry 6500 - 653F
	0xd7a0, 0xd7b4, 0xd7c8, 0xd7dc, 0xd7f0, 0xd804, 0xd818, 0xd82c,
	0xd840, 0xd854, 0xd868, 0xd87c, 0xd890, 0xd8a4, 0xd8b8, 0xd8cc,
	0xd8e0, 0xd8f4, 0xd908, 0xd91c, 0xd930, 0xd944, 0xd958, 0xd96c,
	0xd980, 0xd994, 0xd9a8, 0xd9bc, 0xd9d0, 0xd9e4, 0xd9f8, 0xda0c,
	0xda20, 0xda34, 0xda48, 0xda5c, 0xda70, 0xda84, 0xda98, 0xdaac,
	0xdac0, 0xdad4, 0xdae8, 0xdafc, 0xdb10, 0xdb24, 0xdb38, 0xdb4c,
	0xdb60, 0xdb74, 0xdb88, 0xdb9c, 0xdbb0, 0xdbc4, 0xdbd8, 0xdbec,
	0xdc00, 0xdc14, 0xdc28, 0xdc3c, 0xdc50, 0xdc64, 0xdc78, 0xdc8c,
	// Entry 6540 - 657F
	0xdca0, 0xdcb4, 0xdcc8, 0xdcdc, 0xdcf0, 0xdd04, 0xdd18, 0xdd2c,
	0xdd40, 0xdd54, 0xdd68, 0xdd7c, 0xdd90, 0xdda4, 0xddb8, 0xddcc,
	0xdde0, 0xde03, 0xde26, 0xde49, 0xde6c, 0xde8f, 0xdeb2, 0xded5,
	0xdef8, 0xdf1b, 0xdf3e, 0xdf61, 0xdf84, 0xdfa7, 0xdfca, 0xdfed,
	0xe010, 0xe033, 0xe056, 0xe079, 0xe09c, 0xe0bf, 0xe0e2, 0xe105,
	0xe128, 0xe14b, 0xe16e, 0xe191, 0xe1b4, 0xe1d7, 0xe1fa, 0xe21d,
	0xe240, 0xe263, 0xe286, 0xe2a9, 0xe2cc, 0xe2ef, 0xe312, 0xe335,
	0xe358, 0xe37b, 0xe39e, 0xe3c1, 0xe3e4, 0xe407, 0xe42a, 0xe44d,
	// Entry 6580 - 65BF
	0xe470, 0xe493, 0xe4b6, 0xe4d9, 0xe4fc, 0xe51f, 0xe542, 0xe565,
	0xe588, 0xe5ab, 0xe5ce, 0xe5f1, 0xe614, 0xe637, 0xe65a, 0xe67d,
	0xe6a0, 0xe6c3, 0xe6e6, 0xe709, 0xe72c, 0xe74f, 0xe772, 0xe795,
	0xe7b8, 0xe7db, 0xe7fe, 0xe821, 0xe844, 0xe867, 0xe88a, 0xe8ad,
	0xe8d0, 0xe8f3, 0xe916, 0xe939, 0xe95c, 0xe97f, 0xe9a2, 0xe9c5,
	0xe9e8, 0xea0b, 0xea2e, 0xea51, 0xea74, 0xea97, 0xeaba, 0xeadd,
	0xeb00, 0xeb23, 0xeb46, 0xeb69, 0xeb8c, 0xebaf, 0xebd2, 0xebf5,
	0xec18, 0xec3b, 0xec5e, 0xec81, 0xeca4, 0xecc7, 0xecea, 0xed0d,
	// Entry 65C0 - 65FF
	0xed30, 0xed53, 0xed76, 0xed99, 0xedbc, 0xeddf, 0xee02, 0xee25,
	0xee48, 0xee6b, 0xee8e, 0xeeb1, 0xeed4, 0xeef7, 0xef1a, 0xef3d,
	0xef60, 0xef83, 0xefa6, 0xefc9, 0xefec, 0xf00f, 0xf032, 0xf055,
	0xf078, 0xf09b, 0xf0be, 0xf0e1, 0xf104, 0xf127, 0xf14a, 0xf16d,
	0xf190, 0xf1b3, 0xf1d6, 0xf1f9, 0xf21c, 0xf23f, 0xf262, 0xf285,
	0xf2a8, 0xf2cb, 0xf2ee, 0xf311, 0xf334, 0xf357, 0xf37a, 0xf39d,
	0xf3c0, 0xf3e3, 0xf406, 0xf429, 0xf44c, 0xf46f, 0xf492, 0xf4b5,
	0xf4d8, 0xf4fb, 0xf51e, 0xf541, 0xf564, 0xf587, 0xf5aa, 0xf5cd,
	// Entry 6600 - 663F
	0xf5f0, 0xf613, 0xf636, 0xf659, 0xf67c, 0xf69f, 0xf6c2, 0xf6e5,
	0xf708, 0xf72b, 0xf74e, 0xf771, 0xf794, 0xf7b7, 0xf7da, 0xf7fd,
	0xf820, 0xf843, 0xf866, 0xf889, 0xf8ac, 0xf8cf, 0xf8f2, 0xf915,
	0xf938, 0xf95b, 0xf97e, 0xf9a1, 0xf9c4, 0xf9e7, 0xfa0a, 0xfa2d,
	0xfa50, 0xfa73, 0xfa96, 0xfab9, 0xfadc, 0xfaff, 0xfb22, 0xfb45,
	0xfb68, 0xfb8b, 0xfbae, 0xfbd1, 0xfbf4, 0xfc17, 0xfc3a, 0xfc5d,
	0xfc80, 0xfca3, 0xfcc6, 0xfce9, 0xfd0c, 0xfd2f, 0xfd52, 0xfd75,
	0xfd98, 0xfdbb, 0xfdde, 0xfe01, 0xfe24, 0xfe47, 0xfe6a, 0xfe8d,
	// Entry 6640 - 667F
	0xfeb0, 0xfed3, 0xfef6, 0xff19, 0xff3c, 0xff5f, 0xff82, 0xffa5,
	0xffc8, 0xffeb, 0x000e, 0x0031, 0x0054, 0x0077, 0x009a, 0x00bd,
	0x00e0, 0x0103, 0x0126, 0x0149, 0x016c, 0x018f, 0x01b2, 0x01d5,
	0x01f8, 0x021b, 0x023e, 0x0261, 0x0284, 0x02a7, 0x02ca, 0x02ed,
	0x0310, 0x0333, 0x0356, 0x0379, 0x039c, 0x03bf, 0x03e2, 0x0405,
	0x0428, 0x044b, 0x046e, 0x0491, 0x04b4, 0x04d7, 0x04fa, 0x051d,
	0x0540, 0x0563, 0x0586, 0x05a9, 0x05cc, 0x05ef, 0x0612, 0x0635,
	0x0658, 0x067b, 0x069e, 0x06c1, 0x06e4, 0x0707, 0x072a, 0x074d,
	// Entry 6680 - 66BF
	0x0770, 0x0793, 0x07b6, 0x07d9, 0x07fc, 0x081f, 0x0842, 0x0865,
	0x0888, 0x08ab, 0x08ce, 0x08f1, 0x0914, 0x0937, 0x095a, 0x097d,
	0x09a0, 0x09c3, 0x09e6, 0x0a09, 0x0a2c, 0x0a4f, 0x0a72, 0x0a95,
	0x0ab8, 0x0adb, 0x0afe, 0x0b21, 0x0b44, 0x0b67, 0x0b8a, 0x0bad,
	0x0bd0, 0x0bf3, 0x0c16, 0x0c39, 0x0c5c, 0x0c7f, 0x0ca2, 0x0cc5,
	0x0ce8, 0x0d0b, 0x0d2e, 0x0d51, 0x0d74, 0x0d97, 0x0dba, 0x0ddd,
	0x0e00, 0x0e23, 0x0e46, 0x0e69, 0x0e8c, 0x0eaf, 0x0ed2, 0x0ef5,
	0x0f18, 0x0f3b, 0x0f5e, 0x0f81, 0x0fa4, 0x0fc7, 0x0fea, 0x100d,
	// Entry 66C0 - 66FF
	0x1030, 0x1053, 0x1076, 0x1099, 0x10bc, 0x10df, 0x1102, 0x1125,
	0x1148, 0x116b, 0x118e, 0x11b1, 0x11d4, 0x11f7, 0x121a, 0x123d,
	0x1260, 0x1283, 0x12a6, 0x12c9, 0x12ec, 0x130f, 0x1332, 0x1355,
	0x1378, 0x139b, 0x13be, 0x13e1, 0x1404, 0x1427, 0x144a, 0x146d,
	0x1490, 0x14b3, 0x14d6, 0x14f9, 0x151c, 0x153f, 0x1562, 0x1585,
	0x15a8, 0x15cb, 0x15ee, 0x1611, 0x1634, 0x1657, 0x167a, 0x169d,
	0x16c0, 0x16e3, 0x1706, 0x1729, 0x174c, 0x176f, 0x1792, 0x17b5,
	0x17d8, 0x17fb, 0x181e, 0x1841, 0x1864, 0x1887, 0x18aa, 0x18cd,
	// Entry 6700 - 673F
	0x18f0, 0x1913, 0x1936, 0x1959, 0x197c, 0x199f, 0x19c2, 0x19e5,
	0x1a08, 0x1a2b, 0x1a4e, 0x1a71, 0x1a94, 0x1ab7, 0x1ada, 0x1afd,
	0x1b20, 0x1b43, 0x1b66, 0x1b89, 0x1bac, 0x1bcf, 0x1bf2, 0x1c15,
	0x1c38, 0x1c5b, 0x1c7e, 0x1ca1, 0x1cc4, 0x1ce7, 0x1d0a, 0x1d2d,
	0x1d50, 0x1d73, 0x1d96, 0x1db9, 0x1ddc, 0x1dff, 0x1e22, 0x1e3b,
	0x1e55, 0x1e6a, 0x1e7f, 0x1e94, 0x1eaa, 0x1ebf, 0x1ed4, 0x1ee9,
	0x1efe, 0x1f13, 0x1f28, 0x1f3d, 0x1f52, 0x1f67, 0x1f7c, 0x1f91,
	0x1fa6, 0x1fbb, 0x1fd0, 0x1fe5, 0x1ffa, 0x200f, 0x2025, 0x203b,
	// Entry 6740 - 677F
	0x2051, 0x2067, 0x207d, 0x2093, 0x20a9, 0x20bf, 0x20d5, 0x20ec,
	0x2103, 0x211a, 0x2130, 0x2146, 0x215c, 0x2172, 0x2188, 0x219e,
	0x21b4, 0x21ca, 0x21e0, 0x21f6, 0x220c, 0x2222, 0x2238, 0x224e,
	0x2264, 0x227a, 0x2290, 0x22a6, 0x22bc, 0x22d2, 0x22e8, 0x22fe,
	0x2314, 0x232a, 0x2341, 0x2357, 0x236d, 0x2383, 0x2399, 0x23af,
	0x23c5, 0x23db, 0x23f1, 0x2407, 0x241d, 0x2433, 0x2449, 0x245f,
	0x2475, 0x248b, 0x24a1, 0x24b7, 0x24cd, 0x24e3, 0x24f9, 0x250f,
	0x2525, 0x253b, 0x2551, 0x2567, 0x257d, 0x2593, 0x25a9, 0x25bf,
	// Entry 6780 - 67BF
	0x25d5, 0x25eb, 0x2601, 0x2617, 0x262d, 0x2643, 0x2659, 0x266f,
	0x2685, 0x269b, 0x26b1, 0x26c7, 0x26dd, 0x26f3, 0x2709, 0x271f,
	0x2735, 0x274b, 0x2761, 0x2777, 0x278e, 0x27a4, 0x27ba, 0x27d0,
	0x27e6, 0x27fc, 0x2812, 0x2828, 0x283e, 0x2854, 0x286a, 0x2880,
	0x2896, 0x28ac, 0x28c2, 0x28d8, 0x28ef, 0x2905, 0x291b, 0x2931,
	0x2947, 0x295d, 0x2973, 0x2989, 0x299f, 0x29b5, 0x29cb, 0x29e1,
	0x29f7, 0x2a0d, 0x2a23, 0x2a39, 0x2a4f, 0x2a66, 0x2a7c, 0x2a92,
	0x2aa8, 0x2abe, 0x2ad4, 0x2aea, 0x2b00, 0x2b16, 0x2b2c, 0x2b43,
	// Entry 67C0 - 67FF
	0x2b59, 0x2b6f, 0x2b85, 0x2b9b, 0x2bb1, 0x2bc7, 0x2bdd, 0x2bf3,
	0x2c09, 0x2c1f, 0x2c35, 0x2c4b, 0x2c61, 0x2c77, 0x2c8e, 0x2ca5,
	0x2cbb, 0x2cd1, 0x2ce7, 0x2cfd, 0x2d13, 0x2d29, 0x2d3f, 0x2d55,
	0x2d6b, 0x2d81, 0x2d97, 0x2dad, 0x2dc3, 0x2dd9, 0x2def, 0x2e05,
	0x2e1b, 0x2e31, 0x2e47, 0x2e5d, 0x2e73, 0x2e89, 0x2e9f, 0x2eb5,
	0x2ecb, 0x2ee1, 0x2ef7, 0x2f0d, 0x2f23, 0x2f39, 0x2f4f, 0x2f65,
	0x2f7b, 0x2f91, 0x2fa7, 0x2fbd, 0x2fd3, 0x2fe9, 0x2fff, 0x3015,
	0x302b, 0x3041, 0x3057, 0x306d, 0x3083, 0x309a, 0x30b0, 0x30c6,
	// Entry 6800 - 683F
	0x30dc, 0x30f2, 0x3108, 0x311e, 0x3134, 0x314a, 0x3160, 0x3176,
	0x318c, 0x31a3, 0x31b9, 0x31cf, 0x31e5, 0x31fb, 0x3211, 0x3227,
	0x323d, 0x3253, 0x3269, 0x327f, 0x3295, 0x32ab, 0x32c1, 0x32d7,
	0x32ed, 0x3303, 0x3319, 0x332f, 0x3345, 0x335b, 0x3371, 0x3387,
	0x339d, 0x33b3, 0x33c9, 0x33df, 0x33f5, 0x340b, 0x3421, 0x3437,
	0x344d, 0x3463, 0x3479, 0x348f, 0x34a5, 0x34bb, 0x34d1, 0x34e7,
	0x34fd, 0x3513, 0x3529, 0x353f, 0x3555, 0x356b, 0x3581, 0x3597,
	0x35ad, 0x35c3, 0x35d9, 0x35ef, 0x3605, 0x361b, 0x3631, 0x3647,
	// Entry 6840 - 687F
	0x365d, 0x3673, 0x3689, 0x369f, 0x36ba, 0x36d5, 0x36ed, 0x3705,
	0x371d, 0x3735, 0x374d, 0x3765, 0x377c, 0x3791, 0x37a6, 0x37bb,
	0x37d0, 0x37e5, 0x37fa, 0x380f, 0x3824, 0x3839, 0x384e, 0x3863,
	0x3878, 0x388d, 0x38a2, 0x38b7, 0x38cc, 0x38e1, 0x38f6, 0x390b,
	0x3920, 0x3935, 0x394a, 0x395f, 0x3974, 0x3989, 0x399e, 0x39b3,
	0x39c8, 0x39dd, 0x39f2, 0x3a07, 0x3a1c, 0x3a31, 0x3a46, 0x3a5b,
	0x3a70, 0x3a85, 0x3a9a, 0x3aaf, 0x3ac4, 0x3ad9, 0x3aee, 0x3b03,
	0x3b18, 0x3b2d, 0x3b42, 0x3b57, 0x3b6c, 0x3b81, 0x3b96, 0x3bab,
	// Entry 6880 - 68BF
	0x3bc0, 0x3bd5, 0x3bea, 0x3bff, 0x3c14, 0x3c29, 0x3c3e, 0x3c53,
	0x3c68, 0x3c7d, 0x3c92, 0x3ca7, 0x3cbc, 0x3cd1, 0x3ce6, 0x3cfb,
	0x3d10, 0x3d25, 0x3d3a, 0x3d4f, 0x3d64, 0x3d79, 0x3d8e, 0x3da3,
	0x3db8, 0x3dcd, 0x3de2, 0x3df7, 0x3e0c, 0x3e21, 0x3e36, 0x3e4b,
	0x3e60, 0x3e75, 0x3e8a, 0x3e9f, 0x3eb4, 0x3ec9, 0x3ede, 0x3ef3,
	0x3f08, 0x3f1d, 0x3f32, 0x3f47, 0x3f5c, 0x3f71, 0x3f86, 0x3f9b,
	0x3fb0, 0x3fc5, 0x3fda, 0x3fef, 0x4004, 0x4019, 0x402e, 0x4043,
	0x4058, 0x406d, 0x4082, 0x4097, 0x40ac, 0x40c1, 0x40d6, 0x40eb,
	// Entry 68C0 - 68FF
	0x4100, 0x4115, 0x412a, 0x413f, 0x4154, 0x4169, 0x417e, 0x4193,
	0x41a8, 0x41bd, 0x41d2, 0x41e7, 0x41fc, 0x4211, 0x4226, 0x423b,
	0x4250, 0x4265, 0x427a, 0x428f, 0x42a4, 0x42b9, 0x42ce, 0x42e3,
	0x42f8, 0x430d, 0x4322, 0x4337, 0x434c, 0x4361, 0x4376, 0x438b,
	0x43a0, 0x43b5, 0x43ca, 0x43df, 0x43f4, 0x4409, 0x441e, 0x4433,
	0x4448, 0x445d, 0x4472, 0x4487, 0x449c, 0x44b1, 0x44c6, 0x44db,
	0x44f0, 0x4505, 0x451a, 0x452f, 0x4544, 0x4559, 0x456e, 0x4583,
	0x4598, 0x45ad, 0x45c2, 0x45d7, 0x45ec, 0x4601, 0x4616, 0x462b,
	// Entry 6900 - 693F
	0x4640, 0x4655, 0x466a, 0x467f, 0x4694, 0x46a9, 0x46be, 0x46d3,
	0x46e8, 0x46fd, 0x4712, 0x4727, 0x473c, 0x4751, 0x4766, 0x477b,
	0x4790, 0x47a5, 0x47ba, 0x47cf, 0x47e4, 0x47f9, 0x480e, 0x4823,
	0x4838, 0x484d, 0x4862, 0x4877, 0x488c, 0x48a1, 0x48b6, 0x48cb,
	0x48e0, 0x48f5, 0x490a, 0x491f, 0x4934, 0x4949, 0x495e, 0x4973,
	0x4988, 0x499d, 0x49b2, 0x49c7, 0x49dc, 0x49f1, 0x4a06, 0x4a1b,
	0x4a30, 0x4a45, 0x4a5a, 0x4a6f, 0x4a84, 0x4a99, 0x4aae, 0x4ac3,
	0x4ad8, 0x4aed, 0x4b02, 0x4b17, 0x4b2c, 0x4b41, 0x4b56, 0x4b6b,
	// Entry 6940 - 697F
	0x4b80, 0x4b95, 0x4baa, 0x4bbf, 0x4bd4, 0x4be9, 0x4bfe, 0x4c13,
	0x4c28, 0x4c3d, 0x4c52, 0x4c67, 0x4c7c, 0x4c91, 0x4ca6, 0x4cbb,
	0x4cd0, 0x4ce5, 0x4cfa, 0x4d0f, 0x4d24, 0x4d39, 0x4d4e, 0x4d63,
	0x4d78, 0x4d8d, 0x4da2, 0x4db7, 0x4dcc, 0x4de1, 0x4df6, 0x4e0b,
	0x4e20, 0x4e35, 0x4e4a, 0x4e5f, 0x4e74, 0x4e89, 0x4e9e, 0x4eb3,
	0x4ec8, 0x4edd, 0x4ef2, 0x4f07, 0x4f1c, 0x4f31, 0x4f46, 0x4f5b,
	0x4f70, 0x4f85, 0x4f9a, 0x4faf, 0x4fc4, 0x4fd9, 0x4fee, 0x5003,
	0x5018, 0x502d, 0x5042, 0x5057, 0x506c, 0x5081, 0x5096, 0x50ab,
	// Entry 6980 - 69BF
	0x50c0, 0x50d5, 0x50ea, 0x50ff, 0x5114, 0x5129, 0x513e, 0x5153,
	0x5168, 0x517d, 0x5192, 0x51a7, 0x51bc, 0x51d1, 0x51e6, 0x51fb,
	0x5210, 0x5225, 0x523a, 0x524f, 0x5264, 0x5279, 0x528e, 0x52a3,
	0x52b8, 0x52cd, 0x52e2, 0x52f7, 0x530c, 0x5321, 0x5336, 0x534b,
	0x5360, 0x5375, 0x538a, 0x539f, 0x53b4, 0x53c9, 0x53de, 0x53f3,
	0x5408, 0x541d, 0x5432, 0x5447, 0x545c, 0x5471, 0x5486, 0x549b,
	0x54b0, 0x54c5, 0x54da, 0x54ef, 0x5504, 0x5519, 0x552e, 0x5543,
	0x5558, 0x556d, 0x5582, 0x5597, 0x55ac, 0x55c1, 0x55d6, 0x55eb,
	// Entry 69C0 - 69FF
	0x5600, 0x5615, 0x562a, 0x563f, 0x5654, 0x5669, 0x567e, 0x5693,
	0x56a8, 0x56bd, 0x56d2, 0x56e7, 0x56fc, 0x5711, 0x5726, 0x573b,
	0x5750, 0x5765, 0x577a, 0x578f, 0x57a4, 0x57b9, 0x57ce, 0x57e3,
	0x57f8, 0x5809, 0x581a, 0x582b, 0x583c, 0x584d, 0x585e, 0x586f,
	0x5880, 0x5891, 0x58a2, 0x58b3, 0x58c4, 0x58d7, 0x58ea, 0x58fd,
	0x5910, 0x5923, 0x5935, 0x594d, 0x595f, 0x5971, 0x5988, 0x599a,
	0x59ac, 0x59be, 0x59cf, 0x59e0, 0x59f1, 0x5a02, 0x5a15, 0x5a28,
	0x5a3b, 0x5a4e, 0x5a68, 0x5a82, 0x5a9c, 0x5ac8, 0x5ae2, 0x5b02,
	// Entry 6A00 - 6A3F
	0x5b15, 0x5b28, 0x5b3b, 0x5b4e, 0x5b63, 0x5b78, 0x5b8d, 0x5ba2,
	0x5bbe, 0x5bd1, 0x5be6, 0x5bf9, 0x5c0e, 0x5c21, 0x5c36, 0x5c49,
	0x5c5e, 0x5c6f, 0x5c81, 0x5c94, 0x5ca7, 0x5cba, 0x5ccf, 0x5ce4,
	0x5cf7, 0x5d0c, 0x5d1d, 0x5d35, 0x5d47, 0x5d58, 0x5d6b, 0x5d7c,
	0x5d8d, 0x5d9f, 0x5db6, 0x5dc8, 0x5dda, 0x5df2, 0x5e0c, 0x5e24,
	0x5e3a, 0x5e4c, 0x5e5d, 0x5e6f, 0x5e81, 0x5e94, 0x5eaa, 0x5ec4,
	0x5ed6, 0x5eed, 0x5f00, 0x5f12, 0x5f24, 0x5f36, 0x5f48, 0x5f5a,
	0x5f6d, 0x5f80, 0x5f97, 0x5fae, 0x5fc5, 0x5fdc, 0x5ff5, 0x600e,
	// Entry 6A40 - 6A7F
	0x6026, 0x603e, 0x6056, 0x606f, 0x6094, 0x60b8, 0x60de, 0x6100,
	0x6122, 0x6145, 0x6163, 0x618f, 0x61ae, 0x61ca, 0x61e8, 0x6206,
	0x622a, 0x6243, 0x6262, 0x627b, 0x6299, 0x62b0, 0x62ca, 0x62e2,
	0x62fa, 0x6316, 0x632e, 0x634c, 0x6364, 0x6381, 0x6397, 0x63b0,
	0x63c7, 0x63de, 0x63f9, 0x6411, 0x642b, 0x6449, 0x645d, 0x6483,
	0x64a2, 0x64c5, 0x64df, 0x64f7, 0x6515, 0x6534, 0x6558, 0x6582,
	0x65a6, 0x65d1, 0x65f6, 0x6617, 0x6639, 0x665d, 0x667f, 0x66a7,
	0x66c8, 0x66f2, 0x671a, 0x6739, 0x675b, 0x677e, 0x67a7, 0x67c7,
	// Entry 6A80 - 6ABF
	0x67e5, 0x680d, 0x6835, 0x6854, 0x6875, 0x6893, 0x68b9, 0x68e2,
	0x690d, 0x692e, 0x694f, 0x6978, 0x69a0, 0x69c9, 0x69f3, 0x6a14,
	0x6a33, 0x6a51, 0x6a79, 0x6a99, 0x6abe, 0x6add, 0x6b06, 0x6b33,
	0x6b5e, 0x6b7c, 0x6b9a, 0x6bb6, 0x6bd3, 0x6bf3, 0x6c15, 0x6c3b,
	0x6c63, 0x6c85, 0x6caf, 0x6cd7, 0x6cf8, 0x6d1a, 0x6d3b, 0x6d65,
	0x6d85, 0x6db2, 0x6ddf, 0x6dff, 0x6e1c, 0x6e3c, 0x6e62, 0x6e88,
	0x6ead, 0x6ed2, 0x6ef3, 0x6f16, 0x6f38, 0x6f58, 0x6f79, 0x6fa1,
	0x6fc9, 0x6fee, 0x7018, 0x7040, 0x705f, 0x7086, 0x70b7, 0x70d7,
	// Entry 6AC0 - 6AFF
	0x70ff, 0x711f, 0x713f, 0x7163, 0x7186, 0x71a9, 0x71cf, 0x71ee,
	0x7211, 0x7231, 0x7259, 0x7281, 0x72ac, 0x72cc, 0x72f4, 0x7319,
	0x733c, 0x7360, 0x737e, 0x73a3, 0x73c4, 0x73e7, 0x740c, 0x7435,
	0x745d, 0x7484, 0x74af, 0x74db, 0x7502, 0x752a, 0x7551, 0x7577,
	0x75a4, 0x75ca, 0x75f2, 0x761a, 0x763f, 0x7668, 0x768a, 0x76ac,
	0x76ce, 0x76ef, 0x770f, 0x7732, 0x7759, 0x7782, 0x77a7, 0x77cb,
	0x77f0, 0x780d, 0x782b, 0x784a, 0x786b, 0x788b, 0x78b7, 0x78e2,
	0x790f, 0x793f, 0x796e, 0x7995, 0x79cb, 0x79fe, 0x7a1f, 0x7a5c,
	// Entry 6B00 - 6B3F
	0x7a98, 0x7acd, 0x7aef, 0x7b0d, 0x7b30, 0x7b50, 0x7b78, 0x7b9f,
	0x7bc2, 0x7be7, 0x7c0a, 0x7c2e, 0x7c56, 0x7c7f, 0x7cad, 0x7ce0,
	0x7d10, 0x7d45, 0x7d73, 0x7d9e, 0x7dce, 0x7e06, 0x7e35, 0x7e64,
	0x7e94, 0x7ec8, 0x7ef6, 0x7f23, 0x7f4e, 0x7f7b, 0x7fad, 0x7fe5,
	0x8011, 0x803e, 0x806d, 0x808e, 0x80b1, 0x80e8, 0x8114, 0x8142,
	0x816c, 0x8198, 0x81cb, 0x81f7, 0x8223, 0x8254, 0x8284, 0x82bb,
	0x82f4, 0x8328, 0x835d, 0x8383, 0x83a7, 0x83cc, 0x83f1, 0x8427,
	0x845b, 0x8486, 0x84b1, 0x84de, 0x850f, 0x854b, 0x8580, 0x85b8,
	// Entry 6B40 - 6B7F
	0x85e9, 0x8625, 0x865a, 0x8692, 0x86b8, 0x86de, 0x870a, 0x8737,
	0x875e, 0x8787, 0x87b0, 0x87e1, 0x8813, 0x8847, 0x886f, 0x889f,
	0x88d0, 0x8903, 0x8927, 0x894c, 0x896b, 0x898e, 0x89b2, 0x89d5,
	0x89f8, 0x8a1b, 0x8a3e, 0x8a61, 0x8a8c, 0x8ab5, 0x8ae0, 0x8b09,
	0x8b2d, 0x8b55, 0x8b72, 0x8b8f, 0x8bab, 0x8bcf, 0x8bec, 0x8c08,
	0x8c27, 0x8c47, 0x8c61, 0x8c79, 0x8c8f, 0x8ca3, 0x8cb6, 0x8cd6,
	0x8cf6, 0x8d16, 0x8d2c, 0x8d48, 0x8d62, 0x8d78, 0x8d8c, 0x8da2,
	0x8dbf, 0x8ddc, 0x8dfb, 0x8e19, 0x8e37, 0x8e54, 0x8e77, 0x8e9b,
	// Entry 6B80 - 6BBF
	0x8eb0, 0x8ed1, 0x8ef3, 0x8f08, 0x8f1d, 0x8f3e, 0x8f60, 0x8f7a,
	0x8f94, 0x8fb8, 0x8fd3, 0x8fed, 0x9003, 0x901b, 0x9034, 0x904f,
	0x9066, 0x907f, 0x90a0, 0x90c0, 0x90da, 0x90f1, 0x910b, 0x9126,
	0x9146, 0x9167, 0x9180, 0x9199, 0x91b1, 0x91cc, 0x91e6, 0x9203,
	0x9224, 0x9244, 0x9271, 0x928a, 0x92a6, 0x92c6, 0x92ea, 0x930e,
	0x9337, 0x9360, 0x938b, 0x93b6, 0x93e2, 0x940e, 0x9439, 0x9464,
	0x9493, 0x94c2, 0x94e4, 0x9506, 0x9537, 0x9568, 0x958b, 0x95a7,
	0x95c4, 0x95e0, 0x9605, 0x962a, 0x963e, 0x9657, 0x966f, 0x968a,
	// Entry 6BC0 - 6BFF
	0x96a4, 0x96c1, 0x96e2, 0x9702, 0x972f, 0x974c, 0x9776, 0x9798,
	0x97ba, 0x97dc, 0x97fd, 0x981e, 0x983f, 0x9868, 0x9887, 0x98a6,
	0x98c5, 0x98e4, 0x9903, 0x991c, 0x9933, 0x994b, 0x9961, 0x997a,
	0x9991, 0x99ac, 0x99c5, 0x99e4, 0x9a05, 0x9a24, 0x9a4a, 0x9a6a,
	0x9a93, 0x9abb, 0x9ad9, 0x9af5, 0x9b13, 0x9b30, 0x9b4c, 0x9b69,
	0x9b87, 0x9ba4, 0x9bca, 0x9bf0, 0x9c0a, 0x9c1f, 0x9c2f, 0x9c43,
	0x9c57, 0x9c6b, 0x9c83, 0x9c9d, 0x9cbc, 0x9cde, 0x9cef, 0x9d02,
	0x9d1e, 0x9d37, 0x9d4d, 0x9d6d, 0x9d8d, 0x9dad, 0x9dcd, 0x9ded,
	// Entry 6C00 - 6C3F
	0x9e0d, 0x9e2d, 0x9e4d, 0x9e6d, 0x9e8e, 0x9eaf, 0x9ec9, 0x9ee3,
	0x9eff, 0x9f1a, 0x9f3b, 0x9f5a, 0x9f7b, 0x9fa2, 0x9fbb, 0x9fd7,
	0x9ff5, 0xa010, 0xa02d, 0xa04c, 0xa05f, 0xa076, 0xa08b, 0xa09f,
	0xa0b4, 0xa0d3, 0xa0f2, 0xa107, 0xa122, 0xa141, 0xa160, 0xa179,
	0xa192, 0xa1b4, 0xa1d8, 0xa1f2, 0xa210, 0xa22a, 0xa248, 0xa27f,
	0xa2b8, 0xa2fc, 0xa335, 0xa370, 0xa3b8, 0xa400, 0xa448, 0xa45c,
	0xa47b, 0xa49a, 0xa4b1, 0xa4c5, 0xa4db, 0xa4f0, 0xa508, 0xa51f,
	0xa536, 0xa54e, 0xa56d, 0xa58c, 0xa5ad, 0xa5ca, 0xa5e6, 0xa608,
	// Entry 6C40 - 6C7F
	0xa628, 0xa64d, 0xa66d, 0xa68c, 0xa6b8, 0xa6e2, 0xa70d, 0xa736,
	0xa755, 0xa772, 0xa78f, 0xa7ac, 0xa7c9, 0xa7e6, 0xa803, 0xa820,
	0xa83d, 0xa85a, 0xa878, 0xa896, 0xa8b4, 0xa8d2, 0xa8f0, 0xa90e,
	0xa92c, 0xa94a, 0xa968, 0xa986, 0xa9a4, 0xa9c2, 0xa9e0, 0xa9fe,
	0xaa1c, 0xaa3a, 0xaa58, 0xaa76, 0xaa94, 0xaab2, 0xaad6, 0xaafa,
	0xab1e, 0xab42, 0xab66, 0xab8a, 0xabaf, 0xabd4, 0xabf9, 0xac1e,
	0xac43, 0xac68, 0xac8d, 0xacb2, 0xacd7, 0xacfc, 0xad21, 0xad46,
	0xad6b, 0xad90, 0xadb5, 0xadda, 0xadff, 0xae24, 0xae49, 0xae6e,
	// Entry 6C80 - 6CBF
	0xae93, 0xaeb8, 0xaedd, 0xaf02, 0xaf27, 0xaf4c, 0xaf71, 0xaf96,
	0xafbb, 0xafe0, 0xb005, 0xb024, 0xb045, 0xb066, 0xb07a, 0xb08c,
	0xb09d, 0xb0ae, 0xb0c1, 0xb0d3, 0xb0e5, 0xb0f6, 0xb109, 0xb11c,
	0xb12e, 0xb13f, 0xb153, 0xb167, 0xb17d, 0xb193, 0xb1a8, 0xb1bd,
	0xb1d4, 0xb1ea, 0xb200, 0xb212, 0xb22b, 0xb241, 0xb25a, 0xb272,
	0xb282, 0xb296, 0xb2af, 0xb2c2, 0xb2d7, 0xb2f2, 0xb30b, 0xb31f,
	0xb337, 0xb352, 0xb37b, 0xb393, 0xb3ad, 0xb3c3, 0xb3dc, 0xb3ef,
	0xb404, 0xb41e, 0xb433, 0xb44a, 0xb45f, 0xb474, 0xb48c, 0xb49e,
	// Entry 6CC0 - 6CFF
	0xb4af, 0xb4c7, 0xb4de, 0xb4f2, 0xb506, 0xb520, 0xb53d, 0xb552,
	0xb566, 0xb57d, 0xb592, 0xb5a9, 0xb5bf, 0xb5d3, 0xb5e9, 0xb600,
	0xb61a, 0xb630, 0xb64b, 0xb663, 0xb676, 0xb68d, 0xb6a6, 0xb6bb,
	0xb6cf, 0xb6e3, 0xb704, 0xb71b, 0xb730, 0xb746, 0xb759, 0xb773,
	0xb78d, 0xb7a6, 0xb7c0, 0xb7d5, 0xb7ef, 0xb80a, 0xb81d, 0xb830,
	0xb845, 0xb858, 0xb86f, 0xb886, 0xb89b, 0xb8b3, 0xb8ca, 0xb8e0,
	0xb8f6, 0xb90e, 0xb923, 0xb938, 0xb951, 0xb969, 0xb983, 0xb99d,
	0xb9b4, 0xb9cb, 0xb9e6, 0xba01, 0xba1e, 0xba3a, 0xba56, 0xba71,
	// Entry 6D00 - 6D3F
	0xba8e, 0xbaab, 0xbac7, 0xbae2, 0xbafd, 0xbb1a, 0xbb36, 0xbb52,
	0xbb6d, 0xbb8a, 0xbba7, 0xbbc3, 0xbbdd, 0xbbf7, 0xbc13, 0xbc2e,
	0xbc49, 0xbc57, 0xbc66, 0xbc81, 0xbc9c, 0xbcb7, 0xbcd2, 0xbced,
	0xbd08, 0xbd23, 0xbd3e, 0xbd59, 0xbd74, 0xbd8f, 0xbdaa, 0xbdc5,
	0xbde0, 0xbdfb, 0xbe16, 0xbe31, 0xbe4c, 0xbe67, 0xbe82, 0xbe9d,
	0xbeb8, 0xbed3, 0xbeee, 0xbf09, 0xbf24, 0xbf3d, 0xbf56, 0xbf6f,
	0xbf88, 0xbfa1, 0xbfba, 0xbfd3, 0xbfec, 0xc005, 0xc01e, 0xc037,
	0xc050, 0xc069, 0xc082, 0xc09b, 0xc0b4, 0xc0cd, 0xc0e6, 0xc0ff,
	// Entry 6D40 - 6D7F
	0xc118, 0xc131, 0xc14a, 0xc163, 0xc17c, 0xc195, 0xc1ae, 0xc1cb,
	0xc1e8, 0xc205, 0xc222, 0xc23f, 0xc25c, 0xc279, 0xc296, 0xc2b3,
	0xc2d0, 0xc2ed, 0xc30a, 0xc327, 0xc344, 0xc361, 0xc37e, 0xc39b,
	0xc3b8, 0xc3d5, 0xc3f2, 0xc40f, 0xc42c, 0xc449, 0xc466, 0xc483,
	0xc4a0, 0xc4bb, 0xc4d6, 0xc4f1, 0xc50c, 0xc527, 0xc542, 0xc55d,
	0xc578, 0xc593, 0xc5ae, 0xc5c9, 0xc5e4, 0xc5ff, 0xc61a, 0xc635,
	0xc650, 0xc66b, 0xc686, 0xc6a1, 0xc6bc, 0xc6d7, 0xc6f2, 0xc70d,
	0xc728, 0xc743, 0xc765, 0xc787, 0xc7a9, 0xc7cb, 0xc7ed, 0xc80f,
	// Entry 6D80 - 6DBF
	0xc831, 0xc853, 0xc875, 0xc897, 0xc8b9, 0xc8db, 0xc8fd, 0xc91f,
	0xc941, 0xc963, 0xc985, 0xc9a7, 0xc9c9, 0xc9eb, 0xca0d, 0xca2f,
	0xca51, 0xca73, 0xca95, 0xcab7, 0xcad7, 0xcaf7, 0xcb17, 0xcb37,
	0xcb57, 0xcb77, 0xcb97, 0xcbb7, 0xcbd7, 0xcbf7, 0xcc17, 0xcc37,
	0xcc57, 0xcc77, 0xcc97, 0xccb7, 0xccd7, 0xccf7, 0xcd17, 0xcd37,
	0xcd57, 0xcd77, 0xcd97, 0xcdb7, 0xcdd7, 0xcdf7, 0xce14, 0xce31,
	0xce4e, 0xce6b, 0xce88, 0xcea5, 0xcec2, 0xcedf, 0xcefc, 0xcf19,
	0xcf36, 0xcf53, 0xcf70, 0xcf8d, 0xcfaa, 0xcfc7, 0xcfe4, 0xd001,
	// Entry 6DC0 - 6DFF
	0xd01c, 0xd037, 0xd052, 0xd06d, 0xd088, 0xd0a3, 0xd0be, 0xd0d9,
	0xd0f4, 0xd10f, 0xd12a, 0xd145, 0xd160, 0xd17b, 0xd196, 0xd1b1,
	0xd1cc, 0xd1e7, 0xd202, 0xd21d, 0xd238, 0xd253, 0xd26e, 0xd290,
	0xd2b2, 0xd2d4, 0xd2f6, 0xd318, 0xd33a, 0xd35c, 0xd37e, 0xd3a0,
	0xd3c2, 0xd3e4, 0xd406, 0xd428, 0xd44a, 0xd46c, 0xd48e, 0xd4b0,
	0xd4d2, 0xd4f4, 0xd516, 0xd538, 0xd55a, 0xd57c, 0xd59e, 0xd5c0,
	0xd5e2, 0xd602, 0xd622, 0xd642, 0xd662, 0xd682, 0xd6a2, 0xd6c2,
	0xd6e2, 0xd702, 0xd722, 0xd742, 0xd762, 0xd782, 0xd7a2, 0xd7c2,
	// Entry 6E00 - 6E3F
	0xd7e2, 0xd802, 0xd822, 0xd842, 0xd862, 0xd882, 0xd8a2, 0xd8c2,
	0xd8e2, 0xd902, 0xd922, 0xd940, 0xd95e, 0xd97c, 0xd99a, 0xd9b8,
	0xd9d6, 0xd9f4, 0xda12, 0xda30, 0xda4e, 0xda6c, 0xda8a, 0xdaa8,
	0xdac6, 0xdae4, 0xdb02, 0xdb20, 0xdb3e, 0xdb5c, 0xdb7a, 0xdb98,
	0xdbb4, 0xdbd0, 0xdbec, 0xdc08, 0xdc24, 0xdc40, 0xdc5c, 0xdc78,
	0xdc94, 0xdcb0, 0xdccc, 0xdce8, 0xdd04, 0xdd20, 0xdd3c, 0xdd58,
	0xdd74, 0xdd90, 0xddac, 0xddc8, 0xdde4, 0xde00, 0xde1c, 0xde38,
	0xde54, 0xde70, 0xde94, 0xdeb8, 0xdedc, 0xdf00, 0xdf24, 0xdf48,
	// Entry 6E40 - 6E7F
	0xdf6c, 0xdf90, 0xdfb4, 0xdfd8, 0xdffc, 0xe020, 0xe044, 0xe068,
	0xe08c, 0xe0b0, 0xe0d4, 0xe0f8, 0xe11c, 0xe13e, 0xe160, 0xe182,
	0xe1a4, 0xe1c6, 0xe1e8, 0xe20a, 0xe22c, 0xe24e, 0xe270, 0xe292,
	0xe2b4, 0xe2d6, 0xe2f8, 0xe31a, 0xe33c, 0xe35e, 0xe380, 0xe3a2,
	0xe3c4, 0xe3e6, 0xe408, 0xe42a, 0xe44c, 0xe46e, 0xe490, 0xe4b3,
	0xe4d6, 0xe4f9, 0xe51c, 0xe53f, 0xe562, 0xe585, 0xe5a8, 0xe5cb,
	0xe5ee, 0xe611, 0xe634, 0xe657, 0xe67a, 0xe69d, 0xe6c0, 0xe6e3,
	0xe706, 0xe729, 0xe74c, 0xe76f, 0xe792, 0xe7b5, 0xe7d8, 0xe7fb,
	// Entry 6E80 - 6EBF
	0xe81e, 0xe83f, 0xe860, 0xe881, 0xe8a2, 0xe8c3, 0xe8e4, 0xe905,
	0xe926, 0xe947, 0xe968, 0xe989, 0xe9aa, 0xe9cb, 0xe9ec, 0xea0d,
	0xea2e, 0xea4f, 0xea70, 0xea91, 0xeab2, 0xead3, 0xeaf4, 0xeb15,
	0xeb36, 0xeb57, 0xeb78, 0xeb99, 0xebba, 0xebdb, 0xebfc, 0xec1d,
	0xec3e, 0xec5f, 0xec80, 0xeca1, 0xecc2, 0xece3, 0xed04, 0xed25,
	0xed46, 0xed67, 0xed88, 0xeda9, 0xedca, 0xedeb, 0xee0c, 0xee2d,
	0xee4e, 0xee6f, 0xee90, 0xeeb1, 0xeed2, 0xeef1, 0xef10, 0xef2f,
	0xef4e, 0xef6d, 0xef8c, 0xefab, 0xefca, 0xefe9, 0xf008, 0xf027,
	// Entry 6EC0 - 6EFF
	0xf046, 0xf065, 0xf084, 0xf0a3, 0xf0c2, 0xf0e1, 0xf100, 0xf11f,
	0xf13e, 0xf15d, 0xf17c, 0xf19b, 0xf1ba, 0xf1d9, 0xf1f8, 0xf21e,
	0xf244, 0xf26a, 0xf290, 0xf2b6, 0xf2dc, 0xf302, 0xf328, 0xf34e,
	0xf374, 0xf39a, 0xf3c0, 0xf3e6, 0xf40c, 0xf432, 0xf458, 0xf47e,
	0xf4a4, 0xf4ca, 0xf4f0, 0xf516, 0xf53c, 0xf562, 0xf588, 0xf5ae,
	0xf5d4, 0xf5f8, 0xf61c, 0xf640, 0xf664, 0xf688, 0xf6ac, 0xf6d0,
	0xf6f4, 0xf718, 0xf73c, 0xf760, 0xf784, 0xf7a8, 0xf7cc, 0xf7f0,
	0xf814, 0xf838, 0xf85c, 0xf880, 0xf8a4, 0xf8c8, 0xf8ec, 0xf910,
	// Entry 6F00 - 6F3F
	0xf934, 0xf958, 0xf97c, 0xf9a4, 0xf9cc, 0xf9f4, 0xfa1c, 0xfa44,
	0xfa6c, 0xfa94, 0xfabc, 0xfae4, 0xfb0c, 0xfb34, 0xfb5c, 0xfb84,
	0xfbac, 0xfbd4, 0xfbfc, 0xfc24, 0xfc4c, 0xfc74, 0xfc9c, 0xfcc4,
	0xfcec, 0xfd14, 0xfd3c, 0xfd64, 0xfd8c, 0xfdb2, 0xfdd8, 0xfdfe,
	0xfe24, 0xfe4a, 0xfe70, 0xfe96, 0xfebc, 0xfee2, 0xff08, 0xff2e,
	0xff54, 0xff7a, 0xffa0, 0xffc6, 0xffec, 0x0012, 0x0038, 0x005e,
	0x0084, 0x00aa, 0x00d0, 0x00f6, 0x011c, 0x0142, 0x0168, 0x0195,
	0x01c2, 0x01ef, 0x021c, 0x0249, 0x0276, 0x02a3, 0x02d0, 0x02fd,
	// Entry 6F40 - 6F7F
	0x032a, 0x0357, 0x0384, 0x03b1, 0x03de, 0x040b, 0x0438, 0x0465,
	0x0492, 0x04bf, 0x04ec, 0x0519, 0x0546, 0x0573, 0x05a0, 0x05cd,
	0x05fa, 0x0625, 0x0650, 0x067b, 0x06a6, 0x06d1, 0x06fc, 0x0727,
	0x0752, 0x077d, 0x07a8, 0x07d3, 0x07fe, 0x0829, 0x0854, 0x087f,
	0x08aa, 0x08d5, 0x0900, 0x092b, 0x0956, 0x0981, 0x09ac, 0x09d7,
	0x0a02, 0x0a2d, 0x0a58, 0x0a78, 0x0a98, 0x0ab8, 0x0ad8, 0x0af8,
	0x0b18, 0x0b38, 0x0b58, 0x0b78, 0x0b98, 0x0bb8, 0x0bd8, 0x0bf8,
	0x0c18, 0x0c38, 0x0c58, 0x0c78, 0x0c98, 0x0cb8, 0x0cd8, 0x0cf8,
	// Entry 6F80 - 6FBF
	0x0d18, 0x0d38, 0x0d58, 0x0d78, 0x0d98, 0x0db6, 0x0dd4, 0x0df2,
	0x0e10, 0x0e2e, 0x0e4c, 0x0e6a, 0x0e88, 0x0ea6, 0x0ec4, 0x0ee2,
	0x0f00, 0x0f1e, 0x0f3c, 0x0f5a, 0x0f78, 0x0f96, 0x0fb4, 0x0fd2,
	0x0ff0, 0x100e, 0x102c, 0x104a, 0x1068, 0x1086, 0x10a4, 0x10c7,
	0x10ea, 0x1109, 0x1127, 0x1146, 0x1165, 0x1186, 0x11a4, 0x11c1,
	0x11e0, 0x11fe, 0x121d, 0x123c, 0x1258, 0x1274, 0x1290, 0x12b1,
	0x12cd, 0x12ea, 0x1310, 0x132f, 0x134c, 0x136d, 0x138a, 0x13a7,
	0x13c4, 0x13e3, 0x13fa, 0x1417, 0x1433, 0x1450, 0x146d, 0x148c,
	// Entry 6FC0 - 6FFF
	0x14a8, 0x14c3, 0x14e0, 0x14fc, 0x1519, 0x1536, 0x1550, 0x156a,
	0x1584, 0x15a3, 0x15bd, 0x15d8, 0x15fb, 0x1618, 0x1633, 0x1652,
	0x166d, 0x1688, 0x16a3, 0x16c0, 0x16e6, 0x1706, 0x1724, 0x1742,
	0x175e, 0x177a, 0x1795, 0x17b6, 0x17d6, 0x17f7, 0x1818, 0x183b,
	0x185b, 0x187a, 0x189b, 0x18bb, 0x18dc, 0x18fd, 0x191b, 0x1939,
	0x1957, 0x197a, 0x1998, 0x19b7, 0x19df, 0x1a00, 0x1a1f, 0x1a42,
	0x1a61, 0x1a80, 0x1a9f, 0x1ac0, 0x1ad9, 0x1af8, 0x1b16, 0x1b35,
	0x1b54, 0x1b75, 0x1b93, 0x1bb0, 0x1bcf, 0x1bed, 0x1c0c, 0x1c2b,
	// Entry 7000 - 703F
	0x1c47, 0x1c63, 0x1c7f, 0x1ca0, 0x1cbc, 0x1cd9, 0x1cfe, 0x1d1d,
	0x1d3a, 0x1d5b, 0x1d78, 0x1d95, 0x1db2, 0x1dd1, 0x1df9, 0x1e1b,
	0x1e3b, 0x1e5b, 0x1e79, 0x1e97, 0x1eb4, 0x1eda, 0x1eff, 0x1f25,
	0x1f4b, 0x1f73, 0x1f98, 0x1fbc, 0x1fe2, 0x2007, 0x202d, 0x2053,
	0x2076, 0x2099, 0x20bc, 0x20e4, 0x2107, 0x212b, 0x2158, 0x217e,
	0x21a2, 0x21ca, 0x21ee, 0x2212, 0x2236, 0x225c, 0x227a, 0x229e,
	0x22c1, 0x22e5, 0x2309, 0x232f, 0x2352, 0x2374, 0x2398, 0x23bb,
	0x23df, 0x2403, 0x2424, 0x2445, 0x2466, 0x248c, 0x24ad, 0x24cf,
	// Entry 7040 - 707F
	0x24f9, 0x251d, 0x253f, 0x2565, 0x2587, 0x25a9, 0x25cb, 0x25ef,
	0x261c, 0x2643, 0x2668, 0x268d, 0x26b0, 0x26d3, 0x26f5, 0x271f,
	0x2748, 0x2772, 0x279c, 0x27c8, 0x27f1, 0x2819, 0x2843, 0x286c,
	0x2896, 0x28c0, 0x28e7, 0x290e, 0x2935, 0x2961, 0x2988, 0x29b0,
	0x29e1, 0x2a0b, 0x2a33, 0x2a5f, 0x2a87, 0x2aaf, 0x2ad7, 0x2b01,
	0x2b23, 0x2b4b, 0x2b72, 0x2b9a, 0x2bc2, 0x2bec, 0x2c13, 0x2c39,
	0x2c61, 0x2c88, 0x2cb0, 0x2cd8, 0x2cfd, 0x2d22, 0x2d47, 0x2d71,
	0x2d96, 0x2dbc, 0x2dea, 0x2e12, 0x2e38, 0x2e62, 0x2e88, 0x2eae,
	// Entry 7080 - 70BF
	0x2ed4, 0x2efc, 0x2f2d, 0x2f58, 0x2f81, 0x2faa, 0x2fd1, 0x2ff8,
	0x301e, 0x304f, 0x307f, 0x30b0, 0x30e1, 0x3114, 0x3144, 0x3173,
	0x31a4, 0x31d4, 0x3205, 0x3236, 0x3264, 0x3292, 0x32c0, 0x32f3,
	0x3321, 0x3350, 0x3388, 0x33b9, 0x33e8, 0x341b, 0x344a, 0x3479,
	0x34a8, 0x34d9, 0x3502, 0x3531, 0x355f, 0x358e, 0x35bd, 0x35ee,
	0x361c, 0x3649, 0x3678, 0x36a6, 0x36d5, 0x3704, 0x3730, 0x375c,
	0x3788, 0x37b9, 0x37e5, 0x3812, 0x3847, 0x3876, 0x38a3, 0x38d4,
	0x3901, 0x392e, 0x395b, 0x398a, 0x39c2, 0x39f4, 0x3a24, 0x3a54,
	// Entry 70C0 - 70FF
	0x3a82, 0x3ab0, 0x3add, 0x3afe, 0x3b1d, 0x3b39, 0x3b54, 0x3b6f,
	0x3b8c, 0x3ba8, 0x3bc4, 0x3bdf, 0x3bfc, 0x3c19, 0x3c35, 0x3c5a,
	0x3c7e, 0x3ca2, 0x3cc8, 0x3ced, 0x3d12, 0x3d36, 0x3d5c, 0x3d82,
	0x3da7, 0x3dc9, 0x3dea, 0x3e0b, 0x3e2e, 0x3e50, 0x3e72, 0x3e93,
	0x3eb6, 0x3ed9, 0x3efb, 0x3f22, 0x3f48, 0x3f6e, 0x3f96, 0x3fbd,
	0x3fe4, 0x400a, 0x4032, 0x405a, 0x4081, 0x40a2, 0x40c2, 0x40e2,
	0x4104, 0x4125, 0x4146, 0x4166, 0x4188, 0x41aa, 0x41cb, 0x41e6,
	0x4203, 0x421d, 0x4238, 0x4254, 0x4270, 0x4290, 0x42b2, 0x42de,
	// Entry 7100 - 713F
	0x4308, 0x432a, 0x434c, 0x4372, 0x4395, 0x43b7, 0x43db, 0x4402,
	0x4434, 0x445d, 0x4489, 0x44b5, 0x44e1, 0x4518, 0x4550, 0x4583,
	0x45b6, 0x45e0, 0x460c, 0x4638, 0x4664, 0x468c, 0x46b6, 0x46ec,
	0x4722, 0x474f, 0x478a, 0x47c1, 0x47fd, 0x4834, 0x486e, 0x489d,
	0x48cd, 0x48fc, 0x492b, 0x4964, 0x499b, 0x49dc, 0x4a18, 0x4a4a,
	0x4a7c, 0x4aba, 0x4aef, 0x4b29, 0x4b6a, 0x4b9c, 0x4bce, 0x4c01,
	0x4c38, 0x4c6e, 0x4ca3, 0x4cd6, 0x4d0f, 0x4d42, 0x4d71, 0x4da7,
	0x4de2, 0x4e14, 0x4e4a, 0x4e6c, 0x4e93, 0x4ebc, 0x4ee8, 0x4f1a,
	// Entry 7140 - 717F
	0x4f46, 0x4f77, 0x4fa4, 0x4fcd, 0x4ffb, 0x502e, 0x5066, 0x5094,
	0x50c7, 0x50fe, 0x5126, 0x5153, 0x5182, 0x51ab, 0x51db, 0x5216,
	0x524f, 0x5264, 0x528e, 0x52a8, 0x52c8, 0x52ed, 0x530d, 0x5330,
	0x535c, 0x537e, 0x53ab, 0x53dd, 0x53ff, 0x5414, 0x5434, 0x5452,
	0x5475, 0x5493, 0x54a8, 0x54c1, 0x54d5, 0x54f9, 0x5518, 0x553a,
	0x5557, 0x557e, 0x55a0, 0x55be, 0x55d7, 0x55ee, 0x5603, 0x5623,
	0x5641, 0x5664, 0x567f, 0x56a8, 0x56be, 0x56da, 0x5700, 0x5721,
	0x5745, 0x5764, 0x5794, 0x57c4, 0x57da, 0x5801, 0x582a, 0x5852,
	// Entry 7180 - 71BF
	0x587a, 0x5897, 0x58c3, 0x58f4, 0x5926, 0x5947, 0x5978, 0x59a7,
	0x59d7, 0x59f6, 0x5a21, 0x5a42, 0x5a61, 0x5a81, 0x5aac, 0x5acd,
	0x5af7, 0x5b19, 0x5b3c, 0x5b64, 0x5b8d, 0x5bc6, 0x5bfb, 0x5c1d,
	0x5c41, 0x5c64, 0x5c87, 0x5cb0, 0x5cdb, 0x5d05, 0x5d20, 0x5d4a,
	0x5d79, 0x5daa, 0x5dc9, 0x5e01, 0x5e3a, 0x5e57, 0x5e80, 0x5ea1,
	0x5ec4, 0x5ee5, 0x5f07, 0x5f28, 0x5f53, 0x5f84, 0x5fa4, 0x5fc4,
	0x5fe4, 0x600b, 0x6034, 0x6062, 0x608d, 0x60b7, 0x60e4, 0x610a,
	0x6132, 0x615e, 0x6186, 0x61a7, 0x61c4, 0x61e3, 0x6204, 0x622f,
	// Entry 71C0 - 71FF
	0x6259, 0x627b, 0x62a4, 0x62c7, 0x62ef, 0x6319, 0x6348, 0x636f,
	0x6398, 0x63c5, 0x63f1, 0x641a, 0x6449, 0x647b, 0x64b2, 0x64e8,
	0x651d, 0x654f, 0x6572, 0x6598, 0x65bf, 0x65f4, 0x662a, 0x665b,
	0x668c, 0x66bc, 0x66ee, 0x6726, 0x675a, 0x6780, 0x67aa, 0x67de,
	0x6812, 0x6845, 0x686d, 0x688d, 0x68b2, 0x68d9, 0x6901, 0x6923,
	0x694b, 0x6971, 0x6996, 0x69b8, 0x69d3, 0x69f3, 0x6a1c, 0x6a46,
	0x6a6b, 0x6a8e, 0x6abe, 0x6aed, 0x6b1c, 0x6b49, 0x6b75, 0x6ba4,
	0x6bd2, 0x6c07, 0x6c1c, 0x6c36, 0x6c4e, 0x6c68, 0x6c81, 0x6c99,
	// Entry 7200 - 723F
	0x6cb3, 0x6ccc, 0x6ce5, 0x6d00, 0x6d1a, 0x6d32, 0x6d4c, 0x6d65,
	0x6d7b, 0x6d93, 0x6daa, 0x6dc5, 0x6de0, 0x6e00, 0x6e20, 0x6e42,
	0x6e64, 0x6e82, 0x6ea0, 0x6ebe, 0x6ede, 0x6efe, 0x6f1a, 0x6f3f,
	0x6f67, 0x6f8f, 0x6fb7, 0x6fe1, 0x7015, 0x7049, 0x7079, 0x70a6,
	0x70d4, 0x7108, 0x713d, 0x7171, 0x71a7, 0x71d7, 0x7205, 0x7235,
	0x7266, 0x72a2, 0x72c6, 0x72fd, 0x732d, 0x735e, 0x739a, 0x73c3,
	0x73ed, 0x7416, 0x7441, 0x746d, 0x7498, 0x74c6, 0x74f0, 0x751b,
	0x7545, 0x756d, 0x7596, 0x75be, 0x75e9, 0x7615, 0x7640, 0x766a,
	// Entry 7240 - 727F
	0x7695, 0x76bf, 0x76f5, 0x772b, 0x7766, 0x779d, 0x77d4, 0x7810,
	0x7834, 0x7862, 0x7890, 0x78be, 0x78e6, 0x790f, 0x7937, 0x7961,
	0x798c, 0x79b8, 0x79e3, 0x7a10, 0x7a40, 0x7a71, 0x7aa1, 0x7ad3,
	0x7b06, 0x7b3a, 0x7b6d, 0x7ba2, 0x7bd7, 0x7c0d, 0x7c42, 0x7c79,
	0x7caa, 0x7cd9, 0x7d0a, 0x7d3c, 0x7d79, 0x7d9e, 0x7dd6, 0x7e07,
	0x7e42, 0x7e7f, 0x7ea3, 0x7ecf, 0x7efc, 0x7f28, 0x7f4d, 0x7f76,
	0x7fa0, 0x7fc9, 0x7ff5, 0x8022, 0x804e, 0x8079, 0x80a5, 0x80d0,
	0x8108, 0x8140, 0x817d, 0x81b4, 0x81eb, 0x8227, 0x824c, 0x827e,
	// Entry 7280 - 72BF
	0x82b1, 0x82e3, 0x8317, 0x834d, 0x8384, 0x83ba, 0x83f2, 0x8431,
	0x8471, 0x849a, 0x84c4, 0x84ed, 0x8516, 0x8540, 0x8569, 0x8599,
	0x85cf, 0x8606, 0x863c, 0x8672, 0x86a9, 0x86df, 0x8711, 0x8742,
	0x8774, 0x8799, 0x87be, 0x87e6, 0x880c, 0x8843, 0x8879, 0x88af,
	0x88e5, 0x891d, 0x8955, 0x8992, 0x89c4, 0x89f5, 0x8a26, 0x8a57,
	0x8a8a, 0x8abd, 0x8af5, 0x8b2c, 0x8b64, 0x8b9b, 0x8bd6, 0x8c11,
	0x8c52, 0x8c93, 0x8cd4, 0x8d15, 0x8d56, 0x8d97, 0x8dd8, 0x8e19,
	0x8e53, 0x8e8d, 0x8ec3, 0x8ef9, 0x8f34, 0x8f6d, 0x8fa6, 0x8fe5,
	// Entry 72C0 - 72FF
	0x9024, 0x906a, 0x90b0, 0x90ef, 0x912e, 0x916d, 0x91ac, 0x91e4,
	0x921c, 0x9250, 0x9284, 0x92bd, 0x92e8, 0x9314, 0x933f, 0x936c,
	0x939a, 0x93c4, 0x93ee, 0x9418, 0x9442, 0x946c, 0x9492, 0x94b8,
	0x94e3, 0x9513, 0x9549, 0x9580, 0x95b6, 0x95ed, 0x9631, 0x9676,
	0x96ba, 0x96fe, 0x9743, 0x9787, 0x97bf, 0x97f7, 0x9837, 0x9877,
	0x98ab, 0x98df, 0x9921, 0x9963, 0x9986, 0x99a9, 0x99c1, 0x99d9,
	0x99f2, 0x9a0d, 0x9a2d, 0x9a59, 0x9a7d, 0x9a98, 0x9aa8, 0x9abc,
	0x9ae8, 0x9b10, 0x9b3d, 0x9b66, 0x9b90, 0x9bb0, 0x9be8, 0x9c1b,
	// Entry 7300 - 733F
	0x9c56, 0x9c76, 0x9c9b, 0x9cbd, 0x9ce5, 0x9d0d, 0x9d33, 0x9d59,
	0x9d75, 0x9d91, 0x9dae, 0x9dc3, 0x9ddc, 0x9df3, 0x9e0f, 0x9e2d,
	0x9e47, 0x9e61, 0x9e7d, 0x9e9f, 0x9eb3, 0x9ecb, 0x9ee5, 0x9f05,
	0x9f2b, 0x9f58, 0x9f8a, 0x9fb1, 0x9fdf, 0xa012, 0xa036, 0xa05b,
	0xa081, 0xa09a, 0xa0b4, 0xa0cd, 0xa0ea, 0xa109, 0xa125, 0xa135,
	0xa14d, 0xa165, 0xa17e, 0xa196, 0xa1b1, 0xa1cb, 0xa1ef, 0xa213,
	0xa22c, 0xa245, 0xa265, 0xa285, 0xa2a5, 0xa2bc, 0xa2dc, 0xa2f8,
	0xa30f, 0xa32f, 0xa34b, 0xa368, 0xa386, 0xa3a5, 0xa3c0, 0xa3e4,
	// Entry 7340 - 737F
	0xa404, 0xa424, 0xa44d, 0xa472, 0xa488, 0xa4a6, 0xa4c5, 0xa4dc,
	0xa4fb, 0xa519, 0xa53a, 0xa55a, 0xa57a, 0xa593, 0xa5b4, 0xa5d5,
	0xa5f8, 0xa617, 0xa63a, 0xa666, 0xa68d, 0xa6b3, 0xa6d9, 0xa6ff,
	0xa710, 0xa72a, 0xa745, 0xa769, 0xa782, 0xa7a4, 0xa7bf, 0xa7e1,
	0xa804, 0xa814, 0xa824, 0xa83a, 0xa858, 0xa87a, 0xa8a1, 0xa8c9,
	0xa8f0, 0xa91c, 0xa943, 0xa968, 0xa996, 0xa9b2, 0xa9cb, 0xa9e4,
	0xa9fd, 0xaa16, 0xaa2f, 0xaa48, 0xaa61, 0xaa73, 0xaa97, 0xaabc,
	0xaad7, 0xaaf1, 0xab0b, 0xab29, 0xab43, 0xab64, 0xab75, 0xab8a,
	// Entry 7380 - 73BF
	0xab9f, 0xabb0, 0xabc7, 0xabe2, 0xabfd, 0xac18, 0xac33, 0xac4e,
	0xac6d, 0xac8c, 0xacab, 0xacca, 0xace9, 0xad08, 0xad27, 0xad46,
	0xad66, 0xad86, 0xada6, 0xadc6, 0xade6, 0xae06, 0xae26, 0xae45,
	0xae65, 0xae85, 0xaea8, 0xaec9, 0xaeea, 0xaf0d, 0xaf2f, 0xaf4f,
	0xaf77, 0xaf94, 0xafb6, 0xafd6, 0xaff9, 0xb01c, 0xb03d, 0xb05c,
	0xb07e, 0xb09f, 0xb0c0, 0xb0e2, 0xb101, 0xb122, 0xb142, 0xb162,
	0xb181, 0xb1a3, 0xb1c2, 0xb1e2, 0xb202, 0xb222, 0xb240, 0xb265,
	0xb283, 0xb2b0, 0xb2d3, 0xb2fe, 0xb31e, 0xb33e, 0xb35f, 0xb380,
	// Entry 73C0 - 73FF
	0xb3a0, 0xb3c0, 0xb3e0, 0xb400, 0xb421, 0xb441, 0xb461, 0xb481,
	0xb4a1, 0xb4c2, 0xb4e4, 0xb504, 0xb524, 0xb545, 0xb566, 0xb586,
	0xb5a8, 0xb5c9, 0xb5e9, 0xb609, 0xb629, 0xb649, 0xb66a, 0xb68a,
	0xb6ab, 0xb6cc, 0xb6ed, 0xb70f, 0xb730, 0xb751, 0xb772, 0xb792,
	0xb7b3, 0xb7d2, 0xb7f2, 0xb811, 0xb830, 0xb84f, 0xb86f, 0xb88e,
	0xb8ae, 0xb8cd, 0xb8ea, 0xb907, 0xb924, 0xb941, 0xb95e, 0xb97b,
	0xb998, 0xb9be, 0xb9e3, 0xba0b, 0xba31, 0xba5d, 0xba7e, 0xbaa8,
	0xbac9, 0xbae9, 0xbb09, 0xbb2b, 0xbb4c, 0xbb6d, 0xbb8d, 0xbbaf,
	// Entry 7400 - 743F
	0xbbd1, 0xbbf2, 0xbc16, 0xbc37, 0xbc47, 0xbc56, 0xbc66, 0xbc76,
	0xbc86, 0xbc96, 0xbca6, 0xbcb7, 0xbcc7, 0xbcd7, 0xbce7, 0xbcf7,
	0xbd08, 0xbd18, 0xbd28, 0xbd39, 0xbd49, 0xbd59, 0xbd69, 0xbd79,
	0xbd89, 0xbd98, 0xbda8, 0xbdb8, 0xbdc8, 0xbdd9, 0xbde9, 0xbdf8,
	0xbe07, 0xbe18, 0xbe27, 0xbe39, 0xbe4a, 0xbe5b, 0xbe6c, 0xbe7e,
	0xbe8f, 0xbea0, 0xbeb0, 0xbec0, 0xbed1, 0xbee2, 0xbef3, 0xbf04,
	0xbf13, 0xbf24, 0xbf33, 0xbf44, 0xbf55, 0xbf65, 0xbf75, 0xbf87,
	0xbf98, 0xbfa9, 0xbfb9, 0xbfcb, 0xbfdd, 0xbfee, 0xbffe, 0xc01c,
	// Entry 7440 - 747F
	0xc03a, 0xc058, 0xc077, 0xc095, 0xc0b4, 0xc0d2, 0xc0f1, 0xc10f,
	0xc12d, 0xc14b, 0xc16a, 0xc188, 0xc1a7, 0xc1c5, 0xc1e4, 0xc203,
	0xc222, 0xc241, 0xc260, 0xc27f, 0xc29e, 0xc2bd, 0xc2dc, 0xc2fb,
	0xc31b, 0xc33b, 0xc359, 0xc377, 0xc395, 0xc3b4, 0xc3d2, 0xc3f1,
	0xc40f, 0xc42c, 0xc449, 0xc466, 0xc484, 0xc4a1, 0xc4bf, 0xc4dc,
	0xc4fa, 0xc518, 0xc536, 0xc554, 0xc572, 0xc590, 0xc5ae, 0xc5cc,
	0xc5eb, 0xc609, 0xc628, 0xc646, 0xc665, 0xc683, 0xc6a1, 0xc6bf,
	0xc6de, 0xc6fc, 0xc71b, 0xc739, 0xc75c, 0xc77a, 0xc798, 0xc7b6,
	// Entry 7480 - 74BF
	0xc7d5, 0xc7f4, 0xc812, 0xc830, 0xc84e, 0xc86c, 0xc88b, 0xc8a9,
	0xc8c8, 0xc8e6, 0xc904, 0xc922, 0xc940, 0xc95f, 0xc97d, 0xc99c,
	0xc9ba, 0xc9dd, 0xc9fb, 0xca19, 0xca37, 0xca56, 0xca74, 0xca93,
	0xcab1, 0xcacf, 0xcaed, 0xcb0b, 0xcb2a, 0xcb48, 0xcb67, 0xcb85,
	0xcba4, 0xcbc3, 0xcbe2, 0xcc01, 0xcc20, 0xcc3f, 0xcc5e, 0xcc7c,
	0xcc9a, 0xccb8, 0xccd7, 0xccf5, 0xcd14, 0xcd32, 0xcd52, 0xcd72,
	0xcd91, 0xcdb0, 0xcdcf, 0xcdee, 0xce0d, 0xce2d, 0xce4d, 0xce6d,
	0xce8d, 0xceae, 0xcece, 0xceef, 0xcf0f, 0xcf30, 0xcf51, 0xcf76,
	// Entry 74C0 - 74FF
	0xcf9c, 0xcfc1, 0xcfdf, 0xcffd, 0xd01b, 0xd03a, 0xd05a, 0xd07a,
	0xd09a, 0xd0ba, 0xd0db, 0xd0f9, 0xd117, 0xd135, 0xd154, 0xd172,
	0xd191, 0xd1af, 0xd1ce, 0xd1ed, 0xd20c, 0xd22c, 0xd24c, 0xd26b,
	0xd28b, 0xd2aa, 0xd2ca, 0xd2ee, 0xd313, 0xd337, 0xd356, 0xd375,
	0xd394, 0xd3b4, 0xd3d3, 0xd3f3, 0xd412, 0xd431, 0xd450, 0xd46f,
	0xd48f, 0xd4ae, 0xd4ce, 0xd4ed, 0xd50b, 0xd52a, 0xd549, 0xd568,
	0xd588, 0xd5a7, 0xd5c7, 0xd5e6, 0xd605, 0xd624, 0xd644, 0xd664,
	0xd682, 0xd6a0, 0xd6be, 0xd6dd, 0xd6fb, 0xd71a, 0xd738, 0xd758,
	// Entry 7500 - 753F
	0xd778, 0xd798, 0xd7b8, 0xd7d8, 0xd7ef, 0xd806, 0xd81f, 0xd837,
	0xd84f, 0xd866, 0xd87f, 0xd898, 0xd8b0, 0xd8d4, 0xd8f7, 0xd91e,
	0xd946, 0xd972, 0xd9a2, 0xd9c9, 0xd9e2, 0xd9fc, 0xda15, 0xda2e,
	0xda45, 0xda64, 0xda7b, 0xda93, 0xdaaa, 0xdac0, 0xdad7, 0xdaed,
	0xdb03, 0xdb1b, 0xdb33, 0xdb4b, 0xdb63, 0xdb7b, 0xdb92, 0xdba8,
	0xdbc1, 0xdbd9, 0xdbf0, 0xdc09, 0xdc20, 0xdc38, 0xdc4f, 0xdc67,
	0xdc7e, 0xdc96, 0xdcae, 0xdcc6, 0xdcde, 0xdcf6, 0xdd0d, 0xdd25,
	0xdd3c, 0xdd53, 0xdd68, 0xdd85, 0xdd9a, 0xddb0, 0xddc5, 0xddd9,
	// Entry 7540 - 757F
	0xddee, 0xde02, 0xde16, 0xde2c, 0xde42, 0xde58, 0xde6e, 0xde84,
	0xde99, 0xdead, 0xdec4, 0xdeda, 0xdeef, 0xdf06, 0xdf1b, 0xdf31,
	0xdf46, 0xdf5c, 0xdf71, 0xdf87, 0xdf9d, 0xdfb3, 0xdfc9, 0xdfdf,
	0xdff4, 0xe00a, 0xe01f, 0xe02a, 0xe042, 0xe063, 0xe06e, 0xe085,
	0xe095, 0xe0a4, 0xe0b3, 0xe0c4, 0xe0d4, 0xe0e4, 0xe0f3, 0xe104,
	0xe115, 0xe125, 0xe143, 0xe15e, 0xe174, 0xe18a, 0xe1a2, 0xe1b9,
	0xe1d0, 0xe1e6, 0xe1fe, 0xe216, 0xe22d, 0xe243, 0xe25c, 0xe275,
	0xe28d, 0xe2a5, 0xe2bd, 0xe2d7, 0xe2f0, 0xe309, 0xe327, 0xe345,
	// Entry 7580 - 75BF
	0xe365, 0xe384, 0xe3a3, 0xe3c1, 0xe3e1, 0xe401, 0xe420, 0xe43f,
	0xe45e, 0xe47f, 0xe49f, 0xe4bf, 0xe4de, 0xe4ff, 0xe520, 0xe540,
	0xe55f, 0xe581, 0xe5a3, 0xe5c4, 0xe5e5, 0xe606, 0xe629, 0xe64b,
	0xe66d, 0xe684, 0xe69d, 0xe6b2, 0xe6ca, 0xe6e4, 0xe703, 0xe722,
	0xe743, 0xe763, 0xe783, 0xe7a2, 0xe7c3, 0xe7e4, 0xe804, 0xe81b,
	0xe83b, 0xe858, 0xe87b, 0xe891, 0xe8b1, 0xe8d1, 0xe8fa, 0xe919,
	0xe931, 0xe949, 0xe963, 0xe97c, 0xe995, 0xe9ad, 0xe9c7, 0xe9e1,
	0xe9fa, 0xea12, 0xea2d, 0xea48, 0xea62, 0xea7c, 0xea96, 0xeab2,
	// Entry 75C0 - 75FF
	0xeacd, 0xeae8, 0xeb08, 0xeb28, 0xeb4a, 0xeb6b, 0xeb8c, 0xebac,
	0xebce, 0xebf0, 0xec11, 0xec32, 0xec53, 0xec76, 0xec98, 0xecba,
	0xecdb, 0xecfe, 0xed21, 0xed43, 0xed64, 0xed88, 0xedac, 0xedcf,
	0xedf2, 0xee15, 0xee3a, 0xee5e, 0xee82, 0xee98, 0xeeba, 0xeede,
	0xef01, 0xef24, 0xef46, 0xef6a, 0xef8e, 0xefb1, 0xefd3, 0xeffe,
	0xf028, 0xf053, 0xf07e, 0xf09d, 0xf0bd, 0xf0d5, 0xf0ec, 0xf104,
	0xf11b, 0xf132, 0xf14a, 0xf161, 0xf178, 0xf18f, 0xf1a6, 0xf1bd,
	0xf1d5, 0xf1ed, 0xf205, 0xf21c, 0xf233, 0xf24a, 0xf261, 0xf278,
	// Entry 7600 - 763F
	0xf291, 0xf2a8, 0xf2c0, 0xf2d8, 0xf2f0, 0xf307, 0xf31e, 0xf337,
	0xf356, 0xf376, 0xf395, 0xf3b4, 0xf3d3, 0xf3f3, 0xf412, 0xf431,
	0xf450, 0xf46f, 0xf48e, 0xf4ae, 0xf4ce, 0xf4ee, 0xf50d, 0xf52c,
	0xf54b, 0xf56a, 0xf58b, 0xf5aa, 0xf5ca, 0xf5ea, 0xf609, 0xf62a,
	0xf649, 0xf667, 0xf685, 0xf6a3, 0xf6c2, 0xf6e1, 0xf6ff, 0xf71d,
	0xf73b, 0xf75b, 0xf77a, 0xf798, 0xf7b8, 0xf7df, 0xf805, 0xf826,
	0xf848, 0xf869, 0xf88a, 0xf8ab, 0xf8cc, 0xf8ed, 0xf90f, 0xf931,
	0xf953, 0xf974, 0xf995, 0xf9b6, 0xf9d7, 0xf9fa, 0xfa1b, 0xfa3d,
	// Entry 7640 - 767F
	0xfa5f, 0xfa80, 0xfaa1, 0xfac4, 0xfaed, 0xfb16, 0xfb35, 0xfb53,
	0xfb72, 0xfb90, 0xfbae, 0xfbcc, 0xfbeb, 0xfc09, 0xfc27, 0xfc45,
	0xfc63, 0xfc82, 0xfca1, 0xfcc0, 0xfcde, 0xfcfc, 0xfd1a, 0xfd38,
	0xfd56, 0xfd76, 0xfd94, 0xfdb3, 0xfdd2, 0xfdf1, 0xfe0f, 0xfe2d,
	0xfe4d, 0xfe72, 0xfe98, 0xfebd, 0xfee2, 0xff08, 0xff2d, 0xff52,
	0xff77, 0xff9c, 0xffc2, 0xffe8, 0x000e, 0x0033, 0x0058, 0x007d,
	0x00a2, 0x00c7, 0x00ee, 0x0113, 0x0139, 0x015f, 0x0185, 0x01aa,
	0x01cf, 0x01f6, 0x022d, 0x0256, 0x026c, 0x0283, 0x0299, 0x02b0,
	// Entry 7680 - 76BF
	0x02c7, 0x02e0, 0x02f9, 0x0317, 0x0335, 0x0355, 0x0374, 0x0393,
	0x03b1, 0x03d1, 0x03f1, 0x0410, 0x042b, 0x0446, 0x0463, 0x047f,
	0x049b, 0x04b6, 0x04d3, 0x04f0, 0x050c, 0x0527, 0x0542, 0x055f,
	0x057b, 0x0597, 0x05b2, 0x05cf, 0x05ec, 0x0608, 0x0619, 0x062c,
	0x063f, 0x0659, 0x066c, 0x067f, 0x0692, 0x06a5, 0x06b7, 0x06c8,
	0x06e3, 0x06ff, 0x071b, 0x0737, 0x0753, 0x076f, 0x078b, 0x07a7,
	0x07c3, 0x07df, 0x07fb, 0x0817, 0x0833, 0x084f, 0x086b, 0x0887,
	0x08a3, 0x08bf, 0x08db, 0x08f7, 0x0913, 0x092f, 0x094b, 0x0967,
	// Entry 76C0 - 76FF
	0x0983, 0x099f, 0x09bb, 0x09d7, 0x09f3, 0x0a0f, 0x0a2b, 0x0a47,
	0x0a63, 0x0a7f, 0x0a9b, 0x0ab7, 0x0ad3, 0x0aef, 0x0b0b, 0x0b27,
	0x0b43, 0x0b5f, 0x0b7b, 0x0b97, 0x0bb3, 0x0bcf, 0x0beb, 0x0c07,
	0x0c23, 0x0c3f, 0x0c58, 0x0c72, 0x0c8c, 0x0ca6, 0x0cc0, 0x0cda,
	0x0cf4, 0x0d0e, 0x0d28, 0x0d42, 0x0d5c, 0x0d76, 0x0d90, 0x0daa,
	0x0dc4, 0x0dde, 0x0df8, 0x0e12, 0x0e2c, 0x0e46, 0x0e60, 0x0e7a,
	0x0e94, 0x0eae, 0x0ec8, 0x0ee2, 0x0efc, 0x0f16, 0x0f30, 0x0f4a,
	0x0f64, 0x0f7e, 0x0f98, 0x0fb2, 0x0fcc, 0x0fe6, 0x1000, 0x101a,
	// Entry 7700 - 773F
	0x1034, 0x104e, 0x1068, 0x1082, 0x109c, 0x10b6, 0x10d0, 0x10ea,
	0x1104, 0x111e, 0x1138, 0x1152, 0x1163, 0x117d, 0x1197, 0x11b3,
	0x11ce, 0x11e9, 0x1203, 0x121f, 0x123b, 0x1256, 0x1270, 0x128b,
	0x12a8, 0x12c4, 0x12df, 0x12f9, 0x1313, 0x132f, 0x134a, 0x1365,
	0x137f, 0x139b, 0x13b7, 0x13d2, 0x13ec, 0x1407, 0x1424, 0x1440,
	0x145b, 0x1471, 0x148d, 0x14a9, 0x14c7, 0x14e4, 0x1501, 0x151d,
	0x153b, 0x1559, 0x1576, 0x1592, 0x15af, 0x15ce, 0x15ec, 0x1609,
	0x1621, 0x163a, 0x1653, 0x166e, 0x1688, 0x16a2, 0x16bb, 0x16d6,
	// Entry 7740 - 777F
	0x16f1, 0x170b, 0x1724, 0x173e, 0x175a, 0x1775, 0x178f, 0x17a7,
	0x17b8, 0x17cc, 0x17e0, 0x17f4, 0x1808, 0x181c, 0x1830, 0x1844,
	0x1858, 0x186c, 0x1881, 0x1896, 0x18ab, 0x18c0, 0x18d5, 0x18ea,
	0x18ff, 0x1914, 0x1929, 0x193e, 0x1953, 0x1968, 0x197c, 0x198c,
	0x199b, 0x19aa, 0x19bb, 0x19cb, 0x19db, 0x19ea, 0x19fb, 0x1a0c,
	0x1a1c, 0x1a41, 0x1a6f, 0x1a86, 0x1aa1, 0x1acc, 0x1af0, 0x1b14,
	0x1b38, 0x1b5c, 0x1b80, 0x1ba4, 0x1bc8, 0x1bec, 0x1c10, 0x1c34,
	0x1c58, 0x1c7c, 0x1ca0, 0x1cc4, 0x1ce8, 0x1d0c, 0x1d30, 0x1d54,
	// Entry 7780 - 77BF
	0x1d78, 0x1d9c, 0x1dc0, 0x1de4, 0x1e08, 0x1e2c, 0x1e50, 0x1e74,
	0x1ea3, 0x1ec8, 0x1eed, 0x1ef7, 0x1f01, 0x1f10, 0x1f2e, 0x1f4c,
	0x1f6a, 0x1f88, 0x1fa6, 0x1fc4, 0x1fe2, 0x2000, 0x201e, 0x203c,
	0x205a, 0x2078, 0x2096, 0x20b4, 0x20d2, 0x20f0, 0x210e, 0x212c,
	0x214a, 0x2168, 0x2186, 0x21a4, 0x21c2, 0x21e0, 0x21fe, 0x221c,
	0x2226, 0x2230, 0x223a, 0x2244, 0x224f, 0x2259, 0x2280, 0x22a7,
	0x22ce, 0x22f5, 0x231c, 0x2343, 0x236a, 0x2391, 0x23b8, 0x23df,
	0x2406, 0x242d, 0x2454, 0x247b, 0x24a2, 0x24c9, 0x24f0, 0x2517,
	// Entry 77C0 - 77FF
	0x253e, 0x2565, 0x258c, 0x25b3, 0x25da, 0x2601, 0x2628, 0x264f,
	0x265d, 0x266b, 0x2679, 0x2683, 0x26a4, 0x26b8, 0x26df, 0x2706,
	0x272d, 0x2754, 0x277b, 0x27a2, 0x27c9, 0x27f0, 0x2817, 0x283e,
	0x2865, 0x288c, 0x28b3, 0x28da, 0x2901, 0x2928, 0x294f, 0x2976,
	0x299d, 0x29c4, 0x29eb, 0x2a12, 0x2a39, 0x2a60, 0x2a87, 0x2aae,
	0x2add, 0x2af0, 0x2b03, 0x2b16, 0x2b29, 0x2b3c, 0x2b45, 0x2b4f,
	0x2b5b, 0x2b67, 0x2b71, 0x2b7c, 0x2b86, 0x2b90, 0x2b9b, 0x2bbb,
	0x2bc5, 0x2bd4, 0x2be9, 0x2bf6, 0x2c04, 0x2c13, 0x2c29, 0x2c40,
	// Entry 7800 - 783F
	0x2c5c, 0x2c6b, 0x2c87, 0x2ca3, 0x2cad, 0x2cb8, 0x2cc6, 0x2cd6,
	0x2ce1, 0x2cec, 0x2cf7, 0x2d07, 0x2d29, 0x2d4b, 0x2d6d, 0x2d8f,
	0x2db1, 0x2dd3, 0x2df5, 0x2e17, 0x2e39, 0x2e5b, 0x2e7d, 0x2e9f,
	0x2ec1, 0x2ee3, 0x2f05, 0x2f27, 0x2f49, 0x2f6b, 0x2f8d, 0x2faf,
	0x2fd1, 0x2ff3, 0x3015, 0x3037, 0x3059, 0x307b, 0x308f, 0x30a4,
	0x30b7, 0x30d9, 0x30fb, 0x311d, 0x3130, 0x3152, 0x3174, 0x3196,
	0x31b8, 0x31da, 0x31fc, 0x321e, 0x3240, 0x3262, 0x3284, 0x32a6,
	0x32c8, 0x32ea, 0x330c, 0x332e, 0x3350, 0x3372, 0x3394, 0x33b6,
	// Entry 7840 - 787F
	0x33d8, 0x33fa, 0x341c, 0x343e, 0x3460, 0x3482, 0x34a4, 0x34c6,
	0x34e8, 0x350a, 0x352c, 0x354e, 0x3570, 0x3592, 0x35b4, 0x35d6,
	0x35f8, 0x361a, 0x363c, 0x365e, 0x3680, 0x36b3, 0x36e6, 0x3719,
	0x374c, 0x377f, 0x37b2, 0x37e5, 0x3818, 0x384b, 0x3866, 0x387e,
	0x3893, 0x38a8, 0x38bf, 0x38d4, 0x38ef, 0x3905, 0x390c, 0x3911,
	0x3920, 0x3930, 0x3946, 0x394d, 0x395e, 0x3973, 0x397a, 0x3989,
	0x3993, 0x399a, 0x39a3, 0x39bc, 0x39d0, 0x39ea, 0x39fe, 0x3a0d,
	0x3a28, 0x3a41, 0x3a5b, 0x3a6b, 0x3a85, 0x3a9d, 0x3ab8, 0x3ac5,
	// Entry 7880 - 78BF
	0x3ad7, 0x3af3, 0x3b0e, 0x3b21, 0x3b2e, 0x3b3a, 0x3b47, 0x3b52,
	0x3b5f, 0x3b68, 0x3b82, 0x3b98, 0x3bb8, 0x3bc7, 0x3bd6, 0x3bea,
	0x3bfc, 0x3bff, 0x3c10, 0x3c17, 0x3c1b, 0x3c22, 0x3c2a, 0x3c32,
	0x3c40, 0x3c4e, 0x3c57, 0x3c5d, 0x3c67, 0x3c6c, 0x3c7a, 0x3c7e,
	0x3c86, 0x3c8f, 0x3c96, 0x3ca2, 0x3cad, 0x3cb1, 0x3cc1, 0x3ccb,
	0x3cd6, 0x3ced, 0x3cf5, 0x3cfb, 0x3d04, 0x3d0a, 0x3d0f, 0x3d19,
	0x3d22, 0x3d27, 0x3d2d, 0x3d36, 0x3d3f, 0x3d4a, 0x3d4e, 0x3d53,
	0x3d5b, 0x3d65, 0x3d6e, 0x3d7c, 0x3d88, 0x3d93, 0x3d9f, 0x3da8,
	// Entry 78C0 - 78FF
	0x3db3, 0x3dc1, 0x3dce, 0x3dd7, 0x3ddc, 0x3de8, 0x3dfc, 0x3e01,
	0x3e05, 0x3e0a, 0x3e16, 0x3e31, 0x3e3f, 0x3e49, 0x3e52, 0x3e5a,
	0x3e60, 0x3e6d, 0x3e72, 0x3e7a, 0x3e81, 0x3e8a, 0x3e93, 0x3e9c,
	0x3ea7, 0x3eae, 0x3ebc, 0x3ed1, 0x3ee4, 0x3eee, 0x3efc, 0x3f0a,
	0x3f12, 0x3f24, 0x3f2f, 0x3f48, 0x3f60, 0x3f67, 0x3f6d, 0x3f7c,
	0x3f89, 0x3f97, 0x3fa5, 0x3fb5, 0x3fbe, 0x3fcf, 0x3fd6, 0x3fe2,
	0x3fef, 0x3ffc, 0x4009, 0x4018, 0x4026, 0x4033, 0x403d, 0x4052,
	0x4060, 0x406e, 0x4088, 0x409a, 0x40a8, 0x40b7, 0x40d2, 0x40e3,
	// Entry 7900 - 793F
	0x40ef, 0x40fc, 0x411a, 0x4139, 0x4144, 0x4155, 0x4163, 0x416f,
	0x417d, 0x4192, 0x419c, 0x41a8, 0x41ae, 0x41b7, 0x41c5, 0x41cc,
	0x41d7, 0x41dd, 0x41ea, 0x41f9, 0x4203, 0x420d, 0x4219, 0x4222,
	0x422a, 0x4231, 0x4245, 0x4251, 0x4267, 0x4270, 0x4276, 0x4286,
	0x428d, 0x4293, 0x42a0, 0x42b7, 0x42ce, 0x42de, 0x42f1, 0x42ff,
	0x430a, 0x4310, 0x4316, 0x4322, 0x4328, 0x4334, 0x4345, 0x4353,
	0x435a, 0x4367, 0x436d, 0x437e, 0x4388, 0x439c, 0x43a6, 0x43c1,
	0x43da, 0x43f6, 0x440a, 0x4411, 0x4424, 0x4439, 0x4448, 0x4451,
	// Entry 7940 - 797F
	0x4468, 0x447a, 0x4480, 0x448d, 0x449a, 0x44a1, 0x44af, 0x44c0,
	0x44cf, 0x44e3, 0x44f7, 0x44ff, 0x4503, 0x451b, 0x4520, 0x452a,
	0x453b, 0x4541, 0x4551, 0x4558, 0x4567, 0x4576, 0x4585, 0x4592,
	0x459f, 0x45b0, 0x45c1, 0x45c8, 0x45d5, 0x45da, 0x45fb, 0x4608,
	0x460f, 0x4632, 0x4653, 0x4674, 0x4695, 0x46b6, 0x46b9, 0x46be,
	0x46c0, 0x46cd, 0x46d0, 0x46d5, 0x46dc, 0x46e2, 0x46e5, 0x46eb,
	0x46f4, 0x46f9, 0x46fe, 0x4703, 0x4708, 0x470b, 0x470f, 0x4714,
	0x471a, 0x4721, 0x4728, 0x472b, 0x472e, 0x4732, 0x473a, 0x4741,
	// Entry 7980 - 79BF
	0x474d, 0x4750, 0x4753, 0x475b, 0x4766, 0x476a, 0x4777, 0x477f,
	0x4785, 0x4793, 0x479d, 0x47b4, 0x47b8, 0x47bf, 0x47c4, 0x47ca,
	0x47d9, 0x47e7, 0x47ee, 0x47f8, 0x4800, 0x480a, 0x4815, 0x481d,
	0x4828, 0x4836, 0x4840, 0x484b, 0x4853, 0x485b, 0x4864, 0x4870,
	0x4879, 0x4882, 0x488c, 0x4894, 0x489e, 0x48a6, 0x48aa, 0x48ad,
	0x48b0, 0x48b4, 0x48b9, 0x48bf, 0x48df, 0x4901, 0x4923, 0x4946,
	0x4956, 0x4966, 0x4972, 0x4980, 0x4990, 0x49a3, 0x49b2, 0x49b7,
	0x49c1, 0x49cb, 0x49d2, 0x49d9, 0x49de, 0x49e3, 0x49e9, 0x49ef,
	// Entry 79C0 - 79FF
	0x49fd, 0x4a02, 0x4a09, 0x4a0e, 0x4a17, 0x4a24, 0x4a34, 0x4a41,
	0x4a4d, 0x4a57, 0x4a69, 0x4a7c, 0x4a7f, 0x4a83, 0x4a86, 0x4a8b,
	0x4a91, 0x4aac, 0x4ac1, 0x4ad8, 0x4ae6, 0x4afb, 0x4b0a, 0x4b20,
	0x4b33, 0x4b42, 0x4b4b, 0x4b56, 0x4b5a, 0x4b6d, 0x4b75, 0x4b82,
	0x4b91, 0x4b96, 0x4ba0, 0x4bb6, 0x4bc3, 0x4bc6, 0x4bcb, 0x4be2,
	0x4beb, 0x4bf1, 0x4bf9, 0x4c04, 0x4c10, 0x4c17, 0x4c22, 0x4c29,
	0x4c2d, 0x4c36, 0x4c41, 0x4c45, 0x4c4e, 0x4c52, 0x4c59, 0x4c6a,
	0x4c71, 0x4c7e, 0x4c8a, 0x4c94, 0x4ca3, 0x4cb0, 0x4cc0, 0x4cca,
	// Entry 7A00 - 7A3F
	0x4cd5, 0x4ce1, 0x4ced, 0x4cfe, 0x4d0e, 0x4d1e, 0x4d3d, 0x4d50,
	0x4d5c, 0x4d60, 0x4d6f, 0x4d7f, 0x4d95, 0x4d9c, 0x4da7, 0x4db2,
	0x4dbf, 0x4dcb, 0x4dd9, 0x4de8, 0x4df4, 0x4e09, 0x4e12, 0x4e23,
	0x4e34, 0x4e3f, 0x4e55, 0x4e6e, 0x4e85, 0x4e9d, 0x4ead, 0x4ed2,
	0x4ed6, 0x4ee7, 0x4ef0, 0x4ef8, 0x4f03, 0x4f0f, 0x4f12, 0x4f1d,
	0x4f2d, 0x4f3b, 0x4f49, 0x4f51, 0x4f62, 0x4f6c, 0x4f84, 0x4f9e,
	0x4fa7, 0x4fb0, 0x4fb7, 0x4fc4, 0x4fcd, 0x4fdb, 0x4feb, 0x4ff8,
	0x4ffe, 0x5006, 0x5024, 0x502f, 0x5038, 0x5042, 0x504b, 0x5056,
	// Entry 7A40 - 7A7F
	0x505b, 0x5065, 0x506b, 0x506f, 0x5081, 0x5086, 0x5091, 0x50a2,
	0x50bc, 0x50ce, 0x50d9, 0x50e3, 0x50ea, 0x50f7, 0x5108, 0x512b,
	0x514b, 0x516a, 0x5187, 0x51a5, 0x51ac, 0x51b7, 0x51c0, 0x51cc,
	0x51f6, 0x5204, 0x5214, 0x5224, 0x5235, 0x523b, 0x524c, 0x5258,
	0x5262, 0x5267, 0x5274, 0x5282, 0x5291, 0x529d, 0x52b6, 0x52eb,
	0x5339, 0x536b, 0x53a1, 0x53b6, 0x53cc, 0x53ec, 0x53f3, 0x540e,
	0x542c, 0x5433, 0x5440, 0x545e, 0x547d, 0x548e, 0x54a2, 0x54a5,
	0x54a9, 0x54b2, 0x54b6, 0x54d3, 0x54db, 0x54e6, 0x54f2, 0x5511,
	// Entry 7A80 - 7ABF
	0x552f, 0x5563, 0x5583, 0x559f, 0x55bb, 0x55c5, 0x55eb, 0x560f,
	0x5627, 0x563f, 0x565d, 0x5661, 0x566f, 0x5675, 0x567b, 0x5687,
	0x568c, 0x5692, 0x569c, 0x56a5, 0x56b1, 0x56d1, 0x56ed, 0x56fb,
	0x570e, 0x5721, 0x5731, 0x5742, 0x5756, 0x5768, 0x577c, 0x578e,
	0x57a6, 0x57c0, 0x57de, 0x57fe, 0x581f, 0x5840, 0x5854, 0x5877,
	0x5883, 0x58aa, 0x58d2, 0x58ea, 0x58fb, 0x590c, 0x5918, 0x5921,
	0x592e, 0x5933, 0x5939, 0x5942, 0x595c, 0x596b, 0x5980, 0x5995,
	0x59ac, 0x59c2, 0x59d8, 0x59ed, 0x5a04, 0x5a1b, 0x5a31, 0x5a46,
	// Entry 7AC0 - 7AFF
	0x5a5e, 0x5a76, 0x5a8b, 0x5aa0, 0x5ab7, 0x5acd, 0x5ae3, 0x5af8,
	0x5b0f, 0x5b26, 0x5b3c, 0x5b51, 0x5b69, 0x5b81, 0x5b8e, 0x5baf,
	0x5bd3, 0x5bdb, 0x5bf4, 0x5c00, 0x5c04, 0x5c0a, 0x5c1b, 0x5c35,
	0x5c3e, 0x5c42, 0x5c61, 0x5c6e, 0x5c7d, 0x5c83, 0x5c8d, 0x5c95,
	0x5ca0, 0x5cbc, 0x5cd8, 0x5cf5, 0x5d0e, 0x5d27, 0x5d40, 0x5d56,
	0x5d66, 0x5d76, 0x5d8d, 0x5d9c, 0x5db5, 0x5dc6, 0x5dd3, 0x5de4,
	0x5dfc, 0x5e13, 0x5e28, 0x5e39, 0x5e4a, 0x5e5d, 0x5e7d, 0x5ea6,
	0x5ebd, 0x5ed6, 0x5eeb, 0x5f14, 0x5f49, 0x5f6c, 0x5f8e, 0x5fb1,
	// Entry 7B00 - 7B3F
	0x5fd3, 0x5ff6, 0x6018, 0x603b, 0x605b, 0x607d, 0x609d, 0x60bf,
	0x60df, 0x6101, 0x610c, 0x611c, 0x612e, 0x6147, 0x614e, 0x615f,
	0x617b, 0x6197, 0x61ad, 0x61bb, 0x61c9, 0x61d9, 0x61e9, 0x61fb,
	0x6204, 0x6219, 0x6222, 0x6228, 0x6234, 0x623c, 0x624d, 0x625f,
	0x627d, 0x6292, 0x62a4, 0x62b4, 0x62c3, 0x62cf, 0x62d5, 0x62e0,
	0x62f3, 0x6300, 0x630c, 0x6316, 0x6325, 0x6333, 0x6337, 0x6340,
	0x6348, 0x6356, 0x6360, 0x636b, 0x6373, 0x6377, 0x637c, 0x6387,
	0x6396, 0x63a9, 0x63b7, 0x63bf, 0x63c7, 0x63ce, 0x63f8, 0x6406,
	// Entry 7B40 - 7B7F
	0x641f, 0x6438, 0x6443, 0x644a, 0x645d, 0x6473, 0x647e, 0x648a,
	0x648e, 0x64a9, 0x64b9, 0x64c9, 0x64d8, 0x64e8, 0x64fa, 0x650d,
	0x651f, 0x6533, 0x6546, 0x655a, 0x656b, 0x657d, 0x6588, 0x659d,
	0x65ab, 0x65c1, 0x65d0, 0x65e8, 0x65fc, 0x6619, 0x6629, 0x6643,
	0x664c, 0x6656, 0x6661, 0x6672, 0x6685, 0x668a, 0x6697, 0x66b6,
	0x66cc, 0x66e8, 0x6715, 0x6740, 0x6774, 0x678a, 0x67a1, 0x67ad,
	0x67cb, 0x67e8, 0x67f5, 0x6818, 0x6834, 0x6841, 0x684d, 0x6860,
	0x686d, 0x6881, 0x688d, 0x689a, 0x68a9, 0x68b5, 0x68c9, 0x68e7,
	// Entry 7B80 - 7BBF
	0x6904, 0x691e, 0x6948, 0x697a, 0x698b, 0x6997, 0x69a1, 0x69ad,
	0x69b8, 0x69c8, 0x69e1, 0x69ff, 0x6a1c, 0x6a2a, 0x6a36, 0x6a40,
	0x6a4b, 0x6a55, 0x6a63, 0x6a75, 0x6a89, 0x6a94, 0x6ab7, 0x6acd,
	0x6adc, 0x6ae8, 0x6af5, 0x6aff, 0x6b11, 0x6b27, 0x6b4a, 0x6b64,
	0x6b84, 0x6bab, 0x6bc2, 0x6be3, 0x6bf3, 0x6c02, 0x6c10, 0x6c26,
	0x6c3b, 0x6c4b, 0x6c61, 0x6c7a, 0x6c8e, 0x6ca2, 0x6cb4, 0x6cc7,
	0x6cdb, 0x6cf8, 0x6d20, 0x6d2f, 0x6d47, 0x6d5f, 0x6d77, 0x6d8f,
	0x6da7, 0x6dbf, 0x6dde, 0x6dfd, 0x6e1c, 0x6e3b, 0x6e58, 0x6e75,
	// Entry 7BC0 - 7BFF
	0x6e92, 0x6eaf, 0x6ed2, 0x6ef5, 0x6f18, 0x6f3b, 0x6f52, 0x6f69,
	0x6f80, 0x6f97, 0x6fb4, 0x6fd1, 0x6fee, 0x700b, 0x7027, 0x7053,
	0x706e, 0x7099, 0x70a9, 0x70b7, 0x70c8, 0x70d8, 0x70f3, 0x7114,
	0x712d, 0x714c, 0x7164, 0x717c, 0x71b8, 0x71ed, 0x7226, 0x7240,
	0x725f, 0x7284, 0x7296, 0x72b0, 0x72bd, 0x72d2, 0x72d8, 0x72e2,
	0x72f2, 0x72fd, 0x730d, 0x732e, 0x7333, 0x7338, 0x7342, 0x7349,
	0x734d, 0x7355, 0x7358, 0x7364, 0x736e, 0x7376, 0x737d, 0x7386,
	0x7391, 0x739b, 0x73ae, 0x73b2, 0x73bf, 0x73c9, 0x73dc, 0x73f0,
	// Entry 7C00 - 7C3F
	0x73fe, 0x740f, 0x7416, 0x741e, 0x742e, 0x7440, 0x7451, 0x745f,
	0x7463, 0x746a, 0x7473, 0x748b, 0x74a1, 0x74b2, 0x74cd, 0x74e4,
	0x74e8, 0x74f5, 0x7503, 0x7514, 0x7532, 0x7546, 0x755a, 0x7572,
	0x7579, 0x7584, 0x758d, 0x759f, 0x75a9, 0x75b7, 0x75c8, 0x75d3,
	0x75e0, 0x75e8, 0x75f3, 0x75f9, 0x7605, 0x760b, 0x760f, 0x7616,
	0x7626, 0x762d, 0x763a, 0x7646, 0x7663, 0x7672, 0x768c, 0x7697,
	0x76a3, 0x76b1, 0x76c7, 0x76d4, 0x76e0, 0x76e3, 0x76f3, 0x7701,
	0x7711, 0x7716, 0x771c, 0x7728, 0x772b, 0x7733, 0x7744, 0x774a,
	// Entry 7C40 - 7C7F
	0x7752, 0x775a, 0x7767, 0x7771, 0x778e, 0x77a2, 0x77bc, 0x77ca,
	0x77e5, 0x77f7, 0x7808, 0x7811, 0x7825, 0x7836, 0x7844, 0x784b,
	0x7858, 0x785d, 0x7861, 0x786e, 0x7878, 0x7885, 0x7891, 0x789d,
	0x78bf, 0x78d8, 0x78f2, 0x790d, 0x7928, 0x7948, 0x7968, 0x798a,
	0x79aa, 0x79cc, 0x79e9, 0x7a08, 0x7a27, 0x7a43, 0x7a6c, 0x7a8e,
	0x7ab5, 0x7ade, 0x7b07, 0x7b25, 0x7b3f, 0x7b5a, 0x7b77, 0x7b96,
	0x7bb5, 0x7bd6, 0x7bf0, 0x7c0c, 0x7c2a, 0x7c4a, 0x7c6e, 0x7c93,
	0x7cb3, 0x7cd8, 0x7d01, 0x7d27, 0x7d4f, 0x7d77, 0x7da7, 0x7dd8,
	// Entry 7C80 - 7CBF
	0x7df7, 0x7e14, 0x7e32, 0x7e54, 0x7e7f, 0x7ea5, 0x7ed8, 0x7f01,
	0x7f2a, 0x7f55, 0x7f72, 0x7f91, 0x7fb0, 0x7fcf, 0x7feb, 0x8009,
	0x8028, 0x804a, 0x8067, 0x8084, 0x80a3, 0x80c4, 0x80e5, 0x8101,
	0x811f, 0x813f, 0x815a, 0x8177, 0x8194, 0x81ae, 0x81c7, 0x81e3,
	0x8201, 0x821a, 0x8233, 0x824f, 0x8269, 0x8284, 0x82a7, 0x82cc,
	0x82ea, 0x8307, 0x832c, 0x834b, 0x8365, 0x8380, 0x83a0, 0x83bb,
	0x83da, 0x83f5, 0x8419, 0x8436, 0x8461, 0x848e, 0x84af, 0x84d0,
	0x84ed, 0x850b, 0x852b, 0x8547, 0x8569, 0x8587, 0x85a7, 0x85c7,
	// Entry 7CC0 - 7CFF
	0x85e7, 0x8607, 0x8624, 0x8646, 0x866b, 0x8687, 0x86a1, 0x86bc,
	0x86db, 0x86f6, 0x8715, 0x8735, 0x8761, 0x878b, 0x87b8, 0x87e4,
	0x87ff, 0x8817, 0x8828, 0x883a, 0x8851, 0x886d, 0x8897, 0x88a3,
	0x88b4, 0x88cf, 0x88e1, 0x88f4, 0x8905, 0x8917, 0x892e, 0x894a,
	0x8979, 0x89a4, 0x89b1, 0x89c3, 0x89db, 0x89f5, 0x8a26, 0x8a53,
	0x8a61, 0x8a73, 0x8a8b, 0x8aa5, 0x8ad1, 0x8ae1, 0x8af2, 0x8b04,
	0x8b14, 0x8b29, 0x8b3f, 0x8b5a, 0x8b66, 0x8b73, 0x8b81, 0x8b8d,
	0x8b9a, 0x8bac, 0x8bc3, 0x8bdd, 0x8bf8, 0x8c11, 0x8c2b, 0x8c4a,
	// Entry 7D00 - 7D3F
	0x8c6e, 0x8c87, 0x8ca1, 0x8cb9, 0x8cd2, 0x8cf0, 0x8d13, 0x8d2e,
	0x8d4a, 0x8d64, 0x8d7f, 0x8d9f, 0x8dbd, 0x8ddc, 0x8df4, 0x8e16,
	0x8e33, 0x8e51, 0x8e68, 0x8e89, 0x8eb1, 0x8ece, 0x8eeb, 0x8f08,
	0x8f24, 0x8f3d, 0x8f5c, 0x8f7a, 0x8f9d, 0x8fbe, 0x8fdd, 0x8ffc,
	0x901e, 0x902e, 0x9047, 0x9055, 0x906c, 0x907f, 0x9092, 0x90a4,
	0x90b7, 0x90c9, 0x90d9, 0x90ea, 0x90fd, 0x9110, 0x9122, 0x9135,
	0x9147, 0x9174, 0x919f, 0x91cd, 0x91fa, 0x9228, 0x9254, 0x9283,
	0x92b1, 0x92de, 0x9309, 0x9337, 0x9364, 0x9394, 0x93c2, 0x93f3,
	// Entry 7D40 - 7D7F
	0x9423, 0x944d, 0x9475, 0x94a0, 0x94ca, 0x94fa, 0x9528, 0x9559,
	0x9589, 0x95bf, 0x95f3, 0x962a, 0x9660, 0x9691, 0x96c0, 0x96f2,
	0x9723, 0x9754, 0x9783, 0x97b5, 0x97e6, 0x9815, 0x9842, 0x9872,
	0x98a1, 0x98d1, 0x98ff, 0x9930, 0x9960, 0x9995, 0x99c8, 0x99fe,
	0x9a33, 0x9a4e, 0x9a67, 0x9a83, 0x9a9e, 0x9ab5, 0x9aca, 0x9ae2,
	0x9af9, 0x9b13, 0x9b2b, 0x9b46, 0x9b60, 0x9b80, 0x9b9e, 0x9bbf,
	0x9bdf, 0x9bf4, 0x9c07, 0x9c1d, 0x9c32, 0x9c4c, 0x9c64, 0x9c7f,
	0x9c99, 0x9cb4, 0x9ccf, 0x9cea, 0x9d05, 0x9d20, 0x9d38, 0x9d5e,
	// Entry 7D80 - 7DBF
	0x9d82, 0x9da9, 0x9dcf, 0x9df6, 0x9e1d, 0x9e44, 0x9e6b, 0x9e8b,
	0x9ea9, 0x9eca, 0x9eea, 0x9f0b, 0x9f2c, 0x9f4d, 0x9f6e, 0x9f95,
	0x9fba, 0x9fe2, 0xa009, 0xa031, 0xa059, 0xa081, 0xa0a9, 0xa0cf,
	0xa0f3, 0xa11a, 0xa140, 0xa167, 0xa18e, 0xa1b5, 0xa1dc, 0xa207,
	0xa230, 0xa25c, 0xa287, 0xa2b3, 0xa2df, 0xa30b, 0xa337, 0xa353,
	0xa36d, 0xa38a, 0xa3a6, 0xa3d5, 0xa402, 0xa432, 0xa461, 0xa482,
	0xa4a1, 0xa4c3, 0xa4e4, 0xa4ff, 0xa521, 0xa541, 0xa562, 0xa585,
	0xa5a9, 0xa5c9, 0xa5ea, 0xa60b, 0xa62e, 0xa650, 0xa672, 0xa69c,
	// Entry 7DC0 - 7DFF
	0xa6c7, 0xa6f2, 0xa71e, 0xa739, 0xa75b, 0xa781, 0xa7b2, 0xa7d5,
	0xa7f7, 0xa80b, 0xa82a, 0xa84a, 0xa868, 0xa881, 0xa891, 0xa8a5,
	0xa8c1, 0xa8de, 0xa903, 0xa912, 0xa91d, 0xa928, 0xa935, 0xa946,
	0xa956, 0xa96b, 0xa974, 0xa981, 0xa997, 0xa9a1, 0xa9ad, 0xa9be,
	0xa9ca, 0xa9dd, 0xa9ed, 0xa9fe, 0xaa07, 0xaa31, 0xaa45, 0xaa59,
	0xaa63, 0xaa71, 0xaa8e, 0xaa9b, 0xaaa5, 0xaaae, 0xaabb, 0xaad7,
	0xaaf3, 0xab21, 0xab46, 0xab6e, 0xaba4, 0xabc1, 0xabe1, 0xabef,
	0xabfd, 0xac0e, 0xac14, 0xac1a, 0xac27, 0xac37, 0xac3c, 0xac52,
	// Entry 7E00 - 7E3F
	0xac5a, 0xac60, 0xac71, 0xac7a, 0xac84, 0xac8c, 0xac97, 0xaca4,
	0xacb8, 0xacc8, 0xacd5, 0xacda, 0xace2, 0xace7, 0xacf8, 0xad0a,
	0xad1b, 0xad27, 0xad3b, 0xad48, 0xad5f, 0xad67, 0xad72, 0xad7b,
	0xad82, 0xad8a, 0xad8f, 0xad95, 0xad9b, 0xada9, 0xadb4, 0xadc7,
	0xadd8, 0xaddb, 0xade8, 0xadef, 0xadf8, 0xae00, 0xae08, 0xae16,
	0xae21, 0xae2b, 0xae3a, 0xae48, 0xae4f, 0xae57, 0xae5a, 0xae61,
	0xae6c, 0xae74, 0xae7f, 0xae8a, 0xae8f, 0xae98, 0xae9d, 0xaecc,
	0xaed8, 0xaeee, 0xaf10, 0xaf34, 0xaf43, 0xaf50, 0xaf55, 0xaf63,
	// Entry 7E40 - 7E7F
	0xaf7a, 0xaf7e, 0xaf86, 0xaf8d, 0xaf98, 0xafa1, 0xafa5, 0xafae,
	0xafb6, 0xafbc, 0xafc8, 0xafcd, 0xafd1, 0xafd4, 0xafd9, 0xafdc,
	0xafe4, 0xafed, 0xaff1, 0xaff8, 0xaffe, 0xb008, 0xb00e, 0xb013,
	0xb01f, 0xb029, 0xb031, 0xb039, 0xb03e, 0xb045, 0xb04d, 0xb052,
	0xb059, 0xb065, 0xb06b, 0xb072, 0xb079, 0xb081, 0xb088, 0xb08e,
	0xb092, 0xb099, 0xb09d, 0xb0a2, 0xb0a7, 0xb0b0, 0xb0b5, 0xb0bd,
	0xb0c3, 0xb0c9, 0xb0ce, 0xb0d2, 0xb0db, 0xb0e7, 0xb0ff, 0xb119,
	0xb12d, 0xb147, 0xb14b, 0xb14e, 0xb152, 0xb157, 0xb160, 0xb16c,
	// Entry 7E80 - 7EBF
	0xb177, 0xb18b, 0xb19f, 0xb1b0, 0xb1be, 0xb1cc, 0xb1d8, 0xb1df,
	0xb1ea, 0xb1f6, 0xb1fc, 0xb201, 0xb208, 0xb20e, 0xb214, 0xb21e,
	0xb226, 0xb230, 0xb23f, 0xb24e, 0xb259, 0xb26a, 0xb26f, 0xb274,
	0xb27f, 0xb28d, 0xb2a2, 0xb2b7, 0xb2c6, 0xb2de, 0xb2e2, 0xb2e7,
	0xb2ee, 0xb2f7, 0xb2fa, 0xb2ff, 0xb305, 0xb30a, 0xb316, 0xb320,
	0xb325, 0xb32b, 0xb32f, 0xb334, 0xb345, 0xb350, 0xb363, 0xb36c,
	0xb376, 0xb386, 0xb38d, 0xb393, 0xb3a4, 0xb3ab, 0xb3b0, 0xb3b6,
	0xb3bd, 0xb3ca, 0xb3d9, 0xb3e5, 0xb3ef, 0xb3f9, 0xb3fe, 0xb404,
	// Entry 7EC0 - 7EFF
	0xb411, 0xb41c, 0xb422, 0xb429, 0xb435, 0xb447, 0xb45a, 0xb46c,
	0xb480, 0xb494, 0xb4a6, 0xb4d3, 0xb500, 0xb52f, 0xb556, 0xb57e,
	0xb5a5, 0xb5ce, 0xb5f7, 0xb61e, 0xb645, 0xb66d, 0xb694, 0xb6bd,
	0xb6e6, 0xb70d, 0xb736, 0xb760, 0xb789, 0xb7b4, 0xb7df, 0xb808,
	0xb842, 0xb87c, 0xb8b8, 0xb8cf, 0xb8e7, 0xb8fe, 0xb917, 0xb930,
	0xb947, 0xb95e, 0xb976, 0xb98d, 0xb9a6, 0xb9bf, 0xb9d6, 0xb9ef,
	0xba09, 0xba22, 0xba3d, 0xba58, 0xba71, 0xbaab, 0xbae5, 0xbb21,
	0xbb55, 0xbb8a, 0xbbbe, 0xbbf4, 0xbc2a, 0xbc5e, 0xbc92, 0xbcc7,
	// Entry 7F00 - 7F3F
	0xbcfb, 0xbd31, 0xbd67, 0xbd9b, 0xbdd1, 0xbe08, 0xbe3e, 0xbe76,
	0xbeae, 0xbee4, 0xbf1c, 0xbf54, 0xbf8e, 0xbfa4, 0xbfba, 0xbfd2,
	0xbfff, 0xc02c, 0xc05b, 0xc073, 0xc08a, 0xc0a3, 0xc0bb, 0xc0d2,
	0xc0eb, 0xc0fe, 0xc112, 0xc126, 0xc137, 0xc14a, 0xc15c, 0xc16f,
	0xc184, 0xc19a, 0xc1b0, 0xc1c3, 0xc1d8, 0xc1ec, 0xc201, 0xc20d,
	0xc21f, 0xc225, 0xc22b, 0xc237, 0xc244, 0xc254, 0xc25f, 0xc264,
	0xc268, 0xc271, 0xc27a, 0xc284, 0xc28a, 0xc297, 0xc2a4, 0xc2a9,
	0xc2ae, 0xc2b1, 0xc2ba, 0xc2bf, 0xc2ce, 0xc2d7, 0xc2e0, 0xc2e4,
	// Entry 7F40 - 7F7F
	0xc2f1, 0xc2fc, 0xc302, 0xc306, 0xc30c, 0xc312, 0xc319, 0xc326,
	0xc32a, 0xc330, 0xc33a, 0xc344, 0xc34d, 0xc354, 0xc358, 0xc35b,
	0xc35f, 0xc365, 0xc36e, 0xc37a, 0xc37e, 0xc385, 0xc395, 0xc39a,
	0xc3a8, 0xc3b3, 0xc3be, 0xc3c3, 0xc3cc, 0xc3d2, 0xc3d8, 0xc3de,
	0xc3ed, 0xc3fc, 0xc40c, 0xc41b, 0xc42b, 0xc43b, 0xc44c, 0xc45b,
	0xc46b, 0xc47b, 0xc48c, 0xc49c, 0xc4ad, 0xc4be, 0xc4d0, 0xc4df,
	0xc4ef, 0xc4ff, 0xc510, 0xc520, 0xc531, 0xc543, 0xc553, 0xc564,
	0xc575, 0xc587, 0xc598, 0xc5aa, 0xc5bc, 0xc5cf, 0xc5de, 0xc5ee,
	// Entry 7F80 - 7FBF
	0xc5fe, 0xc60f, 0xc61f, 0xc630, 0xc641, 0xc653, 0xc663, 0xc674,
	0xc686, 0xc697, 0xc6a9, 0xc6bb, 0xc6ce, 0xc6de, 0xc6ef, 0xc700,
	0xc712, 0xc723, 0xc735, 0xc747, 0xc75a, 0xc76b, 0xc77d, 0xc78f,
	0xc7a2, 0xc7b4, 0xc7c7, 0xc7da, 0xc815, 0xc84f, 0xc88a, 0xc8c4,
	0xc8f8, 0xc934, 0xc96f, 0xc9ab, 0xc9e6, 0xca1b, 0xca5d, 0xca9a,
	0xcad5, 0xcb12, 0xcb4d, 0xcb83, 0xcbbf, 0xcbf9, 0xcc35, 0xcc6f,
	0xcca4, 0xcce5, 0xcd21, 0xcd5c, 0xcd98, 0xcdd3, 0xce08, 0xce43,
	0xce7d, 0xceb8, 0xcef2, 0xcf26, 0xcf67, 0xcfa3, 0xcfdd, 0xd019,
	// Entry 7FC0 - 7FFF
	0xd053, 0xd088, 0xd0c5, 0xd100, 0xd13d, 0xd178, 0xd1ae, 0xd1f0,
	0xd229, 0xd261, 0xd299, 0xd2d1, 0xd2f2, 0xd314, 0xd336, 0xd358,
	0xd373, 0xd38e, 0xd3a9, 0xd3c4, 0xd3df, 0xd3fa, 0xd417, 0xd434,
	0xd451, 0xd46e, 0xd48b, 0xd4a8, 0xd4c7, 0xd4e6, 0xd506, 0xd526,
	0xd546, 0xd566, 0xd57d, 0xd596, 0xd5ae, 0xd5c8, 0xd5e1, 0xd5f8,
	0xd611, 0xd629, 0xd643, 0xd65c, 0xd672, 0xd689, 0xd6a0, 0xd6b7,
	0xd6cb, 0xd6ff, 0xd733, 0xd766, 0xd778, 0xd792, 0xd7a7, 0xd7c5,
	0xd7e3, 0xd808, 0xd82c, 0xd84e, 0xd871, 0xd894, 0xd8b6, 0xd8ed,
	// Entry 8000 - 803F
	0xd925, 0xd95c, 0xd994, 0xd9db, 0xda23, 0xda6a, 0xdab1, 0xdb09,
	0xdb61, 0xdbb8, 0xdc0f, 0xdc66, 0xdcbd, 0xdce0, 0xdd12, 0xdd2a,
	0xdd3c, 0xdd51, 0xdd67, 0xdd91, 0xddc5, 0xddfa, 0xde24, 0xde4c,
	0xde5c, 0xde6d, 0xde7f, 0xde95, 0xdeac, 0xdeda, 0xdef3, 0xdf1b,
	0xdf40, 0xdf67, 0xdf8d, 0xdfab, 0xdfb7, 0xdfd4, 0xdfed, 0xe007,
	0xe01e, 0xe037, 0xe04b, 0xe05e, 0xe071, 0xe086, 0xe09a, 0xe0ae,
	0xe0c1, 0xe0d6, 0xe0eb, 0xe0ff, 0xe120, 0xe141, 0xe162, 0xe183,
	0xe1a4, 0xe1c5, 0xe1e6, 0xe207, 0xe228, 0xe249, 0xe26a, 0xe28b,
	// Entry 8040 - 807F
	0xe2ac, 0xe2cd, 0xe2ee, 0xe30f, 0xe330, 0xe351, 0xe372, 0xe393,
	0xe3b4, 0xe3d5, 0xe3f6, 0xe417, 0xe438, 0xe459, 0xe47a, 0xe49b,
	0xe4bc, 0xe4dd, 0xe4fe, 0xe51f, 0xe540, 0xe561, 0xe582, 0xe5a3,
	0xe5c4, 0xe5e5, 0xe606, 0xe627, 0xe648, 0xe669, 0xe68a, 0xe6ab,
	0xe6cc, 0xe6ed, 0xe70e, 0xe72f, 0xe750, 0xe771, 0xe792, 0xe7b3,
	0xe7d4, 0xe7f5, 0xe816, 0xe837, 0xe858, 0xe879, 0xe89a, 0xe8bb,
	0xe8dc, 0xe8fd, 0xe91e, 0xe93f, 0xe960, 0xe981, 0xe9a2, 0xe9c3,
	0xe9e4, 0xea05, 0xea26, 0xea47, 0xea68, 0xea89, 0xeaaa, 0xeacb,
	// Entry 8080 - 80BF
	0xeaec, 0xeb0d, 0xeb2e, 0xeb4f, 0xeb70, 0xeb91, 0xebb2, 0xebd3,
	0xebf4, 0xec15, 0xec36, 0xec57, 0xec78, 0xec99, 0xecba, 0xecdb,
	0xecfc, 0xed1d, 0xed3e, 0xed5f, 0xed80, 0xeda1, 0xedc2, 0xede3,
	0xee04, 0xee25, 0xee46, 0xee67, 0xee88, 0xeea9, 0xeeca, 0xeeeb,
	0xef0c, 0xef2d, 0xef4e, 0xef6f, 0xef90, 0xefb1, 0xefd2, 0xeff3,
	0xf014, 0xf035, 0xf056, 0xf077, 0xf098, 0xf0b9, 0xf0da, 0xf0fb,
	0xf11c, 0xf13d, 0xf15e, 0xf17f, 0xf1a0, 0xf1c1, 0xf1e2, 0xf203,
	0xf224, 0xf245, 0xf266, 0xf287, 0xf2a8, 0xf2c9, 0xf2ea, 0xf30b,
	// Entry 80C0 - 80FF
	0xf32c, 0xf34d, 0xf36e, 0xf38f, 0xf3b0, 0xf3d1, 0xf3f2, 0xf413,
	0xf434, 0xf455, 0xf476, 0xf497, 0xf4b8, 0xf4d9, 0xf4fa, 0xf51b,
	0xf53c, 0xf55d, 0xf57e, 0xf59f, 0xf5c0, 0xf5e1, 0xf602, 0xf623,
	0xf644, 0xf665, 0xf686, 0xf6a7, 0xf6c8, 0xf6e9, 0xf70a, 0xf72b,
	0xf74c, 0xf76d, 0xf78e, 0xf7af, 0xf7d0, 0xf7f1, 0xf812, 0xf833,
	0xf854, 0xf875, 0xf896, 0xf8b7, 0xf8d8, 0xf8f9, 0xf91a, 0xf93b,
	0xf95c, 0xf97d, 0xf99e, 0xf9bf, 0xf9e0, 0xfa01, 0xfa22, 0xfa43,
	0xfa64, 0xfa85, 0xfaa6, 0xfac7, 0xfae8, 0xfb09, 0xfb2a, 0xfb4b,
	// Entry 8100 - 813F
	0xfb6c, 0xfb8d, 0xfbae, 0xfbcf, 0xfbf0, 0xfc11, 0xfc32, 0xfc53,
	0xfc74, 0xfc95, 0xfcb6, 0xfcd7, 0xfcf8, 0xfd19, 0xfd3a, 0xfd5b,
	0xfd7c, 0xfd9d, 0xfdbe, 0xfddf, 0xfe00, 0xfe21, 0xfe42, 0xfe63,
	0xfe84, 0xfea5, 0xfec6, 0xfee7, 0xff08, 0xff29, 0xff4a, 0xff6b,
	0xff8c, 0xffad, 0xffce, 0xffef, 0x0010, 0x0031, 0x0052, 0x0073,
	0x0094, 0x00b5, 0x00d6, 0x00f7, 0x0118, 0x0139, 0x015a, 0x017b,
	0x019c, 0x01bd, 0x01de, 0x01ff, 0x0220, 0x0241, 0x0262, 0x0283,
	0x02a4, 0x02c5, 0x02e6, 0x0307, 0x0328, 0x0349, 0x036a, 0x038b,
	// Entry 8140 - 817F
	0x03ac, 0x03cd, 0x03ee, 0x040f, 0x0430, 0x0451, 0x0472, 0x0493,
	0x04b4, 0x04d5, 0x04f6, 0x0517, 0x0538, 0x0559, 0x057a, 0x059b,
	0x05bc, 0x05dd, 0x05fe, 0x061f, 0x0640, 0x0661, 0x0682, 0x06a3,
	0x06c4, 0x06e5, 0x0706, 0x0727, 0x0748, 0x0769, 0x078a, 0x07ab,
	0x07cc, 0x07ed, 0x080e, 0x082f, 0x0850, 0x0871, 0x0892, 0x08b3,
	0x08d4, 0x08f5, 0x0916, 0x0937, 0x0958, 0x0979, 0x099a, 0x09bb,
	0x09dc, 0x09fd, 0x0a1e, 0x0a3f, 0x0a60, 0x0a81, 0x0aa2, 0x0ac3,
	0x0ae4, 0x0b05, 0x0b26, 0x0b47, 0x0b68, 0x0b89, 0x0baa, 0x0bcb,
	// Entry 8180 - 81BF
	0x0bec, 0x0c0d, 0x0c2e, 0x0c4f, 0x0c70, 0x0c91, 0x0cb2, 0x0cd3,
	0x0cf4, 0x0d15, 0x0d36, 0x0d57, 0x0d78, 0x0d99, 0x0dba, 0x0ddb,
	0x0dfc, 0x0e1d, 0x0e3e, 0x0e5f, 0x0e80, 0x0ea1, 0x0ec2, 0x0ee3,
	0x0f04, 0x0f25, 0x0f46, 0x0f67, 0x0f88, 0x0fa9, 0x0fca, 0x0feb,
	0x100c, 0x102d, 0x104e, 0x106f, 0x1090, 0x10b1, 0x10d2, 0x10f3,
	0x1114, 0x1135, 0x1156, 0x1177, 0x1198, 0x11b9, 0x11da, 0x11fb,
	0x121c, 0x123d, 0x125e, 0x127f, 0x12a0, 0x12c1, 0x12e2, 0x1303,
	0x1324, 0x1345, 0x1366, 0x1387, 0x13a8, 0x13c9, 0x13ea, 0x140b,
	// Entry 81C0 - 81FF
	0x142c, 0x144d, 0x146e, 0x148f, 0x14b0, 0x14d1, 0x14f2, 0x1513,
	0x1534, 0x1555, 0x1576, 0x1597, 0x15b8, 0x15d9, 0x15fa, 0x161b,
	0x163c, 0x165d, 0x167e, 0x169f, 0x16c0, 0x16e1, 0x1702, 0x1723,
	0x1744, 0x1765, 0x1786, 0x17a7, 0x17c8, 0x17e9, 0x180a, 0x182b,
	0x184c, 0x186d, 0x188e, 0x18af, 0x18d0, 0x18f1, 0x1912, 0x1933,
	0x1954, 0x1975, 0x1996, 0x19b7, 0x19d8, 0x19f9, 0x1a1a, 0x1a3b,
	0x1a5c, 0x1a7d, 0x1a9e, 0x1abf, 0x1ae0, 0x1b01, 0x1b22, 0x1b43,
	0x1b64, 0x1b85, 0x1ba6, 0x1bc7, 0x1be8, 0x1c09, 0x1c2a, 0x1c4b,
	// Entry 8200 - 823F
	0x1c6c, 0x1c8d, 0x1cae, 0x1ccf, 0x1cf0, 0x1d11, 0x1d32, 0x1d53,
	0x1d74, 0x1d95, 0x1db6, 0x1dd7, 0x1df8, 0x1e19, 0x1e3a, 0x1e5b,
	0x1e7c, 0x1e9d, 0x1ebe, 0x1edf, 0x1f00, 0x1f21, 0x1f42, 0x1f63,
	0x1f84, 0x1fa5, 0x1fc6, 0x1fe7, 0x2008, 0x2029, 0x204a, 0x206b,
	0x208c, 0x20ad, 0x20ce, 0x20ef, 0x2110, 0x2131, 0x2152, 0x2173,
	0x2194, 0x21b5, 0x21d6, 0x21f7, 0x2218, 0x2239, 0x225a, 0x227b,
	0x229c, 0x22bd, 0x22de, 0x22ff, 0x2320, 0x2341, 0x2362, 0x2383,
	0x23a4, 0x23c5, 0x23e6, 0x2407, 0x2428, 0x2449, 0x246a, 0x248b,
	// Entry 8240 - 827F
	0x24ac, 0x24cd, 0x24ee, 0x250f, 0x2530, 0x2551, 0x2572, 0x2593,
	0x25b4, 0x25d5, 0x25f6, 0x2617, 0x2638, 0x2659, 0x267a, 0x269b,
	0x26bc, 0x26dd, 0x26e9, 0x26f2, 0x2706, 0x2718, 0x2727, 0x2736,
	0x2746, 0x2753, 0x2761, 0x2775, 0x278a, 0x2796, 0x27a3, 0x27ac,
	0x27bc, 0x27c9, 0x27d4, 0x27e2, 0x27ef, 0x27fc, 0x280b, 0x2819,
	0x2827, 0x2834, 0x2843, 0x2852, 0x2860, 0x2869, 0x2876, 0x2888,
	0x2897, 0x28ac, 0x28bd, 0x28ce, 0x28e8, 0x2902, 0x291c, 0x2936,
	0x2950, 0x296a, 0x2984, 0x299e, 0x29b8, 0x29d2, 0x29ec, 0x2a06,
	// Entry 8280 - 82BF
	0x2a20, 0x2a3a, 0x2a54, 0x2a6e, 0x2a88, 0x2aa2, 0x2abc, 0x2ad6,
	0x2af0, 0x2b0a, 0x2b24, 0x2b3e, 0x2b58, 0x2b72, 0x2b89, 0x2b9c,
	0x2bb4, 0x2bc9, 0x2bd5, 0x2be5, 0x2bfd, 0x2c15, 0x2c2d, 0x2c45,
	0x2c5d, 0x2c75, 0x2c8d, 0x2ca5, 0x2cbd, 0x2cd5, 0x2ced, 0x2d05,
	0x2d1d, 0x2d35, 0x2d4d, 0x2d65, 0x2d7d, 0x2d95, 0x2dad, 0x2dc5,
	0x2ddd, 0x2df5, 0x2e0d, 0x2e25, 0x2e3d, 0x2e55, 0x2e6b, 0x2e7c,
	0x2e93, 0x2e9c, 0x2ea6, 0x2ebb, 0x2ed0, 0x2ee5, 0x2efa, 0x2f0f,
	0x2f24, 0x2f39, 0x2f4e, 0x2f63, 0x2f78, 0x2f8d, 0x2fa2, 0x2fb7,
	// Entry 82C0 - 82FF
	0x2fcc, 0x2fe1, 0x2ff6, 0x300b, 0x3020, 0x3035, 0x304a, 0x305f,
	0x3074, 0x3089, 0x309e, 0x30b3, 0x30c8, 0x30dd, 0x30f2, 0x3107,
	0x311c, 0x3131, 0x3146, 0x315b, 0x3170, 0x3185, 0x319a, 0x31af,
	0x31c4, 0x31d9, 0x31ee, 0x3203, 0x3218, 0x322d, 0x3242, 0x3257,
	0x326c, 0x3281, 0x3296, 0x32ab, 0x32c0, 0x32d5, 0x32ea, 0x32ff,
	0x3314, 0x3329, 0x333e, 0x3353, 0x3368, 0x337d, 0x3392, 0x33a7,
	0x33bc, 0x33d1, 0x33e6, 0x33fb, 0x3410, 0x3425, 0x343a, 0x344f,
	0x3464, 0x3479, 0x348e, 0x34a3, 0x34b8, 0x34cd, 0x34e2, 0x34f7,
	// Entry 8300 - 833F
	0x350c, 0x3521, 0x3536, 0x354b, 0x3560, 0x3575, 0x358b, 0x35a1,
	0x35b7, 0x35cd, 0x35e3, 0x35f9, 0x360f, 0x3625, 0x363b, 0x3651,
	0x3667, 0x367d, 0x3693, 0x36a9, 0x36bf, 0x36d5, 0x36eb, 0x3701,
	0x3717, 0x372d, 0x3743, 0x3759, 0x376f, 0x3785, 0x379b, 0x37b1,
	0x37c7, 0x37dd, 0x37f3, 0x3809, 0x381f, 0x3835, 0x384b, 0x3861,
	0x3877, 0x388d, 0x38a3, 0x38b9, 0x38cf, 0x38e5, 0x38fb, 0x3911,
	0x3927, 0x393d, 0x3953, 0x3969, 0x397f, 0x3995, 0x39ab, 0x39c1,
	0x39d7, 0x39ed, 0x3a03, 0x3a19, 0x3a2f, 0x3a45, 0x3a5b, 0x3a71,
	// Entry 8340 - 837F
	0x3a87, 0x3a9d, 0x3ab3, 0x3ac9, 0x3adf, 0x3af5, 0x3b0b, 0x3b21,
	0x3b37, 0x3b4d, 0x3b63, 0x3b79, 0x3b8f, 0x3ba5, 0x3bbb, 0x3bd1,
	0x3be7, 0x3bfd, 0x3c13, 0x3c29, 0x3c3f, 0x3c55, 0x3c6b, 0x3c81,
	0x3c97, 0x3cad, 0x3cc3, 0x3cd9, 0x3cef, 0x3d05, 0x3d1b, 0x3d31,
	0x3d47, 0x3d5d, 0x3d73, 0x3d89, 0x3d9f, 0x3db5, 0x3dcb, 0x3de1,
	0x3df7, 0x3e0d, 0x3e23, 0x3e39, 0x3e4f, 0x3e65, 0x3e7b, 0x3e91,
	0x3ea7, 0x3ebd, 0x3ed3, 0x3ee9, 0x3eff, 0x3f15, 0x3f2b, 0x3f41,
	0x3f57, 0x3f6d, 0x3f83, 0x3f99, 0x3faf, 0x3fc5, 0x3fdb, 0x3ff1,
	// Entry 8380 - 83BF
	0x4007, 0x401d, 0x4033, 0x4049, 0x405f, 0x4075, 0x408b, 0x40a1,
	0x40b7, 0x40cd, 0x40e3, 0x40f9, 0x410f, 0x4125, 0x413b, 0x4151,
	0x4167, 0x417d, 0x4193, 0x41a9, 0x41bf, 0x41d5, 0x41eb, 0x4201,
	0x4217, 0x422d, 0x4243, 0x4259, 0x426f, 0x4285, 0x429b, 0x42b1,
	0x42c7, 0x42dd, 0x42f3,
} // Size: 67422 bytes

const directData string = "" + // Size: 409 bytes
	"<CJK Ideograph Extension A><CJK Ideograph Extension B><CJK Ideograph Ext" +
	"ension C><CJK Ideograph Extension D><CJK Ideograph Extension E><CJK Ideo" +
	"graph Extension F><CJK Ideograph Extension G><CJK Ideograph><Hangul Syll" +
	"able><Low Surrogate><Non Private Use High Surrogate><Plane 15 Private Us" +
	"e><Plane 16 Private Use><Private Use High Surrogate><Private Use><Tangut" +
	" Ideograph Supplement><Tangut Ideograph><control>"

const singleData string = ("" + // Size: 869107 bytes; the redundant, explicit parens are for https://golang.org/issue/18078
	"SPACEEXCLAMATION MARKQUOTATION MARKNUMBER SIGNDOLLAR SIGNPERCENT SIGNAMP" +
	"ERSANDAPOSTROPHELEFT PARENTHESISRIGHT PARENTHESISASTERISKPLUS SIGNCOMMAH" +
	"YPHEN-MINUSFULL STOPSOLIDUSDIGIT ZERODIGIT ONEDIGIT TWODIGIT THREEDIGIT " +
	"FOURDIGIT FIVEDIGIT SIXDIGIT SEVENDIGIT EIGHTDIGIT NINECOLONSEMICOLONLES" +
	"S-THAN SIGNEQUALS SIGNGREATER-THAN SIGNQUESTION MARKCOMMERCIAL ATLATIN C" +
	"APITAL LETTER ALATIN CAPITAL LETTER BLATIN CAPITAL LETTER CLATIN CAPITAL" +
	" LETTER DLATIN CAPITAL LETTER ELATIN CAPITAL LETTER FLATIN CAPITAL LETTE" +
	"R GLATIN CAPITAL LETTER HLATIN CAPITAL LETTER ILATIN CAPITAL LETTER JLAT" +
	"IN CAPITAL LETTER KLATIN CAPITAL LETTER LLATIN CAPITAL LETTER MLATIN CAP" +
	"ITAL LETTER NLATIN CAPITAL LETTER OLATIN CAPITAL LETTER PLATIN CAPITAL L" +
	"ETTER QLATIN CAPITAL LETTER RLATIN CAPITAL LETTER SLATIN CAPITAL LETTER " +
	"TLATIN CAPITAL LETTER ULATIN CAPITAL LETTER VLATIN CAPITAL LETTER WLATIN" +
	" CAPITAL LETTER XLATIN CAPITAL LETTER YLATIN CAPITAL LETTER ZLEFT SQUARE" +
	" BRACKETREVERSE SOLIDUSRIGHT SQUARE BRACKETCIRCUMFLEX ACCENTLOW LINEGRAV" +
	"E ACCENTLATIN SMALL LETTER ALATIN SMALL LETTER BLATIN SMALL LETTER CLATI" +
	"N SMALL LETTER DLATIN SMALL LETTER ELATIN SMALL LETTER FLATIN SMALL LETT" +
	"ER GLATIN SMALL LETTER HLATIN SMALL LETTER ILATIN SMALL LETTER JLATIN SM" +
	"ALL LETTER KLATIN SMALL LETTER LLATIN SMALL LETTER MLATIN SMALL LETTER N" +
	"LATIN SMALL LETTER OLATIN SMALL LETTER PLATIN SMALL LETTER QLATIN SMALL " +
	"LETTER RLATIN SMALL LETTER SLATIN SMALL LETTER TLATIN SMALL LETTER ULATI" +
	"N SMALL LETTER VLATIN SMALL LETTER WLATIN SMALL LETTER XLATIN SMALL LETT" +
	"ER YLATIN SMALL LETTER ZLEFT CURLY BRACKETVERTICAL LINERIGHT CURLY BRACK" +
	"ETTILDENO-BREAK SPACEINVERTED EXCLAMATION MARKCENT SIGNPOUND SIGNCURRENC" +
	"Y SIGNYEN SIGNBROKEN BARSECTION SIGNDIAERESISCOPYRIGHT SIGNFEMININE ORDI" +
	"NAL INDICATORLEFT-POINTING DOUBLE ANGLE QUOTATION MARKNOT SIGNSOFT HYPHE" +
	"NREGISTERED SIGNMACRONDEGREE SIGNPLUS-MINUS SIGNSUPERSCRIPT TWOSUPERSCRI" +
	"PT THREEACUTE ACCENTMICRO SIGNPILCROW SIGNMIDDLE DOTCEDILLASUPERSCRIPT O" +
	"NEMASCULINE ORDINAL INDICATORRIGHT-POINTING DOUBLE ANGLE QUOTATION MARKV" +
	"ULGAR FRACTION ONE QUARTERVULGAR FRACTION ONE HALFVULGAR FRACTION THREE " +
	"QUARTERSINVERTED QUESTION MARKLATIN CAPITAL LETTER A WITH GRAVELATIN CAP" +
	"ITAL LETTER A WITH ACUTELATIN CAPITAL LETTER A WITH CIRCUMFLEXLATIN CAPI" +
	"TAL LETTER A WITH TILDELATIN CAPITAL LETTER A WITH DIAERESISLATIN CAPITA" +
	"L LETTER A WITH RING ABOVELATIN CAPITAL LETTER AELATIN CAPITAL LETTER C " +
	"WITH CEDILLALATIN CAPITAL LETTER E WITH GRAVELATIN CAPITAL LETTER E WITH" +
	" ACUTELATIN CAPITAL LETTER E WITH CIRCUMFLEXLATIN CAPITAL LETTER E WITH " +
	"DIAERESISLATIN CAPITAL LETTER I WITH GRAVELATIN CAPITAL LETTER I WITH AC" +
	"UTELATIN CAPITAL LETTER I WITH CIRCUMFLEXLATIN CAPITAL LETTER I WITH DIA" +
	"ERESISLATIN CAPITAL LETTER ETHLATIN CAPITAL LETTER N WITH TILDELATIN CAP" +
	"ITAL LETTER O WITH GRAVELATIN CAPITAL LETTER O WITH ACUTELATIN CAPITAL L" +
	"ETTER O WITH CIRCUMFLEXLATIN CAPITAL LETTER O WITH TILDELATIN CAPITAL LE" +
	"TTER O WITH DIAERESISMULTIPLICATION SIGNLATIN CAPITAL LETTER O WITH STRO" +
	"KELATIN CAPITAL LETTER U WITH GRAVELATIN CAPITAL LETTER U WITH ACUTELATI" +
	"N CAPITAL LETTER U WITH CIRCUMFLEXLATIN CAPITAL LETTER U WITH DIAERESISL" +
	"ATIN CAPITAL LETTER Y WITH ACUTELATIN CAPITAL LETTER THORNLATIN SMALL LE" +
	"TTER SHARP SLATIN SMALL LETTER A WITH GRAVELATIN SMALL LETTER A WITH ACU" +
	"TELATIN SMALL LETTER A WITH CIRCUMFLEXLATIN SMALL LETTER A WITH TILDELAT" +
	"IN SMALL LETTER A WITH DIAERESISLATIN SMALL LETTER A WITH RING ABOVELATI" +
	"N SMALL LETTER AELATIN SMALL LETTER C WITH CEDILLALATIN SMALL LETTER E W" +
	"ITH GRAVELATIN SMALL LETTER E WITH ACUTELATIN SMALL LETTER E WITH CIRCUM" +
	"FLEXLATIN SMALL LETTER E WITH DIAERESISLATIN SMALL LETTER I WITH GRAVELA" +
	"TIN SMALL LETTER I WITH ACUTELATIN SMALL LETTER I WITH CIRCUMFLEXLATIN S" +
	"MALL LETTER I WITH DIAERESISLATIN SMALL LETTER ETHLATIN SMALL LETTER N W" +
	"ITH TILDELATIN SMALL LETTER O WITH GRAVELATIN SMALL LETTER O WITH ACUTEL" +
	"ATIN SMALL LETTER O WITH CIRCUMFLEXLATIN SMALL LETTER O WITH TILDELATIN " +
	"SMALL LETTER O WITH DIAERESISDIVISION SIGNLATIN SMALL LETTER O WITH STRO" +
	"KELATIN SMALL LETTER U WITH GRAVELATIN SMALL LETTER U WITH ACUTELATIN SM" +
	"ALL LETTER U WITH CIRCUMFLEXLATIN SMALL LETTER U WITH DIAERESISLATIN SMA" +
	"LL LETTER Y WITH ACUTELATIN SMALL LETTER THORNLATIN SMALL LETTER Y WITH " +
	"DIAERESISLATIN CAPITAL LETTER A WITH MACRONLATIN SMALL LETTER A WITH MAC" +
	"RONLATIN CAPITAL LETTER A WITH BREVELATIN SMALL LETTER A WITH BREVELATIN" +
	" CAPITAL LETTER A WITH OGONEKLATIN SMALL LETTER A WITH OGONEKLATIN CAPIT" +
	"AL LETTER C WITH ACUTELATIN SMALL LETTER C WITH ACUTELATIN CAPITAL LETTE" +
	"R C WITH CIRCUMFLEXLATIN SMALL LETTER C WITH CIRCUMFLEXLATIN CAPITAL LET") + ("" +
	"TER C WITH DOT ABOVELATIN SMALL LETTER C WITH DOT ABOVELATIN CAPITAL LET" +
	"TER C WITH CARONLATIN SMALL LETTER C WITH CARONLATIN CAPITAL LETTER D WI" +
	"TH CARONLATIN SMALL LETTER D WITH CARONLATIN CAPITAL LETTER D WITH STROK" +
	"ELATIN SMALL LETTER D WITH STROKELATIN CAPITAL LETTER E WITH MACRONLATIN" +
	" SMALL LETTER E WITH MACRONLATIN CAPITAL LETTER E WITH BREVELATIN SMALL " +
	"LETTER E WITH BREVELATIN CAPITAL LETTER E WITH DOT ABOVELATIN SMALL LETT" +
	"ER E WITH DOT ABOVELATIN CAPITAL LETTER E WITH OGONEKLATIN SMALL LETTER " +
	"E WITH OGONEKLATIN CAPITAL LETTER E WITH CARONLATIN SMALL LETTER E WITH " +
	"CARONLATIN CAPITAL LETTER G WITH CIRCUMFLEXLATIN SMALL LETTER G WITH CIR" +
	"CUMFLEXLATIN CAPITAL LETTER G WITH BREVELATIN SMALL LETTER G WITH BREVEL" +
	"ATIN CAPITAL LETTER G WITH DOT ABOVELATIN SMALL LETTER G WITH DOT ABOVEL" +
	"ATIN CAPITAL LETTER G WITH CEDILLALATIN SMALL LETTER G WITH CEDILLALATIN" +
	" CAPITAL LETTER H WITH CIRCUMFLEXLATIN SMALL LETTER H WITH CIRCUMFLEXLAT" +
	"IN CAPITAL LETTER H WITH STROKELATIN SMALL LETTER H WITH STROKELATIN CAP" +
	"ITAL LETTER I WITH TILDELATIN SMALL LETTER I WITH TILDELATIN CAPITAL LET" +
	"TER I WITH MACRONLATIN SMALL LETTER I WITH MACRONLATIN CAPITAL LETTER I " +
	"WITH BREVELATIN SMALL LETTER I WITH BREVELATIN CAPITAL LETTER I WITH OGO" +
	"NEKLATIN SMALL LETTER I WITH OGONEKLATIN CAPITAL LETTER I WITH DOT ABOVE" +
	"LATIN SMALL LETTER DOTLESS ILATIN CAPITAL LIGATURE IJLATIN SMALL LIGATUR" +
	"E IJLATIN CAPITAL LETTER J WITH CIRCUMFLEXLATIN SMALL LETTER J WITH CIRC" +
	"UMFLEXLATIN CAPITAL LETTER K WITH CEDILLALATIN SMALL LETTER K WITH CEDIL" +
	"LALATIN SMALL LETTER KRALATIN CAPITAL LETTER L WITH ACUTELATIN SMALL LET" +
	"TER L WITH ACUTELATIN CAPITAL LETTER L WITH CEDILLALATIN SMALL LETTER L " +
	"WITH CEDILLALATIN CAPITAL LETTER L WITH CARONLATIN SMALL LETTER L WITH C" +
	"ARONLATIN CAPITAL LETTER L WITH MIDDLE DOTLATIN SMALL LETTER L WITH MIDD" +
	"LE DOTLATIN CAPITAL LETTER L WITH STROKELATIN SMALL LETTER L WITH STROKE" +
	"LATIN CAPITAL LETTER N WITH ACUTELATIN SMALL LETTER N WITH ACUTELATIN CA" +
	"PITAL LETTER N WITH CEDILLALATIN SMALL LETTER N WITH CEDILLALATIN CAPITA" +
	"L LETTER N WITH CARONLATIN SMALL LETTER N WITH CARONLATIN SMALL LETTER N" +
	" PRECEDED BY APOSTROPHELATIN CAPITAL LETTER ENGLATIN SMALL LETTER ENGLAT" +
	"IN CAPITAL LETTER O WITH MACRONLATIN SMALL LETTER O WITH MACRONLATIN CAP" +
	"ITAL LETTER O WITH BREVELATIN SMALL LETTER O WITH BREVELATIN CAPITAL LET" +
	"TER O WITH DOUBLE ACUTELATIN SMALL LETTER O WITH DOUBLE ACUTELATIN CAPIT" +
	"AL LIGATURE OELATIN SMALL LIGATURE OELATIN CAPITAL LETTER R WITH ACUTELA" +
	"TIN SMALL LETTER R WITH ACUTELATIN CAPITAL LETTER R WITH CEDILLALATIN SM" +
	"ALL LETTER R WITH CEDILLALATIN CAPITAL LETTER R WITH CARONLATIN SMALL LE" +
	"TTER R WITH CARONLATIN CAPITAL LETTER S WITH ACUTELATIN SMALL LETTER S W" +
	"ITH ACUTELATIN CAPITAL LETTER S WITH CIRCUMFLEXLATIN SMALL LETTER S WITH" +
	" CIRCUMFLEXLATIN CAPITAL LETTER S WITH CEDILLALATIN SMALL LETTER S WITH " +
	"CEDILLALATIN CAPITAL LETTER S WITH CARONLATIN SMALL LETTER S WITH CARONL" +
	"ATIN CAPITAL LETTER T WITH CEDILLALATIN SMALL LETTER T WITH CEDILLALATIN" +
	" CAPITAL LETTER T WITH CARONLATIN SMALL LETTER T WITH CARONLATIN CAPITAL" +
	" LETTER T WITH STROKELATIN SMALL LETTER T WITH STROKELATIN CAPITAL LETTE" +
	"R U WITH TILDELATIN SMALL LETTER U WITH TILDELATIN CAPITAL LETTER U WITH" +
	" MACRONLATIN SMALL LETTER U WITH MACRONLATIN CAPITAL LETTER U WITH BREVE" +
	"LATIN SMALL LETTER U WITH BREVELATIN CAPITAL LETTER U WITH RING ABOVELAT" +
	"IN SMALL LETTER U WITH RING ABOVELATIN CAPITAL LETTER U WITH DOUBLE ACUT" +
	"ELATIN SMALL LETTER U WITH DOUBLE ACUTELATIN CAPITAL LETTER U WITH OGONE" +
	"KLATIN SMALL LETTER U WITH OGONEKLATIN CAPITAL LETTER W WITH CIRCUMFLEXL" +
	"ATIN SMALL LETTER W WITH CIRCUMFLEXLATIN CAPITAL LETTER Y WITH CIRCUMFLE" +
	"XLATIN SMALL LETTER Y WITH CIRCUMFLEXLATIN CAPITAL LETTER Y WITH DIAERES" +
	"ISLATIN CAPITAL LETTER Z WITH ACUTELATIN SMALL LETTER Z WITH ACUTELATIN " +
	"CAPITAL LETTER Z WITH DOT ABOVELATIN SMALL LETTER Z WITH DOT ABOVELATIN " +
	"CAPITAL LETTER Z WITH CARONLATIN SMALL LETTER Z WITH CARONLATIN SMALL LE" +
	"TTER LONG SLATIN SMALL LETTER B WITH STROKELATIN CAPITAL LETTER B WITH H" +
	"OOKLATIN CAPITAL LETTER B WITH TOPBARLATIN SMALL LETTER B WITH TOPBARLAT" +
	"IN CAPITAL LETTER TONE SIXLATIN SMALL LETTER TONE SIXLATIN CAPITAL LETTE" +
	"R OPEN OLATIN CAPITAL LETTER C WITH HOOKLATIN SMALL LETTER C WITH HOOKLA" +
	"TIN CAPITAL LETTER AFRICAN DLATIN CAPITAL LETTER D WITH HOOKLATIN CAPITA" +
	"L LETTER D WITH TOPBARLATIN SMALL LETTER D WITH TOPBARLATIN SMALL LETTER" +
	" TURNED DELTALATIN CAPITAL LETTER REVERSED ELATIN CAPITAL LETTER SCHWALA" +
	"TIN CAPITAL LETTER OPEN ELATIN CAPITAL LETTER F WITH HOOKLATIN SMALL LET" +
	"TER F WITH HOOKLATIN CAPITAL LETTER G WITH HOOKLATIN CAPITAL LETTER GAMM" +
	"ALATIN SMALL LETTER HVLATIN CAPITAL LETTER IOTALATIN CAPITAL LETTER I WI") + ("" +
	"TH STROKELATIN CAPITAL LETTER K WITH HOOKLATIN SMALL LETTER K WITH HOOKL" +
	"ATIN SMALL LETTER L WITH BARLATIN SMALL LETTER LAMBDA WITH STROKELATIN C" +
	"APITAL LETTER TURNED MLATIN CAPITAL LETTER N WITH LEFT HOOKLATIN SMALL L" +
	"ETTER N WITH LONG RIGHT LEGLATIN CAPITAL LETTER O WITH MIDDLE TILDELATIN" +
	" CAPITAL LETTER O WITH HORNLATIN SMALL LETTER O WITH HORNLATIN CAPITAL L" +
	"ETTER OILATIN SMALL LETTER OILATIN CAPITAL LETTER P WITH HOOKLATIN SMALL" +
	" LETTER P WITH HOOKLATIN LETTER YRLATIN CAPITAL LETTER TONE TWOLATIN SMA" +
	"LL LETTER TONE TWOLATIN CAPITAL LETTER ESHLATIN LETTER REVERSED ESH LOOP" +
	"LATIN SMALL LETTER T WITH PALATAL HOOKLATIN CAPITAL LETTER T WITH HOOKLA" +
	"TIN SMALL LETTER T WITH HOOKLATIN CAPITAL LETTER T WITH RETROFLEX HOOKLA" +
	"TIN CAPITAL LETTER U WITH HORNLATIN SMALL LETTER U WITH HORNLATIN CAPITA" +
	"L LETTER UPSILONLATIN CAPITAL LETTER V WITH HOOKLATIN CAPITAL LETTER Y W" +
	"ITH HOOKLATIN SMALL LETTER Y WITH HOOKLATIN CAPITAL LETTER Z WITH STROKE" +
	"LATIN SMALL LETTER Z WITH STROKELATIN CAPITAL LETTER EZHLATIN CAPITAL LE" +
	"TTER EZH REVERSEDLATIN SMALL LETTER EZH REVERSEDLATIN SMALL LETTER EZH W" +
	"ITH TAILLATIN LETTER TWO WITH STROKELATIN CAPITAL LETTER TONE FIVELATIN " +
	"SMALL LETTER TONE FIVELATIN LETTER INVERTED GLOTTAL STOP WITH STROKELATI" +
	"N LETTER WYNNLATIN LETTER DENTAL CLICKLATIN LETTER LATERAL CLICKLATIN LE" +
	"TTER ALVEOLAR CLICKLATIN LETTER RETROFLEX CLICKLATIN CAPITAL LETTER DZ W" +
	"ITH CARONLATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARONLATIN SMAL" +
	"L LETTER DZ WITH CARONLATIN CAPITAL LETTER LJLATIN CAPITAL LETTER L WITH" +
	" SMALL LETTER JLATIN SMALL LETTER LJLATIN CAPITAL LETTER NJLATIN CAPITAL" +
	" LETTER N WITH SMALL LETTER JLATIN SMALL LETTER NJLATIN CAPITAL LETTER A" +
	" WITH CARONLATIN SMALL LETTER A WITH CARONLATIN CAPITAL LETTER I WITH CA" +
	"RONLATIN SMALL LETTER I WITH CARONLATIN CAPITAL LETTER O WITH CARONLATIN" +
	" SMALL LETTER O WITH CARONLATIN CAPITAL LETTER U WITH CARONLATIN SMALL L" +
	"ETTER U WITH CARONLATIN CAPITAL LETTER U WITH DIAERESIS AND MACRONLATIN " +
	"SMALL LETTER U WITH DIAERESIS AND MACRONLATIN CAPITAL LETTER U WITH DIAE" +
	"RESIS AND ACUTELATIN SMALL LETTER U WITH DIAERESIS AND ACUTELATIN CAPITA" +
	"L LETTER U WITH DIAERESIS AND CARONLATIN SMALL LETTER U WITH DIAERESIS A" +
	"ND CARONLATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVELATIN SMALL LETTE" +
	"R U WITH DIAERESIS AND GRAVELATIN SMALL LETTER TURNED ELATIN CAPITAL LET" +
	"TER A WITH DIAERESIS AND MACRONLATIN SMALL LETTER A WITH DIAERESIS AND M" +
	"ACRONLATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRONLATIN SMALL LETTER " +
	"A WITH DOT ABOVE AND MACRONLATIN CAPITAL LETTER AE WITH MACRONLATIN SMAL" +
	"L LETTER AE WITH MACRONLATIN CAPITAL LETTER G WITH STROKELATIN SMALL LET" +
	"TER G WITH STROKELATIN CAPITAL LETTER G WITH CARONLATIN SMALL LETTER G W" +
	"ITH CARONLATIN CAPITAL LETTER K WITH CARONLATIN SMALL LETTER K WITH CARO" +
	"NLATIN CAPITAL LETTER O WITH OGONEKLATIN SMALL LETTER O WITH OGONEKLATIN" +
	" CAPITAL LETTER O WITH OGONEK AND MACRONLATIN SMALL LETTER O WITH OGONEK" +
	" AND MACRONLATIN CAPITAL LETTER EZH WITH CARONLATIN SMALL LETTER EZH WIT" +
	"H CARONLATIN SMALL LETTER J WITH CARONLATIN CAPITAL LETTER DZLATIN CAPIT" +
	"AL LETTER D WITH SMALL LETTER ZLATIN SMALL LETTER DZLATIN CAPITAL LETTER" +
	" G WITH ACUTELATIN SMALL LETTER G WITH ACUTELATIN CAPITAL LETTER HWAIRLA" +
	"TIN CAPITAL LETTER WYNNLATIN CAPITAL LETTER N WITH GRAVELATIN SMALL LETT" +
	"ER N WITH GRAVELATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTELATIN SMA" +
	"LL LETTER A WITH RING ABOVE AND ACUTELATIN CAPITAL LETTER AE WITH ACUTEL" +
	"ATIN SMALL LETTER AE WITH ACUTELATIN CAPITAL LETTER O WITH STROKE AND AC" +
	"UTELATIN SMALL LETTER O WITH STROKE AND ACUTELATIN CAPITAL LETTER A WITH" +
	" DOUBLE GRAVELATIN SMALL LETTER A WITH DOUBLE GRAVELATIN CAPITAL LETTER " +
	"A WITH INVERTED BREVELATIN SMALL LETTER A WITH INVERTED BREVELATIN CAPIT" +
	"AL LETTER E WITH DOUBLE GRAVELATIN SMALL LETTER E WITH DOUBLE GRAVELATIN" +
	" CAPITAL LETTER E WITH INVERTED BREVELATIN SMALL LETTER E WITH INVERTED " +
	"BREVELATIN CAPITAL LETTER I WITH DOUBLE GRAVELATIN SMALL LETTER I WITH D" +
	"OUBLE GRAVELATIN CAPITAL LETTER I WITH INVERTED BREVELATIN SMALL LETTER " +
	"I WITH INVERTED BREVELATIN CAPITAL LETTER O WITH DOUBLE GRAVELATIN SMALL" +
	" LETTER O WITH DOUBLE GRAVELATIN CAPITAL LETTER O WITH INVERTED BREVELAT" +
	"IN SMALL LETTER O WITH INVERTED BREVELATIN CAPITAL LETTER R WITH DOUBLE " +
	"GRAVELATIN SMALL LETTER R WITH DOUBLE GRAVELATIN CAPITAL LETTER R WITH I" +
	"NVERTED BREVELATIN SMALL LETTER R WITH INVERTED BREVELATIN CAPITAL LETTE" +
	"R U WITH DOUBLE GRAVELATIN SMALL LETTER U WITH DOUBLE GRAVELATIN CAPITAL" +
	" LETTER U WITH INVERTED BREVELATIN SMALL LETTER U WITH INVERTED BREVELAT" +
	"IN CAPITAL LETTER S WITH COMMA BELOWLATIN SMALL LETTER S WITH COMMA BELO" +
	"WLATIN CAPITAL LETTER T WITH COMMA BELOWLATIN SMALL LETTER T WITH COMMA ") + ("" +
	"BELOWLATIN CAPITAL LETTER YOGHLATIN SMALL LETTER YOGHLATIN CAPITAL LETTE" +
	"R H WITH CARONLATIN SMALL LETTER H WITH CARONLATIN CAPITAL LETTER N WITH" +
	" LONG RIGHT LEGLATIN SMALL LETTER D WITH CURLLATIN CAPITAL LETTER OULATI" +
	"N SMALL LETTER OULATIN CAPITAL LETTER Z WITH HOOKLATIN SMALL LETTER Z WI" +
	"TH HOOKLATIN CAPITAL LETTER A WITH DOT ABOVELATIN SMALL LETTER A WITH DO" +
	"T ABOVELATIN CAPITAL LETTER E WITH CEDILLALATIN SMALL LETTER E WITH CEDI" +
	"LLALATIN CAPITAL LETTER O WITH DIAERESIS AND MACRONLATIN SMALL LETTER O " +
	"WITH DIAERESIS AND MACRONLATIN CAPITAL LETTER O WITH TILDE AND MACRONLAT" +
	"IN SMALL LETTER O WITH TILDE AND MACRONLATIN CAPITAL LETTER O WITH DOT A" +
	"BOVELATIN SMALL LETTER O WITH DOT ABOVELATIN CAPITAL LETTER O WITH DOT A" +
	"BOVE AND MACRONLATIN SMALL LETTER O WITH DOT ABOVE AND MACRONLATIN CAPIT" +
	"AL LETTER Y WITH MACRONLATIN SMALL LETTER Y WITH MACRONLATIN SMALL LETTE" +
	"R L WITH CURLLATIN SMALL LETTER N WITH CURLLATIN SMALL LETTER T WITH CUR" +
	"LLATIN SMALL LETTER DOTLESS JLATIN SMALL LETTER DB DIGRAPHLATIN SMALL LE" +
	"TTER QP DIGRAPHLATIN CAPITAL LETTER A WITH STROKELATIN CAPITAL LETTER C " +
	"WITH STROKELATIN SMALL LETTER C WITH STROKELATIN CAPITAL LETTER L WITH B" +
	"ARLATIN CAPITAL LETTER T WITH DIAGONAL STROKELATIN SMALL LETTER S WITH S" +
	"WASH TAILLATIN SMALL LETTER Z WITH SWASH TAILLATIN CAPITAL LETTER GLOTTA" +
	"L STOPLATIN SMALL LETTER GLOTTAL STOPLATIN CAPITAL LETTER B WITH STROKEL" +
	"ATIN CAPITAL LETTER U BARLATIN CAPITAL LETTER TURNED VLATIN CAPITAL LETT" +
	"ER E WITH STROKELATIN SMALL LETTER E WITH STROKELATIN CAPITAL LETTER J W" +
	"ITH STROKELATIN SMALL LETTER J WITH STROKELATIN CAPITAL LETTER SMALL Q W" +
	"ITH HOOK TAILLATIN SMALL LETTER Q WITH HOOK TAILLATIN CAPITAL LETTER R W" +
	"ITH STROKELATIN SMALL LETTER R WITH STROKELATIN CAPITAL LETTER Y WITH ST" +
	"ROKELATIN SMALL LETTER Y WITH STROKELATIN SMALL LETTER TURNED ALATIN SMA" +
	"LL LETTER ALPHALATIN SMALL LETTER TURNED ALPHALATIN SMALL LETTER B WITH " +
	"HOOKLATIN SMALL LETTER OPEN OLATIN SMALL LETTER C WITH CURLLATIN SMALL L" +
	"ETTER D WITH TAILLATIN SMALL LETTER D WITH HOOKLATIN SMALL LETTER REVERS" +
	"ED ELATIN SMALL LETTER SCHWALATIN SMALL LETTER SCHWA WITH HOOKLATIN SMAL" +
	"L LETTER OPEN ELATIN SMALL LETTER REVERSED OPEN ELATIN SMALL LETTER REVE" +
	"RSED OPEN E WITH HOOKLATIN SMALL LETTER CLOSED REVERSED OPEN ELATIN SMAL" +
	"L LETTER DOTLESS J WITH STROKELATIN SMALL LETTER G WITH HOOKLATIN SMALL " +
	"LETTER SCRIPT GLATIN LETTER SMALL CAPITAL GLATIN SMALL LETTER GAMMALATIN" +
	" SMALL LETTER RAMS HORNLATIN SMALL LETTER TURNED HLATIN SMALL LETTER H W" +
	"ITH HOOKLATIN SMALL LETTER HENG WITH HOOKLATIN SMALL LETTER I WITH STROK" +
	"ELATIN SMALL LETTER IOTALATIN LETTER SMALL CAPITAL ILATIN SMALL LETTER L" +
	" WITH MIDDLE TILDELATIN SMALL LETTER L WITH BELTLATIN SMALL LETTER L WIT" +
	"H RETROFLEX HOOKLATIN SMALL LETTER LEZHLATIN SMALL LETTER TURNED MLATIN " +
	"SMALL LETTER TURNED M WITH LONG LEGLATIN SMALL LETTER M WITH HOOKLATIN S" +
	"MALL LETTER N WITH LEFT HOOKLATIN SMALL LETTER N WITH RETROFLEX HOOKLATI" +
	"N LETTER SMALL CAPITAL NLATIN SMALL LETTER BARRED OLATIN LETTER SMALL CA" +
	"PITAL OELATIN SMALL LETTER CLOSED OMEGALATIN SMALL LETTER PHILATIN SMALL" +
	" LETTER TURNED RLATIN SMALL LETTER TURNED R WITH LONG LEGLATIN SMALL LET" +
	"TER TURNED R WITH HOOKLATIN SMALL LETTER R WITH LONG LEGLATIN SMALL LETT" +
	"ER R WITH TAILLATIN SMALL LETTER R WITH FISHHOOKLATIN SMALL LETTER REVER" +
	"SED R WITH FISHHOOKLATIN LETTER SMALL CAPITAL RLATIN LETTER SMALL CAPITA" +
	"L INVERTED RLATIN SMALL LETTER S WITH HOOKLATIN SMALL LETTER ESHLATIN SM" +
	"ALL LETTER DOTLESS J WITH STROKE AND HOOKLATIN SMALL LETTER SQUAT REVERS" +
	"ED ESHLATIN SMALL LETTER ESH WITH CURLLATIN SMALL LETTER TURNED TLATIN S" +
	"MALL LETTER T WITH RETROFLEX HOOKLATIN SMALL LETTER U BARLATIN SMALL LET" +
	"TER UPSILONLATIN SMALL LETTER V WITH HOOKLATIN SMALL LETTER TURNED VLATI" +
	"N SMALL LETTER TURNED WLATIN SMALL LETTER TURNED YLATIN LETTER SMALL CAP" +
	"ITAL YLATIN SMALL LETTER Z WITH RETROFLEX HOOKLATIN SMALL LETTER Z WITH " +
	"CURLLATIN SMALL LETTER EZHLATIN SMALL LETTER EZH WITH CURLLATIN LETTER G" +
	"LOTTAL STOPLATIN LETTER PHARYNGEAL VOICED FRICATIVELATIN LETTER INVERTED" +
	" GLOTTAL STOPLATIN LETTER STRETCHED CLATIN LETTER BILABIAL CLICKLATIN LE" +
	"TTER SMALL CAPITAL BLATIN SMALL LETTER CLOSED OPEN ELATIN LETTER SMALL C" +
	"APITAL G WITH HOOKLATIN LETTER SMALL CAPITAL HLATIN SMALL LETTER J WITH " +
	"CROSSED-TAILLATIN SMALL LETTER TURNED KLATIN LETTER SMALL CAPITAL LLATIN" +
	" SMALL LETTER Q WITH HOOKLATIN LETTER GLOTTAL STOP WITH STROKELATIN LETT" +
	"ER REVERSED GLOTTAL STOP WITH STROKELATIN SMALL LETTER DZ DIGRAPHLATIN S" +
	"MALL LETTER DEZH DIGRAPHLATIN SMALL LETTER DZ DIGRAPH WITH CURLLATIN SMA" +
	"LL LETTER TS DIGRAPHLATIN SMALL LETTER TESH DIGRAPHLATIN SMALL LETTER TC" +
	" DIGRAPH WITH CURLLATIN SMALL LETTER FENG DIGRAPHLATIN SMALL LETTER LS D") + ("" +
	"IGRAPHLATIN SMALL LETTER LZ DIGRAPHLATIN LETTER BILABIAL PERCUSSIVELATIN" +
	" LETTER BIDENTAL PERCUSSIVELATIN SMALL LETTER TURNED H WITH FISHHOOKLATI" +
	"N SMALL LETTER TURNED H WITH FISHHOOK AND TAILMODIFIER LETTER SMALL HMOD" +
	"IFIER LETTER SMALL H WITH HOOKMODIFIER LETTER SMALL JMODIFIER LETTER SMA" +
	"LL RMODIFIER LETTER SMALL TURNED RMODIFIER LETTER SMALL TURNED R WITH HO" +
	"OKMODIFIER LETTER SMALL CAPITAL INVERTED RMODIFIER LETTER SMALL WMODIFIE" +
	"R LETTER SMALL YMODIFIER LETTER PRIMEMODIFIER LETTER DOUBLE PRIMEMODIFIE" +
	"R LETTER TURNED COMMAMODIFIER LETTER APOSTROPHEMODIFIER LETTER REVERSED " +
	"COMMAMODIFIER LETTER RIGHT HALF RINGMODIFIER LETTER LEFT HALF RINGMODIFI" +
	"ER LETTER GLOTTAL STOPMODIFIER LETTER REVERSED GLOTTAL STOPMODIFIER LETT" +
	"ER LEFT ARROWHEADMODIFIER LETTER RIGHT ARROWHEADMODIFIER LETTER UP ARROW" +
	"HEADMODIFIER LETTER DOWN ARROWHEADMODIFIER LETTER CIRCUMFLEX ACCENTCARON" +
	"MODIFIER LETTER VERTICAL LINEMODIFIER LETTER MACRONMODIFIER LETTER ACUTE" +
	" ACCENTMODIFIER LETTER GRAVE ACCENTMODIFIER LETTER LOW VERTICAL LINEMODI" +
	"FIER LETTER LOW MACRONMODIFIER LETTER LOW GRAVE ACCENTMODIFIER LETTER LO" +
	"W ACUTE ACCENTMODIFIER LETTER TRIANGULAR COLONMODIFIER LETTER HALF TRIAN" +
	"GULAR COLONMODIFIER LETTER CENTRED RIGHT HALF RINGMODIFIER LETTER CENTRE" +
	"D LEFT HALF RINGMODIFIER LETTER UP TACKMODIFIER LETTER DOWN TACKMODIFIER" +
	" LETTER PLUS SIGNMODIFIER LETTER MINUS SIGNBREVEDOT ABOVERING ABOVEOGONE" +
	"KSMALL TILDEDOUBLE ACUTE ACCENTMODIFIER LETTER RHOTIC HOOKMODIFIER LETTE" +
	"R CROSS ACCENTMODIFIER LETTER SMALL GAMMAMODIFIER LETTER SMALL LMODIFIER" +
	" LETTER SMALL SMODIFIER LETTER SMALL XMODIFIER LETTER SMALL REVERSED GLO" +
	"TTAL STOPMODIFIER LETTER EXTRA-HIGH TONE BARMODIFIER LETTER HIGH TONE BA" +
	"RMODIFIER LETTER MID TONE BARMODIFIER LETTER LOW TONE BARMODIFIER LETTER" +
	" EXTRA-LOW TONE BARMODIFIER LETTER YIN DEPARTING TONE MARKMODIFIER LETTE" +
	"R YANG DEPARTING TONE MARKMODIFIER LETTER VOICINGMODIFIER LETTER UNASPIR" +
	"ATEDMODIFIER LETTER DOUBLE APOSTROPHEMODIFIER LETTER LOW DOWN ARROWHEADM" +
	"ODIFIER LETTER LOW UP ARROWHEADMODIFIER LETTER LOW LEFT ARROWHEADMODIFIE" +
	"R LETTER LOW RIGHT ARROWHEADMODIFIER LETTER LOW RINGMODIFIER LETTER MIDD" +
	"LE GRAVE ACCENTMODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENTMODIFIER LETTER" +
	" MIDDLE DOUBLE ACUTE ACCENTMODIFIER LETTER LOW TILDEMODIFIER LETTER RAIS" +
	"ED COLONMODIFIER LETTER BEGIN HIGH TONEMODIFIER LETTER END HIGH TONEMODI" +
	"FIER LETTER BEGIN LOW TONEMODIFIER LETTER END LOW TONEMODIFIER LETTER SH" +
	"ELFMODIFIER LETTER OPEN SHELFMODIFIER LETTER LOW LEFT ARROWCOMBINING GRA" +
	"VE ACCENTCOMBINING ACUTE ACCENTCOMBINING CIRCUMFLEX ACCENTCOMBINING TILD" +
	"ECOMBINING MACRONCOMBINING OVERLINECOMBINING BREVECOMBINING DOT ABOVECOM" +
	"BINING DIAERESISCOMBINING HOOK ABOVECOMBINING RING ABOVECOMBINING DOUBLE" +
	" ACUTE ACCENTCOMBINING CARONCOMBINING VERTICAL LINE ABOVECOMBINING DOUBL" +
	"E VERTICAL LINE ABOVECOMBINING DOUBLE GRAVE ACCENTCOMBINING CANDRABINDUC" +
	"OMBINING INVERTED BREVECOMBINING TURNED COMMA ABOVECOMBINING COMMA ABOVE" +
	"COMBINING REVERSED COMMA ABOVECOMBINING COMMA ABOVE RIGHTCOMBINING GRAVE" +
	" ACCENT BELOWCOMBINING ACUTE ACCENT BELOWCOMBINING LEFT TACK BELOWCOMBIN" +
	"ING RIGHT TACK BELOWCOMBINING LEFT ANGLE ABOVECOMBINING HORNCOMBINING LE" +
	"FT HALF RING BELOWCOMBINING UP TACK BELOWCOMBINING DOWN TACK BELOWCOMBIN" +
	"ING PLUS SIGN BELOWCOMBINING MINUS SIGN BELOWCOMBINING PALATALIZED HOOK " +
	"BELOWCOMBINING RETROFLEX HOOK BELOWCOMBINING DOT BELOWCOMBINING DIAERESI" +
	"S BELOWCOMBINING RING BELOWCOMBINING COMMA BELOWCOMBINING CEDILLACOMBINI" +
	"NG OGONEKCOMBINING VERTICAL LINE BELOWCOMBINING BRIDGE BELOWCOMBINING IN" +
	"VERTED DOUBLE ARCH BELOWCOMBINING CARON BELOWCOMBINING CIRCUMFLEX ACCENT" +
	" BELOWCOMBINING BREVE BELOWCOMBINING INVERTED BREVE BELOWCOMBINING TILDE" +
	" BELOWCOMBINING MACRON BELOWCOMBINING LOW LINECOMBINING DOUBLE LOW LINEC" +
	"OMBINING TILDE OVERLAYCOMBINING SHORT STROKE OVERLAYCOMBINING LONG STROK" +
	"E OVERLAYCOMBINING SHORT SOLIDUS OVERLAYCOMBINING LONG SOLIDUS OVERLAYCO" +
	"MBINING RIGHT HALF RING BELOWCOMBINING INVERTED BRIDGE BELOWCOMBINING SQ" +
	"UARE BELOWCOMBINING SEAGULL BELOWCOMBINING X ABOVECOMBINING VERTICAL TIL" +
	"DECOMBINING DOUBLE OVERLINECOMBINING GRAVE TONE MARKCOMBINING ACUTE TONE" +
	" MARKCOMBINING GREEK PERISPOMENICOMBINING GREEK KORONISCOMBINING GREEK D" +
	"IALYTIKA TONOSCOMBINING GREEK YPOGEGRAMMENICOMBINING BRIDGE ABOVECOMBINI" +
	"NG EQUALS SIGN BELOWCOMBINING DOUBLE VERTICAL LINE BELOWCOMBINING LEFT A" +
	"NGLE BELOWCOMBINING NOT TILDE ABOVECOMBINING HOMOTHETIC ABOVECOMBINING A" +
	"LMOST EQUAL TO ABOVECOMBINING LEFT RIGHT ARROW BELOWCOMBINING UPWARDS AR" +
	"ROW BELOWCOMBINING GRAPHEME JOINERCOMBINING RIGHT ARROWHEAD ABOVECOMBINI" +
	"NG LEFT HALF RING ABOVECOMBINING FERMATACOMBINING X BELOWCOMBINING LEFT " +
	"ARROWHEAD BELOWCOMBINING RIGHT ARROWHEAD BELOWCOMBINING RIGHT ARROWHEAD ") + ("" +
	"AND UP ARROWHEAD BELOWCOMBINING RIGHT HALF RING ABOVECOMBINING DOT ABOVE" +
	" RIGHTCOMBINING ASTERISK BELOWCOMBINING DOUBLE RING BELOWCOMBINING ZIGZA" +
	"G ABOVECOMBINING DOUBLE BREVE BELOWCOMBINING DOUBLE BREVECOMBINING DOUBL" +
	"E MACRONCOMBINING DOUBLE MACRON BELOWCOMBINING DOUBLE TILDECOMBINING DOU" +
	"BLE INVERTED BREVECOMBINING DOUBLE RIGHTWARDS ARROW BELOWCOMBINING LATIN" +
	" SMALL LETTER ACOMBINING LATIN SMALL LETTER ECOMBINING LATIN SMALL LETTE" +
	"R ICOMBINING LATIN SMALL LETTER OCOMBINING LATIN SMALL LETTER UCOMBINING" +
	" LATIN SMALL LETTER CCOMBINING LATIN SMALL LETTER DCOMBINING LATIN SMALL" +
	" LETTER HCOMBINING LATIN SMALL LETTER MCOMBINING LATIN SMALL LETTER RCOM" +
	"BINING LATIN SMALL LETTER TCOMBINING LATIN SMALL LETTER VCOMBINING LATIN" +
	" SMALL LETTER XGREEK CAPITAL LETTER HETAGREEK SMALL LETTER HETAGREEK CAP" +
	"ITAL LETTER ARCHAIC SAMPIGREEK SMALL LETTER ARCHAIC SAMPIGREEK NUMERAL S" +
	"IGNGREEK LOWER NUMERAL SIGNGREEK CAPITAL LETTER PAMPHYLIAN DIGAMMAGREEK " +
	"SMALL LETTER PAMPHYLIAN DIGAMMAGREEK YPOGEGRAMMENIGREEK SMALL REVERSED L" +
	"UNATE SIGMA SYMBOLGREEK SMALL DOTTED LUNATE SIGMA SYMBOLGREEK SMALL REVE" +
	"RSED DOTTED LUNATE SIGMA SYMBOLGREEK QUESTION MARKGREEK CAPITAL LETTER Y" +
	"OTGREEK TONOSGREEK DIALYTIKA TONOSGREEK CAPITAL LETTER ALPHA WITH TONOSG" +
	"REEK ANO TELEIAGREEK CAPITAL LETTER EPSILON WITH TONOSGREEK CAPITAL LETT" +
	"ER ETA WITH TONOSGREEK CAPITAL LETTER IOTA WITH TONOSGREEK CAPITAL LETTE" +
	"R OMICRON WITH TONOSGREEK CAPITAL LETTER UPSILON WITH TONOSGREEK CAPITAL" +
	" LETTER OMEGA WITH TONOSGREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS" +
	"GREEK CAPITAL LETTER ALPHAGREEK CAPITAL LETTER BETAGREEK CAPITAL LETTER " +
	"GAMMAGREEK CAPITAL LETTER DELTAGREEK CAPITAL LETTER EPSILONGREEK CAPITAL" +
	" LETTER ZETAGREEK CAPITAL LETTER ETAGREEK CAPITAL LETTER THETAGREEK CAPI" +
	"TAL LETTER IOTAGREEK CAPITAL LETTER KAPPAGREEK CAPITAL LETTER LAMDAGREEK" +
	" CAPITAL LETTER MUGREEK CAPITAL LETTER NUGREEK CAPITAL LETTER XIGREEK CA" +
	"PITAL LETTER OMICRONGREEK CAPITAL LETTER PIGREEK CAPITAL LETTER RHOGREEK" +
	" CAPITAL LETTER SIGMAGREEK CAPITAL LETTER TAUGREEK CAPITAL LETTER UPSILO" +
	"NGREEK CAPITAL LETTER PHIGREEK CAPITAL LETTER CHIGREEK CAPITAL LETTER PS" +
	"IGREEK CAPITAL LETTER OMEGAGREEK CAPITAL LETTER IOTA WITH DIALYTIKAGREEK" +
	" CAPITAL LETTER UPSILON WITH DIALYTIKAGREEK SMALL LETTER ALPHA WITH TONO" +
	"SGREEK SMALL LETTER EPSILON WITH TONOSGREEK SMALL LETTER ETA WITH TONOSG" +
	"REEK SMALL LETTER IOTA WITH TONOSGREEK SMALL LETTER UPSILON WITH DIALYTI" +
	"KA AND TONOSGREEK SMALL LETTER ALPHAGREEK SMALL LETTER BETAGREEK SMALL L" +
	"ETTER GAMMAGREEK SMALL LETTER DELTAGREEK SMALL LETTER EPSILONGREEK SMALL" +
	" LETTER ZETAGREEK SMALL LETTER ETAGREEK SMALL LETTER THETAGREEK SMALL LE" +
	"TTER IOTAGREEK SMALL LETTER KAPPAGREEK SMALL LETTER LAMDAGREEK SMALL LET" +
	"TER MUGREEK SMALL LETTER NUGREEK SMALL LETTER XIGREEK SMALL LETTER OMICR" +
	"ONGREEK SMALL LETTER PIGREEK SMALL LETTER RHOGREEK SMALL LETTER FINAL SI" +
	"GMAGREEK SMALL LETTER SIGMAGREEK SMALL LETTER TAUGREEK SMALL LETTER UPSI" +
	"LONGREEK SMALL LETTER PHIGREEK SMALL LETTER CHIGREEK SMALL LETTER PSIGRE" +
	"EK SMALL LETTER OMEGAGREEK SMALL LETTER IOTA WITH DIALYTIKAGREEK SMALL L" +
	"ETTER UPSILON WITH DIALYTIKAGREEK SMALL LETTER OMICRON WITH TONOSGREEK S" +
	"MALL LETTER UPSILON WITH TONOSGREEK SMALL LETTER OMEGA WITH TONOSGREEK C" +
	"APITAL KAI SYMBOLGREEK BETA SYMBOLGREEK THETA SYMBOLGREEK UPSILON WITH H" +
	"OOK SYMBOLGREEK UPSILON WITH ACUTE AND HOOK SYMBOLGREEK UPSILON WITH DIA" +
	"ERESIS AND HOOK SYMBOLGREEK PHI SYMBOLGREEK PI SYMBOLGREEK KAI SYMBOLGRE" +
	"EK LETTER ARCHAIC KOPPAGREEK SMALL LETTER ARCHAIC KOPPAGREEK LETTER STIG" +
	"MAGREEK SMALL LETTER STIGMAGREEK LETTER DIGAMMAGREEK SMALL LETTER DIGAMM" +
	"AGREEK LETTER KOPPAGREEK SMALL LETTER KOPPAGREEK LETTER SAMPIGREEK SMALL" +
	" LETTER SAMPICOPTIC CAPITAL LETTER SHEICOPTIC SMALL LETTER SHEICOPTIC CA" +
	"PITAL LETTER FEICOPTIC SMALL LETTER FEICOPTIC CAPITAL LETTER KHEICOPTIC " +
	"SMALL LETTER KHEICOPTIC CAPITAL LETTER HORICOPTIC SMALL LETTER HORICOPTI" +
	"C CAPITAL LETTER GANGIACOPTIC SMALL LETTER GANGIACOPTIC CAPITAL LETTER S" +
	"HIMACOPTIC SMALL LETTER SHIMACOPTIC CAPITAL LETTER DEICOPTIC SMALL LETTE" +
	"R DEIGREEK KAPPA SYMBOLGREEK RHO SYMBOLGREEK LUNATE SIGMA SYMBOLGREEK LE" +
	"TTER YOTGREEK CAPITAL THETA SYMBOLGREEK LUNATE EPSILON SYMBOLGREEK REVER" +
	"SED LUNATE EPSILON SYMBOLGREEK CAPITAL LETTER SHOGREEK SMALL LETTER SHOG" +
	"REEK CAPITAL LUNATE SIGMA SYMBOLGREEK CAPITAL LETTER SANGREEK SMALL LETT" +
	"ER SANGREEK RHO WITH STROKE SYMBOLGREEK CAPITAL REVERSED LUNATE SIGMA SY" +
	"MBOLGREEK CAPITAL DOTTED LUNATE SIGMA SYMBOLGREEK CAPITAL REVERSED DOTTE" +
	"D LUNATE SIGMA SYMBOLCYRILLIC CAPITAL LETTER IE WITH GRAVECYRILLIC CAPIT" +
	"AL LETTER IOCYRILLIC CAPITAL LETTER DJECYRILLIC CAPITAL LETTER GJECYRILL" +
	"IC CAPITAL LETTER UKRAINIAN IECYRILLIC CAPITAL LETTER DZECYRILLIC CAPITA") + ("" +
	"L LETTER BYELORUSSIAN-UKRAINIAN ICYRILLIC CAPITAL LETTER YICYRILLIC CAPI" +
	"TAL LETTER JECYRILLIC CAPITAL LETTER LJECYRILLIC CAPITAL LETTER NJECYRIL" +
	"LIC CAPITAL LETTER TSHECYRILLIC CAPITAL LETTER KJECYRILLIC CAPITAL LETTE" +
	"R I WITH GRAVECYRILLIC CAPITAL LETTER SHORT UCYRILLIC CAPITAL LETTER DZH" +
	"ECYRILLIC CAPITAL LETTER ACYRILLIC CAPITAL LETTER BECYRILLIC CAPITAL LET" +
	"TER VECYRILLIC CAPITAL LETTER GHECYRILLIC CAPITAL LETTER DECYRILLIC CAPI" +
	"TAL LETTER IECYRILLIC CAPITAL LETTER ZHECYRILLIC CAPITAL LETTER ZECYRILL" +
	"IC CAPITAL LETTER ICYRILLIC CAPITAL LETTER SHORT ICYRILLIC CAPITAL LETTE" +
	"R KACYRILLIC CAPITAL LETTER ELCYRILLIC CAPITAL LETTER EMCYRILLIC CAPITAL" +
	" LETTER ENCYRILLIC CAPITAL LETTER OCYRILLIC CAPITAL LETTER PECYRILLIC CA" +
	"PITAL LETTER ERCYRILLIC CAPITAL LETTER ESCYRILLIC CAPITAL LETTER TECYRIL" +
	"LIC CAPITAL LETTER UCYRILLIC CAPITAL LETTER EFCYRILLIC CAPITAL LETTER HA" +
	"CYRILLIC CAPITAL LETTER TSECYRILLIC CAPITAL LETTER CHECYRILLIC CAPITAL L" +
	"ETTER SHACYRILLIC CAPITAL LETTER SHCHACYRILLIC CAPITAL LETTER HARD SIGNC" +
	"YRILLIC CAPITAL LETTER YERUCYRILLIC CAPITAL LETTER SOFT SIGNCYRILLIC CAP" +
	"ITAL LETTER ECYRILLIC CAPITAL LETTER YUCYRILLIC CAPITAL LETTER YACYRILLI" +
	"C SMALL LETTER ACYRILLIC SMALL LETTER BECYRILLIC SMALL LETTER VECYRILLIC" +
	" SMALL LETTER GHECYRILLIC SMALL LETTER DECYRILLIC SMALL LETTER IECYRILLI" +
	"C SMALL LETTER ZHECYRILLIC SMALL LETTER ZECYRILLIC SMALL LETTER ICYRILLI" +
	"C SMALL LETTER SHORT ICYRILLIC SMALL LETTER KACYRILLIC SMALL LETTER ELCY" +
	"RILLIC SMALL LETTER EMCYRILLIC SMALL LETTER ENCYRILLIC SMALL LETTER OCYR" +
	"ILLIC SMALL LETTER PECYRILLIC SMALL LETTER ERCYRILLIC SMALL LETTER ESCYR" +
	"ILLIC SMALL LETTER TECYRILLIC SMALL LETTER UCYRILLIC SMALL LETTER EFCYRI" +
	"LLIC SMALL LETTER HACYRILLIC SMALL LETTER TSECYRILLIC SMALL LETTER CHECY" +
	"RILLIC SMALL LETTER SHACYRILLIC SMALL LETTER SHCHACYRILLIC SMALL LETTER " +
	"HARD SIGNCYRILLIC SMALL LETTER YERUCYRILLIC SMALL LETTER SOFT SIGNCYRILL" +
	"IC SMALL LETTER ECYRILLIC SMALL LETTER YUCYRILLIC SMALL LETTER YACYRILLI" +
	"C SMALL LETTER IE WITH GRAVECYRILLIC SMALL LETTER IOCYRILLIC SMALL LETTE" +
	"R DJECYRILLIC SMALL LETTER GJECYRILLIC SMALL LETTER UKRAINIAN IECYRILLIC" +
	" SMALL LETTER DZECYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN ICYRILLIC " +
	"SMALL LETTER YICYRILLIC SMALL LETTER JECYRILLIC SMALL LETTER LJECYRILLIC" +
	" SMALL LETTER NJECYRILLIC SMALL LETTER TSHECYRILLIC SMALL LETTER KJECYRI" +
	"LLIC SMALL LETTER I WITH GRAVECYRILLIC SMALL LETTER SHORT UCYRILLIC SMAL" +
	"L LETTER DZHECYRILLIC CAPITAL LETTER OMEGACYRILLIC SMALL LETTER OMEGACYR" +
	"ILLIC CAPITAL LETTER YATCYRILLIC SMALL LETTER YATCYRILLIC CAPITAL LETTER" +
	" IOTIFIED ECYRILLIC SMALL LETTER IOTIFIED ECYRILLIC CAPITAL LETTER LITTL" +
	"E YUSCYRILLIC SMALL LETTER LITTLE YUSCYRILLIC CAPITAL LETTER IOTIFIED LI" +
	"TTLE YUSCYRILLIC SMALL LETTER IOTIFIED LITTLE YUSCYRILLIC CAPITAL LETTER" +
	" BIG YUSCYRILLIC SMALL LETTER BIG YUSCYRILLIC CAPITAL LETTER IOTIFIED BI" +
	"G YUSCYRILLIC SMALL LETTER IOTIFIED BIG YUSCYRILLIC CAPITAL LETTER KSICY" +
	"RILLIC SMALL LETTER KSICYRILLIC CAPITAL LETTER PSICYRILLIC SMALL LETTER " +
	"PSICYRILLIC CAPITAL LETTER FITACYRILLIC SMALL LETTER FITACYRILLIC CAPITA" +
	"L LETTER IZHITSACYRILLIC SMALL LETTER IZHITSACYRILLIC CAPITAL LETTER IZH" +
	"ITSA WITH DOUBLE GRAVE ACCENTCYRILLIC SMALL LETTER IZHITSA WITH DOUBLE G" +
	"RAVE ACCENTCYRILLIC CAPITAL LETTER UKCYRILLIC SMALL LETTER UKCYRILLIC CA" +
	"PITAL LETTER ROUND OMEGACYRILLIC SMALL LETTER ROUND OMEGACYRILLIC CAPITA" +
	"L LETTER OMEGA WITH TITLOCYRILLIC SMALL LETTER OMEGA WITH TITLOCYRILLIC " +
	"CAPITAL LETTER OTCYRILLIC SMALL LETTER OTCYRILLIC CAPITAL LETTER KOPPACY" +
	"RILLIC SMALL LETTER KOPPACYRILLIC THOUSANDS SIGNCOMBINING CYRILLIC TITLO" +
	"COMBINING CYRILLIC PALATALIZATIONCOMBINING CYRILLIC DASIA PNEUMATACOMBIN" +
	"ING CYRILLIC PSILI PNEUMATACOMBINING CYRILLIC POKRYTIECOMBINING CYRILLIC" +
	" HUNDRED THOUSANDS SIGNCOMBINING CYRILLIC MILLIONS SIGNCYRILLIC CAPITAL " +
	"LETTER SHORT I WITH TAILCYRILLIC SMALL LETTER SHORT I WITH TAILCYRILLIC " +
	"CAPITAL LETTER SEMISOFT SIGNCYRILLIC SMALL LETTER SEMISOFT SIGNCYRILLIC " +
	"CAPITAL LETTER ER WITH TICKCYRILLIC SMALL LETTER ER WITH TICKCYRILLIC CA" +
	"PITAL LETTER GHE WITH UPTURNCYRILLIC SMALL LETTER GHE WITH UPTURNCYRILLI" +
	"C CAPITAL LETTER GHE WITH STROKECYRILLIC SMALL LETTER GHE WITH STROKECYR" +
	"ILLIC CAPITAL LETTER GHE WITH MIDDLE HOOKCYRILLIC SMALL LETTER GHE WITH " +
	"MIDDLE HOOKCYRILLIC CAPITAL LETTER ZHE WITH DESCENDERCYRILLIC SMALL LETT" +
	"ER ZHE WITH DESCENDERCYRILLIC CAPITAL LETTER ZE WITH DESCENDERCYRILLIC S" +
	"MALL LETTER ZE WITH DESCENDERCYRILLIC CAPITAL LETTER KA WITH DESCENDERCY" +
	"RILLIC SMALL LETTER KA WITH DESCENDERCYRILLIC CAPITAL LETTER KA WITH VER" +
	"TICAL STROKECYRILLIC SMALL LETTER KA WITH VERTICAL STROKECYRILLIC CAPITA" +
	"L LETTER KA WITH STROKECYRILLIC SMALL LETTER KA WITH STROKECYRILLIC CAPI") + ("" +
	"TAL LETTER BASHKIR KACYRILLIC SMALL LETTER BASHKIR KACYRILLIC CAPITAL LE" +
	"TTER EN WITH DESCENDERCYRILLIC SMALL LETTER EN WITH DESCENDERCYRILLIC CA" +
	"PITAL LIGATURE EN GHECYRILLIC SMALL LIGATURE EN GHECYRILLIC CAPITAL LETT" +
	"ER PE WITH MIDDLE HOOKCYRILLIC SMALL LETTER PE WITH MIDDLE HOOKCYRILLIC " +
	"CAPITAL LETTER ABKHASIAN HACYRILLIC SMALL LETTER ABKHASIAN HACYRILLIC CA" +
	"PITAL LETTER ES WITH DESCENDERCYRILLIC SMALL LETTER ES WITH DESCENDERCYR" +
	"ILLIC CAPITAL LETTER TE WITH DESCENDERCYRILLIC SMALL LETTER TE WITH DESC" +
	"ENDERCYRILLIC CAPITAL LETTER STRAIGHT UCYRILLIC SMALL LETTER STRAIGHT UC" +
	"YRILLIC CAPITAL LETTER STRAIGHT U WITH STROKECYRILLIC SMALL LETTER STRAI" +
	"GHT U WITH STROKECYRILLIC CAPITAL LETTER HA WITH DESCENDERCYRILLIC SMALL" +
	" LETTER HA WITH DESCENDERCYRILLIC CAPITAL LIGATURE TE TSECYRILLIC SMALL " +
	"LIGATURE TE TSECYRILLIC CAPITAL LETTER CHE WITH DESCENDERCYRILLIC SMALL " +
	"LETTER CHE WITH DESCENDERCYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROK" +
	"ECYRILLIC SMALL LETTER CHE WITH VERTICAL STROKECYRILLIC CAPITAL LETTER S" +
	"HHACYRILLIC SMALL LETTER SHHACYRILLIC CAPITAL LETTER ABKHASIAN CHECYRILL" +
	"IC SMALL LETTER ABKHASIAN CHECYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH " +
	"DESCENDERCYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDERCYRILLIC LETT" +
	"ER PALOCHKACYRILLIC CAPITAL LETTER ZHE WITH BREVECYRILLIC SMALL LETTER Z" +
	"HE WITH BREVECYRILLIC CAPITAL LETTER KA WITH HOOKCYRILLIC SMALL LETTER K" +
	"A WITH HOOKCYRILLIC CAPITAL LETTER EL WITH TAILCYRILLIC SMALL LETTER EL " +
	"WITH TAILCYRILLIC CAPITAL LETTER EN WITH HOOKCYRILLIC SMALL LETTER EN WI" +
	"TH HOOKCYRILLIC CAPITAL LETTER EN WITH TAILCYRILLIC SMALL LETTER EN WITH" +
	" TAILCYRILLIC CAPITAL LETTER KHAKASSIAN CHECYRILLIC SMALL LETTER KHAKASS" +
	"IAN CHECYRILLIC CAPITAL LETTER EM WITH TAILCYRILLIC SMALL LETTER EM WITH" +
	" TAILCYRILLIC SMALL LETTER PALOCHKACYRILLIC CAPITAL LETTER A WITH BREVEC" +
	"YRILLIC SMALL LETTER A WITH BREVECYRILLIC CAPITAL LETTER A WITH DIAERESI" +
	"SCYRILLIC SMALL LETTER A WITH DIAERESISCYRILLIC CAPITAL LIGATURE A IECYR" +
	"ILLIC SMALL LIGATURE A IECYRILLIC CAPITAL LETTER IE WITH BREVECYRILLIC S" +
	"MALL LETTER IE WITH BREVECYRILLIC CAPITAL LETTER SCHWACYRILLIC SMALL LET" +
	"TER SCHWACYRILLIC CAPITAL LETTER SCHWA WITH DIAERESISCYRILLIC SMALL LETT" +
	"ER SCHWA WITH DIAERESISCYRILLIC CAPITAL LETTER ZHE WITH DIAERESISCYRILLI" +
	"C SMALL LETTER ZHE WITH DIAERESISCYRILLIC CAPITAL LETTER ZE WITH DIAERES" +
	"ISCYRILLIC SMALL LETTER ZE WITH DIAERESISCYRILLIC CAPITAL LETTER ABKHASI" +
	"AN DZECYRILLIC SMALL LETTER ABKHASIAN DZECYRILLIC CAPITAL LETTER I WITH " +
	"MACRONCYRILLIC SMALL LETTER I WITH MACRONCYRILLIC CAPITAL LETTER I WITH " +
	"DIAERESISCYRILLIC SMALL LETTER I WITH DIAERESISCYRILLIC CAPITAL LETTER O" +
	" WITH DIAERESISCYRILLIC SMALL LETTER O WITH DIAERESISCYRILLIC CAPITAL LE" +
	"TTER BARRED OCYRILLIC SMALL LETTER BARRED OCYRILLIC CAPITAL LETTER BARRE" +
	"D O WITH DIAERESISCYRILLIC SMALL LETTER BARRED O WITH DIAERESISCYRILLIC " +
	"CAPITAL LETTER E WITH DIAERESISCYRILLIC SMALL LETTER E WITH DIAERESISCYR" +
	"ILLIC CAPITAL LETTER U WITH MACRONCYRILLIC SMALL LETTER U WITH MACRONCYR" +
	"ILLIC CAPITAL LETTER U WITH DIAERESISCYRILLIC SMALL LETTER U WITH DIAERE" +
	"SISCYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTECYRILLIC SMALL LETTER U WI" +
	"TH DOUBLE ACUTECYRILLIC CAPITAL LETTER CHE WITH DIAERESISCYRILLIC SMALL " +
	"LETTER CHE WITH DIAERESISCYRILLIC CAPITAL LETTER GHE WITH DESCENDERCYRIL" +
	"LIC SMALL LETTER GHE WITH DESCENDERCYRILLIC CAPITAL LETTER YERU WITH DIA" +
	"ERESISCYRILLIC SMALL LETTER YERU WITH DIAERESISCYRILLIC CAPITAL LETTER G" +
	"HE WITH STROKE AND HOOKCYRILLIC SMALL LETTER GHE WITH STROKE AND HOOKCYR" +
	"ILLIC CAPITAL LETTER HA WITH HOOKCYRILLIC SMALL LETTER HA WITH HOOKCYRIL" +
	"LIC CAPITAL LETTER HA WITH STROKECYRILLIC SMALL LETTER HA WITH STROKECYR" +
	"ILLIC CAPITAL LETTER KOMI DECYRILLIC SMALL LETTER KOMI DECYRILLIC CAPITA" +
	"L LETTER KOMI DJECYRILLIC SMALL LETTER KOMI DJECYRILLIC CAPITAL LETTER K" +
	"OMI ZJECYRILLIC SMALL LETTER KOMI ZJECYRILLIC CAPITAL LETTER KOMI DZJECY" +
	"RILLIC SMALL LETTER KOMI DZJECYRILLIC CAPITAL LETTER KOMI LJECYRILLIC SM" +
	"ALL LETTER KOMI LJECYRILLIC CAPITAL LETTER KOMI NJECYRILLIC SMALL LETTER" +
	" KOMI NJECYRILLIC CAPITAL LETTER KOMI SJECYRILLIC SMALL LETTER KOMI SJEC" +
	"YRILLIC CAPITAL LETTER KOMI TJECYRILLIC SMALL LETTER KOMI TJECYRILLIC CA" +
	"PITAL LETTER REVERSED ZECYRILLIC SMALL LETTER REVERSED ZECYRILLIC CAPITA" +
	"L LETTER EL WITH HOOKCYRILLIC SMALL LETTER EL WITH HOOKCYRILLIC CAPITAL " +
	"LETTER LHACYRILLIC SMALL LETTER LHACYRILLIC CAPITAL LETTER RHACYRILLIC S" +
	"MALL LETTER RHACYRILLIC CAPITAL LETTER YAECYRILLIC SMALL LETTER YAECYRIL" +
	"LIC CAPITAL LETTER QACYRILLIC SMALL LETTER QACYRILLIC CAPITAL LETTER WEC" +
	"YRILLIC SMALL LETTER WECYRILLIC CAPITAL LETTER ALEUT KACYRILLIC SMALL LE" +
	"TTER ALEUT KACYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOKCYRILLIC SMALL L") + ("" +
	"ETTER EL WITH MIDDLE HOOKCYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOKCYRI" +
	"LLIC SMALL LETTER EN WITH MIDDLE HOOKCYRILLIC CAPITAL LETTER PE WITH DES" +
	"CENDERCYRILLIC SMALL LETTER PE WITH DESCENDERCYRILLIC CAPITAL LETTER SHH" +
	"A WITH DESCENDERCYRILLIC SMALL LETTER SHHA WITH DESCENDERCYRILLIC CAPITA" +
	"L LETTER EN WITH LEFT HOOKCYRILLIC SMALL LETTER EN WITH LEFT HOOKCYRILLI" +
	"C CAPITAL LETTER DZZHECYRILLIC SMALL LETTER DZZHECYRILLIC CAPITAL LETTER" +
	" DCHECYRILLIC SMALL LETTER DCHECYRILLIC CAPITAL LETTER EL WITH DESCENDER" +
	"CYRILLIC SMALL LETTER EL WITH DESCENDERARMENIAN CAPITAL LETTER AYBARMENI" +
	"AN CAPITAL LETTER BENARMENIAN CAPITAL LETTER GIMARMENIAN CAPITAL LETTER " +
	"DAARMENIAN CAPITAL LETTER ECHARMENIAN CAPITAL LETTER ZAARMENIAN CAPITAL " +
	"LETTER EHARMENIAN CAPITAL LETTER ETARMENIAN CAPITAL LETTER TOARMENIAN CA" +
	"PITAL LETTER ZHEARMENIAN CAPITAL LETTER INIARMENIAN CAPITAL LETTER LIWNA" +
	"RMENIAN CAPITAL LETTER XEHARMENIAN CAPITAL LETTER CAARMENIAN CAPITAL LET" +
	"TER KENARMENIAN CAPITAL LETTER HOARMENIAN CAPITAL LETTER JAARMENIAN CAPI" +
	"TAL LETTER GHADARMENIAN CAPITAL LETTER CHEHARMENIAN CAPITAL LETTER MENAR" +
	"MENIAN CAPITAL LETTER YIARMENIAN CAPITAL LETTER NOWARMENIAN CAPITAL LETT" +
	"ER SHAARMENIAN CAPITAL LETTER VOARMENIAN CAPITAL LETTER CHAARMENIAN CAPI" +
	"TAL LETTER PEHARMENIAN CAPITAL LETTER JHEHARMENIAN CAPITAL LETTER RAARME" +
	"NIAN CAPITAL LETTER SEHARMENIAN CAPITAL LETTER VEWARMENIAN CAPITAL LETTE" +
	"R TIWNARMENIAN CAPITAL LETTER REHARMENIAN CAPITAL LETTER COARMENIAN CAPI" +
	"TAL LETTER YIWNARMENIAN CAPITAL LETTER PIWRARMENIAN CAPITAL LETTER KEHAR" +
	"MENIAN CAPITAL LETTER OHARMENIAN CAPITAL LETTER FEHARMENIAN MODIFIER LET" +
	"TER LEFT HALF RINGARMENIAN APOSTROPHEARMENIAN EMPHASIS MARKARMENIAN EXCL" +
	"AMATION MARKARMENIAN COMMAARMENIAN QUESTION MARKARMENIAN ABBREVIATION MA" +
	"RKARMENIAN SMALL LETTER TURNED AYBARMENIAN SMALL LETTER AYBARMENIAN SMAL" +
	"L LETTER BENARMENIAN SMALL LETTER GIMARMENIAN SMALL LETTER DAARMENIAN SM" +
	"ALL LETTER ECHARMENIAN SMALL LETTER ZAARMENIAN SMALL LETTER EHARMENIAN S" +
	"MALL LETTER ETARMENIAN SMALL LETTER TOARMENIAN SMALL LETTER ZHEARMENIAN " +
	"SMALL LETTER INIARMENIAN SMALL LETTER LIWNARMENIAN SMALL LETTER XEHARMEN" +
	"IAN SMALL LETTER CAARMENIAN SMALL LETTER KENARMENIAN SMALL LETTER HOARME" +
	"NIAN SMALL LETTER JAARMENIAN SMALL LETTER GHADARMENIAN SMALL LETTER CHEH" +
	"ARMENIAN SMALL LETTER MENARMENIAN SMALL LETTER YIARMENIAN SMALL LETTER N" +
	"OWARMENIAN SMALL LETTER SHAARMENIAN SMALL LETTER VOARMENIAN SMALL LETTER" +
	" CHAARMENIAN SMALL LETTER PEHARMENIAN SMALL LETTER JHEHARMENIAN SMALL LE" +
	"TTER RAARMENIAN SMALL LETTER SEHARMENIAN SMALL LETTER VEWARMENIAN SMALL " +
	"LETTER TIWNARMENIAN SMALL LETTER REHARMENIAN SMALL LETTER COARMENIAN SMA" +
	"LL LETTER YIWNARMENIAN SMALL LETTER PIWRARMENIAN SMALL LETTER KEHARMENIA" +
	"N SMALL LETTER OHARMENIAN SMALL LETTER FEHARMENIAN SMALL LIGATURE ECH YI" +
	"WNARMENIAN SMALL LETTER YI WITH STROKEARMENIAN FULL STOPARMENIAN HYPHENR" +
	"IGHT-FACING ARMENIAN ETERNITY SIGNLEFT-FACING ARMENIAN ETERNITY SIGNARME" +
	"NIAN DRAM SIGNHEBREW ACCENT ETNAHTAHEBREW ACCENT SEGOLHEBREW ACCENT SHAL" +
	"SHELETHEBREW ACCENT ZAQEF QATANHEBREW ACCENT ZAQEF GADOLHEBREW ACCENT TI" +
	"PEHAHEBREW ACCENT REVIAHEBREW ACCENT ZARQAHEBREW ACCENT PASHTAHEBREW ACC" +
	"ENT YETIVHEBREW ACCENT TEVIRHEBREW ACCENT GERESHHEBREW ACCENT GERESH MUQ" +
	"DAMHEBREW ACCENT GERSHAYIMHEBREW ACCENT QARNEY PARAHEBREW ACCENT TELISHA" +
	" GEDOLAHEBREW ACCENT PAZERHEBREW ACCENT ATNAH HAFUKHHEBREW ACCENT MUNAHH" +
	"EBREW ACCENT MAHAPAKHHEBREW ACCENT MERKHAHEBREW ACCENT MERKHA KEFULAHEBR" +
	"EW ACCENT DARGAHEBREW ACCENT QADMAHEBREW ACCENT TELISHA QETANAHEBREW ACC" +
	"ENT YERAH BEN YOMOHEBREW ACCENT OLEHEBREW ACCENT ILUYHEBREW ACCENT DEHIH" +
	"EBREW ACCENT ZINORHEBREW MARK MASORA CIRCLEHEBREW POINT SHEVAHEBREW POIN" +
	"T HATAF SEGOLHEBREW POINT HATAF PATAHHEBREW POINT HATAF QAMATSHEBREW POI" +
	"NT HIRIQHEBREW POINT TSEREHEBREW POINT SEGOLHEBREW POINT PATAHHEBREW POI" +
	"NT QAMATSHEBREW POINT HOLAMHEBREW POINT HOLAM HASER FOR VAVHEBREW POINT " +
	"QUBUTSHEBREW POINT DAGESH OR MAPIQHEBREW POINT METEGHEBREW PUNCTUATION M" +
	"AQAFHEBREW POINT RAFEHEBREW PUNCTUATION PASEQHEBREW POINT SHIN DOTHEBREW" +
	" POINT SIN DOTHEBREW PUNCTUATION SOF PASUQHEBREW MARK UPPER DOTHEBREW MA" +
	"RK LOWER DOTHEBREW PUNCTUATION NUN HAFUKHAHEBREW POINT QAMATS QATANHEBRE" +
	"W LETTER ALEFHEBREW LETTER BETHEBREW LETTER GIMELHEBREW LETTER DALETHEBR" +
	"EW LETTER HEHEBREW LETTER VAVHEBREW LETTER ZAYINHEBREW LETTER HETHEBREW " +
	"LETTER TETHEBREW LETTER YODHEBREW LETTER FINAL KAFHEBREW LETTER KAFHEBRE" +
	"W LETTER LAMEDHEBREW LETTER FINAL MEMHEBREW LETTER MEMHEBREW LETTER FINA" +
	"L NUNHEBREW LETTER NUNHEBREW LETTER SAMEKHHEBREW LETTER AYINHEBREW LETTE" +
	"R FINAL PEHEBREW LETTER PEHEBREW LETTER FINAL TSADIHEBREW LETTER TSADIHE" +
	"BREW LETTER QOFHEBREW LETTER RESHHEBREW LETTER SHINHEBREW LETTER TAVHEBR") + ("" +
	"EW YOD TRIANGLEHEBREW LIGATURE YIDDISH DOUBLE VAVHEBREW LIGATURE YIDDISH" +
	" VAV YODHEBREW LIGATURE YIDDISH DOUBLE YODHEBREW PUNCTUATION GERESHHEBRE" +
	"W PUNCTUATION GERSHAYIMARABIC NUMBER SIGNARABIC SIGN SANAHARABIC FOOTNOT" +
	"E MARKERARABIC SIGN SAFHAARABIC SIGN SAMVATARABIC NUMBER MARK ABOVEARABI" +
	"C-INDIC CUBE ROOTARABIC-INDIC FOURTH ROOTARABIC RAYARABIC-INDIC PER MILL" +
	"E SIGNARABIC-INDIC PER TEN THOUSAND SIGNAFGHANI SIGNARABIC COMMAARABIC D" +
	"ATE SEPARATORARABIC POETIC VERSE SIGNARABIC SIGN MISRAARABIC SIGN SALLAL" +
	"LAHOU ALAYHE WASSALLAMARABIC SIGN ALAYHE ASSALLAMARABIC SIGN RAHMATULLAH" +
	" ALAYHEARABIC SIGN RADI ALLAHOU ANHUARABIC SIGN TAKHALLUSARABIC SMALL HI" +
	"GH TAHARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEHARABIC SMALL HIGH" +
	" ZAINARABIC SMALL FATHAARABIC SMALL DAMMAARABIC SMALL KASRAARABIC SEMICO" +
	"LONARABIC LETTER MARKARABIC TRIPLE DOT PUNCTUATION MARKARABIC QUESTION M" +
	"ARKARABIC LETTER KASHMIRI YEHARABIC LETTER HAMZAARABIC LETTER ALEF WITH " +
	"MADDA ABOVEARABIC LETTER ALEF WITH HAMZA ABOVEARABIC LETTER WAW WITH HAM" +
	"ZA ABOVEARABIC LETTER ALEF WITH HAMZA BELOWARABIC LETTER YEH WITH HAMZA " +
	"ABOVEARABIC LETTER ALEFARABIC LETTER BEHARABIC LETTER TEH MARBUTAARABIC " +
	"LETTER TEHARABIC LETTER THEHARABIC LETTER JEEMARABIC LETTER HAHARABIC LE" +
	"TTER KHAHARABIC LETTER DALARABIC LETTER THALARABIC LETTER REHARABIC LETT" +
	"ER ZAINARABIC LETTER SEENARABIC LETTER SHEENARABIC LETTER SADARABIC LETT" +
	"ER DADARABIC LETTER TAHARABIC LETTER ZAHARABIC LETTER AINARABIC LETTER G" +
	"HAINARABIC LETTER KEHEH WITH TWO DOTS ABOVEARABIC LETTER KEHEH WITH THRE" +
	"E DOTS BELOWARABIC LETTER FARSI YEH WITH INVERTED VARABIC LETTER FARSI Y" +
	"EH WITH TWO DOTS ABOVEARABIC LETTER FARSI YEH WITH THREE DOTS ABOVEARABI" +
	"C TATWEELARABIC LETTER FEHARABIC LETTER QAFARABIC LETTER KAFARABIC LETTE" +
	"R LAMARABIC LETTER MEEMARABIC LETTER NOONARABIC LETTER HEHARABIC LETTER " +
	"WAWARABIC LETTER ALEF MAKSURAARABIC LETTER YEHARABIC FATHATANARABIC DAMM" +
	"ATANARABIC KASRATANARABIC FATHAARABIC DAMMAARABIC KASRAARABIC SHADDAARAB" +
	"IC SUKUNARABIC MADDAH ABOVEARABIC HAMZA ABOVEARABIC HAMZA BELOWARABIC SU" +
	"BSCRIPT ALEFARABIC INVERTED DAMMAARABIC MARK NOON GHUNNAARABIC ZWARAKAYA" +
	"RABIC VOWEL SIGN SMALL V ABOVEARABIC VOWEL SIGN INVERTED SMALL V ABOVEAR" +
	"ABIC VOWEL SIGN DOT BELOWARABIC REVERSED DAMMAARABIC FATHA WITH TWO DOTS" +
	"ARABIC WAVY HAMZA BELOWARABIC-INDIC DIGIT ZEROARABIC-INDIC DIGIT ONEARAB" +
	"IC-INDIC DIGIT TWOARABIC-INDIC DIGIT THREEARABIC-INDIC DIGIT FOURARABIC-" +
	"INDIC DIGIT FIVEARABIC-INDIC DIGIT SIXARABIC-INDIC DIGIT SEVENARABIC-IND" +
	"IC DIGIT EIGHTARABIC-INDIC DIGIT NINEARABIC PERCENT SIGNARABIC DECIMAL S" +
	"EPARATORARABIC THOUSANDS SEPARATORARABIC FIVE POINTED STARARABIC LETTER " +
	"DOTLESS BEHARABIC LETTER DOTLESS QAFARABIC LETTER SUPERSCRIPT ALEFARABIC" +
	" LETTER ALEF WASLAARABIC LETTER ALEF WITH WAVY HAMZA ABOVEARABIC LETTER " +
	"ALEF WITH WAVY HAMZA BELOWARABIC LETTER HIGH HAMZAARABIC LETTER HIGH HAM" +
	"ZA ALEFARABIC LETTER HIGH HAMZA WAWARABIC LETTER U WITH HAMZA ABOVEARABI" +
	"C LETTER HIGH HAMZA YEHARABIC LETTER TTEHARABIC LETTER TTEHEHARABIC LETT" +
	"ER BEEHARABIC LETTER TEH WITH RINGARABIC LETTER TEH WITH THREE DOTS ABOV" +
	"E DOWNWARDSARABIC LETTER PEHARABIC LETTER TEHEHARABIC LETTER BEHEHARABIC" +
	" LETTER HAH WITH HAMZA ABOVEARABIC LETTER HAH WITH TWO DOTS VERTICAL ABO" +
	"VEARABIC LETTER NYEHARABIC LETTER DYEHARABIC LETTER HAH WITH THREE DOTS " +
	"ABOVEARABIC LETTER TCHEHARABIC LETTER TCHEHEHARABIC LETTER DDALARABIC LE" +
	"TTER DAL WITH RINGARABIC LETTER DAL WITH DOT BELOWARABIC LETTER DAL WITH" +
	" DOT BELOW AND SMALL TAHARABIC LETTER DAHALARABIC LETTER DDAHALARABIC LE" +
	"TTER DULARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDSARABIC LETTER D" +
	"AL WITH FOUR DOTS ABOVEARABIC LETTER RREHARABIC LETTER REH WITH SMALL VA" +
	"RABIC LETTER REH WITH RINGARABIC LETTER REH WITH DOT BELOWARABIC LETTER " +
	"REH WITH SMALL V BELOWARABIC LETTER REH WITH DOT BELOW AND DOT ABOVEARAB" +
	"IC LETTER REH WITH TWO DOTS ABOVEARABIC LETTER JEHARABIC LETTER REH WITH" +
	" FOUR DOTS ABOVEARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVEARABIC LE" +
	"TTER SEEN WITH THREE DOTS BELOWARABIC LETTER SEEN WITH THREE DOTS BELOW " +
	"AND THREE DOTS ABOVEARABIC LETTER SAD WITH TWO DOTS BELOWARABIC LETTER S" +
	"AD WITH THREE DOTS ABOVEARABIC LETTER TAH WITH THREE DOTS ABOVEARABIC LE" +
	"TTER AIN WITH THREE DOTS ABOVEARABIC LETTER DOTLESS FEHARABIC LETTER FEH" +
	" WITH DOT MOVED BELOWARABIC LETTER FEH WITH DOT BELOWARABIC LETTER VEHAR" +
	"ABIC LETTER FEH WITH THREE DOTS BELOWARABIC LETTER PEHEHARABIC LETTER QA" +
	"F WITH DOT ABOVEARABIC LETTER QAF WITH THREE DOTS ABOVEARABIC LETTER KEH" +
	"EHARABIC LETTER SWASH KAFARABIC LETTER KAF WITH RINGARABIC LETTER KAF WI" +
	"TH DOT ABOVEARABIC LETTER NGARABIC LETTER KAF WITH THREE DOTS BELOWARABI" +
	"C LETTER GAFARABIC LETTER GAF WITH RINGARABIC LETTER NGOEHARABIC LETTER ") + ("" +
	"GAF WITH TWO DOTS BELOWARABIC LETTER GUEHARABIC LETTER GAF WITH THREE DO" +
	"TS ABOVEARABIC LETTER LAM WITH SMALL VARABIC LETTER LAM WITH DOT ABOVEAR" +
	"ABIC LETTER LAM WITH THREE DOTS ABOVEARABIC LETTER LAM WITH THREE DOTS B" +
	"ELOWARABIC LETTER NOON WITH DOT BELOWARABIC LETTER NOON GHUNNAARABIC LET" +
	"TER RNOONARABIC LETTER NOON WITH RINGARABIC LETTER NOON WITH THREE DOTS " +
	"ABOVEARABIC LETTER HEH DOACHASHMEEARABIC LETTER TCHEH WITH DOT ABOVEARAB" +
	"IC LETTER HEH WITH YEH ABOVEARABIC LETTER HEH GOALARABIC LETTER HEH GOAL" +
	" WITH HAMZA ABOVEARABIC LETTER TEH MARBUTA GOALARABIC LETTER WAW WITH RI" +
	"NGARABIC LETTER KIRGHIZ OEARABIC LETTER OEARABIC LETTER UARABIC LETTER Y" +
	"UARABIC LETTER KIRGHIZ YUARABIC LETTER WAW WITH TWO DOTS ABOVEARABIC LET" +
	"TER VEARABIC LETTER FARSI YEHARABIC LETTER YEH WITH TAILARABIC LETTER YE" +
	"H WITH SMALL VARABIC LETTER WAW WITH DOT ABOVEARABIC LETTER EARABIC LETT" +
	"ER YEH WITH THREE DOTS BELOWARABIC LETTER YEH BARREEARABIC LETTER YEH BA" +
	"RREE WITH HAMZA ABOVEARABIC FULL STOPARABIC LETTER AEARABIC SMALL HIGH L" +
	"IGATURE SAD WITH LAM WITH ALEF MAKSURAARABIC SMALL HIGH LIGATURE QAF WIT" +
	"H LAM WITH ALEF MAKSURAARABIC SMALL HIGH MEEM INITIAL FORMARABIC SMALL H" +
	"IGH LAM ALEFARABIC SMALL HIGH JEEMARABIC SMALL HIGH THREE DOTSARABIC SMA" +
	"LL HIGH SEENARABIC END OF AYAHARABIC START OF RUB EL HIZBARABIC SMALL HI" +
	"GH ROUNDED ZEROARABIC SMALL HIGH UPRIGHT RECTANGULAR ZEROARABIC SMALL HI" +
	"GH DOTLESS HEAD OF KHAHARABIC SMALL HIGH MEEM ISOLATED FORMARABIC SMALL " +
	"LOW SEENARABIC SMALL HIGH MADDAARABIC SMALL WAWARABIC SMALL YEHARABIC SM" +
	"ALL HIGH YEHARABIC SMALL HIGH NOONARABIC PLACE OF SAJDAHARABIC EMPTY CEN" +
	"TRE LOW STOPARABIC EMPTY CENTRE HIGH STOPARABIC ROUNDED HIGH STOP WITH F" +
	"ILLED CENTREARABIC SMALL LOW MEEMARABIC LETTER DAL WITH INVERTED VARABIC" +
	" LETTER REH WITH INVERTED VEXTENDED ARABIC-INDIC DIGIT ZEROEXTENDED ARAB" +
	"IC-INDIC DIGIT ONEEXTENDED ARABIC-INDIC DIGIT TWOEXTENDED ARABIC-INDIC D" +
	"IGIT THREEEXTENDED ARABIC-INDIC DIGIT FOUREXTENDED ARABIC-INDIC DIGIT FI" +
	"VEEXTENDED ARABIC-INDIC DIGIT SIXEXTENDED ARABIC-INDIC DIGIT SEVENEXTEND" +
	"ED ARABIC-INDIC DIGIT EIGHTEXTENDED ARABIC-INDIC DIGIT NINEARABIC LETTER" +
	" SHEEN WITH DOT BELOWARABIC LETTER DAD WITH DOT BELOWARABIC LETTER GHAIN" +
	" WITH DOT BELOWARABIC SIGN SINDHI AMPERSANDARABIC SIGN SINDHI POSTPOSITI" +
	"ON MENARABIC LETTER HEH WITH INVERTED VSYRIAC END OF PARAGRAPHSYRIAC SUP" +
	"RALINEAR FULL STOPSYRIAC SUBLINEAR FULL STOPSYRIAC SUPRALINEAR COLONSYRI" +
	"AC SUBLINEAR COLONSYRIAC HORIZONTAL COLONSYRIAC COLON SKEWED LEFTSYRIAC " +
	"COLON SKEWED RIGHTSYRIAC SUPRALINEAR COLON SKEWED LEFTSYRIAC SUBLINEAR C" +
	"OLON SKEWED RIGHTSYRIAC CONTRACTIONSYRIAC HARKLEAN OBELUSSYRIAC HARKLEAN" +
	" METOBELUSSYRIAC HARKLEAN ASTERISCUSSYRIAC ABBREVIATION MARKSYRIAC LETTE" +
	"R ALAPHSYRIAC LETTER SUPERSCRIPT ALAPHSYRIAC LETTER BETHSYRIAC LETTER GA" +
	"MALSYRIAC LETTER GAMAL GARSHUNISYRIAC LETTER DALATHSYRIAC LETTER DOTLESS" +
	" DALATH RISHSYRIAC LETTER HESYRIAC LETTER WAWSYRIAC LETTER ZAINSYRIAC LE" +
	"TTER HETHSYRIAC LETTER TETHSYRIAC LETTER TETH GARSHUNISYRIAC LETTER YUDH" +
	"SYRIAC LETTER YUDH HESYRIAC LETTER KAPHSYRIAC LETTER LAMADHSYRIAC LETTER" +
	" MIMSYRIAC LETTER NUNSYRIAC LETTER SEMKATHSYRIAC LETTER FINAL SEMKATHSYR" +
	"IAC LETTER ESYRIAC LETTER PESYRIAC LETTER REVERSED PESYRIAC LETTER SADHE" +
	"SYRIAC LETTER QAPHSYRIAC LETTER RISHSYRIAC LETTER SHINSYRIAC LETTER TAWS" +
	"YRIAC LETTER PERSIAN BHETHSYRIAC LETTER PERSIAN GHAMALSYRIAC LETTER PERS" +
	"IAN DHALATHSYRIAC PTHAHA ABOVESYRIAC PTHAHA BELOWSYRIAC PTHAHA DOTTEDSYR" +
	"IAC ZQAPHA ABOVESYRIAC ZQAPHA BELOWSYRIAC ZQAPHA DOTTEDSYRIAC RBASA ABOV" +
	"ESYRIAC RBASA BELOWSYRIAC DOTTED ZLAMA HORIZONTALSYRIAC DOTTED ZLAMA ANG" +
	"ULARSYRIAC HBASA ABOVESYRIAC HBASA BELOWSYRIAC HBASA-ESASA DOTTEDSYRIAC " +
	"ESASA ABOVESYRIAC ESASA BELOWSYRIAC RWAHASYRIAC FEMININE DOTSYRIAC QUSHS" +
	"HAYASYRIAC RUKKAKHASYRIAC TWO VERTICAL DOTS ABOVESYRIAC TWO VERTICAL DOT" +
	"S BELOWSYRIAC THREE DOTS ABOVESYRIAC THREE DOTS BELOWSYRIAC OBLIQUE LINE" +
	" ABOVESYRIAC OBLIQUE LINE BELOWSYRIAC MUSICSYRIAC BARREKHSYRIAC LETTER S" +
	"OGDIAN ZHAINSYRIAC LETTER SOGDIAN KHAPHSYRIAC LETTER SOGDIAN FEARABIC LE" +
	"TTER BEH WITH THREE DOTS HORIZONTALLY BELOWARABIC LETTER BEH WITH DOT BE" +
	"LOW AND THREE DOTS ABOVEARABIC LETTER BEH WITH THREE DOTS POINTING UPWAR" +
	"DS BELOWARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO" +
	" DOTS ABOVEARABIC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVEARABIC LET" +
	"TER BEH WITH INVERTED SMALL V BELOWARABIC LETTER BEH WITH SMALL VARABIC " +
	"LETTER HAH WITH TWO DOTS ABOVEARABIC LETTER HAH WITH THREE DOTS POINTING" +
	" UPWARDS BELOWARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL" +
	" TAHARABIC LETTER DAL WITH INVERTED SMALL V BELOWARABIC LETTER REH WITH " +
	"STROKEARABIC LETTER SEEN WITH FOUR DOTS ABOVEARABIC LETTER AIN WITH TWO ") + ("" +
	"DOTS ABOVEARABIC LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVEARAB" +
	"IC LETTER AIN WITH TWO DOTS VERTICALLY ABOVEARABIC LETTER FEH WITH TWO D" +
	"OTS BELOWARABIC LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOWARABIC " +
	"LETTER KEHEH WITH DOT ABOVEARABIC LETTER KEHEH WITH THREE DOTS ABOVEARAB" +
	"IC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS BELOWARABIC LETTER MEEM" +
	" WITH DOT ABOVEARABIC LETTER MEEM WITH DOT BELOWARABIC LETTER NOON WITH " +
	"TWO DOTS BELOWARABIC LETTER NOON WITH SMALL TAHARABIC LETTER NOON WITH S" +
	"MALL VARABIC LETTER LAM WITH BARARABIC LETTER REH WITH TWO DOTS VERTICAL" +
	"LY ABOVEARABIC LETTER REH WITH HAMZA ABOVEARABIC LETTER SEEN WITH TWO DO" +
	"TS VERTICALLY ABOVEARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH BELOWA" +
	"RABIC LETTER HAH WITH SMALL ARABIC LETTER TAH AND TWO DOTSARABIC LETTER " +
	"SEEN WITH SMALL ARABIC LETTER TAH AND TWO DOTSARABIC LETTER REH WITH SMA" +
	"LL ARABIC LETTER TAH AND TWO DOTSARABIC LETTER HAH WITH SMALL ARABIC LET" +
	"TER TAH ABOVEARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT TWO ABO" +
	"VEARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVEARABIC " +
	"LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVEARABIC LETTER" +
	" FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVEARABIC LETTER FAR" +
	"SI YEH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOWARABIC LETTER WAW WITH" +
	" EXTENDED ARABIC-INDIC DIGIT TWO ABOVEARABIC LETTER WAW WITH EXTENDED AR" +
	"ABIC-INDIC DIGIT THREE ABOVEARABIC LETTER YEH BARREE WITH EXTENDED ARABI" +
	"C-INDIC DIGIT TWO ABOVEARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-IND" +
	"IC DIGIT THREE ABOVEARABIC LETTER HAH WITH EXTENDED ARABIC-INDIC DIGIT F" +
	"OUR BELOWARABIC LETTER SEEN WITH EXTENDED ARABIC-INDIC DIGIT FOUR ABOVEA" +
	"RABIC LETTER SEEN WITH INVERTED VARABIC LETTER KAF WITH TWO DOTS ABOVETH" +
	"AANA LETTER HAATHAANA LETTER SHAVIYANITHAANA LETTER NOONUTHAANA LETTER R" +
	"AATHAANA LETTER BAATHAANA LETTER LHAVIYANITHAANA LETTER KAAFUTHAANA LETT" +
	"ER ALIFUTHAANA LETTER VAAVUTHAANA LETTER MEEMUTHAANA LETTER FAAFUTHAANA " +
	"LETTER DHAALUTHAANA LETTER THAATHAANA LETTER LAAMUTHAANA LETTER GAAFUTHA" +
	"ANA LETTER GNAVIYANITHAANA LETTER SEENUTHAANA LETTER DAVIYANITHAANA LETT" +
	"ER ZAVIYANITHAANA LETTER TAVIYANITHAANA LETTER YAATHAANA LETTER PAVIYANI" +
	"THAANA LETTER JAVIYANITHAANA LETTER CHAVIYANITHAANA LETTER TTAATHAANA LE" +
	"TTER HHAATHAANA LETTER KHAATHAANA LETTER THAALUTHAANA LETTER ZAATHAANA L" +
	"ETTER SHEENUTHAANA LETTER SAADHUTHAANA LETTER DAADHUTHAANA LETTER TOTHAA" +
	"NA LETTER ZOTHAANA LETTER AINUTHAANA LETTER GHAINUTHAANA LETTER QAAFUTHA" +
	"ANA LETTER WAAVUTHAANA ABAFILITHAANA AABAAFILITHAANA IBIFILITHAANA EEBEE" +
	"FILITHAANA UBUFILITHAANA OOBOOFILITHAANA EBEFILITHAANA EYBEYFILITHAANA O" +
	"BOFILITHAANA OABOAFILITHAANA SUKUNTHAANA LETTER NAANKO DIGIT ZERONKO DIG" +
	"IT ONENKO DIGIT TWONKO DIGIT THREENKO DIGIT FOURNKO DIGIT FIVENKO DIGIT " +
	"SIXNKO DIGIT SEVENNKO DIGIT EIGHTNKO DIGIT NINENKO LETTER ANKO LETTER EE" +
	"NKO LETTER INKO LETTER ENKO LETTER UNKO LETTER OONKO LETTER ONKO LETTER " +
	"DAGBASINNANKO LETTER NNKO LETTER BANKO LETTER PANKO LETTER TANKO LETTER " +
	"JANKO LETTER CHANKO LETTER DANKO LETTER RANKO LETTER RRANKO LETTER SANKO" +
	" LETTER GBANKO LETTER FANKO LETTER KANKO LETTER LANKO LETTER NA WOLOSONK" +
	"O LETTER MANKO LETTER NYANKO LETTER NANKO LETTER HANKO LETTER WANKO LETT" +
	"ER YANKO LETTER NYA WOLOSONKO LETTER JONA JANKO LETTER JONA CHANKO LETTE" +
	"R JONA RANKO COMBINING SHORT HIGH TONENKO COMBINING SHORT LOW TONENKO CO" +
	"MBINING SHORT RISING TONENKO COMBINING LONG DESCENDING TONENKO COMBINING" +
	" LONG HIGH TONENKO COMBINING LONG LOW TONENKO COMBINING LONG RISING TONE" +
	"NKO COMBINING NASALIZATION MARKNKO COMBINING DOUBLE DOT ABOVENKO HIGH TO" +
	"NE APOSTROPHENKO LOW TONE APOSTROPHENKO SYMBOL OO DENNENNKO SYMBOL GBAKU" +
	"RUNENNKO COMMANKO EXCLAMATION MARKNKO LAJANYALANNKO DANTAYALANNKO DOROME" +
	" SIGNNKO TAMAN SIGNSAMARITAN LETTER ALAFSAMARITAN LETTER BITSAMARITAN LE" +
	"TTER GAMANSAMARITAN LETTER DALATSAMARITAN LETTER IYSAMARITAN LETTER BAAS" +
	"AMARITAN LETTER ZENSAMARITAN LETTER ITSAMARITAN LETTER TITSAMARITAN LETT" +
	"ER YUTSAMARITAN LETTER KAAFSAMARITAN LETTER LABATSAMARITAN LETTER MIMSAM" +
	"ARITAN LETTER NUNSAMARITAN LETTER SINGAATSAMARITAN LETTER INSAMARITAN LE" +
	"TTER FISAMARITAN LETTER TSAADIYSAMARITAN LETTER QUFSAMARITAN LETTER RISH" +
	"SAMARITAN LETTER SHANSAMARITAN LETTER TAAFSAMARITAN MARK INSAMARITAN MAR" +
	"K IN-ALAFSAMARITAN MARK OCCLUSIONSAMARITAN MARK DAGESHSAMARITAN MODIFIER" +
	" LETTER EPENTHETIC YUTSAMARITAN MARK EPENTHETIC YUTSAMARITAN VOWEL SIGN " +
	"LONG ESAMARITAN VOWEL SIGN ESAMARITAN VOWEL SIGN OVERLONG AASAMARITAN VO" +
	"WEL SIGN LONG AASAMARITAN VOWEL SIGN AASAMARITAN VOWEL SIGN OVERLONG ASA" +
	"MARITAN VOWEL SIGN LONG ASAMARITAN VOWEL SIGN ASAMARITAN MODIFIER LETTER" +
	" SHORT ASAMARITAN VOWEL SIGN SHORT ASAMARITAN VOWEL SIGN LONG USAMARITAN") + ("" +
	" VOWEL SIGN USAMARITAN MODIFIER LETTER ISAMARITAN VOWEL SIGN LONG ISAMAR" +
	"ITAN VOWEL SIGN ISAMARITAN VOWEL SIGN OSAMARITAN VOWEL SIGN SUKUNSAMARIT" +
	"AN MARK NEQUDAASAMARITAN PUNCTUATION NEQUDAASAMARITAN PUNCTUATION AFSAAQ" +
	"SAMARITAN PUNCTUATION ANGEDSAMARITAN PUNCTUATION BAUSAMARITAN PUNCTUATIO" +
	"N ATMAAUSAMARITAN PUNCTUATION SHIYYAALAASAMARITAN ABBREVIATION MARKSAMAR" +
	"ITAN PUNCTUATION MELODIC QITSASAMARITAN PUNCTUATION ZIQAASAMARITAN PUNCT" +
	"UATION QITSASAMARITAN PUNCTUATION ZAEFSAMARITAN PUNCTUATION TURUSAMARITA" +
	"N PUNCTUATION ARKAANUSAMARITAN PUNCTUATION SOF MASHFAATSAMARITAN PUNCTUA" +
	"TION ANNAAUMANDAIC LETTER HALQAMANDAIC LETTER ABMANDAIC LETTER AGMANDAIC" +
	" LETTER ADMANDAIC LETTER AHMANDAIC LETTER USHENNAMANDAIC LETTER AZMANDAI" +
	"C LETTER ITMANDAIC LETTER ATTMANDAIC LETTER AKSAMANDAIC LETTER AKMANDAIC" +
	" LETTER ALMANDAIC LETTER AMMANDAIC LETTER ANMANDAIC LETTER ASMANDAIC LET" +
	"TER INMANDAIC LETTER APMANDAIC LETTER ASZMANDAIC LETTER AQMANDAIC LETTER" +
	" ARMANDAIC LETTER ASHMANDAIC LETTER ATMANDAIC LETTER DUSHENNAMANDAIC LET" +
	"TER KADMANDAIC LETTER AINMANDAIC AFFRICATION MARKMANDAIC VOCALIZATION MA" +
	"RKMANDAIC GEMINATION MARKMANDAIC PUNCTUATIONSYRIAC LETTER MALAYALAM NGAS" +
	"YRIAC LETTER MALAYALAM JASYRIAC LETTER MALAYALAM NYASYRIAC LETTER MALAYA" +
	"LAM TTASYRIAC LETTER MALAYALAM NNASYRIAC LETTER MALAYALAM NNNASYRIAC LET" +
	"TER MALAYALAM BHASYRIAC LETTER MALAYALAM RASYRIAC LETTER MALAYALAM LLASY" +
	"RIAC LETTER MALAYALAM LLLASYRIAC LETTER MALAYALAM SSAARABIC LETTER BEH W" +
	"ITH SMALL V BELOWARABIC LETTER BEH WITH HAMZA ABOVEARABIC LETTER JEEM WI" +
	"TH TWO DOTS ABOVEARABIC LETTER TAH WITH TWO DOTS ABOVEARABIC LETTER FEH " +
	"WITH DOT BELOW AND THREE DOTS ABOVEARABIC LETTER QAF WITH DOT BELOWARABI" +
	"C LETTER LAM WITH DOUBLE BARARABIC LETTER MEEM WITH THREE DOTS ABOVEARAB" +
	"IC LETTER YEH WITH TWO DOTS BELOW AND HAMZA ABOVEARABIC LETTER YEH WITH " +
	"TWO DOTS BELOW AND DOT ABOVEARABIC LETTER REH WITH LOOPARABIC LETTER WAW" +
	" WITH DOT WITHINARABIC LETTER ROHINGYA YEHARABIC LETTER LOW ALEFARABIC L" +
	"ETTER DAL WITH THREE DOTS BELOWARABIC LETTER SAD WITH THREE DOTS BELOWAR" +
	"ABIC LETTER GAF WITH INVERTED STROKEARABIC LETTER STRAIGHT WAWARABIC LET" +
	"TER ZAIN WITH INVERTED V ABOVEARABIC LETTER AIN WITH THREE DOTS BELOWARA" +
	"BIC LETTER KAF WITH DOT BELOWARABIC LETTER BEH WITH SMALL MEEM ABOVEARAB" +
	"IC LETTER PEH WITH SMALL MEEM ABOVEARABIC LETTER TEH WITH SMALL TEH ABOV" +
	"EARABIC LETTER REH WITH SMALL NOON ABOVEARABIC LETTER YEH WITH TWO DOTS " +
	"BELOW AND SMALL NOON ABOVEARABIC LETTER AFRICAN FEHARABIC LETTER AFRICAN" +
	" QAFARABIC LETTER AFRICAN NOONARABIC LETTER PEH WITH SMALL VARABIC LETTE" +
	"R TEH WITH SMALL VARABIC LETTER TTEH WITH SMALL VARABIC LETTER TCHEH WIT" +
	"H SMALL VARABIC LETTER KEHEH WITH SMALL VARABIC LETTER GHAIN WITH THREE " +
	"DOTS ABOVEARABIC LETTER AFRICAN QAF WITH THREE DOTS ABOVEARABIC LETTER J" +
	"EEM WITH THREE DOTS ABOVEARABIC LETTER JEEM WITH THREE DOTS BELOWARABIC " +
	"LETTER LAM WITH SMALL ARABIC LETTER TAH ABOVEARABIC SMALL LOW WAWARABIC " +
	"SMALL HIGH WORD AR-RUBARABIC SMALL HIGH SADARABIC SMALL HIGH AINARABIC S" +
	"MALL HIGH QAFARABIC SMALL HIGH NOON WITH KASRAARABIC SMALL LOW NOON WITH" +
	" KASRAARABIC SMALL HIGH WORD ATH-THALATHAARABIC SMALL HIGH WORD AS-SAJDA" +
	"ARABIC SMALL HIGH WORD AN-NISFARABIC SMALL HIGH WORD SAKTAARABIC SMALL H" +
	"IGH WORD QIFARABIC SMALL HIGH WORD WAQFAARABIC SMALL HIGH FOOTNOTE MARKE" +
	"RARABIC SMALL HIGH SIGN SAFHAARABIC DISPUTED END OF AYAHARABIC TURNED DA" +
	"MMA BELOWARABIC CURLY FATHAARABIC CURLY DAMMAARABIC CURLY KASRAARABIC CU" +
	"RLY FATHATANARABIC CURLY DAMMATANARABIC CURLY KASRATANARABIC TONE ONE DO" +
	"T ABOVEARABIC TONE TWO DOTS ABOVEARABIC TONE LOOP ABOVEARABIC TONE ONE D" +
	"OT BELOWARABIC TONE TWO DOTS BELOWARABIC TONE LOOP BELOWARABIC OPEN FATH" +
	"ATANARABIC OPEN DAMMATANARABIC OPEN KASRATANARABIC SMALL HIGH WAWARABIC " +
	"FATHA WITH RINGARABIC FATHA WITH DOT ABOVEARABIC KASRA WITH DOT BELOWARA" +
	"BIC LEFT ARROWHEAD ABOVEARABIC RIGHT ARROWHEAD ABOVEARABIC LEFT ARROWHEA" +
	"D BELOWARABIC RIGHT ARROWHEAD BELOWARABIC DOUBLE RIGHT ARROWHEAD ABOVEAR" +
	"ABIC DOUBLE RIGHT ARROWHEAD ABOVE WITH DOTARABIC RIGHT ARROWHEAD ABOVE W" +
	"ITH DOTARABIC DAMMA WITH DOTARABIC MARK SIDEWAYS NOON GHUNNADEVANAGARI S" +
	"IGN INVERTED CANDRABINDUDEVANAGARI SIGN CANDRABINDUDEVANAGARI SIGN ANUSV" +
	"ARADEVANAGARI SIGN VISARGADEVANAGARI LETTER SHORT ADEVANAGARI LETTER ADE" +
	"VANAGARI LETTER AADEVANAGARI LETTER IDEVANAGARI LETTER IIDEVANAGARI LETT" +
	"ER UDEVANAGARI LETTER UUDEVANAGARI LETTER VOCALIC RDEVANAGARI LETTER VOC" +
	"ALIC LDEVANAGARI LETTER CANDRA EDEVANAGARI LETTER SHORT EDEVANAGARI LETT" +
	"ER EDEVANAGARI LETTER AIDEVANAGARI LETTER CANDRA ODEVANAGARI LETTER SHOR" +
	"T ODEVANAGARI LETTER ODEVANAGARI LETTER AUDEVANAGARI LETTER KADEVANAGARI" +
	" LETTER KHADEVANAGARI LETTER GADEVANAGARI LETTER GHADEVANAGARI LETTER NG") + ("" +
	"ADEVANAGARI LETTER CADEVANAGARI LETTER CHADEVANAGARI LETTER JADEVANAGARI" +
	" LETTER JHADEVANAGARI LETTER NYADEVANAGARI LETTER TTADEVANAGARI LETTER T" +
	"THADEVANAGARI LETTER DDADEVANAGARI LETTER DDHADEVANAGARI LETTER NNADEVAN" +
	"AGARI LETTER TADEVANAGARI LETTER THADEVANAGARI LETTER DADEVANAGARI LETTE" +
	"R DHADEVANAGARI LETTER NADEVANAGARI LETTER NNNADEVANAGARI LETTER PADEVAN" +
	"AGARI LETTER PHADEVANAGARI LETTER BADEVANAGARI LETTER BHADEVANAGARI LETT" +
	"ER MADEVANAGARI LETTER YADEVANAGARI LETTER RADEVANAGARI LETTER RRADEVANA" +
	"GARI LETTER LADEVANAGARI LETTER LLADEVANAGARI LETTER LLLADEVANAGARI LETT" +
	"ER VADEVANAGARI LETTER SHADEVANAGARI LETTER SSADEVANAGARI LETTER SADEVAN" +
	"AGARI LETTER HADEVANAGARI VOWEL SIGN OEDEVANAGARI VOWEL SIGN OOEDEVANAGA" +
	"RI SIGN NUKTADEVANAGARI SIGN AVAGRAHADEVANAGARI VOWEL SIGN AADEVANAGARI " +
	"VOWEL SIGN IDEVANAGARI VOWEL SIGN IIDEVANAGARI VOWEL SIGN UDEVANAGARI VO" +
	"WEL SIGN UUDEVANAGARI VOWEL SIGN VOCALIC RDEVANAGARI VOWEL SIGN VOCALIC " +
	"RRDEVANAGARI VOWEL SIGN CANDRA EDEVANAGARI VOWEL SIGN SHORT EDEVANAGARI " +
	"VOWEL SIGN EDEVANAGARI VOWEL SIGN AIDEVANAGARI VOWEL SIGN CANDRA ODEVANA" +
	"GARI VOWEL SIGN SHORT ODEVANAGARI VOWEL SIGN ODEVANAGARI VOWEL SIGN AUDE" +
	"VANAGARI SIGN VIRAMADEVANAGARI VOWEL SIGN PRISHTHAMATRA EDEVANAGARI VOWE" +
	"L SIGN AWDEVANAGARI OMDEVANAGARI STRESS SIGN UDATTADEVANAGARI STRESS SIG" +
	"N ANUDATTADEVANAGARI GRAVE ACCENTDEVANAGARI ACUTE ACCENTDEVANAGARI VOWEL" +
	" SIGN CANDRA LONG EDEVANAGARI VOWEL SIGN UEDEVANAGARI VOWEL SIGN UUEDEVA" +
	"NAGARI LETTER QADEVANAGARI LETTER KHHADEVANAGARI LETTER GHHADEVANAGARI L" +
	"ETTER ZADEVANAGARI LETTER DDDHADEVANAGARI LETTER RHADEVANAGARI LETTER FA" +
	"DEVANAGARI LETTER YYADEVANAGARI LETTER VOCALIC RRDEVANAGARI LETTER VOCAL" +
	"IC LLDEVANAGARI VOWEL SIGN VOCALIC LDEVANAGARI VOWEL SIGN VOCALIC LLDEVA" +
	"NAGARI DANDADEVANAGARI DOUBLE DANDADEVANAGARI DIGIT ZERODEVANAGARI DIGIT" +
	" ONEDEVANAGARI DIGIT TWODEVANAGARI DIGIT THREEDEVANAGARI DIGIT FOURDEVAN" +
	"AGARI DIGIT FIVEDEVANAGARI DIGIT SIXDEVANAGARI DIGIT SEVENDEVANAGARI DIG" +
	"IT EIGHTDEVANAGARI DIGIT NINEDEVANAGARI ABBREVIATION SIGNDEVANAGARI SIGN" +
	" HIGH SPACING DOTDEVANAGARI LETTER CANDRA ADEVANAGARI LETTER OEDEVANAGAR" +
	"I LETTER OOEDEVANAGARI LETTER AWDEVANAGARI LETTER UEDEVANAGARI LETTER UU" +
	"EDEVANAGARI LETTER MARWARI DDADEVANAGARI LETTER ZHADEVANAGARI LETTER HEA" +
	"VY YADEVANAGARI LETTER GGADEVANAGARI LETTER JJADEVANAGARI LETTER GLOTTAL" +
	" STOPDEVANAGARI LETTER DDDADEVANAGARI LETTER BBABENGALI ANJIBENGALI SIGN" +
	" CANDRABINDUBENGALI SIGN ANUSVARABENGALI SIGN VISARGABENGALI LETTER ABEN" +
	"GALI LETTER AABENGALI LETTER IBENGALI LETTER IIBENGALI LETTER UBENGALI L" +
	"ETTER UUBENGALI LETTER VOCALIC RBENGALI LETTER VOCALIC LBENGALI LETTER E" +
	"BENGALI LETTER AIBENGALI LETTER OBENGALI LETTER AUBENGALI LETTER KABENGA" +
	"LI LETTER KHABENGALI LETTER GABENGALI LETTER GHABENGALI LETTER NGABENGAL" +
	"I LETTER CABENGALI LETTER CHABENGALI LETTER JABENGALI LETTER JHABENGALI " +
	"LETTER NYABENGALI LETTER TTABENGALI LETTER TTHABENGALI LETTER DDABENGALI" +
	" LETTER DDHABENGALI LETTER NNABENGALI LETTER TABENGALI LETTER THABENGALI" +
	" LETTER DABENGALI LETTER DHABENGALI LETTER NABENGALI LETTER PABENGALI LE" +
	"TTER PHABENGALI LETTER BABENGALI LETTER BHABENGALI LETTER MABENGALI LETT" +
	"ER YABENGALI LETTER RABENGALI LETTER LABENGALI LETTER SHABENGALI LETTER " +
	"SSABENGALI LETTER SABENGALI LETTER HABENGALI SIGN NUKTABENGALI SIGN AVAG" +
	"RAHABENGALI VOWEL SIGN AABENGALI VOWEL SIGN IBENGALI VOWEL SIGN IIBENGAL" +
	"I VOWEL SIGN UBENGALI VOWEL SIGN UUBENGALI VOWEL SIGN VOCALIC RBENGALI V" +
	"OWEL SIGN VOCALIC RRBENGALI VOWEL SIGN EBENGALI VOWEL SIGN AIBENGALI VOW" +
	"EL SIGN OBENGALI VOWEL SIGN AUBENGALI SIGN VIRAMABENGALI LETTER KHANDA T" +
	"ABENGALI AU LENGTH MARKBENGALI LETTER RRABENGALI LETTER RHABENGALI LETTE" +
	"R YYABENGALI LETTER VOCALIC RRBENGALI LETTER VOCALIC LLBENGALI VOWEL SIG" +
	"N VOCALIC LBENGALI VOWEL SIGN VOCALIC LLBENGALI DIGIT ZEROBENGALI DIGIT " +
	"ONEBENGALI DIGIT TWOBENGALI DIGIT THREEBENGALI DIGIT FOURBENGALI DIGIT F" +
	"IVEBENGALI DIGIT SIXBENGALI DIGIT SEVENBENGALI DIGIT EIGHTBENGALI DIGIT " +
	"NINEBENGALI LETTER RA WITH MIDDLE DIAGONALBENGALI LETTER RA WITH LOWER D" +
	"IAGONALBENGALI RUPEE MARKBENGALI RUPEE SIGNBENGALI CURRENCY NUMERATOR ON" +
	"EBENGALI CURRENCY NUMERATOR TWOBENGALI CURRENCY NUMERATOR THREEBENGALI C" +
	"URRENCY NUMERATOR FOURBENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOM" +
	"INATORBENGALI CURRENCY DENOMINATOR SIXTEENBENGALI ISSHARBENGALI GANDA MA" +
	"RKBENGALI LETTER VEDIC ANUSVARABENGALI ABBREVIATION SIGNBENGALI SANDHI M" +
	"ARKGURMUKHI SIGN ADAK BINDIGURMUKHI SIGN BINDIGURMUKHI SIGN VISARGAGURMU" +
	"KHI LETTER AGURMUKHI LETTER AAGURMUKHI LETTER IGURMUKHI LETTER IIGURMUKH" +
	"I LETTER UGURMUKHI LETTER UUGURMUKHI LETTER EEGURMUKHI LETTER AIGURMUKHI" +
	" LETTER OOGURMUKHI LETTER AUGURMUKHI LETTER KAGURMUKHI LETTER KHAGURMUKH") + ("" +
	"I LETTER GAGURMUKHI LETTER GHAGURMUKHI LETTER NGAGURMUKHI LETTER CAGURMU" +
	"KHI LETTER CHAGURMUKHI LETTER JAGURMUKHI LETTER JHAGURMUKHI LETTER NYAGU" +
	"RMUKHI LETTER TTAGURMUKHI LETTER TTHAGURMUKHI LETTER DDAGURMUKHI LETTER " +
	"DDHAGURMUKHI LETTER NNAGURMUKHI LETTER TAGURMUKHI LETTER THAGURMUKHI LET" +
	"TER DAGURMUKHI LETTER DHAGURMUKHI LETTER NAGURMUKHI LETTER PAGURMUKHI LE" +
	"TTER PHAGURMUKHI LETTER BAGURMUKHI LETTER BHAGURMUKHI LETTER MAGURMUKHI " +
	"LETTER YAGURMUKHI LETTER RAGURMUKHI LETTER LAGURMUKHI LETTER LLAGURMUKHI" +
	" LETTER VAGURMUKHI LETTER SHAGURMUKHI LETTER SAGURMUKHI LETTER HAGURMUKH" +
	"I SIGN NUKTAGURMUKHI VOWEL SIGN AAGURMUKHI VOWEL SIGN IGURMUKHI VOWEL SI" +
	"GN IIGURMUKHI VOWEL SIGN UGURMUKHI VOWEL SIGN UUGURMUKHI VOWEL SIGN EEGU" +
	"RMUKHI VOWEL SIGN AIGURMUKHI VOWEL SIGN OOGURMUKHI VOWEL SIGN AUGURMUKHI" +
	" SIGN VIRAMAGURMUKHI SIGN UDAATGURMUKHI LETTER KHHAGURMUKHI LETTER GHHAG" +
	"URMUKHI LETTER ZAGURMUKHI LETTER RRAGURMUKHI LETTER FAGURMUKHI DIGIT ZER" +
	"OGURMUKHI DIGIT ONEGURMUKHI DIGIT TWOGURMUKHI DIGIT THREEGURMUKHI DIGIT " +
	"FOURGURMUKHI DIGIT FIVEGURMUKHI DIGIT SIXGURMUKHI DIGIT SEVENGURMUKHI DI" +
	"GIT EIGHTGURMUKHI DIGIT NINEGURMUKHI TIPPIGURMUKHI ADDAKGURMUKHI IRIGURM" +
	"UKHI URAGURMUKHI EK ONKARGURMUKHI SIGN YAKASHGURMUKHI ABBREVIATION SIGNG" +
	"UJARATI SIGN CANDRABINDUGUJARATI SIGN ANUSVARAGUJARATI SIGN VISARGAGUJAR" +
	"ATI LETTER AGUJARATI LETTER AAGUJARATI LETTER IGUJARATI LETTER IIGUJARAT" +
	"I LETTER UGUJARATI LETTER UUGUJARATI LETTER VOCALIC RGUJARATI LETTER VOC" +
	"ALIC LGUJARATI VOWEL CANDRA EGUJARATI LETTER EGUJARATI LETTER AIGUJARATI" +
	" VOWEL CANDRA OGUJARATI LETTER OGUJARATI LETTER AUGUJARATI LETTER KAGUJA" +
	"RATI LETTER KHAGUJARATI LETTER GAGUJARATI LETTER GHAGUJARATI LETTER NGAG" +
	"UJARATI LETTER CAGUJARATI LETTER CHAGUJARATI LETTER JAGUJARATI LETTER JH" +
	"AGUJARATI LETTER NYAGUJARATI LETTER TTAGUJARATI LETTER TTHAGUJARATI LETT" +
	"ER DDAGUJARATI LETTER DDHAGUJARATI LETTER NNAGUJARATI LETTER TAGUJARATI " +
	"LETTER THAGUJARATI LETTER DAGUJARATI LETTER DHAGUJARATI LETTER NAGUJARAT" +
	"I LETTER PAGUJARATI LETTER PHAGUJARATI LETTER BAGUJARATI LETTER BHAGUJAR" +
	"ATI LETTER MAGUJARATI LETTER YAGUJARATI LETTER RAGUJARATI LETTER LAGUJAR" +
	"ATI LETTER LLAGUJARATI LETTER VAGUJARATI LETTER SHAGUJARATI LETTER SSAGU" +
	"JARATI LETTER SAGUJARATI LETTER HAGUJARATI SIGN NUKTAGUJARATI SIGN AVAGR" +
	"AHAGUJARATI VOWEL SIGN AAGUJARATI VOWEL SIGN IGUJARATI VOWEL SIGN IIGUJA" +
	"RATI VOWEL SIGN UGUJARATI VOWEL SIGN UUGUJARATI VOWEL SIGN VOCALIC RGUJA" +
	"RATI VOWEL SIGN VOCALIC RRGUJARATI VOWEL SIGN CANDRA EGUJARATI VOWEL SIG" +
	"N EGUJARATI VOWEL SIGN AIGUJARATI VOWEL SIGN CANDRA OGUJARATI VOWEL SIGN" +
	" OGUJARATI VOWEL SIGN AUGUJARATI SIGN VIRAMAGUJARATI OMGUJARATI LETTER V" +
	"OCALIC RRGUJARATI LETTER VOCALIC LLGUJARATI VOWEL SIGN VOCALIC LGUJARATI" +
	" VOWEL SIGN VOCALIC LLGUJARATI DIGIT ZEROGUJARATI DIGIT ONEGUJARATI DIGI" +
	"T TWOGUJARATI DIGIT THREEGUJARATI DIGIT FOURGUJARATI DIGIT FIVEGUJARATI " +
	"DIGIT SIXGUJARATI DIGIT SEVENGUJARATI DIGIT EIGHTGUJARATI DIGIT NINEGUJA" +
	"RATI ABBREVIATION SIGNGUJARATI RUPEE SIGNGUJARATI LETTER ZHAGUJARATI SIG" +
	"N SUKUNGUJARATI SIGN SHADDAGUJARATI SIGN MADDAHGUJARATI SIGN THREE-DOT N" +
	"UKTA ABOVEGUJARATI SIGN CIRCLE NUKTA ABOVEGUJARATI SIGN TWO-CIRCLE NUKTA" +
	" ABOVEORIYA SIGN CANDRABINDUORIYA SIGN ANUSVARAORIYA SIGN VISARGAORIYA L" +
	"ETTER AORIYA LETTER AAORIYA LETTER IORIYA LETTER IIORIYA LETTER UORIYA L" +
	"ETTER UUORIYA LETTER VOCALIC RORIYA LETTER VOCALIC LORIYA LETTER EORIYA " +
	"LETTER AIORIYA LETTER OORIYA LETTER AUORIYA LETTER KAORIYA LETTER KHAORI" +
	"YA LETTER GAORIYA LETTER GHAORIYA LETTER NGAORIYA LETTER CAORIYA LETTER " +
	"CHAORIYA LETTER JAORIYA LETTER JHAORIYA LETTER NYAORIYA LETTER TTAORIYA " +
	"LETTER TTHAORIYA LETTER DDAORIYA LETTER DDHAORIYA LETTER NNAORIYA LETTER" +
	" TAORIYA LETTER THAORIYA LETTER DAORIYA LETTER DHAORIYA LETTER NAORIYA L" +
	"ETTER PAORIYA LETTER PHAORIYA LETTER BAORIYA LETTER BHAORIYA LETTER MAOR" +
	"IYA LETTER YAORIYA LETTER RAORIYA LETTER LAORIYA LETTER LLAORIYA LETTER " +
	"VAORIYA LETTER SHAORIYA LETTER SSAORIYA LETTER SAORIYA LETTER HAORIYA SI" +
	"GN NUKTAORIYA SIGN AVAGRAHAORIYA VOWEL SIGN AAORIYA VOWEL SIGN IORIYA VO" +
	"WEL SIGN IIORIYA VOWEL SIGN UORIYA VOWEL SIGN UUORIYA VOWEL SIGN VOCALIC" +
	" RORIYA VOWEL SIGN VOCALIC RRORIYA VOWEL SIGN EORIYA VOWEL SIGN AIORIYA " +
	"VOWEL SIGN OORIYA VOWEL SIGN AUORIYA SIGN VIRAMAORIYA SIGN OVERLINEORIYA" +
	" AI LENGTH MARKORIYA AU LENGTH MARKORIYA LETTER RRAORIYA LETTER RHAORIYA" +
	" LETTER YYAORIYA LETTER VOCALIC RRORIYA LETTER VOCALIC LLORIYA VOWEL SIG" +
	"N VOCALIC LORIYA VOWEL SIGN VOCALIC LLORIYA DIGIT ZEROORIYA DIGIT ONEORI" +
	"YA DIGIT TWOORIYA DIGIT THREEORIYA DIGIT FOURORIYA DIGIT FIVEORIYA DIGIT" +
	" SIXORIYA DIGIT SEVENORIYA DIGIT EIGHTORIYA DIGIT NINEORIYA ISSHARORIYA " +
	"LETTER WAORIYA FRACTION ONE QUARTERORIYA FRACTION ONE HALFORIYA FRACTION") + ("" +
	" THREE QUARTERSORIYA FRACTION ONE SIXTEENTHORIYA FRACTION ONE EIGHTHORIY" +
	"A FRACTION THREE SIXTEENTHSTAMIL SIGN ANUSVARATAMIL SIGN VISARGATAMIL LE" +
	"TTER ATAMIL LETTER AATAMIL LETTER ITAMIL LETTER IITAMIL LETTER UTAMIL LE" +
	"TTER UUTAMIL LETTER ETAMIL LETTER EETAMIL LETTER AITAMIL LETTER OTAMIL L" +
	"ETTER OOTAMIL LETTER AUTAMIL LETTER KATAMIL LETTER NGATAMIL LETTER CATAM" +
	"IL LETTER JATAMIL LETTER NYATAMIL LETTER TTATAMIL LETTER NNATAMIL LETTER" +
	" TATAMIL LETTER NATAMIL LETTER NNNATAMIL LETTER PATAMIL LETTER MATAMIL L" +
	"ETTER YATAMIL LETTER RATAMIL LETTER RRATAMIL LETTER LATAMIL LETTER LLATA" +
	"MIL LETTER LLLATAMIL LETTER VATAMIL LETTER SHATAMIL LETTER SSATAMIL LETT" +
	"ER SATAMIL LETTER HATAMIL VOWEL SIGN AATAMIL VOWEL SIGN ITAMIL VOWEL SIG" +
	"N IITAMIL VOWEL SIGN UTAMIL VOWEL SIGN UUTAMIL VOWEL SIGN ETAMIL VOWEL S" +
	"IGN EETAMIL VOWEL SIGN AITAMIL VOWEL SIGN OTAMIL VOWEL SIGN OOTAMIL VOWE" +
	"L SIGN AUTAMIL SIGN VIRAMATAMIL OMTAMIL AU LENGTH MARKTAMIL DIGIT ZEROTA" +
	"MIL DIGIT ONETAMIL DIGIT TWOTAMIL DIGIT THREETAMIL DIGIT FOURTAMIL DIGIT" +
	" FIVETAMIL DIGIT SIXTAMIL DIGIT SEVENTAMIL DIGIT EIGHTTAMIL DIGIT NINETA" +
	"MIL NUMBER TENTAMIL NUMBER ONE HUNDREDTAMIL NUMBER ONE THOUSANDTAMIL DAY" +
	" SIGNTAMIL MONTH SIGNTAMIL YEAR SIGNTAMIL DEBIT SIGNTAMIL CREDIT SIGNTAM" +
	"IL AS ABOVE SIGNTAMIL RUPEE SIGNTAMIL NUMBER SIGNTELUGU SIGN COMBINING C" +
	"ANDRABINDU ABOVETELUGU SIGN CANDRABINDUTELUGU SIGN ANUSVARATELUGU SIGN V" +
	"ISARGATELUGU SIGN COMBINING ANUSVARA ABOVETELUGU LETTER ATELUGU LETTER A" +
	"ATELUGU LETTER ITELUGU LETTER IITELUGU LETTER UTELUGU LETTER UUTELUGU LE" +
	"TTER VOCALIC RTELUGU LETTER VOCALIC LTELUGU LETTER ETELUGU LETTER EETELU" +
	"GU LETTER AITELUGU LETTER OTELUGU LETTER OOTELUGU LETTER AUTELUGU LETTER" +
	" KATELUGU LETTER KHATELUGU LETTER GATELUGU LETTER GHATELUGU LETTER NGATE" +
	"LUGU LETTER CATELUGU LETTER CHATELUGU LETTER JATELUGU LETTER JHATELUGU L" +
	"ETTER NYATELUGU LETTER TTATELUGU LETTER TTHATELUGU LETTER DDATELUGU LETT" +
	"ER DDHATELUGU LETTER NNATELUGU LETTER TATELUGU LETTER THATELUGU LETTER D" +
	"ATELUGU LETTER DHATELUGU LETTER NATELUGU LETTER PATELUGU LETTER PHATELUG" +
	"U LETTER BATELUGU LETTER BHATELUGU LETTER MATELUGU LETTER YATELUGU LETTE" +
	"R RATELUGU LETTER RRATELUGU LETTER LATELUGU LETTER LLATELUGU LETTER LLLA" +
	"TELUGU LETTER VATELUGU LETTER SHATELUGU LETTER SSATELUGU LETTER SATELUGU" +
	" LETTER HATELUGU SIGN AVAGRAHATELUGU VOWEL SIGN AATELUGU VOWEL SIGN ITEL" +
	"UGU VOWEL SIGN IITELUGU VOWEL SIGN UTELUGU VOWEL SIGN UUTELUGU VOWEL SIG" +
	"N VOCALIC RTELUGU VOWEL SIGN VOCALIC RRTELUGU VOWEL SIGN ETELUGU VOWEL S" +
	"IGN EETELUGU VOWEL SIGN AITELUGU VOWEL SIGN OTELUGU VOWEL SIGN OOTELUGU " +
	"VOWEL SIGN AUTELUGU SIGN VIRAMATELUGU LENGTH MARKTELUGU AI LENGTH MARKTE" +
	"LUGU LETTER TSATELUGU LETTER DZATELUGU LETTER RRRATELUGU LETTER VOCALIC " +
	"RRTELUGU LETTER VOCALIC LLTELUGU VOWEL SIGN VOCALIC LTELUGU VOWEL SIGN V" +
	"OCALIC LLTELUGU DIGIT ZEROTELUGU DIGIT ONETELUGU DIGIT TWOTELUGU DIGIT T" +
	"HREETELUGU DIGIT FOURTELUGU DIGIT FIVETELUGU DIGIT SIXTELUGU DIGIT SEVEN" +
	"TELUGU DIGIT EIGHTTELUGU DIGIT NINETELUGU SIGN SIDDHAMTELUGU FRACTION DI" +
	"GIT ZERO FOR ODD POWERS OF FOURTELUGU FRACTION DIGIT ONE FOR ODD POWERS " +
	"OF FOURTELUGU FRACTION DIGIT TWO FOR ODD POWERS OF FOURTELUGU FRACTION D" +
	"IGIT THREE FOR ODD POWERS OF FOURTELUGU FRACTION DIGIT ONE FOR EVEN POWE" +
	"RS OF FOURTELUGU FRACTION DIGIT TWO FOR EVEN POWERS OF FOURTELUGU FRACTI" +
	"ON DIGIT THREE FOR EVEN POWERS OF FOURTELUGU SIGN TUUMUKANNADA SIGN SPAC" +
	"ING CANDRABINDUKANNADA SIGN CANDRABINDUKANNADA SIGN ANUSVARAKANNADA SIGN" +
	" VISARGAKANNADA SIGN SIDDHAMKANNADA LETTER AKANNADA LETTER AAKANNADA LET" +
	"TER IKANNADA LETTER IIKANNADA LETTER UKANNADA LETTER UUKANNADA LETTER VO" +
	"CALIC RKANNADA LETTER VOCALIC LKANNADA LETTER EKANNADA LETTER EEKANNADA " +
	"LETTER AIKANNADA LETTER OKANNADA LETTER OOKANNADA LETTER AUKANNADA LETTE" +
	"R KAKANNADA LETTER KHAKANNADA LETTER GAKANNADA LETTER GHAKANNADA LETTER " +
	"NGAKANNADA LETTER CAKANNADA LETTER CHAKANNADA LETTER JAKANNADA LETTER JH" +
	"AKANNADA LETTER NYAKANNADA LETTER TTAKANNADA LETTER TTHAKANNADA LETTER D" +
	"DAKANNADA LETTER DDHAKANNADA LETTER NNAKANNADA LETTER TAKANNADA LETTER T" +
	"HAKANNADA LETTER DAKANNADA LETTER DHAKANNADA LETTER NAKANNADA LETTER PAK" +
	"ANNADA LETTER PHAKANNADA LETTER BAKANNADA LETTER BHAKANNADA LETTER MAKAN" +
	"NADA LETTER YAKANNADA LETTER RAKANNADA LETTER RRAKANNADA LETTER LAKANNAD" +
	"A LETTER LLAKANNADA LETTER VAKANNADA LETTER SHAKANNADA LETTER SSAKANNADA" +
	" LETTER SAKANNADA LETTER HAKANNADA SIGN NUKTAKANNADA SIGN AVAGRAHAKANNAD" +
	"A VOWEL SIGN AAKANNADA VOWEL SIGN IKANNADA VOWEL SIGN IIKANNADA VOWEL SI" +
	"GN UKANNADA VOWEL SIGN UUKANNADA VOWEL SIGN VOCALIC RKANNADA VOWEL SIGN " +
	"VOCALIC RRKANNADA VOWEL SIGN EKANNADA VOWEL SIGN EEKANNADA VOWEL SIGN AI" +
	"KANNADA VOWEL SIGN OKANNADA VOWEL SIGN OOKANNADA VOWEL SIGN AUKANNADA SI") + ("" +
	"GN VIRAMAKANNADA LENGTH MARKKANNADA AI LENGTH MARKKANNADA LETTER FAKANNA" +
	"DA LETTER VOCALIC RRKANNADA LETTER VOCALIC LLKANNADA VOWEL SIGN VOCALIC " +
	"LKANNADA VOWEL SIGN VOCALIC LLKANNADA DIGIT ZEROKANNADA DIGIT ONEKANNADA" +
	" DIGIT TWOKANNADA DIGIT THREEKANNADA DIGIT FOURKANNADA DIGIT FIVEKANNADA" +
	" DIGIT SIXKANNADA DIGIT SEVENKANNADA DIGIT EIGHTKANNADA DIGIT NINEKANNAD" +
	"A SIGN JIHVAMULIYAKANNADA SIGN UPADHMANIYAMALAYALAM SIGN COMBINING ANUSV" +
	"ARA ABOVEMALAYALAM SIGN CANDRABINDUMALAYALAM SIGN ANUSVARAMALAYALAM SIGN" +
	" VISARGAMALAYALAM LETTER VEDIC ANUSVARAMALAYALAM LETTER AMALAYALAM LETTE" +
	"R AAMALAYALAM LETTER IMALAYALAM LETTER IIMALAYALAM LETTER UMALAYALAM LET" +
	"TER UUMALAYALAM LETTER VOCALIC RMALAYALAM LETTER VOCALIC LMALAYALAM LETT" +
	"ER EMALAYALAM LETTER EEMALAYALAM LETTER AIMALAYALAM LETTER OMALAYALAM LE" +
	"TTER OOMALAYALAM LETTER AUMALAYALAM LETTER KAMALAYALAM LETTER KHAMALAYAL" +
	"AM LETTER GAMALAYALAM LETTER GHAMALAYALAM LETTER NGAMALAYALAM LETTER CAM" +
	"ALAYALAM LETTER CHAMALAYALAM LETTER JAMALAYALAM LETTER JHAMALAYALAM LETT" +
	"ER NYAMALAYALAM LETTER TTAMALAYALAM LETTER TTHAMALAYALAM LETTER DDAMALAY" +
	"ALAM LETTER DDHAMALAYALAM LETTER NNAMALAYALAM LETTER TAMALAYALAM LETTER " +
	"THAMALAYALAM LETTER DAMALAYALAM LETTER DHAMALAYALAM LETTER NAMALAYALAM L" +
	"ETTER NNNAMALAYALAM LETTER PAMALAYALAM LETTER PHAMALAYALAM LETTER BAMALA" +
	"YALAM LETTER BHAMALAYALAM LETTER MAMALAYALAM LETTER YAMALAYALAM LETTER R" +
	"AMALAYALAM LETTER RRAMALAYALAM LETTER LAMALAYALAM LETTER LLAMALAYALAM LE" +
	"TTER LLLAMALAYALAM LETTER VAMALAYALAM LETTER SHAMALAYALAM LETTER SSAMALA" +
	"YALAM LETTER SAMALAYALAM LETTER HAMALAYALAM LETTER TTTAMALAYALAM SIGN VE" +
	"RTICAL BAR VIRAMAMALAYALAM SIGN CIRCULAR VIRAMAMALAYALAM SIGN AVAGRAHAMA" +
	"LAYALAM VOWEL SIGN AAMALAYALAM VOWEL SIGN IMALAYALAM VOWEL SIGN IIMALAYA" +
	"LAM VOWEL SIGN UMALAYALAM VOWEL SIGN UUMALAYALAM VOWEL SIGN VOCALIC RMAL" +
	"AYALAM VOWEL SIGN VOCALIC RRMALAYALAM VOWEL SIGN EMALAYALAM VOWEL SIGN E" +
	"EMALAYALAM VOWEL SIGN AIMALAYALAM VOWEL SIGN OMALAYALAM VOWEL SIGN OOMAL" +
	"AYALAM VOWEL SIGN AUMALAYALAM SIGN VIRAMAMALAYALAM LETTER DOT REPHMALAYA" +
	"LAM SIGN PARAMALAYALAM LETTER CHILLU MMALAYALAM LETTER CHILLU YMALAYALAM" +
	" LETTER CHILLU LLLMALAYALAM AU LENGTH MARKMALAYALAM FRACTION ONE ONE-HUN" +
	"DRED-AND-SIXTIETHMALAYALAM FRACTION ONE FORTIETHMALAYALAM FRACTION THREE" +
	" EIGHTIETHSMALAYALAM FRACTION ONE TWENTIETHMALAYALAM FRACTION ONE TENTHM" +
	"ALAYALAM FRACTION THREE TWENTIETHSMALAYALAM FRACTION ONE FIFTHMALAYALAM " +
	"LETTER ARCHAIC IIMALAYALAM LETTER VOCALIC RRMALAYALAM LETTER VOCALIC LLM" +
	"ALAYALAM VOWEL SIGN VOCALIC LMALAYALAM VOWEL SIGN VOCALIC LLMALAYALAM DI" +
	"GIT ZEROMALAYALAM DIGIT ONEMALAYALAM DIGIT TWOMALAYALAM DIGIT THREEMALAY" +
	"ALAM DIGIT FOURMALAYALAM DIGIT FIVEMALAYALAM DIGIT SIXMALAYALAM DIGIT SE" +
	"VENMALAYALAM DIGIT EIGHTMALAYALAM DIGIT NINEMALAYALAM NUMBER TENMALAYALA" +
	"M NUMBER ONE HUNDREDMALAYALAM NUMBER ONE THOUSANDMALAYALAM FRACTION ONE " +
	"QUARTERMALAYALAM FRACTION ONE HALFMALAYALAM FRACTION THREE QUARTERSMALAY" +
	"ALAM FRACTION ONE SIXTEENTHMALAYALAM FRACTION ONE EIGHTHMALAYALAM FRACTI" +
	"ON THREE SIXTEENTHSMALAYALAM DATE MARKMALAYALAM LETTER CHILLU NNMALAYALA" +
	"M LETTER CHILLU NMALAYALAM LETTER CHILLU RRMALAYALAM LETTER CHILLU LMALA" +
	"YALAM LETTER CHILLU LLMALAYALAM LETTER CHILLU KSINHALA SIGN CANDRABINDUS" +
	"INHALA SIGN ANUSVARAYASINHALA SIGN VISARGAYASINHALA LETTER AYANNASINHALA" +
	" LETTER AAYANNASINHALA LETTER AEYANNASINHALA LETTER AEEYANNASINHALA LETT" +
	"ER IYANNASINHALA LETTER IIYANNASINHALA LETTER UYANNASINHALA LETTER UUYAN" +
	"NASINHALA LETTER IRUYANNASINHALA LETTER IRUUYANNASINHALA LETTER ILUYANNA" +
	"SINHALA LETTER ILUUYANNASINHALA LETTER EYANNASINHALA LETTER EEYANNASINHA" +
	"LA LETTER AIYANNASINHALA LETTER OYANNASINHALA LETTER OOYANNASINHALA LETT" +
	"ER AUYANNASINHALA LETTER ALPAPRAANA KAYANNASINHALA LETTER MAHAAPRAANA KA" +
	"YANNASINHALA LETTER ALPAPRAANA GAYANNASINHALA LETTER MAHAAPRAANA GAYANNA" +
	"SINHALA LETTER KANTAJA NAASIKYAYASINHALA LETTER SANYAKA GAYANNASINHALA L" +
	"ETTER ALPAPRAANA CAYANNASINHALA LETTER MAHAAPRAANA CAYANNASINHALA LETTER" +
	" ALPAPRAANA JAYANNASINHALA LETTER MAHAAPRAANA JAYANNASINHALA LETTER TAAL" +
	"UJA NAASIKYAYASINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYASINHALA LETTER " +
	"SANYAKA JAYANNASINHALA LETTER ALPAPRAANA TTAYANNASINHALA LETTER MAHAAPRA" +
	"ANA TTAYANNASINHALA LETTER ALPAPRAANA DDAYANNASINHALA LETTER MAHAAPRAANA" +
	" DDAYANNASINHALA LETTER MUURDHAJA NAYANNASINHALA LETTER SANYAKA DDAYANNA" +
	"SINHALA LETTER ALPAPRAANA TAYANNASINHALA LETTER MAHAAPRAANA TAYANNASINHA" +
	"LA LETTER ALPAPRAANA DAYANNASINHALA LETTER MAHAAPRAANA DAYANNASINHALA LE" +
	"TTER DANTAJA NAYANNASINHALA LETTER SANYAKA DAYANNASINHALA LETTER ALPAPRA" +
	"ANA PAYANNASINHALA LETTER MAHAAPRAANA PAYANNASINHALA LETTER ALPAPRAANA B" +
	"AYANNASINHALA LETTER MAHAAPRAANA BAYANNASINHALA LETTER MAYANNASINHALA LE") + ("" +
	"TTER AMBA BAYANNASINHALA LETTER YAYANNASINHALA LETTER RAYANNASINHALA LET" +
	"TER DANTAJA LAYANNASINHALA LETTER VAYANNASINHALA LETTER TAALUJA SAYANNAS" +
	"INHALA LETTER MUURDHAJA SAYANNASINHALA LETTER DANTAJA SAYANNASINHALA LET" +
	"TER HAYANNASINHALA LETTER MUURDHAJA LAYANNASINHALA LETTER FAYANNASINHALA" +
	" SIGN AL-LAKUNASINHALA VOWEL SIGN AELA-PILLASINHALA VOWEL SIGN KETTI AED" +
	"A-PILLASINHALA VOWEL SIGN DIGA AEDA-PILLASINHALA VOWEL SIGN KETTI IS-PIL" +
	"LASINHALA VOWEL SIGN DIGA IS-PILLASINHALA VOWEL SIGN KETTI PAA-PILLASINH" +
	"ALA VOWEL SIGN DIGA PAA-PILLASINHALA VOWEL SIGN GAETTA-PILLASINHALA VOWE" +
	"L SIGN KOMBUVASINHALA VOWEL SIGN DIGA KOMBUVASINHALA VOWEL SIGN KOMBU DE" +
	"KASINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLASINHALA VOWEL SIGN KOMBUVA HA" +
	"A DIGA AELA-PILLASINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTASINHALA VOWEL" +
	" SIGN GAYANUKITTASINHALA LITH DIGIT ZEROSINHALA LITH DIGIT ONESINHALA LI" +
	"TH DIGIT TWOSINHALA LITH DIGIT THREESINHALA LITH DIGIT FOURSINHALA LITH " +
	"DIGIT FIVESINHALA LITH DIGIT SIXSINHALA LITH DIGIT SEVENSINHALA LITH DIG" +
	"IT EIGHTSINHALA LITH DIGIT NINESINHALA VOWEL SIGN DIGA GAETTA-PILLASINHA" +
	"LA VOWEL SIGN DIGA GAYANUKITTASINHALA PUNCTUATION KUNDDALIYATHAI CHARACT" +
	"ER KO KAITHAI CHARACTER KHO KHAITHAI CHARACTER KHO KHUATTHAI CHARACTER K" +
	"HO KHWAITHAI CHARACTER KHO KHONTHAI CHARACTER KHO RAKHANGTHAI CHARACTER " +
	"NGO NGUTHAI CHARACTER CHO CHANTHAI CHARACTER CHO CHINGTHAI CHARACTER CHO" +
	" CHANGTHAI CHARACTER SO SOTHAI CHARACTER CHO CHOETHAI CHARACTER YO YINGT" +
	"HAI CHARACTER DO CHADATHAI CHARACTER TO PATAKTHAI CHARACTER THO THANTHAI" +
	" CHARACTER THO NANGMONTHOTHAI CHARACTER THO PHUTHAOTHAI CHARACTER NO NEN" +
	"THAI CHARACTER DO DEKTHAI CHARACTER TO TAOTHAI CHARACTER THO THUNGTHAI C" +
	"HARACTER THO THAHANTHAI CHARACTER THO THONGTHAI CHARACTER NO NUTHAI CHAR" +
	"ACTER BO BAIMAITHAI CHARACTER PO PLATHAI CHARACTER PHO PHUNGTHAI CHARACT" +
	"ER FO FATHAI CHARACTER PHO PHANTHAI CHARACTER FO FANTHAI CHARACTER PHO S" +
	"AMPHAOTHAI CHARACTER MO MATHAI CHARACTER YO YAKTHAI CHARACTER RO RUATHAI" +
	" CHARACTER RUTHAI CHARACTER LO LINGTHAI CHARACTER LUTHAI CHARACTER WO WA" +
	"ENTHAI CHARACTER SO SALATHAI CHARACTER SO RUSITHAI CHARACTER SO SUATHAI " +
	"CHARACTER HO HIPTHAI CHARACTER LO CHULATHAI CHARACTER O ANGTHAI CHARACTE" +
	"R HO NOKHUKTHAI CHARACTER PAIYANNOITHAI CHARACTER SARA ATHAI CHARACTER M" +
	"AI HAN-AKATTHAI CHARACTER SARA AATHAI CHARACTER SARA AMTHAI CHARACTER SA" +
	"RA ITHAI CHARACTER SARA IITHAI CHARACTER SARA UETHAI CHARACTER SARA UEET" +
	"HAI CHARACTER SARA UTHAI CHARACTER SARA UUTHAI CHARACTER PHINTHUTHAI CUR" +
	"RENCY SYMBOL BAHTTHAI CHARACTER SARA ETHAI CHARACTER SARA AETHAI CHARACT" +
	"ER SARA OTHAI CHARACTER SARA AI MAIMUANTHAI CHARACTER SARA AI MAIMALAITH" +
	"AI CHARACTER LAKKHANGYAOTHAI CHARACTER MAIYAMOKTHAI CHARACTER MAITAIKHUT" +
	"HAI CHARACTER MAI EKTHAI CHARACTER MAI THOTHAI CHARACTER MAI TRITHAI CHA" +
	"RACTER MAI CHATTAWATHAI CHARACTER THANTHAKHATTHAI CHARACTER NIKHAHITTHAI" +
	" CHARACTER YAMAKKANTHAI CHARACTER FONGMANTHAI DIGIT ZEROTHAI DIGIT ONETH" +
	"AI DIGIT TWOTHAI DIGIT THREETHAI DIGIT FOURTHAI DIGIT FIVETHAI DIGIT SIX" +
	"THAI DIGIT SEVENTHAI DIGIT EIGHTTHAI DIGIT NINETHAI CHARACTER ANGKHANKHU" +
	"THAI CHARACTER KHOMUTLAO LETTER KOLAO LETTER KHO SUNGLAO LETTER KHO TAML" +
	"AO LETTER PALI GHALAO LETTER NGOLAO LETTER COLAO LETTER PALI CHALAO LETT" +
	"ER SO TAMLAO LETTER PALI JHALAO LETTER NYOLAO LETTER PALI NYALAO LETTER " +
	"PALI TTALAO LETTER PALI TTHALAO LETTER PALI DDALAO LETTER PALI DDHALAO L" +
	"ETTER PALI NNALAO LETTER DOLAO LETTER TOLAO LETTER THO SUNGLAO LETTER TH" +
	"O TAMLAO LETTER PALI DHALAO LETTER NOLAO LETTER BOLAO LETTER POLAO LETTE" +
	"R PHO SUNGLAO LETTER FO TAMLAO LETTER PHO TAMLAO LETTER FO SUNGLAO LETTE" +
	"R PALI BHALAO LETTER MOLAO LETTER YOLAO LETTER LO LINGLAO LETTER LO LOOT" +
	"LAO LETTER WOLAO LETTER SANSKRIT SHALAO LETTER SANSKRIT SSALAO LETTER SO" +
	" SUNGLAO LETTER HO SUNGLAO LETTER PALI LLALAO LETTER OLAO LETTER HO TAML" +
	"AO ELLIPSISLAO VOWEL SIGN ALAO VOWEL SIGN MAI KANLAO VOWEL SIGN AALAO VO" +
	"WEL SIGN AMLAO VOWEL SIGN ILAO VOWEL SIGN IILAO VOWEL SIGN YLAO VOWEL SI" +
	"GN YYLAO VOWEL SIGN ULAO VOWEL SIGN UULAO SIGN PALI VIRAMALAO VOWEL SIGN" +
	" MAI KONLAO SEMIVOWEL SIGN LOLAO SEMIVOWEL SIGN NYOLAO VOWEL SIGN ELAO V" +
	"OWEL SIGN EILAO VOWEL SIGN OLAO VOWEL SIGN AYLAO VOWEL SIGN AILAO KO LAL" +
	"AO TONE MAI EKLAO TONE MAI THOLAO TONE MAI TILAO TONE MAI CATAWALAO CANC" +
	"ELLATION MARKLAO NIGGAHITALAO DIGIT ZEROLAO DIGIT ONELAO DIGIT TWOLAO DI" +
	"GIT THREELAO DIGIT FOURLAO DIGIT FIVELAO DIGIT SIXLAO DIGIT SEVENLAO DIG" +
	"IT EIGHTLAO DIGIT NINELAO HO NOLAO HO MOLAO LETTER KHMU GOLAO LETTER KHM" +
	"U NYOTIBETAN SYLLABLE OMTIBETAN MARK GTER YIG MGO TRUNCATED ATIBETAN MAR" +
	"K GTER YIG MGO -UM RNAM BCAD MATIBETAN MARK GTER YIG MGO -UM GTER TSHEG " +
	"MATIBETAN MARK INITIAL YIG MGO MDUN MATIBETAN MARK CLOSING YIG MGO SGAB ") + ("" +
	"MATIBETAN MARK CARET YIG MGO PHUR SHAD MATIBETAN MARK YIG MGO TSHEG SHAD" +
	" MATIBETAN MARK SBRUL SHADTIBETAN MARK BSKUR YIG MGOTIBETAN MARK BKA- SH" +
	"OG YIG MGOTIBETAN MARK INTERSYLLABIC TSHEGTIBETAN MARK DELIMITER TSHEG B" +
	"STARTIBETAN MARK SHADTIBETAN MARK NYIS SHADTIBETAN MARK TSHEG SHADTIBETA" +
	"N MARK NYIS TSHEG SHADTIBETAN MARK RIN CHEN SPUNGS SHADTIBETAN MARK RGYA" +
	" GRAM SHADTIBETAN MARK CARET -DZUD RTAGS ME LONG CANTIBETAN MARK GTER TS" +
	"HEGTIBETAN LOGOTYPE SIGN CHAD RTAGSTIBETAN LOGOTYPE SIGN LHAG RTAGSTIBET" +
	"AN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGSTIBETAN ASTROLOGICAL SIGN -KHY" +
	"UD PATIBETAN ASTROLOGICAL SIGN SDONG TSHUGSTIBETAN SIGN RDEL DKAR GCIGTI" +
	"BETAN SIGN RDEL DKAR GNYISTIBETAN SIGN RDEL DKAR GSUMTIBETAN SIGN RDEL N" +
	"AG GCIGTIBETAN SIGN RDEL NAG GNYISTIBETAN SIGN RDEL DKAR RDEL NAGTIBETAN" +
	" DIGIT ZEROTIBETAN DIGIT ONETIBETAN DIGIT TWOTIBETAN DIGIT THREETIBETAN " +
	"DIGIT FOURTIBETAN DIGIT FIVETIBETAN DIGIT SIXTIBETAN DIGIT SEVENTIBETAN " +
	"DIGIT EIGHTTIBETAN DIGIT NINETIBETAN DIGIT HALF ONETIBETAN DIGIT HALF TW" +
	"OTIBETAN DIGIT HALF THREETIBETAN DIGIT HALF FOURTIBETAN DIGIT HALF FIVET" +
	"IBETAN DIGIT HALF SIXTIBETAN DIGIT HALF SEVENTIBETAN DIGIT HALF EIGHTTIB" +
	"ETAN DIGIT HALF NINETIBETAN DIGIT HALF ZEROTIBETAN MARK BSDUS RTAGSTIBET" +
	"AN MARK NGAS BZUNG NYI ZLATIBETAN MARK CARET -DZUD RTAGS BZHI MIG CANTIB" +
	"ETAN MARK NGAS BZUNG SGOR RTAGSTIBETAN MARK CHE MGOTIBETAN MARK TSA -PHR" +
	"UTIBETAN MARK GUG RTAGS GYONTIBETAN MARK GUG RTAGS GYASTIBETAN MARK ANG " +
	"KHANG GYONTIBETAN MARK ANG KHANG GYASTIBETAN SIGN YAR TSHESTIBETAN SIGN " +
	"MAR TSHESTIBETAN LETTER KATIBETAN LETTER KHATIBETAN LETTER GATIBETAN LET" +
	"TER GHATIBETAN LETTER NGATIBETAN LETTER CATIBETAN LETTER CHATIBETAN LETT" +
	"ER JATIBETAN LETTER NYATIBETAN LETTER TTATIBETAN LETTER TTHATIBETAN LETT" +
	"ER DDATIBETAN LETTER DDHATIBETAN LETTER NNATIBETAN LETTER TATIBETAN LETT" +
	"ER THATIBETAN LETTER DATIBETAN LETTER DHATIBETAN LETTER NATIBETAN LETTER" +
	" PATIBETAN LETTER PHATIBETAN LETTER BATIBETAN LETTER BHATIBETAN LETTER M" +
	"ATIBETAN LETTER TSATIBETAN LETTER TSHATIBETAN LETTER DZATIBETAN LETTER D" +
	"ZHATIBETAN LETTER WATIBETAN LETTER ZHATIBETAN LETTER ZATIBETAN LETTER -A" +
	"TIBETAN LETTER YATIBETAN LETTER RATIBETAN LETTER LATIBETAN LETTER SHATIB" +
	"ETAN LETTER SSATIBETAN LETTER SATIBETAN LETTER HATIBETAN LETTER ATIBETAN" +
	" LETTER KSSATIBETAN LETTER FIXED-FORM RATIBETAN LETTER KKATIBETAN LETTER" +
	" RRATIBETAN VOWEL SIGN AATIBETAN VOWEL SIGN ITIBETAN VOWEL SIGN IITIBETA" +
	"N VOWEL SIGN UTIBETAN VOWEL SIGN UUTIBETAN VOWEL SIGN VOCALIC RTIBETAN V" +
	"OWEL SIGN VOCALIC RRTIBETAN VOWEL SIGN VOCALIC LTIBETAN VOWEL SIGN VOCAL" +
	"IC LLTIBETAN VOWEL SIGN ETIBETAN VOWEL SIGN EETIBETAN VOWEL SIGN OTIBETA" +
	"N VOWEL SIGN OOTIBETAN SIGN RJES SU NGA ROTIBETAN SIGN RNAM BCADTIBETAN " +
	"VOWEL SIGN REVERSED ITIBETAN VOWEL SIGN REVERSED IITIBETAN SIGN NYI ZLA " +
	"NAA DATIBETAN SIGN SNA LDANTIBETAN MARK HALANTATIBETAN MARK PALUTATIBETA" +
	"N SIGN LCI RTAGSTIBETAN SIGN YANG RTAGSTIBETAN SIGN LCE TSA CANTIBETAN S" +
	"IGN MCHU CANTIBETAN SIGN GRU CAN RGYINGSTIBETAN SIGN GRU MED RGYINGSTIBE" +
	"TAN SIGN INVERTED MCHU CANTIBETAN SUBJOINED SIGN LCE TSA CANTIBETAN SUBJ" +
	"OINED SIGN MCHU CANTIBETAN SUBJOINED SIGN INVERTED MCHU CANTIBETAN SUBJO" +
	"INED LETTER KATIBETAN SUBJOINED LETTER KHATIBETAN SUBJOINED LETTER GATIB" +
	"ETAN SUBJOINED LETTER GHATIBETAN SUBJOINED LETTER NGATIBETAN SUBJOINED L" +
	"ETTER CATIBETAN SUBJOINED LETTER CHATIBETAN SUBJOINED LETTER JATIBETAN S" +
	"UBJOINED LETTER NYATIBETAN SUBJOINED LETTER TTATIBETAN SUBJOINED LETTER " +
	"TTHATIBETAN SUBJOINED LETTER DDATIBETAN SUBJOINED LETTER DDHATIBETAN SUB" +
	"JOINED LETTER NNATIBETAN SUBJOINED LETTER TATIBETAN SUBJOINED LETTER THA" +
	"TIBETAN SUBJOINED LETTER DATIBETAN SUBJOINED LETTER DHATIBETAN SUBJOINED" +
	" LETTER NATIBETAN SUBJOINED LETTER PATIBETAN SUBJOINED LETTER PHATIBETAN" +
	" SUBJOINED LETTER BATIBETAN SUBJOINED LETTER BHATIBETAN SUBJOINED LETTER" +
	" MATIBETAN SUBJOINED LETTER TSATIBETAN SUBJOINED LETTER TSHATIBETAN SUBJ" +
	"OINED LETTER DZATIBETAN SUBJOINED LETTER DZHATIBETAN SUBJOINED LETTER WA" +
	"TIBETAN SUBJOINED LETTER ZHATIBETAN SUBJOINED LETTER ZATIBETAN SUBJOINED" +
	" LETTER -ATIBETAN SUBJOINED LETTER YATIBETAN SUBJOINED LETTER RATIBETAN " +
	"SUBJOINED LETTER LATIBETAN SUBJOINED LETTER SHATIBETAN SUBJOINED LETTER " +
	"SSATIBETAN SUBJOINED LETTER SATIBETAN SUBJOINED LETTER HATIBETAN SUBJOIN" +
	"ED LETTER ATIBETAN SUBJOINED LETTER KSSATIBETAN SUBJOINED LETTER FIXED-F" +
	"ORM WATIBETAN SUBJOINED LETTER FIXED-FORM YATIBETAN SUBJOINED LETTER FIX" +
	"ED-FORM RATIBETAN KU RU KHATIBETAN KU RU KHA BZHI MIG CANTIBETAN CANTILL" +
	"ATION SIGN HEAVY BEATTIBETAN CANTILLATION SIGN LIGHT BEATTIBETAN CANTILL" +
	"ATION SIGN CANG TE-UTIBETAN CANTILLATION SIGN SBUB -CHALTIBETAN SYMBOL D" +
	"RIL BUTIBETAN SYMBOL RDO RJETIBETAN SYMBOL PADMA GDANTIBETAN SYMBOL RDO ") + ("" +
	"RJE RGYA GRAMTIBETAN SYMBOL PHUR PATIBETAN SYMBOL NOR BUTIBETAN SYMBOL N" +
	"OR BU NYIS -KHYILTIBETAN SYMBOL NOR BU GSUM -KHYILTIBETAN SYMBOL NOR BU " +
	"BZHI -KHYILTIBETAN SIGN RDEL NAG RDEL DKARTIBETAN SIGN RDEL NAG GSUMTIBE" +
	"TAN MARK BSKA- SHOG GI MGO RGYANTIBETAN MARK MNYAM YIG GI MGO RGYANTIBET" +
	"AN MARK NYIS TSHEGTIBETAN MARK INITIAL BRDA RNYING YIG MGO MDUN MATIBETA" +
	"N MARK CLOSING BRDA RNYING YIG MGO SGAB MARIGHT-FACING SVASTI SIGNLEFT-F" +
	"ACING SVASTI SIGNRIGHT-FACING SVASTI SIGN WITH DOTSLEFT-FACING SVASTI SI" +
	"GN WITH DOTSTIBETAN MARK LEADING MCHAN RTAGSTIBETAN MARK TRAILING MCHAN " +
	"RTAGSMYANMAR LETTER KAMYANMAR LETTER KHAMYANMAR LETTER GAMYANMAR LETTER " +
	"GHAMYANMAR LETTER NGAMYANMAR LETTER CAMYANMAR LETTER CHAMYANMAR LETTER J" +
	"AMYANMAR LETTER JHAMYANMAR LETTER NYAMYANMAR LETTER NNYAMYANMAR LETTER T" +
	"TAMYANMAR LETTER TTHAMYANMAR LETTER DDAMYANMAR LETTER DDHAMYANMAR LETTER" +
	" NNAMYANMAR LETTER TAMYANMAR LETTER THAMYANMAR LETTER DAMYANMAR LETTER D" +
	"HAMYANMAR LETTER NAMYANMAR LETTER PAMYANMAR LETTER PHAMYANMAR LETTER BAM" +
	"YANMAR LETTER BHAMYANMAR LETTER MAMYANMAR LETTER YAMYANMAR LETTER RAMYAN" +
	"MAR LETTER LAMYANMAR LETTER WAMYANMAR LETTER SAMYANMAR LETTER HAMYANMAR " +
	"LETTER LLAMYANMAR LETTER AMYANMAR LETTER SHAN AMYANMAR LETTER IMYANMAR L" +
	"ETTER IIMYANMAR LETTER UMYANMAR LETTER UUMYANMAR LETTER EMYANMAR LETTER " +
	"MON EMYANMAR LETTER OMYANMAR LETTER AUMYANMAR VOWEL SIGN TALL AAMYANMAR " +
	"VOWEL SIGN AAMYANMAR VOWEL SIGN IMYANMAR VOWEL SIGN IIMYANMAR VOWEL SIGN" +
	" UMYANMAR VOWEL SIGN UUMYANMAR VOWEL SIGN EMYANMAR VOWEL SIGN AIMYANMAR " +
	"VOWEL SIGN MON IIMYANMAR VOWEL SIGN MON OMYANMAR VOWEL SIGN E ABOVEMYANM" +
	"AR SIGN ANUSVARAMYANMAR SIGN DOT BELOWMYANMAR SIGN VISARGAMYANMAR SIGN V" +
	"IRAMAMYANMAR SIGN ASATMYANMAR CONSONANT SIGN MEDIAL YAMYANMAR CONSONANT " +
	"SIGN MEDIAL RAMYANMAR CONSONANT SIGN MEDIAL WAMYANMAR CONSONANT SIGN MED" +
	"IAL HAMYANMAR LETTER GREAT SAMYANMAR DIGIT ZEROMYANMAR DIGIT ONEMYANMAR " +
	"DIGIT TWOMYANMAR DIGIT THREEMYANMAR DIGIT FOURMYANMAR DIGIT FIVEMYANMAR " +
	"DIGIT SIXMYANMAR DIGIT SEVENMYANMAR DIGIT EIGHTMYANMAR DIGIT NINEMYANMAR" +
	" SIGN LITTLE SECTIONMYANMAR SIGN SECTIONMYANMAR SYMBOL LOCATIVEMYANMAR S" +
	"YMBOL COMPLETEDMYANMAR SYMBOL AFOREMENTIONEDMYANMAR SYMBOL GENITIVEMYANM" +
	"AR LETTER SHAMYANMAR LETTER SSAMYANMAR LETTER VOCALIC RMYANMAR LETTER VO" +
	"CALIC RRMYANMAR LETTER VOCALIC LMYANMAR LETTER VOCALIC LLMYANMAR VOWEL S" +
	"IGN VOCALIC RMYANMAR VOWEL SIGN VOCALIC RRMYANMAR VOWEL SIGN VOCALIC LMY" +
	"ANMAR VOWEL SIGN VOCALIC LLMYANMAR LETTER MON NGAMYANMAR LETTER MON JHAM" +
	"YANMAR LETTER MON BBAMYANMAR LETTER MON BBEMYANMAR CONSONANT SIGN MON ME" +
	"DIAL NAMYANMAR CONSONANT SIGN MON MEDIAL MAMYANMAR CONSONANT SIGN MON ME" +
	"DIAL LAMYANMAR LETTER SGAW KAREN SHAMYANMAR VOWEL SIGN SGAW KAREN EUMYAN" +
	"MAR TONE MARK SGAW KAREN HATHIMYANMAR TONE MARK SGAW KAREN KE PHOMYANMAR" +
	" LETTER WESTERN PWO KAREN THAMYANMAR LETTER WESTERN PWO KAREN PWAMYANMAR" +
	" VOWEL SIGN WESTERN PWO KAREN EUMYANMAR VOWEL SIGN WESTERN PWO KAREN UEM" +
	"YANMAR SIGN WESTERN PWO KAREN TONE-1MYANMAR SIGN WESTERN PWO KAREN TONE-" +
	"2MYANMAR SIGN WESTERN PWO KAREN TONE-3MYANMAR SIGN WESTERN PWO KAREN TON" +
	"E-4MYANMAR SIGN WESTERN PWO KAREN TONE-5MYANMAR LETTER EASTERN PWO KAREN" +
	" NNAMYANMAR LETTER EASTERN PWO KAREN YWAMYANMAR LETTER EASTERN PWO KAREN" +
	" GHWAMYANMAR VOWEL SIGN GEBA KAREN IMYANMAR VOWEL SIGN KAYAH OEMYANMAR V" +
	"OWEL SIGN KAYAH UMYANMAR VOWEL SIGN KAYAH EEMYANMAR LETTER SHAN KAMYANMA" +
	"R LETTER SHAN KHAMYANMAR LETTER SHAN GAMYANMAR LETTER SHAN CAMYANMAR LET" +
	"TER SHAN ZAMYANMAR LETTER SHAN NYAMYANMAR LETTER SHAN DAMYANMAR LETTER S" +
	"HAN NAMYANMAR LETTER SHAN PHAMYANMAR LETTER SHAN FAMYANMAR LETTER SHAN B" +
	"AMYANMAR LETTER SHAN THAMYANMAR LETTER SHAN HAMYANMAR CONSONANT SIGN SHA" +
	"N MEDIAL WAMYANMAR VOWEL SIGN SHAN AAMYANMAR VOWEL SIGN SHAN EMYANMAR VO" +
	"WEL SIGN SHAN E ABOVEMYANMAR VOWEL SIGN SHAN FINAL YMYANMAR SIGN SHAN TO" +
	"NE-2MYANMAR SIGN SHAN TONE-3MYANMAR SIGN SHAN TONE-5MYANMAR SIGN SHAN TO" +
	"NE-6MYANMAR SIGN SHAN COUNCIL TONE-2MYANMAR SIGN SHAN COUNCIL TONE-3MYAN" +
	"MAR SIGN SHAN COUNCIL EMPHATIC TONEMYANMAR LETTER RUMAI PALAUNG FAMYANMA" +
	"R SIGN RUMAI PALAUNG TONE-5MYANMAR SHAN DIGIT ZEROMYANMAR SHAN DIGIT ONE" +
	"MYANMAR SHAN DIGIT TWOMYANMAR SHAN DIGIT THREEMYANMAR SHAN DIGIT FOURMYA" +
	"NMAR SHAN DIGIT FIVEMYANMAR SHAN DIGIT SIXMYANMAR SHAN DIGIT SEVENMYANMA" +
	"R SHAN DIGIT EIGHTMYANMAR SHAN DIGIT NINEMYANMAR SIGN KHAMTI TONE-1MYANM" +
	"AR SIGN KHAMTI TONE-3MYANMAR VOWEL SIGN AITON AMYANMAR VOWEL SIGN AITON " +
	"AIMYANMAR SYMBOL SHAN ONEMYANMAR SYMBOL SHAN EXCLAMATIONGEORGIAN CAPITAL" +
	" LETTER ANGEORGIAN CAPITAL LETTER BANGEORGIAN CAPITAL LETTER GANGEORGIAN" +
	" CAPITAL LETTER DONGEORGIAN CAPITAL LETTER ENGEORGIAN CAPITAL LETTER VIN" +
	"GEORGIAN CAPITAL LETTER ZENGEORGIAN CAPITAL LETTER TANGEORGIAN CAPITAL L") + ("" +
	"ETTER INGEORGIAN CAPITAL LETTER KANGEORGIAN CAPITAL LETTER LASGEORGIAN C" +
	"APITAL LETTER MANGEORGIAN CAPITAL LETTER NARGEORGIAN CAPITAL LETTER ONGE" +
	"ORGIAN CAPITAL LETTER PARGEORGIAN CAPITAL LETTER ZHARGEORGIAN CAPITAL LE" +
	"TTER RAEGEORGIAN CAPITAL LETTER SANGEORGIAN CAPITAL LETTER TARGEORGIAN C" +
	"APITAL LETTER UNGEORGIAN CAPITAL LETTER PHARGEORGIAN CAPITAL LETTER KHAR" +
	"GEORGIAN CAPITAL LETTER GHANGEORGIAN CAPITAL LETTER QARGEORGIAN CAPITAL " +
	"LETTER SHINGEORGIAN CAPITAL LETTER CHINGEORGIAN CAPITAL LETTER CANGEORGI" +
	"AN CAPITAL LETTER JILGEORGIAN CAPITAL LETTER CILGEORGIAN CAPITAL LETTER " +
	"CHARGEORGIAN CAPITAL LETTER XANGEORGIAN CAPITAL LETTER JHANGEORGIAN CAPI" +
	"TAL LETTER HAEGEORGIAN CAPITAL LETTER HEGEORGIAN CAPITAL LETTER HIEGEORG" +
	"IAN CAPITAL LETTER WEGEORGIAN CAPITAL LETTER HARGEORGIAN CAPITAL LETTER " +
	"HOEGEORGIAN CAPITAL LETTER YNGEORGIAN CAPITAL LETTER AENGEORGIAN LETTER " +
	"ANGEORGIAN LETTER BANGEORGIAN LETTER GANGEORGIAN LETTER DONGEORGIAN LETT" +
	"ER ENGEORGIAN LETTER VINGEORGIAN LETTER ZENGEORGIAN LETTER TANGEORGIAN L" +
	"ETTER INGEORGIAN LETTER KANGEORGIAN LETTER LASGEORGIAN LETTER MANGEORGIA" +
	"N LETTER NARGEORGIAN LETTER ONGEORGIAN LETTER PARGEORGIAN LETTER ZHARGEO" +
	"RGIAN LETTER RAEGEORGIAN LETTER SANGEORGIAN LETTER TARGEORGIAN LETTER UN" +
	"GEORGIAN LETTER PHARGEORGIAN LETTER KHARGEORGIAN LETTER GHANGEORGIAN LET" +
	"TER QARGEORGIAN LETTER SHINGEORGIAN LETTER CHINGEORGIAN LETTER CANGEORGI" +
	"AN LETTER JILGEORGIAN LETTER CILGEORGIAN LETTER CHARGEORGIAN LETTER XANG" +
	"EORGIAN LETTER JHANGEORGIAN LETTER HAEGEORGIAN LETTER HEGEORGIAN LETTER " +
	"HIEGEORGIAN LETTER WEGEORGIAN LETTER HARGEORGIAN LETTER HOEGEORGIAN LETT" +
	"ER FIGEORGIAN LETTER YNGEORGIAN LETTER ELIFIGEORGIAN LETTER TURNED GANGE" +
	"ORGIAN LETTER AINGEORGIAN PARAGRAPH SEPARATORMODIFIER LETTER GEORGIAN NA" +
	"RGEORGIAN LETTER AENGEORGIAN LETTER HARD SIGNGEORGIAN LETTER LABIAL SIGN" +
	"HANGUL CHOSEONG KIYEOKHANGUL CHOSEONG SSANGKIYEOKHANGUL CHOSEONG NIEUNHA" +
	"NGUL CHOSEONG TIKEUTHANGUL CHOSEONG SSANGTIKEUTHANGUL CHOSEONG RIEULHANG" +
	"UL CHOSEONG MIEUMHANGUL CHOSEONG PIEUPHANGUL CHOSEONG SSANGPIEUPHANGUL C" +
	"HOSEONG SIOSHANGUL CHOSEONG SSANGSIOSHANGUL CHOSEONG IEUNGHANGUL CHOSEON" +
	"G CIEUCHANGUL CHOSEONG SSANGCIEUCHANGUL CHOSEONG CHIEUCHHANGUL CHOSEONG " +
	"KHIEUKHHANGUL CHOSEONG THIEUTHHANGUL CHOSEONG PHIEUPHHANGUL CHOSEONG HIE" +
	"UHHANGUL CHOSEONG NIEUN-KIYEOKHANGUL CHOSEONG SSANGNIEUNHANGUL CHOSEONG " +
	"NIEUN-TIKEUTHANGUL CHOSEONG NIEUN-PIEUPHANGUL CHOSEONG TIKEUT-KIYEOKHANG" +
	"UL CHOSEONG RIEUL-NIEUNHANGUL CHOSEONG SSANGRIEULHANGUL CHOSEONG RIEUL-H" +
	"IEUHHANGUL CHOSEONG KAPYEOUNRIEULHANGUL CHOSEONG MIEUM-PIEUPHANGUL CHOSE" +
	"ONG KAPYEOUNMIEUMHANGUL CHOSEONG PIEUP-KIYEOKHANGUL CHOSEONG PIEUP-NIEUN" +
	"HANGUL CHOSEONG PIEUP-TIKEUTHANGUL CHOSEONG PIEUP-SIOSHANGUL CHOSEONG PI" +
	"EUP-SIOS-KIYEOKHANGUL CHOSEONG PIEUP-SIOS-TIKEUTHANGUL CHOSEONG PIEUP-SI" +
	"OS-PIEUPHANGUL CHOSEONG PIEUP-SSANGSIOSHANGUL CHOSEONG PIEUP-SIOS-CIEUCH" +
	"ANGUL CHOSEONG PIEUP-CIEUCHANGUL CHOSEONG PIEUP-CHIEUCHHANGUL CHOSEONG P" +
	"IEUP-THIEUTHHANGUL CHOSEONG PIEUP-PHIEUPHHANGUL CHOSEONG KAPYEOUNPIEUPHA" +
	"NGUL CHOSEONG KAPYEOUNSSANGPIEUPHANGUL CHOSEONG SIOS-KIYEOKHANGUL CHOSEO" +
	"NG SIOS-NIEUNHANGUL CHOSEONG SIOS-TIKEUTHANGUL CHOSEONG SIOS-RIEULHANGUL" +
	" CHOSEONG SIOS-MIEUMHANGUL CHOSEONG SIOS-PIEUPHANGUL CHOSEONG SIOS-PIEUP" +
	"-KIYEOKHANGUL CHOSEONG SIOS-SSANGSIOSHANGUL CHOSEONG SIOS-IEUNGHANGUL CH" +
	"OSEONG SIOS-CIEUCHANGUL CHOSEONG SIOS-CHIEUCHHANGUL CHOSEONG SIOS-KHIEUK" +
	"HHANGUL CHOSEONG SIOS-THIEUTHHANGUL CHOSEONG SIOS-PHIEUPHHANGUL CHOSEONG" +
	" SIOS-HIEUHHANGUL CHOSEONG CHITUEUMSIOSHANGUL CHOSEONG CHITUEUMSSANGSIOS" +
	"HANGUL CHOSEONG CEONGCHIEUMSIOSHANGUL CHOSEONG CEONGCHIEUMSSANGSIOSHANGU" +
	"L CHOSEONG PANSIOSHANGUL CHOSEONG IEUNG-KIYEOKHANGUL CHOSEONG IEUNG-TIKE" +
	"UTHANGUL CHOSEONG IEUNG-MIEUMHANGUL CHOSEONG IEUNG-PIEUPHANGUL CHOSEONG " +
	"IEUNG-SIOSHANGUL CHOSEONG IEUNG-PANSIOSHANGUL CHOSEONG SSANGIEUNGHANGUL " +
	"CHOSEONG IEUNG-CIEUCHANGUL CHOSEONG IEUNG-CHIEUCHHANGUL CHOSEONG IEUNG-T" +
	"HIEUTHHANGUL CHOSEONG IEUNG-PHIEUPHHANGUL CHOSEONG YESIEUNGHANGUL CHOSEO" +
	"NG CIEUC-IEUNGHANGUL CHOSEONG CHITUEUMCIEUCHANGUL CHOSEONG CHITUEUMSSANG" +
	"CIEUCHANGUL CHOSEONG CEONGCHIEUMCIEUCHANGUL CHOSEONG CEONGCHIEUMSSANGCIE" +
	"UCHANGUL CHOSEONG CHIEUCH-KHIEUKHHANGUL CHOSEONG CHIEUCH-HIEUHHANGUL CHO" +
	"SEONG CHITUEUMCHIEUCHHANGUL CHOSEONG CEONGCHIEUMCHIEUCHHANGUL CHOSEONG P" +
	"HIEUPH-PIEUPHANGUL CHOSEONG KAPYEOUNPHIEUPHHANGUL CHOSEONG SSANGHIEUHHAN" +
	"GUL CHOSEONG YEORINHIEUHHANGUL CHOSEONG KIYEOK-TIKEUTHANGUL CHOSEONG NIE" +
	"UN-SIOSHANGUL CHOSEONG NIEUN-CIEUCHANGUL CHOSEONG NIEUN-HIEUHHANGUL CHOS" +
	"EONG TIKEUT-RIEULHANGUL CHOSEONG FILLERHANGUL JUNGSEONG FILLERHANGUL JUN" +
	"GSEONG AHANGUL JUNGSEONG AEHANGUL JUNGSEONG YAHANGUL JUNGSEONG YAEHANGUL" +
	" JUNGSEONG EOHANGUL JUNGSEONG EHANGUL JUNGSEONG YEOHANGUL JUNGSEONG YEHA") + ("" +
	"NGUL JUNGSEONG OHANGUL JUNGSEONG WAHANGUL JUNGSEONG WAEHANGUL JUNGSEONG " +
	"OEHANGUL JUNGSEONG YOHANGUL JUNGSEONG UHANGUL JUNGSEONG WEOHANGUL JUNGSE" +
	"ONG WEHANGUL JUNGSEONG WIHANGUL JUNGSEONG YUHANGUL JUNGSEONG EUHANGUL JU" +
	"NGSEONG YIHANGUL JUNGSEONG IHANGUL JUNGSEONG A-OHANGUL JUNGSEONG A-UHANG" +
	"UL JUNGSEONG YA-OHANGUL JUNGSEONG YA-YOHANGUL JUNGSEONG EO-OHANGUL JUNGS" +
	"EONG EO-UHANGUL JUNGSEONG EO-EUHANGUL JUNGSEONG YEO-OHANGUL JUNGSEONG YE" +
	"O-UHANGUL JUNGSEONG O-EOHANGUL JUNGSEONG O-EHANGUL JUNGSEONG O-YEHANGUL " +
	"JUNGSEONG O-OHANGUL JUNGSEONG O-UHANGUL JUNGSEONG YO-YAHANGUL JUNGSEONG " +
	"YO-YAEHANGUL JUNGSEONG YO-YEOHANGUL JUNGSEONG YO-OHANGUL JUNGSEONG YO-IH" +
	"ANGUL JUNGSEONG U-AHANGUL JUNGSEONG U-AEHANGUL JUNGSEONG U-EO-EUHANGUL J" +
	"UNGSEONG U-YEHANGUL JUNGSEONG U-UHANGUL JUNGSEONG YU-AHANGUL JUNGSEONG Y" +
	"U-EOHANGUL JUNGSEONG YU-EHANGUL JUNGSEONG YU-YEOHANGUL JUNGSEONG YU-YEHA" +
	"NGUL JUNGSEONG YU-UHANGUL JUNGSEONG YU-IHANGUL JUNGSEONG EU-UHANGUL JUNG" +
	"SEONG EU-EUHANGUL JUNGSEONG YI-UHANGUL JUNGSEONG I-AHANGUL JUNGSEONG I-Y" +
	"AHANGUL JUNGSEONG I-OHANGUL JUNGSEONG I-UHANGUL JUNGSEONG I-EUHANGUL JUN" +
	"GSEONG I-ARAEAHANGUL JUNGSEONG ARAEAHANGUL JUNGSEONG ARAEA-EOHANGUL JUNG" +
	"SEONG ARAEA-UHANGUL JUNGSEONG ARAEA-IHANGUL JUNGSEONG SSANGARAEAHANGUL J" +
	"UNGSEONG A-EUHANGUL JUNGSEONG YA-UHANGUL JUNGSEONG YEO-YAHANGUL JUNGSEON" +
	"G O-YAHANGUL JUNGSEONG O-YAEHANGUL JONGSEONG KIYEOKHANGUL JONGSEONG SSAN" +
	"GKIYEOKHANGUL JONGSEONG KIYEOK-SIOSHANGUL JONGSEONG NIEUNHANGUL JONGSEON" +
	"G NIEUN-CIEUCHANGUL JONGSEONG NIEUN-HIEUHHANGUL JONGSEONG TIKEUTHANGUL J" +
	"ONGSEONG RIEULHANGUL JONGSEONG RIEUL-KIYEOKHANGUL JONGSEONG RIEUL-MIEUMH" +
	"ANGUL JONGSEONG RIEUL-PIEUPHANGUL JONGSEONG RIEUL-SIOSHANGUL JONGSEONG R" +
	"IEUL-THIEUTHHANGUL JONGSEONG RIEUL-PHIEUPHHANGUL JONGSEONG RIEUL-HIEUHHA" +
	"NGUL JONGSEONG MIEUMHANGUL JONGSEONG PIEUPHANGUL JONGSEONG PIEUP-SIOSHAN" +
	"GUL JONGSEONG SIOSHANGUL JONGSEONG SSANGSIOSHANGUL JONGSEONG IEUNGHANGUL" +
	" JONGSEONG CIEUCHANGUL JONGSEONG CHIEUCHHANGUL JONGSEONG KHIEUKHHANGUL J" +
	"ONGSEONG THIEUTHHANGUL JONGSEONG PHIEUPHHANGUL JONGSEONG HIEUHHANGUL JON" +
	"GSEONG KIYEOK-RIEULHANGUL JONGSEONG KIYEOK-SIOS-KIYEOKHANGUL JONGSEONG N" +
	"IEUN-KIYEOKHANGUL JONGSEONG NIEUN-TIKEUTHANGUL JONGSEONG NIEUN-SIOSHANGU" +
	"L JONGSEONG NIEUN-PANSIOSHANGUL JONGSEONG NIEUN-THIEUTHHANGUL JONGSEONG " +
	"TIKEUT-KIYEOKHANGUL JONGSEONG TIKEUT-RIEULHANGUL JONGSEONG RIEUL-KIYEOK-" +
	"SIOSHANGUL JONGSEONG RIEUL-NIEUNHANGUL JONGSEONG RIEUL-TIKEUTHANGUL JONG" +
	"SEONG RIEUL-TIKEUT-HIEUHHANGUL JONGSEONG SSANGRIEULHANGUL JONGSEONG RIEU" +
	"L-MIEUM-KIYEOKHANGUL JONGSEONG RIEUL-MIEUM-SIOSHANGUL JONGSEONG RIEUL-PI" +
	"EUP-SIOSHANGUL JONGSEONG RIEUL-PIEUP-HIEUHHANGUL JONGSEONG RIEUL-KAPYEOU" +
	"NPIEUPHANGUL JONGSEONG RIEUL-SSANGSIOSHANGUL JONGSEONG RIEUL-PANSIOSHANG" +
	"UL JONGSEONG RIEUL-KHIEUKHHANGUL JONGSEONG RIEUL-YEORINHIEUHHANGUL JONGS" +
	"EONG MIEUM-KIYEOKHANGUL JONGSEONG MIEUM-RIEULHANGUL JONGSEONG MIEUM-PIEU" +
	"PHANGUL JONGSEONG MIEUM-SIOSHANGUL JONGSEONG MIEUM-SSANGSIOSHANGUL JONGS" +
	"EONG MIEUM-PANSIOSHANGUL JONGSEONG MIEUM-CHIEUCHHANGUL JONGSEONG MIEUM-H" +
	"IEUHHANGUL JONGSEONG KAPYEOUNMIEUMHANGUL JONGSEONG PIEUP-RIEULHANGUL JON" +
	"GSEONG PIEUP-PHIEUPHHANGUL JONGSEONG PIEUP-HIEUHHANGUL JONGSEONG KAPYEOU" +
	"NPIEUPHANGUL JONGSEONG SIOS-KIYEOKHANGUL JONGSEONG SIOS-TIKEUTHANGUL JON" +
	"GSEONG SIOS-RIEULHANGUL JONGSEONG SIOS-PIEUPHANGUL JONGSEONG PANSIOSHANG" +
	"UL JONGSEONG IEUNG-KIYEOKHANGUL JONGSEONG IEUNG-SSANGKIYEOKHANGUL JONGSE" +
	"ONG SSANGIEUNGHANGUL JONGSEONG IEUNG-KHIEUKHHANGUL JONGSEONG YESIEUNGHAN" +
	"GUL JONGSEONG YESIEUNG-SIOSHANGUL JONGSEONG YESIEUNG-PANSIOSHANGUL JONGS" +
	"EONG PHIEUPH-PIEUPHANGUL JONGSEONG KAPYEOUNPHIEUPHHANGUL JONGSEONG HIEUH" +
	"-NIEUNHANGUL JONGSEONG HIEUH-RIEULHANGUL JONGSEONG HIEUH-MIEUMHANGUL JON" +
	"GSEONG HIEUH-PIEUPHANGUL JONGSEONG YEORINHIEUHHANGUL JONGSEONG KIYEOK-NI" +
	"EUNHANGUL JONGSEONG KIYEOK-PIEUPHANGUL JONGSEONG KIYEOK-CHIEUCHHANGUL JO" +
	"NGSEONG KIYEOK-KHIEUKHHANGUL JONGSEONG KIYEOK-HIEUHHANGUL JONGSEONG SSAN" +
	"GNIEUNETHIOPIC SYLLABLE HAETHIOPIC SYLLABLE HUETHIOPIC SYLLABLE HIETHIOP" +
	"IC SYLLABLE HAAETHIOPIC SYLLABLE HEEETHIOPIC SYLLABLE HEETHIOPIC SYLLABL" +
	"E HOETHIOPIC SYLLABLE HOAETHIOPIC SYLLABLE LAETHIOPIC SYLLABLE LUETHIOPI" +
	"C SYLLABLE LIETHIOPIC SYLLABLE LAAETHIOPIC SYLLABLE LEEETHIOPIC SYLLABLE" +
	" LEETHIOPIC SYLLABLE LOETHIOPIC SYLLABLE LWAETHIOPIC SYLLABLE HHAETHIOPI" +
	"C SYLLABLE HHUETHIOPIC SYLLABLE HHIETHIOPIC SYLLABLE HHAAETHIOPIC SYLLAB" +
	"LE HHEEETHIOPIC SYLLABLE HHEETHIOPIC SYLLABLE HHOETHIOPIC SYLLABLE HHWAE" +
	"THIOPIC SYLLABLE MAETHIOPIC SYLLABLE MUETHIOPIC SYLLABLE MIETHIOPIC SYLL" +
	"ABLE MAAETHIOPIC SYLLABLE MEEETHIOPIC SYLLABLE MEETHIOPIC SYLLABLE MOETH" +
	"IOPIC SYLLABLE MWAETHIOPIC SYLLABLE SZAETHIOPIC SYLLABLE SZUETHIOPIC SYL" +
	"LABLE SZIETHIOPIC SYLLABLE SZAAETHIOPIC SYLLABLE SZEEETHIOPIC SYLLABLE S") + ("" +
	"ZEETHIOPIC SYLLABLE SZOETHIOPIC SYLLABLE SZWAETHIOPIC SYLLABLE RAETHIOPI" +
	"C SYLLABLE RUETHIOPIC SYLLABLE RIETHIOPIC SYLLABLE RAAETHIOPIC SYLLABLE " +
	"REEETHIOPIC SYLLABLE REETHIOPIC SYLLABLE ROETHIOPIC SYLLABLE RWAETHIOPIC" +
	" SYLLABLE SAETHIOPIC SYLLABLE SUETHIOPIC SYLLABLE SIETHIOPIC SYLLABLE SA" +
	"AETHIOPIC SYLLABLE SEEETHIOPIC SYLLABLE SEETHIOPIC SYLLABLE SOETHIOPIC S" +
	"YLLABLE SWAETHIOPIC SYLLABLE SHAETHIOPIC SYLLABLE SHUETHIOPIC SYLLABLE S" +
	"HIETHIOPIC SYLLABLE SHAAETHIOPIC SYLLABLE SHEEETHIOPIC SYLLABLE SHEETHIO" +
	"PIC SYLLABLE SHOETHIOPIC SYLLABLE SHWAETHIOPIC SYLLABLE QAETHIOPIC SYLLA" +
	"BLE QUETHIOPIC SYLLABLE QIETHIOPIC SYLLABLE QAAETHIOPIC SYLLABLE QEEETHI" +
	"OPIC SYLLABLE QEETHIOPIC SYLLABLE QOETHIOPIC SYLLABLE QOAETHIOPIC SYLLAB" +
	"LE QWAETHIOPIC SYLLABLE QWIETHIOPIC SYLLABLE QWAAETHIOPIC SYLLABLE QWEEE" +
	"THIOPIC SYLLABLE QWEETHIOPIC SYLLABLE QHAETHIOPIC SYLLABLE QHUETHIOPIC S" +
	"YLLABLE QHIETHIOPIC SYLLABLE QHAAETHIOPIC SYLLABLE QHEEETHIOPIC SYLLABLE" +
	" QHEETHIOPIC SYLLABLE QHOETHIOPIC SYLLABLE QHWAETHIOPIC SYLLABLE QHWIETH" +
	"IOPIC SYLLABLE QHWAAETHIOPIC SYLLABLE QHWEEETHIOPIC SYLLABLE QHWEETHIOPI" +
	"C SYLLABLE BAETHIOPIC SYLLABLE BUETHIOPIC SYLLABLE BIETHIOPIC SYLLABLE B" +
	"AAETHIOPIC SYLLABLE BEEETHIOPIC SYLLABLE BEETHIOPIC SYLLABLE BOETHIOPIC " +
	"SYLLABLE BWAETHIOPIC SYLLABLE VAETHIOPIC SYLLABLE VUETHIOPIC SYLLABLE VI" +
	"ETHIOPIC SYLLABLE VAAETHIOPIC SYLLABLE VEEETHIOPIC SYLLABLE VEETHIOPIC S" +
	"YLLABLE VOETHIOPIC SYLLABLE VWAETHIOPIC SYLLABLE TAETHIOPIC SYLLABLE TUE" +
	"THIOPIC SYLLABLE TIETHIOPIC SYLLABLE TAAETHIOPIC SYLLABLE TEEETHIOPIC SY" +
	"LLABLE TEETHIOPIC SYLLABLE TOETHIOPIC SYLLABLE TWAETHIOPIC SYLLABLE CAET" +
	"HIOPIC SYLLABLE CUETHIOPIC SYLLABLE CIETHIOPIC SYLLABLE CAAETHIOPIC SYLL" +
	"ABLE CEEETHIOPIC SYLLABLE CEETHIOPIC SYLLABLE COETHIOPIC SYLLABLE CWAETH" +
	"IOPIC SYLLABLE XAETHIOPIC SYLLABLE XUETHIOPIC SYLLABLE XIETHIOPIC SYLLAB" +
	"LE XAAETHIOPIC SYLLABLE XEEETHIOPIC SYLLABLE XEETHIOPIC SYLLABLE XOETHIO" +
	"PIC SYLLABLE XOAETHIOPIC SYLLABLE XWAETHIOPIC SYLLABLE XWIETHIOPIC SYLLA" +
	"BLE XWAAETHIOPIC SYLLABLE XWEEETHIOPIC SYLLABLE XWEETHIOPIC SYLLABLE NAE" +
	"THIOPIC SYLLABLE NUETHIOPIC SYLLABLE NIETHIOPIC SYLLABLE NAAETHIOPIC SYL" +
	"LABLE NEEETHIOPIC SYLLABLE NEETHIOPIC SYLLABLE NOETHIOPIC SYLLABLE NWAET" +
	"HIOPIC SYLLABLE NYAETHIOPIC SYLLABLE NYUETHIOPIC SYLLABLE NYIETHIOPIC SY" +
	"LLABLE NYAAETHIOPIC SYLLABLE NYEEETHIOPIC SYLLABLE NYEETHIOPIC SYLLABLE " +
	"NYOETHIOPIC SYLLABLE NYWAETHIOPIC SYLLABLE GLOTTAL AETHIOPIC SYLLABLE GL" +
	"OTTAL UETHIOPIC SYLLABLE GLOTTAL IETHIOPIC SYLLABLE GLOTTAL AAETHIOPIC S" +
	"YLLABLE GLOTTAL EEETHIOPIC SYLLABLE GLOTTAL EETHIOPIC SYLLABLE GLOTTAL O" +
	"ETHIOPIC SYLLABLE GLOTTAL WAETHIOPIC SYLLABLE KAETHIOPIC SYLLABLE KUETHI" +
	"OPIC SYLLABLE KIETHIOPIC SYLLABLE KAAETHIOPIC SYLLABLE KEEETHIOPIC SYLLA" +
	"BLE KEETHIOPIC SYLLABLE KOETHIOPIC SYLLABLE KOAETHIOPIC SYLLABLE KWAETHI" +
	"OPIC SYLLABLE KWIETHIOPIC SYLLABLE KWAAETHIOPIC SYLLABLE KWEEETHIOPIC SY" +
	"LLABLE KWEETHIOPIC SYLLABLE KXAETHIOPIC SYLLABLE KXUETHIOPIC SYLLABLE KX" +
	"IETHIOPIC SYLLABLE KXAAETHIOPIC SYLLABLE KXEEETHIOPIC SYLLABLE KXEETHIOP" +
	"IC SYLLABLE KXOETHIOPIC SYLLABLE KXWAETHIOPIC SYLLABLE KXWIETHIOPIC SYLL" +
	"ABLE KXWAAETHIOPIC SYLLABLE KXWEEETHIOPIC SYLLABLE KXWEETHIOPIC SYLLABLE" +
	" WAETHIOPIC SYLLABLE WUETHIOPIC SYLLABLE WIETHIOPIC SYLLABLE WAAETHIOPIC" +
	" SYLLABLE WEEETHIOPIC SYLLABLE WEETHIOPIC SYLLABLE WOETHIOPIC SYLLABLE W" +
	"OAETHIOPIC SYLLABLE PHARYNGEAL AETHIOPIC SYLLABLE PHARYNGEAL UETHIOPIC S" +
	"YLLABLE PHARYNGEAL IETHIOPIC SYLLABLE PHARYNGEAL AAETHIOPIC SYLLABLE PHA" +
	"RYNGEAL EEETHIOPIC SYLLABLE PHARYNGEAL EETHIOPIC SYLLABLE PHARYNGEAL OET" +
	"HIOPIC SYLLABLE ZAETHIOPIC SYLLABLE ZUETHIOPIC SYLLABLE ZIETHIOPIC SYLLA" +
	"BLE ZAAETHIOPIC SYLLABLE ZEEETHIOPIC SYLLABLE ZEETHIOPIC SYLLABLE ZOETHI" +
	"OPIC SYLLABLE ZWAETHIOPIC SYLLABLE ZHAETHIOPIC SYLLABLE ZHUETHIOPIC SYLL" +
	"ABLE ZHIETHIOPIC SYLLABLE ZHAAETHIOPIC SYLLABLE ZHEEETHIOPIC SYLLABLE ZH" +
	"EETHIOPIC SYLLABLE ZHOETHIOPIC SYLLABLE ZHWAETHIOPIC SYLLABLE YAETHIOPIC" +
	" SYLLABLE YUETHIOPIC SYLLABLE YIETHIOPIC SYLLABLE YAAETHIOPIC SYLLABLE Y" +
	"EEETHIOPIC SYLLABLE YEETHIOPIC SYLLABLE YOETHIOPIC SYLLABLE YOAETHIOPIC " +
	"SYLLABLE DAETHIOPIC SYLLABLE DUETHIOPIC SYLLABLE DIETHIOPIC SYLLABLE DAA" +
	"ETHIOPIC SYLLABLE DEEETHIOPIC SYLLABLE DEETHIOPIC SYLLABLE DOETHIOPIC SY" +
	"LLABLE DWAETHIOPIC SYLLABLE DDAETHIOPIC SYLLABLE DDUETHIOPIC SYLLABLE DD" +
	"IETHIOPIC SYLLABLE DDAAETHIOPIC SYLLABLE DDEEETHIOPIC SYLLABLE DDEETHIOP" +
	"IC SYLLABLE DDOETHIOPIC SYLLABLE DDWAETHIOPIC SYLLABLE JAETHIOPIC SYLLAB" +
	"LE JUETHIOPIC SYLLABLE JIETHIOPIC SYLLABLE JAAETHIOPIC SYLLABLE JEEETHIO" +
	"PIC SYLLABLE JEETHIOPIC SYLLABLE JOETHIOPIC SYLLABLE JWAETHIOPIC SYLLABL" +
	"E GAETHIOPIC SYLLABLE GUETHIOPIC SYLLABLE GIETHIOPIC SYLLABLE GAAETHIOPI" +
	"C SYLLABLE GEEETHIOPIC SYLLABLE GEETHIOPIC SYLLABLE GOETHIOPIC SYLLABLE ") + ("" +
	"GOAETHIOPIC SYLLABLE GWAETHIOPIC SYLLABLE GWIETHIOPIC SYLLABLE GWAAETHIO" +
	"PIC SYLLABLE GWEEETHIOPIC SYLLABLE GWEETHIOPIC SYLLABLE GGAETHIOPIC SYLL" +
	"ABLE GGUETHIOPIC SYLLABLE GGIETHIOPIC SYLLABLE GGAAETHIOPIC SYLLABLE GGE" +
	"EETHIOPIC SYLLABLE GGEETHIOPIC SYLLABLE GGOETHIOPIC SYLLABLE GGWAAETHIOP" +
	"IC SYLLABLE THAETHIOPIC SYLLABLE THUETHIOPIC SYLLABLE THIETHIOPIC SYLLAB" +
	"LE THAAETHIOPIC SYLLABLE THEEETHIOPIC SYLLABLE THEETHIOPIC SYLLABLE THOE" +
	"THIOPIC SYLLABLE THWAETHIOPIC SYLLABLE CHAETHIOPIC SYLLABLE CHUETHIOPIC " +
	"SYLLABLE CHIETHIOPIC SYLLABLE CHAAETHIOPIC SYLLABLE CHEEETHIOPIC SYLLABL" +
	"E CHEETHIOPIC SYLLABLE CHOETHIOPIC SYLLABLE CHWAETHIOPIC SYLLABLE PHAETH" +
	"IOPIC SYLLABLE PHUETHIOPIC SYLLABLE PHIETHIOPIC SYLLABLE PHAAETHIOPIC SY" +
	"LLABLE PHEEETHIOPIC SYLLABLE PHEETHIOPIC SYLLABLE PHOETHIOPIC SYLLABLE P" +
	"HWAETHIOPIC SYLLABLE TSAETHIOPIC SYLLABLE TSUETHIOPIC SYLLABLE TSIETHIOP" +
	"IC SYLLABLE TSAAETHIOPIC SYLLABLE TSEEETHIOPIC SYLLABLE TSEETHIOPIC SYLL" +
	"ABLE TSOETHIOPIC SYLLABLE TSWAETHIOPIC SYLLABLE TZAETHIOPIC SYLLABLE TZU" +
	"ETHIOPIC SYLLABLE TZIETHIOPIC SYLLABLE TZAAETHIOPIC SYLLABLE TZEEETHIOPI" +
	"C SYLLABLE TZEETHIOPIC SYLLABLE TZOETHIOPIC SYLLABLE TZOAETHIOPIC SYLLAB" +
	"LE FAETHIOPIC SYLLABLE FUETHIOPIC SYLLABLE FIETHIOPIC SYLLABLE FAAETHIOP" +
	"IC SYLLABLE FEEETHIOPIC SYLLABLE FEETHIOPIC SYLLABLE FOETHIOPIC SYLLABLE" +
	" FWAETHIOPIC SYLLABLE PAETHIOPIC SYLLABLE PUETHIOPIC SYLLABLE PIETHIOPIC" +
	" SYLLABLE PAAETHIOPIC SYLLABLE PEEETHIOPIC SYLLABLE PEETHIOPIC SYLLABLE " +
	"POETHIOPIC SYLLABLE PWAETHIOPIC SYLLABLE RYAETHIOPIC SYLLABLE MYAETHIOPI" +
	"C SYLLABLE FYAETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARKETHIOPI" +
	"C COMBINING VOWEL LENGTH MARKETHIOPIC COMBINING GEMINATION MARKETHIOPIC " +
	"SECTION MARKETHIOPIC WORDSPACEETHIOPIC FULL STOPETHIOPIC COMMAETHIOPIC S" +
	"EMICOLONETHIOPIC COLONETHIOPIC PREFACE COLONETHIOPIC QUESTION MARKETHIOP" +
	"IC PARAGRAPH SEPARATORETHIOPIC DIGIT ONEETHIOPIC DIGIT TWOETHIOPIC DIGIT" +
	" THREEETHIOPIC DIGIT FOURETHIOPIC DIGIT FIVEETHIOPIC DIGIT SIXETHIOPIC D" +
	"IGIT SEVENETHIOPIC DIGIT EIGHTETHIOPIC DIGIT NINEETHIOPIC NUMBER TENETHI" +
	"OPIC NUMBER TWENTYETHIOPIC NUMBER THIRTYETHIOPIC NUMBER FORTYETHIOPIC NU" +
	"MBER FIFTYETHIOPIC NUMBER SIXTYETHIOPIC NUMBER SEVENTYETHIOPIC NUMBER EI" +
	"GHTYETHIOPIC NUMBER NINETYETHIOPIC NUMBER HUNDREDETHIOPIC NUMBER TEN THO" +
	"USANDETHIOPIC SYLLABLE SEBATBEIT MWAETHIOPIC SYLLABLE MWIETHIOPIC SYLLAB" +
	"LE MWEEETHIOPIC SYLLABLE MWEETHIOPIC SYLLABLE SEBATBEIT BWAETHIOPIC SYLL" +
	"ABLE BWIETHIOPIC SYLLABLE BWEEETHIOPIC SYLLABLE BWEETHIOPIC SYLLABLE SEB" +
	"ATBEIT FWAETHIOPIC SYLLABLE FWIETHIOPIC SYLLABLE FWEEETHIOPIC SYLLABLE F" +
	"WEETHIOPIC SYLLABLE SEBATBEIT PWAETHIOPIC SYLLABLE PWIETHIOPIC SYLLABLE " +
	"PWEEETHIOPIC SYLLABLE PWEETHIOPIC TONAL MARK YIZETETHIOPIC TONAL MARK DE" +
	"RETETHIOPIC TONAL MARK RIKRIKETHIOPIC TONAL MARK SHORT RIKRIKETHIOPIC TO" +
	"NAL MARK DIFATETHIOPIC TONAL MARK KENATETHIOPIC TONAL MARK CHIRETETHIOPI" +
	"C TONAL MARK HIDETETHIOPIC TONAL MARK DERET-HIDETETHIOPIC TONAL MARK KUR" +
	"TCHEROKEE LETTER ACHEROKEE LETTER ECHEROKEE LETTER ICHEROKEE LETTER OCHE" +
	"ROKEE LETTER UCHEROKEE LETTER VCHEROKEE LETTER GACHEROKEE LETTER KACHERO" +
	"KEE LETTER GECHEROKEE LETTER GICHEROKEE LETTER GOCHEROKEE LETTER GUCHERO" +
	"KEE LETTER GVCHEROKEE LETTER HACHEROKEE LETTER HECHEROKEE LETTER HICHERO" +
	"KEE LETTER HOCHEROKEE LETTER HUCHEROKEE LETTER HVCHEROKEE LETTER LACHERO" +
	"KEE LETTER LECHEROKEE LETTER LICHEROKEE LETTER LOCHEROKEE LETTER LUCHERO" +
	"KEE LETTER LVCHEROKEE LETTER MACHEROKEE LETTER MECHEROKEE LETTER MICHERO" +
	"KEE LETTER MOCHEROKEE LETTER MUCHEROKEE LETTER NACHEROKEE LETTER HNACHER" +
	"OKEE LETTER NAHCHEROKEE LETTER NECHEROKEE LETTER NICHEROKEE LETTER NOCHE" +
	"ROKEE LETTER NUCHEROKEE LETTER NVCHEROKEE LETTER QUACHEROKEE LETTER QUEC" +
	"HEROKEE LETTER QUICHEROKEE LETTER QUOCHEROKEE LETTER QUUCHEROKEE LETTER " +
	"QUVCHEROKEE LETTER SACHEROKEE LETTER SCHEROKEE LETTER SECHEROKEE LETTER " +
	"SICHEROKEE LETTER SOCHEROKEE LETTER SUCHEROKEE LETTER SVCHEROKEE LETTER " +
	"DACHEROKEE LETTER TACHEROKEE LETTER DECHEROKEE LETTER TECHEROKEE LETTER " +
	"DICHEROKEE LETTER TICHEROKEE LETTER DOCHEROKEE LETTER DUCHEROKEE LETTER " +
	"DVCHEROKEE LETTER DLACHEROKEE LETTER TLACHEROKEE LETTER TLECHEROKEE LETT" +
	"ER TLICHEROKEE LETTER TLOCHEROKEE LETTER TLUCHEROKEE LETTER TLVCHEROKEE " +
	"LETTER TSACHEROKEE LETTER TSECHEROKEE LETTER TSICHEROKEE LETTER TSOCHERO" +
	"KEE LETTER TSUCHEROKEE LETTER TSVCHEROKEE LETTER WACHEROKEE LETTER WECHE" +
	"ROKEE LETTER WICHEROKEE LETTER WOCHEROKEE LETTER WUCHEROKEE LETTER WVCHE" +
	"ROKEE LETTER YACHEROKEE LETTER YECHEROKEE LETTER YICHEROKEE LETTER YOCHE" +
	"ROKEE LETTER YUCHEROKEE LETTER YVCHEROKEE LETTER MVCHEROKEE SMALL LETTER" +
	" YECHEROKEE SMALL LETTER YICHEROKEE SMALL LETTER YOCHEROKEE SMALL LETTER" +
	" YUCHEROKEE SMALL LETTER YVCHEROKEE SMALL LETTER MVCANADIAN SYLLABICS HY") + ("" +
	"PHENCANADIAN SYLLABICS ECANADIAN SYLLABICS AAICANADIAN SYLLABICS ICANADI" +
	"AN SYLLABICS IICANADIAN SYLLABICS OCANADIAN SYLLABICS OOCANADIAN SYLLABI" +
	"CS Y-CREE OOCANADIAN SYLLABICS CARRIER EECANADIAN SYLLABICS CARRIER ICAN" +
	"ADIAN SYLLABICS ACANADIAN SYLLABICS AACANADIAN SYLLABICS WECANADIAN SYLL" +
	"ABICS WEST-CREE WECANADIAN SYLLABICS WICANADIAN SYLLABICS WEST-CREE WICA" +
	"NADIAN SYLLABICS WIICANADIAN SYLLABICS WEST-CREE WIICANADIAN SYLLABICS W" +
	"OCANADIAN SYLLABICS WEST-CREE WOCANADIAN SYLLABICS WOOCANADIAN SYLLABICS" +
	" WEST-CREE WOOCANADIAN SYLLABICS NASKAPI WOOCANADIAN SYLLABICS WACANADIA" +
	"N SYLLABICS WEST-CREE WACANADIAN SYLLABICS WAACANADIAN SYLLABICS WEST-CR" +
	"EE WAACANADIAN SYLLABICS NASKAPI WAACANADIAN SYLLABICS AICANADIAN SYLLAB" +
	"ICS Y-CREE WCANADIAN SYLLABICS GLOTTAL STOPCANADIAN SYLLABICS FINAL ACUT" +
	"ECANADIAN SYLLABICS FINAL GRAVECANADIAN SYLLABICS FINAL BOTTOM HALF RING" +
	"CANADIAN SYLLABICS FINAL TOP HALF RINGCANADIAN SYLLABICS FINAL RIGHT HAL" +
	"F RINGCANADIAN SYLLABICS FINAL RINGCANADIAN SYLLABICS FINAL DOUBLE ACUTE" +
	"CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKESCANADIAN SYLLABICS" +
	" FINAL MIDDLE DOTCANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKECANADIA" +
	"N SYLLABICS FINAL PLUSCANADIAN SYLLABICS FINAL DOWN TACKCANADIAN SYLLABI" +
	"CS ENCANADIAN SYLLABICS INCANADIAN SYLLABICS ONCANADIAN SYLLABICS ANCANA" +
	"DIAN SYLLABICS PECANADIAN SYLLABICS PAAICANADIAN SYLLABICS PICANADIAN SY" +
	"LLABICS PIICANADIAN SYLLABICS POCANADIAN SYLLABICS POOCANADIAN SYLLABICS" +
	" Y-CREE POOCANADIAN SYLLABICS CARRIER HEECANADIAN SYLLABICS CARRIER HICA" +
	"NADIAN SYLLABICS PACANADIAN SYLLABICS PAACANADIAN SYLLABICS PWECANADIAN " +
	"SYLLABICS WEST-CREE PWECANADIAN SYLLABICS PWICANADIAN SYLLABICS WEST-CRE" +
	"E PWICANADIAN SYLLABICS PWIICANADIAN SYLLABICS WEST-CREE PWIICANADIAN SY" +
	"LLABICS PWOCANADIAN SYLLABICS WEST-CREE PWOCANADIAN SYLLABICS PWOOCANADI" +
	"AN SYLLABICS WEST-CREE PWOOCANADIAN SYLLABICS PWACANADIAN SYLLABICS WEST" +
	"-CREE PWACANADIAN SYLLABICS PWAACANADIAN SYLLABICS WEST-CREE PWAACANADIA" +
	"N SYLLABICS Y-CREE PWAACANADIAN SYLLABICS PCANADIAN SYLLABICS WEST-CREE " +
	"PCANADIAN SYLLABICS CARRIER HCANADIAN SYLLABICS TECANADIAN SYLLABICS TAA" +
	"ICANADIAN SYLLABICS TICANADIAN SYLLABICS TIICANADIAN SYLLABICS TOCANADIA" +
	"N SYLLABICS TOOCANADIAN SYLLABICS Y-CREE TOOCANADIAN SYLLABICS CARRIER D" +
	"EECANADIAN SYLLABICS CARRIER DICANADIAN SYLLABICS TACANADIAN SYLLABICS T" +
	"AACANADIAN SYLLABICS TWECANADIAN SYLLABICS WEST-CREE TWECANADIAN SYLLABI" +
	"CS TWICANADIAN SYLLABICS WEST-CREE TWICANADIAN SYLLABICS TWIICANADIAN SY" +
	"LLABICS WEST-CREE TWIICANADIAN SYLLABICS TWOCANADIAN SYLLABICS WEST-CREE" +
	" TWOCANADIAN SYLLABICS TWOOCANADIAN SYLLABICS WEST-CREE TWOOCANADIAN SYL" +
	"LABICS TWACANADIAN SYLLABICS WEST-CREE TWACANADIAN SYLLABICS TWAACANADIA" +
	"N SYLLABICS WEST-CREE TWAACANADIAN SYLLABICS NASKAPI TWAACANADIAN SYLLAB" +
	"ICS TCANADIAN SYLLABICS TTECANADIAN SYLLABICS TTICANADIAN SYLLABICS TTOC" +
	"ANADIAN SYLLABICS TTACANADIAN SYLLABICS KECANADIAN SYLLABICS KAAICANADIA" +
	"N SYLLABICS KICANADIAN SYLLABICS KIICANADIAN SYLLABICS KOCANADIAN SYLLAB" +
	"ICS KOOCANADIAN SYLLABICS Y-CREE KOOCANADIAN SYLLABICS KACANADIAN SYLLAB" +
	"ICS KAACANADIAN SYLLABICS KWECANADIAN SYLLABICS WEST-CREE KWECANADIAN SY" +
	"LLABICS KWICANADIAN SYLLABICS WEST-CREE KWICANADIAN SYLLABICS KWIICANADI" +
	"AN SYLLABICS WEST-CREE KWIICANADIAN SYLLABICS KWOCANADIAN SYLLABICS WEST" +
	"-CREE KWOCANADIAN SYLLABICS KWOOCANADIAN SYLLABICS WEST-CREE KWOOCANADIA" +
	"N SYLLABICS KWACANADIAN SYLLABICS WEST-CREE KWACANADIAN SYLLABICS KWAACA" +
	"NADIAN SYLLABICS WEST-CREE KWAACANADIAN SYLLABICS NASKAPI KWAACANADIAN S" +
	"YLLABICS KCANADIAN SYLLABICS KWCANADIAN SYLLABICS SOUTH-SLAVEY KEHCANADI" +
	"AN SYLLABICS SOUTH-SLAVEY KIHCANADIAN SYLLABICS SOUTH-SLAVEY KOHCANADIAN" +
	" SYLLABICS SOUTH-SLAVEY KAHCANADIAN SYLLABICS CECANADIAN SYLLABICS CAAIC" +
	"ANADIAN SYLLABICS CICANADIAN SYLLABICS CIICANADIAN SYLLABICS COCANADIAN " +
	"SYLLABICS COOCANADIAN SYLLABICS Y-CREE COOCANADIAN SYLLABICS CACANADIAN " +
	"SYLLABICS CAACANADIAN SYLLABICS CWECANADIAN SYLLABICS WEST-CREE CWECANAD" +
	"IAN SYLLABICS CWICANADIAN SYLLABICS WEST-CREE CWICANADIAN SYLLABICS CWII" +
	"CANADIAN SYLLABICS WEST-CREE CWIICANADIAN SYLLABICS CWOCANADIAN SYLLABIC" +
	"S WEST-CREE CWOCANADIAN SYLLABICS CWOOCANADIAN SYLLABICS WEST-CREE CWOOC" +
	"ANADIAN SYLLABICS CWACANADIAN SYLLABICS WEST-CREE CWACANADIAN SYLLABICS " +
	"CWAACANADIAN SYLLABICS WEST-CREE CWAACANADIAN SYLLABICS NASKAPI CWAACANA" +
	"DIAN SYLLABICS CCANADIAN SYLLABICS SAYISI THCANADIAN SYLLABICS MECANADIA" +
	"N SYLLABICS MAAICANADIAN SYLLABICS MICANADIAN SYLLABICS MIICANADIAN SYLL" +
	"ABICS MOCANADIAN SYLLABICS MOOCANADIAN SYLLABICS Y-CREE MOOCANADIAN SYLL" +
	"ABICS MACANADIAN SYLLABICS MAACANADIAN SYLLABICS MWECANADIAN SYLLABICS W" +
	"EST-CREE MWECANADIAN SYLLABICS MWICANADIAN SYLLABICS WEST-CREE MWICANADI") + ("" +
	"AN SYLLABICS MWIICANADIAN SYLLABICS WEST-CREE MWIICANADIAN SYLLABICS MWO" +
	"CANADIAN SYLLABICS WEST-CREE MWOCANADIAN SYLLABICS MWOOCANADIAN SYLLABIC" +
	"S WEST-CREE MWOOCANADIAN SYLLABICS MWACANADIAN SYLLABICS WEST-CREE MWACA" +
	"NADIAN SYLLABICS MWAACANADIAN SYLLABICS WEST-CREE MWAACANADIAN SYLLABICS" +
	" NASKAPI MWAACANADIAN SYLLABICS MCANADIAN SYLLABICS WEST-CREE MCANADIAN " +
	"SYLLABICS MHCANADIAN SYLLABICS ATHAPASCAN MCANADIAN SYLLABICS SAYISI MCA" +
	"NADIAN SYLLABICS NECANADIAN SYLLABICS NAAICANADIAN SYLLABICS NICANADIAN " +
	"SYLLABICS NIICANADIAN SYLLABICS NOCANADIAN SYLLABICS NOOCANADIAN SYLLABI" +
	"CS Y-CREE NOOCANADIAN SYLLABICS NACANADIAN SYLLABICS NAACANADIAN SYLLABI" +
	"CS NWECANADIAN SYLLABICS WEST-CREE NWECANADIAN SYLLABICS NWACANADIAN SYL" +
	"LABICS WEST-CREE NWACANADIAN SYLLABICS NWAACANADIAN SYLLABICS WEST-CREE " +
	"NWAACANADIAN SYLLABICS NASKAPI NWAACANADIAN SYLLABICS NCANADIAN SYLLABIC" +
	"S CARRIER NGCANADIAN SYLLABICS NHCANADIAN SYLLABICS LECANADIAN SYLLABICS" +
	" LAAICANADIAN SYLLABICS LICANADIAN SYLLABICS LIICANADIAN SYLLABICS LOCAN" +
	"ADIAN SYLLABICS LOOCANADIAN SYLLABICS Y-CREE LOOCANADIAN SYLLABICS LACAN" +
	"ADIAN SYLLABICS LAACANADIAN SYLLABICS LWECANADIAN SYLLABICS WEST-CREE LW" +
	"ECANADIAN SYLLABICS LWICANADIAN SYLLABICS WEST-CREE LWICANADIAN SYLLABIC" +
	"S LWIICANADIAN SYLLABICS WEST-CREE LWIICANADIAN SYLLABICS LWOCANADIAN SY" +
	"LLABICS WEST-CREE LWOCANADIAN SYLLABICS LWOOCANADIAN SYLLABICS WEST-CREE" +
	" LWOOCANADIAN SYLLABICS LWACANADIAN SYLLABICS WEST-CREE LWACANADIAN SYLL" +
	"ABICS LWAACANADIAN SYLLABICS WEST-CREE LWAACANADIAN SYLLABICS LCANADIAN " +
	"SYLLABICS WEST-CREE LCANADIAN SYLLABICS MEDIAL LCANADIAN SYLLABICS SECAN" +
	"ADIAN SYLLABICS SAAICANADIAN SYLLABICS SICANADIAN SYLLABICS SIICANADIAN " +
	"SYLLABICS SOCANADIAN SYLLABICS SOOCANADIAN SYLLABICS Y-CREE SOOCANADIAN " +
	"SYLLABICS SACANADIAN SYLLABICS SAACANADIAN SYLLABICS SWECANADIAN SYLLABI" +
	"CS WEST-CREE SWECANADIAN SYLLABICS SWICANADIAN SYLLABICS WEST-CREE SWICA" +
	"NADIAN SYLLABICS SWIICANADIAN SYLLABICS WEST-CREE SWIICANADIAN SYLLABICS" +
	" SWOCANADIAN SYLLABICS WEST-CREE SWOCANADIAN SYLLABICS SWOOCANADIAN SYLL" +
	"ABICS WEST-CREE SWOOCANADIAN SYLLABICS SWACANADIAN SYLLABICS WEST-CREE S" +
	"WACANADIAN SYLLABICS SWAACANADIAN SYLLABICS WEST-CREE SWAACANADIAN SYLLA" +
	"BICS NASKAPI SWAACANADIAN SYLLABICS SCANADIAN SYLLABICS ATHAPASCAN SCANA" +
	"DIAN SYLLABICS SWCANADIAN SYLLABICS BLACKFOOT SCANADIAN SYLLABICS MOOSE-" +
	"CREE SKCANADIAN SYLLABICS NASKAPI SKWCANADIAN SYLLABICS NASKAPI S-WCANAD" +
	"IAN SYLLABICS NASKAPI SPWACANADIAN SYLLABICS NASKAPI STWACANADIAN SYLLAB" +
	"ICS NASKAPI SKWACANADIAN SYLLABICS NASKAPI SCWACANADIAN SYLLABICS SHECAN" +
	"ADIAN SYLLABICS SHICANADIAN SYLLABICS SHIICANADIAN SYLLABICS SHOCANADIAN" +
	" SYLLABICS SHOOCANADIAN SYLLABICS SHACANADIAN SYLLABICS SHAACANADIAN SYL" +
	"LABICS SHWECANADIAN SYLLABICS WEST-CREE SHWECANADIAN SYLLABICS SHWICANAD" +
	"IAN SYLLABICS WEST-CREE SHWICANADIAN SYLLABICS SHWIICANADIAN SYLLABICS W" +
	"EST-CREE SHWIICANADIAN SYLLABICS SHWOCANADIAN SYLLABICS WEST-CREE SHWOCA" +
	"NADIAN SYLLABICS SHWOOCANADIAN SYLLABICS WEST-CREE SHWOOCANADIAN SYLLABI" +
	"CS SHWACANADIAN SYLLABICS WEST-CREE SHWACANADIAN SYLLABICS SHWAACANADIAN" +
	" SYLLABICS WEST-CREE SHWAACANADIAN SYLLABICS SHCANADIAN SYLLABICS YECANA" +
	"DIAN SYLLABICS YAAICANADIAN SYLLABICS YICANADIAN SYLLABICS YIICANADIAN S" +
	"YLLABICS YOCANADIAN SYLLABICS YOOCANADIAN SYLLABICS Y-CREE YOOCANADIAN S" +
	"YLLABICS YACANADIAN SYLLABICS YAACANADIAN SYLLABICS YWECANADIAN SYLLABIC" +
	"S WEST-CREE YWECANADIAN SYLLABICS YWICANADIAN SYLLABICS WEST-CREE YWICAN" +
	"ADIAN SYLLABICS YWIICANADIAN SYLLABICS WEST-CREE YWIICANADIAN SYLLABICS " +
	"YWOCANADIAN SYLLABICS WEST-CREE YWOCANADIAN SYLLABICS YWOOCANADIAN SYLLA" +
	"BICS WEST-CREE YWOOCANADIAN SYLLABICS YWACANADIAN SYLLABICS WEST-CREE YW" +
	"ACANADIAN SYLLABICS YWAACANADIAN SYLLABICS WEST-CREE YWAACANADIAN SYLLAB" +
	"ICS NASKAPI YWAACANADIAN SYLLABICS YCANADIAN SYLLABICS BIBLE-CREE YCANAD" +
	"IAN SYLLABICS WEST-CREE YCANADIAN SYLLABICS SAYISI YICANADIAN SYLLABICS " +
	"RECANADIAN SYLLABICS R-CREE RECANADIAN SYLLABICS WEST-CREE LECANADIAN SY" +
	"LLABICS RAAICANADIAN SYLLABICS RICANADIAN SYLLABICS RIICANADIAN SYLLABIC" +
	"S ROCANADIAN SYLLABICS ROOCANADIAN SYLLABICS WEST-CREE LOCANADIAN SYLLAB" +
	"ICS RACANADIAN SYLLABICS RAACANADIAN SYLLABICS WEST-CREE LACANADIAN SYLL" +
	"ABICS RWAACANADIAN SYLLABICS WEST-CREE RWAACANADIAN SYLLABICS RCANADIAN " +
	"SYLLABICS WEST-CREE RCANADIAN SYLLABICS MEDIAL RCANADIAN SYLLABICS FECAN" +
	"ADIAN SYLLABICS FAAICANADIAN SYLLABICS FICANADIAN SYLLABICS FIICANADIAN " +
	"SYLLABICS FOCANADIAN SYLLABICS FOOCANADIAN SYLLABICS FACANADIAN SYLLABIC" +
	"S FAACANADIAN SYLLABICS FWAACANADIAN SYLLABICS WEST-CREE FWAACANADIAN SY" +
	"LLABICS FCANADIAN SYLLABICS THECANADIAN SYLLABICS N-CREE THECANADIAN SYL" +
	"LABICS THICANADIAN SYLLABICS N-CREE THICANADIAN SYLLABICS THIICANADIAN S") + ("" +
	"YLLABICS N-CREE THIICANADIAN SYLLABICS THOCANADIAN SYLLABICS THOOCANADIA" +
	"N SYLLABICS THACANADIAN SYLLABICS THAACANADIAN SYLLABICS THWAACANADIAN S" +
	"YLLABICS WEST-CREE THWAACANADIAN SYLLABICS THCANADIAN SYLLABICS TTHECANA" +
	"DIAN SYLLABICS TTHICANADIAN SYLLABICS TTHOCANADIAN SYLLABICS TTHACANADIA" +
	"N SYLLABICS TTHCANADIAN SYLLABICS TYECANADIAN SYLLABICS TYICANADIAN SYLL" +
	"ABICS TYOCANADIAN SYLLABICS TYACANADIAN SYLLABICS NUNAVIK HECANADIAN SYL" +
	"LABICS NUNAVIK HICANADIAN SYLLABICS NUNAVIK HIICANADIAN SYLLABICS NUNAVI" +
	"K HOCANADIAN SYLLABICS NUNAVIK HOOCANADIAN SYLLABICS NUNAVIK HACANADIAN " +
	"SYLLABICS NUNAVIK HAACANADIAN SYLLABICS NUNAVIK HCANADIAN SYLLABICS NUNA" +
	"VUT HCANADIAN SYLLABICS HKCANADIAN SYLLABICS QAAICANADIAN SYLLABICS QICA" +
	"NADIAN SYLLABICS QIICANADIAN SYLLABICS QOCANADIAN SYLLABICS QOOCANADIAN " +
	"SYLLABICS QACANADIAN SYLLABICS QAACANADIAN SYLLABICS QCANADIAN SYLLABICS" +
	" TLHECANADIAN SYLLABICS TLHICANADIAN SYLLABICS TLHOCANADIAN SYLLABICS TL" +
	"HACANADIAN SYLLABICS WEST-CREE RECANADIAN SYLLABICS WEST-CREE RICANADIAN" +
	" SYLLABICS WEST-CREE ROCANADIAN SYLLABICS WEST-CREE RACANADIAN SYLLABICS" +
	" NGAAICANADIAN SYLLABICS NGICANADIAN SYLLABICS NGIICANADIAN SYLLABICS NG" +
	"OCANADIAN SYLLABICS NGOOCANADIAN SYLLABICS NGACANADIAN SYLLABICS NGAACAN" +
	"ADIAN SYLLABICS NGCANADIAN SYLLABICS NNGCANADIAN SYLLABICS SAYISI SHECAN" +
	"ADIAN SYLLABICS SAYISI SHICANADIAN SYLLABICS SAYISI SHOCANADIAN SYLLABIC" +
	"S SAYISI SHACANADIAN SYLLABICS WOODS-CREE THECANADIAN SYLLABICS WOODS-CR" +
	"EE THICANADIAN SYLLABICS WOODS-CREE THOCANADIAN SYLLABICS WOODS-CREE THA" +
	"CANADIAN SYLLABICS WOODS-CREE THCANADIAN SYLLABICS LHICANADIAN SYLLABICS" +
	" LHIICANADIAN SYLLABICS LHOCANADIAN SYLLABICS LHOOCANADIAN SYLLABICS LHA" +
	"CANADIAN SYLLABICS LHAACANADIAN SYLLABICS LHCANADIAN SYLLABICS TH-CREE T" +
	"HECANADIAN SYLLABICS TH-CREE THICANADIAN SYLLABICS TH-CREE THIICANADIAN " +
	"SYLLABICS TH-CREE THOCANADIAN SYLLABICS TH-CREE THOOCANADIAN SYLLABICS T" +
	"H-CREE THACANADIAN SYLLABICS TH-CREE THAACANADIAN SYLLABICS TH-CREE THCA" +
	"NADIAN SYLLABICS AIVILIK BCANADIAN SYLLABICS BLACKFOOT ECANADIAN SYLLABI" +
	"CS BLACKFOOT ICANADIAN SYLLABICS BLACKFOOT OCANADIAN SYLLABICS BLACKFOOT" +
	" ACANADIAN SYLLABICS BLACKFOOT WECANADIAN SYLLABICS BLACKFOOT WICANADIAN" +
	" SYLLABICS BLACKFOOT WOCANADIAN SYLLABICS BLACKFOOT WACANADIAN SYLLABICS" +
	" BLACKFOOT NECANADIAN SYLLABICS BLACKFOOT NICANADIAN SYLLABICS BLACKFOOT" +
	" NOCANADIAN SYLLABICS BLACKFOOT NACANADIAN SYLLABICS BLACKFOOT KECANADIA" +
	"N SYLLABICS BLACKFOOT KICANADIAN SYLLABICS BLACKFOOT KOCANADIAN SYLLABIC" +
	"S BLACKFOOT KACANADIAN SYLLABICS SAYISI HECANADIAN SYLLABICS SAYISI HICA" +
	"NADIAN SYLLABICS SAYISI HOCANADIAN SYLLABICS SAYISI HACANADIAN SYLLABICS" +
	" CARRIER GHUCANADIAN SYLLABICS CARRIER GHOCANADIAN SYLLABICS CARRIER GHE" +
	"CANADIAN SYLLABICS CARRIER GHEECANADIAN SYLLABICS CARRIER GHICANADIAN SY" +
	"LLABICS CARRIER GHACANADIAN SYLLABICS CARRIER RUCANADIAN SYLLABICS CARRI" +
	"ER ROCANADIAN SYLLABICS CARRIER RECANADIAN SYLLABICS CARRIER REECANADIAN" +
	" SYLLABICS CARRIER RICANADIAN SYLLABICS CARRIER RACANADIAN SYLLABICS CAR" +
	"RIER WUCANADIAN SYLLABICS CARRIER WOCANADIAN SYLLABICS CARRIER WECANADIA" +
	"N SYLLABICS CARRIER WEECANADIAN SYLLABICS CARRIER WICANADIAN SYLLABICS C" +
	"ARRIER WACANADIAN SYLLABICS CARRIER HWUCANADIAN SYLLABICS CARRIER HWOCAN" +
	"ADIAN SYLLABICS CARRIER HWECANADIAN SYLLABICS CARRIER HWEECANADIAN SYLLA" +
	"BICS CARRIER HWICANADIAN SYLLABICS CARRIER HWACANADIAN SYLLABICS CARRIER" +
	" THUCANADIAN SYLLABICS CARRIER THOCANADIAN SYLLABICS CARRIER THECANADIAN" +
	" SYLLABICS CARRIER THEECANADIAN SYLLABICS CARRIER THICANADIAN SYLLABICS " +
	"CARRIER THACANADIAN SYLLABICS CARRIER TTUCANADIAN SYLLABICS CARRIER TTOC" +
	"ANADIAN SYLLABICS CARRIER TTECANADIAN SYLLABICS CARRIER TTEECANADIAN SYL" +
	"LABICS CARRIER TTICANADIAN SYLLABICS CARRIER TTACANADIAN SYLLABICS CARRI" +
	"ER PUCANADIAN SYLLABICS CARRIER POCANADIAN SYLLABICS CARRIER PECANADIAN " +
	"SYLLABICS CARRIER PEECANADIAN SYLLABICS CARRIER PICANADIAN SYLLABICS CAR" +
	"RIER PACANADIAN SYLLABICS CARRIER PCANADIAN SYLLABICS CARRIER GUCANADIAN" +
	" SYLLABICS CARRIER GOCANADIAN SYLLABICS CARRIER GECANADIAN SYLLABICS CAR" +
	"RIER GEECANADIAN SYLLABICS CARRIER GICANADIAN SYLLABICS CARRIER GACANADI" +
	"AN SYLLABICS CARRIER KHUCANADIAN SYLLABICS CARRIER KHOCANADIAN SYLLABICS" +
	" CARRIER KHECANADIAN SYLLABICS CARRIER KHEECANADIAN SYLLABICS CARRIER KH" +
	"ICANADIAN SYLLABICS CARRIER KHACANADIAN SYLLABICS CARRIER KKUCANADIAN SY" +
	"LLABICS CARRIER KKOCANADIAN SYLLABICS CARRIER KKECANADIAN SYLLABICS CARR" +
	"IER KKEECANADIAN SYLLABICS CARRIER KKICANADIAN SYLLABICS CARRIER KKACANA" +
	"DIAN SYLLABICS CARRIER KKCANADIAN SYLLABICS CARRIER NUCANADIAN SYLLABICS" +
	" CARRIER NOCANADIAN SYLLABICS CARRIER NECANADIAN SYLLABICS CARRIER NEECA" +
	"NADIAN SYLLABICS CARRIER NICANADIAN SYLLABICS CARRIER NACANADIAN SYLLABI") + ("" +
	"CS CARRIER MUCANADIAN SYLLABICS CARRIER MOCANADIAN SYLLABICS CARRIER MEC" +
	"ANADIAN SYLLABICS CARRIER MEECANADIAN SYLLABICS CARRIER MICANADIAN SYLLA" +
	"BICS CARRIER MACANADIAN SYLLABICS CARRIER YUCANADIAN SYLLABICS CARRIER Y" +
	"OCANADIAN SYLLABICS CARRIER YECANADIAN SYLLABICS CARRIER YEECANADIAN SYL" +
	"LABICS CARRIER YICANADIAN SYLLABICS CARRIER YACANADIAN SYLLABICS CARRIER" +
	" JUCANADIAN SYLLABICS SAYISI JUCANADIAN SYLLABICS CARRIER JOCANADIAN SYL" +
	"LABICS CARRIER JECANADIAN SYLLABICS CARRIER JEECANADIAN SYLLABICS CARRIE" +
	"R JICANADIAN SYLLABICS SAYISI JICANADIAN SYLLABICS CARRIER JACANADIAN SY" +
	"LLABICS CARRIER JJUCANADIAN SYLLABICS CARRIER JJOCANADIAN SYLLABICS CARR" +
	"IER JJECANADIAN SYLLABICS CARRIER JJEECANADIAN SYLLABICS CARRIER JJICANA" +
	"DIAN SYLLABICS CARRIER JJACANADIAN SYLLABICS CARRIER LUCANADIAN SYLLABIC" +
	"S CARRIER LOCANADIAN SYLLABICS CARRIER LECANADIAN SYLLABICS CARRIER LEEC" +
	"ANADIAN SYLLABICS CARRIER LICANADIAN SYLLABICS CARRIER LACANADIAN SYLLAB" +
	"ICS CARRIER DLUCANADIAN SYLLABICS CARRIER DLOCANADIAN SYLLABICS CARRIER " +
	"DLECANADIAN SYLLABICS CARRIER DLEECANADIAN SYLLABICS CARRIER DLICANADIAN" +
	" SYLLABICS CARRIER DLACANADIAN SYLLABICS CARRIER LHUCANADIAN SYLLABICS C" +
	"ARRIER LHOCANADIAN SYLLABICS CARRIER LHECANADIAN SYLLABICS CARRIER LHEEC" +
	"ANADIAN SYLLABICS CARRIER LHICANADIAN SYLLABICS CARRIER LHACANADIAN SYLL" +
	"ABICS CARRIER TLHUCANADIAN SYLLABICS CARRIER TLHOCANADIAN SYLLABICS CARR" +
	"IER TLHECANADIAN SYLLABICS CARRIER TLHEECANADIAN SYLLABICS CARRIER TLHIC" +
	"ANADIAN SYLLABICS CARRIER TLHACANADIAN SYLLABICS CARRIER TLUCANADIAN SYL" +
	"LABICS CARRIER TLOCANADIAN SYLLABICS CARRIER TLECANADIAN SYLLABICS CARRI" +
	"ER TLEECANADIAN SYLLABICS CARRIER TLICANADIAN SYLLABICS CARRIER TLACANAD" +
	"IAN SYLLABICS CARRIER ZUCANADIAN SYLLABICS CARRIER ZOCANADIAN SYLLABICS " +
	"CARRIER ZECANADIAN SYLLABICS CARRIER ZEECANADIAN SYLLABICS CARRIER ZICAN" +
	"ADIAN SYLLABICS CARRIER ZACANADIAN SYLLABICS CARRIER ZCANADIAN SYLLABICS" +
	" CARRIER INITIAL ZCANADIAN SYLLABICS CARRIER DZUCANADIAN SYLLABICS CARRI" +
	"ER DZOCANADIAN SYLLABICS CARRIER DZECANADIAN SYLLABICS CARRIER DZEECANAD" +
	"IAN SYLLABICS CARRIER DZICANADIAN SYLLABICS CARRIER DZACANADIAN SYLLABIC" +
	"S CARRIER SUCANADIAN SYLLABICS CARRIER SOCANADIAN SYLLABICS CARRIER SECA" +
	"NADIAN SYLLABICS CARRIER SEECANADIAN SYLLABICS CARRIER SICANADIAN SYLLAB" +
	"ICS CARRIER SACANADIAN SYLLABICS CARRIER SHUCANADIAN SYLLABICS CARRIER S" +
	"HOCANADIAN SYLLABICS CARRIER SHECANADIAN SYLLABICS CARRIER SHEECANADIAN " +
	"SYLLABICS CARRIER SHICANADIAN SYLLABICS CARRIER SHACANADIAN SYLLABICS CA" +
	"RRIER SHCANADIAN SYLLABICS CARRIER TSUCANADIAN SYLLABICS CARRIER TSOCANA" +
	"DIAN SYLLABICS CARRIER TSECANADIAN SYLLABICS CARRIER TSEECANADIAN SYLLAB" +
	"ICS CARRIER TSICANADIAN SYLLABICS CARRIER TSACANADIAN SYLLABICS CARRIER " +
	"CHUCANADIAN SYLLABICS CARRIER CHOCANADIAN SYLLABICS CARRIER CHECANADIAN " +
	"SYLLABICS CARRIER CHEECANADIAN SYLLABICS CARRIER CHICANADIAN SYLLABICS C" +
	"ARRIER CHACANADIAN SYLLABICS CARRIER TTSUCANADIAN SYLLABICS CARRIER TTSO" +
	"CANADIAN SYLLABICS CARRIER TTSECANADIAN SYLLABICS CARRIER TTSEECANADIAN " +
	"SYLLABICS CARRIER TTSICANADIAN SYLLABICS CARRIER TTSACANADIAN SYLLABICS " +
	"CHI SIGNCANADIAN SYLLABICS FULL STOPCANADIAN SYLLABICS QAICANADIAN SYLLA" +
	"BICS NGAICANADIAN SYLLABICS NNGICANADIAN SYLLABICS NNGIICANADIAN SYLLABI" +
	"CS NNGOCANADIAN SYLLABICS NNGOOCANADIAN SYLLABICS NNGACANADIAN SYLLABICS" +
	" NNGAACANADIAN SYLLABICS WOODS-CREE THWEECANADIAN SYLLABICS WOODS-CREE T" +
	"HWICANADIAN SYLLABICS WOODS-CREE THWIICANADIAN SYLLABICS WOODS-CREE THWO" +
	"CANADIAN SYLLABICS WOODS-CREE THWOOCANADIAN SYLLABICS WOODS-CREE THWACAN" +
	"ADIAN SYLLABICS WOODS-CREE THWAACANADIAN SYLLABICS WOODS-CREE FINAL THCA" +
	"NADIAN SYLLABICS BLACKFOOT WOGHAM SPACE MARKOGHAM LETTER BEITHOGHAM LETT" +
	"ER LUISOGHAM LETTER FEARNOGHAM LETTER SAILOGHAM LETTER NIONOGHAM LETTER " +
	"UATHOGHAM LETTER DAIROGHAM LETTER TINNEOGHAM LETTER COLLOGHAM LETTER CEI" +
	"RTOGHAM LETTER MUINOGHAM LETTER GORTOGHAM LETTER NGEADALOGHAM LETTER STR" +
	"AIFOGHAM LETTER RUISOGHAM LETTER AILMOGHAM LETTER ONNOGHAM LETTER UROGHA" +
	"M LETTER EADHADHOGHAM LETTER IODHADHOGHAM LETTER EABHADHOGHAM LETTER ORO" +
	"GHAM LETTER UILLEANNOGHAM LETTER IFINOGHAM LETTER EAMHANCHOLLOGHAM LETTE" +
	"R PEITHOGHAM FEATHER MARKOGHAM REVERSED FEATHER MARKRUNIC LETTER FEHU FE" +
	"OH FE FRUNIC LETTER VRUNIC LETTER URUZ UR URUNIC LETTER YRRUNIC LETTER Y" +
	"RUNIC LETTER WRUNIC LETTER THURISAZ THURS THORNRUNIC LETTER ETHRUNIC LET" +
	"TER ANSUZ ARUNIC LETTER OS ORUNIC LETTER AC ARUNIC LETTER AESCRUNIC LETT" +
	"ER LONG-BRANCH-OSS ORUNIC LETTER SHORT-TWIG-OSS ORUNIC LETTER ORUNIC LET" +
	"TER OERUNIC LETTER ONRUNIC LETTER RAIDO RAD REID RRUNIC LETTER KAUNARUNI" +
	"C LETTER CENRUNIC LETTER KAUN KRUNIC LETTER GRUNIC LETTER ENGRUNIC LETTE" +
	"R GEBO GYFU GRUNIC LETTER GARRUNIC LETTER WUNJO WYNN WRUNIC LETTER HAGLA") + ("" +
	"Z HRUNIC LETTER HAEGL HRUNIC LETTER LONG-BRANCH-HAGALL HRUNIC LETTER SHO" +
	"RT-TWIG-HAGALL HRUNIC LETTER NAUDIZ NYD NAUD NRUNIC LETTER SHORT-TWIG-NA" +
	"UD NRUNIC LETTER DOTTED-NRUNIC LETTER ISAZ IS ISS IRUNIC LETTER ERUNIC L" +
	"ETTER JERAN JRUNIC LETTER GERRUNIC LETTER LONG-BRANCH-AR AERUNIC LETTER " +
	"SHORT-TWIG-AR ARUNIC LETTER IWAZ EOHRUNIC LETTER PERTHO PEORTH PRUNIC LE" +
	"TTER ALGIZ EOLHXRUNIC LETTER SOWILO SRUNIC LETTER SIGEL LONG-BRANCH-SOL " +
	"SRUNIC LETTER SHORT-TWIG-SOL SRUNIC LETTER CRUNIC LETTER ZRUNIC LETTER T" +
	"IWAZ TIR TYR TRUNIC LETTER SHORT-TWIG-TYR TRUNIC LETTER DRUNIC LETTER BE" +
	"RKANAN BEORC BJARKAN BRUNIC LETTER SHORT-TWIG-BJARKAN BRUNIC LETTER DOTT" +
	"ED-PRUNIC LETTER OPEN-PRUNIC LETTER EHWAZ EH ERUNIC LETTER MANNAZ MAN MR" +
	"UNIC LETTER LONG-BRANCH-MADR MRUNIC LETTER SHORT-TWIG-MADR MRUNIC LETTER" +
	" LAUKAZ LAGU LOGR LRUNIC LETTER DOTTED-LRUNIC LETTER INGWAZRUNIC LETTER " +
	"INGRUNIC LETTER DAGAZ DAEG DRUNIC LETTER OTHALAN ETHEL ORUNIC LETTER EAR" +
	"RUNIC LETTER IORRUNIC LETTER CWEORTHRUNIC LETTER CALCRUNIC LETTER CEALCR" +
	"UNIC LETTER STANRUNIC LETTER LONG-BRANCH-YRRUNIC LETTER SHORT-TWIG-YRRUN" +
	"IC LETTER ICELANDIC-YRRUNIC LETTER QRUNIC LETTER XRUNIC SINGLE PUNCTUATI" +
	"ONRUNIC MULTIPLE PUNCTUATIONRUNIC CROSS PUNCTUATIONRUNIC ARLAUG SYMBOLRU" +
	"NIC TVIMADUR SYMBOLRUNIC BELGTHOR SYMBOLRUNIC LETTER KRUNIC LETTER SHRUN" +
	"IC LETTER OORUNIC LETTER FRANKS CASKET OSRUNIC LETTER FRANKS CASKET ISRU" +
	"NIC LETTER FRANKS CASKET EHRUNIC LETTER FRANKS CASKET ACRUNIC LETTER FRA" +
	"NKS CASKET AESCTAGALOG LETTER ATAGALOG LETTER ITAGALOG LETTER UTAGALOG L" +
	"ETTER KATAGALOG LETTER GATAGALOG LETTER NGATAGALOG LETTER TATAGALOG LETT" +
	"ER DATAGALOG LETTER NATAGALOG LETTER PATAGALOG LETTER BATAGALOG LETTER M" +
	"ATAGALOG LETTER YATAGALOG LETTER LATAGALOG LETTER WATAGALOG LETTER SATAG" +
	"ALOG LETTER HATAGALOG VOWEL SIGN ITAGALOG VOWEL SIGN UTAGALOG SIGN VIRAM" +
	"AHANUNOO LETTER AHANUNOO LETTER IHANUNOO LETTER UHANUNOO LETTER KAHANUNO" +
	"O LETTER GAHANUNOO LETTER NGAHANUNOO LETTER TAHANUNOO LETTER DAHANUNOO L" +
	"ETTER NAHANUNOO LETTER PAHANUNOO LETTER BAHANUNOO LETTER MAHANUNOO LETTE" +
	"R YAHANUNOO LETTER RAHANUNOO LETTER LAHANUNOO LETTER WAHANUNOO LETTER SA" +
	"HANUNOO LETTER HAHANUNOO VOWEL SIGN IHANUNOO VOWEL SIGN UHANUNOO SIGN PA" +
	"MUDPODPHILIPPINE SINGLE PUNCTUATIONPHILIPPINE DOUBLE PUNCTUATIONBUHID LE" +
	"TTER ABUHID LETTER IBUHID LETTER UBUHID LETTER KABUHID LETTER GABUHID LE" +
	"TTER NGABUHID LETTER TABUHID LETTER DABUHID LETTER NABUHID LETTER PABUHI" +
	"D LETTER BABUHID LETTER MABUHID LETTER YABUHID LETTER RABUHID LETTER LAB" +
	"UHID LETTER WABUHID LETTER SABUHID LETTER HABUHID VOWEL SIGN IBUHID VOWE" +
	"L SIGN UTAGBANWA LETTER ATAGBANWA LETTER ITAGBANWA LETTER UTAGBANWA LETT" +
	"ER KATAGBANWA LETTER GATAGBANWA LETTER NGATAGBANWA LETTER TATAGBANWA LET" +
	"TER DATAGBANWA LETTER NATAGBANWA LETTER PATAGBANWA LETTER BATAGBANWA LET" +
	"TER MATAGBANWA LETTER YATAGBANWA LETTER LATAGBANWA LETTER WATAGBANWA LET" +
	"TER SATAGBANWA VOWEL SIGN ITAGBANWA VOWEL SIGN UKHMER LETTER KAKHMER LET" +
	"TER KHAKHMER LETTER KOKHMER LETTER KHOKHMER LETTER NGOKHMER LETTER CAKHM" +
	"ER LETTER CHAKHMER LETTER COKHMER LETTER CHOKHMER LETTER NYOKHMER LETTER" +
	" DAKHMER LETTER TTHAKHMER LETTER DOKHMER LETTER TTHOKHMER LETTER NNOKHME" +
	"R LETTER TAKHMER LETTER THAKHMER LETTER TOKHMER LETTER THOKHMER LETTER N" +
	"OKHMER LETTER BAKHMER LETTER PHAKHMER LETTER POKHMER LETTER PHOKHMER LET" +
	"TER MOKHMER LETTER YOKHMER LETTER ROKHMER LETTER LOKHMER LETTER VOKHMER " +
	"LETTER SHAKHMER LETTER SSOKHMER LETTER SAKHMER LETTER HAKHMER LETTER LAK" +
	"HMER LETTER QAKHMER INDEPENDENT VOWEL QAQKHMER INDEPENDENT VOWEL QAAKHME" +
	"R INDEPENDENT VOWEL QIKHMER INDEPENDENT VOWEL QIIKHMER INDEPENDENT VOWEL" +
	" QUKHMER INDEPENDENT VOWEL QUKKHMER INDEPENDENT VOWEL QUUKHMER INDEPENDE" +
	"NT VOWEL QUUVKHMER INDEPENDENT VOWEL RYKHMER INDEPENDENT VOWEL RYYKHMER " +
	"INDEPENDENT VOWEL LYKHMER INDEPENDENT VOWEL LYYKHMER INDEPENDENT VOWEL Q" +
	"EKHMER INDEPENDENT VOWEL QAIKHMER INDEPENDENT VOWEL QOO TYPE ONEKHMER IN" +
	"DEPENDENT VOWEL QOO TYPE TWOKHMER INDEPENDENT VOWEL QAUKHMER VOWEL INHER" +
	"ENT AQKHMER VOWEL INHERENT AAKHMER VOWEL SIGN AAKHMER VOWEL SIGN IKHMER " +
	"VOWEL SIGN IIKHMER VOWEL SIGN YKHMER VOWEL SIGN YYKHMER VOWEL SIGN UKHME" +
	"R VOWEL SIGN UUKHMER VOWEL SIGN UAKHMER VOWEL SIGN OEKHMER VOWEL SIGN YA" +
	"KHMER VOWEL SIGN IEKHMER VOWEL SIGN EKHMER VOWEL SIGN AEKHMER VOWEL SIGN" +
	" AIKHMER VOWEL SIGN OOKHMER VOWEL SIGN AUKHMER SIGN NIKAHITKHMER SIGN RE" +
	"AHMUKKHMER SIGN YUUKALEAPINTUKHMER SIGN MUUSIKATOANKHMER SIGN TRIISAPKHM" +
	"ER SIGN BANTOCKHMER SIGN ROBATKHMER SIGN TOANDAKHIATKHMER SIGN KAKABATKH" +
	"MER SIGN AHSDAKHMER SIGN SAMYOK SANNYAKHMER SIGN VIRIAMKHMER SIGN COENGK" +
	"HMER SIGN BATHAMASATKHMER SIGN KHANKHMER SIGN BARIYOOSANKHMER SIGN CAMNU" +
	"C PII KUUHKHMER SIGN LEK TOOKHMER SIGN BEYYALKHMER SIGN PHNAEK MUANKHMER") + ("" +
	" SIGN KOOMUUTKHMER CURRENCY SYMBOL RIELKHMER SIGN AVAKRAHASANYAKHMER SIG" +
	"N ATTHACANKHMER DIGIT ZEROKHMER DIGIT ONEKHMER DIGIT TWOKHMER DIGIT THRE" +
	"EKHMER DIGIT FOURKHMER DIGIT FIVEKHMER DIGIT SIXKHMER DIGIT SEVENKHMER D" +
	"IGIT EIGHTKHMER DIGIT NINEKHMER SYMBOL LEK ATTAK SONKHMER SYMBOL LEK ATT" +
	"AK MUOYKHMER SYMBOL LEK ATTAK PIIKHMER SYMBOL LEK ATTAK BEIKHMER SYMBOL " +
	"LEK ATTAK BUONKHMER SYMBOL LEK ATTAK PRAMKHMER SYMBOL LEK ATTAK PRAM-MUO" +
	"YKHMER SYMBOL LEK ATTAK PRAM-PIIKHMER SYMBOL LEK ATTAK PRAM-BEIKHMER SYM" +
	"BOL LEK ATTAK PRAM-BUONMONGOLIAN BIRGAMONGOLIAN ELLIPSISMONGOLIAN COMMAM" +
	"ONGOLIAN FULL STOPMONGOLIAN COLONMONGOLIAN FOUR DOTSMONGOLIAN TODO SOFT " +
	"HYPHENMONGOLIAN SIBE SYLLABLE BOUNDARY MARKERMONGOLIAN MANCHU COMMAMONGO" +
	"LIAN MANCHU FULL STOPMONGOLIAN NIRUGUMONGOLIAN FREE VARIATION SELECTOR O" +
	"NEMONGOLIAN FREE VARIATION SELECTOR TWOMONGOLIAN FREE VARIATION SELECTOR" +
	" THREEMONGOLIAN VOWEL SEPARATORMONGOLIAN DIGIT ZEROMONGOLIAN DIGIT ONEMO" +
	"NGOLIAN DIGIT TWOMONGOLIAN DIGIT THREEMONGOLIAN DIGIT FOURMONGOLIAN DIGI" +
	"T FIVEMONGOLIAN DIGIT SIXMONGOLIAN DIGIT SEVENMONGOLIAN DIGIT EIGHTMONGO" +
	"LIAN DIGIT NINEMONGOLIAN LETTER AMONGOLIAN LETTER EMONGOLIAN LETTER IMON" +
	"GOLIAN LETTER OMONGOLIAN LETTER UMONGOLIAN LETTER OEMONGOLIAN LETTER UEM" +
	"ONGOLIAN LETTER EEMONGOLIAN LETTER NAMONGOLIAN LETTER ANGMONGOLIAN LETTE" +
	"R BAMONGOLIAN LETTER PAMONGOLIAN LETTER QAMONGOLIAN LETTER GAMONGOLIAN L" +
	"ETTER MAMONGOLIAN LETTER LAMONGOLIAN LETTER SAMONGOLIAN LETTER SHAMONGOL" +
	"IAN LETTER TAMONGOLIAN LETTER DAMONGOLIAN LETTER CHAMONGOLIAN LETTER JAM" +
	"ONGOLIAN LETTER YAMONGOLIAN LETTER RAMONGOLIAN LETTER WAMONGOLIAN LETTER" +
	" FAMONGOLIAN LETTER KAMONGOLIAN LETTER KHAMONGOLIAN LETTER TSAMONGOLIAN " +
	"LETTER ZAMONGOLIAN LETTER HAAMONGOLIAN LETTER ZRAMONGOLIAN LETTER LHAMON" +
	"GOLIAN LETTER ZHIMONGOLIAN LETTER CHIMONGOLIAN LETTER TODO LONG VOWEL SI" +
	"GNMONGOLIAN LETTER TODO EMONGOLIAN LETTER TODO IMONGOLIAN LETTER TODO OM" +
	"ONGOLIAN LETTER TODO UMONGOLIAN LETTER TODO OEMONGOLIAN LETTER TODO UEMO" +
	"NGOLIAN LETTER TODO ANGMONGOLIAN LETTER TODO BAMONGOLIAN LETTER TODO PAM" +
	"ONGOLIAN LETTER TODO QAMONGOLIAN LETTER TODO GAMONGOLIAN LETTER TODO MAM" +
	"ONGOLIAN LETTER TODO TAMONGOLIAN LETTER TODO DAMONGOLIAN LETTER TODO CHA" +
	"MONGOLIAN LETTER TODO JAMONGOLIAN LETTER TODO TSAMONGOLIAN LETTER TODO Y" +
	"AMONGOLIAN LETTER TODO WAMONGOLIAN LETTER TODO KAMONGOLIAN LETTER TODO G" +
	"AAMONGOLIAN LETTER TODO HAAMONGOLIAN LETTER TODO JIAMONGOLIAN LETTER TOD" +
	"O NIAMONGOLIAN LETTER TODO DZAMONGOLIAN LETTER SIBE EMONGOLIAN LETTER SI" +
	"BE IMONGOLIAN LETTER SIBE IYMONGOLIAN LETTER SIBE UEMONGOLIAN LETTER SIB" +
	"E UMONGOLIAN LETTER SIBE ANGMONGOLIAN LETTER SIBE KAMONGOLIAN LETTER SIB" +
	"E GAMONGOLIAN LETTER SIBE HAMONGOLIAN LETTER SIBE PAMONGOLIAN LETTER SIB" +
	"E SHAMONGOLIAN LETTER SIBE TAMONGOLIAN LETTER SIBE DAMONGOLIAN LETTER SI" +
	"BE JAMONGOLIAN LETTER SIBE FAMONGOLIAN LETTER SIBE GAAMONGOLIAN LETTER S" +
	"IBE HAAMONGOLIAN LETTER SIBE TSAMONGOLIAN LETTER SIBE ZAMONGOLIAN LETTER" +
	" SIBE RAAMONGOLIAN LETTER SIBE CHAMONGOLIAN LETTER SIBE ZHAMONGOLIAN LET" +
	"TER MANCHU IMONGOLIAN LETTER MANCHU KAMONGOLIAN LETTER MANCHU RAMONGOLIA" +
	"N LETTER MANCHU FAMONGOLIAN LETTER MANCHU ZHAMONGOLIAN LETTER CHA WITH T" +
	"WO DOTSMONGOLIAN LETTER ALI GALI ANUSVARA ONEMONGOLIAN LETTER ALI GALI V" +
	"ISARGA ONEMONGOLIAN LETTER ALI GALI DAMARUMONGOLIAN LETTER ALI GALI UBAD" +
	"AMAMONGOLIAN LETTER ALI GALI INVERTED UBADAMAMONGOLIAN LETTER ALI GALI B" +
	"ALUDAMONGOLIAN LETTER ALI GALI THREE BALUDAMONGOLIAN LETTER ALI GALI AMO" +
	"NGOLIAN LETTER ALI GALI IMONGOLIAN LETTER ALI GALI KAMONGOLIAN LETTER AL" +
	"I GALI NGAMONGOLIAN LETTER ALI GALI CAMONGOLIAN LETTER ALI GALI TTAMONGO" +
	"LIAN LETTER ALI GALI TTHAMONGOLIAN LETTER ALI GALI DDAMONGOLIAN LETTER A" +
	"LI GALI NNAMONGOLIAN LETTER ALI GALI TAMONGOLIAN LETTER ALI GALI DAMONGO" +
	"LIAN LETTER ALI GALI PAMONGOLIAN LETTER ALI GALI PHAMONGOLIAN LETTER ALI" +
	" GALI SSAMONGOLIAN LETTER ALI GALI ZHAMONGOLIAN LETTER ALI GALI ZAMONGOL" +
	"IAN LETTER ALI GALI AHMONGOLIAN LETTER TODO ALI GALI TAMONGOLIAN LETTER " +
	"TODO ALI GALI ZHAMONGOLIAN LETTER MANCHU ALI GALI GHAMONGOLIAN LETTER MA" +
	"NCHU ALI GALI NGAMONGOLIAN LETTER MANCHU ALI GALI CAMONGOLIAN LETTER MAN" +
	"CHU ALI GALI JHAMONGOLIAN LETTER MANCHU ALI GALI TTAMONGOLIAN LETTER MAN" +
	"CHU ALI GALI DDHAMONGOLIAN LETTER MANCHU ALI GALI TAMONGOLIAN LETTER MAN" +
	"CHU ALI GALI DHAMONGOLIAN LETTER MANCHU ALI GALI SSAMONGOLIAN LETTER MAN" +
	"CHU ALI GALI CYAMONGOLIAN LETTER MANCHU ALI GALI ZHAMONGOLIAN LETTER MAN" +
	"CHU ALI GALI ZAMONGOLIAN LETTER ALI GALI HALF UMONGOLIAN LETTER ALI GALI" +
	" HALF YAMONGOLIAN LETTER MANCHU ALI GALI BHAMONGOLIAN LETTER ALI GALI DA" +
	"GALGAMONGOLIAN LETTER MANCHU ALI GALI LHACANADIAN SYLLABICS OYCANADIAN S" +
	"YLLABICS AYCANADIAN SYLLABICS AAYCANADIAN SYLLABICS WAYCANADIAN SYLLABIC") + ("" +
	"S POYCANADIAN SYLLABICS PAYCANADIAN SYLLABICS PWOYCANADIAN SYLLABICS TAY" +
	"CANADIAN SYLLABICS KAYCANADIAN SYLLABICS KWAYCANADIAN SYLLABICS MAYCANAD" +
	"IAN SYLLABICS NOYCANADIAN SYLLABICS NAYCANADIAN SYLLABICS LAYCANADIAN SY" +
	"LLABICS SOYCANADIAN SYLLABICS SAYCANADIAN SYLLABICS SHOYCANADIAN SYLLABI" +
	"CS SHAYCANADIAN SYLLABICS SHWOYCANADIAN SYLLABICS YOYCANADIAN SYLLABICS " +
	"YAYCANADIAN SYLLABICS RAYCANADIAN SYLLABICS NWICANADIAN SYLLABICS OJIBWA" +
	"Y NWICANADIAN SYLLABICS NWIICANADIAN SYLLABICS OJIBWAY NWIICANADIAN SYLL" +
	"ABICS NWOCANADIAN SYLLABICS OJIBWAY NWOCANADIAN SYLLABICS NWOOCANADIAN S" +
	"YLLABICS OJIBWAY NWOOCANADIAN SYLLABICS RWEECANADIAN SYLLABICS RWICANADI" +
	"AN SYLLABICS RWIICANADIAN SYLLABICS RWOCANADIAN SYLLABICS RWOOCANADIAN S" +
	"YLLABICS RWACANADIAN SYLLABICS OJIBWAY PCANADIAN SYLLABICS OJIBWAY TCANA" +
	"DIAN SYLLABICS OJIBWAY KCANADIAN SYLLABICS OJIBWAY CCANADIAN SYLLABICS O" +
	"JIBWAY MCANADIAN SYLLABICS OJIBWAY NCANADIAN SYLLABICS OJIBWAY SCANADIAN" +
	" SYLLABICS OJIBWAY SHCANADIAN SYLLABICS EASTERN WCANADIAN SYLLABICS WEST" +
	"ERN WCANADIAN SYLLABICS FINAL SMALL RINGCANADIAN SYLLABICS FINAL RAISED " +
	"DOTCANADIAN SYLLABICS R-CREE RWECANADIAN SYLLABICS WEST-CREE LOOCANADIAN" +
	" SYLLABICS WEST-CREE LAACANADIAN SYLLABICS THWECANADIAN SYLLABICS THWACA" +
	"NADIAN SYLLABICS TTHWECANADIAN SYLLABICS TTHOOCANADIAN SYLLABICS TTHAACA" +
	"NADIAN SYLLABICS TLHWECANADIAN SYLLABICS TLHOOCANADIAN SYLLABICS SAYISI " +
	"SHWECANADIAN SYLLABICS SAYISI SHOOCANADIAN SYLLABICS SAYISI HOOCANADIAN " +
	"SYLLABICS CARRIER GWUCANADIAN SYLLABICS CARRIER DENE GEECANADIAN SYLLABI" +
	"CS CARRIER GAACANADIAN SYLLABICS CARRIER GWACANADIAN SYLLABICS SAYISI JU" +
	"UCANADIAN SYLLABICS CARRIER JWACANADIAN SYLLABICS BEAVER DENE LCANADIAN " +
	"SYLLABICS BEAVER DENE RCANADIAN SYLLABICS CARRIER DENTAL SLIMBU VOWEL-CA" +
	"RRIER LETTERLIMBU LETTER KALIMBU LETTER KHALIMBU LETTER GALIMBU LETTER G" +
	"HALIMBU LETTER NGALIMBU LETTER CALIMBU LETTER CHALIMBU LETTER JALIMBU LE" +
	"TTER JHALIMBU LETTER YANLIMBU LETTER TALIMBU LETTER THALIMBU LETTER DALI" +
	"MBU LETTER DHALIMBU LETTER NALIMBU LETTER PALIMBU LETTER PHALIMBU LETTER" +
	" BALIMBU LETTER BHALIMBU LETTER MALIMBU LETTER YALIMBU LETTER RALIMBU LE" +
	"TTER LALIMBU LETTER WALIMBU LETTER SHALIMBU LETTER SSALIMBU LETTER SALIM" +
	"BU LETTER HALIMBU LETTER GYANLIMBU LETTER TRALIMBU VOWEL SIGN ALIMBU VOW" +
	"EL SIGN ILIMBU VOWEL SIGN ULIMBU VOWEL SIGN EELIMBU VOWEL SIGN AILIMBU V" +
	"OWEL SIGN OOLIMBU VOWEL SIGN AULIMBU VOWEL SIGN ELIMBU VOWEL SIGN OLIMBU" +
	" SUBJOINED LETTER YALIMBU SUBJOINED LETTER RALIMBU SUBJOINED LETTER WALI" +
	"MBU SMALL LETTER KALIMBU SMALL LETTER NGALIMBU SMALL LETTER ANUSVARALIMB" +
	"U SMALL LETTER TALIMBU SMALL LETTER NALIMBU SMALL LETTER PALIMBU SMALL L" +
	"ETTER MALIMBU SMALL LETTER RALIMBU SMALL LETTER LALIMBU SIGN MUKPHRENGLI" +
	"MBU SIGN KEMPHRENGLIMBU SIGN SA-ILIMBU SIGN LOOLIMBU EXCLAMATION MARKLIM" +
	"BU QUESTION MARKLIMBU DIGIT ZEROLIMBU DIGIT ONELIMBU DIGIT TWOLIMBU DIGI" +
	"T THREELIMBU DIGIT FOURLIMBU DIGIT FIVELIMBU DIGIT SIXLIMBU DIGIT SEVENL" +
	"IMBU DIGIT EIGHTLIMBU DIGIT NINETAI LE LETTER KATAI LE LETTER XATAI LE L" +
	"ETTER NGATAI LE LETTER TSATAI LE LETTER SATAI LE LETTER YATAI LE LETTER " +
	"TATAI LE LETTER THATAI LE LETTER LATAI LE LETTER PATAI LE LETTER PHATAI " +
	"LE LETTER MATAI LE LETTER FATAI LE LETTER VATAI LE LETTER HATAI LE LETTE" +
	"R QATAI LE LETTER KHATAI LE LETTER TSHATAI LE LETTER NATAI LE LETTER ATA" +
	"I LE LETTER ITAI LE LETTER EETAI LE LETTER EHTAI LE LETTER UTAI LE LETTE" +
	"R OOTAI LE LETTER OTAI LE LETTER UETAI LE LETTER ETAI LE LETTER AUETAI L" +
	"E LETTER AITAI LE LETTER TONE-2TAI LE LETTER TONE-3TAI LE LETTER TONE-4T" +
	"AI LE LETTER TONE-5TAI LE LETTER TONE-6NEW TAI LUE LETTER HIGH QANEW TAI" +
	" LUE LETTER LOW QANEW TAI LUE LETTER HIGH KANEW TAI LUE LETTER HIGH XANE" +
	"W TAI LUE LETTER HIGH NGANEW TAI LUE LETTER LOW KANEW TAI LUE LETTER LOW" +
	" XANEW TAI LUE LETTER LOW NGANEW TAI LUE LETTER HIGH TSANEW TAI LUE LETT" +
	"ER HIGH SANEW TAI LUE LETTER HIGH YANEW TAI LUE LETTER LOW TSANEW TAI LU" +
	"E LETTER LOW SANEW TAI LUE LETTER LOW YANEW TAI LUE LETTER HIGH TANEW TA" +
	"I LUE LETTER HIGH THANEW TAI LUE LETTER HIGH NANEW TAI LUE LETTER LOW TA" +
	"NEW TAI LUE LETTER LOW THANEW TAI LUE LETTER LOW NANEW TAI LUE LETTER HI" +
	"GH PANEW TAI LUE LETTER HIGH PHANEW TAI LUE LETTER HIGH MANEW TAI LUE LE" +
	"TTER LOW PANEW TAI LUE LETTER LOW PHANEW TAI LUE LETTER LOW MANEW TAI LU" +
	"E LETTER HIGH FANEW TAI LUE LETTER HIGH VANEW TAI LUE LETTER HIGH LANEW " +
	"TAI LUE LETTER LOW FANEW TAI LUE LETTER LOW VANEW TAI LUE LETTER LOW LAN" +
	"EW TAI LUE LETTER HIGH HANEW TAI LUE LETTER HIGH DANEW TAI LUE LETTER HI" +
	"GH BANEW TAI LUE LETTER LOW HANEW TAI LUE LETTER LOW DANEW TAI LUE LETTE" +
	"R LOW BANEW TAI LUE LETTER HIGH KVANEW TAI LUE LETTER HIGH XVANEW TAI LU" +
	"E LETTER LOW KVANEW TAI LUE LETTER LOW XVANEW TAI LUE LETTER HIGH SUANEW") + ("" +
	" TAI LUE LETTER LOW SUANEW TAI LUE VOWEL SIGN VOWEL SHORTENERNEW TAI LUE" +
	" VOWEL SIGN AANEW TAI LUE VOWEL SIGN IINEW TAI LUE VOWEL SIGN UNEW TAI L" +
	"UE VOWEL SIGN UUNEW TAI LUE VOWEL SIGN ENEW TAI LUE VOWEL SIGN AENEW TAI" +
	" LUE VOWEL SIGN ONEW TAI LUE VOWEL SIGN OANEW TAI LUE VOWEL SIGN UENEW T" +
	"AI LUE VOWEL SIGN AYNEW TAI LUE VOWEL SIGN AAYNEW TAI LUE VOWEL SIGN UYN" +
	"EW TAI LUE VOWEL SIGN OYNEW TAI LUE VOWEL SIGN OAYNEW TAI LUE VOWEL SIGN" +
	" UEYNEW TAI LUE VOWEL SIGN IYNEW TAI LUE LETTER FINAL VNEW TAI LUE LETTE" +
	"R FINAL NGNEW TAI LUE LETTER FINAL NNEW TAI LUE LETTER FINAL MNEW TAI LU" +
	"E LETTER FINAL KNEW TAI LUE LETTER FINAL DNEW TAI LUE LETTER FINAL BNEW " +
	"TAI LUE TONE MARK-1NEW TAI LUE TONE MARK-2NEW TAI LUE DIGIT ZERONEW TAI " +
	"LUE DIGIT ONENEW TAI LUE DIGIT TWONEW TAI LUE DIGIT THREENEW TAI LUE DIG" +
	"IT FOURNEW TAI LUE DIGIT FIVENEW TAI LUE DIGIT SIXNEW TAI LUE DIGIT SEVE" +
	"NNEW TAI LUE DIGIT EIGHTNEW TAI LUE DIGIT NINENEW TAI LUE THAM DIGIT ONE" +
	"NEW TAI LUE SIGN LAENEW TAI LUE SIGN LAEVKHMER SYMBOL PATHAMASATKHMER SY" +
	"MBOL MUOY KOETKHMER SYMBOL PII KOETKHMER SYMBOL BEI KOETKHMER SYMBOL BUO" +
	"N KOETKHMER SYMBOL PRAM KOETKHMER SYMBOL PRAM-MUOY KOETKHMER SYMBOL PRAM" +
	"-PII KOETKHMER SYMBOL PRAM-BEI KOETKHMER SYMBOL PRAM-BUON KOETKHMER SYMB" +
	"OL DAP KOETKHMER SYMBOL DAP-MUOY KOETKHMER SYMBOL DAP-PII KOETKHMER SYMB" +
	"OL DAP-BEI KOETKHMER SYMBOL DAP-BUON KOETKHMER SYMBOL DAP-PRAM KOETKHMER" +
	" SYMBOL TUTEYASATKHMER SYMBOL MUOY ROCKHMER SYMBOL PII ROCKHMER SYMBOL B" +
	"EI ROCKHMER SYMBOL BUON ROCKHMER SYMBOL PRAM ROCKHMER SYMBOL PRAM-MUOY R" +
	"OCKHMER SYMBOL PRAM-PII ROCKHMER SYMBOL PRAM-BEI ROCKHMER SYMBOL PRAM-BU" +
	"ON ROCKHMER SYMBOL DAP ROCKHMER SYMBOL DAP-MUOY ROCKHMER SYMBOL DAP-PII " +
	"ROCKHMER SYMBOL DAP-BEI ROCKHMER SYMBOL DAP-BUON ROCKHMER SYMBOL DAP-PRA" +
	"M ROCBUGINESE LETTER KABUGINESE LETTER GABUGINESE LETTER NGABUGINESE LET" +
	"TER NGKABUGINESE LETTER PABUGINESE LETTER BABUGINESE LETTER MABUGINESE L" +
	"ETTER MPABUGINESE LETTER TABUGINESE LETTER DABUGINESE LETTER NABUGINESE " +
	"LETTER NRABUGINESE LETTER CABUGINESE LETTER JABUGINESE LETTER NYABUGINES" +
	"E LETTER NYCABUGINESE LETTER YABUGINESE LETTER RABUGINESE LETTER LABUGIN" +
	"ESE LETTER VABUGINESE LETTER SABUGINESE LETTER ABUGINESE LETTER HABUGINE" +
	"SE VOWEL SIGN IBUGINESE VOWEL SIGN UBUGINESE VOWEL SIGN EBUGINESE VOWEL " +
	"SIGN OBUGINESE VOWEL SIGN AEBUGINESE PALLAWABUGINESE END OF SECTIONTAI T" +
	"HAM LETTER HIGH KATAI THAM LETTER HIGH KHATAI THAM LETTER HIGH KXATAI TH" +
	"AM LETTER LOW KATAI THAM LETTER LOW KXATAI THAM LETTER LOW KHATAI THAM L" +
	"ETTER NGATAI THAM LETTER HIGH CATAI THAM LETTER HIGH CHATAI THAM LETTER " +
	"LOW CATAI THAM LETTER LOW SATAI THAM LETTER LOW CHATAI THAM LETTER NYATA" +
	"I THAM LETTER RATATAI THAM LETTER HIGH RATHATAI THAM LETTER DATAI THAM L" +
	"ETTER LOW RATHATAI THAM LETTER RANATAI THAM LETTER HIGH TATAI THAM LETTE" +
	"R HIGH THATAI THAM LETTER LOW TATAI THAM LETTER LOW THATAI THAM LETTER N" +
	"ATAI THAM LETTER BATAI THAM LETTER HIGH PATAI THAM LETTER HIGH PHATAI TH" +
	"AM LETTER HIGH FATAI THAM LETTER LOW PATAI THAM LETTER LOW FATAI THAM LE" +
	"TTER LOW PHATAI THAM LETTER MATAI THAM LETTER LOW YATAI THAM LETTER HIGH" +
	" YATAI THAM LETTER RATAI THAM LETTER RUETAI THAM LETTER LATAI THAM LETTE" +
	"R LUETAI THAM LETTER WATAI THAM LETTER HIGH SHATAI THAM LETTER HIGH SSAT" +
	"AI THAM LETTER HIGH SATAI THAM LETTER HIGH HATAI THAM LETTER LLATAI THAM" +
	" LETTER ATAI THAM LETTER LOW HATAI THAM LETTER ITAI THAM LETTER IITAI TH" +
	"AM LETTER UTAI THAM LETTER UUTAI THAM LETTER EETAI THAM LETTER OOTAI THA" +
	"M LETTER LAETAI THAM LETTER GREAT SATAI THAM CONSONANT SIGN MEDIAL RATAI" +
	" THAM CONSONANT SIGN MEDIAL LATAI THAM CONSONANT SIGN LA TANG LAITAI THA" +
	"M SIGN MAI KANG LAITAI THAM CONSONANT SIGN FINAL NGATAI THAM CONSONANT S" +
	"IGN LOW PATAI THAM CONSONANT SIGN HIGH RATHA OR LOW PATAI THAM CONSONANT" +
	" SIGN MATAI THAM CONSONANT SIGN BATAI THAM CONSONANT SIGN SATAI THAM SIG" +
	"N SAKOTTAI THAM VOWEL SIGN ATAI THAM VOWEL SIGN MAI SATTAI THAM VOWEL SI" +
	"GN AATAI THAM VOWEL SIGN TALL AATAI THAM VOWEL SIGN ITAI THAM VOWEL SIGN" +
	" IITAI THAM VOWEL SIGN UETAI THAM VOWEL SIGN UUETAI THAM VOWEL SIGN UTAI" +
	" THAM VOWEL SIGN UUTAI THAM VOWEL SIGN OTAI THAM VOWEL SIGN OA BELOWTAI " +
	"THAM VOWEL SIGN OYTAI THAM VOWEL SIGN ETAI THAM VOWEL SIGN AETAI THAM VO" +
	"WEL SIGN OOTAI THAM VOWEL SIGN AITAI THAM VOWEL SIGN THAM AITAI THAM VOW" +
	"EL SIGN OA ABOVETAI THAM SIGN MAI KANGTAI THAM SIGN TONE-1TAI THAM SIGN " +
	"TONE-2TAI THAM SIGN KHUEN TONE-3TAI THAM SIGN KHUEN TONE-4TAI THAM SIGN " +
	"KHUEN TONE-5TAI THAM SIGN RA HAAMTAI THAM SIGN MAI SAMTAI THAM SIGN KHUE" +
	"N-LUE KARANTAI THAM COMBINING CRYPTOGRAMMIC DOTTAI THAM HORA DIGIT ZEROT" +
	"AI THAM HORA DIGIT ONETAI THAM HORA DIGIT TWOTAI THAM HORA DIGIT THREETA" +
	"I THAM HORA DIGIT FOURTAI THAM HORA DIGIT FIVETAI THAM HORA DIGIT SIXTAI") + ("" +
	" THAM HORA DIGIT SEVENTAI THAM HORA DIGIT EIGHTTAI THAM HORA DIGIT NINET" +
	"AI THAM THAM DIGIT ZEROTAI THAM THAM DIGIT ONETAI THAM THAM DIGIT TWOTAI" +
	" THAM THAM DIGIT THREETAI THAM THAM DIGIT FOURTAI THAM THAM DIGIT FIVETA" +
	"I THAM THAM DIGIT SIXTAI THAM THAM DIGIT SEVENTAI THAM THAM DIGIT EIGHTT" +
	"AI THAM THAM DIGIT NINETAI THAM SIGN WIANGTAI THAM SIGN WIANGWAAKTAI THA" +
	"M SIGN SAWANTAI THAM SIGN KEOWTAI THAM SIGN HOYTAI THAM SIGN DOKMAITAI T" +
	"HAM SIGN REVERSED ROTATED RANATAI THAM SIGN MAI YAMOKTAI THAM SIGN KAANT" +
	"AI THAM SIGN KAANKUUTAI THAM SIGN SATKAANTAI THAM SIGN SATKAANKUUTAI THA" +
	"M SIGN HANGTAI THAM SIGN CAANGCOMBINING DOUBLED CIRCUMFLEX ACCENTCOMBINI" +
	"NG DIAERESIS-RINGCOMBINING INFINITYCOMBINING DOWNWARDS ARROWCOMBINING TR" +
	"IPLE DOTCOMBINING X-X BELOWCOMBINING WIGGLY LINE BELOWCOMBINING OPEN MAR" +
	"K BELOWCOMBINING DOUBLE OPEN MARK BELOWCOMBINING LIGHT CENTRALIZATION ST" +
	"ROKE BELOWCOMBINING STRONG CENTRALIZATION STROKE BELOWCOMBINING PARENTHE" +
	"SES ABOVECOMBINING DOUBLE PARENTHESES ABOVECOMBINING PARENTHESES BELOWCO" +
	"MBINING PARENTHESES OVERLAYCOMBINING LATIN SMALL LETTER W BELOWCOMBINING" +
	" LATIN SMALL LETTER TURNED W BELOWBALINESE SIGN ULU RICEMBALINESE SIGN U" +
	"LU CANDRABALINESE SIGN CECEKBALINESE SIGN SURANGBALINESE SIGN BISAHBALIN" +
	"ESE LETTER AKARABALINESE LETTER AKARA TEDUNGBALINESE LETTER IKARABALINES" +
	"E LETTER IKARA TEDUNGBALINESE LETTER UKARABALINESE LETTER UKARA TEDUNGBA" +
	"LINESE LETTER RA REPABALINESE LETTER RA REPA TEDUNGBALINESE LETTER LA LE" +
	"NGABALINESE LETTER LA LENGA TEDUNGBALINESE LETTER EKARABALINESE LETTER A" +
	"IKARABALINESE LETTER OKARABALINESE LETTER OKARA TEDUNGBALINESE LETTER KA" +
	"BALINESE LETTER KA MAHAPRANABALINESE LETTER GABALINESE LETTER GA GORABAL" +
	"INESE LETTER NGABALINESE LETTER CABALINESE LETTER CA LACABALINESE LETTER" +
	" JABALINESE LETTER JA JERABALINESE LETTER NYABALINESE LETTER TA LATIKBAL" +
	"INESE LETTER TA MURDA MAHAPRANABALINESE LETTER DA MURDA ALPAPRANABALINES" +
	"E LETTER DA MURDA MAHAPRANABALINESE LETTER NA RAMBATBALINESE LETTER TABA" +
	"LINESE LETTER TA TAWABALINESE LETTER DABALINESE LETTER DA MADUBALINESE L" +
	"ETTER NABALINESE LETTER PABALINESE LETTER PA KAPALBALINESE LETTER BABALI" +
	"NESE LETTER BA KEMBANGBALINESE LETTER MABALINESE LETTER YABALINESE LETTE" +
	"R RABALINESE LETTER LABALINESE LETTER WABALINESE LETTER SA SAGABALINESE " +
	"LETTER SA SAPABALINESE LETTER SABALINESE LETTER HABALINESE SIGN REREKANB" +
	"ALINESE VOWEL SIGN TEDUNGBALINESE VOWEL SIGN ULUBALINESE VOWEL SIGN ULU " +
	"SARIBALINESE VOWEL SIGN SUKUBALINESE VOWEL SIGN SUKU ILUTBALINESE VOWEL " +
	"SIGN RA REPABALINESE VOWEL SIGN RA REPA TEDUNGBALINESE VOWEL SIGN LA LEN" +
	"GABALINESE VOWEL SIGN LA LENGA TEDUNGBALINESE VOWEL SIGN TALINGBALINESE " +
	"VOWEL SIGN TALING REPABALINESE VOWEL SIGN TALING TEDUNGBALINESE VOWEL SI" +
	"GN TALING REPA TEDUNGBALINESE VOWEL SIGN PEPETBALINESE VOWEL SIGN PEPET " +
	"TEDUNGBALINESE ADEG ADEGBALINESE LETTER KAF SASAKBALINESE LETTER KHOT SA" +
	"SAKBALINESE LETTER TZIR SASAKBALINESE LETTER EF SASAKBALINESE LETTER VE " +
	"SASAKBALINESE LETTER ZAL SASAKBALINESE LETTER ASYURA SASAKBALINESE DIGIT" +
	" ZEROBALINESE DIGIT ONEBALINESE DIGIT TWOBALINESE DIGIT THREEBALINESE DI" +
	"GIT FOURBALINESE DIGIT FIVEBALINESE DIGIT SIXBALINESE DIGIT SEVENBALINES" +
	"E DIGIT EIGHTBALINESE DIGIT NINEBALINESE PANTIBALINESE PAMADABALINESE WI" +
	"NDUBALINESE CARIK PAMUNGKAHBALINESE CARIK SIKIBALINESE CARIK PARERENBALI" +
	"NESE PAMENENGBALINESE MUSICAL SYMBOL DONGBALINESE MUSICAL SYMBOL DENGBAL" +
	"INESE MUSICAL SYMBOL DUNGBALINESE MUSICAL SYMBOL DANGBALINESE MUSICAL SY" +
	"MBOL DANG SURANGBALINESE MUSICAL SYMBOL DINGBALINESE MUSICAL SYMBOL DAEN" +
	"GBALINESE MUSICAL SYMBOL DEUNGBALINESE MUSICAL SYMBOL DAINGBALINESE MUSI" +
	"CAL SYMBOL DANG GEDEBALINESE MUSICAL SYMBOL COMBINING TEGEHBALINESE MUSI" +
	"CAL SYMBOL COMBINING ENDEPBALINESE MUSICAL SYMBOL COMBINING KEMPULBALINE" +
	"SE MUSICAL SYMBOL COMBINING KEMPLIBALINESE MUSICAL SYMBOL COMBINING JEGO" +
	"GANBALINESE MUSICAL SYMBOL COMBINING KEMPUL WITH JEGOGANBALINESE MUSICAL" +
	" SYMBOL COMBINING KEMPLI WITH JEGOGANBALINESE MUSICAL SYMBOL COMBINING B" +
	"ENDEBALINESE MUSICAL SYMBOL COMBINING GONGBALINESE MUSICAL SYMBOL RIGHT-" +
	"HAND OPEN DUGBALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DAGBALINESE MUSICAL" +
	" SYMBOL RIGHT-HAND CLOSED TUKBALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED T" +
	"AKBALINESE MUSICAL SYMBOL LEFT-HAND OPEN PANGBALINESE MUSICAL SYMBOL LEF" +
	"T-HAND OPEN PUNGBALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLAKBALINESE MU" +
	"SICAL SYMBOL LEFT-HAND CLOSED PLUKBALINESE MUSICAL SYMBOL LEFT-HAND OPEN" +
	" PINGSUNDANESE SIGN PANYECEKSUNDANESE SIGN PANGLAYARSUNDANESE SIGN PANGW" +
	"ISADSUNDANESE LETTER ASUNDANESE LETTER ISUNDANESE LETTER USUNDANESE LETT" +
	"ER AESUNDANESE LETTER OSUNDANESE LETTER ESUNDANESE LETTER EUSUNDANESE LE" +
	"TTER KASUNDANESE LETTER QASUNDANESE LETTER GASUNDANESE LETTER NGASUNDANE") + ("" +
	"SE LETTER CASUNDANESE LETTER JASUNDANESE LETTER ZASUNDANESE LETTER NYASU" +
	"NDANESE LETTER TASUNDANESE LETTER DASUNDANESE LETTER NASUNDANESE LETTER " +
	"PASUNDANESE LETTER FASUNDANESE LETTER VASUNDANESE LETTER BASUNDANESE LET" +
	"TER MASUNDANESE LETTER YASUNDANESE LETTER RASUNDANESE LETTER LASUNDANESE" +
	" LETTER WASUNDANESE LETTER SASUNDANESE LETTER XASUNDANESE LETTER HASUNDA" +
	"NESE CONSONANT SIGN PAMINGKALSUNDANESE CONSONANT SIGN PANYAKRASUNDANESE " +
	"CONSONANT SIGN PANYIKUSUNDANESE VOWEL SIGN PANGHULUSUNDANESE VOWEL SIGN " +
	"PANYUKUSUNDANESE VOWEL SIGN PANAELAENGSUNDANESE VOWEL SIGN PANOLONGSUNDA" +
	"NESE VOWEL SIGN PAMEPETSUNDANESE VOWEL SIGN PANEULEUNGSUNDANESE SIGN PAM" +
	"AAEHSUNDANESE SIGN VIRAMASUNDANESE CONSONANT SIGN PASANGAN MASUNDANESE C" +
	"ONSONANT SIGN PASANGAN WASUNDANESE LETTER KHASUNDANESE LETTER SYASUNDANE" +
	"SE DIGIT ZEROSUNDANESE DIGIT ONESUNDANESE DIGIT TWOSUNDANESE DIGIT THREE" +
	"SUNDANESE DIGIT FOURSUNDANESE DIGIT FIVESUNDANESE DIGIT SIXSUNDANESE DIG" +
	"IT SEVENSUNDANESE DIGIT EIGHTSUNDANESE DIGIT NINESUNDANESE AVAGRAHASUNDA" +
	"NESE LETTER REUSUNDANESE LETTER LEUSUNDANESE LETTER BHASUNDANESE LETTER " +
	"FINAL KSUNDANESE LETTER FINAL MBATAK LETTER ABATAK LETTER SIMALUNGUN ABA" +
	"TAK LETTER HABATAK LETTER SIMALUNGUN HABATAK LETTER MANDAILING HABATAK L" +
	"ETTER BABATAK LETTER KARO BABATAK LETTER PABATAK LETTER SIMALUNGUN PABAT" +
	"AK LETTER NABATAK LETTER MANDAILING NABATAK LETTER WABATAK LETTER SIMALU" +
	"NGUN WABATAK LETTER PAKPAK WABATAK LETTER GABATAK LETTER SIMALUNGUN GABA" +
	"TAK LETTER JABATAK LETTER DABATAK LETTER RABATAK LETTER SIMALUNGUN RABAT" +
	"AK LETTER MABATAK LETTER SIMALUNGUN MABATAK LETTER SOUTHERN TABATAK LETT" +
	"ER NORTHERN TABATAK LETTER SABATAK LETTER SIMALUNGUN SABATAK LETTER MAND" +
	"AILING SABATAK LETTER YABATAK LETTER SIMALUNGUN YABATAK LETTER NGABATAK " +
	"LETTER LABATAK LETTER SIMALUNGUN LABATAK LETTER NYABATAK LETTER CABATAK " +
	"LETTER NDABATAK LETTER MBABATAK LETTER IBATAK LETTER UBATAK SIGN TOMPIBA" +
	"TAK VOWEL SIGN EBATAK VOWEL SIGN PAKPAK EBATAK VOWEL SIGN EEBATAK VOWEL " +
	"SIGN IBATAK VOWEL SIGN KARO IBATAK VOWEL SIGN OBATAK VOWEL SIGN KARO OBA" +
	"TAK VOWEL SIGN UBATAK VOWEL SIGN U FOR SIMALUNGUN SABATAK CONSONANT SIGN" +
	" NGBATAK CONSONANT SIGN HBATAK PANGOLATBATAK PANONGONANBATAK SYMBOL BIND" +
	"U NA METEKBATAK SYMBOL BINDU PINARBORASBATAK SYMBOL BINDU JUDULBATAK SYM" +
	"BOL BINDU PANGOLATLEPCHA LETTER KALEPCHA LETTER KLALEPCHA LETTER KHALEPC" +
	"HA LETTER GALEPCHA LETTER GLALEPCHA LETTER NGALEPCHA LETTER CALEPCHA LET" +
	"TER CHALEPCHA LETTER JALEPCHA LETTER NYALEPCHA LETTER TALEPCHA LETTER TH" +
	"ALEPCHA LETTER DALEPCHA LETTER NALEPCHA LETTER PALEPCHA LETTER PLALEPCHA" +
	" LETTER PHALEPCHA LETTER FALEPCHA LETTER FLALEPCHA LETTER BALEPCHA LETTE" +
	"R BLALEPCHA LETTER MALEPCHA LETTER MLALEPCHA LETTER TSALEPCHA LETTER TSH" +
	"ALEPCHA LETTER DZALEPCHA LETTER YALEPCHA LETTER RALEPCHA LETTER LALEPCHA" +
	" LETTER HALEPCHA LETTER HLALEPCHA LETTER VALEPCHA LETTER SALEPCHA LETTER" +
	" SHALEPCHA LETTER WALEPCHA LETTER ALEPCHA SUBJOINED LETTER YALEPCHA SUBJ" +
	"OINED LETTER RALEPCHA VOWEL SIGN AALEPCHA VOWEL SIGN ILEPCHA VOWEL SIGN " +
	"OLEPCHA VOWEL SIGN OOLEPCHA VOWEL SIGN ULEPCHA VOWEL SIGN UULEPCHA VOWEL" +
	" SIGN ELEPCHA CONSONANT SIGN KLEPCHA CONSONANT SIGN MLEPCHA CONSONANT SI" +
	"GN LLEPCHA CONSONANT SIGN NLEPCHA CONSONANT SIGN PLEPCHA CONSONANT SIGN " +
	"RLEPCHA CONSONANT SIGN TLEPCHA CONSONANT SIGN NYIN-DOLEPCHA CONSONANT SI" +
	"GN KANGLEPCHA SIGN RANLEPCHA SIGN NUKTALEPCHA PUNCTUATION TA-ROLLEPCHA P" +
	"UNCTUATION NYET THYOOM TA-ROLLEPCHA PUNCTUATION CER-WALEPCHA PUNCTUATION" +
	" TSHOOK CER-WALEPCHA PUNCTUATION TSHOOKLEPCHA DIGIT ZEROLEPCHA DIGIT ONE" +
	"LEPCHA DIGIT TWOLEPCHA DIGIT THREELEPCHA DIGIT FOURLEPCHA DIGIT FIVELEPC" +
	"HA DIGIT SIXLEPCHA DIGIT SEVENLEPCHA DIGIT EIGHTLEPCHA DIGIT NINELEPCHA " +
	"LETTER TTALEPCHA LETTER TTHALEPCHA LETTER DDAOL CHIKI DIGIT ZEROOL CHIKI" +
	" DIGIT ONEOL CHIKI DIGIT TWOOL CHIKI DIGIT THREEOL CHIKI DIGIT FOUROL CH" +
	"IKI DIGIT FIVEOL CHIKI DIGIT SIXOL CHIKI DIGIT SEVENOL CHIKI DIGIT EIGHT" +
	"OL CHIKI DIGIT NINEOL CHIKI LETTER LAOL CHIKI LETTER ATOL CHIKI LETTER A" +
	"GOL CHIKI LETTER ANGOL CHIKI LETTER ALOL CHIKI LETTER LAAOL CHIKI LETTER" +
	" AAKOL CHIKI LETTER AAJOL CHIKI LETTER AAMOL CHIKI LETTER AAWOL CHIKI LE" +
	"TTER LIOL CHIKI LETTER ISOL CHIKI LETTER IHOL CHIKI LETTER INYOL CHIKI L" +
	"ETTER IROL CHIKI LETTER LUOL CHIKI LETTER UCOL CHIKI LETTER UDOL CHIKI L" +
	"ETTER UNNOL CHIKI LETTER UYOL CHIKI LETTER LEOL CHIKI LETTER EPOL CHIKI " +
	"LETTER EDDOL CHIKI LETTER ENOL CHIKI LETTER ERROL CHIKI LETTER LOOL CHIK" +
	"I LETTER OTTOL CHIKI LETTER OBOL CHIKI LETTER OVOL CHIKI LETTER OHOL CHI" +
	"KI MU TTUDDAGOL CHIKI GAAHLAA TTUDDAAGOL CHIKI MU-GAAHLAA TTUDDAAGOL CHI" +
	"KI RELAAOL CHIKI PHAARKAAOL CHIKI AHADOL CHIKI PUNCTUATION MUCAADOL CHIK" +
	"I PUNCTUATION DOUBLE MUCAADCYRILLIC SMALL LETTER ROUNDED VECYRILLIC SMAL") + ("" +
	"L LETTER LONG-LEGGED DECYRILLIC SMALL LETTER NARROW OCYRILLIC SMALL LETT" +
	"ER WIDE ESCYRILLIC SMALL LETTER TALL TECYRILLIC SMALL LETTER THREE-LEGGE" +
	"D TECYRILLIC SMALL LETTER TALL HARD SIGNCYRILLIC SMALL LETTER TALL YATCY" +
	"RILLIC SMALL LETTER UNBLENDED UKGEORGIAN MTAVRULI CAPITAL LETTER ANGEORG" +
	"IAN MTAVRULI CAPITAL LETTER BANGEORGIAN MTAVRULI CAPITAL LETTER GANGEORG" +
	"IAN MTAVRULI CAPITAL LETTER DONGEORGIAN MTAVRULI CAPITAL LETTER ENGEORGI" +
	"AN MTAVRULI CAPITAL LETTER VINGEORGIAN MTAVRULI CAPITAL LETTER ZENGEORGI" +
	"AN MTAVRULI CAPITAL LETTER TANGEORGIAN MTAVRULI CAPITAL LETTER INGEORGIA" +
	"N MTAVRULI CAPITAL LETTER KANGEORGIAN MTAVRULI CAPITAL LETTER LASGEORGIA" +
	"N MTAVRULI CAPITAL LETTER MANGEORGIAN MTAVRULI CAPITAL LETTER NARGEORGIA" +
	"N MTAVRULI CAPITAL LETTER ONGEORGIAN MTAVRULI CAPITAL LETTER PARGEORGIAN" +
	" MTAVRULI CAPITAL LETTER ZHARGEORGIAN MTAVRULI CAPITAL LETTER RAEGEORGIA" +
	"N MTAVRULI CAPITAL LETTER SANGEORGIAN MTAVRULI CAPITAL LETTER TARGEORGIA" +
	"N MTAVRULI CAPITAL LETTER UNGEORGIAN MTAVRULI CAPITAL LETTER PHARGEORGIA" +
	"N MTAVRULI CAPITAL LETTER KHARGEORGIAN MTAVRULI CAPITAL LETTER GHANGEORG" +
	"IAN MTAVRULI CAPITAL LETTER QARGEORGIAN MTAVRULI CAPITAL LETTER SHINGEOR" +
	"GIAN MTAVRULI CAPITAL LETTER CHINGEORGIAN MTAVRULI CAPITAL LETTER CANGEO" +
	"RGIAN MTAVRULI CAPITAL LETTER JILGEORGIAN MTAVRULI CAPITAL LETTER CILGEO" +
	"RGIAN MTAVRULI CAPITAL LETTER CHARGEORGIAN MTAVRULI CAPITAL LETTER XANGE" +
	"ORGIAN MTAVRULI CAPITAL LETTER JHANGEORGIAN MTAVRULI CAPITAL LETTER HAEG" +
	"EORGIAN MTAVRULI CAPITAL LETTER HEGEORGIAN MTAVRULI CAPITAL LETTER HIEGE" +
	"ORGIAN MTAVRULI CAPITAL LETTER WEGEORGIAN MTAVRULI CAPITAL LETTER HARGEO" +
	"RGIAN MTAVRULI CAPITAL LETTER HOEGEORGIAN MTAVRULI CAPITAL LETTER FIGEOR" +
	"GIAN MTAVRULI CAPITAL LETTER YNGEORGIAN MTAVRULI CAPITAL LETTER ELIFIGEO" +
	"RGIAN MTAVRULI CAPITAL LETTER TURNED GANGEORGIAN MTAVRULI CAPITAL LETTER" +
	" AINGEORGIAN MTAVRULI CAPITAL LETTER AENGEORGIAN MTAVRULI CAPITAL LETTER" +
	" HARD SIGNGEORGIAN MTAVRULI CAPITAL LETTER LABIAL SIGNSUNDANESE PUNCTUAT" +
	"ION BINDU SURYASUNDANESE PUNCTUATION BINDU PANGLONGSUNDANESE PUNCTUATION" +
	" BINDU PURNAMASUNDANESE PUNCTUATION BINDU CAKRASUNDANESE PUNCTUATION BIN" +
	"DU LEU SATANGASUNDANESE PUNCTUATION BINDU KA SATANGASUNDANESE PUNCTUATIO" +
	"N BINDU DA SATANGASUNDANESE PUNCTUATION BINDU BA SATANGAVEDIC TONE KARSH" +
	"ANAVEDIC TONE SHARAVEDIC TONE PRENKHAVEDIC SIGN NIHSHVASAVEDIC SIGN YAJU" +
	"RVEDIC MIDLINE SVARITAVEDIC TONE YAJURVEDIC AGGRAVATED INDEPENDENT SVARI" +
	"TAVEDIC TONE YAJURVEDIC INDEPENDENT SVARITAVEDIC TONE YAJURVEDIC KATHAKA" +
	" INDEPENDENT SVARITAVEDIC TONE CANDRA BELOWVEDIC TONE YAJURVEDIC KATHAKA" +
	" INDEPENDENT SVARITA SCHROEDERVEDIC TONE DOUBLE SVARITAVEDIC TONE TRIPLE" +
	" SVARITAVEDIC TONE KATHAKA ANUDATTAVEDIC TONE DOT BELOWVEDIC TONE TWO DO" +
	"TS BELOWVEDIC TONE THREE DOTS BELOWVEDIC TONE RIGVEDIC KASHMIRI INDEPEND" +
	"ENT SVARITAVEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITAVEDIC SIGN VISARGA" +
	" SVARITAVEDIC SIGN VISARGA UDATTAVEDIC SIGN REVERSED VISARGA UDATTAVEDIC" +
	" SIGN VISARGA ANUDATTAVEDIC SIGN REVERSED VISARGA ANUDATTAVEDIC SIGN VIS" +
	"ARGA UDATTA WITH TAILVEDIC SIGN VISARGA ANUDATTA WITH TAILVEDIC SIGN ANU" +
	"SVARA ANTARGOMUKHAVEDIC SIGN ANUSVARA BAHIRGOMUKHAVEDIC SIGN ANUSVARA VA" +
	"MAGOMUKHAVEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAILVEDIC SIGN TIRYAKVEDIC" +
	" SIGN HEXIFORM LONG ANUSVARAVEDIC SIGN LONG ANUSVARAVEDIC SIGN RTHANG LO" +
	"NG ANUSVARAVEDIC SIGN ANUSVARA UBHAYATO MUKHAVEDIC SIGN ARDHAVISARGAVEDI" +
	"C SIGN ROTATED ARDHAVISARGAVEDIC TONE CANDRA ABOVEVEDIC SIGN JIHVAMULIYA" +
	"VEDIC SIGN UPADHMANIYAVEDIC SIGN ATIKRAMAVEDIC TONE RING ABOVEVEDIC TONE" +
	" DOUBLE RING ABOVEVEDIC SIGN DOUBLE ANUSVARA ANTARGOMUKHALATIN LETTER SM" +
	"ALL CAPITAL ALATIN LETTER SMALL CAPITAL AELATIN SMALL LETTER TURNED AELA" +
	"TIN LETTER SMALL CAPITAL BARRED BLATIN LETTER SMALL CAPITAL CLATIN LETTE" +
	"R SMALL CAPITAL DLATIN LETTER SMALL CAPITAL ETHLATIN LETTER SMALL CAPITA" +
	"L ELATIN SMALL LETTER TURNED OPEN ELATIN SMALL LETTER TURNED ILATIN LETT" +
	"ER SMALL CAPITAL JLATIN LETTER SMALL CAPITAL KLATIN LETTER SMALL CAPITAL" +
	" L WITH STROKELATIN LETTER SMALL CAPITAL MLATIN LETTER SMALL CAPITAL REV" +
	"ERSED NLATIN LETTER SMALL CAPITAL OLATIN LETTER SMALL CAPITAL OPEN OLATI" +
	"N SMALL LETTER SIDEWAYS OLATIN SMALL LETTER SIDEWAYS OPEN OLATIN SMALL L" +
	"ETTER SIDEWAYS O WITH STROKELATIN SMALL LETTER TURNED OELATIN LETTER SMA" +
	"LL CAPITAL OULATIN SMALL LETTER TOP HALF OLATIN SMALL LETTER BOTTOM HALF" +
	" OLATIN LETTER SMALL CAPITAL PLATIN LETTER SMALL CAPITAL REVERSED RLATIN" +
	" LETTER SMALL CAPITAL TURNED RLATIN LETTER SMALL CAPITAL TLATIN LETTER S" +
	"MALL CAPITAL ULATIN SMALL LETTER SIDEWAYS ULATIN SMALL LETTER SIDEWAYS D" +
	"IAERESIZED ULATIN SMALL LETTER SIDEWAYS TURNED MLATIN LETTER SMALL CAPIT" +
	"AL VLATIN LETTER SMALL CAPITAL WLATIN LETTER SMALL CAPITAL ZLATIN LETTER") + ("" +
	" SMALL CAPITAL EZHLATIN LETTER VOICED LARYNGEAL SPIRANTLATIN LETTER AING" +
	"REEK LETTER SMALL CAPITAL GAMMAGREEK LETTER SMALL CAPITAL LAMDAGREEK LET" +
	"TER SMALL CAPITAL PIGREEK LETTER SMALL CAPITAL RHOGREEK LETTER SMALL CAP" +
	"ITAL PSICYRILLIC LETTER SMALL CAPITAL ELMODIFIER LETTER CAPITAL AMODIFIE" +
	"R LETTER CAPITAL AEMODIFIER LETTER CAPITAL BMODIFIER LETTER CAPITAL BARR" +
	"ED BMODIFIER LETTER CAPITAL DMODIFIER LETTER CAPITAL EMODIFIER LETTER CA" +
	"PITAL REVERSED EMODIFIER LETTER CAPITAL GMODIFIER LETTER CAPITAL HMODIFI" +
	"ER LETTER CAPITAL IMODIFIER LETTER CAPITAL JMODIFIER LETTER CAPITAL KMOD" +
	"IFIER LETTER CAPITAL LMODIFIER LETTER CAPITAL MMODIFIER LETTER CAPITAL N" +
	"MODIFIER LETTER CAPITAL REVERSED NMODIFIER LETTER CAPITAL OMODIFIER LETT" +
	"ER CAPITAL OUMODIFIER LETTER CAPITAL PMODIFIER LETTER CAPITAL RMODIFIER " +
	"LETTER CAPITAL TMODIFIER LETTER CAPITAL UMODIFIER LETTER CAPITAL WMODIFI" +
	"ER LETTER SMALL AMODIFIER LETTER SMALL TURNED AMODIFIER LETTER SMALL ALP" +
	"HAMODIFIER LETTER SMALL TURNED AEMODIFIER LETTER SMALL BMODIFIER LETTER " +
	"SMALL DMODIFIER LETTER SMALL EMODIFIER LETTER SMALL SCHWAMODIFIER LETTER" +
	" SMALL OPEN EMODIFIER LETTER SMALL TURNED OPEN EMODIFIER LETTER SMALL GM" +
	"ODIFIER LETTER SMALL TURNED IMODIFIER LETTER SMALL KMODIFIER LETTER SMAL" +
	"L MMODIFIER LETTER SMALL ENGMODIFIER LETTER SMALL OMODIFIER LETTER SMALL" +
	" OPEN OMODIFIER LETTER SMALL TOP HALF OMODIFIER LETTER SMALL BOTTOM HALF" +
	" OMODIFIER LETTER SMALL PMODIFIER LETTER SMALL TMODIFIER LETTER SMALL UM" +
	"ODIFIER LETTER SMALL SIDEWAYS UMODIFIER LETTER SMALL TURNED MMODIFIER LE" +
	"TTER SMALL VMODIFIER LETTER SMALL AINMODIFIER LETTER SMALL BETAMODIFIER " +
	"LETTER SMALL GREEK GAMMAMODIFIER LETTER SMALL DELTAMODIFIER LETTER SMALL" +
	" GREEK PHIMODIFIER LETTER SMALL CHILATIN SUBSCRIPT SMALL LETTER ILATIN S" +
	"UBSCRIPT SMALL LETTER RLATIN SUBSCRIPT SMALL LETTER ULATIN SUBSCRIPT SMA" +
	"LL LETTER VGREEK SUBSCRIPT SMALL LETTER BETAGREEK SUBSCRIPT SMALL LETTER" +
	" GAMMAGREEK SUBSCRIPT SMALL LETTER RHOGREEK SUBSCRIPT SMALL LETTER PHIGR" +
	"EEK SUBSCRIPT SMALL LETTER CHILATIN SMALL LETTER UELATIN SMALL LETTER B " +
	"WITH MIDDLE TILDELATIN SMALL LETTER D WITH MIDDLE TILDELATIN SMALL LETTE" +
	"R F WITH MIDDLE TILDELATIN SMALL LETTER M WITH MIDDLE TILDELATIN SMALL L" +
	"ETTER N WITH MIDDLE TILDELATIN SMALL LETTER P WITH MIDDLE TILDELATIN SMA" +
	"LL LETTER R WITH MIDDLE TILDELATIN SMALL LETTER R WITH FISHHOOK AND MIDD" +
	"LE TILDELATIN SMALL LETTER S WITH MIDDLE TILDELATIN SMALL LETTER T WITH " +
	"MIDDLE TILDELATIN SMALL LETTER Z WITH MIDDLE TILDELATIN SMALL LETTER TUR" +
	"NED GMODIFIER LETTER CYRILLIC ENLATIN SMALL LETTER INSULAR GLATIN SMALL " +
	"LETTER TH WITH STRIKETHROUGHLATIN SMALL CAPITAL LETTER I WITH STROKELATI" +
	"N SMALL LETTER IOTA WITH STROKELATIN SMALL LETTER P WITH STROKELATIN SMA" +
	"LL CAPITAL LETTER U WITH STROKELATIN SMALL LETTER UPSILON WITH STROKELAT" +
	"IN SMALL LETTER B WITH PALATAL HOOKLATIN SMALL LETTER D WITH PALATAL HOO" +
	"KLATIN SMALL LETTER F WITH PALATAL HOOKLATIN SMALL LETTER G WITH PALATAL" +
	" HOOKLATIN SMALL LETTER K WITH PALATAL HOOKLATIN SMALL LETTER L WITH PAL" +
	"ATAL HOOKLATIN SMALL LETTER M WITH PALATAL HOOKLATIN SMALL LETTER N WITH" +
	" PALATAL HOOKLATIN SMALL LETTER P WITH PALATAL HOOKLATIN SMALL LETTER R " +
	"WITH PALATAL HOOKLATIN SMALL LETTER S WITH PALATAL HOOKLATIN SMALL LETTE" +
	"R ESH WITH PALATAL HOOKLATIN SMALL LETTER V WITH PALATAL HOOKLATIN SMALL" +
	" LETTER X WITH PALATAL HOOKLATIN SMALL LETTER Z WITH PALATAL HOOKLATIN S" +
	"MALL LETTER A WITH RETROFLEX HOOKLATIN SMALL LETTER ALPHA WITH RETROFLEX" +
	" HOOKLATIN SMALL LETTER D WITH HOOK AND TAILLATIN SMALL LETTER E WITH RE" +
	"TROFLEX HOOKLATIN SMALL LETTER OPEN E WITH RETROFLEX HOOKLATIN SMALL LET" +
	"TER REVERSED OPEN E WITH RETROFLEX HOOKLATIN SMALL LETTER SCHWA WITH RET" +
	"ROFLEX HOOKLATIN SMALL LETTER I WITH RETROFLEX HOOKLATIN SMALL LETTER OP" +
	"EN O WITH RETROFLEX HOOKLATIN SMALL LETTER ESH WITH RETROFLEX HOOKLATIN " +
	"SMALL LETTER U WITH RETROFLEX HOOKLATIN SMALL LETTER EZH WITH RETROFLEX " +
	"HOOKMODIFIER LETTER SMALL TURNED ALPHAMODIFIER LETTER SMALL CMODIFIER LE" +
	"TTER SMALL C WITH CURLMODIFIER LETTER SMALL ETHMODIFIER LETTER SMALL REV" +
	"ERSED OPEN EMODIFIER LETTER SMALL FMODIFIER LETTER SMALL DOTLESS J WITH " +
	"STROKEMODIFIER LETTER SMALL SCRIPT GMODIFIER LETTER SMALL TURNED HMODIFI" +
	"ER LETTER SMALL I WITH STROKEMODIFIER LETTER SMALL IOTAMODIFIER LETTER S" +
	"MALL CAPITAL IMODIFIER LETTER SMALL CAPITAL I WITH STROKEMODIFIER LETTER" +
	" SMALL J WITH CROSSED-TAILMODIFIER LETTER SMALL L WITH RETROFLEX HOOKMOD" +
	"IFIER LETTER SMALL L WITH PALATAL HOOKMODIFIER LETTER SMALL CAPITAL LMOD" +
	"IFIER LETTER SMALL M WITH HOOKMODIFIER LETTER SMALL TURNED M WITH LONG L" +
	"EGMODIFIER LETTER SMALL N WITH LEFT HOOKMODIFIER LETTER SMALL N WITH RET" +
	"ROFLEX HOOKMODIFIER LETTER SMALL CAPITAL NMODIFIER LETTER SMALL BARRED O") + ("" +
	"MODIFIER LETTER SMALL PHIMODIFIER LETTER SMALL S WITH HOOKMODIFIER LETTE" +
	"R SMALL ESHMODIFIER LETTER SMALL T WITH PALATAL HOOKMODIFIER LETTER SMAL" +
	"L U BARMODIFIER LETTER SMALL UPSILONMODIFIER LETTER SMALL CAPITAL UMODIF" +
	"IER LETTER SMALL V WITH HOOKMODIFIER LETTER SMALL TURNED VMODIFIER LETTE" +
	"R SMALL ZMODIFIER LETTER SMALL Z WITH RETROFLEX HOOKMODIFIER LETTER SMAL" +
	"L Z WITH CURLMODIFIER LETTER SMALL EZHMODIFIER LETTER SMALL THETACOMBINI" +
	"NG DOTTED GRAVE ACCENTCOMBINING DOTTED ACUTE ACCENTCOMBINING SNAKE BELOW" +
	"COMBINING SUSPENSION MARKCOMBINING MACRON-ACUTECOMBINING GRAVE-MACRONCOM" +
	"BINING MACRON-GRAVECOMBINING ACUTE-MACRONCOMBINING GRAVE-ACUTE-GRAVECOMB" +
	"INING ACUTE-GRAVE-ACUTECOMBINING LATIN SMALL LETTER R BELOWCOMBINING BRE" +
	"VE-MACRONCOMBINING MACRON-BREVECOMBINING DOUBLE CIRCUMFLEX ABOVECOMBININ" +
	"G OGONEK ABOVECOMBINING ZIGZAG BELOWCOMBINING IS BELOWCOMBINING UR ABOVE" +
	"COMBINING US ABOVECOMBINING LATIN SMALL LETTER FLATTENED OPEN A ABOVECOM" +
	"BINING LATIN SMALL LETTER AECOMBINING LATIN SMALL LETTER AOCOMBINING LAT" +
	"IN SMALL LETTER AVCOMBINING LATIN SMALL LETTER C CEDILLACOMBINING LATIN " +
	"SMALL LETTER INSULAR DCOMBINING LATIN SMALL LETTER ETHCOMBINING LATIN SM" +
	"ALL LETTER GCOMBINING LATIN LETTER SMALL CAPITAL GCOMBINING LATIN SMALL " +
	"LETTER KCOMBINING LATIN SMALL LETTER LCOMBINING LATIN LETTER SMALL CAPIT" +
	"AL LCOMBINING LATIN LETTER SMALL CAPITAL MCOMBINING LATIN SMALL LETTER N" +
	"COMBINING LATIN LETTER SMALL CAPITAL NCOMBINING LATIN LETTER SMALL CAPIT" +
	"AL RCOMBINING LATIN SMALL LETTER R ROTUNDACOMBINING LATIN SMALL LETTER S" +
	"COMBINING LATIN SMALL LETTER LONG SCOMBINING LATIN SMALL LETTER ZCOMBINI" +
	"NG LATIN SMALL LETTER ALPHACOMBINING LATIN SMALL LETTER BCOMBINING LATIN" +
	" SMALL LETTER BETACOMBINING LATIN SMALL LETTER SCHWACOMBINING LATIN SMAL" +
	"L LETTER FCOMBINING LATIN SMALL LETTER L WITH DOUBLE MIDDLE TILDECOMBINI" +
	"NG LATIN SMALL LETTER O WITH LIGHT CENTRALIZATION STROKECOMBINING LATIN " +
	"SMALL LETTER PCOMBINING LATIN SMALL LETTER ESHCOMBINING LATIN SMALL LETT" +
	"ER U WITH LIGHT CENTRALIZATION STROKECOMBINING LATIN SMALL LETTER WCOMBI" +
	"NING LATIN SMALL LETTER A WITH DIAERESISCOMBINING LATIN SMALL LETTER O W" +
	"ITH DIAERESISCOMBINING LATIN SMALL LETTER U WITH DIAERESISCOMBINING UP T" +
	"ACK ABOVECOMBINING KAVYKA ABOVE RIGHTCOMBINING KAVYKA ABOVE LEFTCOMBININ" +
	"G DOT ABOVE LEFTCOMBINING WIDE INVERTED BRIDGE BELOWCOMBINING DELETION M" +
	"ARKCOMBINING DOUBLE INVERTED BREVE BELOWCOMBINING ALMOST EQUAL TO BELOWC" +
	"OMBINING LEFT ARROWHEAD ABOVECOMBINING RIGHT ARROWHEAD AND DOWN ARROWHEA" +
	"D BELOWLATIN CAPITAL LETTER A WITH RING BELOWLATIN SMALL LETTER A WITH R" +
	"ING BELOWLATIN CAPITAL LETTER B WITH DOT ABOVELATIN SMALL LETTER B WITH " +
	"DOT ABOVELATIN CAPITAL LETTER B WITH DOT BELOWLATIN SMALL LETTER B WITH " +
	"DOT BELOWLATIN CAPITAL LETTER B WITH LINE BELOWLATIN SMALL LETTER B WITH" +
	" LINE BELOWLATIN CAPITAL LETTER C WITH CEDILLA AND ACUTELATIN SMALL LETT" +
	"ER C WITH CEDILLA AND ACUTELATIN CAPITAL LETTER D WITH DOT ABOVELATIN SM" +
	"ALL LETTER D WITH DOT ABOVELATIN CAPITAL LETTER D WITH DOT BELOWLATIN SM" +
	"ALL LETTER D WITH DOT BELOWLATIN CAPITAL LETTER D WITH LINE BELOWLATIN S" +
	"MALL LETTER D WITH LINE BELOWLATIN CAPITAL LETTER D WITH CEDILLALATIN SM" +
	"ALL LETTER D WITH CEDILLALATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOWLAT" +
	"IN SMALL LETTER D WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER E WITH MACRO" +
	"N AND GRAVELATIN SMALL LETTER E WITH MACRON AND GRAVELATIN CAPITAL LETTE" +
	"R E WITH MACRON AND ACUTELATIN SMALL LETTER E WITH MACRON AND ACUTELATIN" +
	" CAPITAL LETTER E WITH CIRCUMFLEX BELOWLATIN SMALL LETTER E WITH CIRCUMF" +
	"LEX BELOWLATIN CAPITAL LETTER E WITH TILDE BELOWLATIN SMALL LETTER E WIT" +
	"H TILDE BELOWLATIN CAPITAL LETTER E WITH CEDILLA AND BREVELATIN SMALL LE" +
	"TTER E WITH CEDILLA AND BREVELATIN CAPITAL LETTER F WITH DOT ABOVELATIN " +
	"SMALL LETTER F WITH DOT ABOVELATIN CAPITAL LETTER G WITH MACRONLATIN SMA" +
	"LL LETTER G WITH MACRONLATIN CAPITAL LETTER H WITH DOT ABOVELATIN SMALL " +
	"LETTER H WITH DOT ABOVELATIN CAPITAL LETTER H WITH DOT BELOWLATIN SMALL " +
	"LETTER H WITH DOT BELOWLATIN CAPITAL LETTER H WITH DIAERESISLATIN SMALL " +
	"LETTER H WITH DIAERESISLATIN CAPITAL LETTER H WITH CEDILLALATIN SMALL LE" +
	"TTER H WITH CEDILLALATIN CAPITAL LETTER H WITH BREVE BELOWLATIN SMALL LE" +
	"TTER H WITH BREVE BELOWLATIN CAPITAL LETTER I WITH TILDE BELOWLATIN SMAL" +
	"L LETTER I WITH TILDE BELOWLATIN CAPITAL LETTER I WITH DIAERESIS AND ACU" +
	"TELATIN SMALL LETTER I WITH DIAERESIS AND ACUTELATIN CAPITAL LETTER K WI" +
	"TH ACUTELATIN SMALL LETTER K WITH ACUTELATIN CAPITAL LETTER K WITH DOT B" +
	"ELOWLATIN SMALL LETTER K WITH DOT BELOWLATIN CAPITAL LETTER K WITH LINE " +
	"BELOWLATIN SMALL LETTER K WITH LINE BELOWLATIN CAPITAL LETTER L WITH DOT" +
	" BELOWLATIN SMALL LETTER L WITH DOT BELOWLATIN CAPITAL LETTER L WITH DOT") + ("" +
	" BELOW AND MACRONLATIN SMALL LETTER L WITH DOT BELOW AND MACRONLATIN CAP" +
	"ITAL LETTER L WITH LINE BELOWLATIN SMALL LETTER L WITH LINE BELOWLATIN C" +
	"APITAL LETTER L WITH CIRCUMFLEX BELOWLATIN SMALL LETTER L WITH CIRCUMFLE" +
	"X BELOWLATIN CAPITAL LETTER M WITH ACUTELATIN SMALL LETTER M WITH ACUTEL" +
	"ATIN CAPITAL LETTER M WITH DOT ABOVELATIN SMALL LETTER M WITH DOT ABOVEL" +
	"ATIN CAPITAL LETTER M WITH DOT BELOWLATIN SMALL LETTER M WITH DOT BELOWL" +
	"ATIN CAPITAL LETTER N WITH DOT ABOVELATIN SMALL LETTER N WITH DOT ABOVEL" +
	"ATIN CAPITAL LETTER N WITH DOT BELOWLATIN SMALL LETTER N WITH DOT BELOWL" +
	"ATIN CAPITAL LETTER N WITH LINE BELOWLATIN SMALL LETTER N WITH LINE BELO" +
	"WLATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOWLATIN SMALL LETTER N WITH C" +
	"IRCUMFLEX BELOWLATIN CAPITAL LETTER O WITH TILDE AND ACUTELATIN SMALL LE" +
	"TTER O WITH TILDE AND ACUTELATIN CAPITAL LETTER O WITH TILDE AND DIAERES" +
	"ISLATIN SMALL LETTER O WITH TILDE AND DIAERESISLATIN CAPITAL LETTER O WI" +
	"TH MACRON AND GRAVELATIN SMALL LETTER O WITH MACRON AND GRAVELATIN CAPIT" +
	"AL LETTER O WITH MACRON AND ACUTELATIN SMALL LETTER O WITH MACRON AND AC" +
	"UTELATIN CAPITAL LETTER P WITH ACUTELATIN SMALL LETTER P WITH ACUTELATIN" +
	" CAPITAL LETTER P WITH DOT ABOVELATIN SMALL LETTER P WITH DOT ABOVELATIN" +
	" CAPITAL LETTER R WITH DOT ABOVELATIN SMALL LETTER R WITH DOT ABOVELATIN" +
	" CAPITAL LETTER R WITH DOT BELOWLATIN SMALL LETTER R WITH DOT BELOWLATIN" +
	" CAPITAL LETTER R WITH DOT BELOW AND MACRONLATIN SMALL LETTER R WITH DOT" +
	" BELOW AND MACRONLATIN CAPITAL LETTER R WITH LINE BELOWLATIN SMALL LETTE" +
	"R R WITH LINE BELOWLATIN CAPITAL LETTER S WITH DOT ABOVELATIN SMALL LETT" +
	"ER S WITH DOT ABOVELATIN CAPITAL LETTER S WITH DOT BELOWLATIN SMALL LETT" +
	"ER S WITH DOT BELOWLATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVELATIN " +
	"SMALL LETTER S WITH ACUTE AND DOT ABOVELATIN CAPITAL LETTER S WITH CARON" +
	" AND DOT ABOVELATIN SMALL LETTER S WITH CARON AND DOT ABOVELATIN CAPITAL" +
	" LETTER S WITH DOT BELOW AND DOT ABOVELATIN SMALL LETTER S WITH DOT BELO" +
	"W AND DOT ABOVELATIN CAPITAL LETTER T WITH DOT ABOVELATIN SMALL LETTER T" +
	" WITH DOT ABOVELATIN CAPITAL LETTER T WITH DOT BELOWLATIN SMALL LETTER T" +
	" WITH DOT BELOWLATIN CAPITAL LETTER T WITH LINE BELOWLATIN SMALL LETTER " +
	"T WITH LINE BELOWLATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOWLATIN SMALL" +
	" LETTER T WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER U WITH DIAERESIS BEL" +
	"OWLATIN SMALL LETTER U WITH DIAERESIS BELOWLATIN CAPITAL LETTER U WITH T" +
	"ILDE BELOWLATIN SMALL LETTER U WITH TILDE BELOWLATIN CAPITAL LETTER U WI" +
	"TH CIRCUMFLEX BELOWLATIN SMALL LETTER U WITH CIRCUMFLEX BELOWLATIN CAPIT" +
	"AL LETTER U WITH TILDE AND ACUTELATIN SMALL LETTER U WITH TILDE AND ACUT" +
	"ELATIN CAPITAL LETTER U WITH MACRON AND DIAERESISLATIN SMALL LETTER U WI" +
	"TH MACRON AND DIAERESISLATIN CAPITAL LETTER V WITH TILDELATIN SMALL LETT" +
	"ER V WITH TILDELATIN CAPITAL LETTER V WITH DOT BELOWLATIN SMALL LETTER V" +
	" WITH DOT BELOWLATIN CAPITAL LETTER W WITH GRAVELATIN SMALL LETTER W WIT" +
	"H GRAVELATIN CAPITAL LETTER W WITH ACUTELATIN SMALL LETTER W WITH ACUTEL" +
	"ATIN CAPITAL LETTER W WITH DIAERESISLATIN SMALL LETTER W WITH DIAERESISL" +
	"ATIN CAPITAL LETTER W WITH DOT ABOVELATIN SMALL LETTER W WITH DOT ABOVEL" +
	"ATIN CAPITAL LETTER W WITH DOT BELOWLATIN SMALL LETTER W WITH DOT BELOWL" +
	"ATIN CAPITAL LETTER X WITH DOT ABOVELATIN SMALL LETTER X WITH DOT ABOVEL" +
	"ATIN CAPITAL LETTER X WITH DIAERESISLATIN SMALL LETTER X WITH DIAERESISL" +
	"ATIN CAPITAL LETTER Y WITH DOT ABOVELATIN SMALL LETTER Y WITH DOT ABOVEL" +
	"ATIN CAPITAL LETTER Z WITH CIRCUMFLEXLATIN SMALL LETTER Z WITH CIRCUMFLE" +
	"XLATIN CAPITAL LETTER Z WITH DOT BELOWLATIN SMALL LETTER Z WITH DOT BELO" +
	"WLATIN CAPITAL LETTER Z WITH LINE BELOWLATIN SMALL LETTER Z WITH LINE BE" +
	"LOWLATIN SMALL LETTER H WITH LINE BELOWLATIN SMALL LETTER T WITH DIAERES" +
	"ISLATIN SMALL LETTER W WITH RING ABOVELATIN SMALL LETTER Y WITH RING ABO" +
	"VELATIN SMALL LETTER A WITH RIGHT HALF RINGLATIN SMALL LETTER LONG S WIT" +
	"H DOT ABOVELATIN SMALL LETTER LONG S WITH DIAGONAL STROKELATIN SMALL LET" +
	"TER LONG S WITH HIGH STROKELATIN CAPITAL LETTER SHARP SLATIN SMALL LETTE" +
	"R DELTALATIN CAPITAL LETTER A WITH DOT BELOWLATIN SMALL LETTER A WITH DO" +
	"T BELOWLATIN CAPITAL LETTER A WITH HOOK ABOVELATIN SMALL LETTER A WITH H" +
	"OOK ABOVELATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTELATIN SMALL LET" +
	"TER A WITH CIRCUMFLEX AND ACUTELATIN CAPITAL LETTER A WITH CIRCUMFLEX AN" +
	"D GRAVELATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVELATIN CAPITAL LETTE" +
	"R A WITH CIRCUMFLEX AND HOOK ABOVELATIN SMALL LETTER A WITH CIRCUMFLEX A" +
	"ND HOOK ABOVELATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDELATIN SMALL" +
	" LETTER A WITH CIRCUMFLEX AND TILDELATIN CAPITAL LETTER A WITH CIRCUMFLE" +
	"X AND DOT BELOWLATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOWLATIN C") + ("" +
	"APITAL LETTER A WITH BREVE AND ACUTELATIN SMALL LETTER A WITH BREVE AND " +
	"ACUTELATIN CAPITAL LETTER A WITH BREVE AND GRAVELATIN SMALL LETTER A WIT" +
	"H BREVE AND GRAVELATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVELATIN S" +
	"MALL LETTER A WITH BREVE AND HOOK ABOVELATIN CAPITAL LETTER A WITH BREVE" +
	" AND TILDELATIN SMALL LETTER A WITH BREVE AND TILDELATIN CAPITAL LETTER " +
	"A WITH BREVE AND DOT BELOWLATIN SMALL LETTER A WITH BREVE AND DOT BELOWL" +
	"ATIN CAPITAL LETTER E WITH DOT BELOWLATIN SMALL LETTER E WITH DOT BELOWL" +
	"ATIN CAPITAL LETTER E WITH HOOK ABOVELATIN SMALL LETTER E WITH HOOK ABOV" +
	"ELATIN CAPITAL LETTER E WITH TILDELATIN SMALL LETTER E WITH TILDELATIN C" +
	"APITAL LETTER E WITH CIRCUMFLEX AND ACUTELATIN SMALL LETTER E WITH CIRCU" +
	"MFLEX AND ACUTELATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVELATIN SMA" +
	"LL LETTER E WITH CIRCUMFLEX AND GRAVELATIN CAPITAL LETTER E WITH CIRCUMF" +
	"LEX AND HOOK ABOVELATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVELAT" +
	"IN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDELATIN SMALL LETTER E WITH C" +
	"IRCUMFLEX AND TILDELATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOWL" +
	"ATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOWLATIN CAPITAL LETTER I " +
	"WITH HOOK ABOVELATIN SMALL LETTER I WITH HOOK ABOVELATIN CAPITAL LETTER " +
	"I WITH DOT BELOWLATIN SMALL LETTER I WITH DOT BELOWLATIN CAPITAL LETTER " +
	"O WITH DOT BELOWLATIN SMALL LETTER O WITH DOT BELOWLATIN CAPITAL LETTER " +
	"O WITH HOOK ABOVELATIN SMALL LETTER O WITH HOOK ABOVELATIN CAPITAL LETTE" +
	"R O WITH CIRCUMFLEX AND ACUTELATIN SMALL LETTER O WITH CIRCUMFLEX AND AC" +
	"UTELATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVELATIN SMALL LETTER O " +
	"WITH CIRCUMFLEX AND GRAVELATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK" +
	" ABOVELATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVELATIN CAPITAL L" +
	"ETTER O WITH CIRCUMFLEX AND TILDELATIN SMALL LETTER O WITH CIRCUMFLEX AN" +
	"D TILDELATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOWLATIN SMALL L" +
	"ETTER O WITH CIRCUMFLEX AND DOT BELOWLATIN CAPITAL LETTER O WITH HORN AN" +
	"D ACUTELATIN SMALL LETTER O WITH HORN AND ACUTELATIN CAPITAL LETTER O WI" +
	"TH HORN AND GRAVELATIN SMALL LETTER O WITH HORN AND GRAVELATIN CAPITAL L" +
	"ETTER O WITH HORN AND HOOK ABOVELATIN SMALL LETTER O WITH HORN AND HOOK " +
	"ABOVELATIN CAPITAL LETTER O WITH HORN AND TILDELATIN SMALL LETTER O WITH" +
	" HORN AND TILDELATIN CAPITAL LETTER O WITH HORN AND DOT BELOWLATIN SMALL" +
	" LETTER O WITH HORN AND DOT BELOWLATIN CAPITAL LETTER U WITH DOT BELOWLA" +
	"TIN SMALL LETTER U WITH DOT BELOWLATIN CAPITAL LETTER U WITH HOOK ABOVEL" +
	"ATIN SMALL LETTER U WITH HOOK ABOVELATIN CAPITAL LETTER U WITH HORN AND " +
	"ACUTELATIN SMALL LETTER U WITH HORN AND ACUTELATIN CAPITAL LETTER U WITH" +
	" HORN AND GRAVELATIN SMALL LETTER U WITH HORN AND GRAVELATIN CAPITAL LET" +
	"TER U WITH HORN AND HOOK ABOVELATIN SMALL LETTER U WITH HORN AND HOOK AB" +
	"OVELATIN CAPITAL LETTER U WITH HORN AND TILDELATIN SMALL LETTER U WITH H" +
	"ORN AND TILDELATIN CAPITAL LETTER U WITH HORN AND DOT BELOWLATIN SMALL L" +
	"ETTER U WITH HORN AND DOT BELOWLATIN CAPITAL LETTER Y WITH GRAVELATIN SM" +
	"ALL LETTER Y WITH GRAVELATIN CAPITAL LETTER Y WITH DOT BELOWLATIN SMALL " +
	"LETTER Y WITH DOT BELOWLATIN CAPITAL LETTER Y WITH HOOK ABOVELATIN SMALL" +
	" LETTER Y WITH HOOK ABOVELATIN CAPITAL LETTER Y WITH TILDELATIN SMALL LE" +
	"TTER Y WITH TILDELATIN CAPITAL LETTER MIDDLE-WELSH LLLATIN SMALL LETTER " +
	"MIDDLE-WELSH LLLATIN CAPITAL LETTER MIDDLE-WELSH VLATIN SMALL LETTER MID" +
	"DLE-WELSH VLATIN CAPITAL LETTER Y WITH LOOPLATIN SMALL LETTER Y WITH LOO" +
	"PGREEK SMALL LETTER ALPHA WITH PSILIGREEK SMALL LETTER ALPHA WITH DASIAG" +
	"REEK SMALL LETTER ALPHA WITH PSILI AND VARIAGREEK SMALL LETTER ALPHA WIT" +
	"H DASIA AND VARIAGREEK SMALL LETTER ALPHA WITH PSILI AND OXIAGREEK SMALL" +
	" LETTER ALPHA WITH DASIA AND OXIAGREEK SMALL LETTER ALPHA WITH PSILI AND" +
	" PERISPOMENIGREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENIGREEK CAP" +
	"ITAL LETTER ALPHA WITH PSILIGREEK CAPITAL LETTER ALPHA WITH DASIAGREEK C" +
	"APITAL LETTER ALPHA WITH PSILI AND VARIAGREEK CAPITAL LETTER ALPHA WITH " +
	"DASIA AND VARIAGREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIAGREEK CAPIT" +
	"AL LETTER ALPHA WITH DASIA AND OXIAGREEK CAPITAL LETTER ALPHA WITH PSILI" +
	" AND PERISPOMENIGREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENIGRE" +
	"EK SMALL LETTER EPSILON WITH PSILIGREEK SMALL LETTER EPSILON WITH DASIAG" +
	"REEK SMALL LETTER EPSILON WITH PSILI AND VARIAGREEK SMALL LETTER EPSILON" +
	" WITH DASIA AND VARIAGREEK SMALL LETTER EPSILON WITH PSILI AND OXIAGREEK" +
	" SMALL LETTER EPSILON WITH DASIA AND OXIAGREEK CAPITAL LETTER EPSILON WI" +
	"TH PSILIGREEK CAPITAL LETTER EPSILON WITH DASIAGREEK CAPITAL LETTER EPSI" +
	"LON WITH PSILI AND VARIAGREEK CAPITAL LETTER EPSILON WITH DASIA AND VARI" +
	"AGREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIAGREEK CAPITAL LETTER EP") + ("" +
	"SILON WITH DASIA AND OXIAGREEK SMALL LETTER ETA WITH PSILIGREEK SMALL LE" +
	"TTER ETA WITH DASIAGREEK SMALL LETTER ETA WITH PSILI AND VARIAGREEK SMAL" +
	"L LETTER ETA WITH DASIA AND VARIAGREEK SMALL LETTER ETA WITH PSILI AND O" +
	"XIAGREEK SMALL LETTER ETA WITH DASIA AND OXIAGREEK SMALL LETTER ETA WITH" +
	" PSILI AND PERISPOMENIGREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENIG" +
	"REEK CAPITAL LETTER ETA WITH PSILIGREEK CAPITAL LETTER ETA WITH DASIAGRE" +
	"EK CAPITAL LETTER ETA WITH PSILI AND VARIAGREEK CAPITAL LETTER ETA WITH " +
	"DASIA AND VARIAGREEK CAPITAL LETTER ETA WITH PSILI AND OXIAGREEK CAPITAL" +
	" LETTER ETA WITH DASIA AND OXIAGREEK CAPITAL LETTER ETA WITH PSILI AND P" +
	"ERISPOMENIGREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENIGREEK SMALL" +
	" LETTER IOTA WITH PSILIGREEK SMALL LETTER IOTA WITH DASIAGREEK SMALL LET" +
	"TER IOTA WITH PSILI AND VARIAGREEK SMALL LETTER IOTA WITH DASIA AND VARI" +
	"AGREEK SMALL LETTER IOTA WITH PSILI AND OXIAGREEK SMALL LETTER IOTA WITH" +
	" DASIA AND OXIAGREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENIGREEK S" +
	"MALL LETTER IOTA WITH DASIA AND PERISPOMENIGREEK CAPITAL LETTER IOTA WIT" +
	"H PSILIGREEK CAPITAL LETTER IOTA WITH DASIAGREEK CAPITAL LETTER IOTA WIT" +
	"H PSILI AND VARIAGREEK CAPITAL LETTER IOTA WITH DASIA AND VARIAGREEK CAP" +
	"ITAL LETTER IOTA WITH PSILI AND OXIAGREEK CAPITAL LETTER IOTA WITH DASIA" +
	" AND OXIAGREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENIGREEK CAPIT" +
	"AL LETTER IOTA WITH DASIA AND PERISPOMENIGREEK SMALL LETTER OMICRON WITH" +
	" PSILIGREEK SMALL LETTER OMICRON WITH DASIAGREEK SMALL LETTER OMICRON WI" +
	"TH PSILI AND VARIAGREEK SMALL LETTER OMICRON WITH DASIA AND VARIAGREEK S" +
	"MALL LETTER OMICRON WITH PSILI AND OXIAGREEK SMALL LETTER OMICRON WITH D" +
	"ASIA AND OXIAGREEK CAPITAL LETTER OMICRON WITH PSILIGREEK CAPITAL LETTER" +
	" OMICRON WITH DASIAGREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIAGREE" +
	"K CAPITAL LETTER OMICRON WITH DASIA AND VARIAGREEK CAPITAL LETTER OMICRO" +
	"N WITH PSILI AND OXIAGREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIAGRE" +
	"EK SMALL LETTER UPSILON WITH PSILIGREEK SMALL LETTER UPSILON WITH DASIAG" +
	"REEK SMALL LETTER UPSILON WITH PSILI AND VARIAGREEK SMALL LETTER UPSILON" +
	" WITH DASIA AND VARIAGREEK SMALL LETTER UPSILON WITH PSILI AND OXIAGREEK" +
	" SMALL LETTER UPSILON WITH DASIA AND OXIAGREEK SMALL LETTER UPSILON WITH" +
	" PSILI AND PERISPOMENIGREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOM" +
	"ENIGREEK CAPITAL LETTER UPSILON WITH DASIAGREEK CAPITAL LETTER UPSILON W" +
	"ITH DASIA AND VARIAGREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIAGREEK" +
	" CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENIGREEK SMALL LETTER OME" +
	"GA WITH PSILIGREEK SMALL LETTER OMEGA WITH DASIAGREEK SMALL LETTER OMEGA" +
	" WITH PSILI AND VARIAGREEK SMALL LETTER OMEGA WITH DASIA AND VARIAGREEK " +
	"SMALL LETTER OMEGA WITH PSILI AND OXIAGREEK SMALL LETTER OMEGA WITH DASI" +
	"A AND OXIAGREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENIGREEK SMALL" +
	" LETTER OMEGA WITH DASIA AND PERISPOMENIGREEK CAPITAL LETTER OMEGA WITH " +
	"PSILIGREEK CAPITAL LETTER OMEGA WITH DASIAGREEK CAPITAL LETTER OMEGA WIT" +
	"H PSILI AND VARIAGREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIAGREEK CA" +
	"PITAL LETTER OMEGA WITH PSILI AND OXIAGREEK CAPITAL LETTER OMEGA WITH DA" +
	"SIA AND OXIAGREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENIGREEK C" +
	"APITAL LETTER OMEGA WITH DASIA AND PERISPOMENIGREEK SMALL LETTER ALPHA W" +
	"ITH VARIAGREEK SMALL LETTER ALPHA WITH OXIAGREEK SMALL LETTER EPSILON WI" +
	"TH VARIAGREEK SMALL LETTER EPSILON WITH OXIAGREEK SMALL LETTER ETA WITH " +
	"VARIAGREEK SMALL LETTER ETA WITH OXIAGREEK SMALL LETTER IOTA WITH VARIAG" +
	"REEK SMALL LETTER IOTA WITH OXIAGREEK SMALL LETTER OMICRON WITH VARIAGRE" +
	"EK SMALL LETTER OMICRON WITH OXIAGREEK SMALL LETTER UPSILON WITH VARIAGR" +
	"EEK SMALL LETTER UPSILON WITH OXIAGREEK SMALL LETTER OMEGA WITH VARIAGRE" +
	"EK SMALL LETTER OMEGA WITH OXIAGREEK SMALL LETTER ALPHA WITH PSILI AND Y" +
	"POGEGRAMMENIGREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENIGREEK S" +
	"MALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETT" +
	"ER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA " +
	"WITH PSILI AND OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH DASIA" +
	" AND OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH PSILI AND PERIS" +
	"POMENI AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOM" +
	"ENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRA" +
	"MMENIGREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENIGREEK CAPIT" +
	"AL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LET" +
	"TER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER AL" +
	"PHA WITH PSILI AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WIT" +
	"H DASIA AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH PSILI") + ("" +
	" AND PERISPOMENI AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH DASIA" +
	" AND PERISPOMENI AND PROSGEGRAMMENIGREEK SMALL LETTER ETA WITH PSILI AND" +
	" YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENIGREEK S" +
	"MALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER" +
	" ETA WITH DASIA AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH P" +
	"SILI AND OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH DASIA AND OXI" +
	"A AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND" +
	" YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOG" +
	"EGRAMMENIGREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENIGREEK CAP" +
	"ITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WI" +
	"TH PSILI AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH DASIA" +
	" AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH PSILI AND OXI" +
	"A AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PRO" +
	"SGEGRAMMENIGREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSG" +
	"EGRAMMENIGREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEG" +
	"RAMMENIGREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENIGREEK SMALL " +
	"LETTER OMEGA WITH DASIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH P" +
	"SILI AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH DASIA AND " +
	"VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND " +
	"YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMM" +
	"ENIGREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI" +
	"GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENIGRE" +
	"EK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENIGREEK CAPITAL LETTE" +
	"R OMEGA WITH DASIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH PSI" +
	"LI AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH DASIA AND" +
	" VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA " +
	"AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PRO" +
	"SGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PRO" +
	"SGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PRO" +
	"SGEGRAMMENIGREEK SMALL LETTER ALPHA WITH VRACHYGREEK SMALL LETTER ALPHA " +
	"WITH MACRONGREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENIGREEK SM" +
	"ALL LETTER ALPHA WITH YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH OXIA AN" +
	"D YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH PERISPOMENIGREEK SMALL LETT" +
	"ER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER ALPHA WI" +
	"TH VRACHYGREEK CAPITAL LETTER ALPHA WITH MACRONGREEK CAPITAL LETTER ALPH" +
	"A WITH VARIAGREEK CAPITAL LETTER ALPHA WITH OXIAGREEK CAPITAL LETTER ALP" +
	"HA WITH PROSGEGRAMMENIGREEK KORONISGREEK PROSGEGRAMMENIGREEK PSILIGREEK " +
	"PERISPOMENIGREEK DIALYTIKA AND PERISPOMENIGREEK SMALL LETTER ETA WITH VA" +
	"RIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH YPOGEGRAMMENIGREEK SMAL" +
	"L LETTER ETA WITH OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH PERI" +
	"SPOMENIGREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENIGREEK CA" +
	"PITAL LETTER EPSILON WITH VARIAGREEK CAPITAL LETTER EPSILON WITH OXIAGRE" +
	"EK CAPITAL LETTER ETA WITH VARIAGREEK CAPITAL LETTER ETA WITH OXIAGREEK " +
	"CAPITAL LETTER ETA WITH PROSGEGRAMMENIGREEK PSILI AND VARIAGREEK PSILI A" +
	"ND OXIAGREEK PSILI AND PERISPOMENIGREEK SMALL LETTER IOTA WITH VRACHYGRE" +
	"EK SMALL LETTER IOTA WITH MACRONGREEK SMALL LETTER IOTA WITH DIALYTIKA A" +
	"ND VARIAGREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIAGREEK SMALL LETTE" +
	"R IOTA WITH PERISPOMENIGREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISP" +
	"OMENIGREEK CAPITAL LETTER IOTA WITH VRACHYGREEK CAPITAL LETTER IOTA WITH" +
	" MACRONGREEK CAPITAL LETTER IOTA WITH VARIAGREEK CAPITAL LETTER IOTA WIT" +
	"H OXIAGREEK DASIA AND VARIAGREEK DASIA AND OXIAGREEK DASIA AND PERISPOME" +
	"NIGREEK SMALL LETTER UPSILON WITH VRACHYGREEK SMALL LETTER UPSILON WITH " +
	"MACRONGREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIAGREEK SMALL LET" +
	"TER UPSILON WITH DIALYTIKA AND OXIAGREEK SMALL LETTER RHO WITH PSILIGREE" +
	"K SMALL LETTER RHO WITH DASIAGREEK SMALL LETTER UPSILON WITH PERISPOMENI" +
	"GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENIGREEK CAPITAL L" +
	"ETTER UPSILON WITH VRACHYGREEK CAPITAL LETTER UPSILON WITH MACRONGREEK C" +
	"APITAL LETTER UPSILON WITH VARIAGREEK CAPITAL LETTER UPSILON WITH OXIAGR" +
	"EEK CAPITAL LETTER RHO WITH DASIAGREEK DIALYTIKA AND VARIAGREEK DIALYTIK" +
	"A AND OXIAGREEK VARIAGREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMME" +
	"NIGREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WI" +
	"TH OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH PERISPOMENIGREEK " +
	"SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTE" +
	"R OMICRON WITH VARIAGREEK CAPITAL LETTER OMICRON WITH OXIAGREEK CAPITAL ") + ("" +
	"LETTER OMEGA WITH VARIAGREEK CAPITAL LETTER OMEGA WITH OXIAGREEK CAPITAL" +
	" LETTER OMEGA WITH PROSGEGRAMMENIGREEK OXIAGREEK DASIAEN QUADEM QUADEN S" +
	"PACEEM SPACETHREE-PER-EM SPACEFOUR-PER-EM SPACESIX-PER-EM SPACEFIGURE SP" +
	"ACEPUNCTUATION SPACETHIN SPACEHAIR SPACEZERO WIDTH SPACEZERO WIDTH NON-J" +
	"OINERZERO WIDTH JOINERLEFT-TO-RIGHT MARKRIGHT-TO-LEFT MARKHYPHENNON-BREA" +
	"KING HYPHENFIGURE DASHEN DASHEM DASHHORIZONTAL BARDOUBLE VERTICAL LINEDO" +
	"UBLE LOW LINELEFT SINGLE QUOTATION MARKRIGHT SINGLE QUOTATION MARKSINGLE" +
	" LOW-9 QUOTATION MARKSINGLE HIGH-REVERSED-9 QUOTATION MARKLEFT DOUBLE QU" +
	"OTATION MARKRIGHT DOUBLE QUOTATION MARKDOUBLE LOW-9 QUOTATION MARKDOUBLE" +
	" HIGH-REVERSED-9 QUOTATION MARKDAGGERDOUBLE DAGGERBULLETTRIANGULAR BULLE" +
	"TONE DOT LEADERTWO DOT LEADERHORIZONTAL ELLIPSISHYPHENATION POINTLINE SE" +
	"PARATORPARAGRAPH SEPARATORLEFT-TO-RIGHT EMBEDDINGRIGHT-TO-LEFT EMBEDDING" +
	"POP DIRECTIONAL FORMATTINGLEFT-TO-RIGHT OVERRIDERIGHT-TO-LEFT OVERRIDENA" +
	"RROW NO-BREAK SPACEPER MILLE SIGNPER TEN THOUSAND SIGNPRIMEDOUBLE PRIMET" +
	"RIPLE PRIMEREVERSED PRIMEREVERSED DOUBLE PRIMEREVERSED TRIPLE PRIMECARET" +
	"SINGLE LEFT-POINTING ANGLE QUOTATION MARKSINGLE RIGHT-POINTING ANGLE QUO" +
	"TATION MARKREFERENCE MARKDOUBLE EXCLAMATION MARKINTERROBANGOVERLINEUNDER" +
	"TIECHARACTER TIECARET INSERTION POINTASTERISMHYPHEN BULLETFRACTION SLASH" +
	"LEFT SQUARE BRACKET WITH QUILLRIGHT SQUARE BRACKET WITH QUILLDOUBLE QUES" +
	"TION MARKQUESTION EXCLAMATION MARKEXCLAMATION QUESTION MARKTIRONIAN SIGN" +
	" ETREVERSED PILCROW SIGNBLACK LEFTWARDS BULLETBLACK RIGHTWARDS BULLETLOW" +
	" ASTERISKREVERSED SEMICOLONCLOSE UPTWO ASTERISKS ALIGNED VERTICALLYCOMME" +
	"RCIAL MINUS SIGNSWUNG DASHINVERTED UNDERTIEFLOWER PUNCTUATION MARKTHREE " +
	"DOT PUNCTUATIONQUADRUPLE PRIMEFOUR DOT PUNCTUATIONFIVE DOT PUNCTUATIONTW" +
	"O DOT PUNCTUATIONFOUR DOT MARKDOTTED CROSSTRICOLONVERTICAL FOUR DOTSMEDI" +
	"UM MATHEMATICAL SPACEWORD JOINERFUNCTION APPLICATIONINVISIBLE TIMESINVIS" +
	"IBLE SEPARATORINVISIBLE PLUSLEFT-TO-RIGHT ISOLATERIGHT-TO-LEFT ISOLATEFI" +
	"RST STRONG ISOLATEPOP DIRECTIONAL ISOLATEINHIBIT SYMMETRIC SWAPPINGACTIV" +
	"ATE SYMMETRIC SWAPPINGINHIBIT ARABIC FORM SHAPINGACTIVATE ARABIC FORM SH" +
	"APINGNATIONAL DIGIT SHAPESNOMINAL DIGIT SHAPESSUPERSCRIPT ZEROSUPERSCRIP" +
	"T LATIN SMALL LETTER ISUPERSCRIPT FOURSUPERSCRIPT FIVESUPERSCRIPT SIXSUP" +
	"ERSCRIPT SEVENSUPERSCRIPT EIGHTSUPERSCRIPT NINESUPERSCRIPT PLUS SIGNSUPE" +
	"RSCRIPT MINUSSUPERSCRIPT EQUALS SIGNSUPERSCRIPT LEFT PARENTHESISSUPERSCR" +
	"IPT RIGHT PARENTHESISSUPERSCRIPT LATIN SMALL LETTER NSUBSCRIPT ZEROSUBSC" +
	"RIPT ONESUBSCRIPT TWOSUBSCRIPT THREESUBSCRIPT FOURSUBSCRIPT FIVESUBSCRIP" +
	"T SIXSUBSCRIPT SEVENSUBSCRIPT EIGHTSUBSCRIPT NINESUBSCRIPT PLUS SIGNSUBS" +
	"CRIPT MINUSSUBSCRIPT EQUALS SIGNSUBSCRIPT LEFT PARENTHESISSUBSCRIPT RIGH" +
	"T PARENTHESISLATIN SUBSCRIPT SMALL LETTER ALATIN SUBSCRIPT SMALL LETTER " +
	"ELATIN SUBSCRIPT SMALL LETTER OLATIN SUBSCRIPT SMALL LETTER XLATIN SUBSC" +
	"RIPT SMALL LETTER SCHWALATIN SUBSCRIPT SMALL LETTER HLATIN SUBSCRIPT SMA" +
	"LL LETTER KLATIN SUBSCRIPT SMALL LETTER LLATIN SUBSCRIPT SMALL LETTER ML" +
	"ATIN SUBSCRIPT SMALL LETTER NLATIN SUBSCRIPT SMALL LETTER PLATIN SUBSCRI" +
	"PT SMALL LETTER SLATIN SUBSCRIPT SMALL LETTER TEURO-CURRENCY SIGNCOLON S" +
	"IGNCRUZEIRO SIGNFRENCH FRANC SIGNLIRA SIGNMILL SIGNNAIRA SIGNPESETA SIGN" +
	"RUPEE SIGNWON SIGNNEW SHEQEL SIGNDONG SIGNEURO SIGNKIP SIGNTUGRIK SIGNDR" +
	"ACHMA SIGNGERMAN PENNY SIGNPESO SIGNGUARANI SIGNAUSTRAL SIGNHRYVNIA SIGN" +
	"CEDI SIGNLIVRE TOURNOIS SIGNSPESMILO SIGNTENGE SIGNINDIAN RUPEE SIGNTURK" +
	"ISH LIRA SIGNNORDIC MARK SIGNMANAT SIGNRUBLE SIGNLARI SIGNBITCOIN SIGNCO" +
	"MBINING LEFT HARPOON ABOVECOMBINING RIGHT HARPOON ABOVECOMBINING LONG VE" +
	"RTICAL LINE OVERLAYCOMBINING SHORT VERTICAL LINE OVERLAYCOMBINING ANTICL" +
	"OCKWISE ARROW ABOVECOMBINING CLOCKWISE ARROW ABOVECOMBINING LEFT ARROW A" +
	"BOVECOMBINING RIGHT ARROW ABOVECOMBINING RING OVERLAYCOMBINING CLOCKWISE" +
	" RING OVERLAYCOMBINING ANTICLOCKWISE RING OVERLAYCOMBINING THREE DOTS AB" +
	"OVECOMBINING FOUR DOTS ABOVECOMBINING ENCLOSING CIRCLECOMBINING ENCLOSIN" +
	"G SQUARECOMBINING ENCLOSING DIAMONDCOMBINING ENCLOSING CIRCLE BACKSLASHC" +
	"OMBINING LEFT RIGHT ARROW ABOVECOMBINING ENCLOSING SCREENCOMBINING ENCLO" +
	"SING KEYCAPCOMBINING ENCLOSING UPWARD POINTING TRIANGLECOMBINING REVERSE" +
	" SOLIDUS OVERLAYCOMBINING DOUBLE VERTICAL STROKE OVERLAYCOMBINING ANNUIT" +
	"Y SYMBOLCOMBINING TRIPLE UNDERDOTCOMBINING WIDE BRIDGE ABOVECOMBINING LE" +
	"FTWARDS ARROW OVERLAYCOMBINING LONG DOUBLE SOLIDUS OVERLAYCOMBINING RIGH" +
	"TWARDS HARPOON WITH BARB DOWNWARDSCOMBINING LEFTWARDS HARPOON WITH BARB " +
	"DOWNWARDSCOMBINING LEFT ARROW BELOWCOMBINING RIGHT ARROW BELOWCOMBINING " +
	"ASTERISK ABOVEACCOUNT OFADDRESSED TO THE SUBJECTDOUBLE-STRUCK CAPITAL CD" +
	"EGREE CELSIUSCENTRE LINE SYMBOLCARE OFCADA UNAEULER CONSTANTSCRUPLEDEGRE") + ("" +
	"E FAHRENHEITSCRIPT SMALL GSCRIPT CAPITAL HBLACK-LETTER CAPITAL HDOUBLE-S" +
	"TRUCK CAPITAL HPLANCK CONSTANTPLANCK CONSTANT OVER TWO PISCRIPT CAPITAL " +
	"IBLACK-LETTER CAPITAL ISCRIPT CAPITAL LSCRIPT SMALL LL B BAR SYMBOLDOUBL" +
	"E-STRUCK CAPITAL NNUMERO SIGNSOUND RECORDING COPYRIGHTSCRIPT CAPITAL PDO" +
	"UBLE-STRUCK CAPITAL PDOUBLE-STRUCK CAPITAL QSCRIPT CAPITAL RBLACK-LETTER" +
	" CAPITAL RDOUBLE-STRUCK CAPITAL RPRESCRIPTION TAKERESPONSESERVICE MARKTE" +
	"LEPHONE SIGNTRADE MARK SIGNVERSICLEDOUBLE-STRUCK CAPITAL ZOUNCE SIGNOHM " +
	"SIGNINVERTED OHM SIGNBLACK-LETTER CAPITAL ZTURNED GREEK SMALL LETTER IOT" +
	"AKELVIN SIGNANGSTROM SIGNSCRIPT CAPITAL BBLACK-LETTER CAPITAL CESTIMATED" +
	" SYMBOLSCRIPT SMALL ESCRIPT CAPITAL ESCRIPT CAPITAL FTURNED CAPITAL FSCR" +
	"IPT CAPITAL MSCRIPT SMALL OALEF SYMBOLBET SYMBOLGIMEL SYMBOLDALET SYMBOL" +
	"INFORMATION SOURCEROTATED CAPITAL QFACSIMILE SIGNDOUBLE-STRUCK SMALL PID" +
	"OUBLE-STRUCK SMALL GAMMADOUBLE-STRUCK CAPITAL GAMMADOUBLE-STRUCK CAPITAL" +
	" PIDOUBLE-STRUCK N-ARY SUMMATIONTURNED SANS-SERIF CAPITAL GTURNED SANS-S" +
	"ERIF CAPITAL LREVERSED SANS-SERIF CAPITAL LTURNED SANS-SERIF CAPITAL YDO" +
	"UBLE-STRUCK ITALIC CAPITAL DDOUBLE-STRUCK ITALIC SMALL DDOUBLE-STRUCK IT" +
	"ALIC SMALL EDOUBLE-STRUCK ITALIC SMALL IDOUBLE-STRUCK ITALIC SMALL JPROP" +
	"ERTY LINETURNED AMPERSANDPER SIGNAKTIESELSKABTURNED SMALL FSYMBOL FOR SA" +
	"MARITAN SOURCEVULGAR FRACTION ONE SEVENTHVULGAR FRACTION ONE NINTHVULGAR" +
	" FRACTION ONE TENTHVULGAR FRACTION ONE THIRDVULGAR FRACTION TWO THIRDSVU" +
	"LGAR FRACTION ONE FIFTHVULGAR FRACTION TWO FIFTHSVULGAR FRACTION THREE F" +
	"IFTHSVULGAR FRACTION FOUR FIFTHSVULGAR FRACTION ONE SIXTHVULGAR FRACTION" +
	" FIVE SIXTHSVULGAR FRACTION ONE EIGHTHVULGAR FRACTION THREE EIGHTHSVULGA" +
	"R FRACTION FIVE EIGHTHSVULGAR FRACTION SEVEN EIGHTHSFRACTION NUMERATOR O" +
	"NEROMAN NUMERAL ONEROMAN NUMERAL TWOROMAN NUMERAL THREEROMAN NUMERAL FOU" +
	"RROMAN NUMERAL FIVEROMAN NUMERAL SIXROMAN NUMERAL SEVENROMAN NUMERAL EIG" +
	"HTROMAN NUMERAL NINEROMAN NUMERAL TENROMAN NUMERAL ELEVENROMAN NUMERAL T" +
	"WELVEROMAN NUMERAL FIFTYROMAN NUMERAL ONE HUNDREDROMAN NUMERAL FIVE HUND" +
	"REDROMAN NUMERAL ONE THOUSANDSMALL ROMAN NUMERAL ONESMALL ROMAN NUMERAL " +
	"TWOSMALL ROMAN NUMERAL THREESMALL ROMAN NUMERAL FOURSMALL ROMAN NUMERAL " +
	"FIVESMALL ROMAN NUMERAL SIXSMALL ROMAN NUMERAL SEVENSMALL ROMAN NUMERAL " +
	"EIGHTSMALL ROMAN NUMERAL NINESMALL ROMAN NUMERAL TENSMALL ROMAN NUMERAL " +
	"ELEVENSMALL ROMAN NUMERAL TWELVESMALL ROMAN NUMERAL FIFTYSMALL ROMAN NUM" +
	"ERAL ONE HUNDREDSMALL ROMAN NUMERAL FIVE HUNDREDSMALL ROMAN NUMERAL ONE " +
	"THOUSANDROMAN NUMERAL ONE THOUSAND C DROMAN NUMERAL FIVE THOUSANDROMAN N" +
	"UMERAL TEN THOUSANDROMAN NUMERAL REVERSED ONE HUNDREDLATIN SMALL LETTER " +
	"REVERSED CROMAN NUMERAL SIX LATE FORMROMAN NUMERAL FIFTY EARLY FORMROMAN" +
	" NUMERAL FIFTY THOUSANDROMAN NUMERAL ONE HUNDRED THOUSANDVULGAR FRACTION" +
	" ZERO THIRDSTURNED DIGIT TWOTURNED DIGIT THREELEFTWARDS ARROWUPWARDS ARR" +
	"OWRIGHTWARDS ARROWDOWNWARDS ARROWLEFT RIGHT ARROWUP DOWN ARROWNORTH WEST" +
	" ARROWNORTH EAST ARROWSOUTH EAST ARROWSOUTH WEST ARROWLEFTWARDS ARROW WI" +
	"TH STROKERIGHTWARDS ARROW WITH STROKELEFTWARDS WAVE ARROWRIGHTWARDS WAVE" +
	" ARROWLEFTWARDS TWO HEADED ARROWUPWARDS TWO HEADED ARROWRIGHTWARDS TWO H" +
	"EADED ARROWDOWNWARDS TWO HEADED ARROWLEFTWARDS ARROW WITH TAILRIGHTWARDS" +
	" ARROW WITH TAILLEFTWARDS ARROW FROM BARUPWARDS ARROW FROM BARRIGHTWARDS" +
	" ARROW FROM BARDOWNWARDS ARROW FROM BARUP DOWN ARROW WITH BASELEFTWARDS " +
	"ARROW WITH HOOKRIGHTWARDS ARROW WITH HOOKLEFTWARDS ARROW WITH LOOPRIGHTW" +
	"ARDS ARROW WITH LOOPLEFT RIGHT WAVE ARROWLEFT RIGHT ARROW WITH STROKEDOW" +
	"NWARDS ZIGZAG ARROWUPWARDS ARROW WITH TIP LEFTWARDSUPWARDS ARROW WITH TI" +
	"P RIGHTWARDSDOWNWARDS ARROW WITH TIP LEFTWARDSDOWNWARDS ARROW WITH TIP R" +
	"IGHTWARDSRIGHTWARDS ARROW WITH CORNER DOWNWARDSDOWNWARDS ARROW WITH CORN" +
	"ER LEFTWARDSANTICLOCKWISE TOP SEMICIRCLE ARROWCLOCKWISE TOP SEMICIRCLE A" +
	"RROWNORTH WEST ARROW TO LONG BARLEFTWARDS ARROW TO BAR OVER RIGHTWARDS A" +
	"RROW TO BARANTICLOCKWISE OPEN CIRCLE ARROWCLOCKWISE OPEN CIRCLE ARROWLEF" +
	"TWARDS HARPOON WITH BARB UPWARDSLEFTWARDS HARPOON WITH BARB DOWNWARDSUPW" +
	"ARDS HARPOON WITH BARB RIGHTWARDSUPWARDS HARPOON WITH BARB LEFTWARDSRIGH" +
	"TWARDS HARPOON WITH BARB UPWARDSRIGHTWARDS HARPOON WITH BARB DOWNWARDSDO" +
	"WNWARDS HARPOON WITH BARB RIGHTWARDSDOWNWARDS HARPOON WITH BARB LEFTWARD" +
	"SRIGHTWARDS ARROW OVER LEFTWARDS ARROWUPWARDS ARROW LEFTWARDS OF DOWNWAR" +
	"DS ARROWLEFTWARDS ARROW OVER RIGHTWARDS ARROWLEFTWARDS PAIRED ARROWSUPWA" +
	"RDS PAIRED ARROWSRIGHTWARDS PAIRED ARROWSDOWNWARDS PAIRED ARROWSLEFTWARD" +
	"S HARPOON OVER RIGHTWARDS HARPOONRIGHTWARDS HARPOON OVER LEFTWARDS HARPO" +
	"ONLEFTWARDS DOUBLE ARROW WITH STROKELEFT RIGHT DOUBLE ARROW WITH STROKER" +
	"IGHTWARDS DOUBLE ARROW WITH STROKELEFTWARDS DOUBLE ARROWUPWARDS DOUBLE A") + ("" +
	"RROWRIGHTWARDS DOUBLE ARROWDOWNWARDS DOUBLE ARROWLEFT RIGHT DOUBLE ARROW" +
	"UP DOWN DOUBLE ARROWNORTH WEST DOUBLE ARROWNORTH EAST DOUBLE ARROWSOUTH " +
	"EAST DOUBLE ARROWSOUTH WEST DOUBLE ARROWLEFTWARDS TRIPLE ARROWRIGHTWARDS" +
	" TRIPLE ARROWLEFTWARDS SQUIGGLE ARROWRIGHTWARDS SQUIGGLE ARROWUPWARDS AR" +
	"ROW WITH DOUBLE STROKEDOWNWARDS ARROW WITH DOUBLE STROKELEFTWARDS DASHED" +
	" ARROWUPWARDS DASHED ARROWRIGHTWARDS DASHED ARROWDOWNWARDS DASHED ARROWL" +
	"EFTWARDS ARROW TO BARRIGHTWARDS ARROW TO BARLEFTWARDS WHITE ARROWUPWARDS" +
	" WHITE ARROWRIGHTWARDS WHITE ARROWDOWNWARDS WHITE ARROWUPWARDS WHITE ARR" +
	"OW FROM BARUPWARDS WHITE ARROW ON PEDESTALUPWARDS WHITE ARROW ON PEDESTA" +
	"L WITH HORIZONTAL BARUPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BARUP" +
	"WARDS WHITE DOUBLE ARROWUPWARDS WHITE DOUBLE ARROW ON PEDESTALRIGHTWARDS" +
	" WHITE ARROW FROM WALLNORTH WEST ARROW TO CORNERSOUTH EAST ARROW TO CORN" +
	"ERUP DOWN WHITE ARROWRIGHT ARROW WITH SMALL CIRCLEDOWNWARDS ARROW LEFTWA" +
	"RDS OF UPWARDS ARROWTHREE RIGHTWARDS ARROWSLEFTWARDS ARROW WITH VERTICAL" +
	" STROKERIGHTWARDS ARROW WITH VERTICAL STROKELEFT RIGHT ARROW WITH VERTIC" +
	"AL STROKELEFTWARDS ARROW WITH DOUBLE VERTICAL STROKERIGHTWARDS ARROW WIT" +
	"H DOUBLE VERTICAL STROKELEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKELEFT" +
	"WARDS OPEN-HEADED ARROWRIGHTWARDS OPEN-HEADED ARROWLEFT RIGHT OPEN-HEADE" +
	"D ARROWFOR ALLCOMPLEMENTPARTIAL DIFFERENTIALTHERE EXISTSTHERE DOES NOT E" +
	"XISTEMPTY SETINCREMENTNABLAELEMENT OFNOT AN ELEMENT OFSMALL ELEMENT OFCO" +
	"NTAINS AS MEMBERDOES NOT CONTAIN AS MEMBERSMALL CONTAINS AS MEMBEREND OF" +
	" PROOFN-ARY PRODUCTN-ARY COPRODUCTN-ARY SUMMATIONMINUS SIGNMINUS-OR-PLUS" +
	" SIGNDOT PLUSDIVISION SLASHSET MINUSASTERISK OPERATORRING OPERATORBULLET" +
	" OPERATORSQUARE ROOTCUBE ROOTFOURTH ROOTPROPORTIONAL TOINFINITYRIGHT ANG" +
	"LEANGLEMEASURED ANGLESPHERICAL ANGLEDIVIDESDOES NOT DIVIDEPARALLEL TONOT" +
	" PARALLEL TOLOGICAL ANDLOGICAL ORINTERSECTIONUNIONINTEGRALDOUBLE INTEGRA" +
	"LTRIPLE INTEGRALCONTOUR INTEGRALSURFACE INTEGRALVOLUME INTEGRALCLOCKWISE" +
	" INTEGRALCLOCKWISE CONTOUR INTEGRALANTICLOCKWISE CONTOUR INTEGRALTHEREFO" +
	"REBECAUSERATIOPROPORTIONDOT MINUSEXCESSGEOMETRIC PROPORTIONHOMOTHETICTIL" +
	"DE OPERATORREVERSED TILDEINVERTED LAZY SSINE WAVEWREATH PRODUCTNOT TILDE" +
	"MINUS TILDEASYMPTOTICALLY EQUAL TONOT ASYMPTOTICALLY EQUAL TOAPPROXIMATE" +
	"LY EQUAL TOAPPROXIMATELY BUT NOT ACTUALLY EQUAL TONEITHER APPROXIMATELY " +
	"NOR ACTUALLY EQUAL TOALMOST EQUAL TONOT ALMOST EQUAL TOALMOST EQUAL OR E" +
	"QUAL TOTRIPLE TILDEALL EQUAL TOEQUIVALENT TOGEOMETRICALLY EQUIVALENT TOD" +
	"IFFERENCE BETWEENAPPROACHES THE LIMITGEOMETRICALLY EQUAL TOAPPROXIMATELY" +
	" EQUAL TO OR THE IMAGE OFIMAGE OF OR APPROXIMATELY EQUAL TOCOLON EQUALSE" +
	"QUALS COLONRING IN EQUAL TORING EQUAL TOCORRESPONDS TOESTIMATESEQUIANGUL" +
	"AR TOSTAR EQUALSDELTA EQUAL TOEQUAL TO BY DEFINITIONMEASURED BYQUESTIONE" +
	"D EQUAL TONOT EQUAL TOIDENTICAL TONOT IDENTICAL TOSTRICTLY EQUIVALENT TO" +
	"LESS-THAN OR EQUAL TOGREATER-THAN OR EQUAL TOLESS-THAN OVER EQUAL TOGREA" +
	"TER-THAN OVER EQUAL TOLESS-THAN BUT NOT EQUAL TOGREATER-THAN BUT NOT EQU" +
	"AL TOMUCH LESS-THANMUCH GREATER-THANBETWEENNOT EQUIVALENT TONOT LESS-THA" +
	"NNOT GREATER-THANNEITHER LESS-THAN NOR EQUAL TONEITHER GREATER-THAN NOR " +
	"EQUAL TOLESS-THAN OR EQUIVALENT TOGREATER-THAN OR EQUIVALENT TONEITHER L" +
	"ESS-THAN NOR EQUIVALENT TONEITHER GREATER-THAN NOR EQUIVALENT TOLESS-THA" +
	"N OR GREATER-THANGREATER-THAN OR LESS-THANNEITHER LESS-THAN NOR GREATER-" +
	"THANNEITHER GREATER-THAN NOR LESS-THANPRECEDESSUCCEEDSPRECEDES OR EQUAL " +
	"TOSUCCEEDS OR EQUAL TOPRECEDES OR EQUIVALENT TOSUCCEEDS OR EQUIVALENT TO" +
	"DOES NOT PRECEDEDOES NOT SUCCEEDSUBSET OFSUPERSET OFNOT A SUBSET OFNOT A" +
	" SUPERSET OFSUBSET OF OR EQUAL TOSUPERSET OF OR EQUAL TONEITHER A SUBSET" +
	" OF NOR EQUAL TONEITHER A SUPERSET OF NOR EQUAL TOSUBSET OF WITH NOT EQU" +
	"AL TOSUPERSET OF WITH NOT EQUAL TOMULTISETMULTISET MULTIPLICATIONMULTISE" +
	"T UNIONSQUARE IMAGE OFSQUARE ORIGINAL OFSQUARE IMAGE OF OR EQUAL TOSQUAR" +
	"E ORIGINAL OF OR EQUAL TOSQUARE CAPSQUARE CUPCIRCLED PLUSCIRCLED MINUSCI" +
	"RCLED TIMESCIRCLED DIVISION SLASHCIRCLED DOT OPERATORCIRCLED RING OPERAT" +
	"ORCIRCLED ASTERISK OPERATORCIRCLED EQUALSCIRCLED DASHSQUARED PLUSSQUARED" +
	" MINUSSQUARED TIMESSQUARED DOT OPERATORRIGHT TACKLEFT TACKDOWN TACKUP TA" +
	"CKASSERTIONMODELSTRUEFORCESTRIPLE VERTICAL BAR RIGHT TURNSTILEDOUBLE VER" +
	"TICAL BAR DOUBLE RIGHT TURNSTILEDOES NOT PROVENOT TRUEDOES NOT FORCENEGA" +
	"TED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILEPRECEDES UNDER RELATIONSUC" +
	"CEEDS UNDER RELATIONNORMAL SUBGROUP OFCONTAINS AS NORMAL SUBGROUPNORMAL " +
	"SUBGROUP OF OR EQUAL TOCONTAINS AS NORMAL SUBGROUP OR EQUAL TOORIGINAL O" +
	"FIMAGE OFMULTIMAPHERMITIAN CONJUGATE MATRIXINTERCALATEXORNANDNORRIGHT AN" +
	"GLE WITH ARCRIGHT TRIANGLEN-ARY LOGICAL ANDN-ARY LOGICAL ORN-ARY INTERSE") + ("" +
	"CTIONN-ARY UNIONDIAMOND OPERATORDOT OPERATORSTAR OPERATORDIVISION TIMESB" +
	"OWTIELEFT NORMAL FACTOR SEMIDIRECT PRODUCTRIGHT NORMAL FACTOR SEMIDIRECT" +
	" PRODUCTLEFT SEMIDIRECT PRODUCTRIGHT SEMIDIRECT PRODUCTREVERSED TILDE EQ" +
	"UALSCURLY LOGICAL ORCURLY LOGICAL ANDDOUBLE SUBSETDOUBLE SUPERSETDOUBLE " +
	"INTERSECTIONDOUBLE UNIONPITCHFORKEQUAL AND PARALLEL TOLESS-THAN WITH DOT" +
	"GREATER-THAN WITH DOTVERY MUCH LESS-THANVERY MUCH GREATER-THANLESS-THAN " +
	"EQUAL TO OR GREATER-THANGREATER-THAN EQUAL TO OR LESS-THANEQUAL TO OR LE" +
	"SS-THANEQUAL TO OR GREATER-THANEQUAL TO OR PRECEDESEQUAL TO OR SUCCEEDSD" +
	"OES NOT PRECEDE OR EQUALDOES NOT SUCCEED OR EQUALNOT SQUARE IMAGE OF OR " +
	"EQUAL TONOT SQUARE ORIGINAL OF OR EQUAL TOSQUARE IMAGE OF OR NOT EQUAL T" +
	"OSQUARE ORIGINAL OF OR NOT EQUAL TOLESS-THAN BUT NOT EQUIVALENT TOGREATE" +
	"R-THAN BUT NOT EQUIVALENT TOPRECEDES BUT NOT EQUIVALENT TOSUCCEEDS BUT N" +
	"OT EQUIVALENT TONOT NORMAL SUBGROUP OFDOES NOT CONTAIN AS NORMAL SUBGROU" +
	"PNOT NORMAL SUBGROUP OF OR EQUAL TODOES NOT CONTAIN AS NORMAL SUBGROUP O" +
	"R EQUALVERTICAL ELLIPSISMIDLINE HORIZONTAL ELLIPSISUP RIGHT DIAGONAL ELL" +
	"IPSISDOWN RIGHT DIAGONAL ELLIPSISELEMENT OF WITH LONG HORIZONTAL STROKEE" +
	"LEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKESMALL ELEMENT OF " +
	"WITH VERTICAL BAR AT END OF HORIZONTAL STROKEELEMENT OF WITH DOT ABOVEEL" +
	"EMENT OF WITH OVERBARSMALL ELEMENT OF WITH OVERBARELEMENT OF WITH UNDERB" +
	"ARELEMENT OF WITH TWO HORIZONTAL STROKESCONTAINS WITH LONG HORIZONTAL ST" +
	"ROKECONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKESMALL CONTAINS" +
	" WITH VERTICAL BAR AT END OF HORIZONTAL STROKECONTAINS WITH OVERBARSMALL" +
	" CONTAINS WITH OVERBARZ NOTATION BAG MEMBERSHIPDIAMETER SIGNELECTRIC ARR" +
	"OWHOUSEUP ARROWHEADDOWN ARROWHEADPROJECTIVEPERSPECTIVEWAVY LINELEFT CEIL" +
	"INGRIGHT CEILINGLEFT FLOORRIGHT FLOORBOTTOM RIGHT CROPBOTTOM LEFT CROPTO" +
	"P RIGHT CROPTOP LEFT CROPREVERSED NOT SIGNSQUARE LOZENGEARCSEGMENTSECTOR" +
	"TELEPHONE RECORDERPOSITION INDICATORVIEWDATA SQUAREPLACE OF INTEREST SIG" +
	"NTURNED NOT SIGNWATCHHOURGLASSTOP LEFT CORNERTOP RIGHT CORNERBOTTOM LEFT" +
	" CORNERBOTTOM RIGHT CORNERTOP HALF INTEGRALBOTTOM HALF INTEGRALFROWNSMIL" +
	"EUP ARROWHEAD BETWEEN TWO HORIZONTAL BARSOPTION KEYERASE TO THE RIGHTX I" +
	"N A RECTANGLE BOXKEYBOARDLEFT-POINTING ANGLE BRACKETRIGHT-POINTING ANGLE" +
	" BRACKETERASE TO THE LEFTBENZENE RINGCYLINDRICITYALL AROUND-PROFILESYMME" +
	"TRYTOTAL RUNOUTDIMENSION ORIGINCONICAL TAPERSLOPECOUNTERBORECOUNTERSINKA" +
	"PL FUNCTIONAL SYMBOL I-BEAMAPL FUNCTIONAL SYMBOL SQUISH QUADAPL FUNCTION" +
	"AL SYMBOL QUAD EQUALAPL FUNCTIONAL SYMBOL QUAD DIVIDEAPL FUNCTIONAL SYMB" +
	"OL QUAD DIAMONDAPL FUNCTIONAL SYMBOL QUAD JOTAPL FUNCTIONAL SYMBOL QUAD " +
	"CIRCLEAPL FUNCTIONAL SYMBOL CIRCLE STILEAPL FUNCTIONAL SYMBOL CIRCLE JOT" +
	"APL FUNCTIONAL SYMBOL SLASH BARAPL FUNCTIONAL SYMBOL BACKSLASH BARAPL FU" +
	"NCTIONAL SYMBOL QUAD SLASHAPL FUNCTIONAL SYMBOL QUAD BACKSLASHAPL FUNCTI" +
	"ONAL SYMBOL QUAD LESS-THANAPL FUNCTIONAL SYMBOL QUAD GREATER-THANAPL FUN" +
	"CTIONAL SYMBOL LEFTWARDS VANEAPL FUNCTIONAL SYMBOL RIGHTWARDS VANEAPL FU" +
	"NCTIONAL SYMBOL QUAD LEFTWARDS ARROWAPL FUNCTIONAL SYMBOL QUAD RIGHTWARD" +
	"S ARROWAPL FUNCTIONAL SYMBOL CIRCLE BACKSLASHAPL FUNCTIONAL SYMBOL DOWN " +
	"TACK UNDERBARAPL FUNCTIONAL SYMBOL DELTA STILEAPL FUNCTIONAL SYMBOL QUAD" +
	" DOWN CARETAPL FUNCTIONAL SYMBOL QUAD DELTAAPL FUNCTIONAL SYMBOL DOWN TA" +
	"CK JOTAPL FUNCTIONAL SYMBOL UPWARDS VANEAPL FUNCTIONAL SYMBOL QUAD UPWAR" +
	"DS ARROWAPL FUNCTIONAL SYMBOL UP TACK OVERBARAPL FUNCTIONAL SYMBOL DEL S" +
	"TILEAPL FUNCTIONAL SYMBOL QUAD UP CARETAPL FUNCTIONAL SYMBOL QUAD DELAPL" +
	" FUNCTIONAL SYMBOL UP TACK JOTAPL FUNCTIONAL SYMBOL DOWNWARDS VANEAPL FU" +
	"NCTIONAL SYMBOL QUAD DOWNWARDS ARROWAPL FUNCTIONAL SYMBOL QUOTE UNDERBAR" +
	"APL FUNCTIONAL SYMBOL DELTA UNDERBARAPL FUNCTIONAL SYMBOL DIAMOND UNDERB" +
	"ARAPL FUNCTIONAL SYMBOL JOT UNDERBARAPL FUNCTIONAL SYMBOL CIRCLE UNDERBA" +
	"RAPL FUNCTIONAL SYMBOL UP SHOE JOTAPL FUNCTIONAL SYMBOL QUOTE QUADAPL FU" +
	"NCTIONAL SYMBOL CIRCLE STARAPL FUNCTIONAL SYMBOL QUAD COLONAPL FUNCTIONA" +
	"L SYMBOL UP TACK DIAERESISAPL FUNCTIONAL SYMBOL DEL DIAERESISAPL FUNCTIO" +
	"NAL SYMBOL STAR DIAERESISAPL FUNCTIONAL SYMBOL JOT DIAERESISAPL FUNCTION" +
	"AL SYMBOL CIRCLE DIAERESISAPL FUNCTIONAL SYMBOL DOWN SHOE STILEAPL FUNCT" +
	"IONAL SYMBOL LEFT SHOE STILEAPL FUNCTIONAL SYMBOL TILDE DIAERESISAPL FUN" +
	"CTIONAL SYMBOL GREATER-THAN DIAERESISAPL FUNCTIONAL SYMBOL COMMA BARAPL " +
	"FUNCTIONAL SYMBOL DEL TILDEAPL FUNCTIONAL SYMBOL ZILDEAPL FUNCTIONAL SYM" +
	"BOL STILE TILDEAPL FUNCTIONAL SYMBOL SEMICOLON UNDERBARAPL FUNCTIONAL SY" +
	"MBOL QUAD NOT EQUALAPL FUNCTIONAL SYMBOL QUAD QUESTIONAPL FUNCTIONAL SYM" +
	"BOL DOWN CARET TILDEAPL FUNCTIONAL SYMBOL UP CARET TILDEAPL FUNCTIONAL S" +
	"YMBOL IOTAAPL FUNCTIONAL SYMBOL RHOAPL FUNCTIONAL SYMBOL OMEGAAPL FUNCTI") + ("" +
	"ONAL SYMBOL ALPHA UNDERBARAPL FUNCTIONAL SYMBOL EPSILON UNDERBARAPL FUNC" +
	"TIONAL SYMBOL IOTA UNDERBARAPL FUNCTIONAL SYMBOL OMEGA UNDERBARAPL FUNCT" +
	"IONAL SYMBOL ALPHANOT CHECK MARKRIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROWS" +
	"HOULDERED OPEN BOXBELL SYMBOLVERTICAL LINE WITH MIDDLE DOTINSERTION SYMB" +
	"OLCONTINUOUS UNDERLINE SYMBOLDISCONTINUOUS UNDERLINE SYMBOLEMPHASIS SYMB" +
	"OLCOMPOSITION SYMBOLWHITE SQUARE WITH CENTRE VERTICAL LINEENTER SYMBOLAL" +
	"TERNATIVE KEY SYMBOLHELM SYMBOLCIRCLED HORIZONTAL BAR WITH NOTCHCIRCLED " +
	"TRIANGLE DOWNBROKEN CIRCLE WITH NORTHWEST ARROWUNDO SYMBOLMONOSTABLE SYM" +
	"BOLHYSTERESIS SYMBOLOPEN-CIRCUIT-OUTPUT H-TYPE SYMBOLOPEN-CIRCUIT-OUTPUT" +
	" L-TYPE SYMBOLPASSIVE-PULL-DOWN-OUTPUT SYMBOLPASSIVE-PULL-UP-OUTPUT SYMB" +
	"OLDIRECT CURRENT SYMBOL FORM TWOSOFTWARE-FUNCTION SYMBOLAPL FUNCTIONAL S" +
	"YMBOL QUADDECIMAL SEPARATOR KEY SYMBOLPREVIOUS PAGENEXT PAGEPRINT SCREEN" +
	" SYMBOLCLEAR SCREEN SYMBOLLEFT PARENTHESIS UPPER HOOKLEFT PARENTHESIS EX" +
	"TENSIONLEFT PARENTHESIS LOWER HOOKRIGHT PARENTHESIS UPPER HOOKRIGHT PARE" +
	"NTHESIS EXTENSIONRIGHT PARENTHESIS LOWER HOOKLEFT SQUARE BRACKET UPPER C" +
	"ORNERLEFT SQUARE BRACKET EXTENSIONLEFT SQUARE BRACKET LOWER CORNERRIGHT " +
	"SQUARE BRACKET UPPER CORNERRIGHT SQUARE BRACKET EXTENSIONRIGHT SQUARE BR" +
	"ACKET LOWER CORNERLEFT CURLY BRACKET UPPER HOOKLEFT CURLY BRACKET MIDDLE" +
	" PIECELEFT CURLY BRACKET LOWER HOOKCURLY BRACKET EXTENSIONRIGHT CURLY BR" +
	"ACKET UPPER HOOKRIGHT CURLY BRACKET MIDDLE PIECERIGHT CURLY BRACKET LOWE" +
	"R HOOKINTEGRAL EXTENSIONHORIZONTAL LINE EXTENSIONUPPER LEFT OR LOWER RIG" +
	"HT CURLY BRACKET SECTIONUPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTIONS" +
	"UMMATION TOPSUMMATION BOTTOMTOP SQUARE BRACKETBOTTOM SQUARE BRACKETBOTTO" +
	"M SQUARE BRACKET OVER TOP SQUARE BRACKETRADICAL SYMBOL BOTTOMLEFT VERTIC" +
	"AL BOX LINERIGHT VERTICAL BOX LINEHORIZONTAL SCAN LINE-1HORIZONTAL SCAN " +
	"LINE-3HORIZONTAL SCAN LINE-7HORIZONTAL SCAN LINE-9DENTISTRY SYMBOL LIGHT" +
	" VERTICAL AND TOP RIGHTDENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHTD" +
	"ENTISTRY SYMBOL LIGHT VERTICAL WITH CIRCLEDENTISTRY SYMBOL LIGHT DOWN AN" +
	"D HORIZONTAL WITH CIRCLEDENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CI" +
	"RCLEDENTISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLEDENTISTRY SYMBOL LIGHT " +
	"DOWN AND HORIZONTAL WITH TRIANGLEDENTISTRY SYMBOL LIGHT UP AND HORIZONTA" +
	"L WITH TRIANGLEDENTISTRY SYMBOL LIGHT VERTICAL AND WAVEDENTISTRY SYMBOL " +
	"LIGHT DOWN AND HORIZONTAL WITH WAVEDENTISTRY SYMBOL LIGHT UP AND HORIZON" +
	"TAL WITH WAVEDENTISTRY SYMBOL LIGHT DOWN AND HORIZONTALDENTISTRY SYMBOL " +
	"LIGHT UP AND HORIZONTALDENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFTDENTI" +
	"STRY SYMBOL LIGHT VERTICAL AND BOTTOM LEFTSQUARE FOOTRETURN SYMBOLEJECT " +
	"SYMBOLVERTICAL LINE EXTENSIONMETRICAL BREVEMETRICAL LONG OVER SHORTMETRI" +
	"CAL SHORT OVER LONGMETRICAL LONG OVER TWO SHORTSMETRICAL TWO SHORTS OVER" +
	" LONGMETRICAL TWO SHORTS JOINEDMETRICAL TRISEMEMETRICAL TETRASEMEMETRICA" +
	"L PENTASEMEEARTH GROUNDFUSETOP PARENTHESISBOTTOM PARENTHESISTOP CURLY BR" +
	"ACKETBOTTOM CURLY BRACKETTOP TORTOISE SHELL BRACKETBOTTOM TORTOISE SHELL" +
	" BRACKETWHITE TRAPEZIUMBENZENE RING WITH CIRCLESTRAIGHTNESSFLATNESSAC CU" +
	"RRENTELECTRICAL INTERSECTIONDECIMAL EXPONENT SYMBOLBLACK RIGHT-POINTING " +
	"DOUBLE TRIANGLEBLACK LEFT-POINTING DOUBLE TRIANGLEBLACK UP-POINTING DOUB" +
	"LE TRIANGLEBLACK DOWN-POINTING DOUBLE TRIANGLEBLACK RIGHT-POINTING DOUBL" +
	"E TRIANGLE WITH VERTICAL BARBLACK LEFT-POINTING DOUBLE TRIANGLE WITH VER" +
	"TICAL BARBLACK RIGHT-POINTING TRIANGLE WITH DOUBLE VERTICAL BARALARM CLO" +
	"CKSTOPWATCHTIMER CLOCKHOURGLASS WITH FLOWING SANDBLACK MEDIUM LEFT-POINT" +
	"ING TRIANGLEBLACK MEDIUM RIGHT-POINTING TRIANGLEBLACK MEDIUM UP-POINTING" +
	" TRIANGLEBLACK MEDIUM DOWN-POINTING TRIANGLEDOUBLE VERTICAL BARBLACK SQU" +
	"ARE FOR STOPBLACK CIRCLE FOR RECORDPOWER SYMBOLPOWER ON-OFF SYMBOLPOWER " +
	"ON SYMBOLPOWER SLEEP SYMBOLOBSERVER EYE SYMBOLSYMBOL FOR NULLSYMBOL FOR " +
	"START OF HEADINGSYMBOL FOR START OF TEXTSYMBOL FOR END OF TEXTSYMBOL FOR" +
	" END OF TRANSMISSIONSYMBOL FOR ENQUIRYSYMBOL FOR ACKNOWLEDGESYMBOL FOR B" +
	"ELLSYMBOL FOR BACKSPACESYMBOL FOR HORIZONTAL TABULATIONSYMBOL FOR LINE F" +
	"EEDSYMBOL FOR VERTICAL TABULATIONSYMBOL FOR FORM FEEDSYMBOL FOR CARRIAGE" +
	" RETURNSYMBOL FOR SHIFT OUTSYMBOL FOR SHIFT INSYMBOL FOR DATA LINK ESCAP" +
	"ESYMBOL FOR DEVICE CONTROL ONESYMBOL FOR DEVICE CONTROL TWOSYMBOL FOR DE" +
	"VICE CONTROL THREESYMBOL FOR DEVICE CONTROL FOURSYMBOL FOR NEGATIVE ACKN" +
	"OWLEDGESYMBOL FOR SYNCHRONOUS IDLESYMBOL FOR END OF TRANSMISSION BLOCKSY" +
	"MBOL FOR CANCELSYMBOL FOR END OF MEDIUMSYMBOL FOR SUBSTITUTESYMBOL FOR E" +
	"SCAPESYMBOL FOR FILE SEPARATORSYMBOL FOR GROUP SEPARATORSYMBOL FOR RECOR" +
	"D SEPARATORSYMBOL FOR UNIT SEPARATORSYMBOL FOR SPACESYMBOL FOR DELETEBLA" +
	"NK SYMBOLOPEN BOXSYMBOL FOR NEWLINESYMBOL FOR DELETE FORM TWOSYMBOL FOR ") + ("" +
	"SUBSTITUTE FORM TWOOCR HOOKOCR CHAIROCR FORKOCR INVERTED FORKOCR BELT BU" +
	"CKLEOCR BOW TIEOCR BRANCH BANK IDENTIFICATIONOCR AMOUNT OF CHECKOCR DASH" +
	"OCR CUSTOMER ACCOUNT NUMBEROCR DOUBLE BACKSLASHCIRCLED DIGIT ONECIRCLED " +
	"DIGIT TWOCIRCLED DIGIT THREECIRCLED DIGIT FOURCIRCLED DIGIT FIVECIRCLED " +
	"DIGIT SIXCIRCLED DIGIT SEVENCIRCLED DIGIT EIGHTCIRCLED DIGIT NINECIRCLED" +
	" NUMBER TENCIRCLED NUMBER ELEVENCIRCLED NUMBER TWELVECIRCLED NUMBER THIR" +
	"TEENCIRCLED NUMBER FOURTEENCIRCLED NUMBER FIFTEENCIRCLED NUMBER SIXTEENC" +
	"IRCLED NUMBER SEVENTEENCIRCLED NUMBER EIGHTEENCIRCLED NUMBER NINETEENCIR" +
	"CLED NUMBER TWENTYPARENTHESIZED DIGIT ONEPARENTHESIZED DIGIT TWOPARENTHE" +
	"SIZED DIGIT THREEPARENTHESIZED DIGIT FOURPARENTHESIZED DIGIT FIVEPARENTH" +
	"ESIZED DIGIT SIXPARENTHESIZED DIGIT SEVENPARENTHESIZED DIGIT EIGHTPARENT" +
	"HESIZED DIGIT NINEPARENTHESIZED NUMBER TENPARENTHESIZED NUMBER ELEVENPAR" +
	"ENTHESIZED NUMBER TWELVEPARENTHESIZED NUMBER THIRTEENPARENTHESIZED NUMBE" +
	"R FOURTEENPARENTHESIZED NUMBER FIFTEENPARENTHESIZED NUMBER SIXTEENPARENT" +
	"HESIZED NUMBER SEVENTEENPARENTHESIZED NUMBER EIGHTEENPARENTHESIZED NUMBE" +
	"R NINETEENPARENTHESIZED NUMBER TWENTYDIGIT ONE FULL STOPDIGIT TWO FULL S" +
	"TOPDIGIT THREE FULL STOPDIGIT FOUR FULL STOPDIGIT FIVE FULL STOPDIGIT SI" +
	"X FULL STOPDIGIT SEVEN FULL STOPDIGIT EIGHT FULL STOPDIGIT NINE FULL STO" +
	"PNUMBER TEN FULL STOPNUMBER ELEVEN FULL STOPNUMBER TWELVE FULL STOPNUMBE" +
	"R THIRTEEN FULL STOPNUMBER FOURTEEN FULL STOPNUMBER FIFTEEN FULL STOPNUM" +
	"BER SIXTEEN FULL STOPNUMBER SEVENTEEN FULL STOPNUMBER EIGHTEEN FULL STOP" +
	"NUMBER NINETEEN FULL STOPNUMBER TWENTY FULL STOPPARENTHESIZED LATIN SMAL" +
	"L LETTER APARENTHESIZED LATIN SMALL LETTER BPARENTHESIZED LATIN SMALL LE" +
	"TTER CPARENTHESIZED LATIN SMALL LETTER DPARENTHESIZED LATIN SMALL LETTER" +
	" EPARENTHESIZED LATIN SMALL LETTER FPARENTHESIZED LATIN SMALL LETTER GPA" +
	"RENTHESIZED LATIN SMALL LETTER HPARENTHESIZED LATIN SMALL LETTER IPARENT" +
	"HESIZED LATIN SMALL LETTER JPARENTHESIZED LATIN SMALL LETTER KPARENTHESI" +
	"ZED LATIN SMALL LETTER LPARENTHESIZED LATIN SMALL LETTER MPARENTHESIZED " +
	"LATIN SMALL LETTER NPARENTHESIZED LATIN SMALL LETTER OPARENTHESIZED LATI" +
	"N SMALL LETTER PPARENTHESIZED LATIN SMALL LETTER QPARENTHESIZED LATIN SM" +
	"ALL LETTER RPARENTHESIZED LATIN SMALL LETTER SPARENTHESIZED LATIN SMALL " +
	"LETTER TPARENTHESIZED LATIN SMALL LETTER UPARENTHESIZED LATIN SMALL LETT" +
	"ER VPARENTHESIZED LATIN SMALL LETTER WPARENTHESIZED LATIN SMALL LETTER X" +
	"PARENTHESIZED LATIN SMALL LETTER YPARENTHESIZED LATIN SMALL LETTER ZCIRC" +
	"LED LATIN CAPITAL LETTER ACIRCLED LATIN CAPITAL LETTER BCIRCLED LATIN CA" +
	"PITAL LETTER CCIRCLED LATIN CAPITAL LETTER DCIRCLED LATIN CAPITAL LETTER" +
	" ECIRCLED LATIN CAPITAL LETTER FCIRCLED LATIN CAPITAL LETTER GCIRCLED LA" +
	"TIN CAPITAL LETTER HCIRCLED LATIN CAPITAL LETTER ICIRCLED LATIN CAPITAL " +
	"LETTER JCIRCLED LATIN CAPITAL LETTER KCIRCLED LATIN CAPITAL LETTER LCIRC" +
	"LED LATIN CAPITAL LETTER MCIRCLED LATIN CAPITAL LETTER NCIRCLED LATIN CA" +
	"PITAL LETTER OCIRCLED LATIN CAPITAL LETTER PCIRCLED LATIN CAPITAL LETTER" +
	" QCIRCLED LATIN CAPITAL LETTER RCIRCLED LATIN CAPITAL LETTER SCIRCLED LA" +
	"TIN CAPITAL LETTER TCIRCLED LATIN CAPITAL LETTER UCIRCLED LATIN CAPITAL " +
	"LETTER VCIRCLED LATIN CAPITAL LETTER WCIRCLED LATIN CAPITAL LETTER XCIRC" +
	"LED LATIN CAPITAL LETTER YCIRCLED LATIN CAPITAL LETTER ZCIRCLED LATIN SM" +
	"ALL LETTER ACIRCLED LATIN SMALL LETTER BCIRCLED LATIN SMALL LETTER CCIRC" +
	"LED LATIN SMALL LETTER DCIRCLED LATIN SMALL LETTER ECIRCLED LATIN SMALL " +
	"LETTER FCIRCLED LATIN SMALL LETTER GCIRCLED LATIN SMALL LETTER HCIRCLED " +
	"LATIN SMALL LETTER ICIRCLED LATIN SMALL LETTER JCIRCLED LATIN SMALL LETT" +
	"ER KCIRCLED LATIN SMALL LETTER LCIRCLED LATIN SMALL LETTER MCIRCLED LATI" +
	"N SMALL LETTER NCIRCLED LATIN SMALL LETTER OCIRCLED LATIN SMALL LETTER P" +
	"CIRCLED LATIN SMALL LETTER QCIRCLED LATIN SMALL LETTER RCIRCLED LATIN SM" +
	"ALL LETTER SCIRCLED LATIN SMALL LETTER TCIRCLED LATIN SMALL LETTER UCIRC" +
	"LED LATIN SMALL LETTER VCIRCLED LATIN SMALL LETTER WCIRCLED LATIN SMALL " +
	"LETTER XCIRCLED LATIN SMALL LETTER YCIRCLED LATIN SMALL LETTER ZCIRCLED " +
	"DIGIT ZERONEGATIVE CIRCLED NUMBER ELEVENNEGATIVE CIRCLED NUMBER TWELVENE" +
	"GATIVE CIRCLED NUMBER THIRTEENNEGATIVE CIRCLED NUMBER FOURTEENNEGATIVE C" +
	"IRCLED NUMBER FIFTEENNEGATIVE CIRCLED NUMBER SIXTEENNEGATIVE CIRCLED NUM" +
	"BER SEVENTEENNEGATIVE CIRCLED NUMBER EIGHTEENNEGATIVE CIRCLED NUMBER NIN" +
	"ETEENNEGATIVE CIRCLED NUMBER TWENTYDOUBLE CIRCLED DIGIT ONEDOUBLE CIRCLE" +
	"D DIGIT TWODOUBLE CIRCLED DIGIT THREEDOUBLE CIRCLED DIGIT FOURDOUBLE CIR" +
	"CLED DIGIT FIVEDOUBLE CIRCLED DIGIT SIXDOUBLE CIRCLED DIGIT SEVENDOUBLE " +
	"CIRCLED DIGIT EIGHTDOUBLE CIRCLED DIGIT NINEDOUBLE CIRCLED NUMBER TENNEG" +
	"ATIVE CIRCLED DIGIT ZEROBOX DRAWINGS LIGHT HORIZONTALBOX DRAWINGS HEAVY ") + ("" +
	"HORIZONTALBOX DRAWINGS LIGHT VERTICALBOX DRAWINGS HEAVY VERTICALBOX DRAW" +
	"INGS LIGHT TRIPLE DASH HORIZONTALBOX DRAWINGS HEAVY TRIPLE DASH HORIZONT" +
	"ALBOX DRAWINGS LIGHT TRIPLE DASH VERTICALBOX DRAWINGS HEAVY TRIPLE DASH " +
	"VERTICALBOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTALBOX DRAWINGS HEAVY Q" +
	"UADRUPLE DASH HORIZONTALBOX DRAWINGS LIGHT QUADRUPLE DASH VERTICALBOX DR" +
	"AWINGS HEAVY QUADRUPLE DASH VERTICALBOX DRAWINGS LIGHT DOWN AND RIGHTBOX" +
	" DRAWINGS DOWN LIGHT AND RIGHT HEAVYBOX DRAWINGS DOWN HEAVY AND RIGHT LI" +
	"GHTBOX DRAWINGS HEAVY DOWN AND RIGHTBOX DRAWINGS LIGHT DOWN AND LEFTBOX " +
	"DRAWINGS DOWN LIGHT AND LEFT HEAVYBOX DRAWINGS DOWN HEAVY AND LEFT LIGHT" +
	"BOX DRAWINGS HEAVY DOWN AND LEFTBOX DRAWINGS LIGHT UP AND RIGHTBOX DRAWI" +
	"NGS UP LIGHT AND RIGHT HEAVYBOX DRAWINGS UP HEAVY AND RIGHT LIGHTBOX DRA" +
	"WINGS HEAVY UP AND RIGHTBOX DRAWINGS LIGHT UP AND LEFTBOX DRAWINGS UP LI" +
	"GHT AND LEFT HEAVYBOX DRAWINGS UP HEAVY AND LEFT LIGHTBOX DRAWINGS HEAVY" +
	" UP AND LEFTBOX DRAWINGS LIGHT VERTICAL AND RIGHTBOX DRAWINGS VERTICAL L" +
	"IGHT AND RIGHT HEAVYBOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHTBOX DRAWIN" +
	"GS DOWN HEAVY AND RIGHT UP LIGHTBOX DRAWINGS VERTICAL HEAVY AND RIGHT LI" +
	"GHTBOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVYBOX DRAWINGS UP LIGHT AND R" +
	"IGHT DOWN HEAVYBOX DRAWINGS HEAVY VERTICAL AND RIGHTBOX DRAWINGS LIGHT V" +
	"ERTICAL AND LEFTBOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVYBOX DRAWINGS U" +
	"P HEAVY AND LEFT DOWN LIGHTBOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHTBOX " +
	"DRAWINGS VERTICAL HEAVY AND LEFT LIGHTBOX DRAWINGS DOWN LIGHT AND LEFT U" +
	"P HEAVYBOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVYBOX DRAWINGS HEAVY VERTI" +
	"CAL AND LEFTBOX DRAWINGS LIGHT DOWN AND HORIZONTALBOX DRAWINGS LEFT HEAV" +
	"Y AND RIGHT DOWN LIGHTBOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHTBOX DR" +
	"AWINGS DOWN LIGHT AND HORIZONTAL HEAVYBOX DRAWINGS DOWN HEAVY AND HORIZO" +
	"NTAL LIGHTBOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVYBOX DRAWINGS LEFT " +
	"LIGHT AND RIGHT DOWN HEAVYBOX DRAWINGS HEAVY DOWN AND HORIZONTALBOX DRAW" +
	"INGS LIGHT UP AND HORIZONTALBOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHTBO" +
	"X DRAWINGS RIGHT HEAVY AND LEFT UP LIGHTBOX DRAWINGS UP LIGHT AND HORIZO" +
	"NTAL HEAVYBOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHTBOX DRAWINGS RIGHT L" +
	"IGHT AND LEFT UP HEAVYBOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVYBOX DRAW" +
	"INGS HEAVY UP AND HORIZONTALBOX DRAWINGS LIGHT VERTICAL AND HORIZONTALBO" +
	"X DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHTBOX DRAWINGS RIGHT HEAVY A" +
	"ND LEFT VERTICAL LIGHTBOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVYBO" +
	"X DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHTBOX DRAWINGS DOWN HEAVY AND" +
	" UP HORIZONTAL LIGHTBOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHTBOX " +
	"DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHTBOX DRAWINGS RIGHT UP HEAVY A" +
	"ND LEFT DOWN LIGHTBOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHTBOX DRA" +
	"WINGS RIGHT DOWN HEAVY AND LEFT UP LIGHTBOX DRAWINGS DOWN LIGHT AND UP H" +
	"ORIZONTAL HEAVYBOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVYBOX DRAWIN" +
	"GS RIGHT LIGHT AND LEFT VERTICAL HEAVYBOX DRAWINGS LEFT LIGHT AND RIGHT " +
	"VERTICAL HEAVYBOX DRAWINGS HEAVY VERTICAL AND HORIZONTALBOX DRAWINGS LIG" +
	"HT DOUBLE DASH HORIZONTALBOX DRAWINGS HEAVY DOUBLE DASH HORIZONTALBOX DR" +
	"AWINGS LIGHT DOUBLE DASH VERTICALBOX DRAWINGS HEAVY DOUBLE DASH VERTICAL" +
	"BOX DRAWINGS DOUBLE HORIZONTALBOX DRAWINGS DOUBLE VERTICALBOX DRAWINGS D" +
	"OWN SINGLE AND RIGHT DOUBLEBOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLEBOX " +
	"DRAWINGS DOUBLE DOWN AND RIGHTBOX DRAWINGS DOWN SINGLE AND LEFT DOUBLEBO" +
	"X DRAWINGS DOWN DOUBLE AND LEFT SINGLEBOX DRAWINGS DOUBLE DOWN AND LEFTB" +
	"OX DRAWINGS UP SINGLE AND RIGHT DOUBLEBOX DRAWINGS UP DOUBLE AND RIGHT S" +
	"INGLEBOX DRAWINGS DOUBLE UP AND RIGHTBOX DRAWINGS UP SINGLE AND LEFT DOU" +
	"BLEBOX DRAWINGS UP DOUBLE AND LEFT SINGLEBOX DRAWINGS DOUBLE UP AND LEFT" +
	"BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLEBOX DRAWINGS VERTICAL DOUBL" +
	"E AND RIGHT SINGLEBOX DRAWINGS DOUBLE VERTICAL AND RIGHTBOX DRAWINGS VER" +
	"TICAL SINGLE AND LEFT DOUBLEBOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE" +
	"BOX DRAWINGS DOUBLE VERTICAL AND LEFTBOX DRAWINGS DOWN SINGLE AND HORIZO" +
	"NTAL DOUBLEBOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLEBOX DRAWINGS DO" +
	"UBLE DOWN AND HORIZONTALBOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLEBOX " +
	"DRAWINGS UP DOUBLE AND HORIZONTAL SINGLEBOX DRAWINGS DOUBLE UP AND HORIZ" +
	"ONTALBOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLEBOX DRAWINGS VERT" +
	"ICAL DOUBLE AND HORIZONTAL SINGLEBOX DRAWINGS DOUBLE VERTICAL AND HORIZO" +
	"NTALBOX DRAWINGS LIGHT ARC DOWN AND RIGHTBOX DRAWINGS LIGHT ARC DOWN AND" +
	" LEFTBOX DRAWINGS LIGHT ARC UP AND LEFTBOX DRAWINGS LIGHT ARC UP AND RIG" +
	"HTBOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFTBOX DRAWINGS LIGH" +
	"T DIAGONAL UPPER LEFT TO LOWER RIGHTBOX DRAWINGS LIGHT DIAGONAL CROSSBOX") + ("" +
	" DRAWINGS LIGHT LEFTBOX DRAWINGS LIGHT UPBOX DRAWINGS LIGHT RIGHTBOX DRA" +
	"WINGS LIGHT DOWNBOX DRAWINGS HEAVY LEFTBOX DRAWINGS HEAVY UPBOX DRAWINGS" +
	" HEAVY RIGHTBOX DRAWINGS HEAVY DOWNBOX DRAWINGS LIGHT LEFT AND HEAVY RIG" +
	"HTBOX DRAWINGS LIGHT UP AND HEAVY DOWNBOX DRAWINGS HEAVY LEFT AND LIGHT " +
	"RIGHTBOX DRAWINGS HEAVY UP AND LIGHT DOWNUPPER HALF BLOCKLOWER ONE EIGHT" +
	"H BLOCKLOWER ONE QUARTER BLOCKLOWER THREE EIGHTHS BLOCKLOWER HALF BLOCKL" +
	"OWER FIVE EIGHTHS BLOCKLOWER THREE QUARTERS BLOCKLOWER SEVEN EIGHTHS BLO" +
	"CKFULL BLOCKLEFT SEVEN EIGHTHS BLOCKLEFT THREE QUARTERS BLOCKLEFT FIVE E" +
	"IGHTHS BLOCKLEFT HALF BLOCKLEFT THREE EIGHTHS BLOCKLEFT ONE QUARTER BLOC" +
	"KLEFT ONE EIGHTH BLOCKRIGHT HALF BLOCKLIGHT SHADEMEDIUM SHADEDARK SHADEU" +
	"PPER ONE EIGHTH BLOCKRIGHT ONE EIGHTH BLOCKQUADRANT LOWER LEFTQUADRANT L" +
	"OWER RIGHTQUADRANT UPPER LEFTQUADRANT UPPER LEFT AND LOWER LEFT AND LOWE" +
	"R RIGHTQUADRANT UPPER LEFT AND LOWER RIGHTQUADRANT UPPER LEFT AND UPPER " +
	"RIGHT AND LOWER LEFTQUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHTQ" +
	"UADRANT UPPER RIGHTQUADRANT UPPER RIGHT AND LOWER LEFTQUADRANT UPPER RIG" +
	"HT AND LOWER LEFT AND LOWER RIGHTBLACK SQUAREWHITE SQUAREWHITE SQUARE WI" +
	"TH ROUNDED CORNERSWHITE SQUARE CONTAINING BLACK SMALL SQUARESQUARE WITH " +
	"HORIZONTAL FILLSQUARE WITH VERTICAL FILLSQUARE WITH ORTHOGONAL CROSSHATC" +
	"H FILLSQUARE WITH UPPER LEFT TO LOWER RIGHT FILLSQUARE WITH UPPER RIGHT " +
	"TO LOWER LEFT FILLSQUARE WITH DIAGONAL CROSSHATCH FILLBLACK SMALL SQUARE" +
	"WHITE SMALL SQUAREBLACK RECTANGLEWHITE RECTANGLEBLACK VERTICAL RECTANGLE" +
	"WHITE VERTICAL RECTANGLEBLACK PARALLELOGRAMWHITE PARALLELOGRAMBLACK UP-P" +
	"OINTING TRIANGLEWHITE UP-POINTING TRIANGLEBLACK UP-POINTING SMALL TRIANG" +
	"LEWHITE UP-POINTING SMALL TRIANGLEBLACK RIGHT-POINTING TRIANGLEWHITE RIG" +
	"HT-POINTING TRIANGLEBLACK RIGHT-POINTING SMALL TRIANGLEWHITE RIGHT-POINT" +
	"ING SMALL TRIANGLEBLACK RIGHT-POINTING POINTERWHITE RIGHT-POINTING POINT" +
	"ERBLACK DOWN-POINTING TRIANGLEWHITE DOWN-POINTING TRIANGLEBLACK DOWN-POI" +
	"NTING SMALL TRIANGLEWHITE DOWN-POINTING SMALL TRIANGLEBLACK LEFT-POINTIN" +
	"G TRIANGLEWHITE LEFT-POINTING TRIANGLEBLACK LEFT-POINTING SMALL TRIANGLE" +
	"WHITE LEFT-POINTING SMALL TRIANGLEBLACK LEFT-POINTING POINTERWHITE LEFT-" +
	"POINTING POINTERBLACK DIAMONDWHITE DIAMONDWHITE DIAMOND CONTAINING BLACK" +
	" SMALL DIAMONDFISHEYELOZENGEWHITE CIRCLEDOTTED CIRCLECIRCLE WITH VERTICA" +
	"L FILLBULLSEYEBLACK CIRCLECIRCLE WITH LEFT HALF BLACKCIRCLE WITH RIGHT H" +
	"ALF BLACKCIRCLE WITH LOWER HALF BLACKCIRCLE WITH UPPER HALF BLACKCIRCLE " +
	"WITH UPPER RIGHT QUADRANT BLACKCIRCLE WITH ALL BUT UPPER LEFT QUADRANT B" +
	"LACKLEFT HALF BLACK CIRCLERIGHT HALF BLACK CIRCLEINVERSE BULLETINVERSE W" +
	"HITE CIRCLEUPPER HALF INVERSE WHITE CIRCLELOWER HALF INVERSE WHITE CIRCL" +
	"EUPPER LEFT QUADRANT CIRCULAR ARCUPPER RIGHT QUADRANT CIRCULAR ARCLOWER " +
	"RIGHT QUADRANT CIRCULAR ARCLOWER LEFT QUADRANT CIRCULAR ARCUPPER HALF CI" +
	"RCLELOWER HALF CIRCLEBLACK LOWER RIGHT TRIANGLEBLACK LOWER LEFT TRIANGLE" +
	"BLACK UPPER LEFT TRIANGLEBLACK UPPER RIGHT TRIANGLEWHITE BULLETSQUARE WI" +
	"TH LEFT HALF BLACKSQUARE WITH RIGHT HALF BLACKSQUARE WITH UPPER LEFT DIA" +
	"GONAL HALF BLACKSQUARE WITH LOWER RIGHT DIAGONAL HALF BLACKWHITE SQUARE " +
	"WITH VERTICAL BISECTING LINEWHITE UP-POINTING TRIANGLE WITH DOTUP-POINTI" +
	"NG TRIANGLE WITH LEFT HALF BLACKUP-POINTING TRIANGLE WITH RIGHT HALF BLA" +
	"CKLARGE CIRCLEWHITE SQUARE WITH UPPER LEFT QUADRANTWHITE SQUARE WITH LOW" +
	"ER LEFT QUADRANTWHITE SQUARE WITH LOWER RIGHT QUADRANTWHITE SQUARE WITH " +
	"UPPER RIGHT QUADRANTWHITE CIRCLE WITH UPPER LEFT QUADRANTWHITE CIRCLE WI" +
	"TH LOWER LEFT QUADRANTWHITE CIRCLE WITH LOWER RIGHT QUADRANTWHITE CIRCLE" +
	" WITH UPPER RIGHT QUADRANTUPPER LEFT TRIANGLEUPPER RIGHT TRIANGLELOWER L" +
	"EFT TRIANGLEWHITE MEDIUM SQUAREBLACK MEDIUM SQUAREWHITE MEDIUM SMALL SQU" +
	"AREBLACK MEDIUM SMALL SQUARELOWER RIGHT TRIANGLEBLACK SUN WITH RAYSCLOUD" +
	"UMBRELLASNOWMANCOMETBLACK STARWHITE STARLIGHTNINGTHUNDERSTORMSUNASCENDIN" +
	"G NODEDESCENDING NODECONJUNCTIONOPPOSITIONBLACK TELEPHONEWHITE TELEPHONE" +
	"BALLOT BOXBALLOT BOX WITH CHECKBALLOT BOX WITH XSALTIREUMBRELLA WITH RAI" +
	"N DROPSHOT BEVERAGEWHITE SHOGI PIECEBLACK SHOGI PIECESHAMROCKREVERSED RO" +
	"TATED FLORAL HEART BULLETBLACK LEFT POINTING INDEXBLACK RIGHT POINTING I" +
	"NDEXWHITE LEFT POINTING INDEXWHITE UP POINTING INDEXWHITE RIGHT POINTING" +
	" INDEXWHITE DOWN POINTING INDEXSKULL AND CROSSBONESCAUTION SIGNRADIOACTI" +
	"VE SIGNBIOHAZARD SIGNCADUCEUSANKHORTHODOX CROSSCHI RHOCROSS OF LORRAINEC" +
	"ROSS OF JERUSALEMSTAR AND CRESCENTFARSI SYMBOLADI SHAKTIHAMMER AND SICKL" +
	"EPEACE SYMBOLYIN YANGTRIGRAM FOR HEAVENTRIGRAM FOR LAKETRIGRAM FOR FIRET" +
	"RIGRAM FOR THUNDERTRIGRAM FOR WINDTRIGRAM FOR WATERTRIGRAM FOR MOUNTAINT" +
	"RIGRAM FOR EARTHWHEEL OF DHARMAWHITE FROWNING FACEWHITE SMILING FACEBLAC") + ("" +
	"K SMILING FACEWHITE SUN WITH RAYSFIRST QUARTER MOONLAST QUARTER MOONMERC" +
	"URYFEMALE SIGNEARTHMALE SIGNJUPITERSATURNURANUSNEPTUNEPLUTOARIESTAURUSGE" +
	"MINICANCERLEOVIRGOLIBRASCORPIUSSAGITTARIUSCAPRICORNAQUARIUSPISCESWHITE C" +
	"HESS KINGWHITE CHESS QUEENWHITE CHESS ROOKWHITE CHESS BISHOPWHITE CHESS " +
	"KNIGHTWHITE CHESS PAWNBLACK CHESS KINGBLACK CHESS QUEENBLACK CHESS ROOKB" +
	"LACK CHESS BISHOPBLACK CHESS KNIGHTBLACK CHESS PAWNBLACK SPADE SUITWHITE" +
	" HEART SUITWHITE DIAMOND SUITBLACK CLUB SUITWHITE SPADE SUITBLACK HEART " +
	"SUITBLACK DIAMOND SUITWHITE CLUB SUITHOT SPRINGSQUARTER NOTEEIGHTH NOTEB" +
	"EAMED EIGHTH NOTESBEAMED SIXTEENTH NOTESMUSIC FLAT SIGNMUSIC NATURAL SIG" +
	"NMUSIC SHARP SIGNWEST SYRIAC CROSSEAST SYRIAC CROSSUNIVERSAL RECYCLING S" +
	"YMBOLRECYCLING SYMBOL FOR TYPE-1 PLASTICSRECYCLING SYMBOL FOR TYPE-2 PLA" +
	"STICSRECYCLING SYMBOL FOR TYPE-3 PLASTICSRECYCLING SYMBOL FOR TYPE-4 PLA" +
	"STICSRECYCLING SYMBOL FOR TYPE-5 PLASTICSRECYCLING SYMBOL FOR TYPE-6 PLA" +
	"STICSRECYCLING SYMBOL FOR TYPE-7 PLASTICSRECYCLING SYMBOL FOR GENERIC MA" +
	"TERIALSBLACK UNIVERSAL RECYCLING SYMBOLRECYCLED PAPER SYMBOLPARTIALLY-RE" +
	"CYCLED PAPER SYMBOLPERMANENT PAPER SIGNWHEELCHAIR SYMBOLDIE FACE-1DIE FA" +
	"CE-2DIE FACE-3DIE FACE-4DIE FACE-5DIE FACE-6WHITE CIRCLE WITH DOT RIGHTW" +
	"HITE CIRCLE WITH TWO DOTSBLACK CIRCLE WITH WHITE DOT RIGHTBLACK CIRCLE W" +
	"ITH TWO WHITE DOTSMONOGRAM FOR YANGMONOGRAM FOR YINDIGRAM FOR GREATER YA" +
	"NGDIGRAM FOR LESSER YINDIGRAM FOR LESSER YANGDIGRAM FOR GREATER YINWHITE" +
	" FLAGBLACK FLAGHAMMER AND PICKANCHORCROSSED SWORDSSTAFF OF AESCULAPIUSSC" +
	"ALESALEMBICFLOWERGEARSTAFF OF HERMESATOM SYMBOLFLEUR-DE-LISOUTLINED WHIT" +
	"E STARTHREE LINES CONVERGING RIGHTTHREE LINES CONVERGING LEFTWARNING SIG" +
	"NHIGH VOLTAGE SIGNDOUBLED FEMALE SIGNDOUBLED MALE SIGNINTERLOCKED FEMALE" +
	" AND MALE SIGNMALE AND FEMALE SIGNMALE WITH STROKE SIGNMALE WITH STROKE " +
	"AND MALE AND FEMALE SIGNVERTICAL MALE WITH STROKE SIGNHORIZONTAL MALE WI" +
	"TH STROKE SIGNMEDIUM WHITE CIRCLEMEDIUM BLACK CIRCLEMEDIUM SMALL WHITE C" +
	"IRCLEMARRIAGE SYMBOLDIVORCE SYMBOLUNMARRIED PARTNERSHIP SYMBOLCOFFINFUNE" +
	"RAL URNNEUTERCERESPALLASJUNOVESTACHIRONBLACK MOON LILITHSEXTILESEMISEXTI" +
	"LEQUINCUNXSESQUIQUADRATESOCCER BALLBASEBALLSQUARED KEYWHITE DRAUGHTS MAN" +
	"WHITE DRAUGHTS KINGBLACK DRAUGHTS MANBLACK DRAUGHTS KINGSNOWMAN WITHOUT " +
	"SNOWSUN BEHIND CLOUDRAINBLACK SNOWMANTHUNDER CLOUD AND RAINTURNED WHITE " +
	"SHOGI PIECETURNED BLACK SHOGI PIECEWHITE DIAMOND IN SQUARECROSSING LANES" +
	"DISABLED CAROPHIUCHUSPICKCAR SLIDINGHELMET WITH WHITE CROSSCIRCLED CROSS" +
	"ING LANESCHAINSNO ENTRYALTERNATE ONE-WAY LEFT WAY TRAFFICBLACK TWO-WAY L" +
	"EFT WAY TRAFFICWHITE TWO-WAY LEFT WAY TRAFFICBLACK LEFT LANE MERGEWHITE " +
	"LEFT LANE MERGEDRIVE SLOW SIGNHEAVY WHITE DOWN-POINTING TRIANGLELEFT CLO" +
	"SED ENTRYSQUARED SALTIREFALLING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE" +
	"BLACK TRUCKRESTRICTED LEFT ENTRY-1RESTRICTED LEFT ENTRY-2ASTRONOMICAL SY" +
	"MBOL FOR URANUSHEAVY CIRCLE WITH STROKE AND TWO DOTS ABOVEPENTAGRAMRIGHT" +
	"-HANDED INTERLACED PENTAGRAMLEFT-HANDED INTERLACED PENTAGRAMINVERTED PEN" +
	"TAGRAMBLACK CROSS ON SHIELDSHINTO SHRINECHURCHCASTLEHISTORIC SITEGEAR WI" +
	"THOUT HUBGEAR WITH HANDLESMAP SYMBOL FOR LIGHTHOUSEMOUNTAINUMBRELLA ON G" +
	"ROUNDFOUNTAINFLAG IN HOLEFERRYSAILBOATSQUARE FOUR CORNERSSKIERICE SKATEP" +
	"ERSON WITH BALLTENTJAPANESE BANK SYMBOLHEADSTONE GRAVEYARD SYMBOLFUEL PU" +
	"MPCUP ON BLACK SQUAREWHITE FLAG WITH HORIZONTAL MIDDLE BLACK STRIPEBLACK" +
	" SAFETY SCISSORSUPPER BLADE SCISSORSBLACK SCISSORSLOWER BLADE SCISSORSWH" +
	"ITE SCISSORSWHITE HEAVY CHECK MARKTELEPHONE LOCATION SIGNTAPE DRIVEAIRPL" +
	"ANEENVELOPERAISED FISTRAISED HANDVICTORY HANDWRITING HANDLOWER RIGHT PEN" +
	"CILPENCILUPPER RIGHT PENCILWHITE NIBBLACK NIBCHECK MARKHEAVY CHECK MARKM" +
	"ULTIPLICATION XHEAVY MULTIPLICATION XBALLOT XHEAVY BALLOT XOUTLINED GREE" +
	"K CROSSHEAVY GREEK CROSSOPEN CENTRE CROSSHEAVY OPEN CENTRE CROSSLATIN CR" +
	"OSSSHADOWED WHITE LATIN CROSSOUTLINED LATIN CROSSMALTESE CROSSSTAR OF DA" +
	"VIDFOUR TEARDROP-SPOKED ASTERISKFOUR BALLOON-SPOKED ASTERISKHEAVY FOUR B" +
	"ALLOON-SPOKED ASTERISKFOUR CLUB-SPOKED ASTERISKBLACK FOUR POINTED STARWH" +
	"ITE FOUR POINTED STARSPARKLESSTRESS OUTLINED WHITE STARCIRCLED WHITE STA" +
	"ROPEN CENTRE BLACK STARBLACK CENTRE WHITE STAROUTLINED BLACK STARHEAVY O" +
	"UTLINED BLACK STARPINWHEEL STARSHADOWED WHITE STARHEAVY ASTERISKOPEN CEN" +
	"TRE ASTERISKEIGHT SPOKED ASTERISKEIGHT POINTED BLACK STAREIGHT POINTED P" +
	"INWHEEL STARSIX POINTED BLACK STAREIGHT POINTED RECTILINEAR BLACK STARHE" +
	"AVY EIGHT POINTED RECTILINEAR BLACK STARTWELVE POINTED BLACK STARSIXTEEN" +
	" POINTED ASTERISKTEARDROP-SPOKED ASTERISKOPEN CENTRE TEARDROP-SPOKED AST" +
	"ERISKHEAVY TEARDROP-SPOKED ASTERISKSIX PETALLED BLACK AND WHITE FLORETTE" +
	"BLACK FLORETTEWHITE FLORETTEEIGHT PETALLED OUTLINED BLACK FLORETTECIRCLE") + ("" +
	"D OPEN CENTRE EIGHT POINTED STARHEAVY TEARDROP-SPOKED PINWHEEL ASTERISKS" +
	"NOWFLAKETIGHT TRIFOLIATE SNOWFLAKEHEAVY CHEVRON SNOWFLAKESPARKLEHEAVY SP" +
	"ARKLEBALLOON-SPOKED ASTERISKEIGHT TEARDROP-SPOKED PROPELLER ASTERISKHEAV" +
	"Y EIGHT TEARDROP-SPOKED PROPELLER ASTERISKCROSS MARKSHADOWED WHITE CIRCL" +
	"ENEGATIVE SQUARED CROSS MARKLOWER RIGHT DROP-SHADOWED WHITE SQUAREUPPER " +
	"RIGHT DROP-SHADOWED WHITE SQUARELOWER RIGHT SHADOWED WHITE SQUAREUPPER R" +
	"IGHT SHADOWED WHITE SQUAREBLACK QUESTION MARK ORNAMENTWHITE QUESTION MAR" +
	"K ORNAMENTWHITE EXCLAMATION MARK ORNAMENTBLACK DIAMOND MINUS WHITE XHEAV" +
	"Y EXCLAMATION MARK SYMBOLLIGHT VERTICAL BARMEDIUM VERTICAL BARHEAVY VERT" +
	"ICAL BARHEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENTHEAVY SINGLE CO" +
	"MMA QUOTATION MARK ORNAMENTHEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNA" +
	"MENTHEAVY DOUBLE COMMA QUOTATION MARK ORNAMENTHEAVY LOW SINGLE COMMA QUO" +
	"TATION MARK ORNAMENTHEAVY LOW DOUBLE COMMA QUOTATION MARK ORNAMENTCURVED" +
	" STEM PARAGRAPH SIGN ORNAMENTHEAVY EXCLAMATION MARK ORNAMENTHEAVY HEART " +
	"EXCLAMATION MARK ORNAMENTHEAVY BLACK HEARTROTATED HEAVY BLACK HEART BULL" +
	"ETFLORAL HEARTROTATED FLORAL HEART BULLETMEDIUM LEFT PARENTHESIS ORNAMEN" +
	"TMEDIUM RIGHT PARENTHESIS ORNAMENTMEDIUM FLATTENED LEFT PARENTHESIS ORNA" +
	"MENTMEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENTMEDIUM LEFT-POINTING ANGL" +
	"E BRACKET ORNAMENTMEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENTHEAVY LEFT" +
	"-POINTING ANGLE QUOTATION MARK ORNAMENTHEAVY RIGHT-POINTING ANGLE QUOTAT" +
	"ION MARK ORNAMENTHEAVY LEFT-POINTING ANGLE BRACKET ORNAMENTHEAVY RIGHT-P" +
	"OINTING ANGLE BRACKET ORNAMENTLIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT" +
	"LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENTMEDIUM LEFT CURLY BRACKET ORN" +
	"AMENTMEDIUM RIGHT CURLY BRACKET ORNAMENTDINGBAT NEGATIVE CIRCLED DIGIT O" +
	"NEDINGBAT NEGATIVE CIRCLED DIGIT TWODINGBAT NEGATIVE CIRCLED DIGIT THREE" +
	"DINGBAT NEGATIVE CIRCLED DIGIT FOURDINGBAT NEGATIVE CIRCLED DIGIT FIVEDI" +
	"NGBAT NEGATIVE CIRCLED DIGIT SIXDINGBAT NEGATIVE CIRCLED DIGIT SEVENDING" +
	"BAT NEGATIVE CIRCLED DIGIT EIGHTDINGBAT NEGATIVE CIRCLED DIGIT NINEDINGB" +
	"AT NEGATIVE CIRCLED NUMBER TENDINGBAT CIRCLED SANS-SERIF DIGIT ONEDINGBA" +
	"T CIRCLED SANS-SERIF DIGIT TWODINGBAT CIRCLED SANS-SERIF DIGIT THREEDING" +
	"BAT CIRCLED SANS-SERIF DIGIT FOURDINGBAT CIRCLED SANS-SERIF DIGIT FIVEDI" +
	"NGBAT CIRCLED SANS-SERIF DIGIT SIXDINGBAT CIRCLED SANS-SERIF DIGIT SEVEN" +
	"DINGBAT CIRCLED SANS-SERIF DIGIT EIGHTDINGBAT CIRCLED SANS-SERIF DIGIT N" +
	"INEDINGBAT CIRCLED SANS-SERIF NUMBER TENDINGBAT NEGATIVE CIRCLED SANS-SE" +
	"RIF DIGIT ONEDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT TWODINGBAT NEGATI" +
	"VE CIRCLED SANS-SERIF DIGIT THREEDINGBAT NEGATIVE CIRCLED SANS-SERIF DIG" +
	"IT FOURDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FIVEDINGBAT NEGATIVE CI" +
	"RCLED SANS-SERIF DIGIT SIXDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVE" +
	"NDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHTDINGBAT NEGATIVE CIRCLED" +
	" SANS-SERIF DIGIT NINEDINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TENHEAV" +
	"Y WIDE-HEADED RIGHTWARDS ARROWHEAVY PLUS SIGNHEAVY MINUS SIGNHEAVY DIVIS" +
	"ION SIGNHEAVY SOUTH EAST ARROWHEAVY RIGHTWARDS ARROWHEAVY NORTH EAST ARR" +
	"OWDRAFTING POINT RIGHTWARDS ARROWHEAVY ROUND-TIPPED RIGHTWARDS ARROWTRIA" +
	"NGLE-HEADED RIGHTWARDS ARROWHEAVY TRIANGLE-HEADED RIGHTWARDS ARROWDASHED" +
	" TRIANGLE-HEADED RIGHTWARDS ARROWHEAVY DASHED TRIANGLE-HEADED RIGHTWARDS" +
	" ARROWBLACK RIGHTWARDS ARROWTHREE-D TOP-LIGHTED RIGHTWARDS ARROWHEADTHRE" +
	"E-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEADBLACK RIGHTWARDS ARROWHEADHEAVY B" +
	"LACK CURVED DOWNWARDS AND RIGHTWARDS ARROWHEAVY BLACK CURVED UPWARDS AND" +
	" RIGHTWARDS ARROWSQUAT BLACK RIGHTWARDS ARROWHEAVY CONCAVE-POINTED BLACK" +
	" RIGHTWARDS ARROWRIGHT-SHADED WHITE RIGHTWARDS ARROWLEFT-SHADED WHITE RI" +
	"GHTWARDS ARROWBACK-TILTED SHADOWED WHITE RIGHTWARDS ARROWFRONT-TILTED SH" +
	"ADOWED WHITE RIGHTWARDS ARROWHEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS" +
	" ARROWHEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROWNOTCHED LOWER RIG" +
	"HT-SHADOWED WHITE RIGHTWARDS ARROWCURLY LOOPNOTCHED UPPER RIGHT-SHADOWED" +
	" WHITE RIGHTWARDS ARROWCIRCLED HEAVY WHITE RIGHTWARDS ARROWWHITE-FEATHER" +
	"ED RIGHTWARDS ARROWBLACK-FEATHERED SOUTH EAST ARROWBLACK-FEATHERED RIGHT" +
	"WARDS ARROWBLACK-FEATHERED NORTH EAST ARROWHEAVY BLACK-FEATHERED SOUTH E" +
	"AST ARROWHEAVY BLACK-FEATHERED RIGHTWARDS ARROWHEAVY BLACK-FEATHERED NOR" +
	"TH EAST ARROWTEARDROP-BARBED RIGHTWARDS ARROWHEAVY TEARDROP-SHANKED RIGH" +
	"TWARDS ARROWWEDGE-TAILED RIGHTWARDS ARROWHEAVY WEDGE-TAILED RIGHTWARDS A" +
	"RROWOPEN-OUTLINED RIGHTWARDS ARROWDOUBLE CURLY LOOPTHREE DIMENSIONAL ANG" +
	"LEWHITE TRIANGLE CONTAINING SMALL WHITE TRIANGLEPERPENDICULAROPEN SUBSET" +
	"OPEN SUPERSETLEFT S-SHAPED BAG DELIMITERRIGHT S-SHAPED BAG DELIMITEROR W" +
	"ITH DOT INSIDEREVERSE SOLIDUS PRECEDING SUBSETSUPERSET PRECEDING SOLIDUS") + ("" +
	"VERTICAL BAR WITH HORIZONTAL STROKEMATHEMATICAL RISING DIAGONALLONG DIVI" +
	"SIONMATHEMATICAL FALLING DIAGONALSQUARED LOGICAL ANDSQUARED LOGICAL ORWH" +
	"ITE DIAMOND WITH CENTRED DOTAND WITH DOTELEMENT OF OPENING UPWARDSLOWER " +
	"RIGHT CORNER WITH DOTUPPER LEFT CORNER WITH DOTLEFT OUTER JOINRIGHT OUTE" +
	"R JOINFULL OUTER JOINLARGE UP TACKLARGE DOWN TACKLEFT AND RIGHT DOUBLE T" +
	"URNSTILELEFT AND RIGHT TACKLEFT MULTIMAPLONG RIGHT TACKLONG LEFT TACKUP " +
	"TACK WITH CIRCLE ABOVELOZENGE DIVIDED BY HORIZONTAL RULEWHITE CONCAVE-SI" +
	"DED DIAMONDWHITE CONCAVE-SIDED DIAMOND WITH LEFTWARDS TICKWHITE CONCAVE-" +
	"SIDED DIAMOND WITH RIGHTWARDS TICKWHITE SQUARE WITH LEFTWARDS TICKWHITE " +
	"SQUARE WITH RIGHTWARDS TICKMATHEMATICAL LEFT WHITE SQUARE BRACKETMATHEMA" +
	"TICAL RIGHT WHITE SQUARE BRACKETMATHEMATICAL LEFT ANGLE BRACKETMATHEMATI" +
	"CAL RIGHT ANGLE BRACKETMATHEMATICAL LEFT DOUBLE ANGLE BRACKETMATHEMATICA" +
	"L RIGHT DOUBLE ANGLE BRACKETMATHEMATICAL LEFT WHITE TORTOISE SHELL BRACK" +
	"ETMATHEMATICAL RIGHT WHITE TORTOISE SHELL BRACKETMATHEMATICAL LEFT FLATT" +
	"ENED PARENTHESISMATHEMATICAL RIGHT FLATTENED PARENTHESISUPWARDS QUADRUPL" +
	"E ARROWDOWNWARDS QUADRUPLE ARROWANTICLOCKWISE GAPPED CIRCLE ARROWCLOCKWI" +
	"SE GAPPED CIRCLE ARROWRIGHT ARROW WITH CIRCLED PLUSLONG LEFTWARDS ARROWL" +
	"ONG RIGHTWARDS ARROWLONG LEFT RIGHT ARROWLONG LEFTWARDS DOUBLE ARROWLONG" +
	" RIGHTWARDS DOUBLE ARROWLONG LEFT RIGHT DOUBLE ARROWLONG LEFTWARDS ARROW" +
	" FROM BARLONG RIGHTWARDS ARROW FROM BARLONG LEFTWARDS DOUBLE ARROW FROM " +
	"BARLONG RIGHTWARDS DOUBLE ARROW FROM BARLONG RIGHTWARDS SQUIGGLE ARROWBR" +
	"AILLE PATTERN BLANKBRAILLE PATTERN DOTS-1BRAILLE PATTERN DOTS-2BRAILLE P" +
	"ATTERN DOTS-12BRAILLE PATTERN DOTS-3BRAILLE PATTERN DOTS-13BRAILLE PATTE" +
	"RN DOTS-23BRAILLE PATTERN DOTS-123BRAILLE PATTERN DOTS-4BRAILLE PATTERN " +
	"DOTS-14BRAILLE PATTERN DOTS-24BRAILLE PATTERN DOTS-124BRAILLE PATTERN DO" +
	"TS-34BRAILLE PATTERN DOTS-134BRAILLE PATTERN DOTS-234BRAILLE PATTERN DOT" +
	"S-1234BRAILLE PATTERN DOTS-5BRAILLE PATTERN DOTS-15BRAILLE PATTERN DOTS-" +
	"25BRAILLE PATTERN DOTS-125BRAILLE PATTERN DOTS-35BRAILLE PATTERN DOTS-13" +
	"5BRAILLE PATTERN DOTS-235BRAILLE PATTERN DOTS-1235BRAILLE PATTERN DOTS-4" +
	"5BRAILLE PATTERN DOTS-145BRAILLE PATTERN DOTS-245BRAILLE PATTERN DOTS-12" +
	"45BRAILLE PATTERN DOTS-345BRAILLE PATTERN DOTS-1345BRAILLE PATTERN DOTS-" +
	"2345BRAILLE PATTERN DOTS-12345BRAILLE PATTERN DOTS-6BRAILLE PATTERN DOTS" +
	"-16BRAILLE PATTERN DOTS-26BRAILLE PATTERN DOTS-126BRAILLE PATTERN DOTS-3" +
	"6BRAILLE PATTERN DOTS-136BRAILLE PATTERN DOTS-236BRAILLE PATTERN DOTS-12" +
	"36BRAILLE PATTERN DOTS-46BRAILLE PATTERN DOTS-146BRAILLE PATTERN DOTS-24" +
	"6BRAILLE PATTERN DOTS-1246BRAILLE PATTERN DOTS-346BRAILLE PATTERN DOTS-1" +
	"346BRAILLE PATTERN DOTS-2346BRAILLE PATTERN DOTS-12346BRAILLE PATTERN DO" +
	"TS-56BRAILLE PATTERN DOTS-156BRAILLE PATTERN DOTS-256BRAILLE PATTERN DOT" +
	"S-1256BRAILLE PATTERN DOTS-356BRAILLE PATTERN DOTS-1356BRAILLE PATTERN D" +
	"OTS-2356BRAILLE PATTERN DOTS-12356BRAILLE PATTERN DOTS-456BRAILLE PATTER" +
	"N DOTS-1456BRAILLE PATTERN DOTS-2456BRAILLE PATTERN DOTS-12456BRAILLE PA" +
	"TTERN DOTS-3456BRAILLE PATTERN DOTS-13456BRAILLE PATTERN DOTS-23456BRAIL" +
	"LE PATTERN DOTS-123456BRAILLE PATTERN DOTS-7BRAILLE PATTERN DOTS-17BRAIL" +
	"LE PATTERN DOTS-27BRAILLE PATTERN DOTS-127BRAILLE PATTERN DOTS-37BRAILLE" +
	" PATTERN DOTS-137BRAILLE PATTERN DOTS-237BRAILLE PATTERN DOTS-1237BRAILL" +
	"E PATTERN DOTS-47BRAILLE PATTERN DOTS-147BRAILLE PATTERN DOTS-247BRAILLE" +
	" PATTERN DOTS-1247BRAILLE PATTERN DOTS-347BRAILLE PATTERN DOTS-1347BRAIL" +
	"LE PATTERN DOTS-2347BRAILLE PATTERN DOTS-12347BRAILLE PATTERN DOTS-57BRA" +
	"ILLE PATTERN DOTS-157BRAILLE PATTERN DOTS-257BRAILLE PATTERN DOTS-1257BR" +
	"AILLE PATTERN DOTS-357BRAILLE PATTERN DOTS-1357BRAILLE PATTERN DOTS-2357" +
	"BRAILLE PATTERN DOTS-12357BRAILLE PATTERN DOTS-457BRAILLE PATTERN DOTS-1" +
	"457BRAILLE PATTERN DOTS-2457BRAILLE PATTERN DOTS-12457BRAILLE PATTERN DO" +
	"TS-3457BRAILLE PATTERN DOTS-13457BRAILLE PATTERN DOTS-23457BRAILLE PATTE" +
	"RN DOTS-123457BRAILLE PATTERN DOTS-67BRAILLE PATTERN DOTS-167BRAILLE PAT" +
	"TERN DOTS-267BRAILLE PATTERN DOTS-1267BRAILLE PATTERN DOTS-367BRAILLE PA" +
	"TTERN DOTS-1367BRAILLE PATTERN DOTS-2367BRAILLE PATTERN DOTS-12367BRAILL" +
	"E PATTERN DOTS-467BRAILLE PATTERN DOTS-1467BRAILLE PATTERN DOTS-2467BRAI" +
	"LLE PATTERN DOTS-12467BRAILLE PATTERN DOTS-3467BRAILLE PATTERN DOTS-1346" +
	"7BRAILLE PATTERN DOTS-23467BRAILLE PATTERN DOTS-123467BRAILLE PATTERN DO" +
	"TS-567BRAILLE PATTERN DOTS-1567BRAILLE PATTERN DOTS-2567BRAILLE PATTERN " +
	"DOTS-12567BRAILLE PATTERN DOTS-3567BRAILLE PATTERN DOTS-13567BRAILLE PAT" +
	"TERN DOTS-23567BRAILLE PATTERN DOTS-123567BRAILLE PATTERN DOTS-4567BRAIL" +
	"LE PATTERN DOTS-14567BRAILLE PATTERN DOTS-24567BRAILLE PATTERN DOTS-1245" +
	"67BRAILLE PATTERN DOTS-34567BRAILLE PATTERN DOTS-134567BRAILLE PATTERN D") + ("" +
	"OTS-234567BRAILLE PATTERN DOTS-1234567BRAILLE PATTERN DOTS-8BRAILLE PATT" +
	"ERN DOTS-18BRAILLE PATTERN DOTS-28BRAILLE PATTERN DOTS-128BRAILLE PATTER" +
	"N DOTS-38BRAILLE PATTERN DOTS-138BRAILLE PATTERN DOTS-238BRAILLE PATTERN" +
	" DOTS-1238BRAILLE PATTERN DOTS-48BRAILLE PATTERN DOTS-148BRAILLE PATTERN" +
	" DOTS-248BRAILLE PATTERN DOTS-1248BRAILLE PATTERN DOTS-348BRAILLE PATTER" +
	"N DOTS-1348BRAILLE PATTERN DOTS-2348BRAILLE PATTERN DOTS-12348BRAILLE PA" +
	"TTERN DOTS-58BRAILLE PATTERN DOTS-158BRAILLE PATTERN DOTS-258BRAILLE PAT" +
	"TERN DOTS-1258BRAILLE PATTERN DOTS-358BRAILLE PATTERN DOTS-1358BRAILLE P" +
	"ATTERN DOTS-2358BRAILLE PATTERN DOTS-12358BRAILLE PATTERN DOTS-458BRAILL" +
	"E PATTERN DOTS-1458BRAILLE PATTERN DOTS-2458BRAILLE PATTERN DOTS-12458BR" +
	"AILLE PATTERN DOTS-3458BRAILLE PATTERN DOTS-13458BRAILLE PATTERN DOTS-23" +
	"458BRAILLE PATTERN DOTS-123458BRAILLE PATTERN DOTS-68BRAILLE PATTERN DOT" +
	"S-168BRAILLE PATTERN DOTS-268BRAILLE PATTERN DOTS-1268BRAILLE PATTERN DO" +
	"TS-368BRAILLE PATTERN DOTS-1368BRAILLE PATTERN DOTS-2368BRAILLE PATTERN " +
	"DOTS-12368BRAILLE PATTERN DOTS-468BRAILLE PATTERN DOTS-1468BRAILLE PATTE" +
	"RN DOTS-2468BRAILLE PATTERN DOTS-12468BRAILLE PATTERN DOTS-3468BRAILLE P" +
	"ATTERN DOTS-13468BRAILLE PATTERN DOTS-23468BRAILLE PATTERN DOTS-123468BR" +
	"AILLE PATTERN DOTS-568BRAILLE PATTERN DOTS-1568BRAILLE PATTERN DOTS-2568" +
	"BRAILLE PATTERN DOTS-12568BRAILLE PATTERN DOTS-3568BRAILLE PATTERN DOTS-" +
	"13568BRAILLE PATTERN DOTS-23568BRAILLE PATTERN DOTS-123568BRAILLE PATTER" +
	"N DOTS-4568BRAILLE PATTERN DOTS-14568BRAILLE PATTERN DOTS-24568BRAILLE P" +
	"ATTERN DOTS-124568BRAILLE PATTERN DOTS-34568BRAILLE PATTERN DOTS-134568B" +
	"RAILLE PATTERN DOTS-234568BRAILLE PATTERN DOTS-1234568BRAILLE PATTERN DO" +
	"TS-78BRAILLE PATTERN DOTS-178BRAILLE PATTERN DOTS-278BRAILLE PATTERN DOT" +
	"S-1278BRAILLE PATTERN DOTS-378BRAILLE PATTERN DOTS-1378BRAILLE PATTERN D" +
	"OTS-2378BRAILLE PATTERN DOTS-12378BRAILLE PATTERN DOTS-478BRAILLE PATTER" +
	"N DOTS-1478BRAILLE PATTERN DOTS-2478BRAILLE PATTERN DOTS-12478BRAILLE PA" +
	"TTERN DOTS-3478BRAILLE PATTERN DOTS-13478BRAILLE PATTERN DOTS-23478BRAIL" +
	"LE PATTERN DOTS-123478BRAILLE PATTERN DOTS-578BRAILLE PATTERN DOTS-1578B" +
	"RAILLE PATTERN DOTS-2578BRAILLE PATTERN DOTS-12578BRAILLE PATTERN DOTS-3" +
	"578BRAILLE PATTERN DOTS-13578BRAILLE PATTERN DOTS-23578BRAILLE PATTERN D" +
	"OTS-123578BRAILLE PATTERN DOTS-4578BRAILLE PATTERN DOTS-14578BRAILLE PAT" +
	"TERN DOTS-24578BRAILLE PATTERN DOTS-124578BRAILLE PATTERN DOTS-34578BRAI" +
	"LLE PATTERN DOTS-134578BRAILLE PATTERN DOTS-234578BRAILLE PATTERN DOTS-1" +
	"234578BRAILLE PATTERN DOTS-678BRAILLE PATTERN DOTS-1678BRAILLE PATTERN D" +
	"OTS-2678BRAILLE PATTERN DOTS-12678BRAILLE PATTERN DOTS-3678BRAILLE PATTE" +
	"RN DOTS-13678BRAILLE PATTERN DOTS-23678BRAILLE PATTERN DOTS-123678BRAILL" +
	"E PATTERN DOTS-4678BRAILLE PATTERN DOTS-14678BRAILLE PATTERN DOTS-24678B" +
	"RAILLE PATTERN DOTS-124678BRAILLE PATTERN DOTS-34678BRAILLE PATTERN DOTS" +
	"-134678BRAILLE PATTERN DOTS-234678BRAILLE PATTERN DOTS-1234678BRAILLE PA" +
	"TTERN DOTS-5678BRAILLE PATTERN DOTS-15678BRAILLE PATTERN DOTS-25678BRAIL" +
	"LE PATTERN DOTS-125678BRAILLE PATTERN DOTS-35678BRAILLE PATTERN DOTS-135" +
	"678BRAILLE PATTERN DOTS-235678BRAILLE PATTERN DOTS-1235678BRAILLE PATTER" +
	"N DOTS-45678BRAILLE PATTERN DOTS-145678BRAILLE PATTERN DOTS-245678BRAILL" +
	"E PATTERN DOTS-1245678BRAILLE PATTERN DOTS-345678BRAILLE PATTERN DOTS-13" +
	"45678BRAILLE PATTERN DOTS-2345678BRAILLE PATTERN DOTS-12345678RIGHTWARDS" +
	" TWO-HEADED ARROW WITH VERTICAL STROKERIGHTWARDS TWO-HEADED ARROW WITH D" +
	"OUBLE VERTICAL STROKELEFTWARDS DOUBLE ARROW WITH VERTICAL STROKERIGHTWAR" +
	"DS DOUBLE ARROW WITH VERTICAL STROKELEFT RIGHT DOUBLE ARROW WITH VERTICA" +
	"L STROKERIGHTWARDS TWO-HEADED ARROW FROM BARLEFTWARDS DOUBLE ARROW FROM " +
	"BARRIGHTWARDS DOUBLE ARROW FROM BARDOWNWARDS ARROW WITH HORIZONTAL STROK" +
	"EUPWARDS ARROW WITH HORIZONTAL STROKEUPWARDS TRIPLE ARROWDOWNWARDS TRIPL" +
	"E ARROWLEFTWARDS DOUBLE DASH ARROWRIGHTWARDS DOUBLE DASH ARROWLEFTWARDS " +
	"TRIPLE DASH ARROWRIGHTWARDS TRIPLE DASH ARROWRIGHTWARDS TWO-HEADED TRIPL" +
	"E DASH ARROWRIGHTWARDS ARROW WITH DOTTED STEMUPWARDS ARROW TO BARDOWNWAR" +
	"DS ARROW TO BARRIGHTWARDS ARROW WITH TAIL WITH VERTICAL STROKERIGHTWARDS" +
	" ARROW WITH TAIL WITH DOUBLE VERTICAL STROKERIGHTWARDS TWO-HEADED ARROW " +
	"WITH TAILRIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKERIGHT" +
	"WARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKELEFTWARDS AR" +
	"ROW-TAILRIGHTWARDS ARROW-TAILLEFTWARDS DOUBLE ARROW-TAILRIGHTWARDS DOUBL" +
	"E ARROW-TAILLEFTWARDS ARROW TO BLACK DIAMONDRIGHTWARDS ARROW TO BLACK DI" +
	"AMONDLEFTWARDS ARROW FROM BAR TO BLACK DIAMONDRIGHTWARDS ARROW FROM BAR " +
	"TO BLACK DIAMONDNORTH WEST AND SOUTH EAST ARROWNORTH EAST AND SOUTH WEST" +
	" ARROWNORTH WEST ARROW WITH HOOKNORTH EAST ARROW WITH HOOKSOUTH EAST ARR") + ("" +
	"OW WITH HOOKSOUTH WEST ARROW WITH HOOKNORTH WEST ARROW AND NORTH EAST AR" +
	"ROWNORTH EAST ARROW AND SOUTH EAST ARROWSOUTH EAST ARROW AND SOUTH WEST " +
	"ARROWSOUTH WEST ARROW AND NORTH WEST ARROWRISING DIAGONAL CROSSING FALLI" +
	"NG DIAGONALFALLING DIAGONAL CROSSING RISING DIAGONALSOUTH EAST ARROW CRO" +
	"SSING NORTH EAST ARROWNORTH EAST ARROW CROSSING SOUTH EAST ARROWFALLING " +
	"DIAGONAL CROSSING NORTH EAST ARROWRISING DIAGONAL CROSSING SOUTH EAST AR" +
	"ROWNORTH EAST ARROW CROSSING NORTH WEST ARROWNORTH WEST ARROW CROSSING N" +
	"ORTH EAST ARROWWAVE ARROW POINTING DIRECTLY RIGHTARROW POINTING RIGHTWAR" +
	"DS THEN CURVING UPWARDSARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDSA" +
	"RROW POINTING DOWNWARDS THEN CURVING LEFTWARDSARROW POINTING DOWNWARDS T" +
	"HEN CURVING RIGHTWARDSRIGHT-SIDE ARC CLOCKWISE ARROWLEFT-SIDE ARC ANTICL" +
	"OCKWISE ARROWTOP ARC ANTICLOCKWISE ARROWBOTTOM ARC ANTICLOCKWISE ARROWTO" +
	"P ARC CLOCKWISE ARROW WITH MINUSTOP ARC ANTICLOCKWISE ARROW WITH PLUSLOW" +
	"ER RIGHT SEMICIRCULAR CLOCKWISE ARROWLOWER LEFT SEMICIRCULAR ANTICLOCKWI" +
	"SE ARROWANTICLOCKWISE CLOSED CIRCLE ARROWCLOCKWISE CLOSED CIRCLE ARROWRI" +
	"GHTWARDS ARROW ABOVE SHORT LEFTWARDS ARROWLEFTWARDS ARROW ABOVE SHORT RI" +
	"GHTWARDS ARROWSHORT RIGHTWARDS ARROW ABOVE LEFTWARDS ARROWRIGHTWARDS ARR" +
	"OW WITH PLUS BELOWLEFTWARDS ARROW WITH PLUS BELOWRIGHTWARDS ARROW THROUG" +
	"H XLEFT RIGHT ARROW THROUGH SMALL CIRCLEUPWARDS TWO-HEADED ARROW FROM SM" +
	"ALL CIRCLELEFT BARB UP RIGHT BARB DOWN HARPOONLEFT BARB DOWN RIGHT BARB " +
	"UP HARPOONUP BARB RIGHT DOWN BARB LEFT HARPOONUP BARB LEFT DOWN BARB RIG" +
	"HT HARPOONLEFT BARB UP RIGHT BARB UP HARPOONUP BARB RIGHT DOWN BARB RIGH" +
	"T HARPOONLEFT BARB DOWN RIGHT BARB DOWN HARPOONUP BARB LEFT DOWN BARB LE" +
	"FT HARPOONLEFTWARDS HARPOON WITH BARB UP TO BARRIGHTWARDS HARPOON WITH B" +
	"ARB UP TO BARUPWARDS HARPOON WITH BARB RIGHT TO BARDOWNWARDS HARPOON WIT" +
	"H BARB RIGHT TO BARLEFTWARDS HARPOON WITH BARB DOWN TO BARRIGHTWARDS HAR" +
	"POON WITH BARB DOWN TO BARUPWARDS HARPOON WITH BARB LEFT TO BARDOWNWARDS" +
	" HARPOON WITH BARB LEFT TO BARLEFTWARDS HARPOON WITH BARB UP FROM BARRIG" +
	"HTWARDS HARPOON WITH BARB UP FROM BARUPWARDS HARPOON WITH BARB RIGHT FRO" +
	"M BARDOWNWARDS HARPOON WITH BARB RIGHT FROM BARLEFTWARDS HARPOON WITH BA" +
	"RB DOWN FROM BARRIGHTWARDS HARPOON WITH BARB DOWN FROM BARUPWARDS HARPOO" +
	"N WITH BARB LEFT FROM BARDOWNWARDS HARPOON WITH BARB LEFT FROM BARLEFTWA" +
	"RDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWNUPWARDS H" +
	"ARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHTRIGHTWARDS H" +
	"ARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWNDOWNWARDS HAR" +
	"POON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHTLEFTWARDS HA" +
	"RPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UPLEFTWARDS HARPOO" +
	"N WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWNRIGHTWARDS HARPO" +
	"ON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UPRIGHTWARDS HARPOON W" +
	"ITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWNLEFTWARDS HARPOON WI" +
	"TH BARB UP ABOVE LONG DASHLEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DA" +
	"SHRIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASHRIGHTWARDS HARPOON WITH" +
	" BARB DOWN BELOW LONG DASHUPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARD" +
	"S HARPOON WITH BARB RIGHTDOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS" +
	" HARPOON WITH BARB RIGHTRIGHT DOUBLE ARROW WITH ROUNDED HEADEQUALS SIGN " +
	"ABOVE RIGHTWARDS ARROWTILDE OPERATOR ABOVE RIGHTWARDS ARROWLEFTWARDS ARR" +
	"OW ABOVE TILDE OPERATORRIGHTWARDS ARROW ABOVE TILDE OPERATORRIGHTWARDS A" +
	"RROW ABOVE ALMOST EQUAL TOLESS-THAN ABOVE LEFTWARDS ARROWLEFTWARDS ARROW" +
	" THROUGH LESS-THANGREATER-THAN ABOVE RIGHTWARDS ARROWSUBSET ABOVE RIGHTW" +
	"ARDS ARROWLEFTWARDS ARROW THROUGH SUBSETSUPERSET ABOVE LEFTWARDS ARROWLE" +
	"FT FISH TAILRIGHT FISH TAILUP FISH TAILDOWN FISH TAILTRIPLE VERTICAL BAR" +
	" DELIMITERZ NOTATION SPOTZ NOTATION TYPE COLONLEFT WHITE CURLY BRACKETRI" +
	"GHT WHITE CURLY BRACKETLEFT WHITE PARENTHESISRIGHT WHITE PARENTHESISZ NO" +
	"TATION LEFT IMAGE BRACKETZ NOTATION RIGHT IMAGE BRACKETZ NOTATION LEFT B" +
	"INDING BRACKETZ NOTATION RIGHT BINDING BRACKETLEFT SQUARE BRACKET WITH U" +
	"NDERBARRIGHT SQUARE BRACKET WITH UNDERBARLEFT SQUARE BRACKET WITH TICK I" +
	"N TOP CORNERRIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNERLEFT SQUARE B" +
	"RACKET WITH TICK IN BOTTOM CORNERRIGHT SQUARE BRACKET WITH TICK IN TOP C" +
	"ORNERLEFT ANGLE BRACKET WITH DOTRIGHT ANGLE BRACKET WITH DOTLEFT ARC LES" +
	"S-THAN BRACKETRIGHT ARC GREATER-THAN BRACKETDOUBLE LEFT ARC GREATER-THAN" +
	" BRACKETDOUBLE RIGHT ARC LESS-THAN BRACKETLEFT BLACK TORTOISE SHELL BRAC" +
	"KETRIGHT BLACK TORTOISE SHELL BRACKETDOTTED FENCEVERTICAL ZIGZAG LINEMEA" +
	"SURED ANGLE OPENING LEFTRIGHT ANGLE VARIANT WITH SQUAREMEASURED RIGHT AN" +
	"GLE WITH DOTANGLE WITH S INSIDEACUTE ANGLESPHERICAL ANGLE OPENING LEFTSP") + ("" +
	"HERICAL ANGLE OPENING UPTURNED ANGLEREVERSED ANGLEANGLE WITH UNDERBARREV" +
	"ERSED ANGLE WITH UNDERBAROBLIQUE ANGLE OPENING UPOBLIQUE ANGLE OPENING D" +
	"OWNMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHTMEA" +
	"SURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND LEFTMEASURED A" +
	"NGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND RIGHTMEASURED ANGLE" +
	" WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND LEFTMEASURED ANGLE WITH" +
	" OPEN ARM ENDING IN ARROW POINTING RIGHT AND UPMEASURED ANGLE WITH OPEN " +
	"ARM ENDING IN ARROW POINTING LEFT AND UPMEASURED ANGLE WITH OPEN ARM END" +
	"ING IN ARROW POINTING RIGHT AND DOWNMEASURED ANGLE WITH OPEN ARM ENDING " +
	"IN ARROW POINTING LEFT AND DOWNREVERSED EMPTY SETEMPTY SET WITH OVERBARE" +
	"MPTY SET WITH SMALL CIRCLE ABOVEEMPTY SET WITH RIGHT ARROW ABOVEEMPTY SE" +
	"T WITH LEFT ARROW ABOVECIRCLE WITH HORIZONTAL BARCIRCLED VERTICAL BARCIR" +
	"CLED PARALLELCIRCLED REVERSE SOLIDUSCIRCLED PERPENDICULARCIRCLE DIVIDED " +
	"BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BARCIRCLE WITH SUPERI" +
	"MPOSED XCIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGNUP ARROW THROUGH CIRC" +
	"LECIRCLED WHITE BULLETCIRCLED BULLETCIRCLED LESS-THANCIRCLED GREATER-THA" +
	"NCIRCLE WITH SMALL CIRCLE TO THE RIGHTCIRCLE WITH TWO HORIZONTAL STROKES" +
	" TO THE RIGHTSQUARED RISING DIAGONAL SLASHSQUARED FALLING DIAGONAL SLASH" +
	"SQUARED ASTERISKSQUARED SMALL CIRCLESQUARED SQUARETWO JOINED SQUARESTRIA" +
	"NGLE WITH DOT ABOVETRIANGLE WITH UNDERBARS IN TRIANGLETRIANGLE WITH SERI" +
	"FS AT BOTTOMRIGHT TRIANGLE ABOVE LEFT TRIANGLELEFT TRIANGLE BESIDE VERTI" +
	"CAL BARVERTICAL BAR BESIDE RIGHT TRIANGLEBOWTIE WITH LEFT HALF BLACKBOWT" +
	"IE WITH RIGHT HALF BLACKBLACK BOWTIETIMES WITH LEFT HALF BLACKTIMES WITH" +
	" RIGHT HALF BLACKWHITE HOURGLASSBLACK HOURGLASSLEFT WIGGLY FENCERIGHT WI" +
	"GGLY FENCELEFT DOUBLE WIGGLY FENCERIGHT DOUBLE WIGGLY FENCEINCOMPLETE IN" +
	"FINITYTIE OVER INFINITYINFINITY NEGATED WITH VERTICAL BARDOUBLE-ENDED MU" +
	"LTIMAPSQUARE WITH CONTOURED OUTLINEINCREASES ASSHUFFLE PRODUCTEQUALS SIG" +
	"N AND SLANTED PARALLELEQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVEI" +
	"DENTICAL TO AND SLANTED PARALLELGLEICH STARKTHERMODYNAMICDOWN-POINTING T" +
	"RIANGLE WITH LEFT HALF BLACKDOWN-POINTING TRIANGLE WITH RIGHT HALF BLACK" +
	"BLACK DIAMOND WITH DOWN ARROWBLACK LOZENGEWHITE CIRCLE WITH DOWN ARROWBL" +
	"ACK CIRCLE WITH DOWN ARROWERROR-BARRED WHITE SQUAREERROR-BARRED BLACK SQ" +
	"UAREERROR-BARRED WHITE DIAMONDERROR-BARRED BLACK DIAMONDERROR-BARRED WHI" +
	"TE CIRCLEERROR-BARRED BLACK CIRCLERULE-DELAYEDREVERSE SOLIDUS OPERATORSO" +
	"LIDUS WITH OVERBARREVERSE SOLIDUS WITH HORIZONTAL STROKEBIG SOLIDUSBIG R" +
	"EVERSE SOLIDUSDOUBLE PLUSTRIPLE PLUSLEFT-POINTING CURVED ANGLE BRACKETRI" +
	"GHT-POINTING CURVED ANGLE BRACKETTINYMINYN-ARY CIRCLED DOT OPERATORN-ARY" +
	" CIRCLED PLUS OPERATORN-ARY CIRCLED TIMES OPERATORN-ARY UNION OPERATOR W" +
	"ITH DOTN-ARY UNION OPERATOR WITH PLUSN-ARY SQUARE INTERSECTION OPERATORN" +
	"-ARY SQUARE UNION OPERATORTWO LOGICAL AND OPERATORTWO LOGICAL OR OPERATO" +
	"RN-ARY TIMES OPERATORMODULO TWO SUMSUMMATION WITH INTEGRALQUADRUPLE INTE" +
	"GRAL OPERATORFINITE PART INTEGRALINTEGRAL WITH DOUBLE STROKEINTEGRAL AVE" +
	"RAGE WITH SLASHCIRCULATION FUNCTIONANTICLOCKWISE INTEGRATIONLINE INTEGRA" +
	"TION WITH RECTANGULAR PATH AROUND POLELINE INTEGRATION WITH SEMICIRCULAR" +
	" PATH AROUND POLELINE INTEGRATION NOT INCLUDING THE POLEINTEGRAL AROUND " +
	"A POINT OPERATORQUATERNION INTEGRAL OPERATORINTEGRAL WITH LEFTWARDS ARRO" +
	"W WITH HOOKINTEGRAL WITH TIMES SIGNINTEGRAL WITH INTERSECTIONINTEGRAL WI" +
	"TH UNIONINTEGRAL WITH OVERBARINTEGRAL WITH UNDERBARJOINLARGE LEFT TRIANG" +
	"LE OPERATORZ NOTATION SCHEMA COMPOSITIONZ NOTATION SCHEMA PIPINGZ NOTATI" +
	"ON SCHEMA PROJECTIONPLUS SIGN WITH SMALL CIRCLE ABOVEPLUS SIGN WITH CIRC" +
	"UMFLEX ACCENT ABOVEPLUS SIGN WITH TILDE ABOVEPLUS SIGN WITH DOT BELOWPLU" +
	"S SIGN WITH TILDE BELOWPLUS SIGN WITH SUBSCRIPT TWOPLUS SIGN WITH BLACK " +
	"TRIANGLEMINUS SIGN WITH COMMA ABOVEMINUS SIGN WITH DOT BELOWMINUS SIGN W" +
	"ITH FALLING DOTSMINUS SIGN WITH RISING DOTSPLUS SIGN IN LEFT HALF CIRCLE" +
	"PLUS SIGN IN RIGHT HALF CIRCLEVECTOR OR CROSS PRODUCTMULTIPLICATION SIGN" +
	" WITH DOT ABOVEMULTIPLICATION SIGN WITH UNDERBARSEMIDIRECT PRODUCT WITH " +
	"BOTTOM CLOSEDSMASH PRODUCTMULTIPLICATION SIGN IN LEFT HALF CIRCLEMULTIPL" +
	"ICATION SIGN IN RIGHT HALF CIRCLECIRCLED MULTIPLICATION SIGN WITH CIRCUM" +
	"FLEX ACCENTMULTIPLICATION SIGN IN DOUBLE CIRCLECIRCLED DIVISION SIGNPLUS" +
	" SIGN IN TRIANGLEMINUS SIGN IN TRIANGLEMULTIPLICATION SIGN IN TRIANGLEIN" +
	"TERIOR PRODUCTRIGHTHAND INTERIOR PRODUCTZ NOTATION RELATIONAL COMPOSITIO" +
	"NAMALGAMATION OR COPRODUCTINTERSECTION WITH DOTUNION WITH MINUS SIGNUNIO" +
	"N WITH OVERBARINTERSECTION WITH OVERBARINTERSECTION WITH LOGICAL ANDUNIO" +
	"N WITH LOGICAL ORUNION ABOVE INTERSECTIONINTERSECTION ABOVE UNIONUNION A") + ("" +
	"BOVE BAR ABOVE INTERSECTIONINTERSECTION ABOVE BAR ABOVE UNIONUNION BESID" +
	"E AND JOINED WITH UNIONINTERSECTION BESIDE AND JOINED WITH INTERSECTIONC" +
	"LOSED UNION WITH SERIFSCLOSED INTERSECTION WITH SERIFSDOUBLE SQUARE INTE" +
	"RSECTIONDOUBLE SQUARE UNIONCLOSED UNION WITH SERIFS AND SMASH PRODUCTLOG" +
	"ICAL AND WITH DOT ABOVELOGICAL OR WITH DOT ABOVEDOUBLE LOGICAL ANDDOUBLE" +
	" LOGICAL ORTWO INTERSECTING LOGICAL ANDTWO INTERSECTING LOGICAL ORSLOPIN" +
	"G LARGE ORSLOPING LARGE ANDLOGICAL OR OVERLAPPING LOGICAL ANDLOGICAL AND" +
	" WITH MIDDLE STEMLOGICAL OR WITH MIDDLE STEMLOGICAL AND WITH HORIZONTAL " +
	"DASHLOGICAL OR WITH HORIZONTAL DASHLOGICAL AND WITH DOUBLE OVERBARLOGICA" +
	"L AND WITH UNDERBARLOGICAL AND WITH DOUBLE UNDERBARSMALL VEE WITH UNDERB" +
	"ARLOGICAL OR WITH DOUBLE OVERBARLOGICAL OR WITH DOUBLE UNDERBARZ NOTATIO" +
	"N DOMAIN ANTIRESTRICTIONZ NOTATION RANGE ANTIRESTRICTIONEQUALS SIGN WITH" +
	" DOT BELOWIDENTICAL WITH DOT ABOVETRIPLE HORIZONTAL BAR WITH DOUBLE VERT" +
	"ICAL STROKETRIPLE HORIZONTAL BAR WITH TRIPLE VERTICAL STROKETILDE OPERAT" +
	"OR WITH DOT ABOVETILDE OPERATOR WITH RISING DOTSSIMILAR MINUS SIMILARCON" +
	"GRUENT WITH DOT ABOVEEQUALS WITH ASTERISKALMOST EQUAL TO WITH CIRCUMFLEX" +
	" ACCENTAPPROXIMATELY EQUAL OR EQUAL TOEQUALS SIGN ABOVE PLUS SIGNPLUS SI" +
	"GN ABOVE EQUALS SIGNEQUALS SIGN ABOVE TILDE OPERATORDOUBLE COLON EQUALTW" +
	"O CONSECUTIVE EQUALS SIGNSTHREE CONSECUTIVE EQUALS SIGNSEQUALS SIGN WITH" +
	" TWO DOTS ABOVE AND TWO DOTS BELOWEQUIVALENT WITH FOUR DOTS ABOVELESS-TH" +
	"AN WITH CIRCLE INSIDEGREATER-THAN WITH CIRCLE INSIDELESS-THAN WITH QUEST" +
	"ION MARK ABOVEGREATER-THAN WITH QUESTION MARK ABOVELESS-THAN OR SLANTED " +
	"EQUAL TOGREATER-THAN OR SLANTED EQUAL TOLESS-THAN OR SLANTED EQUAL TO WI" +
	"TH DOT INSIDEGREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDELESS-THAN O" +
	"R SLANTED EQUAL TO WITH DOT ABOVEGREATER-THAN OR SLANTED EQUAL TO WITH D" +
	"OT ABOVELESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHTGREATER-THAN O" +
	"R SLANTED EQUAL TO WITH DOT ABOVE LEFTLESS-THAN OR APPROXIMATEGREATER-TH" +
	"AN OR APPROXIMATELESS-THAN AND SINGLE-LINE NOT EQUAL TOGREATER-THAN AND " +
	"SINGLE-LINE NOT EQUAL TOLESS-THAN AND NOT APPROXIMATEGREATER-THAN AND NO" +
	"T APPROXIMATELESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THANGREATER" +
	"-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THANLESS-THAN ABOVE SIMILAR OR " +
	"EQUALGREATER-THAN ABOVE SIMILAR OR EQUALLESS-THAN ABOVE SIMILAR ABOVE GR" +
	"EATER-THANGREATER-THAN ABOVE SIMILAR ABOVE LESS-THANLESS-THAN ABOVE GREA" +
	"TER-THAN ABOVE DOUBLE-LINE EQUALGREATER-THAN ABOVE LESS-THAN ABOVE DOUBL" +
	"E-LINE EQUALLESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANT" +
	"ED EQUALGREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED E" +
	"QUALSLANTED EQUAL TO OR LESS-THANSLANTED EQUAL TO OR GREATER-THANSLANTED" +
	" EQUAL TO OR LESS-THAN WITH DOT INSIDESLANTED EQUAL TO OR GREATER-THAN W" +
	"ITH DOT INSIDEDOUBLE-LINE EQUAL TO OR LESS-THANDOUBLE-LINE EQUAL TO OR G" +
	"REATER-THANDOUBLE-LINE SLANTED EQUAL TO OR LESS-THANDOUBLE-LINE SLANTED " +
	"EQUAL TO OR GREATER-THANSIMILAR OR LESS-THANSIMILAR OR GREATER-THANSIMIL" +
	"AR ABOVE LESS-THAN ABOVE EQUALS SIGNSIMILAR ABOVE GREATER-THAN ABOVE EQU" +
	"ALS SIGNDOUBLE NESTED LESS-THANDOUBLE NESTED GREATER-THANDOUBLE NESTED L" +
	"ESS-THAN WITH UNDERBARGREATER-THAN OVERLAPPING LESS-THANGREATER-THAN BES" +
	"IDE LESS-THANLESS-THAN CLOSED BY CURVEGREATER-THAN CLOSED BY CURVELESS-T" +
	"HAN CLOSED BY CURVE ABOVE SLANTED EQUALGREATER-THAN CLOSED BY CURVE ABOV" +
	"E SLANTED EQUALSMALLER THANLARGER THANSMALLER THAN OR EQUAL TOLARGER THA" +
	"N OR EQUAL TOEQUALS SIGN WITH BUMPY ABOVEPRECEDES ABOVE SINGLE-LINE EQUA" +
	"LS SIGNSUCCEEDS ABOVE SINGLE-LINE EQUALS SIGNPRECEDES ABOVE SINGLE-LINE " +
	"NOT EQUAL TOSUCCEEDS ABOVE SINGLE-LINE NOT EQUAL TOPRECEDES ABOVE EQUALS" +
	" SIGNSUCCEEDS ABOVE EQUALS SIGNPRECEDES ABOVE NOT EQUAL TOSUCCEEDS ABOVE" +
	" NOT EQUAL TOPRECEDES ABOVE ALMOST EQUAL TOSUCCEEDS ABOVE ALMOST EQUAL T" +
	"OPRECEDES ABOVE NOT ALMOST EQUAL TOSUCCEEDS ABOVE NOT ALMOST EQUAL TODOU" +
	"BLE PRECEDESDOUBLE SUCCEEDSSUBSET WITH DOTSUPERSET WITH DOTSUBSET WITH P" +
	"LUS SIGN BELOWSUPERSET WITH PLUS SIGN BELOWSUBSET WITH MULTIPLICATION SI" +
	"GN BELOWSUPERSET WITH MULTIPLICATION SIGN BELOWSUBSET OF OR EQUAL TO WIT" +
	"H DOT ABOVESUPERSET OF OR EQUAL TO WITH DOT ABOVESUBSET OF ABOVE EQUALS " +
	"SIGNSUPERSET OF ABOVE EQUALS SIGNSUBSET OF ABOVE TILDE OPERATORSUPERSET " +
	"OF ABOVE TILDE OPERATORSUBSET OF ABOVE ALMOST EQUAL TOSUPERSET OF ABOVE " +
	"ALMOST EQUAL TOSUBSET OF ABOVE NOT EQUAL TOSUPERSET OF ABOVE NOT EQUAL T" +
	"OSQUARE LEFT OPEN BOX OPERATORSQUARE RIGHT OPEN BOX OPERATORCLOSED SUBSE" +
	"TCLOSED SUPERSETCLOSED SUBSET OR EQUAL TOCLOSED SUPERSET OR EQUAL TOSUBS" +
	"ET ABOVE SUPERSETSUPERSET ABOVE SUBSETSUBSET ABOVE SUBSETSUPERSET ABOVE " +
	"SUPERSETSUPERSET BESIDE SUBSETSUPERSET BESIDE AND JOINED BY DASH WITH SU") + ("" +
	"BSETELEMENT OF OPENING DOWNWARDSPITCHFORK WITH TEE TOPTRANSVERSAL INTERS" +
	"ECTIONFORKINGNONFORKINGSHORT LEFT TACKSHORT DOWN TACKSHORT UP TACKPERPEN" +
	"DICULAR WITH SVERTICAL BAR TRIPLE RIGHT TURNSTILEDOUBLE VERTICAL BAR LEF" +
	"T TURNSTILEVERTICAL BAR DOUBLE LEFT TURNSTILEDOUBLE VERTICAL BAR DOUBLE " +
	"LEFT TURNSTILELONG DASH FROM LEFT MEMBER OF DOUBLE VERTICALSHORT DOWN TA" +
	"CK WITH OVERBARSHORT UP TACK WITH UNDERBARSHORT UP TACK ABOVE SHORT DOWN" +
	" TACKDOUBLE DOWN TACKDOUBLE UP TACKDOUBLE STROKE NOT SIGNREVERSED DOUBLE" +
	" STROKE NOT SIGNDOES NOT DIVIDE WITH REVERSED NEGATION SLASHVERTICAL LIN" +
	"E WITH CIRCLE ABOVEVERTICAL LINE WITH CIRCLE BELOWDOWN TACK WITH CIRCLE " +
	"BELOWPARALLEL WITH HORIZONTAL STROKEPARALLEL WITH TILDE OPERATORTRIPLE V" +
	"ERTICAL BAR BINARY RELATIONTRIPLE VERTICAL BAR WITH HORIZONTAL STROKETRI" +
	"PLE COLON OPERATORTRIPLE NESTED LESS-THANTRIPLE NESTED GREATER-THANDOUBL" +
	"E-LINE SLANTED LESS-THAN OR EQUAL TODOUBLE-LINE SLANTED GREATER-THAN OR " +
	"EQUAL TOTRIPLE SOLIDUS BINARY RELATIONLARGE TRIPLE VERTICAL BAR OPERATOR" +
	"DOUBLE SOLIDUS OPERATORWHITE VERTICAL BARN-ARY WHITE VERTICAL BARNORTH E" +
	"AST WHITE ARROWNORTH WEST WHITE ARROWSOUTH EAST WHITE ARROWSOUTH WEST WH" +
	"ITE ARROWLEFT RIGHT WHITE ARROWLEFTWARDS BLACK ARROWUPWARDS BLACK ARROWD" +
	"OWNWARDS BLACK ARROWNORTH EAST BLACK ARROWNORTH WEST BLACK ARROWSOUTH EA" +
	"ST BLACK ARROWSOUTH WEST BLACK ARROWLEFT RIGHT BLACK ARROWUP DOWN BLACK " +
	"ARROWRIGHTWARDS ARROW WITH TIP DOWNWARDSRIGHTWARDS ARROW WITH TIP UPWARD" +
	"SLEFTWARDS ARROW WITH TIP DOWNWARDSLEFTWARDS ARROW WITH TIP UPWARDSSQUAR" +
	"E WITH TOP HALF BLACKSQUARE WITH BOTTOM HALF BLACKSQUARE WITH UPPER RIGH" +
	"T DIAGONAL HALF BLACKSQUARE WITH LOWER LEFT DIAGONAL HALF BLACKDIAMOND W" +
	"ITH LEFT HALF BLACKDIAMOND WITH RIGHT HALF BLACKDIAMOND WITH TOP HALF BL" +
	"ACKDIAMOND WITH BOTTOM HALF BLACKDOTTED SQUAREBLACK LARGE SQUAREWHITE LA" +
	"RGE SQUAREBLACK VERY SMALL SQUAREWHITE VERY SMALL SQUAREBLACK PENTAGONWH" +
	"ITE PENTAGONWHITE HEXAGONBLACK HEXAGONHORIZONTAL BLACK HEXAGONBLACK LARG" +
	"E CIRCLEBLACK MEDIUM DIAMONDWHITE MEDIUM DIAMONDBLACK MEDIUM LOZENGEWHIT" +
	"E MEDIUM LOZENGEBLACK SMALL DIAMONDBLACK SMALL LOZENGEWHITE SMALL LOZENG" +
	"EBLACK HORIZONTAL ELLIPSEWHITE HORIZONTAL ELLIPSEBLACK VERTICAL ELLIPSEW" +
	"HITE VERTICAL ELLIPSELEFT ARROW WITH SMALL CIRCLETHREE LEFTWARDS ARROWSL" +
	"EFT ARROW WITH CIRCLED PLUSLONG LEFTWARDS SQUIGGLE ARROWLEFTWARDS TWO-HE" +
	"ADED ARROW WITH VERTICAL STROKELEFTWARDS TWO-HEADED ARROW WITH DOUBLE VE" +
	"RTICAL STROKELEFTWARDS TWO-HEADED ARROW FROM BARLEFTWARDS TWO-HEADED TRI" +
	"PLE DASH ARROWLEFTWARDS ARROW WITH DOTTED STEMLEFTWARDS ARROW WITH TAIL " +
	"WITH VERTICAL STROKELEFTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROK" +
	"ELEFTWARDS TWO-HEADED ARROW WITH TAILLEFTWARDS TWO-HEADED ARROW WITH TAI" +
	"L WITH VERTICAL STROKELEFTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE V" +
	"ERTICAL STROKELEFTWARDS ARROW THROUGH XWAVE ARROW POINTING DIRECTLY LEFT" +
	"EQUALS SIGN ABOVE LEFTWARDS ARROWREVERSE TILDE OPERATOR ABOVE LEFTWARDS " +
	"ARROWLEFTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TORIGHTWARDS ARROW THROU" +
	"GH GREATER-THANRIGHTWARDS ARROW THROUGH SUPERSETLEFTWARDS QUADRUPLE ARRO" +
	"WRIGHTWARDS QUADRUPLE ARROWREVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROW" +
	"RIGHTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TOTILDE OPERATOR ABOVE LEFTW" +
	"ARDS ARROWLEFTWARDS ARROW ABOVE ALMOST EQUAL TOLEFTWARDS ARROW ABOVE REV" +
	"ERSE TILDE OPERATORRIGHTWARDS ARROW ABOVE REVERSE TILDE OPERATORDOWNWARD" +
	"S TRIANGLE-HEADED ZIGZAG ARROWSHORT SLANTED NORTH ARROWSHORT BACKSLANTED" +
	" SOUTH ARROWWHITE MEDIUM STARBLACK SMALL STARWHITE SMALL STARBLACK RIGHT" +
	"-POINTING PENTAGONWHITE RIGHT-POINTING PENTAGONHEAVY LARGE CIRCLEHEAVY O" +
	"VAL WITH OVAL INSIDEHEAVY CIRCLE WITH CIRCLE INSIDEHEAVY CIRCLEHEAVY CIR" +
	"CLED SALTIRESLANTED NORTH ARROW WITH HOOKED HEADBACKSLANTED SOUTH ARROW " +
	"WITH HOOKED TAILSLANTED NORTH ARROW WITH HORIZONTAL TAILBACKSLANTED SOUT" +
	"H ARROW WITH HORIZONTAL TAILBENT ARROW POINTING DOWNWARDS THEN NORTH EAS" +
	"TSHORT BENT ARROW POINTING DOWNWARDS THEN NORTH EASTLEFTWARDS TRIANGLE-H" +
	"EADED ARROWUPWARDS TRIANGLE-HEADED ARROWRIGHTWARDS TRIANGLE-HEADED ARROW" +
	"DOWNWARDS TRIANGLE-HEADED ARROWLEFT RIGHT TRIANGLE-HEADED ARROWUP DOWN T" +
	"RIANGLE-HEADED ARROWNORTH WEST TRIANGLE-HEADED ARROWNORTH EAST TRIANGLE-" +
	"HEADED ARROWSOUTH EAST TRIANGLE-HEADED ARROWSOUTH WEST TRIANGLE-HEADED A" +
	"RROWLEFTWARDS TRIANGLE-HEADED DASHED ARROWUPWARDS TRIANGLE-HEADED DASHED" +
	" ARROWRIGHTWARDS TRIANGLE-HEADED DASHED ARROWDOWNWARDS TRIANGLE-HEADED D" +
	"ASHED ARROWCLOCKWISE TRIANGLE-HEADED OPEN CIRCLE ARROWANTICLOCKWISE TRIA" +
	"NGLE-HEADED OPEN CIRCLE ARROWLEFTWARDS TRIANGLE-HEADED ARROW TO BARUPWAR" +
	"DS TRIANGLE-HEADED ARROW TO BARRIGHTWARDS TRIANGLE-HEADED ARROW TO BARDO" +
	"WNWARDS TRIANGLE-HEADED ARROW TO BARNORTH WEST TRIANGLE-HEADED ARROW TO ") + ("" +
	"BARNORTH EAST TRIANGLE-HEADED ARROW TO BARSOUTH EAST TRIANGLE-HEADED ARR" +
	"OW TO BARSOUTH WEST TRIANGLE-HEADED ARROW TO BARLEFTWARDS TRIANGLE-HEADE" +
	"D ARROW WITH DOUBLE HORIZONTAL STROKEUPWARDS TRIANGLE-HEADED ARROW WITH " +
	"DOUBLE HORIZONTAL STROKERIGHTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HOR" +
	"IZONTAL STROKEDOWNWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STR" +
	"OKEHORIZONTAL TAB KEYVERTICAL TAB KEYLEFTWARDS TRIANGLE-HEADED ARROW OVE" +
	"R RIGHTWARDS TRIANGLE-HEADED ARROWUPWARDS TRIANGLE-HEADED ARROW LEFTWARD" +
	"S OF DOWNWARDS TRIANGLE-HEADED ARROWRIGHTWARDS TRIANGLE-HEADED ARROW OVE" +
	"R LEFTWARDS TRIANGLE-HEADED ARROWDOWNWARDS TRIANGLE-HEADED ARROW LEFTWAR" +
	"DS OF UPWARDS TRIANGLE-HEADED ARROWLEFTWARDS TRIANGLE-HEADED PAIRED ARRO" +
	"WSUPWARDS TRIANGLE-HEADED PAIRED ARROWSRIGHTWARDS TRIANGLE-HEADED PAIRED" +
	" ARROWSDOWNWARDS TRIANGLE-HEADED PAIRED ARROWSLEFTWARDS BLACK CIRCLED WH" +
	"ITE ARROWUPWARDS BLACK CIRCLED WHITE ARROWRIGHTWARDS BLACK CIRCLED WHITE" +
	" ARROWDOWNWARDS BLACK CIRCLED WHITE ARROWANTICLOCKWISE TRIANGLE-HEADED R" +
	"IGHT U-SHAPED ARROWANTICLOCKWISE TRIANGLE-HEADED BOTTOM U-SHAPED ARROWAN" +
	"TICLOCKWISE TRIANGLE-HEADED LEFT U-SHAPED ARROWANTICLOCKWISE TRIANGLE-HE" +
	"ADED TOP U-SHAPED ARROWRETURN LEFTRETURN RIGHTNEWLINE LEFTNEWLINE RIGHTF" +
	"OUR CORNER ARROWS CIRCLING ANTICLOCKWISERIGHTWARDS BLACK ARROWSYMBOL FOR" +
	" TYPE A ELECTRONICSTHREE-D TOP-LIGHTED LEFTWARDS EQUILATERAL ARROWHEADTH" +
	"REE-D RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEADTHREE-D TOP-LIGHTED RIG" +
	"HTWARDS EQUILATERAL ARROWHEADTHREE-D LEFT-LIGHTED DOWNWARDS EQUILATERAL " +
	"ARROWHEADBLACK LEFTWARDS EQUILATERAL ARROWHEADBLACK UPWARDS EQUILATERAL " +
	"ARROWHEADBLACK RIGHTWARDS EQUILATERAL ARROWHEADBLACK DOWNWARDS EQUILATER" +
	"AL ARROWHEADDOWNWARDS TRIANGLE-HEADED ARROW WITH LONG TIP LEFTWARDSDOWNW" +
	"ARDS TRIANGLE-HEADED ARROW WITH LONG TIP RIGHTWARDSUPWARDS TRIANGLE-HEAD" +
	"ED ARROW WITH LONG TIP LEFTWARDSUPWARDS TRIANGLE-HEADED ARROW WITH LONG " +
	"TIP RIGHTWARDSLEFTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWARDSRIGHT" +
	"WARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWARDSLEFTWARDS TRIANGLE-HEAD" +
	"ED ARROW WITH LONG TIP DOWNWARDSRIGHTWARDS TRIANGLE-HEADED ARROW WITH LO" +
	"NG TIP DOWNWARDSBLACK CURVED DOWNWARDS AND LEFTWARDS ARROWBLACK CURVED D" +
	"OWNWARDS AND RIGHTWARDS ARROWBLACK CURVED UPWARDS AND LEFTWARDS ARROWBLA" +
	"CK CURVED UPWARDS AND RIGHTWARDS ARROWBLACK CURVED LEFTWARDS AND UPWARDS" +
	" ARROWBLACK CURVED RIGHTWARDS AND UPWARDS ARROWBLACK CURVED LEFTWARDS AN" +
	"D DOWNWARDS ARROWBLACK CURVED RIGHTWARDS AND DOWNWARDS ARROWRIBBON ARROW" +
	" DOWN LEFTRIBBON ARROW DOWN RIGHTRIBBON ARROW UP LEFTRIBBON ARROW UP RIG" +
	"HTRIBBON ARROW LEFT UPRIBBON ARROW RIGHT UPRIBBON ARROW LEFT DOWNRIBBON " +
	"ARROW RIGHT DOWNUPWARDS WHITE ARROW FROM BAR WITH HORIZONTAL BARUP ARROW" +
	"HEAD IN A RECTANGLE BOXOVERLAPPING WHITE SQUARESOVERLAPPING WHITE AND BL" +
	"ACK SQUARESOVERLAPPING BLACK SQUARESBALLOT BOX WITH LIGHT XCIRCLED XCIRC" +
	"LED BOLD XBLACK SQUARE CENTREDBLACK DIAMOND CENTREDTURNED BLACK PENTAGON" +
	"HORIZONTAL BLACK OCTAGONBLACK OCTAGONBLACK MEDIUM UP-POINTING TRIANGLE C" +
	"ENTREDBLACK MEDIUM DOWN-POINTING TRIANGLE CENTREDBLACK MEDIUM LEFT-POINT" +
	"ING TRIANGLE CENTREDBLACK MEDIUM RIGHT-POINTING TRIANGLE CENTREDNEPTUNE " +
	"FORM TWOTOP HALF BLACK CIRCLEBOTTOM HALF BLACK CIRCLELIGHT FOUR POINTED " +
	"BLACK CUSPROTATED LIGHT FOUR POINTED BLACK CUSPWHITE FOUR POINTED CUSPRO" +
	"TATED WHITE FOUR POINTED CUSPSQUARE POSITION INDICATORUNCERTAINTY SIGNGR" +
	"OUP MARKPLUTO FORM TWOPLUTO FORM THREEPLUTO FORM FOURPLUTO FORM FIVETRAN" +
	"SPLUTOPROSERPINAASTRAEAHYGIEAPHOLUSNESSUSWHITE MOON SELENABLACK DIAMOND " +
	"ON CROSSTRUE LIGHT MOON ARTACUPIDOHADESZEUSKRONOSAPOLLONADMETOSVULCANUSP" +
	"OSEIDONLEFT HALF BLACK STARRIGHT HALF BLACK STARSTAR WITH LEFT HALF BLAC" +
	"KSTAR WITH RIGHT HALF BLACKLEFTWARDS TWO-HEADED ARROW WITH TRIANGLE ARRO" +
	"WHEADSUPWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADSRIGHTWARDS TWO-HE" +
	"ADED ARROW WITH TRIANGLE ARROWHEADSDOWNWARDS TWO-HEADED ARROW WITH TRIAN" +
	"GLE ARROWHEADSERIS FORM ONEERIS FORM TWOSEDNARUSSIAN ASTROLOGICAL SYMBOL" +
	" VIGINTILERUSSIAN ASTROLOGICAL SYMBOL NOVILERUSSIAN ASTROLOGICAL SYMBOL " +
	"QUINTILERUSSIAN ASTROLOGICAL SYMBOL BINOVILERUSSIAN ASTROLOGICAL SYMBOL " +
	"SENTAGONRUSSIAN ASTROLOGICAL SYMBOL TREDECILEEQUALS SIGN WITH INFINITY B" +
	"ELOWUNITED SYMBOLSEPARATED SYMBOLDOUBLED SYMBOLPASSED SYMBOLREVERSED RIG" +
	"HT ANGLEHELLSCHREIBER PAUSE SYMBOLGLAGOLITIC CAPITAL LETTER AZUGLAGOLITI" +
	"C CAPITAL LETTER BUKYGLAGOLITIC CAPITAL LETTER VEDEGLAGOLITIC CAPITAL LE" +
	"TTER GLAGOLIGLAGOLITIC CAPITAL LETTER DOBROGLAGOLITIC CAPITAL LETTER YES" +
	"TUGLAGOLITIC CAPITAL LETTER ZHIVETEGLAGOLITIC CAPITAL LETTER DZELOGLAGOL" +
	"ITIC CAPITAL LETTER ZEMLJAGLAGOLITIC CAPITAL LETTER IZHEGLAGOLITIC CAPIT" +
	"AL LETTER INITIAL IZHEGLAGOLITIC CAPITAL LETTER IGLAGOLITIC CAPITAL LETT") + ("" +
	"ER DJERVIGLAGOLITIC CAPITAL LETTER KAKOGLAGOLITIC CAPITAL LETTER LJUDIJE" +
	"GLAGOLITIC CAPITAL LETTER MYSLITEGLAGOLITIC CAPITAL LETTER NASHIGLAGOLIT" +
	"IC CAPITAL LETTER ONUGLAGOLITIC CAPITAL LETTER POKOJIGLAGOLITIC CAPITAL " +
	"LETTER RITSIGLAGOLITIC CAPITAL LETTER SLOVOGLAGOLITIC CAPITAL LETTER TVR" +
	"IDOGLAGOLITIC CAPITAL LETTER UKUGLAGOLITIC CAPITAL LETTER FRITUGLAGOLITI" +
	"C CAPITAL LETTER HERUGLAGOLITIC CAPITAL LETTER OTUGLAGOLITIC CAPITAL LET" +
	"TER PEGLAGOLITIC CAPITAL LETTER SHTAGLAGOLITIC CAPITAL LETTER TSIGLAGOLI" +
	"TIC CAPITAL LETTER CHRIVIGLAGOLITIC CAPITAL LETTER SHAGLAGOLITIC CAPITAL" +
	" LETTER YERUGLAGOLITIC CAPITAL LETTER YERIGLAGOLITIC CAPITAL LETTER YATI" +
	"GLAGOLITIC CAPITAL LETTER SPIDERY HAGLAGOLITIC CAPITAL LETTER YUGLAGOLIT" +
	"IC CAPITAL LETTER SMALL YUSGLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAIL" +
	"GLAGOLITIC CAPITAL LETTER YOGLAGOLITIC CAPITAL LETTER IOTATED SMALL YUSG" +
	"LAGOLITIC CAPITAL LETTER BIG YUSGLAGOLITIC CAPITAL LETTER IOTATED BIG YU" +
	"SGLAGOLITIC CAPITAL LETTER FITAGLAGOLITIC CAPITAL LETTER IZHITSAGLAGOLIT" +
	"IC CAPITAL LETTER SHTAPICGLAGOLITIC CAPITAL LETTER TROKUTASTI AGLAGOLITI" +
	"C CAPITAL LETTER LATINATE MYSLITEGLAGOLITIC SMALL LETTER AZUGLAGOLITIC S" +
	"MALL LETTER BUKYGLAGOLITIC SMALL LETTER VEDEGLAGOLITIC SMALL LETTER GLAG" +
	"OLIGLAGOLITIC SMALL LETTER DOBROGLAGOLITIC SMALL LETTER YESTUGLAGOLITIC " +
	"SMALL LETTER ZHIVETEGLAGOLITIC SMALL LETTER DZELOGLAGOLITIC SMALL LETTER" +
	" ZEMLJAGLAGOLITIC SMALL LETTER IZHEGLAGOLITIC SMALL LETTER INITIAL IZHEG" +
	"LAGOLITIC SMALL LETTER IGLAGOLITIC SMALL LETTER DJERVIGLAGOLITIC SMALL L" +
	"ETTER KAKOGLAGOLITIC SMALL LETTER LJUDIJEGLAGOLITIC SMALL LETTER MYSLITE" +
	"GLAGOLITIC SMALL LETTER NASHIGLAGOLITIC SMALL LETTER ONUGLAGOLITIC SMALL" +
	" LETTER POKOJIGLAGOLITIC SMALL LETTER RITSIGLAGOLITIC SMALL LETTER SLOVO" +
	"GLAGOLITIC SMALL LETTER TVRIDOGLAGOLITIC SMALL LETTER UKUGLAGOLITIC SMAL" +
	"L LETTER FRITUGLAGOLITIC SMALL LETTER HERUGLAGOLITIC SMALL LETTER OTUGLA" +
	"GOLITIC SMALL LETTER PEGLAGOLITIC SMALL LETTER SHTAGLAGOLITIC SMALL LETT" +
	"ER TSIGLAGOLITIC SMALL LETTER CHRIVIGLAGOLITIC SMALL LETTER SHAGLAGOLITI" +
	"C SMALL LETTER YERUGLAGOLITIC SMALL LETTER YERIGLAGOLITIC SMALL LETTER Y" +
	"ATIGLAGOLITIC SMALL LETTER SPIDERY HAGLAGOLITIC SMALL LETTER YUGLAGOLITI" +
	"C SMALL LETTER SMALL YUSGLAGOLITIC SMALL LETTER SMALL YUS WITH TAILGLAGO" +
	"LITIC SMALL LETTER YOGLAGOLITIC SMALL LETTER IOTATED SMALL YUSGLAGOLITIC" +
	" SMALL LETTER BIG YUSGLAGOLITIC SMALL LETTER IOTATED BIG YUSGLAGOLITIC S" +
	"MALL LETTER FITAGLAGOLITIC SMALL LETTER IZHITSAGLAGOLITIC SMALL LETTER S" +
	"HTAPICGLAGOLITIC SMALL LETTER TROKUTASTI AGLAGOLITIC SMALL LETTER LATINA" +
	"TE MYSLITELATIN CAPITAL LETTER L WITH DOUBLE BARLATIN SMALL LETTER L WIT" +
	"H DOUBLE BARLATIN CAPITAL LETTER L WITH MIDDLE TILDELATIN CAPITAL LETTER" +
	" P WITH STROKELATIN CAPITAL LETTER R WITH TAILLATIN SMALL LETTER A WITH " +
	"STROKELATIN SMALL LETTER T WITH DIAGONAL STROKELATIN CAPITAL LETTER H WI" +
	"TH DESCENDERLATIN SMALL LETTER H WITH DESCENDERLATIN CAPITAL LETTER K WI" +
	"TH DESCENDERLATIN SMALL LETTER K WITH DESCENDERLATIN CAPITAL LETTER Z WI" +
	"TH DESCENDERLATIN SMALL LETTER Z WITH DESCENDERLATIN CAPITAL LETTER ALPH" +
	"ALATIN CAPITAL LETTER M WITH HOOKLATIN CAPITAL LETTER TURNED ALATIN CAPI" +
	"TAL LETTER TURNED ALPHALATIN SMALL LETTER V WITH RIGHT HOOKLATIN CAPITAL" +
	" LETTER W WITH HOOKLATIN SMALL LETTER W WITH HOOKLATIN SMALL LETTER V WI" +
	"TH CURLLATIN CAPITAL LETTER HALF HLATIN SMALL LETTER HALF HLATIN SMALL L" +
	"ETTER TAILLESS PHILATIN SMALL LETTER E WITH NOTCHLATIN SMALL LETTER TURN" +
	"ED R WITH TAILLATIN SMALL LETTER O WITH LOW RING INSIDELATIN LETTER SMAL" +
	"L CAPITAL TURNED ELATIN SUBSCRIPT SMALL LETTER JMODIFIER LETTER CAPITAL " +
	"VLATIN CAPITAL LETTER S WITH SWASH TAILLATIN CAPITAL LETTER Z WITH SWASH" +
	" TAILCOPTIC CAPITAL LETTER ALFACOPTIC SMALL LETTER ALFACOPTIC CAPITAL LE" +
	"TTER VIDACOPTIC SMALL LETTER VIDACOPTIC CAPITAL LETTER GAMMACOPTIC SMALL" +
	" LETTER GAMMACOPTIC CAPITAL LETTER DALDACOPTIC SMALL LETTER DALDACOPTIC " +
	"CAPITAL LETTER EIECOPTIC SMALL LETTER EIECOPTIC CAPITAL LETTER SOUCOPTIC" +
	" SMALL LETTER SOUCOPTIC CAPITAL LETTER ZATACOPTIC SMALL LETTER ZATACOPTI" +
	"C CAPITAL LETTER HATECOPTIC SMALL LETTER HATECOPTIC CAPITAL LETTER THETH" +
	"ECOPTIC SMALL LETTER THETHECOPTIC CAPITAL LETTER IAUDACOPTIC SMALL LETTE" +
	"R IAUDACOPTIC CAPITAL LETTER KAPACOPTIC SMALL LETTER KAPACOPTIC CAPITAL " +
	"LETTER LAULACOPTIC SMALL LETTER LAULACOPTIC CAPITAL LETTER MICOPTIC SMAL" +
	"L LETTER MICOPTIC CAPITAL LETTER NICOPTIC SMALL LETTER NICOPTIC CAPITAL " +
	"LETTER KSICOPTIC SMALL LETTER KSICOPTIC CAPITAL LETTER OCOPTIC SMALL LET" +
	"TER OCOPTIC CAPITAL LETTER PICOPTIC SMALL LETTER PICOPTIC CAPITAL LETTER" +
	" ROCOPTIC SMALL LETTER ROCOPTIC CAPITAL LETTER SIMACOPTIC SMALL LETTER S" +
	"IMACOPTIC CAPITAL LETTER TAUCOPTIC SMALL LETTER TAUCOPTIC CAPITAL LETTER") + ("" +
	" UACOPTIC SMALL LETTER UACOPTIC CAPITAL LETTER FICOPTIC SMALL LETTER FIC" +
	"OPTIC CAPITAL LETTER KHICOPTIC SMALL LETTER KHICOPTIC CAPITAL LETTER PSI" +
	"COPTIC SMALL LETTER PSICOPTIC CAPITAL LETTER OOUCOPTIC SMALL LETTER OOUC" +
	"OPTIC CAPITAL LETTER DIALECT-P ALEFCOPTIC SMALL LETTER DIALECT-P ALEFCOP" +
	"TIC CAPITAL LETTER OLD COPTIC AINCOPTIC SMALL LETTER OLD COPTIC AINCOPTI" +
	"C CAPITAL LETTER CRYPTOGRAMMIC EIECOPTIC SMALL LETTER CRYPTOGRAMMIC EIEC" +
	"OPTIC CAPITAL LETTER DIALECT-P KAPACOPTIC SMALL LETTER DIALECT-P KAPACOP" +
	"TIC CAPITAL LETTER DIALECT-P NICOPTIC SMALL LETTER DIALECT-P NICOPTIC CA" +
	"PITAL LETTER CRYPTOGRAMMIC NICOPTIC SMALL LETTER CRYPTOGRAMMIC NICOPTIC " +
	"CAPITAL LETTER OLD COPTIC OOUCOPTIC SMALL LETTER OLD COPTIC OOUCOPTIC CA" +
	"PITAL LETTER SAMPICOPTIC SMALL LETTER SAMPICOPTIC CAPITAL LETTER CROSSED" +
	" SHEICOPTIC SMALL LETTER CROSSED SHEICOPTIC CAPITAL LETTER OLD COPTIC SH" +
	"EICOPTIC SMALL LETTER OLD COPTIC SHEICOPTIC CAPITAL LETTER OLD COPTIC ES" +
	"HCOPTIC SMALL LETTER OLD COPTIC ESHCOPTIC CAPITAL LETTER AKHMIMIC KHEICO" +
	"PTIC SMALL LETTER AKHMIMIC KHEICOPTIC CAPITAL LETTER DIALECT-P HORICOPTI" +
	"C SMALL LETTER DIALECT-P HORICOPTIC CAPITAL LETTER OLD COPTIC HORICOPTIC" +
	" SMALL LETTER OLD COPTIC HORICOPTIC CAPITAL LETTER OLD COPTIC HACOPTIC S" +
	"MALL LETTER OLD COPTIC HACOPTIC CAPITAL LETTER L-SHAPED HACOPTIC SMALL L" +
	"ETTER L-SHAPED HACOPTIC CAPITAL LETTER OLD COPTIC HEICOPTIC SMALL LETTER" +
	" OLD COPTIC HEICOPTIC CAPITAL LETTER OLD COPTIC HATCOPTIC SMALL LETTER O" +
	"LD COPTIC HATCOPTIC CAPITAL LETTER OLD COPTIC GANGIACOPTIC SMALL LETTER " +
	"OLD COPTIC GANGIACOPTIC CAPITAL LETTER OLD COPTIC DJACOPTIC SMALL LETTER" +
	" OLD COPTIC DJACOPTIC CAPITAL LETTER OLD COPTIC SHIMACOPTIC SMALL LETTER" +
	" OLD COPTIC SHIMACOPTIC CAPITAL LETTER OLD NUBIAN SHIMACOPTIC SMALL LETT" +
	"ER OLD NUBIAN SHIMACOPTIC CAPITAL LETTER OLD NUBIAN NGICOPTIC SMALL LETT" +
	"ER OLD NUBIAN NGICOPTIC CAPITAL LETTER OLD NUBIAN NYICOPTIC SMALL LETTER" +
	" OLD NUBIAN NYICOPTIC CAPITAL LETTER OLD NUBIAN WAUCOPTIC SMALL LETTER O" +
	"LD NUBIAN WAUCOPTIC SYMBOL KAICOPTIC SYMBOL MI ROCOPTIC SYMBOL PI ROCOPT" +
	"IC SYMBOL STAUROSCOPTIC SYMBOL TAU ROCOPTIC SYMBOL KHI ROCOPTIC SYMBOL S" +
	"HIMA SIMACOPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEICOPTIC SMALL LETTER CRY" +
	"PTOGRAMMIC SHEICOPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIACOPTIC SMALL LE" +
	"TTER CRYPTOGRAMMIC GANGIACOPTIC COMBINING NI ABOVECOPTIC COMBINING SPIRI" +
	"TUS ASPERCOPTIC COMBINING SPIRITUS LENISCOPTIC CAPITAL LETTER BOHAIRIC K" +
	"HEICOPTIC SMALL LETTER BOHAIRIC KHEICOPTIC OLD NUBIAN FULL STOPCOPTIC OL" +
	"D NUBIAN DIRECT QUESTION MARKCOPTIC OLD NUBIAN INDIRECT QUESTION MARKCOP" +
	"TIC OLD NUBIAN VERSE DIVIDERCOPTIC FRACTION ONE HALFCOPTIC FULL STOPCOPT" +
	"IC MORPHOLOGICAL DIVIDERGEORGIAN SMALL LETTER ANGEORGIAN SMALL LETTER BA" +
	"NGEORGIAN SMALL LETTER GANGEORGIAN SMALL LETTER DONGEORGIAN SMALL LETTER" +
	" ENGEORGIAN SMALL LETTER VINGEORGIAN SMALL LETTER ZENGEORGIAN SMALL LETT" +
	"ER TANGEORGIAN SMALL LETTER INGEORGIAN SMALL LETTER KANGEORGIAN SMALL LE" +
	"TTER LASGEORGIAN SMALL LETTER MANGEORGIAN SMALL LETTER NARGEORGIAN SMALL" +
	" LETTER ONGEORGIAN SMALL LETTER PARGEORGIAN SMALL LETTER ZHARGEORGIAN SM" +
	"ALL LETTER RAEGEORGIAN SMALL LETTER SANGEORGIAN SMALL LETTER TARGEORGIAN" +
	" SMALL LETTER UNGEORGIAN SMALL LETTER PHARGEORGIAN SMALL LETTER KHARGEOR" +
	"GIAN SMALL LETTER GHANGEORGIAN SMALL LETTER QARGEORGIAN SMALL LETTER SHI" +
	"NGEORGIAN SMALL LETTER CHINGEORGIAN SMALL LETTER CANGEORGIAN SMALL LETTE" +
	"R JILGEORGIAN SMALL LETTER CILGEORGIAN SMALL LETTER CHARGEORGIAN SMALL L" +
	"ETTER XANGEORGIAN SMALL LETTER JHANGEORGIAN SMALL LETTER HAEGEORGIAN SMA" +
	"LL LETTER HEGEORGIAN SMALL LETTER HIEGEORGIAN SMALL LETTER WEGEORGIAN SM" +
	"ALL LETTER HARGEORGIAN SMALL LETTER HOEGEORGIAN SMALL LETTER YNGEORGIAN " +
	"SMALL LETTER AENTIFINAGH LETTER YATIFINAGH LETTER YABTIFINAGH LETTER YAB" +
	"HTIFINAGH LETTER YAGTIFINAGH LETTER YAGHHTIFINAGH LETTER BERBER ACADEMY " +
	"YAJTIFINAGH LETTER YAJTIFINAGH LETTER YADTIFINAGH LETTER YADHTIFINAGH LE" +
	"TTER YADDTIFINAGH LETTER YADDHTIFINAGH LETTER YEYTIFINAGH LETTER YAFTIFI" +
	"NAGH LETTER YAKTIFINAGH LETTER TUAREG YAKTIFINAGH LETTER YAKHHTIFINAGH L" +
	"ETTER YAHTIFINAGH LETTER BERBER ACADEMY YAHTIFINAGH LETTER TUAREG YAHTIF" +
	"INAGH LETTER YAHHTIFINAGH LETTER YAATIFINAGH LETTER YAKHTIFINAGH LETTER " +
	"TUAREG YAKHTIFINAGH LETTER YAQTIFINAGH LETTER TUAREG YAQTIFINAGH LETTER " +
	"YITIFINAGH LETTER YAZHTIFINAGH LETTER AHAGGAR YAZHTIFINAGH LETTER TUAREG" +
	" YAZHTIFINAGH LETTER YALTIFINAGH LETTER YAMTIFINAGH LETTER YANTIFINAGH L" +
	"ETTER TUAREG YAGNTIFINAGH LETTER TUAREG YANGTIFINAGH LETTER YAPTIFINAGH " +
	"LETTER YUTIFINAGH LETTER YARTIFINAGH LETTER YARRTIFINAGH LETTER YAGHTIFI" +
	"NAGH LETTER TUAREG YAGHTIFINAGH LETTER AYER YAGHTIFINAGH LETTER YASTIFIN" +
	"AGH LETTER YASSTIFINAGH LETTER YASHTIFINAGH LETTER YATTIFINAGH LETTER YA") + ("" +
	"THTIFINAGH LETTER YACHTIFINAGH LETTER YATTTIFINAGH LETTER YAVTIFINAGH LE" +
	"TTER YAWTIFINAGH LETTER YAYTIFINAGH LETTER YAZTIFINAGH LETTER TAWELLEMET" +
	" YAZTIFINAGH LETTER YAZZTIFINAGH LETTER YETIFINAGH LETTER YOTIFINAGH MOD" +
	"IFIER LETTER LABIALIZATION MARKTIFINAGH SEPARATOR MARKTIFINAGH CONSONANT" +
	" JOINERETHIOPIC SYLLABLE LOAETHIOPIC SYLLABLE MOAETHIOPIC SYLLABLE ROAET" +
	"HIOPIC SYLLABLE SOAETHIOPIC SYLLABLE SHOAETHIOPIC SYLLABLE BOAETHIOPIC S" +
	"YLLABLE TOAETHIOPIC SYLLABLE COAETHIOPIC SYLLABLE NOAETHIOPIC SYLLABLE N" +
	"YOAETHIOPIC SYLLABLE GLOTTAL OAETHIOPIC SYLLABLE ZOAETHIOPIC SYLLABLE DO" +
	"AETHIOPIC SYLLABLE DDOAETHIOPIC SYLLABLE JOAETHIOPIC SYLLABLE THOAETHIOP" +
	"IC SYLLABLE CHOAETHIOPIC SYLLABLE PHOAETHIOPIC SYLLABLE POAETHIOPIC SYLL" +
	"ABLE GGWAETHIOPIC SYLLABLE GGWIETHIOPIC SYLLABLE GGWEEETHIOPIC SYLLABLE " +
	"GGWEETHIOPIC SYLLABLE SSAETHIOPIC SYLLABLE SSUETHIOPIC SYLLABLE SSIETHIO" +
	"PIC SYLLABLE SSAAETHIOPIC SYLLABLE SSEEETHIOPIC SYLLABLE SSEETHIOPIC SYL" +
	"LABLE SSOETHIOPIC SYLLABLE CCAETHIOPIC SYLLABLE CCUETHIOPIC SYLLABLE CCI" +
	"ETHIOPIC SYLLABLE CCAAETHIOPIC SYLLABLE CCEEETHIOPIC SYLLABLE CCEETHIOPI" +
	"C SYLLABLE CCOETHIOPIC SYLLABLE ZZAETHIOPIC SYLLABLE ZZUETHIOPIC SYLLABL" +
	"E ZZIETHIOPIC SYLLABLE ZZAAETHIOPIC SYLLABLE ZZEEETHIOPIC SYLLABLE ZZEET" +
	"HIOPIC SYLLABLE ZZOETHIOPIC SYLLABLE CCHAETHIOPIC SYLLABLE CCHUETHIOPIC " +
	"SYLLABLE CCHIETHIOPIC SYLLABLE CCHAAETHIOPIC SYLLABLE CCHEEETHIOPIC SYLL" +
	"ABLE CCHEETHIOPIC SYLLABLE CCHOETHIOPIC SYLLABLE QYAETHIOPIC SYLLABLE QY" +
	"UETHIOPIC SYLLABLE QYIETHIOPIC SYLLABLE QYAAETHIOPIC SYLLABLE QYEEETHIOP" +
	"IC SYLLABLE QYEETHIOPIC SYLLABLE QYOETHIOPIC SYLLABLE KYAETHIOPIC SYLLAB" +
	"LE KYUETHIOPIC SYLLABLE KYIETHIOPIC SYLLABLE KYAAETHIOPIC SYLLABLE KYEEE" +
	"THIOPIC SYLLABLE KYEETHIOPIC SYLLABLE KYOETHIOPIC SYLLABLE XYAETHIOPIC S" +
	"YLLABLE XYUETHIOPIC SYLLABLE XYIETHIOPIC SYLLABLE XYAAETHIOPIC SYLLABLE " +
	"XYEEETHIOPIC SYLLABLE XYEETHIOPIC SYLLABLE XYOETHIOPIC SYLLABLE GYAETHIO" +
	"PIC SYLLABLE GYUETHIOPIC SYLLABLE GYIETHIOPIC SYLLABLE GYAAETHIOPIC SYLL" +
	"ABLE GYEEETHIOPIC SYLLABLE GYEETHIOPIC SYLLABLE GYOCOMBINING CYRILLIC LE" +
	"TTER BECOMBINING CYRILLIC LETTER VECOMBINING CYRILLIC LETTER GHECOMBININ" +
	"G CYRILLIC LETTER DECOMBINING CYRILLIC LETTER ZHECOMBINING CYRILLIC LETT" +
	"ER ZECOMBINING CYRILLIC LETTER KACOMBINING CYRILLIC LETTER ELCOMBINING C" +
	"YRILLIC LETTER EMCOMBINING CYRILLIC LETTER ENCOMBINING CYRILLIC LETTER O" +
	"COMBINING CYRILLIC LETTER PECOMBINING CYRILLIC LETTER ERCOMBINING CYRILL" +
	"IC LETTER ESCOMBINING CYRILLIC LETTER TECOMBINING CYRILLIC LETTER HACOMB" +
	"INING CYRILLIC LETTER TSECOMBINING CYRILLIC LETTER CHECOMBINING CYRILLIC" +
	" LETTER SHACOMBINING CYRILLIC LETTER SHCHACOMBINING CYRILLIC LETTER FITA" +
	"COMBINING CYRILLIC LETTER ES-TECOMBINING CYRILLIC LETTER ACOMBINING CYRI" +
	"LLIC LETTER IECOMBINING CYRILLIC LETTER DJERVCOMBINING CYRILLIC LETTER M" +
	"ONOGRAPH UKCOMBINING CYRILLIC LETTER YATCOMBINING CYRILLIC LETTER YUCOMB" +
	"INING CYRILLIC LETTER IOTIFIED ACOMBINING CYRILLIC LETTER LITTLE YUSCOMB" +
	"INING CYRILLIC LETTER BIG YUSCOMBINING CYRILLIC LETTER IOTIFIED BIG YUSR" +
	"IGHT ANGLE SUBSTITUTION MARKERRIGHT ANGLE DOTTED SUBSTITUTION MARKERLEFT" +
	" SUBSTITUTION BRACKETRIGHT SUBSTITUTION BRACKETLEFT DOTTED SUBSTITUTION " +
	"BRACKETRIGHT DOTTED SUBSTITUTION BRACKETRAISED INTERPOLATION MARKERRAISE" +
	"D DOTTED INTERPOLATION MARKERDOTTED TRANSPOSITION MARKERLEFT TRANSPOSITI" +
	"ON BRACKETRIGHT TRANSPOSITION BRACKETRAISED SQUARELEFT RAISED OMISSION B" +
	"RACKETRIGHT RAISED OMISSION BRACKETEDITORIAL CORONISPARAGRAPHOSFORKED PA" +
	"RAGRAPHOSREVERSED FORKED PARAGRAPHOSHYPODIASTOLEDOTTED OBELOSDOWNWARDS A" +
	"NCORAUPWARDS ANCORADOTTED RIGHT-POINTING ANGLEDOUBLE OBLIQUE HYPHENINVER" +
	"TED INTERROBANGPALM BRANCHHYPHEN WITH DIAERESISTILDE WITH RING ABOVELEFT" +
	" LOW PARAPHRASE BRACKETRIGHT LOW PARAPHRASE BRACKETTILDE WITH DOT ABOVET" +
	"ILDE WITH DOT BELOWLEFT VERTICAL BAR WITH QUILLRIGHT VERTICAL BAR WITH Q" +
	"UILLTOP LEFT HALF BRACKETTOP RIGHT HALF BRACKETBOTTOM LEFT HALF BRACKETB" +
	"OTTOM RIGHT HALF BRACKETLEFT SIDEWAYS U BRACKETRIGHT SIDEWAYS U BRACKETL" +
	"EFT DOUBLE PARENTHESISRIGHT DOUBLE PARENTHESISTWO DOTS OVER ONE DOT PUNC" +
	"TUATIONONE DOT OVER TWO DOTS PUNCTUATIONSQUARED FOUR DOT PUNCTUATIONFIVE" +
	" DOT MARKREVERSED QUESTION MARKVERTICAL TILDERING POINTWORD SEPARATOR MI" +
	"DDLE DOTTURNED COMMARAISED DOTRAISED COMMATURNED SEMICOLONDAGGER WITH LE" +
	"FT GUARDDAGGER WITH RIGHT GUARDTURNED DAGGERTOP HALF SECTION SIGNTWO-EM " +
	"DASHTHREE-EM DASHSTENOGRAPHIC FULL STOPVERTICAL SIX DOTSWIGGLY VERTICAL " +
	"LINECAPITULUMDOUBLE HYPHENREVERSED COMMADOUBLE LOW-REVERSED-9 QUOTATION " +
	"MARKDASH WITH LEFT UPTURNDOUBLE SUSPENSION MARKINVERTED LOW KAVYKAINVERT" +
	"ED LOW KAVYKA WITH KAVYKA ABOVELOW KAVYKALOW KAVYKA WITH DOTDOUBLE STACK" +
	"ED COMMADOTTED SOLIDUSTRIPLE DAGGERMEDIEVAL COMMAPARAGRAPHUS MARKPUNCTUS") + ("" +
	" ELEVATUS MARKCORNISH VERSE DIVIDERCROSS PATTY WITH RIGHT CROSSBARCROSS " +
	"PATTY WITH LEFT CROSSBARTIRONIAN SIGN CAPITAL ETCJK RADICAL REPEATCJK RA" +
	"DICAL CLIFFCJK RADICAL SECOND ONECJK RADICAL SECOND TWOCJK RADICAL SECON" +
	"D THREECJK RADICAL PERSONCJK RADICAL BOXCJK RADICAL TABLECJK RADICAL KNI" +
	"FE ONECJK RADICAL KNIFE TWOCJK RADICAL DIVINATIONCJK RADICAL SEALCJK RAD" +
	"ICAL SMALL ONECJK RADICAL SMALL TWOCJK RADICAL LAME ONECJK RADICAL LAME " +
	"TWOCJK RADICAL LAME THREECJK RADICAL LAME FOURCJK RADICAL SNAKECJK RADIC" +
	"AL THREADCJK RADICAL SNOUT ONECJK RADICAL SNOUT TWOCJK RADICAL HEART ONE" +
	"CJK RADICAL HEART TWOCJK RADICAL HANDCJK RADICAL RAPCJK RADICAL CHOKECJK" +
	" RADICAL SUNCJK RADICAL MOONCJK RADICAL DEATHCJK RADICAL MOTHERCJK RADIC" +
	"AL CIVILIANCJK RADICAL WATER ONECJK RADICAL WATER TWOCJK RADICAL FIRECJK" +
	" RADICAL PAW ONECJK RADICAL PAW TWOCJK RADICAL SIMPLIFIED HALF TREE TRUN" +
	"KCJK RADICAL COWCJK RADICAL DOGCJK RADICAL JADECJK RADICAL BOLT OF CLOTH" +
	"CJK RADICAL EYECJK RADICAL SPIRIT ONECJK RADICAL SPIRIT TWOCJK RADICAL B" +
	"AMBOOCJK RADICAL SILKCJK RADICAL C-SIMPLIFIED SILKCJK RADICAL NET ONECJK" +
	" RADICAL NET TWOCJK RADICAL NET THREECJK RADICAL NET FOURCJK RADICAL MES" +
	"HCJK RADICAL SHEEPCJK RADICAL RAMCJK RADICAL EWECJK RADICAL OLDCJK RADIC" +
	"AL BRUSH ONECJK RADICAL BRUSH TWOCJK RADICAL MEATCJK RADICAL MORTARCJK R" +
	"ADICAL GRASS ONECJK RADICAL GRASS TWOCJK RADICAL GRASS THREECJK RADICAL " +
	"TIGERCJK RADICAL CLOTHESCJK RADICAL WEST ONECJK RADICAL WEST TWOCJK RADI" +
	"CAL C-SIMPLIFIED SEECJK RADICAL SIMPLIFIED HORNCJK RADICAL HORNCJK RADIC" +
	"AL C-SIMPLIFIED SPEECHCJK RADICAL C-SIMPLIFIED SHELLCJK RADICAL FOOTCJK " +
	"RADICAL C-SIMPLIFIED CARTCJK RADICAL SIMPLIFIED WALKCJK RADICAL WALK ONE" +
	"CJK RADICAL WALK TWOCJK RADICAL CITYCJK RADICAL C-SIMPLIFIED GOLDCJK RAD" +
	"ICAL LONG ONECJK RADICAL LONG TWOCJK RADICAL C-SIMPLIFIED LONGCJK RADICA" +
	"L C-SIMPLIFIED GATECJK RADICAL MOUND ONECJK RADICAL MOUND TWOCJK RADICAL" +
	" RAINCJK RADICAL BLUECJK RADICAL C-SIMPLIFIED TANNED LEATHERCJK RADICAL " +
	"C-SIMPLIFIED LEAFCJK RADICAL C-SIMPLIFIED WINDCJK RADICAL C-SIMPLIFIED F" +
	"LYCJK RADICAL EAT ONECJK RADICAL EAT TWOCJK RADICAL EAT THREECJK RADICAL" +
	" C-SIMPLIFIED EATCJK RADICAL HEADCJK RADICAL C-SIMPLIFIED HORSECJK RADIC" +
	"AL BONECJK RADICAL GHOSTCJK RADICAL C-SIMPLIFIED FISHCJK RADICAL C-SIMPL" +
	"IFIED BIRDCJK RADICAL C-SIMPLIFIED SALTCJK RADICAL SIMPLIFIED WHEATCJK R" +
	"ADICAL SIMPLIFIED YELLOWCJK RADICAL C-SIMPLIFIED FROGCJK RADICAL J-SIMPL" +
	"IFIED EVENCJK RADICAL C-SIMPLIFIED EVENCJK RADICAL J-SIMPLIFIED TOOTHCJK" +
	" RADICAL C-SIMPLIFIED TOOTHCJK RADICAL J-SIMPLIFIED DRAGONCJK RADICAL C-" +
	"SIMPLIFIED DRAGONCJK RADICAL TURTLECJK RADICAL J-SIMPLIFIED TURTLECJK RA" +
	"DICAL C-SIMPLIFIED TURTLEKANGXI RADICAL ONEKANGXI RADICAL LINEKANGXI RAD" +
	"ICAL DOTKANGXI RADICAL SLASHKANGXI RADICAL SECONDKANGXI RADICAL HOOKKANG" +
	"XI RADICAL TWOKANGXI RADICAL LIDKANGXI RADICAL MANKANGXI RADICAL LEGSKAN" +
	"GXI RADICAL ENTERKANGXI RADICAL EIGHTKANGXI RADICAL DOWN BOXKANGXI RADIC" +
	"AL COVERKANGXI RADICAL ICEKANGXI RADICAL TABLEKANGXI RADICAL OPEN BOXKAN" +
	"GXI RADICAL KNIFEKANGXI RADICAL POWERKANGXI RADICAL WRAPKANGXI RADICAL S" +
	"POONKANGXI RADICAL RIGHT OPEN BOXKANGXI RADICAL HIDING ENCLOSUREKANGXI R" +
	"ADICAL TENKANGXI RADICAL DIVINATIONKANGXI RADICAL SEALKANGXI RADICAL CLI" +
	"FFKANGXI RADICAL PRIVATEKANGXI RADICAL AGAINKANGXI RADICAL MOUTHKANGXI R" +
	"ADICAL ENCLOSUREKANGXI RADICAL EARTHKANGXI RADICAL SCHOLARKANGXI RADICAL" +
	" GOKANGXI RADICAL GO SLOWLYKANGXI RADICAL EVENINGKANGXI RADICAL BIGKANGX" +
	"I RADICAL WOMANKANGXI RADICAL CHILDKANGXI RADICAL ROOFKANGXI RADICAL INC" +
	"HKANGXI RADICAL SMALLKANGXI RADICAL LAMEKANGXI RADICAL CORPSEKANGXI RADI" +
	"CAL SPROUTKANGXI RADICAL MOUNTAINKANGXI RADICAL RIVERKANGXI RADICAL WORK" +
	"KANGXI RADICAL ONESELFKANGXI RADICAL TURBANKANGXI RADICAL DRYKANGXI RADI" +
	"CAL SHORT THREADKANGXI RADICAL DOTTED CLIFFKANGXI RADICAL LONG STRIDEKAN" +
	"GXI RADICAL TWO HANDSKANGXI RADICAL SHOOTKANGXI RADICAL BOWKANGXI RADICA" +
	"L SNOUTKANGXI RADICAL BRISTLEKANGXI RADICAL STEPKANGXI RADICAL HEARTKANG" +
	"XI RADICAL HALBERDKANGXI RADICAL DOORKANGXI RADICAL HANDKANGXI RADICAL B" +
	"RANCHKANGXI RADICAL RAPKANGXI RADICAL SCRIPTKANGXI RADICAL DIPPERKANGXI " +
	"RADICAL AXEKANGXI RADICAL SQUAREKANGXI RADICAL NOTKANGXI RADICAL SUNKANG" +
	"XI RADICAL SAYKANGXI RADICAL MOONKANGXI RADICAL TREEKANGXI RADICAL LACKK" +
	"ANGXI RADICAL STOPKANGXI RADICAL DEATHKANGXI RADICAL WEAPONKANGXI RADICA" +
	"L DO NOTKANGXI RADICAL COMPAREKANGXI RADICAL FURKANGXI RADICAL CLANKANGX" +
	"I RADICAL STEAMKANGXI RADICAL WATERKANGXI RADICAL FIREKANGXI RADICAL CLA" +
	"WKANGXI RADICAL FATHERKANGXI RADICAL DOUBLE XKANGXI RADICAL HALF TREE TR" +
	"UNKKANGXI RADICAL SLICEKANGXI RADICAL FANGKANGXI RADICAL COWKANGXI RADIC" +
	"AL DOGKANGXI RADICAL PROFOUNDKANGXI RADICAL JADEKANGXI RADICAL MELONKANG") + ("" +
	"XI RADICAL TILEKANGXI RADICAL SWEETKANGXI RADICAL LIFEKANGXI RADICAL USE" +
	"KANGXI RADICAL FIELDKANGXI RADICAL BOLT OF CLOTHKANGXI RADICAL SICKNESSK" +
	"ANGXI RADICAL DOTTED TENTKANGXI RADICAL WHITEKANGXI RADICAL SKINKANGXI R" +
	"ADICAL DISHKANGXI RADICAL EYEKANGXI RADICAL SPEARKANGXI RADICAL ARROWKAN" +
	"GXI RADICAL STONEKANGXI RADICAL SPIRITKANGXI RADICAL TRACKKANGXI RADICAL" +
	" GRAINKANGXI RADICAL CAVEKANGXI RADICAL STANDKANGXI RADICAL BAMBOOKANGXI" +
	" RADICAL RICEKANGXI RADICAL SILKKANGXI RADICAL JARKANGXI RADICAL NETKANG" +
	"XI RADICAL SHEEPKANGXI RADICAL FEATHERKANGXI RADICAL OLDKANGXI RADICAL A" +
	"NDKANGXI RADICAL PLOWKANGXI RADICAL EARKANGXI RADICAL BRUSHKANGXI RADICA" +
	"L MEATKANGXI RADICAL MINISTERKANGXI RADICAL SELFKANGXI RADICAL ARRIVEKAN" +
	"GXI RADICAL MORTARKANGXI RADICAL TONGUEKANGXI RADICAL OPPOSEKANGXI RADIC" +
	"AL BOATKANGXI RADICAL STOPPINGKANGXI RADICAL COLORKANGXI RADICAL GRASSKA" +
	"NGXI RADICAL TIGERKANGXI RADICAL INSECTKANGXI RADICAL BLOODKANGXI RADICA" +
	"L WALK ENCLOSUREKANGXI RADICAL CLOTHESKANGXI RADICAL WESTKANGXI RADICAL " +
	"SEEKANGXI RADICAL HORNKANGXI RADICAL SPEECHKANGXI RADICAL VALLEYKANGXI R" +
	"ADICAL BEANKANGXI RADICAL PIGKANGXI RADICAL BADGERKANGXI RADICAL SHELLKA" +
	"NGXI RADICAL REDKANGXI RADICAL RUNKANGXI RADICAL FOOTKANGXI RADICAL BODY" +
	"KANGXI RADICAL CARTKANGXI RADICAL BITTERKANGXI RADICAL MORNINGKANGXI RAD" +
	"ICAL WALKKANGXI RADICAL CITYKANGXI RADICAL WINEKANGXI RADICAL DISTINGUIS" +
	"HKANGXI RADICAL VILLAGEKANGXI RADICAL GOLDKANGXI RADICAL LONGKANGXI RADI" +
	"CAL GATEKANGXI RADICAL MOUNDKANGXI RADICAL SLAVEKANGXI RADICAL SHORT TAI" +
	"LED BIRDKANGXI RADICAL RAINKANGXI RADICAL BLUEKANGXI RADICAL WRONGKANGXI" +
	" RADICAL FACEKANGXI RADICAL LEATHERKANGXI RADICAL TANNED LEATHERKANGXI R" +
	"ADICAL LEEKKANGXI RADICAL SOUNDKANGXI RADICAL LEAFKANGXI RADICAL WINDKAN" +
	"GXI RADICAL FLYKANGXI RADICAL EATKANGXI RADICAL HEADKANGXI RADICAL FRAGR" +
	"ANTKANGXI RADICAL HORSEKANGXI RADICAL BONEKANGXI RADICAL TALLKANGXI RADI" +
	"CAL HAIRKANGXI RADICAL FIGHTKANGXI RADICAL SACRIFICIAL WINEKANGXI RADICA" +
	"L CAULDRONKANGXI RADICAL GHOSTKANGXI RADICAL FISHKANGXI RADICAL BIRDKANG" +
	"XI RADICAL SALTKANGXI RADICAL DEERKANGXI RADICAL WHEATKANGXI RADICAL HEM" +
	"PKANGXI RADICAL YELLOWKANGXI RADICAL MILLETKANGXI RADICAL BLACKKANGXI RA" +
	"DICAL EMBROIDERYKANGXI RADICAL FROGKANGXI RADICAL TRIPODKANGXI RADICAL D" +
	"RUMKANGXI RADICAL RATKANGXI RADICAL NOSEKANGXI RADICAL EVENKANGXI RADICA" +
	"L TOOTHKANGXI RADICAL DRAGONKANGXI RADICAL TURTLEKANGXI RADICAL FLUTEIDE" +
	"OGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHTIDEOGRAPHIC DESCRIPTION CHAR" +
	"ACTER ABOVE TO BELOWIDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO MIDDLE AND" +
	" RIGHTIDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BELOWIDEOGRA" +
	"PHIC DESCRIPTION CHARACTER FULL SURROUNDIDEOGRAPHIC DESCRIPTION CHARACTE" +
	"R SURROUND FROM ABOVEIDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM BEL" +
	"OWIDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFTIDEOGRAPHIC DESCRI" +
	"PTION CHARACTER SURROUND FROM UPPER LEFTIDEOGRAPHIC DESCRIPTION CHARACTE" +
	"R SURROUND FROM UPPER RIGHTIDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FR" +
	"OM LOWER LEFTIDEOGRAPHIC DESCRIPTION CHARACTER OVERLAIDIDEOGRAPHIC SPACE" +
	"IDEOGRAPHIC COMMAIDEOGRAPHIC FULL STOPDITTO MARKJAPANESE INDUSTRIAL STAN" +
	"DARD SYMBOLIDEOGRAPHIC ITERATION MARKIDEOGRAPHIC CLOSING MARKIDEOGRAPHIC" +
	" NUMBER ZEROLEFT ANGLE BRACKETRIGHT ANGLE BRACKETLEFT DOUBLE ANGLE BRACK" +
	"ETRIGHT DOUBLE ANGLE BRACKETLEFT CORNER BRACKETRIGHT CORNER BRACKETLEFT " +
	"WHITE CORNER BRACKETRIGHT WHITE CORNER BRACKETLEFT BLACK LENTICULAR BRAC" +
	"KETRIGHT BLACK LENTICULAR BRACKETPOSTAL MARKGETA MARKLEFT TORTOISE SHELL" +
	" BRACKETRIGHT TORTOISE SHELL BRACKETLEFT WHITE LENTICULAR BRACKETRIGHT W" +
	"HITE LENTICULAR BRACKETLEFT WHITE TORTOISE SHELL BRACKETRIGHT WHITE TORT" +
	"OISE SHELL BRACKETLEFT WHITE SQUARE BRACKETRIGHT WHITE SQUARE BRACKETWAV" +
	"E DASHREVERSED DOUBLE PRIME QUOTATION MARKDOUBLE PRIME QUOTATION MARKLOW" +
	" DOUBLE PRIME QUOTATION MARKPOSTAL MARK FACEHANGZHOU NUMERAL ONEHANGZHOU" +
	" NUMERAL TWOHANGZHOU NUMERAL THREEHANGZHOU NUMERAL FOURHANGZHOU NUMERAL " +
	"FIVEHANGZHOU NUMERAL SIXHANGZHOU NUMERAL SEVENHANGZHOU NUMERAL EIGHTHANG" +
	"ZHOU NUMERAL NINEIDEOGRAPHIC LEVEL TONE MARKIDEOGRAPHIC RISING TONE MARK" +
	"IDEOGRAPHIC DEPARTING TONE MARKIDEOGRAPHIC ENTERING TONE MARKHANGUL SING" +
	"LE DOT TONE MARKHANGUL DOUBLE DOT TONE MARKWAVY DASHVERTICAL KANA REPEAT" +
	" MARKVERTICAL KANA REPEAT WITH VOICED SOUND MARKVERTICAL KANA REPEAT MAR" +
	"K UPPER HALFVERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALFVERTIC" +
	"AL KANA REPEAT MARK LOWER HALFCIRCLED POSTAL MARKIDEOGRAPHIC TELEGRAPH L" +
	"INE FEED SEPARATOR SYMBOLHANGZHOU NUMERAL TENHANGZHOU NUMERAL TWENTYHANG" +
	"ZHOU NUMERAL THIRTYVERTICAL IDEOGRAPHIC ITERATION MARKMASU MARKPART ALTE" +
	"RNATION MARKIDEOGRAPHIC VARIATION INDICATORIDEOGRAPHIC HALF FILL SPACEHI") + ("" +
	"RAGANA LETTER SMALL AHIRAGANA LETTER AHIRAGANA LETTER SMALL IHIRAGANA LE" +
	"TTER IHIRAGANA LETTER SMALL UHIRAGANA LETTER UHIRAGANA LETTER SMALL EHIR" +
	"AGANA LETTER EHIRAGANA LETTER SMALL OHIRAGANA LETTER OHIRAGANA LETTER KA" +
	"HIRAGANA LETTER GAHIRAGANA LETTER KIHIRAGANA LETTER GIHIRAGANA LETTER KU" +
	"HIRAGANA LETTER GUHIRAGANA LETTER KEHIRAGANA LETTER GEHIRAGANA LETTER KO" +
	"HIRAGANA LETTER GOHIRAGANA LETTER SAHIRAGANA LETTER ZAHIRAGANA LETTER SI" +
	"HIRAGANA LETTER ZIHIRAGANA LETTER SUHIRAGANA LETTER ZUHIRAGANA LETTER SE" +
	"HIRAGANA LETTER ZEHIRAGANA LETTER SOHIRAGANA LETTER ZOHIRAGANA LETTER TA" +
	"HIRAGANA LETTER DAHIRAGANA LETTER TIHIRAGANA LETTER DIHIRAGANA LETTER SM" +
	"ALL TUHIRAGANA LETTER TUHIRAGANA LETTER DUHIRAGANA LETTER TEHIRAGANA LET" +
	"TER DEHIRAGANA LETTER TOHIRAGANA LETTER DOHIRAGANA LETTER NAHIRAGANA LET" +
	"TER NIHIRAGANA LETTER NUHIRAGANA LETTER NEHIRAGANA LETTER NOHIRAGANA LET" +
	"TER HAHIRAGANA LETTER BAHIRAGANA LETTER PAHIRAGANA LETTER HIHIRAGANA LET" +
	"TER BIHIRAGANA LETTER PIHIRAGANA LETTER HUHIRAGANA LETTER BUHIRAGANA LET" +
	"TER PUHIRAGANA LETTER HEHIRAGANA LETTER BEHIRAGANA LETTER PEHIRAGANA LET" +
	"TER HOHIRAGANA LETTER BOHIRAGANA LETTER POHIRAGANA LETTER MAHIRAGANA LET" +
	"TER MIHIRAGANA LETTER MUHIRAGANA LETTER MEHIRAGANA LETTER MOHIRAGANA LET" +
	"TER SMALL YAHIRAGANA LETTER YAHIRAGANA LETTER SMALL YUHIRAGANA LETTER YU" +
	"HIRAGANA LETTER SMALL YOHIRAGANA LETTER YOHIRAGANA LETTER RAHIRAGANA LET" +
	"TER RIHIRAGANA LETTER RUHIRAGANA LETTER REHIRAGANA LETTER ROHIRAGANA LET" +
	"TER SMALL WAHIRAGANA LETTER WAHIRAGANA LETTER WIHIRAGANA LETTER WEHIRAGA" +
	"NA LETTER WOHIRAGANA LETTER NHIRAGANA LETTER VUHIRAGANA LETTER SMALL KAH" +
	"IRAGANA LETTER SMALL KECOMBINING KATAKANA-HIRAGANA VOICED SOUND MARKCOMB" +
	"INING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARKKATAKANA-HIRAGANA VOICED S" +
	"OUND MARKKATAKANA-HIRAGANA SEMI-VOICED SOUND MARKHIRAGANA ITERATION MARK" +
	"HIRAGANA VOICED ITERATION MARKHIRAGANA DIGRAPH YORIKATAKANA-HIRAGANA DOU" +
	"BLE HYPHENKATAKANA LETTER SMALL AKATAKANA LETTER AKATAKANA LETTER SMALL " +
	"IKATAKANA LETTER IKATAKANA LETTER SMALL UKATAKANA LETTER UKATAKANA LETTE" +
	"R SMALL EKATAKANA LETTER EKATAKANA LETTER SMALL OKATAKANA LETTER OKATAKA" +
	"NA LETTER KAKATAKANA LETTER GAKATAKANA LETTER KIKATAKANA LETTER GIKATAKA" +
	"NA LETTER KUKATAKANA LETTER GUKATAKANA LETTER KEKATAKANA LETTER GEKATAKA" +
	"NA LETTER KOKATAKANA LETTER GOKATAKANA LETTER SAKATAKANA LETTER ZAKATAKA" +
	"NA LETTER SIKATAKANA LETTER ZIKATAKANA LETTER SUKATAKANA LETTER ZUKATAKA" +
	"NA LETTER SEKATAKANA LETTER ZEKATAKANA LETTER SOKATAKANA LETTER ZOKATAKA" +
	"NA LETTER TAKATAKANA LETTER DAKATAKANA LETTER TIKATAKANA LETTER DIKATAKA" +
	"NA LETTER SMALL TUKATAKANA LETTER TUKATAKANA LETTER DUKATAKANA LETTER TE" +
	"KATAKANA LETTER DEKATAKANA LETTER TOKATAKANA LETTER DOKATAKANA LETTER NA" +
	"KATAKANA LETTER NIKATAKANA LETTER NUKATAKANA LETTER NEKATAKANA LETTER NO" +
	"KATAKANA LETTER HAKATAKANA LETTER BAKATAKANA LETTER PAKATAKANA LETTER HI" +
	"KATAKANA LETTER BIKATAKANA LETTER PIKATAKANA LETTER HUKATAKANA LETTER BU" +
	"KATAKANA LETTER PUKATAKANA LETTER HEKATAKANA LETTER BEKATAKANA LETTER PE" +
	"KATAKANA LETTER HOKATAKANA LETTER BOKATAKANA LETTER POKATAKANA LETTER MA" +
	"KATAKANA LETTER MIKATAKANA LETTER MUKATAKANA LETTER MEKATAKANA LETTER MO" +
	"KATAKANA LETTER SMALL YAKATAKANA LETTER YAKATAKANA LETTER SMALL YUKATAKA" +
	"NA LETTER YUKATAKANA LETTER SMALL YOKATAKANA LETTER YOKATAKANA LETTER RA" +
	"KATAKANA LETTER RIKATAKANA LETTER RUKATAKANA LETTER REKATAKANA LETTER RO" +
	"KATAKANA LETTER SMALL WAKATAKANA LETTER WAKATAKANA LETTER WIKATAKANA LET" +
	"TER WEKATAKANA LETTER WOKATAKANA LETTER NKATAKANA LETTER VUKATAKANA LETT" +
	"ER SMALL KAKATAKANA LETTER SMALL KEKATAKANA LETTER VAKATAKANA LETTER VIK" +
	"ATAKANA LETTER VEKATAKANA LETTER VOKATAKANA MIDDLE DOTKATAKANA-HIRAGANA " +
	"PROLONGED SOUND MARKKATAKANA ITERATION MARKKATAKANA VOICED ITERATION MAR" +
	"KKATAKANA DIGRAPH KOTOBOPOMOFO LETTER BBOPOMOFO LETTER PBOPOMOFO LETTER " +
	"MBOPOMOFO LETTER FBOPOMOFO LETTER DBOPOMOFO LETTER TBOPOMOFO LETTER NBOP" +
	"OMOFO LETTER LBOPOMOFO LETTER GBOPOMOFO LETTER KBOPOMOFO LETTER HBOPOMOF" +
	"O LETTER JBOPOMOFO LETTER QBOPOMOFO LETTER XBOPOMOFO LETTER ZHBOPOMOFO L" +
	"ETTER CHBOPOMOFO LETTER SHBOPOMOFO LETTER RBOPOMOFO LETTER ZBOPOMOFO LET" +
	"TER CBOPOMOFO LETTER SBOPOMOFO LETTER ABOPOMOFO LETTER OBOPOMOFO LETTER " +
	"EBOPOMOFO LETTER EHBOPOMOFO LETTER AIBOPOMOFO LETTER EIBOPOMOFO LETTER A" +
	"UBOPOMOFO LETTER OUBOPOMOFO LETTER ANBOPOMOFO LETTER ENBOPOMOFO LETTER A" +
	"NGBOPOMOFO LETTER ENGBOPOMOFO LETTER ERBOPOMOFO LETTER IBOPOMOFO LETTER " +
	"UBOPOMOFO LETTER IUBOPOMOFO LETTER VBOPOMOFO LETTER NGBOPOMOFO LETTER GN" +
	"BOPOMOFO LETTER IHBOPOMOFO LETTER O WITH DOT ABOVEBOPOMOFO LETTER NNHANG" +
	"UL LETTER KIYEOKHANGUL LETTER SSANGKIYEOKHANGUL LETTER KIYEOK-SIOSHANGUL" +
	" LETTER NIEUNHANGUL LETTER NIEUN-CIEUCHANGUL LETTER NIEUN-HIEUHHANGUL LE") + ("" +
	"TTER TIKEUTHANGUL LETTER SSANGTIKEUTHANGUL LETTER RIEULHANGUL LETTER RIE" +
	"UL-KIYEOKHANGUL LETTER RIEUL-MIEUMHANGUL LETTER RIEUL-PIEUPHANGUL LETTER" +
	" RIEUL-SIOSHANGUL LETTER RIEUL-THIEUTHHANGUL LETTER RIEUL-PHIEUPHHANGUL " +
	"LETTER RIEUL-HIEUHHANGUL LETTER MIEUMHANGUL LETTER PIEUPHANGUL LETTER SS" +
	"ANGPIEUPHANGUL LETTER PIEUP-SIOSHANGUL LETTER SIOSHANGUL LETTER SSANGSIO" +
	"SHANGUL LETTER IEUNGHANGUL LETTER CIEUCHANGUL LETTER SSANGCIEUCHANGUL LE" +
	"TTER CHIEUCHHANGUL LETTER KHIEUKHHANGUL LETTER THIEUTHHANGUL LETTER PHIE" +
	"UPHHANGUL LETTER HIEUHHANGUL LETTER AHANGUL LETTER AEHANGUL LETTER YAHAN" +
	"GUL LETTER YAEHANGUL LETTER EOHANGUL LETTER EHANGUL LETTER YEOHANGUL LET" +
	"TER YEHANGUL LETTER OHANGUL LETTER WAHANGUL LETTER WAEHANGUL LETTER OEHA" +
	"NGUL LETTER YOHANGUL LETTER UHANGUL LETTER WEOHANGUL LETTER WEHANGUL LET" +
	"TER WIHANGUL LETTER YUHANGUL LETTER EUHANGUL LETTER YIHANGUL LETTER IHAN" +
	"GUL FILLERHANGUL LETTER SSANGNIEUNHANGUL LETTER NIEUN-TIKEUTHANGUL LETTE" +
	"R NIEUN-SIOSHANGUL LETTER NIEUN-PANSIOSHANGUL LETTER RIEUL-KIYEOK-SIOSHA" +
	"NGUL LETTER RIEUL-TIKEUTHANGUL LETTER RIEUL-PIEUP-SIOSHANGUL LETTER RIEU" +
	"L-PANSIOSHANGUL LETTER RIEUL-YEORINHIEUHHANGUL LETTER MIEUM-PIEUPHANGUL " +
	"LETTER MIEUM-SIOSHANGUL LETTER MIEUM-PANSIOSHANGUL LETTER KAPYEOUNMIEUMH" +
	"ANGUL LETTER PIEUP-KIYEOKHANGUL LETTER PIEUP-TIKEUTHANGUL LETTER PIEUP-S" +
	"IOS-KIYEOKHANGUL LETTER PIEUP-SIOS-TIKEUTHANGUL LETTER PIEUP-CIEUCHANGUL" +
	" LETTER PIEUP-THIEUTHHANGUL LETTER KAPYEOUNPIEUPHANGUL LETTER KAPYEOUNSS" +
	"ANGPIEUPHANGUL LETTER SIOS-KIYEOKHANGUL LETTER SIOS-NIEUNHANGUL LETTER S" +
	"IOS-TIKEUTHANGUL LETTER SIOS-PIEUPHANGUL LETTER SIOS-CIEUCHANGUL LETTER " +
	"PANSIOSHANGUL LETTER SSANGIEUNGHANGUL LETTER YESIEUNGHANGUL LETTER YESIE" +
	"UNG-SIOSHANGUL LETTER YESIEUNG-PANSIOSHANGUL LETTER KAPYEOUNPHIEUPHHANGU" +
	"L LETTER SSANGHIEUHHANGUL LETTER YEORINHIEUHHANGUL LETTER YO-YAHANGUL LE" +
	"TTER YO-YAEHANGUL LETTER YO-IHANGUL LETTER YU-YEOHANGUL LETTER YU-YEHANG" +
	"UL LETTER YU-IHANGUL LETTER ARAEAHANGUL LETTER ARAEAEIDEOGRAPHIC ANNOTAT" +
	"ION LINKING MARKIDEOGRAPHIC ANNOTATION REVERSE MARKIDEOGRAPHIC ANNOTATIO" +
	"N ONE MARKIDEOGRAPHIC ANNOTATION TWO MARKIDEOGRAPHIC ANNOTATION THREE MA" +
	"RKIDEOGRAPHIC ANNOTATION FOUR MARKIDEOGRAPHIC ANNOTATION TOP MARKIDEOGRA" +
	"PHIC ANNOTATION MIDDLE MARKIDEOGRAPHIC ANNOTATION BOTTOM MARKIDEOGRAPHIC" +
	" ANNOTATION FIRST MARKIDEOGRAPHIC ANNOTATION SECOND MARKIDEOGRAPHIC ANNO" +
	"TATION THIRD MARKIDEOGRAPHIC ANNOTATION FOURTH MARKIDEOGRAPHIC ANNOTATIO" +
	"N HEAVEN MARKIDEOGRAPHIC ANNOTATION EARTH MARKIDEOGRAPHIC ANNOTATION MAN" +
	" MARKBOPOMOFO LETTER BUBOPOMOFO LETTER ZIBOPOMOFO LETTER JIBOPOMOFO LETT" +
	"ER GUBOPOMOFO LETTER EEBOPOMOFO LETTER ENNBOPOMOFO LETTER OOBOPOMOFO LET" +
	"TER ONNBOPOMOFO LETTER IRBOPOMOFO LETTER ANNBOPOMOFO LETTER INNBOPOMOFO " +
	"LETTER UNNBOPOMOFO LETTER IMBOPOMOFO LETTER NGGBOPOMOFO LETTER AINNBOPOM" +
	"OFO LETTER AUNNBOPOMOFO LETTER AMBOPOMOFO LETTER OMBOPOMOFO LETTER ONGBO" +
	"POMOFO LETTER INNNBOPOMOFO FINAL LETTER PBOPOMOFO FINAL LETTER TBOPOMOFO" +
	" FINAL LETTER KBOPOMOFO FINAL LETTER HBOPOMOFO LETTER GHBOPOMOFO LETTER " +
	"LHBOPOMOFO LETTER ZYBOPOMOFO FINAL LETTER GBOPOMOFO LETTER GWBOPOMOFO LE" +
	"TTER KWBOPOMOFO LETTER OEBOPOMOFO LETTER AHCJK STROKE TCJK STROKE WGCJK " +
	"STROKE XGCJK STROKE BXGCJK STROKE SWCJK STROKE HZZCJK STROKE HZGCJK STRO" +
	"KE HPCJK STROKE HZWGCJK STROKE SZWGCJK STROKE HZTCJK STROKE HZZPCJK STRO" +
	"KE HPWGCJK STROKE HZWCJK STROKE HZZZCJK STROKE NCJK STROKE HCJK STROKE S" +
	"CJK STROKE PCJK STROKE SPCJK STROKE DCJK STROKE HZCJK STROKE HGCJK STROK" +
	"E SZCJK STROKE SWZCJK STROKE STCJK STROKE SGCJK STROKE PDCJK STROKE PZCJ" +
	"K STROKE TNCJK STROKE SZZCJK STROKE SWGCJK STROKE HXWGCJK STROKE HZZZGCJ" +
	"K STROKE PGCJK STROKE QKATAKANA LETTER SMALL KUKATAKANA LETTER SMALL SIK" +
	"ATAKANA LETTER SMALL SUKATAKANA LETTER SMALL TOKATAKANA LETTER SMALL NUK" +
	"ATAKANA LETTER SMALL HAKATAKANA LETTER SMALL HIKATAKANA LETTER SMALL HUK" +
	"ATAKANA LETTER SMALL HEKATAKANA LETTER SMALL HOKATAKANA LETTER SMALL MUK" +
	"ATAKANA LETTER SMALL RAKATAKANA LETTER SMALL RIKATAKANA LETTER SMALL RUK" +
	"ATAKANA LETTER SMALL REKATAKANA LETTER SMALL ROPARENTHESIZED HANGUL KIYE" +
	"OKPARENTHESIZED HANGUL NIEUNPARENTHESIZED HANGUL TIKEUTPARENTHESIZED HAN" +
	"GUL RIEULPARENTHESIZED HANGUL MIEUMPARENTHESIZED HANGUL PIEUPPARENTHESIZ" +
	"ED HANGUL SIOSPARENTHESIZED HANGUL IEUNGPARENTHESIZED HANGUL CIEUCPARENT" +
	"HESIZED HANGUL CHIEUCHPARENTHESIZED HANGUL KHIEUKHPARENTHESIZED HANGUL T" +
	"HIEUTHPARENTHESIZED HANGUL PHIEUPHPARENTHESIZED HANGUL HIEUHPARENTHESIZE" +
	"D HANGUL KIYEOK APARENTHESIZED HANGUL NIEUN APARENTHESIZED HANGUL TIKEUT" +
	" APARENTHESIZED HANGUL RIEUL APARENTHESIZED HANGUL MIEUM APARENTHESIZED " +
	"HANGUL PIEUP APARENTHESIZED HANGUL SIOS APARENTHESIZED HANGUL IEUNG APAR" +
	"ENTHESIZED HANGUL CIEUC APARENTHESIZED HANGUL CHIEUCH APARENTHESIZED HAN") + ("" +
	"GUL KHIEUKH APARENTHESIZED HANGUL THIEUTH APARENTHESIZED HANGUL PHIEUPH " +
	"APARENTHESIZED HANGUL HIEUH APARENTHESIZED HANGUL CIEUC UPARENTHESIZED K" +
	"OREAN CHARACTER OJEONPARENTHESIZED KOREAN CHARACTER O HUPARENTHESIZED ID" +
	"EOGRAPH ONEPARENTHESIZED IDEOGRAPH TWOPARENTHESIZED IDEOGRAPH THREEPAREN" +
	"THESIZED IDEOGRAPH FOURPARENTHESIZED IDEOGRAPH FIVEPARENTHESIZED IDEOGRA" +
	"PH SIXPARENTHESIZED IDEOGRAPH SEVENPARENTHESIZED IDEOGRAPH EIGHTPARENTHE" +
	"SIZED IDEOGRAPH NINEPARENTHESIZED IDEOGRAPH TENPARENTHESIZED IDEOGRAPH M" +
	"OONPARENTHESIZED IDEOGRAPH FIREPARENTHESIZED IDEOGRAPH WATERPARENTHESIZE" +
	"D IDEOGRAPH WOODPARENTHESIZED IDEOGRAPH METALPARENTHESIZED IDEOGRAPH EAR" +
	"THPARENTHESIZED IDEOGRAPH SUNPARENTHESIZED IDEOGRAPH STOCKPARENTHESIZED " +
	"IDEOGRAPH HAVEPARENTHESIZED IDEOGRAPH SOCIETYPARENTHESIZED IDEOGRAPH NAM" +
	"EPARENTHESIZED IDEOGRAPH SPECIALPARENTHESIZED IDEOGRAPH FINANCIALPARENTH" +
	"ESIZED IDEOGRAPH CONGRATULATIONPARENTHESIZED IDEOGRAPH LABORPARENTHESIZE" +
	"D IDEOGRAPH REPRESENTPARENTHESIZED IDEOGRAPH CALLPARENTHESIZED IDEOGRAPH" +
	" STUDYPARENTHESIZED IDEOGRAPH SUPERVISEPARENTHESIZED IDEOGRAPH ENTERPRIS" +
	"EPARENTHESIZED IDEOGRAPH RESOURCEPARENTHESIZED IDEOGRAPH ALLIANCEPARENTH" +
	"ESIZED IDEOGRAPH FESTIVALPARENTHESIZED IDEOGRAPH RESTPARENTHESIZED IDEOG" +
	"RAPH SELFPARENTHESIZED IDEOGRAPH REACHCIRCLED IDEOGRAPH QUESTIONCIRCLED " +
	"IDEOGRAPH KINDERGARTENCIRCLED IDEOGRAPH SCHOOLCIRCLED IDEOGRAPH KOTOCIRC" +
	"LED NUMBER TEN ON BLACK SQUARECIRCLED NUMBER TWENTY ON BLACK SQUARECIRCL" +
	"ED NUMBER THIRTY ON BLACK SQUARECIRCLED NUMBER FORTY ON BLACK SQUARECIRC" +
	"LED NUMBER FIFTY ON BLACK SQUARECIRCLED NUMBER SIXTY ON BLACK SQUARECIRC" +
	"LED NUMBER SEVENTY ON BLACK SQUARECIRCLED NUMBER EIGHTY ON BLACK SQUAREP" +
	"ARTNERSHIP SIGNCIRCLED NUMBER TWENTY ONECIRCLED NUMBER TWENTY TWOCIRCLED" +
	" NUMBER TWENTY THREECIRCLED NUMBER TWENTY FOURCIRCLED NUMBER TWENTY FIVE" +
	"CIRCLED NUMBER TWENTY SIXCIRCLED NUMBER TWENTY SEVENCIRCLED NUMBER TWENT" +
	"Y EIGHTCIRCLED NUMBER TWENTY NINECIRCLED NUMBER THIRTYCIRCLED NUMBER THI" +
	"RTY ONECIRCLED NUMBER THIRTY TWOCIRCLED NUMBER THIRTY THREECIRCLED NUMBE" +
	"R THIRTY FOURCIRCLED NUMBER THIRTY FIVECIRCLED HANGUL KIYEOKCIRCLED HANG" +
	"UL NIEUNCIRCLED HANGUL TIKEUTCIRCLED HANGUL RIEULCIRCLED HANGUL MIEUMCIR" +
	"CLED HANGUL PIEUPCIRCLED HANGUL SIOSCIRCLED HANGUL IEUNGCIRCLED HANGUL C" +
	"IEUCCIRCLED HANGUL CHIEUCHCIRCLED HANGUL KHIEUKHCIRCLED HANGUL THIEUTHCI" +
	"RCLED HANGUL PHIEUPHCIRCLED HANGUL HIEUHCIRCLED HANGUL KIYEOK ACIRCLED H" +
	"ANGUL NIEUN ACIRCLED HANGUL TIKEUT ACIRCLED HANGUL RIEUL ACIRCLED HANGUL" +
	" MIEUM ACIRCLED HANGUL PIEUP ACIRCLED HANGUL SIOS ACIRCLED HANGUL IEUNG " +
	"ACIRCLED HANGUL CIEUC ACIRCLED HANGUL CHIEUCH ACIRCLED HANGUL KHIEUKH AC" +
	"IRCLED HANGUL THIEUTH ACIRCLED HANGUL PHIEUPH ACIRCLED HANGUL HIEUH ACIR" +
	"CLED KOREAN CHARACTER CHAMKOCIRCLED KOREAN CHARACTER JUEUICIRCLED HANGUL" +
	" IEUNG UKOREAN STANDARD SYMBOLCIRCLED IDEOGRAPH ONECIRCLED IDEOGRAPH TWO" +
	"CIRCLED IDEOGRAPH THREECIRCLED IDEOGRAPH FOURCIRCLED IDEOGRAPH FIVECIRCL" +
	"ED IDEOGRAPH SIXCIRCLED IDEOGRAPH SEVENCIRCLED IDEOGRAPH EIGHTCIRCLED ID" +
	"EOGRAPH NINECIRCLED IDEOGRAPH TENCIRCLED IDEOGRAPH MOONCIRCLED IDEOGRAPH" +
	" FIRECIRCLED IDEOGRAPH WATERCIRCLED IDEOGRAPH WOODCIRCLED IDEOGRAPH META" +
	"LCIRCLED IDEOGRAPH EARTHCIRCLED IDEOGRAPH SUNCIRCLED IDEOGRAPH STOCKCIRC" +
	"LED IDEOGRAPH HAVECIRCLED IDEOGRAPH SOCIETYCIRCLED IDEOGRAPH NAMECIRCLED" +
	" IDEOGRAPH SPECIALCIRCLED IDEOGRAPH FINANCIALCIRCLED IDEOGRAPH CONGRATUL" +
	"ATIONCIRCLED IDEOGRAPH LABORCIRCLED IDEOGRAPH SECRETCIRCLED IDEOGRAPH MA" +
	"LECIRCLED IDEOGRAPH FEMALECIRCLED IDEOGRAPH SUITABLECIRCLED IDEOGRAPH EX" +
	"CELLENTCIRCLED IDEOGRAPH PRINTCIRCLED IDEOGRAPH ATTENTIONCIRCLED IDEOGRA" +
	"PH ITEMCIRCLED IDEOGRAPH RESTCIRCLED IDEOGRAPH COPYCIRCLED IDEOGRAPH COR" +
	"RECTCIRCLED IDEOGRAPH HIGHCIRCLED IDEOGRAPH CENTRECIRCLED IDEOGRAPH LOWC" +
	"IRCLED IDEOGRAPH LEFTCIRCLED IDEOGRAPH RIGHTCIRCLED IDEOGRAPH MEDICINECI" +
	"RCLED IDEOGRAPH RELIGIONCIRCLED IDEOGRAPH STUDYCIRCLED IDEOGRAPH SUPERVI" +
	"SECIRCLED IDEOGRAPH ENTERPRISECIRCLED IDEOGRAPH RESOURCECIRCLED IDEOGRAP" +
	"H ALLIANCECIRCLED IDEOGRAPH NIGHTCIRCLED NUMBER THIRTY SIXCIRCLED NUMBER" +
	" THIRTY SEVENCIRCLED NUMBER THIRTY EIGHTCIRCLED NUMBER THIRTY NINECIRCLE" +
	"D NUMBER FORTYCIRCLED NUMBER FORTY ONECIRCLED NUMBER FORTY TWOCIRCLED NU" +
	"MBER FORTY THREECIRCLED NUMBER FORTY FOURCIRCLED NUMBER FORTY FIVECIRCLE" +
	"D NUMBER FORTY SIXCIRCLED NUMBER FORTY SEVENCIRCLED NUMBER FORTY EIGHTCI" +
	"RCLED NUMBER FORTY NINECIRCLED NUMBER FIFTYIDEOGRAPHIC TELEGRAPH SYMBOL " +
	"FOR JANUARYIDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARYIDEOGRAPHIC TELEGRAP" +
	"H SYMBOL FOR MARCHIDEOGRAPHIC TELEGRAPH SYMBOL FOR APRILIDEOGRAPHIC TELE" +
	"GRAPH SYMBOL FOR MAYIDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNEIDEOGRAPHIC TEL" +
	"EGRAPH SYMBOL FOR JULYIDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUSTIDEOGRAPHIC") + ("" +
	" TELEGRAPH SYMBOL FOR SEPTEMBERIDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBERI" +
	"DEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBERIDEOGRAPHIC TELEGRAPH SYMBOL FOR" +
	" DECEMBERSQUARE HGSQUARE ERGSQUARE EVLIMITED LIABILITY SIGNCIRCLED KATAK" +
	"ANA ACIRCLED KATAKANA ICIRCLED KATAKANA UCIRCLED KATAKANA ECIRCLED KATAK" +
	"ANA OCIRCLED KATAKANA KACIRCLED KATAKANA KICIRCLED KATAKANA KUCIRCLED KA" +
	"TAKANA KECIRCLED KATAKANA KOCIRCLED KATAKANA SACIRCLED KATAKANA SICIRCLE" +
	"D KATAKANA SUCIRCLED KATAKANA SECIRCLED KATAKANA SOCIRCLED KATAKANA TACI" +
	"RCLED KATAKANA TICIRCLED KATAKANA TUCIRCLED KATAKANA TECIRCLED KATAKANA " +
	"TOCIRCLED KATAKANA NACIRCLED KATAKANA NICIRCLED KATAKANA NUCIRCLED KATAK" +
	"ANA NECIRCLED KATAKANA NOCIRCLED KATAKANA HACIRCLED KATAKANA HICIRCLED K" +
	"ATAKANA HUCIRCLED KATAKANA HECIRCLED KATAKANA HOCIRCLED KATAKANA MACIRCL" +
	"ED KATAKANA MICIRCLED KATAKANA MUCIRCLED KATAKANA MECIRCLED KATAKANA MOC" +
	"IRCLED KATAKANA YACIRCLED KATAKANA YUCIRCLED KATAKANA YOCIRCLED KATAKANA" +
	" RACIRCLED KATAKANA RICIRCLED KATAKANA RUCIRCLED KATAKANA RECIRCLED KATA" +
	"KANA ROCIRCLED KATAKANA WACIRCLED KATAKANA WICIRCLED KATAKANA WECIRCLED " +
	"KATAKANA WOSQUARE ERA NAME REIWASQUARE APAATOSQUARE ARUHUASQUARE ANPEASQ" +
	"UARE AARUSQUARE ININGUSQUARE INTISQUARE UONSQUARE ESUKUUDOSQUARE EEKAASQ" +
	"UARE ONSUSQUARE OOMUSQUARE KAIRISQUARE KARATTOSQUARE KARORIISQUARE GARON" +
	"SQUARE GANMASQUARE GIGASQUARE GINIISQUARE KYURIISQUARE GIRUDAASQUARE KIR" +
	"OSQUARE KIROGURAMUSQUARE KIROMEETORUSQUARE KIROWATTOSQUARE GURAMUSQUARE " +
	"GURAMUTONSQUARE KURUZEIROSQUARE KUROONESQUARE KEESUSQUARE KORUNASQUARE K" +
	"OOPOSQUARE SAIKURUSQUARE SANTIIMUSQUARE SIRINGUSQUARE SENTISQUARE SENTOS" +
	"QUARE DAASUSQUARE DESISQUARE DORUSQUARE TONSQUARE NANOSQUARE NOTTOSQUARE" +
	" HAITUSQUARE PAASENTOSQUARE PAATUSQUARE BAARERUSQUARE PIASUTORUSQUARE PI" +
	"KURUSQUARE PIKOSQUARE BIRUSQUARE HUARADDOSQUARE HUIITOSQUARE BUSSYERUSQU" +
	"ARE HURANSQUARE HEKUTAARUSQUARE PESOSQUARE PENIHISQUARE HERUTUSQUARE PEN" +
	"SUSQUARE PEEZISQUARE BEETASQUARE POINTOSQUARE BORUTOSQUARE HONSQUARE PON" +
	"DOSQUARE HOORUSQUARE HOONSQUARE MAIKUROSQUARE MAIRUSQUARE MAHHASQUARE MA" +
	"RUKUSQUARE MANSYONSQUARE MIKURONSQUARE MIRISQUARE MIRIBAARUSQUARE MEGASQ" +
	"UARE MEGATONSQUARE MEETORUSQUARE YAADOSQUARE YAARUSQUARE YUANSQUARE RITT" +
	"ORUSQUARE RIRASQUARE RUPIISQUARE RUUBURUSQUARE REMUSQUARE RENTOGENSQUARE" +
	" WATTOIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZEROIDEOGRAPHIC TELEGRAPH SY" +
	"MBOL FOR HOUR ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWOIDEOGRAPHIC TE" +
	"LEGRAPH SYMBOL FOR HOUR THREEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURI" +
	"DEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVEIDEOGRAPHIC TELEGRAPH SYMBOL FO" +
	"R HOUR SIXIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENIDEOGRAPHIC TELEGRA" +
	"PH SYMBOL FOR HOUR EIGHTIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINEIDEOGR" +
	"APHIC TELEGRAPH SYMBOL FOR HOUR TENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR" +
	" ELEVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVEIDEOGRAPHIC TELEGRAPH" +
	" SYMBOL FOR HOUR THIRTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEENI" +
	"DEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEENIDEOGRAPHIC TELEGRAPH SYMBOL" +
	" FOR HOUR SIXTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEENIDEOGRAP" +
	"HIC TELEGRAPH SYMBOL FOR HOUR EIGHTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR H" +
	"OUR NINETEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTYIDEOGRAPHIC TELE" +
	"GRAPH SYMBOL FOR HOUR TWENTY-ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TW" +
	"ENTY-TWOIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREEIDEOGRAPHIC TE" +
	"LEGRAPH SYMBOL FOR HOUR TWENTY-FOURSQUARE HPASQUARE DASQUARE AUSQUARE BA" +
	"RSQUARE OVSQUARE PCSQUARE DMSQUARE DM SQUAREDSQUARE DM CUBEDSQUARE IUSQU" +
	"ARE ERA NAME HEISEISQUARE ERA NAME SYOUWASQUARE ERA NAME TAISYOUSQUARE E" +
	"RA NAME MEIZISQUARE CORPORATIONSQUARE PA AMPSSQUARE NASQUARE MU ASQUARE " +
	"MASQUARE KASQUARE KBSQUARE MBSQUARE GBSQUARE CALSQUARE KCALSQUARE PFSQUA" +
	"RE NFSQUARE MU FSQUARE MU GSQUARE MGSQUARE KGSQUARE HZSQUARE KHZSQUARE M" +
	"HZSQUARE GHZSQUARE THZSQUARE MU LSQUARE MLSQUARE DLSQUARE KLSQUARE FMSQU" +
	"ARE NMSQUARE MU MSQUARE MMSQUARE CMSQUARE KMSQUARE MM SQUAREDSQUARE CM S" +
	"QUAREDSQUARE M SQUAREDSQUARE KM SQUAREDSQUARE MM CUBEDSQUARE CM CUBEDSQU" +
	"ARE M CUBEDSQUARE KM CUBEDSQUARE M OVER SSQUARE M OVER S SQUAREDSQUARE P" +
	"ASQUARE KPASQUARE MPASQUARE GPASQUARE RADSQUARE RAD OVER SSQUARE RAD OVE" +
	"R S SQUAREDSQUARE PSSQUARE NSSQUARE MU SSQUARE MSSQUARE PVSQUARE NVSQUAR" +
	"E MU VSQUARE MVSQUARE KVSQUARE MV MEGASQUARE PWSQUARE NWSQUARE MU WSQUAR" +
	"E MWSQUARE KWSQUARE MW MEGASQUARE K OHMSQUARE M OHMSQUARE AMSQUARE BQSQU" +
	"ARE CCSQUARE CDSQUARE C OVER KGSQUARE COSQUARE DBSQUARE GYSQUARE HASQUAR" +
	"E HPSQUARE INSQUARE KKSQUARE KM CAPITALSQUARE KTSQUARE LMSQUARE LNSQUARE" +
	" LOGSQUARE LXSQUARE MB SMALLSQUARE MILSQUARE MOLSQUARE PHSQUARE PMSQUARE" +
	" PPMSQUARE PRSQUARE SRSQUARE SVSQUARE WBSQUARE V OVER MSQUARE A OVER MID") + ("" +
	"EOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR D" +
	"AY TWOIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREEIDEOGRAPHIC TELEGRAPH SY" +
	"MBOL FOR DAY FOURIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVEIDEOGRAPHIC TE" +
	"LEGRAPH SYMBOL FOR DAY SIXIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENIDEO" +
	"GRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTIDEOGRAPHIC TELEGRAPH SYMBOL FOR D" +
	"AY NINEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TENIDEOGRAPHIC TELEGRAPH SYM" +
	"BOL FOR DAY ELEVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVEIDEOGRAPHIC" +
	" TELEGRAPH SYMBOL FOR DAY THIRTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY F" +
	"OURTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEENIDEOGRAPHIC TELEGRAPH" +
	" SYMBOL FOR DAY SIXTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEENIDE" +
	"OGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEENIDEOGRAPHIC TELEGRAPH SYMBOL F" +
	"OR DAY NINETEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTYIDEOGRAPHIC TE" +
	"LEGRAPH SYMBOL FOR DAY TWENTY-ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TW" +
	"ENTY-TWOIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREEIDEOGRAPHIC TEL" +
	"EGRAPH SYMBOL FOR DAY TWENTY-FOURIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TW" +
	"ENTY-FIVEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIXIDEOGRAPHIC TELE" +
	"GRAPH SYMBOL FOR DAY TWENTY-SEVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TW" +
	"ENTY-EIGHTIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINEIDEOGRAPHIC TE" +
	"LEGRAPH SYMBOL FOR DAY THIRTYIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY" +
	"-ONESQUARE GALHEXAGRAM FOR THE CREATIVE HEAVENHEXAGRAM FOR THE RECEPTIVE" +
	" EARTHHEXAGRAM FOR DIFFICULTY AT THE BEGINNINGHEXAGRAM FOR YOUTHFUL FOLL" +
	"YHEXAGRAM FOR WAITINGHEXAGRAM FOR CONFLICTHEXAGRAM FOR THE ARMYHEXAGRAM " +
	"FOR HOLDING TOGETHERHEXAGRAM FOR SMALL TAMINGHEXAGRAM FOR TREADINGHEXAGR" +
	"AM FOR PEACEHEXAGRAM FOR STANDSTILLHEXAGRAM FOR FELLOWSHIPHEXAGRAM FOR G" +
	"REAT POSSESSIONHEXAGRAM FOR MODESTYHEXAGRAM FOR ENTHUSIASMHEXAGRAM FOR F" +
	"OLLOWINGHEXAGRAM FOR WORK ON THE DECAYEDHEXAGRAM FOR APPROACHHEXAGRAM FO" +
	"R CONTEMPLATIONHEXAGRAM FOR BITING THROUGHHEXAGRAM FOR GRACEHEXAGRAM FOR" +
	" SPLITTING APARTHEXAGRAM FOR RETURNHEXAGRAM FOR INNOCENCEHEXAGRAM FOR GR" +
	"EAT TAMINGHEXAGRAM FOR MOUTH CORNERSHEXAGRAM FOR GREAT PREPONDERANCEHEXA" +
	"GRAM FOR THE ABYSMAL WATERHEXAGRAM FOR THE CLINGING FIREHEXAGRAM FOR INF" +
	"LUENCEHEXAGRAM FOR DURATIONHEXAGRAM FOR RETREATHEXAGRAM FOR GREAT POWERH" +
	"EXAGRAM FOR PROGRESSHEXAGRAM FOR DARKENING OF THE LIGHTHEXAGRAM FOR THE " +
	"FAMILYHEXAGRAM FOR OPPOSITIONHEXAGRAM FOR OBSTRUCTIONHEXAGRAM FOR DELIVE" +
	"RANCEHEXAGRAM FOR DECREASEHEXAGRAM FOR INCREASEHEXAGRAM FOR BREAKTHROUGH" +
	"HEXAGRAM FOR COMING TO MEETHEXAGRAM FOR GATHERING TOGETHERHEXAGRAM FOR P" +
	"USHING UPWARDHEXAGRAM FOR OPPRESSIONHEXAGRAM FOR THE WELLHEXAGRAM FOR RE" +
	"VOLUTIONHEXAGRAM FOR THE CAULDRONHEXAGRAM FOR THE AROUSING THUNDERHEXAGR" +
	"AM FOR THE KEEPING STILL MOUNTAINHEXAGRAM FOR DEVELOPMENTHEXAGRAM FOR TH" +
	"E MARRYING MAIDENHEXAGRAM FOR ABUNDANCEHEXAGRAM FOR THE WANDERERHEXAGRAM" +
	" FOR THE GENTLE WINDHEXAGRAM FOR THE JOYOUS LAKEHEXAGRAM FOR DISPERSIONH" +
	"EXAGRAM FOR LIMITATIONHEXAGRAM FOR INNER TRUTHHEXAGRAM FOR SMALL PREPOND" +
	"ERANCEHEXAGRAM FOR AFTER COMPLETIONHEXAGRAM FOR BEFORE COMPLETIONYI SYLL" +
	"ABLE ITYI SYLLABLE IXYI SYLLABLE IYI SYLLABLE IPYI SYLLABLE IETYI SYLLAB" +
	"LE IEXYI SYLLABLE IEYI SYLLABLE IEPYI SYLLABLE ATYI SYLLABLE AXYI SYLLAB" +
	"LE AYI SYLLABLE APYI SYLLABLE UOXYI SYLLABLE UOYI SYLLABLE UOPYI SYLLABL" +
	"E OTYI SYLLABLE OXYI SYLLABLE OYI SYLLABLE OPYI SYLLABLE EXYI SYLLABLE E" +
	"YI SYLLABLE WUYI SYLLABLE BITYI SYLLABLE BIXYI SYLLABLE BIYI SYLLABLE BI" +
	"PYI SYLLABLE BIETYI SYLLABLE BIEXYI SYLLABLE BIEYI SYLLABLE BIEPYI SYLLA" +
	"BLE BATYI SYLLABLE BAXYI SYLLABLE BAYI SYLLABLE BAPYI SYLLABLE BUOXYI SY" +
	"LLABLE BUOYI SYLLABLE BUOPYI SYLLABLE BOTYI SYLLABLE BOXYI SYLLABLE BOYI" +
	" SYLLABLE BOPYI SYLLABLE BEXYI SYLLABLE BEYI SYLLABLE BEPYI SYLLABLE BUT" +
	"YI SYLLABLE BUXYI SYLLABLE BUYI SYLLABLE BUPYI SYLLABLE BURXYI SYLLABLE " +
	"BURYI SYLLABLE BYTYI SYLLABLE BYXYI SYLLABLE BYYI SYLLABLE BYPYI SYLLABL" +
	"E BYRXYI SYLLABLE BYRYI SYLLABLE PITYI SYLLABLE PIXYI SYLLABLE PIYI SYLL" +
	"ABLE PIPYI SYLLABLE PIEXYI SYLLABLE PIEYI SYLLABLE PIEPYI SYLLABLE PATYI" +
	" SYLLABLE PAXYI SYLLABLE PAYI SYLLABLE PAPYI SYLLABLE PUOXYI SYLLABLE PU" +
	"OYI SYLLABLE PUOPYI SYLLABLE POTYI SYLLABLE POXYI SYLLABLE POYI SYLLABLE" +
	" POPYI SYLLABLE PUTYI SYLLABLE PUXYI SYLLABLE PUYI SYLLABLE PUPYI SYLLAB" +
	"LE PURXYI SYLLABLE PURYI SYLLABLE PYTYI SYLLABLE PYXYI SYLLABLE PYYI SYL" +
	"LABLE PYPYI SYLLABLE PYRXYI SYLLABLE PYRYI SYLLABLE BBITYI SYLLABLE BBIX" +
	"YI SYLLABLE BBIYI SYLLABLE BBIPYI SYLLABLE BBIETYI SYLLABLE BBIEXYI SYLL" +
	"ABLE BBIEYI SYLLABLE BBIEPYI SYLLABLE BBATYI SYLLABLE BBAXYI SYLLABLE BB" +
	"AYI SYLLABLE BBAPYI SYLLABLE BBUOXYI SYLLABLE BBUOYI SYLLABLE BBUOPYI SY" +
	"LLABLE BBOTYI SYLLABLE BBOXYI SYLLABLE BBOYI SYLLABLE BBOPYI SYLLABLE BB") + ("" +
	"EXYI SYLLABLE BBEYI SYLLABLE BBEPYI SYLLABLE BBUTYI SYLLABLE BBUXYI SYLL" +
	"ABLE BBUYI SYLLABLE BBUPYI SYLLABLE BBURXYI SYLLABLE BBURYI SYLLABLE BBY" +
	"TYI SYLLABLE BBYXYI SYLLABLE BBYYI SYLLABLE BBYPYI SYLLABLE NBITYI SYLLA" +
	"BLE NBIXYI SYLLABLE NBIYI SYLLABLE NBIPYI SYLLABLE NBIEXYI SYLLABLE NBIE" +
	"YI SYLLABLE NBIEPYI SYLLABLE NBATYI SYLLABLE NBAXYI SYLLABLE NBAYI SYLLA" +
	"BLE NBAPYI SYLLABLE NBOTYI SYLLABLE NBOXYI SYLLABLE NBOYI SYLLABLE NBOPY" +
	"I SYLLABLE NBUTYI SYLLABLE NBUXYI SYLLABLE NBUYI SYLLABLE NBUPYI SYLLABL" +
	"E NBURXYI SYLLABLE NBURYI SYLLABLE NBYTYI SYLLABLE NBYXYI SYLLABLE NBYYI" +
	" SYLLABLE NBYPYI SYLLABLE NBYRXYI SYLLABLE NBYRYI SYLLABLE HMITYI SYLLAB" +
	"LE HMIXYI SYLLABLE HMIYI SYLLABLE HMIPYI SYLLABLE HMIEXYI SYLLABLE HMIEY" +
	"I SYLLABLE HMIEPYI SYLLABLE HMATYI SYLLABLE HMAXYI SYLLABLE HMAYI SYLLAB" +
	"LE HMAPYI SYLLABLE HMUOXYI SYLLABLE HMUOYI SYLLABLE HMUOPYI SYLLABLE HMO" +
	"TYI SYLLABLE HMOXYI SYLLABLE HMOYI SYLLABLE HMOPYI SYLLABLE HMUTYI SYLLA" +
	"BLE HMUXYI SYLLABLE HMUYI SYLLABLE HMUPYI SYLLABLE HMURXYI SYLLABLE HMUR" +
	"YI SYLLABLE HMYXYI SYLLABLE HMYYI SYLLABLE HMYPYI SYLLABLE HMYRXYI SYLLA" +
	"BLE HMYRYI SYLLABLE MITYI SYLLABLE MIXYI SYLLABLE MIYI SYLLABLE MIPYI SY" +
	"LLABLE MIEXYI SYLLABLE MIEYI SYLLABLE MIEPYI SYLLABLE MATYI SYLLABLE MAX" +
	"YI SYLLABLE MAYI SYLLABLE MAPYI SYLLABLE MUOTYI SYLLABLE MUOXYI SYLLABLE" +
	" MUOYI SYLLABLE MUOPYI SYLLABLE MOTYI SYLLABLE MOXYI SYLLABLE MOYI SYLLA" +
	"BLE MOPYI SYLLABLE MEXYI SYLLABLE MEYI SYLLABLE MUTYI SYLLABLE MUXYI SYL" +
	"LABLE MUYI SYLLABLE MUPYI SYLLABLE MURXYI SYLLABLE MURYI SYLLABLE MYTYI " +
	"SYLLABLE MYXYI SYLLABLE MYYI SYLLABLE MYPYI SYLLABLE FITYI SYLLABLE FIXY" +
	"I SYLLABLE FIYI SYLLABLE FIPYI SYLLABLE FATYI SYLLABLE FAXYI SYLLABLE FA" +
	"YI SYLLABLE FAPYI SYLLABLE FOXYI SYLLABLE FOYI SYLLABLE FOPYI SYLLABLE F" +
	"UTYI SYLLABLE FUXYI SYLLABLE FUYI SYLLABLE FUPYI SYLLABLE FURXYI SYLLABL" +
	"E FURYI SYLLABLE FYTYI SYLLABLE FYXYI SYLLABLE FYYI SYLLABLE FYPYI SYLLA" +
	"BLE VITYI SYLLABLE VIXYI SYLLABLE VIYI SYLLABLE VIPYI SYLLABLE VIETYI SY" +
	"LLABLE VIEXYI SYLLABLE VIEYI SYLLABLE VIEPYI SYLLABLE VATYI SYLLABLE VAX" +
	"YI SYLLABLE VAYI SYLLABLE VAPYI SYLLABLE VOTYI SYLLABLE VOXYI SYLLABLE V" +
	"OYI SYLLABLE VOPYI SYLLABLE VEXYI SYLLABLE VEPYI SYLLABLE VUTYI SYLLABLE" +
	" VUXYI SYLLABLE VUYI SYLLABLE VUPYI SYLLABLE VURXYI SYLLABLE VURYI SYLLA" +
	"BLE VYTYI SYLLABLE VYXYI SYLLABLE VYYI SYLLABLE VYPYI SYLLABLE VYRXYI SY" +
	"LLABLE VYRYI SYLLABLE DITYI SYLLABLE DIXYI SYLLABLE DIYI SYLLABLE DIPYI " +
	"SYLLABLE DIEXYI SYLLABLE DIEYI SYLLABLE DIEPYI SYLLABLE DATYI SYLLABLE D" +
	"AXYI SYLLABLE DAYI SYLLABLE DAPYI SYLLABLE DUOXYI SYLLABLE DUOYI SYLLABL" +
	"E DOTYI SYLLABLE DOXYI SYLLABLE DOYI SYLLABLE DOPYI SYLLABLE DEXYI SYLLA" +
	"BLE DEYI SYLLABLE DEPYI SYLLABLE DUTYI SYLLABLE DUXYI SYLLABLE DUYI SYLL" +
	"ABLE DUPYI SYLLABLE DURXYI SYLLABLE DURYI SYLLABLE TITYI SYLLABLE TIXYI " +
	"SYLLABLE TIYI SYLLABLE TIPYI SYLLABLE TIEXYI SYLLABLE TIEYI SYLLABLE TIE" +
	"PYI SYLLABLE TATYI SYLLABLE TAXYI SYLLABLE TAYI SYLLABLE TAPYI SYLLABLE " +
	"TUOTYI SYLLABLE TUOXYI SYLLABLE TUOYI SYLLABLE TUOPYI SYLLABLE TOTYI SYL" +
	"LABLE TOXYI SYLLABLE TOYI SYLLABLE TOPYI SYLLABLE TEXYI SYLLABLE TEYI SY" +
	"LLABLE TEPYI SYLLABLE TUTYI SYLLABLE TUXYI SYLLABLE TUYI SYLLABLE TUPYI " +
	"SYLLABLE TURXYI SYLLABLE TURYI SYLLABLE DDITYI SYLLABLE DDIXYI SYLLABLE " +
	"DDIYI SYLLABLE DDIPYI SYLLABLE DDIEXYI SYLLABLE DDIEYI SYLLABLE DDIEPYI " +
	"SYLLABLE DDATYI SYLLABLE DDAXYI SYLLABLE DDAYI SYLLABLE DDAPYI SYLLABLE " +
	"DDUOXYI SYLLABLE DDUOYI SYLLABLE DDUOPYI SYLLABLE DDOTYI SYLLABLE DDOXYI" +
	" SYLLABLE DDOYI SYLLABLE DDOPYI SYLLABLE DDEXYI SYLLABLE DDEYI SYLLABLE " +
	"DDEPYI SYLLABLE DDUTYI SYLLABLE DDUXYI SYLLABLE DDUYI SYLLABLE DDUPYI SY" +
	"LLABLE DDURXYI SYLLABLE DDURYI SYLLABLE NDITYI SYLLABLE NDIXYI SYLLABLE " +
	"NDIYI SYLLABLE NDIPYI SYLLABLE NDIEXYI SYLLABLE NDIEYI SYLLABLE NDATYI S" +
	"YLLABLE NDAXYI SYLLABLE NDAYI SYLLABLE NDAPYI SYLLABLE NDOTYI SYLLABLE N" +
	"DOXYI SYLLABLE NDOYI SYLLABLE NDOPYI SYLLABLE NDEXYI SYLLABLE NDEYI SYLL" +
	"ABLE NDEPYI SYLLABLE NDUTYI SYLLABLE NDUXYI SYLLABLE NDUYI SYLLABLE NDUP" +
	"YI SYLLABLE NDURXYI SYLLABLE NDURYI SYLLABLE HNITYI SYLLABLE HNIXYI SYLL" +
	"ABLE HNIYI SYLLABLE HNIPYI SYLLABLE HNIETYI SYLLABLE HNIEXYI SYLLABLE HN" +
	"IEYI SYLLABLE HNIEPYI SYLLABLE HNATYI SYLLABLE HNAXYI SYLLABLE HNAYI SYL" +
	"LABLE HNAPYI SYLLABLE HNUOXYI SYLLABLE HNUOYI SYLLABLE HNOTYI SYLLABLE H" +
	"NOXYI SYLLABLE HNOPYI SYLLABLE HNEXYI SYLLABLE HNEYI SYLLABLE HNEPYI SYL" +
	"LABLE HNUTYI SYLLABLE NITYI SYLLABLE NIXYI SYLLABLE NIYI SYLLABLE NIPYI " +
	"SYLLABLE NIEXYI SYLLABLE NIEYI SYLLABLE NIEPYI SYLLABLE NAXYI SYLLABLE N" +
	"AYI SYLLABLE NAPYI SYLLABLE NUOXYI SYLLABLE NUOYI SYLLABLE NUOPYI SYLLAB" +
	"LE NOTYI SYLLABLE NOXYI SYLLABLE NOYI SYLLABLE NOPYI SYLLABLE NEXYI SYLL" +
	"ABLE NEYI SYLLABLE NEPYI SYLLABLE NUTYI SYLLABLE NUXYI SYLLABLE NUYI SYL") + ("" +
	"LABLE NUPYI SYLLABLE NURXYI SYLLABLE NURYI SYLLABLE HLITYI SYLLABLE HLIX" +
	"YI SYLLABLE HLIYI SYLLABLE HLIPYI SYLLABLE HLIEXYI SYLLABLE HLIEYI SYLLA" +
	"BLE HLIEPYI SYLLABLE HLATYI SYLLABLE HLAXYI SYLLABLE HLAYI SYLLABLE HLAP" +
	"YI SYLLABLE HLUOXYI SYLLABLE HLUOYI SYLLABLE HLUOPYI SYLLABLE HLOXYI SYL" +
	"LABLE HLOYI SYLLABLE HLOPYI SYLLABLE HLEXYI SYLLABLE HLEYI SYLLABLE HLEP" +
	"YI SYLLABLE HLUTYI SYLLABLE HLUXYI SYLLABLE HLUYI SYLLABLE HLUPYI SYLLAB" +
	"LE HLURXYI SYLLABLE HLURYI SYLLABLE HLYTYI SYLLABLE HLYXYI SYLLABLE HLYY" +
	"I SYLLABLE HLYPYI SYLLABLE HLYRXYI SYLLABLE HLYRYI SYLLABLE LITYI SYLLAB" +
	"LE LIXYI SYLLABLE LIYI SYLLABLE LIPYI SYLLABLE LIETYI SYLLABLE LIEXYI SY" +
	"LLABLE LIEYI SYLLABLE LIEPYI SYLLABLE LATYI SYLLABLE LAXYI SYLLABLE LAYI" +
	" SYLLABLE LAPYI SYLLABLE LUOTYI SYLLABLE LUOXYI SYLLABLE LUOYI SYLLABLE " +
	"LUOPYI SYLLABLE LOTYI SYLLABLE LOXYI SYLLABLE LOYI SYLLABLE LOPYI SYLLAB" +
	"LE LEXYI SYLLABLE LEYI SYLLABLE LEPYI SYLLABLE LUTYI SYLLABLE LUXYI SYLL" +
	"ABLE LUYI SYLLABLE LUPYI SYLLABLE LURXYI SYLLABLE LURYI SYLLABLE LYTYI S" +
	"YLLABLE LYXYI SYLLABLE LYYI SYLLABLE LYPYI SYLLABLE LYRXYI SYLLABLE LYRY" +
	"I SYLLABLE GITYI SYLLABLE GIXYI SYLLABLE GIYI SYLLABLE GIPYI SYLLABLE GI" +
	"ETYI SYLLABLE GIEXYI SYLLABLE GIEYI SYLLABLE GIEPYI SYLLABLE GATYI SYLLA" +
	"BLE GAXYI SYLLABLE GAYI SYLLABLE GAPYI SYLLABLE GUOTYI SYLLABLE GUOXYI S" +
	"YLLABLE GUOYI SYLLABLE GUOPYI SYLLABLE GOTYI SYLLABLE GOXYI SYLLABLE GOY" +
	"I SYLLABLE GOPYI SYLLABLE GETYI SYLLABLE GEXYI SYLLABLE GEYI SYLLABLE GE" +
	"PYI SYLLABLE GUTYI SYLLABLE GUXYI SYLLABLE GUYI SYLLABLE GUPYI SYLLABLE " +
	"GURXYI SYLLABLE GURYI SYLLABLE KITYI SYLLABLE KIXYI SYLLABLE KIYI SYLLAB" +
	"LE KIPYI SYLLABLE KIEXYI SYLLABLE KIEYI SYLLABLE KIEPYI SYLLABLE KATYI S" +
	"YLLABLE KAXYI SYLLABLE KAYI SYLLABLE KAPYI SYLLABLE KUOXYI SYLLABLE KUOY" +
	"I SYLLABLE KUOPYI SYLLABLE KOTYI SYLLABLE KOXYI SYLLABLE KOYI SYLLABLE K" +
	"OPYI SYLLABLE KETYI SYLLABLE KEXYI SYLLABLE KEYI SYLLABLE KEPYI SYLLABLE" +
	" KUTYI SYLLABLE KUXYI SYLLABLE KUYI SYLLABLE KUPYI SYLLABLE KURXYI SYLLA" +
	"BLE KURYI SYLLABLE GGITYI SYLLABLE GGIXYI SYLLABLE GGIYI SYLLABLE GGIEXY" +
	"I SYLLABLE GGIEYI SYLLABLE GGIEPYI SYLLABLE GGATYI SYLLABLE GGAXYI SYLLA" +
	"BLE GGAYI SYLLABLE GGAPYI SYLLABLE GGUOTYI SYLLABLE GGUOXYI SYLLABLE GGU" +
	"OYI SYLLABLE GGUOPYI SYLLABLE GGOTYI SYLLABLE GGOXYI SYLLABLE GGOYI SYLL" +
	"ABLE GGOPYI SYLLABLE GGETYI SYLLABLE GGEXYI SYLLABLE GGEYI SYLLABLE GGEP" +
	"YI SYLLABLE GGUTYI SYLLABLE GGUXYI SYLLABLE GGUYI SYLLABLE GGUPYI SYLLAB" +
	"LE GGURXYI SYLLABLE GGURYI SYLLABLE MGIEXYI SYLLABLE MGIEYI SYLLABLE MGA" +
	"TYI SYLLABLE MGAXYI SYLLABLE MGAYI SYLLABLE MGAPYI SYLLABLE MGUOXYI SYLL" +
	"ABLE MGUOYI SYLLABLE MGUOPYI SYLLABLE MGOTYI SYLLABLE MGOXYI SYLLABLE MG" +
	"OYI SYLLABLE MGOPYI SYLLABLE MGEXYI SYLLABLE MGEYI SYLLABLE MGEPYI SYLLA" +
	"BLE MGUTYI SYLLABLE MGUXYI SYLLABLE MGUYI SYLLABLE MGUPYI SYLLABLE MGURX" +
	"YI SYLLABLE MGURYI SYLLABLE HXITYI SYLLABLE HXIXYI SYLLABLE HXIYI SYLLAB" +
	"LE HXIPYI SYLLABLE HXIETYI SYLLABLE HXIEXYI SYLLABLE HXIEYI SYLLABLE HXI" +
	"EPYI SYLLABLE HXATYI SYLLABLE HXAXYI SYLLABLE HXAYI SYLLABLE HXAPYI SYLL" +
	"ABLE HXUOTYI SYLLABLE HXUOXYI SYLLABLE HXUOYI SYLLABLE HXUOPYI SYLLABLE " +
	"HXOTYI SYLLABLE HXOXYI SYLLABLE HXOYI SYLLABLE HXOPYI SYLLABLE HXEXYI SY" +
	"LLABLE HXEYI SYLLABLE HXEPYI SYLLABLE NGIEXYI SYLLABLE NGIEYI SYLLABLE N" +
	"GIEPYI SYLLABLE NGATYI SYLLABLE NGAXYI SYLLABLE NGAYI SYLLABLE NGAPYI SY" +
	"LLABLE NGUOTYI SYLLABLE NGUOXYI SYLLABLE NGUOYI SYLLABLE NGOTYI SYLLABLE" +
	" NGOXYI SYLLABLE NGOYI SYLLABLE NGOPYI SYLLABLE NGEXYI SYLLABLE NGEYI SY" +
	"LLABLE NGEPYI SYLLABLE HITYI SYLLABLE HIEXYI SYLLABLE HIEYI SYLLABLE HAT" +
	"YI SYLLABLE HAXYI SYLLABLE HAYI SYLLABLE HAPYI SYLLABLE HUOTYI SYLLABLE " +
	"HUOXYI SYLLABLE HUOYI SYLLABLE HUOPYI SYLLABLE HOTYI SYLLABLE HOXYI SYLL" +
	"ABLE HOYI SYLLABLE HOPYI SYLLABLE HEXYI SYLLABLE HEYI SYLLABLE HEPYI SYL" +
	"LABLE WATYI SYLLABLE WAXYI SYLLABLE WAYI SYLLABLE WAPYI SYLLABLE WUOXYI " +
	"SYLLABLE WUOYI SYLLABLE WUOPYI SYLLABLE WOXYI SYLLABLE WOYI SYLLABLE WOP" +
	"YI SYLLABLE WEXYI SYLLABLE WEYI SYLLABLE WEPYI SYLLABLE ZITYI SYLLABLE Z" +
	"IXYI SYLLABLE ZIYI SYLLABLE ZIPYI SYLLABLE ZIEXYI SYLLABLE ZIEYI SYLLABL" +
	"E ZIEPYI SYLLABLE ZATYI SYLLABLE ZAXYI SYLLABLE ZAYI SYLLABLE ZAPYI SYLL" +
	"ABLE ZUOXYI SYLLABLE ZUOYI SYLLABLE ZUOPYI SYLLABLE ZOTYI SYLLABLE ZOXYI" +
	" SYLLABLE ZOYI SYLLABLE ZOPYI SYLLABLE ZEXYI SYLLABLE ZEYI SYLLABLE ZEPY" +
	"I SYLLABLE ZUTYI SYLLABLE ZUXYI SYLLABLE ZUYI SYLLABLE ZUPYI SYLLABLE ZU" +
	"RXYI SYLLABLE ZURYI SYLLABLE ZYTYI SYLLABLE ZYXYI SYLLABLE ZYYI SYLLABLE" +
	" ZYPYI SYLLABLE ZYRXYI SYLLABLE ZYRYI SYLLABLE CITYI SYLLABLE CIXYI SYLL" +
	"ABLE CIYI SYLLABLE CIPYI SYLLABLE CIETYI SYLLABLE CIEXYI SYLLABLE CIEYI " +
	"SYLLABLE CIEPYI SYLLABLE CATYI SYLLABLE CAXYI SYLLABLE CAYI SYLLABLE CAP" +
	"YI SYLLABLE CUOXYI SYLLABLE CUOYI SYLLABLE CUOPYI SYLLABLE COTYI SYLLABL") + ("" +
	"E COXYI SYLLABLE COYI SYLLABLE COPYI SYLLABLE CEXYI SYLLABLE CEYI SYLLAB" +
	"LE CEPYI SYLLABLE CUTYI SYLLABLE CUXYI SYLLABLE CUYI SYLLABLE CUPYI SYLL" +
	"ABLE CURXYI SYLLABLE CURYI SYLLABLE CYTYI SYLLABLE CYXYI SYLLABLE CYYI S" +
	"YLLABLE CYPYI SYLLABLE CYRXYI SYLLABLE CYRYI SYLLABLE ZZITYI SYLLABLE ZZ" +
	"IXYI SYLLABLE ZZIYI SYLLABLE ZZIPYI SYLLABLE ZZIETYI SYLLABLE ZZIEXYI SY" +
	"LLABLE ZZIEYI SYLLABLE ZZIEPYI SYLLABLE ZZATYI SYLLABLE ZZAXYI SYLLABLE " +
	"ZZAYI SYLLABLE ZZAPYI SYLLABLE ZZOXYI SYLLABLE ZZOYI SYLLABLE ZZOPYI SYL" +
	"LABLE ZZEXYI SYLLABLE ZZEYI SYLLABLE ZZEPYI SYLLABLE ZZUXYI SYLLABLE ZZU" +
	"YI SYLLABLE ZZUPYI SYLLABLE ZZURXYI SYLLABLE ZZURYI SYLLABLE ZZYTYI SYLL" +
	"ABLE ZZYXYI SYLLABLE ZZYYI SYLLABLE ZZYPYI SYLLABLE ZZYRXYI SYLLABLE ZZY" +
	"RYI SYLLABLE NZITYI SYLLABLE NZIXYI SYLLABLE NZIYI SYLLABLE NZIPYI SYLLA" +
	"BLE NZIEXYI SYLLABLE NZIEYI SYLLABLE NZIEPYI SYLLABLE NZATYI SYLLABLE NZ" +
	"AXYI SYLLABLE NZAYI SYLLABLE NZAPYI SYLLABLE NZUOXYI SYLLABLE NZUOYI SYL" +
	"LABLE NZOXYI SYLLABLE NZOPYI SYLLABLE NZEXYI SYLLABLE NZEYI SYLLABLE NZU" +
	"XYI SYLLABLE NZUYI SYLLABLE NZUPYI SYLLABLE NZURXYI SYLLABLE NZURYI SYLL" +
	"ABLE NZYTYI SYLLABLE NZYXYI SYLLABLE NZYYI SYLLABLE NZYPYI SYLLABLE NZYR" +
	"XYI SYLLABLE NZYRYI SYLLABLE SITYI SYLLABLE SIXYI SYLLABLE SIYI SYLLABLE" +
	" SIPYI SYLLABLE SIEXYI SYLLABLE SIEYI SYLLABLE SIEPYI SYLLABLE SATYI SYL" +
	"LABLE SAXYI SYLLABLE SAYI SYLLABLE SAPYI SYLLABLE SUOXYI SYLLABLE SUOYI " +
	"SYLLABLE SUOPYI SYLLABLE SOTYI SYLLABLE SOXYI SYLLABLE SOYI SYLLABLE SOP" +
	"YI SYLLABLE SEXYI SYLLABLE SEYI SYLLABLE SEPYI SYLLABLE SUTYI SYLLABLE S" +
	"UXYI SYLLABLE SUYI SYLLABLE SUPYI SYLLABLE SURXYI SYLLABLE SURYI SYLLABL" +
	"E SYTYI SYLLABLE SYXYI SYLLABLE SYYI SYLLABLE SYPYI SYLLABLE SYRXYI SYLL" +
	"ABLE SYRYI SYLLABLE SSITYI SYLLABLE SSIXYI SYLLABLE SSIYI SYLLABLE SSIPY" +
	"I SYLLABLE SSIEXYI SYLLABLE SSIEYI SYLLABLE SSIEPYI SYLLABLE SSATYI SYLL" +
	"ABLE SSAXYI SYLLABLE SSAYI SYLLABLE SSAPYI SYLLABLE SSOTYI SYLLABLE SSOX" +
	"YI SYLLABLE SSOYI SYLLABLE SSOPYI SYLLABLE SSEXYI SYLLABLE SSEYI SYLLABL" +
	"E SSEPYI SYLLABLE SSUTYI SYLLABLE SSUXYI SYLLABLE SSUYI SYLLABLE SSUPYI " +
	"SYLLABLE SSYTYI SYLLABLE SSYXYI SYLLABLE SSYYI SYLLABLE SSYPYI SYLLABLE " +
	"SSYRXYI SYLLABLE SSYRYI SYLLABLE ZHATYI SYLLABLE ZHAXYI SYLLABLE ZHAYI S" +
	"YLLABLE ZHAPYI SYLLABLE ZHUOXYI SYLLABLE ZHUOYI SYLLABLE ZHUOPYI SYLLABL" +
	"E ZHOTYI SYLLABLE ZHOXYI SYLLABLE ZHOYI SYLLABLE ZHOPYI SYLLABLE ZHETYI " +
	"SYLLABLE ZHEXYI SYLLABLE ZHEYI SYLLABLE ZHEPYI SYLLABLE ZHUTYI SYLLABLE " +
	"ZHUXYI SYLLABLE ZHUYI SYLLABLE ZHUPYI SYLLABLE ZHURXYI SYLLABLE ZHURYI S" +
	"YLLABLE ZHYTYI SYLLABLE ZHYXYI SYLLABLE ZHYYI SYLLABLE ZHYPYI SYLLABLE Z" +
	"HYRXYI SYLLABLE ZHYRYI SYLLABLE CHATYI SYLLABLE CHAXYI SYLLABLE CHAYI SY" +
	"LLABLE CHAPYI SYLLABLE CHUOTYI SYLLABLE CHUOXYI SYLLABLE CHUOYI SYLLABLE" +
	" CHUOPYI SYLLABLE CHOTYI SYLLABLE CHOXYI SYLLABLE CHOYI SYLLABLE CHOPYI " +
	"SYLLABLE CHETYI SYLLABLE CHEXYI SYLLABLE CHEYI SYLLABLE CHEPYI SYLLABLE " +
	"CHUXYI SYLLABLE CHUYI SYLLABLE CHUPYI SYLLABLE CHURXYI SYLLABLE CHURYI S" +
	"YLLABLE CHYTYI SYLLABLE CHYXYI SYLLABLE CHYYI SYLLABLE CHYPYI SYLLABLE C" +
	"HYRXYI SYLLABLE CHYRYI SYLLABLE RRAXYI SYLLABLE RRAYI SYLLABLE RRUOXYI S" +
	"YLLABLE RRUOYI SYLLABLE RROTYI SYLLABLE RROXYI SYLLABLE RROYI SYLLABLE R" +
	"ROPYI SYLLABLE RRETYI SYLLABLE RREXYI SYLLABLE RREYI SYLLABLE RREPYI SYL" +
	"LABLE RRUTYI SYLLABLE RRUXYI SYLLABLE RRUYI SYLLABLE RRUPYI SYLLABLE RRU" +
	"RXYI SYLLABLE RRURYI SYLLABLE RRYTYI SYLLABLE RRYXYI SYLLABLE RRYYI SYLL" +
	"ABLE RRYPYI SYLLABLE RRYRXYI SYLLABLE RRYRYI SYLLABLE NRATYI SYLLABLE NR" +
	"AXYI SYLLABLE NRAYI SYLLABLE NRAPYI SYLLABLE NROXYI SYLLABLE NROYI SYLLA" +
	"BLE NROPYI SYLLABLE NRETYI SYLLABLE NREXYI SYLLABLE NREYI SYLLABLE NREPY" +
	"I SYLLABLE NRUTYI SYLLABLE NRUXYI SYLLABLE NRUYI SYLLABLE NRUPYI SYLLABL" +
	"E NRURXYI SYLLABLE NRURYI SYLLABLE NRYTYI SYLLABLE NRYXYI SYLLABLE NRYYI" +
	" SYLLABLE NRYPYI SYLLABLE NRYRXYI SYLLABLE NRYRYI SYLLABLE SHATYI SYLLAB" +
	"LE SHAXYI SYLLABLE SHAYI SYLLABLE SHAPYI SYLLABLE SHUOXYI SYLLABLE SHUOY" +
	"I SYLLABLE SHUOPYI SYLLABLE SHOTYI SYLLABLE SHOXYI SYLLABLE SHOYI SYLLAB" +
	"LE SHOPYI SYLLABLE SHETYI SYLLABLE SHEXYI SYLLABLE SHEYI SYLLABLE SHEPYI" +
	" SYLLABLE SHUTYI SYLLABLE SHUXYI SYLLABLE SHUYI SYLLABLE SHUPYI SYLLABLE" +
	" SHURXYI SYLLABLE SHURYI SYLLABLE SHYTYI SYLLABLE SHYXYI SYLLABLE SHYYI " +
	"SYLLABLE SHYPYI SYLLABLE SHYRXYI SYLLABLE SHYRYI SYLLABLE RATYI SYLLABLE" +
	" RAXYI SYLLABLE RAYI SYLLABLE RAPYI SYLLABLE RUOXYI SYLLABLE RUOYI SYLLA" +
	"BLE RUOPYI SYLLABLE ROTYI SYLLABLE ROXYI SYLLABLE ROYI SYLLABLE ROPYI SY" +
	"LLABLE REXYI SYLLABLE REYI SYLLABLE REPYI SYLLABLE RUTYI SYLLABLE RUXYI " +
	"SYLLABLE RUYI SYLLABLE RUPYI SYLLABLE RURXYI SYLLABLE RURYI SYLLABLE RYT" +
	"YI SYLLABLE RYXYI SYLLABLE RYYI SYLLABLE RYPYI SYLLABLE RYRXYI SYLLABLE " +
	"RYRYI SYLLABLE JITYI SYLLABLE JIXYI SYLLABLE JIYI SYLLABLE JIPYI SYLLABL") + ("" +
	"E JIETYI SYLLABLE JIEXYI SYLLABLE JIEYI SYLLABLE JIEPYI SYLLABLE JUOTYI " +
	"SYLLABLE JUOXYI SYLLABLE JUOYI SYLLABLE JUOPYI SYLLABLE JOTYI SYLLABLE J" +
	"OXYI SYLLABLE JOYI SYLLABLE JOPYI SYLLABLE JUTYI SYLLABLE JUXYI SYLLABLE" +
	" JUYI SYLLABLE JUPYI SYLLABLE JURXYI SYLLABLE JURYI SYLLABLE JYTYI SYLLA" +
	"BLE JYXYI SYLLABLE JYYI SYLLABLE JYPYI SYLLABLE JYRXYI SYLLABLE JYRYI SY" +
	"LLABLE QITYI SYLLABLE QIXYI SYLLABLE QIYI SYLLABLE QIPYI SYLLABLE QIETYI" +
	" SYLLABLE QIEXYI SYLLABLE QIEYI SYLLABLE QIEPYI SYLLABLE QUOTYI SYLLABLE" +
	" QUOXYI SYLLABLE QUOYI SYLLABLE QUOPYI SYLLABLE QOTYI SYLLABLE QOXYI SYL" +
	"LABLE QOYI SYLLABLE QOPYI SYLLABLE QUTYI SYLLABLE QUXYI SYLLABLE QUYI SY" +
	"LLABLE QUPYI SYLLABLE QURXYI SYLLABLE QURYI SYLLABLE QYTYI SYLLABLE QYXY" +
	"I SYLLABLE QYYI SYLLABLE QYPYI SYLLABLE QYRXYI SYLLABLE QYRYI SYLLABLE J" +
	"JITYI SYLLABLE JJIXYI SYLLABLE JJIYI SYLLABLE JJIPYI SYLLABLE JJIETYI SY" +
	"LLABLE JJIEXYI SYLLABLE JJIEYI SYLLABLE JJIEPYI SYLLABLE JJUOXYI SYLLABL" +
	"E JJUOYI SYLLABLE JJUOPYI SYLLABLE JJOTYI SYLLABLE JJOXYI SYLLABLE JJOYI" +
	" SYLLABLE JJOPYI SYLLABLE JJUTYI SYLLABLE JJUXYI SYLLABLE JJUYI SYLLABLE" +
	" JJUPYI SYLLABLE JJURXYI SYLLABLE JJURYI SYLLABLE JJYTYI SYLLABLE JJYXYI" +
	" SYLLABLE JJYYI SYLLABLE JJYPYI SYLLABLE NJITYI SYLLABLE NJIXYI SYLLABLE" +
	" NJIYI SYLLABLE NJIPYI SYLLABLE NJIETYI SYLLABLE NJIEXYI SYLLABLE NJIEYI" +
	" SYLLABLE NJIEPYI SYLLABLE NJUOXYI SYLLABLE NJUOYI SYLLABLE NJOTYI SYLLA" +
	"BLE NJOXYI SYLLABLE NJOYI SYLLABLE NJOPYI SYLLABLE NJUXYI SYLLABLE NJUYI" +
	" SYLLABLE NJUPYI SYLLABLE NJURXYI SYLLABLE NJURYI SYLLABLE NJYTYI SYLLAB" +
	"LE NJYXYI SYLLABLE NJYYI SYLLABLE NJYPYI SYLLABLE NJYRXYI SYLLABLE NJYRY" +
	"I SYLLABLE NYITYI SYLLABLE NYIXYI SYLLABLE NYIYI SYLLABLE NYIPYI SYLLABL" +
	"E NYIETYI SYLLABLE NYIEXYI SYLLABLE NYIEYI SYLLABLE NYIEPYI SYLLABLE NYU" +
	"OXYI SYLLABLE NYUOYI SYLLABLE NYUOPYI SYLLABLE NYOTYI SYLLABLE NYOXYI SY" +
	"LLABLE NYOYI SYLLABLE NYOPYI SYLLABLE NYUTYI SYLLABLE NYUXYI SYLLABLE NY" +
	"UYI SYLLABLE NYUPYI SYLLABLE XITYI SYLLABLE XIXYI SYLLABLE XIYI SYLLABLE" +
	" XIPYI SYLLABLE XIETYI SYLLABLE XIEXYI SYLLABLE XIEYI SYLLABLE XIEPYI SY" +
	"LLABLE XUOXYI SYLLABLE XUOYI SYLLABLE XOTYI SYLLABLE XOXYI SYLLABLE XOYI" +
	" SYLLABLE XOPYI SYLLABLE XYTYI SYLLABLE XYXYI SYLLABLE XYYI SYLLABLE XYP" +
	"YI SYLLABLE XYRXYI SYLLABLE XYRYI SYLLABLE YITYI SYLLABLE YIXYI SYLLABLE" +
	" YIYI SYLLABLE YIPYI SYLLABLE YIETYI SYLLABLE YIEXYI SYLLABLE YIEYI SYLL" +
	"ABLE YIEPYI SYLLABLE YUOTYI SYLLABLE YUOXYI SYLLABLE YUOYI SYLLABLE YUOP" +
	"YI SYLLABLE YOTYI SYLLABLE YOXYI SYLLABLE YOYI SYLLABLE YOPYI SYLLABLE Y" +
	"UTYI SYLLABLE YUXYI SYLLABLE YUYI SYLLABLE YUPYI SYLLABLE YURXYI SYLLABL" +
	"E YURYI SYLLABLE YYTYI SYLLABLE YYXYI SYLLABLE YYYI SYLLABLE YYPYI SYLLA" +
	"BLE YYRXYI SYLLABLE YYRYI RADICAL QOTYI RADICAL LIYI RADICAL KITYI RADIC" +
	"AL NYIPYI RADICAL CYPYI RADICAL SSIYI RADICAL GGOPYI RADICAL GEPYI RADIC" +
	"AL MIYI RADICAL HXITYI RADICAL LYRYI RADICAL BBUTYI RADICAL MOPYI RADICA" +
	"L YOYI RADICAL PUTYI RADICAL HXUOYI RADICAL TATYI RADICAL GAYI RADICAL Z" +
	"UPYI RADICAL CYTYI RADICAL DDURYI RADICAL BURYI RADICAL GGUOYI RADICAL N" +
	"YOPYI RADICAL TUYI RADICAL OPYI RADICAL JJUTYI RADICAL ZOTYI RADICAL PYT" +
	"YI RADICAL HMOYI RADICAL YITYI RADICAL VURYI RADICAL SHYYI RADICAL VEPYI" +
	" RADICAL ZAYI RADICAL JOYI RADICAL NZUPYI RADICAL JJYYI RADICAL GOTYI RA" +
	"DICAL JJIEYI RADICAL WOYI RADICAL DUYI RADICAL SHURYI RADICAL LIEYI RADI" +
	"CAL CYYI RADICAL CUOPYI RADICAL CIPYI RADICAL HXOPYI RADICAL SHATYI RADI" +
	"CAL ZURYI RADICAL SHOPYI RADICAL CHEYI RADICAL ZZIETYI RADICAL NBIEYI RA" +
	"DICAL KELISU LETTER BALISU LETTER PALISU LETTER PHALISU LETTER DALISU LE" +
	"TTER TALISU LETTER THALISU LETTER GALISU LETTER KALISU LETTER KHALISU LE" +
	"TTER JALISU LETTER CALISU LETTER CHALISU LETTER DZALISU LETTER TSALISU L" +
	"ETTER TSHALISU LETTER MALISU LETTER NALISU LETTER LALISU LETTER SALISU L" +
	"ETTER ZHALISU LETTER ZALISU LETTER NGALISU LETTER HALISU LETTER XALISU L" +
	"ETTER HHALISU LETTER FALISU LETTER WALISU LETTER SHALISU LETTER YALISU L" +
	"ETTER GHALISU LETTER ALISU LETTER AELISU LETTER ELISU LETTER EULISU LETT" +
	"ER ILISU LETTER OLISU LETTER ULISU LETTER UELISU LETTER UHLISU LETTER OE" +
	"LISU LETTER TONE MYA TILISU LETTER TONE NA POLISU LETTER TONE MYA CYALIS" +
	"U LETTER TONE MYA BOLISU LETTER TONE MYA NALISU LETTER TONE MYA JEULISU " +
	"PUNCTUATION COMMALISU PUNCTUATION FULL STOPVAI SYLLABLE EEVAI SYLLABLE E" +
	"ENVAI SYLLABLE HEEVAI SYLLABLE WEEVAI SYLLABLE WEENVAI SYLLABLE PEEVAI S" +
	"YLLABLE BHEEVAI SYLLABLE BEEVAI SYLLABLE MBEEVAI SYLLABLE KPEEVAI SYLLAB" +
	"LE MGBEEVAI SYLLABLE GBEEVAI SYLLABLE FEEVAI SYLLABLE VEEVAI SYLLABLE TE" +
	"EVAI SYLLABLE THEEVAI SYLLABLE DHEEVAI SYLLABLE DHHEEVAI SYLLABLE LEEVAI" +
	" SYLLABLE REEVAI SYLLABLE DEEVAI SYLLABLE NDEEVAI SYLLABLE SEEVAI SYLLAB" +
	"LE SHEEVAI SYLLABLE ZEEVAI SYLLABLE ZHEEVAI SYLLABLE CEEVAI SYLLABLE JEE") + ("" +
	"VAI SYLLABLE NJEEVAI SYLLABLE YEEVAI SYLLABLE KEEVAI SYLLABLE NGGEEVAI S" +
	"YLLABLE GEEVAI SYLLABLE MEEVAI SYLLABLE NEEVAI SYLLABLE NYEEVAI SYLLABLE" +
	" IVAI SYLLABLE INVAI SYLLABLE HIVAI SYLLABLE HINVAI SYLLABLE WIVAI SYLLA" +
	"BLE WINVAI SYLLABLE PIVAI SYLLABLE BHIVAI SYLLABLE BIVAI SYLLABLE MBIVAI" +
	" SYLLABLE KPIVAI SYLLABLE MGBIVAI SYLLABLE GBIVAI SYLLABLE FIVAI SYLLABL" +
	"E VIVAI SYLLABLE TIVAI SYLLABLE THIVAI SYLLABLE DHIVAI SYLLABLE DHHIVAI " +
	"SYLLABLE LIVAI SYLLABLE RIVAI SYLLABLE DIVAI SYLLABLE NDIVAI SYLLABLE SI" +
	"VAI SYLLABLE SHIVAI SYLLABLE ZIVAI SYLLABLE ZHIVAI SYLLABLE CIVAI SYLLAB" +
	"LE JIVAI SYLLABLE NJIVAI SYLLABLE YIVAI SYLLABLE KIVAI SYLLABLE NGGIVAI " +
	"SYLLABLE GIVAI SYLLABLE MIVAI SYLLABLE NIVAI SYLLABLE NYIVAI SYLLABLE AV" +
	"AI SYLLABLE ANVAI SYLLABLE NGANVAI SYLLABLE HAVAI SYLLABLE HANVAI SYLLAB" +
	"LE WAVAI SYLLABLE WANVAI SYLLABLE PAVAI SYLLABLE BHAVAI SYLLABLE BAVAI S" +
	"YLLABLE MBAVAI SYLLABLE KPAVAI SYLLABLE KPANVAI SYLLABLE MGBAVAI SYLLABL" +
	"E GBAVAI SYLLABLE FAVAI SYLLABLE VAVAI SYLLABLE TAVAI SYLLABLE THAVAI SY" +
	"LLABLE DHAVAI SYLLABLE DHHAVAI SYLLABLE LAVAI SYLLABLE RAVAI SYLLABLE DA" +
	"VAI SYLLABLE NDAVAI SYLLABLE SAVAI SYLLABLE SHAVAI SYLLABLE ZAVAI SYLLAB" +
	"LE ZHAVAI SYLLABLE CAVAI SYLLABLE JAVAI SYLLABLE NJAVAI SYLLABLE YAVAI S" +
	"YLLABLE KAVAI SYLLABLE KANVAI SYLLABLE NGGAVAI SYLLABLE GAVAI SYLLABLE M" +
	"AVAI SYLLABLE NAVAI SYLLABLE NYAVAI SYLLABLE OOVAI SYLLABLE OONVAI SYLLA" +
	"BLE HOOVAI SYLLABLE WOOVAI SYLLABLE WOONVAI SYLLABLE POOVAI SYLLABLE BHO" +
	"OVAI SYLLABLE BOOVAI SYLLABLE MBOOVAI SYLLABLE KPOOVAI SYLLABLE MGBOOVAI" +
	" SYLLABLE GBOOVAI SYLLABLE FOOVAI SYLLABLE VOOVAI SYLLABLE TOOVAI SYLLAB" +
	"LE THOOVAI SYLLABLE DHOOVAI SYLLABLE DHHOOVAI SYLLABLE LOOVAI SYLLABLE R" +
	"OOVAI SYLLABLE DOOVAI SYLLABLE NDOOVAI SYLLABLE SOOVAI SYLLABLE SHOOVAI " +
	"SYLLABLE ZOOVAI SYLLABLE ZHOOVAI SYLLABLE COOVAI SYLLABLE JOOVAI SYLLABL" +
	"E NJOOVAI SYLLABLE YOOVAI SYLLABLE KOOVAI SYLLABLE NGGOOVAI SYLLABLE GOO" +
	"VAI SYLLABLE MOOVAI SYLLABLE NOOVAI SYLLABLE NYOOVAI SYLLABLE UVAI SYLLA" +
	"BLE UNVAI SYLLABLE HUVAI SYLLABLE HUNVAI SYLLABLE WUVAI SYLLABLE WUNVAI " +
	"SYLLABLE PUVAI SYLLABLE BHUVAI SYLLABLE BUVAI SYLLABLE MBUVAI SYLLABLE K" +
	"PUVAI SYLLABLE MGBUVAI SYLLABLE GBUVAI SYLLABLE FUVAI SYLLABLE VUVAI SYL" +
	"LABLE TUVAI SYLLABLE THUVAI SYLLABLE DHUVAI SYLLABLE DHHUVAI SYLLABLE LU" +
	"VAI SYLLABLE RUVAI SYLLABLE DUVAI SYLLABLE NDUVAI SYLLABLE SUVAI SYLLABL" +
	"E SHUVAI SYLLABLE ZUVAI SYLLABLE ZHUVAI SYLLABLE CUVAI SYLLABLE JUVAI SY" +
	"LLABLE NJUVAI SYLLABLE YUVAI SYLLABLE KUVAI SYLLABLE NGGUVAI SYLLABLE GU" +
	"VAI SYLLABLE MUVAI SYLLABLE NUVAI SYLLABLE NYUVAI SYLLABLE OVAI SYLLABLE" +
	" ONVAI SYLLABLE NGONVAI SYLLABLE HOVAI SYLLABLE HONVAI SYLLABLE WOVAI SY" +
	"LLABLE WONVAI SYLLABLE POVAI SYLLABLE BHOVAI SYLLABLE BOVAI SYLLABLE MBO" +
	"VAI SYLLABLE KPOVAI SYLLABLE MGBOVAI SYLLABLE GBOVAI SYLLABLE GBONVAI SY" +
	"LLABLE FOVAI SYLLABLE VOVAI SYLLABLE TOVAI SYLLABLE THOVAI SYLLABLE DHOV" +
	"AI SYLLABLE DHHOVAI SYLLABLE LOVAI SYLLABLE ROVAI SYLLABLE DOVAI SYLLABL" +
	"E NDOVAI SYLLABLE SOVAI SYLLABLE SHOVAI SYLLABLE ZOVAI SYLLABLE ZHOVAI S" +
	"YLLABLE COVAI SYLLABLE JOVAI SYLLABLE NJOVAI SYLLABLE YOVAI SYLLABLE KOV" +
	"AI SYLLABLE NGGOVAI SYLLABLE GOVAI SYLLABLE MOVAI SYLLABLE NOVAI SYLLABL" +
	"E NYOVAI SYLLABLE EVAI SYLLABLE ENVAI SYLLABLE NGENVAI SYLLABLE HEVAI SY" +
	"LLABLE HENVAI SYLLABLE WEVAI SYLLABLE WENVAI SYLLABLE PEVAI SYLLABLE BHE" +
	"VAI SYLLABLE BEVAI SYLLABLE MBEVAI SYLLABLE KPEVAI SYLLABLE KPENVAI SYLL" +
	"ABLE MGBEVAI SYLLABLE GBEVAI SYLLABLE GBENVAI SYLLABLE FEVAI SYLLABLE VE" +
	"VAI SYLLABLE TEVAI SYLLABLE THEVAI SYLLABLE DHEVAI SYLLABLE DHHEVAI SYLL" +
	"ABLE LEVAI SYLLABLE REVAI SYLLABLE DEVAI SYLLABLE NDEVAI SYLLABLE SEVAI " +
	"SYLLABLE SHEVAI SYLLABLE ZEVAI SYLLABLE ZHEVAI SYLLABLE CEVAI SYLLABLE J" +
	"EVAI SYLLABLE NJEVAI SYLLABLE YEVAI SYLLABLE KEVAI SYLLABLE NGGEVAI SYLL" +
	"ABLE NGGENVAI SYLLABLE GEVAI SYLLABLE GENVAI SYLLABLE MEVAI SYLLABLE NEV" +
	"AI SYLLABLE NYEVAI SYLLABLE NGVAI SYLLABLE LENGTHENERVAI COMMAVAI FULL S" +
	"TOPVAI QUESTION MARKVAI SYLLABLE NDOLE FAVAI SYLLABLE NDOLE KAVAI SYLLAB" +
	"LE NDOLE SOOVAI SYMBOL FEENGVAI SYMBOL KEENGVAI SYMBOL TINGVAI SYMBOL NI" +
	"IVAI SYMBOL BANGVAI SYMBOL FAAVAI SYMBOL TAAVAI SYMBOL DANGVAI SYMBOL DO" +
	"ONGVAI SYMBOL KUNGVAI SYMBOL TONGVAI SYMBOL DO-OVAI SYMBOL JONGVAI DIGIT" +
	" ZEROVAI DIGIT ONEVAI DIGIT TWOVAI DIGIT THREEVAI DIGIT FOURVAI DIGIT FI" +
	"VEVAI DIGIT SIXVAI DIGIT SEVENVAI DIGIT EIGHTVAI DIGIT NINEVAI SYLLABLE " +
	"NDOLE MAVAI SYLLABLE NDOLE DOCYRILLIC CAPITAL LETTER ZEMLYACYRILLIC SMAL" +
	"L LETTER ZEMLYACYRILLIC CAPITAL LETTER DZELOCYRILLIC SMALL LETTER DZELOC" +
	"YRILLIC CAPITAL LETTER REVERSED DZECYRILLIC SMALL LETTER REVERSED DZECYR" +
	"ILLIC CAPITAL LETTER IOTACYRILLIC SMALL LETTER IOTACYRILLIC CAPITAL LETT" +
	"ER DJERVCYRILLIC SMALL LETTER DJERVCYRILLIC CAPITAL LETTER MONOGRAPH UKC") + ("" +
	"YRILLIC SMALL LETTER MONOGRAPH UKCYRILLIC CAPITAL LETTER BROAD OMEGACYRI" +
	"LLIC SMALL LETTER BROAD OMEGACYRILLIC CAPITAL LETTER NEUTRAL YERCYRILLIC" +
	" SMALL LETTER NEUTRAL YERCYRILLIC CAPITAL LETTER YERU WITH BACK YERCYRIL" +
	"LIC SMALL LETTER YERU WITH BACK YERCYRILLIC CAPITAL LETTER IOTIFIED YATC" +
	"YRILLIC SMALL LETTER IOTIFIED YATCYRILLIC CAPITAL LETTER REVERSED YUCYRI" +
	"LLIC SMALL LETTER REVERSED YUCYRILLIC CAPITAL LETTER IOTIFIED ACYRILLIC " +
	"SMALL LETTER IOTIFIED ACYRILLIC CAPITAL LETTER CLOSED LITTLE YUSCYRILLIC" +
	" SMALL LETTER CLOSED LITTLE YUSCYRILLIC CAPITAL LETTER BLENDED YUSCYRILL" +
	"IC SMALL LETTER BLENDED YUSCYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTL" +
	"E YUSCYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUSCYRILLIC CAPITAL LE" +
	"TTER YNCYRILLIC SMALL LETTER YNCYRILLIC CAPITAL LETTER REVERSED TSECYRIL" +
	"LIC SMALL LETTER REVERSED TSECYRILLIC CAPITAL LETTER SOFT DECYRILLIC SMA" +
	"LL LETTER SOFT DECYRILLIC CAPITAL LETTER SOFT ELCYRILLIC SMALL LETTER SO" +
	"FT ELCYRILLIC CAPITAL LETTER SOFT EMCYRILLIC SMALL LETTER SOFT EMCYRILLI" +
	"C CAPITAL LETTER MONOCULAR OCYRILLIC SMALL LETTER MONOCULAR OCYRILLIC CA" +
	"PITAL LETTER BINOCULAR OCYRILLIC SMALL LETTER BINOCULAR OCYRILLIC CAPITA" +
	"L LETTER DOUBLE MONOCULAR OCYRILLIC SMALL LETTER DOUBLE MONOCULAR OCYRIL" +
	"LIC LETTER MULTIOCULAR OCOMBINING CYRILLIC VZMETCOMBINING CYRILLIC TEN M" +
	"ILLIONS SIGNCOMBINING CYRILLIC HUNDRED MILLIONS SIGNCOMBINING CYRILLIC T" +
	"HOUSAND MILLIONS SIGNSLAVONIC ASTERISKCOMBINING CYRILLIC LETTER UKRAINIA" +
	"N IECOMBINING CYRILLIC LETTER ICOMBINING CYRILLIC LETTER YICOMBINING CYR" +
	"ILLIC LETTER UCOMBINING CYRILLIC LETTER HARD SIGNCOMBINING CYRILLIC LETT" +
	"ER YERUCOMBINING CYRILLIC LETTER SOFT SIGNCOMBINING CYRILLIC LETTER OMEG" +
	"ACOMBINING CYRILLIC KAVYKACOMBINING CYRILLIC PAYEROKCYRILLIC KAVYKACYRIL" +
	"LIC PAYEROKCYRILLIC CAPITAL LETTER DWECYRILLIC SMALL LETTER DWECYRILLIC " +
	"CAPITAL LETTER DZWECYRILLIC SMALL LETTER DZWECYRILLIC CAPITAL LETTER ZHW" +
	"ECYRILLIC SMALL LETTER ZHWECYRILLIC CAPITAL LETTER CCHECYRILLIC SMALL LE" +
	"TTER CCHECYRILLIC CAPITAL LETTER DZZECYRILLIC SMALL LETTER DZZECYRILLIC " +
	"CAPITAL LETTER TE WITH MIDDLE HOOKCYRILLIC SMALL LETTER TE WITH MIDDLE H" +
	"OOKCYRILLIC CAPITAL LETTER TWECYRILLIC SMALL LETTER TWECYRILLIC CAPITAL " +
	"LETTER TSWECYRILLIC SMALL LETTER TSWECYRILLIC CAPITAL LETTER TSSECYRILLI" +
	"C SMALL LETTER TSSECYRILLIC CAPITAL LETTER TCHECYRILLIC SMALL LETTER TCH" +
	"ECYRILLIC CAPITAL LETTER HWECYRILLIC SMALL LETTER HWECYRILLIC CAPITAL LE" +
	"TTER SHWECYRILLIC SMALL LETTER SHWECYRILLIC CAPITAL LETTER DOUBLE OCYRIL" +
	"LIC SMALL LETTER DOUBLE OCYRILLIC CAPITAL LETTER CROSSED OCYRILLIC SMALL" +
	" LETTER CROSSED OMODIFIER LETTER CYRILLIC HARD SIGNMODIFIER LETTER CYRIL" +
	"LIC SOFT SIGNCOMBINING CYRILLIC LETTER EFCOMBINING CYRILLIC LETTER IOTIF" +
	"IED EBAMUM LETTER ABAMUM LETTER KABAMUM LETTER UBAMUM LETTER KUBAMUM LET" +
	"TER EEBAMUM LETTER REEBAMUM LETTER TAEBAMUM LETTER OBAMUM LETTER NYIBAMU" +
	"M LETTER IBAMUM LETTER LABAMUM LETTER PABAMUM LETTER RIIBAMUM LETTER RIE" +
	"EBAMUM LETTER LEEEEBAMUM LETTER MEEEEBAMUM LETTER TAABAMUM LETTER NDAABA" +
	"MUM LETTER NJAEMBAMUM LETTER MBAMUM LETTER SUUBAMUM LETTER MUBAMUM LETTE" +
	"R SHIIBAMUM LETTER SIBAMUM LETTER SHEUXBAMUM LETTER SEUXBAMUM LETTER KYE" +
	"EBAMUM LETTER KETBAMUM LETTER NUAEBAMUM LETTER NUBAMUM LETTER NJUAEBAMUM" +
	" LETTER YOQBAMUM LETTER SHUBAMUM LETTER YUQBAMUM LETTER YABAMUM LETTER N" +
	"SHABAMUM LETTER KEUXBAMUM LETTER PEUXBAMUM LETTER NJEEBAMUM LETTER NTEEB" +
	"AMUM LETTER PUEBAMUM LETTER WUEBAMUM LETTER PEEBAMUM LETTER FEEBAMUM LET" +
	"TER RUBAMUM LETTER LUBAMUM LETTER MIBAMUM LETTER NIBAMUM LETTER REUXBAMU" +
	"M LETTER RAEBAMUM LETTER KENBAMUM LETTER NGKWAENBAMUM LETTER NGGABAMUM L" +
	"ETTER NGABAMUM LETTER SHOBAMUM LETTER PUAEBAMUM LETTER FUBAMUM LETTER FO" +
	"MBAMUM LETTER WABAMUM LETTER NABAMUM LETTER LIBAMUM LETTER PIBAMUM LETTE" +
	"R LOQBAMUM LETTER KOBAMUM LETTER MBENBAMUM LETTER RENBAMUM LETTER MENBAM" +
	"UM LETTER MABAMUM LETTER TIBAMUM LETTER KIBAMUM LETTER MOBAMUM LETTER MB" +
	"AABAMUM LETTER TETBAMUM LETTER KPABAMUM LETTER TENBAMUM LETTER NTUUBAMUM" +
	" LETTER SAMBABAMUM LETTER FAAMAEBAMUM LETTER KOVUUBAMUM LETTER KOGHOMBAM" +
	"UM COMBINING MARK KOQNDONBAMUM COMBINING MARK TUKWENTISBAMUM NJAEMLIBAMU" +
	"M FULL STOPBAMUM COLONBAMUM COMMABAMUM SEMICOLONBAMUM QUESTION MARKMODIF" +
	"IER LETTER CHINESE TONE YIN PINGMODIFIER LETTER CHINESE TONE YANG PINGMO" +
	"DIFIER LETTER CHINESE TONE YIN SHANGMODIFIER LETTER CHINESE TONE YANG SH" +
	"ANGMODIFIER LETTER CHINESE TONE YIN QUMODIFIER LETTER CHINESE TONE YANG " +
	"QUMODIFIER LETTER CHINESE TONE YIN RUMODIFIER LETTER CHINESE TONE YANG R" +
	"UMODIFIER LETTER EXTRA-HIGH DOTTED TONE BARMODIFIER LETTER HIGH DOTTED T" +
	"ONE BARMODIFIER LETTER MID DOTTED TONE BARMODIFIER LETTER LOW DOTTED TON" +
	"E BARMODIFIER LETTER EXTRA-LOW DOTTED TONE BARMODIFIER LETTER EXTRA-HIGH") + ("" +
	" DOTTED LEFT-STEM TONE BARMODIFIER LETTER HIGH DOTTED LEFT-STEM TONE BAR" +
	"MODIFIER LETTER MID DOTTED LEFT-STEM TONE BARMODIFIER LETTER LOW DOTTED " +
	"LEFT-STEM TONE BARMODIFIER LETTER EXTRA-LOW DOTTED LEFT-STEM TONE BARMOD" +
	"IFIER LETTER EXTRA-HIGH LEFT-STEM TONE BARMODIFIER LETTER HIGH LEFT-STEM" +
	" TONE BARMODIFIER LETTER MID LEFT-STEM TONE BARMODIFIER LETTER LOW LEFT-" +
	"STEM TONE BARMODIFIER LETTER EXTRA-LOW LEFT-STEM TONE BARMODIFIER LETTER" +
	" DOT VERTICAL BARMODIFIER LETTER DOT SLASHMODIFIER LETTER DOT HORIZONTAL" +
	" BARMODIFIER LETTER LOWER RIGHT CORNER ANGLEMODIFIER LETTER RAISED UP AR" +
	"ROWMODIFIER LETTER RAISED DOWN ARROWMODIFIER LETTER RAISED EXCLAMATION M" +
	"ARKMODIFIER LETTER RAISED INVERTED EXCLAMATION MARKMODIFIER LETTER LOW I" +
	"NVERTED EXCLAMATION MARKMODIFIER LETTER STRESS AND HIGH TONEMODIFIER LET" +
	"TER STRESS AND LOW TONELATIN CAPITAL LETTER EGYPTOLOGICAL ALEFLATIN SMAL" +
	"L LETTER EGYPTOLOGICAL ALEFLATIN CAPITAL LETTER EGYPTOLOGICAL AINLATIN S" +
	"MALL LETTER EGYPTOLOGICAL AINLATIN CAPITAL LETTER HENGLATIN SMALL LETTER" +
	" HENGLATIN CAPITAL LETTER TZLATIN SMALL LETTER TZLATIN CAPITAL LETTER TR" +
	"ESILLOLATIN SMALL LETTER TRESILLOLATIN CAPITAL LETTER CUATRILLOLATIN SMA" +
	"LL LETTER CUATRILLOLATIN CAPITAL LETTER CUATRILLO WITH COMMALATIN SMALL " +
	"LETTER CUATRILLO WITH COMMALATIN LETTER SMALL CAPITAL FLATIN LETTER SMAL" +
	"L CAPITAL SLATIN CAPITAL LETTER AALATIN SMALL LETTER AALATIN CAPITAL LET" +
	"TER AOLATIN SMALL LETTER AOLATIN CAPITAL LETTER AULATIN SMALL LETTER AUL" +
	"ATIN CAPITAL LETTER AVLATIN SMALL LETTER AVLATIN CAPITAL LETTER AV WITH " +
	"HORIZONTAL BARLATIN SMALL LETTER AV WITH HORIZONTAL BARLATIN CAPITAL LET" +
	"TER AYLATIN SMALL LETTER AYLATIN CAPITAL LETTER REVERSED C WITH DOTLATIN" +
	" SMALL LETTER REVERSED C WITH DOTLATIN CAPITAL LETTER K WITH STROKELATIN" +
	" SMALL LETTER K WITH STROKELATIN CAPITAL LETTER K WITH DIAGONAL STROKELA" +
	"TIN SMALL LETTER K WITH DIAGONAL STROKELATIN CAPITAL LETTER K WITH STROK" +
	"E AND DIAGONAL STROKELATIN SMALL LETTER K WITH STROKE AND DIAGONAL STROK" +
	"ELATIN CAPITAL LETTER BROKEN LLATIN SMALL LETTER BROKEN LLATIN CAPITAL L" +
	"ETTER L WITH HIGH STROKELATIN SMALL LETTER L WITH HIGH STROKELATIN CAPIT" +
	"AL LETTER O WITH LONG STROKE OVERLAYLATIN SMALL LETTER O WITH LONG STROK" +
	"E OVERLAYLATIN CAPITAL LETTER O WITH LOOPLATIN SMALL LETTER O WITH LOOPL" +
	"ATIN CAPITAL LETTER OOLATIN SMALL LETTER OOLATIN CAPITAL LETTER P WITH S" +
	"TROKE THROUGH DESCENDERLATIN SMALL LETTER P WITH STROKE THROUGH DESCENDE" +
	"RLATIN CAPITAL LETTER P WITH FLOURISHLATIN SMALL LETTER P WITH FLOURISHL" +
	"ATIN CAPITAL LETTER P WITH SQUIRREL TAILLATIN SMALL LETTER P WITH SQUIRR" +
	"EL TAILLATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDERLATIN SMALL L" +
	"ETTER Q WITH STROKE THROUGH DESCENDERLATIN CAPITAL LETTER Q WITH DIAGONA" +
	"L STROKELATIN SMALL LETTER Q WITH DIAGONAL STROKELATIN CAPITAL LETTER R " +
	"ROTUNDALATIN SMALL LETTER R ROTUNDALATIN CAPITAL LETTER RUM ROTUNDALATIN" +
	" SMALL LETTER RUM ROTUNDALATIN CAPITAL LETTER V WITH DIAGONAL STROKELATI" +
	"N SMALL LETTER V WITH DIAGONAL STROKELATIN CAPITAL LETTER VYLATIN SMALL " +
	"LETTER VYLATIN CAPITAL LETTER VISIGOTHIC ZLATIN SMALL LETTER VISIGOTHIC " +
	"ZLATIN CAPITAL LETTER THORN WITH STROKELATIN SMALL LETTER THORN WITH STR" +
	"OKELATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDERLATIN SMALL L" +
	"ETTER THORN WITH STROKE THROUGH DESCENDERLATIN CAPITAL LETTER VENDLATIN " +
	"SMALL LETTER VENDLATIN CAPITAL LETTER ETLATIN SMALL LETTER ETLATIN CAPIT" +
	"AL LETTER ISLATIN SMALL LETTER ISLATIN CAPITAL LETTER CONLATIN SMALL LET" +
	"TER CONMODIFIER LETTER USLATIN SMALL LETTER DUMLATIN SMALL LETTER LUMLAT" +
	"IN SMALL LETTER MUMLATIN SMALL LETTER NUMLATIN SMALL LETTER RUMLATIN LET" +
	"TER SMALL CAPITAL RUMLATIN SMALL LETTER TUMLATIN SMALL LETTER UMLATIN CA" +
	"PITAL LETTER INSULAR DLATIN SMALL LETTER INSULAR DLATIN CAPITAL LETTER I" +
	"NSULAR FLATIN SMALL LETTER INSULAR FLATIN CAPITAL LETTER INSULAR GLATIN " +
	"CAPITAL LETTER TURNED INSULAR GLATIN SMALL LETTER TURNED INSULAR GLATIN " +
	"CAPITAL LETTER TURNED LLATIN SMALL LETTER TURNED LLATIN CAPITAL LETTER I" +
	"NSULAR RLATIN SMALL LETTER INSULAR RLATIN CAPITAL LETTER INSULAR SLATIN " +
	"SMALL LETTER INSULAR SLATIN CAPITAL LETTER INSULAR TLATIN SMALL LETTER I" +
	"NSULAR TMODIFIER LETTER LOW CIRCUMFLEX ACCENTMODIFIER LETTER COLONMODIFI" +
	"ER LETTER SHORT EQUALS SIGNLATIN CAPITAL LETTER SALTILLOLATIN SMALL LETT" +
	"ER SALTILLOLATIN CAPITAL LETTER TURNED HLATIN SMALL LETTER L WITH RETROF" +
	"LEX HOOK AND BELTLATIN LETTER SINOLOGICAL DOTLATIN CAPITAL LETTER N WITH" +
	" DESCENDERLATIN SMALL LETTER N WITH DESCENDERLATIN CAPITAL LETTER C WITH" +
	" BARLATIN SMALL LETTER C WITH BARLATIN SMALL LETTER C WITH PALATAL HOOKL" +
	"ATIN SMALL LETTER H WITH PALATAL HOOKLATIN CAPITAL LETTER B WITH FLOURIS" +
	"HLATIN SMALL LETTER B WITH FLOURISHLATIN CAPITAL LETTER F WITH STROKELAT") + ("" +
	"IN SMALL LETTER F WITH STROKELATIN CAPITAL LETTER VOLAPUK AELATIN SMALL " +
	"LETTER VOLAPUK AELATIN CAPITAL LETTER VOLAPUK OELATIN SMALL LETTER VOLAP" +
	"UK OELATIN CAPITAL LETTER VOLAPUK UELATIN SMALL LETTER VOLAPUK UELATIN C" +
	"APITAL LETTER G WITH OBLIQUE STROKELATIN SMALL LETTER G WITH OBLIQUE STR" +
	"OKELATIN CAPITAL LETTER K WITH OBLIQUE STROKELATIN SMALL LETTER K WITH O" +
	"BLIQUE STROKELATIN CAPITAL LETTER N WITH OBLIQUE STROKELATIN SMALL LETTE" +
	"R N WITH OBLIQUE STROKELATIN CAPITAL LETTER R WITH OBLIQUE STROKELATIN S" +
	"MALL LETTER R WITH OBLIQUE STROKELATIN CAPITAL LETTER S WITH OBLIQUE STR" +
	"OKELATIN SMALL LETTER S WITH OBLIQUE STROKELATIN CAPITAL LETTER H WITH H" +
	"OOKLATIN CAPITAL LETTER REVERSED OPEN ELATIN CAPITAL LETTER SCRIPT GLATI" +
	"N CAPITAL LETTER L WITH BELTLATIN CAPITAL LETTER SMALL CAPITAL ILATIN LE" +
	"TTER SMALL CAPITAL QLATIN CAPITAL LETTER TURNED KLATIN CAPITAL LETTER TU" +
	"RNED TLATIN CAPITAL LETTER J WITH CROSSED-TAILLATIN CAPITAL LETTER CHILA" +
	"TIN CAPITAL LETTER BETALATIN SMALL LETTER BETALATIN CAPITAL LETTER OMEGA" +
	"LATIN SMALL LETTER OMEGALATIN CAPITAL LETTER U WITH STROKELATIN SMALL LE" +
	"TTER U WITH STROKELATIN CAPITAL LETTER GLOTTAL ALATIN SMALL LETTER GLOTT" +
	"AL ALATIN CAPITAL LETTER GLOTTAL ILATIN SMALL LETTER GLOTTAL ILATIN CAPI" +
	"TAL LETTER GLOTTAL ULATIN SMALL LETTER GLOTTAL ULATIN CAPITAL LETTER ANG" +
	"LICANA WLATIN SMALL LETTER ANGLICANA WLATIN CAPITAL LETTER C WITH PALATA" +
	"L HOOKLATIN CAPITAL LETTER S WITH HOOKLATIN CAPITAL LETTER Z WITH PALATA" +
	"L HOOKLATIN CAPITAL LETTER D WITH SHORT STROKE OVERLAYLATIN SMALL LETTER" +
	" D WITH SHORT STROKE OVERLAYLATIN CAPITAL LETTER S WITH SHORT STROKE OVE" +
	"RLAYLATIN SMALL LETTER S WITH SHORT STROKE OVERLAYLATIN CAPITAL LETTER R" +
	"EVERSED HALF HLATIN SMALL LETTER REVERSED HALF HLATIN EPIGRAPHIC LETTER " +
	"SIDEWAYS IMODIFIER LETTER CAPITAL H WITH STROKEMODIFIER LETTER SMALL LIG" +
	"ATURE OELATIN LETTER SMALL CAPITAL TURNED MLATIN EPIGRAPHIC LETTER REVER" +
	"SED FLATIN EPIGRAPHIC LETTER REVERSED PLATIN EPIGRAPHIC LETTER INVERTED " +
	"MLATIN EPIGRAPHIC LETTER I LONGALATIN EPIGRAPHIC LETTER ARCHAIC MSYLOTI " +
	"NAGRI LETTER ASYLOTI NAGRI LETTER ISYLOTI NAGRI SIGN DVISVARASYLOTI NAGR" +
	"I LETTER USYLOTI NAGRI LETTER ESYLOTI NAGRI LETTER OSYLOTI NAGRI SIGN HA" +
	"SANTASYLOTI NAGRI LETTER KOSYLOTI NAGRI LETTER KHOSYLOTI NAGRI LETTER GO" +
	"SYLOTI NAGRI LETTER GHOSYLOTI NAGRI SIGN ANUSVARASYLOTI NAGRI LETTER COS" +
	"YLOTI NAGRI LETTER CHOSYLOTI NAGRI LETTER JOSYLOTI NAGRI LETTER JHOSYLOT" +
	"I NAGRI LETTER TTOSYLOTI NAGRI LETTER TTHOSYLOTI NAGRI LETTER DDOSYLOTI " +
	"NAGRI LETTER DDHOSYLOTI NAGRI LETTER TOSYLOTI NAGRI LETTER THOSYLOTI NAG" +
	"RI LETTER DOSYLOTI NAGRI LETTER DHOSYLOTI NAGRI LETTER NOSYLOTI NAGRI LE" +
	"TTER POSYLOTI NAGRI LETTER PHOSYLOTI NAGRI LETTER BOSYLOTI NAGRI LETTER " +
	"BHOSYLOTI NAGRI LETTER MOSYLOTI NAGRI LETTER ROSYLOTI NAGRI LETTER LOSYL" +
	"OTI NAGRI LETTER RROSYLOTI NAGRI LETTER SOSYLOTI NAGRI LETTER HOSYLOTI N" +
	"AGRI VOWEL SIGN ASYLOTI NAGRI VOWEL SIGN ISYLOTI NAGRI VOWEL SIGN USYLOT" +
	"I NAGRI VOWEL SIGN ESYLOTI NAGRI VOWEL SIGN OOSYLOTI NAGRI POETRY MARK-1" +
	"SYLOTI NAGRI POETRY MARK-2SYLOTI NAGRI POETRY MARK-3SYLOTI NAGRI POETRY " +
	"MARK-4SYLOTI NAGRI SIGN ALTERNATE HASANTANORTH INDIC FRACTION ONE QUARTE" +
	"RNORTH INDIC FRACTION ONE HALFNORTH INDIC FRACTION THREE QUARTERSNORTH I" +
	"NDIC FRACTION ONE SIXTEENTHNORTH INDIC FRACTION ONE EIGHTHNORTH INDIC FR" +
	"ACTION THREE SIXTEENTHSNORTH INDIC QUARTER MARKNORTH INDIC PLACEHOLDER M" +
	"ARKNORTH INDIC RUPEE MARKNORTH INDIC QUANTITY MARKPHAGS-PA LETTER KAPHAG" +
	"S-PA LETTER KHAPHAGS-PA LETTER GAPHAGS-PA LETTER NGAPHAGS-PA LETTER CAPH" +
	"AGS-PA LETTER CHAPHAGS-PA LETTER JAPHAGS-PA LETTER NYAPHAGS-PA LETTER TA" +
	"PHAGS-PA LETTER THAPHAGS-PA LETTER DAPHAGS-PA LETTER NAPHAGS-PA LETTER P" +
	"APHAGS-PA LETTER PHAPHAGS-PA LETTER BAPHAGS-PA LETTER MAPHAGS-PA LETTER " +
	"TSAPHAGS-PA LETTER TSHAPHAGS-PA LETTER DZAPHAGS-PA LETTER WAPHAGS-PA LET" +
	"TER ZHAPHAGS-PA LETTER ZAPHAGS-PA LETTER SMALL APHAGS-PA LETTER YAPHAGS-" +
	"PA LETTER RAPHAGS-PA LETTER LAPHAGS-PA LETTER SHAPHAGS-PA LETTER SAPHAGS" +
	"-PA LETTER HAPHAGS-PA LETTER APHAGS-PA LETTER IPHAGS-PA LETTER UPHAGS-PA" +
	" LETTER EPHAGS-PA LETTER OPHAGS-PA LETTER QAPHAGS-PA LETTER XAPHAGS-PA L" +
	"ETTER FAPHAGS-PA LETTER GGAPHAGS-PA LETTER EEPHAGS-PA SUBJOINED LETTER W" +
	"APHAGS-PA SUBJOINED LETTER YAPHAGS-PA LETTER TTAPHAGS-PA LETTER TTHAPHAG" +
	"S-PA LETTER DDAPHAGS-PA LETTER NNAPHAGS-PA LETTER ALTERNATE YAPHAGS-PA L" +
	"ETTER VOICELESS SHAPHAGS-PA LETTER VOICED HAPHAGS-PA LETTER ASPIRATED FA" +
	"PHAGS-PA SUBJOINED LETTER RAPHAGS-PA SUPERFIXED LETTER RAPHAGS-PA LETTER" +
	" CANDRABINDUPHAGS-PA SINGLE HEAD MARKPHAGS-PA DOUBLE HEAD MARKPHAGS-PA M" +
	"ARK SHADPHAGS-PA MARK DOUBLE SHADSAURASHTRA SIGN ANUSVARASAURASHTRA SIGN" +
	" VISARGASAURASHTRA LETTER ASAURASHTRA LETTER AASAURASHTRA LETTER ISAURAS") + ("" +
	"HTRA LETTER IISAURASHTRA LETTER USAURASHTRA LETTER UUSAURASHTRA LETTER V" +
	"OCALIC RSAURASHTRA LETTER VOCALIC RRSAURASHTRA LETTER VOCALIC LSAURASHTR" +
	"A LETTER VOCALIC LLSAURASHTRA LETTER ESAURASHTRA LETTER EESAURASHTRA LET" +
	"TER AISAURASHTRA LETTER OSAURASHTRA LETTER OOSAURASHTRA LETTER AUSAURASH" +
	"TRA LETTER KASAURASHTRA LETTER KHASAURASHTRA LETTER GASAURASHTRA LETTER " +
	"GHASAURASHTRA LETTER NGASAURASHTRA LETTER CASAURASHTRA LETTER CHASAURASH" +
	"TRA LETTER JASAURASHTRA LETTER JHASAURASHTRA LETTER NYASAURASHTRA LETTER" +
	" TTASAURASHTRA LETTER TTHASAURASHTRA LETTER DDASAURASHTRA LETTER DDHASAU" +
	"RASHTRA LETTER NNASAURASHTRA LETTER TASAURASHTRA LETTER THASAURASHTRA LE" +
	"TTER DASAURASHTRA LETTER DHASAURASHTRA LETTER NASAURASHTRA LETTER PASAUR" +
	"ASHTRA LETTER PHASAURASHTRA LETTER BASAURASHTRA LETTER BHASAURASHTRA LET" +
	"TER MASAURASHTRA LETTER YASAURASHTRA LETTER RASAURASHTRA LETTER LASAURAS" +
	"HTRA LETTER VASAURASHTRA LETTER SHASAURASHTRA LETTER SSASAURASHTRA LETTE" +
	"R SASAURASHTRA LETTER HASAURASHTRA LETTER LLASAURASHTRA CONSONANT SIGN H" +
	"AARUSAURASHTRA VOWEL SIGN AASAURASHTRA VOWEL SIGN ISAURASHTRA VOWEL SIGN" +
	" IISAURASHTRA VOWEL SIGN USAURASHTRA VOWEL SIGN UUSAURASHTRA VOWEL SIGN " +
	"VOCALIC RSAURASHTRA VOWEL SIGN VOCALIC RRSAURASHTRA VOWEL SIGN VOCALIC L" +
	"SAURASHTRA VOWEL SIGN VOCALIC LLSAURASHTRA VOWEL SIGN ESAURASHTRA VOWEL " +
	"SIGN EESAURASHTRA VOWEL SIGN AISAURASHTRA VOWEL SIGN OSAURASHTRA VOWEL S" +
	"IGN OOSAURASHTRA VOWEL SIGN AUSAURASHTRA SIGN VIRAMASAURASHTRA SIGN CAND" +
	"RABINDUSAURASHTRA DANDASAURASHTRA DOUBLE DANDASAURASHTRA DIGIT ZEROSAURA" +
	"SHTRA DIGIT ONESAURASHTRA DIGIT TWOSAURASHTRA DIGIT THREESAURASHTRA DIGI" +
	"T FOURSAURASHTRA DIGIT FIVESAURASHTRA DIGIT SIXSAURASHTRA DIGIT SEVENSAU" +
	"RASHTRA DIGIT EIGHTSAURASHTRA DIGIT NINECOMBINING DEVANAGARI DIGIT ZEROC" +
	"OMBINING DEVANAGARI DIGIT ONECOMBINING DEVANAGARI DIGIT TWOCOMBINING DEV" +
	"ANAGARI DIGIT THREECOMBINING DEVANAGARI DIGIT FOURCOMBINING DEVANAGARI D" +
	"IGIT FIVECOMBINING DEVANAGARI DIGIT SIXCOMBINING DEVANAGARI DIGIT SEVENC" +
	"OMBINING DEVANAGARI DIGIT EIGHTCOMBINING DEVANAGARI DIGIT NINECOMBINING " +
	"DEVANAGARI LETTER ACOMBINING DEVANAGARI LETTER UCOMBINING DEVANAGARI LET" +
	"TER KACOMBINING DEVANAGARI LETTER NACOMBINING DEVANAGARI LETTER PACOMBIN" +
	"ING DEVANAGARI LETTER RACOMBINING DEVANAGARI LETTER VICOMBINING DEVANAGA" +
	"RI SIGN AVAGRAHADEVANAGARI SIGN SPACING CANDRABINDUDEVANAGARI SIGN CANDR" +
	"ABINDU VIRAMADEVANAGARI SIGN DOUBLE CANDRABINDU VIRAMADEVANAGARI SIGN CA" +
	"NDRABINDU TWODEVANAGARI SIGN CANDRABINDU THREEDEVANAGARI SIGN CANDRABIND" +
	"U AVAGRAHADEVANAGARI SIGN PUSHPIKADEVANAGARI GAP FILLERDEVANAGARI CARETD" +
	"EVANAGARI HEADSTROKEDEVANAGARI SIGN SIDDHAMDEVANAGARI JAIN OMDEVANAGARI " +
	"LETTER AYDEVANAGARI VOWEL SIGN AYKAYAH LI DIGIT ZEROKAYAH LI DIGIT ONEKA" +
	"YAH LI DIGIT TWOKAYAH LI DIGIT THREEKAYAH LI DIGIT FOURKAYAH LI DIGIT FI" +
	"VEKAYAH LI DIGIT SIXKAYAH LI DIGIT SEVENKAYAH LI DIGIT EIGHTKAYAH LI DIG" +
	"IT NINEKAYAH LI LETTER KAKAYAH LI LETTER KHAKAYAH LI LETTER GAKAYAH LI L" +
	"ETTER NGAKAYAH LI LETTER SAKAYAH LI LETTER SHAKAYAH LI LETTER ZAKAYAH LI" +
	" LETTER NYAKAYAH LI LETTER TAKAYAH LI LETTER HTAKAYAH LI LETTER NAKAYAH " +
	"LI LETTER PAKAYAH LI LETTER PHAKAYAH LI LETTER MAKAYAH LI LETTER DAKAYAH" +
	" LI LETTER BAKAYAH LI LETTER RAKAYAH LI LETTER YAKAYAH LI LETTER LAKAYAH" +
	" LI LETTER WAKAYAH LI LETTER THAKAYAH LI LETTER HAKAYAH LI LETTER VAKAYA" +
	"H LI LETTER CAKAYAH LI LETTER AKAYAH LI LETTER OEKAYAH LI LETTER IKAYAH " +
	"LI LETTER OOKAYAH LI VOWEL UEKAYAH LI VOWEL EKAYAH LI VOWEL UKAYAH LI VO" +
	"WEL EEKAYAH LI VOWEL OKAYAH LI TONE PLOPHUKAYAH LI TONE CALYAKAYAH LI TO" +
	"NE CALYA PLOPHUKAYAH LI SIGN CWIKAYAH LI SIGN SHYAREJANG LETTER KAREJANG" +
	" LETTER GAREJANG LETTER NGAREJANG LETTER TAREJANG LETTER DAREJANG LETTER" +
	" NAREJANG LETTER PAREJANG LETTER BAREJANG LETTER MAREJANG LETTER CAREJAN" +
	"G LETTER JAREJANG LETTER NYAREJANG LETTER SAREJANG LETTER RAREJANG LETTE" +
	"R LAREJANG LETTER YAREJANG LETTER WAREJANG LETTER HAREJANG LETTER MBAREJ" +
	"ANG LETTER NGGAREJANG LETTER NDAREJANG LETTER NYJAREJANG LETTER AREJANG " +
	"VOWEL SIGN IREJANG VOWEL SIGN UREJANG VOWEL SIGN EREJANG VOWEL SIGN AIRE" +
	"JANG VOWEL SIGN OREJANG VOWEL SIGN AUREJANG VOWEL SIGN EUREJANG VOWEL SI" +
	"GN EAREJANG CONSONANT SIGN NGREJANG CONSONANT SIGN NREJANG CONSONANT SIG" +
	"N RREJANG CONSONANT SIGN HREJANG VIRAMAREJANG SECTION MARKHANGUL CHOSEON" +
	"G TIKEUT-MIEUMHANGUL CHOSEONG TIKEUT-PIEUPHANGUL CHOSEONG TIKEUT-SIOSHAN" +
	"GUL CHOSEONG TIKEUT-CIEUCHANGUL CHOSEONG RIEUL-KIYEOKHANGUL CHOSEONG RIE" +
	"UL-SSANGKIYEOKHANGUL CHOSEONG RIEUL-TIKEUTHANGUL CHOSEONG RIEUL-SSANGTIK" +
	"EUTHANGUL CHOSEONG RIEUL-MIEUMHANGUL CHOSEONG RIEUL-PIEUPHANGUL CHOSEONG" +
	" RIEUL-SSANGPIEUPHANGUL CHOSEONG RIEUL-KAPYEOUNPIEUPHANGUL CHOSEONG RIEU" +
	"L-SIOSHANGUL CHOSEONG RIEUL-CIEUCHANGUL CHOSEONG RIEUL-KHIEUKHHANGUL CHO") + ("" +
	"SEONG MIEUM-KIYEOKHANGUL CHOSEONG MIEUM-TIKEUTHANGUL CHOSEONG MIEUM-SIOS" +
	"HANGUL CHOSEONG PIEUP-SIOS-THIEUTHHANGUL CHOSEONG PIEUP-KHIEUKHHANGUL CH" +
	"OSEONG PIEUP-HIEUHHANGUL CHOSEONG SSANGSIOS-PIEUPHANGUL CHOSEONG IEUNG-R" +
	"IEULHANGUL CHOSEONG IEUNG-HIEUHHANGUL CHOSEONG SSANGCIEUC-HIEUHHANGUL CH" +
	"OSEONG SSANGTHIEUTHHANGUL CHOSEONG PHIEUPH-HIEUHHANGUL CHOSEONG HIEUH-SI" +
	"OSHANGUL CHOSEONG SSANGYEORINHIEUHJAVANESE SIGN PANYANGGAJAVANESE SIGN C" +
	"ECAKJAVANESE SIGN LAYARJAVANESE SIGN WIGNYANJAVANESE LETTER AJAVANESE LE" +
	"TTER I KAWIJAVANESE LETTER IJAVANESE LETTER IIJAVANESE LETTER UJAVANESE " +
	"LETTER PA CEREKJAVANESE LETTER NGA LELETJAVANESE LETTER NGA LELET RASWAD" +
	"IJAVANESE LETTER EJAVANESE LETTER AIJAVANESE LETTER OJAVANESE LETTER KAJ" +
	"AVANESE LETTER KA SASAKJAVANESE LETTER KA MURDAJAVANESE LETTER GAJAVANES" +
	"E LETTER GA MURDAJAVANESE LETTER NGAJAVANESE LETTER CAJAVANESE LETTER CA" +
	" MURDAJAVANESE LETTER JAJAVANESE LETTER NYA MURDAJAVANESE LETTER JA MAHA" +
	"PRANAJAVANESE LETTER NYAJAVANESE LETTER TTAJAVANESE LETTER TTA MAHAPRANA" +
	"JAVANESE LETTER DDAJAVANESE LETTER DDA MAHAPRANAJAVANESE LETTER NA MURDA" +
	"JAVANESE LETTER TAJAVANESE LETTER TA MURDAJAVANESE LETTER DAJAVANESE LET" +
	"TER DA MAHAPRANAJAVANESE LETTER NAJAVANESE LETTER PAJAVANESE LETTER PA M" +
	"URDAJAVANESE LETTER BAJAVANESE LETTER BA MURDAJAVANESE LETTER MAJAVANESE" +
	" LETTER YAJAVANESE LETTER RAJAVANESE LETTER RA AGUNGJAVANESE LETTER LAJA" +
	"VANESE LETTER WAJAVANESE LETTER SA MURDAJAVANESE LETTER SA MAHAPRANAJAVA" +
	"NESE LETTER SAJAVANESE LETTER HAJAVANESE SIGN CECAK TELUJAVANESE VOWEL S" +
	"IGN TARUNGJAVANESE VOWEL SIGN TOLONGJAVANESE VOWEL SIGN WULUJAVANESE VOW" +
	"EL SIGN WULU MELIKJAVANESE VOWEL SIGN SUKUJAVANESE VOWEL SIGN SUKU MENDU" +
	"TJAVANESE VOWEL SIGN TALINGJAVANESE VOWEL SIGN DIRGA MUREJAVANESE VOWEL " +
	"SIGN PEPETJAVANESE CONSONANT SIGN KERETJAVANESE CONSONANT SIGN PENGKALJA" +
	"VANESE CONSONANT SIGN CAKRAJAVANESE PANGKONJAVANESE LEFT RERENGGANJAVANE" +
	"SE RIGHT RERENGGANJAVANESE PADA ANDAPJAVANESE PADA MADYAJAVANESE PADA LU" +
	"HURJAVANESE PADA WINDUJAVANESE PADA PANGKATJAVANESE PADA LINGSAJAVANESE " +
	"PADA LUNGSIJAVANESE PADA ADEGJAVANESE PADA ADEG ADEGJAVANESE PADA PISELE" +
	"HJAVANESE TURNED PADA PISELEHJAVANESE PANGRANGKEPJAVANESE DIGIT ZEROJAVA" +
	"NESE DIGIT ONEJAVANESE DIGIT TWOJAVANESE DIGIT THREEJAVANESE DIGIT FOURJ" +
	"AVANESE DIGIT FIVEJAVANESE DIGIT SIXJAVANESE DIGIT SEVENJAVANESE DIGIT E" +
	"IGHTJAVANESE DIGIT NINEJAVANESE PADA TIRTA TUMETESJAVANESE PADA ISEN-ISE" +
	"NMYANMAR LETTER SHAN GHAMYANMAR LETTER SHAN CHAMYANMAR LETTER SHAN JHAMY" +
	"ANMAR LETTER SHAN NNAMYANMAR LETTER SHAN BHAMYANMAR SIGN SHAN SAWMYANMAR" +
	" MODIFIER LETTER SHAN REDUPLICATIONMYANMAR LETTER TAI LAING NYAMYANMAR L" +
	"ETTER TAI LAING FAMYANMAR LETTER TAI LAING GAMYANMAR LETTER TAI LAING GH" +
	"AMYANMAR LETTER TAI LAING JAMYANMAR LETTER TAI LAING JHAMYANMAR LETTER T" +
	"AI LAING DDAMYANMAR LETTER TAI LAING DDHAMYANMAR LETTER TAI LAING NNAMYA" +
	"NMAR TAI LAING DIGIT ZEROMYANMAR TAI LAING DIGIT ONEMYANMAR TAI LAING DI" +
	"GIT TWOMYANMAR TAI LAING DIGIT THREEMYANMAR TAI LAING DIGIT FOURMYANMAR " +
	"TAI LAING DIGIT FIVEMYANMAR TAI LAING DIGIT SIXMYANMAR TAI LAING DIGIT S" +
	"EVENMYANMAR TAI LAING DIGIT EIGHTMYANMAR TAI LAING DIGIT NINEMYANMAR LET" +
	"TER TAI LAING LLAMYANMAR LETTER TAI LAING DAMYANMAR LETTER TAI LAING DHA" +
	"MYANMAR LETTER TAI LAING BAMYANMAR LETTER TAI LAING BHACHAM LETTER ACHAM" +
	" LETTER ICHAM LETTER UCHAM LETTER ECHAM LETTER AICHAM LETTER OCHAM LETTE" +
	"R KACHAM LETTER KHACHAM LETTER GACHAM LETTER GHACHAM LETTER NGUECHAM LET" +
	"TER NGACHAM LETTER CHACHAM LETTER CHHACHAM LETTER JACHAM LETTER JHACHAM " +
	"LETTER NHUECHAM LETTER NHACHAM LETTER NHJACHAM LETTER TACHAM LETTER THAC" +
	"HAM LETTER DACHAM LETTER DHACHAM LETTER NUECHAM LETTER NACHAM LETTER DDA" +
	"CHAM LETTER PACHAM LETTER PPACHAM LETTER PHACHAM LETTER BACHAM LETTER BH" +
	"ACHAM LETTER MUECHAM LETTER MACHAM LETTER BBACHAM LETTER YACHAM LETTER R" +
	"ACHAM LETTER LACHAM LETTER VACHAM LETTER SSACHAM LETTER SACHAM LETTER HA" +
	"CHAM VOWEL SIGN AACHAM VOWEL SIGN ICHAM VOWEL SIGN IICHAM VOWEL SIGN EIC" +
	"HAM VOWEL SIGN UCHAM VOWEL SIGN OECHAM VOWEL SIGN OCHAM VOWEL SIGN AICHA" +
	"M VOWEL SIGN AUCHAM VOWEL SIGN UECHAM CONSONANT SIGN YACHAM CONSONANT SI" +
	"GN RACHAM CONSONANT SIGN LACHAM CONSONANT SIGN WACHAM LETTER FINAL KCHAM" +
	" LETTER FINAL GCHAM LETTER FINAL NGCHAM CONSONANT SIGN FINAL NGCHAM LETT" +
	"ER FINAL CHCHAM LETTER FINAL TCHAM LETTER FINAL NCHAM LETTER FINAL PCHAM" +
	" LETTER FINAL YCHAM LETTER FINAL RCHAM LETTER FINAL LCHAM LETTER FINAL S" +
	"SCHAM CONSONANT SIGN FINAL MCHAM CONSONANT SIGN FINAL HCHAM DIGIT ZEROCH" +
	"AM DIGIT ONECHAM DIGIT TWOCHAM DIGIT THREECHAM DIGIT FOURCHAM DIGIT FIVE" +
	"CHAM DIGIT SIXCHAM DIGIT SEVENCHAM DIGIT EIGHTCHAM DIGIT NINECHAM PUNCTU" +
	"ATION SPIRALCHAM PUNCTUATION DANDACHAM PUNCTUATION DOUBLE DANDACHAM PUNC") + ("" +
	"TUATION TRIPLE DANDAMYANMAR LETTER KHAMTI GAMYANMAR LETTER KHAMTI CAMYAN" +
	"MAR LETTER KHAMTI CHAMYANMAR LETTER KHAMTI JAMYANMAR LETTER KHAMTI JHAMY" +
	"ANMAR LETTER KHAMTI NYAMYANMAR LETTER KHAMTI TTAMYANMAR LETTER KHAMTI TT" +
	"HAMYANMAR LETTER KHAMTI DDAMYANMAR LETTER KHAMTI DDHAMYANMAR LETTER KHAM" +
	"TI DHAMYANMAR LETTER KHAMTI NAMYANMAR LETTER KHAMTI SAMYANMAR LETTER KHA" +
	"MTI HAMYANMAR LETTER KHAMTI HHAMYANMAR LETTER KHAMTI FAMYANMAR MODIFIER " +
	"LETTER KHAMTI REDUPLICATIONMYANMAR LETTER KHAMTI XAMYANMAR LETTER KHAMTI" +
	" ZAMYANMAR LETTER KHAMTI RAMYANMAR LOGOGRAM KHAMTI OAYMYANMAR LOGOGRAM K" +
	"HAMTI QNMYANMAR LOGOGRAM KHAMTI HMMYANMAR SYMBOL AITON EXCLAMATIONMYANMA" +
	"R SYMBOL AITON ONEMYANMAR SYMBOL AITON TWOMYANMAR LETTER AITON RAMYANMAR" +
	" SIGN PAO KAREN TONEMYANMAR SIGN TAI LAING TONE-2MYANMAR SIGN TAI LAING " +
	"TONE-5MYANMAR LETTER SHWE PALAUNG CHAMYANMAR LETTER SHWE PALAUNG SHATAI " +
	"VIET LETTER LOW KOTAI VIET LETTER HIGH KOTAI VIET LETTER LOW KHOTAI VIET" +
	" LETTER HIGH KHOTAI VIET LETTER LOW KHHOTAI VIET LETTER HIGH KHHOTAI VIE" +
	"T LETTER LOW GOTAI VIET LETTER HIGH GOTAI VIET LETTER LOW NGOTAI VIET LE" +
	"TTER HIGH NGOTAI VIET LETTER LOW COTAI VIET LETTER HIGH COTAI VIET LETTE" +
	"R LOW CHOTAI VIET LETTER HIGH CHOTAI VIET LETTER LOW SOTAI VIET LETTER H" +
	"IGH SOTAI VIET LETTER LOW NYOTAI VIET LETTER HIGH NYOTAI VIET LETTER LOW" +
	" DOTAI VIET LETTER HIGH DOTAI VIET LETTER LOW TOTAI VIET LETTER HIGH TOT" +
	"AI VIET LETTER LOW THOTAI VIET LETTER HIGH THOTAI VIET LETTER LOW NOTAI " +
	"VIET LETTER HIGH NOTAI VIET LETTER LOW BOTAI VIET LETTER HIGH BOTAI VIET" +
	" LETTER LOW POTAI VIET LETTER HIGH POTAI VIET LETTER LOW PHOTAI VIET LET" +
	"TER HIGH PHOTAI VIET LETTER LOW FOTAI VIET LETTER HIGH FOTAI VIET LETTER" +
	" LOW MOTAI VIET LETTER HIGH MOTAI VIET LETTER LOW YOTAI VIET LETTER HIGH" +
	" YOTAI VIET LETTER LOW ROTAI VIET LETTER HIGH ROTAI VIET LETTER LOW LOTA" +
	"I VIET LETTER HIGH LOTAI VIET LETTER LOW VOTAI VIET LETTER HIGH VOTAI VI" +
	"ET LETTER LOW HOTAI VIET LETTER HIGH HOTAI VIET LETTER LOW OTAI VIET LET" +
	"TER HIGH OTAI VIET MAI KANGTAI VIET VOWEL AATAI VIET VOWEL ITAI VIET VOW" +
	"EL UETAI VIET VOWEL UTAI VIET VOWEL ETAI VIET VOWEL OTAI VIET MAI KHITTA" +
	"I VIET VOWEL IATAI VIET VOWEL UEATAI VIET VOWEL UATAI VIET VOWEL AUETAI " +
	"VIET VOWEL AYTAI VIET VOWEL ANTAI VIET VOWEL AMTAI VIET TONE MAI EKTAI V" +
	"IET TONE MAI NUENGTAI VIET TONE MAI THOTAI VIET TONE MAI SONGTAI VIET SY" +
	"MBOL KONTAI VIET SYMBOL NUENGTAI VIET SYMBOL SAMTAI VIET SYMBOL HO HOITA" +
	"I VIET SYMBOL KOI KOIMEETEI MAYEK LETTER EMEETEI MAYEK LETTER OMEETEI MA" +
	"YEK LETTER CHAMEETEI MAYEK LETTER NYAMEETEI MAYEK LETTER TTAMEETEI MAYEK" +
	" LETTER TTHAMEETEI MAYEK LETTER DDAMEETEI MAYEK LETTER DDHAMEETEI MAYEK " +
	"LETTER NNAMEETEI MAYEK LETTER SHAMEETEI MAYEK LETTER SSAMEETEI MAYEK VOW" +
	"EL SIGN IIMEETEI MAYEK VOWEL SIGN UUMEETEI MAYEK VOWEL SIGN AAIMEETEI MA" +
	"YEK VOWEL SIGN AUMEETEI MAYEK VOWEL SIGN AAUMEETEI MAYEK CHEIKHANMEETEI " +
	"MAYEK AHANG KHUDAMMEETEI MAYEK ANJIMEETEI MAYEK SYLLABLE REPETITION MARK" +
	"MEETEI MAYEK WORD REPETITION MARKMEETEI MAYEK VOWEL SIGN VISARGAMEETEI M" +
	"AYEK VIRAMAETHIOPIC SYLLABLE TTHUETHIOPIC SYLLABLE TTHIETHIOPIC SYLLABLE" +
	" TTHAAETHIOPIC SYLLABLE TTHEEETHIOPIC SYLLABLE TTHEETHIOPIC SYLLABLE TTH" +
	"OETHIOPIC SYLLABLE DDHUETHIOPIC SYLLABLE DDHIETHIOPIC SYLLABLE DDHAAETHI" +
	"OPIC SYLLABLE DDHEEETHIOPIC SYLLABLE DDHEETHIOPIC SYLLABLE DDHOETHIOPIC " +
	"SYLLABLE DZUETHIOPIC SYLLABLE DZIETHIOPIC SYLLABLE DZAAETHIOPIC SYLLABLE" +
	" DZEEETHIOPIC SYLLABLE DZEETHIOPIC SYLLABLE DZOETHIOPIC SYLLABLE CCHHAET" +
	"HIOPIC SYLLABLE CCHHUETHIOPIC SYLLABLE CCHHIETHIOPIC SYLLABLE CCHHAAETHI" +
	"OPIC SYLLABLE CCHHEEETHIOPIC SYLLABLE CCHHEETHIOPIC SYLLABLE CCHHOETHIOP" +
	"IC SYLLABLE BBAETHIOPIC SYLLABLE BBUETHIOPIC SYLLABLE BBIETHIOPIC SYLLAB" +
	"LE BBAAETHIOPIC SYLLABLE BBEEETHIOPIC SYLLABLE BBEETHIOPIC SYLLABLE BBOL" +
	"ATIN SMALL LETTER BARRED ALPHALATIN SMALL LETTER A REVERSED-SCHWALATIN S" +
	"MALL LETTER BLACKLETTER ELATIN SMALL LETTER BARRED ELATIN SMALL LETTER E" +
	" WITH FLOURISHLATIN SMALL LETTER LENIS FLATIN SMALL LETTER SCRIPT G WITH" +
	" CROSSED-TAILLATIN SMALL LETTER L WITH INVERTED LAZY SLATIN SMALL LETTER" +
	" L WITH DOUBLE MIDDLE TILDELATIN SMALL LETTER L WITH MIDDLE RINGLATIN SM" +
	"ALL LETTER M WITH CROSSED-TAILLATIN SMALL LETTER N WITH CROSSED-TAILLATI" +
	"N SMALL LETTER ENG WITH CROSSED-TAILLATIN SMALL LETTER BLACKLETTER OLATI" +
	"N SMALL LETTER BLACKLETTER O WITH STROKELATIN SMALL LETTER OPEN O WITH S" +
	"TROKELATIN SMALL LETTER INVERTED OELATIN SMALL LETTER TURNED OE WITH STR" +
	"OKELATIN SMALL LETTER TURNED OE WITH HORIZONTAL STROKELATIN SMALL LETTER" +
	" TURNED O OPEN-OLATIN SMALL LETTER TURNED O OPEN-O WITH STROKELATIN SMAL" +
	"L LETTER STIRRUP RLATIN LETTER SMALL CAPITAL R WITH RIGHT LEGLATIN SMALL" +
	" LETTER R WITHOUT HANDLELATIN SMALL LETTER DOUBLE RLATIN SMALL LETTER R ") + ("" +
	"WITH CROSSED-TAILLATIN SMALL LETTER DOUBLE R WITH CROSSED-TAILLATIN SMAL" +
	"L LETTER SCRIPT RLATIN SMALL LETTER SCRIPT R WITH RINGLATIN SMALL LETTER" +
	" BASELINE ESHLATIN SMALL LETTER U WITH SHORT RIGHT LEGLATIN SMALL LETTER" +
	" U BAR WITH SHORT RIGHT LEGLATIN SMALL LETTER UILATIN SMALL LETTER TURNE" +
	"D UILATIN SMALL LETTER U WITH LEFT HOOKLATIN SMALL LETTER CHILATIN SMALL" +
	" LETTER CHI WITH LOW RIGHT RINGLATIN SMALL LETTER CHI WITH LOW LEFT SERI" +
	"FLATIN SMALL LETTER X WITH LOW RIGHT RINGLATIN SMALL LETTER X WITH LONG " +
	"LEFT LEGLATIN SMALL LETTER X WITH LONG LEFT LEG AND LOW RIGHT RINGLATIN " +
	"SMALL LETTER X WITH LONG LEFT LEG WITH SERIFLATIN SMALL LETTER Y WITH SH" +
	"ORT RIGHT LEGMODIFIER BREVE WITH INVERTED BREVEMODIFIER LETTER SMALL HEN" +
	"GMODIFIER LETTER SMALL L WITH INVERTED LAZY SMODIFIER LETTER SMALL L WIT" +
	"H MIDDLE TILDEMODIFIER LETTER SMALL U WITH LEFT HOOKLATIN SMALL LETTER S" +
	"AKHA YATLATIN SMALL LETTER IOTIFIED ELATIN SMALL LETTER OPEN OELATIN SMA" +
	"LL LETTER UOLATIN SMALL LETTER INVERTED ALPHAGREEK LETTER SMALL CAPITAL " +
	"OMEGALATIN SMALL LETTER DZ DIGRAPH WITH RETROFLEX HOOKLATIN SMALL LETTER" +
	" TS DIGRAPH WITH RETROFLEX HOOKLATIN SMALL LETTER TURNED R WITH MIDDLE T" +
	"ILDEMODIFIER LETTER SMALL TURNED WMODIFIER LETTER LEFT TACKMODIFIER LETT" +
	"ER RIGHT TACKCHEROKEE SMALL LETTER ACHEROKEE SMALL LETTER ECHEROKEE SMAL" +
	"L LETTER ICHEROKEE SMALL LETTER OCHEROKEE SMALL LETTER UCHEROKEE SMALL L" +
	"ETTER VCHEROKEE SMALL LETTER GACHEROKEE SMALL LETTER KACHEROKEE SMALL LE" +
	"TTER GECHEROKEE SMALL LETTER GICHEROKEE SMALL LETTER GOCHEROKEE SMALL LE" +
	"TTER GUCHEROKEE SMALL LETTER GVCHEROKEE SMALL LETTER HACHEROKEE SMALL LE" +
	"TTER HECHEROKEE SMALL LETTER HICHEROKEE SMALL LETTER HOCHEROKEE SMALL LE" +
	"TTER HUCHEROKEE SMALL LETTER HVCHEROKEE SMALL LETTER LACHEROKEE SMALL LE" +
	"TTER LECHEROKEE SMALL LETTER LICHEROKEE SMALL LETTER LOCHEROKEE SMALL LE" +
	"TTER LUCHEROKEE SMALL LETTER LVCHEROKEE SMALL LETTER MACHEROKEE SMALL LE" +
	"TTER MECHEROKEE SMALL LETTER MICHEROKEE SMALL LETTER MOCHEROKEE SMALL LE" +
	"TTER MUCHEROKEE SMALL LETTER NACHEROKEE SMALL LETTER HNACHEROKEE SMALL L" +
	"ETTER NAHCHEROKEE SMALL LETTER NECHEROKEE SMALL LETTER NICHEROKEE SMALL " +
	"LETTER NOCHEROKEE SMALL LETTER NUCHEROKEE SMALL LETTER NVCHEROKEE SMALL " +
	"LETTER QUACHEROKEE SMALL LETTER QUECHEROKEE SMALL LETTER QUICHEROKEE SMA" +
	"LL LETTER QUOCHEROKEE SMALL LETTER QUUCHEROKEE SMALL LETTER QUVCHEROKEE " +
	"SMALL LETTER SACHEROKEE SMALL LETTER SCHEROKEE SMALL LETTER SECHEROKEE S" +
	"MALL LETTER SICHEROKEE SMALL LETTER SOCHEROKEE SMALL LETTER SUCHEROKEE S" +
	"MALL LETTER SVCHEROKEE SMALL LETTER DACHEROKEE SMALL LETTER TACHEROKEE S" +
	"MALL LETTER DECHEROKEE SMALL LETTER TECHEROKEE SMALL LETTER DICHEROKEE S" +
	"MALL LETTER TICHEROKEE SMALL LETTER DOCHEROKEE SMALL LETTER DUCHEROKEE S" +
	"MALL LETTER DVCHEROKEE SMALL LETTER DLACHEROKEE SMALL LETTER TLACHEROKEE" +
	" SMALL LETTER TLECHEROKEE SMALL LETTER TLICHEROKEE SMALL LETTER TLOCHERO" +
	"KEE SMALL LETTER TLUCHEROKEE SMALL LETTER TLVCHEROKEE SMALL LETTER TSACH" +
	"EROKEE SMALL LETTER TSECHEROKEE SMALL LETTER TSICHEROKEE SMALL LETTER TS" +
	"OCHEROKEE SMALL LETTER TSUCHEROKEE SMALL LETTER TSVCHEROKEE SMALL LETTER" +
	" WACHEROKEE SMALL LETTER WECHEROKEE SMALL LETTER WICHEROKEE SMALL LETTER" +
	" WOCHEROKEE SMALL LETTER WUCHEROKEE SMALL LETTER WVCHEROKEE SMALL LETTER" +
	" YAMEETEI MAYEK LETTER KOKMEETEI MAYEK LETTER SAMMEETEI MAYEK LETTER LAI" +
	"MEETEI MAYEK LETTER MITMEETEI MAYEK LETTER PAMEETEI MAYEK LETTER NAMEETE" +
	"I MAYEK LETTER CHILMEETEI MAYEK LETTER TILMEETEI MAYEK LETTER KHOUMEETEI" +
	" MAYEK LETTER NGOUMEETEI MAYEK LETTER THOUMEETEI MAYEK LETTER WAIMEETEI " +
	"MAYEK LETTER YANGMEETEI MAYEK LETTER HUKMEETEI MAYEK LETTER UNMEETEI MAY" +
	"EK LETTER IMEETEI MAYEK LETTER PHAMMEETEI MAYEK LETTER ATIYAMEETEI MAYEK" +
	" LETTER GOKMEETEI MAYEK LETTER JHAMMEETEI MAYEK LETTER RAIMEETEI MAYEK L" +
	"ETTER BAMEETEI MAYEK LETTER JILMEETEI MAYEK LETTER DILMEETEI MAYEK LETTE" +
	"R GHOUMEETEI MAYEK LETTER DHOUMEETEI MAYEK LETTER BHAMMEETEI MAYEK LETTE" +
	"R KOK LONSUMMEETEI MAYEK LETTER LAI LONSUMMEETEI MAYEK LETTER MIT LONSUM" +
	"MEETEI MAYEK LETTER PA LONSUMMEETEI MAYEK LETTER NA LONSUMMEETEI MAYEK L" +
	"ETTER TIL LONSUMMEETEI MAYEK LETTER NGOU LONSUMMEETEI MAYEK LETTER I LON" +
	"SUMMEETEI MAYEK VOWEL SIGN ONAPMEETEI MAYEK VOWEL SIGN INAPMEETEI MAYEK " +
	"VOWEL SIGN ANAPMEETEI MAYEK VOWEL SIGN YENAPMEETEI MAYEK VOWEL SIGN SOUN" +
	"APMEETEI MAYEK VOWEL SIGN UNAPMEETEI MAYEK VOWEL SIGN CHEINAPMEETEI MAYE" +
	"K VOWEL SIGN NUNGMEETEI MAYEK CHEIKHEIMEETEI MAYEK LUM IYEKMEETEI MAYEK " +
	"APUN IYEKMEETEI MAYEK DIGIT ZEROMEETEI MAYEK DIGIT ONEMEETEI MAYEK DIGIT" +
	" TWOMEETEI MAYEK DIGIT THREEMEETEI MAYEK DIGIT FOURMEETEI MAYEK DIGIT FI" +
	"VEMEETEI MAYEK DIGIT SIXMEETEI MAYEK DIGIT SEVENMEETEI MAYEK DIGIT EIGHT" +
	"MEETEI MAYEK DIGIT NINEHANGUL JUNGSEONG O-YEOHANGUL JUNGSEONG O-O-IHANGU") + ("" +
	"L JUNGSEONG YO-AHANGUL JUNGSEONG YO-AEHANGUL JUNGSEONG YO-EOHANGUL JUNGS" +
	"EONG U-YEOHANGUL JUNGSEONG U-I-IHANGUL JUNGSEONG YU-AEHANGUL JUNGSEONG Y" +
	"U-OHANGUL JUNGSEONG EU-AHANGUL JUNGSEONG EU-EOHANGUL JUNGSEONG EU-EHANGU" +
	"L JUNGSEONG EU-OHANGUL JUNGSEONG I-YA-OHANGUL JUNGSEONG I-YAEHANGUL JUNG" +
	"SEONG I-YEOHANGUL JUNGSEONG I-YEHANGUL JUNGSEONG I-O-IHANGUL JUNGSEONG I" +
	"-YOHANGUL JUNGSEONG I-YUHANGUL JUNGSEONG I-IHANGUL JUNGSEONG ARAEA-AHANG" +
	"UL JUNGSEONG ARAEA-EHANGUL JONGSEONG NIEUN-RIEULHANGUL JONGSEONG NIEUN-C" +
	"HIEUCHHANGUL JONGSEONG SSANGTIKEUTHANGUL JONGSEONG SSANGTIKEUT-PIEUPHANG" +
	"UL JONGSEONG TIKEUT-PIEUPHANGUL JONGSEONG TIKEUT-SIOSHANGUL JONGSEONG TI" +
	"KEUT-SIOS-KIYEOKHANGUL JONGSEONG TIKEUT-CIEUCHANGUL JONGSEONG TIKEUT-CHI" +
	"EUCHHANGUL JONGSEONG TIKEUT-THIEUTHHANGUL JONGSEONG RIEUL-SSANGKIYEOKHAN" +
	"GUL JONGSEONG RIEUL-KIYEOK-HIEUHHANGUL JONGSEONG SSANGRIEUL-KHIEUKHHANGU" +
	"L JONGSEONG RIEUL-MIEUM-HIEUHHANGUL JONGSEONG RIEUL-PIEUP-TIKEUTHANGUL J" +
	"ONGSEONG RIEUL-PIEUP-PHIEUPHHANGUL JONGSEONG RIEUL-YESIEUNGHANGUL JONGSE" +
	"ONG RIEUL-YEORINHIEUH-HIEUHHANGUL JONGSEONG KAPYEOUNRIEULHANGUL JONGSEON" +
	"G MIEUM-NIEUNHANGUL JONGSEONG MIEUM-SSANGNIEUNHANGUL JONGSEONG SSANGMIEU" +
	"MHANGUL JONGSEONG MIEUM-PIEUP-SIOSHANGUL JONGSEONG MIEUM-CIEUCHANGUL JON" +
	"GSEONG PIEUP-TIKEUTHANGUL JONGSEONG PIEUP-RIEUL-PHIEUPHHANGUL JONGSEONG " +
	"PIEUP-MIEUMHANGUL JONGSEONG SSANGPIEUPHANGUL JONGSEONG PIEUP-SIOS-TIKEUT" +
	"HANGUL JONGSEONG PIEUP-CIEUCHANGUL JONGSEONG PIEUP-CHIEUCHHANGUL JONGSEO" +
	"NG SIOS-MIEUMHANGUL JONGSEONG SIOS-KAPYEOUNPIEUPHANGUL JONGSEONG SSANGSI" +
	"OS-KIYEOKHANGUL JONGSEONG SSANGSIOS-TIKEUTHANGUL JONGSEONG SIOS-PANSIOSH" +
	"ANGUL JONGSEONG SIOS-CIEUCHANGUL JONGSEONG SIOS-CHIEUCHHANGUL JONGSEONG " +
	"SIOS-THIEUTHHANGUL JONGSEONG SIOS-HIEUHHANGUL JONGSEONG PANSIOS-PIEUPHAN" +
	"GUL JONGSEONG PANSIOS-KAPYEOUNPIEUPHANGUL JONGSEONG YESIEUNG-MIEUMHANGUL" +
	" JONGSEONG YESIEUNG-HIEUHHANGUL JONGSEONG CIEUC-PIEUPHANGUL JONGSEONG CI" +
	"EUC-SSANGPIEUPHANGUL JONGSEONG SSANGCIEUCHANGUL JONGSEONG PHIEUPH-SIOSHA" +
	"NGUL JONGSEONG PHIEUPH-THIEUTHCJK COMPATIBILITY IDEOGRAPH-F900CJK COMPAT" +
	"IBILITY IDEOGRAPH-F901CJK COMPATIBILITY IDEOGRAPH-F902CJK COMPATIBILITY " +
	"IDEOGRAPH-F903CJK COMPATIBILITY IDEOGRAPH-F904CJK COMPATIBILITY IDEOGRAP" +
	"H-F905CJK COMPATIBILITY IDEOGRAPH-F906CJK COMPATIBILITY IDEOGRAPH-F907CJ" +
	"K COMPATIBILITY IDEOGRAPH-F908CJK COMPATIBILITY IDEOGRAPH-F909CJK COMPAT" +
	"IBILITY IDEOGRAPH-F90ACJK COMPATIBILITY IDEOGRAPH-F90BCJK COMPATIBILITY " +
	"IDEOGRAPH-F90CCJK COMPATIBILITY IDEOGRAPH-F90DCJK COMPATIBILITY IDEOGRAP" +
	"H-F90ECJK COMPATIBILITY IDEOGRAPH-F90FCJK COMPATIBILITY IDEOGRAPH-F910CJ" +
	"K COMPATIBILITY IDEOGRAPH-F911CJK COMPATIBILITY IDEOGRAPH-F912CJK COMPAT" +
	"IBILITY IDEOGRAPH-F913CJK COMPATIBILITY IDEOGRAPH-F914CJK COMPATIBILITY " +
	"IDEOGRAPH-F915CJK COMPATIBILITY IDEOGRAPH-F916CJK COMPATIBILITY IDEOGRAP" +
	"H-F917CJK COMPATIBILITY IDEOGRAPH-F918CJK COMPATIBILITY IDEOGRAPH-F919CJ" +
	"K COMPATIBILITY IDEOGRAPH-F91ACJK COMPATIBILITY IDEOGRAPH-F91BCJK COMPAT" +
	"IBILITY IDEOGRAPH-F91CCJK COMPATIBILITY IDEOGRAPH-F91DCJK COMPATIBILITY " +
	"IDEOGRAPH-F91ECJK COMPATIBILITY IDEOGRAPH-F91FCJK COMPATIBILITY IDEOGRAP" +
	"H-F920CJK COMPATIBILITY IDEOGRAPH-F921CJK COMPATIBILITY IDEOGRAPH-F922CJ" +
	"K COMPATIBILITY IDEOGRAPH-F923CJK COMPATIBILITY IDEOGRAPH-F924CJK COMPAT" +
	"IBILITY IDEOGRAPH-F925CJK COMPATIBILITY IDEOGRAPH-F926CJK COMPATIBILITY " +
	"IDEOGRAPH-F927CJK COMPATIBILITY IDEOGRAPH-F928CJK COMPATIBILITY IDEOGRAP" +
	"H-F929CJK COMPATIBILITY IDEOGRAPH-F92ACJK COMPATIBILITY IDEOGRAPH-F92BCJ" +
	"K COMPATIBILITY IDEOGRAPH-F92CCJK COMPATIBILITY IDEOGRAPH-F92DCJK COMPAT" +
	"IBILITY IDEOGRAPH-F92ECJK COMPATIBILITY IDEOGRAPH-F92FCJK COMPATIBILITY " +
	"IDEOGRAPH-F930CJK COMPATIBILITY IDEOGRAPH-F931CJK COMPATIBILITY IDEOGRAP" +
	"H-F932CJK COMPATIBILITY IDEOGRAPH-F933CJK COMPATIBILITY IDEOGRAPH-F934CJ" +
	"K COMPATIBILITY IDEOGRAPH-F935CJK COMPATIBILITY IDEOGRAPH-F936CJK COMPAT" +
	"IBILITY IDEOGRAPH-F937CJK COMPATIBILITY IDEOGRAPH-F938CJK COMPATIBILITY " +
	"IDEOGRAPH-F939CJK COMPATIBILITY IDEOGRAPH-F93ACJK COMPATIBILITY IDEOGRAP" +
	"H-F93BCJK COMPATIBILITY IDEOGRAPH-F93CCJK COMPATIBILITY IDEOGRAPH-F93DCJ" +
	"K COMPATIBILITY IDEOGRAPH-F93ECJK COMPATIBILITY IDEOGRAPH-F93FCJK COMPAT" +
	"IBILITY IDEOGRAPH-F940CJK COMPATIBILITY IDEOGRAPH-F941CJK COMPATIBILITY " +
	"IDEOGRAPH-F942CJK COMPATIBILITY IDEOGRAPH-F943CJK COMPATIBILITY IDEOGRAP" +
	"H-F944CJK COMPATIBILITY IDEOGRAPH-F945CJK COMPATIBILITY IDEOGRAPH-F946CJ" +
	"K COMPATIBILITY IDEOGRAPH-F947CJK COMPATIBILITY IDEOGRAPH-F948CJK COMPAT" +
	"IBILITY IDEOGRAPH-F949CJK COMPATIBILITY IDEOGRAPH-F94ACJK COMPATIBILITY " +
	"IDEOGRAPH-F94BCJK COMPATIBILITY IDEOGRAPH-F94CCJK COMPATIBILITY IDEOGRAP" +
	"H-F94DCJK COMPATIBILITY IDEOGRAPH-F94ECJK COMPATIBILITY IDEOGRAPH-F94FCJ" +
	"K COMPATIBILITY IDEOGRAPH-F950CJK COMPATIBILITY IDEOGRAPH-F951CJK COMPAT") + ("" +
	"IBILITY IDEOGRAPH-F952CJK COMPATIBILITY IDEOGRAPH-F953CJK COMPATIBILITY " +
	"IDEOGRAPH-F954CJK COMPATIBILITY IDEOGRAPH-F955CJK COMPATIBILITY IDEOGRAP" +
	"H-F956CJK COMPATIBILITY IDEOGRAPH-F957CJK COMPATIBILITY IDEOGRAPH-F958CJ" +
	"K COMPATIBILITY IDEOGRAPH-F959CJK COMPATIBILITY IDEOGRAPH-F95ACJK COMPAT" +
	"IBILITY IDEOGRAPH-F95BCJK COMPATIBILITY IDEOGRAPH-F95CCJK COMPATIBILITY " +
	"IDEOGRAPH-F95DCJK COMPATIBILITY IDEOGRAPH-F95ECJK COMPATIBILITY IDEOGRAP" +
	"H-F95FCJK COMPATIBILITY IDEOGRAPH-F960CJK COMPATIBILITY IDEOGRAPH-F961CJ" +
	"K COMPATIBILITY IDEOGRAPH-F962CJK COMPATIBILITY IDEOGRAPH-F963CJK COMPAT" +
	"IBILITY IDEOGRAPH-F964CJK COMPATIBILITY IDEOGRAPH-F965CJK COMPATIBILITY " +
	"IDEOGRAPH-F966CJK COMPATIBILITY IDEOGRAPH-F967CJK COMPATIBILITY IDEOGRAP" +
	"H-F968CJK COMPATIBILITY IDEOGRAPH-F969CJK COMPATIBILITY IDEOGRAPH-F96ACJ" +
	"K COMPATIBILITY IDEOGRAPH-F96BCJK COMPATIBILITY IDEOGRAPH-F96CCJK COMPAT" +
	"IBILITY IDEOGRAPH-F96DCJK COMPATIBILITY IDEOGRAPH-F96ECJK COMPATIBILITY " +
	"IDEOGRAPH-F96FCJK COMPATIBILITY IDEOGRAPH-F970CJK COMPATIBILITY IDEOGRAP" +
	"H-F971CJK COMPATIBILITY IDEOGRAPH-F972CJK COMPATIBILITY IDEOGRAPH-F973CJ" +
	"K COMPATIBILITY IDEOGRAPH-F974CJK COMPATIBILITY IDEOGRAPH-F975CJK COMPAT" +
	"IBILITY IDEOGRAPH-F976CJK COMPATIBILITY IDEOGRAPH-F977CJK COMPATIBILITY " +
	"IDEOGRAPH-F978CJK COMPATIBILITY IDEOGRAPH-F979CJK COMPATIBILITY IDEOGRAP" +
	"H-F97ACJK COMPATIBILITY IDEOGRAPH-F97BCJK COMPATIBILITY IDEOGRAPH-F97CCJ" +
	"K COMPATIBILITY IDEOGRAPH-F97DCJK COMPATIBILITY IDEOGRAPH-F97ECJK COMPAT" +
	"IBILITY IDEOGRAPH-F97FCJK COMPATIBILITY IDEOGRAPH-F980CJK COMPATIBILITY " +
	"IDEOGRAPH-F981CJK COMPATIBILITY IDEOGRAPH-F982CJK COMPATIBILITY IDEOGRAP" +
	"H-F983CJK COMPATIBILITY IDEOGRAPH-F984CJK COMPATIBILITY IDEOGRAPH-F985CJ" +
	"K COMPATIBILITY IDEOGRAPH-F986CJK COMPATIBILITY IDEOGRAPH-F987CJK COMPAT" +
	"IBILITY IDEOGRAPH-F988CJK COMPATIBILITY IDEOGRAPH-F989CJK COMPATIBILITY " +
	"IDEOGRAPH-F98ACJK COMPATIBILITY IDEOGRAPH-F98BCJK COMPATIBILITY IDEOGRAP" +
	"H-F98CCJK COMPATIBILITY IDEOGRAPH-F98DCJK COMPATIBILITY IDEOGRAPH-F98ECJ" +
	"K COMPATIBILITY IDEOGRAPH-F98FCJK COMPATIBILITY IDEOGRAPH-F990CJK COMPAT" +
	"IBILITY IDEOGRAPH-F991CJK COMPATIBILITY IDEOGRAPH-F992CJK COMPATIBILITY " +
	"IDEOGRAPH-F993CJK COMPATIBILITY IDEOGRAPH-F994CJK COMPATIBILITY IDEOGRAP" +
	"H-F995CJK COMPATIBILITY IDEOGRAPH-F996CJK COMPATIBILITY IDEOGRAPH-F997CJ" +
	"K COMPATIBILITY IDEOGRAPH-F998CJK COMPATIBILITY IDEOGRAPH-F999CJK COMPAT" +
	"IBILITY IDEOGRAPH-F99ACJK COMPATIBILITY IDEOGRAPH-F99BCJK COMPATIBILITY " +
	"IDEOGRAPH-F99CCJK COMPATIBILITY IDEOGRAPH-F99DCJK COMPATIBILITY IDEOGRAP" +
	"H-F99ECJK COMPATIBILITY IDEOGRAPH-F99FCJK COMPATIBILITY IDEOGRAPH-F9A0CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9A1CJK COMPATIBILITY IDEOGRAPH-F9A2CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9A3CJK COMPATIBILITY IDEOGRAPH-F9A4CJK COMPATIBILITY " +
	"IDEOGRAPH-F9A5CJK COMPATIBILITY IDEOGRAPH-F9A6CJK COMPATIBILITY IDEOGRAP" +
	"H-F9A7CJK COMPATIBILITY IDEOGRAPH-F9A8CJK COMPATIBILITY IDEOGRAPH-F9A9CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9AACJK COMPATIBILITY IDEOGRAPH-F9ABCJK COMPAT" +
	"IBILITY IDEOGRAPH-F9ACCJK COMPATIBILITY IDEOGRAPH-F9ADCJK COMPATIBILITY " +
	"IDEOGRAPH-F9AECJK COMPATIBILITY IDEOGRAPH-F9AFCJK COMPATIBILITY IDEOGRAP" +
	"H-F9B0CJK COMPATIBILITY IDEOGRAPH-F9B1CJK COMPATIBILITY IDEOGRAPH-F9B2CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9B3CJK COMPATIBILITY IDEOGRAPH-F9B4CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9B5CJK COMPATIBILITY IDEOGRAPH-F9B6CJK COMPATIBILITY " +
	"IDEOGRAPH-F9B7CJK COMPATIBILITY IDEOGRAPH-F9B8CJK COMPATIBILITY IDEOGRAP" +
	"H-F9B9CJK COMPATIBILITY IDEOGRAPH-F9BACJK COMPATIBILITY IDEOGRAPH-F9BBCJ" +
	"K COMPATIBILITY IDEOGRAPH-F9BCCJK COMPATIBILITY IDEOGRAPH-F9BDCJK COMPAT" +
	"IBILITY IDEOGRAPH-F9BECJK COMPATIBILITY IDEOGRAPH-F9BFCJK COMPATIBILITY " +
	"IDEOGRAPH-F9C0CJK COMPATIBILITY IDEOGRAPH-F9C1CJK COMPATIBILITY IDEOGRAP" +
	"H-F9C2CJK COMPATIBILITY IDEOGRAPH-F9C3CJK COMPATIBILITY IDEOGRAPH-F9C4CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9C5CJK COMPATIBILITY IDEOGRAPH-F9C6CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9C7CJK COMPATIBILITY IDEOGRAPH-F9C8CJK COMPATIBILITY " +
	"IDEOGRAPH-F9C9CJK COMPATIBILITY IDEOGRAPH-F9CACJK COMPATIBILITY IDEOGRAP" +
	"H-F9CBCJK COMPATIBILITY IDEOGRAPH-F9CCCJK COMPATIBILITY IDEOGRAPH-F9CDCJ" +
	"K COMPATIBILITY IDEOGRAPH-F9CECJK COMPATIBILITY IDEOGRAPH-F9CFCJK COMPAT" +
	"IBILITY IDEOGRAPH-F9D0CJK COMPATIBILITY IDEOGRAPH-F9D1CJK COMPATIBILITY " +
	"IDEOGRAPH-F9D2CJK COMPATIBILITY IDEOGRAPH-F9D3CJK COMPATIBILITY IDEOGRAP" +
	"H-F9D4CJK COMPATIBILITY IDEOGRAPH-F9D5CJK COMPATIBILITY IDEOGRAPH-F9D6CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9D7CJK COMPATIBILITY IDEOGRAPH-F9D8CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9D9CJK COMPATIBILITY IDEOGRAPH-F9DACJK COMPATIBILITY " +
	"IDEOGRAPH-F9DBCJK COMPATIBILITY IDEOGRAPH-F9DCCJK COMPATIBILITY IDEOGRAP" +
	"H-F9DDCJK COMPATIBILITY IDEOGRAPH-F9DECJK COMPATIBILITY IDEOGRAPH-F9DFCJ" +
	"K COMPATIBILITY IDEOGRAPH-F9E0CJK COMPATIBILITY IDEOGRAPH-F9E1CJK COMPAT") + ("" +
	"IBILITY IDEOGRAPH-F9E2CJK COMPATIBILITY IDEOGRAPH-F9E3CJK COMPATIBILITY " +
	"IDEOGRAPH-F9E4CJK COMPATIBILITY IDEOGRAPH-F9E5CJK COMPATIBILITY IDEOGRAP" +
	"H-F9E6CJK COMPATIBILITY IDEOGRAPH-F9E7CJK COMPATIBILITY IDEOGRAPH-F9E8CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9E9CJK COMPATIBILITY IDEOGRAPH-F9EACJK COMPAT" +
	"IBILITY IDEOGRAPH-F9EBCJK COMPATIBILITY IDEOGRAPH-F9ECCJK COMPATIBILITY " +
	"IDEOGRAPH-F9EDCJK COMPATIBILITY IDEOGRAPH-F9EECJK COMPATIBILITY IDEOGRAP" +
	"H-F9EFCJK COMPATIBILITY IDEOGRAPH-F9F0CJK COMPATIBILITY IDEOGRAPH-F9F1CJ" +
	"K COMPATIBILITY IDEOGRAPH-F9F2CJK COMPATIBILITY IDEOGRAPH-F9F3CJK COMPAT" +
	"IBILITY IDEOGRAPH-F9F4CJK COMPATIBILITY IDEOGRAPH-F9F5CJK COMPATIBILITY " +
	"IDEOGRAPH-F9F6CJK COMPATIBILITY IDEOGRAPH-F9F7CJK COMPATIBILITY IDEOGRAP" +
	"H-F9F8CJK COMPATIBILITY IDEOGRAPH-F9F9CJK COMPATIBILITY IDEOGRAPH-F9FACJ" +
	"K COMPATIBILITY IDEOGRAPH-F9FBCJK COMPATIBILITY IDEOGRAPH-F9FCCJK COMPAT" +
	"IBILITY IDEOGRAPH-F9FDCJK COMPATIBILITY IDEOGRAPH-F9FECJK COMPATIBILITY " +
	"IDEOGRAPH-F9FFCJK COMPATIBILITY IDEOGRAPH-FA00CJK COMPATIBILITY IDEOGRAP" +
	"H-FA01CJK COMPATIBILITY IDEOGRAPH-FA02CJK COMPATIBILITY IDEOGRAPH-FA03CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA04CJK COMPATIBILITY IDEOGRAPH-FA05CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA06CJK COMPATIBILITY IDEOGRAPH-FA07CJK COMPATIBILITY " +
	"IDEOGRAPH-FA08CJK COMPATIBILITY IDEOGRAPH-FA09CJK COMPATIBILITY IDEOGRAP" +
	"H-FA0ACJK COMPATIBILITY IDEOGRAPH-FA0BCJK COMPATIBILITY IDEOGRAPH-FA0CCJ" +
	"K COMPATIBILITY IDEOGRAPH-FA0DCJK COMPATIBILITY IDEOGRAPH-FA0ECJK COMPAT" +
	"IBILITY IDEOGRAPH-FA0FCJK COMPATIBILITY IDEOGRAPH-FA10CJK COMPATIBILITY " +
	"IDEOGRAPH-FA11CJK COMPATIBILITY IDEOGRAPH-FA12CJK COMPATIBILITY IDEOGRAP" +
	"H-FA13CJK COMPATIBILITY IDEOGRAPH-FA14CJK COMPATIBILITY IDEOGRAPH-FA15CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA16CJK COMPATIBILITY IDEOGRAPH-FA17CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA18CJK COMPATIBILITY IDEOGRAPH-FA19CJK COMPATIBILITY " +
	"IDEOGRAPH-FA1ACJK COMPATIBILITY IDEOGRAPH-FA1BCJK COMPATIBILITY IDEOGRAP" +
	"H-FA1CCJK COMPATIBILITY IDEOGRAPH-FA1DCJK COMPATIBILITY IDEOGRAPH-FA1ECJ" +
	"K COMPATIBILITY IDEOGRAPH-FA1FCJK COMPATIBILITY IDEOGRAPH-FA20CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA21CJK COMPATIBILITY IDEOGRAPH-FA22CJK COMPATIBILITY " +
	"IDEOGRAPH-FA23CJK COMPATIBILITY IDEOGRAPH-FA24CJK COMPATIBILITY IDEOGRAP" +
	"H-FA25CJK COMPATIBILITY IDEOGRAPH-FA26CJK COMPATIBILITY IDEOGRAPH-FA27CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA28CJK COMPATIBILITY IDEOGRAPH-FA29CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA2ACJK COMPATIBILITY IDEOGRAPH-FA2BCJK COMPATIBILITY " +
	"IDEOGRAPH-FA2CCJK COMPATIBILITY IDEOGRAPH-FA2DCJK COMPATIBILITY IDEOGRAP" +
	"H-FA2ECJK COMPATIBILITY IDEOGRAPH-FA2FCJK COMPATIBILITY IDEOGRAPH-FA30CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA31CJK COMPATIBILITY IDEOGRAPH-FA32CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA33CJK COMPATIBILITY IDEOGRAPH-FA34CJK COMPATIBILITY " +
	"IDEOGRAPH-FA35CJK COMPATIBILITY IDEOGRAPH-FA36CJK COMPATIBILITY IDEOGRAP" +
	"H-FA37CJK COMPATIBILITY IDEOGRAPH-FA38CJK COMPATIBILITY IDEOGRAPH-FA39CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA3ACJK COMPATIBILITY IDEOGRAPH-FA3BCJK COMPAT" +
	"IBILITY IDEOGRAPH-FA3CCJK COMPATIBILITY IDEOGRAPH-FA3DCJK COMPATIBILITY " +
	"IDEOGRAPH-FA3ECJK COMPATIBILITY IDEOGRAPH-FA3FCJK COMPATIBILITY IDEOGRAP" +
	"H-FA40CJK COMPATIBILITY IDEOGRAPH-FA41CJK COMPATIBILITY IDEOGRAPH-FA42CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA43CJK COMPATIBILITY IDEOGRAPH-FA44CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA45CJK COMPATIBILITY IDEOGRAPH-FA46CJK COMPATIBILITY " +
	"IDEOGRAPH-FA47CJK COMPATIBILITY IDEOGRAPH-FA48CJK COMPATIBILITY IDEOGRAP" +
	"H-FA49CJK COMPATIBILITY IDEOGRAPH-FA4ACJK COMPATIBILITY IDEOGRAPH-FA4BCJ" +
	"K COMPATIBILITY IDEOGRAPH-FA4CCJK COMPATIBILITY IDEOGRAPH-FA4DCJK COMPAT" +
	"IBILITY IDEOGRAPH-FA4ECJK COMPATIBILITY IDEOGRAPH-FA4FCJK COMPATIBILITY " +
	"IDEOGRAPH-FA50CJK COMPATIBILITY IDEOGRAPH-FA51CJK COMPATIBILITY IDEOGRAP" +
	"H-FA52CJK COMPATIBILITY IDEOGRAPH-FA53CJK COMPATIBILITY IDEOGRAPH-FA54CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA55CJK COMPATIBILITY IDEOGRAPH-FA56CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA57CJK COMPATIBILITY IDEOGRAPH-FA58CJK COMPATIBILITY " +
	"IDEOGRAPH-FA59CJK COMPATIBILITY IDEOGRAPH-FA5ACJK COMPATIBILITY IDEOGRAP" +
	"H-FA5BCJK COMPATIBILITY IDEOGRAPH-FA5CCJK COMPATIBILITY IDEOGRAPH-FA5DCJ" +
	"K COMPATIBILITY IDEOGRAPH-FA5ECJK COMPATIBILITY IDEOGRAPH-FA5FCJK COMPAT" +
	"IBILITY IDEOGRAPH-FA60CJK COMPATIBILITY IDEOGRAPH-FA61CJK COMPATIBILITY " +
	"IDEOGRAPH-FA62CJK COMPATIBILITY IDEOGRAPH-FA63CJK COMPATIBILITY IDEOGRAP" +
	"H-FA64CJK COMPATIBILITY IDEOGRAPH-FA65CJK COMPATIBILITY IDEOGRAPH-FA66CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA67CJK COMPATIBILITY IDEOGRAPH-FA68CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA69CJK COMPATIBILITY IDEOGRAPH-FA6ACJK COMPATIBILITY " +
	"IDEOGRAPH-FA6BCJK COMPATIBILITY IDEOGRAPH-FA6CCJK COMPATIBILITY IDEOGRAP" +
	"H-FA6DCJK COMPATIBILITY IDEOGRAPH-FA70CJK COMPATIBILITY IDEOGRAPH-FA71CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA72CJK COMPATIBILITY IDEOGRAPH-FA73CJK COMPAT") + ("" +
	"IBILITY IDEOGRAPH-FA74CJK COMPATIBILITY IDEOGRAPH-FA75CJK COMPATIBILITY " +
	"IDEOGRAPH-FA76CJK COMPATIBILITY IDEOGRAPH-FA77CJK COMPATIBILITY IDEOGRAP" +
	"H-FA78CJK COMPATIBILITY IDEOGRAPH-FA79CJK COMPATIBILITY IDEOGRAPH-FA7ACJ" +
	"K COMPATIBILITY IDEOGRAPH-FA7BCJK COMPATIBILITY IDEOGRAPH-FA7CCJK COMPAT" +
	"IBILITY IDEOGRAPH-FA7DCJK COMPATIBILITY IDEOGRAPH-FA7ECJK COMPATIBILITY " +
	"IDEOGRAPH-FA7FCJK COMPATIBILITY IDEOGRAPH-FA80CJK COMPATIBILITY IDEOGRAP" +
	"H-FA81CJK COMPATIBILITY IDEOGRAPH-FA82CJK COMPATIBILITY IDEOGRAPH-FA83CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA84CJK COMPATIBILITY IDEOGRAPH-FA85CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA86CJK COMPATIBILITY IDEOGRAPH-FA87CJK COMPATIBILITY " +
	"IDEOGRAPH-FA88CJK COMPATIBILITY IDEOGRAPH-FA89CJK COMPATIBILITY IDEOGRAP" +
	"H-FA8ACJK COMPATIBILITY IDEOGRAPH-FA8BCJK COMPATIBILITY IDEOGRAPH-FA8CCJ" +
	"K COMPATIBILITY IDEOGRAPH-FA8DCJK COMPATIBILITY IDEOGRAPH-FA8ECJK COMPAT" +
	"IBILITY IDEOGRAPH-FA8FCJK COMPATIBILITY IDEOGRAPH-FA90CJK COMPATIBILITY " +
	"IDEOGRAPH-FA91CJK COMPATIBILITY IDEOGRAPH-FA92CJK COMPATIBILITY IDEOGRAP" +
	"H-FA93CJK COMPATIBILITY IDEOGRAPH-FA94CJK COMPATIBILITY IDEOGRAPH-FA95CJ" +
	"K COMPATIBILITY IDEOGRAPH-FA96CJK COMPATIBILITY IDEOGRAPH-FA97CJK COMPAT" +
	"IBILITY IDEOGRAPH-FA98CJK COMPATIBILITY IDEOGRAPH-FA99CJK COMPATIBILITY " +
	"IDEOGRAPH-FA9ACJK COMPATIBILITY IDEOGRAPH-FA9BCJK COMPATIBILITY IDEOGRAP" +
	"H-FA9CCJK COMPATIBILITY IDEOGRAPH-FA9DCJK COMPATIBILITY IDEOGRAPH-FA9ECJ" +
	"K COMPATIBILITY IDEOGRAPH-FA9FCJK COMPATIBILITY IDEOGRAPH-FAA0CJK COMPAT" +
	"IBILITY IDEOGRAPH-FAA1CJK COMPATIBILITY IDEOGRAPH-FAA2CJK COMPATIBILITY " +
	"IDEOGRAPH-FAA3CJK COMPATIBILITY IDEOGRAPH-FAA4CJK COMPATIBILITY IDEOGRAP" +
	"H-FAA5CJK COMPATIBILITY IDEOGRAPH-FAA6CJK COMPATIBILITY IDEOGRAPH-FAA7CJ" +
	"K COMPATIBILITY IDEOGRAPH-FAA8CJK COMPATIBILITY IDEOGRAPH-FAA9CJK COMPAT" +
	"IBILITY IDEOGRAPH-FAAACJK COMPATIBILITY IDEOGRAPH-FAABCJK COMPATIBILITY " +
	"IDEOGRAPH-FAACCJK COMPATIBILITY IDEOGRAPH-FAADCJK COMPATIBILITY IDEOGRAP" +
	"H-FAAECJK COMPATIBILITY IDEOGRAPH-FAAFCJK COMPATIBILITY IDEOGRAPH-FAB0CJ" +
	"K COMPATIBILITY IDEOGRAPH-FAB1CJK COMPATIBILITY IDEOGRAPH-FAB2CJK COMPAT" +
	"IBILITY IDEOGRAPH-FAB3CJK COMPATIBILITY IDEOGRAPH-FAB4CJK COMPATIBILITY " +
	"IDEOGRAPH-FAB5CJK COMPATIBILITY IDEOGRAPH-FAB6CJK COMPATIBILITY IDEOGRAP" +
	"H-FAB7CJK COMPATIBILITY IDEOGRAPH-FAB8CJK COMPATIBILITY IDEOGRAPH-FAB9CJ" +
	"K COMPATIBILITY IDEOGRAPH-FABACJK COMPATIBILITY IDEOGRAPH-FABBCJK COMPAT" +
	"IBILITY IDEOGRAPH-FABCCJK COMPATIBILITY IDEOGRAPH-FABDCJK COMPATIBILITY " +
	"IDEOGRAPH-FABECJK COMPATIBILITY IDEOGRAPH-FABFCJK COMPATIBILITY IDEOGRAP" +
	"H-FAC0CJK COMPATIBILITY IDEOGRAPH-FAC1CJK COMPATIBILITY IDEOGRAPH-FAC2CJ" +
	"K COMPATIBILITY IDEOGRAPH-FAC3CJK COMPATIBILITY IDEOGRAPH-FAC4CJK COMPAT" +
	"IBILITY IDEOGRAPH-FAC5CJK COMPATIBILITY IDEOGRAPH-FAC6CJK COMPATIBILITY " +
	"IDEOGRAPH-FAC7CJK COMPATIBILITY IDEOGRAPH-FAC8CJK COMPATIBILITY IDEOGRAP" +
	"H-FAC9CJK COMPATIBILITY IDEOGRAPH-FACACJK COMPATIBILITY IDEOGRAPH-FACBCJ" +
	"K COMPATIBILITY IDEOGRAPH-FACCCJK COMPATIBILITY IDEOGRAPH-FACDCJK COMPAT" +
	"IBILITY IDEOGRAPH-FACECJK COMPATIBILITY IDEOGRAPH-FACFCJK COMPATIBILITY " +
	"IDEOGRAPH-FAD0CJK COMPATIBILITY IDEOGRAPH-FAD1CJK COMPATIBILITY IDEOGRAP" +
	"H-FAD2CJK COMPATIBILITY IDEOGRAPH-FAD3CJK COMPATIBILITY IDEOGRAPH-FAD4CJ" +
	"K COMPATIBILITY IDEOGRAPH-FAD5CJK COMPATIBILITY IDEOGRAPH-FAD6CJK COMPAT" +
	"IBILITY IDEOGRAPH-FAD7CJK COMPATIBILITY IDEOGRAPH-FAD8CJK COMPATIBILITY " +
	"IDEOGRAPH-FAD9LATIN SMALL LIGATURE FFLATIN SMALL LIGATURE FILATIN SMALL " +
	"LIGATURE FLLATIN SMALL LIGATURE FFILATIN SMALL LIGATURE FFLLATIN SMALL L" +
	"IGATURE LONG S TLATIN SMALL LIGATURE STARMENIAN SMALL LIGATURE MEN NOWAR" +
	"MENIAN SMALL LIGATURE MEN ECHARMENIAN SMALL LIGATURE MEN INIARMENIAN SMA" +
	"LL LIGATURE VEW NOWARMENIAN SMALL LIGATURE MEN XEHHEBREW LETTER YOD WITH" +
	" HIRIQHEBREW POINT JUDEO-SPANISH VARIKAHEBREW LIGATURE YIDDISH YOD YOD P" +
	"ATAHHEBREW LETTER ALTERNATIVE AYINHEBREW LETTER WIDE ALEFHEBREW LETTER W" +
	"IDE DALETHEBREW LETTER WIDE HEHEBREW LETTER WIDE KAFHEBREW LETTER WIDE L" +
	"AMEDHEBREW LETTER WIDE FINAL MEMHEBREW LETTER WIDE RESHHEBREW LETTER WID" +
	"E TAVHEBREW LETTER ALTERNATIVE PLUS SIGNHEBREW LETTER SHIN WITH SHIN DOT" +
	"HEBREW LETTER SHIN WITH SIN DOTHEBREW LETTER SHIN WITH DAGESH AND SHIN D" +
	"OTHEBREW LETTER SHIN WITH DAGESH AND SIN DOTHEBREW LETTER ALEF WITH PATA" +
	"HHEBREW LETTER ALEF WITH QAMATSHEBREW LETTER ALEF WITH MAPIQHEBREW LETTE" +
	"R BET WITH DAGESHHEBREW LETTER GIMEL WITH DAGESHHEBREW LETTER DALET WITH" +
	" DAGESHHEBREW LETTER HE WITH MAPIQHEBREW LETTER VAV WITH DAGESHHEBREW LE" +
	"TTER ZAYIN WITH DAGESHHEBREW LETTER TET WITH DAGESHHEBREW LETTER YOD WIT" +
	"H DAGESHHEBREW LETTER FINAL KAF WITH DAGESHHEBREW LETTER KAF WITH DAGESH" +
	"HEBREW LETTER LAMED WITH DAGESHHEBREW LETTER MEM WITH DAGESHHEBREW LETTE" +
	"R NUN WITH DAGESHHEBREW LETTER SAMEKH WITH DAGESHHEBREW LETTER FINAL PE ") + ("" +
	"WITH DAGESHHEBREW LETTER PE WITH DAGESHHEBREW LETTER TSADI WITH DAGESHHE" +
	"BREW LETTER QOF WITH DAGESHHEBREW LETTER RESH WITH DAGESHHEBREW LETTER S" +
	"HIN WITH DAGESHHEBREW LETTER TAV WITH DAGESHHEBREW LETTER VAV WITH HOLAM" +
	"HEBREW LETTER BET WITH RAFEHEBREW LETTER KAF WITH RAFEHEBREW LETTER PE W" +
	"ITH RAFEHEBREW LIGATURE ALEF LAMEDARABIC LETTER ALEF WASLA ISOLATED FORM" +
	"ARABIC LETTER ALEF WASLA FINAL FORMARABIC LETTER BEEH ISOLATED FORMARABI" +
	"C LETTER BEEH FINAL FORMARABIC LETTER BEEH INITIAL FORMARABIC LETTER BEE" +
	"H MEDIAL FORMARABIC LETTER PEH ISOLATED FORMARABIC LETTER PEH FINAL FORM" +
	"ARABIC LETTER PEH INITIAL FORMARABIC LETTER PEH MEDIAL FORMARABIC LETTER" +
	" BEHEH ISOLATED FORMARABIC LETTER BEHEH FINAL FORMARABIC LETTER BEHEH IN" +
	"ITIAL FORMARABIC LETTER BEHEH MEDIAL FORMARABIC LETTER TTEHEH ISOLATED F" +
	"ORMARABIC LETTER TTEHEH FINAL FORMARABIC LETTER TTEHEH INITIAL FORMARABI" +
	"C LETTER TTEHEH MEDIAL FORMARABIC LETTER TEHEH ISOLATED FORMARABIC LETTE" +
	"R TEHEH FINAL FORMARABIC LETTER TEHEH INITIAL FORMARABIC LETTER TEHEH ME" +
	"DIAL FORMARABIC LETTER TTEH ISOLATED FORMARABIC LETTER TTEH FINAL FORMAR" +
	"ABIC LETTER TTEH INITIAL FORMARABIC LETTER TTEH MEDIAL FORMARABIC LETTER" +
	" VEH ISOLATED FORMARABIC LETTER VEH FINAL FORMARABIC LETTER VEH INITIAL " +
	"FORMARABIC LETTER VEH MEDIAL FORMARABIC LETTER PEHEH ISOLATED FORMARABIC" +
	" LETTER PEHEH FINAL FORMARABIC LETTER PEHEH INITIAL FORMARABIC LETTER PE" +
	"HEH MEDIAL FORMARABIC LETTER DYEH ISOLATED FORMARABIC LETTER DYEH FINAL " +
	"FORMARABIC LETTER DYEH INITIAL FORMARABIC LETTER DYEH MEDIAL FORMARABIC " +
	"LETTER NYEH ISOLATED FORMARABIC LETTER NYEH FINAL FORMARABIC LETTER NYEH" +
	" INITIAL FORMARABIC LETTER NYEH MEDIAL FORMARABIC LETTER TCHEH ISOLATED " +
	"FORMARABIC LETTER TCHEH FINAL FORMARABIC LETTER TCHEH INITIAL FORMARABIC" +
	" LETTER TCHEH MEDIAL FORMARABIC LETTER TCHEHEH ISOLATED FORMARABIC LETTE" +
	"R TCHEHEH FINAL FORMARABIC LETTER TCHEHEH INITIAL FORMARABIC LETTER TCHE" +
	"HEH MEDIAL FORMARABIC LETTER DDAHAL ISOLATED FORMARABIC LETTER DDAHAL FI" +
	"NAL FORMARABIC LETTER DAHAL ISOLATED FORMARABIC LETTER DAHAL FINAL FORMA" +
	"RABIC LETTER DUL ISOLATED FORMARABIC LETTER DUL FINAL FORMARABIC LETTER " +
	"DDAL ISOLATED FORMARABIC LETTER DDAL FINAL FORMARABIC LETTER JEH ISOLATE" +
	"D FORMARABIC LETTER JEH FINAL FORMARABIC LETTER RREH ISOLATED FORMARABIC" +
	" LETTER RREH FINAL FORMARABIC LETTER KEHEH ISOLATED FORMARABIC LETTER KE" +
	"HEH FINAL FORMARABIC LETTER KEHEH INITIAL FORMARABIC LETTER KEHEH MEDIAL" +
	" FORMARABIC LETTER GAF ISOLATED FORMARABIC LETTER GAF FINAL FORMARABIC L" +
	"ETTER GAF INITIAL FORMARABIC LETTER GAF MEDIAL FORMARABIC LETTER GUEH IS" +
	"OLATED FORMARABIC LETTER GUEH FINAL FORMARABIC LETTER GUEH INITIAL FORMA" +
	"RABIC LETTER GUEH MEDIAL FORMARABIC LETTER NGOEH ISOLATED FORMARABIC LET" +
	"TER NGOEH FINAL FORMARABIC LETTER NGOEH INITIAL FORMARABIC LETTER NGOEH " +
	"MEDIAL FORMARABIC LETTER NOON GHUNNA ISOLATED FORMARABIC LETTER NOON GHU" +
	"NNA FINAL FORMARABIC LETTER RNOON ISOLATED FORMARABIC LETTER RNOON FINAL" +
	" FORMARABIC LETTER RNOON INITIAL FORMARABIC LETTER RNOON MEDIAL FORMARAB" +
	"IC LETTER HEH WITH YEH ABOVE ISOLATED FORMARABIC LETTER HEH WITH YEH ABO" +
	"VE FINAL FORMARABIC LETTER HEH GOAL ISOLATED FORMARABIC LETTER HEH GOAL " +
	"FINAL FORMARABIC LETTER HEH GOAL INITIAL FORMARABIC LETTER HEH GOAL MEDI" +
	"AL FORMARABIC LETTER HEH DOACHASHMEE ISOLATED FORMARABIC LETTER HEH DOAC" +
	"HASHMEE FINAL FORMARABIC LETTER HEH DOACHASHMEE INITIAL FORMARABIC LETTE" +
	"R HEH DOACHASHMEE MEDIAL FORMARABIC LETTER YEH BARREE ISOLATED FORMARABI" +
	"C LETTER YEH BARREE FINAL FORMARABIC LETTER YEH BARREE WITH HAMZA ABOVE " +
	"ISOLATED FORMARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORMARABIC " +
	"SYMBOL DOT ABOVEARABIC SYMBOL DOT BELOWARABIC SYMBOL TWO DOTS ABOVEARABI" +
	"C SYMBOL TWO DOTS BELOWARABIC SYMBOL THREE DOTS ABOVEARABIC SYMBOL THREE" +
	" DOTS BELOWARABIC SYMBOL THREE DOTS POINTING DOWNWARDS ABOVEARABIC SYMBO" +
	"L THREE DOTS POINTING DOWNWARDS BELOWARABIC SYMBOL FOUR DOTS ABOVEARABIC" +
	" SYMBOL FOUR DOTS BELOWARABIC SYMBOL DOUBLE VERTICAL BAR BELOWARABIC SYM" +
	"BOL TWO DOTS VERTICALLY ABOVEARABIC SYMBOL TWO DOTS VERTICALLY BELOWARAB" +
	"IC SYMBOL RINGARABIC SYMBOL SMALL TAH ABOVEARABIC SYMBOL SMALL TAH BELOW" +
	"ARABIC LETTER NG ISOLATED FORMARABIC LETTER NG FINAL FORMARABIC LETTER N" +
	"G INITIAL FORMARABIC LETTER NG MEDIAL FORMARABIC LETTER U ISOLATED FORMA" +
	"RABIC LETTER U FINAL FORMARABIC LETTER OE ISOLATED FORMARABIC LETTER OE " +
	"FINAL FORMARABIC LETTER YU ISOLATED FORMARABIC LETTER YU FINAL FORMARABI" +
	"C LETTER U WITH HAMZA ABOVE ISOLATED FORMARABIC LETTER VE ISOLATED FORMA" +
	"RABIC LETTER VE FINAL FORMARABIC LETTER KIRGHIZ OE ISOLATED FORMARABIC L" +
	"ETTER KIRGHIZ OE FINAL FORMARABIC LETTER KIRGHIZ YU ISOLATED FORMARABIC " +
	"LETTER KIRGHIZ YU FINAL FORMARABIC LETTER E ISOLATED FORMARABIC LETTER E") + ("" +
	" FINAL FORMARABIC LETTER E INITIAL FORMARABIC LETTER E MEDIAL FORMARABIC" +
	" LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORMARABIC LETTER UIG" +
	"HUR KAZAKH KIRGHIZ ALEF MAKSURA MEDIAL FORMARABIC LIGATURE YEH WITH HAMZ" +
	"A ABOVE WITH ALEF ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH" +
	" ALEF FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FO" +
	"RMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORMARABIC LIGATURE" +
	" YEH WITH HAMZA ABOVE WITH WAW ISOLATED FORMARABIC LIGATURE YEH WITH HAM" +
	"ZA ABOVE WITH WAW FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U " +
	"ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORMARABI" +
	"C LIGATURE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORMARABIC LIGATURE YEH" +
	" WITH HAMZA ABOVE WITH OE FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE" +
	" WITH YU ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL" +
	" FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORMARABIC LIG" +
	"ATURE YEH WITH HAMZA ABOVE WITH E FINAL FORMARABIC LIGATURE YEH WITH HAM" +
	"ZA ABOVE WITH E INITIAL FORMARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZ" +
	"A ABOVE WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE UIGHUR KIRGHIZ YE" +
	"H WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE UIGHUR KI" +
	"RGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORMARABIC LETTER F" +
	"ARSI YEH ISOLATED FORMARABIC LETTER FARSI YEH FINAL FORMARABIC LETTER FA" +
	"RSI YEH INITIAL FORMARABIC LETTER FARSI YEH MEDIAL FORMARABIC LIGATURE Y" +
	"EH WITH HAMZA ABOVE WITH JEEM ISOLATED FORMARABIC LIGATURE YEH WITH HAMZ" +
	"A ABOVE WITH HAH ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH " +
	"MEEM ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA" +
	" ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FOR" +
	"MARABIC LIGATURE BEH WITH JEEM ISOLATED FORMARABIC LIGATURE BEH WITH HAH" +
	" ISOLATED FORMARABIC LIGATURE BEH WITH KHAH ISOLATED FORMARABIC LIGATURE" +
	" BEH WITH MEEM ISOLATED FORMARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLAT" +
	"ED FORMARABIC LIGATURE BEH WITH YEH ISOLATED FORMARABIC LIGATURE TEH WIT" +
	"H JEEM ISOLATED FORMARABIC LIGATURE TEH WITH HAH ISOLATED FORMARABIC LIG" +
	"ATURE TEH WITH KHAH ISOLATED FORMARABIC LIGATURE TEH WITH MEEM ISOLATED " +
	"FORMARABIC LIGATURE TEH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE T" +
	"EH WITH YEH ISOLATED FORMARABIC LIGATURE THEH WITH JEEM ISOLATED FORMARA" +
	"BIC LIGATURE THEH WITH MEEM ISOLATED FORMARABIC LIGATURE THEH WITH ALEF " +
	"MAKSURA ISOLATED FORMARABIC LIGATURE THEH WITH YEH ISOLATED FORMARABIC L" +
	"IGATURE JEEM WITH HAH ISOLATED FORMARABIC LIGATURE JEEM WITH MEEM ISOLAT" +
	"ED FORMARABIC LIGATURE HAH WITH JEEM ISOLATED FORMARABIC LIGATURE HAH WI" +
	"TH MEEM ISOLATED FORMARABIC LIGATURE KHAH WITH JEEM ISOLATED FORMARABIC " +
	"LIGATURE KHAH WITH HAH ISOLATED FORMARABIC LIGATURE KHAH WITH MEEM ISOLA" +
	"TED FORMARABIC LIGATURE SEEN WITH JEEM ISOLATED FORMARABIC LIGATURE SEEN" +
	" WITH HAH ISOLATED FORMARABIC LIGATURE SEEN WITH KHAH ISOLATED FORMARABI" +
	"C LIGATURE SEEN WITH MEEM ISOLATED FORMARABIC LIGATURE SAD WITH HAH ISOL" +
	"ATED FORMARABIC LIGATURE SAD WITH MEEM ISOLATED FORMARABIC LIGATURE DAD " +
	"WITH JEEM ISOLATED FORMARABIC LIGATURE DAD WITH HAH ISOLATED FORMARABIC " +
	"LIGATURE DAD WITH KHAH ISOLATED FORMARABIC LIGATURE DAD WITH MEEM ISOLAT" +
	"ED FORMARABIC LIGATURE TAH WITH HAH ISOLATED FORMARABIC LIGATURE TAH WIT" +
	"H MEEM ISOLATED FORMARABIC LIGATURE ZAH WITH MEEM ISOLATED FORMARABIC LI" +
	"GATURE AIN WITH JEEM ISOLATED FORMARABIC LIGATURE AIN WITH MEEM ISOLATED" +
	" FORMARABIC LIGATURE GHAIN WITH JEEM ISOLATED FORMARABIC LIGATURE GHAIN " +
	"WITH MEEM ISOLATED FORMARABIC LIGATURE FEH WITH JEEM ISOLATED FORMARABIC" +
	" LIGATURE FEH WITH HAH ISOLATED FORMARABIC LIGATURE FEH WITH KHAH ISOLAT" +
	"ED FORMARABIC LIGATURE FEH WITH MEEM ISOLATED FORMARABIC LIGATURE FEH WI" +
	"TH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE FEH WITH YEH ISOLATED FORMA" +
	"RABIC LIGATURE QAF WITH HAH ISOLATED FORMARABIC LIGATURE QAF WITH MEEM I" +
	"SOLATED FORMARABIC LIGATURE QAF WITH ALEF MAKSURA ISOLATED FORMARABIC LI" +
	"GATURE QAF WITH YEH ISOLATED FORMARABIC LIGATURE KAF WITH ALEF ISOLATED " +
	"FORMARABIC LIGATURE KAF WITH JEEM ISOLATED FORMARABIC LIGATURE KAF WITH " +
	"HAH ISOLATED FORMARABIC LIGATURE KAF WITH KHAH ISOLATED FORMARABIC LIGAT" +
	"URE KAF WITH LAM ISOLATED FORMARABIC LIGATURE KAF WITH MEEM ISOLATED FOR" +
	"MARABIC LIGATURE KAF WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE KAF " +
	"WITH YEH ISOLATED FORMARABIC LIGATURE LAM WITH JEEM ISOLATED FORMARABIC " +
	"LIGATURE LAM WITH HAH ISOLATED FORMARABIC LIGATURE LAM WITH KHAH ISOLATE" +
	"D FORMARABIC LIGATURE LAM WITH MEEM ISOLATED FORMARABIC LIGATURE LAM WIT" +
	"H ALEF MAKSURA ISOLATED FORMARABIC LIGATURE LAM WITH YEH ISOLATED FORMAR" +
	"ABIC LIGATURE MEEM WITH JEEM ISOLATED FORMARABIC LIGATURE MEEM WITH HAH ") + ("" +
	"ISOLATED FORMARABIC LIGATURE MEEM WITH KHAH ISOLATED FORMARABIC LIGATURE" +
	" MEEM WITH MEEM ISOLATED FORMARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOL" +
	"ATED FORMARABIC LIGATURE MEEM WITH YEH ISOLATED FORMARABIC LIGATURE NOON" +
	" WITH JEEM ISOLATED FORMARABIC LIGATURE NOON WITH HAH ISOLATED FORMARABI" +
	"C LIGATURE NOON WITH KHAH ISOLATED FORMARABIC LIGATURE NOON WITH MEEM IS" +
	"OLATED FORMARABIC LIGATURE NOON WITH ALEF MAKSURA ISOLATED FORMARABIC LI" +
	"GATURE NOON WITH YEH ISOLATED FORMARABIC LIGATURE HEH WITH JEEM ISOLATED" +
	" FORMARABIC LIGATURE HEH WITH MEEM ISOLATED FORMARABIC LIGATURE HEH WITH" +
	" ALEF MAKSURA ISOLATED FORMARABIC LIGATURE HEH WITH YEH ISOLATED FORMARA" +
	"BIC LIGATURE YEH WITH JEEM ISOLATED FORMARABIC LIGATURE YEH WITH HAH ISO" +
	"LATED FORMARABIC LIGATURE YEH WITH KHAH ISOLATED FORMARABIC LIGATURE YEH" +
	" WITH MEEM ISOLATED FORMARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED F" +
	"ORMARABIC LIGATURE YEH WITH YEH ISOLATED FORMARABIC LIGATURE THAL WITH S" +
	"UPERSCRIPT ALEF ISOLATED FORMARABIC LIGATURE REH WITH SUPERSCRIPT ALEF I" +
	"SOLATED FORMARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED " +
	"FORMARABIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORMARABIC LIGATURE SH" +
	"ADDA WITH KASRATAN ISOLATED FORMARABIC LIGATURE SHADDA WITH FATHA ISOLAT" +
	"ED FORMARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORMARABIC LIGATURE SH" +
	"ADDA WITH KASRA ISOLATED FORMARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALE" +
	"F ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORMA" +
	"RABIC LIGATURE YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORMARABIC LIGATURE " +
	"YEH WITH HAMZA ABOVE WITH MEEM FINAL FORMARABIC LIGATURE YEH WITH HAMZA " +
	"ABOVE WITH NOON FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF" +
	" MAKSURA FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL F" +
	"ORMARABIC LIGATURE BEH WITH REH FINAL FORMARABIC LIGATURE BEH WITH ZAIN " +
	"FINAL FORMARABIC LIGATURE BEH WITH MEEM FINAL FORMARABIC LIGATURE BEH WI" +
	"TH NOON FINAL FORMARABIC LIGATURE BEH WITH ALEF MAKSURA FINAL FORMARABIC" +
	" LIGATURE BEH WITH YEH FINAL FORMARABIC LIGATURE TEH WITH REH FINAL FORM" +
	"ARABIC LIGATURE TEH WITH ZAIN FINAL FORMARABIC LIGATURE TEH WITH MEEM FI" +
	"NAL FORMARABIC LIGATURE TEH WITH NOON FINAL FORMARABIC LIGATURE TEH WITH" +
	" ALEF MAKSURA FINAL FORMARABIC LIGATURE TEH WITH YEH FINAL FORMARABIC LI" +
	"GATURE THEH WITH REH FINAL FORMARABIC LIGATURE THEH WITH ZAIN FINAL FORM" +
	"ARABIC LIGATURE THEH WITH MEEM FINAL FORMARABIC LIGATURE THEH WITH NOON " +
	"FINAL FORMARABIC LIGATURE THEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATU" +
	"RE THEH WITH YEH FINAL FORMARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL F" +
	"ORMARABIC LIGATURE FEH WITH YEH FINAL FORMARABIC LIGATURE QAF WITH ALEF " +
	"MAKSURA FINAL FORMARABIC LIGATURE QAF WITH YEH FINAL FORMARABIC LIGATURE" +
	" KAF WITH ALEF FINAL FORMARABIC LIGATURE KAF WITH LAM FINAL FORMARABIC L" +
	"IGATURE KAF WITH MEEM FINAL FORMARABIC LIGATURE KAF WITH ALEF MAKSURA FI" +
	"NAL FORMARABIC LIGATURE KAF WITH YEH FINAL FORMARABIC LIGATURE LAM WITH " +
	"MEEM FINAL FORMARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORMARABIC LI" +
	"GATURE LAM WITH YEH FINAL FORMARABIC LIGATURE MEEM WITH ALEF FINAL FORMA" +
	"RABIC LIGATURE MEEM WITH MEEM FINAL FORMARABIC LIGATURE NOON WITH REH FI" +
	"NAL FORMARABIC LIGATURE NOON WITH ZAIN FINAL FORMARABIC LIGATURE NOON WI" +
	"TH MEEM FINAL FORMARABIC LIGATURE NOON WITH NOON FINAL FORMARABIC LIGATU" +
	"RE NOON WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE NOON WITH YEH FINAL " +
	"FORMARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FINAL FORMARABIC " +
	"LIGATURE YEH WITH REH FINAL FORMARABIC LIGATURE YEH WITH ZAIN FINAL FORM" +
	"ARABIC LIGATURE YEH WITH MEEM FINAL FORMARABIC LIGATURE YEH WITH NOON FI" +
	"NAL FORMARABIC LIGATURE YEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE " +
	"YEH WITH YEH FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM IN" +
	"ITIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH INITIAL FORMARAB" +
	"IC LIGATURE YEH WITH HAMZA ABOVE WITH KHAH INITIAL FORMARABIC LIGATURE Y" +
	"EH WITH HAMZA ABOVE WITH MEEM INITIAL FORMARABIC LIGATURE YEH WITH HAMZA" +
	" ABOVE WITH HEH INITIAL FORMARABIC LIGATURE BEH WITH JEEM INITIAL FORMAR" +
	"ABIC LIGATURE BEH WITH HAH INITIAL FORMARABIC LIGATURE BEH WITH KHAH INI" +
	"TIAL FORMARABIC LIGATURE BEH WITH MEEM INITIAL FORMARABIC LIGATURE BEH W" +
	"ITH HEH INITIAL FORMARABIC LIGATURE TEH WITH JEEM INITIAL FORMARABIC LIG" +
	"ATURE TEH WITH HAH INITIAL FORMARABIC LIGATURE TEH WITH KHAH INITIAL FOR" +
	"MARABIC LIGATURE TEH WITH MEEM INITIAL FORMARABIC LIGATURE TEH WITH HEH " +
	"INITIAL FORMARABIC LIGATURE THEH WITH MEEM INITIAL FORMARABIC LIGATURE J" +
	"EEM WITH HAH INITIAL FORMARABIC LIGATURE JEEM WITH MEEM INITIAL FORMARAB" +
	"IC LIGATURE HAH WITH JEEM INITIAL FORMARABIC LIGATURE HAH WITH MEEM INIT" +
	"IAL FORMARABIC LIGATURE KHAH WITH JEEM INITIAL FORMARABIC LIGATURE KHAH ") + ("" +
	"WITH MEEM INITIAL FORMARABIC LIGATURE SEEN WITH JEEM INITIAL FORMARABIC " +
	"LIGATURE SEEN WITH HAH INITIAL FORMARABIC LIGATURE SEEN WITH KHAH INITIA" +
	"L FORMARABIC LIGATURE SEEN WITH MEEM INITIAL FORMARABIC LIGATURE SAD WIT" +
	"H HAH INITIAL FORMARABIC LIGATURE SAD WITH KHAH INITIAL FORMARABIC LIGAT" +
	"URE SAD WITH MEEM INITIAL FORMARABIC LIGATURE DAD WITH JEEM INITIAL FORM" +
	"ARABIC LIGATURE DAD WITH HAH INITIAL FORMARABIC LIGATURE DAD WITH KHAH I" +
	"NITIAL FORMARABIC LIGATURE DAD WITH MEEM INITIAL FORMARABIC LIGATURE TAH" +
	" WITH HAH INITIAL FORMARABIC LIGATURE ZAH WITH MEEM INITIAL FORMARABIC L" +
	"IGATURE AIN WITH JEEM INITIAL FORMARABIC LIGATURE AIN WITH MEEM INITIAL " +
	"FORMARABIC LIGATURE GHAIN WITH JEEM INITIAL FORMARABIC LIGATURE GHAIN WI" +
	"TH MEEM INITIAL FORMARABIC LIGATURE FEH WITH JEEM INITIAL FORMARABIC LIG" +
	"ATURE FEH WITH HAH INITIAL FORMARABIC LIGATURE FEH WITH KHAH INITIAL FOR" +
	"MARABIC LIGATURE FEH WITH MEEM INITIAL FORMARABIC LIGATURE QAF WITH HAH " +
	"INITIAL FORMARABIC LIGATURE QAF WITH MEEM INITIAL FORMARABIC LIGATURE KA" +
	"F WITH JEEM INITIAL FORMARABIC LIGATURE KAF WITH HAH INITIAL FORMARABIC " +
	"LIGATURE KAF WITH KHAH INITIAL FORMARABIC LIGATURE KAF WITH LAM INITIAL " +
	"FORMARABIC LIGATURE KAF WITH MEEM INITIAL FORMARABIC LIGATURE LAM WITH J" +
	"EEM INITIAL FORMARABIC LIGATURE LAM WITH HAH INITIAL FORMARABIC LIGATURE" +
	" LAM WITH KHAH INITIAL FORMARABIC LIGATURE LAM WITH MEEM INITIAL FORMARA" +
	"BIC LIGATURE LAM WITH HEH INITIAL FORMARABIC LIGATURE MEEM WITH JEEM INI" +
	"TIAL FORMARABIC LIGATURE MEEM WITH HAH INITIAL FORMARABIC LIGATURE MEEM " +
	"WITH KHAH INITIAL FORMARABIC LIGATURE MEEM WITH MEEM INITIAL FORMARABIC " +
	"LIGATURE NOON WITH JEEM INITIAL FORMARABIC LIGATURE NOON WITH HAH INITIA" +
	"L FORMARABIC LIGATURE NOON WITH KHAH INITIAL FORMARABIC LIGATURE NOON WI" +
	"TH MEEM INITIAL FORMARABIC LIGATURE NOON WITH HEH INITIAL FORMARABIC LIG" +
	"ATURE HEH WITH JEEM INITIAL FORMARABIC LIGATURE HEH WITH MEEM INITIAL FO" +
	"RMARABIC LIGATURE HEH WITH SUPERSCRIPT ALEF INITIAL FORMARABIC LIGATURE " +
	"YEH WITH JEEM INITIAL FORMARABIC LIGATURE YEH WITH HAH INITIAL FORMARABI" +
	"C LIGATURE YEH WITH KHAH INITIAL FORMARABIC LIGATURE YEH WITH MEEM INITI" +
	"AL FORMARABIC LIGATURE YEH WITH HEH INITIAL FORMARABIC LIGATURE YEH WITH" +
	" HAMZA ABOVE WITH MEEM MEDIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE W" +
	"ITH HEH MEDIAL FORMARABIC LIGATURE BEH WITH MEEM MEDIAL FORMARABIC LIGAT" +
	"URE BEH WITH HEH MEDIAL FORMARABIC LIGATURE TEH WITH MEEM MEDIAL FORMARA" +
	"BIC LIGATURE TEH WITH HEH MEDIAL FORMARABIC LIGATURE THEH WITH MEEM MEDI" +
	"AL FORMARABIC LIGATURE THEH WITH HEH MEDIAL FORMARABIC LIGATURE SEEN WIT" +
	"H MEEM MEDIAL FORMARABIC LIGATURE SEEN WITH HEH MEDIAL FORMARABIC LIGATU" +
	"RE SHEEN WITH MEEM MEDIAL FORMARABIC LIGATURE SHEEN WITH HEH MEDIAL FORM" +
	"ARABIC LIGATURE KAF WITH LAM MEDIAL FORMARABIC LIGATURE KAF WITH MEEM ME" +
	"DIAL FORMARABIC LIGATURE LAM WITH MEEM MEDIAL FORMARABIC LIGATURE NOON W" +
	"ITH MEEM MEDIAL FORMARABIC LIGATURE NOON WITH HEH MEDIAL FORMARABIC LIGA" +
	"TURE YEH WITH MEEM MEDIAL FORMARABIC LIGATURE YEH WITH HEH MEDIAL FORMAR" +
	"ABIC LIGATURE SHADDA WITH FATHA MEDIAL FORMARABIC LIGATURE SHADDA WITH D" +
	"AMMA MEDIAL FORMARABIC LIGATURE SHADDA WITH KASRA MEDIAL FORMARABIC LIGA" +
	"TURE TAH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE TAH WITH YEH ISO" +
	"LATED FORMARABIC LIGATURE AIN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGA" +
	"TURE AIN WITH YEH ISOLATED FORMARABIC LIGATURE GHAIN WITH ALEF MAKSURA I" +
	"SOLATED FORMARABIC LIGATURE GHAIN WITH YEH ISOLATED FORMARABIC LIGATURE " +
	"SEEN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE SEEN WITH YEH ISOLAT" +
	"ED FORMARABIC LIGATURE SHEEN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGAT" +
	"URE SHEEN WITH YEH ISOLATED FORMARABIC LIGATURE HAH WITH ALEF MAKSURA IS" +
	"OLATED FORMARABIC LIGATURE HAH WITH YEH ISOLATED FORMARABIC LIGATURE JEE" +
	"M WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE JEEM WITH YEH ISOLATED " +
	"FORMARABIC LIGATURE KHAH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE " +
	"KHAH WITH YEH ISOLATED FORMARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATE" +
	"D FORMARABIC LIGATURE SAD WITH YEH ISOLATED FORMARABIC LIGATURE DAD WITH" +
	" ALEF MAKSURA ISOLATED FORMARABIC LIGATURE DAD WITH YEH ISOLATED FORMARA" +
	"BIC LIGATURE SHEEN WITH JEEM ISOLATED FORMARABIC LIGATURE SHEEN WITH HAH" +
	" ISOLATED FORMARABIC LIGATURE SHEEN WITH KHAH ISOLATED FORMARABIC LIGATU" +
	"RE SHEEN WITH MEEM ISOLATED FORMARABIC LIGATURE SHEEN WITH REH ISOLATED " +
	"FORMARABIC LIGATURE SEEN WITH REH ISOLATED FORMARABIC LIGATURE SAD WITH " +
	"REH ISOLATED FORMARABIC LIGATURE DAD WITH REH ISOLATED FORMARABIC LIGATU" +
	"RE TAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE TAH WITH YEH FINAL FO" +
	"RMARABIC LIGATURE AIN WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE AIN WI" +
	"TH YEH FINAL FORMARABIC LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORMARABI") + ("" +
	"C LIGATURE GHAIN WITH YEH FINAL FORMARABIC LIGATURE SEEN WITH ALEF MAKSU" +
	"RA FINAL FORMARABIC LIGATURE SEEN WITH YEH FINAL FORMARABIC LIGATURE SHE" +
	"EN WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SHEEN WITH YEH FINAL FORM" +
	"ARABIC LIGATURE HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE HAH WITH" +
	" YEH FINAL FORMARABIC LIGATURE JEEM WITH ALEF MAKSURA FINAL FORMARABIC L" +
	"IGATURE JEEM WITH YEH FINAL FORMARABIC LIGATURE KHAH WITH ALEF MAKSURA F" +
	"INAL FORMARABIC LIGATURE KHAH WITH YEH FINAL FORMARABIC LIGATURE SAD WIT" +
	"H ALEF MAKSURA FINAL FORMARABIC LIGATURE SAD WITH YEH FINAL FORMARABIC L" +
	"IGATURE DAD WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE DAD WITH YEH FIN" +
	"AL FORMARABIC LIGATURE SHEEN WITH JEEM FINAL FORMARABIC LIGATURE SHEEN W" +
	"ITH HAH FINAL FORMARABIC LIGATURE SHEEN WITH KHAH FINAL FORMARABIC LIGAT" +
	"URE SHEEN WITH MEEM FINAL FORMARABIC LIGATURE SHEEN WITH REH FINAL FORMA" +
	"RABIC LIGATURE SEEN WITH REH FINAL FORMARABIC LIGATURE SAD WITH REH FINA" +
	"L FORMARABIC LIGATURE DAD WITH REH FINAL FORMARABIC LIGATURE SHEEN WITH " +
	"JEEM INITIAL FORMARABIC LIGATURE SHEEN WITH HAH INITIAL FORMARABIC LIGAT" +
	"URE SHEEN WITH KHAH INITIAL FORMARABIC LIGATURE SHEEN WITH MEEM INITIAL " +
	"FORMARABIC LIGATURE SEEN WITH HEH INITIAL FORMARABIC LIGATURE SHEEN WITH" +
	" HEH INITIAL FORMARABIC LIGATURE TAH WITH MEEM INITIAL FORMARABIC LIGATU" +
	"RE SEEN WITH JEEM MEDIAL FORMARABIC LIGATURE SEEN WITH HAH MEDIAL FORMAR" +
	"ABIC LIGATURE SEEN WITH KHAH MEDIAL FORMARABIC LIGATURE SHEEN WITH JEEM " +
	"MEDIAL FORMARABIC LIGATURE SHEEN WITH HAH MEDIAL FORMARABIC LIGATURE SHE" +
	"EN WITH KHAH MEDIAL FORMARABIC LIGATURE TAH WITH MEEM MEDIAL FORMARABIC " +
	"LIGATURE ZAH WITH MEEM MEDIAL FORMARABIC LIGATURE ALEF WITH FATHATAN FIN" +
	"AL FORMARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORMORNATE LEFT PAREN" +
	"THESISORNATE RIGHT PARENTHESISARABIC LIGATURE TEH WITH JEEM WITH MEEM IN" +
	"ITIAL FORMARABIC LIGATURE TEH WITH HAH WITH JEEM FINAL FORMARABIC LIGATU" +
	"RE TEH WITH HAH WITH JEEM INITIAL FORMARABIC LIGATURE TEH WITH HAH WITH " +
	"MEEM INITIAL FORMARABIC LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORMARA" +
	"BIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORMARABIC LIGATURE TEH WIT" +
	"H MEEM WITH HAH INITIAL FORMARABIC LIGATURE TEH WITH MEEM WITH KHAH INIT" +
	"IAL FORMARABIC LIGATURE JEEM WITH MEEM WITH HAH FINAL FORMARABIC LIGATUR" +
	"E JEEM WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE HAH WITH MEEM WITH" +
	" YEH FINAL FORMARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FOR" +
	"MARABIC LIGATURE SEEN WITH HAH WITH JEEM INITIAL FORMARABIC LIGATURE SEE" +
	"N WITH JEEM WITH HAH INITIAL FORMARABIC LIGATURE SEEN WITH JEEM WITH ALE" +
	"F MAKSURA FINAL FORMARABIC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORMAR" +
	"ABIC LIGATURE SEEN WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE SEEN W" +
	"ITH MEEM WITH JEEM INITIAL FORMARABIC LIGATURE SEEN WITH MEEM WITH MEEM " +
	"FINAL FORMARABIC LIGATURE SEEN WITH MEEM WITH MEEM INITIAL FORMARABIC LI" +
	"GATURE SAD WITH HAH WITH HAH FINAL FORMARABIC LIGATURE SAD WITH HAH WITH" +
	" HAH INITIAL FORMARABIC LIGATURE SAD WITH MEEM WITH MEEM FINAL FORMARABI" +
	"C LIGATURE SHEEN WITH HAH WITH MEEM FINAL FORMARABIC LIGATURE SHEEN WITH" +
	" HAH WITH MEEM INITIAL FORMARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINA" +
	"L FORMARABIC LIGATURE SHEEN WITH MEEM WITH KHAH FINAL FORMARABIC LIGATUR" +
	"E SHEEN WITH MEEM WITH KHAH INITIAL FORMARABIC LIGATURE SHEEN WITH MEEM " +
	"WITH MEEM FINAL FORMARABIC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FO" +
	"RMARABIC LIGATURE DAD WITH HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATU" +
	"RE DAD WITH KHAH WITH MEEM FINAL FORMARABIC LIGATURE DAD WITH KHAH WITH " +
	"MEEM INITIAL FORMARABIC LIGATURE TAH WITH MEEM WITH HAH FINAL FORMARABIC" +
	" LIGATURE TAH WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE TAH WITH ME" +
	"EM WITH MEEM INITIAL FORMARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FO" +
	"RMARABIC LIGATURE AIN WITH JEEM WITH MEEM FINAL FORMARABIC LIGATURE AIN " +
	"WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE AIN WITH MEEM WITH MEEM IN" +
	"ITIAL FORMARABIC LIGATURE AIN WITH MEEM WITH ALEF MAKSURA FINAL FORMARAB" +
	"IC LIGATURE GHAIN WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE GHAIN WI" +
	"TH MEEM WITH YEH FINAL FORMARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAK" +
	"SURA FINAL FORMARABIC LIGATURE FEH WITH KHAH WITH MEEM FINAL FORMARABIC " +
	"LIGATURE FEH WITH KHAH WITH MEEM INITIAL FORMARABIC LIGATURE QAF WITH ME" +
	"EM WITH HAH FINAL FORMARABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORM" +
	"ARABIC LIGATURE LAM WITH HAH WITH MEEM FINAL FORMARABIC LIGATURE LAM WIT" +
	"H HAH WITH YEH FINAL FORMARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA " +
	"FINAL FORMARABIC LIGATURE LAM WITH JEEM WITH JEEM INITIAL FORMARABIC LIG" +
	"ATURE LAM WITH JEEM WITH JEEM FINAL FORMARABIC LIGATURE LAM WITH KHAH WI" +
	"TH MEEM FINAL FORMARABIC LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORMAR") + ("" +
	"ABIC LIGATURE LAM WITH MEEM WITH HAH FINAL FORMARABIC LIGATURE LAM WITH " +
	"MEEM WITH HAH INITIAL FORMARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIA" +
	"L FORMARABIC LIGATURE MEEM WITH HAH WITH MEEM INITIAL FORMARABIC LIGATUR" +
	"E MEEM WITH HAH WITH YEH FINAL FORMARABIC LIGATURE MEEM WITH JEEM WITH H" +
	"AH INITIAL FORMARABIC LIGATURE MEEM WITH JEEM WITH MEEM INITIAL FORMARAB" +
	"IC LIGATURE MEEM WITH KHAH WITH JEEM INITIAL FORMARABIC LIGATURE MEEM WI" +
	"TH KHAH WITH MEEM INITIAL FORMARABIC LIGATURE MEEM WITH JEEM WITH KHAH I" +
	"NITIAL FORMARABIC LIGATURE HEH WITH MEEM WITH JEEM INITIAL FORMARABIC LI" +
	"GATURE HEH WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE NOON WITH HAH" +
	" WITH MEEM INITIAL FORMARABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA F" +
	"INAL FORMARABIC LIGATURE NOON WITH JEEM WITH MEEM FINAL FORMARABIC LIGAT" +
	"URE NOON WITH JEEM WITH MEEM INITIAL FORMARABIC LIGATURE NOON WITH JEEM " +
	"WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE NOON WITH MEEM WITH YEH FINA" +
	"L FORMARABIC LIGATURE NOON WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC " +
	"LIGATURE YEH WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE YEH WITH MEEM" +
	" WITH MEEM INITIAL FORMARABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORM" +
	"ARABIC LIGATURE TEH WITH JEEM WITH YEH FINAL FORMARABIC LIGATURE TEH WIT" +
	"H JEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE TEH WITH KHAH WITH YE" +
	"H FINAL FORMARABIC LIGATURE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORMAR" +
	"ABIC LIGATURE TEH WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE TEH WITH " +
	"MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE JEEM WITH MEEM WITH YEH" +
	" FINAL FORMARABIC LIGATURE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORMARA" +
	"BIC LIGATURE JEEM WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE " +
	"SEEN WITH KHAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SAD WITH HAH " +
	"WITH YEH FINAL FORMARABIC LIGATURE SHEEN WITH HAH WITH YEH FINAL FORMARA" +
	"BIC LIGATURE DAD WITH HAH WITH YEH FINAL FORMARABIC LIGATURE LAM WITH JE" +
	"EM WITH YEH FINAL FORMARABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORMA" +
	"RABIC LIGATURE YEH WITH HAH WITH YEH FINAL FORMARABIC LIGATURE YEH WITH " +
	"JEEM WITH YEH FINAL FORMARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FOR" +
	"MARABIC LIGATURE MEEM WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE QAF W" +
	"ITH MEEM WITH YEH FINAL FORMARABIC LIGATURE NOON WITH HAH WITH YEH FINAL" +
	" FORMARABIC LIGATURE QAF WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE " +
	"LAM WITH HAH WITH MEEM INITIAL FORMARABIC LIGATURE AIN WITH MEEM WITH YE" +
	"H FINAL FORMARABIC LIGATURE KAF WITH MEEM WITH YEH FINAL FORMARABIC LIGA" +
	"TURE NOON WITH JEEM WITH HAH INITIAL FORMARABIC LIGATURE MEEM WITH KHAH " +
	"WITH YEH FINAL FORMARABIC LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORMA" +
	"RABIC LIGATURE KAF WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE LAM WIT" +
	"H JEEM WITH MEEM FINAL FORMARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL" +
	" FORMARABIC LIGATURE JEEM WITH HAH WITH YEH FINAL FORMARABIC LIGATURE HA" +
	"H WITH JEEM WITH YEH FINAL FORMARABIC LIGATURE MEEM WITH JEEM WITH YEH F" +
	"INAL FORMARABIC LIGATURE FEH WITH MEEM WITH YEH FINAL FORMARABIC LIGATUR" +
	"E BEH WITH HAH WITH YEH FINAL FORMARABIC LIGATURE KAF WITH MEEM WITH MEE" +
	"M INITIAL FORMARABIC LIGATURE AIN WITH JEEM WITH MEEM INITIAL FORMARABIC" +
	" LIGATURE SAD WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE SEEN WITH " +
	"KHAH WITH YEH FINAL FORMARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FO" +
	"RMARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORMARABIC LI" +
	"GATURE QALA USED AS KORANIC STOP SIGN ISOLATED FORMARABIC LIGATURE ALLAH" +
	" ISOLATED FORMARABIC LIGATURE AKBAR ISOLATED FORMARABIC LIGATURE MOHAMMA" +
	"D ISOLATED FORMARABIC LIGATURE SALAM ISOLATED FORMARABIC LIGATURE RASOUL" +
	" ISOLATED FORMARABIC LIGATURE ALAYHE ISOLATED FORMARABIC LIGATURE WASALL" +
	"AM ISOLATED FORMARABIC LIGATURE SALLA ISOLATED FORMARABIC LIGATURE SALLA" +
	"LLAHOU ALAYHE WASALLAMARABIC LIGATURE JALLAJALALOUHOURIAL SIGNARABIC LIG" +
	"ATURE BISMILLAH AR-RAHMAN AR-RAHEEMVARIATION SELECTOR-1VARIATION SELECTO" +
	"R-2VARIATION SELECTOR-3VARIATION SELECTOR-4VARIATION SELECTOR-5VARIATION" +
	" SELECTOR-6VARIATION SELECTOR-7VARIATION SELECTOR-8VARIATION SELECTOR-9V" +
	"ARIATION SELECTOR-10VARIATION SELECTOR-11VARIATION SELECTOR-12VARIATION " +
	"SELECTOR-13VARIATION SELECTOR-14VARIATION SELECTOR-15VARIATION SELECTOR-" +
	"16PRESENTATION FORM FOR VERTICAL COMMAPRESENTATION FORM FOR VERTICAL IDE" +
	"OGRAPHIC COMMAPRESENTATION FORM FOR VERTICAL IDEOGRAPHIC FULL STOPPRESEN" +
	"TATION FORM FOR VERTICAL COLONPRESENTATION FORM FOR VERTICAL SEMICOLONPR" +
	"ESENTATION FORM FOR VERTICAL EXCLAMATION MARKPRESENTATION FORM FOR VERTI" +
	"CAL QUESTION MARKPRESENTATION FORM FOR VERTICAL LEFT WHITE LENTICULAR BR" +
	"ACKETPRESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRAKCETPRESEN" +
	"TATION FORM FOR VERTICAL HORIZONTAL ELLIPSISCOMBINING LIGATURE LEFT HALF") + ("" +
	"COMBINING LIGATURE RIGHT HALFCOMBINING DOUBLE TILDE LEFT HALFCOMBINING D" +
	"OUBLE TILDE RIGHT HALFCOMBINING MACRON LEFT HALFCOMBINING MACRON RIGHT H" +
	"ALFCOMBINING CONJOINING MACRONCOMBINING LIGATURE LEFT HALF BELOWCOMBININ" +
	"G LIGATURE RIGHT HALF BELOWCOMBINING TILDE LEFT HALF BELOWCOMBINING TILD" +
	"E RIGHT HALF BELOWCOMBINING MACRON LEFT HALF BELOWCOMBINING MACRON RIGHT" +
	" HALF BELOWCOMBINING CONJOINING MACRON BELOWCOMBINING CYRILLIC TITLO LEF" +
	"T HALFCOMBINING CYRILLIC TITLO RIGHT HALFPRESENTATION FORM FOR VERTICAL " +
	"TWO DOT LEADERPRESENTATION FORM FOR VERTICAL EM DASHPRESENTATION FORM FO" +
	"R VERTICAL EN DASHPRESENTATION FORM FOR VERTICAL LOW LINEPRESENTATION FO" +
	"RM FOR VERTICAL WAVY LOW LINEPRESENTATION FORM FOR VERTICAL LEFT PARENTH" +
	"ESISPRESENTATION FORM FOR VERTICAL RIGHT PARENTHESISPRESENTATION FORM FO" +
	"R VERTICAL LEFT CURLY BRACKETPRESENTATION FORM FOR VERTICAL RIGHT CURLY " +
	"BRACKETPRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKETPRESENT" +
	"ATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKETPRESENTATION FORM FO" +
	"R VERTICAL LEFT BLACK LENTICULAR BRACKETPRESENTATION FORM FOR VERTICAL R" +
	"IGHT BLACK LENTICULAR BRACKETPRESENTATION FORM FOR VERTICAL LEFT DOUBLE " +
	"ANGLE BRACKETPRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKETPR" +
	"ESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKETPRESENTATION FORM FOR VER" +
	"TICAL RIGHT ANGLE BRACKETPRESENTATION FORM FOR VERTICAL LEFT CORNER BRAC" +
	"KETPRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKETPRESENTATION FORM " +
	"FOR VERTICAL LEFT WHITE CORNER BRACKETPRESENTATION FORM FOR VERTICAL RIG" +
	"HT WHITE CORNER BRACKETSESAME DOTWHITE SESAME DOTPRESENTATION FORM FOR V" +
	"ERTICAL LEFT SQUARE BRACKETPRESENTATION FORM FOR VERTICAL RIGHT SQUARE B" +
	"RACKETDASHED OVERLINECENTRELINE OVERLINEWAVY OVERLINEDOUBLE WAVY OVERLIN" +
	"EDASHED LOW LINECENTRELINE LOW LINEWAVY LOW LINESMALL COMMASMALL IDEOGRA" +
	"PHIC COMMASMALL FULL STOPSMALL SEMICOLONSMALL COLONSMALL QUESTION MARKSM" +
	"ALL EXCLAMATION MARKSMALL EM DASHSMALL LEFT PARENTHESISSMALL RIGHT PAREN" +
	"THESISSMALL LEFT CURLY BRACKETSMALL RIGHT CURLY BRACKETSMALL LEFT TORTOI" +
	"SE SHELL BRACKETSMALL RIGHT TORTOISE SHELL BRACKETSMALL NUMBER SIGNSMALL" +
	" AMPERSANDSMALL ASTERISKSMALL PLUS SIGNSMALL HYPHEN-MINUSSMALL LESS-THAN" +
	" SIGNSMALL GREATER-THAN SIGNSMALL EQUALS SIGNSMALL REVERSE SOLIDUSSMALL " +
	"DOLLAR SIGNSMALL PERCENT SIGNSMALL COMMERCIAL ATARABIC FATHATAN ISOLATED" +
	" FORMARABIC TATWEEL WITH FATHATAN ABOVEARABIC DAMMATAN ISOLATED FORMARAB" +
	"IC TAIL FRAGMENTARABIC KASRATAN ISOLATED FORMARABIC FATHA ISOLATED FORMA" +
	"RABIC FATHA MEDIAL FORMARABIC DAMMA ISOLATED FORMARABIC DAMMA MEDIAL FOR" +
	"MARABIC KASRA ISOLATED FORMARABIC KASRA MEDIAL FORMARABIC SHADDA ISOLATE" +
	"D FORMARABIC SHADDA MEDIAL FORMARABIC SUKUN ISOLATED FORMARABIC SUKUN ME" +
	"DIAL FORMARABIC LETTER HAMZA ISOLATED FORMARABIC LETTER ALEF WITH MADDA " +
	"ABOVE ISOLATED FORMARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORMARABIC " +
	"LETTER ALEF WITH HAMZA ABOVE ISOLATED FORMARABIC LETTER ALEF WITH HAMZA " +
	"ABOVE FINAL FORMARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORMARABIC L" +
	"ETTER WAW WITH HAMZA ABOVE FINAL FORMARABIC LETTER ALEF WITH HAMZA BELOW" +
	" ISOLATED FORMARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORMARABIC LETTE" +
	"R YEH WITH HAMZA ABOVE ISOLATED FORMARABIC LETTER YEH WITH HAMZA ABOVE F" +
	"INAL FORMARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORMARABIC LETTER YE" +
	"H WITH HAMZA ABOVE MEDIAL FORMARABIC LETTER ALEF ISOLATED FORMARABIC LET" +
	"TER ALEF FINAL FORMARABIC LETTER BEH ISOLATED FORMARABIC LETTER BEH FINA" +
	"L FORMARABIC LETTER BEH INITIAL FORMARABIC LETTER BEH MEDIAL FORMARABIC " +
	"LETTER TEH MARBUTA ISOLATED FORMARABIC LETTER TEH MARBUTA FINAL FORMARAB" +
	"IC LETTER TEH ISOLATED FORMARABIC LETTER TEH FINAL FORMARABIC LETTER TEH" +
	" INITIAL FORMARABIC LETTER TEH MEDIAL FORMARABIC LETTER THEH ISOLATED FO" +
	"RMARABIC LETTER THEH FINAL FORMARABIC LETTER THEH INITIAL FORMARABIC LET" +
	"TER THEH MEDIAL FORMARABIC LETTER JEEM ISOLATED FORMARABIC LETTER JEEM F" +
	"INAL FORMARABIC LETTER JEEM INITIAL FORMARABIC LETTER JEEM MEDIAL FORMAR" +
	"ABIC LETTER HAH ISOLATED FORMARABIC LETTER HAH FINAL FORMARABIC LETTER H" +
	"AH INITIAL FORMARABIC LETTER HAH MEDIAL FORMARABIC LETTER KHAH ISOLATED " +
	"FORMARABIC LETTER KHAH FINAL FORMARABIC LETTER KHAH INITIAL FORMARABIC L" +
	"ETTER KHAH MEDIAL FORMARABIC LETTER DAL ISOLATED FORMARABIC LETTER DAL F" +
	"INAL FORMARABIC LETTER THAL ISOLATED FORMARABIC LETTER THAL FINAL FORMAR" +
	"ABIC LETTER REH ISOLATED FORMARABIC LETTER REH FINAL FORMARABIC LETTER Z" +
	"AIN ISOLATED FORMARABIC LETTER ZAIN FINAL FORMARABIC LETTER SEEN ISOLATE" +
	"D FORMARABIC LETTER SEEN FINAL FORMARABIC LETTER SEEN INITIAL FORMARABIC" +
	" LETTER SEEN MEDIAL FORMARABIC LETTER SHEEN ISOLATED FORMARABIC LETTER S" +
	"HEEN FINAL FORMARABIC LETTER SHEEN INITIAL FORMARABIC LETTER SHEEN MEDIA") + ("" +
	"L FORMARABIC LETTER SAD ISOLATED FORMARABIC LETTER SAD FINAL FORMARABIC " +
	"LETTER SAD INITIAL FORMARABIC LETTER SAD MEDIAL FORMARABIC LETTER DAD IS" +
	"OLATED FORMARABIC LETTER DAD FINAL FORMARABIC LETTER DAD INITIAL FORMARA" +
	"BIC LETTER DAD MEDIAL FORMARABIC LETTER TAH ISOLATED FORMARABIC LETTER T" +
	"AH FINAL FORMARABIC LETTER TAH INITIAL FORMARABIC LETTER TAH MEDIAL FORM" +
	"ARABIC LETTER ZAH ISOLATED FORMARABIC LETTER ZAH FINAL FORMARABIC LETTER" +
	" ZAH INITIAL FORMARABIC LETTER ZAH MEDIAL FORMARABIC LETTER AIN ISOLATED" +
	" FORMARABIC LETTER AIN FINAL FORMARABIC LETTER AIN INITIAL FORMARABIC LE" +
	"TTER AIN MEDIAL FORMARABIC LETTER GHAIN ISOLATED FORMARABIC LETTER GHAIN" +
	" FINAL FORMARABIC LETTER GHAIN INITIAL FORMARABIC LETTER GHAIN MEDIAL FO" +
	"RMARABIC LETTER FEH ISOLATED FORMARABIC LETTER FEH FINAL FORMARABIC LETT" +
	"ER FEH INITIAL FORMARABIC LETTER FEH MEDIAL FORMARABIC LETTER QAF ISOLAT" +
	"ED FORMARABIC LETTER QAF FINAL FORMARABIC LETTER QAF INITIAL FORMARABIC " +
	"LETTER QAF MEDIAL FORMARABIC LETTER KAF ISOLATED FORMARABIC LETTER KAF F" +
	"INAL FORMARABIC LETTER KAF INITIAL FORMARABIC LETTER KAF MEDIAL FORMARAB" +
	"IC LETTER LAM ISOLATED FORMARABIC LETTER LAM FINAL FORMARABIC LETTER LAM" +
	" INITIAL FORMARABIC LETTER LAM MEDIAL FORMARABIC LETTER MEEM ISOLATED FO" +
	"RMARABIC LETTER MEEM FINAL FORMARABIC LETTER MEEM INITIAL FORMARABIC LET" +
	"TER MEEM MEDIAL FORMARABIC LETTER NOON ISOLATED FORMARABIC LETTER NOON F" +
	"INAL FORMARABIC LETTER NOON INITIAL FORMARABIC LETTER NOON MEDIAL FORMAR" +
	"ABIC LETTER HEH ISOLATED FORMARABIC LETTER HEH FINAL FORMARABIC LETTER H" +
	"EH INITIAL FORMARABIC LETTER HEH MEDIAL FORMARABIC LETTER WAW ISOLATED F" +
	"ORMARABIC LETTER WAW FINAL FORMARABIC LETTER ALEF MAKSURA ISOLATED FORMA" +
	"RABIC LETTER ALEF MAKSURA FINAL FORMARABIC LETTER YEH ISOLATED FORMARABI" +
	"C LETTER YEH FINAL FORMARABIC LETTER YEH INITIAL FORMARABIC LETTER YEH M" +
	"EDIAL FORMARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORMAR" +
	"ABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORMARABIC LIGATURE L" +
	"AM WITH ALEF WITH HAMZA ABOVE ISOLATED FORMARABIC LIGATURE LAM WITH ALEF" +
	" WITH HAMZA ABOVE FINAL FORMARABIC LIGATURE LAM WITH ALEF WITH HAMZA BEL" +
	"OW ISOLATED FORMARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FOR" +
	"MARABIC LIGATURE LAM WITH ALEF ISOLATED FORMARABIC LIGATURE LAM WITH ALE" +
	"F FINAL FORMZERO WIDTH NO-BREAK SPACEFULLWIDTH EXCLAMATION MARKFULLWIDTH" +
	" QUOTATION MARKFULLWIDTH NUMBER SIGNFULLWIDTH DOLLAR SIGNFULLWIDTH PERCE" +
	"NT SIGNFULLWIDTH AMPERSANDFULLWIDTH APOSTROPHEFULLWIDTH LEFT PARENTHESIS" +
	"FULLWIDTH RIGHT PARENTHESISFULLWIDTH ASTERISKFULLWIDTH PLUS SIGNFULLWIDT" +
	"H COMMAFULLWIDTH HYPHEN-MINUSFULLWIDTH FULL STOPFULLWIDTH SOLIDUSFULLWID" +
	"TH DIGIT ZEROFULLWIDTH DIGIT ONEFULLWIDTH DIGIT TWOFULLWIDTH DIGIT THREE" +
	"FULLWIDTH DIGIT FOURFULLWIDTH DIGIT FIVEFULLWIDTH DIGIT SIXFULLWIDTH DIG" +
	"IT SEVENFULLWIDTH DIGIT EIGHTFULLWIDTH DIGIT NINEFULLWIDTH COLONFULLWIDT" +
	"H SEMICOLONFULLWIDTH LESS-THAN SIGNFULLWIDTH EQUALS SIGNFULLWIDTH GREATE" +
	"R-THAN SIGNFULLWIDTH QUESTION MARKFULLWIDTH COMMERCIAL ATFULLWIDTH LATIN" +
	" CAPITAL LETTER AFULLWIDTH LATIN CAPITAL LETTER BFULLWIDTH LATIN CAPITAL" +
	" LETTER CFULLWIDTH LATIN CAPITAL LETTER DFULLWIDTH LATIN CAPITAL LETTER " +
	"EFULLWIDTH LATIN CAPITAL LETTER FFULLWIDTH LATIN CAPITAL LETTER GFULLWID" +
	"TH LATIN CAPITAL LETTER HFULLWIDTH LATIN CAPITAL LETTER IFULLWIDTH LATIN" +
	" CAPITAL LETTER JFULLWIDTH LATIN CAPITAL LETTER KFULLWIDTH LATIN CAPITAL" +
	" LETTER LFULLWIDTH LATIN CAPITAL LETTER MFULLWIDTH LATIN CAPITAL LETTER " +
	"NFULLWIDTH LATIN CAPITAL LETTER OFULLWIDTH LATIN CAPITAL LETTER PFULLWID" +
	"TH LATIN CAPITAL LETTER QFULLWIDTH LATIN CAPITAL LETTER RFULLWIDTH LATIN" +
	" CAPITAL LETTER SFULLWIDTH LATIN CAPITAL LETTER TFULLWIDTH LATIN CAPITAL" +
	" LETTER UFULLWIDTH LATIN CAPITAL LETTER VFULLWIDTH LATIN CAPITAL LETTER " +
	"WFULLWIDTH LATIN CAPITAL LETTER XFULLWIDTH LATIN CAPITAL LETTER YFULLWID" +
	"TH LATIN CAPITAL LETTER ZFULLWIDTH LEFT SQUARE BRACKETFULLWIDTH REVERSE " +
	"SOLIDUSFULLWIDTH RIGHT SQUARE BRACKETFULLWIDTH CIRCUMFLEX ACCENTFULLWIDT" +
	"H LOW LINEFULLWIDTH GRAVE ACCENTFULLWIDTH LATIN SMALL LETTER AFULLWIDTH " +
	"LATIN SMALL LETTER BFULLWIDTH LATIN SMALL LETTER CFULLWIDTH LATIN SMALL " +
	"LETTER DFULLWIDTH LATIN SMALL LETTER EFULLWIDTH LATIN SMALL LETTER FFULL" +
	"WIDTH LATIN SMALL LETTER GFULLWIDTH LATIN SMALL LETTER HFULLWIDTH LATIN " +
	"SMALL LETTER IFULLWIDTH LATIN SMALL LETTER JFULLWIDTH LATIN SMALL LETTER" +
	" KFULLWIDTH LATIN SMALL LETTER LFULLWIDTH LATIN SMALL LETTER MFULLWIDTH " +
	"LATIN SMALL LETTER NFULLWIDTH LATIN SMALL LETTER OFULLWIDTH LATIN SMALL " +
	"LETTER PFULLWIDTH LATIN SMALL LETTER QFULLWIDTH LATIN SMALL LETTER RFULL" +
	"WIDTH LATIN SMALL LETTER SFULLWIDTH LATIN SMALL LETTER TFULLWIDTH LATIN " +
	"SMALL LETTER UFULLWIDTH LATIN SMALL LETTER VFULLWIDTH LATIN SMALL LETTER") + ("" +
	" WFULLWIDTH LATIN SMALL LETTER XFULLWIDTH LATIN SMALL LETTER YFULLWIDTH " +
	"LATIN SMALL LETTER ZFULLWIDTH LEFT CURLY BRACKETFULLWIDTH VERTICAL LINEF" +
	"ULLWIDTH RIGHT CURLY BRACKETFULLWIDTH TILDEFULLWIDTH LEFT WHITE PARENTHE" +
	"SISFULLWIDTH RIGHT WHITE PARENTHESISHALFWIDTH IDEOGRAPHIC FULL STOPHALFW" +
	"IDTH LEFT CORNER BRACKETHALFWIDTH RIGHT CORNER BRACKETHALFWIDTH IDEOGRAP" +
	"HIC COMMAHALFWIDTH KATAKANA MIDDLE DOTHALFWIDTH KATAKANA LETTER WOHALFWI" +
	"DTH KATAKANA LETTER SMALL AHALFWIDTH KATAKANA LETTER SMALL IHALFWIDTH KA" +
	"TAKANA LETTER SMALL UHALFWIDTH KATAKANA LETTER SMALL EHALFWIDTH KATAKANA" +
	" LETTER SMALL OHALFWIDTH KATAKANA LETTER SMALL YAHALFWIDTH KATAKANA LETT" +
	"ER SMALL YUHALFWIDTH KATAKANA LETTER SMALL YOHALFWIDTH KATAKANA LETTER S" +
	"MALL TUHALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARKHALFWIDTH KATAKAN" +
	"A LETTER AHALFWIDTH KATAKANA LETTER IHALFWIDTH KATAKANA LETTER UHALFWIDT" +
	"H KATAKANA LETTER EHALFWIDTH KATAKANA LETTER OHALFWIDTH KATAKANA LETTER " +
	"KAHALFWIDTH KATAKANA LETTER KIHALFWIDTH KATAKANA LETTER KUHALFWIDTH KATA" +
	"KANA LETTER KEHALFWIDTH KATAKANA LETTER KOHALFWIDTH KATAKANA LETTER SAHA" +
	"LFWIDTH KATAKANA LETTER SIHALFWIDTH KATAKANA LETTER SUHALFWIDTH KATAKANA" +
	" LETTER SEHALFWIDTH KATAKANA LETTER SOHALFWIDTH KATAKANA LETTER TAHALFWI" +
	"DTH KATAKANA LETTER TIHALFWIDTH KATAKANA LETTER TUHALFWIDTH KATAKANA LET" +
	"TER TEHALFWIDTH KATAKANA LETTER TOHALFWIDTH KATAKANA LETTER NAHALFWIDTH " +
	"KATAKANA LETTER NIHALFWIDTH KATAKANA LETTER NUHALFWIDTH KATAKANA LETTER " +
	"NEHALFWIDTH KATAKANA LETTER NOHALFWIDTH KATAKANA LETTER HAHALFWIDTH KATA" +
	"KANA LETTER HIHALFWIDTH KATAKANA LETTER HUHALFWIDTH KATAKANA LETTER HEHA" +
	"LFWIDTH KATAKANA LETTER HOHALFWIDTH KATAKANA LETTER MAHALFWIDTH KATAKANA" +
	" LETTER MIHALFWIDTH KATAKANA LETTER MUHALFWIDTH KATAKANA LETTER MEHALFWI" +
	"DTH KATAKANA LETTER MOHALFWIDTH KATAKANA LETTER YAHALFWIDTH KATAKANA LET" +
	"TER YUHALFWIDTH KATAKANA LETTER YOHALFWIDTH KATAKANA LETTER RAHALFWIDTH " +
	"KATAKANA LETTER RIHALFWIDTH KATAKANA LETTER RUHALFWIDTH KATAKANA LETTER " +
	"REHALFWIDTH KATAKANA LETTER ROHALFWIDTH KATAKANA LETTER WAHALFWIDTH KATA" +
	"KANA LETTER NHALFWIDTH KATAKANA VOICED SOUND MARKHALFWIDTH KATAKANA SEMI" +
	"-VOICED SOUND MARKHALFWIDTH HANGUL FILLERHALFWIDTH HANGUL LETTER KIYEOKH" +
	"ALFWIDTH HANGUL LETTER SSANGKIYEOKHALFWIDTH HANGUL LETTER KIYEOK-SIOSHAL" +
	"FWIDTH HANGUL LETTER NIEUNHALFWIDTH HANGUL LETTER NIEUN-CIEUCHALFWIDTH H" +
	"ANGUL LETTER NIEUN-HIEUHHALFWIDTH HANGUL LETTER TIKEUTHALFWIDTH HANGUL L" +
	"ETTER SSANGTIKEUTHALFWIDTH HANGUL LETTER RIEULHALFWIDTH HANGUL LETTER RI" +
	"EUL-KIYEOKHALFWIDTH HANGUL LETTER RIEUL-MIEUMHALFWIDTH HANGUL LETTER RIE" +
	"UL-PIEUPHALFWIDTH HANGUL LETTER RIEUL-SIOSHALFWIDTH HANGUL LETTER RIEUL-" +
	"THIEUTHHALFWIDTH HANGUL LETTER RIEUL-PHIEUPHHALFWIDTH HANGUL LETTER RIEU" +
	"L-HIEUHHALFWIDTH HANGUL LETTER MIEUMHALFWIDTH HANGUL LETTER PIEUPHALFWID" +
	"TH HANGUL LETTER SSANGPIEUPHALFWIDTH HANGUL LETTER PIEUP-SIOSHALFWIDTH H" +
	"ANGUL LETTER SIOSHALFWIDTH HANGUL LETTER SSANGSIOSHALFWIDTH HANGUL LETTE" +
	"R IEUNGHALFWIDTH HANGUL LETTER CIEUCHALFWIDTH HANGUL LETTER SSANGCIEUCHA" +
	"LFWIDTH HANGUL LETTER CHIEUCHHALFWIDTH HANGUL LETTER KHIEUKHHALFWIDTH HA" +
	"NGUL LETTER THIEUTHHALFWIDTH HANGUL LETTER PHIEUPHHALFWIDTH HANGUL LETTE" +
	"R HIEUHHALFWIDTH HANGUL LETTER AHALFWIDTH HANGUL LETTER AEHALFWIDTH HANG" +
	"UL LETTER YAHALFWIDTH HANGUL LETTER YAEHALFWIDTH HANGUL LETTER EOHALFWID" +
	"TH HANGUL LETTER EHALFWIDTH HANGUL LETTER YEOHALFWIDTH HANGUL LETTER YEH" +
	"ALFWIDTH HANGUL LETTER OHALFWIDTH HANGUL LETTER WAHALFWIDTH HANGUL LETTE" +
	"R WAEHALFWIDTH HANGUL LETTER OEHALFWIDTH HANGUL LETTER YOHALFWIDTH HANGU" +
	"L LETTER UHALFWIDTH HANGUL LETTER WEOHALFWIDTH HANGUL LETTER WEHALFWIDTH" +
	" HANGUL LETTER WIHALFWIDTH HANGUL LETTER YUHALFWIDTH HANGUL LETTER EUHAL" +
	"FWIDTH HANGUL LETTER YIHALFWIDTH HANGUL LETTER IFULLWIDTH CENT SIGNFULLW" +
	"IDTH POUND SIGNFULLWIDTH NOT SIGNFULLWIDTH MACRONFULLWIDTH BROKEN BARFUL" +
	"LWIDTH YEN SIGNFULLWIDTH WON SIGNHALFWIDTH FORMS LIGHT VERTICALHALFWIDTH" +
	" LEFTWARDS ARROWHALFWIDTH UPWARDS ARROWHALFWIDTH RIGHTWARDS ARROWHALFWID" +
	"TH DOWNWARDS ARROWHALFWIDTH BLACK SQUAREHALFWIDTH WHITE CIRCLEINTERLINEA" +
	"R ANNOTATION ANCHORINTERLINEAR ANNOTATION SEPARATORINTERLINEAR ANNOTATIO" +
	"N TERMINATOROBJECT REPLACEMENT CHARACTERREPLACEMENT CHARACTERLINEAR B SY" +
	"LLABLE B008 ALINEAR B SYLLABLE B038 ELINEAR B SYLLABLE B028 ILINEAR B SY" +
	"LLABLE B061 OLINEAR B SYLLABLE B010 ULINEAR B SYLLABLE B001 DALINEAR B S" +
	"YLLABLE B045 DELINEAR B SYLLABLE B007 DILINEAR B SYLLABLE B014 DOLINEAR " +
	"B SYLLABLE B051 DULINEAR B SYLLABLE B057 JALINEAR B SYLLABLE B046 JELINE" +
	"AR B SYLLABLE B036 JOLINEAR B SYLLABLE B065 JULINEAR B SYLLABLE B077 KAL" +
	"INEAR B SYLLABLE B044 KELINEAR B SYLLABLE B067 KILINEAR B SYLLABLE B070 " +
	"KOLINEAR B SYLLABLE B081 KULINEAR B SYLLABLE B080 MALINEAR B SYLLABLE B0") + ("" +
	"13 MELINEAR B SYLLABLE B073 MILINEAR B SYLLABLE B015 MOLINEAR B SYLLABLE" +
	" B023 MULINEAR B SYLLABLE B006 NALINEAR B SYLLABLE B024 NELINEAR B SYLLA" +
	"BLE B030 NILINEAR B SYLLABLE B052 NOLINEAR B SYLLABLE B055 NULINEAR B SY" +
	"LLABLE B003 PALINEAR B SYLLABLE B072 PELINEAR B SYLLABLE B039 PILINEAR B" +
	" SYLLABLE B011 POLINEAR B SYLLABLE B050 PULINEAR B SYLLABLE B016 QALINEA" +
	"R B SYLLABLE B078 QELINEAR B SYLLABLE B021 QILINEAR B SYLLABLE B032 QOLI" +
	"NEAR B SYLLABLE B060 RALINEAR B SYLLABLE B027 RELINEAR B SYLLABLE B053 R" +
	"ILINEAR B SYLLABLE B002 ROLINEAR B SYLLABLE B026 RULINEAR B SYLLABLE B03" +
	"1 SALINEAR B SYLLABLE B009 SELINEAR B SYLLABLE B041 SILINEAR B SYLLABLE " +
	"B012 SOLINEAR B SYLLABLE B058 SULINEAR B SYLLABLE B059 TALINEAR B SYLLAB" +
	"LE B004 TELINEAR B SYLLABLE B037 TILINEAR B SYLLABLE B005 TOLINEAR B SYL" +
	"LABLE B069 TULINEAR B SYLLABLE B054 WALINEAR B SYLLABLE B075 WELINEAR B " +
	"SYLLABLE B040 WILINEAR B SYLLABLE B042 WOLINEAR B SYLLABLE B017 ZALINEAR" +
	" B SYLLABLE B074 ZELINEAR B SYLLABLE B020 ZOLINEAR B SYLLABLE B025 A2LIN" +
	"EAR B SYLLABLE B043 A3LINEAR B SYLLABLE B085 AULINEAR B SYLLABLE B071 DW" +
	"ELINEAR B SYLLABLE B090 DWOLINEAR B SYLLABLE B048 NWALINEAR B SYLLABLE B" +
	"029 PU2LINEAR B SYLLABLE B062 PTELINEAR B SYLLABLE B076 RA2LINEAR B SYLL" +
	"ABLE B033 RA3LINEAR B SYLLABLE B068 RO2LINEAR B SYLLABLE B066 TA2LINEAR " +
	"B SYLLABLE B087 TWELINEAR B SYLLABLE B091 TWOLINEAR B SYMBOL B018LINEAR " +
	"B SYMBOL B019LINEAR B SYMBOL B022LINEAR B SYMBOL B034LINEAR B SYMBOL B04" +
	"7LINEAR B SYMBOL B049LINEAR B SYMBOL B056LINEAR B SYMBOL B063LINEAR B SY" +
	"MBOL B064LINEAR B SYMBOL B079LINEAR B SYMBOL B082LINEAR B SYMBOL B083LIN" +
	"EAR B SYMBOL B086LINEAR B SYMBOL B089LINEAR B IDEOGRAM B100 MANLINEAR B " +
	"IDEOGRAM B102 WOMANLINEAR B IDEOGRAM B104 DEERLINEAR B IDEOGRAM B105 EQU" +
	"IDLINEAR B IDEOGRAM B105F MARELINEAR B IDEOGRAM B105M STALLIONLINEAR B I" +
	"DEOGRAM B106F EWELINEAR B IDEOGRAM B106M RAMLINEAR B IDEOGRAM B107F SHE-" +
	"GOATLINEAR B IDEOGRAM B107M HE-GOATLINEAR B IDEOGRAM B108F SOWLINEAR B I" +
	"DEOGRAM B108M BOARLINEAR B IDEOGRAM B109F COWLINEAR B IDEOGRAM B109M BUL" +
	"LLINEAR B IDEOGRAM B120 WHEATLINEAR B IDEOGRAM B121 BARLEYLINEAR B IDEOG" +
	"RAM B122 OLIVELINEAR B IDEOGRAM B123 SPICELINEAR B IDEOGRAM B125 CYPERUS" +
	"LINEAR B MONOGRAM B127 KAPOLINEAR B MONOGRAM B128 KANAKOLINEAR B IDEOGRA" +
	"M B130 OILLINEAR B IDEOGRAM B131 WINELINEAR B IDEOGRAM B132LINEAR B MONO" +
	"GRAM B133 AREPALINEAR B MONOGRAM B135 MERILINEAR B IDEOGRAM B140 BRONZEL" +
	"INEAR B IDEOGRAM B141 GOLDLINEAR B IDEOGRAM B142LINEAR B IDEOGRAM B145 W" +
	"OOLLINEAR B IDEOGRAM B146LINEAR B IDEOGRAM B150LINEAR B IDEOGRAM B151 HO" +
	"RNLINEAR B IDEOGRAM B152LINEAR B IDEOGRAM B153LINEAR B IDEOGRAM B154LINE" +
	"AR B MONOGRAM B156 TURO2LINEAR B IDEOGRAM B157LINEAR B IDEOGRAM B158LINE" +
	"AR B IDEOGRAM B159 CLOTHLINEAR B IDEOGRAM B160LINEAR B IDEOGRAM B161LINE" +
	"AR B IDEOGRAM B162 GARMENTLINEAR B IDEOGRAM B163 ARMOURLINEAR B IDEOGRAM" +
	" B164LINEAR B IDEOGRAM B165LINEAR B IDEOGRAM B166LINEAR B IDEOGRAM B167L" +
	"INEAR B IDEOGRAM B168LINEAR B IDEOGRAM B169LINEAR B IDEOGRAM B170LINEAR " +
	"B IDEOGRAM B171LINEAR B IDEOGRAM B172LINEAR B IDEOGRAM B173 MONTHLINEAR " +
	"B IDEOGRAM B174LINEAR B IDEOGRAM B176 TREELINEAR B IDEOGRAM B177LINEAR B" +
	" IDEOGRAM B178LINEAR B IDEOGRAM B179LINEAR B IDEOGRAM B180LINEAR B IDEOG" +
	"RAM B181LINEAR B IDEOGRAM B182LINEAR B IDEOGRAM B183LINEAR B IDEOGRAM B1" +
	"84LINEAR B IDEOGRAM B185LINEAR B IDEOGRAM B189LINEAR B IDEOGRAM B190LINE" +
	"AR B IDEOGRAM B191 HELMETLINEAR B IDEOGRAM B220 FOOTSTOOLLINEAR B IDEOGR" +
	"AM B225 BATHTUBLINEAR B IDEOGRAM B230 SPEARLINEAR B IDEOGRAM B231 ARROWL" +
	"INEAR B IDEOGRAM B232LINEAR B IDEOGRAM B233 SWORDLINEAR B IDEOGRAM B234L" +
	"INEAR B IDEOGRAM B236LINEAR B IDEOGRAM B240 WHEELED CHARIOTLINEAR B IDEO" +
	"GRAM B241 CHARIOTLINEAR B IDEOGRAM B242 CHARIOT FRAMELINEAR B IDEOGRAM B" +
	"243 WHEELLINEAR B IDEOGRAM B245LINEAR B IDEOGRAM B246LINEAR B MONOGRAM B" +
	"247 DIPTELINEAR B IDEOGRAM B248LINEAR B IDEOGRAM B249LINEAR B IDEOGRAM B" +
	"251LINEAR B IDEOGRAM B252LINEAR B IDEOGRAM B253LINEAR B IDEOGRAM B254 DA" +
	"RTLINEAR B IDEOGRAM B255LINEAR B IDEOGRAM B256LINEAR B IDEOGRAM B257LINE" +
	"AR B IDEOGRAM B258LINEAR B IDEOGRAM B259LINEAR B IDEOGRAM VESSEL B155LIN" +
	"EAR B IDEOGRAM VESSEL B200LINEAR B IDEOGRAM VESSEL B201LINEAR B IDEOGRAM" +
	" VESSEL B202LINEAR B IDEOGRAM VESSEL B203LINEAR B IDEOGRAM VESSEL B204LI" +
	"NEAR B IDEOGRAM VESSEL B205LINEAR B IDEOGRAM VESSEL B206LINEAR B IDEOGRA" +
	"M VESSEL B207LINEAR B IDEOGRAM VESSEL B208LINEAR B IDEOGRAM VESSEL B209L" +
	"INEAR B IDEOGRAM VESSEL B210LINEAR B IDEOGRAM VESSEL B211LINEAR B IDEOGR" +
	"AM VESSEL B212LINEAR B IDEOGRAM VESSEL B213LINEAR B IDEOGRAM VESSEL B214" +
	"LINEAR B IDEOGRAM VESSEL B215LINEAR B IDEOGRAM VESSEL B216LINEAR B IDEOG" +
	"RAM VESSEL B217LINEAR B IDEOGRAM VESSEL B218LINEAR B IDEOGRAM VESSEL B21") + ("" +
	"9LINEAR B IDEOGRAM VESSEL B221LINEAR B IDEOGRAM VESSEL B222LINEAR B IDEO" +
	"GRAM VESSEL B226LINEAR B IDEOGRAM VESSEL B227LINEAR B IDEOGRAM VESSEL B2" +
	"28LINEAR B IDEOGRAM VESSEL B229LINEAR B IDEOGRAM VESSEL B250LINEAR B IDE" +
	"OGRAM VESSEL B305AEGEAN WORD SEPARATOR LINEAEGEAN WORD SEPARATOR DOTAEGE" +
	"AN CHECK MARKAEGEAN NUMBER ONEAEGEAN NUMBER TWOAEGEAN NUMBER THREEAEGEAN" +
	" NUMBER FOURAEGEAN NUMBER FIVEAEGEAN NUMBER SIXAEGEAN NUMBER SEVENAEGEAN" +
	" NUMBER EIGHTAEGEAN NUMBER NINEAEGEAN NUMBER TENAEGEAN NUMBER TWENTYAEGE" +
	"AN NUMBER THIRTYAEGEAN NUMBER FORTYAEGEAN NUMBER FIFTYAEGEAN NUMBER SIXT" +
	"YAEGEAN NUMBER SEVENTYAEGEAN NUMBER EIGHTYAEGEAN NUMBER NINETYAEGEAN NUM" +
	"BER ONE HUNDREDAEGEAN NUMBER TWO HUNDREDAEGEAN NUMBER THREE HUNDREDAEGEA" +
	"N NUMBER FOUR HUNDREDAEGEAN NUMBER FIVE HUNDREDAEGEAN NUMBER SIX HUNDRED" +
	"AEGEAN NUMBER SEVEN HUNDREDAEGEAN NUMBER EIGHT HUNDREDAEGEAN NUMBER NINE" +
	" HUNDREDAEGEAN NUMBER ONE THOUSANDAEGEAN NUMBER TWO THOUSANDAEGEAN NUMBE" +
	"R THREE THOUSANDAEGEAN NUMBER FOUR THOUSANDAEGEAN NUMBER FIVE THOUSANDAE" +
	"GEAN NUMBER SIX THOUSANDAEGEAN NUMBER SEVEN THOUSANDAEGEAN NUMBER EIGHT " +
	"THOUSANDAEGEAN NUMBER NINE THOUSANDAEGEAN NUMBER TEN THOUSANDAEGEAN NUMB" +
	"ER TWENTY THOUSANDAEGEAN NUMBER THIRTY THOUSANDAEGEAN NUMBER FORTY THOUS" +
	"ANDAEGEAN NUMBER FIFTY THOUSANDAEGEAN NUMBER SIXTY THOUSANDAEGEAN NUMBER" +
	" SEVENTY THOUSANDAEGEAN NUMBER EIGHTY THOUSANDAEGEAN NUMBER NINETY THOUS" +
	"ANDAEGEAN WEIGHT BASE UNITAEGEAN WEIGHT FIRST SUBUNITAEGEAN WEIGHT SECON" +
	"D SUBUNITAEGEAN WEIGHT THIRD SUBUNITAEGEAN WEIGHT FOURTH SUBUNITAEGEAN D" +
	"RY MEASURE FIRST SUBUNITAEGEAN LIQUID MEASURE FIRST SUBUNITAEGEAN MEASUR" +
	"E SECOND SUBUNITAEGEAN MEASURE THIRD SUBUNITGREEK ACROPHONIC ATTIC ONE Q" +
	"UARTERGREEK ACROPHONIC ATTIC ONE HALFGREEK ACROPHONIC ATTIC ONE DRACHMAG" +
	"REEK ACROPHONIC ATTIC FIVEGREEK ACROPHONIC ATTIC FIFTYGREEK ACROPHONIC A" +
	"TTIC FIVE HUNDREDGREEK ACROPHONIC ATTIC FIVE THOUSANDGREEK ACROPHONIC AT" +
	"TIC FIFTY THOUSANDGREEK ACROPHONIC ATTIC FIVE TALENTSGREEK ACROPHONIC AT" +
	"TIC TEN TALENTSGREEK ACROPHONIC ATTIC FIFTY TALENTSGREEK ACROPHONIC ATTI" +
	"C ONE HUNDRED TALENTSGREEK ACROPHONIC ATTIC FIVE HUNDRED TALENTSGREEK AC" +
	"ROPHONIC ATTIC ONE THOUSAND TALENTSGREEK ACROPHONIC ATTIC FIVE THOUSAND " +
	"TALENTSGREEK ACROPHONIC ATTIC FIVE STATERSGREEK ACROPHONIC ATTIC TEN STA" +
	"TERSGREEK ACROPHONIC ATTIC FIFTY STATERSGREEK ACROPHONIC ATTIC ONE HUNDR" +
	"ED STATERSGREEK ACROPHONIC ATTIC FIVE HUNDRED STATERSGREEK ACROPHONIC AT" +
	"TIC ONE THOUSAND STATERSGREEK ACROPHONIC ATTIC TEN THOUSAND STATERSGREEK" +
	" ACROPHONIC ATTIC FIFTY THOUSAND STATERSGREEK ACROPHONIC ATTIC TEN MNASG" +
	"REEK ACROPHONIC HERAEUM ONE PLETHRONGREEK ACROPHONIC THESPIAN ONEGREEK A" +
	"CROPHONIC HERMIONIAN ONEGREEK ACROPHONIC EPIDAUREAN TWOGREEK ACROPHONIC " +
	"THESPIAN TWOGREEK ACROPHONIC CYRENAIC TWO DRACHMASGREEK ACROPHONIC EPIDA" +
	"UREAN TWO DRACHMASGREEK ACROPHONIC TROEZENIAN FIVEGREEK ACROPHONIC TROEZ" +
	"ENIAN TENGREEK ACROPHONIC TROEZENIAN TEN ALTERNATE FORMGREEK ACROPHONIC " +
	"HERMIONIAN TENGREEK ACROPHONIC MESSENIAN TENGREEK ACROPHONIC THESPIAN TE" +
	"NGREEK ACROPHONIC THESPIAN THIRTYGREEK ACROPHONIC TROEZENIAN FIFTYGREEK " +
	"ACROPHONIC TROEZENIAN FIFTY ALTERNATE FORMGREEK ACROPHONIC HERMIONIAN FI" +
	"FTYGREEK ACROPHONIC THESPIAN FIFTYGREEK ACROPHONIC THESPIAN ONE HUNDREDG" +
	"REEK ACROPHONIC THESPIAN THREE HUNDREDGREEK ACROPHONIC EPIDAUREAN FIVE H" +
	"UNDREDGREEK ACROPHONIC TROEZENIAN FIVE HUNDREDGREEK ACROPHONIC THESPIAN " +
	"FIVE HUNDREDGREEK ACROPHONIC CARYSTIAN FIVE HUNDREDGREEK ACROPHONIC NAXI" +
	"AN FIVE HUNDREDGREEK ACROPHONIC THESPIAN ONE THOUSANDGREEK ACROPHONIC TH" +
	"ESPIAN FIVE THOUSANDGREEK ACROPHONIC DELPHIC FIVE MNASGREEK ACROPHONIC S" +
	"TRATIAN FIFTY MNASGREEK ONE HALF SIGNGREEK ONE HALF SIGN ALTERNATE FORMG" +
	"REEK TWO THIRDS SIGNGREEK THREE QUARTERS SIGNGREEK YEAR SIGNGREEK TALENT" +
	" SIGNGREEK DRACHMA SIGNGREEK OBOL SIGNGREEK TWO OBOLS SIGNGREEK THREE OB" +
	"OLS SIGNGREEK FOUR OBOLS SIGNGREEK FIVE OBOLS SIGNGREEK METRETES SIGNGRE" +
	"EK KYATHOS BASE SIGNGREEK LITRA SIGNGREEK OUNKIA SIGNGREEK XESTES SIGNGR" +
	"EEK ARTABE SIGNGREEK AROURA SIGNGREEK GRAMMA SIGNGREEK TRYBLION BASE SIG" +
	"NGREEK ZERO SIGNGREEK ONE QUARTER SIGNGREEK SINUSOID SIGNGREEK INDICTION" +
	" SIGNNOMISMA SIGNROMAN SEXTANS SIGNROMAN UNCIA SIGNROMAN SEMUNCIA SIGNRO" +
	"MAN SEXTULA SIGNROMAN DIMIDIA SEXTULA SIGNROMAN SILIQUA SIGNROMAN DENARI" +
	"US SIGNROMAN QUINARIUS SIGNROMAN SESTERTIUS SIGNROMAN DUPONDIUS SIGNROMA" +
	"N AS SIGNROMAN CENTURIAL SIGNASCIA SYMBOLGREEK SYMBOL TAU RHOPHAISTOS DI" +
	"SC SIGN PEDESTRIANPHAISTOS DISC SIGN PLUMED HEADPHAISTOS DISC SIGN TATTO" +
	"OED HEADPHAISTOS DISC SIGN CAPTIVEPHAISTOS DISC SIGN CHILDPHAISTOS DISC " +
	"SIGN WOMANPHAISTOS DISC SIGN HELMETPHAISTOS DISC SIGN GAUNTLETPHAISTOS D" +
	"ISC SIGN TIARAPHAISTOS DISC SIGN ARROWPHAISTOS DISC SIGN BOWPHAISTOS DIS") + ("" +
	"C SIGN SHIELDPHAISTOS DISC SIGN CLUBPHAISTOS DISC SIGN MANACLESPHAISTOS " +
	"DISC SIGN MATTOCKPHAISTOS DISC SIGN SAWPHAISTOS DISC SIGN LIDPHAISTOS DI" +
	"SC SIGN BOOMERANGPHAISTOS DISC SIGN CARPENTRY PLANEPHAISTOS DISC SIGN DO" +
	"LIUMPHAISTOS DISC SIGN COMBPHAISTOS DISC SIGN SLINGPHAISTOS DISC SIGN CO" +
	"LUMNPHAISTOS DISC SIGN BEEHIVEPHAISTOS DISC SIGN SHIPPHAISTOS DISC SIGN " +
	"HORNPHAISTOS DISC SIGN HIDEPHAISTOS DISC SIGN BULLS LEGPHAISTOS DISC SIG" +
	"N CATPHAISTOS DISC SIGN RAMPHAISTOS DISC SIGN EAGLEPHAISTOS DISC SIGN DO" +
	"VEPHAISTOS DISC SIGN TUNNYPHAISTOS DISC SIGN BEEPHAISTOS DISC SIGN PLANE" +
	" TREEPHAISTOS DISC SIGN VINEPHAISTOS DISC SIGN PAPYRUSPHAISTOS DISC SIGN" +
	" ROSETTEPHAISTOS DISC SIGN LILYPHAISTOS DISC SIGN OX BACKPHAISTOS DISC S" +
	"IGN FLUTEPHAISTOS DISC SIGN GRATERPHAISTOS DISC SIGN STRAINERPHAISTOS DI" +
	"SC SIGN SMALL AXEPHAISTOS DISC SIGN WAVY BANDPHAISTOS DISC SIGN COMBININ" +
	"G OBLIQUE STROKELYCIAN LETTER ALYCIAN LETTER ELYCIAN LETTER BLYCIAN LETT" +
	"ER BHLYCIAN LETTER GLYCIAN LETTER DLYCIAN LETTER ILYCIAN LETTER WLYCIAN " +
	"LETTER ZLYCIAN LETTER THLYCIAN LETTER JLYCIAN LETTER KLYCIAN LETTER QLYC" +
	"IAN LETTER LLYCIAN LETTER MLYCIAN LETTER NLYCIAN LETTER MMLYCIAN LETTER " +
	"NNLYCIAN LETTER ULYCIAN LETTER PLYCIAN LETTER KKLYCIAN LETTER RLYCIAN LE" +
	"TTER SLYCIAN LETTER TLYCIAN LETTER TTLYCIAN LETTER ANLYCIAN LETTER ENLYC" +
	"IAN LETTER HLYCIAN LETTER XCARIAN LETTER ACARIAN LETTER P2CARIAN LETTER " +
	"DCARIAN LETTER LCARIAN LETTER UUUCARIAN LETTER RCARIAN LETTER LDCARIAN L" +
	"ETTER A2CARIAN LETTER QCARIAN LETTER BCARIAN LETTER MCARIAN LETTER OCARI" +
	"AN LETTER D2CARIAN LETTER TCARIAN LETTER SHCARIAN LETTER SH2CARIAN LETTE" +
	"R SCARIAN LETTER C-18CARIAN LETTER UCARIAN LETTER NNCARIAN LETTER XCARIA" +
	"N LETTER NCARIAN LETTER TT2CARIAN LETTER PCARIAN LETTER SSCARIAN LETTER " +
	"ICARIAN LETTER ECARIAN LETTER UUUUCARIAN LETTER KCARIAN LETTER K2CARIAN " +
	"LETTER NDCARIAN LETTER UUCARIAN LETTER GCARIAN LETTER G2CARIAN LETTER ST" +
	"CARIAN LETTER ST2CARIAN LETTER NGCARIAN LETTER IICARIAN LETTER C-39CARIA" +
	"N LETTER TTCARIAN LETTER UUU2CARIAN LETTER RRCARIAN LETTER MBCARIAN LETT" +
	"ER MB2CARIAN LETTER MB3CARIAN LETTER MB4CARIAN LETTER LD2CARIAN LETTER E" +
	"2CARIAN LETTER UUU3COPTIC EPACT THOUSANDS MARKCOPTIC EPACT DIGIT ONECOPT" +
	"IC EPACT DIGIT TWOCOPTIC EPACT DIGIT THREECOPTIC EPACT DIGIT FOURCOPTIC " +
	"EPACT DIGIT FIVECOPTIC EPACT DIGIT SIXCOPTIC EPACT DIGIT SEVENCOPTIC EPA" +
	"CT DIGIT EIGHTCOPTIC EPACT DIGIT NINECOPTIC EPACT NUMBER TENCOPTIC EPACT" +
	" NUMBER TWENTYCOPTIC EPACT NUMBER THIRTYCOPTIC EPACT NUMBER FORTYCOPTIC " +
	"EPACT NUMBER FIFTYCOPTIC EPACT NUMBER SIXTYCOPTIC EPACT NUMBER SEVENTYCO" +
	"PTIC EPACT NUMBER EIGHTYCOPTIC EPACT NUMBER NINETYCOPTIC EPACT NUMBER ON" +
	"E HUNDREDCOPTIC EPACT NUMBER TWO HUNDREDCOPTIC EPACT NUMBER THREE HUNDRE" +
	"DCOPTIC EPACT NUMBER FOUR HUNDREDCOPTIC EPACT NUMBER FIVE HUNDREDCOPTIC " +
	"EPACT NUMBER SIX HUNDREDCOPTIC EPACT NUMBER SEVEN HUNDREDCOPTIC EPACT NU" +
	"MBER EIGHT HUNDREDCOPTIC EPACT NUMBER NINE HUNDREDOLD ITALIC LETTER AOLD" +
	" ITALIC LETTER BEOLD ITALIC LETTER KEOLD ITALIC LETTER DEOLD ITALIC LETT" +
	"ER EOLD ITALIC LETTER VEOLD ITALIC LETTER ZEOLD ITALIC LETTER HEOLD ITAL" +
	"IC LETTER THEOLD ITALIC LETTER IOLD ITALIC LETTER KAOLD ITALIC LETTER EL" +
	"OLD ITALIC LETTER EMOLD ITALIC LETTER ENOLD ITALIC LETTER ESHOLD ITALIC " +
	"LETTER OOLD ITALIC LETTER PEOLD ITALIC LETTER SHEOLD ITALIC LETTER KUOLD" +
	" ITALIC LETTER EROLD ITALIC LETTER ESOLD ITALIC LETTER TEOLD ITALIC LETT" +
	"ER UOLD ITALIC LETTER EKSOLD ITALIC LETTER PHEOLD ITALIC LETTER KHEOLD I" +
	"TALIC LETTER EFOLD ITALIC LETTER ERSOLD ITALIC LETTER CHEOLD ITALIC LETT" +
	"ER IIOLD ITALIC LETTER UUOLD ITALIC LETTER ESSOLD ITALIC NUMERAL ONEOLD " +
	"ITALIC NUMERAL FIVEOLD ITALIC NUMERAL TENOLD ITALIC NUMERAL FIFTYOLD ITA" +
	"LIC LETTER YEOLD ITALIC LETTER NORTHERN TSEOLD ITALIC LETTER SOUTHERN TS" +
	"EGOTHIC LETTER AHSAGOTHIC LETTER BAIRKANGOTHIC LETTER GIBAGOTHIC LETTER " +
	"DAGSGOTHIC LETTER AIHVUSGOTHIC LETTER QAIRTHRAGOTHIC LETTER IUJAGOTHIC L" +
	"ETTER HAGLGOTHIC LETTER THIUTHGOTHIC LETTER EISGOTHIC LETTER KUSMAGOTHIC" +
	" LETTER LAGUSGOTHIC LETTER MANNAGOTHIC LETTER NAUTHSGOTHIC LETTER JERGOT" +
	"HIC LETTER URUSGOTHIC LETTER PAIRTHRAGOTHIC LETTER NINETYGOTHIC LETTER R" +
	"AIDAGOTHIC LETTER SAUILGOTHIC LETTER TEIWSGOTHIC LETTER WINJAGOTHIC LETT" +
	"ER FAIHUGOTHIC LETTER IGGWSGOTHIC LETTER HWAIRGOTHIC LETTER OTHALGOTHIC " +
	"LETTER NINE HUNDREDOLD PERMIC LETTER ANOLD PERMIC LETTER BUROLD PERMIC L" +
	"ETTER GAIOLD PERMIC LETTER DOIOLD PERMIC LETTER EOLD PERMIC LETTER ZHOIO" +
	"LD PERMIC LETTER DZHOIOLD PERMIC LETTER ZATAOLD PERMIC LETTER DZITAOLD P" +
	"ERMIC LETTER IOLD PERMIC LETTER KOKEOLD PERMIC LETTER LEIOLD PERMIC LETT" +
	"ER MENOEOLD PERMIC LETTER NENOEOLD PERMIC LETTER VOOIOLD PERMIC LETTER P" +
	"EEIOLD PERMIC LETTER REIOLD PERMIC LETTER SIIOLD PERMIC LETTER TAIOLD PE") + ("" +
	"RMIC LETTER UOLD PERMIC LETTER CHERYOLD PERMIC LETTER SHOOIOLD PERMIC LE" +
	"TTER SHCHOOIOLD PERMIC LETTER YRYOLD PERMIC LETTER YERUOLD PERMIC LETTER" +
	" OOLD PERMIC LETTER OOOLD PERMIC LETTER EFOLD PERMIC LETTER HAOLD PERMIC" +
	" LETTER TSIUOLD PERMIC LETTER VEROLD PERMIC LETTER YEROLD PERMIC LETTER " +
	"YERIOLD PERMIC LETTER YATOLD PERMIC LETTER IEOLD PERMIC LETTER YUOLD PER" +
	"MIC LETTER YAOLD PERMIC LETTER IACOMBINING OLD PERMIC LETTER ANCOMBINING" +
	" OLD PERMIC LETTER DOICOMBINING OLD PERMIC LETTER ZATACOMBINING OLD PERM" +
	"IC LETTER NENOECOMBINING OLD PERMIC LETTER SIIUGARITIC LETTER ALPAUGARIT" +
	"IC LETTER BETAUGARITIC LETTER GAMLAUGARITIC LETTER KHAUGARITIC LETTER DE" +
	"LTAUGARITIC LETTER HOUGARITIC LETTER WOUGARITIC LETTER ZETAUGARITIC LETT" +
	"ER HOTAUGARITIC LETTER TETUGARITIC LETTER YODUGARITIC LETTER KAFUGARITIC" +
	" LETTER SHINUGARITIC LETTER LAMDAUGARITIC LETTER MEMUGARITIC LETTER DHAL" +
	"UGARITIC LETTER NUNUGARITIC LETTER ZUUGARITIC LETTER SAMKAUGARITIC LETTE" +
	"R AINUGARITIC LETTER PUUGARITIC LETTER SADEUGARITIC LETTER QOPAUGARITIC " +
	"LETTER RASHAUGARITIC LETTER THANNAUGARITIC LETTER GHAINUGARITIC LETTER T" +
	"OUGARITIC LETTER IUGARITIC LETTER UUGARITIC LETTER SSUUGARITIC WORD DIVI" +
	"DEROLD PERSIAN SIGN AOLD PERSIAN SIGN IOLD PERSIAN SIGN UOLD PERSIAN SIG" +
	"N KAOLD PERSIAN SIGN KUOLD PERSIAN SIGN GAOLD PERSIAN SIGN GUOLD PERSIAN" +
	" SIGN XAOLD PERSIAN SIGN CAOLD PERSIAN SIGN JAOLD PERSIAN SIGN JIOLD PER" +
	"SIAN SIGN TAOLD PERSIAN SIGN TUOLD PERSIAN SIGN DAOLD PERSIAN SIGN DIOLD" +
	" PERSIAN SIGN DUOLD PERSIAN SIGN THAOLD PERSIAN SIGN PAOLD PERSIAN SIGN " +
	"BAOLD PERSIAN SIGN FAOLD PERSIAN SIGN NAOLD PERSIAN SIGN NUOLD PERSIAN S" +
	"IGN MAOLD PERSIAN SIGN MIOLD PERSIAN SIGN MUOLD PERSIAN SIGN YAOLD PERSI" +
	"AN SIGN VAOLD PERSIAN SIGN VIOLD PERSIAN SIGN RAOLD PERSIAN SIGN RUOLD P" +
	"ERSIAN SIGN LAOLD PERSIAN SIGN SAOLD PERSIAN SIGN ZAOLD PERSIAN SIGN SHA" +
	"OLD PERSIAN SIGN SSAOLD PERSIAN SIGN HAOLD PERSIAN SIGN AURAMAZDAAOLD PE" +
	"RSIAN SIGN AURAMAZDAA-2OLD PERSIAN SIGN AURAMAZDAAHAOLD PERSIAN SIGN XSH" +
	"AAYATHIYAOLD PERSIAN SIGN DAHYAAUSHOLD PERSIAN SIGN DAHYAAUSH-2OLD PERSI" +
	"AN SIGN BAGAOLD PERSIAN SIGN BUUMISHOLD PERSIAN WORD DIVIDEROLD PERSIAN " +
	"NUMBER ONEOLD PERSIAN NUMBER TWOOLD PERSIAN NUMBER TENOLD PERSIAN NUMBER" +
	" TWENTYOLD PERSIAN NUMBER HUNDREDDESERET CAPITAL LETTER LONG IDESERET CA" +
	"PITAL LETTER LONG EDESERET CAPITAL LETTER LONG ADESERET CAPITAL LETTER L" +
	"ONG AHDESERET CAPITAL LETTER LONG ODESERET CAPITAL LETTER LONG OODESERET" +
	" CAPITAL LETTER SHORT IDESERET CAPITAL LETTER SHORT EDESERET CAPITAL LET" +
	"TER SHORT ADESERET CAPITAL LETTER SHORT AHDESERET CAPITAL LETTER SHORT O" +
	"DESERET CAPITAL LETTER SHORT OODESERET CAPITAL LETTER AYDESERET CAPITAL " +
	"LETTER OWDESERET CAPITAL LETTER WUDESERET CAPITAL LETTER YEEDESERET CAPI" +
	"TAL LETTER HDESERET CAPITAL LETTER PEEDESERET CAPITAL LETTER BEEDESERET " +
	"CAPITAL LETTER TEEDESERET CAPITAL LETTER DEEDESERET CAPITAL LETTER CHEED" +
	"ESERET CAPITAL LETTER JEEDESERET CAPITAL LETTER KAYDESERET CAPITAL LETTE" +
	"R GAYDESERET CAPITAL LETTER EFDESERET CAPITAL LETTER VEEDESERET CAPITAL " +
	"LETTER ETHDESERET CAPITAL LETTER THEEDESERET CAPITAL LETTER ESDESERET CA" +
	"PITAL LETTER ZEEDESERET CAPITAL LETTER ESHDESERET CAPITAL LETTER ZHEEDES" +
	"ERET CAPITAL LETTER ERDESERET CAPITAL LETTER ELDESERET CAPITAL LETTER EM" +
	"DESERET CAPITAL LETTER ENDESERET CAPITAL LETTER ENGDESERET CAPITAL LETTE" +
	"R OIDESERET CAPITAL LETTER EWDESERET SMALL LETTER LONG IDESERET SMALL LE" +
	"TTER LONG EDESERET SMALL LETTER LONG ADESERET SMALL LETTER LONG AHDESERE" +
	"T SMALL LETTER LONG ODESERET SMALL LETTER LONG OODESERET SMALL LETTER SH" +
	"ORT IDESERET SMALL LETTER SHORT EDESERET SMALL LETTER SHORT ADESERET SMA" +
	"LL LETTER SHORT AHDESERET SMALL LETTER SHORT ODESERET SMALL LETTER SHORT" +
	" OODESERET SMALL LETTER AYDESERET SMALL LETTER OWDESERET SMALL LETTER WU" +
	"DESERET SMALL LETTER YEEDESERET SMALL LETTER HDESERET SMALL LETTER PEEDE" +
	"SERET SMALL LETTER BEEDESERET SMALL LETTER TEEDESERET SMALL LETTER DEEDE" +
	"SERET SMALL LETTER CHEEDESERET SMALL LETTER JEEDESERET SMALL LETTER KAYD" +
	"ESERET SMALL LETTER GAYDESERET SMALL LETTER EFDESERET SMALL LETTER VEEDE" +
	"SERET SMALL LETTER ETHDESERET SMALL LETTER THEEDESERET SMALL LETTER ESDE" +
	"SERET SMALL LETTER ZEEDESERET SMALL LETTER ESHDESERET SMALL LETTER ZHEED" +
	"ESERET SMALL LETTER ERDESERET SMALL LETTER ELDESERET SMALL LETTER EMDESE" +
	"RET SMALL LETTER ENDESERET SMALL LETTER ENGDESERET SMALL LETTER OIDESERE" +
	"T SMALL LETTER EWSHAVIAN LETTER PEEPSHAVIAN LETTER TOTSHAVIAN LETTER KIC" +
	"KSHAVIAN LETTER FEESHAVIAN LETTER THIGHSHAVIAN LETTER SOSHAVIAN LETTER S" +
	"URESHAVIAN LETTER CHURCHSHAVIAN LETTER YEASHAVIAN LETTER HUNGSHAVIAN LET" +
	"TER BIBSHAVIAN LETTER DEADSHAVIAN LETTER GAGSHAVIAN LETTER VOWSHAVIAN LE" +
	"TTER THEYSHAVIAN LETTER ZOOSHAVIAN LETTER MEASURESHAVIAN LETTER JUDGESHA") + ("" +
	"VIAN LETTER WOESHAVIAN LETTER HA-HASHAVIAN LETTER LOLLSHAVIAN LETTER MIM" +
	"ESHAVIAN LETTER IFSHAVIAN LETTER EGGSHAVIAN LETTER ASHSHAVIAN LETTER ADO" +
	"SHAVIAN LETTER ONSHAVIAN LETTER WOOLSHAVIAN LETTER OUTSHAVIAN LETTER AHS" +
	"HAVIAN LETTER ROARSHAVIAN LETTER NUNSHAVIAN LETTER EATSHAVIAN LETTER AGE" +
	"SHAVIAN LETTER ICESHAVIAN LETTER UPSHAVIAN LETTER OAKSHAVIAN LETTER OOZE" +
	"SHAVIAN LETTER OILSHAVIAN LETTER AWESHAVIAN LETTER ARESHAVIAN LETTER ORS" +
	"HAVIAN LETTER AIRSHAVIAN LETTER ERRSHAVIAN LETTER ARRAYSHAVIAN LETTER EA" +
	"RSHAVIAN LETTER IANSHAVIAN LETTER YEWOSMANYA LETTER ALEFOSMANYA LETTER B" +
	"AOSMANYA LETTER TAOSMANYA LETTER JAOSMANYA LETTER XAOSMANYA LETTER KHAOS" +
	"MANYA LETTER DEELOSMANYA LETTER RAOSMANYA LETTER SAOSMANYA LETTER SHIINO" +
	"SMANYA LETTER DHAOSMANYA LETTER CAYNOSMANYA LETTER GAOSMANYA LETTER FAOS" +
	"MANYA LETTER QAAFOSMANYA LETTER KAAFOSMANYA LETTER LAANOSMANYA LETTER MI" +
	"INOSMANYA LETTER NUUNOSMANYA LETTER WAWOSMANYA LETTER HAOSMANYA LETTER Y" +
	"AOSMANYA LETTER AOSMANYA LETTER EOSMANYA LETTER IOSMANYA LETTER OOSMANYA" +
	" LETTER UOSMANYA LETTER AAOSMANYA LETTER EEOSMANYA LETTER OOOSMANYA DIGI" +
	"T ZEROOSMANYA DIGIT ONEOSMANYA DIGIT TWOOSMANYA DIGIT THREEOSMANYA DIGIT" +
	" FOUROSMANYA DIGIT FIVEOSMANYA DIGIT SIXOSMANYA DIGIT SEVENOSMANYA DIGIT" +
	" EIGHTOSMANYA DIGIT NINEOSAGE CAPITAL LETTER AOSAGE CAPITAL LETTER AIOSA" +
	"GE CAPITAL LETTER AINOSAGE CAPITAL LETTER AHOSAGE CAPITAL LETTER BRAOSAG" +
	"E CAPITAL LETTER CHAOSAGE CAPITAL LETTER EHCHAOSAGE CAPITAL LETTER EOSAG" +
	"E CAPITAL LETTER EINOSAGE CAPITAL LETTER HAOSAGE CAPITAL LETTER HYAOSAGE" +
	" CAPITAL LETTER IOSAGE CAPITAL LETTER KAOSAGE CAPITAL LETTER EHKAOSAGE C" +
	"APITAL LETTER KYAOSAGE CAPITAL LETTER LAOSAGE CAPITAL LETTER MAOSAGE CAP" +
	"ITAL LETTER NAOSAGE CAPITAL LETTER OOSAGE CAPITAL LETTER OINOSAGE CAPITA" +
	"L LETTER PAOSAGE CAPITAL LETTER EHPAOSAGE CAPITAL LETTER SAOSAGE CAPITAL" +
	" LETTER SHAOSAGE CAPITAL LETTER TAOSAGE CAPITAL LETTER EHTAOSAGE CAPITAL" +
	" LETTER TSAOSAGE CAPITAL LETTER EHTSAOSAGE CAPITAL LETTER TSHAOSAGE CAPI" +
	"TAL LETTER DHAOSAGE CAPITAL LETTER UOSAGE CAPITAL LETTER WAOSAGE CAPITAL" +
	" LETTER KHAOSAGE CAPITAL LETTER GHAOSAGE CAPITAL LETTER ZAOSAGE CAPITAL " +
	"LETTER ZHAOSAGE SMALL LETTER AOSAGE SMALL LETTER AIOSAGE SMALL LETTER AI" +
	"NOSAGE SMALL LETTER AHOSAGE SMALL LETTER BRAOSAGE SMALL LETTER CHAOSAGE " +
	"SMALL LETTER EHCHAOSAGE SMALL LETTER EOSAGE SMALL LETTER EINOSAGE SMALL " +
	"LETTER HAOSAGE SMALL LETTER HYAOSAGE SMALL LETTER IOSAGE SMALL LETTER KA" +
	"OSAGE SMALL LETTER EHKAOSAGE SMALL LETTER KYAOSAGE SMALL LETTER LAOSAGE " +
	"SMALL LETTER MAOSAGE SMALL LETTER NAOSAGE SMALL LETTER OOSAGE SMALL LETT" +
	"ER OINOSAGE SMALL LETTER PAOSAGE SMALL LETTER EHPAOSAGE SMALL LETTER SAO" +
	"SAGE SMALL LETTER SHAOSAGE SMALL LETTER TAOSAGE SMALL LETTER EHTAOSAGE S" +
	"MALL LETTER TSAOSAGE SMALL LETTER EHTSAOSAGE SMALL LETTER TSHAOSAGE SMAL" +
	"L LETTER DHAOSAGE SMALL LETTER UOSAGE SMALL LETTER WAOSAGE SMALL LETTER " +
	"KHAOSAGE SMALL LETTER GHAOSAGE SMALL LETTER ZAOSAGE SMALL LETTER ZHAELBA" +
	"SAN LETTER AELBASAN LETTER BEELBASAN LETTER CEELBASAN LETTER CHEELBASAN " +
	"LETTER DEELBASAN LETTER NDEELBASAN LETTER DHEELBASAN LETTER EIELBASAN LE" +
	"TTER EELBASAN LETTER FEELBASAN LETTER GEELBASAN LETTER GJEELBASAN LETTER" +
	" HEELBASAN LETTER IELBASAN LETTER JEELBASAN LETTER KEELBASAN LETTER LEEL" +
	"BASAN LETTER LLEELBASAN LETTER MEELBASAN LETTER NEELBASAN LETTER NAELBAS" +
	"AN LETTER NJEELBASAN LETTER OELBASAN LETTER PEELBASAN LETTER QEELBASAN L" +
	"ETTER REELBASAN LETTER RREELBASAN LETTER SEELBASAN LETTER SHEELBASAN LET" +
	"TER TEELBASAN LETTER THEELBASAN LETTER UELBASAN LETTER VEELBASAN LETTER " +
	"XEELBASAN LETTER YELBASAN LETTER ZEELBASAN LETTER ZHEELBASAN LETTER GHEE" +
	"LBASAN LETTER GHAMMAELBASAN LETTER KHECAUCASIAN ALBANIAN LETTER ALTCAUCA" +
	"SIAN ALBANIAN LETTER BETCAUCASIAN ALBANIAN LETTER GIMCAUCASIAN ALBANIAN " +
	"LETTER DATCAUCASIAN ALBANIAN LETTER EBCAUCASIAN ALBANIAN LETTER ZARLCAUC" +
	"ASIAN ALBANIAN LETTER EYNCAUCASIAN ALBANIAN LETTER ZHILCAUCASIAN ALBANIA" +
	"N LETTER TASCAUCASIAN ALBANIAN LETTER CHACAUCASIAN ALBANIAN LETTER YOWDC" +
	"AUCASIAN ALBANIAN LETTER ZHACAUCASIAN ALBANIAN LETTER IRBCAUCASIAN ALBAN" +
	"IAN LETTER SHACAUCASIAN ALBANIAN LETTER LANCAUCASIAN ALBANIAN LETTER INY" +
	"ACAUCASIAN ALBANIAN LETTER XEYNCAUCASIAN ALBANIAN LETTER DYANCAUCASIAN A" +
	"LBANIAN LETTER CARCAUCASIAN ALBANIAN LETTER JHOXCAUCASIAN ALBANIAN LETTE" +
	"R KARCAUCASIAN ALBANIAN LETTER LYITCAUCASIAN ALBANIAN LETTER HEYTCAUCASI" +
	"AN ALBANIAN LETTER QAYCAUCASIAN ALBANIAN LETTER AORCAUCASIAN ALBANIAN LE" +
	"TTER CHOYCAUCASIAN ALBANIAN LETTER CHICAUCASIAN ALBANIAN LETTER CYAYCAUC" +
	"ASIAN ALBANIAN LETTER MAQCAUCASIAN ALBANIAN LETTER QARCAUCASIAN ALBANIAN" +
	" LETTER NOWCCAUCASIAN ALBANIAN LETTER DZYAYCAUCASIAN ALBANIAN LETTER SHA" +
	"KCAUCASIAN ALBANIAN LETTER JAYNCAUCASIAN ALBANIAN LETTER ONCAUCASIAN ALB") + ("" +
	"ANIAN LETTER TYAYCAUCASIAN ALBANIAN LETTER FAMCAUCASIAN ALBANIAN LETTER " +
	"DZAYCAUCASIAN ALBANIAN LETTER CHATCAUCASIAN ALBANIAN LETTER PENCAUCASIAN" +
	" ALBANIAN LETTER GHEYSCAUCASIAN ALBANIAN LETTER RATCAUCASIAN ALBANIAN LE" +
	"TTER SEYKCAUCASIAN ALBANIAN LETTER VEYZCAUCASIAN ALBANIAN LETTER TIWRCAU" +
	"CASIAN ALBANIAN LETTER SHOYCAUCASIAN ALBANIAN LETTER IWNCAUCASIAN ALBANI" +
	"AN LETTER CYAWCAUCASIAN ALBANIAN LETTER CAYNCAUCASIAN ALBANIAN LETTER YA" +
	"YDCAUCASIAN ALBANIAN LETTER PIWRCAUCASIAN ALBANIAN LETTER KIWCAUCASIAN A" +
	"LBANIAN CITATION MARKLINEAR A SIGN AB001LINEAR A SIGN AB002LINEAR A SIGN" +
	" AB003LINEAR A SIGN AB004LINEAR A SIGN AB005LINEAR A SIGN AB006LINEAR A " +
	"SIGN AB007LINEAR A SIGN AB008LINEAR A SIGN AB009LINEAR A SIGN AB010LINEA" +
	"R A SIGN AB011LINEAR A SIGN AB013LINEAR A SIGN AB016LINEAR A SIGN AB017L" +
	"INEAR A SIGN AB020LINEAR A SIGN AB021LINEAR A SIGN AB021FLINEAR A SIGN A" +
	"B021MLINEAR A SIGN AB022LINEAR A SIGN AB022FLINEAR A SIGN AB022MLINEAR A" +
	" SIGN AB023LINEAR A SIGN AB023MLINEAR A SIGN AB024LINEAR A SIGN AB026LIN" +
	"EAR A SIGN AB027LINEAR A SIGN AB028LINEAR A SIGN A028BLINEAR A SIGN AB02" +
	"9LINEAR A SIGN AB030LINEAR A SIGN AB031LINEAR A SIGN AB034LINEAR A SIGN " +
	"AB037LINEAR A SIGN AB038LINEAR A SIGN AB039LINEAR A SIGN AB040LINEAR A S" +
	"IGN AB041LINEAR A SIGN AB044LINEAR A SIGN AB045LINEAR A SIGN AB046LINEAR" +
	" A SIGN AB047LINEAR A SIGN AB048LINEAR A SIGN AB049LINEAR A SIGN AB050LI" +
	"NEAR A SIGN AB051LINEAR A SIGN AB053LINEAR A SIGN AB054LINEAR A SIGN AB0" +
	"55LINEAR A SIGN AB056LINEAR A SIGN AB057LINEAR A SIGN AB058LINEAR A SIGN" +
	" AB059LINEAR A SIGN AB060LINEAR A SIGN AB061LINEAR A SIGN AB065LINEAR A " +
	"SIGN AB066LINEAR A SIGN AB067LINEAR A SIGN AB069LINEAR A SIGN AB070LINEA" +
	"R A SIGN AB073LINEAR A SIGN AB074LINEAR A SIGN AB076LINEAR A SIGN AB077L" +
	"INEAR A SIGN AB078LINEAR A SIGN AB079LINEAR A SIGN AB080LINEAR A SIGN AB" +
	"081LINEAR A SIGN AB082LINEAR A SIGN AB085LINEAR A SIGN AB086LINEAR A SIG" +
	"N AB087LINEAR A SIGN A100-102LINEAR A SIGN AB118LINEAR A SIGN AB120LINEA" +
	"R A SIGN A120BLINEAR A SIGN AB122LINEAR A SIGN AB123LINEAR A SIGN AB131A" +
	"LINEAR A SIGN AB131BLINEAR A SIGN A131CLINEAR A SIGN AB164LINEAR A SIGN " +
	"AB171LINEAR A SIGN AB180LINEAR A SIGN AB188LINEAR A SIGN AB191LINEAR A S" +
	"IGN A301LINEAR A SIGN A302LINEAR A SIGN A303LINEAR A SIGN A304LINEAR A S" +
	"IGN A305LINEAR A SIGN A306LINEAR A SIGN A307LINEAR A SIGN A308LINEAR A S" +
	"IGN A309ALINEAR A SIGN A309BLINEAR A SIGN A309CLINEAR A SIGN A310LINEAR " +
	"A SIGN A311LINEAR A SIGN A312LINEAR A SIGN A313ALINEAR A SIGN A313BLINEA" +
	"R A SIGN A313CLINEAR A SIGN A314LINEAR A SIGN A315LINEAR A SIGN A316LINE" +
	"AR A SIGN A317LINEAR A SIGN A318LINEAR A SIGN A319LINEAR A SIGN A320LINE" +
	"AR A SIGN A321LINEAR A SIGN A322LINEAR A SIGN A323LINEAR A SIGN A324LINE" +
	"AR A SIGN A325LINEAR A SIGN A326LINEAR A SIGN A327LINEAR A SIGN A328LINE" +
	"AR A SIGN A329LINEAR A SIGN A330LINEAR A SIGN A331LINEAR A SIGN A332LINE" +
	"AR A SIGN A333LINEAR A SIGN A334LINEAR A SIGN A335LINEAR A SIGN A336LINE" +
	"AR A SIGN A337LINEAR A SIGN A338LINEAR A SIGN A339LINEAR A SIGN A340LINE" +
	"AR A SIGN A341LINEAR A SIGN A342LINEAR A SIGN A343LINEAR A SIGN A344LINE" +
	"AR A SIGN A345LINEAR A SIGN A346LINEAR A SIGN A347LINEAR A SIGN A348LINE" +
	"AR A SIGN A349LINEAR A SIGN A350LINEAR A SIGN A351LINEAR A SIGN A352LINE" +
	"AR A SIGN A353LINEAR A SIGN A354LINEAR A SIGN A355LINEAR A SIGN A356LINE" +
	"AR A SIGN A357LINEAR A SIGN A358LINEAR A SIGN A359LINEAR A SIGN A360LINE" +
	"AR A SIGN A361LINEAR A SIGN A362LINEAR A SIGN A363LINEAR A SIGN A364LINE" +
	"AR A SIGN A365LINEAR A SIGN A366LINEAR A SIGN A367LINEAR A SIGN A368LINE" +
	"AR A SIGN A369LINEAR A SIGN A370LINEAR A SIGN A371LINEAR A SIGN A400-VAS" +
	"LINEAR A SIGN A401-VASLINEAR A SIGN A402-VASLINEAR A SIGN A403-VASLINEAR" +
	" A SIGN A404-VASLINEAR A SIGN A405-VASLINEAR A SIGN A406-VASLINEAR A SIG" +
	"N A407-VASLINEAR A SIGN A408-VASLINEAR A SIGN A409-VASLINEAR A SIGN A410" +
	"-VASLINEAR A SIGN A411-VASLINEAR A SIGN A412-VASLINEAR A SIGN A413-VASLI" +
	"NEAR A SIGN A414-VASLINEAR A SIGN A415-VASLINEAR A SIGN A416-VASLINEAR A" +
	" SIGN A417-VASLINEAR A SIGN A418-VASLINEAR A SIGN A501LINEAR A SIGN A502" +
	"LINEAR A SIGN A503LINEAR A SIGN A504LINEAR A SIGN A505LINEAR A SIGN A506" +
	"LINEAR A SIGN A508LINEAR A SIGN A509LINEAR A SIGN A510LINEAR A SIGN A511" +
	"LINEAR A SIGN A512LINEAR A SIGN A513LINEAR A SIGN A515LINEAR A SIGN A516" +
	"LINEAR A SIGN A520LINEAR A SIGN A521LINEAR A SIGN A523LINEAR A SIGN A524" +
	"LINEAR A SIGN A525LINEAR A SIGN A526LINEAR A SIGN A527LINEAR A SIGN A528" +
	"LINEAR A SIGN A529LINEAR A SIGN A530LINEAR A SIGN A531LINEAR A SIGN A532" +
	"LINEAR A SIGN A534LINEAR A SIGN A535LINEAR A SIGN A536LINEAR A SIGN A537" +
	"LINEAR A SIGN A538LINEAR A SIGN A539LINEAR A SIGN A540LINEAR A SIGN A541" +
	"LINEAR A SIGN A542LINEAR A SIGN A545LINEAR A SIGN A547LINEAR A SIGN A548") + ("" +
	"LINEAR A SIGN A549LINEAR A SIGN A550LINEAR A SIGN A551LINEAR A SIGN A552" +
	"LINEAR A SIGN A553LINEAR A SIGN A554LINEAR A SIGN A555LINEAR A SIGN A556" +
	"LINEAR A SIGN A557LINEAR A SIGN A559LINEAR A SIGN A563LINEAR A SIGN A564" +
	"LINEAR A SIGN A565LINEAR A SIGN A566LINEAR A SIGN A568LINEAR A SIGN A569" +
	"LINEAR A SIGN A570LINEAR A SIGN A571LINEAR A SIGN A572LINEAR A SIGN A573" +
	"LINEAR A SIGN A574LINEAR A SIGN A575LINEAR A SIGN A576LINEAR A SIGN A577" +
	"LINEAR A SIGN A578LINEAR A SIGN A579LINEAR A SIGN A580LINEAR A SIGN A581" +
	"LINEAR A SIGN A582LINEAR A SIGN A583LINEAR A SIGN A584LINEAR A SIGN A585" +
	"LINEAR A SIGN A586LINEAR A SIGN A587LINEAR A SIGN A588LINEAR A SIGN A589" +
	"LINEAR A SIGN A591LINEAR A SIGN A592LINEAR A SIGN A594LINEAR A SIGN A595" +
	"LINEAR A SIGN A596LINEAR A SIGN A598LINEAR A SIGN A600LINEAR A SIGN A601" +
	"LINEAR A SIGN A602LINEAR A SIGN A603LINEAR A SIGN A604LINEAR A SIGN A606" +
	"LINEAR A SIGN A608LINEAR A SIGN A609LINEAR A SIGN A610LINEAR A SIGN A611" +
	"LINEAR A SIGN A612LINEAR A SIGN A613LINEAR A SIGN A614LINEAR A SIGN A615" +
	"LINEAR A SIGN A616LINEAR A SIGN A617LINEAR A SIGN A618LINEAR A SIGN A619" +
	"LINEAR A SIGN A620LINEAR A SIGN A621LINEAR A SIGN A622LINEAR A SIGN A623" +
	"LINEAR A SIGN A624LINEAR A SIGN A626LINEAR A SIGN A627LINEAR A SIGN A628" +
	"LINEAR A SIGN A629LINEAR A SIGN A634LINEAR A SIGN A637LINEAR A SIGN A638" +
	"LINEAR A SIGN A640LINEAR A SIGN A642LINEAR A SIGN A643LINEAR A SIGN A644" +
	"LINEAR A SIGN A645LINEAR A SIGN A646LINEAR A SIGN A648LINEAR A SIGN A649" +
	"LINEAR A SIGN A651LINEAR A SIGN A652LINEAR A SIGN A653LINEAR A SIGN A654" +
	"LINEAR A SIGN A655LINEAR A SIGN A656LINEAR A SIGN A657LINEAR A SIGN A658" +
	"LINEAR A SIGN A659LINEAR A SIGN A660LINEAR A SIGN A661LINEAR A SIGN A662" +
	"LINEAR A SIGN A663LINEAR A SIGN A664LINEAR A SIGN A701 ALINEAR A SIGN A7" +
	"02 BLINEAR A SIGN A703 DLINEAR A SIGN A704 ELINEAR A SIGN A705 FLINEAR A" +
	" SIGN A706 HLINEAR A SIGN A707 JLINEAR A SIGN A708 KLINEAR A SIGN A709 L" +
	"LINEAR A SIGN A709-2 L2LINEAR A SIGN A709-3 L3LINEAR A SIGN A709-4 L4LIN" +
	"EAR A SIGN A709-6 L6LINEAR A SIGN A710 WLINEAR A SIGN A711 XLINEAR A SIG" +
	"N A712 YLINEAR A SIGN A713 OMEGALINEAR A SIGN A714 ABBLINEAR A SIGN A715" +
	" BBLINEAR A SIGN A717 DDLINEAR A SIGN A726 EYYYLINEAR A SIGN A732 JELINE" +
	"AR A SIGN A800LINEAR A SIGN A801LINEAR A SIGN A802LINEAR A SIGN A803LINE" +
	"AR A SIGN A804LINEAR A SIGN A805LINEAR A SIGN A806LINEAR A SIGN A807CYPR" +
	"IOT SYLLABLE ACYPRIOT SYLLABLE ECYPRIOT SYLLABLE ICYPRIOT SYLLABLE OCYPR" +
	"IOT SYLLABLE UCYPRIOT SYLLABLE JACYPRIOT SYLLABLE JOCYPRIOT SYLLABLE KAC" +
	"YPRIOT SYLLABLE KECYPRIOT SYLLABLE KICYPRIOT SYLLABLE KOCYPRIOT SYLLABLE" +
	" KUCYPRIOT SYLLABLE LACYPRIOT SYLLABLE LECYPRIOT SYLLABLE LICYPRIOT SYLL" +
	"ABLE LOCYPRIOT SYLLABLE LUCYPRIOT SYLLABLE MACYPRIOT SYLLABLE MECYPRIOT " +
	"SYLLABLE MICYPRIOT SYLLABLE MOCYPRIOT SYLLABLE MUCYPRIOT SYLLABLE NACYPR" +
	"IOT SYLLABLE NECYPRIOT SYLLABLE NICYPRIOT SYLLABLE NOCYPRIOT SYLLABLE NU" +
	"CYPRIOT SYLLABLE PACYPRIOT SYLLABLE PECYPRIOT SYLLABLE PICYPRIOT SYLLABL" +
	"E POCYPRIOT SYLLABLE PUCYPRIOT SYLLABLE RACYPRIOT SYLLABLE RECYPRIOT SYL" +
	"LABLE RICYPRIOT SYLLABLE ROCYPRIOT SYLLABLE RUCYPRIOT SYLLABLE SACYPRIOT" +
	" SYLLABLE SECYPRIOT SYLLABLE SICYPRIOT SYLLABLE SOCYPRIOT SYLLABLE SUCYP" +
	"RIOT SYLLABLE TACYPRIOT SYLLABLE TECYPRIOT SYLLABLE TICYPRIOT SYLLABLE T" +
	"OCYPRIOT SYLLABLE TUCYPRIOT SYLLABLE WACYPRIOT SYLLABLE WECYPRIOT SYLLAB" +
	"LE WICYPRIOT SYLLABLE WOCYPRIOT SYLLABLE XACYPRIOT SYLLABLE XECYPRIOT SY" +
	"LLABLE ZACYPRIOT SYLLABLE ZOIMPERIAL ARAMAIC LETTER ALEPHIMPERIAL ARAMAI" +
	"C LETTER BETHIMPERIAL ARAMAIC LETTER GIMELIMPERIAL ARAMAIC LETTER DALETH" +
	"IMPERIAL ARAMAIC LETTER HEIMPERIAL ARAMAIC LETTER WAWIMPERIAL ARAMAIC LE" +
	"TTER ZAYINIMPERIAL ARAMAIC LETTER HETHIMPERIAL ARAMAIC LETTER TETHIMPERI" +
	"AL ARAMAIC LETTER YODHIMPERIAL ARAMAIC LETTER KAPHIMPERIAL ARAMAIC LETTE" +
	"R LAMEDHIMPERIAL ARAMAIC LETTER MEMIMPERIAL ARAMAIC LETTER NUNIMPERIAL A" +
	"RAMAIC LETTER SAMEKHIMPERIAL ARAMAIC LETTER AYINIMPERIAL ARAMAIC LETTER " +
	"PEIMPERIAL ARAMAIC LETTER SADHEIMPERIAL ARAMAIC LETTER QOPHIMPERIAL ARAM" +
	"AIC LETTER RESHIMPERIAL ARAMAIC LETTER SHINIMPERIAL ARAMAIC LETTER TAWIM" +
	"PERIAL ARAMAIC SECTION SIGNIMPERIAL ARAMAIC NUMBER ONEIMPERIAL ARAMAIC N" +
	"UMBER TWOIMPERIAL ARAMAIC NUMBER THREEIMPERIAL ARAMAIC NUMBER TENIMPERIA" +
	"L ARAMAIC NUMBER TWENTYIMPERIAL ARAMAIC NUMBER ONE HUNDREDIMPERIAL ARAMA" +
	"IC NUMBER ONE THOUSANDIMPERIAL ARAMAIC NUMBER TEN THOUSANDPALMYRENE LETT" +
	"ER ALEPHPALMYRENE LETTER BETHPALMYRENE LETTER GIMELPALMYRENE LETTER DALE" +
	"THPALMYRENE LETTER HEPALMYRENE LETTER WAWPALMYRENE LETTER ZAYINPALMYRENE" +
	" LETTER HETHPALMYRENE LETTER TETHPALMYRENE LETTER YODHPALMYRENE LETTER K" +
	"APHPALMYRENE LETTER LAMEDHPALMYRENE LETTER MEMPALMYRENE LETTER FINAL NUN" +
	"PALMYRENE LETTER NUNPALMYRENE LETTER SAMEKHPALMYRENE LETTER AYINPALMYREN") + ("" +
	"E LETTER PEPALMYRENE LETTER SADHEPALMYRENE LETTER QOPHPALMYRENE LETTER R" +
	"ESHPALMYRENE LETTER SHINPALMYRENE LETTER TAWPALMYRENE LEFT-POINTING FLEU" +
	"RONPALMYRENE RIGHT-POINTING FLEURONPALMYRENE NUMBER ONEPALMYRENE NUMBER " +
	"TWOPALMYRENE NUMBER THREEPALMYRENE NUMBER FOURPALMYRENE NUMBER FIVEPALMY" +
	"RENE NUMBER TENPALMYRENE NUMBER TWENTYNABATAEAN LETTER FINAL ALEPHNABATA" +
	"EAN LETTER ALEPHNABATAEAN LETTER FINAL BETHNABATAEAN LETTER BETHNABATAEA" +
	"N LETTER GIMELNABATAEAN LETTER DALETHNABATAEAN LETTER FINAL HENABATAEAN " +
	"LETTER HENABATAEAN LETTER WAWNABATAEAN LETTER ZAYINNABATAEAN LETTER HETH" +
	"NABATAEAN LETTER TETHNABATAEAN LETTER FINAL YODHNABATAEAN LETTER YODHNAB" +
	"ATAEAN LETTER FINAL KAPHNABATAEAN LETTER KAPHNABATAEAN LETTER FINAL LAME" +
	"DHNABATAEAN LETTER LAMEDHNABATAEAN LETTER FINAL MEMNABATAEAN LETTER MEMN" +
	"ABATAEAN LETTER FINAL NUNNABATAEAN LETTER NUNNABATAEAN LETTER SAMEKHNABA" +
	"TAEAN LETTER AYINNABATAEAN LETTER PENABATAEAN LETTER SADHENABATAEAN LETT" +
	"ER QOPHNABATAEAN LETTER RESHNABATAEAN LETTER FINAL SHINNABATAEAN LETTER " +
	"SHINNABATAEAN LETTER TAWNABATAEAN NUMBER ONENABATAEAN NUMBER TWONABATAEA" +
	"N NUMBER THREENABATAEAN NUMBER FOURNABATAEAN CRUCIFORM NUMBER FOURNABATA" +
	"EAN NUMBER FIVENABATAEAN NUMBER TENNABATAEAN NUMBER TWENTYNABATAEAN NUMB" +
	"ER ONE HUNDREDHATRAN LETTER ALEPHHATRAN LETTER BETHHATRAN LETTER GIMELHA" +
	"TRAN LETTER DALETH-RESHHATRAN LETTER HEHATRAN LETTER WAWHATRAN LETTER ZA" +
	"YNHATRAN LETTER HETHHATRAN LETTER TETHHATRAN LETTER YODHHATRAN LETTER KA" +
	"PHHATRAN LETTER LAMEDHHATRAN LETTER MEMHATRAN LETTER NUNHATRAN LETTER SA" +
	"MEKHHATRAN LETTER AYNHATRAN LETTER PEHATRAN LETTER SADHEHATRAN LETTER QO" +
	"PHHATRAN LETTER SHINHATRAN LETTER TAWHATRAN NUMBER ONEHATRAN NUMBER FIVE" +
	"HATRAN NUMBER TENHATRAN NUMBER TWENTYHATRAN NUMBER ONE HUNDREDPHOENICIAN" +
	" LETTER ALFPHOENICIAN LETTER BETPHOENICIAN LETTER GAMLPHOENICIAN LETTER " +
	"DELTPHOENICIAN LETTER HEPHOENICIAN LETTER WAUPHOENICIAN LETTER ZAIPHOENI" +
	"CIAN LETTER HETPHOENICIAN LETTER TETPHOENICIAN LETTER YODPHOENICIAN LETT" +
	"ER KAFPHOENICIAN LETTER LAMDPHOENICIAN LETTER MEMPHOENICIAN LETTER NUNPH" +
	"OENICIAN LETTER SEMKPHOENICIAN LETTER AINPHOENICIAN LETTER PEPHOENICIAN " +
	"LETTER SADEPHOENICIAN LETTER QOFPHOENICIAN LETTER ROSHPHOENICIAN LETTER " +
	"SHINPHOENICIAN LETTER TAUPHOENICIAN NUMBER ONEPHOENICIAN NUMBER TENPHOEN" +
	"ICIAN NUMBER TWENTYPHOENICIAN NUMBER ONE HUNDREDPHOENICIAN NUMBER TWOPHO" +
	"ENICIAN NUMBER THREEPHOENICIAN WORD SEPARATORLYDIAN LETTER ALYDIAN LETTE" +
	"R BLYDIAN LETTER GLYDIAN LETTER DLYDIAN LETTER ELYDIAN LETTER VLYDIAN LE" +
	"TTER ILYDIAN LETTER YLYDIAN LETTER KLYDIAN LETTER LLYDIAN LETTER MLYDIAN" +
	" LETTER NLYDIAN LETTER OLYDIAN LETTER RLYDIAN LETTER SSLYDIAN LETTER TLY" +
	"DIAN LETTER ULYDIAN LETTER FLYDIAN LETTER QLYDIAN LETTER SLYDIAN LETTER " +
	"TTLYDIAN LETTER ANLYDIAN LETTER ENLYDIAN LETTER LYLYDIAN LETTER NNLYDIAN" +
	" LETTER CLYDIAN TRIANGULAR MARKMEROITIC HIEROGLYPHIC LETTER AMEROITIC HI" +
	"EROGLYPHIC LETTER EMEROITIC HIEROGLYPHIC LETTER IMEROITIC HIEROGLYPHIC L" +
	"ETTER OMEROITIC HIEROGLYPHIC LETTER YAMEROITIC HIEROGLYPHIC LETTER WAMER" +
	"OITIC HIEROGLYPHIC LETTER BAMEROITIC HIEROGLYPHIC LETTER BA-2MEROITIC HI" +
	"EROGLYPHIC LETTER PAMEROITIC HIEROGLYPHIC LETTER MAMEROITIC HIEROGLYPHIC" +
	" LETTER NAMEROITIC HIEROGLYPHIC LETTER NA-2MEROITIC HIEROGLYPHIC LETTER " +
	"NEMEROITIC HIEROGLYPHIC LETTER NE-2MEROITIC HIEROGLYPHIC LETTER RAMEROIT" +
	"IC HIEROGLYPHIC LETTER RA-2MEROITIC HIEROGLYPHIC LETTER LAMEROITIC HIERO" +
	"GLYPHIC LETTER KHAMEROITIC HIEROGLYPHIC LETTER HHAMEROITIC HIEROGLYPHIC " +
	"LETTER SAMEROITIC HIEROGLYPHIC LETTER SA-2MEROITIC HIEROGLYPHIC LETTER S" +
	"EMEROITIC HIEROGLYPHIC LETTER KAMEROITIC HIEROGLYPHIC LETTER QAMEROITIC " +
	"HIEROGLYPHIC LETTER TAMEROITIC HIEROGLYPHIC LETTER TA-2MEROITIC HIEROGLY" +
	"PHIC LETTER TEMEROITIC HIEROGLYPHIC LETTER TE-2MEROITIC HIEROGLYPHIC LET" +
	"TER TOMEROITIC HIEROGLYPHIC LETTER DAMEROITIC HIEROGLYPHIC SYMBOL VIDJME" +
	"ROITIC HIEROGLYPHIC SYMBOL VIDJ-2MEROITIC CURSIVE LETTER AMEROITIC CURSI" +
	"VE LETTER EMEROITIC CURSIVE LETTER IMEROITIC CURSIVE LETTER OMEROITIC CU" +
	"RSIVE LETTER YAMEROITIC CURSIVE LETTER WAMEROITIC CURSIVE LETTER BAMEROI" +
	"TIC CURSIVE LETTER PAMEROITIC CURSIVE LETTER MAMEROITIC CURSIVE LETTER N" +
	"AMEROITIC CURSIVE LETTER NEMEROITIC CURSIVE LETTER RAMEROITIC CURSIVE LE" +
	"TTER LAMEROITIC CURSIVE LETTER KHAMEROITIC CURSIVE LETTER HHAMEROITIC CU" +
	"RSIVE LETTER SAMEROITIC CURSIVE LETTER ARCHAIC SAMEROITIC CURSIVE LETTER" +
	" SEMEROITIC CURSIVE LETTER KAMEROITIC CURSIVE LETTER QAMEROITIC CURSIVE " +
	"LETTER TAMEROITIC CURSIVE LETTER TEMEROITIC CURSIVE LETTER TOMEROITIC CU" +
	"RSIVE LETTER DAMEROITIC CURSIVE FRACTION ELEVEN TWELFTHSMEROITIC CURSIVE" +
	" FRACTION ONE HALFMEROITIC CURSIVE LOGOGRAM RMTMEROITIC CURSIVE LOGOGRAM" +
	" IMNMEROITIC CURSIVE NUMBER ONEMEROITIC CURSIVE NUMBER TWOMEROITIC CURSI") + ("" +
	"VE NUMBER THREEMEROITIC CURSIVE NUMBER FOURMEROITIC CURSIVE NUMBER FIVEM" +
	"EROITIC CURSIVE NUMBER SIXMEROITIC CURSIVE NUMBER SEVENMEROITIC CURSIVE " +
	"NUMBER EIGHTMEROITIC CURSIVE NUMBER NINEMEROITIC CURSIVE NUMBER TENMEROI" +
	"TIC CURSIVE NUMBER TWENTYMEROITIC CURSIVE NUMBER THIRTYMEROITIC CURSIVE " +
	"NUMBER FORTYMEROITIC CURSIVE NUMBER FIFTYMEROITIC CURSIVE NUMBER SIXTYME" +
	"ROITIC CURSIVE NUMBER SEVENTYMEROITIC CURSIVE NUMBER ONE HUNDREDMEROITIC" +
	" CURSIVE NUMBER TWO HUNDREDMEROITIC CURSIVE NUMBER THREE HUNDREDMEROITIC" +
	" CURSIVE NUMBER FOUR HUNDREDMEROITIC CURSIVE NUMBER FIVE HUNDREDMEROITIC" +
	" CURSIVE NUMBER SIX HUNDREDMEROITIC CURSIVE NUMBER SEVEN HUNDREDMEROITIC" +
	" CURSIVE NUMBER EIGHT HUNDREDMEROITIC CURSIVE NUMBER NINE HUNDREDMEROITI" +
	"C CURSIVE NUMBER ONE THOUSANDMEROITIC CURSIVE NUMBER TWO THOUSANDMEROITI" +
	"C CURSIVE NUMBER THREE THOUSANDMEROITIC CURSIVE NUMBER FOUR THOUSANDMERO" +
	"ITIC CURSIVE NUMBER FIVE THOUSANDMEROITIC CURSIVE NUMBER SIX THOUSANDMER" +
	"OITIC CURSIVE NUMBER SEVEN THOUSANDMEROITIC CURSIVE NUMBER EIGHT THOUSAN" +
	"DMEROITIC CURSIVE NUMBER NINE THOUSANDMEROITIC CURSIVE NUMBER TEN THOUSA" +
	"NDMEROITIC CURSIVE NUMBER TWENTY THOUSANDMEROITIC CURSIVE NUMBER THIRTY " +
	"THOUSANDMEROITIC CURSIVE NUMBER FORTY THOUSANDMEROITIC CURSIVE NUMBER FI" +
	"FTY THOUSANDMEROITIC CURSIVE NUMBER SIXTY THOUSANDMEROITIC CURSIVE NUMBE" +
	"R SEVENTY THOUSANDMEROITIC CURSIVE NUMBER EIGHTY THOUSANDMEROITIC CURSIV" +
	"E NUMBER NINETY THOUSANDMEROITIC CURSIVE NUMBER ONE HUNDRED THOUSANDMERO" +
	"ITIC CURSIVE NUMBER TWO HUNDRED THOUSANDMEROITIC CURSIVE NUMBER THREE HU" +
	"NDRED THOUSANDMEROITIC CURSIVE NUMBER FOUR HUNDRED THOUSANDMEROITIC CURS" +
	"IVE NUMBER FIVE HUNDRED THOUSANDMEROITIC CURSIVE NUMBER SIX HUNDRED THOU" +
	"SANDMEROITIC CURSIVE NUMBER SEVEN HUNDRED THOUSANDMEROITIC CURSIVE NUMBE" +
	"R EIGHT HUNDRED THOUSANDMEROITIC CURSIVE NUMBER NINE HUNDRED THOUSANDMER" +
	"OITIC CURSIVE FRACTION ONE TWELFTHMEROITIC CURSIVE FRACTION TWO TWELFTHS" +
	"MEROITIC CURSIVE FRACTION THREE TWELFTHSMEROITIC CURSIVE FRACTION FOUR T" +
	"WELFTHSMEROITIC CURSIVE FRACTION FIVE TWELFTHSMEROITIC CURSIVE FRACTION " +
	"SIX TWELFTHSMEROITIC CURSIVE FRACTION SEVEN TWELFTHSMEROITIC CURSIVE FRA" +
	"CTION EIGHT TWELFTHSMEROITIC CURSIVE FRACTION NINE TWELFTHSMEROITIC CURS" +
	"IVE FRACTION TEN TWELFTHSKHAROSHTHI LETTER AKHAROSHTHI VOWEL SIGN IKHARO" +
	"SHTHI VOWEL SIGN UKHAROSHTHI VOWEL SIGN VOCALIC RKHAROSHTHI VOWEL SIGN E" +
	"KHAROSHTHI VOWEL SIGN OKHAROSHTHI VOWEL LENGTH MARKKHAROSHTHI SIGN DOUBL" +
	"E RING BELOWKHAROSHTHI SIGN ANUSVARAKHAROSHTHI SIGN VISARGAKHAROSHTHI LE" +
	"TTER KAKHAROSHTHI LETTER KHAKHAROSHTHI LETTER GAKHAROSHTHI LETTER GHAKHA" +
	"ROSHTHI LETTER CAKHAROSHTHI LETTER CHAKHAROSHTHI LETTER JAKHAROSHTHI LET" +
	"TER NYAKHAROSHTHI LETTER TTAKHAROSHTHI LETTER TTHAKHAROSHTHI LETTER DDAK" +
	"HAROSHTHI LETTER DDHAKHAROSHTHI LETTER NNAKHAROSHTHI LETTER TAKHAROSHTHI" +
	" LETTER THAKHAROSHTHI LETTER DAKHAROSHTHI LETTER DHAKHAROSHTHI LETTER NA" +
	"KHAROSHTHI LETTER PAKHAROSHTHI LETTER PHAKHAROSHTHI LETTER BAKHAROSHTHI " +
	"LETTER BHAKHAROSHTHI LETTER MAKHAROSHTHI LETTER YAKHAROSHTHI LETTER RAKH" +
	"AROSHTHI LETTER LAKHAROSHTHI LETTER VAKHAROSHTHI LETTER SHAKHAROSHTHI LE" +
	"TTER SSAKHAROSHTHI LETTER SAKHAROSHTHI LETTER ZAKHAROSHTHI LETTER HAKHAR" +
	"OSHTHI LETTER KKAKHAROSHTHI LETTER TTTHAKHAROSHTHI LETTER TTTAKHAROSHTHI" +
	" LETTER VHAKHAROSHTHI SIGN BAR ABOVEKHAROSHTHI SIGN CAUDAKHAROSHTHI SIGN" +
	" DOT BELOWKHAROSHTHI VIRAMAKHAROSHTHI DIGIT ONEKHAROSHTHI DIGIT TWOKHARO" +
	"SHTHI DIGIT THREEKHAROSHTHI DIGIT FOURKHAROSHTHI NUMBER TENKHAROSHTHI NU" +
	"MBER TWENTYKHAROSHTHI NUMBER ONE HUNDREDKHAROSHTHI NUMBER ONE THOUSANDKH" +
	"AROSHTHI FRACTION ONE HALFKHAROSHTHI PUNCTUATION DOTKHAROSHTHI PUNCTUATI" +
	"ON SMALL CIRCLEKHAROSHTHI PUNCTUATION CIRCLEKHAROSHTHI PUNCTUATION CRESC" +
	"ENT BARKHAROSHTHI PUNCTUATION MANGALAMKHAROSHTHI PUNCTUATION LOTUSKHAROS" +
	"HTHI PUNCTUATION DANDAKHAROSHTHI PUNCTUATION DOUBLE DANDAKHAROSHTHI PUNC" +
	"TUATION LINESOLD SOUTH ARABIAN LETTER HEOLD SOUTH ARABIAN LETTER LAMEDHO" +
	"LD SOUTH ARABIAN LETTER HETHOLD SOUTH ARABIAN LETTER MEMOLD SOUTH ARABIA" +
	"N LETTER QOPHOLD SOUTH ARABIAN LETTER WAWOLD SOUTH ARABIAN LETTER SHINOL" +
	"D SOUTH ARABIAN LETTER RESHOLD SOUTH ARABIAN LETTER BETHOLD SOUTH ARABIA" +
	"N LETTER TAWOLD SOUTH ARABIAN LETTER SATOLD SOUTH ARABIAN LETTER KAPHOLD" +
	" SOUTH ARABIAN LETTER NUNOLD SOUTH ARABIAN LETTER KHETHOLD SOUTH ARABIAN" +
	" LETTER SADHEOLD SOUTH ARABIAN LETTER SAMEKHOLD SOUTH ARABIAN LETTER FEO" +
	"LD SOUTH ARABIAN LETTER ALEFOLD SOUTH ARABIAN LETTER AYNOLD SOUTH ARABIA" +
	"N LETTER DHADHEOLD SOUTH ARABIAN LETTER GIMELOLD SOUTH ARABIAN LETTER DA" +
	"LETHOLD SOUTH ARABIAN LETTER GHAYNOLD SOUTH ARABIAN LETTER TETHOLD SOUTH" +
	" ARABIAN LETTER ZAYNOLD SOUTH ARABIAN LETTER DHALETHOLD SOUTH ARABIAN LE" +
	"TTER YODHOLD SOUTH ARABIAN LETTER THAWOLD SOUTH ARABIAN LETTER THETHOLD ") + ("" +
	"SOUTH ARABIAN NUMBER ONEOLD SOUTH ARABIAN NUMBER FIFTYOLD SOUTH ARABIAN " +
	"NUMERIC INDICATOROLD NORTH ARABIAN LETTER HEHOLD NORTH ARABIAN LETTER LA" +
	"MOLD NORTH ARABIAN LETTER HAHOLD NORTH ARABIAN LETTER MEEMOLD NORTH ARAB" +
	"IAN LETTER QAFOLD NORTH ARABIAN LETTER WAWOLD NORTH ARABIAN LETTER ES-2O" +
	"LD NORTH ARABIAN LETTER REHOLD NORTH ARABIAN LETTER BEHOLD NORTH ARABIAN" +
	" LETTER TEHOLD NORTH ARABIAN LETTER ES-1OLD NORTH ARABIAN LETTER KAFOLD " +
	"NORTH ARABIAN LETTER NOONOLD NORTH ARABIAN LETTER KHAHOLD NORTH ARABIAN " +
	"LETTER SADOLD NORTH ARABIAN LETTER ES-3OLD NORTH ARABIAN LETTER FEHOLD N" +
	"ORTH ARABIAN LETTER ALEFOLD NORTH ARABIAN LETTER AINOLD NORTH ARABIAN LE" +
	"TTER DADOLD NORTH ARABIAN LETTER GEEMOLD NORTH ARABIAN LETTER DALOLD NOR" +
	"TH ARABIAN LETTER GHAINOLD NORTH ARABIAN LETTER TAHOLD NORTH ARABIAN LET" +
	"TER ZAINOLD NORTH ARABIAN LETTER THALOLD NORTH ARABIAN LETTER YEHOLD NOR" +
	"TH ARABIAN LETTER THEHOLD NORTH ARABIAN LETTER ZAHOLD NORTH ARABIAN NUMB" +
	"ER ONEOLD NORTH ARABIAN NUMBER TENOLD NORTH ARABIAN NUMBER TWENTYMANICHA" +
	"EAN LETTER ALEPHMANICHAEAN LETTER BETHMANICHAEAN LETTER BHETHMANICHAEAN " +
	"LETTER GIMELMANICHAEAN LETTER GHIMELMANICHAEAN LETTER DALETHMANICHAEAN L" +
	"ETTER HEMANICHAEAN LETTER WAWMANICHAEAN SIGN UDMANICHAEAN LETTER ZAYINMA" +
	"NICHAEAN LETTER ZHAYINMANICHAEAN LETTER JAYINMANICHAEAN LETTER JHAYINMAN" +
	"ICHAEAN LETTER HETHMANICHAEAN LETTER TETHMANICHAEAN LETTER YODHMANICHAEA" +
	"N LETTER KAPHMANICHAEAN LETTER XAPHMANICHAEAN LETTER KHAPHMANICHAEAN LET" +
	"TER LAMEDHMANICHAEAN LETTER DHAMEDHMANICHAEAN LETTER THAMEDHMANICHAEAN L" +
	"ETTER MEMMANICHAEAN LETTER NUNMANICHAEAN LETTER SAMEKHMANICHAEAN LETTER " +
	"AYINMANICHAEAN LETTER AAYINMANICHAEAN LETTER PEMANICHAEAN LETTER FEMANIC" +
	"HAEAN LETTER SADHEMANICHAEAN LETTER QOPHMANICHAEAN LETTER XOPHMANICHAEAN" +
	" LETTER QHOPHMANICHAEAN LETTER RESHMANICHAEAN LETTER SHINMANICHAEAN LETT" +
	"ER SSHINMANICHAEAN LETTER TAWMANICHAEAN ABBREVIATION MARK ABOVEMANICHAEA" +
	"N ABBREVIATION MARK BELOWMANICHAEAN NUMBER ONEMANICHAEAN NUMBER FIVEMANI" +
	"CHAEAN NUMBER TENMANICHAEAN NUMBER TWENTYMANICHAEAN NUMBER ONE HUNDREDMA" +
	"NICHAEAN PUNCTUATION STARMANICHAEAN PUNCTUATION FLEURONMANICHAEAN PUNCTU" +
	"ATION DOUBLE DOT WITHIN DOTMANICHAEAN PUNCTUATION DOT WITHIN DOTMANICHAE" +
	"AN PUNCTUATION DOTMANICHAEAN PUNCTUATION TWO DOTSMANICHAEAN PUNCTUATION " +
	"LINE FILLERAVESTAN LETTER AAVESTAN LETTER AAAVESTAN LETTER AOAVESTAN LET" +
	"TER AAOAVESTAN LETTER ANAVESTAN LETTER AANAVESTAN LETTER AEAVESTAN LETTE" +
	"R AEEAVESTAN LETTER EAVESTAN LETTER EEAVESTAN LETTER OAVESTAN LETTER OOA" +
	"VESTAN LETTER IAVESTAN LETTER IIAVESTAN LETTER UAVESTAN LETTER UUAVESTAN" +
	" LETTER KEAVESTAN LETTER XEAVESTAN LETTER XYEAVESTAN LETTER XVEAVESTAN L" +
	"ETTER GEAVESTAN LETTER GGEAVESTAN LETTER GHEAVESTAN LETTER CEAVESTAN LET" +
	"TER JEAVESTAN LETTER TEAVESTAN LETTER THEAVESTAN LETTER DEAVESTAN LETTER" +
	" DHEAVESTAN LETTER TTEAVESTAN LETTER PEAVESTAN LETTER FEAVESTAN LETTER B" +
	"EAVESTAN LETTER BHEAVESTAN LETTER NGEAVESTAN LETTER NGYEAVESTAN LETTER N" +
	"GVEAVESTAN LETTER NEAVESTAN LETTER NYEAVESTAN LETTER NNEAVESTAN LETTER M" +
	"EAVESTAN LETTER HMEAVESTAN LETTER YYEAVESTAN LETTER YEAVESTAN LETTER VEA" +
	"VESTAN LETTER REAVESTAN LETTER LEAVESTAN LETTER SEAVESTAN LETTER ZEAVEST" +
	"AN LETTER SHEAVESTAN LETTER ZHEAVESTAN LETTER SHYEAVESTAN LETTER SSHEAVE" +
	"STAN LETTER HEAVESTAN ABBREVIATION MARKTINY TWO DOTS OVER ONE DOT PUNCTU" +
	"ATIONSMALL TWO DOTS OVER ONE DOT PUNCTUATIONLARGE TWO DOTS OVER ONE DOT " +
	"PUNCTUATIONLARGE ONE DOT OVER TWO DOTS PUNCTUATIONLARGE TWO RINGS OVER O" +
	"NE RING PUNCTUATIONLARGE ONE RING OVER TWO RINGS PUNCTUATIONINSCRIPTIONA" +
	"L PARTHIAN LETTER ALEPHINSCRIPTIONAL PARTHIAN LETTER BETHINSCRIPTIONAL P" +
	"ARTHIAN LETTER GIMELINSCRIPTIONAL PARTHIAN LETTER DALETHINSCRIPTIONAL PA" +
	"RTHIAN LETTER HEINSCRIPTIONAL PARTHIAN LETTER WAWINSCRIPTIONAL PARTHIAN " +
	"LETTER ZAYININSCRIPTIONAL PARTHIAN LETTER HETHINSCRIPTIONAL PARTHIAN LET" +
	"TER TETHINSCRIPTIONAL PARTHIAN LETTER YODHINSCRIPTIONAL PARTHIAN LETTER " +
	"KAPHINSCRIPTIONAL PARTHIAN LETTER LAMEDHINSCRIPTIONAL PARTHIAN LETTER ME" +
	"MINSCRIPTIONAL PARTHIAN LETTER NUNINSCRIPTIONAL PARTHIAN LETTER SAMEKHIN" +
	"SCRIPTIONAL PARTHIAN LETTER AYININSCRIPTIONAL PARTHIAN LETTER PEINSCRIPT" +
	"IONAL PARTHIAN LETTER SADHEINSCRIPTIONAL PARTHIAN LETTER QOPHINSCRIPTION" +
	"AL PARTHIAN LETTER RESHINSCRIPTIONAL PARTHIAN LETTER SHININSCRIPTIONAL P" +
	"ARTHIAN LETTER TAWINSCRIPTIONAL PARTHIAN NUMBER ONEINSCRIPTIONAL PARTHIA" +
	"N NUMBER TWOINSCRIPTIONAL PARTHIAN NUMBER THREEINSCRIPTIONAL PARTHIAN NU" +
	"MBER FOURINSCRIPTIONAL PARTHIAN NUMBER TENINSCRIPTIONAL PARTHIAN NUMBER " +
	"TWENTYINSCRIPTIONAL PARTHIAN NUMBER ONE HUNDREDINSCRIPTIONAL PARTHIAN NU" +
	"MBER ONE THOUSANDINSCRIPTIONAL PAHLAVI LETTER ALEPHINSCRIPTIONAL PAHLAVI" +
	" LETTER BETHINSCRIPTIONAL PAHLAVI LETTER GIMELINSCRIPTIONAL PAHLAVI LETT") + ("" +
	"ER DALETHINSCRIPTIONAL PAHLAVI LETTER HEINSCRIPTIONAL PAHLAVI LETTER WAW" +
	"-AYIN-RESHINSCRIPTIONAL PAHLAVI LETTER ZAYININSCRIPTIONAL PAHLAVI LETTER" +
	" HETHINSCRIPTIONAL PAHLAVI LETTER TETHINSCRIPTIONAL PAHLAVI LETTER YODHI" +
	"NSCRIPTIONAL PAHLAVI LETTER KAPHINSCRIPTIONAL PAHLAVI LETTER LAMEDHINSCR" +
	"IPTIONAL PAHLAVI LETTER MEM-QOPHINSCRIPTIONAL PAHLAVI LETTER NUNINSCRIPT" +
	"IONAL PAHLAVI LETTER SAMEKHINSCRIPTIONAL PAHLAVI LETTER PEINSCRIPTIONAL " +
	"PAHLAVI LETTER SADHEINSCRIPTIONAL PAHLAVI LETTER SHININSCRIPTIONAL PAHLA" +
	"VI LETTER TAWINSCRIPTIONAL PAHLAVI NUMBER ONEINSCRIPTIONAL PAHLAVI NUMBE" +
	"R TWOINSCRIPTIONAL PAHLAVI NUMBER THREEINSCRIPTIONAL PAHLAVI NUMBER FOUR" +
	"INSCRIPTIONAL PAHLAVI NUMBER TENINSCRIPTIONAL PAHLAVI NUMBER TWENTYINSCR" +
	"IPTIONAL PAHLAVI NUMBER ONE HUNDREDINSCRIPTIONAL PAHLAVI NUMBER ONE THOU" +
	"SANDPSALTER PAHLAVI LETTER ALEPHPSALTER PAHLAVI LETTER BETHPSALTER PAHLA" +
	"VI LETTER GIMELPSALTER PAHLAVI LETTER DALETHPSALTER PAHLAVI LETTER HEPSA" +
	"LTER PAHLAVI LETTER WAW-AYIN-RESHPSALTER PAHLAVI LETTER ZAYINPSALTER PAH" +
	"LAVI LETTER HETHPSALTER PAHLAVI LETTER YODHPSALTER PAHLAVI LETTER KAPHPS" +
	"ALTER PAHLAVI LETTER LAMEDHPSALTER PAHLAVI LETTER MEM-QOPHPSALTER PAHLAV" +
	"I LETTER NUNPSALTER PAHLAVI LETTER SAMEKHPSALTER PAHLAVI LETTER PEPSALTE" +
	"R PAHLAVI LETTER SADHEPSALTER PAHLAVI LETTER SHINPSALTER PAHLAVI LETTER " +
	"TAWPSALTER PAHLAVI SECTION MARKPSALTER PAHLAVI TURNED SECTION MARKPSALTE" +
	"R PAHLAVI FOUR DOTS WITH CROSSPSALTER PAHLAVI FOUR DOTS WITH DOTPSALTER " +
	"PAHLAVI NUMBER ONEPSALTER PAHLAVI NUMBER TWOPSALTER PAHLAVI NUMBER THREE" +
	"PSALTER PAHLAVI NUMBER FOURPSALTER PAHLAVI NUMBER TENPSALTER PAHLAVI NUM" +
	"BER TWENTYPSALTER PAHLAVI NUMBER ONE HUNDREDOLD TURKIC LETTER ORKHON AOL" +
	"D TURKIC LETTER YENISEI AOLD TURKIC LETTER YENISEI AEOLD TURKIC LETTER O" +
	"RKHON IOLD TURKIC LETTER YENISEI IOLD TURKIC LETTER YENISEI EOLD TURKIC " +
	"LETTER ORKHON OOLD TURKIC LETTER ORKHON OEOLD TURKIC LETTER YENISEI OEOL" +
	"D TURKIC LETTER ORKHON ABOLD TURKIC LETTER YENISEI ABOLD TURKIC LETTER O" +
	"RKHON AEBOLD TURKIC LETTER YENISEI AEBOLD TURKIC LETTER ORKHON AGOLD TUR" +
	"KIC LETTER YENISEI AGOLD TURKIC LETTER ORKHON AEGOLD TURKIC LETTER YENIS" +
	"EI AEGOLD TURKIC LETTER ORKHON ADOLD TURKIC LETTER YENISEI ADOLD TURKIC " +
	"LETTER ORKHON AEDOLD TURKIC LETTER ORKHON EZOLD TURKIC LETTER YENISEI EZ" +
	"OLD TURKIC LETTER ORKHON AYOLD TURKIC LETTER YENISEI AYOLD TURKIC LETTER" +
	" ORKHON AEYOLD TURKIC LETTER YENISEI AEYOLD TURKIC LETTER ORKHON AEKOLD " +
	"TURKIC LETTER YENISEI AEKOLD TURKIC LETTER ORKHON OEKOLD TURKIC LETTER Y" +
	"ENISEI OEKOLD TURKIC LETTER ORKHON ALOLD TURKIC LETTER YENISEI ALOLD TUR" +
	"KIC LETTER ORKHON AELOLD TURKIC LETTER ORKHON ELTOLD TURKIC LETTER ORKHO" +
	"N EMOLD TURKIC LETTER ORKHON ANOLD TURKIC LETTER ORKHON AENOLD TURKIC LE" +
	"TTER YENISEI AENOLD TURKIC LETTER ORKHON ENTOLD TURKIC LETTER YENISEI EN" +
	"TOLD TURKIC LETTER ORKHON ENCOLD TURKIC LETTER YENISEI ENCOLD TURKIC LET" +
	"TER ORKHON ENYOLD TURKIC LETTER YENISEI ENYOLD TURKIC LETTER YENISEI ANG" +
	"OLD TURKIC LETTER ORKHON ENGOLD TURKIC LETTER YENISEI AENGOLD TURKIC LET" +
	"TER ORKHON EPOLD TURKIC LETTER ORKHON OPOLD TURKIC LETTER ORKHON ICOLD T" +
	"URKIC LETTER ORKHON ECOLD TURKIC LETTER YENISEI ECOLD TURKIC LETTER ORKH" +
	"ON AQOLD TURKIC LETTER YENISEI AQOLD TURKIC LETTER ORKHON IQOLD TURKIC L" +
	"ETTER YENISEI IQOLD TURKIC LETTER ORKHON OQOLD TURKIC LETTER YENISEI OQO" +
	"LD TURKIC LETTER ORKHON AROLD TURKIC LETTER YENISEI AROLD TURKIC LETTER " +
	"ORKHON AEROLD TURKIC LETTER ORKHON ASOLD TURKIC LETTER ORKHON AESOLD TUR" +
	"KIC LETTER ORKHON ASHOLD TURKIC LETTER YENISEI ASHOLD TURKIC LETTER ORKH" +
	"ON ESHOLD TURKIC LETTER YENISEI ESHOLD TURKIC LETTER ORKHON ATOLD TURKIC" +
	" LETTER YENISEI ATOLD TURKIC LETTER ORKHON AETOLD TURKIC LETTER YENISEI " +
	"AETOLD TURKIC LETTER ORKHON OTOLD TURKIC LETTER ORKHON BASHOLD HUNGARIAN" +
	" CAPITAL LETTER AOLD HUNGARIAN CAPITAL LETTER AAOLD HUNGARIAN CAPITAL LE" +
	"TTER EBOLD HUNGARIAN CAPITAL LETTER AMBOLD HUNGARIAN CAPITAL LETTER ECOL" +
	"D HUNGARIAN CAPITAL LETTER ENCOLD HUNGARIAN CAPITAL LETTER ECSOLD HUNGAR" +
	"IAN CAPITAL LETTER EDOLD HUNGARIAN CAPITAL LETTER ANDOLD HUNGARIAN CAPIT" +
	"AL LETTER EOLD HUNGARIAN CAPITAL LETTER CLOSE EOLD HUNGARIAN CAPITAL LET" +
	"TER EEOLD HUNGARIAN CAPITAL LETTER EFOLD HUNGARIAN CAPITAL LETTER EGOLD " +
	"HUNGARIAN CAPITAL LETTER EGYOLD HUNGARIAN CAPITAL LETTER EHOLD HUNGARIAN" +
	" CAPITAL LETTER IOLD HUNGARIAN CAPITAL LETTER IIOLD HUNGARIAN CAPITAL LE" +
	"TTER EJOLD HUNGARIAN CAPITAL LETTER EKOLD HUNGARIAN CAPITAL LETTER AKOLD" +
	" HUNGARIAN CAPITAL LETTER UNKOLD HUNGARIAN CAPITAL LETTER ELOLD HUNGARIA" +
	"N CAPITAL LETTER ELYOLD HUNGARIAN CAPITAL LETTER EMOLD HUNGARIAN CAPITAL" +
	" LETTER ENOLD HUNGARIAN CAPITAL LETTER ENYOLD HUNGARIAN CAPITAL LETTER O" +
	"OLD HUNGARIAN CAPITAL LETTER OOOLD HUNGARIAN CAPITAL LETTER NIKOLSBURG O") + ("" +
	"EOLD HUNGARIAN CAPITAL LETTER RUDIMENTA OEOLD HUNGARIAN CAPITAL LETTER O" +
	"EEOLD HUNGARIAN CAPITAL LETTER EPOLD HUNGARIAN CAPITAL LETTER EMPOLD HUN" +
	"GARIAN CAPITAL LETTER EROLD HUNGARIAN CAPITAL LETTER SHORT EROLD HUNGARI" +
	"AN CAPITAL LETTER ESOLD HUNGARIAN CAPITAL LETTER ESZOLD HUNGARIAN CAPITA" +
	"L LETTER ETOLD HUNGARIAN CAPITAL LETTER ENTOLD HUNGARIAN CAPITAL LETTER " +
	"ETYOLD HUNGARIAN CAPITAL LETTER ECHOLD HUNGARIAN CAPITAL LETTER UOLD HUN" +
	"GARIAN CAPITAL LETTER UUOLD HUNGARIAN CAPITAL LETTER NIKOLSBURG UEOLD HU" +
	"NGARIAN CAPITAL LETTER RUDIMENTA UEOLD HUNGARIAN CAPITAL LETTER EVOLD HU" +
	"NGARIAN CAPITAL LETTER EZOLD HUNGARIAN CAPITAL LETTER EZSOLD HUNGARIAN C" +
	"APITAL LETTER ENT-SHAPED SIGNOLD HUNGARIAN CAPITAL LETTER USOLD HUNGARIA" +
	"N SMALL LETTER AOLD HUNGARIAN SMALL LETTER AAOLD HUNGARIAN SMALL LETTER " +
	"EBOLD HUNGARIAN SMALL LETTER AMBOLD HUNGARIAN SMALL LETTER ECOLD HUNGARI" +
	"AN SMALL LETTER ENCOLD HUNGARIAN SMALL LETTER ECSOLD HUNGARIAN SMALL LET" +
	"TER EDOLD HUNGARIAN SMALL LETTER ANDOLD HUNGARIAN SMALL LETTER EOLD HUNG" +
	"ARIAN SMALL LETTER CLOSE EOLD HUNGARIAN SMALL LETTER EEOLD HUNGARIAN SMA" +
	"LL LETTER EFOLD HUNGARIAN SMALL LETTER EGOLD HUNGARIAN SMALL LETTER EGYO" +
	"LD HUNGARIAN SMALL LETTER EHOLD HUNGARIAN SMALL LETTER IOLD HUNGARIAN SM" +
	"ALL LETTER IIOLD HUNGARIAN SMALL LETTER EJOLD HUNGARIAN SMALL LETTER EKO" +
	"LD HUNGARIAN SMALL LETTER AKOLD HUNGARIAN SMALL LETTER UNKOLD HUNGARIAN " +
	"SMALL LETTER ELOLD HUNGARIAN SMALL LETTER ELYOLD HUNGARIAN SMALL LETTER " +
	"EMOLD HUNGARIAN SMALL LETTER ENOLD HUNGARIAN SMALL LETTER ENYOLD HUNGARI" +
	"AN SMALL LETTER OOLD HUNGARIAN SMALL LETTER OOOLD HUNGARIAN SMALL LETTER" +
	" NIKOLSBURG OEOLD HUNGARIAN SMALL LETTER RUDIMENTA OEOLD HUNGARIAN SMALL" +
	" LETTER OEEOLD HUNGARIAN SMALL LETTER EPOLD HUNGARIAN SMALL LETTER EMPOL" +
	"D HUNGARIAN SMALL LETTER EROLD HUNGARIAN SMALL LETTER SHORT EROLD HUNGAR" +
	"IAN SMALL LETTER ESOLD HUNGARIAN SMALL LETTER ESZOLD HUNGARIAN SMALL LET" +
	"TER ETOLD HUNGARIAN SMALL LETTER ENTOLD HUNGARIAN SMALL LETTER ETYOLD HU" +
	"NGARIAN SMALL LETTER ECHOLD HUNGARIAN SMALL LETTER UOLD HUNGARIAN SMALL " +
	"LETTER UUOLD HUNGARIAN SMALL LETTER NIKOLSBURG UEOLD HUNGARIAN SMALL LET" +
	"TER RUDIMENTA UEOLD HUNGARIAN SMALL LETTER EVOLD HUNGARIAN SMALL LETTER " +
	"EZOLD HUNGARIAN SMALL LETTER EZSOLD HUNGARIAN SMALL LETTER ENT-SHAPED SI" +
	"GNOLD HUNGARIAN SMALL LETTER USOLD HUNGARIAN NUMBER ONEOLD HUNGARIAN NUM" +
	"BER FIVEOLD HUNGARIAN NUMBER TENOLD HUNGARIAN NUMBER FIFTYOLD HUNGARIAN " +
	"NUMBER ONE HUNDREDOLD HUNGARIAN NUMBER ONE THOUSANDHANIFI ROHINGYA LETTE" +
	"R AHANIFI ROHINGYA LETTER BAHANIFI ROHINGYA LETTER PAHANIFI ROHINGYA LET" +
	"TER TAHANIFI ROHINGYA LETTER TTAHANIFI ROHINGYA LETTER JAHANIFI ROHINGYA" +
	" LETTER CAHANIFI ROHINGYA LETTER HAHANIFI ROHINGYA LETTER KHAHANIFI ROHI" +
	"NGYA LETTER FAHANIFI ROHINGYA LETTER DAHANIFI ROHINGYA LETTER DDAHANIFI " +
	"ROHINGYA LETTER RAHANIFI ROHINGYA LETTER RRAHANIFI ROHINGYA LETTER ZAHAN" +
	"IFI ROHINGYA LETTER SAHANIFI ROHINGYA LETTER SHAHANIFI ROHINGYA LETTER K" +
	"AHANIFI ROHINGYA LETTER GAHANIFI ROHINGYA LETTER LAHANIFI ROHINGYA LETTE" +
	"R MAHANIFI ROHINGYA LETTER NAHANIFI ROHINGYA LETTER WAHANIFI ROHINGYA LE" +
	"TTER KINNA WAHANIFI ROHINGYA LETTER YAHANIFI ROHINGYA LETTER KINNA YAHAN" +
	"IFI ROHINGYA LETTER NGAHANIFI ROHINGYA LETTER NYAHANIFI ROHINGYA LETTER " +
	"VAHANIFI ROHINGYA VOWEL AHANIFI ROHINGYA VOWEL IHANIFI ROHINGYA VOWEL UH" +
	"ANIFI ROHINGYA VOWEL EHANIFI ROHINGYA VOWEL OHANIFI ROHINGYA MARK SAKINH" +
	"ANIFI ROHINGYA MARK NA KHONNAHANIFI ROHINGYA SIGN HARBAHAYHANIFI ROHINGY" +
	"A SIGN TAHALAHANIFI ROHINGYA SIGN TANAHANIFI ROHINGYA SIGN TASSIHANIFI R" +
	"OHINGYA DIGIT ZEROHANIFI ROHINGYA DIGIT ONEHANIFI ROHINGYA DIGIT TWOHANI" +
	"FI ROHINGYA DIGIT THREEHANIFI ROHINGYA DIGIT FOURHANIFI ROHINGYA DIGIT F" +
	"IVEHANIFI ROHINGYA DIGIT SIXHANIFI ROHINGYA DIGIT SEVENHANIFI ROHINGYA D" +
	"IGIT EIGHTHANIFI ROHINGYA DIGIT NINERUMI DIGIT ONERUMI DIGIT TWORUMI DIG" +
	"IT THREERUMI DIGIT FOURRUMI DIGIT FIVERUMI DIGIT SIXRUMI DIGIT SEVENRUMI" +
	" DIGIT EIGHTRUMI DIGIT NINERUMI NUMBER TENRUMI NUMBER TWENTYRUMI NUMBER " +
	"THIRTYRUMI NUMBER FORTYRUMI NUMBER FIFTYRUMI NUMBER SIXTYRUMI NUMBER SEV" +
	"ENTYRUMI NUMBER EIGHTYRUMI NUMBER NINETYRUMI NUMBER ONE HUNDREDRUMI NUMB" +
	"ER TWO HUNDREDRUMI NUMBER THREE HUNDREDRUMI NUMBER FOUR HUNDREDRUMI NUMB" +
	"ER FIVE HUNDREDRUMI NUMBER SIX HUNDREDRUMI NUMBER SEVEN HUNDREDRUMI NUMB" +
	"ER EIGHT HUNDREDRUMI NUMBER NINE HUNDREDRUMI FRACTION ONE HALFRUMI FRACT" +
	"ION ONE QUARTERRUMI FRACTION ONE THIRDRUMI FRACTION TWO THIRDSYEZIDI LET" +
	"TER ELIFYEZIDI LETTER BEYEZIDI LETTER PEYEZIDI LETTER PHEYEZIDI LETTER T" +
	"HEYEZIDI LETTER SEYEZIDI LETTER CIMYEZIDI LETTER CHIMYEZIDI LETTER CHHIM" +
	"YEZIDI LETTER HHAYEZIDI LETTER XAYEZIDI LETTER DALYEZIDI LETTER ZALYEZID" +
	"I LETTER RAYEZIDI LETTER RHAYEZIDI LETTER ZAYEZIDI LETTER JAYEZIDI LETTE") + ("" +
	"R SINYEZIDI LETTER SHINYEZIDI LETTER SADYEZIDI LETTER DADYEZIDI LETTER T" +
	"AYEZIDI LETTER ZEYEZIDI LETTER EYNYEZIDI LETTER XHEYNYEZIDI LETTER FAYEZ" +
	"IDI LETTER VAYEZIDI LETTER VA ALTERNATE FORMYEZIDI LETTER QAFYEZIDI LETT" +
	"ER KAFYEZIDI LETTER KHAFYEZIDI LETTER GAFYEZIDI LETTER LAMYEZIDI LETTER " +
	"MIMYEZIDI LETTER NUNYEZIDI LETTER UMYEZIDI LETTER WAWYEZIDI LETTER OWYEZ" +
	"IDI LETTER EWYEZIDI LETTER HAYYEZIDI LETTER YOTYEZIDI LETTER ETYEZIDI CO" +
	"MBINING HAMZA MARKYEZIDI COMBINING MADDA MARKYEZIDI HYPHENATION MARKYEZI" +
	"DI LETTER LAM WITH DOT ABOVEYEZIDI LETTER YOT WITH CIRCUMFLEX ABOVEOLD S" +
	"OGDIAN LETTER ALEPHOLD SOGDIAN LETTER FINAL ALEPHOLD SOGDIAN LETTER BETH" +
	"OLD SOGDIAN LETTER FINAL BETHOLD SOGDIAN LETTER GIMELOLD SOGDIAN LETTER " +
	"HEOLD SOGDIAN LETTER FINAL HEOLD SOGDIAN LETTER WAWOLD SOGDIAN LETTER ZA" +
	"YINOLD SOGDIAN LETTER HETHOLD SOGDIAN LETTER YODHOLD SOGDIAN LETTER KAPH" +
	"OLD SOGDIAN LETTER LAMEDHOLD SOGDIAN LETTER MEMOLD SOGDIAN LETTER NUNOLD" +
	" SOGDIAN LETTER FINAL NUNOLD SOGDIAN LETTER FINAL NUN WITH VERTICAL TAIL" +
	"OLD SOGDIAN LETTER SAMEKHOLD SOGDIAN LETTER AYINOLD SOGDIAN LETTER ALTER" +
	"NATE AYINOLD SOGDIAN LETTER PEOLD SOGDIAN LETTER SADHEOLD SOGDIAN LETTER" +
	" FINAL SADHEOLD SOGDIAN LETTER FINAL SADHE WITH VERTICAL TAILOLD SOGDIAN" +
	" LETTER RESH-AYIN-DALETHOLD SOGDIAN LETTER SHINOLD SOGDIAN LETTER TAWOLD" +
	" SOGDIAN LETTER FINAL TAWOLD SOGDIAN LETTER FINAL TAW WITH VERTICAL TAIL" +
	"OLD SOGDIAN NUMBER ONEOLD SOGDIAN NUMBER TWOOLD SOGDIAN NUMBER THREEOLD " +
	"SOGDIAN NUMBER FOUROLD SOGDIAN NUMBER FIVEOLD SOGDIAN NUMBER TENOLD SOGD" +
	"IAN NUMBER TWENTYOLD SOGDIAN NUMBER THIRTYOLD SOGDIAN NUMBER ONE HUNDRED" +
	"OLD SOGDIAN FRACTION ONE HALFOLD SOGDIAN LIGATURE AYIN-DALETHSOGDIAN LET" +
	"TER ALEPHSOGDIAN LETTER BETHSOGDIAN LETTER GIMELSOGDIAN LETTER HESOGDIAN" +
	" LETTER WAWSOGDIAN LETTER ZAYINSOGDIAN LETTER HETHSOGDIAN LETTER YODHSOG" +
	"DIAN LETTER KAPHSOGDIAN LETTER LAMEDHSOGDIAN LETTER MEMSOGDIAN LETTER NU" +
	"NSOGDIAN LETTER SAMEKHSOGDIAN LETTER AYINSOGDIAN LETTER PESOGDIAN LETTER" +
	" SADHESOGDIAN LETTER RESH-AYINSOGDIAN LETTER SHINSOGDIAN LETTER TAWSOGDI" +
	"AN LETTER FETHSOGDIAN LETTER LESHSOGDIAN INDEPENDENT SHINSOGDIAN COMBINI" +
	"NG DOT BELOWSOGDIAN COMBINING TWO DOTS BELOWSOGDIAN COMBINING DOT ABOVES" +
	"OGDIAN COMBINING TWO DOTS ABOVESOGDIAN COMBINING CURVE ABOVESOGDIAN COMB" +
	"INING CURVE BELOWSOGDIAN COMBINING HOOK ABOVESOGDIAN COMBINING HOOK BELO" +
	"WSOGDIAN COMBINING LONG HOOK BELOWSOGDIAN COMBINING RESH BELOWSOGDIAN CO" +
	"MBINING STROKE BELOWSOGDIAN NUMBER ONESOGDIAN NUMBER TENSOGDIAN NUMBER T" +
	"WENTYSOGDIAN NUMBER ONE HUNDREDSOGDIAN PUNCTUATION TWO VERTICAL BARSSOGD" +
	"IAN PUNCTUATION TWO VERTICAL BARS WITH DOTSSOGDIAN PUNCTUATION CIRCLE WI" +
	"TH DOTSOGDIAN PUNCTUATION TWO CIRCLES WITH DOTSSOGDIAN PUNCTUATION HALF " +
	"CIRCLE WITH DOTCHORASMIAN LETTER ALEPHCHORASMIAN LETTER SMALL ALEPHCHORA" +
	"SMIAN LETTER BETHCHORASMIAN LETTER GIMELCHORASMIAN LETTER DALETHCHORASMI" +
	"AN LETTER HECHORASMIAN LETTER WAWCHORASMIAN LETTER CURLED WAWCHORASMIAN " +
	"LETTER ZAYINCHORASMIAN LETTER HETHCHORASMIAN LETTER YODHCHORASMIAN LETTE" +
	"R KAPHCHORASMIAN LETTER LAMEDHCHORASMIAN LETTER MEMCHORASMIAN LETTER NUN" +
	"CHORASMIAN LETTER SAMEKHCHORASMIAN LETTER AYINCHORASMIAN LETTER PECHORAS" +
	"MIAN LETTER RESHCHORASMIAN LETTER SHINCHORASMIAN LETTER TAWCHORASMIAN NU" +
	"MBER ONECHORASMIAN NUMBER TWOCHORASMIAN NUMBER THREECHORASMIAN NUMBER FO" +
	"URCHORASMIAN NUMBER TENCHORASMIAN NUMBER TWENTYCHORASMIAN NUMBER ONE HUN" +
	"DREDELYMAIC LETTER ALEPHELYMAIC LETTER BETHELYMAIC LETTER GIMELELYMAIC L" +
	"ETTER DALETHELYMAIC LETTER HEELYMAIC LETTER WAWELYMAIC LETTER ZAYINELYMA" +
	"IC LETTER HETHELYMAIC LETTER TETHELYMAIC LETTER YODHELYMAIC LETTER KAPHE" +
	"LYMAIC LETTER LAMEDHELYMAIC LETTER MEMELYMAIC LETTER NUNELYMAIC LETTER S" +
	"AMEKHELYMAIC LETTER AYINELYMAIC LETTER PEELYMAIC LETTER SADHEELYMAIC LET" +
	"TER QOPHELYMAIC LETTER RESHELYMAIC LETTER SHINELYMAIC LETTER TAWELYMAIC " +
	"LIGATURE ZAYIN-YODHBRAHMI SIGN CANDRABINDUBRAHMI SIGN ANUSVARABRAHMI SIG" +
	"N VISARGABRAHMI SIGN JIHVAMULIYABRAHMI SIGN UPADHMANIYABRAHMI LETTER ABR" +
	"AHMI LETTER AABRAHMI LETTER IBRAHMI LETTER IIBRAHMI LETTER UBRAHMI LETTE" +
	"R UUBRAHMI LETTER VOCALIC RBRAHMI LETTER VOCALIC RRBRAHMI LETTER VOCALIC" +
	" LBRAHMI LETTER VOCALIC LLBRAHMI LETTER EBRAHMI LETTER AIBRAHMI LETTER O" +
	"BRAHMI LETTER AUBRAHMI LETTER KABRAHMI LETTER KHABRAHMI LETTER GABRAHMI " +
	"LETTER GHABRAHMI LETTER NGABRAHMI LETTER CABRAHMI LETTER CHABRAHMI LETTE" +
	"R JABRAHMI LETTER JHABRAHMI LETTER NYABRAHMI LETTER TTABRAHMI LETTER TTH" +
	"ABRAHMI LETTER DDABRAHMI LETTER DDHABRAHMI LETTER NNABRAHMI LETTER TABRA" +
	"HMI LETTER THABRAHMI LETTER DABRAHMI LETTER DHABRAHMI LETTER NABRAHMI LE" +
	"TTER PABRAHMI LETTER PHABRAHMI LETTER BABRAHMI LETTER BHABRAHMI LETTER M" +
	"ABRAHMI LETTER YABRAHMI LETTER RABRAHMI LETTER LABRAHMI LETTER VABRAHMI ") + ("" +
	"LETTER SHABRAHMI LETTER SSABRAHMI LETTER SABRAHMI LETTER HABRAHMI LETTER" +
	" LLABRAHMI LETTER OLD TAMIL LLLABRAHMI LETTER OLD TAMIL RRABRAHMI LETTER" +
	" OLD TAMIL NNNABRAHMI VOWEL SIGN AABRAHMI VOWEL SIGN BHATTIPROLU AABRAHM" +
	"I VOWEL SIGN IBRAHMI VOWEL SIGN IIBRAHMI VOWEL SIGN UBRAHMI VOWEL SIGN U" +
	"UBRAHMI VOWEL SIGN VOCALIC RBRAHMI VOWEL SIGN VOCALIC RRBRAHMI VOWEL SIG" +
	"N VOCALIC LBRAHMI VOWEL SIGN VOCALIC LLBRAHMI VOWEL SIGN EBRAHMI VOWEL S" +
	"IGN AIBRAHMI VOWEL SIGN OBRAHMI VOWEL SIGN AUBRAHMI VIRAMABRAHMI DANDABR" +
	"AHMI DOUBLE DANDABRAHMI PUNCTUATION DOTBRAHMI PUNCTUATION DOUBLE DOTBRAH" +
	"MI PUNCTUATION LINEBRAHMI PUNCTUATION CRESCENT BARBRAHMI PUNCTUATION LOT" +
	"USBRAHMI NUMBER ONEBRAHMI NUMBER TWOBRAHMI NUMBER THREEBRAHMI NUMBER FOU" +
	"RBRAHMI NUMBER FIVEBRAHMI NUMBER SIXBRAHMI NUMBER SEVENBRAHMI NUMBER EIG" +
	"HTBRAHMI NUMBER NINEBRAHMI NUMBER TENBRAHMI NUMBER TWENTYBRAHMI NUMBER T" +
	"HIRTYBRAHMI NUMBER FORTYBRAHMI NUMBER FIFTYBRAHMI NUMBER SIXTYBRAHMI NUM" +
	"BER SEVENTYBRAHMI NUMBER EIGHTYBRAHMI NUMBER NINETYBRAHMI NUMBER ONE HUN" +
	"DREDBRAHMI NUMBER ONE THOUSANDBRAHMI DIGIT ZEROBRAHMI DIGIT ONEBRAHMI DI" +
	"GIT TWOBRAHMI DIGIT THREEBRAHMI DIGIT FOURBRAHMI DIGIT FIVEBRAHMI DIGIT " +
	"SIXBRAHMI DIGIT SEVENBRAHMI DIGIT EIGHTBRAHMI DIGIT NINEBRAHMI NUMBER JO" +
	"INERKAITHI SIGN CANDRABINDUKAITHI SIGN ANUSVARAKAITHI SIGN VISARGAKAITHI" +
	" LETTER AKAITHI LETTER AAKAITHI LETTER IKAITHI LETTER IIKAITHI LETTER UK" +
	"AITHI LETTER UUKAITHI LETTER EKAITHI LETTER AIKAITHI LETTER OKAITHI LETT" +
	"ER AUKAITHI LETTER KAKAITHI LETTER KHAKAITHI LETTER GAKAITHI LETTER GHAK" +
	"AITHI LETTER NGAKAITHI LETTER CAKAITHI LETTER CHAKAITHI LETTER JAKAITHI " +
	"LETTER JHAKAITHI LETTER NYAKAITHI LETTER TTAKAITHI LETTER TTHAKAITHI LET" +
	"TER DDAKAITHI LETTER DDDHAKAITHI LETTER DDHAKAITHI LETTER RHAKAITHI LETT" +
	"ER NNAKAITHI LETTER TAKAITHI LETTER THAKAITHI LETTER DAKAITHI LETTER DHA" +
	"KAITHI LETTER NAKAITHI LETTER PAKAITHI LETTER PHAKAITHI LETTER BAKAITHI " +
	"LETTER BHAKAITHI LETTER MAKAITHI LETTER YAKAITHI LETTER RAKAITHI LETTER " +
	"LAKAITHI LETTER VAKAITHI LETTER SHAKAITHI LETTER SSAKAITHI LETTER SAKAIT" +
	"HI LETTER HAKAITHI VOWEL SIGN AAKAITHI VOWEL SIGN IKAITHI VOWEL SIGN IIK" +
	"AITHI VOWEL SIGN UKAITHI VOWEL SIGN UUKAITHI VOWEL SIGN EKAITHI VOWEL SI" +
	"GN AIKAITHI VOWEL SIGN OKAITHI VOWEL SIGN AUKAITHI SIGN VIRAMAKAITHI SIG" +
	"N NUKTAKAITHI ABBREVIATION SIGNKAITHI ENUMERATION SIGNKAITHI NUMBER SIGN" +
	"KAITHI SECTION MARKKAITHI DOUBLE SECTION MARKKAITHI DANDAKAITHI DOUBLE D" +
	"ANDAKAITHI NUMBER SIGN ABOVESORA SOMPENG LETTER SAHSORA SOMPENG LETTER T" +
	"AHSORA SOMPENG LETTER BAHSORA SOMPENG LETTER CAHSORA SOMPENG LETTER DAHS" +
	"ORA SOMPENG LETTER GAHSORA SOMPENG LETTER MAHSORA SOMPENG LETTER NGAHSOR" +
	"A SOMPENG LETTER LAHSORA SOMPENG LETTER NAHSORA SOMPENG LETTER VAHSORA S" +
	"OMPENG LETTER PAHSORA SOMPENG LETTER YAHSORA SOMPENG LETTER RAHSORA SOMP" +
	"ENG LETTER HAHSORA SOMPENG LETTER KAHSORA SOMPENG LETTER JAHSORA SOMPENG" +
	" LETTER NYAHSORA SOMPENG LETTER AHSORA SOMPENG LETTER EEHSORA SOMPENG LE" +
	"TTER IHSORA SOMPENG LETTER UHSORA SOMPENG LETTER OHSORA SOMPENG LETTER E" +
	"HSORA SOMPENG LETTER MAESORA SOMPENG DIGIT ZEROSORA SOMPENG DIGIT ONESOR" +
	"A SOMPENG DIGIT TWOSORA SOMPENG DIGIT THREESORA SOMPENG DIGIT FOURSORA S" +
	"OMPENG DIGIT FIVESORA SOMPENG DIGIT SIXSORA SOMPENG DIGIT SEVENSORA SOMP" +
	"ENG DIGIT EIGHTSORA SOMPENG DIGIT NINECHAKMA SIGN CANDRABINDUCHAKMA SIGN" +
	" ANUSVARACHAKMA SIGN VISARGACHAKMA LETTER AACHAKMA LETTER ICHAKMA LETTER" +
	" UCHAKMA LETTER ECHAKMA LETTER KAACHAKMA LETTER KHAACHAKMA LETTER GAACHA" +
	"KMA LETTER GHAACHAKMA LETTER NGAACHAKMA LETTER CAACHAKMA LETTER CHAACHAK" +
	"MA LETTER JAACHAKMA LETTER JHAACHAKMA LETTER NYAACHAKMA LETTER TTAACHAKM" +
	"A LETTER TTHAACHAKMA LETTER DDAACHAKMA LETTER DDHAACHAKMA LETTER NNAACHA" +
	"KMA LETTER TAACHAKMA LETTER THAACHAKMA LETTER DAACHAKMA LETTER DHAACHAKM" +
	"A LETTER NAACHAKMA LETTER PAACHAKMA LETTER PHAACHAKMA LETTER BAACHAKMA L" +
	"ETTER BHAACHAKMA LETTER MAACHAKMA LETTER YYAACHAKMA LETTER YAACHAKMA LET" +
	"TER RAACHAKMA LETTER LAACHAKMA LETTER WAACHAKMA LETTER SAACHAKMA LETTER " +
	"HAACHAKMA VOWEL SIGN ACHAKMA VOWEL SIGN ICHAKMA VOWEL SIGN IICHAKMA VOWE" +
	"L SIGN UCHAKMA VOWEL SIGN UUCHAKMA VOWEL SIGN ECHAKMA VOWEL SIGN AICHAKM" +
	"A VOWEL SIGN OCHAKMA VOWEL SIGN AUCHAKMA VOWEL SIGN OICHAKMA O MARKCHAKM" +
	"A AU MARKCHAKMA VIRAMACHAKMA MAAYYAACHAKMA DIGIT ZEROCHAKMA DIGIT ONECHA" +
	"KMA DIGIT TWOCHAKMA DIGIT THREECHAKMA DIGIT FOURCHAKMA DIGIT FIVECHAKMA " +
	"DIGIT SIXCHAKMA DIGIT SEVENCHAKMA DIGIT EIGHTCHAKMA DIGIT NINECHAKMA SEC" +
	"TION MARKCHAKMA DANDACHAKMA DOUBLE DANDACHAKMA QUESTION MARKCHAKMA LETTE" +
	"R LHAACHAKMA VOWEL SIGN AACHAKMA VOWEL SIGN EICHAKMA LETTER VAAMAHAJANI " +
	"LETTER AMAHAJANI LETTER IMAHAJANI LETTER UMAHAJANI LETTER EMAHAJANI LETT" +
	"ER OMAHAJANI LETTER KAMAHAJANI LETTER KHAMAHAJANI LETTER GAMAHAJANI LETT") + ("" +
	"ER GHAMAHAJANI LETTER CAMAHAJANI LETTER CHAMAHAJANI LETTER JAMAHAJANI LE" +
	"TTER JHAMAHAJANI LETTER NYAMAHAJANI LETTER TTAMAHAJANI LETTER TTHAMAHAJA" +
	"NI LETTER DDAMAHAJANI LETTER DDHAMAHAJANI LETTER NNAMAHAJANI LETTER TAMA" +
	"HAJANI LETTER THAMAHAJANI LETTER DAMAHAJANI LETTER DHAMAHAJANI LETTER NA" +
	"MAHAJANI LETTER PAMAHAJANI LETTER PHAMAHAJANI LETTER BAMAHAJANI LETTER B" +
	"HAMAHAJANI LETTER MAMAHAJANI LETTER RAMAHAJANI LETTER LAMAHAJANI LETTER " +
	"VAMAHAJANI LETTER SAMAHAJANI LETTER HAMAHAJANI LETTER RRAMAHAJANI SIGN N" +
	"UKTAMAHAJANI ABBREVIATION SIGNMAHAJANI SECTION MARKMAHAJANI LIGATURE SHR" +
	"ISHARADA SIGN CANDRABINDUSHARADA SIGN ANUSVARASHARADA SIGN VISARGASHARAD" +
	"A LETTER ASHARADA LETTER AASHARADA LETTER ISHARADA LETTER IISHARADA LETT" +
	"ER USHARADA LETTER UUSHARADA LETTER VOCALIC RSHARADA LETTER VOCALIC RRSH" +
	"ARADA LETTER VOCALIC LSHARADA LETTER VOCALIC LLSHARADA LETTER ESHARADA L" +
	"ETTER AISHARADA LETTER OSHARADA LETTER AUSHARADA LETTER KASHARADA LETTER" +
	" KHASHARADA LETTER GASHARADA LETTER GHASHARADA LETTER NGASHARADA LETTER " +
	"CASHARADA LETTER CHASHARADA LETTER JASHARADA LETTER JHASHARADA LETTER NY" +
	"ASHARADA LETTER TTASHARADA LETTER TTHASHARADA LETTER DDASHARADA LETTER D" +
	"DHASHARADA LETTER NNASHARADA LETTER TASHARADA LETTER THASHARADA LETTER D" +
	"ASHARADA LETTER DHASHARADA LETTER NASHARADA LETTER PASHARADA LETTER PHAS" +
	"HARADA LETTER BASHARADA LETTER BHASHARADA LETTER MASHARADA LETTER YASHAR" +
	"ADA LETTER RASHARADA LETTER LASHARADA LETTER LLASHARADA LETTER VASHARADA" +
	" LETTER SHASHARADA LETTER SSASHARADA LETTER SASHARADA LETTER HASHARADA V" +
	"OWEL SIGN AASHARADA VOWEL SIGN ISHARADA VOWEL SIGN IISHARADA VOWEL SIGN " +
	"USHARADA VOWEL SIGN UUSHARADA VOWEL SIGN VOCALIC RSHARADA VOWEL SIGN VOC" +
	"ALIC RRSHARADA VOWEL SIGN VOCALIC LSHARADA VOWEL SIGN VOCALIC LLSHARADA " +
	"VOWEL SIGN ESHARADA VOWEL SIGN AISHARADA VOWEL SIGN OSHARADA VOWEL SIGN " +
	"AUSHARADA SIGN VIRAMASHARADA SIGN AVAGRAHASHARADA SIGN JIHVAMULIYASHARAD" +
	"A SIGN UPADHMANIYASHARADA OMSHARADA DANDASHARADA DOUBLE DANDASHARADA ABB" +
	"REVIATION SIGNSHARADA SEPARATORSHARADA SANDHI MARKSHARADA SIGN NUKTASHAR" +
	"ADA VOWEL MODIFIER MARKSHARADA EXTRA SHORT VOWEL MARKSHARADA SUTRA MARKS" +
	"HARADA VOWEL SIGN PRISHTHAMATRA ESHARADA SIGN INVERTED CANDRABINDUSHARAD" +
	"A DIGIT ZEROSHARADA DIGIT ONESHARADA DIGIT TWOSHARADA DIGIT THREESHARADA" +
	" DIGIT FOURSHARADA DIGIT FIVESHARADA DIGIT SIXSHARADA DIGIT SEVENSHARADA" +
	" DIGIT EIGHTSHARADA DIGIT NINESHARADA EKAMSHARADA SIGN SIDDHAMSHARADA HE" +
	"ADSTROKESHARADA CONTINUATION SIGNSHARADA SECTION MARK-1SHARADA SECTION M" +
	"ARK-2SINHALA ARCHAIC DIGIT ONESINHALA ARCHAIC DIGIT TWOSINHALA ARCHAIC D" +
	"IGIT THREESINHALA ARCHAIC DIGIT FOURSINHALA ARCHAIC DIGIT FIVESINHALA AR" +
	"CHAIC DIGIT SIXSINHALA ARCHAIC DIGIT SEVENSINHALA ARCHAIC DIGIT EIGHTSIN" +
	"HALA ARCHAIC DIGIT NINESINHALA ARCHAIC NUMBER TENSINHALA ARCHAIC NUMBER " +
	"TWENTYSINHALA ARCHAIC NUMBER THIRTYSINHALA ARCHAIC NUMBER FORTYSINHALA A" +
	"RCHAIC NUMBER FIFTYSINHALA ARCHAIC NUMBER SIXTYSINHALA ARCHAIC NUMBER SE" +
	"VENTYSINHALA ARCHAIC NUMBER EIGHTYSINHALA ARCHAIC NUMBER NINETYSINHALA A" +
	"RCHAIC NUMBER ONE HUNDREDSINHALA ARCHAIC NUMBER ONE THOUSANDKHOJKI LETTE" +
	"R AKHOJKI LETTER AAKHOJKI LETTER IKHOJKI LETTER UKHOJKI LETTER EKHOJKI L" +
	"ETTER AIKHOJKI LETTER OKHOJKI LETTER AUKHOJKI LETTER KAKHOJKI LETTER KHA" +
	"KHOJKI LETTER GAKHOJKI LETTER GGAKHOJKI LETTER GHAKHOJKI LETTER NGAKHOJK" +
	"I LETTER CAKHOJKI LETTER CHAKHOJKI LETTER JAKHOJKI LETTER JJAKHOJKI LETT" +
	"ER NYAKHOJKI LETTER TTAKHOJKI LETTER TTHAKHOJKI LETTER DDAKHOJKI LETTER " +
	"DDHAKHOJKI LETTER NNAKHOJKI LETTER TAKHOJKI LETTER THAKHOJKI LETTER DAKH" +
	"OJKI LETTER DDDAKHOJKI LETTER DHAKHOJKI LETTER NAKHOJKI LETTER PAKHOJKI " +
	"LETTER PHAKHOJKI LETTER BAKHOJKI LETTER BBAKHOJKI LETTER BHAKHOJKI LETTE" +
	"R MAKHOJKI LETTER YAKHOJKI LETTER RAKHOJKI LETTER LAKHOJKI LETTER VAKHOJ" +
	"KI LETTER SAKHOJKI LETTER HAKHOJKI LETTER LLAKHOJKI VOWEL SIGN AAKHOJKI " +
	"VOWEL SIGN IKHOJKI VOWEL SIGN IIKHOJKI VOWEL SIGN UKHOJKI VOWEL SIGN EKH" +
	"OJKI VOWEL SIGN AIKHOJKI VOWEL SIGN OKHOJKI VOWEL SIGN AUKHOJKI SIGN ANU" +
	"SVARAKHOJKI SIGN VIRAMAKHOJKI SIGN NUKTAKHOJKI SIGN SHADDAKHOJKI DANDAKH" +
	"OJKI DOUBLE DANDAKHOJKI WORD SEPARATORKHOJKI SECTION MARKKHOJKI DOUBLE S" +
	"ECTION MARKKHOJKI ABBREVIATION SIGNKHOJKI SIGN SUKUNMULTANI LETTER AMULT" +
	"ANI LETTER IMULTANI LETTER UMULTANI LETTER EMULTANI LETTER KAMULTANI LET" +
	"TER KHAMULTANI LETTER GAMULTANI LETTER GHAMULTANI LETTER CAMULTANI LETTE" +
	"R CHAMULTANI LETTER JAMULTANI LETTER JJAMULTANI LETTER NYAMULTANI LETTER" +
	" TTAMULTANI LETTER TTHAMULTANI LETTER DDAMULTANI LETTER DDDAMULTANI LETT" +
	"ER DDHAMULTANI LETTER NNAMULTANI LETTER TAMULTANI LETTER THAMULTANI LETT" +
	"ER DAMULTANI LETTER DHAMULTANI LETTER NAMULTANI LETTER PAMULTANI LETTER " +
	"PHAMULTANI LETTER BAMULTANI LETTER BHAMULTANI LETTER MAMULTANI LETTER YA") + ("" +
	"MULTANI LETTER RAMULTANI LETTER LAMULTANI LETTER VAMULTANI LETTER SAMULT" +
	"ANI LETTER HAMULTANI LETTER RRAMULTANI LETTER RHAMULTANI SECTION MARKKHU" +
	"DAWADI LETTER AKHUDAWADI LETTER AAKHUDAWADI LETTER IKHUDAWADI LETTER IIK" +
	"HUDAWADI LETTER UKHUDAWADI LETTER UUKHUDAWADI LETTER EKHUDAWADI LETTER A" +
	"IKHUDAWADI LETTER OKHUDAWADI LETTER AUKHUDAWADI LETTER KAKHUDAWADI LETTE" +
	"R KHAKHUDAWADI LETTER GAKHUDAWADI LETTER GGAKHUDAWADI LETTER GHAKHUDAWAD" +
	"I LETTER NGAKHUDAWADI LETTER CAKHUDAWADI LETTER CHAKHUDAWADI LETTER JAKH" +
	"UDAWADI LETTER JJAKHUDAWADI LETTER JHAKHUDAWADI LETTER NYAKHUDAWADI LETT" +
	"ER TTAKHUDAWADI LETTER TTHAKHUDAWADI LETTER DDAKHUDAWADI LETTER DDDAKHUD" +
	"AWADI LETTER RRAKHUDAWADI LETTER DDHAKHUDAWADI LETTER NNAKHUDAWADI LETTE" +
	"R TAKHUDAWADI LETTER THAKHUDAWADI LETTER DAKHUDAWADI LETTER DHAKHUDAWADI" +
	" LETTER NAKHUDAWADI LETTER PAKHUDAWADI LETTER PHAKHUDAWADI LETTER BAKHUD" +
	"AWADI LETTER BBAKHUDAWADI LETTER BHAKHUDAWADI LETTER MAKHUDAWADI LETTER " +
	"YAKHUDAWADI LETTER RAKHUDAWADI LETTER LAKHUDAWADI LETTER VAKHUDAWADI LET" +
	"TER SHAKHUDAWADI LETTER SAKHUDAWADI LETTER HAKHUDAWADI SIGN ANUSVARAKHUD" +
	"AWADI VOWEL SIGN AAKHUDAWADI VOWEL SIGN IKHUDAWADI VOWEL SIGN IIKHUDAWAD" +
	"I VOWEL SIGN UKHUDAWADI VOWEL SIGN UUKHUDAWADI VOWEL SIGN EKHUDAWADI VOW" +
	"EL SIGN AIKHUDAWADI VOWEL SIGN OKHUDAWADI VOWEL SIGN AUKHUDAWADI SIGN NU" +
	"KTAKHUDAWADI SIGN VIRAMAKHUDAWADI DIGIT ZEROKHUDAWADI DIGIT ONEKHUDAWADI" +
	" DIGIT TWOKHUDAWADI DIGIT THREEKHUDAWADI DIGIT FOURKHUDAWADI DIGIT FIVEK" +
	"HUDAWADI DIGIT SIXKHUDAWADI DIGIT SEVENKHUDAWADI DIGIT EIGHTKHUDAWADI DI" +
	"GIT NINEGRANTHA SIGN COMBINING ANUSVARA ABOVEGRANTHA SIGN CANDRABINDUGRA" +
	"NTHA SIGN ANUSVARAGRANTHA SIGN VISARGAGRANTHA LETTER AGRANTHA LETTER AAG" +
	"RANTHA LETTER IGRANTHA LETTER IIGRANTHA LETTER UGRANTHA LETTER UUGRANTHA" +
	" LETTER VOCALIC RGRANTHA LETTER VOCALIC LGRANTHA LETTER EEGRANTHA LETTER" +
	" AIGRANTHA LETTER OOGRANTHA LETTER AUGRANTHA LETTER KAGRANTHA LETTER KHA" +
	"GRANTHA LETTER GAGRANTHA LETTER GHAGRANTHA LETTER NGAGRANTHA LETTER CAGR" +
	"ANTHA LETTER CHAGRANTHA LETTER JAGRANTHA LETTER JHAGRANTHA LETTER NYAGRA" +
	"NTHA LETTER TTAGRANTHA LETTER TTHAGRANTHA LETTER DDAGRANTHA LETTER DDHAG" +
	"RANTHA LETTER NNAGRANTHA LETTER TAGRANTHA LETTER THAGRANTHA LETTER DAGRA" +
	"NTHA LETTER DHAGRANTHA LETTER NAGRANTHA LETTER PAGRANTHA LETTER PHAGRANT" +
	"HA LETTER BAGRANTHA LETTER BHAGRANTHA LETTER MAGRANTHA LETTER YAGRANTHA " +
	"LETTER RAGRANTHA LETTER LAGRANTHA LETTER LLAGRANTHA LETTER VAGRANTHA LET" +
	"TER SHAGRANTHA LETTER SSAGRANTHA LETTER SAGRANTHA LETTER HACOMBINING BIN" +
	"DU BELOWGRANTHA SIGN NUKTAGRANTHA SIGN AVAGRAHAGRANTHA VOWEL SIGN AAGRAN" +
	"THA VOWEL SIGN IGRANTHA VOWEL SIGN IIGRANTHA VOWEL SIGN UGRANTHA VOWEL S" +
	"IGN UUGRANTHA VOWEL SIGN VOCALIC RGRANTHA VOWEL SIGN VOCALIC RRGRANTHA V" +
	"OWEL SIGN EEGRANTHA VOWEL SIGN AIGRANTHA VOWEL SIGN OOGRANTHA VOWEL SIGN" +
	" AUGRANTHA SIGN VIRAMAGRANTHA OMGRANTHA AU LENGTH MARKGRANTHA SIGN PLUTA" +
	"GRANTHA LETTER VEDIC ANUSVARAGRANTHA LETTER VEDIC DOUBLE ANUSVARAGRANTHA" +
	" LETTER VOCALIC RRGRANTHA LETTER VOCALIC LLGRANTHA VOWEL SIGN VOCALIC LG" +
	"RANTHA VOWEL SIGN VOCALIC LLCOMBINING GRANTHA DIGIT ZEROCOMBINING GRANTH" +
	"A DIGIT ONECOMBINING GRANTHA DIGIT TWOCOMBINING GRANTHA DIGIT THREECOMBI" +
	"NING GRANTHA DIGIT FOURCOMBINING GRANTHA DIGIT FIVECOMBINING GRANTHA DIG" +
	"IT SIXCOMBINING GRANTHA LETTER ACOMBINING GRANTHA LETTER KACOMBINING GRA" +
	"NTHA LETTER NACOMBINING GRANTHA LETTER VICOMBINING GRANTHA LETTER PANEWA" +
	" LETTER ANEWA LETTER AANEWA LETTER INEWA LETTER IINEWA LETTER UNEWA LETT" +
	"ER UUNEWA LETTER VOCALIC RNEWA LETTER VOCALIC RRNEWA LETTER VOCALIC LNEW" +
	"A LETTER VOCALIC LLNEWA LETTER ENEWA LETTER AINEWA LETTER ONEWA LETTER A" +
	"UNEWA LETTER KANEWA LETTER KHANEWA LETTER GANEWA LETTER GHANEWA LETTER N" +
	"GANEWA LETTER NGHANEWA LETTER CANEWA LETTER CHANEWA LETTER JANEWA LETTER" +
	" JHANEWA LETTER NYANEWA LETTER NYHANEWA LETTER TTANEWA LETTER TTHANEWA L" +
	"ETTER DDANEWA LETTER DDHANEWA LETTER NNANEWA LETTER TANEWA LETTER THANEW" +
	"A LETTER DANEWA LETTER DHANEWA LETTER NANEWA LETTER NHANEWA LETTER PANEW" +
	"A LETTER PHANEWA LETTER BANEWA LETTER BHANEWA LETTER MANEWA LETTER MHANE" +
	"WA LETTER YANEWA LETTER RANEWA LETTER RHANEWA LETTER LANEWA LETTER LHANE" +
	"WA LETTER WANEWA LETTER SHANEWA LETTER SSANEWA LETTER SANEWA LETTER HANE" +
	"WA VOWEL SIGN AANEWA VOWEL SIGN INEWA VOWEL SIGN IINEWA VOWEL SIGN UNEWA" +
	" VOWEL SIGN UUNEWA VOWEL SIGN VOCALIC RNEWA VOWEL SIGN VOCALIC RRNEWA VO" +
	"WEL SIGN VOCALIC LNEWA VOWEL SIGN VOCALIC LLNEWA VOWEL SIGN ENEWA VOWEL " +
	"SIGN AINEWA VOWEL SIGN ONEWA VOWEL SIGN AUNEWA SIGN VIRAMANEWA SIGN CAND" +
	"RABINDUNEWA SIGN ANUSVARANEWA SIGN VISARGANEWA SIGN NUKTANEWA SIGN AVAGR" +
	"AHANEWA SIGN FINAL ANUSVARANEWA OMNEWA SIDDHINEWA DANDANEWA DOUBLE DANDA" +
	"NEWA COMMANEWA GAP FILLERNEWA ABBREVIATION SIGNNEWA DIGIT ZERONEWA DIGIT") + ("" +
	" ONENEWA DIGIT TWONEWA DIGIT THREENEWA DIGIT FOURNEWA DIGIT FIVENEWA DIG" +
	"IT SIXNEWA DIGIT SEVENNEWA DIGIT EIGHTNEWA DIGIT NINENEWA DOUBLE COMMANE" +
	"WA PLACEHOLDER MARKNEWA INSERTION SIGNNEWA SANDHI MARKNEWA LETTER VEDIC " +
	"ANUSVARANEWA SIGN JIHVAMULIYANEWA SIGN UPADHMANIYATIRHUTA ANJITIRHUTA LE" +
	"TTER ATIRHUTA LETTER AATIRHUTA LETTER ITIRHUTA LETTER IITIRHUTA LETTER U" +
	"TIRHUTA LETTER UUTIRHUTA LETTER VOCALIC RTIRHUTA LETTER VOCALIC RRTIRHUT" +
	"A LETTER VOCALIC LTIRHUTA LETTER VOCALIC LLTIRHUTA LETTER ETIRHUTA LETTE" +
	"R AITIRHUTA LETTER OTIRHUTA LETTER AUTIRHUTA LETTER KATIRHUTA LETTER KHA" +
	"TIRHUTA LETTER GATIRHUTA LETTER GHATIRHUTA LETTER NGATIRHUTA LETTER CATI" +
	"RHUTA LETTER CHATIRHUTA LETTER JATIRHUTA LETTER JHATIRHUTA LETTER NYATIR" +
	"HUTA LETTER TTATIRHUTA LETTER TTHATIRHUTA LETTER DDATIRHUTA LETTER DDHAT" +
	"IRHUTA LETTER NNATIRHUTA LETTER TATIRHUTA LETTER THATIRHUTA LETTER DATIR" +
	"HUTA LETTER DHATIRHUTA LETTER NATIRHUTA LETTER PATIRHUTA LETTER PHATIRHU" +
	"TA LETTER BATIRHUTA LETTER BHATIRHUTA LETTER MATIRHUTA LETTER YATIRHUTA " +
	"LETTER RATIRHUTA LETTER LATIRHUTA LETTER VATIRHUTA LETTER SHATIRHUTA LET" +
	"TER SSATIRHUTA LETTER SATIRHUTA LETTER HATIRHUTA VOWEL SIGN AATIRHUTA VO" +
	"WEL SIGN ITIRHUTA VOWEL SIGN IITIRHUTA VOWEL SIGN UTIRHUTA VOWEL SIGN UU" +
	"TIRHUTA VOWEL SIGN VOCALIC RTIRHUTA VOWEL SIGN VOCALIC RRTIRHUTA VOWEL S" +
	"IGN VOCALIC LTIRHUTA VOWEL SIGN VOCALIC LLTIRHUTA VOWEL SIGN ETIRHUTA VO" +
	"WEL SIGN SHORT ETIRHUTA VOWEL SIGN AITIRHUTA VOWEL SIGN OTIRHUTA VOWEL S" +
	"IGN SHORT OTIRHUTA VOWEL SIGN AUTIRHUTA SIGN CANDRABINDUTIRHUTA SIGN ANU" +
	"SVARATIRHUTA SIGN VISARGATIRHUTA SIGN VIRAMATIRHUTA SIGN NUKTATIRHUTA SI" +
	"GN AVAGRAHATIRHUTA GVANGTIRHUTA ABBREVIATION SIGNTIRHUTA OMTIRHUTA DIGIT" +
	" ZEROTIRHUTA DIGIT ONETIRHUTA DIGIT TWOTIRHUTA DIGIT THREETIRHUTA DIGIT " +
	"FOURTIRHUTA DIGIT FIVETIRHUTA DIGIT SIXTIRHUTA DIGIT SEVENTIRHUTA DIGIT " +
	"EIGHTTIRHUTA DIGIT NINESIDDHAM LETTER ASIDDHAM LETTER AASIDDHAM LETTER I" +
	"SIDDHAM LETTER IISIDDHAM LETTER USIDDHAM LETTER UUSIDDHAM LETTER VOCALIC" +
	" RSIDDHAM LETTER VOCALIC RRSIDDHAM LETTER VOCALIC LSIDDHAM LETTER VOCALI" +
	"C LLSIDDHAM LETTER ESIDDHAM LETTER AISIDDHAM LETTER OSIDDHAM LETTER AUSI" +
	"DDHAM LETTER KASIDDHAM LETTER KHASIDDHAM LETTER GASIDDHAM LETTER GHASIDD" +
	"HAM LETTER NGASIDDHAM LETTER CASIDDHAM LETTER CHASIDDHAM LETTER JASIDDHA" +
	"M LETTER JHASIDDHAM LETTER NYASIDDHAM LETTER TTASIDDHAM LETTER TTHASIDDH" +
	"AM LETTER DDASIDDHAM LETTER DDHASIDDHAM LETTER NNASIDDHAM LETTER TASIDDH" +
	"AM LETTER THASIDDHAM LETTER DASIDDHAM LETTER DHASIDDHAM LETTER NASIDDHAM" +
	" LETTER PASIDDHAM LETTER PHASIDDHAM LETTER BASIDDHAM LETTER BHASIDDHAM L" +
	"ETTER MASIDDHAM LETTER YASIDDHAM LETTER RASIDDHAM LETTER LASIDDHAM LETTE" +
	"R VASIDDHAM LETTER SHASIDDHAM LETTER SSASIDDHAM LETTER SASIDDHAM LETTER " +
	"HASIDDHAM VOWEL SIGN AASIDDHAM VOWEL SIGN ISIDDHAM VOWEL SIGN IISIDDHAM " +
	"VOWEL SIGN USIDDHAM VOWEL SIGN UUSIDDHAM VOWEL SIGN VOCALIC RSIDDHAM VOW" +
	"EL SIGN VOCALIC RRSIDDHAM VOWEL SIGN ESIDDHAM VOWEL SIGN AISIDDHAM VOWEL" +
	" SIGN OSIDDHAM VOWEL SIGN AUSIDDHAM SIGN CANDRABINDUSIDDHAM SIGN ANUSVAR" +
	"ASIDDHAM SIGN VISARGASIDDHAM SIGN VIRAMASIDDHAM SIGN NUKTASIDDHAM SIGN S" +
	"IDDHAMSIDDHAM DANDASIDDHAM DOUBLE DANDASIDDHAM SEPARATOR DOTSIDDHAM SEPA" +
	"RATOR BARSIDDHAM REPETITION MARK-1SIDDHAM REPETITION MARK-2SIDDHAM REPET" +
	"ITION MARK-3SIDDHAM END OF TEXT MARKSIDDHAM SECTION MARK WITH TRIDENT AN" +
	"D U-SHAPED ORNAMENTSSIDDHAM SECTION MARK WITH TRIDENT AND DOTTED CRESCEN" +
	"TSSIDDHAM SECTION MARK WITH RAYS AND DOTTED CRESCENTSSIDDHAM SECTION MAR" +
	"K WITH RAYS AND DOTTED DOUBLE CRESCENTSSIDDHAM SECTION MARK WITH RAYS AN" +
	"D DOTTED TRIPLE CRESCENTSSIDDHAM SECTION MARK DOUBLE RINGSIDDHAM SECTION" +
	" MARK DOUBLE RING WITH RAYSSIDDHAM SECTION MARK WITH DOUBLE CRESCENTSSID" +
	"DHAM SECTION MARK WITH TRIPLE CRESCENTSSIDDHAM SECTION MARK WITH QUADRUP" +
	"LE CRESCENTSSIDDHAM SECTION MARK WITH SEPTUPLE CRESCENTSSIDDHAM SECTION " +
	"MARK WITH CIRCLES AND RAYSSIDDHAM SECTION MARK WITH CIRCLES AND TWO ENCL" +
	"OSURESSIDDHAM SECTION MARK WITH CIRCLES AND FOUR ENCLOSURESSIDDHAM LETTE" +
	"R THREE-CIRCLE ALTERNATE ISIDDHAM LETTER TWO-CIRCLE ALTERNATE ISIDDHAM L" +
	"ETTER TWO-CIRCLE ALTERNATE IISIDDHAM LETTER ALTERNATE USIDDHAM VOWEL SIG" +
	"N ALTERNATE USIDDHAM VOWEL SIGN ALTERNATE UUMODI LETTER AMODI LETTER AAM" +
	"ODI LETTER IMODI LETTER IIMODI LETTER UMODI LETTER UUMODI LETTER VOCALIC" +
	" RMODI LETTER VOCALIC RRMODI LETTER VOCALIC LMODI LETTER VOCALIC LLMODI " +
	"LETTER EMODI LETTER AIMODI LETTER OMODI LETTER AUMODI LETTER KAMODI LETT" +
	"ER KHAMODI LETTER GAMODI LETTER GHAMODI LETTER NGAMODI LETTER CAMODI LET" +
	"TER CHAMODI LETTER JAMODI LETTER JHAMODI LETTER NYAMODI LETTER TTAMODI L" +
	"ETTER TTHAMODI LETTER DDAMODI LETTER DDHAMODI LETTER NNAMODI LETTER TAMO" +
	"DI LETTER THAMODI LETTER DAMODI LETTER DHAMODI LETTER NAMODI LETTER PAMO") + ("" +
	"DI LETTER PHAMODI LETTER BAMODI LETTER BHAMODI LETTER MAMODI LETTER YAMO" +
	"DI LETTER RAMODI LETTER LAMODI LETTER VAMODI LETTER SHAMODI LETTER SSAMO" +
	"DI LETTER SAMODI LETTER HAMODI LETTER LLAMODI VOWEL SIGN AAMODI VOWEL SI" +
	"GN IMODI VOWEL SIGN IIMODI VOWEL SIGN UMODI VOWEL SIGN UUMODI VOWEL SIGN" +
	" VOCALIC RMODI VOWEL SIGN VOCALIC RRMODI VOWEL SIGN VOCALIC LMODI VOWEL " +
	"SIGN VOCALIC LLMODI VOWEL SIGN EMODI VOWEL SIGN AIMODI VOWEL SIGN OMODI " +
	"VOWEL SIGN AUMODI SIGN ANUSVARAMODI SIGN VISARGAMODI SIGN VIRAMAMODI SIG" +
	"N ARDHACANDRAMODI DANDAMODI DOUBLE DANDAMODI ABBREVIATION SIGNMODI SIGN " +
	"HUVAMODI DIGIT ZEROMODI DIGIT ONEMODI DIGIT TWOMODI DIGIT THREEMODI DIGI" +
	"T FOURMODI DIGIT FIVEMODI DIGIT SIXMODI DIGIT SEVENMODI DIGIT EIGHTMODI " +
	"DIGIT NINEMONGOLIAN BIRGA WITH ORNAMENTMONGOLIAN ROTATED BIRGAMONGOLIAN " +
	"DOUBLE BIRGA WITH ORNAMENTMONGOLIAN TRIPLE BIRGA WITH ORNAMENTMONGOLIAN " +
	"BIRGA WITH DOUBLE ORNAMENTMONGOLIAN ROTATED BIRGA WITH ORNAMENTMONGOLIAN" +
	" ROTATED BIRGA WITH DOUBLE ORNAMENTMONGOLIAN INVERTED BIRGAMONGOLIAN INV" +
	"ERTED BIRGA WITH DOUBLE ORNAMENTMONGOLIAN SWIRL BIRGAMONGOLIAN SWIRL BIR" +
	"GA WITH ORNAMENTMONGOLIAN SWIRL BIRGA WITH DOUBLE ORNAMENTMONGOLIAN TURN" +
	"ED SWIRL BIRGA WITH DOUBLE ORNAMENTTAKRI LETTER ATAKRI LETTER AATAKRI LE" +
	"TTER ITAKRI LETTER IITAKRI LETTER UTAKRI LETTER UUTAKRI LETTER ETAKRI LE" +
	"TTER AITAKRI LETTER OTAKRI LETTER AUTAKRI LETTER KATAKRI LETTER KHATAKRI" +
	" LETTER GATAKRI LETTER GHATAKRI LETTER NGATAKRI LETTER CATAKRI LETTER CH" +
	"ATAKRI LETTER JATAKRI LETTER JHATAKRI LETTER NYATAKRI LETTER TTATAKRI LE" +
	"TTER TTHATAKRI LETTER DDATAKRI LETTER DDHATAKRI LETTER NNATAKRI LETTER T" +
	"ATAKRI LETTER THATAKRI LETTER DATAKRI LETTER DHATAKRI LETTER NATAKRI LET" +
	"TER PATAKRI LETTER PHATAKRI LETTER BATAKRI LETTER BHATAKRI LETTER MATAKR" +
	"I LETTER YATAKRI LETTER RATAKRI LETTER LATAKRI LETTER VATAKRI LETTER SHA" +
	"TAKRI LETTER SATAKRI LETTER HATAKRI LETTER RRATAKRI SIGN ANUSVARATAKRI S" +
	"IGN VISARGATAKRI VOWEL SIGN AATAKRI VOWEL SIGN ITAKRI VOWEL SIGN IITAKRI" +
	" VOWEL SIGN UTAKRI VOWEL SIGN UUTAKRI VOWEL SIGN ETAKRI VOWEL SIGN AITAK" +
	"RI VOWEL SIGN OTAKRI VOWEL SIGN AUTAKRI SIGN VIRAMATAKRI SIGN NUKTATAKRI" +
	" LETTER ARCHAIC KHATAKRI DIGIT ZEROTAKRI DIGIT ONETAKRI DIGIT TWOTAKRI D" +
	"IGIT THREETAKRI DIGIT FOURTAKRI DIGIT FIVETAKRI DIGIT SIXTAKRI DIGIT SEV" +
	"ENTAKRI DIGIT EIGHTTAKRI DIGIT NINEAHOM LETTER KAAHOM LETTER KHAAHOM LET" +
	"TER NGAAHOM LETTER NAAHOM LETTER TAAHOM LETTER ALTERNATE TAAHOM LETTER P" +
	"AAHOM LETTER PHAAHOM LETTER BAAHOM LETTER MAAHOM LETTER JAAHOM LETTER CH" +
	"AAHOM LETTER THAAHOM LETTER RAAHOM LETTER LAAHOM LETTER SAAHOM LETTER NY" +
	"AAHOM LETTER HAAHOM LETTER AAHOM LETTER DAAHOM LETTER DHAAHOM LETTER GAA" +
	"HOM LETTER ALTERNATE GAAHOM LETTER GHAAHOM LETTER BHAAHOM LETTER JHAAHOM" +
	" LETTER ALTERNATE BAAHOM CONSONANT SIGN MEDIAL LAAHOM CONSONANT SIGN MED" +
	"IAL RAAHOM CONSONANT SIGN MEDIAL LIGATING RAAHOM VOWEL SIGN AAHOM VOWEL " +
	"SIGN AAAHOM VOWEL SIGN IAHOM VOWEL SIGN IIAHOM VOWEL SIGN UAHOM VOWEL SI" +
	"GN UUAHOM VOWEL SIGN EAHOM VOWEL SIGN AWAHOM VOWEL SIGN OAHOM VOWEL SIGN" +
	" AIAHOM VOWEL SIGN AMAHOM SIGN KILLERAHOM DIGIT ZEROAHOM DIGIT ONEAHOM D" +
	"IGIT TWOAHOM DIGIT THREEAHOM DIGIT FOURAHOM DIGIT FIVEAHOM DIGIT SIXAHOM" +
	" DIGIT SEVENAHOM DIGIT EIGHTAHOM DIGIT NINEAHOM NUMBER TENAHOM NUMBER TW" +
	"ENTYAHOM SIGN SMALL SECTIONAHOM SIGN SECTIONAHOM SIGN RULAIAHOM SYMBOL V" +
	"IDOGRA LETTER ADOGRA LETTER AADOGRA LETTER IDOGRA LETTER IIDOGRA LETTER " +
	"UDOGRA LETTER UUDOGRA LETTER EDOGRA LETTER AIDOGRA LETTER ODOGRA LETTER " +
	"AUDOGRA LETTER KADOGRA LETTER KHADOGRA LETTER GADOGRA LETTER GHADOGRA LE" +
	"TTER NGADOGRA LETTER CADOGRA LETTER CHADOGRA LETTER JADOGRA LETTER JHADO" +
	"GRA LETTER NYADOGRA LETTER TTADOGRA LETTER TTHADOGRA LETTER DDADOGRA LET" +
	"TER DDHADOGRA LETTER NNADOGRA LETTER TADOGRA LETTER THADOGRA LETTER DADO" +
	"GRA LETTER DHADOGRA LETTER NADOGRA LETTER PADOGRA LETTER PHADOGRA LETTER" +
	" BADOGRA LETTER BHADOGRA LETTER MADOGRA LETTER YADOGRA LETTER RADOGRA LE" +
	"TTER LADOGRA LETTER VADOGRA LETTER SHADOGRA LETTER SSADOGRA LETTER SADOG" +
	"RA LETTER HADOGRA LETTER RRADOGRA VOWEL SIGN AADOGRA VOWEL SIGN IDOGRA V" +
	"OWEL SIGN IIDOGRA VOWEL SIGN UDOGRA VOWEL SIGN UUDOGRA VOWEL SIGN VOCALI" +
	"C RDOGRA VOWEL SIGN VOCALIC RRDOGRA VOWEL SIGN EDOGRA VOWEL SIGN AIDOGRA" +
	" VOWEL SIGN ODOGRA VOWEL SIGN AUDOGRA SIGN ANUSVARADOGRA SIGN VISARGADOG" +
	"RA SIGN VIRAMADOGRA SIGN NUKTADOGRA ABBREVIATION SIGNWARANG CITI CAPITAL" +
	" LETTER NGAAWARANG CITI CAPITAL LETTER AWARANG CITI CAPITAL LETTER WIWAR" +
	"ANG CITI CAPITAL LETTER YUWARANG CITI CAPITAL LETTER YAWARANG CITI CAPIT" +
	"AL LETTER YOWARANG CITI CAPITAL LETTER IIWARANG CITI CAPITAL LETTER UUWA" +
	"RANG CITI CAPITAL LETTER EWARANG CITI CAPITAL LETTER OWARANG CITI CAPITA" +
	"L LETTER ANGWARANG CITI CAPITAL LETTER GAWARANG CITI CAPITAL LETTER KOWA") + ("" +
	"RANG CITI CAPITAL LETTER ENYWARANG CITI CAPITAL LETTER YUJWARANG CITI CA" +
	"PITAL LETTER UCWARANG CITI CAPITAL LETTER ENNWARANG CITI CAPITAL LETTER " +
	"ODDWARANG CITI CAPITAL LETTER TTEWARANG CITI CAPITAL LETTER NUNGWARANG C" +
	"ITI CAPITAL LETTER DAWARANG CITI CAPITAL LETTER ATWARANG CITI CAPITAL LE" +
	"TTER AMWARANG CITI CAPITAL LETTER BUWARANG CITI CAPITAL LETTER PUWARANG " +
	"CITI CAPITAL LETTER HIYOWARANG CITI CAPITAL LETTER HOLOWARANG CITI CAPIT" +
	"AL LETTER HORRWARANG CITI CAPITAL LETTER HARWARANG CITI CAPITAL LETTER S" +
	"SUUWARANG CITI CAPITAL LETTER SIIWARANG CITI CAPITAL LETTER VIYOWARANG C" +
	"ITI SMALL LETTER NGAAWARANG CITI SMALL LETTER AWARANG CITI SMALL LETTER " +
	"WIWARANG CITI SMALL LETTER YUWARANG CITI SMALL LETTER YAWARANG CITI SMAL" +
	"L LETTER YOWARANG CITI SMALL LETTER IIWARANG CITI SMALL LETTER UUWARANG " +
	"CITI SMALL LETTER EWARANG CITI SMALL LETTER OWARANG CITI SMALL LETTER AN" +
	"GWARANG CITI SMALL LETTER GAWARANG CITI SMALL LETTER KOWARANG CITI SMALL" +
	" LETTER ENYWARANG CITI SMALL LETTER YUJWARANG CITI SMALL LETTER UCWARANG" +
	" CITI SMALL LETTER ENNWARANG CITI SMALL LETTER ODDWARANG CITI SMALL LETT" +
	"ER TTEWARANG CITI SMALL LETTER NUNGWARANG CITI SMALL LETTER DAWARANG CIT" +
	"I SMALL LETTER ATWARANG CITI SMALL LETTER AMWARANG CITI SMALL LETTER BUW" +
	"ARANG CITI SMALL LETTER PUWARANG CITI SMALL LETTER HIYOWARANG CITI SMALL" +
	" LETTER HOLOWARANG CITI SMALL LETTER HORRWARANG CITI SMALL LETTER HARWAR" +
	"ANG CITI SMALL LETTER SSUUWARANG CITI SMALL LETTER SIIWARANG CITI SMALL " +
	"LETTER VIYOWARANG CITI DIGIT ZEROWARANG CITI DIGIT ONEWARANG CITI DIGIT " +
	"TWOWARANG CITI DIGIT THREEWARANG CITI DIGIT FOURWARANG CITI DIGIT FIVEWA" +
	"RANG CITI DIGIT SIXWARANG CITI DIGIT SEVENWARANG CITI DIGIT EIGHTWARANG " +
	"CITI DIGIT NINEWARANG CITI NUMBER TENWARANG CITI NUMBER TWENTYWARANG CIT" +
	"I NUMBER THIRTYWARANG CITI NUMBER FORTYWARANG CITI NUMBER FIFTYWARANG CI" +
	"TI NUMBER SIXTYWARANG CITI NUMBER SEVENTYWARANG CITI NUMBER EIGHTYWARANG" +
	" CITI NUMBER NINETYWARANG CITI OMDIVES AKURU LETTER ADIVES AKURU LETTER " +
	"AADIVES AKURU LETTER IDIVES AKURU LETTER IIDIVES AKURU LETTER UDIVES AKU" +
	"RU LETTER UUDIVES AKURU LETTER EDIVES AKURU LETTER ODIVES AKURU LETTER K" +
	"ADIVES AKURU LETTER KHADIVES AKURU LETTER GADIVES AKURU LETTER GHADIVES " +
	"AKURU LETTER NGADIVES AKURU LETTER CADIVES AKURU LETTER CHADIVES AKURU L" +
	"ETTER JADIVES AKURU LETTER NYADIVES AKURU LETTER TTADIVES AKURU LETTER D" +
	"DADIVES AKURU LETTER DDHADIVES AKURU LETTER NNADIVES AKURU LETTER TADIVE" +
	"S AKURU LETTER THADIVES AKURU LETTER DADIVES AKURU LETTER DHADIVES AKURU" +
	" LETTER NADIVES AKURU LETTER PADIVES AKURU LETTER PHADIVES AKURU LETTER " +
	"BADIVES AKURU LETTER BHADIVES AKURU LETTER MADIVES AKURU LETTER YADIVES " +
	"AKURU LETTER YYADIVES AKURU LETTER RADIVES AKURU LETTER LADIVES AKURU LE" +
	"TTER VADIVES AKURU LETTER SHADIVES AKURU LETTER SSADIVES AKURU LETTER SA" +
	"DIVES AKURU LETTER HADIVES AKURU LETTER LLADIVES AKURU LETTER ZADIVES AK" +
	"URU VOWEL SIGN AADIVES AKURU VOWEL SIGN IDIVES AKURU VOWEL SIGN IIDIVES " +
	"AKURU VOWEL SIGN UDIVES AKURU VOWEL SIGN UUDIVES AKURU VOWEL SIGN EDIVES" +
	" AKURU VOWEL SIGN AIDIVES AKURU VOWEL SIGN ODIVES AKURU SIGN ANUSVARADIV" +
	"ES AKURU SIGN CANDRABINDUDIVES AKURU SIGN HALANTADIVES AKURU VIRAMADIVES" +
	" AKURU PREFIXED NASAL SIGNDIVES AKURU MEDIAL YADIVES AKURU INITIAL RADIV" +
	"ES AKURU MEDIAL RADIVES AKURU SIGN NUKTADIVES AKURU DOUBLE DANDADIVES AK" +
	"URU GAP FILLERDIVES AKURU END OF TEXT MARKDIVES AKURU DIGIT ZERODIVES AK" +
	"URU DIGIT ONEDIVES AKURU DIGIT TWODIVES AKURU DIGIT THREEDIVES AKURU DIG" +
	"IT FOURDIVES AKURU DIGIT FIVEDIVES AKURU DIGIT SIXDIVES AKURU DIGIT SEVE" +
	"NDIVES AKURU DIGIT EIGHTDIVES AKURU DIGIT NINENANDINAGARI LETTER ANANDIN" +
	"AGARI LETTER AANANDINAGARI LETTER INANDINAGARI LETTER IINANDINAGARI LETT" +
	"ER UNANDINAGARI LETTER UUNANDINAGARI LETTER VOCALIC RNANDINAGARI LETTER " +
	"VOCALIC RRNANDINAGARI LETTER ENANDINAGARI LETTER AINANDINAGARI LETTER ON" +
	"ANDINAGARI LETTER AUNANDINAGARI LETTER KANANDINAGARI LETTER KHANANDINAGA" +
	"RI LETTER GANANDINAGARI LETTER GHANANDINAGARI LETTER NGANANDINAGARI LETT" +
	"ER CANANDINAGARI LETTER CHANANDINAGARI LETTER JANANDINAGARI LETTER JHANA" +
	"NDINAGARI LETTER NYANANDINAGARI LETTER TTANANDINAGARI LETTER TTHANANDINA" +
	"GARI LETTER DDANANDINAGARI LETTER DDHANANDINAGARI LETTER NNANANDINAGARI " +
	"LETTER TANANDINAGARI LETTER THANANDINAGARI LETTER DANANDINAGARI LETTER D" +
	"HANANDINAGARI LETTER NANANDINAGARI LETTER PANANDINAGARI LETTER PHANANDIN" +
	"AGARI LETTER BANANDINAGARI LETTER BHANANDINAGARI LETTER MANANDINAGARI LE" +
	"TTER YANANDINAGARI LETTER RANANDINAGARI LETTER LANANDINAGARI LETTER VANA" +
	"NDINAGARI LETTER SHANANDINAGARI LETTER SSANANDINAGARI LETTER SANANDINAGA" +
	"RI LETTER HANANDINAGARI LETTER LLANANDINAGARI LETTER RRANANDINAGARI VOWE" +
	"L SIGN AANANDINAGARI VOWEL SIGN INANDINAGARI VOWEL SIGN IINANDINAGARI VO") + ("" +
	"WEL SIGN UNANDINAGARI VOWEL SIGN UUNANDINAGARI VOWEL SIGN VOCALIC RNANDI" +
	"NAGARI VOWEL SIGN VOCALIC RRNANDINAGARI VOWEL SIGN ENANDINAGARI VOWEL SI" +
	"GN AINANDINAGARI VOWEL SIGN ONANDINAGARI VOWEL SIGN AUNANDINAGARI SIGN A" +
	"NUSVARANANDINAGARI SIGN VISARGANANDINAGARI SIGN VIRAMANANDINAGARI SIGN A" +
	"VAGRAHANANDINAGARI SIGN SIDDHAMNANDINAGARI HEADSTROKENANDINAGARI VOWEL S" +
	"IGN PRISHTHAMATRA EZANABAZAR SQUARE LETTER AZANABAZAR SQUARE VOWEL SIGN " +
	"IZANABAZAR SQUARE VOWEL SIGN UEZANABAZAR SQUARE VOWEL SIGN UZANABAZAR SQ" +
	"UARE VOWEL SIGN EZANABAZAR SQUARE VOWEL SIGN OEZANABAZAR SQUARE VOWEL SI" +
	"GN OZANABAZAR SQUARE VOWEL SIGN AIZANABAZAR SQUARE VOWEL SIGN AUZANABAZA" +
	"R SQUARE VOWEL SIGN REVERSED IZANABAZAR SQUARE VOWEL LENGTH MARKZANABAZA" +
	"R SQUARE LETTER KAZANABAZAR SQUARE LETTER KHAZANABAZAR SQUARE LETTER GAZ" +
	"ANABAZAR SQUARE LETTER GHAZANABAZAR SQUARE LETTER NGAZANABAZAR SQUARE LE" +
	"TTER CAZANABAZAR SQUARE LETTER CHAZANABAZAR SQUARE LETTER JAZANABAZAR SQ" +
	"UARE LETTER NYAZANABAZAR SQUARE LETTER TTAZANABAZAR SQUARE LETTER TTHAZA" +
	"NABAZAR SQUARE LETTER DDAZANABAZAR SQUARE LETTER DDHAZANABAZAR SQUARE LE" +
	"TTER NNAZANABAZAR SQUARE LETTER TAZANABAZAR SQUARE LETTER THAZANABAZAR S" +
	"QUARE LETTER DAZANABAZAR SQUARE LETTER DHAZANABAZAR SQUARE LETTER NAZANA" +
	"BAZAR SQUARE LETTER PAZANABAZAR SQUARE LETTER PHAZANABAZAR SQUARE LETTER" +
	" BAZANABAZAR SQUARE LETTER BHAZANABAZAR SQUARE LETTER MAZANABAZAR SQUARE" +
	" LETTER TSAZANABAZAR SQUARE LETTER TSHAZANABAZAR SQUARE LETTER DZAZANABA" +
	"ZAR SQUARE LETTER DZHAZANABAZAR SQUARE LETTER ZHAZANABAZAR SQUARE LETTER" +
	" ZAZANABAZAR SQUARE LETTER -AZANABAZAR SQUARE LETTER YAZANABAZAR SQUARE " +
	"LETTER RAZANABAZAR SQUARE LETTER LAZANABAZAR SQUARE LETTER VAZANABAZAR S" +
	"QUARE LETTER SHAZANABAZAR SQUARE LETTER SSAZANABAZAR SQUARE LETTER SAZAN" +
	"ABAZAR SQUARE LETTER HAZANABAZAR SQUARE LETTER KSSAZANABAZAR SQUARE FINA" +
	"L CONSONANT MARKZANABAZAR SQUARE SIGN VIRAMAZANABAZAR SQUARE SIGN CANDRA" +
	"BINDUZANABAZAR SQUARE SIGN CANDRABINDU WITH ORNAMENTZANABAZAR SQUARE SIG" +
	"N CANDRA WITH ORNAMENTZANABAZAR SQUARE SIGN ANUSVARAZANABAZAR SQUARE SIG" +
	"N VISARGAZANABAZAR SQUARE CLUSTER-INITIAL LETTER RAZANABAZAR SQUARE CLUS" +
	"TER-FINAL LETTER YAZANABAZAR SQUARE CLUSTER-FINAL LETTER RAZANABAZAR SQU" +
	"ARE CLUSTER-FINAL LETTER LAZANABAZAR SQUARE CLUSTER-FINAL LETTER VAZANAB" +
	"AZAR SQUARE INITIAL HEAD MARKZANABAZAR SQUARE CLOSING HEAD MARKZANABAZAR" +
	" SQUARE MARK TSHEGZANABAZAR SQUARE MARK SHADZANABAZAR SQUARE MARK DOUBLE" +
	" SHADZANABAZAR SQUARE MARK LONG TSHEGZANABAZAR SQUARE INITIAL DOUBLE-LIN" +
	"ED HEAD MARKZANABAZAR SQUARE CLOSING DOUBLE-LINED HEAD MARKZANABAZAR SQU" +
	"ARE SUBJOINERSOYOMBO LETTER ASOYOMBO VOWEL SIGN ISOYOMBO VOWEL SIGN UESO" +
	"YOMBO VOWEL SIGN USOYOMBO VOWEL SIGN ESOYOMBO VOWEL SIGN OSOYOMBO VOWEL " +
	"SIGN OESOYOMBO VOWEL SIGN AISOYOMBO VOWEL SIGN AUSOYOMBO VOWEL SIGN VOCA" +
	"LIC RSOYOMBO VOWEL SIGN VOCALIC LSOYOMBO VOWEL LENGTH MARKSOYOMBO LETTER" +
	" KASOYOMBO LETTER KHASOYOMBO LETTER GASOYOMBO LETTER GHASOYOMBO LETTER N" +
	"GASOYOMBO LETTER CASOYOMBO LETTER CHASOYOMBO LETTER JASOYOMBO LETTER JHA" +
	"SOYOMBO LETTER NYASOYOMBO LETTER TTASOYOMBO LETTER TTHASOYOMBO LETTER DD" +
	"ASOYOMBO LETTER DDHASOYOMBO LETTER NNASOYOMBO LETTER TASOYOMBO LETTER TH" +
	"ASOYOMBO LETTER DASOYOMBO LETTER DHASOYOMBO LETTER NASOYOMBO LETTER PASO" +
	"YOMBO LETTER PHASOYOMBO LETTER BASOYOMBO LETTER BHASOYOMBO LETTER MASOYO" +
	"MBO LETTER TSASOYOMBO LETTER TSHASOYOMBO LETTER DZASOYOMBO LETTER ZHASOY" +
	"OMBO LETTER ZASOYOMBO LETTER -ASOYOMBO LETTER YASOYOMBO LETTER RASOYOMBO" +
	" LETTER LASOYOMBO LETTER VASOYOMBO LETTER SHASOYOMBO LETTER SSASOYOMBO L" +
	"ETTER SASOYOMBO LETTER HASOYOMBO LETTER KSSASOYOMBO SIGN JIHVAMULIYASOYO" +
	"MBO SIGN UPADHMANIYASOYOMBO CLUSTER-INITIAL LETTER RASOYOMBO CLUSTER-INI" +
	"TIAL LETTER LASOYOMBO CLUSTER-INITIAL LETTER SHASOYOMBO CLUSTER-INITIAL " +
	"LETTER SASOYOMBO FINAL CONSONANT SIGN GSOYOMBO FINAL CONSONANT SIGN KSOY" +
	"OMBO FINAL CONSONANT SIGN NGSOYOMBO FINAL CONSONANT SIGN DSOYOMBO FINAL " +
	"CONSONANT SIGN NSOYOMBO FINAL CONSONANT SIGN BSOYOMBO FINAL CONSONANT SI" +
	"GN MSOYOMBO FINAL CONSONANT SIGN RSOYOMBO FINAL CONSONANT SIGN LSOYOMBO " +
	"FINAL CONSONANT SIGN SHSOYOMBO FINAL CONSONANT SIGN SSOYOMBO FINAL CONSO" +
	"NANT SIGN -ASOYOMBO SIGN ANUSVARASOYOMBO SIGN VISARGASOYOMBO GEMINATION " +
	"MARKSOYOMBO SUBJOINERSOYOMBO MARK TSHEGSOYOMBO MARK SHADSOYOMBO MARK DOU" +
	"BLE SHADSOYOMBO MARK PLUTASOYOMBO HEAD MARK WITH MOON AND SUN AND TRIPLE" +
	" FLAMESOYOMBO HEAD MARK WITH MOON AND SUN AND FLAMESOYOMBO HEAD MARK WIT" +
	"H MOON AND SUNSOYOMBO TERMINAL MARK-1SOYOMBO TERMINAL MARK-2PAU CIN HAU " +
	"LETTER PAPAU CIN HAU LETTER KAPAU CIN HAU LETTER LAPAU CIN HAU LETTER MA" +
	"PAU CIN HAU LETTER DAPAU CIN HAU LETTER ZAPAU CIN HAU LETTER VAPAU CIN H" +
	"AU LETTER NGAPAU CIN HAU LETTER HAPAU CIN HAU LETTER GAPAU CIN HAU LETTE") + ("" +
	"R KHAPAU CIN HAU LETTER SAPAU CIN HAU LETTER BAPAU CIN HAU LETTER CAPAU " +
	"CIN HAU LETTER TAPAU CIN HAU LETTER THAPAU CIN HAU LETTER NAPAU CIN HAU " +
	"LETTER PHAPAU CIN HAU LETTER RAPAU CIN HAU LETTER FAPAU CIN HAU LETTER C" +
	"HAPAU CIN HAU LETTER APAU CIN HAU LETTER EPAU CIN HAU LETTER IPAU CIN HA" +
	"U LETTER OPAU CIN HAU LETTER UPAU CIN HAU LETTER UAPAU CIN HAU LETTER IA" +
	"PAU CIN HAU LETTER FINAL PPAU CIN HAU LETTER FINAL KPAU CIN HAU LETTER F" +
	"INAL TPAU CIN HAU LETTER FINAL MPAU CIN HAU LETTER FINAL NPAU CIN HAU LE" +
	"TTER FINAL LPAU CIN HAU LETTER FINAL WPAU CIN HAU LETTER FINAL NGPAU CIN" +
	" HAU LETTER FINAL YPAU CIN HAU RISING TONE LONGPAU CIN HAU RISING TONEPA" +
	"U CIN HAU SANDHI GLOTTAL STOPPAU CIN HAU RISING TONE LONG FINALPAU CIN H" +
	"AU RISING TONE FINALPAU CIN HAU SANDHI GLOTTAL STOP FINALPAU CIN HAU SAN" +
	"DHI TONE LONGPAU CIN HAU SANDHI TONEPAU CIN HAU SANDHI TONE LONG FINALPA" +
	"U CIN HAU SANDHI TONE FINALPAU CIN HAU MID-LEVEL TONEPAU CIN HAU GLOTTAL" +
	" STOP VARIANTPAU CIN HAU MID-LEVEL TONE LONG FINALPAU CIN HAU MID-LEVEL " +
	"TONE FINALPAU CIN HAU LOW-FALLING TONE LONGPAU CIN HAU LOW-FALLING TONEP" +
	"AU CIN HAU GLOTTAL STOPPAU CIN HAU LOW-FALLING TONE LONG FINALPAU CIN HA" +
	"U LOW-FALLING TONE FINALPAU CIN HAU GLOTTAL STOP FINALBHAIKSUKI LETTER A" +
	"BHAIKSUKI LETTER AABHAIKSUKI LETTER IBHAIKSUKI LETTER IIBHAIKSUKI LETTER" +
	" UBHAIKSUKI LETTER UUBHAIKSUKI LETTER VOCALIC RBHAIKSUKI LETTER VOCALIC " +
	"RRBHAIKSUKI LETTER VOCALIC LBHAIKSUKI LETTER EBHAIKSUKI LETTER AIBHAIKSU" +
	"KI LETTER OBHAIKSUKI LETTER AUBHAIKSUKI LETTER KABHAIKSUKI LETTER KHABHA" +
	"IKSUKI LETTER GABHAIKSUKI LETTER GHABHAIKSUKI LETTER NGABHAIKSUKI LETTER" +
	" CABHAIKSUKI LETTER CHABHAIKSUKI LETTER JABHAIKSUKI LETTER JHABHAIKSUKI " +
	"LETTER NYABHAIKSUKI LETTER TTABHAIKSUKI LETTER TTHABHAIKSUKI LETTER DDAB" +
	"HAIKSUKI LETTER DDHABHAIKSUKI LETTER NNABHAIKSUKI LETTER TABHAIKSUKI LET" +
	"TER THABHAIKSUKI LETTER DABHAIKSUKI LETTER DHABHAIKSUKI LETTER NABHAIKSU" +
	"KI LETTER PABHAIKSUKI LETTER PHABHAIKSUKI LETTER BABHAIKSUKI LETTER BHAB" +
	"HAIKSUKI LETTER MABHAIKSUKI LETTER YABHAIKSUKI LETTER RABHAIKSUKI LETTER" +
	" LABHAIKSUKI LETTER VABHAIKSUKI LETTER SHABHAIKSUKI LETTER SSABHAIKSUKI " +
	"LETTER SABHAIKSUKI LETTER HABHAIKSUKI VOWEL SIGN AABHAIKSUKI VOWEL SIGN " +
	"IBHAIKSUKI VOWEL SIGN IIBHAIKSUKI VOWEL SIGN UBHAIKSUKI VOWEL SIGN UUBHA" +
	"IKSUKI VOWEL SIGN VOCALIC RBHAIKSUKI VOWEL SIGN VOCALIC RRBHAIKSUKI VOWE" +
	"L SIGN VOCALIC LBHAIKSUKI VOWEL SIGN EBHAIKSUKI VOWEL SIGN AIBHAIKSUKI V" +
	"OWEL SIGN OBHAIKSUKI VOWEL SIGN AUBHAIKSUKI SIGN CANDRABINDUBHAIKSUKI SI" +
	"GN ANUSVARABHAIKSUKI SIGN VISARGABHAIKSUKI SIGN VIRAMABHAIKSUKI SIGN AVA" +
	"GRAHABHAIKSUKI DANDABHAIKSUKI DOUBLE DANDABHAIKSUKI WORD SEPARATORBHAIKS" +
	"UKI GAP FILLER-1BHAIKSUKI GAP FILLER-2BHAIKSUKI DIGIT ZEROBHAIKSUKI DIGI" +
	"T ONEBHAIKSUKI DIGIT TWOBHAIKSUKI DIGIT THREEBHAIKSUKI DIGIT FOURBHAIKSU" +
	"KI DIGIT FIVEBHAIKSUKI DIGIT SIXBHAIKSUKI DIGIT SEVENBHAIKSUKI DIGIT EIG" +
	"HTBHAIKSUKI DIGIT NINEBHAIKSUKI NUMBER ONEBHAIKSUKI NUMBER TWOBHAIKSUKI " +
	"NUMBER THREEBHAIKSUKI NUMBER FOURBHAIKSUKI NUMBER FIVEBHAIKSUKI NUMBER S" +
	"IXBHAIKSUKI NUMBER SEVENBHAIKSUKI NUMBER EIGHTBHAIKSUKI NUMBER NINEBHAIK" +
	"SUKI NUMBER TENBHAIKSUKI NUMBER TWENTYBHAIKSUKI NUMBER THIRTYBHAIKSUKI N" +
	"UMBER FORTYBHAIKSUKI NUMBER FIFTYBHAIKSUKI NUMBER SIXTYBHAIKSUKI NUMBER " +
	"SEVENTYBHAIKSUKI NUMBER EIGHTYBHAIKSUKI NUMBER NINETYBHAIKSUKI HUNDREDS " +
	"UNIT MARKMARCHEN HEAD MARKMARCHEN MARK SHADMARCHEN LETTER KAMARCHEN LETT" +
	"ER KHAMARCHEN LETTER GAMARCHEN LETTER NGAMARCHEN LETTER CAMARCHEN LETTER" +
	" CHAMARCHEN LETTER JAMARCHEN LETTER NYAMARCHEN LETTER TAMARCHEN LETTER T" +
	"HAMARCHEN LETTER DAMARCHEN LETTER NAMARCHEN LETTER PAMARCHEN LETTER PHAM" +
	"ARCHEN LETTER BAMARCHEN LETTER MAMARCHEN LETTER TSAMARCHEN LETTER TSHAMA" +
	"RCHEN LETTER DZAMARCHEN LETTER WAMARCHEN LETTER ZHAMARCHEN LETTER ZAMARC" +
	"HEN LETTER -AMARCHEN LETTER YAMARCHEN LETTER RAMARCHEN LETTER LAMARCHEN " +
	"LETTER SHAMARCHEN LETTER SAMARCHEN LETTER HAMARCHEN LETTER AMARCHEN SUBJ" +
	"OINED LETTER KAMARCHEN SUBJOINED LETTER KHAMARCHEN SUBJOINED LETTER GAMA" +
	"RCHEN SUBJOINED LETTER NGAMARCHEN SUBJOINED LETTER CAMARCHEN SUBJOINED L" +
	"ETTER CHAMARCHEN SUBJOINED LETTER JAMARCHEN SUBJOINED LETTER NYAMARCHEN " +
	"SUBJOINED LETTER TAMARCHEN SUBJOINED LETTER THAMARCHEN SUBJOINED LETTER " +
	"DAMARCHEN SUBJOINED LETTER NAMARCHEN SUBJOINED LETTER PAMARCHEN SUBJOINE" +
	"D LETTER PHAMARCHEN SUBJOINED LETTER BAMARCHEN SUBJOINED LETTER MAMARCHE" +
	"N SUBJOINED LETTER TSAMARCHEN SUBJOINED LETTER TSHAMARCHEN SUBJOINED LET" +
	"TER DZAMARCHEN SUBJOINED LETTER WAMARCHEN SUBJOINED LETTER ZHAMARCHEN SU" +
	"BJOINED LETTER ZAMARCHEN SUBJOINED LETTER YAMARCHEN SUBJOINED LETTER RAM" +
	"ARCHEN SUBJOINED LETTER LAMARCHEN SUBJOINED LETTER SHAMARCHEN SUBJOINED " +
	"LETTER SAMARCHEN SUBJOINED LETTER HAMARCHEN SUBJOINED LETTER AMARCHEN VO") + ("" +
	"WEL SIGN AAMARCHEN VOWEL SIGN IMARCHEN VOWEL SIGN UMARCHEN VOWEL SIGN EM" +
	"ARCHEN VOWEL SIGN OMARCHEN SIGN ANUSVARAMARCHEN SIGN CANDRABINDUMASARAM " +
	"GONDI LETTER AMASARAM GONDI LETTER AAMASARAM GONDI LETTER IMASARAM GONDI" +
	" LETTER IIMASARAM GONDI LETTER UMASARAM GONDI LETTER UUMASARAM GONDI LET" +
	"TER EMASARAM GONDI LETTER AIMASARAM GONDI LETTER OMASARAM GONDI LETTER A" +
	"UMASARAM GONDI LETTER KAMASARAM GONDI LETTER KHAMASARAM GONDI LETTER GAM" +
	"ASARAM GONDI LETTER GHAMASARAM GONDI LETTER NGAMASARAM GONDI LETTER CAMA" +
	"SARAM GONDI LETTER CHAMASARAM GONDI LETTER JAMASARAM GONDI LETTER JHAMAS" +
	"ARAM GONDI LETTER NYAMASARAM GONDI LETTER TTAMASARAM GONDI LETTER TTHAMA" +
	"SARAM GONDI LETTER DDAMASARAM GONDI LETTER DDHAMASARAM GONDI LETTER NNAM" +
	"ASARAM GONDI LETTER TAMASARAM GONDI LETTER THAMASARAM GONDI LETTER DAMAS" +
	"ARAM GONDI LETTER DHAMASARAM GONDI LETTER NAMASARAM GONDI LETTER PAMASAR" +
	"AM GONDI LETTER PHAMASARAM GONDI LETTER BAMASARAM GONDI LETTER BHAMASARA" +
	"M GONDI LETTER MAMASARAM GONDI LETTER YAMASARAM GONDI LETTER RAMASARAM G" +
	"ONDI LETTER LAMASARAM GONDI LETTER VAMASARAM GONDI LETTER SHAMASARAM GON" +
	"DI LETTER SSAMASARAM GONDI LETTER SAMASARAM GONDI LETTER HAMASARAM GONDI" +
	" LETTER LLAMASARAM GONDI LETTER KSSAMASARAM GONDI LETTER JNYAMASARAM GON" +
	"DI LETTER TRAMASARAM GONDI VOWEL SIGN AAMASARAM GONDI VOWEL SIGN IMASARA" +
	"M GONDI VOWEL SIGN IIMASARAM GONDI VOWEL SIGN UMASARAM GONDI VOWEL SIGN " +
	"UUMASARAM GONDI VOWEL SIGN VOCALIC RMASARAM GONDI VOWEL SIGN EMASARAM GO" +
	"NDI VOWEL SIGN AIMASARAM GONDI VOWEL SIGN OMASARAM GONDI VOWEL SIGN AUMA" +
	"SARAM GONDI SIGN ANUSVARAMASARAM GONDI SIGN VISARGAMASARAM GONDI SIGN NU" +
	"KTAMASARAM GONDI SIGN CANDRAMASARAM GONDI SIGN HALANTAMASARAM GONDI VIRA" +
	"MAMASARAM GONDI REPHAMASARAM GONDI RA-KARAMASARAM GONDI DIGIT ZEROMASARA" +
	"M GONDI DIGIT ONEMASARAM GONDI DIGIT TWOMASARAM GONDI DIGIT THREEMASARAM" +
	" GONDI DIGIT FOURMASARAM GONDI DIGIT FIVEMASARAM GONDI DIGIT SIXMASARAM " +
	"GONDI DIGIT SEVENMASARAM GONDI DIGIT EIGHTMASARAM GONDI DIGIT NINEGUNJAL" +
	"A GONDI LETTER AGUNJALA GONDI LETTER AAGUNJALA GONDI LETTER IGUNJALA GON" +
	"DI LETTER IIGUNJALA GONDI LETTER UGUNJALA GONDI LETTER UUGUNJALA GONDI L" +
	"ETTER EEGUNJALA GONDI LETTER AIGUNJALA GONDI LETTER OOGUNJALA GONDI LETT" +
	"ER AUGUNJALA GONDI LETTER YAGUNJALA GONDI LETTER VAGUNJALA GONDI LETTER " +
	"BAGUNJALA GONDI LETTER BHAGUNJALA GONDI LETTER MAGUNJALA GONDI LETTER KA" +
	"GUNJALA GONDI LETTER KHAGUNJALA GONDI LETTER TAGUNJALA GONDI LETTER THAG" +
	"UNJALA GONDI LETTER LAGUNJALA GONDI LETTER GAGUNJALA GONDI LETTER GHAGUN" +
	"JALA GONDI LETTER DAGUNJALA GONDI LETTER DHAGUNJALA GONDI LETTER NAGUNJA" +
	"LA GONDI LETTER CAGUNJALA GONDI LETTER CHAGUNJALA GONDI LETTER TTAGUNJAL" +
	"A GONDI LETTER TTHAGUNJALA GONDI LETTER LLAGUNJALA GONDI LETTER JAGUNJAL" +
	"A GONDI LETTER JHAGUNJALA GONDI LETTER DDAGUNJALA GONDI LETTER DDHAGUNJA" +
	"LA GONDI LETTER NGAGUNJALA GONDI LETTER PAGUNJALA GONDI LETTER PHAGUNJAL" +
	"A GONDI LETTER HAGUNJALA GONDI LETTER RAGUNJALA GONDI LETTER SAGUNJALA G" +
	"ONDI VOWEL SIGN AAGUNJALA GONDI VOWEL SIGN IGUNJALA GONDI VOWEL SIGN IIG" +
	"UNJALA GONDI VOWEL SIGN UGUNJALA GONDI VOWEL SIGN UUGUNJALA GONDI VOWEL " +
	"SIGN EEGUNJALA GONDI VOWEL SIGN AIGUNJALA GONDI VOWEL SIGN OOGUNJALA GON" +
	"DI VOWEL SIGN AUGUNJALA GONDI SIGN ANUSVARAGUNJALA GONDI SIGN VISARGAGUN" +
	"JALA GONDI VIRAMAGUNJALA GONDI OMGUNJALA GONDI DIGIT ZEROGUNJALA GONDI D" +
	"IGIT ONEGUNJALA GONDI DIGIT TWOGUNJALA GONDI DIGIT THREEGUNJALA GONDI DI" +
	"GIT FOURGUNJALA GONDI DIGIT FIVEGUNJALA GONDI DIGIT SIXGUNJALA GONDI DIG" +
	"IT SEVENGUNJALA GONDI DIGIT EIGHTGUNJALA GONDI DIGIT NINEMAKASAR LETTER " +
	"KAMAKASAR LETTER GAMAKASAR LETTER NGAMAKASAR LETTER PAMAKASAR LETTER BAM" +
	"AKASAR LETTER MAMAKASAR LETTER TAMAKASAR LETTER DAMAKASAR LETTER NAMAKAS" +
	"AR LETTER CAMAKASAR LETTER JAMAKASAR LETTER NYAMAKASAR LETTER YAMAKASAR " +
	"LETTER RAMAKASAR LETTER LAMAKASAR LETTER VAMAKASAR LETTER SAMAKASAR LETT" +
	"ER AMAKASAR ANGKAMAKASAR VOWEL SIGN IMAKASAR VOWEL SIGN UMAKASAR VOWEL S" +
	"IGN EMAKASAR VOWEL SIGN OMAKASAR PASSIMBANGMAKASAR END OF SECTIONLISU LE" +
	"TTER YHATAMIL FRACTION ONE THREE-HUNDRED-AND-TWENTIETHTAMIL FRACTION ONE" +
	" ONE-HUNDRED-AND-SIXTIETHTAMIL FRACTION ONE EIGHTIETHTAMIL FRACTION ONE " +
	"SIXTY-FOURTHTAMIL FRACTION ONE FORTIETHTAMIL FRACTION ONE THIRTY-SECONDT" +
	"AMIL FRACTION THREE EIGHTIETHSTAMIL FRACTION THREE SIXTY-FOURTHSTAMIL FR" +
	"ACTION ONE TWENTIETHTAMIL FRACTION ONE SIXTEENTH-1TAMIL FRACTION ONE SIX" +
	"TEENTH-2TAMIL FRACTION ONE TENTHTAMIL FRACTION ONE EIGHTHTAMIL FRACTION " +
	"THREE TWENTIETHSTAMIL FRACTION THREE SIXTEENTHSTAMIL FRACTION ONE FIFTHT" +
	"AMIL FRACTION ONE QUARTERTAMIL FRACTION ONE HALF-1TAMIL FRACTION ONE HAL" +
	"F-2TAMIL FRACTION THREE QUARTERSTAMIL FRACTION DOWNSCALING FACTOR KIIZHT" +
	"AMIL SIGN NELTAMIL SIGN CEVITUTAMIL SIGN AAZHAAKKUTAMIL SIGN UZHAKKUTAMI") + ("" +
	"L SIGN MUUVUZHAKKUTAMIL SIGN KURUNITAMIL SIGN PATHAKKUTAMIL SIGN MUKKURU" +
	"NITAMIL SIGN KAACUTAMIL SIGN PANAMTAMIL SIGN PONTAMIL SIGN VARAAKANTAMIL" +
	" SIGN PAARAMTAMIL SIGN KUZHITAMIL SIGN VELITAMIL WET CULTIVATION SIGNTAM" +
	"IL DRY CULTIVATION SIGNTAMIL LAND SIGNTAMIL SALT PAN SIGNTAMIL TRADITION" +
	"AL CREDIT SIGNTAMIL TRADITIONAL NUMBER SIGNTAMIL CURRENT SIGNTAMIL AND O" +
	"DD SIGNTAMIL SPENT SIGNTAMIL TOTAL SIGNTAMIL IN POSSESSION SIGNTAMIL STA" +
	"RTING FROM SIGNTAMIL SIGN MUTHALIYATAMIL SIGN VAKAIYARAATAMIL PUNCTUATIO" +
	"N END OF TEXTCUNEIFORM SIGN ACUNEIFORM SIGN A TIMES ACUNEIFORM SIGN A TI" +
	"MES BADCUNEIFORM SIGN A TIMES GAN2 TENUCUNEIFORM SIGN A TIMES HACUNEIFOR" +
	"M SIGN A TIMES IGICUNEIFORM SIGN A TIMES LAGAR GUNUCUNEIFORM SIGN A TIME" +
	"S MUSHCUNEIFORM SIGN A TIMES SAGCUNEIFORM SIGN A2CUNEIFORM SIGN ABCUNEIF" +
	"ORM SIGN AB TIMES ASH2CUNEIFORM SIGN AB TIMES DUN3 GUNUCUNEIFORM SIGN AB" +
	" TIMES GALCUNEIFORM SIGN AB TIMES GAN2 TENUCUNEIFORM SIGN AB TIMES HACUN" +
	"EIFORM SIGN AB TIMES IGI GUNUCUNEIFORM SIGN AB TIMES IMINCUNEIFORM SIGN " +
	"AB TIMES LAGABCUNEIFORM SIGN AB TIMES SHESHCUNEIFORM SIGN AB TIMES U PLU" +
	"S U PLUS UCUNEIFORM SIGN AB GUNUCUNEIFORM SIGN AB2CUNEIFORM SIGN AB2 TIM" +
	"ES BALAGCUNEIFORM SIGN AB2 TIMES GAN2 TENUCUNEIFORM SIGN AB2 TIMES ME PL" +
	"US ENCUNEIFORM SIGN AB2 TIMES SHA3CUNEIFORM SIGN AB2 TIMES TAK4CUNEIFORM" +
	" SIGN ADCUNEIFORM SIGN AKCUNEIFORM SIGN AK TIMES ERIN2CUNEIFORM SIGN AK " +
	"TIMES SHITA PLUS GISHCUNEIFORM SIGN ALCUNEIFORM SIGN AL TIMES ALCUNEIFOR" +
	"M SIGN AL TIMES DIM2CUNEIFORM SIGN AL TIMES GISHCUNEIFORM SIGN AL TIMES " +
	"HACUNEIFORM SIGN AL TIMES KAD3CUNEIFORM SIGN AL TIMES KICUNEIFORM SIGN A" +
	"L TIMES SHECUNEIFORM SIGN AL TIMES USHCUNEIFORM SIGN ALANCUNEIFORM SIGN " +
	"ALEPHCUNEIFORM SIGN AMARCUNEIFORM SIGN AMAR TIMES SHECUNEIFORM SIGN ANCU" +
	"NEIFORM SIGN AN OVER ANCUNEIFORM SIGN AN THREE TIMESCUNEIFORM SIGN AN PL" +
	"US NAGA OPPOSING AN PLUS NAGACUNEIFORM SIGN AN PLUS NAGA SQUAREDCUNEIFOR" +
	"M SIGN ANSHECUNEIFORM SIGN APINCUNEIFORM SIGN ARADCUNEIFORM SIGN ARAD TI" +
	"MES KURCUNEIFORM SIGN ARKABCUNEIFORM SIGN ASAL2CUNEIFORM SIGN ASHCUNEIFO" +
	"RM SIGN ASH ZIDA TENUCUNEIFORM SIGN ASH KABA TENUCUNEIFORM SIGN ASH OVER" +
	" ASH TUG2 OVER TUG2 TUG2 OVER TUG2 PAPCUNEIFORM SIGN ASH OVER ASH OVER A" +
	"SHCUNEIFORM SIGN ASH OVER ASH OVER ASH CROSSING ASH OVER ASH OVER ASHCUN" +
	"EIFORM SIGN ASH2CUNEIFORM SIGN ASHGABCUNEIFORM SIGN BACUNEIFORM SIGN BAD" +
	"CUNEIFORM SIGN BAG3CUNEIFORM SIGN BAHAR2CUNEIFORM SIGN BALCUNEIFORM SIGN" +
	" BAL OVER BALCUNEIFORM SIGN BALAGCUNEIFORM SIGN BARCUNEIFORM SIGN BARA2C" +
	"UNEIFORM SIGN BICUNEIFORM SIGN BI TIMES ACUNEIFORM SIGN BI TIMES GARCUNE" +
	"IFORM SIGN BI TIMES IGI GUNUCUNEIFORM SIGN BUCUNEIFORM SIGN BU OVER BU A" +
	"BCUNEIFORM SIGN BU OVER BU UNCUNEIFORM SIGN BU CROSSING BUCUNEIFORM SIGN" +
	" BULUGCUNEIFORM SIGN BULUG OVER BULUGCUNEIFORM SIGN BURCUNEIFORM SIGN BU" +
	"R2CUNEIFORM SIGN DACUNEIFORM SIGN DAGCUNEIFORM SIGN DAG KISIM5 TIMES A P" +
	"LUS MASHCUNEIFORM SIGN DAG KISIM5 TIMES AMARCUNEIFORM SIGN DAG KISIM5 TI" +
	"MES BALAGCUNEIFORM SIGN DAG KISIM5 TIMES BICUNEIFORM SIGN DAG KISIM5 TIM" +
	"ES GACUNEIFORM SIGN DAG KISIM5 TIMES GA PLUS MASHCUNEIFORM SIGN DAG KISI" +
	"M5 TIMES GICUNEIFORM SIGN DAG KISIM5 TIMES GIR2CUNEIFORM SIGN DAG KISIM5" +
	" TIMES GUDCUNEIFORM SIGN DAG KISIM5 TIMES HACUNEIFORM SIGN DAG KISIM5 TI" +
	"MES IRCUNEIFORM SIGN DAG KISIM5 TIMES IR PLUS LUCUNEIFORM SIGN DAG KISIM" +
	"5 TIMES KAKCUNEIFORM SIGN DAG KISIM5 TIMES LACUNEIFORM SIGN DAG KISIM5 T" +
	"IMES LUCUNEIFORM SIGN DAG KISIM5 TIMES LU PLUS MASH2CUNEIFORM SIGN DAG K" +
	"ISIM5 TIMES LUMCUNEIFORM SIGN DAG KISIM5 TIMES NECUNEIFORM SIGN DAG KISI" +
	"M5 TIMES PAP PLUS PAPCUNEIFORM SIGN DAG KISIM5 TIMES SICUNEIFORM SIGN DA" +
	"G KISIM5 TIMES TAK4CUNEIFORM SIGN DAG KISIM5 TIMES U2 PLUS GIR2CUNEIFORM" +
	" SIGN DAG KISIM5 TIMES USHCUNEIFORM SIGN DAMCUNEIFORM SIGN DARCUNEIFORM " +
	"SIGN DARA3CUNEIFORM SIGN DARA4CUNEIFORM SIGN DICUNEIFORM SIGN DIBCUNEIFO" +
	"RM SIGN DIMCUNEIFORM SIGN DIM TIMES SHECUNEIFORM SIGN DIM2CUNEIFORM SIGN" +
	" DINCUNEIFORM SIGN DIN KASKAL U GUNU DISHCUNEIFORM SIGN DISHCUNEIFORM SI" +
	"GN DUCUNEIFORM SIGN DU OVER DUCUNEIFORM SIGN DU GUNUCUNEIFORM SIGN DU SH" +
	"ESHIGCUNEIFORM SIGN DUBCUNEIFORM SIGN DUB TIMES ESH2CUNEIFORM SIGN DUB2C" +
	"UNEIFORM SIGN DUGCUNEIFORM SIGN DUGUDCUNEIFORM SIGN DUHCUNEIFORM SIGN DU" +
	"NCUNEIFORM SIGN DUN3CUNEIFORM SIGN DUN3 GUNUCUNEIFORM SIGN DUN3 GUNU GUN" +
	"UCUNEIFORM SIGN DUN4CUNEIFORM SIGN DUR2CUNEIFORM SIGN ECUNEIFORM SIGN E " +
	"TIMES PAPCUNEIFORM SIGN E OVER E NUN OVER NUNCUNEIFORM SIGN E2CUNEIFORM " +
	"SIGN E2 TIMES A PLUS HA PLUS DACUNEIFORM SIGN E2 TIMES GARCUNEIFORM SIGN" +
	" E2 TIMES MICUNEIFORM SIGN E2 TIMES SALCUNEIFORM SIGN E2 TIMES SHECUNEIF" +
	"ORM SIGN E2 TIMES UCUNEIFORM SIGN EDINCUNEIFORM SIGN EGIRCUNEIFORM SIGN " +
	"ELCUNEIFORM SIGN ENCUNEIFORM SIGN EN TIMES GAN2CUNEIFORM SIGN EN TIMES G") + ("" +
	"AN2 TENUCUNEIFORM SIGN EN TIMES MECUNEIFORM SIGN EN CROSSING ENCUNEIFORM" +
	" SIGN EN OPPOSING ENCUNEIFORM SIGN EN SQUAREDCUNEIFORM SIGN ERENCUNEIFOR" +
	"M SIGN ERIN2CUNEIFORM SIGN ESH2CUNEIFORM SIGN EZENCUNEIFORM SIGN EZEN TI" +
	"MES ACUNEIFORM SIGN EZEN TIMES A PLUS LALCUNEIFORM SIGN EZEN TIMES A PLU" +
	"S LAL TIMES LALCUNEIFORM SIGN EZEN TIMES ANCUNEIFORM SIGN EZEN TIMES BAD" +
	"CUNEIFORM SIGN EZEN TIMES DUN3 GUNUCUNEIFORM SIGN EZEN TIMES DUN3 GUNU G" +
	"UNUCUNEIFORM SIGN EZEN TIMES HACUNEIFORM SIGN EZEN TIMES HA GUNUCUNEIFOR" +
	"M SIGN EZEN TIMES IGI GUNUCUNEIFORM SIGN EZEN TIMES KASKALCUNEIFORM SIGN" +
	" EZEN TIMES KASKAL SQUAREDCUNEIFORM SIGN EZEN TIMES KU3CUNEIFORM SIGN EZ" +
	"EN TIMES LACUNEIFORM SIGN EZEN TIMES LAL TIMES LALCUNEIFORM SIGN EZEN TI" +
	"MES LICUNEIFORM SIGN EZEN TIMES LUCUNEIFORM SIGN EZEN TIMES U2CUNEIFORM " +
	"SIGN EZEN TIMES UDCUNEIFORM SIGN GACUNEIFORM SIGN GA GUNUCUNEIFORM SIGN " +
	"GA2CUNEIFORM SIGN GA2 TIMES A PLUS DA PLUS HACUNEIFORM SIGN GA2 TIMES A " +
	"PLUS HACUNEIFORM SIGN GA2 TIMES A PLUS IGICUNEIFORM SIGN GA2 TIMES AB2 T" +
	"ENU PLUS TABCUNEIFORM SIGN GA2 TIMES ANCUNEIFORM SIGN GA2 TIMES ASHCUNEI" +
	"FORM SIGN GA2 TIMES ASH2 PLUS GALCUNEIFORM SIGN GA2 TIMES BADCUNEIFORM S" +
	"IGN GA2 TIMES BAR PLUS RACUNEIFORM SIGN GA2 TIMES BURCUNEIFORM SIGN GA2 " +
	"TIMES BUR PLUS RACUNEIFORM SIGN GA2 TIMES DACUNEIFORM SIGN GA2 TIMES DIC" +
	"UNEIFORM SIGN GA2 TIMES DIM TIMES SHECUNEIFORM SIGN GA2 TIMES DUBCUNEIFO" +
	"RM SIGN GA2 TIMES ELCUNEIFORM SIGN GA2 TIMES EL PLUS LACUNEIFORM SIGN GA" +
	"2 TIMES ENCUNEIFORM SIGN GA2 TIMES EN TIMES GAN2 TENUCUNEIFORM SIGN GA2 " +
	"TIMES GAN2 TENUCUNEIFORM SIGN GA2 TIMES GARCUNEIFORM SIGN GA2 TIMES GICU" +
	"NEIFORM SIGN GA2 TIMES GI4CUNEIFORM SIGN GA2 TIMES GI4 PLUS ACUNEIFORM S" +
	"IGN GA2 TIMES GIR2 PLUS SUCUNEIFORM SIGN GA2 TIMES HA PLUS LU PLUS ESH2C" +
	"UNEIFORM SIGN GA2 TIMES HALCUNEIFORM SIGN GA2 TIMES HAL PLUS LACUNEIFORM" +
	" SIGN GA2 TIMES HI PLUS LICUNEIFORM SIGN GA2 TIMES HUB2CUNEIFORM SIGN GA" +
	"2 TIMES IGI GUNUCUNEIFORM SIGN GA2 TIMES ISH PLUS HU PLUS ASHCUNEIFORM S" +
	"IGN GA2 TIMES KAKCUNEIFORM SIGN GA2 TIMES KASKALCUNEIFORM SIGN GA2 TIMES" +
	" KIDCUNEIFORM SIGN GA2 TIMES KID PLUS LALCUNEIFORM SIGN GA2 TIMES KU3 PL" +
	"US ANCUNEIFORM SIGN GA2 TIMES LACUNEIFORM SIGN GA2 TIMES ME PLUS ENCUNEI" +
	"FORM SIGN GA2 TIMES MICUNEIFORM SIGN GA2 TIMES NUNCUNEIFORM SIGN GA2 TIM" +
	"ES NUN OVER NUNCUNEIFORM SIGN GA2 TIMES PACUNEIFORM SIGN GA2 TIMES SALCU" +
	"NEIFORM SIGN GA2 TIMES SARCUNEIFORM SIGN GA2 TIMES SHECUNEIFORM SIGN GA2" +
	" TIMES SHE PLUS TURCUNEIFORM SIGN GA2 TIMES SHIDCUNEIFORM SIGN GA2 TIMES" +
	" SUMCUNEIFORM SIGN GA2 TIMES TAK4CUNEIFORM SIGN GA2 TIMES UCUNEIFORM SIG" +
	"N GA2 TIMES UDCUNEIFORM SIGN GA2 TIMES UD PLUS DUCUNEIFORM SIGN GA2 OVER" +
	" GA2CUNEIFORM SIGN GABACUNEIFORM SIGN GABA CROSSING GABACUNEIFORM SIGN G" +
	"ADCUNEIFORM SIGN GAD OVER GAD GAR OVER GARCUNEIFORM SIGN GALCUNEIFORM SI" +
	"GN GAL GAD OVER GAD GAR OVER GARCUNEIFORM SIGN GALAMCUNEIFORM SIGN GAMCU" +
	"NEIFORM SIGN GANCUNEIFORM SIGN GAN2CUNEIFORM SIGN GAN2 TENUCUNEIFORM SIG" +
	"N GAN2 OVER GAN2CUNEIFORM SIGN GAN2 CROSSING GAN2CUNEIFORM SIGN GARCUNEI" +
	"FORM SIGN GAR3CUNEIFORM SIGN GASHANCUNEIFORM SIGN GESHTINCUNEIFORM SIGN " +
	"GESHTIN TIMES KURCUNEIFORM SIGN GICUNEIFORM SIGN GI TIMES ECUNEIFORM SIG" +
	"N GI TIMES UCUNEIFORM SIGN GI CROSSING GICUNEIFORM SIGN GI4CUNEIFORM SIG" +
	"N GI4 OVER GI4CUNEIFORM SIGN GI4 CROSSING GI4CUNEIFORM SIGN GIDIMCUNEIFO" +
	"RM SIGN GIR2CUNEIFORM SIGN GIR2 GUNUCUNEIFORM SIGN GIR3CUNEIFORM SIGN GI" +
	"R3 TIMES A PLUS IGICUNEIFORM SIGN GIR3 TIMES GAN2 TENUCUNEIFORM SIGN GIR" +
	"3 TIMES IGICUNEIFORM SIGN GIR3 TIMES LU PLUS IGICUNEIFORM SIGN GIR3 TIME" +
	"S PACUNEIFORM SIGN GISALCUNEIFORM SIGN GISHCUNEIFORM SIGN GISH CROSSING " +
	"GISHCUNEIFORM SIGN GISH TIMES BADCUNEIFORM SIGN GISH TIMES TAK4CUNEIFORM" +
	" SIGN GISH TENUCUNEIFORM SIGN GUCUNEIFORM SIGN GU CROSSING GUCUNEIFORM S" +
	"IGN GU2CUNEIFORM SIGN GU2 TIMES KAKCUNEIFORM SIGN GU2 TIMES KAK TIMES IG" +
	"I GUNUCUNEIFORM SIGN GU2 TIMES NUNCUNEIFORM SIGN GU2 TIMES SAL PLUS TUG2" +
	"CUNEIFORM SIGN GU2 GUNUCUNEIFORM SIGN GUDCUNEIFORM SIGN GUD TIMES A PLUS" +
	" KURCUNEIFORM SIGN GUD TIMES KURCUNEIFORM SIGN GUD OVER GUD LUGALCUNEIFO" +
	"RM SIGN GULCUNEIFORM SIGN GUMCUNEIFORM SIGN GUM TIMES SHECUNEIFORM SIGN " +
	"GURCUNEIFORM SIGN GUR7CUNEIFORM SIGN GURUNCUNEIFORM SIGN GURUSHCUNEIFORM" +
	" SIGN HACUNEIFORM SIGN HA TENUCUNEIFORM SIGN HA GUNUCUNEIFORM SIGN HALCU" +
	"NEIFORM SIGN HICUNEIFORM SIGN HI TIMES ASHCUNEIFORM SIGN HI TIMES ASH2CU" +
	"NEIFORM SIGN HI TIMES BADCUNEIFORM SIGN HI TIMES DISHCUNEIFORM SIGN HI T" +
	"IMES GADCUNEIFORM SIGN HI TIMES KINCUNEIFORM SIGN HI TIMES NUNCUNEIFORM " +
	"SIGN HI TIMES SHECUNEIFORM SIGN HI TIMES UCUNEIFORM SIGN HUCUNEIFORM SIG" +
	"N HUB2CUNEIFORM SIGN HUB2 TIMES ANCUNEIFORM SIGN HUB2 TIMES HALCUNEIFORM" +
	" SIGN HUB2 TIMES KASKALCUNEIFORM SIGN HUB2 TIMES LISHCUNEIFORM SIGN HUB2") + ("" +
	" TIMES UDCUNEIFORM SIGN HUL2CUNEIFORM SIGN ICUNEIFORM SIGN I ACUNEIFORM " +
	"SIGN IBCUNEIFORM SIGN IDIMCUNEIFORM SIGN IDIM OVER IDIM BURCUNEIFORM SIG" +
	"N IDIM OVER IDIM SQUAREDCUNEIFORM SIGN IGCUNEIFORM SIGN IGICUNEIFORM SIG" +
	"N IGI DIBCUNEIFORM SIGN IGI RICUNEIFORM SIGN IGI OVER IGI SHIR OVER SHIR" +
	" UD OVER UDCUNEIFORM SIGN IGI GUNUCUNEIFORM SIGN ILCUNEIFORM SIGN IL TIM" +
	"ES GAN2 TENUCUNEIFORM SIGN IL2CUNEIFORM SIGN IMCUNEIFORM SIGN IM TIMES T" +
	"AK4CUNEIFORM SIGN IM CROSSING IMCUNEIFORM SIGN IM OPPOSING IMCUNEIFORM S" +
	"IGN IM SQUAREDCUNEIFORM SIGN IMINCUNEIFORM SIGN INCUNEIFORM SIGN IRCUNEI" +
	"FORM SIGN ISHCUNEIFORM SIGN KACUNEIFORM SIGN KA TIMES ACUNEIFORM SIGN KA" +
	" TIMES ADCUNEIFORM SIGN KA TIMES AD PLUS KU3CUNEIFORM SIGN KA TIMES ASH2" +
	"CUNEIFORM SIGN KA TIMES BADCUNEIFORM SIGN KA TIMES BALAGCUNEIFORM SIGN K" +
	"A TIMES BARCUNEIFORM SIGN KA TIMES BICUNEIFORM SIGN KA TIMES ERIN2CUNEIF" +
	"ORM SIGN KA TIMES ESH2CUNEIFORM SIGN KA TIMES GACUNEIFORM SIGN KA TIMES " +
	"GALCUNEIFORM SIGN KA TIMES GAN2 TENUCUNEIFORM SIGN KA TIMES GARCUNEIFORM" +
	" SIGN KA TIMES GAR PLUS SHA3 PLUS ACUNEIFORM SIGN KA TIMES GICUNEIFORM S" +
	"IGN KA TIMES GIR2CUNEIFORM SIGN KA TIMES GISH PLUS SARCUNEIFORM SIGN KA " +
	"TIMES GISH CROSSING GISHCUNEIFORM SIGN KA TIMES GUCUNEIFORM SIGN KA TIME" +
	"S GUR7CUNEIFORM SIGN KA TIMES IGICUNEIFORM SIGN KA TIMES IMCUNEIFORM SIG" +
	"N KA TIMES KAKCUNEIFORM SIGN KA TIMES KICUNEIFORM SIGN KA TIMES KIDCUNEI" +
	"FORM SIGN KA TIMES LICUNEIFORM SIGN KA TIMES LUCUNEIFORM SIGN KA TIMES M" +
	"ECUNEIFORM SIGN KA TIMES ME PLUS DUCUNEIFORM SIGN KA TIMES ME PLUS GICUN" +
	"EIFORM SIGN KA TIMES ME PLUS TECUNEIFORM SIGN KA TIMES MICUNEIFORM SIGN " +
	"KA TIMES MI PLUS NUNUZCUNEIFORM SIGN KA TIMES NECUNEIFORM SIGN KA TIMES " +
	"NUNCUNEIFORM SIGN KA TIMES PICUNEIFORM SIGN KA TIMES RUCUNEIFORM SIGN KA" +
	" TIMES SACUNEIFORM SIGN KA TIMES SARCUNEIFORM SIGN KA TIMES SHACUNEIFORM" +
	" SIGN KA TIMES SHECUNEIFORM SIGN KA TIMES SHIDCUNEIFORM SIGN KA TIMES SH" +
	"UCUNEIFORM SIGN KA TIMES SIGCUNEIFORM SIGN KA TIMES SUHURCUNEIFORM SIGN " +
	"KA TIMES TARCUNEIFORM SIGN KA TIMES UCUNEIFORM SIGN KA TIMES U2CUNEIFORM" +
	" SIGN KA TIMES UDCUNEIFORM SIGN KA TIMES UMUM TIMES PACUNEIFORM SIGN KA " +
	"TIMES USHCUNEIFORM SIGN KA TIMES ZICUNEIFORM SIGN KA2CUNEIFORM SIGN KA2 " +
	"CROSSING KA2CUNEIFORM SIGN KABCUNEIFORM SIGN KAD2CUNEIFORM SIGN KAD3CUNE" +
	"IFORM SIGN KAD4CUNEIFORM SIGN KAD5CUNEIFORM SIGN KAD5 OVER KAD5CUNEIFORM" +
	" SIGN KAKCUNEIFORM SIGN KAK TIMES IGI GUNUCUNEIFORM SIGN KALCUNEIFORM SI" +
	"GN KAL TIMES BADCUNEIFORM SIGN KAL CROSSING KALCUNEIFORM SIGN KAM2CUNEIF" +
	"ORM SIGN KAM4CUNEIFORM SIGN KASKALCUNEIFORM SIGN KASKAL LAGAB TIMES U OV" +
	"ER LAGAB TIMES UCUNEIFORM SIGN KASKAL OVER KASKAL LAGAB TIMES U OVER LAG" +
	"AB TIMES UCUNEIFORM SIGN KESH2CUNEIFORM SIGN KICUNEIFORM SIGN KI TIMES B" +
	"ADCUNEIFORM SIGN KI TIMES UCUNEIFORM SIGN KI TIMES UDCUNEIFORM SIGN KIDC" +
	"UNEIFORM SIGN KINCUNEIFORM SIGN KISALCUNEIFORM SIGN KISHCUNEIFORM SIGN K" +
	"ISIM5CUNEIFORM SIGN KISIM5 OVER KISIM5CUNEIFORM SIGN KUCUNEIFORM SIGN KU" +
	" OVER HI TIMES ASH2 KU OVER HI TIMES ASH2CUNEIFORM SIGN KU3CUNEIFORM SIG" +
	"N KU4CUNEIFORM SIGN KU4 VARIANT FORMCUNEIFORM SIGN KU7CUNEIFORM SIGN KUL" +
	"CUNEIFORM SIGN KUL GUNUCUNEIFORM SIGN KUNCUNEIFORM SIGN KURCUNEIFORM SIG" +
	"N KUR OPPOSING KURCUNEIFORM SIGN KUSHU2CUNEIFORM SIGN KWU318CUNEIFORM SI" +
	"GN LACUNEIFORM SIGN LAGABCUNEIFORM SIGN LAGAB TIMES ACUNEIFORM SIGN LAGA" +
	"B TIMES A PLUS DA PLUS HACUNEIFORM SIGN LAGAB TIMES A PLUS GARCUNEIFORM " +
	"SIGN LAGAB TIMES A PLUS LALCUNEIFORM SIGN LAGAB TIMES ALCUNEIFORM SIGN L" +
	"AGAB TIMES ANCUNEIFORM SIGN LAGAB TIMES ASH ZIDA TENUCUNEIFORM SIGN LAGA" +
	"B TIMES BADCUNEIFORM SIGN LAGAB TIMES BICUNEIFORM SIGN LAGAB TIMES DARCU" +
	"NEIFORM SIGN LAGAB TIMES ENCUNEIFORM SIGN LAGAB TIMES GACUNEIFORM SIGN L" +
	"AGAB TIMES GARCUNEIFORM SIGN LAGAB TIMES GUDCUNEIFORM SIGN LAGAB TIMES G" +
	"UD PLUS GUDCUNEIFORM SIGN LAGAB TIMES HACUNEIFORM SIGN LAGAB TIMES HALCU" +
	"NEIFORM SIGN LAGAB TIMES HI TIMES NUNCUNEIFORM SIGN LAGAB TIMES IGI GUNU" +
	"CUNEIFORM SIGN LAGAB TIMES IMCUNEIFORM SIGN LAGAB TIMES IM PLUS HACUNEIF" +
	"ORM SIGN LAGAB TIMES IM PLUS LUCUNEIFORM SIGN LAGAB TIMES KICUNEIFORM SI" +
	"GN LAGAB TIMES KINCUNEIFORM SIGN LAGAB TIMES KU3CUNEIFORM SIGN LAGAB TIM" +
	"ES KULCUNEIFORM SIGN LAGAB TIMES KUL PLUS HI PLUS ACUNEIFORM SIGN LAGAB " +
	"TIMES LAGABCUNEIFORM SIGN LAGAB TIMES LISHCUNEIFORM SIGN LAGAB TIMES LUC" +
	"UNEIFORM SIGN LAGAB TIMES LULCUNEIFORM SIGN LAGAB TIMES MECUNEIFORM SIGN" +
	" LAGAB TIMES ME PLUS ENCUNEIFORM SIGN LAGAB TIMES MUSHCUNEIFORM SIGN LAG" +
	"AB TIMES NECUNEIFORM SIGN LAGAB TIMES SHE PLUS SUMCUNEIFORM SIGN LAGAB T" +
	"IMES SHITA PLUS GISH PLUS ERIN2CUNEIFORM SIGN LAGAB TIMES SHITA PLUS GIS" +
	"H TENUCUNEIFORM SIGN LAGAB TIMES SHU2CUNEIFORM SIGN LAGAB TIMES SHU2 PLU" +
	"S SHU2CUNEIFORM SIGN LAGAB TIMES SUMCUNEIFORM SIGN LAGAB TIMES TAGCUNEIF") + ("" +
	"ORM SIGN LAGAB TIMES TAK4CUNEIFORM SIGN LAGAB TIMES TE PLUS A PLUS SU PL" +
	"US NACUNEIFORM SIGN LAGAB TIMES UCUNEIFORM SIGN LAGAB TIMES U PLUS ACUNE" +
	"IFORM SIGN LAGAB TIMES U PLUS U PLUS UCUNEIFORM SIGN LAGAB TIMES U2 PLUS" +
	" ASHCUNEIFORM SIGN LAGAB TIMES UDCUNEIFORM SIGN LAGAB TIMES USHCUNEIFORM" +
	" SIGN LAGAB SQUAREDCUNEIFORM SIGN LAGARCUNEIFORM SIGN LAGAR TIMES SHECUN" +
	"EIFORM SIGN LAGAR TIMES SHE PLUS SUMCUNEIFORM SIGN LAGAR GUNUCUNEIFORM S" +
	"IGN LAGAR GUNU OVER LAGAR GUNU SHECUNEIFORM SIGN LAHSHUCUNEIFORM SIGN LA" +
	"LCUNEIFORM SIGN LAL TIMES LALCUNEIFORM SIGN LAMCUNEIFORM SIGN LAM TIMES " +
	"KURCUNEIFORM SIGN LAM TIMES KUR PLUS RUCUNEIFORM SIGN LICUNEIFORM SIGN L" +
	"ILCUNEIFORM SIGN LIMMU2CUNEIFORM SIGN LISHCUNEIFORM SIGN LUCUNEIFORM SIG" +
	"N LU TIMES BADCUNEIFORM SIGN LU2CUNEIFORM SIGN LU2 TIMES ALCUNEIFORM SIG" +
	"N LU2 TIMES BADCUNEIFORM SIGN LU2 TIMES ESH2CUNEIFORM SIGN LU2 TIMES ESH" +
	"2 TENUCUNEIFORM SIGN LU2 TIMES GAN2 TENUCUNEIFORM SIGN LU2 TIMES HI TIME" +
	"S BADCUNEIFORM SIGN LU2 TIMES IMCUNEIFORM SIGN LU2 TIMES KAD2CUNEIFORM S" +
	"IGN LU2 TIMES KAD3CUNEIFORM SIGN LU2 TIMES KAD3 PLUS ASHCUNEIFORM SIGN L" +
	"U2 TIMES KICUNEIFORM SIGN LU2 TIMES LA PLUS ASHCUNEIFORM SIGN LU2 TIMES " +
	"LAGABCUNEIFORM SIGN LU2 TIMES ME PLUS ENCUNEIFORM SIGN LU2 TIMES NECUNEI" +
	"FORM SIGN LU2 TIMES NUCUNEIFORM SIGN LU2 TIMES SI PLUS ASHCUNEIFORM SIGN" +
	" LU2 TIMES SIK2 PLUS BUCUNEIFORM SIGN LU2 TIMES TUG2CUNEIFORM SIGN LU2 T" +
	"ENUCUNEIFORM SIGN LU2 CROSSING LU2CUNEIFORM SIGN LU2 OPPOSING LU2CUNEIFO" +
	"RM SIGN LU2 SQUAREDCUNEIFORM SIGN LU2 SHESHIGCUNEIFORM SIGN LU3CUNEIFORM" +
	" SIGN LUGALCUNEIFORM SIGN LUGAL OVER LUGALCUNEIFORM SIGN LUGAL OPPOSING " +
	"LUGALCUNEIFORM SIGN LUGAL SHESHIGCUNEIFORM SIGN LUHCUNEIFORM SIGN LULCUN" +
	"EIFORM SIGN LUMCUNEIFORM SIGN LUM OVER LUMCUNEIFORM SIGN LUM OVER LUM GA" +
	"R OVER GARCUNEIFORM SIGN MACUNEIFORM SIGN MA TIMES TAK4CUNEIFORM SIGN MA" +
	" GUNUCUNEIFORM SIGN MA2CUNEIFORM SIGN MAHCUNEIFORM SIGN MARCUNEIFORM SIG" +
	"N MASHCUNEIFORM SIGN MASH2CUNEIFORM SIGN MECUNEIFORM SIGN MESCUNEIFORM S" +
	"IGN MICUNEIFORM SIGN MINCUNEIFORM SIGN MUCUNEIFORM SIGN MU OVER MUCUNEIF" +
	"ORM SIGN MUGCUNEIFORM SIGN MUG GUNUCUNEIFORM SIGN MUNSUBCUNEIFORM SIGN M" +
	"URGU2CUNEIFORM SIGN MUSHCUNEIFORM SIGN MUSH TIMES ACUNEIFORM SIGN MUSH T" +
	"IMES KURCUNEIFORM SIGN MUSH TIMES ZACUNEIFORM SIGN MUSH OVER MUSHCUNEIFO" +
	"RM SIGN MUSH OVER MUSH TIMES A PLUS NACUNEIFORM SIGN MUSH CROSSING MUSHC" +
	"UNEIFORM SIGN MUSH3CUNEIFORM SIGN MUSH3 TIMES ACUNEIFORM SIGN MUSH3 TIME" +
	"S A PLUS DICUNEIFORM SIGN MUSH3 TIMES DICUNEIFORM SIGN MUSH3 GUNUCUNEIFO" +
	"RM SIGN NACUNEIFORM SIGN NA2CUNEIFORM SIGN NAGACUNEIFORM SIGN NAGA INVER" +
	"TEDCUNEIFORM SIGN NAGA TIMES SHU TENUCUNEIFORM SIGN NAGA OPPOSING NAGACU" +
	"NEIFORM SIGN NAGARCUNEIFORM SIGN NAM NUTILLUCUNEIFORM SIGN NAMCUNEIFORM " +
	"SIGN NAM2CUNEIFORM SIGN NECUNEIFORM SIGN NE TIMES ACUNEIFORM SIGN NE TIM" +
	"ES UDCUNEIFORM SIGN NE SHESHIGCUNEIFORM SIGN NICUNEIFORM SIGN NI TIMES E" +
	"CUNEIFORM SIGN NI2CUNEIFORM SIGN NIMCUNEIFORM SIGN NIM TIMES GAN2 TENUCU" +
	"NEIFORM SIGN NIM TIMES GAR PLUS GAN2 TENUCUNEIFORM SIGN NINDA2CUNEIFORM " +
	"SIGN NINDA2 TIMES ANCUNEIFORM SIGN NINDA2 TIMES ASHCUNEIFORM SIGN NINDA2" +
	" TIMES ASH PLUS ASHCUNEIFORM SIGN NINDA2 TIMES GUDCUNEIFORM SIGN NINDA2 " +
	"TIMES ME PLUS GAN2 TENUCUNEIFORM SIGN NINDA2 TIMES NECUNEIFORM SIGN NIND" +
	"A2 TIMES NUNCUNEIFORM SIGN NINDA2 TIMES SHECUNEIFORM SIGN NINDA2 TIMES S" +
	"HE PLUS A ANCUNEIFORM SIGN NINDA2 TIMES SHE PLUS ASHCUNEIFORM SIGN NINDA" +
	"2 TIMES SHE PLUS ASH PLUS ASHCUNEIFORM SIGN NINDA2 TIMES U2 PLUS ASHCUNE" +
	"IFORM SIGN NINDA2 TIMES USHCUNEIFORM SIGN NISAGCUNEIFORM SIGN NUCUNEIFOR" +
	"M SIGN NU11CUNEIFORM SIGN NUNCUNEIFORM SIGN NUN LAGAR TIMES GARCUNEIFORM" +
	" SIGN NUN LAGAR TIMES MASHCUNEIFORM SIGN NUN LAGAR TIMES SALCUNEIFORM SI" +
	"GN NUN LAGAR TIMES SAL OVER NUN LAGAR TIMES SALCUNEIFORM SIGN NUN LAGAR " +
	"TIMES USHCUNEIFORM SIGN NUN TENUCUNEIFORM SIGN NUN OVER NUNCUNEIFORM SIG" +
	"N NUN CROSSING NUNCUNEIFORM SIGN NUN CROSSING NUN LAGAR OVER LAGARCUNEIF" +
	"ORM SIGN NUNUZCUNEIFORM SIGN NUNUZ AB2 TIMES ASHGABCUNEIFORM SIGN NUNUZ " +
	"AB2 TIMES BICUNEIFORM SIGN NUNUZ AB2 TIMES DUGCUNEIFORM SIGN NUNUZ AB2 T" +
	"IMES GUDCUNEIFORM SIGN NUNUZ AB2 TIMES IGI GUNUCUNEIFORM SIGN NUNUZ AB2 " +
	"TIMES KAD3CUNEIFORM SIGN NUNUZ AB2 TIMES LACUNEIFORM SIGN NUNUZ AB2 TIME" +
	"S NECUNEIFORM SIGN NUNUZ AB2 TIMES SILA3CUNEIFORM SIGN NUNUZ AB2 TIMES U" +
	"2CUNEIFORM SIGN NUNUZ KISIM5 TIMES BICUNEIFORM SIGN NUNUZ KISIM5 TIMES B" +
	"I UCUNEIFORM SIGN PACUNEIFORM SIGN PADCUNEIFORM SIGN PANCUNEIFORM SIGN P" +
	"APCUNEIFORM SIGN PESH2CUNEIFORM SIGN PICUNEIFORM SIGN PI TIMES ACUNEIFOR" +
	"M SIGN PI TIMES ABCUNEIFORM SIGN PI TIMES BICUNEIFORM SIGN PI TIMES BUCU" +
	"NEIFORM SIGN PI TIMES ECUNEIFORM SIGN PI TIMES ICUNEIFORM SIGN PI TIMES " +
	"IBCUNEIFORM SIGN PI TIMES UCUNEIFORM SIGN PI TIMES U2CUNEIFORM SIGN PI C") + ("" +
	"ROSSING PICUNEIFORM SIGN PIRIGCUNEIFORM SIGN PIRIG TIMES KALCUNEIFORM SI" +
	"GN PIRIG TIMES UDCUNEIFORM SIGN PIRIG TIMES ZACUNEIFORM SIGN PIRIG OPPOS" +
	"ING PIRIGCUNEIFORM SIGN RACUNEIFORM SIGN RABCUNEIFORM SIGN RICUNEIFORM S" +
	"IGN RUCUNEIFORM SIGN SACUNEIFORM SIGN SAG NUTILLUCUNEIFORM SIGN SAGCUNEI" +
	"FORM SIGN SAG TIMES ACUNEIFORM SIGN SAG TIMES DUCUNEIFORM SIGN SAG TIMES" +
	" DUBCUNEIFORM SIGN SAG TIMES HACUNEIFORM SIGN SAG TIMES KAKCUNEIFORM SIG" +
	"N SAG TIMES KURCUNEIFORM SIGN SAG TIMES LUMCUNEIFORM SIGN SAG TIMES MICU" +
	"NEIFORM SIGN SAG TIMES NUNCUNEIFORM SIGN SAG TIMES SALCUNEIFORM SIGN SAG" +
	" TIMES SHIDCUNEIFORM SIGN SAG TIMES TABCUNEIFORM SIGN SAG TIMES U2CUNEIF" +
	"ORM SIGN SAG TIMES UBCUNEIFORM SIGN SAG TIMES UMCUNEIFORM SIGN SAG TIMES" +
	" URCUNEIFORM SIGN SAG TIMES USHCUNEIFORM SIGN SAG OVER SAGCUNEIFORM SIGN" +
	" SAG GUNUCUNEIFORM SIGN SALCUNEIFORM SIGN SAL LAGAB TIMES ASH2CUNEIFORM " +
	"SIGN SANGA2CUNEIFORM SIGN SARCUNEIFORM SIGN SHACUNEIFORM SIGN SHA3CUNEIF" +
	"ORM SIGN SHA3 TIMES ACUNEIFORM SIGN SHA3 TIMES BADCUNEIFORM SIGN SHA3 TI" +
	"MES GISHCUNEIFORM SIGN SHA3 TIMES NECUNEIFORM SIGN SHA3 TIMES SHU2CUNEIF" +
	"ORM SIGN SHA3 TIMES TURCUNEIFORM SIGN SHA3 TIMES UCUNEIFORM SIGN SHA3 TI" +
	"MES U PLUS ACUNEIFORM SIGN SHA6CUNEIFORM SIGN SHAB6CUNEIFORM SIGN SHAR2C" +
	"UNEIFORM SIGN SHECUNEIFORM SIGN SHE HUCUNEIFORM SIGN SHE OVER SHE GAD OV" +
	"ER GAD GAR OVER GARCUNEIFORM SIGN SHE OVER SHE TAB OVER TAB GAR OVER GAR" +
	"CUNEIFORM SIGN SHEG9CUNEIFORM SIGN SHENCUNEIFORM SIGN SHESHCUNEIFORM SIG" +
	"N SHESH2CUNEIFORM SIGN SHESHLAMCUNEIFORM SIGN SHIDCUNEIFORM SIGN SHID TI" +
	"MES ACUNEIFORM SIGN SHID TIMES IMCUNEIFORM SIGN SHIMCUNEIFORM SIGN SHIM " +
	"TIMES ACUNEIFORM SIGN SHIM TIMES BALCUNEIFORM SIGN SHIM TIMES BULUGCUNEI" +
	"FORM SIGN SHIM TIMES DINCUNEIFORM SIGN SHIM TIMES GARCUNEIFORM SIGN SHIM" +
	" TIMES IGICUNEIFORM SIGN SHIM TIMES IGI GUNUCUNEIFORM SIGN SHIM TIMES KU" +
	"SHU2CUNEIFORM SIGN SHIM TIMES LULCUNEIFORM SIGN SHIM TIMES MUGCUNEIFORM " +
	"SIGN SHIM TIMES SALCUNEIFORM SIGN SHINIGCUNEIFORM SIGN SHIRCUNEIFORM SIG" +
	"N SHIR TENUCUNEIFORM SIGN SHIR OVER SHIR BUR OVER BURCUNEIFORM SIGN SHIT" +
	"ACUNEIFORM SIGN SHUCUNEIFORM SIGN SHU OVER INVERTED SHUCUNEIFORM SIGN SH" +
	"U2CUNEIFORM SIGN SHUBURCUNEIFORM SIGN SICUNEIFORM SIGN SI GUNUCUNEIFORM " +
	"SIGN SIGCUNEIFORM SIGN SIG4CUNEIFORM SIGN SIG4 OVER SIG4 SHU2CUNEIFORM S" +
	"IGN SIK2CUNEIFORM SIGN SILA3CUNEIFORM SIGN SUCUNEIFORM SIGN SU OVER SUCU" +
	"NEIFORM SIGN SUDCUNEIFORM SIGN SUD2CUNEIFORM SIGN SUHURCUNEIFORM SIGN SU" +
	"MCUNEIFORM SIGN SUMASHCUNEIFORM SIGN SURCUNEIFORM SIGN SUR9CUNEIFORM SIG" +
	"N TACUNEIFORM SIGN TA ASTERISKCUNEIFORM SIGN TA TIMES HICUNEIFORM SIGN T" +
	"A TIMES MICUNEIFORM SIGN TA GUNUCUNEIFORM SIGN TABCUNEIFORM SIGN TAB OVE" +
	"R TAB NI OVER NI DISH OVER DISHCUNEIFORM SIGN TAB SQUAREDCUNEIFORM SIGN " +
	"TAGCUNEIFORM SIGN TAG TIMES BICUNEIFORM SIGN TAG TIMES GUDCUNEIFORM SIGN" +
	" TAG TIMES SHECUNEIFORM SIGN TAG TIMES SHUCUNEIFORM SIGN TAG TIMES TUG2C" +
	"UNEIFORM SIGN TAG TIMES UDCUNEIFORM SIGN TAK4CUNEIFORM SIGN TARCUNEIFORM" +
	" SIGN TECUNEIFORM SIGN TE GUNUCUNEIFORM SIGN TICUNEIFORM SIGN TI TENUCUN" +
	"EIFORM SIGN TILCUNEIFORM SIGN TIRCUNEIFORM SIGN TIR TIMES TAK4CUNEIFORM " +
	"SIGN TIR OVER TIRCUNEIFORM SIGN TIR OVER TIR GAD OVER GAD GAR OVER GARCU" +
	"NEIFORM SIGN TUCUNEIFORM SIGN TUG2CUNEIFORM SIGN TUKCUNEIFORM SIGN TUMCU" +
	"NEIFORM SIGN TURCUNEIFORM SIGN TUR OVER TUR ZA OVER ZACUNEIFORM SIGN UCU" +
	"NEIFORM SIGN U GUDCUNEIFORM SIGN U U UCUNEIFORM SIGN U OVER U PA OVER PA" +
	" GAR OVER GARCUNEIFORM SIGN U OVER U SUR OVER SURCUNEIFORM SIGN U OVER U" +
	" U REVERSED OVER U REVERSEDCUNEIFORM SIGN U2CUNEIFORM SIGN UBCUNEIFORM S" +
	"IGN UDCUNEIFORM SIGN UD KUSHU2CUNEIFORM SIGN UD TIMES BADCUNEIFORM SIGN " +
	"UD TIMES MICUNEIFORM SIGN UD TIMES U PLUS U PLUS UCUNEIFORM SIGN UD TIME" +
	"S U PLUS U PLUS U GUNUCUNEIFORM SIGN UD GUNUCUNEIFORM SIGN UD SHESHIGCUN" +
	"EIFORM SIGN UD SHESHIG TIMES BADCUNEIFORM SIGN UDUGCUNEIFORM SIGN UMCUNE" +
	"IFORM SIGN UM TIMES LAGABCUNEIFORM SIGN UM TIMES ME PLUS DACUNEIFORM SIG" +
	"N UM TIMES SHA3CUNEIFORM SIGN UM TIMES UCUNEIFORM SIGN UMBINCUNEIFORM SI" +
	"GN UMUMCUNEIFORM SIGN UMUM TIMES KASKALCUNEIFORM SIGN UMUM TIMES PACUNEI" +
	"FORM SIGN UNCUNEIFORM SIGN UN GUNUCUNEIFORM SIGN URCUNEIFORM SIGN UR CRO" +
	"SSING URCUNEIFORM SIGN UR SHESHIGCUNEIFORM SIGN UR2CUNEIFORM SIGN UR2 TI" +
	"MES A PLUS HACUNEIFORM SIGN UR2 TIMES A PLUS NACUNEIFORM SIGN UR2 TIMES " +
	"ALCUNEIFORM SIGN UR2 TIMES HACUNEIFORM SIGN UR2 TIMES NUNCUNEIFORM SIGN " +
	"UR2 TIMES U2CUNEIFORM SIGN UR2 TIMES U2 PLUS ASHCUNEIFORM SIGN UR2 TIMES" +
	" U2 PLUS BICUNEIFORM SIGN UR4CUNEIFORM SIGN URICUNEIFORM SIGN URI3CUNEIF" +
	"ORM SIGN URUCUNEIFORM SIGN URU TIMES ACUNEIFORM SIGN URU TIMES ASHGABCUN" +
	"EIFORM SIGN URU TIMES BARCUNEIFORM SIGN URU TIMES DUNCUNEIFORM SIGN URU " +
	"TIMES GACUNEIFORM SIGN URU TIMES GALCUNEIFORM SIGN URU TIMES GAN2 TENUCU") + ("" +
	"NEIFORM SIGN URU TIMES GARCUNEIFORM SIGN URU TIMES GUCUNEIFORM SIGN URU " +
	"TIMES HACUNEIFORM SIGN URU TIMES IGICUNEIFORM SIGN URU TIMES IMCUNEIFORM" +
	" SIGN URU TIMES ISHCUNEIFORM SIGN URU TIMES KICUNEIFORM SIGN URU TIMES L" +
	"UMCUNEIFORM SIGN URU TIMES MINCUNEIFORM SIGN URU TIMES PACUNEIFORM SIGN " +
	"URU TIMES SHECUNEIFORM SIGN URU TIMES SIG4CUNEIFORM SIGN URU TIMES TUCUN" +
	"EIFORM SIGN URU TIMES U PLUS GUDCUNEIFORM SIGN URU TIMES UDCUNEIFORM SIG" +
	"N URU TIMES URUDACUNEIFORM SIGN URUDACUNEIFORM SIGN URUDA TIMES UCUNEIFO" +
	"RM SIGN USHCUNEIFORM SIGN USH TIMES ACUNEIFORM SIGN USH TIMES KUCUNEIFOR" +
	"M SIGN USH TIMES KURCUNEIFORM SIGN USH TIMES TAK4CUNEIFORM SIGN USHXCUNE" +
	"IFORM SIGN USH2CUNEIFORM SIGN USHUMXCUNEIFORM SIGN UTUKICUNEIFORM SIGN U" +
	"Z3CUNEIFORM SIGN UZ3 TIMES KASKALCUNEIFORM SIGN UZUCUNEIFORM SIGN ZACUNE" +
	"IFORM SIGN ZA TENUCUNEIFORM SIGN ZA SQUARED TIMES KURCUNEIFORM SIGN ZAGC" +
	"UNEIFORM SIGN ZAMXCUNEIFORM SIGN ZE2CUNEIFORM SIGN ZICUNEIFORM SIGN ZI O" +
	"VER ZICUNEIFORM SIGN ZI3CUNEIFORM SIGN ZIBCUNEIFORM SIGN ZIB KABA TENUCU" +
	"NEIFORM SIGN ZIGCUNEIFORM SIGN ZIZ2CUNEIFORM SIGN ZUCUNEIFORM SIGN ZU5CU" +
	"NEIFORM SIGN ZU5 TIMES ACUNEIFORM SIGN ZUBURCUNEIFORM SIGN ZUMCUNEIFORM " +
	"SIGN KAP ELAMITECUNEIFORM SIGN AB TIMES NUNCUNEIFORM SIGN AB2 TIMES ACUN" +
	"EIFORM SIGN AMAR TIMES KUGCUNEIFORM SIGN DAG KISIM5 TIMES U2 PLUS MASHCU" +
	"NEIFORM SIGN DAG3CUNEIFORM SIGN DISH PLUS SHUCUNEIFORM SIGN DUB TIMES SH" +
	"ECUNEIFORM SIGN EZEN TIMES GUDCUNEIFORM SIGN EZEN TIMES SHECUNEIFORM SIG" +
	"N GA2 TIMES AN PLUS KAK PLUS ACUNEIFORM SIGN GA2 TIMES ASH2CUNEIFORM SIG" +
	"N GE22CUNEIFORM SIGN GIGCUNEIFORM SIGN HUSHCUNEIFORM SIGN KA TIMES ANSHE" +
	"CUNEIFORM SIGN KA TIMES ASH3CUNEIFORM SIGN KA TIMES GISHCUNEIFORM SIGN K" +
	"A TIMES GUDCUNEIFORM SIGN KA TIMES HI TIMES ASH2CUNEIFORM SIGN KA TIMES " +
	"LUMCUNEIFORM SIGN KA TIMES PACUNEIFORM SIGN KA TIMES SHULCUNEIFORM SIGN " +
	"KA TIMES TUCUNEIFORM SIGN KA TIMES UR2CUNEIFORM SIGN LAGAB TIMES GICUNEI" +
	"FORM SIGN LU2 SHESHIG TIMES BADCUNEIFORM SIGN LU2 TIMES ESH2 PLUS LALCUN" +
	"EIFORM SIGN LU2 TIMES SHUCUNEIFORM SIGN MESHCUNEIFORM SIGN MUSH3 TIMES Z" +
	"ACUNEIFORM SIGN NA4CUNEIFORM SIGN NINCUNEIFORM SIGN NIN9CUNEIFORM SIGN N" +
	"INDA2 TIMES BALCUNEIFORM SIGN NINDA2 TIMES GICUNEIFORM SIGN NU11 ROTATED" +
	" NINETY DEGREESCUNEIFORM SIGN PESH2 ASTERISKCUNEIFORM SIGN PIR2CUNEIFORM" +
	" SIGN SAG TIMES IGI GUNUCUNEIFORM SIGN TI2CUNEIFORM SIGN UM TIMES MECUNE" +
	"IFORM SIGN U UCUNEIFORM NUMERIC SIGN TWO ASHCUNEIFORM NUMERIC SIGN THREE" +
	" ASHCUNEIFORM NUMERIC SIGN FOUR ASHCUNEIFORM NUMERIC SIGN FIVE ASHCUNEIF" +
	"ORM NUMERIC SIGN SIX ASHCUNEIFORM NUMERIC SIGN SEVEN ASHCUNEIFORM NUMERI" +
	"C SIGN EIGHT ASHCUNEIFORM NUMERIC SIGN NINE ASHCUNEIFORM NUMERIC SIGN TH" +
	"REE DISHCUNEIFORM NUMERIC SIGN FOUR DISHCUNEIFORM NUMERIC SIGN FIVE DISH" +
	"CUNEIFORM NUMERIC SIGN SIX DISHCUNEIFORM NUMERIC SIGN SEVEN DISHCUNEIFOR" +
	"M NUMERIC SIGN EIGHT DISHCUNEIFORM NUMERIC SIGN NINE DISHCUNEIFORM NUMER" +
	"IC SIGN FOUR UCUNEIFORM NUMERIC SIGN FIVE UCUNEIFORM NUMERIC SIGN SIX UC" +
	"UNEIFORM NUMERIC SIGN SEVEN UCUNEIFORM NUMERIC SIGN EIGHT UCUNEIFORM NUM" +
	"ERIC SIGN NINE UCUNEIFORM NUMERIC SIGN ONE GESH2CUNEIFORM NUMERIC SIGN T" +
	"WO GESH2CUNEIFORM NUMERIC SIGN THREE GESH2CUNEIFORM NUMERIC SIGN FOUR GE" +
	"SH2CUNEIFORM NUMERIC SIGN FIVE GESH2CUNEIFORM NUMERIC SIGN SIX GESH2CUNE" +
	"IFORM NUMERIC SIGN SEVEN GESH2CUNEIFORM NUMERIC SIGN EIGHT GESH2CUNEIFOR" +
	"M NUMERIC SIGN NINE GESH2CUNEIFORM NUMERIC SIGN ONE GESHUCUNEIFORM NUMER" +
	"IC SIGN TWO GESHUCUNEIFORM NUMERIC SIGN THREE GESHUCUNEIFORM NUMERIC SIG" +
	"N FOUR GESHUCUNEIFORM NUMERIC SIGN FIVE GESHUCUNEIFORM NUMERIC SIGN TWO " +
	"SHAR2CUNEIFORM NUMERIC SIGN THREE SHAR2CUNEIFORM NUMERIC SIGN THREE SHAR" +
	"2 VARIANT FORMCUNEIFORM NUMERIC SIGN FOUR SHAR2CUNEIFORM NUMERIC SIGN FI" +
	"VE SHAR2CUNEIFORM NUMERIC SIGN SIX SHAR2CUNEIFORM NUMERIC SIGN SEVEN SHA" +
	"R2CUNEIFORM NUMERIC SIGN EIGHT SHAR2CUNEIFORM NUMERIC SIGN NINE SHAR2CUN" +
	"EIFORM NUMERIC SIGN ONE SHARUCUNEIFORM NUMERIC SIGN TWO SHARUCUNEIFORM N" +
	"UMERIC SIGN THREE SHARUCUNEIFORM NUMERIC SIGN THREE SHARU VARIANT FORMCU" +
	"NEIFORM NUMERIC SIGN FOUR SHARUCUNEIFORM NUMERIC SIGN FIVE SHARUCUNEIFOR" +
	"M NUMERIC SIGN SHAR2 TIMES GAL PLUS DISHCUNEIFORM NUMERIC SIGN SHAR2 TIM" +
	"ES GAL PLUS MINCUNEIFORM NUMERIC SIGN ONE BURUCUNEIFORM NUMERIC SIGN TWO" +
	" BURUCUNEIFORM NUMERIC SIGN THREE BURUCUNEIFORM NUMERIC SIGN THREE BURU " +
	"VARIANT FORMCUNEIFORM NUMERIC SIGN FOUR BURUCUNEIFORM NUMERIC SIGN FIVE " +
	"BURUCUNEIFORM NUMERIC SIGN THREE VARIANT FORM ESH16CUNEIFORM NUMERIC SIG" +
	"N THREE VARIANT FORM ESH21CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU" +
	"CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU4CUNEIFORM NUMERIC SIGN FO" +
	"UR VARIANT FORM LIMMU ACUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU BC" +
	"UNEIFORM NUMERIC SIGN SIX VARIANT FORM ASH9CUNEIFORM NUMERIC SIGN SEVEN ") + ("" +
	"VARIANT FORM IMIN3CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN ACUNEIF" +
	"ORM NUMERIC SIGN SEVEN VARIANT FORM IMIN BCUNEIFORM NUMERIC SIGN EIGHT V" +
	"ARIANT FORM USSUCUNEIFORM NUMERIC SIGN EIGHT VARIANT FORM USSU3CUNEIFORM" +
	" NUMERIC SIGN NINE VARIANT FORM ILIMMUCUNEIFORM NUMERIC SIGN NINE VARIAN" +
	"T FORM ILIMMU3CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU4CUNEIFORM " +
	"NUMERIC SIGN NINE VARIANT FORM ILIMMU ACUNEIFORM NUMERIC SIGN TWO ASH TE" +
	"NUCUNEIFORM NUMERIC SIGN THREE ASH TENUCUNEIFORM NUMERIC SIGN FOUR ASH T" +
	"ENUCUNEIFORM NUMERIC SIGN FIVE ASH TENUCUNEIFORM NUMERIC SIGN SIX ASH TE" +
	"NUCUNEIFORM NUMERIC SIGN ONE BAN2CUNEIFORM NUMERIC SIGN TWO BAN2CUNEIFOR" +
	"M NUMERIC SIGN THREE BAN2CUNEIFORM NUMERIC SIGN FOUR BAN2CUNEIFORM NUMER" +
	"IC SIGN FOUR BAN2 VARIANT FORMCUNEIFORM NUMERIC SIGN FIVE BAN2CUNEIFORM " +
	"NUMERIC SIGN FIVE BAN2 VARIANT FORMCUNEIFORM NUMERIC SIGN NIGIDAMINCUNEI" +
	"FORM NUMERIC SIGN NIGIDAESHCUNEIFORM NUMERIC SIGN ONE ESHE3CUNEIFORM NUM" +
	"ERIC SIGN TWO ESHE3CUNEIFORM NUMERIC SIGN ONE THIRD DISHCUNEIFORM NUMERI" +
	"C SIGN TWO THIRDS DISHCUNEIFORM NUMERIC SIGN FIVE SIXTHS DISHCUNEIFORM N" +
	"UMERIC SIGN ONE THIRD VARIANT FORM ACUNEIFORM NUMERIC SIGN TWO THIRDS VA" +
	"RIANT FORM ACUNEIFORM NUMERIC SIGN ONE EIGHTH ASHCUNEIFORM NUMERIC SIGN " +
	"ONE QUARTER ASHCUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE SIXTHCUNEIFORM NU" +
	"MERIC SIGN OLD ASSYRIAN ONE QUARTERCUNEIFORM NUMERIC SIGN ONE QUARTER GU" +
	"RCUNEIFORM NUMERIC SIGN ONE HALF GURCUNEIFORM NUMERIC SIGN ELAMITE ONE T" +
	"HIRDCUNEIFORM NUMERIC SIGN ELAMITE TWO THIRDSCUNEIFORM NUMERIC SIGN ELAM" +
	"ITE FORTYCUNEIFORM NUMERIC SIGN ELAMITE FIFTYCUNEIFORM NUMERIC SIGN FOUR" +
	" U VARIANT FORMCUNEIFORM NUMERIC SIGN FIVE U VARIANT FORMCUNEIFORM NUMER" +
	"IC SIGN SIX U VARIANT FORMCUNEIFORM NUMERIC SIGN SEVEN U VARIANT FORMCUN" +
	"EIFORM NUMERIC SIGN EIGHT U VARIANT FORMCUNEIFORM NUMERIC SIGN NINE U VA" +
	"RIANT FORMCUNEIFORM PUNCTUATION SIGN OLD ASSYRIAN WORD DIVIDERCUNEIFORM " +
	"PUNCTUATION SIGN VERTICAL COLONCUNEIFORM PUNCTUATION SIGN DIAGONAL COLON" +
	"CUNEIFORM PUNCTUATION SIGN DIAGONAL TRICOLONCUNEIFORM PUNCTUATION SIGN D" +
	"IAGONAL QUADCOLONCUNEIFORM SIGN AB TIMES NUN TENUCUNEIFORM SIGN AB TIMES" +
	" SHU2CUNEIFORM SIGN AD TIMES ESH2CUNEIFORM SIGN BAD TIMES DISH TENUCUNEI" +
	"FORM SIGN BAHAR2 TIMES AB2CUNEIFORM SIGN BAHAR2 TIMES NICUNEIFORM SIGN B" +
	"AHAR2 TIMES ZACUNEIFORM SIGN BU OVER BU TIMES NA2CUNEIFORM SIGN DA TIMES" +
	" TAK4CUNEIFORM SIGN DAG TIMES KURCUNEIFORM SIGN DIM TIMES IGICUNEIFORM S" +
	"IGN DIM TIMES U U UCUNEIFORM SIGN DIM2 TIMES UDCUNEIFORM SIGN DUG TIMES " +
	"ANSHECUNEIFORM SIGN DUG TIMES ASHCUNEIFORM SIGN DUG TIMES ASH AT LEFTCUN" +
	"EIFORM SIGN DUG TIMES DINCUNEIFORM SIGN DUG TIMES DUNCUNEIFORM SIGN DUG " +
	"TIMES ERIN2CUNEIFORM SIGN DUG TIMES GACUNEIFORM SIGN DUG TIMES GICUNEIFO" +
	"RM SIGN DUG TIMES GIR2 GUNUCUNEIFORM SIGN DUG TIMES GISHCUNEIFORM SIGN D" +
	"UG TIMES HACUNEIFORM SIGN DUG TIMES HICUNEIFORM SIGN DUG TIMES IGI GUNUC" +
	"UNEIFORM SIGN DUG TIMES KASKALCUNEIFORM SIGN DUG TIMES KURCUNEIFORM SIGN" +
	" DUG TIMES KUSHU2CUNEIFORM SIGN DUG TIMES KUSHU2 PLUS KASKALCUNEIFORM SI" +
	"GN DUG TIMES LAK-020CUNEIFORM SIGN DUG TIMES LAMCUNEIFORM SIGN DUG TIMES" +
	" LAM TIMES KURCUNEIFORM SIGN DUG TIMES LUH PLUS GISHCUNEIFORM SIGN DUG T" +
	"IMES MASHCUNEIFORM SIGN DUG TIMES MESCUNEIFORM SIGN DUG TIMES MICUNEIFOR" +
	"M SIGN DUG TIMES NICUNEIFORM SIGN DUG TIMES PICUNEIFORM SIGN DUG TIMES S" +
	"HECUNEIFORM SIGN DUG TIMES SI GUNUCUNEIFORM SIGN E2 TIMES KURCUNEIFORM S" +
	"IGN E2 TIMES PAPCUNEIFORM SIGN ERIN2 XCUNEIFORM SIGN ESH2 CROSSING ESH2C" +
	"UNEIFORM SIGN EZEN SHESHIG TIMES ASHCUNEIFORM SIGN EZEN SHESHIG TIMES HI" +
	"CUNEIFORM SIGN EZEN SHESHIG TIMES IGI GUNUCUNEIFORM SIGN EZEN SHESHIG TI" +
	"MES LACUNEIFORM SIGN EZEN SHESHIG TIMES LALCUNEIFORM SIGN EZEN SHESHIG T" +
	"IMES MECUNEIFORM SIGN EZEN SHESHIG TIMES MESCUNEIFORM SIGN EZEN SHESHIG " +
	"TIMES SUCUNEIFORM SIGN EZEN TIMES SUCUNEIFORM SIGN GA2 TIMES BAHAR2CUNEI" +
	"FORM SIGN GA2 TIMES DIM GUNUCUNEIFORM SIGN GA2 TIMES DUG TIMES IGI GUNUC" +
	"UNEIFORM SIGN GA2 TIMES DUG TIMES KASKALCUNEIFORM SIGN GA2 TIMES ERENCUN" +
	"EIFORM SIGN GA2 TIMES GACUNEIFORM SIGN GA2 TIMES GAR PLUS DICUNEIFORM SI" +
	"GN GA2 TIMES GAR PLUS NECUNEIFORM SIGN GA2 TIMES HA PLUS ACUNEIFORM SIGN" +
	" GA2 TIMES KUSHU2 PLUS KASKALCUNEIFORM SIGN GA2 TIMES LAMCUNEIFORM SIGN " +
	"GA2 TIMES LAM TIMES KURCUNEIFORM SIGN GA2 TIMES LUHCUNEIFORM SIGN GA2 TI" +
	"MES MUSHCUNEIFORM SIGN GA2 TIMES NECUNEIFORM SIGN GA2 TIMES NE PLUS E2CU" +
	"NEIFORM SIGN GA2 TIMES NE PLUS GICUNEIFORM SIGN GA2 TIMES SHIMCUNEIFORM " +
	"SIGN GA2 TIMES ZIZ2CUNEIFORM SIGN GABA ROTATED NINETY DEGREESCUNEIFORM S" +
	"IGN GESHTIN TIMES UCUNEIFORM SIGN GISH TIMES GISH CROSSING GISHCUNEIFORM" +
	" SIGN GU2 TIMES IGI GUNUCUNEIFORM SIGN GUD PLUS GISH TIMES TAK4CUNEIFORM" +
	" SIGN HA TENU GUNUCUNEIFORM SIGN HI TIMES ASH OVER HI TIMES ASHCUNEIFORM") + ("" +
	" SIGN KA TIMES BUCUNEIFORM SIGN KA TIMES KACUNEIFORM SIGN KA TIMES U U U" +
	"CUNEIFORM SIGN KA TIMES URCUNEIFORM SIGN LAGAB TIMES ZU OVER ZUCUNEIFORM" +
	" SIGN LAK-003CUNEIFORM SIGN LAK-021CUNEIFORM SIGN LAK-025CUNEIFORM SIGN " +
	"LAK-030CUNEIFORM SIGN LAK-050CUNEIFORM SIGN LAK-051CUNEIFORM SIGN LAK-06" +
	"2CUNEIFORM SIGN LAK-079 OVER LAK-079 GUNUCUNEIFORM SIGN LAK-080CUNEIFORM" +
	" SIGN LAK-081 OVER LAK-081CUNEIFORM SIGN LAK-092CUNEIFORM SIGN LAK-130CU" +
	"NEIFORM SIGN LAK-142CUNEIFORM SIGN LAK-210CUNEIFORM SIGN LAK-219CUNEIFOR" +
	"M SIGN LAK-220CUNEIFORM SIGN LAK-225CUNEIFORM SIGN LAK-228CUNEIFORM SIGN" +
	" LAK-238CUNEIFORM SIGN LAK-265CUNEIFORM SIGN LAK-266CUNEIFORM SIGN LAK-3" +
	"43CUNEIFORM SIGN LAK-347CUNEIFORM SIGN LAK-348CUNEIFORM SIGN LAK-383CUNE" +
	"IFORM SIGN LAK-384CUNEIFORM SIGN LAK-390CUNEIFORM SIGN LAK-441CUNEIFORM " +
	"SIGN LAK-449CUNEIFORM SIGN LAK-449 TIMES GUCUNEIFORM SIGN LAK-449 TIMES " +
	"IGICUNEIFORM SIGN LAK-449 TIMES PAP PLUS LU3CUNEIFORM SIGN LAK-449 TIMES" +
	" PAP PLUS PAP PLUS LU3CUNEIFORM SIGN LAK-449 TIMES U2 PLUS BACUNEIFORM S" +
	"IGN LAK-450CUNEIFORM SIGN LAK-457CUNEIFORM SIGN LAK-470CUNEIFORM SIGN LA" +
	"K-483CUNEIFORM SIGN LAK-490CUNEIFORM SIGN LAK-492CUNEIFORM SIGN LAK-493C" +
	"UNEIFORM SIGN LAK-495CUNEIFORM SIGN LAK-550CUNEIFORM SIGN LAK-608CUNEIFO" +
	"RM SIGN LAK-617CUNEIFORM SIGN LAK-617 TIMES ASHCUNEIFORM SIGN LAK-617 TI" +
	"MES BADCUNEIFORM SIGN LAK-617 TIMES DUN3 GUNU GUNUCUNEIFORM SIGN LAK-617" +
	" TIMES KU3CUNEIFORM SIGN LAK-617 TIMES LACUNEIFORM SIGN LAK-617 TIMES TA" +
	"RCUNEIFORM SIGN LAK-617 TIMES TECUNEIFORM SIGN LAK-617 TIMES U2CUNEIFORM" +
	" SIGN LAK-617 TIMES UDCUNEIFORM SIGN LAK-617 TIMES URUDACUNEIFORM SIGN L" +
	"AK-636CUNEIFORM SIGN LAK-648CUNEIFORM SIGN LAK-648 TIMES DUBCUNEIFORM SI" +
	"GN LAK-648 TIMES GACUNEIFORM SIGN LAK-648 TIMES IGICUNEIFORM SIGN LAK-64" +
	"8 TIMES IGI GUNUCUNEIFORM SIGN LAK-648 TIMES NICUNEIFORM SIGN LAK-648 TI" +
	"MES PAP PLUS PAP PLUS LU3CUNEIFORM SIGN LAK-648 TIMES SHESH PLUS KICUNEI" +
	"FORM SIGN LAK-648 TIMES UDCUNEIFORM SIGN LAK-648 TIMES URUDACUNEIFORM SI" +
	"GN LAK-724CUNEIFORM SIGN LAK-749CUNEIFORM SIGN LU2 GUNU TIMES ASHCUNEIFO" +
	"RM SIGN LU2 TIMES DISHCUNEIFORM SIGN LU2 TIMES HALCUNEIFORM SIGN LU2 TIM" +
	"ES PAPCUNEIFORM SIGN LU2 TIMES PAP PLUS PAP PLUS LU3CUNEIFORM SIGN LU2 T" +
	"IMES TAK4CUNEIFORM SIGN MI PLUS ZA7CUNEIFORM SIGN MUSH OVER MUSH TIMES G" +
	"ACUNEIFORM SIGN MUSH OVER MUSH TIMES KAKCUNEIFORM SIGN NINDA2 TIMES DIM " +
	"GUNUCUNEIFORM SIGN NINDA2 TIMES GISHCUNEIFORM SIGN NINDA2 TIMES GULCUNEI" +
	"FORM SIGN NINDA2 TIMES HICUNEIFORM SIGN NINDA2 TIMES KESH2CUNEIFORM SIGN" +
	" NINDA2 TIMES LAK-050CUNEIFORM SIGN NINDA2 TIMES MASHCUNEIFORM SIGN NIND" +
	"A2 TIMES PAP PLUS PAPCUNEIFORM SIGN NINDA2 TIMES UCUNEIFORM SIGN NINDA2 " +
	"TIMES U PLUS UCUNEIFORM SIGN NINDA2 TIMES URUDACUNEIFORM SIGN SAG GUNU T" +
	"IMES HACUNEIFORM SIGN SAG TIMES ENCUNEIFORM SIGN SAG TIMES SHE AT LEFTCU" +
	"NEIFORM SIGN SAG TIMES TAK4CUNEIFORM SIGN SHA6 TENUCUNEIFORM SIGN SHE OV" +
	"ER SHECUNEIFORM SIGN SHE PLUS HUB2CUNEIFORM SIGN SHE PLUS NAM2CUNEIFORM " +
	"SIGN SHE PLUS SARCUNEIFORM SIGN SHU2 PLUS DUG TIMES NICUNEIFORM SIGN SHU" +
	"2 PLUS E2 TIMES ANCUNEIFORM SIGN SI TIMES TAK4CUNEIFORM SIGN TAK4 PLUS S" +
	"AGCUNEIFORM SIGN TUM TIMES GAN2 TENUCUNEIFORM SIGN TUM TIMES THREE DISHC" +
	"UNEIFORM SIGN UR2 INVERTEDCUNEIFORM SIGN UR2 TIMES UDCUNEIFORM SIGN URU " +
	"TIMES DARA3CUNEIFORM SIGN URU TIMES LAK-668CUNEIFORM SIGN URU TIMES LU3C" +
	"UNEIFORM SIGN ZA7CUNEIFORM SIGN ZU OVER ZU PLUS SARCUNEIFORM SIGN ZU5 TI" +
	"MES THREE DISH TENUEGYPTIAN HIEROGLYPH A001EGYPTIAN HIEROGLYPH A002EGYPT" +
	"IAN HIEROGLYPH A003EGYPTIAN HIEROGLYPH A004EGYPTIAN HIEROGLYPH A005EGYPT" +
	"IAN HIEROGLYPH A005AEGYPTIAN HIEROGLYPH A006EGYPTIAN HIEROGLYPH A006AEGY" +
	"PTIAN HIEROGLYPH A006BEGYPTIAN HIEROGLYPH A007EGYPTIAN HIEROGLYPH A008EG" +
	"YPTIAN HIEROGLYPH A009EGYPTIAN HIEROGLYPH A010EGYPTIAN HIEROGLYPH A011EG" +
	"YPTIAN HIEROGLYPH A012EGYPTIAN HIEROGLYPH A013EGYPTIAN HIEROGLYPH A014EG" +
	"YPTIAN HIEROGLYPH A014AEGYPTIAN HIEROGLYPH A015EGYPTIAN HIEROGLYPH A016E" +
	"GYPTIAN HIEROGLYPH A017EGYPTIAN HIEROGLYPH A017AEGYPTIAN HIEROGLYPH A018" +
	"EGYPTIAN HIEROGLYPH A019EGYPTIAN HIEROGLYPH A020EGYPTIAN HIEROGLYPH A021" +
	"EGYPTIAN HIEROGLYPH A022EGYPTIAN HIEROGLYPH A023EGYPTIAN HIEROGLYPH A024" +
	"EGYPTIAN HIEROGLYPH A025EGYPTIAN HIEROGLYPH A026EGYPTIAN HIEROGLYPH A027" +
	"EGYPTIAN HIEROGLYPH A028EGYPTIAN HIEROGLYPH A029EGYPTIAN HIEROGLYPH A030" +
	"EGYPTIAN HIEROGLYPH A031EGYPTIAN HIEROGLYPH A032EGYPTIAN HIEROGLYPH A032" +
	"AEGYPTIAN HIEROGLYPH A033EGYPTIAN HIEROGLYPH A034EGYPTIAN HIEROGLYPH A03" +
	"5EGYPTIAN HIEROGLYPH A036EGYPTIAN HIEROGLYPH A037EGYPTIAN HIEROGLYPH A03" +
	"8EGYPTIAN HIEROGLYPH A039EGYPTIAN HIEROGLYPH A040EGYPTIAN HIEROGLYPH A04" +
	"0AEGYPTIAN HIEROGLYPH A041EGYPTIAN HIEROGLYPH A042EGYPTIAN HIEROGLYPH A0" +
	"42AEGYPTIAN HIEROGLYPH A043EGYPTIAN HIEROGLYPH A043AEGYPTIAN HIEROGLYPH ") + ("" +
	"A044EGYPTIAN HIEROGLYPH A045EGYPTIAN HIEROGLYPH A045AEGYPTIAN HIEROGLYPH" +
	" A046EGYPTIAN HIEROGLYPH A047EGYPTIAN HIEROGLYPH A048EGYPTIAN HIEROGLYPH" +
	" A049EGYPTIAN HIEROGLYPH A050EGYPTIAN HIEROGLYPH A051EGYPTIAN HIEROGLYPH" +
	" A052EGYPTIAN HIEROGLYPH A053EGYPTIAN HIEROGLYPH A054EGYPTIAN HIEROGLYPH" +
	" A055EGYPTIAN HIEROGLYPH A056EGYPTIAN HIEROGLYPH A057EGYPTIAN HIEROGLYPH" +
	" A058EGYPTIAN HIEROGLYPH A059EGYPTIAN HIEROGLYPH A060EGYPTIAN HIEROGLYPH" +
	" A061EGYPTIAN HIEROGLYPH A062EGYPTIAN HIEROGLYPH A063EGYPTIAN HIEROGLYPH" +
	" A064EGYPTIAN HIEROGLYPH A065EGYPTIAN HIEROGLYPH A066EGYPTIAN HIEROGLYPH" +
	" A067EGYPTIAN HIEROGLYPH A068EGYPTIAN HIEROGLYPH A069EGYPTIAN HIEROGLYPH" +
	" A070EGYPTIAN HIEROGLYPH B001EGYPTIAN HIEROGLYPH B002EGYPTIAN HIEROGLYPH" +
	" B003EGYPTIAN HIEROGLYPH B004EGYPTIAN HIEROGLYPH B005EGYPTIAN HIEROGLYPH" +
	" B005AEGYPTIAN HIEROGLYPH B006EGYPTIAN HIEROGLYPH B007EGYPTIAN HIEROGLYP" +
	"H B008EGYPTIAN HIEROGLYPH B009EGYPTIAN HIEROGLYPH C001EGYPTIAN HIEROGLYP" +
	"H C002EGYPTIAN HIEROGLYPH C002AEGYPTIAN HIEROGLYPH C002BEGYPTIAN HIEROGL" +
	"YPH C002CEGYPTIAN HIEROGLYPH C003EGYPTIAN HIEROGLYPH C004EGYPTIAN HIEROG" +
	"LYPH C005EGYPTIAN HIEROGLYPH C006EGYPTIAN HIEROGLYPH C007EGYPTIAN HIEROG" +
	"LYPH C008EGYPTIAN HIEROGLYPH C009EGYPTIAN HIEROGLYPH C010EGYPTIAN HIEROG" +
	"LYPH C010AEGYPTIAN HIEROGLYPH C011EGYPTIAN HIEROGLYPH C012EGYPTIAN HIERO" +
	"GLYPH C013EGYPTIAN HIEROGLYPH C014EGYPTIAN HIEROGLYPH C015EGYPTIAN HIERO" +
	"GLYPH C016EGYPTIAN HIEROGLYPH C017EGYPTIAN HIEROGLYPH C018EGYPTIAN HIERO" +
	"GLYPH C019EGYPTIAN HIEROGLYPH C020EGYPTIAN HIEROGLYPH C021EGYPTIAN HIERO" +
	"GLYPH C022EGYPTIAN HIEROGLYPH C023EGYPTIAN HIEROGLYPH C024EGYPTIAN HIERO" +
	"GLYPH D001EGYPTIAN HIEROGLYPH D002EGYPTIAN HIEROGLYPH D003EGYPTIAN HIERO" +
	"GLYPH D004EGYPTIAN HIEROGLYPH D005EGYPTIAN HIEROGLYPH D006EGYPTIAN HIERO" +
	"GLYPH D007EGYPTIAN HIEROGLYPH D008EGYPTIAN HIEROGLYPH D008AEGYPTIAN HIER" +
	"OGLYPH D009EGYPTIAN HIEROGLYPH D010EGYPTIAN HIEROGLYPH D011EGYPTIAN HIER" +
	"OGLYPH D012EGYPTIAN HIEROGLYPH D013EGYPTIAN HIEROGLYPH D014EGYPTIAN HIER" +
	"OGLYPH D015EGYPTIAN HIEROGLYPH D016EGYPTIAN HIEROGLYPH D017EGYPTIAN HIER" +
	"OGLYPH D018EGYPTIAN HIEROGLYPH D019EGYPTIAN HIEROGLYPH D020EGYPTIAN HIER" +
	"OGLYPH D021EGYPTIAN HIEROGLYPH D022EGYPTIAN HIEROGLYPH D023EGYPTIAN HIER" +
	"OGLYPH D024EGYPTIAN HIEROGLYPH D025EGYPTIAN HIEROGLYPH D026EGYPTIAN HIER" +
	"OGLYPH D027EGYPTIAN HIEROGLYPH D027AEGYPTIAN HIEROGLYPH D028EGYPTIAN HIE" +
	"ROGLYPH D029EGYPTIAN HIEROGLYPH D030EGYPTIAN HIEROGLYPH D031EGYPTIAN HIE" +
	"ROGLYPH D031AEGYPTIAN HIEROGLYPH D032EGYPTIAN HIEROGLYPH D033EGYPTIAN HI" +
	"EROGLYPH D034EGYPTIAN HIEROGLYPH D034AEGYPTIAN HIEROGLYPH D035EGYPTIAN H" +
	"IEROGLYPH D036EGYPTIAN HIEROGLYPH D037EGYPTIAN HIEROGLYPH D038EGYPTIAN H" +
	"IEROGLYPH D039EGYPTIAN HIEROGLYPH D040EGYPTIAN HIEROGLYPH D041EGYPTIAN H" +
	"IEROGLYPH D042EGYPTIAN HIEROGLYPH D043EGYPTIAN HIEROGLYPH D044EGYPTIAN H" +
	"IEROGLYPH D045EGYPTIAN HIEROGLYPH D046EGYPTIAN HIEROGLYPH D046AEGYPTIAN " +
	"HIEROGLYPH D047EGYPTIAN HIEROGLYPH D048EGYPTIAN HIEROGLYPH D048AEGYPTIAN" +
	" HIEROGLYPH D049EGYPTIAN HIEROGLYPH D050EGYPTIAN HIEROGLYPH D050AEGYPTIA" +
	"N HIEROGLYPH D050BEGYPTIAN HIEROGLYPH D050CEGYPTIAN HIEROGLYPH D050DEGYP" +
	"TIAN HIEROGLYPH D050EEGYPTIAN HIEROGLYPH D050FEGYPTIAN HIEROGLYPH D050GE" +
	"GYPTIAN HIEROGLYPH D050HEGYPTIAN HIEROGLYPH D050IEGYPTIAN HIEROGLYPH D05" +
	"1EGYPTIAN HIEROGLYPH D052EGYPTIAN HIEROGLYPH D052AEGYPTIAN HIEROGLYPH D0" +
	"53EGYPTIAN HIEROGLYPH D054EGYPTIAN HIEROGLYPH D054AEGYPTIAN HIEROGLYPH D" +
	"055EGYPTIAN HIEROGLYPH D056EGYPTIAN HIEROGLYPH D057EGYPTIAN HIEROGLYPH D" +
	"058EGYPTIAN HIEROGLYPH D059EGYPTIAN HIEROGLYPH D060EGYPTIAN HIEROGLYPH D" +
	"061EGYPTIAN HIEROGLYPH D062EGYPTIAN HIEROGLYPH D063EGYPTIAN HIEROGLYPH D" +
	"064EGYPTIAN HIEROGLYPH D065EGYPTIAN HIEROGLYPH D066EGYPTIAN HIEROGLYPH D" +
	"067EGYPTIAN HIEROGLYPH D067AEGYPTIAN HIEROGLYPH D067BEGYPTIAN HIEROGLYPH" +
	" D067CEGYPTIAN HIEROGLYPH D067DEGYPTIAN HIEROGLYPH D067EEGYPTIAN HIEROGL" +
	"YPH D067FEGYPTIAN HIEROGLYPH D067GEGYPTIAN HIEROGLYPH D067HEGYPTIAN HIER" +
	"OGLYPH E001EGYPTIAN HIEROGLYPH E002EGYPTIAN HIEROGLYPH E003EGYPTIAN HIER" +
	"OGLYPH E004EGYPTIAN HIEROGLYPH E005EGYPTIAN HIEROGLYPH E006EGYPTIAN HIER" +
	"OGLYPH E007EGYPTIAN HIEROGLYPH E008EGYPTIAN HIEROGLYPH E008AEGYPTIAN HIE" +
	"ROGLYPH E009EGYPTIAN HIEROGLYPH E009AEGYPTIAN HIEROGLYPH E010EGYPTIAN HI" +
	"EROGLYPH E011EGYPTIAN HIEROGLYPH E012EGYPTIAN HIEROGLYPH E013EGYPTIAN HI" +
	"EROGLYPH E014EGYPTIAN HIEROGLYPH E015EGYPTIAN HIEROGLYPH E016EGYPTIAN HI" +
	"EROGLYPH E016AEGYPTIAN HIEROGLYPH E017EGYPTIAN HIEROGLYPH E017AEGYPTIAN " +
	"HIEROGLYPH E018EGYPTIAN HIEROGLYPH E019EGYPTIAN HIEROGLYPH E020EGYPTIAN " +
	"HIEROGLYPH E020AEGYPTIAN HIEROGLYPH E021EGYPTIAN HIEROGLYPH E022EGYPTIAN" +
	" HIEROGLYPH E023EGYPTIAN HIEROGLYPH E024EGYPTIAN HIEROGLYPH E025EGYPTIAN" +
	" HIEROGLYPH E026EGYPTIAN HIEROGLYPH E027EGYPTIAN HIEROGLYPH E028EGYPTIAN") + ("" +
	" HIEROGLYPH E028AEGYPTIAN HIEROGLYPH E029EGYPTIAN HIEROGLYPH E030EGYPTIA" +
	"N HIEROGLYPH E031EGYPTIAN HIEROGLYPH E032EGYPTIAN HIEROGLYPH E033EGYPTIA" +
	"N HIEROGLYPH E034EGYPTIAN HIEROGLYPH E034AEGYPTIAN HIEROGLYPH E036EGYPTI" +
	"AN HIEROGLYPH E037EGYPTIAN HIEROGLYPH E038EGYPTIAN HIEROGLYPH F001EGYPTI" +
	"AN HIEROGLYPH F001AEGYPTIAN HIEROGLYPH F002EGYPTIAN HIEROGLYPH F003EGYPT" +
	"IAN HIEROGLYPH F004EGYPTIAN HIEROGLYPH F005EGYPTIAN HIEROGLYPH F006EGYPT" +
	"IAN HIEROGLYPH F007EGYPTIAN HIEROGLYPH F008EGYPTIAN HIEROGLYPH F009EGYPT" +
	"IAN HIEROGLYPH F010EGYPTIAN HIEROGLYPH F011EGYPTIAN HIEROGLYPH F012EGYPT" +
	"IAN HIEROGLYPH F013EGYPTIAN HIEROGLYPH F013AEGYPTIAN HIEROGLYPH F014EGYP" +
	"TIAN HIEROGLYPH F015EGYPTIAN HIEROGLYPH F016EGYPTIAN HIEROGLYPH F017EGYP" +
	"TIAN HIEROGLYPH F018EGYPTIAN HIEROGLYPH F019EGYPTIAN HIEROGLYPH F020EGYP" +
	"TIAN HIEROGLYPH F021EGYPTIAN HIEROGLYPH F021AEGYPTIAN HIEROGLYPH F022EGY" +
	"PTIAN HIEROGLYPH F023EGYPTIAN HIEROGLYPH F024EGYPTIAN HIEROGLYPH F025EGY" +
	"PTIAN HIEROGLYPH F026EGYPTIAN HIEROGLYPH F027EGYPTIAN HIEROGLYPH F028EGY" +
	"PTIAN HIEROGLYPH F029EGYPTIAN HIEROGLYPH F030EGYPTIAN HIEROGLYPH F031EGY" +
	"PTIAN HIEROGLYPH F031AEGYPTIAN HIEROGLYPH F032EGYPTIAN HIEROGLYPH F033EG" +
	"YPTIAN HIEROGLYPH F034EGYPTIAN HIEROGLYPH F035EGYPTIAN HIEROGLYPH F036EG" +
	"YPTIAN HIEROGLYPH F037EGYPTIAN HIEROGLYPH F037AEGYPTIAN HIEROGLYPH F038E" +
	"GYPTIAN HIEROGLYPH F038AEGYPTIAN HIEROGLYPH F039EGYPTIAN HIEROGLYPH F040" +
	"EGYPTIAN HIEROGLYPH F041EGYPTIAN HIEROGLYPH F042EGYPTIAN HIEROGLYPH F043" +
	"EGYPTIAN HIEROGLYPH F044EGYPTIAN HIEROGLYPH F045EGYPTIAN HIEROGLYPH F045" +
	"AEGYPTIAN HIEROGLYPH F046EGYPTIAN HIEROGLYPH F046AEGYPTIAN HIEROGLYPH F0" +
	"47EGYPTIAN HIEROGLYPH F047AEGYPTIAN HIEROGLYPH F048EGYPTIAN HIEROGLYPH F" +
	"049EGYPTIAN HIEROGLYPH F050EGYPTIAN HIEROGLYPH F051EGYPTIAN HIEROGLYPH F" +
	"051AEGYPTIAN HIEROGLYPH F051BEGYPTIAN HIEROGLYPH F051CEGYPTIAN HIEROGLYP" +
	"H F052EGYPTIAN HIEROGLYPH F053EGYPTIAN HIEROGLYPH G001EGYPTIAN HIEROGLYP" +
	"H G002EGYPTIAN HIEROGLYPH G003EGYPTIAN HIEROGLYPH G004EGYPTIAN HIEROGLYP" +
	"H G005EGYPTIAN HIEROGLYPH G006EGYPTIAN HIEROGLYPH G006AEGYPTIAN HIEROGLY" +
	"PH G007EGYPTIAN HIEROGLYPH G007AEGYPTIAN HIEROGLYPH G007BEGYPTIAN HIEROG" +
	"LYPH G008EGYPTIAN HIEROGLYPH G009EGYPTIAN HIEROGLYPH G010EGYPTIAN HIEROG" +
	"LYPH G011EGYPTIAN HIEROGLYPH G011AEGYPTIAN HIEROGLYPH G012EGYPTIAN HIERO" +
	"GLYPH G013EGYPTIAN HIEROGLYPH G014EGYPTIAN HIEROGLYPH G015EGYPTIAN HIERO" +
	"GLYPH G016EGYPTIAN HIEROGLYPH G017EGYPTIAN HIEROGLYPH G018EGYPTIAN HIERO" +
	"GLYPH G019EGYPTIAN HIEROGLYPH G020EGYPTIAN HIEROGLYPH G020AEGYPTIAN HIER" +
	"OGLYPH G021EGYPTIAN HIEROGLYPH G022EGYPTIAN HIEROGLYPH G023EGYPTIAN HIER" +
	"OGLYPH G024EGYPTIAN HIEROGLYPH G025EGYPTIAN HIEROGLYPH G026EGYPTIAN HIER" +
	"OGLYPH G026AEGYPTIAN HIEROGLYPH G027EGYPTIAN HIEROGLYPH G028EGYPTIAN HIE" +
	"ROGLYPH G029EGYPTIAN HIEROGLYPH G030EGYPTIAN HIEROGLYPH G031EGYPTIAN HIE" +
	"ROGLYPH G032EGYPTIAN HIEROGLYPH G033EGYPTIAN HIEROGLYPH G034EGYPTIAN HIE" +
	"ROGLYPH G035EGYPTIAN HIEROGLYPH G036EGYPTIAN HIEROGLYPH G036AEGYPTIAN HI" +
	"EROGLYPH G037EGYPTIAN HIEROGLYPH G037AEGYPTIAN HIEROGLYPH G038EGYPTIAN H" +
	"IEROGLYPH G039EGYPTIAN HIEROGLYPH G040EGYPTIAN HIEROGLYPH G041EGYPTIAN H" +
	"IEROGLYPH G042EGYPTIAN HIEROGLYPH G043EGYPTIAN HIEROGLYPH G043AEGYPTIAN " +
	"HIEROGLYPH G044EGYPTIAN HIEROGLYPH G045EGYPTIAN HIEROGLYPH G045AEGYPTIAN" +
	" HIEROGLYPH G046EGYPTIAN HIEROGLYPH G047EGYPTIAN HIEROGLYPH G048EGYPTIAN" +
	" HIEROGLYPH G049EGYPTIAN HIEROGLYPH G050EGYPTIAN HIEROGLYPH G051EGYPTIAN" +
	" HIEROGLYPH G052EGYPTIAN HIEROGLYPH G053EGYPTIAN HIEROGLYPH G054EGYPTIAN" +
	" HIEROGLYPH H001EGYPTIAN HIEROGLYPH H002EGYPTIAN HIEROGLYPH H003EGYPTIAN" +
	" HIEROGLYPH H004EGYPTIAN HIEROGLYPH H005EGYPTIAN HIEROGLYPH H006EGYPTIAN" +
	" HIEROGLYPH H006AEGYPTIAN HIEROGLYPH H007EGYPTIAN HIEROGLYPH H008EGYPTIA" +
	"N HIEROGLYPH I001EGYPTIAN HIEROGLYPH I002EGYPTIAN HIEROGLYPH I003EGYPTIA" +
	"N HIEROGLYPH I004EGYPTIAN HIEROGLYPH I005EGYPTIAN HIEROGLYPH I005AEGYPTI" +
	"AN HIEROGLYPH I006EGYPTIAN HIEROGLYPH I007EGYPTIAN HIEROGLYPH I008EGYPTI" +
	"AN HIEROGLYPH I009EGYPTIAN HIEROGLYPH I009AEGYPTIAN HIEROGLYPH I010EGYPT" +
	"IAN HIEROGLYPH I010AEGYPTIAN HIEROGLYPH I011EGYPTIAN HIEROGLYPH I011AEGY" +
	"PTIAN HIEROGLYPH I012EGYPTIAN HIEROGLYPH I013EGYPTIAN HIEROGLYPH I014EGY" +
	"PTIAN HIEROGLYPH I015EGYPTIAN HIEROGLYPH K001EGYPTIAN HIEROGLYPH K002EGY" +
	"PTIAN HIEROGLYPH K003EGYPTIAN HIEROGLYPH K004EGYPTIAN HIEROGLYPH K005EGY" +
	"PTIAN HIEROGLYPH K006EGYPTIAN HIEROGLYPH K007EGYPTIAN HIEROGLYPH K008EGY" +
	"PTIAN HIEROGLYPH L001EGYPTIAN HIEROGLYPH L002EGYPTIAN HIEROGLYPH L002AEG" +
	"YPTIAN HIEROGLYPH L003EGYPTIAN HIEROGLYPH L004EGYPTIAN HIEROGLYPH L005EG" +
	"YPTIAN HIEROGLYPH L006EGYPTIAN HIEROGLYPH L006AEGYPTIAN HIEROGLYPH L007E" +
	"GYPTIAN HIEROGLYPH L008EGYPTIAN HIEROGLYPH M001EGYPTIAN HIEROGLYPH M001A" +
	"EGYPTIAN HIEROGLYPH M001BEGYPTIAN HIEROGLYPH M002EGYPTIAN HIEROGLYPH M00") + ("" +
	"3EGYPTIAN HIEROGLYPH M003AEGYPTIAN HIEROGLYPH M004EGYPTIAN HIEROGLYPH M0" +
	"05EGYPTIAN HIEROGLYPH M006EGYPTIAN HIEROGLYPH M007EGYPTIAN HIEROGLYPH M0" +
	"08EGYPTIAN HIEROGLYPH M009EGYPTIAN HIEROGLYPH M010EGYPTIAN HIEROGLYPH M0" +
	"10AEGYPTIAN HIEROGLYPH M011EGYPTIAN HIEROGLYPH M012EGYPTIAN HIEROGLYPH M" +
	"012AEGYPTIAN HIEROGLYPH M012BEGYPTIAN HIEROGLYPH M012CEGYPTIAN HIEROGLYP" +
	"H M012DEGYPTIAN HIEROGLYPH M012EEGYPTIAN HIEROGLYPH M012FEGYPTIAN HIEROG" +
	"LYPH M012GEGYPTIAN HIEROGLYPH M012HEGYPTIAN HIEROGLYPH M013EGYPTIAN HIER" +
	"OGLYPH M014EGYPTIAN HIEROGLYPH M015EGYPTIAN HIEROGLYPH M015AEGYPTIAN HIE" +
	"ROGLYPH M016EGYPTIAN HIEROGLYPH M016AEGYPTIAN HIEROGLYPH M017EGYPTIAN HI" +
	"EROGLYPH M017AEGYPTIAN HIEROGLYPH M018EGYPTIAN HIEROGLYPH M019EGYPTIAN H" +
	"IEROGLYPH M020EGYPTIAN HIEROGLYPH M021EGYPTIAN HIEROGLYPH M022EGYPTIAN H" +
	"IEROGLYPH M022AEGYPTIAN HIEROGLYPH M023EGYPTIAN HIEROGLYPH M024EGYPTIAN " +
	"HIEROGLYPH M024AEGYPTIAN HIEROGLYPH M025EGYPTIAN HIEROGLYPH M026EGYPTIAN" +
	" HIEROGLYPH M027EGYPTIAN HIEROGLYPH M028EGYPTIAN HIEROGLYPH M028AEGYPTIA" +
	"N HIEROGLYPH M029EGYPTIAN HIEROGLYPH M030EGYPTIAN HIEROGLYPH M031EGYPTIA" +
	"N HIEROGLYPH M031AEGYPTIAN HIEROGLYPH M032EGYPTIAN HIEROGLYPH M033EGYPTI" +
	"AN HIEROGLYPH M033AEGYPTIAN HIEROGLYPH M033BEGYPTIAN HIEROGLYPH M034EGYP" +
	"TIAN HIEROGLYPH M035EGYPTIAN HIEROGLYPH M036EGYPTIAN HIEROGLYPH M037EGYP" +
	"TIAN HIEROGLYPH M038EGYPTIAN HIEROGLYPH M039EGYPTIAN HIEROGLYPH M040EGYP" +
	"TIAN HIEROGLYPH M040AEGYPTIAN HIEROGLYPH M041EGYPTIAN HIEROGLYPH M042EGY" +
	"PTIAN HIEROGLYPH M043EGYPTIAN HIEROGLYPH M044EGYPTIAN HIEROGLYPH N001EGY" +
	"PTIAN HIEROGLYPH N002EGYPTIAN HIEROGLYPH N003EGYPTIAN HIEROGLYPH N004EGY" +
	"PTIAN HIEROGLYPH N005EGYPTIAN HIEROGLYPH N006EGYPTIAN HIEROGLYPH N007EGY" +
	"PTIAN HIEROGLYPH N008EGYPTIAN HIEROGLYPH N009EGYPTIAN HIEROGLYPH N010EGY" +
	"PTIAN HIEROGLYPH N011EGYPTIAN HIEROGLYPH N012EGYPTIAN HIEROGLYPH N013EGY" +
	"PTIAN HIEROGLYPH N014EGYPTIAN HIEROGLYPH N015EGYPTIAN HIEROGLYPH N016EGY" +
	"PTIAN HIEROGLYPH N017EGYPTIAN HIEROGLYPH N018EGYPTIAN HIEROGLYPH N018AEG" +
	"YPTIAN HIEROGLYPH N018BEGYPTIAN HIEROGLYPH N019EGYPTIAN HIEROGLYPH N020E" +
	"GYPTIAN HIEROGLYPH N021EGYPTIAN HIEROGLYPH N022EGYPTIAN HIEROGLYPH N023E" +
	"GYPTIAN HIEROGLYPH N024EGYPTIAN HIEROGLYPH N025EGYPTIAN HIEROGLYPH N025A" +
	"EGYPTIAN HIEROGLYPH N026EGYPTIAN HIEROGLYPH N027EGYPTIAN HIEROGLYPH N028" +
	"EGYPTIAN HIEROGLYPH N029EGYPTIAN HIEROGLYPH N030EGYPTIAN HIEROGLYPH N031" +
	"EGYPTIAN HIEROGLYPH N032EGYPTIAN HIEROGLYPH N033EGYPTIAN HIEROGLYPH N033" +
	"AEGYPTIAN HIEROGLYPH N034EGYPTIAN HIEROGLYPH N034AEGYPTIAN HIEROGLYPH N0" +
	"35EGYPTIAN HIEROGLYPH N035AEGYPTIAN HIEROGLYPH N036EGYPTIAN HIEROGLYPH N" +
	"037EGYPTIAN HIEROGLYPH N037AEGYPTIAN HIEROGLYPH N038EGYPTIAN HIEROGLYPH " +
	"N039EGYPTIAN HIEROGLYPH N040EGYPTIAN HIEROGLYPH N041EGYPTIAN HIEROGLYPH " +
	"N042EGYPTIAN HIEROGLYPH NL001EGYPTIAN HIEROGLYPH NL002EGYPTIAN HIEROGLYP" +
	"H NL003EGYPTIAN HIEROGLYPH NL004EGYPTIAN HIEROGLYPH NL005EGYPTIAN HIEROG" +
	"LYPH NL005AEGYPTIAN HIEROGLYPH NL006EGYPTIAN HIEROGLYPH NL007EGYPTIAN HI" +
	"EROGLYPH NL008EGYPTIAN HIEROGLYPH NL009EGYPTIAN HIEROGLYPH NL010EGYPTIAN" +
	" HIEROGLYPH NL011EGYPTIAN HIEROGLYPH NL012EGYPTIAN HIEROGLYPH NL013EGYPT" +
	"IAN HIEROGLYPH NL014EGYPTIAN HIEROGLYPH NL015EGYPTIAN HIEROGLYPH NL016EG" +
	"YPTIAN HIEROGLYPH NL017EGYPTIAN HIEROGLYPH NL017AEGYPTIAN HIEROGLYPH NL0" +
	"18EGYPTIAN HIEROGLYPH NL019EGYPTIAN HIEROGLYPH NL020EGYPTIAN HIEROGLYPH " +
	"NU001EGYPTIAN HIEROGLYPH NU002EGYPTIAN HIEROGLYPH NU003EGYPTIAN HIEROGLY" +
	"PH NU004EGYPTIAN HIEROGLYPH NU005EGYPTIAN HIEROGLYPH NU006EGYPTIAN HIERO" +
	"GLYPH NU007EGYPTIAN HIEROGLYPH NU008EGYPTIAN HIEROGLYPH NU009EGYPTIAN HI" +
	"EROGLYPH NU010EGYPTIAN HIEROGLYPH NU010AEGYPTIAN HIEROGLYPH NU011EGYPTIA" +
	"N HIEROGLYPH NU011AEGYPTIAN HIEROGLYPH NU012EGYPTIAN HIEROGLYPH NU013EGY" +
	"PTIAN HIEROGLYPH NU014EGYPTIAN HIEROGLYPH NU015EGYPTIAN HIEROGLYPH NU016" +
	"EGYPTIAN HIEROGLYPH NU017EGYPTIAN HIEROGLYPH NU018EGYPTIAN HIEROGLYPH NU" +
	"018AEGYPTIAN HIEROGLYPH NU019EGYPTIAN HIEROGLYPH NU020EGYPTIAN HIEROGLYP" +
	"H NU021EGYPTIAN HIEROGLYPH NU022EGYPTIAN HIEROGLYPH NU022AEGYPTIAN HIERO" +
	"GLYPH O001EGYPTIAN HIEROGLYPH O001AEGYPTIAN HIEROGLYPH O002EGYPTIAN HIER" +
	"OGLYPH O003EGYPTIAN HIEROGLYPH O004EGYPTIAN HIEROGLYPH O005EGYPTIAN HIER" +
	"OGLYPH O005AEGYPTIAN HIEROGLYPH O006EGYPTIAN HIEROGLYPH O006AEGYPTIAN HI" +
	"EROGLYPH O006BEGYPTIAN HIEROGLYPH O006CEGYPTIAN HIEROGLYPH O006DEGYPTIAN" +
	" HIEROGLYPH O006EEGYPTIAN HIEROGLYPH O006FEGYPTIAN HIEROGLYPH O007EGYPTI" +
	"AN HIEROGLYPH O008EGYPTIAN HIEROGLYPH O009EGYPTIAN HIEROGLYPH O010EGYPTI" +
	"AN HIEROGLYPH O010AEGYPTIAN HIEROGLYPH O010BEGYPTIAN HIEROGLYPH O010CEGY" +
	"PTIAN HIEROGLYPH O011EGYPTIAN HIEROGLYPH O012EGYPTIAN HIEROGLYPH O013EGY" +
	"PTIAN HIEROGLYPH O014EGYPTIAN HIEROGLYPH O015EGYPTIAN HIEROGLYPH O016EGY" +
	"PTIAN HIEROGLYPH O017EGYPTIAN HIEROGLYPH O018EGYPTIAN HIEROGLYPH O019EGY") + ("" +
	"PTIAN HIEROGLYPH O019AEGYPTIAN HIEROGLYPH O020EGYPTIAN HIEROGLYPH O020AE" +
	"GYPTIAN HIEROGLYPH O021EGYPTIAN HIEROGLYPH O022EGYPTIAN HIEROGLYPH O023E" +
	"GYPTIAN HIEROGLYPH O024EGYPTIAN HIEROGLYPH O024AEGYPTIAN HIEROGLYPH O025" +
	"EGYPTIAN HIEROGLYPH O025AEGYPTIAN HIEROGLYPH O026EGYPTIAN HIEROGLYPH O02" +
	"7EGYPTIAN HIEROGLYPH O028EGYPTIAN HIEROGLYPH O029EGYPTIAN HIEROGLYPH O02" +
	"9AEGYPTIAN HIEROGLYPH O030EGYPTIAN HIEROGLYPH O030AEGYPTIAN HIEROGLYPH O" +
	"031EGYPTIAN HIEROGLYPH O032EGYPTIAN HIEROGLYPH O033EGYPTIAN HIEROGLYPH O" +
	"033AEGYPTIAN HIEROGLYPH O034EGYPTIAN HIEROGLYPH O035EGYPTIAN HIEROGLYPH " +
	"O036EGYPTIAN HIEROGLYPH O036AEGYPTIAN HIEROGLYPH O036BEGYPTIAN HIEROGLYP" +
	"H O036CEGYPTIAN HIEROGLYPH O036DEGYPTIAN HIEROGLYPH O037EGYPTIAN HIEROGL" +
	"YPH O038EGYPTIAN HIEROGLYPH O039EGYPTIAN HIEROGLYPH O040EGYPTIAN HIEROGL" +
	"YPH O041EGYPTIAN HIEROGLYPH O042EGYPTIAN HIEROGLYPH O043EGYPTIAN HIEROGL" +
	"YPH O044EGYPTIAN HIEROGLYPH O045EGYPTIAN HIEROGLYPH O046EGYPTIAN HIEROGL" +
	"YPH O047EGYPTIAN HIEROGLYPH O048EGYPTIAN HIEROGLYPH O049EGYPTIAN HIEROGL" +
	"YPH O050EGYPTIAN HIEROGLYPH O050AEGYPTIAN HIEROGLYPH O050BEGYPTIAN HIERO" +
	"GLYPH O051EGYPTIAN HIEROGLYPH P001EGYPTIAN HIEROGLYPH P001AEGYPTIAN HIER" +
	"OGLYPH P002EGYPTIAN HIEROGLYPH P003EGYPTIAN HIEROGLYPH P003AEGYPTIAN HIE" +
	"ROGLYPH P004EGYPTIAN HIEROGLYPH P005EGYPTIAN HIEROGLYPH P006EGYPTIAN HIE" +
	"ROGLYPH P007EGYPTIAN HIEROGLYPH P008EGYPTIAN HIEROGLYPH P009EGYPTIAN HIE" +
	"ROGLYPH P010EGYPTIAN HIEROGLYPH P011EGYPTIAN HIEROGLYPH Q001EGYPTIAN HIE" +
	"ROGLYPH Q002EGYPTIAN HIEROGLYPH Q003EGYPTIAN HIEROGLYPH Q004EGYPTIAN HIE" +
	"ROGLYPH Q005EGYPTIAN HIEROGLYPH Q006EGYPTIAN HIEROGLYPH Q007EGYPTIAN HIE" +
	"ROGLYPH R001EGYPTIAN HIEROGLYPH R002EGYPTIAN HIEROGLYPH R002AEGYPTIAN HI" +
	"EROGLYPH R003EGYPTIAN HIEROGLYPH R003AEGYPTIAN HIEROGLYPH R003BEGYPTIAN " +
	"HIEROGLYPH R004EGYPTIAN HIEROGLYPH R005EGYPTIAN HIEROGLYPH R006EGYPTIAN " +
	"HIEROGLYPH R007EGYPTIAN HIEROGLYPH R008EGYPTIAN HIEROGLYPH R009EGYPTIAN " +
	"HIEROGLYPH R010EGYPTIAN HIEROGLYPH R010AEGYPTIAN HIEROGLYPH R011EGYPTIAN" +
	" HIEROGLYPH R012EGYPTIAN HIEROGLYPH R013EGYPTIAN HIEROGLYPH R014EGYPTIAN" +
	" HIEROGLYPH R015EGYPTIAN HIEROGLYPH R016EGYPTIAN HIEROGLYPH R016AEGYPTIA" +
	"N HIEROGLYPH R017EGYPTIAN HIEROGLYPH R018EGYPTIAN HIEROGLYPH R019EGYPTIA" +
	"N HIEROGLYPH R020EGYPTIAN HIEROGLYPH R021EGYPTIAN HIEROGLYPH R022EGYPTIA" +
	"N HIEROGLYPH R023EGYPTIAN HIEROGLYPH R024EGYPTIAN HIEROGLYPH R025EGYPTIA" +
	"N HIEROGLYPH R026EGYPTIAN HIEROGLYPH R027EGYPTIAN HIEROGLYPH R028EGYPTIA" +
	"N HIEROGLYPH R029EGYPTIAN HIEROGLYPH S001EGYPTIAN HIEROGLYPH S002EGYPTIA" +
	"N HIEROGLYPH S002AEGYPTIAN HIEROGLYPH S003EGYPTIAN HIEROGLYPH S004EGYPTI" +
	"AN HIEROGLYPH S005EGYPTIAN HIEROGLYPH S006EGYPTIAN HIEROGLYPH S006AEGYPT" +
	"IAN HIEROGLYPH S007EGYPTIAN HIEROGLYPH S008EGYPTIAN HIEROGLYPH S009EGYPT" +
	"IAN HIEROGLYPH S010EGYPTIAN HIEROGLYPH S011EGYPTIAN HIEROGLYPH S012EGYPT" +
	"IAN HIEROGLYPH S013EGYPTIAN HIEROGLYPH S014EGYPTIAN HIEROGLYPH S014AEGYP" +
	"TIAN HIEROGLYPH S014BEGYPTIAN HIEROGLYPH S015EGYPTIAN HIEROGLYPH S016EGY" +
	"PTIAN HIEROGLYPH S017EGYPTIAN HIEROGLYPH S017AEGYPTIAN HIEROGLYPH S018EG" +
	"YPTIAN HIEROGLYPH S019EGYPTIAN HIEROGLYPH S020EGYPTIAN HIEROGLYPH S021EG" +
	"YPTIAN HIEROGLYPH S022EGYPTIAN HIEROGLYPH S023EGYPTIAN HIEROGLYPH S024EG" +
	"YPTIAN HIEROGLYPH S025EGYPTIAN HIEROGLYPH S026EGYPTIAN HIEROGLYPH S026AE" +
	"GYPTIAN HIEROGLYPH S026BEGYPTIAN HIEROGLYPH S027EGYPTIAN HIEROGLYPH S028" +
	"EGYPTIAN HIEROGLYPH S029EGYPTIAN HIEROGLYPH S030EGYPTIAN HIEROGLYPH S031" +
	"EGYPTIAN HIEROGLYPH S032EGYPTIAN HIEROGLYPH S033EGYPTIAN HIEROGLYPH S034" +
	"EGYPTIAN HIEROGLYPH S035EGYPTIAN HIEROGLYPH S035AEGYPTIAN HIEROGLYPH S03" +
	"6EGYPTIAN HIEROGLYPH S037EGYPTIAN HIEROGLYPH S038EGYPTIAN HIEROGLYPH S03" +
	"9EGYPTIAN HIEROGLYPH S040EGYPTIAN HIEROGLYPH S041EGYPTIAN HIEROGLYPH S04" +
	"2EGYPTIAN HIEROGLYPH S043EGYPTIAN HIEROGLYPH S044EGYPTIAN HIEROGLYPH S04" +
	"5EGYPTIAN HIEROGLYPH S046EGYPTIAN HIEROGLYPH T001EGYPTIAN HIEROGLYPH T00" +
	"2EGYPTIAN HIEROGLYPH T003EGYPTIAN HIEROGLYPH T003AEGYPTIAN HIEROGLYPH T0" +
	"04EGYPTIAN HIEROGLYPH T005EGYPTIAN HIEROGLYPH T006EGYPTIAN HIEROGLYPH T0" +
	"07EGYPTIAN HIEROGLYPH T007AEGYPTIAN HIEROGLYPH T008EGYPTIAN HIEROGLYPH T" +
	"008AEGYPTIAN HIEROGLYPH T009EGYPTIAN HIEROGLYPH T009AEGYPTIAN HIEROGLYPH" +
	" T010EGYPTIAN HIEROGLYPH T011EGYPTIAN HIEROGLYPH T011AEGYPTIAN HIEROGLYP" +
	"H T012EGYPTIAN HIEROGLYPH T013EGYPTIAN HIEROGLYPH T014EGYPTIAN HIEROGLYP" +
	"H T015EGYPTIAN HIEROGLYPH T016EGYPTIAN HIEROGLYPH T016AEGYPTIAN HIEROGLY" +
	"PH T017EGYPTIAN HIEROGLYPH T018EGYPTIAN HIEROGLYPH T019EGYPTIAN HIEROGLY" +
	"PH T020EGYPTIAN HIEROGLYPH T021EGYPTIAN HIEROGLYPH T022EGYPTIAN HIEROGLY" +
	"PH T023EGYPTIAN HIEROGLYPH T024EGYPTIAN HIEROGLYPH T025EGYPTIAN HIEROGLY" +
	"PH T026EGYPTIAN HIEROGLYPH T027EGYPTIAN HIEROGLYPH T028EGYPTIAN HIEROGLY" +
	"PH T029EGYPTIAN HIEROGLYPH T030EGYPTIAN HIEROGLYPH T031EGYPTIAN HIEROGLY") + ("" +
	"PH T032EGYPTIAN HIEROGLYPH T032AEGYPTIAN HIEROGLYPH T033EGYPTIAN HIEROGL" +
	"YPH T033AEGYPTIAN HIEROGLYPH T034EGYPTIAN HIEROGLYPH T035EGYPTIAN HIEROG" +
	"LYPH T036EGYPTIAN HIEROGLYPH U001EGYPTIAN HIEROGLYPH U002EGYPTIAN HIEROG" +
	"LYPH U003EGYPTIAN HIEROGLYPH U004EGYPTIAN HIEROGLYPH U005EGYPTIAN HIEROG" +
	"LYPH U006EGYPTIAN HIEROGLYPH U006AEGYPTIAN HIEROGLYPH U006BEGYPTIAN HIER" +
	"OGLYPH U007EGYPTIAN HIEROGLYPH U008EGYPTIAN HIEROGLYPH U009EGYPTIAN HIER" +
	"OGLYPH U010EGYPTIAN HIEROGLYPH U011EGYPTIAN HIEROGLYPH U012EGYPTIAN HIER" +
	"OGLYPH U013EGYPTIAN HIEROGLYPH U014EGYPTIAN HIEROGLYPH U015EGYPTIAN HIER" +
	"OGLYPH U016EGYPTIAN HIEROGLYPH U017EGYPTIAN HIEROGLYPH U018EGYPTIAN HIER" +
	"OGLYPH U019EGYPTIAN HIEROGLYPH U020EGYPTIAN HIEROGLYPH U021EGYPTIAN HIER" +
	"OGLYPH U022EGYPTIAN HIEROGLYPH U023EGYPTIAN HIEROGLYPH U023AEGYPTIAN HIE" +
	"ROGLYPH U024EGYPTIAN HIEROGLYPH U025EGYPTIAN HIEROGLYPH U026EGYPTIAN HIE" +
	"ROGLYPH U027EGYPTIAN HIEROGLYPH U028EGYPTIAN HIEROGLYPH U029EGYPTIAN HIE" +
	"ROGLYPH U029AEGYPTIAN HIEROGLYPH U030EGYPTIAN HIEROGLYPH U031EGYPTIAN HI" +
	"EROGLYPH U032EGYPTIAN HIEROGLYPH U032AEGYPTIAN HIEROGLYPH U033EGYPTIAN H" +
	"IEROGLYPH U034EGYPTIAN HIEROGLYPH U035EGYPTIAN HIEROGLYPH U036EGYPTIAN H" +
	"IEROGLYPH U037EGYPTIAN HIEROGLYPH U038EGYPTIAN HIEROGLYPH U039EGYPTIAN H" +
	"IEROGLYPH U040EGYPTIAN HIEROGLYPH U041EGYPTIAN HIEROGLYPH U042EGYPTIAN H" +
	"IEROGLYPH V001EGYPTIAN HIEROGLYPH V001AEGYPTIAN HIEROGLYPH V001BEGYPTIAN" +
	" HIEROGLYPH V001CEGYPTIAN HIEROGLYPH V001DEGYPTIAN HIEROGLYPH V001EEGYPT" +
	"IAN HIEROGLYPH V001FEGYPTIAN HIEROGLYPH V001GEGYPTIAN HIEROGLYPH V001HEG" +
	"YPTIAN HIEROGLYPH V001IEGYPTIAN HIEROGLYPH V002EGYPTIAN HIEROGLYPH V002A" +
	"EGYPTIAN HIEROGLYPH V003EGYPTIAN HIEROGLYPH V004EGYPTIAN HIEROGLYPH V005" +
	"EGYPTIAN HIEROGLYPH V006EGYPTIAN HIEROGLYPH V007EGYPTIAN HIEROGLYPH V007" +
	"AEGYPTIAN HIEROGLYPH V007BEGYPTIAN HIEROGLYPH V008EGYPTIAN HIEROGLYPH V0" +
	"09EGYPTIAN HIEROGLYPH V010EGYPTIAN HIEROGLYPH V011EGYPTIAN HIEROGLYPH V0" +
	"11AEGYPTIAN HIEROGLYPH V011BEGYPTIAN HIEROGLYPH V011CEGYPTIAN HIEROGLYPH" +
	" V012EGYPTIAN HIEROGLYPH V012AEGYPTIAN HIEROGLYPH V012BEGYPTIAN HIEROGLY" +
	"PH V013EGYPTIAN HIEROGLYPH V014EGYPTIAN HIEROGLYPH V015EGYPTIAN HIEROGLY" +
	"PH V016EGYPTIAN HIEROGLYPH V017EGYPTIAN HIEROGLYPH V018EGYPTIAN HIEROGLY" +
	"PH V019EGYPTIAN HIEROGLYPH V020EGYPTIAN HIEROGLYPH V020AEGYPTIAN HIEROGL" +
	"YPH V020BEGYPTIAN HIEROGLYPH V020CEGYPTIAN HIEROGLYPH V020DEGYPTIAN HIER" +
	"OGLYPH V020EEGYPTIAN HIEROGLYPH V020FEGYPTIAN HIEROGLYPH V020GEGYPTIAN H" +
	"IEROGLYPH V020HEGYPTIAN HIEROGLYPH V020IEGYPTIAN HIEROGLYPH V020JEGYPTIA" +
	"N HIEROGLYPH V020KEGYPTIAN HIEROGLYPH V020LEGYPTIAN HIEROGLYPH V021EGYPT" +
	"IAN HIEROGLYPH V022EGYPTIAN HIEROGLYPH V023EGYPTIAN HIEROGLYPH V023AEGYP" +
	"TIAN HIEROGLYPH V024EGYPTIAN HIEROGLYPH V025EGYPTIAN HIEROGLYPH V026EGYP" +
	"TIAN HIEROGLYPH V027EGYPTIAN HIEROGLYPH V028EGYPTIAN HIEROGLYPH V028AEGY" +
	"PTIAN HIEROGLYPH V029EGYPTIAN HIEROGLYPH V029AEGYPTIAN HIEROGLYPH V030EG" +
	"YPTIAN HIEROGLYPH V030AEGYPTIAN HIEROGLYPH V031EGYPTIAN HIEROGLYPH V031A" +
	"EGYPTIAN HIEROGLYPH V032EGYPTIAN HIEROGLYPH V033EGYPTIAN HIEROGLYPH V033" +
	"AEGYPTIAN HIEROGLYPH V034EGYPTIAN HIEROGLYPH V035EGYPTIAN HIEROGLYPH V03" +
	"6EGYPTIAN HIEROGLYPH V037EGYPTIAN HIEROGLYPH V037AEGYPTIAN HIEROGLYPH V0" +
	"38EGYPTIAN HIEROGLYPH V039EGYPTIAN HIEROGLYPH V040EGYPTIAN HIEROGLYPH V0" +
	"40AEGYPTIAN HIEROGLYPH W001EGYPTIAN HIEROGLYPH W002EGYPTIAN HIEROGLYPH W" +
	"003EGYPTIAN HIEROGLYPH W003AEGYPTIAN HIEROGLYPH W004EGYPTIAN HIEROGLYPH " +
	"W005EGYPTIAN HIEROGLYPH W006EGYPTIAN HIEROGLYPH W007EGYPTIAN HIEROGLYPH " +
	"W008EGYPTIAN HIEROGLYPH W009EGYPTIAN HIEROGLYPH W009AEGYPTIAN HIEROGLYPH" +
	" W010EGYPTIAN HIEROGLYPH W010AEGYPTIAN HIEROGLYPH W011EGYPTIAN HIEROGLYP" +
	"H W012EGYPTIAN HIEROGLYPH W013EGYPTIAN HIEROGLYPH W014EGYPTIAN HIEROGLYP" +
	"H W014AEGYPTIAN HIEROGLYPH W015EGYPTIAN HIEROGLYPH W016EGYPTIAN HIEROGLY" +
	"PH W017EGYPTIAN HIEROGLYPH W017AEGYPTIAN HIEROGLYPH W018EGYPTIAN HIEROGL" +
	"YPH W018AEGYPTIAN HIEROGLYPH W019EGYPTIAN HIEROGLYPH W020EGYPTIAN HIEROG" +
	"LYPH W021EGYPTIAN HIEROGLYPH W022EGYPTIAN HIEROGLYPH W023EGYPTIAN HIEROG" +
	"LYPH W024EGYPTIAN HIEROGLYPH W024AEGYPTIAN HIEROGLYPH W025EGYPTIAN HIERO" +
	"GLYPH X001EGYPTIAN HIEROGLYPH X002EGYPTIAN HIEROGLYPH X003EGYPTIAN HIERO" +
	"GLYPH X004EGYPTIAN HIEROGLYPH X004AEGYPTIAN HIEROGLYPH X004BEGYPTIAN HIE" +
	"ROGLYPH X005EGYPTIAN HIEROGLYPH X006EGYPTIAN HIEROGLYPH X006AEGYPTIAN HI" +
	"EROGLYPH X007EGYPTIAN HIEROGLYPH X008EGYPTIAN HIEROGLYPH X008AEGYPTIAN H" +
	"IEROGLYPH Y001EGYPTIAN HIEROGLYPH Y001AEGYPTIAN HIEROGLYPH Y002EGYPTIAN " +
	"HIEROGLYPH Y003EGYPTIAN HIEROGLYPH Y004EGYPTIAN HIEROGLYPH Y005EGYPTIAN " +
	"HIEROGLYPH Y006EGYPTIAN HIEROGLYPH Y007EGYPTIAN HIEROGLYPH Y008EGYPTIAN " +
	"HIEROGLYPH Z001EGYPTIAN HIEROGLYPH Z002EGYPTIAN HIEROGLYPH Z002AEGYPTIAN" +
	" HIEROGLYPH Z002BEGYPTIAN HIEROGLYPH Z002CEGYPTIAN HIEROGLYPH Z002DEGYPT") + ("" +
	"IAN HIEROGLYPH Z003EGYPTIAN HIEROGLYPH Z003AEGYPTIAN HIEROGLYPH Z003BEGY" +
	"PTIAN HIEROGLYPH Z004EGYPTIAN HIEROGLYPH Z004AEGYPTIAN HIEROGLYPH Z005EG" +
	"YPTIAN HIEROGLYPH Z005AEGYPTIAN HIEROGLYPH Z006EGYPTIAN HIEROGLYPH Z007E" +
	"GYPTIAN HIEROGLYPH Z008EGYPTIAN HIEROGLYPH Z009EGYPTIAN HIEROGLYPH Z010E" +
	"GYPTIAN HIEROGLYPH Z011EGYPTIAN HIEROGLYPH Z012EGYPTIAN HIEROGLYPH Z013E" +
	"GYPTIAN HIEROGLYPH Z014EGYPTIAN HIEROGLYPH Z015EGYPTIAN HIEROGLYPH Z015A" +
	"EGYPTIAN HIEROGLYPH Z015BEGYPTIAN HIEROGLYPH Z015CEGYPTIAN HIEROGLYPH Z0" +
	"15DEGYPTIAN HIEROGLYPH Z015EEGYPTIAN HIEROGLYPH Z015FEGYPTIAN HIEROGLYPH" +
	" Z015GEGYPTIAN HIEROGLYPH Z015HEGYPTIAN HIEROGLYPH Z015IEGYPTIAN HIEROGL" +
	"YPH Z016EGYPTIAN HIEROGLYPH Z016AEGYPTIAN HIEROGLYPH Z016BEGYPTIAN HIERO" +
	"GLYPH Z016CEGYPTIAN HIEROGLYPH Z016DEGYPTIAN HIEROGLYPH Z016EEGYPTIAN HI" +
	"EROGLYPH Z016FEGYPTIAN HIEROGLYPH Z016GEGYPTIAN HIEROGLYPH Z016HEGYPTIAN" +
	" HIEROGLYPH AA001EGYPTIAN HIEROGLYPH AA002EGYPTIAN HIEROGLYPH AA003EGYPT" +
	"IAN HIEROGLYPH AA004EGYPTIAN HIEROGLYPH AA005EGYPTIAN HIEROGLYPH AA006EG" +
	"YPTIAN HIEROGLYPH AA007EGYPTIAN HIEROGLYPH AA007AEGYPTIAN HIEROGLYPH AA0" +
	"07BEGYPTIAN HIEROGLYPH AA008EGYPTIAN HIEROGLYPH AA009EGYPTIAN HIEROGLYPH" +
	" AA010EGYPTIAN HIEROGLYPH AA011EGYPTIAN HIEROGLYPH AA012EGYPTIAN HIEROGL" +
	"YPH AA013EGYPTIAN HIEROGLYPH AA014EGYPTIAN HIEROGLYPH AA015EGYPTIAN HIER" +
	"OGLYPH AA016EGYPTIAN HIEROGLYPH AA017EGYPTIAN HIEROGLYPH AA018EGYPTIAN H" +
	"IEROGLYPH AA019EGYPTIAN HIEROGLYPH AA020EGYPTIAN HIEROGLYPH AA021EGYPTIA" +
	"N HIEROGLYPH AA022EGYPTIAN HIEROGLYPH AA023EGYPTIAN HIEROGLYPH AA024EGYP" +
	"TIAN HIEROGLYPH AA025EGYPTIAN HIEROGLYPH AA026EGYPTIAN HIEROGLYPH AA027E" +
	"GYPTIAN HIEROGLYPH AA028EGYPTIAN HIEROGLYPH AA029EGYPTIAN HIEROGLYPH AA0" +
	"30EGYPTIAN HIEROGLYPH AA031EGYPTIAN HIEROGLYPH AA032EGYPTIAN HIEROGLYPH " +
	"VERTICAL JOINEREGYPTIAN HIEROGLYPH HORIZONTAL JOINEREGYPTIAN HIEROGLYPH " +
	"INSERT AT TOP STARTEGYPTIAN HIEROGLYPH INSERT AT BOTTOM STARTEGYPTIAN HI" +
	"EROGLYPH INSERT AT TOP ENDEGYPTIAN HIEROGLYPH INSERT AT BOTTOM ENDEGYPTI" +
	"AN HIEROGLYPH OVERLAY MIDDLEEGYPTIAN HIEROGLYPH BEGIN SEGMENTEGYPTIAN HI" +
	"EROGLYPH END SEGMENTANATOLIAN HIEROGLYPH A001ANATOLIAN HIEROGLYPH A002AN" +
	"ATOLIAN HIEROGLYPH A003ANATOLIAN HIEROGLYPH A004ANATOLIAN HIEROGLYPH A00" +
	"5ANATOLIAN HIEROGLYPH A006ANATOLIAN HIEROGLYPH A007ANATOLIAN HIEROGLYPH " +
	"A008ANATOLIAN HIEROGLYPH A009ANATOLIAN HIEROGLYPH A010ANATOLIAN HIEROGLY" +
	"PH A010AANATOLIAN HIEROGLYPH A011ANATOLIAN HIEROGLYPH A012ANATOLIAN HIER" +
	"OGLYPH A013ANATOLIAN HIEROGLYPH A014ANATOLIAN HIEROGLYPH A015ANATOLIAN H" +
	"IEROGLYPH A016ANATOLIAN HIEROGLYPH A017ANATOLIAN HIEROGLYPH A018ANATOLIA" +
	"N HIEROGLYPH A019ANATOLIAN HIEROGLYPH A020ANATOLIAN HIEROGLYPH A021ANATO" +
	"LIAN HIEROGLYPH A022ANATOLIAN HIEROGLYPH A023ANATOLIAN HIEROGLYPH A024AN" +
	"ATOLIAN HIEROGLYPH A025ANATOLIAN HIEROGLYPH A026ANATOLIAN HIEROGLYPH A02" +
	"6AANATOLIAN HIEROGLYPH A027ANATOLIAN HIEROGLYPH A028ANATOLIAN HIEROGLYPH" +
	" A029ANATOLIAN HIEROGLYPH A030ANATOLIAN HIEROGLYPH A031ANATOLIAN HIEROGL" +
	"YPH A032ANATOLIAN HIEROGLYPH A033ANATOLIAN HIEROGLYPH A034ANATOLIAN HIER" +
	"OGLYPH A035ANATOLIAN HIEROGLYPH A036ANATOLIAN HIEROGLYPH A037ANATOLIAN H" +
	"IEROGLYPH A038ANATOLIAN HIEROGLYPH A039ANATOLIAN HIEROGLYPH A039AANATOLI" +
	"AN HIEROGLYPH A040ANATOLIAN HIEROGLYPH A041ANATOLIAN HIEROGLYPH A041AANA" +
	"TOLIAN HIEROGLYPH A042ANATOLIAN HIEROGLYPH A043ANATOLIAN HIEROGLYPH A044" +
	"ANATOLIAN HIEROGLYPH A045ANATOLIAN HIEROGLYPH A045AANATOLIAN HIEROGLYPH " +
	"A046ANATOLIAN HIEROGLYPH A046AANATOLIAN HIEROGLYPH A046BANATOLIAN HIEROG" +
	"LYPH A047ANATOLIAN HIEROGLYPH A048ANATOLIAN HIEROGLYPH A049ANATOLIAN HIE" +
	"ROGLYPH A050ANATOLIAN HIEROGLYPH A051ANATOLIAN HIEROGLYPH A052ANATOLIAN " +
	"HIEROGLYPH A053ANATOLIAN HIEROGLYPH A054ANATOLIAN HIEROGLYPH A055ANATOLI" +
	"AN HIEROGLYPH A056ANATOLIAN HIEROGLYPH A057ANATOLIAN HIEROGLYPH A058ANAT" +
	"OLIAN HIEROGLYPH A059ANATOLIAN HIEROGLYPH A060ANATOLIAN HIEROGLYPH A061A" +
	"NATOLIAN HIEROGLYPH A062ANATOLIAN HIEROGLYPH A063ANATOLIAN HIEROGLYPH A0" +
	"64ANATOLIAN HIEROGLYPH A065ANATOLIAN HIEROGLYPH A066ANATOLIAN HIEROGLYPH" +
	" A066AANATOLIAN HIEROGLYPH A066BANATOLIAN HIEROGLYPH A066CANATOLIAN HIER" +
	"OGLYPH A067ANATOLIAN HIEROGLYPH A068ANATOLIAN HIEROGLYPH A069ANATOLIAN H" +
	"IEROGLYPH A070ANATOLIAN HIEROGLYPH A071ANATOLIAN HIEROGLYPH A072ANATOLIA" +
	"N HIEROGLYPH A073ANATOLIAN HIEROGLYPH A074ANATOLIAN HIEROGLYPH A075ANATO" +
	"LIAN HIEROGLYPH A076ANATOLIAN HIEROGLYPH A077ANATOLIAN HIEROGLYPH A078AN" +
	"ATOLIAN HIEROGLYPH A079ANATOLIAN HIEROGLYPH A080ANATOLIAN HIEROGLYPH A08" +
	"1ANATOLIAN HIEROGLYPH A082ANATOLIAN HIEROGLYPH A083ANATOLIAN HIEROGLYPH " +
	"A084ANATOLIAN HIEROGLYPH A085ANATOLIAN HIEROGLYPH A086ANATOLIAN HIEROGLY" +
	"PH A087ANATOLIAN HIEROGLYPH A088ANATOLIAN HIEROGLYPH A089ANATOLIAN HIERO" +
	"GLYPH A090ANATOLIAN HIEROGLYPH A091ANATOLIAN HIEROGLYPH A092ANATOLIAN HI") + ("" +
	"EROGLYPH A093ANATOLIAN HIEROGLYPH A094ANATOLIAN HIEROGLYPH A095ANATOLIAN" +
	" HIEROGLYPH A096ANATOLIAN HIEROGLYPH A097ANATOLIAN HIEROGLYPH A097AANATO" +
	"LIAN HIEROGLYPH A098ANATOLIAN HIEROGLYPH A098AANATOLIAN HIEROGLYPH A099A" +
	"NATOLIAN HIEROGLYPH A100ANATOLIAN HIEROGLYPH A100AANATOLIAN HIEROGLYPH A" +
	"101ANATOLIAN HIEROGLYPH A101AANATOLIAN HIEROGLYPH A102ANATOLIAN HIEROGLY" +
	"PH A102AANATOLIAN HIEROGLYPH A103ANATOLIAN HIEROGLYPH A104ANATOLIAN HIER" +
	"OGLYPH A104AANATOLIAN HIEROGLYPH A104BANATOLIAN HIEROGLYPH A104CANATOLIA" +
	"N HIEROGLYPH A105ANATOLIAN HIEROGLYPH A105AANATOLIAN HIEROGLYPH A105BANA" +
	"TOLIAN HIEROGLYPH A106ANATOLIAN HIEROGLYPH A107ANATOLIAN HIEROGLYPH A107" +
	"AANATOLIAN HIEROGLYPH A107BANATOLIAN HIEROGLYPH A107CANATOLIAN HIEROGLYP" +
	"H A108ANATOLIAN HIEROGLYPH A109ANATOLIAN HIEROGLYPH A110ANATOLIAN HIEROG" +
	"LYPH A110AANATOLIAN HIEROGLYPH A110BANATOLIAN HIEROGLYPH A111ANATOLIAN H" +
	"IEROGLYPH A112ANATOLIAN HIEROGLYPH A113ANATOLIAN HIEROGLYPH A114ANATOLIA" +
	"N HIEROGLYPH A115ANATOLIAN HIEROGLYPH A115AANATOLIAN HIEROGLYPH A116ANAT" +
	"OLIAN HIEROGLYPH A117ANATOLIAN HIEROGLYPH A118ANATOLIAN HIEROGLYPH A119A" +
	"NATOLIAN HIEROGLYPH A120ANATOLIAN HIEROGLYPH A121ANATOLIAN HIEROGLYPH A1" +
	"22ANATOLIAN HIEROGLYPH A123ANATOLIAN HIEROGLYPH A124ANATOLIAN HIEROGLYPH" +
	" A125ANATOLIAN HIEROGLYPH A125AANATOLIAN HIEROGLYPH A126ANATOLIAN HIEROG" +
	"LYPH A127ANATOLIAN HIEROGLYPH A128ANATOLIAN HIEROGLYPH A129ANATOLIAN HIE" +
	"ROGLYPH A130ANATOLIAN HIEROGLYPH A131ANATOLIAN HIEROGLYPH A132ANATOLIAN " +
	"HIEROGLYPH A133ANATOLIAN HIEROGLYPH A134ANATOLIAN HIEROGLYPH A135ANATOLI" +
	"AN HIEROGLYPH A135AANATOLIAN HIEROGLYPH A136ANATOLIAN HIEROGLYPH A137ANA" +
	"TOLIAN HIEROGLYPH A138ANATOLIAN HIEROGLYPH A139ANATOLIAN HIEROGLYPH A140" +
	"ANATOLIAN HIEROGLYPH A141ANATOLIAN HIEROGLYPH A142ANATOLIAN HIEROGLYPH A" +
	"143ANATOLIAN HIEROGLYPH A144ANATOLIAN HIEROGLYPH A145ANATOLIAN HIEROGLYP" +
	"H A146ANATOLIAN HIEROGLYPH A147ANATOLIAN HIEROGLYPH A148ANATOLIAN HIEROG" +
	"LYPH A149ANATOLIAN HIEROGLYPH A150ANATOLIAN HIEROGLYPH A151ANATOLIAN HIE" +
	"ROGLYPH A152ANATOLIAN HIEROGLYPH A153ANATOLIAN HIEROGLYPH A154ANATOLIAN " +
	"HIEROGLYPH A155ANATOLIAN HIEROGLYPH A156ANATOLIAN HIEROGLYPH A157ANATOLI" +
	"AN HIEROGLYPH A158ANATOLIAN HIEROGLYPH A159ANATOLIAN HIEROGLYPH A160ANAT" +
	"OLIAN HIEROGLYPH A161ANATOLIAN HIEROGLYPH A162ANATOLIAN HIEROGLYPH A163A" +
	"NATOLIAN HIEROGLYPH A164ANATOLIAN HIEROGLYPH A165ANATOLIAN HIEROGLYPH A1" +
	"66ANATOLIAN HIEROGLYPH A167ANATOLIAN HIEROGLYPH A168ANATOLIAN HIEROGLYPH" +
	" A169ANATOLIAN HIEROGLYPH A170ANATOLIAN HIEROGLYPH A171ANATOLIAN HIEROGL" +
	"YPH A172ANATOLIAN HIEROGLYPH A173ANATOLIAN HIEROGLYPH A174ANATOLIAN HIER" +
	"OGLYPH A175ANATOLIAN HIEROGLYPH A176ANATOLIAN HIEROGLYPH A177ANATOLIAN H" +
	"IEROGLYPH A178ANATOLIAN HIEROGLYPH A179ANATOLIAN HIEROGLYPH A180ANATOLIA" +
	"N HIEROGLYPH A181ANATOLIAN HIEROGLYPH A182ANATOLIAN HIEROGLYPH A183ANATO" +
	"LIAN HIEROGLYPH A184ANATOLIAN HIEROGLYPH A185ANATOLIAN HIEROGLYPH A186AN" +
	"ATOLIAN HIEROGLYPH A187ANATOLIAN HIEROGLYPH A188ANATOLIAN HIEROGLYPH A18" +
	"9ANATOLIAN HIEROGLYPH A190ANATOLIAN HIEROGLYPH A191ANATOLIAN HIEROGLYPH " +
	"A192ANATOLIAN HIEROGLYPH A193ANATOLIAN HIEROGLYPH A194ANATOLIAN HIEROGLY" +
	"PH A195ANATOLIAN HIEROGLYPH A196ANATOLIAN HIEROGLYPH A197ANATOLIAN HIERO" +
	"GLYPH A198ANATOLIAN HIEROGLYPH A199ANATOLIAN HIEROGLYPH A200ANATOLIAN HI" +
	"EROGLYPH A201ANATOLIAN HIEROGLYPH A202ANATOLIAN HIEROGLYPH A202AANATOLIA" +
	"N HIEROGLYPH A202BANATOLIAN HIEROGLYPH A203ANATOLIAN HIEROGLYPH A204ANAT" +
	"OLIAN HIEROGLYPH A205ANATOLIAN HIEROGLYPH A206ANATOLIAN HIEROGLYPH A207A" +
	"NATOLIAN HIEROGLYPH A207AANATOLIAN HIEROGLYPH A208ANATOLIAN HIEROGLYPH A" +
	"209ANATOLIAN HIEROGLYPH A209AANATOLIAN HIEROGLYPH A210ANATOLIAN HIEROGLY" +
	"PH A211ANATOLIAN HIEROGLYPH A212ANATOLIAN HIEROGLYPH A213ANATOLIAN HIERO" +
	"GLYPH A214ANATOLIAN HIEROGLYPH A215ANATOLIAN HIEROGLYPH A215AANATOLIAN H" +
	"IEROGLYPH A216ANATOLIAN HIEROGLYPH A216AANATOLIAN HIEROGLYPH A217ANATOLI" +
	"AN HIEROGLYPH A218ANATOLIAN HIEROGLYPH A219ANATOLIAN HIEROGLYPH A220ANAT" +
	"OLIAN HIEROGLYPH A221ANATOLIAN HIEROGLYPH A222ANATOLIAN HIEROGLYPH A223A" +
	"NATOLIAN HIEROGLYPH A224ANATOLIAN HIEROGLYPH A225ANATOLIAN HIEROGLYPH A2" +
	"26ANATOLIAN HIEROGLYPH A227ANATOLIAN HIEROGLYPH A227AANATOLIAN HIEROGLYP" +
	"H A228ANATOLIAN HIEROGLYPH A229ANATOLIAN HIEROGLYPH A230ANATOLIAN HIEROG" +
	"LYPH A231ANATOLIAN HIEROGLYPH A232ANATOLIAN HIEROGLYPH A233ANATOLIAN HIE" +
	"ROGLYPH A234ANATOLIAN HIEROGLYPH A235ANATOLIAN HIEROGLYPH A236ANATOLIAN " +
	"HIEROGLYPH A237ANATOLIAN HIEROGLYPH A238ANATOLIAN HIEROGLYPH A239ANATOLI" +
	"AN HIEROGLYPH A240ANATOLIAN HIEROGLYPH A241ANATOLIAN HIEROGLYPH A242ANAT" +
	"OLIAN HIEROGLYPH A243ANATOLIAN HIEROGLYPH A244ANATOLIAN HIEROGLYPH A245A" +
	"NATOLIAN HIEROGLYPH A246ANATOLIAN HIEROGLYPH A247ANATOLIAN HIEROGLYPH A2" +
	"48ANATOLIAN HIEROGLYPH A249ANATOLIAN HIEROGLYPH A250ANATOLIAN HIEROGLYPH") + ("" +
	" A251ANATOLIAN HIEROGLYPH A252ANATOLIAN HIEROGLYPH A253ANATOLIAN HIEROGL" +
	"YPH A254ANATOLIAN HIEROGLYPH A255ANATOLIAN HIEROGLYPH A256ANATOLIAN HIER" +
	"OGLYPH A257ANATOLIAN HIEROGLYPH A258ANATOLIAN HIEROGLYPH A259ANATOLIAN H" +
	"IEROGLYPH A260ANATOLIAN HIEROGLYPH A261ANATOLIAN HIEROGLYPH A262ANATOLIA" +
	"N HIEROGLYPH A263ANATOLIAN HIEROGLYPH A264ANATOLIAN HIEROGLYPH A265ANATO" +
	"LIAN HIEROGLYPH A266ANATOLIAN HIEROGLYPH A267ANATOLIAN HIEROGLYPH A267AA" +
	"NATOLIAN HIEROGLYPH A268ANATOLIAN HIEROGLYPH A269ANATOLIAN HIEROGLYPH A2" +
	"70ANATOLIAN HIEROGLYPH A271ANATOLIAN HIEROGLYPH A272ANATOLIAN HIEROGLYPH" +
	" A273ANATOLIAN HIEROGLYPH A274ANATOLIAN HIEROGLYPH A275ANATOLIAN HIEROGL" +
	"YPH A276ANATOLIAN HIEROGLYPH A277ANATOLIAN HIEROGLYPH A278ANATOLIAN HIER" +
	"OGLYPH A279ANATOLIAN HIEROGLYPH A280ANATOLIAN HIEROGLYPH A281ANATOLIAN H" +
	"IEROGLYPH A282ANATOLIAN HIEROGLYPH A283ANATOLIAN HIEROGLYPH A284ANATOLIA" +
	"N HIEROGLYPH A285ANATOLIAN HIEROGLYPH A286ANATOLIAN HIEROGLYPH A287ANATO" +
	"LIAN HIEROGLYPH A288ANATOLIAN HIEROGLYPH A289ANATOLIAN HIEROGLYPH A289AA" +
	"NATOLIAN HIEROGLYPH A290ANATOLIAN HIEROGLYPH A291ANATOLIAN HIEROGLYPH A2" +
	"92ANATOLIAN HIEROGLYPH A293ANATOLIAN HIEROGLYPH A294ANATOLIAN HIEROGLYPH" +
	" A294AANATOLIAN HIEROGLYPH A295ANATOLIAN HIEROGLYPH A296ANATOLIAN HIEROG" +
	"LYPH A297ANATOLIAN HIEROGLYPH A298ANATOLIAN HIEROGLYPH A299ANATOLIAN HIE" +
	"ROGLYPH A299AANATOLIAN HIEROGLYPH A300ANATOLIAN HIEROGLYPH A301ANATOLIAN" +
	" HIEROGLYPH A302ANATOLIAN HIEROGLYPH A303ANATOLIAN HIEROGLYPH A304ANATOL" +
	"IAN HIEROGLYPH A305ANATOLIAN HIEROGLYPH A306ANATOLIAN HIEROGLYPH A307ANA" +
	"TOLIAN HIEROGLYPH A308ANATOLIAN HIEROGLYPH A309ANATOLIAN HIEROGLYPH A309" +
	"AANATOLIAN HIEROGLYPH A310ANATOLIAN HIEROGLYPH A311ANATOLIAN HIEROGLYPH " +
	"A312ANATOLIAN HIEROGLYPH A313ANATOLIAN HIEROGLYPH A314ANATOLIAN HIEROGLY" +
	"PH A315ANATOLIAN HIEROGLYPH A316ANATOLIAN HIEROGLYPH A317ANATOLIAN HIERO" +
	"GLYPH A318ANATOLIAN HIEROGLYPH A319ANATOLIAN HIEROGLYPH A320ANATOLIAN HI" +
	"EROGLYPH A321ANATOLIAN HIEROGLYPH A322ANATOLIAN HIEROGLYPH A323ANATOLIAN" +
	" HIEROGLYPH A324ANATOLIAN HIEROGLYPH A325ANATOLIAN HIEROGLYPH A326ANATOL" +
	"IAN HIEROGLYPH A327ANATOLIAN HIEROGLYPH A328ANATOLIAN HIEROGLYPH A329ANA" +
	"TOLIAN HIEROGLYPH A329AANATOLIAN HIEROGLYPH A330ANATOLIAN HIEROGLYPH A33" +
	"1ANATOLIAN HIEROGLYPH A332AANATOLIAN HIEROGLYPH A332BANATOLIAN HIEROGLYP" +
	"H A332CANATOLIAN HIEROGLYPH A333ANATOLIAN HIEROGLYPH A334ANATOLIAN HIERO" +
	"GLYPH A335ANATOLIAN HIEROGLYPH A336ANATOLIAN HIEROGLYPH A336AANATOLIAN H" +
	"IEROGLYPH A336BANATOLIAN HIEROGLYPH A336CANATOLIAN HIEROGLYPH A337ANATOL" +
	"IAN HIEROGLYPH A338ANATOLIAN HIEROGLYPH A339ANATOLIAN HIEROGLYPH A340ANA" +
	"TOLIAN HIEROGLYPH A341ANATOLIAN HIEROGLYPH A342ANATOLIAN HIEROGLYPH A343" +
	"ANATOLIAN HIEROGLYPH A344ANATOLIAN HIEROGLYPH A345ANATOLIAN HIEROGLYPH A" +
	"346ANATOLIAN HIEROGLYPH A347ANATOLIAN HIEROGLYPH A348ANATOLIAN HIEROGLYP" +
	"H A349ANATOLIAN HIEROGLYPH A350ANATOLIAN HIEROGLYPH A351ANATOLIAN HIEROG" +
	"LYPH A352ANATOLIAN HIEROGLYPH A353ANATOLIAN HIEROGLYPH A354ANATOLIAN HIE" +
	"ROGLYPH A355ANATOLIAN HIEROGLYPH A356ANATOLIAN HIEROGLYPH A357ANATOLIAN " +
	"HIEROGLYPH A358ANATOLIAN HIEROGLYPH A359ANATOLIAN HIEROGLYPH A359AANATOL" +
	"IAN HIEROGLYPH A360ANATOLIAN HIEROGLYPH A361ANATOLIAN HIEROGLYPH A362ANA" +
	"TOLIAN HIEROGLYPH A363ANATOLIAN HIEROGLYPH A364ANATOLIAN HIEROGLYPH A364" +
	"AANATOLIAN HIEROGLYPH A365ANATOLIAN HIEROGLYPH A366ANATOLIAN HIEROGLYPH " +
	"A367ANATOLIAN HIEROGLYPH A368ANATOLIAN HIEROGLYPH A368AANATOLIAN HIEROGL" +
	"YPH A369ANATOLIAN HIEROGLYPH A370ANATOLIAN HIEROGLYPH A371ANATOLIAN HIER" +
	"OGLYPH A371AANATOLIAN HIEROGLYPH A372ANATOLIAN HIEROGLYPH A373ANATOLIAN " +
	"HIEROGLYPH A374ANATOLIAN HIEROGLYPH A375ANATOLIAN HIEROGLYPH A376ANATOLI" +
	"AN HIEROGLYPH A377ANATOLIAN HIEROGLYPH A378ANATOLIAN HIEROGLYPH A379ANAT" +
	"OLIAN HIEROGLYPH A380ANATOLIAN HIEROGLYPH A381ANATOLIAN HIEROGLYPH A381A" +
	"ANATOLIAN HIEROGLYPH A382ANATOLIAN HIEROGLYPH A383 RA OR RIANATOLIAN HIE" +
	"ROGLYPH A383AANATOLIAN HIEROGLYPH A384ANATOLIAN HIEROGLYPH A385ANATOLIAN" +
	" HIEROGLYPH A386ANATOLIAN HIEROGLYPH A386AANATOLIAN HIEROGLYPH A387ANATO" +
	"LIAN HIEROGLYPH A388ANATOLIAN HIEROGLYPH A389ANATOLIAN HIEROGLYPH A390AN" +
	"ATOLIAN HIEROGLYPH A391ANATOLIAN HIEROGLYPH A392ANATOLIAN HIEROGLYPH A39" +
	"3 EIGHTANATOLIAN HIEROGLYPH A394ANATOLIAN HIEROGLYPH A395ANATOLIAN HIERO" +
	"GLYPH A396ANATOLIAN HIEROGLYPH A397ANATOLIAN HIEROGLYPH A398ANATOLIAN HI" +
	"EROGLYPH A399ANATOLIAN HIEROGLYPH A400ANATOLIAN HIEROGLYPH A401ANATOLIAN" +
	" HIEROGLYPH A402ANATOLIAN HIEROGLYPH A403ANATOLIAN HIEROGLYPH A404ANATOL" +
	"IAN HIEROGLYPH A405ANATOLIAN HIEROGLYPH A406ANATOLIAN HIEROGLYPH A407ANA" +
	"TOLIAN HIEROGLYPH A408ANATOLIAN HIEROGLYPH A409ANATOLIAN HIEROGLYPH A410" +
	" BEGIN LOGOGRAM MARKANATOLIAN HIEROGLYPH A410A END LOGOGRAM MARKANATOLIA" +
	"N HIEROGLYPH A411ANATOLIAN HIEROGLYPH A412ANATOLIAN HIEROGLYPH A413ANATO") + ("" +
	"LIAN HIEROGLYPH A414ANATOLIAN HIEROGLYPH A415ANATOLIAN HIEROGLYPH A416AN" +
	"ATOLIAN HIEROGLYPH A417ANATOLIAN HIEROGLYPH A418ANATOLIAN HIEROGLYPH A41" +
	"9ANATOLIAN HIEROGLYPH A420ANATOLIAN HIEROGLYPH A421ANATOLIAN HIEROGLYPH " +
	"A422ANATOLIAN HIEROGLYPH A423ANATOLIAN HIEROGLYPH A424ANATOLIAN HIEROGLY" +
	"PH A425ANATOLIAN HIEROGLYPH A426ANATOLIAN HIEROGLYPH A427ANATOLIAN HIERO" +
	"GLYPH A428ANATOLIAN HIEROGLYPH A429ANATOLIAN HIEROGLYPH A430ANATOLIAN HI" +
	"EROGLYPH A431ANATOLIAN HIEROGLYPH A432ANATOLIAN HIEROGLYPH A433ANATOLIAN" +
	" HIEROGLYPH A434ANATOLIAN HIEROGLYPH A435ANATOLIAN HIEROGLYPH A436ANATOL" +
	"IAN HIEROGLYPH A437ANATOLIAN HIEROGLYPH A438ANATOLIAN HIEROGLYPH A439ANA" +
	"TOLIAN HIEROGLYPH A440ANATOLIAN HIEROGLYPH A441ANATOLIAN HIEROGLYPH A442" +
	"ANATOLIAN HIEROGLYPH A443ANATOLIAN HIEROGLYPH A444ANATOLIAN HIEROGLYPH A" +
	"445ANATOLIAN HIEROGLYPH A446ANATOLIAN HIEROGLYPH A447ANATOLIAN HIEROGLYP" +
	"H A448ANATOLIAN HIEROGLYPH A449ANATOLIAN HIEROGLYPH A450ANATOLIAN HIEROG" +
	"LYPH A450AANATOLIAN HIEROGLYPH A451ANATOLIAN HIEROGLYPH A452ANATOLIAN HI" +
	"EROGLYPH A453ANATOLIAN HIEROGLYPH A454ANATOLIAN HIEROGLYPH A455ANATOLIAN" +
	" HIEROGLYPH A456ANATOLIAN HIEROGLYPH A457ANATOLIAN HIEROGLYPH A457AANATO" +
	"LIAN HIEROGLYPH A458ANATOLIAN HIEROGLYPH A459ANATOLIAN HIEROGLYPH A460AN" +
	"ATOLIAN HIEROGLYPH A461ANATOLIAN HIEROGLYPH A462ANATOLIAN HIEROGLYPH A46" +
	"3ANATOLIAN HIEROGLYPH A464ANATOLIAN HIEROGLYPH A465ANATOLIAN HIEROGLYPH " +
	"A466ANATOLIAN HIEROGLYPH A467ANATOLIAN HIEROGLYPH A468ANATOLIAN HIEROGLY" +
	"PH A469ANATOLIAN HIEROGLYPH A470ANATOLIAN HIEROGLYPH A471ANATOLIAN HIERO" +
	"GLYPH A472ANATOLIAN HIEROGLYPH A473ANATOLIAN HIEROGLYPH A474ANATOLIAN HI" +
	"EROGLYPH A475ANATOLIAN HIEROGLYPH A476ANATOLIAN HIEROGLYPH A477ANATOLIAN" +
	" HIEROGLYPH A478ANATOLIAN HIEROGLYPH A479ANATOLIAN HIEROGLYPH A480ANATOL" +
	"IAN HIEROGLYPH A481ANATOLIAN HIEROGLYPH A482ANATOLIAN HIEROGLYPH A483ANA" +
	"TOLIAN HIEROGLYPH A484ANATOLIAN HIEROGLYPH A485ANATOLIAN HIEROGLYPH A486" +
	"ANATOLIAN HIEROGLYPH A487ANATOLIAN HIEROGLYPH A488ANATOLIAN HIEROGLYPH A" +
	"489ANATOLIAN HIEROGLYPH A490ANATOLIAN HIEROGLYPH A491ANATOLIAN HIEROGLYP" +
	"H A492ANATOLIAN HIEROGLYPH A493ANATOLIAN HIEROGLYPH A494ANATOLIAN HIEROG" +
	"LYPH A495ANATOLIAN HIEROGLYPH A496ANATOLIAN HIEROGLYPH A497ANATOLIAN HIE" +
	"ROGLYPH A501ANATOLIAN HIEROGLYPH A502ANATOLIAN HIEROGLYPH A503ANATOLIAN " +
	"HIEROGLYPH A504ANATOLIAN HIEROGLYPH A505ANATOLIAN HIEROGLYPH A506ANATOLI" +
	"AN HIEROGLYPH A507ANATOLIAN HIEROGLYPH A508ANATOLIAN HIEROGLYPH A509ANAT" +
	"OLIAN HIEROGLYPH A510ANATOLIAN HIEROGLYPH A511ANATOLIAN HIEROGLYPH A512A" +
	"NATOLIAN HIEROGLYPH A513ANATOLIAN HIEROGLYPH A514ANATOLIAN HIEROGLYPH A5" +
	"15ANATOLIAN HIEROGLYPH A516ANATOLIAN HIEROGLYPH A517ANATOLIAN HIEROGLYPH" +
	" A518ANATOLIAN HIEROGLYPH A519ANATOLIAN HIEROGLYPH A520ANATOLIAN HIEROGL" +
	"YPH A521ANATOLIAN HIEROGLYPH A522ANATOLIAN HIEROGLYPH A523ANATOLIAN HIER" +
	"OGLYPH A524ANATOLIAN HIEROGLYPH A525ANATOLIAN HIEROGLYPH A526ANATOLIAN H" +
	"IEROGLYPH A527ANATOLIAN HIEROGLYPH A528ANATOLIAN HIEROGLYPH A529ANATOLIA" +
	"N HIEROGLYPH A530BAMUM LETTER PHASE-A NGKUE MFONBAMUM LETTER PHASE-A GBI" +
	"EE FONBAMUM LETTER PHASE-A PON MFON PIPAEMGBIEEBAMUM LETTER PHASE-A PON " +
	"MFON PIPAEMBABAMUM LETTER PHASE-A NAA MFONBAMUM LETTER PHASE-A SHUENSHUE" +
	"TBAMUM LETTER PHASE-A TITA MFONBAMUM LETTER PHASE-A NZA MFONBAMUM LETTER" +
	" PHASE-A SHINDA PA NJIBAMUM LETTER PHASE-A PON PA NJI PIPAEMGBIEEBAMUM L" +
	"ETTER PHASE-A PON PA NJI PIPAEMBABAMUM LETTER PHASE-A MAEMBGBIEEBAMUM LE" +
	"TTER PHASE-A TU MAEMBABAMUM LETTER PHASE-A NGANGUBAMUM LETTER PHASE-A MA" +
	"EMVEUXBAMUM LETTER PHASE-A MANSUAEBAMUM LETTER PHASE-A MVEUAENGAMBAMUM L" +
	"ETTER PHASE-A SEUNYAMBAMUM LETTER PHASE-A NTOQPENBAMUM LETTER PHASE-A KE" +
	"UKEUTNDABAMUM LETTER PHASE-A NKINDIBAMUM LETTER PHASE-A SUUBAMUM LETTER " +
	"PHASE-A NGKUENZEUMBAMUM LETTER PHASE-A LAPAQBAMUM LETTER PHASE-A LET KUT" +
	"BAMUM LETTER PHASE-A NTAP MFAABAMUM LETTER PHASE-A MAEKEUPBAMUM LETTER P" +
	"HASE-A PASHAEBAMUM LETTER PHASE-A GHEUAERAEBAMUM LETTER PHASE-A PAMSHAEB" +
	"AMUM LETTER PHASE-A MON NGGEUAETBAMUM LETTER PHASE-A NZUN MEUTBAMUM LETT" +
	"ER PHASE-A U YUQ NAEBAMUM LETTER PHASE-A GHEUAEGHEUAEBAMUM LETTER PHASE-" +
	"A NTAP NTAABAMUM LETTER PHASE-A SISABAMUM LETTER PHASE-A MGBASABAMUM LET" +
	"TER PHASE-A MEUNJOMNDEUQBAMUM LETTER PHASE-A MOOMPUQBAMUM LETTER PHASE-A" +
	" KAFABAMUM LETTER PHASE-A PA LEERAEWABAMUM LETTER PHASE-A NDA LEERAEWABA" +
	"MUM LETTER PHASE-A PETBAMUM LETTER PHASE-A MAEMKPENBAMUM LETTER PHASE-A " +
	"NIKABAMUM LETTER PHASE-A PUPBAMUM LETTER PHASE-A TUAEPBAMUM LETTER PHASE" +
	"-A LUAEPBAMUM LETTER PHASE-A SONJAMBAMUM LETTER PHASE-A TEUTEUWENBAMUM L" +
	"ETTER PHASE-A MAENYIBAMUM LETTER PHASE-A KETBAMUM LETTER PHASE-A NDAANGG" +
	"EUAETBAMUM LETTER PHASE-A KUOQBAMUM LETTER PHASE-A MOOMEUTBAMUM LETTER P" +
	"HASE-A SHUMBAMUM LETTER PHASE-A LOMMAEBAMUM LETTER PHASE-A FIRIBAMUM LET") + ("" +
	"TER PHASE-A ROMBAMUM LETTER PHASE-A KPOQBAMUM LETTER PHASE-A SOQBAMUM LE" +
	"TTER PHASE-A MAP PIEETBAMUM LETTER PHASE-A SHIRAEBAMUM LETTER PHASE-A NT" +
	"APBAMUM LETTER PHASE-A SHOQ NSHUT YUMBAMUM LETTER PHASE-A NYIT MONGKEUAE" +
	"QBAMUM LETTER PHASE-A PAARAEBAMUM LETTER PHASE-A NKAARAEBAMUM LETTER PHA" +
	"SE-A UNKNOWNBAMUM LETTER PHASE-A NGGENBAMUM LETTER PHASE-A MAESIBAMUM LE" +
	"TTER PHASE-A NJAMBAMUM LETTER PHASE-A MBANYIBAMUM LETTER PHASE-A NYETBAM" +
	"UM LETTER PHASE-A TEUAENBAMUM LETTER PHASE-A SOTBAMUM LETTER PHASE-A PAA" +
	"MBAMUM LETTER PHASE-A NSHIEEBAMUM LETTER PHASE-A MAEMBAMUM LETTER PHASE-" +
	"A NYIBAMUM LETTER PHASE-A KAQBAMUM LETTER PHASE-A NSHABAMUM LETTER PHASE" +
	"-A VEEBAMUM LETTER PHASE-A LUBAMUM LETTER PHASE-A NENBAMUM LETTER PHASE-" +
	"A NAQBAMUM LETTER PHASE-A MBAQBAMUM LETTER PHASE-B NSHUETBAMUM LETTER PH" +
	"ASE-B TU MAEMGBIEEBAMUM LETTER PHASE-B SIEEBAMUM LETTER PHASE-B SET TUBA" +
	"MUM LETTER PHASE-B LOM NTEUMBAMUM LETTER PHASE-B MBA MAELEEBAMUM LETTER " +
	"PHASE-B KIEEMBAMUM LETTER PHASE-B YEURAEBAMUM LETTER PHASE-B MBAARAEBAMU" +
	"M LETTER PHASE-B KAMBAMUM LETTER PHASE-B PEESHIBAMUM LETTER PHASE-B YAFU" +
	" LEERAEWABAMUM LETTER PHASE-B LAM NSHUT NYAMBAMUM LETTER PHASE-B NTIEE S" +
	"HEUOQBAMUM LETTER PHASE-B NDU NJAABAMUM LETTER PHASE-B GHEUGHEUAEMBAMUM " +
	"LETTER PHASE-B PITBAMUM LETTER PHASE-B TU NSIEEBAMUM LETTER PHASE-B SHET" +
	" NJAQBAMUM LETTER PHASE-B SHEUAEQTUBAMUM LETTER PHASE-B MFON TEUAEQBAMUM" +
	" LETTER PHASE-B MBIT MBAAKETBAMUM LETTER PHASE-B NYI NTEUMBAMUM LETTER P" +
	"HASE-B KEUPUQBAMUM LETTER PHASE-B GHEUGHENBAMUM LETTER PHASE-B KEUYEUXBA" +
	"MUM LETTER PHASE-B LAANAEBAMUM LETTER PHASE-B PARUMBAMUM LETTER PHASE-B " +
	"VEUMBAMUM LETTER PHASE-B NGKINDI MVOPBAMUM LETTER PHASE-B NGGEU MBUBAMUM" +
	" LETTER PHASE-B WUAETBAMUM LETTER PHASE-B SAKEUAEBAMUM LETTER PHASE-B TA" +
	"AMBAMUM LETTER PHASE-B MEUQBAMUM LETTER PHASE-B NGGUOQBAMUM LETTER PHASE" +
	"-B NGGUOQ LARGEBAMUM LETTER PHASE-B MFIYAQBAMUM LETTER PHASE-B SUEBAMUM " +
	"LETTER PHASE-B MBEURIBAMUM LETTER PHASE-B MONTIEENBAMUM LETTER PHASE-B N" +
	"YAEMAEBAMUM LETTER PHASE-B PUNGAAMBAMUM LETTER PHASE-B MEUT NGGEETBAMUM " +
	"LETTER PHASE-B FEUXBAMUM LETTER PHASE-B MBUOQBAMUM LETTER PHASE-B FEEBAM" +
	"UM LETTER PHASE-B KEUAEMBAMUM LETTER PHASE-B MA NJEUAENABAMUM LETTER PHA" +
	"SE-B MA NJUQABAMUM LETTER PHASE-B LETBAMUM LETTER PHASE-B NGGAAMBAMUM LE" +
	"TTER PHASE-B NSENBAMUM LETTER PHASE-B MABAMUM LETTER PHASE-B KIQBAMUM LE" +
	"TTER PHASE-B NGOMBAMUM LETTER PHASE-C NGKUE MAEMBABAMUM LETTER PHASE-C N" +
	"ZABAMUM LETTER PHASE-C YUMBAMUM LETTER PHASE-C WANGKUOQBAMUM LETTER PHAS" +
	"E-C NGGENBAMUM LETTER PHASE-C NDEUAEREEBAMUM LETTER PHASE-C NGKAQBAMUM L" +
	"ETTER PHASE-C GHARAEBAMUM LETTER PHASE-C MBEEKEETBAMUM LETTER PHASE-C GB" +
	"AYIBAMUM LETTER PHASE-C NYIR MKPARAQ MEUNBAMUM LETTER PHASE-C NTU MBITBA" +
	"MUM LETTER PHASE-C MBEUMBAMUM LETTER PHASE-C PIRIEENBAMUM LETTER PHASE-C" +
	" NDOMBUBAMUM LETTER PHASE-C MBAA CABBAGE-TREEBAMUM LETTER PHASE-C KEUSHE" +
	"UAEPBAMUM LETTER PHASE-C GHAPBAMUM LETTER PHASE-C KEUKAQBAMUM LETTER PHA" +
	"SE-C YU MUOMAEBAMUM LETTER PHASE-C NZEUMBAMUM LETTER PHASE-C MBUEBAMUM L" +
	"ETTER PHASE-C NSEUAENBAMUM LETTER PHASE-C MBITBAMUM LETTER PHASE-C YEUQB" +
	"AMUM LETTER PHASE-C KPARAQBAMUM LETTER PHASE-C KAABAMUM LETTER PHASE-C S" +
	"EUXBAMUM LETTER PHASE-C NDIDABAMUM LETTER PHASE-C TAASHAEBAMUM LETTER PH" +
	"ASE-C NJUEQBAMUM LETTER PHASE-C TITA YUEBAMUM LETTER PHASE-C SUAETBAMUM " +
	"LETTER PHASE-C NGGUAEN NYAMBAMUM LETTER PHASE-C VEUXBAMUM LETTER PHASE-C" +
	" NANSANAQBAMUM LETTER PHASE-C MA KEUAERIBAMUM LETTER PHASE-C NTAABAMUM L" +
	"ETTER PHASE-C NGGUONBAMUM LETTER PHASE-C LAPBAMUM LETTER PHASE-C MBIRIEE" +
	"NBAMUM LETTER PHASE-C MGBASAQBAMUM LETTER PHASE-C NTEUNGBABAMUM LETTER P" +
	"HASE-C TEUTEUXBAMUM LETTER PHASE-C NGGUMBAMUM LETTER PHASE-C FUEBAMUM LE" +
	"TTER PHASE-C NDEUTBAMUM LETTER PHASE-C NSABAMUM LETTER PHASE-C NSHAQBAMU" +
	"M LETTER PHASE-C BUNGBAMUM LETTER PHASE-C VEUAEPENBAMUM LETTER PHASE-C M" +
	"BERAEBAMUM LETTER PHASE-C RUBAMUM LETTER PHASE-C NJAEMBAMUM LETTER PHASE" +
	"-C LAMBAMUM LETTER PHASE-C TITUAEPBAMUM LETTER PHASE-C NSUOT NGOMBAMUM L" +
	"ETTER PHASE-C NJEEEEBAMUM LETTER PHASE-C KETBAMUM LETTER PHASE-C NGGUBAM" +
	"UM LETTER PHASE-C MAESIBAMUM LETTER PHASE-C MBUAEMBAMUM LETTER PHASE-C L" +
	"UBAMUM LETTER PHASE-C KUTBAMUM LETTER PHASE-C NJAMBAMUM LETTER PHASE-C N" +
	"GOMBAMUM LETTER PHASE-C WUPBAMUM LETTER PHASE-C NGGUEETBAMUM LETTER PHAS" +
	"E-C NSOMBAMUM LETTER PHASE-C NTENBAMUM LETTER PHASE-C KUOP NKAARAEBAMUM " +
	"LETTER PHASE-C NSUNBAMUM LETTER PHASE-C NDAMBAMUM LETTER PHASE-C MA NSIE" +
	"EBAMUM LETTER PHASE-C YAABAMUM LETTER PHASE-C NDAPBAMUM LETTER PHASE-C S" +
	"HUEQBAMUM LETTER PHASE-C SETFONBAMUM LETTER PHASE-C MBIBAMUM LETTER PHAS" +
	"E-C MAEMBABAMUM LETTER PHASE-C MBANYIBAMUM LETTER PHASE-C KEUSEUXBAMUM L" +
	"ETTER PHASE-C MBEUXBAMUM LETTER PHASE-C KEUMBAMUM LETTER PHASE-C MBAA PI") + ("" +
	"CKETBAMUM LETTER PHASE-C YUWOQBAMUM LETTER PHASE-C NJEUXBAMUM LETTER PHA" +
	"SE-C MIEEBAMUM LETTER PHASE-C MUAEBAMUM LETTER PHASE-C SHIQBAMUM LETTER " +
	"PHASE-C KEN LAWBAMUM LETTER PHASE-C KEN FATIGUEBAMUM LETTER PHASE-C NGAQ" +
	"BAMUM LETTER PHASE-C NAQBAMUM LETTER PHASE-C LIQBAMUM LETTER PHASE-C PIN" +
	"BAMUM LETTER PHASE-C PENBAMUM LETTER PHASE-C TETBAMUM LETTER PHASE-D MBU" +
	"OBAMUM LETTER PHASE-D WAPBAMUM LETTER PHASE-D NJIBAMUM LETTER PHASE-D MF" +
	"ONBAMUM LETTER PHASE-D NJIEEBAMUM LETTER PHASE-D LIEEBAMUM LETTER PHASE-" +
	"D NJEUTBAMUM LETTER PHASE-D NSHEEBAMUM LETTER PHASE-D NGGAAMAEBAMUM LETT" +
	"ER PHASE-D NYAMBAMUM LETTER PHASE-D WUAENBAMUM LETTER PHASE-D NGKUNBAMUM" +
	" LETTER PHASE-D SHEEBAMUM LETTER PHASE-D NGKAPBAMUM LETTER PHASE-D KEUAE" +
	"TMEUNBAMUM LETTER PHASE-D TEUTBAMUM LETTER PHASE-D SHEUAEBAMUM LETTER PH" +
	"ASE-D NJAPBAMUM LETTER PHASE-D SUEBAMUM LETTER PHASE-D KETBAMUM LETTER P" +
	"HASE-D YAEMMAEBAMUM LETTER PHASE-D KUOMBAMUM LETTER PHASE-D SAPBAMUM LET" +
	"TER PHASE-D MFEUTBAMUM LETTER PHASE-D NDEUXBAMUM LETTER PHASE-D MALEERIB" +
	"AMUM LETTER PHASE-D MEUTBAMUM LETTER PHASE-D SEUAEQBAMUM LETTER PHASE-D " +
	"YENBAMUM LETTER PHASE-D NJEUAEMBAMUM LETTER PHASE-D KEUOT MBUAEBAMUM LET" +
	"TER PHASE-D NGKEURIBAMUM LETTER PHASE-D TUBAMUM LETTER PHASE-D GHAABAMUM" +
	" LETTER PHASE-D NGKYEEBAMUM LETTER PHASE-D FEUFEUAETBAMUM LETTER PHASE-D" +
	" NDEEBAMUM LETTER PHASE-D MGBOFUMBAMUM LETTER PHASE-D LEUAEPBAMUM LETTER" +
	" PHASE-D NDONBAMUM LETTER PHASE-D MONIBAMUM LETTER PHASE-D MGBEUNBAMUM L" +
	"ETTER PHASE-D PUUTBAMUM LETTER PHASE-D MGBIEEBAMUM LETTER PHASE-D MFOBAM" +
	"UM LETTER PHASE-D LUMBAMUM LETTER PHASE-D NSIEEPBAMUM LETTER PHASE-D MBA" +
	"ABAMUM LETTER PHASE-D KWAETBAMUM LETTER PHASE-D NYETBAMUM LETTER PHASE-D" +
	" TEUAENBAMUM LETTER PHASE-D SOTBAMUM LETTER PHASE-D YUWOQBAMUM LETTER PH" +
	"ASE-D KEUMBAMUM LETTER PHASE-D RAEMBAMUM LETTER PHASE-D TEEEEBAMUM LETTE" +
	"R PHASE-D NGKEUAEQBAMUM LETTER PHASE-D MFEUAEBAMUM LETTER PHASE-D NSIEET" +
	"BAMUM LETTER PHASE-D KEUPBAMUM LETTER PHASE-D PIPBAMUM LETTER PHASE-D PE" +
	"UTAEBAMUM LETTER PHASE-D NYUEBAMUM LETTER PHASE-D LETBAMUM LETTER PHASE-" +
	"D NGGAAMBAMUM LETTER PHASE-D MFIEEBAMUM LETTER PHASE-D NGGWAENBAMUM LETT" +
	"ER PHASE-D YUOMBAMUM LETTER PHASE-D PAPBAMUM LETTER PHASE-D YUOPBAMUM LE" +
	"TTER PHASE-D NDAMBAMUM LETTER PHASE-D NTEUMBAMUM LETTER PHASE-D SUAEBAMU" +
	"M LETTER PHASE-D KUNBAMUM LETTER PHASE-D NGGEUXBAMUM LETTER PHASE-D NGKI" +
	"EEBAMUM LETTER PHASE-D TUOTBAMUM LETTER PHASE-D MEUNBAMUM LETTER PHASE-D" +
	" KUQBAMUM LETTER PHASE-D NSUMBAMUM LETTER PHASE-D TEUNBAMUM LETTER PHASE" +
	"-D MAENJETBAMUM LETTER PHASE-D NGGAPBAMUM LETTER PHASE-D LEUMBAMUM LETTE" +
	"R PHASE-D NGGUOMBAMUM LETTER PHASE-D NSHUTBAMUM LETTER PHASE-D NJUEQBAMU" +
	"M LETTER PHASE-D GHEUAEBAMUM LETTER PHASE-D KUBAMUM LETTER PHASE-D REN O" +
	"LDBAMUM LETTER PHASE-D TAEBAMUM LETTER PHASE-D TOQBAMUM LETTER PHASE-D N" +
	"YIBAMUM LETTER PHASE-D RIIBAMUM LETTER PHASE-D LEEEEBAMUM LETTER PHASE-D" +
	" MEEEEBAMUM LETTER PHASE-D MBAMUM LETTER PHASE-D SUUBAMUM LETTER PHASE-D" +
	" MUBAMUM LETTER PHASE-D SHIIBAMUM LETTER PHASE-D SHEUXBAMUM LETTER PHASE" +
	"-D KYEEBAMUM LETTER PHASE-D NUBAMUM LETTER PHASE-D SHUBAMUM LETTER PHASE" +
	"-D NTEEBAMUM LETTER PHASE-D PEEBAMUM LETTER PHASE-D NIBAMUM LETTER PHASE" +
	"-D SHOQBAMUM LETTER PHASE-D PUQBAMUM LETTER PHASE-D MVOPBAMUM LETTER PHA" +
	"SE-D LOQBAMUM LETTER PHASE-D REN MUCHBAMUM LETTER PHASE-D TIBAMUM LETTER" +
	" PHASE-D NTUUBAMUM LETTER PHASE-D MBAA SEVENBAMUM LETTER PHASE-D SAQBAMU" +
	"M LETTER PHASE-D FAABAMUM LETTER PHASE-E NDAPBAMUM LETTER PHASE-E TOONBA" +
	"MUM LETTER PHASE-E MBEUMBAMUM LETTER PHASE-E LAPBAMUM LETTER PHASE-E VOM" +
	"BAMUM LETTER PHASE-E LOONBAMUM LETTER PHASE-E PAABAMUM LETTER PHASE-E SO" +
	"MBAMUM LETTER PHASE-E RAQBAMUM LETTER PHASE-E NSHUOPBAMUM LETTER PHASE-E" +
	" NDUNBAMUM LETTER PHASE-E PUAEBAMUM LETTER PHASE-E TAMBAMUM LETTER PHASE" +
	"-E NGKABAMUM LETTER PHASE-E KPEUXBAMUM LETTER PHASE-E WUOBAMUM LETTER PH" +
	"ASE-E SEEBAMUM LETTER PHASE-E NGGEUAETBAMUM LETTER PHASE-E PAAMBAMUM LET" +
	"TER PHASE-E TOOBAMUM LETTER PHASE-E KUOPBAMUM LETTER PHASE-E LOMBAMUM LE" +
	"TTER PHASE-E NSHIEEBAMUM LETTER PHASE-E NGOPBAMUM LETTER PHASE-E MAEMBAM" +
	"UM LETTER PHASE-E NGKEUXBAMUM LETTER PHASE-E NGOQBAMUM LETTER PHASE-E NS" +
	"HUEBAMUM LETTER PHASE-E RIMGBABAMUM LETTER PHASE-E NJEUXBAMUM LETTER PHA" +
	"SE-E PEEMBAMUM LETTER PHASE-E SAABAMUM LETTER PHASE-E NGGURAEBAMUM LETTE" +
	"R PHASE-E MGBABAMUM LETTER PHASE-E GHEUXBAMUM LETTER PHASE-E NGKEUAEMBAM" +
	"UM LETTER PHASE-E NJAEMLIBAMUM LETTER PHASE-E MAPBAMUM LETTER PHASE-E LO" +
	"OTBAMUM LETTER PHASE-E NGGEEEEBAMUM LETTER PHASE-E NDIQBAMUM LETTER PHAS" +
	"E-E TAEN NTEUMBAMUM LETTER PHASE-E SETBAMUM LETTER PHASE-E PUMBAMUM LETT" +
	"ER PHASE-E NDAA SOFTNESSBAMUM LETTER PHASE-E NGGUAESHAE NYAMBAMUM LETTER" +
	" PHASE-E YIEEBAMUM LETTER PHASE-E GHEUNBAMUM LETTER PHASE-E TUAEBAMUM LE") + ("" +
	"TTER PHASE-E YEUAEBAMUM LETTER PHASE-E POBAMUM LETTER PHASE-E TUMAEBAMUM" +
	" LETTER PHASE-E KEUAEBAMUM LETTER PHASE-E SUAENBAMUM LETTER PHASE-E TEUA" +
	"EQBAMUM LETTER PHASE-E VEUAEBAMUM LETTER PHASE-E WEUXBAMUM LETTER PHASE-" +
	"E LAAMBAMUM LETTER PHASE-E PUBAMUM LETTER PHASE-E TAAQBAMUM LETTER PHASE" +
	"-E GHAAMAEBAMUM LETTER PHASE-E NGEUREUTBAMUM LETTER PHASE-E SHEUAEQBAMUM" +
	" LETTER PHASE-E MGBENBAMUM LETTER PHASE-E MBEEBAMUM LETTER PHASE-E NZAQB" +
	"AMUM LETTER PHASE-E NKOMBAMUM LETTER PHASE-E GBETBAMUM LETTER PHASE-E TU" +
	"MBAMUM LETTER PHASE-E KUETBAMUM LETTER PHASE-E YAPBAMUM LETTER PHASE-E N" +
	"YI CLEAVERBAMUM LETTER PHASE-E YITBAMUM LETTER PHASE-E MFEUQBAMUM LETTER" +
	" PHASE-E NDIAQBAMUM LETTER PHASE-E PIEEQBAMUM LETTER PHASE-E YUEQBAMUM L" +
	"ETTER PHASE-E LEUAEMBAMUM LETTER PHASE-E FUEBAMUM LETTER PHASE-E GBEUXBA" +
	"MUM LETTER PHASE-E NGKUPBAMUM LETTER PHASE-E KETBAMUM LETTER PHASE-E MAE" +
	"BAMUM LETTER PHASE-E NGKAAMIBAMUM LETTER PHASE-E GHETBAMUM LETTER PHASE-" +
	"E FABAMUM LETTER PHASE-E NTUMBAMUM LETTER PHASE-E PEUTBAMUM LETTER PHASE" +
	"-E YEUMBAMUM LETTER PHASE-E NGGEUAEBAMUM LETTER PHASE-E NYI BETWEENBAMUM" +
	" LETTER PHASE-E NZUQBAMUM LETTER PHASE-E POONBAMUM LETTER PHASE-E MIEEBA" +
	"MUM LETTER PHASE-E FUETBAMUM LETTER PHASE-E NAEBAMUM LETTER PHASE-E MUAE" +
	"BAMUM LETTER PHASE-E GHEUAEBAMUM LETTER PHASE-E FU IBAMUM LETTER PHASE-E" +
	" MVIBAMUM LETTER PHASE-E PUAQBAMUM LETTER PHASE-E NGKUMBAMUM LETTER PHAS" +
	"E-E KUTBAMUM LETTER PHASE-E PIETBAMUM LETTER PHASE-E NTAPBAMUM LETTER PH" +
	"ASE-E YEUAETBAMUM LETTER PHASE-E NGGUPBAMUM LETTER PHASE-E PA PEOPLEBAMU" +
	"M LETTER PHASE-E FU CALLBAMUM LETTER PHASE-E FOMBAMUM LETTER PHASE-E NJE" +
	"EBAMUM LETTER PHASE-E ABAMUM LETTER PHASE-E TOQBAMUM LETTER PHASE-E OBAM" +
	"UM LETTER PHASE-E IBAMUM LETTER PHASE-E LAQBAMUM LETTER PHASE-E PA PLURA" +
	"LBAMUM LETTER PHASE-E TAABAMUM LETTER PHASE-E TAQBAMUM LETTER PHASE-E ND" +
	"AA MY HOUSEBAMUM LETTER PHASE-E SHIQBAMUM LETTER PHASE-E YEUXBAMUM LETTE" +
	"R PHASE-E NGUAEBAMUM LETTER PHASE-E YUAENBAMUM LETTER PHASE-E YOQ SWIMMI" +
	"NGBAMUM LETTER PHASE-E YOQ COVERBAMUM LETTER PHASE-E YUQBAMUM LETTER PHA" +
	"SE-E YUNBAMUM LETTER PHASE-E KEUXBAMUM LETTER PHASE-E PEUXBAMUM LETTER P" +
	"HASE-E NJEE EPOCHBAMUM LETTER PHASE-E PUEBAMUM LETTER PHASE-E WUEBAMUM L" +
	"ETTER PHASE-E FEEBAMUM LETTER PHASE-E VEEBAMUM LETTER PHASE-E LUBAMUM LE" +
	"TTER PHASE-E MIBAMUM LETTER PHASE-E REUXBAMUM LETTER PHASE-E RAEBAMUM LE" +
	"TTER PHASE-E NGUAETBAMUM LETTER PHASE-E NGABAMUM LETTER PHASE-E SHOBAMUM" +
	" LETTER PHASE-E SHOQBAMUM LETTER PHASE-E FU REMEDYBAMUM LETTER PHASE-E N" +
	"ABAMUM LETTER PHASE-E PIBAMUM LETTER PHASE-E LOQBAMUM LETTER PHASE-E KOB" +
	"AMUM LETTER PHASE-E MENBAMUM LETTER PHASE-E MABAMUM LETTER PHASE-E MAQBA" +
	"MUM LETTER PHASE-E TEUBAMUM LETTER PHASE-E KIBAMUM LETTER PHASE-E MONBAM" +
	"UM LETTER PHASE-E TENBAMUM LETTER PHASE-E FAQBAMUM LETTER PHASE-E GHOMBA" +
	"MUM LETTER PHASE-F KABAMUM LETTER PHASE-F UBAMUM LETTER PHASE-F KUBAMUM " +
	"LETTER PHASE-F EEBAMUM LETTER PHASE-F REEBAMUM LETTER PHASE-F TAEBAMUM L" +
	"ETTER PHASE-F NYIBAMUM LETTER PHASE-F LABAMUM LETTER PHASE-F RIIBAMUM LE" +
	"TTER PHASE-F RIEEBAMUM LETTER PHASE-F MEEEEBAMUM LETTER PHASE-F TAABAMUM" +
	" LETTER PHASE-F NDAABAMUM LETTER PHASE-F NJAEMBAMUM LETTER PHASE-F MBAMU" +
	"M LETTER PHASE-F SUUBAMUM LETTER PHASE-F SHIIBAMUM LETTER PHASE-F SIBAMU" +
	"M LETTER PHASE-F SEUXBAMUM LETTER PHASE-F KYEEBAMUM LETTER PHASE-F KETBA" +
	"MUM LETTER PHASE-F NUAEBAMUM LETTER PHASE-F NUBAMUM LETTER PHASE-F NJUAE" +
	"BAMUM LETTER PHASE-F YOQBAMUM LETTER PHASE-F SHUBAMUM LETTER PHASE-F YAB" +
	"AMUM LETTER PHASE-F NSHABAMUM LETTER PHASE-F PEUXBAMUM LETTER PHASE-F NT" +
	"EEBAMUM LETTER PHASE-F WUEBAMUM LETTER PHASE-F PEEBAMUM LETTER PHASE-F R" +
	"UBAMUM LETTER PHASE-F NIBAMUM LETTER PHASE-F REUXBAMUM LETTER PHASE-F KE" +
	"NBAMUM LETTER PHASE-F NGKWAENBAMUM LETTER PHASE-F NGGABAMUM LETTER PHASE" +
	"-F SHOBAMUM LETTER PHASE-F PUAEBAMUM LETTER PHASE-F FOMBAMUM LETTER PHAS" +
	"E-F WABAMUM LETTER PHASE-F LIBAMUM LETTER PHASE-F LOQBAMUM LETTER PHASE-" +
	"F KOBAMUM LETTER PHASE-F MBENBAMUM LETTER PHASE-F RENBAMUM LETTER PHASE-" +
	"F MABAMUM LETTER PHASE-F MOBAMUM LETTER PHASE-F MBAABAMUM LETTER PHASE-F" +
	" TETBAMUM LETTER PHASE-F KPABAMUM LETTER PHASE-F SAMBABAMUM LETTER PHASE" +
	"-F VUEQMRO LETTER TAMRO LETTER NGIMRO LETTER YOMRO LETTER MIMMRO LETTER " +
	"BAMRO LETTER DAMRO LETTER AMRO LETTER PHIMRO LETTER KHAIMRO LETTER HAOMR" +
	"O LETTER DAIMRO LETTER CHUMRO LETTER KEAAEMRO LETTER OLMRO LETTER MAEMMR" +
	"O LETTER NINMRO LETTER PAMRO LETTER OOMRO LETTER OMRO LETTER ROMRO LETTE" +
	"R SHIMRO LETTER THEAMRO LETTER EAMRO LETTER WAMRO LETTER EMRO LETTER KOM" +
	"RO LETTER LANMRO LETTER LAMRO LETTER HAIMRO LETTER RIMRO LETTER TEKMRO D" +
	"IGIT ZEROMRO DIGIT ONEMRO DIGIT TWOMRO DIGIT THREEMRO DIGIT FOURMRO DIGI" +
	"T FIVEMRO DIGIT SIXMRO DIGIT SEVENMRO DIGIT EIGHTMRO DIGIT NINEMRO DANDA") + ("" +
	"MRO DOUBLE DANDABASSA VAH LETTER ENNIBASSA VAH LETTER KABASSA VAH LETTER" +
	" SEBASSA VAH LETTER FABASSA VAH LETTER MBEBASSA VAH LETTER YIEBASSA VAH " +
	"LETTER GAHBASSA VAH LETTER DHIIBASSA VAH LETTER KPAHBASSA VAH LETTER JOB" +
	"ASSA VAH LETTER HWAHBASSA VAH LETTER WABASSA VAH LETTER ZOBASSA VAH LETT" +
	"ER GBUBASSA VAH LETTER DOBASSA VAH LETTER CEBASSA VAH LETTER UWUBASSA VA" +
	"H LETTER TOBASSA VAH LETTER BABASSA VAH LETTER VUBASSA VAH LETTER YEINBA" +
	"SSA VAH LETTER PABASSA VAH LETTER WADDABASSA VAH LETTER ABASSA VAH LETTE" +
	"R OBASSA VAH LETTER OOBASSA VAH LETTER UBASSA VAH LETTER EEBASSA VAH LET" +
	"TER EBASSA VAH LETTER IBASSA VAH COMBINING HIGH TONEBASSA VAH COMBINING " +
	"LOW TONEBASSA VAH COMBINING MID TONEBASSA VAH COMBINING LOW-MID TONEBASS" +
	"A VAH COMBINING HIGH-LOW TONEBASSA VAH FULL STOPPAHAWH HMONG VOWEL KEEBP" +
	"AHAWH HMONG VOWEL KEEVPAHAWH HMONG VOWEL KIBPAHAWH HMONG VOWEL KIVPAHAWH" +
	" HMONG VOWEL KAUBPAHAWH HMONG VOWEL KAUVPAHAWH HMONG VOWEL KUBPAHAWH HMO" +
	"NG VOWEL KUVPAHAWH HMONG VOWEL KEBPAHAWH HMONG VOWEL KEVPAHAWH HMONG VOW" +
	"EL KAIBPAHAWH HMONG VOWEL KAIVPAHAWH HMONG VOWEL KOOBPAHAWH HMONG VOWEL " +
	"KOOVPAHAWH HMONG VOWEL KAWBPAHAWH HMONG VOWEL KAWVPAHAWH HMONG VOWEL KUA" +
	"BPAHAWH HMONG VOWEL KUAVPAHAWH HMONG VOWEL KOBPAHAWH HMONG VOWEL KOVPAHA" +
	"WH HMONG VOWEL KIABPAHAWH HMONG VOWEL KIAVPAHAWH HMONG VOWEL KABPAHAWH H" +
	"MONG VOWEL KAVPAHAWH HMONG VOWEL KWBPAHAWH HMONG VOWEL KWVPAHAWH HMONG V" +
	"OWEL KAABPAHAWH HMONG VOWEL KAAVPAHAWH HMONG CONSONANT VAUPAHAWH HMONG C" +
	"ONSONANT NTSAUPAHAWH HMONG CONSONANT LAUPAHAWH HMONG CONSONANT HAUPAHAWH" +
	" HMONG CONSONANT NLAUPAHAWH HMONG CONSONANT RAUPAHAWH HMONG CONSONANT NK" +
	"AUPAHAWH HMONG CONSONANT QHAUPAHAWH HMONG CONSONANT YAUPAHAWH HMONG CONS" +
	"ONANT HLAUPAHAWH HMONG CONSONANT MAUPAHAWH HMONG CONSONANT CHAUPAHAWH HM" +
	"ONG CONSONANT NCHAUPAHAWH HMONG CONSONANT HNAUPAHAWH HMONG CONSONANT PLH" +
	"AUPAHAWH HMONG CONSONANT NTHAUPAHAWH HMONG CONSONANT NAUPAHAWH HMONG CON" +
	"SONANT AUPAHAWH HMONG CONSONANT XAUPAHAWH HMONG CONSONANT CAUPAHAWH HMON" +
	"G MARK CIM TUBPAHAWH HMONG MARK CIM SOPAHAWH HMONG MARK CIM KESPAHAWH HM" +
	"ONG MARK CIM KHAVPAHAWH HMONG MARK CIM SUAMPAHAWH HMONG MARK CIM HOMPAHA" +
	"WH HMONG MARK CIM TAUMPAHAWH HMONG SIGN VOS THOMPAHAWH HMONG SIGN VOS TS" +
	"HAB CEEBPAHAWH HMONG SIGN CIM CHEEMPAHAWH HMONG SIGN VOS THIABPAHAWH HMO" +
	"NG SIGN VOS FEEMPAHAWH HMONG SIGN XYEEM NTXIVPAHAWH HMONG SIGN XYEEM RHO" +
	"PAHAWH HMONG SIGN XYEEM TOVPAHAWH HMONG SIGN XYEEM FAIBPAHAWH HMONG SIGN" +
	" VOS SEEVPAHAWH HMONG SIGN MEEJ SUABPAHAWH HMONG SIGN VOS NRUAPAHAWH HMO" +
	"NG SIGN IB YAMPAHAWH HMONG SIGN XAUSPAHAWH HMONG SIGN CIM TSOV ROGPAHAWH" +
	" HMONG DIGIT ZEROPAHAWH HMONG DIGIT ONEPAHAWH HMONG DIGIT TWOPAHAWH HMON" +
	"G DIGIT THREEPAHAWH HMONG DIGIT FOURPAHAWH HMONG DIGIT FIVEPAHAWH HMONG " +
	"DIGIT SIXPAHAWH HMONG DIGIT SEVENPAHAWH HMONG DIGIT EIGHTPAHAWH HMONG DI" +
	"GIT NINEPAHAWH HMONG NUMBER TENSPAHAWH HMONG NUMBER HUNDREDSPAHAWH HMONG" +
	" NUMBER TEN THOUSANDSPAHAWH HMONG NUMBER MILLIONSPAHAWH HMONG NUMBER HUN" +
	"DRED MILLIONSPAHAWH HMONG NUMBER TEN BILLIONSPAHAWH HMONG NUMBER TRILLIO" +
	"NSPAHAWH HMONG SIGN VOS LUBPAHAWH HMONG SIGN XYOOPAHAWH HMONG SIGN HLIPA" +
	"HAWH HMONG SIGN THIRD-STAGE HLIPAHAWH HMONG SIGN ZWJ THAJPAHAWH HMONG SI" +
	"GN HNUBPAHAWH HMONG SIGN NQIGPAHAWH HMONG SIGN XIABPAHAWH HMONG SIGN NTU" +
	"JPAHAWH HMONG SIGN AVPAHAWH HMONG SIGN TXHEEJ CEEVPAHAWH HMONG SIGN MEEJ" +
	" TSEEBPAHAWH HMONG SIGN TAUPAHAWH HMONG SIGN LOSPAHAWH HMONG SIGN MUSPAH" +
	"AWH HMONG SIGN CIM HAIS LUS NTOG NTOGPAHAWH HMONG SIGN CIM CUAM TSHOOJPA" +
	"HAWH HMONG SIGN CIM TXWVPAHAWH HMONG SIGN CIM TXWV CHWVPAHAWH HMONG SIGN" +
	" CIM PUB DAWBPAHAWH HMONG SIGN CIM NRES TOSPAHAWH HMONG CLAN SIGN TSHEEJ" +
	"PAHAWH HMONG CLAN SIGN YEEGPAHAWH HMONG CLAN SIGN LISPAHAWH HMONG CLAN S" +
	"IGN LAUJPAHAWH HMONG CLAN SIGN XYOOJPAHAWH HMONG CLAN SIGN KOOPAHAWH HMO" +
	"NG CLAN SIGN HAWJPAHAWH HMONG CLAN SIGN MUASPAHAWH HMONG CLAN SIGN THOJP" +
	"AHAWH HMONG CLAN SIGN TSABPAHAWH HMONG CLAN SIGN PHABPAHAWH HMONG CLAN S" +
	"IGN KHABPAHAWH HMONG CLAN SIGN HAMPAHAWH HMONG CLAN SIGN VAJPAHAWH HMONG" +
	" CLAN SIGN FAJPAHAWH HMONG CLAN SIGN YAJPAHAWH HMONG CLAN SIGN TSWBPAHAW" +
	"H HMONG CLAN SIGN KWMPAHAWH HMONG CLAN SIGN VWJMEDEFAIDRIN CAPITAL LETTE" +
	"R MMEDEFAIDRIN CAPITAL LETTER SMEDEFAIDRIN CAPITAL LETTER VMEDEFAIDRIN C" +
	"APITAL LETTER WMEDEFAIDRIN CAPITAL LETTER ATIUMEDEFAIDRIN CAPITAL LETTER" +
	" ZMEDEFAIDRIN CAPITAL LETTER KPMEDEFAIDRIN CAPITAL LETTER PMEDEFAIDRIN C" +
	"APITAL LETTER TMEDEFAIDRIN CAPITAL LETTER GMEDEFAIDRIN CAPITAL LETTER FM" +
	"EDEFAIDRIN CAPITAL LETTER IMEDEFAIDRIN CAPITAL LETTER KMEDEFAIDRIN CAPIT" +
	"AL LETTER AMEDEFAIDRIN CAPITAL LETTER JMEDEFAIDRIN CAPITAL LETTER EMEDEF" +
	"AIDRIN CAPITAL LETTER BMEDEFAIDRIN CAPITAL LETTER CMEDEFAIDRIN CAPITAL L" +
	"ETTER UMEDEFAIDRIN CAPITAL LETTER YUMEDEFAIDRIN CAPITAL LETTER LMEDEFAID") + ("" +
	"RIN CAPITAL LETTER QMEDEFAIDRIN CAPITAL LETTER HPMEDEFAIDRIN CAPITAL LET" +
	"TER NYMEDEFAIDRIN CAPITAL LETTER XMEDEFAIDRIN CAPITAL LETTER DMEDEFAIDRI" +
	"N CAPITAL LETTER OEMEDEFAIDRIN CAPITAL LETTER NMEDEFAIDRIN CAPITAL LETTE" +
	"R RMEDEFAIDRIN CAPITAL LETTER OMEDEFAIDRIN CAPITAL LETTER AIMEDEFAIDRIN " +
	"CAPITAL LETTER YMEDEFAIDRIN SMALL LETTER MMEDEFAIDRIN SMALL LETTER SMEDE" +
	"FAIDRIN SMALL LETTER VMEDEFAIDRIN SMALL LETTER WMEDEFAIDRIN SMALL LETTER" +
	" ATIUMEDEFAIDRIN SMALL LETTER ZMEDEFAIDRIN SMALL LETTER KPMEDEFAIDRIN SM" +
	"ALL LETTER PMEDEFAIDRIN SMALL LETTER TMEDEFAIDRIN SMALL LETTER GMEDEFAID" +
	"RIN SMALL LETTER FMEDEFAIDRIN SMALL LETTER IMEDEFAIDRIN SMALL LETTER KME" +
	"DEFAIDRIN SMALL LETTER AMEDEFAIDRIN SMALL LETTER JMEDEFAIDRIN SMALL LETT" +
	"ER EMEDEFAIDRIN SMALL LETTER BMEDEFAIDRIN SMALL LETTER CMEDEFAIDRIN SMAL" +
	"L LETTER UMEDEFAIDRIN SMALL LETTER YUMEDEFAIDRIN SMALL LETTER LMEDEFAIDR" +
	"IN SMALL LETTER QMEDEFAIDRIN SMALL LETTER HPMEDEFAIDRIN SMALL LETTER NYM" +
	"EDEFAIDRIN SMALL LETTER XMEDEFAIDRIN SMALL LETTER DMEDEFAIDRIN SMALL LET" +
	"TER OEMEDEFAIDRIN SMALL LETTER NMEDEFAIDRIN SMALL LETTER RMEDEFAIDRIN SM" +
	"ALL LETTER OMEDEFAIDRIN SMALL LETTER AIMEDEFAIDRIN SMALL LETTER YMEDEFAI" +
	"DRIN DIGIT ZEROMEDEFAIDRIN DIGIT ONEMEDEFAIDRIN DIGIT TWOMEDEFAIDRIN DIG" +
	"IT THREEMEDEFAIDRIN DIGIT FOURMEDEFAIDRIN DIGIT FIVEMEDEFAIDRIN DIGIT SI" +
	"XMEDEFAIDRIN DIGIT SEVENMEDEFAIDRIN DIGIT EIGHTMEDEFAIDRIN DIGIT NINEMED" +
	"EFAIDRIN NUMBER TENMEDEFAIDRIN NUMBER ELEVENMEDEFAIDRIN NUMBER TWELVEMED" +
	"EFAIDRIN NUMBER THIRTEENMEDEFAIDRIN NUMBER FOURTEENMEDEFAIDRIN NUMBER FI" +
	"FTEENMEDEFAIDRIN NUMBER SIXTEENMEDEFAIDRIN NUMBER SEVENTEENMEDEFAIDRIN N" +
	"UMBER EIGHTEENMEDEFAIDRIN NUMBER NINETEENMEDEFAIDRIN DIGIT ONE ALTERNATE" +
	" FORMMEDEFAIDRIN DIGIT TWO ALTERNATE FORMMEDEFAIDRIN DIGIT THREE ALTERNA" +
	"TE FORMMEDEFAIDRIN COMMAMEDEFAIDRIN FULL STOPMEDEFAIDRIN SYMBOL AIVAMEDE" +
	"FAIDRIN EXCLAMATION OHMIAO LETTER PAMIAO LETTER BAMIAO LETTER YI PAMIAO " +
	"LETTER PLAMIAO LETTER MAMIAO LETTER MHAMIAO LETTER ARCHAIC MAMIAO LETTER" +
	" FAMIAO LETTER VAMIAO LETTER VFAMIAO LETTER TAMIAO LETTER DAMIAO LETTER " +
	"YI TTAMIAO LETTER YI TAMIAO LETTER TTAMIAO LETTER DDAMIAO LETTER NAMIAO " +
	"LETTER NHAMIAO LETTER YI NNAMIAO LETTER ARCHAIC NAMIAO LETTER NNAMIAO LE" +
	"TTER NNHAMIAO LETTER LAMIAO LETTER LYAMIAO LETTER LHAMIAO LETTER LHYAMIA" +
	"O LETTER TLHAMIAO LETTER DLHAMIAO LETTER TLHYAMIAO LETTER DLHYAMIAO LETT" +
	"ER KAMIAO LETTER GAMIAO LETTER YI KAMIAO LETTER QAMIAO LETTER QGAMIAO LE" +
	"TTER NGAMIAO LETTER NGHAMIAO LETTER ARCHAIC NGAMIAO LETTER HAMIAO LETTER" +
	" XAMIAO LETTER GHAMIAO LETTER GHHAMIAO LETTER TSSAMIAO LETTER DZZAMIAO L" +
	"ETTER NYAMIAO LETTER NYHAMIAO LETTER TSHAMIAO LETTER DZHAMIAO LETTER YI " +
	"TSHAMIAO LETTER YI DZHAMIAO LETTER REFORMED TSHAMIAO LETTER SHAMIAO LETT" +
	"ER SSAMIAO LETTER ZHAMIAO LETTER ZSHAMIAO LETTER TSAMIAO LETTER DZAMIAO " +
	"LETTER YI TSAMIAO LETTER SAMIAO LETTER ZAMIAO LETTER ZSAMIAO LETTER ZZAM" +
	"IAO LETTER ZZSAMIAO LETTER ARCHAIC ZZAMIAO LETTER ZZYAMIAO LETTER ZZSYAM" +
	"IAO LETTER WAMIAO LETTER AHMIAO LETTER HHAMIAO LETTER BRIMIAO LETTER SYI" +
	"MIAO LETTER DZYIMIAO LETTER TEMIAO LETTER TSEMIAO LETTER RTEMIAO SIGN CO" +
	"NSONANT MODIFIER BARMIAO LETTER NASALIZATIONMIAO SIGN ASPIRATIONMIAO SIG" +
	"N REFORMED VOICINGMIAO SIGN REFORMED ASPIRATIONMIAO VOWEL SIGN AMIAO VOW" +
	"EL SIGN AAMIAO VOWEL SIGN AHHMIAO VOWEL SIGN ANMIAO VOWEL SIGN ANGMIAO V" +
	"OWEL SIGN OMIAO VOWEL SIGN OOMIAO VOWEL SIGN WOMIAO VOWEL SIGN WMIAO VOW" +
	"EL SIGN EMIAO VOWEL SIGN ENMIAO VOWEL SIGN ENGMIAO VOWEL SIGN OEYMIAO VO" +
	"WEL SIGN IMIAO VOWEL SIGN IAMIAO VOWEL SIGN IANMIAO VOWEL SIGN IANGMIAO " +
	"VOWEL SIGN IOMIAO VOWEL SIGN IEMIAO VOWEL SIGN IIMIAO VOWEL SIGN IUMIAO " +
	"VOWEL SIGN INGMIAO VOWEL SIGN UMIAO VOWEL SIGN UAMIAO VOWEL SIGN UANMIAO" +
	" VOWEL SIGN UANGMIAO VOWEL SIGN UUMIAO VOWEL SIGN UEIMIAO VOWEL SIGN UNG" +
	"MIAO VOWEL SIGN YMIAO VOWEL SIGN YIMIAO VOWEL SIGN AEMIAO VOWEL SIGN AEE" +
	"MIAO VOWEL SIGN ERRMIAO VOWEL SIGN ROUNDED ERRMIAO VOWEL SIGN ERMIAO VOW" +
	"EL SIGN ROUNDED ERMIAO VOWEL SIGN AIMIAO VOWEL SIGN EIMIAO VOWEL SIGN AU" +
	"MIAO VOWEL SIGN OUMIAO VOWEL SIGN NMIAO VOWEL SIGN NGMIAO VOWEL SIGN UOG" +
	"MIAO VOWEL SIGN YUIMIAO VOWEL SIGN OGMIAO VOWEL SIGN OERMIAO VOWEL SIGN " +
	"VWMIAO VOWEL SIGN IGMIAO VOWEL SIGN EAMIAO VOWEL SIGN IONGMIAO VOWEL SIG" +
	"N UIMIAO TONE RIGHTMIAO TONE TOP RIGHTMIAO TONE ABOVEMIAO TONE BELOWMIAO" +
	" LETTER TONE-2MIAO LETTER TONE-3MIAO LETTER TONE-4MIAO LETTER TONE-5MIAO" +
	" LETTER TONE-6MIAO LETTER TONE-7MIAO LETTER TONE-8MIAO LETTER REFORMED T" +
	"ONE-1MIAO LETTER REFORMED TONE-2MIAO LETTER REFORMED TONE-4MIAO LETTER R" +
	"EFORMED TONE-5MIAO LETTER REFORMED TONE-6MIAO LETTER REFORMED TONE-8TANG" +
	"UT ITERATION MARKNUSHU ITERATION MARKOLD CHINESE HOOK MARKOLD CHINESE IT" +
	"ERATION MARKKHITAN SMALL SCRIPT FILLERVIETNAMESE ALTERNATE READING MARK ") + ("" +
	"CAVIETNAMESE ALTERNATE READING MARK NHAYTANGUT COMPONENT-001TANGUT COMPO" +
	"NENT-002TANGUT COMPONENT-003TANGUT COMPONENT-004TANGUT COMPONENT-005TANG" +
	"UT COMPONENT-006TANGUT COMPONENT-007TANGUT COMPONENT-008TANGUT COMPONENT" +
	"-009TANGUT COMPONENT-010TANGUT COMPONENT-011TANGUT COMPONENT-012TANGUT C" +
	"OMPONENT-013TANGUT COMPONENT-014TANGUT COMPONENT-015TANGUT COMPONENT-016" +
	"TANGUT COMPONENT-017TANGUT COMPONENT-018TANGUT COMPONENT-019TANGUT COMPO" +
	"NENT-020TANGUT COMPONENT-021TANGUT COMPONENT-022TANGUT COMPONENT-023TANG" +
	"UT COMPONENT-024TANGUT COMPONENT-025TANGUT COMPONENT-026TANGUT COMPONENT" +
	"-027TANGUT COMPONENT-028TANGUT COMPONENT-029TANGUT COMPONENT-030TANGUT C" +
	"OMPONENT-031TANGUT COMPONENT-032TANGUT COMPONENT-033TANGUT COMPONENT-034" +
	"TANGUT COMPONENT-035TANGUT COMPONENT-036TANGUT COMPONENT-037TANGUT COMPO" +
	"NENT-038TANGUT COMPONENT-039TANGUT COMPONENT-040TANGUT COMPONENT-041TANG" +
	"UT COMPONENT-042TANGUT COMPONENT-043TANGUT COMPONENT-044TANGUT COMPONENT" +
	"-045TANGUT COMPONENT-046TANGUT COMPONENT-047TANGUT COMPONENT-048TANGUT C" +
	"OMPONENT-049TANGUT COMPONENT-050TANGUT COMPONENT-051TANGUT COMPONENT-052" +
	"TANGUT COMPONENT-053TANGUT COMPONENT-054TANGUT COMPONENT-055TANGUT COMPO" +
	"NENT-056TANGUT COMPONENT-057TANGUT COMPONENT-058TANGUT COMPONENT-059TANG" +
	"UT COMPONENT-060TANGUT COMPONENT-061TANGUT COMPONENT-062TANGUT COMPONENT" +
	"-063TANGUT COMPONENT-064TANGUT COMPONENT-065TANGUT COMPONENT-066TANGUT C" +
	"OMPONENT-067TANGUT COMPONENT-068TANGUT COMPONENT-069TANGUT COMPONENT-070" +
	"TANGUT COMPONENT-071TANGUT COMPONENT-072TANGUT COMPONENT-073TANGUT COMPO" +
	"NENT-074TANGUT COMPONENT-075TANGUT COMPONENT-076TANGUT COMPONENT-077TANG" +
	"UT COMPONENT-078TANGUT COMPONENT-079TANGUT COMPONENT-080TANGUT COMPONENT" +
	"-081TANGUT COMPONENT-082TANGUT COMPONENT-083TANGUT COMPONENT-084TANGUT C" +
	"OMPONENT-085TANGUT COMPONENT-086TANGUT COMPONENT-087TANGUT COMPONENT-088" +
	"TANGUT COMPONENT-089TANGUT COMPONENT-090TANGUT COMPONENT-091TANGUT COMPO" +
	"NENT-092TANGUT COMPONENT-093TANGUT COMPONENT-094TANGUT COMPONENT-095TANG" +
	"UT COMPONENT-096TANGUT COMPONENT-097TANGUT COMPONENT-098TANGUT COMPONENT" +
	"-099TANGUT COMPONENT-100TANGUT COMPONENT-101TANGUT COMPONENT-102TANGUT C" +
	"OMPONENT-103TANGUT COMPONENT-104TANGUT COMPONENT-105TANGUT COMPONENT-106" +
	"TANGUT COMPONENT-107TANGUT COMPONENT-108TANGUT COMPONENT-109TANGUT COMPO" +
	"NENT-110TANGUT COMPONENT-111TANGUT COMPONENT-112TANGUT COMPONENT-113TANG" +
	"UT COMPONENT-114TANGUT COMPONENT-115TANGUT COMPONENT-116TANGUT COMPONENT" +
	"-117TANGUT COMPONENT-118TANGUT COMPONENT-119TANGUT COMPONENT-120TANGUT C" +
	"OMPONENT-121TANGUT COMPONENT-122TANGUT COMPONENT-123TANGUT COMPONENT-124" +
	"TANGUT COMPONENT-125TANGUT COMPONENT-126TANGUT COMPONENT-127TANGUT COMPO" +
	"NENT-128TANGUT COMPONENT-129TANGUT COMPONENT-130TANGUT COMPONENT-131TANG" +
	"UT COMPONENT-132TANGUT COMPONENT-133TANGUT COMPONENT-134TANGUT COMPONENT" +
	"-135TANGUT COMPONENT-136TANGUT COMPONENT-137TANGUT COMPONENT-138TANGUT C" +
	"OMPONENT-139TANGUT COMPONENT-140TANGUT COMPONENT-141TANGUT COMPONENT-142" +
	"TANGUT COMPONENT-143TANGUT COMPONENT-144TANGUT COMPONENT-145TANGUT COMPO" +
	"NENT-146TANGUT COMPONENT-147TANGUT COMPONENT-148TANGUT COMPONENT-149TANG" +
	"UT COMPONENT-150TANGUT COMPONENT-151TANGUT COMPONENT-152TANGUT COMPONENT" +
	"-153TANGUT COMPONENT-154TANGUT COMPONENT-155TANGUT COMPONENT-156TANGUT C" +
	"OMPONENT-157TANGUT COMPONENT-158TANGUT COMPONENT-159TANGUT COMPONENT-160" +
	"TANGUT COMPONENT-161TANGUT COMPONENT-162TANGUT COMPONENT-163TANGUT COMPO" +
	"NENT-164TANGUT COMPONENT-165TANGUT COMPONENT-166TANGUT COMPONENT-167TANG" +
	"UT COMPONENT-168TANGUT COMPONENT-169TANGUT COMPONENT-170TANGUT COMPONENT" +
	"-171TANGUT COMPONENT-172TANGUT COMPONENT-173TANGUT COMPONENT-174TANGUT C" +
	"OMPONENT-175TANGUT COMPONENT-176TANGUT COMPONENT-177TANGUT COMPONENT-178" +
	"TANGUT COMPONENT-179TANGUT COMPONENT-180TANGUT COMPONENT-181TANGUT COMPO" +
	"NENT-182TANGUT COMPONENT-183TANGUT COMPONENT-184TANGUT COMPONENT-185TANG" +
	"UT COMPONENT-186TANGUT COMPONENT-187TANGUT COMPONENT-188TANGUT COMPONENT" +
	"-189TANGUT COMPONENT-190TANGUT COMPONENT-191TANGUT COMPONENT-192TANGUT C" +
	"OMPONENT-193TANGUT COMPONENT-194TANGUT COMPONENT-195TANGUT COMPONENT-196" +
	"TANGUT COMPONENT-197TANGUT COMPONENT-198TANGUT COMPONENT-199TANGUT COMPO" +
	"NENT-200TANGUT COMPONENT-201TANGUT COMPONENT-202TANGUT COMPONENT-203TANG" +
	"UT COMPONENT-204TANGUT COMPONENT-205TANGUT COMPONENT-206TANGUT COMPONENT" +
	"-207TANGUT COMPONENT-208TANGUT COMPONENT-209TANGUT COMPONENT-210TANGUT C" +
	"OMPONENT-211TANGUT COMPONENT-212TANGUT COMPONENT-213TANGUT COMPONENT-214" +
	"TANGUT COMPONENT-215TANGUT COMPONENT-216TANGUT COMPONENT-217TANGUT COMPO" +
	"NENT-218TANGUT COMPONENT-219TANGUT COMPONENT-220TANGUT COMPONENT-221TANG" +
	"UT COMPONENT-222TANGUT COMPONENT-223TANGUT COMPONENT-224TANGUT COMPONENT" +
	"-225TANGUT COMPONENT-226TANGUT COMPONENT-227TANGUT COMPONENT-228TANGUT C") + ("" +
	"OMPONENT-229TANGUT COMPONENT-230TANGUT COMPONENT-231TANGUT COMPONENT-232" +
	"TANGUT COMPONENT-233TANGUT COMPONENT-234TANGUT COMPONENT-235TANGUT COMPO" +
	"NENT-236TANGUT COMPONENT-237TANGUT COMPONENT-238TANGUT COMPONENT-239TANG" +
	"UT COMPONENT-240TANGUT COMPONENT-241TANGUT COMPONENT-242TANGUT COMPONENT" +
	"-243TANGUT COMPONENT-244TANGUT COMPONENT-245TANGUT COMPONENT-246TANGUT C" +
	"OMPONENT-247TANGUT COMPONENT-248TANGUT COMPONENT-249TANGUT COMPONENT-250" +
	"TANGUT COMPONENT-251TANGUT COMPONENT-252TANGUT COMPONENT-253TANGUT COMPO" +
	"NENT-254TANGUT COMPONENT-255TANGUT COMPONENT-256TANGUT COMPONENT-257TANG" +
	"UT COMPONENT-258TANGUT COMPONENT-259TANGUT COMPONENT-260TANGUT COMPONENT" +
	"-261TANGUT COMPONENT-262TANGUT COMPONENT-263TANGUT COMPONENT-264TANGUT C" +
	"OMPONENT-265TANGUT COMPONENT-266TANGUT COMPONENT-267TANGUT COMPONENT-268" +
	"TANGUT COMPONENT-269TANGUT COMPONENT-270TANGUT COMPONENT-271TANGUT COMPO" +
	"NENT-272TANGUT COMPONENT-273TANGUT COMPONENT-274TANGUT COMPONENT-275TANG" +
	"UT COMPONENT-276TANGUT COMPONENT-277TANGUT COMPONENT-278TANGUT COMPONENT" +
	"-279TANGUT COMPONENT-280TANGUT COMPONENT-281TANGUT COMPONENT-282TANGUT C" +
	"OMPONENT-283TANGUT COMPONENT-284TANGUT COMPONENT-285TANGUT COMPONENT-286" +
	"TANGUT COMPONENT-287TANGUT COMPONENT-288TANGUT COMPONENT-289TANGUT COMPO" +
	"NENT-290TANGUT COMPONENT-291TANGUT COMPONENT-292TANGUT COMPONENT-293TANG" +
	"UT COMPONENT-294TANGUT COMPONENT-295TANGUT COMPONENT-296TANGUT COMPONENT" +
	"-297TANGUT COMPONENT-298TANGUT COMPONENT-299TANGUT COMPONENT-300TANGUT C" +
	"OMPONENT-301TANGUT COMPONENT-302TANGUT COMPONENT-303TANGUT COMPONENT-304" +
	"TANGUT COMPONENT-305TANGUT COMPONENT-306TANGUT COMPONENT-307TANGUT COMPO" +
	"NENT-308TANGUT COMPONENT-309TANGUT COMPONENT-310TANGUT COMPONENT-311TANG" +
	"UT COMPONENT-312TANGUT COMPONENT-313TANGUT COMPONENT-314TANGUT COMPONENT" +
	"-315TANGUT COMPONENT-316TANGUT COMPONENT-317TANGUT COMPONENT-318TANGUT C" +
	"OMPONENT-319TANGUT COMPONENT-320TANGUT COMPONENT-321TANGUT COMPONENT-322" +
	"TANGUT COMPONENT-323TANGUT COMPONENT-324TANGUT COMPONENT-325TANGUT COMPO" +
	"NENT-326TANGUT COMPONENT-327TANGUT COMPONENT-328TANGUT COMPONENT-329TANG" +
	"UT COMPONENT-330TANGUT COMPONENT-331TANGUT COMPONENT-332TANGUT COMPONENT" +
	"-333TANGUT COMPONENT-334TANGUT COMPONENT-335TANGUT COMPONENT-336TANGUT C" +
	"OMPONENT-337TANGUT COMPONENT-338TANGUT COMPONENT-339TANGUT COMPONENT-340" +
	"TANGUT COMPONENT-341TANGUT COMPONENT-342TANGUT COMPONENT-343TANGUT COMPO" +
	"NENT-344TANGUT COMPONENT-345TANGUT COMPONENT-346TANGUT COMPONENT-347TANG" +
	"UT COMPONENT-348TANGUT COMPONENT-349TANGUT COMPONENT-350TANGUT COMPONENT" +
	"-351TANGUT COMPONENT-352TANGUT COMPONENT-353TANGUT COMPONENT-354TANGUT C" +
	"OMPONENT-355TANGUT COMPONENT-356TANGUT COMPONENT-357TANGUT COMPONENT-358" +
	"TANGUT COMPONENT-359TANGUT COMPONENT-360TANGUT COMPONENT-361TANGUT COMPO" +
	"NENT-362TANGUT COMPONENT-363TANGUT COMPONENT-364TANGUT COMPONENT-365TANG" +
	"UT COMPONENT-366TANGUT COMPONENT-367TANGUT COMPONENT-368TANGUT COMPONENT" +
	"-369TANGUT COMPONENT-370TANGUT COMPONENT-371TANGUT COMPONENT-372TANGUT C" +
	"OMPONENT-373TANGUT COMPONENT-374TANGUT COMPONENT-375TANGUT COMPONENT-376" +
	"TANGUT COMPONENT-377TANGUT COMPONENT-378TANGUT COMPONENT-379TANGUT COMPO" +
	"NENT-380TANGUT COMPONENT-381TANGUT COMPONENT-382TANGUT COMPONENT-383TANG" +
	"UT COMPONENT-384TANGUT COMPONENT-385TANGUT COMPONENT-386TANGUT COMPONENT" +
	"-387TANGUT COMPONENT-388TANGUT COMPONENT-389TANGUT COMPONENT-390TANGUT C" +
	"OMPONENT-391TANGUT COMPONENT-392TANGUT COMPONENT-393TANGUT COMPONENT-394" +
	"TANGUT COMPONENT-395TANGUT COMPONENT-396TANGUT COMPONENT-397TANGUT COMPO" +
	"NENT-398TANGUT COMPONENT-399TANGUT COMPONENT-400TANGUT COMPONENT-401TANG" +
	"UT COMPONENT-402TANGUT COMPONENT-403TANGUT COMPONENT-404TANGUT COMPONENT" +
	"-405TANGUT COMPONENT-406TANGUT COMPONENT-407TANGUT COMPONENT-408TANGUT C" +
	"OMPONENT-409TANGUT COMPONENT-410TANGUT COMPONENT-411TANGUT COMPONENT-412" +
	"TANGUT COMPONENT-413TANGUT COMPONENT-414TANGUT COMPONENT-415TANGUT COMPO" +
	"NENT-416TANGUT COMPONENT-417TANGUT COMPONENT-418TANGUT COMPONENT-419TANG" +
	"UT COMPONENT-420TANGUT COMPONENT-421TANGUT COMPONENT-422TANGUT COMPONENT" +
	"-423TANGUT COMPONENT-424TANGUT COMPONENT-425TANGUT COMPONENT-426TANGUT C" +
	"OMPONENT-427TANGUT COMPONENT-428TANGUT COMPONENT-429TANGUT COMPONENT-430" +
	"TANGUT COMPONENT-431TANGUT COMPONENT-432TANGUT COMPONENT-433TANGUT COMPO" +
	"NENT-434TANGUT COMPONENT-435TANGUT COMPONENT-436TANGUT COMPONENT-437TANG" +
	"UT COMPONENT-438TANGUT COMPONENT-439TANGUT COMPONENT-440TANGUT COMPONENT" +
	"-441TANGUT COMPONENT-442TANGUT COMPONENT-443TANGUT COMPONENT-444TANGUT C" +
	"OMPONENT-445TANGUT COMPONENT-446TANGUT COMPONENT-447TANGUT COMPONENT-448" +
	"TANGUT COMPONENT-449TANGUT COMPONENT-450TANGUT COMPONENT-451TANGUT COMPO" +
	"NENT-452TANGUT COMPONENT-453TANGUT COMPONENT-454TANGUT COMPONENT-455TANG" +
	"UT COMPONENT-456TANGUT COMPONENT-457TANGUT COMPONENT-458TANGUT COMPONENT") + ("" +
	"-459TANGUT COMPONENT-460TANGUT COMPONENT-461TANGUT COMPONENT-462TANGUT C" +
	"OMPONENT-463TANGUT COMPONENT-464TANGUT COMPONENT-465TANGUT COMPONENT-466" +
	"TANGUT COMPONENT-467TANGUT COMPONENT-468TANGUT COMPONENT-469TANGUT COMPO" +
	"NENT-470TANGUT COMPONENT-471TANGUT COMPONENT-472TANGUT COMPONENT-473TANG" +
	"UT COMPONENT-474TANGUT COMPONENT-475TANGUT COMPONENT-476TANGUT COMPONENT" +
	"-477TANGUT COMPONENT-478TANGUT COMPONENT-479TANGUT COMPONENT-480TANGUT C" +
	"OMPONENT-481TANGUT COMPONENT-482TANGUT COMPONENT-483TANGUT COMPONENT-484" +
	"TANGUT COMPONENT-485TANGUT COMPONENT-486TANGUT COMPONENT-487TANGUT COMPO" +
	"NENT-488TANGUT COMPONENT-489TANGUT COMPONENT-490TANGUT COMPONENT-491TANG" +
	"UT COMPONENT-492TANGUT COMPONENT-493TANGUT COMPONENT-494TANGUT COMPONENT" +
	"-495TANGUT COMPONENT-496TANGUT COMPONENT-497TANGUT COMPONENT-498TANGUT C" +
	"OMPONENT-499TANGUT COMPONENT-500TANGUT COMPONENT-501TANGUT COMPONENT-502" +
	"TANGUT COMPONENT-503TANGUT COMPONENT-504TANGUT COMPONENT-505TANGUT COMPO" +
	"NENT-506TANGUT COMPONENT-507TANGUT COMPONENT-508TANGUT COMPONENT-509TANG" +
	"UT COMPONENT-510TANGUT COMPONENT-511TANGUT COMPONENT-512TANGUT COMPONENT" +
	"-513TANGUT COMPONENT-514TANGUT COMPONENT-515TANGUT COMPONENT-516TANGUT C" +
	"OMPONENT-517TANGUT COMPONENT-518TANGUT COMPONENT-519TANGUT COMPONENT-520" +
	"TANGUT COMPONENT-521TANGUT COMPONENT-522TANGUT COMPONENT-523TANGUT COMPO" +
	"NENT-524TANGUT COMPONENT-525TANGUT COMPONENT-526TANGUT COMPONENT-527TANG" +
	"UT COMPONENT-528TANGUT COMPONENT-529TANGUT COMPONENT-530TANGUT COMPONENT" +
	"-531TANGUT COMPONENT-532TANGUT COMPONENT-533TANGUT COMPONENT-534TANGUT C" +
	"OMPONENT-535TANGUT COMPONENT-536TANGUT COMPONENT-537TANGUT COMPONENT-538" +
	"TANGUT COMPONENT-539TANGUT COMPONENT-540TANGUT COMPONENT-541TANGUT COMPO" +
	"NENT-542TANGUT COMPONENT-543TANGUT COMPONENT-544TANGUT COMPONENT-545TANG" +
	"UT COMPONENT-546TANGUT COMPONENT-547TANGUT COMPONENT-548TANGUT COMPONENT" +
	"-549TANGUT COMPONENT-550TANGUT COMPONENT-551TANGUT COMPONENT-552TANGUT C" +
	"OMPONENT-553TANGUT COMPONENT-554TANGUT COMPONENT-555TANGUT COMPONENT-556" +
	"TANGUT COMPONENT-557TANGUT COMPONENT-558TANGUT COMPONENT-559TANGUT COMPO" +
	"NENT-560TANGUT COMPONENT-561TANGUT COMPONENT-562TANGUT COMPONENT-563TANG" +
	"UT COMPONENT-564TANGUT COMPONENT-565TANGUT COMPONENT-566TANGUT COMPONENT" +
	"-567TANGUT COMPONENT-568TANGUT COMPONENT-569TANGUT COMPONENT-570TANGUT C" +
	"OMPONENT-571TANGUT COMPONENT-572TANGUT COMPONENT-573TANGUT COMPONENT-574" +
	"TANGUT COMPONENT-575TANGUT COMPONENT-576TANGUT COMPONENT-577TANGUT COMPO" +
	"NENT-578TANGUT COMPONENT-579TANGUT COMPONENT-580TANGUT COMPONENT-581TANG" +
	"UT COMPONENT-582TANGUT COMPONENT-583TANGUT COMPONENT-584TANGUT COMPONENT" +
	"-585TANGUT COMPONENT-586TANGUT COMPONENT-587TANGUT COMPONENT-588TANGUT C" +
	"OMPONENT-589TANGUT COMPONENT-590TANGUT COMPONENT-591TANGUT COMPONENT-592" +
	"TANGUT COMPONENT-593TANGUT COMPONENT-594TANGUT COMPONENT-595TANGUT COMPO" +
	"NENT-596TANGUT COMPONENT-597TANGUT COMPONENT-598TANGUT COMPONENT-599TANG" +
	"UT COMPONENT-600TANGUT COMPONENT-601TANGUT COMPONENT-602TANGUT COMPONENT" +
	"-603TANGUT COMPONENT-604TANGUT COMPONENT-605TANGUT COMPONENT-606TANGUT C" +
	"OMPONENT-607TANGUT COMPONENT-608TANGUT COMPONENT-609TANGUT COMPONENT-610" +
	"TANGUT COMPONENT-611TANGUT COMPONENT-612TANGUT COMPONENT-613TANGUT COMPO" +
	"NENT-614TANGUT COMPONENT-615TANGUT COMPONENT-616TANGUT COMPONENT-617TANG" +
	"UT COMPONENT-618TANGUT COMPONENT-619TANGUT COMPONENT-620TANGUT COMPONENT" +
	"-621TANGUT COMPONENT-622TANGUT COMPONENT-623TANGUT COMPONENT-624TANGUT C" +
	"OMPONENT-625TANGUT COMPONENT-626TANGUT COMPONENT-627TANGUT COMPONENT-628" +
	"TANGUT COMPONENT-629TANGUT COMPONENT-630TANGUT COMPONENT-631TANGUT COMPO" +
	"NENT-632TANGUT COMPONENT-633TANGUT COMPONENT-634TANGUT COMPONENT-635TANG" +
	"UT COMPONENT-636TANGUT COMPONENT-637TANGUT COMPONENT-638TANGUT COMPONENT" +
	"-639TANGUT COMPONENT-640TANGUT COMPONENT-641TANGUT COMPONENT-642TANGUT C" +
	"OMPONENT-643TA