// Code generated by running "go generate" in golang.org/x/text. DO NOT EDIT.

package currency

import "golang.org/x/text/internal/tag"

// CLDRVersion is the CLDR version from which the tables in this package are derived.
const CLDRVersion = "32"

const (
	xxx = 285
	xts = 283
	usd = 252
	eur = 94
	jpy = 133
	gbp = 99
	chf = 61
	aud = 19
	nzd = 192
	cad = 58
	sek = 219
	nok = 190
	dkk = 82
	xag = 266
	xau = 267
	xpt = 280
	xpd = 278
	brl = 46
	cny = 68
	inr = 125
	rub = 210
	hkd = 114
	idr = 120
	krw = 141
	mxn = 178
	pln = 201
	sar = 213
	thb = 235
	try = 244
	twd = 246
	zar = 293
)

// currency holds an alphabetically sorted list of canonical 3-letter currency
// identifiers. Each identifier is followed by a byte of type currencyInfo,
// defined in gen_common.go.
const currency tag.Index = "" + // Size: 1208 bytes
	"\x00\x00\x00\x00ADP\x09AED\x00AFA\x00AFN\x09ALK\x00ALL\x09AMD\x09ANG\x00" +
	"AOA\x00AOK\x00AON\x00AOR\x00ARA\x00ARL\x00ARM\x00ARP\x00ARS\x00ATS\x00AU" +
	"D\x00AWG\x00AZM\x00AZN\x00BAD\x00BAM\x00BAN\x00BBD\x00BDT\x00BEC\x00BEF" +
	"\x00BEL\x00BGL\x00BGM\x00BGN\x00BGO\x00BHD\x1bBIF\x09BMD\x00BND\x00BOB" +
	"\x00BOL\x00BOP\x00BOV\x00BRB\x00BRC\x00BRE\x00BRL\x00BRN\x00BRR\x00BRZ" +
	"\x00BSD\x00BTN\x00BUK\x00BWP\x00BYB\x00BYN\x00BYR\x09BZD\x00CAD(CDF\x00C" +
	"HE\x00CHF(CHW\x00CLE\x00CLF$CLP\x09CNH\x00CNX\x00CNY\x00COP\x09COU\x00CR" +
	"C\x08CSD\x00CSK\x00CUC\x00CUP\x00CVE\x00CYP\x00CZK\x08DDM\x00DEM\x00DJF" +
	"\x09DKK0DOP\x00DZD\x00ECS\x00ECV\x00EEK\x00EGP\x00ERN\x00ESA\x00ESB\x00E" +
	"SP\x09ETB\x00EUR\x00FIM\x00FJD\x00FKP\x00FRF\x00GBP\x00GEK\x00GEL\x00GHC" +
	"\x00GHS\x00GIP\x00GMD\x00GNF\x09GNS\x00GQE\x00GRD\x00GTQ\x00GWE\x00GWP" +
	"\x00GYD\x09HKD\x00HNL\x00HRD\x00HRK\x00HTG\x00HUF\x08IDR\x09IEP\x00ILP" +
	"\x00ILR\x00ILS\x00INR\x00IQD\x09IRR\x09ISJ\x00ISK\x09ITL\x09JMD\x00JOD" +
	"\x1bJPY\x09KES\x00KGS\x00KHR\x00KMF\x09KPW\x09KRH\x00KRO\x00KRW\x09KWD" +
	"\x1bKYD\x00KZT\x00LAK\x09LBP\x09LKR\x00LRD\x00LSL\x00LTL\x00LTT\x00LUC" +
	"\x00LUF\x09LUL\x00LVL\x00LVR\x00LYD\x1bMAD\x00MAF\x00MCF\x00MDC\x00MDL" +
	"\x00MGA\x09MGF\x09MKD\x00MKN\x00MLF\x00MMK\x09MNT\x09MOP\x00MRO\x09MTL" +
	"\x00MTP\x00MUR\x09MVP\x00MVR\x00MWK\x00MXN\x00MXP\x00MXV\x00MYR\x00MZE" +
	"\x00MZM\x00MZN\x00NAD\x00NGN\x00NIC\x00NIO\x00NLG\x00NOK\x08NPR\x00NZD" +
	"\x00OMR\x1bPAB\x00PEI\x00PEN\x00PES\x00PGK\x00PHP\x00PKR\x09PLN\x00PLZ" +
	"\x00PTE\x00PYG\x09QAR\x00RHD\x00ROL\x00RON\x00RSD\x09RUB\x00RUR\x00RWF" +
	"\x09SAR\x00SBD\x00SCR\x00SDD\x00SDG\x00SDP\x00SEK\x08SGD\x00SHP\x00SIT" +
	"\x00SKK\x00SLL\x09SOS\x09SRD\x00SRG\x00SSP\x00STD\x09STN\x00SUR\x00SVC" +
	"\x00SYP\x09SZL\x00THB\x00TJR\x00TJS\x00TMM\x09TMT\x00TND\x1bTOP\x00TPE" +
	"\x00TRL\x09TRY\x00TTD\x00TWD\x08TZS\x09UAH\x00UAK\x00UGS\x00UGX\x09USD" +
	"\x00USN\x00USS\x00UYI\x09UYP\x00UYU\x00UZS\x09VEB\x00VEF\x00VND\x09VNN" +
	"\x00VUV\x09WST\x00XAF\x09XAG\x00XAU\x00XBA\x00XBB\x00XBC\x00XBD\x00XCD" +
	"\x00XDR\x00XEU\x00XFO\x00XFU\x00XOF\x09XPD\x00XPF\x09XPT\x00XRE\x00XSU" +
	"\x00XTS\x00XUA\x00XXX\x00YDD\x00YER\x09YUD\x00YUM\x00YUN\x00YUR\x00ZAL" +
	"\x00ZAR\x00ZMK\x09ZMW\x00ZRN\x00ZRZ\x00ZWD\x09ZWL\x00ZWR\x00\xff\xff\xff" +
	"\xff"

const numCurrencies = 300

type toCurrency struct {
	region uint16
	code   uint16
}

var regionToCurrency = []toCurrency{ // 255 elements
	0:   {region: 0x4143, code: 0xdd},
	1:   {region: 0x4144, code: 0x5e},
	2:   {region: 0x4145, code: 0x2},
	3:   {region: 0x4146, code: 0x4},
	4:   {region: 0x4147, code: 0x110},
	5:   {region: 0x4149, code: 0x110},
	6:   {region: 0x414c, code: 0x6},
	7:   {region: 0x414d, code: 0x7},
	8:   {region: 0x414f, code: 0x9},
	9:   {region: 0x4152, code: 0x11},
	10:  {region: 0x4153, code: 0xfc},
	11:  {region: 0x4154, code: 0x5e},
	12:  {region: 0x4155, code: 0x13},
	13:  {region: 0x4157, code: 0x14},
	14:  {region: 0x4158, code: 0x5e},
	15:  {region: 0x415a, code: 0x16},
	16:  {region: 0x4241, code: 0x18},
	17:  {region: 0x4242, code: 0x1a},
	18:  {region: 0x4244, code: 0x1b},
	19:  {region: 0x4245, code: 0x5e},
	20:  {region: 0x4246, code: 0x115},
	21:  {region: 0x4247, code: 0x21},
	22:  {region: 0x4248, code: 0x23},
	23:  {region: 0x4249, code: 0x24},
	24:  {region: 0x424a, code: 0x115},
	25:  {region: 0x424c, code: 0x5e},
	26:  {region: 0x424d, code: 0x25},
	27:  {region: 0x424e, code: 0x26},
	28:  {region: 0x424f, code: 0x27},
	29:  {region: 0x4251, code: 0xfc},
	30:  {region: 0x4252, code: 0x2e},
	31:  {region: 0x4253, code: 0x32},
	32:  {region: 0x4254, code: 0x33},
	33:  {region: 0x4256, code: 0xbe},
	34:  {region: 0x4257, code: 0x35},
	35:  {region: 0x4259, code: 0x37},
	36:  {region: 0x425a, code: 0x39},
	37:  {region: 0x4341, code: 0x3a},
	38:  {region: 0x4343, code: 0x13},
	39:  {region: 0x4344, code: 0x3b},
	40:  {region: 0x4346, code: 0x109},
	41:  {region: 0x4347, code: 0x109},
	42:  {region: 0x4348, code: 0x3d},
	43:  {region: 0x4349, code: 0x115},
	44:  {region: 0x434b, code: 0xc0},
	45:  {region: 0x434c, code: 0x41},
	46:  {region: 0x434d, code: 0x109},
	47:  {region: 0x434e, code: 0x44},
	48:  {region: 0x434f, code: 0x45},
	49:  {region: 0x4352, code: 0x47},
	50:  {region: 0x4355, code: 0x4b},
	51:  {region: 0x4356, code: 0x4c},
	52:  {region: 0x4357, code: 0x8},
	53:  {region: 0x4358, code: 0x13},
	54:  {region: 0x4359, code: 0x5e},
	55:  {region: 0x435a, code: 0x4e},
	56:  {region: 0x4445, code: 0x5e},
	57:  {region: 0x4447, code: 0xfc},
	58:  {region: 0x444a, code: 0x51},
	59:  {region: 0x444b, code: 0x52},
	60:  {region: 0x444d, code: 0x110},
	61:  {region: 0x444f, code: 0x53},
	62:  {region: 0x445a, code: 0x54},
	63:  {region: 0x4541, code: 0x5e},
	64:  {region: 0x4543, code: 0xfc},
	65:  {region: 0x4545, code: 0x5e},
	66:  {region: 0x4547, code: 0x58},
	67:  {region: 0x4548, code: 0x9e},
	68:  {region: 0x4552, code: 0x59},
	69:  {region: 0x4553, code: 0x5e},
	70:  {region: 0x4554, code: 0x5d},
	71:  {region: 0x4555, code: 0x5e},
	72:  {region: 0x4649, code: 0x5e},
	73:  {region: 0x464a, code: 0x60},
	74:  {region: 0x464b, code: 0x61},
	75:  {region: 0x464d, code: 0xfc},
	76:  {region: 0x464f, code: 0x52},
	77:  {region: 0x4652, code: 0x5e},
	78:  {region: 0x4741, code: 0x109},
	79:  {region: 0x4742, code: 0x63},
	80:  {region: 0x4744, code: 0x110},
	81:  {region: 0x4745, code: 0x65},
	82:  {region: 0x4746, code: 0x5e},
	83:  {region: 0x4747, code: 0x63},
	84:  {region: 0x4748, code: 0x67},
	85:  {region: 0x4749, code: 0x68},
	86:  {region: 0x474c, code: 0x52},
	87:  {region: 0x474d, code: 0x69},
	88:  {region: 0x474e, code: 0x6a},
	89:  {region: 0x4750, code: 0x5e},
	90:  {region: 0x4751, code: 0x109},
	91:  {region: 0x4752, code: 0x5e},
	92:  {region: 0x4753, code: 0x63},
	93:  {region: 0x4754, code: 0x6e},
	94:  {region: 0x4755, code: 0xfc},
	95:  {region: 0x4757, code: 0x115},
	96:  {region: 0x4759, code: 0x71},
	97:  {region: 0x484b, code: 0x72},
	98:  {region: 0x484d, code: 0x13},
	99:  {region: 0x484e, code: 0x73},
	100: {region: 0x4852, code: 0x75},
	101: {region: 0x4854, code: 0x76},
	102: {region: 0x4855, code: 0x77},
	103: {region: 0x4943, code: 0x5e},
	104: {region: 0x4944, code: 0x78},
	105: {region: 0x4945, code: 0x5e},
	106: {region: 0x494c, code: 0x7c},
	107: {region: 0x494d, code: 0x63},
	108: {region: 0x494e, code: 0x7d},
	109: {region: 0x494f, code: 0xfc},
	110: {region: 0x4951, code: 0x7e},
	111: {region: 0x4952, code: 0x7f},
	112: {region: 0x4953, code: 0x81},
	113: {region: 0x4954, code: 0x5e},
	114: {region: 0x4a45, code: 0x63},
	115: {region: 0x4a4d, code: 0x83},
	116: {region: 0x4a4f, code: 0x84},
	117: {region: 0x4a50, code: 0x85},
	118: {region: 0x4b45, code: 0x86},
	119: {region: 0x4b47, code: 0x87},
	120: {region: 0x4b48, code: 0x88},
	121: {region: 0x4b49, code: 0x13},
	122: {region: 0x4b4d, code: 0x89},
	123: {region: 0x4b4e, code: 0x110},
	124: {region: 0x4b50, code: 0x8a},
	125: {region: 0x4b52, code: 0x8d},
	126: {region: 0x4b57, code: 0x8e},
	127: {region: 0x4b59, code: 0x8f},
	128: {region: 0x4b5a, code: 0x90},
	129: {region: 0x4c41, code: 0x91},
	130: {region: 0x4c42, code: 0x92},
	131: {region: 0x4c43, code: 0x110},
	132: {region: 0x4c49, code: 0x3d},
	133: {region: 0x4c4b, code: 0x93},
	134: {region: 0x4c52, code: 0x94},
	135: {region: 0x4c53, code: 0x125},
	136: {region: 0x4c54, code: 0x5e},
	137: {region: 0x4c55, code: 0x5e},
	138: {region: 0x4c56, code: 0x5e},
	139: {region: 0x4c59, code: 0x9d},
	140: {region: 0x4d41, code: 0x9e},
	141: {region: 0x4d43, code: 0x5e},
	142: {region: 0x4d44, code: 0xa2},
	143: {region: 0x4d45, code: 0x5e},
	144: {region: 0x4d46, code: 0x5e},
	145: {region: 0x4d47, code: 0xa3},
	146: {region: 0x4d48, code: 0xfc},
	147: {region: 0x4d4b, code: 0xa5},
	148: {region: 0x4d4c, code: 0x115},
	149: {region: 0x4d4d, code: 0xa8},
	150: {region: 0x4d4e, code: 0xa9},
	151: {region: 0x4d4f, code: 0xaa},
	152: {region: 0x4d50, code: 0xfc},
	153: {region: 0x4d51, code: 0x5e},
	154: {region: 0x4d52, code: 0xab},
	155: {region: 0x4d53, code: 0x110},
	156: {region: 0x4d54, code: 0x5e},
	157: {region: 0x4d55, code: 0xae},
	158: {region: 0x4d56, code: 0xb0},
	159: {region: 0x4d57, code: 0xb1},
	160: {region: 0x4d58, code: 0xb2},
	161: {region: 0x4d59, code: 0xb5},
	162: {region: 0x4d5a, code: 0xb8},
	163: {region: 0x4e41, code: 0xb9},
	164: {region: 0x4e43, code: 0x117},
	165: {region: 0x4e45, code: 0x115},
	166: {region: 0x4e46, code: 0x13},
	167: {region: 0x4e47, code: 0xba},
	168: {region: 0x4e49, code: 0xbc},
	169: {region: 0x4e4c, code: 0x5e},
	170: {region: 0x4e4f, code: 0xbe},
	171: {region: 0x4e50, code: 0xbf},
	172: {region: 0x4e52, code: 0x13},
	173: {region: 0x4e55, code: 0xc0},
	174: {region: 0x4e5a, code: 0xc0},
	175: {region: 0x4f4d, code: 0xc1},
	176: {region: 0x5041, code: 0xc2},
	177: {region: 0x5045, code: 0xc4},
	178: {region: 0x5046, code: 0x117},
	179: {region: 0x5047, code: 0xc6},
	180: {region: 0x5048, code: 0xc7},
	181: {region: 0x504b, code: 0xc8},
	182: {region: 0x504c, code: 0xc9},
	183: {region: 0x504d, code: 0x5e},
	184: {region: 0x504e, code: 0xc0},
	185: {region: 0x5052, code: 0xfc},
	186: {region: 0x5053, code: 0x7c},
	187: {region: 0x5054, code: 0x5e},
	188: {region: 0x5057, code: 0xfc},
	189: {region: 0x5059, code: 0xcc},
	190: {region: 0x5141, code: 0xcd},
	191: {region: 0x5245, code: 0x5e},
	192: {region: 0x524f, code: 0xd0},
	193: {region: 0x5253, code: 0xd1},
	194: {region: 0x5255, code: 0xd2},
	195: {region: 0x5257, code: 0xd4},
	196: {region: 0x5341, code: 0xd5},
	197: {region: 0x5342, code: 0xd6},
	198: {region: 0x5343, code: 0xd7},
	199: {region: 0x5344, code: 0xd9},
	200: {region: 0x5345, code: 0xdb},
	201: {region: 0x5347, code: 0xdc},
	202: {region: 0x5348, code: 0xdd},
	203: {region: 0x5349, code: 0x5e},
	204: {region: 0x534a, code: 0xbe},
	205: {region: 0x534b, code: 0x5e},
	206: {region: 0x534c, code: 0xe0},
	207: {region: 0x534d, code: 0x5e},
	208: {region: 0x534e, code: 0x115},
	209: {region: 0x534f, code: 0xe1},
	210: {region: 0x5352, code: 0xe2},
	211: {region: 0x5353, code: 0xe4},
	212: {region: 0x5354, code: 0xe6},
	213: {region: 0x5356, code: 0xfc},
	214: {region: 0x5358, code: 0x8},
	215: {region: 0x5359, code: 0xe9},
	216: {region: 0x535a, code: 0xea},
	217: {region: 0x5441, code: 0x63},
	218: {region: 0x5443, code: 0xfc},
	219: {region: 0x5444, code: 0x109},
	220: {region: 0x5446, code: 0x5e},
	221: {region: 0x5447, code: 0x115},
	222: {region: 0x5448, code: 0xeb},
	223: {region: 0x544a, code: 0xed},
	224: {region: 0x544b, code: 0xc0},
	225: {region: 0x544c, code: 0xfc},
	226: {region: 0x544d, code: 0xef},
	227: {region: 0x544e, code: 0xf0},
	228: {region: 0x544f, code: 0xf1},
	229: {region: 0x5452, code: 0xf4},
	230: {region: 0x5454, code: 0xf5},
	231: {region: 0x5456, code: 0x13},
	232: {region: 0x5457, code: 0xf6},
	233: {region: 0x545a, code: 0xf7},
	234: {region: 0x5541, code: 0xf8},
	235: {region: 0x5547, code: 0xfb},
	236: {region: 0x554d, code: 0xfc},
	237: {region: 0x5553, code: 0xfc},
	238: {region: 0x5559, code: 0x101},
	239: {region: 0x555a, code: 0x102},
	240: {region: 0x5641, code: 0x5e},
	241: {region: 0x5643, code: 0x110},
	242: {region: 0x5645, code: 0x104},
	243: {region: 0x5647, code: 0xfc},
	244: {region: 0x5649, code: 0xfc},
	245: {region: 0x564e, code: 0x105},
	246: {region: 0x5655, code: 0x107},
	247: {region: 0x5746, code: 0x117},
	248: {region: 0x5753, code: 0x108},
	249: {region: 0x584b, code: 0x5e},
	250: {region: 0x5945, code: 0x11f},
	251: {region: 0x5954, code: 0x5e},
	252: {region: 0x5a41, code: 0x125},
	253: {region: 0x5a4d, code: 0x127},
	254: {region: 0x5a57, code: 0xfc},
} // Size: 1044 bytes

type regionInfo struct {
	region uint16
	code   uint16
	from   uint32
	to     uint32
}

var regionData = []regionInfo{ // 495 elements
	0:   {region: 0x4143, code: 0xdd, from: 0xf7021, to: 0x0},
	1:   {region: 0x4144, code: 0x5e, from: 0xf9e21, to: 0x0},
	2:   {region: 0x4144, code: 0x5c, from: 0xea221, to: 0xfa45c},
	3:   {region: 0x4144, code: 0x62, from: 0xf5021, to: 0xfa451},
	4:   {region: 0x4144, code: 0x1, from: 0xf2021, to: 0xfa39f},
	5:   {region: 0x4145, code: 0x2, from: 0xf6ab3, to: 0x0},
	6:   {region: 0x4146, code: 0x4, from: 0xfa547, to: 0x0},
	7:   {region: 0x4146, code: 0x3, from: 0xf0e6e, to: 0xfa59f},
	8:   {region: 0x4147, code: 0x110, from: 0xf5b46, to: 0x0},
	9:   {region: 0x4149, code: 0x110, from: 0xf5b46, to: 0x0},
	10:  {region: 0x414c, code: 0x6, from: 0xf5b10, to: 0x0},
	11:  {region: 0x414c, code: 0x5, from: 0xf3561, to: 0xf5b10},
	12:  {region: 0x414d, code: 0x7, from: 0xf9376, to: 0x0},
	13:  {region: 0x414d, code: 0xd3, from: 0xf8f99, to: 0xf9376},
	14:  {region: 0x414d, code: 0xe7, from: 0xf5221, to: 0xf8f99},
	15:  {region: 0x414f, code: 0x9, from: 0xf9f8d, to: 0x0},
	16:  {region: 0x414f, code: 0xc, from: 0xf96e1, to: 0xfa041},
	17:  {region: 0x414f, code: 0xb, from: 0xf8d39, to: 0xfa041},
	18:  {region: 0x414f, code: 0xa, from: 0xf7228, to: 0xf8e61},
	19:  {region: 0x4151, code: 0x811d, from: 0x0, to: 0x0},
	20:  {region: 0x4152, code: 0x11, from: 0xf9021, to: 0x0},
	21:  {region: 0x4152, code: 0xd, from: 0xf82ce, to: 0xf9021},
	22:  {region: 0x4152, code: 0x10, from: 0xf7ec1, to: 0xf82ce},
	23:  {region: 0x4152, code: 0xe, from: 0xf6421, to: 0xf7ec1},
	24:  {region: 0x4152, code: 0xf, from: 0xeb365, to: 0xf6421},
	25:  {region: 0x4153, code: 0xfc, from: 0xee0f0, to: 0x0},
	26:  {region: 0x4154, code: 0x5e, from: 0xf9e21, to: 0x0},
	27:  {region: 0x4154, code: 0x12, from: 0xf3784, to: 0xfa45c},
	28:  {region: 0x4155, code: 0x13, from: 0xf5c4e, to: 0x0},
	29:  {region: 0x4157, code: 0x14, from: 0xf8421, to: 0x0},
	30:  {region: 0x4157, code: 0x8, from: 0xf28aa, to: 0xf8421},
	31:  {region: 0x4158, code: 0x5e, from: 0xf9e21, to: 0x0},
	32:  {region: 0x415a, code: 0x16, from: 0xfac21, to: 0x0},
	33:  {region: 0x415a, code: 0x15, from: 0xf9376, to: 0xfad9f},
	34:  {region: 0x415a, code: 0xd3, from: 0xf8f99, to: 0xf9421},
	35:  {region: 0x415a, code: 0xe7, from: 0xf5221, to: 0xf8f99},
	36:  {region: 0x4241, code: 0x18, from: 0xf9621, to: 0x0},
	37:  {region: 0x4241, code: 0x19, from: 0xf950f, to: 0xf9ae1},
	38:  {region: 0x4241, code: 0x17, from: 0xf90e1, to: 0xf950f},
	39:  {region: 0x4241, code: 0x123, from: 0xf90e1, to: 0xf9341},
	40:  {region: 0x4241, code: 0x122, from: 0xf8c21, to: 0xf90e1},
	41:  {region: 0x4241, code: 0x120, from: 0xf5c21, to: 0xf8c21},
	42:  {region: 0x4242, code: 0x1a, from: 0xf6b83, to: 0x0},
	43:  {region: 0x4242, code: 0x110, from: 0xf5b46, to: 0xf6b83},
	44:  {region: 0x4244, code: 0x1b, from: 0xf6821, to: 0x0},
	45:  {region: 0x4244, code: 0xc8, from: 0xf3881, to: 0xf6821},
	46:  {region: 0x4244, code: 0x7d, from: 0xe5711, to: 0xf3881},
	47:  {region: 0x4245, code: 0x5e, from: 0xf9e21, to: 0x0},
	48:  {region: 0x4245, code: 0x1d, from: 0xe4e47, to: 0xfa45c},
	49:  {region: 0x4245, code: 0xbd, from: 0xe318f, to: 0xe4e47},
	50:  {region: 0x4245, code: 0x801e, from: 0xf6421, to: 0xf8c65},
	51:  {region: 0x4245, code: 0x801c, from: 0xf6421, to: 0xf8c65},
	52:  {region: 0x4246, code: 0x115, from: 0xf8104, to: 0x0},
	53:  {region: 0x4247, code: 0x21, from: 0xf9ee5, to: 0x0},
	54:  {region: 0x4247, code: 0x1f, from: 0xf5421, to: 0xf9ee5},
	55:  {region: 0x4247, code: 0x20, from: 0xf40ac, to: 0xf5421},
	56:  {region: 0x4247, code: 0x22, from: 0xeaee8, to: 0xf40ac},
	57:  {region: 0x4248, code: 0x23, from: 0xf5b50, to: 0x0},
	58:  {region: 0x4249, code: 0x24, from: 0xf58b3, to: 0x0},
	59:  {region: 0x424a, code: 0x115, from: 0xf6f7e, to: 0x0},
	60:  {region: 0x424c, code: 0x5e, from: 0xf9e21, to: 0x0},
	61:  {region: 0x424c, code: 0x62, from: 0xf5021, to: 0xfa451},
	62:  {region: 0x424d, code: 0x25, from: 0xf6446, to: 0x0},
	63:  {region: 0x424e, code: 0x26, from: 0xf5ecc, to: 0x0},
	64:  {region: 0x424e, code: 0xb5, from: 0xf5730, to: 0xf5ecc},
	65:  {region: 0x424f, code: 0x27, from: 0xf8621, to: 0x0},
	66:  {region: 0x424f, code: 0x29, from: 0xf5621, to: 0xf859f},
	67:  {region: 0x424f, code: 0x28, from: 0xe8ed7, to: 0xf5621},
	68:  {region: 0x424f, code: 0x802a, from: 0x0, to: 0x0},
	69:  {region: 0x4251, code: 0xfc, from: 0xfb621, to: 0x0},
	70:  {region: 0x4251, code: 0x8, from: 0xfb54a, to: 0xfb621},
	71:  {region: 0x4252, code: 0x2e, from: 0xf94e1, to: 0x0},
	72:  {region: 0x4252, code: 0x30, from: 0xf9301, to: 0xf94e1},
	73:  {region: 0x4252, code: 0x2d, from: 0xf8c70, to: 0xf9301},
	74:  {region: 0x4252, code: 0x2f, from: 0xf8a2f, to: 0xf8c70},
	75:  {region: 0x4252, code: 0x2c, from: 0xf845c, to: 0xf8a2f},
	76:  {region: 0x4252, code: 0x2b, from: 0xf5e4d, to: 0xf845c},
	77:  {region: 0x4252, code: 0x31, from: 0xf2d61, to: 0xf5e4d},
	78:  {region: 0x4253, code: 0x32, from: 0xf5cb9, to: 0x0},
	79:  {region: 0x4254, code: 0x33, from: 0xf6c90, to: 0x0},
	80:  {region: 0x4254, code: 0x7d, from: 0xee621, to: 0x0},
	81:  {region: 0x4255, code: 0x34, from: 0xf40e1, to: 0xf8ad2},
	82:  {region: 0x4256, code: 0xbe, from: 0xee2c7, to: 0x0},
	83:  {region: 0x4257, code: 0x35, from: 0xf7117, to: 0x0},
	84:  {region: 0x4257, code: 0x125, from: 0xf524e, to: 0xf7117},
	85:  {region: 0x4259, code: 0x37, from: 0xfc0e1, to: 0x0},
	86:  {region: 0x4259, code: 0x38, from: 0xfa021, to: 0xfc221},
	87:  {region: 0x4259, code: 0x36, from: 0xf9501, to: 0xfa19f},
	88:  {region: 0x4259, code: 0xd3, from: 0xf8f99, to: 0xf9568},
	89:  {region: 0x4259, code: 0xe7, from: 0xf5221, to: 0xf8f99},
	90:  {region: 0x425a, code: 0x39, from: 0xf6c21, to: 0x0},
	91:  {region: 0x4341, code: 0x3a, from: 0xe8421, to: 0x0},
	92:  {region: 0x4343, code: 0x13, from: 0xf5c4e, to: 0x0},
	93:  {region: 0x4344, code: 0x3b, from: 0xf9ce1, to: 0x0},
	94:  {region: 0x4344, code: 0x128, from: 0xf9361, to: 0xf9ce1},
	95:  {region: 0x4344, code: 0x129, from: 0xf675b, to: 0xf9361},
	96:  {region: 0x4346, code: 0x109, from: 0xf9221, to: 0x0},
	97:  {region: 0x4347, code: 0x109, from: 0xf9221, to: 0x0},
	98:  {region: 0x4348, code: 0x3d, from: 0xe0e71, to: 0x0},
	99:  {region: 0x4348, code: 0x803c, from: 0x0, to: 0x0},
	100: {region: 0x4348, code: 0x803e, from: 0x0, to: 0x0},
	101: {region: 0x4349, code: 0x115, from: 0xf4d84, to: 0x0},
	102: {region: 0x434b, code: 0xc0, from: 0xf5eea, to: 0x0},
	103: {region: 0x434c, code: 0x41, from: 0xf6f3d, to: 0x0},
	104: {region: 0x434c, code: 0x3f, from: 0xf5021, to: 0xf6f3d},
	105: {region: 0x434c, code: 0x8040, from: 0x0, to: 0x0},
	106: {region: 0x434d, code: 0x109, from: 0xf6a81, to: 0x0},
	107: {region: 0x434e, code: 0x44, from: 0xf4261, to: 0x0},
	108: {region: 0x434e, code: 0x8043, from: 0xf7621, to: 0xf9d9f},
	109: {region: 0x434e, code: 0x8042, from: 0xfb4f3, to: 0x0},
	110: {region: 0x434f, code: 0x45, from: 0xee221, to: 0x0},
	111: {region: 0x434f, code: 0x8046, from: 0x0, to: 0x0},
	112: {region: 0x4350, code: 0x811d, from: 0x0, to: 0x0},
	113: {region: 0x4352, code: 0x47, from: 0xed15a, to: 0x0},
	114: {region: 0x4353, code: 0x48, from: 0xfa4af, to: 0xfacc3},
	115: {region: 0x4353, code: 0x5e, from: 0xfa644, to: 0xfacc3},
	116: {region: 0x4353, code: 0x121, from: 0xf9438, to: 0xfa4af},
	117: {region: 0x4355, code: 0x4b, from: 0xe8621, to: 0x0},
	118: {region: 0x4355, code: 0x4a, from: 0xf9421, to: 0x0},
	119: {region: 0x4355, code: 0xfc, from: 0xed621, to: 0xf4e21},
	120: {region: 0x4356, code: 0x4c, from: 0xef421, to: 0x0},
	121: {region: 0x4356, code: 0xcb, from: 0xeeeb6, to: 0xf6ee5},
	122: {region: 0x4357, code: 0x8, from: 0xfb54a, to: 0x0},
	123: {region: 0x4358, code: 0x13, from: 0xf5c4e, to: 0x0},
	124: {region: 0x4359, code: 0x5e, from: 0xfb021, to: 0x0},
	125: {region: 0x4359, code: 0x4d, from: 0xef52a, to: 0xfb03f},
	126: {region: 0x435a, code: 0x4e, from: 0xf9221, to: 0x0},
	127: {region: 0x435a, code: 0x49, from: 0xf42c1, to: 0xf9261},
	128: {region: 0x4444, code: 0x4f, from: 0xf38f4, to: 0xf8d42},
	129: {region: 0x4445, code: 0x5e, from: 0xf9e21, to: 0x0},
	130: {region: 0x4445, code: 0x50, from: 0xf38d4, to: 0xfa45c},
	131: {region: 0x4447, code: 0xfc, from: 0xf5b68, to: 0x0},
	132: {region: 0x444a, code: 0x51, from: 0xf72db, to: 0x0},
	133: {region: 0x444b, code: 0x52, from: 0xea2bb, to: 0x0},
	134: {region: 0x444d, code: 0x110, from: 0xf5b46, to: 0x0},
	135: {region: 0x444f, code: 0x53, from: 0xf3741, to: 0x0},
	136: {region: 0x444f, code: 0xfc, from: 0xee2d5, to: 0xf3741},
	137: {region: 0x445a, code: 0x54, from: 0xf5881, to: 0x0},
	138: {region: 0x4541, code: 0x5e, from: 0xf9e21, to: 0x0},
	139: {region: 0x4543, code: 0xfc, from: 0xfa142, to: 0x0},
	140: {region: 0x4543, code: 0x55, from: 0xeb881, to: 0xfa142},
	141: {region: 0x4543, code: 0x8056, from: 0xf92b7, to: 0xfa029},
	142: {region: 0x4545, code: 0x5e, from: 0xfb621, to: 0x0},
	143: {region: 0x4545, code: 0x57, from: 0xf90d5, to: 0xfb59f},
	144: {region: 0x4545, code: 0xe7, from: 0xf5221, to: 0xf90d4},
	145: {region: 0x4547, code: 0x58, from: 0xebb6e, to: 0x0},
	146: {region: 0x4548, code: 0x9e, from: 0xf705a, to: 0x0},
	147: {region: 0x4552, code: 0x59, from: 0xf9b68, to: 0x0},
	148: {region: 0x4552, code: 0x5d, from: 0xf92b8, to: 0xf9b68},
	149: {region: 0x4553, code: 0x5e, from: 0xf9e21, to: 0x0},
	150: {region: 0x4553, code: 0x5c, from: 0xe9953, to: 0xfa45c},
	151: {region: 0x4553, code: 0x805a, from: 0xf7421, to: 0xf7b9f},
	152: {region: 0x4553, code: 0x805b, from: 0xf6e21, to: 0xf959f},
	153: {region: 0x4554, code: 0x5d, from: 0xf712f, to: 0x0},
	154: {region: 0x4555, code: 0x5e, from: 0xf9e21, to: 0x0},
	155: {region: 0x4555, code: 0x8112, from: 0xf7621, to: 0xf9d9f},
	156: {region: 0x4649, code: 0x5e, from: 0xf9e21, to: 0x0},
	157: {region: 0x4649, code: 0x5f, from: 0xf5621, to: 0xfa45c},
	158: {region: 0x464a, code: 0x60, from: 0xf622d, to: 0x0},
	159: {region: 0x464b, code: 0x61, from: 0xeda21, to: 0x0},
	160: {region: 0x464d, code: 0xfc, from: 0xf3021, to: 0x0},
	161: {region: 0x464d, code: 0x85, from: 0xef543, to: 0xf3021},
	162: {region: 0x464f, code: 0x52, from: 0xf3821, to: 0x0},
	163: {region: 0x4652, code: 0x5e, from: 0xf9e21, to: 0x0},
	164: {region: 0x4652, code: 0x62, from: 0xf5021, to: 0xfa451},
	165: {region: 0x4741, code: 0x109, from: 0xf9221, to: 0x0},
	166: {region: 0x4742, code: 0x63, from: 0xd3cfb, to: 0x0},
	167: {region: 0x4744, code: 0x110, from: 0xf5e5b, to: 0x0},
	168: {region: 0x4745, code: 0x65, from: 0xf9737, to: 0x0},
	169: {region: 0x4745, code: 0x64, from: 0xf9285, to: 0xf9739},
	170: {region: 0x4745, code: 0xd3, from: 0xf8f99, to: 0xf92cb},
	171: {region: 0x4745, code: 0xe7, from: 0xf5221, to: 0xf8f99},
	172: {region: 0x4746, code: 0x5e, from: 0xf9e21, to: 0x0},
	173: {region: 0x4746, code: 0x62, from: 0xf5021, to: 0xfa451},
	174: {region: 0x4747, code: 0x63, from: 0xe4c21, to: 0x0},
	175: {region: 0x4748, code: 0x67, from: 0xfaee3, to: 0x0},
	176: {region: 0x4748, code: 0x66, from: 0xf7669, to: 0xfaf9f},
	177: {region: 0x4749, code: 0x68, from: 0xd6221, to: 0x0},
	178: {region: 0x474c, code: 0x52, from: 0xea2bb, to: 0x0},
	179: {region: 0x474d, code: 0x69, from: 0xf66e1, to: 0x0},
	180: {region: 0x474e, code: 0x6a, from: 0xf8426, to: 0x0},
	181: {region: 0x474e, code: 0x6b, from: 0xf6942, to: 0xf8426},
	182: {region: 0x4750, code: 0x5e, from: 0xf9e21, to: 0x0},
	183: {region: 0x4750, code: 0x62, from: 0xf5021, to: 0xfa451},
	184: {region: 0x4751, code: 0x109, from: 0xf9221, to: 0x0},
	185: {region: 0x4751, code: 0x6c, from: 0xf6ee7, to: 0xf84c1},
	186: {region: 0x4752, code: 0x5e, from: 0xfa221, to: 0x0},
	187: {region: 0x4752, code: 0x6d, from: 0xf44a1, to: 0xfa45c},
	188: {region: 0x4753, code: 0x63, from: 0xee821, to: 0x0},
	189: {region: 0x4754, code: 0x6e, from: 0xf0abb, to: 0x0},
	190: {region: 0x4755, code: 0xfc, from: 0xf3115, to: 0x0},
	191: {region: 0x4757, code: 0x115, from: 0xf9a7f, to: 0x0},
	192: {region: 0x4757, code: 0x70, from: 0xf705c, to: 0xf9a7f},
	193: {region: 0x4757, code: 0x6f, from: 0xef421, to: 0xf705c},
	194: {region: 0x4759, code: 0x71, from: 0xf5cba, to: 0x0},
	195: {region: 0x484b, code: 0x72, from: 0xece42, to: 0x0},
	196: {region: 0x484d, code: 0x13, from: 0xf5e50, to: 0x0},
	197: {region: 0x484e, code: 0x73, from: 0xf0c83, to: 0x0},
	198: {region: 0x4852, code: 0x75, from: 0xf94be, to: 0x0},
	199: {region: 0x4852, code: 0x74, from: 0xf8f97, to: 0xf9621},
	200: {region: 0x4852, code: 0x122, from: 0xf8c21, to: 0xf8f97},
	201: {region: 0x4852, code: 0x120, from: 0xf5c21, to: 0xf8c21},
	202: {region: 0x4854, code: 0x76, from: 0xea11a, to: 0x0},
	203: {region: 0x4854, code: 0xfc, from: 0xef621, to: 0x0},
	204: {region: 0x4855, code: 0x77, from: 0xf34f7, to: 0x0},
	205: {region: 0x4943, code: 0x5e, from: 0xf9e21, to: 0x0},
	206: {region: 0x4944, code: 0x78, from: 0xf5b8d, to: 0x0},
	207: {region: 0x4945, code: 0x5e, from: 0xf9e21, to: 0x0},
	208: {region: 0x4945, code: 0x79, from: 0xf0421, to: 0xfa449},
	209: {region: 0x4945, code: 0x63, from: 0xe1021, to: 0xf0421},
	210: {region: 0x494c, code: 0x7c, from: 0xf8324, to: 0x0},
	211: {region: 0x494c, code: 0x7b, from: 0xf7856, to: 0xf8324},
	212: {region: 0x494c, code: 0x7a, from: 0xf3910, to: 0xf7856},
	213: {region: 0x494d, code: 0x63, from: 0xe6023, to: 0x0},
	214: {region: 0x494e, code: 0x7d, from: 0xe5711, to: 0x0},
	215: {region: 0x494f, code: 0xfc, from: 0xf5b68, to: 0x0},
	216: {region: 0x4951, code: 0x7e, from: 0xf1693, to: 0x0},
	217: {region: 0x4951, code: 0x58, from: 0xf016b, to: 0xf1693},
	218: {region: 0x4951, code: 0x7d, from: 0xf016b, to: 0xf1693},
	219: {region: 0x4952, code: 0x7f, from: 0xf18ad, to: 0x0},
	220: {region: 0x4953, code: 0x81, from: 0xf7a21, to: 0x0},
	221: {region: 0x4953, code: 0x80, from: 0xefd81, to: 0xf7a21},
	222: {region: 0x4953, code: 0x52, from: 0xea2bb, to: 0xefd81},
	223: {region: 0x4954, code: 0x5e, from: 0xf9e21, to: 0x0},
	224: {region: 0x4954, code: 0x82, from: 0xe8d18, to: 0xfa45c},
	225: {region: 0x4a45, code: 0x63, from: 0xe5a21, to: 0x0},
	226: {region: 0x4a4d, code: 0x83, from: 0xf6328, to: 0x0},
	227: {region: 0x4a4f, code: 0x84, from: 0xf3ce1, to: 0x0},
	228: {region: 0x4a50, code: 0x85, from: 0xe9ec1, to: 0x0},
	229: {region: 0x4b45, code: 0x86, from: 0xf5d2e, to: 0x0},
	230: {region: 0x4b47, code: 0x87, from: 0xf92aa, to: 0x0},
	231: {region: 0x4b47, code: 0xd3, from: 0xf8f99, to: 0xf92aa},
	232: {region: 0x4b47, code: 0xe7, from: 0xf5221, to: 0xf8f99},
	233: {region: 0x4b48, code: 0x88, from: 0xf7874, to: 0x0},
	234: {region: 0x4b49, code: 0x13, from: 0xf5c4e, to: 0x0},
	235: {region: 0x4b4d, code: 0x89, from: 0xf6ee6, to: 0x0},
	236: {region: 0x4b4e, code: 0x110, from: 0xf5b46, to: 0x0},
	237: {region: 0x4b50, code: 0x8a, from: 0xf4e91, to: 0x0},
	238: {region: 0x4b52, code: 0x8d, from: 0xf54ca, to: 0x0},
	239: {region: 0x4b52, code: 0x8b, from: 0xf424f, to: 0xf54ca},
	240: {region: 0x4b52, code: 0x8c, from: 0xf330f, to: 0xf424f},
	241: {region: 0x4b57, code: 0x8e, from: 0xf5281, to: 0x0},
	242: {region: 0x4b59, code: 0x8f, from: 0xf6621, to: 0x0},
	243: {region: 0x4b59, code: 0x83, from: 0xf6328, to: 0xf6621},
	244: {region: 0x4b5a, code: 0x90, from: 0xf9365, to: 0x0},
	245: {region: 0x4c41, code: 0x91, from: 0xf778a, to: 0x0},
	246: {region: 0x4c42, code: 0x92, from: 0xf3842, to: 0x0},
	247: {region: 0x4c43, code: 0x110, from: 0xf5b46, to: 0x0},
	248: {region: 0x4c49, code: 0x3d, from: 0xf0241, to: 0x0},
	249: {region: 0x4c4b, code: 0x93, from: 0xf74b6, to: 0x0},
	250: {region: 0x4c52, code: 0x94, from: 0xf3021, to: 0x0},
	251: {region: 0x4c53, code: 0x125, from: 0xf524e, to: 0x0},
	252: {region: 0x4c53, code: 0x95, from: 0xf7836, to: 0x0},
	253: {region: 0x4c54, code: 0x5e, from: 0xfbe21, to: 0x0},
	254: {region: 0x4c54, code: 0x96, from: 0xf92d9, to: 0xfbd9f},
	255: {region: 0x4c54, code: 0x97, from: 0xf9141, to: 0xf92d9},
	256: {region: 0x4c54, code: 0xe7, from: 0xf5221, to: 0xf9141},
	257: {region: 0x4c55, code: 0x5e, from: 0xf9e21, to: 0x0},
	258: {region: 0x4c55, code: 0x99, from: 0xf3124, to: 0xfa45c},
	259: {region: 0x4c55, code: 0x8098, from: 0xf6421, to: 0xf8c65},
	260: {region: 0x4c55, code: 0x809a, from: 0xf6421, to: 0xf8c65},
	261: {region: 0x4c56, code: 0x5e, from: 0xfbc21, to: 0x0},
	262: {region: 0x4c56, code: 0x9b, from: 0xf92dc, to: 0xfbb9f},
	263: {region: 0x4c56, code: 0x9c, from: 0xf90a7, to: 0xf9351},
	264: {region: 0x4c56, code: 0xe7, from: 0xf5221, to: 0xf90f4},
	265: {region: 0x4c59, code: 0x9d, from: 0xf6721, to: 0x0},
	266: {region: 0x4d41, code: 0x9e, from: 0xf4f51, to: 0x0},
	267: {region: 0x4d41, code: 0x9f, from: 0xeb221, to: 0xf4f51},
	268: {region: 0x4d43, code: 0x5e, from: 0xf9e21, to: 0x0},
	269: {region: 0x4d43, code: 0x62, from: 0xf5021, to: 0xfa451},
	270: {region: 0x4d43, code: 0xa0, from: 0xf5021, to: 0xfa451},
	271: {region: 0x4d44, code: 0xa2, from: 0xf937d, to: 0x0},
	272: {region: 0x4d44, code: 0xa1, from: 0xf90c1, to: 0xf937d},
	273: {region: 0x4d45, code: 0x5e, from: 0xfa421, to: 0x0},
	274: {region: 0x4d45, code: 0x50, from: 0xf9f42, to: 0xfa4af},
	275: {region: 0x4d45, code: 0x121, from: 0xf9438, to: 0xfa4af},
	276: {region: 0x4d46, code: 0x5e, from: 0xf9e21, to: 0x0},
	277: {region: 0x4d46, code: 0x62, from: 0xf5021, to: 0xfa451},
	278: {region: 0x4d47, code: 0xa3, from: 0xf7f61, to: 0x0},
	279: {region: 0x4d47, code: 0xa4, from: 0xf56e1, to: 0xfa99f},
	280: {region: 0x4d48, code: 0xfc, from: 0xf3021, to: 0x0},
	281: {region: 0x4d4b, code: 0xa5, from: 0xf92b4, to: 0x0},
	282: {region: 0x4d4b, code: 0xa6, from: 0xf909a, to: 0xf92b4},
	283: {region: 0x4d4c, code: 0x115, from: 0xf80c1, to: 0x0},
	284: {region: 0x4d4c, code: 0xa7, from: 0xf54e2, to: 0xf811f},
	285: {region: 0x4d4c, code: 0x115, from: 0xf4d78, to: 0xf54e2},
	286: {region: 0x4d4d, code: 0xa8, from: 0xf8ad2, to: 0x0},
	287: {region: 0x4d4d, code: 0x34, from: 0xf40e1, to: 0xf8ad2},
	288: {region: 0x4d4e, code: 0xa9, from: 0xef661, to: 0x0},
	289: {region: 0x4d4f, code: 0xaa, from: 0xeda21, to: 0x0},
	290: {region: 0x4d50, code: 0xfc, from: 0xf3021, to: 0x0},
	291: {region: 0x4d51, code: 0x5e, from: 0xf9e21, to: 0x0},
	292: {region: 0x4d51, code: 0x62, from: 0xf5021, to: 0xfa451},
	293: {region: 0x4d52, code: 0xab, from: 0xf6add, to: 0x0},
	294: {region: 0x4d52, code: 0x115, from: 0xf4d7c, to: 0xf6add},
	295: {region: 0x4d53, code: 0x110, from: 0xf5e5b, to: 0x0},
	296: {region: 0x4d54, code: 0x5e, from: 0xfb021, to: 0x0},
	297: {region: 0x4d54, code: 0xac, from: 0xf60c7, to: 0xfb03f},
	298: {region: 0x4d54, code: 0xad, from: 0xef50d, to: 0xf60c7},
	299: {region: 0x4d55, code: 0xae, from: 0xf1c81, to: 0x0},
	300: {region: 0x4d56, code: 0xb0, from: 0xf7ae1, to: 0x0},
	301: {region: 0x4d57, code: 0xb1, from: 0xf664f, to: 0x0},
	302: {region: 0x4d58, code: 0xb2, from: 0xf9221, to: 0x0},
	303: {region: 0x4d58, code: 0xb3, from: 0xe3c21, to: 0xf919f},
	304: {region: 0x4d58, code: 0x80b4, from: 0x0, to: 0x0},
	305: {region: 0x4d59, code: 0xb5, from: 0xf5730, to: 0x0},
	306: {region: 0x4d5a, code: 0xb8, from: 0xface1, to: 0x0},
	307: {region: 0x4d5a, code: 0xb7, from: 0xf78d0, to: 0xfad9f},
	308: {region: 0x4d5a, code: 0xb6, from: 0xf6ed9, to: 0xf78d0},
	309: {region: 0x4e41, code: 0xb9, from: 0xf9221, to: 0x0},
	310: {region: 0x4e41, code: 0x125, from: 0xf524e, to: 0x0},
	311: {region: 0x4e43, code: 0x117, from: 0xf8221, to: 0x0},
	312: {region: 0x4e45, code: 0x115, from: 0xf4d93, to: 0x0},
	313: {region: 0x4e46, code: 0x13, from: 0xf5c4e, to: 0x0},
	314: {region: 0x4e47, code: 0xba, from: 0xf6a21, to: 0x0},
	315: {region: 0x4e49, code: 0xbc, from: 0xf8e9e, to: 0x0},
	316: {region: 0x4e49, code: 0xbb, from: 0xf884f, to: 0xf8e9e},
	317: {region: 0x4e4c, code: 0x5e, from: 0xf9e21, to: 0x0},
	318: {region: 0x4e4c, code: 0xbd, from: 0xe2a21, to: 0xfa45c},
	319: {region: 0x4e4f, code: 0xbe, from: 0xee2c7, to: 0x0},
	320: {region: 0x4e4f, code: 0xdb, from: 0xea2bb, to: 0xee2c7},
	321: {region: 0x4e50, code: 0xbf, from: 0xf1a21, to: 0x0},
	322: {region: 0x4e50, code: 0x7d, from: 0xe9c21, to: 0xf5d51},
	323: {region: 0x4e52, code: 0x13, from: 0xf5c4e, to: 0x0},
	324: {region: 0x4e55, code: 0xc0, from: 0xf5eea, to: 0x0},
	325: {region: 0x4e5a, code: 0xc0, from: 0xf5eea, to: 0x0},
	326: {region: 0x4f4d, code: 0xc1, from: 0xf696b, to: 0x0},
	327: {region: 0x5041, code: 0xc2, from: 0xedf64, to: 0x0},
	328: {region: 0x5041, code: 0xfc, from: 0xedf72, to: 0x0},
	329: {region: 0x5045, code: 0xc4, from: 0xf8ee1, to: 0x0},
	330: {region: 0x5045, code: 0xc3, from: 0xf8241, to: 0xf8ee1},
	331: {region: 0x5045, code: 0xc5, from: 0xe8e4e, to: 0xf8241},
	332: {region: 0x5046, code: 0x117, from: 0xf339a, to: 0x0},
	333: {region: 0x5047, code: 0xc6, from: 0xf6f30, to: 0x0},
	334: {region: 0x5047, code: 0x13, from: 0xf5c4e, to: 0xf6f30},
	335: {region: 0x5048, code: 0xc7, from: 0xf34e4, to: 0x0},
	336: {region: 0x504b, code: 0xc8, from: 0xf3881, to: 0x0},
	337: {region: 0x504b, code: 0x7d, from: 0xe5711, to: 0xf370f},
	338: {region: 0x504c, code: 0xc9, from: 0xf9621, to: 0x0},
	339: {region: 0x504c, code: 0xca, from: 0xf3d5c, to: 0xf959f},
	340: {region: 0x504d, code: 0x5e, from: 0xf9e21, to: 0x0},
	341: {region: 0x504d, code: 0x62, from: 0xf6995, to: 0xfa451},
	342: {region: 0x504e, code: 0xc0, from: 0xf622d, to: 0x0},
	343: {region: 0x5052, code: 0xfc, from: 0xed58a, to: 0x0},
	344: {region: 0x5052, code: 0x5c, from: 0xe1021, to: 0xed58a},
	345: {region: 0x5053, code: 0x7c, from: 0xf8324, to: 0x0},
	346: {region: 0x5053, code: 0x84, from: 0xf984c, to: 0x0},
	347: {region: 0x5053, code: 0x7a, from: 0xf5ec1, to: 0xf7856},
	348: {region: 0x5053, code: 0x84, from: 0xf3ce1, to: 0xf5ec1},
	349: {region: 0x5054, code: 0x5e, from: 0xf9e21, to: 0x0},
	350: {region: 0x5054, code: 0xcb, from: 0xeeeb6, to: 0xfa45c},
	351: {region: 0x5057, code: 0xfc, from: 0xf3021, to: 0x0},
	352: {region: 0x5059, code: 0xcc, from: 0xf2f61, to: 0x0},
	353: {region: 0x5141, code: 0xcd, from: 0xf6ab3, to: 0x0},
	354: {region: 0x5245, code: 0x5e, from: 0xf9e21, to: 0x0},
	355: {region: 0x5245, code: 0x62, from: 0xf6e21, to: 0xfa451},
	356: {region: 0x524f, code: 0xd0, from: 0xfaae1, to: 0x0},
	357: {region: 0x524f, code: 0xcf, from: 0xf403c, to: 0xfad9f},
	358: {region: 0x5253, code: 0xd1, from: 0xfad59, to: 0x0},
	359: {region: 0x5253, code: 0x48, from: 0xfa4af, to: 0xfad59},
	360: {region: 0x5253, code: 0x121, from: 0xf9438, to: 0xfa4af},
	361: {region: 0x5255, code: 0xd2, from: 0xf9e21, to: 0x0},
	362: {region: 0x5255, code: 0xd3, from: 0xf8f99, to: 0xf9d9f},
	363: {region: 0x5257, code: 0xd4, from: 0xf58b3, to: 0x0},
	364: {region: 0x5341, code: 0xd5, from: 0xf4156, to: 0x0},
	365: {region: 0x5342, code: 0xd6, from: 0xf7358, to: 0x0},
	366: {region: 0x5342, code: 0x13, from: 0xf5c4e, to: 0xf74de},
	367: {region: 0x5343, code: 0xd7, from: 0xedf61, to: 0x0},
	368: {region: 0x5344, code: 0xd9, from: 0xfae2a, to: 0x0},
	369: {region: 0x5344, code: 0xd8, from: 0xf90c8, to: 0xfaede},
	370: {region: 0x5344, code: 0xda, from: 0xf4a88, to: 0xf9cc1},
	371: {region: 0x5344, code: 0x58, from: 0xec233, to: 0xf4c21},
	372: {region: 0x5344, code: 0x63, from: 0xec233, to: 0xf4c21},
	373: {region: 0x5345, code: 0xdb, from: 0xea2bb, to: 0x0},
	374: {region: 0x5347, code: 0xdc, from: 0xf5ecc, to: 0x0},
	375: {region: 0x5347, code: 0xb5, from: 0xf5730, to: 0xf5ecc},
	376: {region: 0x5348, code: 0xdd, from: 0xefa4f, to: 0x0},
	377: {region: 0x5349, code: 0x5e, from: 0xfae21, to: 0x0},
	378: {region: 0x5349, code: 0xde, from: 0xf9147, to: 0xfae2e},
	379: {region: 0x534a, code: 0xbe, from: 0xee2c7, to: 0x0},
	380: {region: 0x534b, code: 0x5e, from: 0xfb221, to: 0x0},
	381: {region: 0x534b, code: 0xdf, from: 0xf919f, to: 0xfb221},
	382: {region: 0x534b, code: 0x49, from: 0xf42c1, to: 0xf919f},
	383: {region: 0x534c, code: 0xe0, from: 0xf5904, to: 0x0},
	384: {region: 0x534c, code: 0x63, from: 0xe217e, to: 0xf5c44},
	385: {region: 0x534d, code: 0x5e, from: 0xf9e21, to: 0x0},
	386: {region: 0x534d, code: 0x82, from: 0xe9397, to: 0xfa25c},
	387: {region: 0x534e, code: 0x115, from: 0xf4e84, to: 0x0},
	388: {region: 0x534f, code: 0xe1, from: 0xf50e1, to: 0x0},
	389: {region: 0x5352, code: 0xe2, from: 0xfa821, to: 0x0},
	390: {region: 0x5352, code: 0xe3, from: 0xf28aa, to: 0xfa79f},
	391: {region: 0x5352, code: 0xbd, from: 0xe2f74, to: 0xf28aa},
	392: {region: 0x5353, code: 0xe4, from: 0xfb6f2, to: 0x0},
	393: {region: 0x5353, code: 0xd9, from: 0xfae2a, to: 0xfb721},
	394: {region: 0x5354, code: 0xe6, from: 0xfc421, to: 0x0},
	395: {region: 0x5354, code: 0xe5, from: 0xf7328, to: 0xfc39f},
	396: {region: 0x5355, code: 0xe7, from: 0xf5221, to: 0xf8f99},
	397: {region: 0x5356, code: 0xfc, from: 0xfa221, to: 0x0},
	398: {region: 0x5356, code: 0xe8, from: 0xeff6b, to: 0xfa221},
	399: {region: 0x5358, code: 0x8, from: 0xfb54a, to: 0x0},
	400: {region: 0x5359, code: 0xe9, from: 0xf3821, to: 0x0},
	401: {region: 0x535a, code: 0xea, from: 0xf6d26, to: 0x0},
	402: {region: 0x5441, code: 0x63, from: 0xf242c, to: 0x0},
	403: {region: 0x5443, code: 0xfc, from: 0xf6328, to: 0x0},
	404: {region: 0x5444, code: 0x109, from: 0xf9221, to: 0x0},
	405: {region: 0x5446, code: 0x5e, from: 0xf9e21, to: 0x0},
	406: {region: 0x5446, code: 0x62, from: 0xf4e21, to: 0xfa451},
	407: {region: 0x5447, code: 0x115, from: 0xf4d7c, to: 0x0},
	408: {region: 0x5448, code: 0xeb, from: 0xf108f, to: 0x0},
	409: {region: 0x544a, code: 0xed, from: 0xfa15a, to: 0x0},
	410: {region: 0x544a, code: 0xec, from: 0xf96aa, to: 0xfa159},
	411: {region: 0x544a, code: 0xd3, from: 0xf8f99, to: 0xf96aa},
	412: {region: 0x544b, code: 0xc0, from: 0xf5eea, to: 0x0},
	413: {region: 0x544c, code: 0xfc, from: 0xf9f54, to: 0x0},
	414: {region: 0x544c, code: 0xf2, from: 0xf4e22, to: 0xfa4b4},
	415: {region: 0x544c, code: 0x78, from: 0xf6f87, to: 0xfa4b4},
	416: {region: 0x544d, code: 0xef, from: 0xfb221, to: 0x0},
	417: {region: 0x544d, code: 0xee, from: 0xf9361, to: 0xfb221},
	418: {region: 0x544d, code: 0xd3, from: 0xf8f99, to: 0xf9361},
	419: {region: 0x544d, code: 0xe7, from: 0xf5221, to: 0xf8f99},
	420: {region: 0x544e, code: 0xf0, from: 0xf4d61, to: 0x0},
	421: {region: 0x544f, code: 0xf1, from: 0xf5c4e, to: 0x0},
	422: {region: 0x5450, code: 0xf2, from: 0xf4e22, to: 0xfa4b4},
	423: {region: 0x5450, code: 0x78, from: 0xf6f87, to: 0xfa4b4},
	424: {region: 0x5452, code: 0xf4, from: 0xfaa21, to: 0x0},
	425: {region: 0x5452, code: 0xf3, from: 0xf0561, to: 0xfab9f},
	426: {region: 0x5454, code: 0xf5, from: 0xf5821, to: 0x0},
	427: {region: 0x5456, code: 0x13, from: 0xf5c4e, to: 0x0},
	428: {region: 0x5457, code: 0xf6, from: 0xf3acf, to: 0x0},
	429: {region: 0x545a, code: 0xf7, from: 0xf5cce, to: 0x0},
	430: {region: 0x5541, code: 0xf8, from: 0xf9922, to: 0x0},
	431: {region: 0x5541, code: 0xf9, from: 0xf916d, to: 0xf9351},
	432: {region: 0x5541, code: 0xd3, from: 0xf8f99, to: 0xf916d},
	433: {region: 0x5541, code: 0xe7, from: 0xf5221, to: 0xf8f99},
	434: {region: 0x5547, code: 0xfb, from: 0xf86af, to: 0x0},
	435: {region: 0x5547, code: 0xfa, from: 0xf5d0f, to: 0xf86af},
	436: {region: 0x554d, code: 0xfc, from: 0xf3021, to: 0x0},
	437: {region: 0x5553, code: 0xfc, from: 0xe0021, to: 0x0},
	438: {region: 0x5553, code: 0x80fd, from: 0x0, to: 0x0},
	439: {region: 0x5553, code: 0x80fe, from: 0x0, to: 0xfbc61},
	440: {region: 0x5559, code: 0x101, from: 0xf9261, to: 0x0},
	441: {region: 0x5559, code: 0x100, from: 0xf6ee1, to: 0xf9261},
	442: {region: 0x5559, code: 0x80ff, from: 0x0, to: 0x0},
	443: {region: 0x555a, code: 0x102, from: 0xf94e1, to: 0x0},
	444: {region: 0x5641, code: 0x5e, from: 0xf9e21, to: 0x0},
	445: {region: 0x5641, code: 0x82, from: 0xe9d53, to: 0xfa45c},
	446: {region: 0x5643, code: 0x110, from: 0xf5b46, to: 0x0},
	447: {region: 0x5645, code: 0x104, from: 0xfb021, to: 0x0},
	448: {region: 0x5645, code: 0x103, from: 0xe9eab, to: 0xfb0de},
	449: {region: 0x5647, code: 0xfc, from: 0xe5221, to: 0x0},
	450: {region: 0x5647, code: 0x63, from: 0xe5221, to: 0xf4e21},
	451: {region: 0x5649, code: 0xfc, from: 0xe5a21, to: 0x0},
	452: {region: 0x564e, code: 0x105, from: 0xf832e, to: 0x0},
	453: {region: 0x564e, code: 0x106, from: 0xf74a3, to: 0xf832e},
	454: {region: 0x5655, code: 0x107, from: 0xf7a21, to: 0x0},
	455: {region: 0x5746, code: 0x117, from: 0xf52fe, to: 0x0},
	456: {region: 0x5753, code: 0x108, from: 0xf5eea, to: 0x0},
	457: {region: 0x584b, code: 0x5e, from: 0xfa421, to: 0x0},
	458: {region: 0x584b, code: 0x50, from: 0xf9f21, to: 0xfa469},
	459: {region: 0x584b, code: 0x121, from: 0xf9438, to: 0xf9f3e},
	460: {region: 0x5944, code: 0x11e, from: 0xf5a81, to: 0xf9821},
	461: {region: 0x5945, code: 0x11f, from: 0xf8cb6, to: 0x0},
	462: {region: 0x5954, code: 0x5e, from: 0xf9e21, to: 0x0},
	463: {region: 0x5954, code: 0x62, from: 0xf7057, to: 0xfa451},
	464: {region: 0x5954, code: 0x89, from: 0xf6e21, to: 0xf7057},
	465: {region: 0x5955, code: 0x121, from: 0xf9438, to: 0xfa4af},
	466: {region: 0x5955, code: 0x122, from: 0xf8c21, to: 0xf90f8},
	467: {region: 0x5955, code: 0x120, from: 0xf5c21, to: 0xf8c21},
	468: {region: 0x5a41, code: 0x125, from: 0xf524e, to: 0x0},
	469: {region: 0x5a41, code: 0x8124, from: 0xf8321, to: 0xf966d},
	470: {region: 0x5a4d, code: 0x127, from: 0xfba21, to: 0x0},
	471: {region: 0x5a4d, code: 0x126, from: 0xf6030, to: 0xfba21},
	472: {region: 0x5a52, code: 0x128, from: 0xf9361, to: 0xf9cff},
	473: {region: 0x5a52, code: 0x129, from: 0xf675b, to: 0xf9361},
	474: {region: 0x5a57, code: 0xfc, from: 0xfb28c, to: 0x0},
	475: {region: 0x5a57, code: 0x12b, from: 0xfb242, to: 0xfb28c},
	476: {region: 0x5a57, code: 0x12c, from: 0xfb101, to: 0xfb242},
	477: {region: 0x5a57, code: 0x12a, from: 0xf7892, to: 0xfb101},
	478: {region: 0x5a57, code: 0xce, from: 0xf6451, to: 0xf7892},
	479: {region: 0x5a5a, code: 0x810a, from: 0x0, to: 0x0},
	480: {region: 0x5a5a, code: 0x810b, from: 0x0, to: 0x0},
	481: {region: 0x5a5a, code: 0x810c, from: 0x0, to: 0x0},
	482: {region: 0x5a5a, code: 0x810d, from: 0x0, to: 0x0},
	483: {region: 0x5a5a, code: 0x810e, from: 0x0, to: 0x0},
	484: {region: 0x5a5a, code: 0x810f, from: 0x0, to: 0x0},
	485: {region: 0x5a5a, code: 0x8111, from: 0x0, to: 0x0},
	486: {region: 0x5a5a, code: 0x8113, from: 0xf1421, to: 0xfa681},
	487: {region: 0x5a5a, code: 0x8114, from: 0x0, to: 0xfbb7e},
	488: {region: 0x5a5a, code: 0x8116, from: 0x0, to: 0x0},
	489: {region: 0x5a5a, code: 0x8118, from: 0x0, to: 0x0},
	490: {region: 0x5a5a, code: 0x8119, from: 0x0, to: 0xf9f7e},
	491: {region: 0x5a5a, code: 0x811a, from: 0x0, to: 0x0},
	492: {region: 0x5a5a, code: 0x811b, from: 0x0, to: 0x0},
	493: {region: 0x5a5a, code: 0x811c, from: 0x0, to: 0x0},
	494: {region: 0x5a5a, code: 0x811d, from: 0x0, to: 0x0},
} // Size: 5964 bytes

// symbols holds symbol data of the form <n> <str>, where n is the length of
// the symbol string str.
const symbols string = "" + // Size: 1445 bytes
	"\x00\x02Kz\x01$\x02A$\x02KM\x03৳\x02Bs\x02R$\x01P\x03р.\x03CA$\x04CN¥" +
	"\x02¥\x03₡\x03Kč\x02kr\x03E£\x03₧\x03€\x02£\x03₾\x02FG\x01Q\x03HK$\x01L" +
	"\x02kn\x02Ft\x02Rp\x03₪\x03₹\x04JP¥\x03៛\x02CF\x03₩\x03₸\x03₭\x03L£\x02R" +
	"s\x02Lt\x02Ls\x02Ar\x01K\x03₮\x03MX$\x02RM\x03₦\x02C$\x03NZ$\x03₱\x03zł" +
	"\x03₲\x03lei\x03₽\x02RF\x02Db\x03฿\x02T$\x03₺\x03NT$\x03₴\x03US$\x03₫" +
	"\x04FCFA\x03EC$\x03CFA\x04CFPF\x01R\x02ZK\x03leu\x05GH₵\x03AU$\x16የቻይና ዩ" +
	"ዋን\x06ብር\x03***\x09د.إ.\u200f\x03AR$\x03BB$\x09د.ب.\u200f\x03BM$\x03BN" +
	"$\x03BS$\x03BZ$\x03CL$\x03CO$\x03CU$\x03DO$\x09د.ج.\u200f\x09ج.م.\u200f" +
	"\x03FJ$\x04UK£\x03GY$\x09د.ع.\u200f\x06ر.إ.\x03JM$\x09د.أ.\u200f\x09د.ك." +
	"\u200f\x03KY$\x09ل.ل.\u200f\x09د.ل.\u200f\x09د.م.\u200f\x09أ.م.\u200f" +
	"\x09ر.ع.\u200f\x09ر.ق.\u200f\x09ر.س.\u200f\x03SB$\x09د.س.\u200f\x06ج.س." +
	"\x03SR$\x09ل.س.\u200f\x09د.ت.\u200f\x03TT$\x03UY$\x09ر.ي.\u200f\x03Fdj" +
	"\x03Nfk\x01S\x04GB£\x03TSh\x03₼\x03ley\x03S£\x04Bds$\x03BD$\x02B$\x02Br" +
	"\x04CUC$\x03$MN\x03RD$\x04FK£\x02G$\x04Íkr\x02J$\x03CI$\x02L$\x02N$\x07р" +
	"уб.\x03SI$\x02S$\x02$U\x05лв.\x06щ.д.\x02$A\x03$CA\x04£ E\x05£ RU\x04$ " +
	"HK\x03£L\x04$ ZN\x03$ T\x04$ SU\x04din.\x04КМ\x04Кч\x04зл\x07дин.\x04Тл" +
	"\x01F\x06лей\x03USh\x04Kčs\x03ECU\x02TK\x03kr.\x03Ksh\x03öS\x03BGK\x03BG" +
	"J\x04Cub$\x02DM\x04Fl£\x04F.G.\x02FC\x04F.Rw\x03Nu.\x05KR₩\x05TH฿\x06Δρχ" +
	"\x02Tk\x02$b\x02Kr\x02Gs\x03CFP\x03FBu\x01D\x04MOP$\x02MK\x02SR\x02Le" +
	"\x04NAf.\x01E\x02VT\x03WS$\x04SD£\x03BsF\x02p.\x03B/.\x02S/\x03Gs.\x03Bs" +
	".\x02؋\x04¥CN\x03$HK\x08ریال\x03$MX\x03$NZ\x03$EC\x02UM\x02mk\x03$AR\x03" +
	"$AU\x02FB\x03$BM\x03$BN\x03$BS\x03$BZ\x03$CL\x03$CO\x04£CY\x03£E\x03$FJ" +
	"\x04£FK\x04£GB\x04£GI\x04£IE\x04£IL\x05₤IT\x04£LB\x04£MT\x03$NA\x02$C" +
	"\x03$RH\x02FR\x03$SB\x03$SG\x03$SR\x03$TT\x03$US\x03$UY\x04FCFP\x02Kw" +
	"\x05$\u00a0AU\x05$\u00a0HK\x05$\u00a0NZ\x05$\u00a0SG\x05$\u00a0US\x02DA" +
	"\x01G\x02LS\x02DT\x06руб\x07રૂ.\x0a\u200eCN¥\u200e\x06ל״י\x09लेई\x02֏" +
	"\x03NKr\x03元\x03￥\x06レイ\x03\u200b\x06ಲೀ\x02LE\x02Kn\x06сом\x02zl\x02rb" +
	"\x03MTn\x06ден\x04кр\x03NAf\x03Afl\x0cनेरू\x06रू\x04Afl.\x02ر\x03lej\x04" +
	"Esc.\x06\u200bPTE\x04XXXX\x03ლ\x06ТМТ\x03Dkr\x03Skr\x03Nkr\x07රු.\x0fසිෆ" +
	"්එ\x03NIS\x05Lekë\x03den\x02r.\x03BR$\x03Ekr\x04EG£\x04IE£\x03Ikr\x03R" +
	"s.\x07сом.\x04AUD$\x04NZD$\x07крб.\x05soʻm\x06сўм\x03￦\x03ILS\x02P.\x03Z" +
	"ł"

type curToIndex struct {
	cur uint16
	idx uint16
}

var normalLangIndex = []uint16{ // 776 elements
	// Entry 0 - 3F
	0x0000, 0x0014, 0x0017, 0x0018, 0x0018, 0x0018, 0x0018, 0x0019,
	0x0019, 0x001d, 0x001d, 0x0034, 0x0034, 0x0034, 0x0034, 0x0035,
	0x0035, 0x0035, 0x0035, 0x0036, 0x0036, 0x0036, 0x0036, 0x0037,
	0x0037, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
	0x0038, 0x0038, 0x0039, 0x003b, 0x003b, 0x003b, 0x003b, 0x003b,
	0x003b, 0x003b, 0x003b, 0x003c, 0x003c, 0x003f, 0x003f, 0x0041,
	0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0049, 0x0049,
	0x004a, 0x004a, 0x004b, 0x004b, 0x005c, 0x005c, 0x005c, 0x005c,
	// Entry 40 - 7F
	0x005c, 0x005e, 0x005e, 0x005e, 0x005f, 0x005f, 0x0060, 0x006e,
	0x006e, 0x006e, 0x006e, 0x007f, 0x0085, 0x0085, 0x0085, 0x0085,
	0x008e, 0x008e, 0x008e, 0x008f, 0x008f, 0x0091, 0x0091, 0x0091,
	0x0092, 0x0092, 0x0093, 0x0093, 0x0094, 0x0094, 0x0095, 0x0095,
	0x0095, 0x009c, 0x009c, 0x009d, 0x009d, 0x009f, 0x009f, 0x00a3,
	0x00a3, 0x00a3, 0x00a4, 0x00a4, 0x00ac, 0x00ac, 0x00ac, 0x00ad,
	0x00ad, 0x00ad, 0x00ae, 0x00af, 0x00af, 0x00af, 0x00b4, 0x00b4,
	0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00ba, 0x00ba, 0x00bb,
	// Entry 80 - BF
	0x00bb, 0x00be, 0x00be, 0x00be, 0x00c1, 0x00c1, 0x00c1, 0x00c3,
	0x00c5, 0x00c5, 0x00c6, 0x00c7, 0x00c7, 0x00c7, 0x00dc, 0x00dd,
	0x00dd, 0x00de, 0x00df, 0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4,
	0x00e4, 0x00e5, 0x00e5, 0x00e6, 0x00e6, 0x00e6, 0x00e6, 0x00e7,
	0x00e8, 0x00e9, 0x00e9, 0x00ea, 0x00ec, 0x00ec, 0x00ec, 0x00ed,
	0x00ed, 0x00ee, 0x00f0, 0x00f1, 0x00f1, 0x00f2, 0x00f2, 0x00f2,
	0x00f2, 0x00f2, 0x00f2, 0x00f2, 0x00f2, 0x00f3, 0x00f4, 0x00f5,
	0x00f6, 0x00f7, 0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fb, 0x00fc,
	// Entry C0 - FF
	0x00fc, 0x00fd, 0x00fe, 0x00ff, 0x0100, 0x0101, 0x0102, 0x0103,
	0x0104, 0x0104, 0x0105, 0x0106, 0x0107, 0x0108, 0x0109, 0x010a,
	0x010b, 0x010b, 0x010b, 0x010c, 0x010d, 0x010e, 0x010e, 0x010f,
	0x0110, 0x0112, 0x0112, 0x0113, 0x0115, 0x0116, 0x0117, 0x0117,
	0x0118, 0x0119, 0x011a, 0x011b, 0x011c, 0x011d, 0x011d, 0x011d,
	0x011e, 0x011e, 0x011e, 0x011f, 0x0120, 0x0121, 0x0122, 0x0122,
	0x0122, 0x0122, 0x0133, 0x0138, 0x013a, 0x013b, 0x013c, 0x013d,
	0x013f, 0x0141, 0x0142, 0x0144, 0x0146, 0x0146, 0x0147, 0x0147,
	// Entry 100 - 13F
	0x0148, 0x0149, 0x014a, 0x014a, 0x014b, 0x014c, 0x014d, 0x014e,
	0x014f, 0x0150, 0x0151, 0x0152, 0x0154, 0x0156, 0x0157, 0x015c,
	0x015c, 0x015e, 0x015e, 0x015e, 0x015e, 0x0169, 0x0169, 0x0169,
	0x0169, 0x0169, 0x016a, 0x016b, 0x016b, 0x017c, 0x017c, 0x0180,
	0x0180, 0x0181, 0x0182, 0x0182, 0x01a8, 0x01a8, 0x01a8, 0x01a9,
	0x01a9, 0x01a9, 0x01ca, 0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01cb,
	0x01cb, 0x01cc, 0x01cd, 0x01cd, 0x01cd, 0x01cd, 0x01ce, 0x01ce,
	0x01ce, 0x01cf, 0x01d0, 0x01d2, 0x01d2, 0x01d2, 0x01d2, 0x01d3,
	// Entry 140 - 17F
	0x01d3, 0x01d3, 0x01d4, 0x01d5, 0x01d5, 0x01d5, 0x01d5, 0x01d5,
	0x01d5, 0x01d6, 0x01d7, 0x01d7, 0x01d8, 0x01d8, 0x01d8, 0x01d9,
	0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01e0, 0x01e0, 0x01e3,
	0x01e3, 0x01e5, 0x01e5, 0x01e9, 0x01e9, 0x01ec, 0x01ec, 0x01ec,
	0x01ec, 0x01ed, 0x01ed, 0x01ed, 0x01ee, 0x01ee, 0x01ee, 0x01ee,
	0x01ef, 0x01f0, 0x01f0, 0x01f0, 0x01f1, 0x01f1, 0x01f6, 0x01f6,
	0x01f8, 0x01f8, 0x020a, 0x020b, 0x020b, 0x0210, 0x0210, 0x0222,
	0x0222, 0x0225, 0x0225, 0x0229, 0x0229, 0x022a, 0x022a, 0x022b,
	// Entry 180 - 1BF
	0x022b, 0x022b, 0x022b, 0x0237, 0x0237, 0x023f, 0x023f, 0x023f,
	0x023f, 0x023f, 0x023f, 0x023f, 0x0242, 0x0242, 0x0242, 0x0242,
	0x0242, 0x0242, 0x0243, 0x0243, 0x0243, 0x0243, 0x024d, 0x024d,
	0x024e, 0x024e, 0x024e, 0x024f, 0x024f, 0x024f, 0x0250, 0x0250,
	0x0253, 0x0253, 0x0253, 0x0253, 0x0254, 0x0254, 0x0258, 0x0258,
	0x0258, 0x0258, 0x0259, 0x0259, 0x025a, 0x025a, 0x025d, 0x025d,
	0x025f, 0x025f, 0x0260, 0x0260, 0x0260, 0x0260, 0x0260, 0x0260,
	0x0260, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
	// Entry 1C0 - 1FF
	0x0261, 0x0261, 0x0270, 0x0270, 0x0271, 0x0271, 0x0276, 0x0276,
	0x0277, 0x0277, 0x0278, 0x0278, 0x0279, 0x027a, 0x027a, 0x027a,
	0x027a, 0x027c, 0x027c, 0x027d, 0x027d, 0x027d, 0x0290, 0x0290,
	0x0291, 0x0291, 0x0292, 0x0292, 0x0293, 0x0293, 0x0298, 0x0298,
	0x0299, 0x0299, 0x029a, 0x029b, 0x029b, 0x029c, 0x029c, 0x029d,
	0x029d, 0x029e, 0x029e, 0x029e, 0x029e, 0x02aa, 0x02aa, 0x02ad,
	0x02ad, 0x02b0, 0x02b0, 0x02b0, 0x02b2, 0x02b2, 0x02b6, 0x02b7,
	0x02b7, 0x02b8, 0x02b8, 0x02b8, 0x02b8, 0x02b8, 0x02bf, 0x02bf,
	// Entry 200 - 23F
	0x02c0, 0x02c0, 0x02c0, 0x02c1, 0x02c1, 0x02d3, 0x02d3, 0x02d3,
	0x02d3, 0x02d3, 0x02d3, 0x02d3, 0x02d3, 0x02d5, 0x02d5, 0x02d5,
	0x02db, 0x02dc, 0x02dc, 0x02dd, 0x02de, 0x02de, 0x02df, 0x02e0,
	0x02e0, 0x02e0, 0x02f3, 0x02f3, 0x02f3, 0x02f3, 0x02f3, 0x02f3,
	0x02f3, 0x02f3, 0x02f5, 0x02f5, 0x02f5, 0x02f6, 0x02f6, 0x02f7,
	0x02f7, 0x02f8, 0x02fa, 0x02fa, 0x02fc, 0x02fc, 0x02fe, 0x02ff,
	0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x030f, 0x030f, 0x030f,
	0x030f, 0x0310, 0x0310, 0x0313, 0x0314, 0x0314, 0x0314, 0x0316,
	// Entry 240 - 27F
	0x0316, 0x0316, 0x0317, 0x0318, 0x0319, 0x031a, 0x031b, 0x031b,
	0x031c, 0x031e, 0x0320, 0x0320, 0x0320, 0x0320, 0x0321, 0x0321,
	0x0332, 0x0333, 0x0333, 0x0334, 0x0334, 0x033c, 0x033e, 0x033f,
	0x0340, 0x0341, 0x0341, 0x0341, 0x0342, 0x0342, 0x0343, 0x0343,
	0x0344, 0x0344, 0x0345, 0x0345, 0x0346, 0x0346, 0x0347, 0x0347,
	0x0347, 0x034b, 0x034b, 0x034b, 0x034d, 0x034e, 0x034e, 0x034e,
	0x034e, 0x034e, 0x034e, 0x034e, 0x034e, 0x034e, 0x034e, 0x034e,
	0x034e, 0x0351, 0x0351, 0x035f, 0x035f, 0x0369, 0x0369, 0x0369,
	// Entry 280 - 2BF
	0x0369, 0x0369, 0x0369, 0x0369, 0x0369, 0x0369, 0x0369, 0x036a,
	0x036b, 0x036c, 0x036d, 0x036d, 0x036f, 0x036f, 0x0370, 0x0370,
	0x0376, 0x0376, 0x0376, 0x0376, 0x0376, 0x0376, 0x037c, 0x037c,
	0x037c, 0x037c, 0x037c, 0x037c, 0x037c, 0x037c, 0x0394, 0x0394,
	0x0394, 0x0394, 0x0397, 0x0398, 0x0398, 0x0398, 0x0399, 0x0399,
	0x039c, 0x039c, 0x039d, 0x039f, 0x03a2, 0x03a4, 0x03a4, 0x03a5,
	0x03a6, 0x03a6, 0x03a8, 0x03a8, 0x03aa, 0x03aa, 0x03ab, 0x03ac,
	0x03ac, 0x03ac, 0x03ae, 0x03ae, 0x03ae, 0x03ae, 0x03b1, 0x03b1,
	// Entry 2C0 - 2FF
	0x03b6, 0x03b6, 0x03b6, 0x03b6, 0x03b8, 0x03b8, 0x03b8, 0x03b8,
	0x03b8, 0x03b8, 0x03ba, 0x03ba, 0x03cd, 0x03cd, 0x03d0, 0x03d1,
	0x03d1, 0x03d2, 0x03d3, 0x03d3, 0x03d5, 0x03d5, 0x03d5, 0x03d5,
	0x03d6, 0x03d7, 0x03d7, 0x03d7, 0x03d7, 0x03d7, 0x03d9, 0x03d9,
	0x03d9, 0x03d9, 0x03da, 0x03da, 0x03da, 0x03dc, 0x03dc, 0x03dd,
	0x03dd, 0x03dd, 0x03de, 0x03de, 0x03de, 0x03de, 0x03de, 0x03de,
	0x03df, 0x03df, 0x03df, 0x03e2, 0x03e5, 0x03e5, 0x03e5, 0x03e5,
	0x03e5, 0x03e5, 0x03e9, 0x03e9, 0x03e9, 0x03ea, 0x03ec, 0x03ee,
	// Entry 300 - 33F
	0x03f2, 0x03f4, 0x03f5, 0x03f5, 0x03f7, 0x03f7, 0x03f7, 0x03f7,
} // Size: 1576 bytes

var normalSymIndex = []curToIndex{ // 1015 elements
	0:    {cur: 0x13, idx: 0x6},
	1:    {cur: 0x2e, idx: 0x13},
	2:    {cur: 0x3a, idx: 0x1c},
	3:    {cur: 0x44, idx: 0x20},
	4:    {cur: 0x5e, idx: 0x3b},
	5:    {cur: 0x63, idx: 0x3f},
	6:    {cur: 0x72, idx: 0x4b},
	7:    {cur: 0x7c, idx: 0x5a},
	8:    {cur: 0x7d, idx: 0x5e},
	9:    {cur: 0x85, idx: 0x62},
	10:   {cur: 0x8d, idx: 0x6e},
	11:   {cur: 0xb2, idx: 0x90},
	12:   {cur: 0xc0, idx: 0x9e},
	13:   {cur: 0xf6, idx: 0xc7},
	14:   {cur: 0xfc, idx: 0xcf},
	15:   {cur: 0x105, idx: 0xd3},
	16:   {cur: 0x109, idx: 0xd7},
	17:   {cur: 0x110, idx: 0xdc},
	18:   {cur: 0x115, idx: 0xe0},
	19:   {cur: 0x117, idx: 0xe4},
	20:   {cur: 0xb2, idx: 0x0},
	21:   {cur: 0xeb, idx: 0xbc},
	22:   {cur: 0x125, idx: 0xe9},
	23:   {cur: 0xb9, idx: 0x4},
	24:   {cur: 0x67, idx: 0xf2},
	25:   {cur: 0x13, idx: 0xf8},
	26:   {cur: 0x42, idx: 0xfc},
	27:   {cur: 0x5d, idx: 0x113},
	28:   {cur: 0xeb, idx: 0xbc},
	29:   {cur: 0x0, idx: 0x11a},
	30:   {cur: 0x2, idx: 0x11e},
	31:   {cur: 0x13, idx: 0xf8},
	32:   {cur: 0x23, idx: 0x130},
	33:   {cur: 0x54, idx: 0x15a},
	34:   {cur: 0x58, idx: 0x164},
	35:   {cur: 0x7e, idx: 0x17b},
	36:   {cur: 0x7f, idx: 0x185},
	37:   {cur: 0x84, idx: 0x190},
	38:   {cur: 0x8e, idx: 0x19a},
	39:   {cur: 0x92, idx: 0x1a8},
	40:   {cur: 0x9d, idx: 0x1b2},
	41:   {cur: 0x9e, idx: 0x1bc},
	42:   {cur: 0xab, idx: 0x1c6},
	43:   {cur: 0xc1, idx: 0x1d0},
	44:   {cur: 0xcd, idx: 0x1da},
	45:   {cur: 0xd5, idx: 0x1e4},
	46:   {cur: 0xd8, idx: 0x1f2},
	47:   {cur: 0xd9, idx: 0x1fc},
	48:   {cur: 0xe9, idx: 0x207},
	49:   {cur: 0xeb, idx: 0xbc},
	50:   {cur: 0xf0, idx: 0x211},
	51:   {cur: 0x11f, idx: 0x223},
	52:   {cur: 0x51, idx: 0x22d},
	53:   {cur: 0x59, idx: 0x231},
	54:   {cur: 0x89, idx: 0x6b},
	55:   {cur: 0xd9, idx: 0x0},
	56:   {cur: 0xe1, idx: 0x235},
	57:   {cur: 0x63, idx: 0x237},
	58:   {cur: 0xe4, idx: 0x3f},
	59:   {cur: 0xf7, idx: 0x23c},
	60:   {cur: 0x85, idx: 0x25},
	61:   {cur: 0xeb, idx: 0xbc},
	62:   {cur: 0xfc, idx: 0x4},
	63:   {cur: 0x16, idx: 0x240},
	64:   {cur: 0xeb, idx: 0xbc},
	65:   {cur: 0x16, idx: 0x240},
	66:   {cur: 0x2e, idx: 0x0},
	67:   {cur: 0x37, idx: 0x258},
	68:   {cur: 0x3a, idx: 0x0},
	69:   {cur: 0x85, idx: 0x25},
	70:   {cur: 0xc0, idx: 0x0},
	71:   {cur: 0xd2, idx: 0xb2},
	72:   {cur: 0xfc, idx: 0x4},
	73:   {cur: 0x127, idx: 0x8a},
	74:   {cur: 0xf7, idx: 0x23c},
	75:   {cur: 0x13, idx: 0x0},
	76:   {cur: 0x21, idx: 0x294},
	77:   {cur: 0x2e, idx: 0x0},
	78:   {cur: 0x3a, idx: 0x0},
	79:   {cur: 0x44, idx: 0x0},
	80:   {cur: 0x63, idx: 0x0},
	81:   {cur: 0x72, idx: 0x0},
	82:   {cur: 0x7c, idx: 0x0},
	83:   {cur: 0x7d, idx: 0x0},
	84:   {cur: 0x85, idx: 0x0},
	85:   {cur: 0x8d, idx: 0x0},
	86:   {cur: 0xb2, idx: 0x0},
	87:   {cur: 0xc0, idx: 0x0},
	88:   {cur: 0xf6, idx: 0x0},
	89:   {cur: 0xfc, idx: 0x29a},
	90:   {cur: 0x105, idx: 0x0},
	91:   {cur: 0x110, idx: 0x0},
	92:   {cur: 0x1b, idx: 0xc},
	93:   {cur: 0xeb, idx: 0xbc},
	94:   {cur: 0x44, idx: 0x25},
	95:   {cur: 0x44, idx: 0x20},
	96:   {cur: 0x13, idx: 0x2a1},
	97:   {cur: 0x2e, idx: 0x0},
	98:   {cur: 0x3a, idx: 0x2a4},
	99:   {cur: 0x44, idx: 0x0},
	100:  {cur: 0x63, idx: 0x2ad},
	101:  {cur: 0x72, idx: 0x2b3},
	102:  {cur: 0x7c, idx: 0x0},
	103:  {cur: 0x85, idx: 0x0},
	104:  {cur: 0x8d, idx: 0x0},
	105:  {cur: 0xc0, idx: 0x2bc},
	106:  {cur: 0xf6, idx: 0x0},
	107:  {cur: 0xfc, idx: 0x2c5},
	108:  {cur: 0x105, idx: 0x0},
	109:  {cur: 0x110, idx: 0x0},
	110:  {cur: 0x13, idx: 0x0},
	111:  {cur: 0x18, idx: 0x9},
	112:  {cur: 0x2e, idx: 0x0},
	113:  {cur: 0x3a, idx: 0x0},
	114:  {cur: 0x44, idx: 0x0},
	115:  {cur: 0x63, idx: 0x0},
	116:  {cur: 0x72, idx: 0x0},
	117:  {cur: 0x75, idx: 0x51},
	118:  {cur: 0x7c, idx: 0x0},
	119:  {cur: 0x85, idx: 0x25},
	120:  {cur: 0xb2, idx: 0x0},
	121:  {cur: 0xc0, idx: 0x0},
	122:  {cur: 0xd1, idx: 0x2ca},
	123:  {cur: 0xeb, idx: 0xbc},
	124:  {cur: 0xfc, idx: 0x0},
	125:  {cur: 0x110, idx: 0x0},
	126:  {cur: 0x117, idx: 0x0},
	127:  {cur: 0x18, idx: 0x2cf},
	128:  {cur: 0x4e, idx: 0x2d4},
	129:  {cur: 0x85, idx: 0x25},
	130:  {cur: 0xc9, idx: 0x2d9},
	131:  {cur: 0xd1, idx: 0x2de},
	132:  {cur: 0xf4, idx: 0x2e6},
	133:  {cur: 0x13, idx: 0xf8},
	134:  {cur: 0x2e, idx: 0x0},
	135:  {cur: 0x3a, idx: 0x0},
	136:  {cur: 0x44, idx: 0x25},
	137:  {cur: 0x5c, idx: 0x37},
	138:  {cur: 0xb2, idx: 0x0},
	139:  {cur: 0xeb, idx: 0xbc},
	140:  {cur: 0xfc, idx: 0x0},
	141:  {cur: 0x110, idx: 0x0},
	142:  {cur: 0x62, idx: 0x2eb},
	143:  {cur: 0x1b, idx: 0xc},
	144:  {cur: 0xeb, idx: 0xbc},
	145:  {cur: 0xd2, idx: 0xb2},
	146:  {cur: 0xfb, idx: 0x2f4},
	147:  {cur: 0xfc, idx: 0x4},
	148:  {cur: 0x7e, idx: 0x17b},
	149:  {cur: 0x13, idx: 0xf8},
	150:  {cur: 0x49, idx: 0x2f8},
	151:  {cur: 0x4e, idx: 0x2c},
	152:  {cur: 0x7c, idx: 0x0},
	153:  {cur: 0x7d, idx: 0x0},
	154:  {cur: 0x105, idx: 0x0},
	155:  {cur: 0x112, idx: 0x2fd},
	156:  {cur: 0xd2, idx: 0xb2},
	157:  {cur: 0x8d, idx: 0x0},
	158:  {cur: 0xeb, idx: 0xbc},
	159:  {cur: 0x13, idx: 0xf8},
	160:  {cur: 0x52, idx: 0x304},
	161:  {cur: 0xeb, idx: 0xbc},
	162:  {cur: 0xfc, idx: 0x4},
	163:  {cur: 0x86, idx: 0x308},
	164:  {cur: 0x12, idx: 0x30c},
	165:  {cur: 0x13, idx: 0xf8},
	166:  {cur: 0x20, idx: 0x310},
	167:  {cur: 0x22, idx: 0x314},
	168:  {cur: 0x50, idx: 0x31d},
	169:  {cur: 0x85, idx: 0x25},
	170:  {cur: 0xeb, idx: 0xbc},
	171:  {cur: 0xfc, idx: 0x4},
	172:  {cur: 0x5e, idx: 0x0},
	173:  {cur: 0x5e, idx: 0x0},
	174:  {cur: 0x99, idx: 0x2eb},
	175:  {cur: 0x13, idx: 0x0},
	176:  {cur: 0x85, idx: 0x25},
	177:  {cur: 0xc9, idx: 0xa6},
	178:  {cur: 0xeb, idx: 0xbc},
	179:  {cur: 0xfc, idx: 0x4},
	180:  {cur: 0x13, idx: 0xf8},
	181:  {cur: 0x33, idx: 0x332},
	182:  {cur: 0x7c, idx: 0x0},
	183:  {cur: 0x8d, idx: 0x336},
	184:  {cur: 0xeb, idx: 0x33c},
	185:  {cur: 0x109, idx: 0x0},
	186:  {cur: 0x86, idx: 0x308},
	187:  {cur: 0x13, idx: 0xf8},
	188:  {cur: 0x67, idx: 0xf2},
	189:  {cur: 0xeb, idx: 0xbc},
	190:  {cur: 0x6d, idx: 0x342},
	191:  {cur: 0xeb, idx: 0xbc},
	192:  {cur: 0xfc, idx: 0x4},
	193:  {cur: 0x85, idx: 0x25},
	194:  {cur: 0xfc, idx: 0x4},
	195:  {cur: 0x85, idx: 0x62},
	196:  {cur: 0xfc, idx: 0xcf},
	197:  {cur: 0x110, idx: 0x4},
	198:  {cur: 0x110, idx: 0x4},
	199:  {cur: 0x13, idx: 0x4},
	200:  {cur: 0x2e, idx: 0x0},
	201:  {cur: 0x3a, idx: 0x0},
	202:  {cur: 0x44, idx: 0x0},
	203:  {cur: 0x5e, idx: 0x0},
	204:  {cur: 0x63, idx: 0x0},
	205:  {cur: 0x72, idx: 0x0},
	206:  {cur: 0x7c, idx: 0x0},
	207:  {cur: 0x7d, idx: 0x0},
	208:  {cur: 0x85, idx: 0x0},
	209:  {cur: 0x8d, idx: 0x0},
	210:  {cur: 0xb2, idx: 0x0},
	211:  {cur: 0xc0, idx: 0x0},
	212:  {cur: 0xd7, idx: 0x7e},
	213:  {cur: 0xf6, idx: 0x0},
	214:  {cur: 0xfc, idx: 0x0},
	215:  {cur: 0x105, idx: 0x0},
	216:  {cur: 0x109, idx: 0x0},
	217:  {cur: 0x110, idx: 0x0},
	218:  {cur: 0x115, idx: 0x0},
	219:  {cur: 0x117, idx: 0x355},
	220:  {cur: 0x1a, idx: 0x4},
	221:  {cur: 0x24, idx: 0x359},
	222:  {cur: 0x25, idx: 0x4},
	223:  {cur: 0x32, idx: 0x4},
	224:  {cur: 0x35, idx: 0x16},
	225:  {cur: 0x39, idx: 0x4},
	226:  {cur: 0x3a, idx: 0x4},
	227:  {cur: 0x13, idx: 0x4},
	228:  {cur: 0xc0, idx: 0x4},
	229:  {cur: 0x13, idx: 0x4},
	230:  {cur: 0x52, idx: 0x304},
	231:  {cur: 0x110, idx: 0x4},
	232:  {cur: 0x59, idx: 0x231},
	233:  {cur: 0x60, idx: 0x4},
	234:  {cur: 0x61, idx: 0x3f},
	235:  {cur: 0x63, idx: 0x237},
	236:  {cur: 0x110, idx: 0x4},
	237:  {cur: 0x67, idx: 0xf2},
	238:  {cur: 0x63, idx: 0x237},
	239:  {cur: 0x68, idx: 0x3f},
	240:  {cur: 0x69, idx: 0x35d},
	241:  {cur: 0x71, idx: 0x4},
	242:  {cur: 0x83, idx: 0x4},
	243:  {cur: 0x86, idx: 0x308},
	244:  {cur: 0x13, idx: 0x4},
	245:  {cur: 0x110, idx: 0x4},
	246:  {cur: 0x8f, idx: 0x4},
	247:  {cur: 0x110, idx: 0x4},
	248:  {cur: 0x94, idx: 0x4},
	249:  {cur: 0x125, idx: 0xe9},
	250:  {cur: 0xa3, idx: 0x87},
	251:  {cur: 0xaa, idx: 0x35f},
	252:  {cur: 0x110, idx: 0x4},
	253:  {cur: 0x63, idx: 0x237},
	254:  {cur: 0xae, idx: 0x7e},
	255:  {cur: 0xb1, idx: 0x364},
	256:  {cur: 0xb5, idx: 0x94},
	257:  {cur: 0xb9, idx: 0x4},
	258:  {cur: 0x13, idx: 0x4},
	259:  {cur: 0xba, idx: 0x97},
	260:  {cur: 0x13, idx: 0x4},
	261:  {cur: 0xc0, idx: 0x4},
	262:  {cur: 0xc0, idx: 0x4},
	263:  {cur: 0xc6, idx: 0x8a},
	264:  {cur: 0xc7, idx: 0xa2},
	265:  {cur: 0xc8, idx: 0x7e},
	266:  {cur: 0xc0, idx: 0x4},
	267:  {cur: 0xd4, idx: 0xb6},
	268:  {cur: 0xd6, idx: 0x4},
	269:  {cur: 0xd7, idx: 0x367},
	270:  {cur: 0xdb, idx: 0x30},
	271:  {cur: 0xdc, idx: 0x4},
	272:  {cur: 0x63, idx: 0x237},
	273:  {cur: 0xdd, idx: 0x3f},
	274:  {cur: 0xe0, idx: 0x36a},
	275:  {cur: 0x63, idx: 0x237},
	276:  {cur: 0xe4, idx: 0x3f},
	277:  {cur: 0x8, idx: 0x36d},
	278:  {cur: 0xea, idx: 0x372},
	279:  {cur: 0xc0, idx: 0x4},
	280:  {cur: 0xf1, idx: 0xc0},
	281:  {cur: 0xf5, idx: 0x4},
	282:  {cur: 0x13, idx: 0x4},
	283:  {cur: 0xf7, idx: 0x23c},
	284:  {cur: 0xfb, idx: 0x2f4},
	285:  {cur: 0x110, idx: 0x4},
	286:  {cur: 0x107, idx: 0x374},
	287:  {cur: 0x108, idx: 0x377},
	288:  {cur: 0x125, idx: 0xe9},
	289:  {cur: 0x127, idx: 0x8a},
	290:  {cur: 0x13, idx: 0x0},
	291:  {cur: 0x2e, idx: 0x0},
	292:  {cur: 0x44, idx: 0x0},
	293:  {cur: 0x5c, idx: 0x37},
	294:  {cur: 0x63, idx: 0x0},
	295:  {cur: 0x72, idx: 0x0},
	296:  {cur: 0x7c, idx: 0x0},
	297:  {cur: 0x7d, idx: 0x0},
	298:  {cur: 0x85, idx: 0x0},
	299:  {cur: 0x8d, idx: 0x0},
	300:  {cur: 0xb2, idx: 0x0},
	301:  {cur: 0xc0, idx: 0x0},
	302:  {cur: 0xeb, idx: 0xbc},
	303:  {cur: 0xf6, idx: 0x0},
	304:  {cur: 0x109, idx: 0x0},
	305:  {cur: 0x110, idx: 0x0},
	306:  {cur: 0x115, idx: 0x0},
	307:  {cur: 0x3a, idx: 0x0},
	308:  {cur: 0x5e, idx: 0x0},
	309:  {cur: 0xeb, idx: 0x0},
	310:  {cur: 0xfc, idx: 0x0},
	311:  {cur: 0x105, idx: 0x0},
	312:  {cur: 0x11, idx: 0x4},
	313:  {cur: 0xfc, idx: 0xcf},
	314:  {cur: 0x27, idx: 0x10},
	315:  {cur: 0x2e, idx: 0x13},
	316:  {cur: 0x39, idx: 0x4},
	317:  {cur: 0x41, idx: 0x4},
	318:  {cur: 0xfc, idx: 0xcf},
	319:  {cur: 0x45, idx: 0x4},
	320:  {cur: 0xfc, idx: 0xcf},
	321:  {cur: 0x47, idx: 0x28},
	322:  {cur: 0x4b, idx: 0x4},
	323:  {cur: 0xfc, idx: 0xcf},
	324:  {cur: 0x53, idx: 0x264},
	325:  {cur: 0xfc, idx: 0xcf},
	326:  {cur: 0xfc, idx: 0x4},
	327:  {cur: 0x109, idx: 0xd7},
	328:  {cur: 0x6e, idx: 0x49},
	329:  {cur: 0x73, idx: 0x4f},
	330:  {cur: 0xb2, idx: 0x4},
	331:  {cur: 0xbc, idx: 0x9b},
	332:  {cur: 0xc2, idx: 0x387},
	333:  {cur: 0xc4, idx: 0x38b},
	334:  {cur: 0xc7, idx: 0xa2},
	335:  {cur: 0xfc, idx: 0x4},
	336:  {cur: 0xcc, idx: 0x38e},
	337:  {cur: 0xfc, idx: 0x4},
	338:  {cur: 0x85, idx: 0x25},
	339:  {cur: 0xfc, idx: 0x4},
	340:  {cur: 0xfc, idx: 0xcf},
	341:  {cur: 0x101, idx: 0x4},
	342:  {cur: 0x104, idx: 0x392},
	343:  {cur: 0x13, idx: 0xf8},
	344:  {cur: 0x57, idx: 0x30},
	345:  {cur: 0x85, idx: 0x25},
	346:  {cur: 0xeb, idx: 0xbc},
	347:  {cur: 0xfc, idx: 0x4},
	348:  {cur: 0x5c, idx: 0x37},
	349:  {cur: 0xeb, idx: 0xbc},
	350:  {cur: 0x4, idx: 0x396},
	351:  {cur: 0x3a, idx: 0x2a4},
	352:  {cur: 0x44, idx: 0x399},
	353:  {cur: 0x72, idx: 0x39e},
	354:  {cur: 0x7f, idx: 0x3a2},
	355:  {cur: 0x85, idx: 0x25},
	356:  {cur: 0xb2, idx: 0x3ab},
	357:  {cur: 0xc0, idx: 0x3af},
	358:  {cur: 0xeb, idx: 0xbc},
	359:  {cur: 0xfc, idx: 0x4},
	360:  {cur: 0x110, idx: 0x3b3},
	361:  {cur: 0x6a, idx: 0x46},
	362:  {cur: 0xab, idx: 0x3b7},
	363:  {cur: 0x13, idx: 0x0},
	364:  {cur: 0x2e, idx: 0x0},
	365:  {cur: 0x3a, idx: 0x0},
	366:  {cur: 0x44, idx: 0x0},
	367:  {cur: 0x5f, idx: 0x3ba},
	368:  {cur: 0x72, idx: 0x0},
	369:  {cur: 0x7c, idx: 0x0},
	370:  {cur: 0x7d, idx: 0x0},
	371:  {cur: 0x85, idx: 0x25},
	372:  {cur: 0x8d, idx: 0x0},
	373:  {cur: 0xb2, idx: 0x0},
	374:  {cur: 0xc0, idx: 0x0},
	375:  {cur: 0xf6, idx: 0x0},
	376:  {cur: 0xfc, idx: 0x4},
	377:  {cur: 0x105, idx: 0x0},
	378:  {cur: 0x110, idx: 0x0},
	379:  {cur: 0x117, idx: 0x0},
	380:  {cur: 0x85, idx: 0x25},
	381:  {cur: 0xc7, idx: 0xa2},
	382:  {cur: 0xeb, idx: 0xbc},
	383:  {cur: 0xfc, idx: 0x4},
	384:  {cur: 0x52, idx: 0x30},
	385:  {cur: 0x52, idx: 0x304},
	386:  {cur: 0x11, idx: 0x3bd},
	387:  {cur: 0x13, idx: 0x3c1},
	388:  {cur: 0x1d, idx: 0x3c5},
	389:  {cur: 0x25, idx: 0x3c8},
	390:  {cur: 0x26, idx: 0x3cc},
	391:  {cur: 0x32, idx: 0x3d0},
	392:  {cur: 0x39, idx: 0x3d4},
	393:  {cur: 0x3a, idx: 0x2a4},
	394:  {cur: 0x41, idx: 0x3d8},
	395:  {cur: 0x44, idx: 0x0},
	396:  {cur: 0x45, idx: 0x3dc},
	397:  {cur: 0x4d, idx: 0x3e0},
	398:  {cur: 0x60, idx: 0x3e9},
	399:  {cur: 0x61, idx: 0x3ed},
	400:  {cur: 0x62, idx: 0x2eb},
	401:  {cur: 0x63, idx: 0x3f2},
	402:  {cur: 0x68, idx: 0x3f7},
	403:  {cur: 0x72, idx: 0x0},
	404:  {cur: 0x79, idx: 0x3fc},
	405:  {cur: 0x7a, idx: 0x401},
	406:  {cur: 0x82, idx: 0x406},
	407:  {cur: 0x85, idx: 0x0},
	408:  {cur: 0x92, idx: 0x40c},
	409:  {cur: 0xad, idx: 0x411},
	410:  {cur: 0xb2, idx: 0x3ab},
	411:  {cur: 0xb9, idx: 0x416},
	412:  {cur: 0xc0, idx: 0x3af},
	413:  {cur: 0xce, idx: 0x41d},
	414:  {cur: 0xd6, idx: 0x424},
	415:  {cur: 0xdc, idx: 0x428},
	416:  {cur: 0xe2, idx: 0x42c},
	417:  {cur: 0xf5, idx: 0x430},
	418:  {cur: 0xf6, idx: 0x0},
	419:  {cur: 0xfc, idx: 0x434},
	420:  {cur: 0x101, idx: 0x438},
	421:  {cur: 0x108, idx: 0x377},
	422:  {cur: 0x110, idx: 0x0},
	423:  {cur: 0x117, idx: 0x43c},
	424:  {cur: 0x24, idx: 0x359},
	425:  {cur: 0x11, idx: 0x0},
	426:  {cur: 0x13, idx: 0x444},
	427:  {cur: 0x25, idx: 0x0},
	428:  {cur: 0x26, idx: 0x0},
	429:  {cur: 0x32, idx: 0x0},
	430:  {cur: 0x39, idx: 0x0},
	431:  {cur: 0x3a, idx: 0x4},
	432:  {cur: 0x41, idx: 0x0},
	433:  {cur: 0x44, idx: 0x20},
	434:  {cur: 0x45, idx: 0x0},
	435:  {cur: 0x60, idx: 0x0},
	436:  {cur: 0x61, idx: 0x0},
	437:  {cur: 0x63, idx: 0x3f},
	438:  {cur: 0x68, idx: 0x0},
	439:  {cur: 0x72, idx: 0x44a},
	440:  {cur: 0x7c, idx: 0x0},
	441:  {cur: 0x7d, idx: 0x0},
	442:  {cur: 0x85, idx: 0x25},
	443:  {cur: 0x8d, idx: 0x0},
	444:  {cur: 0x92, idx: 0x0},
	445:  {cur: 0xb2, idx: 0x0},
	446:  {cur: 0xb9, idx: 0x0},
	447:  {cur: 0xc0, idx: 0x450},
	448:  {cur: 0xd6, idx: 0x0},
	449:  {cur: 0xdc, idx: 0x456},
	450:  {cur: 0xe2, idx: 0x0},
	451:  {cur: 0xf5, idx: 0x0},
	452:  {cur: 0xfc, idx: 0x45c},
	453:  {cur: 0x101, idx: 0x0},
	454:  {cur: 0x105, idx: 0x0},
	455:  {cur: 0x109, idx: 0x0},
	456:  {cur: 0x115, idx: 0x0},
	457:  {cur: 0x117, idx: 0x0},
	458:  {cur: 0x3b, idx: 0x32a},
	459:  {cur: 0x51, idx: 0x22d},
	460:  {cur: 0x54, idx: 0x462},
	461:  {cur: 0x6a, idx: 0x46},
	462:  {cur: 0x76, idx: 0x465},
	463:  {cur: 0x89, idx: 0x6b},
	464:  {cur: 0x62, idx: 0x0},
	465:  {cur: 0x99, idx: 0x2eb},
	466:  {cur: 0xa3, idx: 0x87},
	467:  {cur: 0xab, idx: 0x3b7},
	468:  {cur: 0xae, idx: 0x7e},
	469:  {cur: 0xd4, idx: 0xb6},
	470:  {cur: 0xd7, idx: 0x367},
	471:  {cur: 0xe9, idx: 0x467},
	472:  {cur: 0xf0, idx: 0x46a},
	473:  {cur: 0x107, idx: 0x374},
	474:  {cur: 0x13, idx: 0xf8},
	475:  {cur: 0x3a, idx: 0x9b},
	476:  {cur: 0x60, idx: 0x16e},
	477:  {cur: 0xd6, idx: 0x28a},
	478:  {cur: 0xeb, idx: 0xbc},
	479:  {cur: 0x117, idx: 0x0},
	480:  {cur: 0x85, idx: 0x25},
	481:  {cur: 0xeb, idx: 0xbc},
	482:  {cur: 0xfc, idx: 0x4},
	483:  {cur: 0xeb, idx: 0xbc},
	484:  {cur: 0xfc, idx: 0x4},
	485:  {cur: 0x5c, idx: 0x37},
	486:  {cur: 0xb2, idx: 0x3ab},
	487:  {cur: 0xeb, idx: 0xbc},
	488:  {cur: 0xfc, idx: 0x4},
	489:  {cur: 0x12, idx: 0x30c},
	490:  {cur: 0x85, idx: 0x25},
	491:  {cur: 0xfc, idx: 0x4},
	492:  {cur: 0xeb, idx: 0xbc},
	493:  {cur: 0x86, idx: 0x308},
	494:  {cur: 0xba, idx: 0x97},
	495:  {cur: 0x67, idx: 0xf2},
	496:  {cur: 0xfc, idx: 0x4},
	497:  {cur: 0x44, idx: 0x47c},
	498:  {cur: 0x7a, idx: 0x487},
	499:  {cur: 0x85, idx: 0x25},
	500:  {cur: 0xeb, idx: 0xbc},
	501:  {cur: 0xfc, idx: 0x4},
	502:  {cur: 0xeb, idx: 0xbc},
	503:  {cur: 0xfc, idx: 0x4},
	504:  {cur: 0x13, idx: 0x0},
	505:  {cur: 0x2e, idx: 0x0},
	506:  {cur: 0x3a, idx: 0x0},
	507:  {cur: 0x44, idx: 0x0},
	508:  {cur: 0x5e, idx: 0x0},
	509:  {cur: 0x63, idx: 0x0},
	510:  {cur: 0x72, idx: 0x0},
	511:  {cur: 0x7c, idx: 0x0},
	512:  {cur: 0x7d, idx: 0x0},
	513:  {cur: 0x85, idx: 0x0},
	514:  {cur: 0x8d, idx: 0x0},
	515:  {cur: 0xb2, idx: 0x0},
	516:  {cur: 0xc0, idx: 0x0},
	517:  {cur: 0xf6, idx: 0x0},
	518:  {cur: 0xfc, idx: 0x0},
	519:  {cur: 0x105, idx: 0x0},
	520:  {cur: 0x110, idx: 0x0},
	521:  {cur: 0x117, idx: 0x0},
	522:  {cur: 0x18, idx: 0x9},
	523:  {cur: 0x13, idx: 0x0},
	524:  {cur: 0x85, idx: 0x25},
	525:  {cur: 0xc9, idx: 0xa6},
	526:  {cur: 0xeb, idx: 0xbc},
	527:  {cur: 0xfc, idx: 0x4},
	528:  {cur: 0x13, idx: 0x0},
	529:  {cur: 0x2e, idx: 0x0},
	530:  {cur: 0x3a, idx: 0x0},
	531:  {cur: 0x44, idx: 0x0},
	532:  {cur: 0x5e, idx: 0x0},
	533:  {cur: 0x63, idx: 0x0},
	534:  {cur: 0x72, idx: 0x0},
	535:  {cur: 0x77, idx: 0x54},
	536:  {cur: 0x7c, idx: 0x0},
	537:  {cur: 0x7d, idx: 0x0},
	538:  {cur: 0x85, idx: 0x25},
	539:  {cur: 0x8d, idx: 0x0},
	540:  {cur: 0xb2, idx: 0x0},
	541:  {cur: 0xc0, idx: 0x0},
	542:  {cur: 0xf6, idx: 0x0},
	543:  {cur: 0xfc, idx: 0x0},
	544:  {cur: 0x105, idx: 0x0},
	545:  {cur: 0x110, idx: 0x0},
	546:  {cur: 0x7, idx: 0x498},
	547:  {cur: 0xeb, idx: 0xbc},
	548:  {cur: 0xfc, idx: 0x4},
	549:  {cur: 0x13, idx: 0xf8},
	550:  {cur: 0x78, idx: 0x57},
	551:  {cur: 0x7d, idx: 0x7e},
	552:  {cur: 0xeb, idx: 0xbc},
	553:  {cur: 0xba, idx: 0x97},
	554:  {cur: 0x44, idx: 0x25},
	555:  {cur: 0x13, idx: 0x0},
	556:  {cur: 0x2e, idx: 0x0},
	557:  {cur: 0x3a, idx: 0x0},
	558:  {cur: 0x5e, idx: 0x0},
	559:  {cur: 0x63, idx: 0x0},
	560:  {cur: 0x7d, idx: 0x0},
	561:  {cur: 0x8d, idx: 0x0},
	562:  {cur: 0xb2, idx: 0x0},
	563:  {cur: 0xc0, idx: 0x0},
	564:  {cur: 0xf6, idx: 0x0},
	565:  {cur: 0xfc, idx: 0x0},
	566:  {cur: 0x105, idx: 0x0},
	567:  {cur: 0x2e, idx: 0x0},
	568:  {cur: 0x72, idx: 0x0},
	569:  {cur: 0x85, idx: 0x0},
	570:  {cur: 0x8d, idx: 0x0},
	571:  {cur: 0xb2, idx: 0x0},
	572:  {cur: 0xeb, idx: 0xbc},
	573:  {cur: 0xf6, idx: 0x0},
	574:  {cur: 0xfc, idx: 0x0},
	575:  {cur: 0x44, idx: 0x49f},
	576:  {cur: 0x85, idx: 0x4a3},
	577:  {cur: 0xfc, idx: 0x4},
	578:  {cur: 0xf7, idx: 0x23c},
	579:  {cur: 0x13, idx: 0x0},
	580:  {cur: 0x44, idx: 0x0},
	581:  {cur: 0x65, idx: 0x42},
	582:  {cur: 0x72, idx: 0x0},
	583:  {cur: 0x7c, idx: 0x0},
	584:  {cur: 0x7d, idx: 0x0},
	585:  {cur: 0x85, idx: 0x0},
	586:  {cur: 0x8d, idx: 0x0},
	587:  {cur: 0xc0, idx: 0x0},
	588:  {cur: 0x105, idx: 0x0},
	589:  {cur: 0x54, idx: 0x462},
	590:  {cur: 0x86, idx: 0x308},
	591:  {cur: 0xf7, idx: 0x23c},
	592:  {cur: 0x13, idx: 0xf8},
	593:  {cur: 0x4c, idx: 0x4ae},
	594:  {cur: 0xeb, idx: 0xbc},
	595:  {cur: 0x86, idx: 0x308},
	596:  {cur: 0x90, idx: 0x72},
	597:  {cur: 0xd2, idx: 0xb2},
	598:  {cur: 0xeb, idx: 0xbc},
	599:  {cur: 0xfc, idx: 0x4},
	600:  {cur: 0x52, idx: 0x304},
	601:  {cur: 0x86, idx: 0x308},
	602:  {cur: 0x88, idx: 0x67},
	603:  {cur: 0xeb, idx: 0xbc},
	604:  {cur: 0xfc, idx: 0x4},
	605:  {cur: 0xeb, idx: 0xbc},
	606:  {cur: 0xfc, idx: 0x4},
	607:  {cur: 0x13, idx: 0xf8},
	608:  {cur: 0xf7, idx: 0x23c},
	609:  {cur: 0x13, idx: 0x0},
	610:  {cur: 0x2e, idx: 0x0},
	611:  {cur: 0x3a, idx: 0x0},
	612:  {cur: 0x63, idx: 0x0},
	613:  {cur: 0x72, idx: 0x0},
	614:  {cur: 0x7c, idx: 0x0},
	615:  {cur: 0x7d, idx: 0x0},
	616:  {cur: 0x87, idx: 0x4bf},
	617:  {cur: 0x8d, idx: 0x0},
	618:  {cur: 0xb2, idx: 0x0},
	619:  {cur: 0xc0, idx: 0x0},
	620:  {cur: 0xeb, idx: 0xbc},
	621:  {cur: 0xf6, idx: 0x0},
	622:  {cur: 0xfc, idx: 0x0},
	623:  {cur: 0x110, idx: 0x0},
	624:  {cur: 0xf7, idx: 0x23c},
	625:  {cur: 0x12, idx: 0x30c},
	626:  {cur: 0x13, idx: 0xf8},
	627:  {cur: 0x85, idx: 0x25},
	628:  {cur: 0xeb, idx: 0xbc},
	629:  {cur: 0xfc, idx: 0x4},
	630:  {cur: 0xfb, idx: 0x2f4},
	631:  {cur: 0xfc, idx: 0x4},
	632:  {cur: 0x3b, idx: 0x32a},
	633:  {cur: 0x9, idx: 0x1},
	634:  {cur: 0x91, idx: 0x76},
	635:  {cur: 0xeb, idx: 0xbc},
	636:  {cur: 0x7e, idx: 0x17b},
	637:  {cur: 0x13, idx: 0x0},
	638:  {cur: 0x2e, idx: 0x0},
	639:  {cur: 0x3a, idx: 0x0},
	640:  {cur: 0x44, idx: 0x0},
	641:  {cur: 0x63, idx: 0x0},
	642:  {cur: 0x72, idx: 0x0},
	643:  {cur: 0x7c, idx: 0x0},
	644:  {cur: 0x7d, idx: 0x0},
	645:  {cur: 0x85, idx: 0x0},
	646:  {cur: 0x8d, idx: 0x0},
	647:  {cur: 0xb2, idx: 0x0},
	648:  {cur: 0xc0, idx: 0x0},
	649:  {cur: 0xf6, idx: 0x0},
	650:  {cur: 0xfc, idx: 0x0},
	651:  {cur: 0x105, idx: 0x0},
	652:  {cur: 0x109, idx: 0x0},
	653:  {cur: 0x110, idx: 0x0},
	654:  {cur: 0x115, idx: 0x0},
	655:  {cur: 0x117, idx: 0x0},
	656:  {cur: 0x3b, idx: 0x32a},
	657:  {cur: 0x86, idx: 0x308},
	658:  {cur: 0x86, idx: 0x308},
	659:  {cur: 0x13, idx: 0xf8},
	660:  {cur: 0x85, idx: 0x25},
	661:  {cur: 0x9b, idx: 0x84},
	662:  {cur: 0xeb, idx: 0xbc},
	663:  {cur: 0xfc, idx: 0x4},
	664:  {cur: 0x86, idx: 0x308},
	665:  {cur: 0xf7, idx: 0x23c},
	666:  {cur: 0x86, idx: 0x308},
	667:  {cur: 0xae, idx: 0x7e},
	668:  {cur: 0xa3, idx: 0x87},
	669:  {cur: 0xb8, idx: 0x4cc},
	670:  {cur: 0x13, idx: 0x0},
	671:  {cur: 0x44, idx: 0x0},
	672:  {cur: 0x63, idx: 0x0},
	673:  {cur: 0x72, idx: 0x0},
	674:  {cur: 0x7c, idx: 0x0},
	675:  {cur: 0x7d, idx: 0x0},
	676:  {cur: 0x85, idx: 0x0},
	677:  {cur: 0x8d, idx: 0x0},
	678:  {cur: 0xa5, idx: 0x4d0},
	679:  {cur: 0xc0, idx: 0x0},
	680:  {cur: 0xf6, idx: 0x0},
	681:  {cur: 0x105, idx: 0x0},
	682:  {cur: 0x85, idx: 0x25},
	683:  {cur: 0xeb, idx: 0xbc},
	684:  {cur: 0xfc, idx: 0x4},
	685:  {cur: 0xa9, idx: 0x8c},
	686:  {cur: 0xeb, idx: 0xbc},
	687:  {cur: 0xfc, idx: 0x4},
	688:  {cur: 0xeb, idx: 0xbc},
	689:  {cur: 0xfc, idx: 0x4},
	690:  {cur: 0x3a, idx: 0x0},
	691:  {cur: 0xb2, idx: 0x0},
	692:  {cur: 0xb5, idx: 0x94},
	693:  {cur: 0xfc, idx: 0x0},
	694:  {cur: 0x26, idx: 0x4},
	695:  {cur: 0xdc, idx: 0x4},
	696:  {cur: 0x8, idx: 0x4dc},
	697:  {cur: 0x14, idx: 0x4e0},
	698:  {cur: 0x76, idx: 0x465},
	699:  {cur: 0xa8, idx: 0x8a},
	700:  {cur: 0xc2, idx: 0x387},
	701:  {cur: 0xeb, idx: 0xbc},
	702:  {cur: 0xf5, idx: 0x21b},
	703:  {cur: 0xfc, idx: 0x4},
	704:  {cur: 0xb9, idx: 0x4},
	705:  {cur: 0x13, idx: 0x0},
	706:  {cur: 0x2e, idx: 0x0},
	707:  {cur: 0x3a, idx: 0x0},
	708:  {cur: 0x44, idx: 0x0},
	709:  {cur: 0x72, idx: 0x0},
	710:  {cur: 0x7c, idx: 0x0},
	711:  {cur: 0x7d, idx: 0x0},
	712:  {cur: 0x85, idx: 0x0},
	713:  {cur: 0x8d, idx: 0x0},
	714:  {cur: 0xb2, idx: 0x0},
	715:  {cur: 0xbe, idx: 0x30},
	716:  {cur: 0xc0, idx: 0x0},
	717:  {cur: 0xf6, idx: 0x0},
	718:  {cur: 0xfc, idx: 0x0},
	719:  {cur: 0x105, idx: 0x0},
	720:  {cur: 0x109, idx: 0x0},
	721:  {cur: 0x110, idx: 0x0},
	722:  {cur: 0x117, idx: 0x0},
	723:  {cur: 0xbf, idx: 0x4e4},
	724:  {cur: 0xeb, idx: 0xbc},
	725:  {cur: 0x13, idx: 0xf8},
	726:  {cur: 0x3a, idx: 0x9b},
	727:  {cur: 0x60, idx: 0x16e},
	728:  {cur: 0xd6, idx: 0x28a},
	729:  {cur: 0xeb, idx: 0xbc},
	730:  {cur: 0x117, idx: 0x0},
	731:  {cur: 0x14, idx: 0x4f8},
	732:  {cur: 0xfc, idx: 0x4},
	733:  {cur: 0x8, idx: 0x36d},
	734:  {cur: 0xe2, idx: 0x4},
	735:  {cur: 0x8, idx: 0x36d},
	736:  {cur: 0x13, idx: 0x0},
	737:  {cur: 0x2e, idx: 0x0},
	738:  {cur: 0x3a, idx: 0x0},
	739:  {cur: 0x44, idx: 0x0},
	740:  {cur: 0x63, idx: 0x0},
	741:  {cur: 0x72, idx: 0x0},
	742:  {cur: 0x7c, idx: 0x0},
	743:  {cur: 0x7d, idx: 0x0},
	744:  {cur: 0x85, idx: 0x0},
	745:  {cur: 0x8d, idx: 0x0},
	746:  {cur: 0xb2, idx: 0x0},
	747:  {cur: 0xbe, idx: 0x30},
	748:  {cur: 0xc0, idx: 0x0},
	749:  {cur: 0xf6, idx: 0x0},
	750:  {cur: 0xfc, idx: 0x0},
	751:  {cur: 0x105, idx: 0x0},
	752:  {cur: 0x109, idx: 0x0},
	753:  {cur: 0x110, idx: 0x0},
	754:  {cur: 0x117, idx: 0x0},
	755:  {cur: 0x63, idx: 0x237},
	756:  {cur: 0xe4, idx: 0x3f},
	757:  {cur: 0xfb, idx: 0x2f4},
	758:  {cur: 0x5d, idx: 0x258},
	759:  {cur: 0x86, idx: 0x308},
	760:  {cur: 0x85, idx: 0x25},
	761:  {cur: 0xfc, idx: 0x4},
	762:  {cur: 0x65, idx: 0x42},
	763:  {cur: 0xfc, idx: 0x4},
	764:  {cur: 0x65, idx: 0x0},
	765:  {cur: 0xd2, idx: 0xb2},
	766:  {cur: 0xeb, idx: 0xbc},
	767:  {cur: 0xc8, idx: 0x4fd},
	768:  {cur: 0x13, idx: 0x0},
	769:  {cur: 0x3a, idx: 0x0},
	770:  {cur: 0x44, idx: 0x0},
	771:  {cur: 0x63, idx: 0x0},
	772:  {cur: 0x72, idx: 0x0},
	773:  {cur: 0x7c, idx: 0x0},
	774:  {cur: 0x7d, idx: 0x0},
	775:  {cur: 0x85, idx: 0x0},
	776:  {cur: 0x8d, idx: 0x0},
	777:  {cur: 0xb2, idx: 0x0},
	778:  {cur: 0xc0, idx: 0x0},
	779:  {cur: 0xc9, idx: 0xa6},
	780:  {cur: 0xf6, idx: 0x0},
	781:  {cur: 0xfc, idx: 0x0},
	782:  {cur: 0x105, idx: 0x0},
	783:  {cur: 0x4, idx: 0x396},
	784:  {cur: 0x13, idx: 0xf8},
	785:  {cur: 0xcb, idx: 0x504},
	786:  {cur: 0xeb, idx: 0xbc},
	787:  {cur: 0x9, idx: 0x1},
	788:  {cur: 0x4c, idx: 0x4ae},
	789:  {cur: 0xcb, idx: 0x509},
	790:  {cur: 0x99, idx: 0x2eb},
	791:  {cur: 0xaa, idx: 0x35f},
	792:  {cur: 0xb8, idx: 0x4cc},
	793:  {cur: 0xcb, idx: 0x4ae},
	794:  {cur: 0xe5, idx: 0xb9},
	795:  {cur: 0xc4, idx: 0x38b},
	796:  {cur: 0x27, idx: 0x10},
	797:  {cur: 0xc4, idx: 0x0},
	798:  {cur: 0xc4, idx: 0x0},
	799:  {cur: 0xfc, idx: 0x4},
	800:  {cur: 0x24, idx: 0x359},
	801:  {cur: 0x13, idx: 0x0},
	802:  {cur: 0x2e, idx: 0x0},
	803:  {cur: 0x3a, idx: 0x0},
	804:  {cur: 0x44, idx: 0x0},
	805:  {cur: 0x5e, idx: 0x0},
	806:  {cur: 0x63, idx: 0x0},
	807:  {cur: 0x72, idx: 0x0},
	808:  {cur: 0x7c, idx: 0x0},
	809:  {cur: 0x7d, idx: 0x0},
	810:  {cur: 0x85, idx: 0x0},
	811:  {cur: 0x8d, idx: 0x0},
	812:  {cur: 0xb2, idx: 0x0},
	813:  {cur: 0xc0, idx: 0x0},
	814:  {cur: 0xf6, idx: 0x0},
	815:  {cur: 0xfc, idx: 0x0},
	816:  {cur: 0x105, idx: 0x0},
	817:  {cur: 0x110, idx: 0x0},
	818:  {cur: 0xa2, idx: 0x4f},
	819:  {cur: 0xf7, idx: 0x23c},
	820:  {cur: 0x0, idx: 0x510},
	821:  {cur: 0x85, idx: 0x25},
	822:  {cur: 0xd2, idx: 0xb2},
	823:  {cur: 0xd3, idx: 0x18},
	824:  {cur: 0xeb, idx: 0xbc},
	825:  {cur: 0xef, idx: 0x519},
	826:  {cur: 0xf8, idx: 0xcb},
	827:  {cur: 0xfc, idx: 0x4},
	828:  {cur: 0x37, idx: 0x258},
	829:  {cur: 0xd3, idx: 0x0},
	830:  {cur: 0x87, idx: 0x4bf},
	831:  {cur: 0x90, idx: 0x72},
	832:  {cur: 0xa2, idx: 0x4f},
	833:  {cur: 0xd4, idx: 0xb6},
	834:  {cur: 0xf7, idx: 0x23c},
	835:  {cur: 0xd2, idx: 0xb2},
	836:  {cur: 0x86, idx: 0x308},
	837:  {cur: 0xf7, idx: 0x23c},
	838:  {cur: 0xc8, idx: 0x7e},
	839:  {cur: 0x52, idx: 0x520},
	840:  {cur: 0xbe, idx: 0x30},
	841:  {cur: 0xdb, idx: 0x524},
	842:  {cur: 0xeb, idx: 0xbc},
	843:  {cur: 0xbe, idx: 0x528},
	844:  {cur: 0xdb, idx: 0x30},
	845:  {cur: 0xb8, idx: 0x4cc},
	846:  {cur: 0x93, idx: 0x52c},
	847:  {cur: 0xeb, idx: 0xbc},
	848:  {cur: 0x115, idx: 0x534},
	849:  {cur: 0x13, idx: 0x0},
	850:  {cur: 0x2e, idx: 0x0},
	851:  {cur: 0x3a, idx: 0x0},
	852:  {cur: 0x44, idx: 0x0},
	853:  {cur: 0x63, idx: 0x0},
	854:  {cur: 0x72, idx: 0x0},
	855:  {cur: 0x7c, idx: 0x544},
	856:  {cur: 0x7d, idx: 0x0},
	857:  {cur: 0x85, idx: 0x0},
	858:  {cur: 0x8d, idx: 0x0},
	859:  {cur: 0xc0, idx: 0x0},
	860:  {cur: 0xf6, idx: 0x0},
	861:  {cur: 0xfc, idx: 0x0},
	862:  {cur: 0x105, idx: 0x0},
	863:  {cur: 0x13, idx: 0x0},
	864:  {cur: 0x2e, idx: 0x0},
	865:  {cur: 0x3a, idx: 0x0},
	866:  {cur: 0x63, idx: 0x0},
	867:  {cur: 0x85, idx: 0x25},
	868:  {cur: 0xb2, idx: 0x0},
	869:  {cur: 0xc0, idx: 0x0},
	870:  {cur: 0xf6, idx: 0x0},
	871:  {cur: 0xfc, idx: 0x4},
	872:  {cur: 0x110, idx: 0x0},
	873:  {cur: 0xe1, idx: 0x235},
	874:  {cur: 0x51, idx: 0x22d},
	875:  {cur: 0x5d, idx: 0x258},
	876:  {cur: 0x86, idx: 0x308},
	877:  {cur: 0x6, idx: 0x548},
	878:  {cur: 0xeb, idx: 0xbc},
	879:  {cur: 0xa5, idx: 0x54e},
	880:  {cur: 0x13, idx: 0x0},
	881:  {cur: 0x18, idx: 0x2cf},
	882:  {cur: 0x85, idx: 0x25},
	883:  {cur: 0x8d, idx: 0x0},
	884:  {cur: 0xc0, idx: 0x0},
	885:  {cur: 0x105, idx: 0x0},
	886:  {cur: 0x13, idx: 0x0},
	887:  {cur: 0x18, idx: 0x9},
	888:  {cur: 0x85, idx: 0x25},
	889:  {cur: 0x8d, idx: 0x0},
	890:  {cur: 0xc0, idx: 0x0},
	891:  {cur: 0x105, idx: 0x0},
	892:  {cur: 0x13, idx: 0x0},
	893:  {cur: 0x1a, idx: 0x24c},
	894:  {cur: 0x25, idx: 0x13a},
	895:  {cur: 0x2e, idx: 0x555},
	896:  {cur: 0x32, idx: 0x142},
	897:  {cur: 0x39, idx: 0x146},
	898:  {cur: 0x44, idx: 0x0},
	899:  {cur: 0x52, idx: 0x520},
	900:  {cur: 0x53, idx: 0x264},
	901:  {cur: 0x57, idx: 0x559},
	902:  {cur: 0x58, idx: 0x55d},
	903:  {cur: 0x63, idx: 0x0},
	904:  {cur: 0x72, idx: 0x0},
	905:  {cur: 0x79, idx: 0x562},
	906:  {cur: 0x7d, idx: 0x0},
	907:  {cur: 0x81, idx: 0x567},
	908:  {cur: 0x83, idx: 0x18c},
	909:  {cur: 0x85, idx: 0x0},
	910:  {cur: 0x8d, idx: 0x0},
	911:  {cur: 0xbe, idx: 0x528},
	912:  {cur: 0xc0, idx: 0x0},
	913:  {cur: 0xdb, idx: 0x30},
	914:  {cur: 0xf6, idx: 0x0},
	915:  {cur: 0x105, idx: 0x0},
	916:  {cur: 0x86, idx: 0x308},
	917:  {cur: 0xeb, idx: 0xbc},
	918:  {cur: 0xf7, idx: 0x23c},
	919:  {cur: 0x3b, idx: 0x32a},
	920:  {cur: 0xfb, idx: 0x2f4},
	921:  {cur: 0x85, idx: 0x25},
	922:  {cur: 0xeb, idx: 0xbc},
	923:  {cur: 0xfc, idx: 0x4},
	924:  {cur: 0x93, idx: 0x56b},
	925:  {cur: 0xb5, idx: 0x94},
	926:  {cur: 0xdc, idx: 0x28e},
	927:  {cur: 0xb5, idx: 0x94},
	928:  {cur: 0xdc, idx: 0x4},
	929:  {cur: 0xfc, idx: 0xcf},
	930:  {cur: 0xeb, idx: 0xbc},
	931:  {cur: 0xfc, idx: 0x4},
	932:  {cur: 0xfb, idx: 0x2f4},
	933:  {cur: 0x86, idx: 0x308},
	934:  {cur: 0xed, idx: 0x56f},
	935:  {cur: 0xfc, idx: 0x4},
	936:  {cur: 0x13, idx: 0xf8},
	937:  {cur: 0x85, idx: 0x25},
	938:  {cur: 0x5d, idx: 0x258},
	939:  {cur: 0x59, idx: 0x231},
	940:  {cur: 0x5e, idx: 0x0},
	941:  {cur: 0x63, idx: 0x0},
	942:  {cur: 0x13, idx: 0x577},
	943:  {cur: 0xc0, idx: 0x57c},
	944:  {cur: 0xf1, idx: 0xc0},
	945:  {cur: 0x13, idx: 0xf8},
	946:  {cur: 0x85, idx: 0x25},
	947:  {cur: 0xeb, idx: 0xbc},
	948:  {cur: 0xf4, idx: 0xc3},
	949:  {cur: 0xfc, idx: 0x4},
	950:  {cur: 0xd2, idx: 0xb2},
	951:  {cur: 0xfc, idx: 0x4},
	952:  {cur: 0x44, idx: 0x4a3},
	953:  {cur: 0xfc, idx: 0x4},
	954:  {cur: 0x13, idx: 0x0},
	955:  {cur: 0x2e, idx: 0x0},
	956:  {cur: 0x3a, idx: 0x0},
	957:  {cur: 0x44, idx: 0x0},
	958:  {cur: 0x5e, idx: 0x0},
	959:  {cur: 0x63, idx: 0x0},
	960:  {cur: 0x72, idx: 0x0},
	961:  {cur: 0x7c, idx: 0x0},
	962:  {cur: 0x7d, idx: 0x0},
	963:  {cur: 0x85, idx: 0x25},
	964:  {cur: 0x8d, idx: 0x0},
	965:  {cur: 0xb2, idx: 0x0},
	966:  {cur: 0xc0, idx: 0x0},
	967:  {cur: 0xf6, idx: 0x0},
	968:  {cur: 0xf8, idx: 0xcb},
	969:  {cur: 0xf9, idx: 0x581},
	970:  {cur: 0xfc, idx: 0x0},
	971:  {cur: 0x105, idx: 0x0},
	972:  {cur: 0x110, idx: 0x0},
	973:  {cur: 0xc8, idx: 0x7e},
	974:  {cur: 0xeb, idx: 0xbc},
	975:  {cur: 0xfc, idx: 0x4},
	976:  {cur: 0xc8, idx: 0x0},
	977:  {cur: 0x102, idx: 0x589},
	978:  {cur: 0x4, idx: 0x396},
	979:  {cur: 0xeb, idx: 0xbc},
	980:  {cur: 0x102, idx: 0x58f},
	981:  {cur: 0x94, idx: 0x4},
	982:  {cur: 0x94, idx: 0x4},
	983:  {cur: 0x13, idx: 0xf8},
	984:  {cur: 0xeb, idx: 0xbc},
	985:  {cur: 0xf7, idx: 0x23c},
	986:  {cur: 0x85, idx: 0x25},
	987:  {cur: 0xfc, idx: 0x4},
	988:  {cur: 0xfc, idx: 0x4},
	989:  {cur: 0xfb, idx: 0x2f4},
	990:  {cur: 0xba, idx: 0x97},
	991:  {cur: 0x13, idx: 0xf8},
	992:  {cur: 0x85, idx: 0x25},
	993:  {cur: 0x8d, idx: 0x596},
	994:  {cur: 0x13, idx: 0xf8},
	995:  {cur: 0x44, idx: 0x4a3},
	996:  {cur: 0x8d, idx: 0x596},
	997:  {cur: 0x13, idx: 0xf8},
	998:  {cur: 0x44, idx: 0x4a3},
	999:  {cur: 0x7b, idx: 0x59a},
	1000: {cur: 0x8d, idx: 0x596},
	1001: {cur: 0x44, idx: 0x20},
	1002: {cur: 0x44, idx: 0x20},
	1003: {cur: 0xaa, idx: 0x35f},
	1004: {cur: 0x44, idx: 0x20},
	1005: {cur: 0xdc, idx: 0x4},
	1006: {cur: 0x13, idx: 0xf8},
	1007: {cur: 0x85, idx: 0x25},
	1008: {cur: 0x8d, idx: 0x596},
	1009: {cur: 0xf6, idx: 0x4},
	1010: {cur: 0x8d, idx: 0x6e},
	1011: {cur: 0xf6, idx: 0xc7},
	1012: {cur: 0xaa, idx: 0x35f},
	1013: {cur: 0xeb, idx: 0xbc},
	1014: {cur: 0x125, idx: 0xe9},
} // Size: 4084 bytes

var narrowLangIndex = []uint16{ // 776 elements
	// Entry 0 - 3F
	0x0000, 0x0062, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064,
	0x0064, 0x0065, 0x0065, 0x0081, 0x0081, 0x0082, 0x0082, 0x0082,
	0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
	0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
	0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
	0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x008b, 0x008b, 0x008e,
	0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x00a8, 0x00a8,
	0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
	// Entry 40 - 7F
	0x00d8, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00dc,
	0x00dc, 0x00dc, 0x00dc, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
	0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00df, 0x00df, 0x00df,
	0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
	0x00e0, 0x00e2, 0x00e2, 0x00e2, 0x00e2, 0x00e8, 0x00e8, 0x00ee,
	0x00ee, 0x00ee, 0x00ee, 0x00ee, 0x00f7, 0x00f7, 0x00f7, 0x00f8,
	0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x00f8,
	0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x00f8,
	// Entry 80 - BF
	0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x00f8,
	0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	// Entry C0 - FF
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0103, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108,
	0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108,
	// Entry 100 - 13F
	0x0108, 0x0108, 0x0108, 0x0108, 0x010d, 0x010d, 0x010d, 0x010d,
	0x010d, 0x010d, 0x010d, 0x010d, 0x0111, 0x0111, 0x0112, 0x0113,
	0x0113, 0x0114, 0x0114, 0x0114, 0x0114, 0x0114, 0x0114, 0x0114,
	0x0114, 0x0114, 0x0114, 0x0114, 0x0114, 0x0171, 0x0171, 0x0172,
	0x0172, 0x0172, 0x0172, 0x0172, 0x017a, 0x017a, 0x017a, 0x017a,
	0x017a, 0x017a, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f,
	0x017f, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f,
	0x017f, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f,
	// Entry 140 - 17F
	0x017f, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f,
	0x017f, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f,
	0x017f, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f, 0x0180,
	0x0180, 0x0182, 0x0182, 0x0185, 0x0185, 0x0185, 0x0185, 0x0185,
	0x0185, 0x0187, 0x0187, 0x0187, 0x0187, 0x0187, 0x0187, 0x0187,
	0x0187, 0x0187, 0x0187, 0x0187, 0x0187, 0x0187, 0x0188, 0x0188,
	0x018a, 0x018a, 0x018b, 0x018b, 0x018b, 0x018b, 0x018b, 0x018c,
	0x018c, 0x018d, 0x018d, 0x018e, 0x018e, 0x018e, 0x018e, 0x018e,
	// Entry 180 - 1BF
	0x018e, 0x018e, 0x018e, 0x018f, 0x018f, 0x0193, 0x0193, 0x0193,
	0x0193, 0x0193, 0x0193, 0x0193, 0x0196, 0x0196, 0x0196, 0x0196,
	0x0196, 0x0196, 0x0196, 0x0196, 0x0196, 0x0196, 0x0197, 0x0197,
	0x0197, 0x0197, 0x0197, 0x0197, 0x0197, 0x0197, 0x0197, 0x0197,
	0x0197, 0x0197, 0x0197, 0x0197, 0x0197, 0x0197, 0x0198, 0x0198,
	0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0199, 0x0199,
	0x019b, 0x019b, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
	0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
	// Entry 1C0 - 1FF
	0x019d, 0x019d, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a9, 0x01a9,
	0x01a9, 0x01a9, 0x01a9, 0x01a9, 0x01a9, 0x01a9, 0x01a9, 0x01a9,
	0x01a9, 0x01aa, 0x01aa, 0x01aa, 0x01aa, 0x01aa, 0x01b5, 0x01b5,
	0x01b5, 0x01b5, 0x01b5, 0x01b5, 0x01b5, 0x01b5, 0x01b6, 0x01b6,
	0x01b6, 0x01b6, 0x01b6, 0x01b6, 0x01b6, 0x01b6, 0x01b6, 0x01b6,
	0x01b6, 0x01b6, 0x01b6, 0x01b6, 0x01b6, 0x01b7, 0x01b7, 0x01b8,
	0x01b8, 0x01ba, 0x01ba, 0x01ba, 0x01bb, 0x01bb, 0x01bc, 0x01bc,
	0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01be, 0x01be,
	// Entry 200 - 23F
	0x01be, 0x01be, 0x01be, 0x01be, 0x01be, 0x01c0, 0x01c0, 0x01c0,
	0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x01c0, 0x01c1, 0x01c1, 0x01c1,
	0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2,
	0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2,
	0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2,
	0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c3,
	0x01c3, 0x01c3, 0x01c3, 0x01c3, 0x01c3, 0x01c5, 0x01c5, 0x01c5,
	0x01c5, 0x01c5, 0x01c5, 0x01c7, 0x01c7, 0x01c7, 0x01c7, 0x01c7,
	// Entry 240 - 27F
	0x01c7, 0x01c7, 0x01c7, 0x01c7, 0x01c7, 0x01c7, 0x01c7, 0x01c7,
	0x01c7, 0x01c7, 0x01c7, 0x01c7, 0x01c7, 0x01c7, 0x01c7, 0x01c7,
	0x01c8, 0x01c8, 0x01c8, 0x01c8, 0x01c8, 0x01cb, 0x01cc, 0x01cc,
	0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc,
	0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc,
	0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc,
	0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc,
	0x01cc, 0x01ce, 0x01ce, 0x01cf, 0x01cf, 0x01d0, 0x01d0, 0x01d0,
	// Entry 280 - 2BF
	0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0,
	0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0,
	0x01d2, 0x01d2, 0x01d2, 0x01d2, 0x01d2, 0x01d2, 0x01d5, 0x01d5,
	0x01d5, 0x01d5, 0x01d5, 0x01d5, 0x01d5, 0x01d5, 0x01d8, 0x01d8,
	0x01d8, 0x01d8, 0x01d9, 0x01d9, 0x01d9, 0x01d9, 0x01d9, 0x01d9,
	0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01db, 0x01db, 0x01db,
	0x01db, 0x01db, 0x01db, 0x01db, 0x01dc, 0x01dc, 0x01dc, 0x01dc,
	0x01dc, 0x01dc, 0x01dc, 0x01dc, 0x01dc, 0x01dc, 0x01dc, 0x01dc,
	// Entry 2C0 - 2FF
	0x01de, 0x01de, 0x01de, 0x01de, 0x01de, 0x01de, 0x01de, 0x01de,
	0x01de, 0x01de, 0x01de, 0x01de, 0x01df, 0x01df, 0x01e0, 0x01e0,
	0x01e0, 0x01e0, 0x01e0, 0x01e0, 0x01e0, 0x01e0, 0x01e0, 0x01e0,
	0x01e0, 0x01e0, 0x01e0, 0x01e0, 0x01e0, 0x01e0, 0x01e1, 0x01e1,
	0x01e1, 0x01e1, 0x01e1, 0x01e1, 0x01e1, 0x01e1, 0x01e1, 0x01e1,
	0x01e1, 0x01e1, 0x01e1, 0x01e1, 0x01e1, 0x01e1, 0x01e1, 0x01e1,
	0x01e1, 0x01e1, 0x01e1, 0x01e1, 0x01e1, 0x01e1, 0x01e1, 0x01e1,
	0x01e1, 0x01e1, 0x01e2, 0x01e2, 0x01e2, 0x01e2, 0x01e2, 0x01e2,
	// Entry 300 - 33F
	0x01e3, 0x01e3, 0x01e3, 0x01e3, 0x01eb, 0x01eb, 0x01eb, 0x01eb,
} // Size: 1576 bytes

var narrowSymIndex = []curToIndex{ // 491 elements
	0:   {cur: 0x9, idx: 0x1},
	1:   {cur: 0x11, idx: 0x4},
	2:   {cur: 0x13, idx: 0x4},
	3:   {cur: 0x18, idx: 0x9},
	4:   {cur: 0x1a, idx: 0x4},
	5:   {cur: 0x1b, idx: 0xc},
	6:   {cur: 0x25, idx: 0x4},
	7:   {cur: 0x26, idx: 0x4},
	8:   {cur: 0x27, idx: 0x10},
	9:   {cur: 0x2e, idx: 0x13},
	10:  {cur: 0x32, idx: 0x4},
	11:  {cur: 0x35, idx: 0x16},
	12:  {cur: 0x37, idx: 0x18},
	13:  {cur: 0x39, idx: 0x4},
	14:  {cur: 0x3a, idx: 0x4},
	15:  {cur: 0x41, idx: 0x4},
	16:  {cur: 0x44, idx: 0x25},
	17:  {cur: 0x45, idx: 0x4},
	18:  {cur: 0x47, idx: 0x28},
	19:  {cur: 0x4a, idx: 0x4},
	20:  {cur: 0x4b, idx: 0x4},
	21:  {cur: 0x4e, idx: 0x2c},
	22:  {cur: 0x52, idx: 0x30},
	23:  {cur: 0x53, idx: 0x4},
	24:  {cur: 0x58, idx: 0x33},
	25:  {cur: 0x5c, idx: 0x37},
	26:  {cur: 0x5e, idx: 0x3b},
	27:  {cur: 0x60, idx: 0x4},
	28:  {cur: 0x61, idx: 0x3f},
	29:  {cur: 0x63, idx: 0x3f},
	30:  {cur: 0x65, idx: 0x42},
	31:  {cur: 0x68, idx: 0x3f},
	32:  {cur: 0x6a, idx: 0x46},
	33:  {cur: 0x6e, idx: 0x49},
	34:  {cur: 0x71, idx: 0x4},
	35:  {cur: 0x72, idx: 0x4},
	36:  {cur: 0x73, idx: 0x4f},
	37:  {cur: 0x75, idx: 0x51},
	38:  {cur: 0x77, idx: 0x54},
	39:  {cur: 0x78, idx: 0x57},
	40:  {cur: 0x7c, idx: 0x5a},
	41:  {cur: 0x7d, idx: 0x5e},
	42:  {cur: 0x81, idx: 0x30},
	43:  {cur: 0x83, idx: 0x4},
	44:  {cur: 0x85, idx: 0x25},
	45:  {cur: 0x88, idx: 0x67},
	46:  {cur: 0x89, idx: 0x6b},
	47:  {cur: 0x8a, idx: 0x6e},
	48:  {cur: 0x8d, idx: 0x6e},
	49:  {cur: 0x8f, idx: 0x4},
	50:  {cur: 0x90, idx: 0x72},
	51:  {cur: 0x91, idx: 0x76},
	52:  {cur: 0x92, idx: 0x7a},
	53:  {cur: 0x93, idx: 0x7e},
	54:  {cur: 0x94, idx: 0x4},
	55:  {cur: 0x96, idx: 0x81},
	56:  {cur: 0x9b, idx: 0x84},
	57:  {cur: 0xa3, idx: 0x87},
	58:  {cur: 0xa8, idx: 0x8a},
	59:  {cur: 0xa9, idx: 0x8c},
	60:  {cur: 0xae, idx: 0x7e},
	61:  {cur: 0xb2, idx: 0x4},
	62:  {cur: 0xb5, idx: 0x94},
	63:  {cur: 0xb9, idx: 0x4},
	64:  {cur: 0xba, idx: 0x97},
	65:  {cur: 0xbc, idx: 0x9b},
	66:  {cur: 0xbe, idx: 0x30},
	67:  {cur: 0xbf, idx: 0x7e},
	68:  {cur: 0xc0, idx: 0x4},
	69:  {cur: 0xc7, idx: 0xa2},
	70:  {cur: 0xc8, idx: 0x7e},
	71:  {cur: 0xc9, idx: 0xa6},
	72:  {cur: 0xcc, idx: 0xaa},
	73:  {cur: 0xd0, idx: 0xae},
	74:  {cur: 0xd2, idx: 0xb2},
	75:  {cur: 0xd3, idx: 0x18},
	76:  {cur: 0xd4, idx: 0xb6},
	77:  {cur: 0xd6, idx: 0x4},
	78:  {cur: 0xdb, idx: 0x30},
	79:  {cur: 0xdc, idx: 0x4},
	80:  {cur: 0xdd, idx: 0x3f},
	81:  {cur: 0xe2, idx: 0x4},
	82:  {cur: 0xe4, idx: 0x3f},
	83:  {cur: 0xe5, idx: 0xb9},
	84:  {cur: 0xe9, idx: 0x3f},
	85:  {cur: 0xeb, idx: 0xbc},
	86:  {cur: 0xf1, idx: 0xc0},
	87:  {cur: 0xf4, idx: 0xc3},
	88:  {cur: 0xf5, idx: 0x4},
	89:  {cur: 0xf6, idx: 0x4},
	90:  {cur: 0xf8, idx: 0xcb},
	91:  {cur: 0xfc, idx: 0x4},
	92:  {cur: 0x101, idx: 0x4},
	93:  {cur: 0x104, idx: 0x10},
	94:  {cur: 0x105, idx: 0xd3},
	95:  {cur: 0x110, idx: 0x4},
	96:  {cur: 0x125, idx: 0xe9},
	97:  {cur: 0x127, idx: 0xeb},
	98:  {cur: 0xd0, idx: 0xee},
	99:  {cur: 0xf6, idx: 0xc7},
	100: {cur: 0xf6, idx: 0xc7},
	101: {cur: 0x11, idx: 0x128},
	102: {cur: 0x13, idx: 0xf8},
	103: {cur: 0x1a, idx: 0x12c},
	104: {cur: 0x25, idx: 0x13a},
	105: {cur: 0x26, idx: 0x13e},
	106: {cur: 0x32, idx: 0x142},
	107: {cur: 0x39, idx: 0x146},
	108: {cur: 0x3a, idx: 0x1c},
	109: {cur: 0x41, idx: 0x14a},
	110: {cur: 0x44, idx: 0x20},
	111: {cur: 0x45, idx: 0x14e},
	112: {cur: 0x4b, idx: 0x152},
	113: {cur: 0x53, idx: 0x156},
	114: {cur: 0x60, idx: 0x16e},
	115: {cur: 0x63, idx: 0x172},
	116: {cur: 0x71, idx: 0x177},
	117: {cur: 0x72, idx: 0x4b},
	118: {cur: 0x83, idx: 0x18c},
	119: {cur: 0x85, idx: 0x62},
	120: {cur: 0x8f, idx: 0x1a4},
	121: {cur: 0xb2, idx: 0x90},
	122: {cur: 0xc0, idx: 0x9e},
	123: {cur: 0xd6, idx: 0x1ee},
	124: {cur: 0xe2, idx: 0x203},
	125: {cur: 0xf5, idx: 0x21b},
	126: {cur: 0xf6, idx: 0xc7},
	127: {cur: 0xfc, idx: 0xcf},
	128: {cur: 0x101, idx: 0x21f},
	129: {cur: 0x26, idx: 0x4},
	130: {cur: 0x37, idx: 0x0},
	131: {cur: 0x52, idx: 0x0},
	132: {cur: 0x75, idx: 0x0},
	133: {cur: 0x81, idx: 0x0},
	134: {cur: 0xbe, idx: 0x0},
	135: {cur: 0xc9, idx: 0x0},
	136: {cur: 0xd3, idx: 0x0},
	137: {cur: 0xdb, idx: 0x0},
	138: {cur: 0xf6, idx: 0xc7},
	139: {cur: 0xd0, idx: 0x244},
	140: {cur: 0xe9, idx: 0x248},
	141: {cur: 0xf6, idx: 0xc7},
	142: {cur: 0x13, idx: 0x6},
	143: {cur: 0x1a, idx: 0x24c},
	144: {cur: 0x25, idx: 0x251},
	145: {cur: 0x32, idx: 0x255},
	146: {cur: 0x37, idx: 0x258},
	147: {cur: 0x39, idx: 0x146},
	148: {cur: 0x3a, idx: 0x1c},
	149: {cur: 0x4a, idx: 0x25b},
	150: {cur: 0x4b, idx: 0x260},
	151: {cur: 0x53, idx: 0x264},
	152: {cur: 0x60, idx: 0x16e},
	153: {cur: 0x61, idx: 0x268},
	154: {cur: 0x71, idx: 0x26d},
	155: {cur: 0x81, idx: 0x270},
	156: {cur: 0x83, idx: 0x275},
	157: {cur: 0x8f, idx: 0x278},
	158: {cur: 0x94, idx: 0x27c},
	159: {cur: 0xb2, idx: 0x90},
	160: {cur: 0xb9, idx: 0x27f},
	161: {cur: 0xc0, idx: 0x9e},
	162: {cur: 0xd2, idx: 0x282},
	163: {cur: 0xd6, idx: 0x28a},
	164: {cur: 0xdc, idx: 0x28e},
	165: {cur: 0xf5, idx: 0x21b},
	166: {cur: 0x101, idx: 0x291},
	167: {cur: 0x110, idx: 0xdc},
	168: {cur: 0x11, idx: 0x0},
	169: {cur: 0x13, idx: 0x0},
	170: {cur: 0x1a, idx: 0x0},
	171: {cur: 0x1b, idx: 0x0},
	172: {cur: 0x25, idx: 0x0},
	173: {cur: 0x26, idx: 0x0},
	174: {cur: 0x2e, idx: 0x0},
	175: {cur: 0x32, idx: 0x0},
	176: {cur: 0x37, idx: 0x0},
	177: {cur: 0x39, idx: 0x0},
	178: {cur: 0x3a, idx: 0x0},
	179: {cur: 0x41, idx: 0x0},
	180: {cur: 0x44, idx: 0x0},
	181: {cur: 0x45, idx: 0x0},
	182: {cur: 0x47, idx: 0x0},
	183: {cur: 0x4b, idx: 0x0},
	184: {cur: 0x53, idx: 0x0},
	185: {cur: 0x60, idx: 0x0},
	186: {cur: 0x68, idx: 0x0},
	187: {cur: 0x71, idx: 0x0},
	188: {cur: 0x72, idx: 0x0},
	189: {cur: 0x7c, idx: 0x0},
	190: {cur: 0x7d, idx: 0x0},
	191: {cur: 0x83, idx: 0x0},
	192: {cur: 0x88, idx: 0x0},
	193: {cur: 0x8d, idx: 0x0},
	194: {cur: 0x8f, idx: 0x0},
	195: {cur: 0x90, idx: 0x0},
	196: {cur: 0x91, idx: 0x0},
	197: {cur: 0x94, idx: 0x0},
	198: {cur: 0xa9, idx: 0x0},
	199: {cur: 0xb2, idx: 0x0},
	200: {cur: 0xb9, idx: 0x0},
	201: {cur: 0xba, idx: 0x0},
	202: {cur: 0xc0, idx: 0x0},
	203: {cur: 0xc7, idx: 0x0},
	204: {cur: 0xcc, idx: 0x0},
	205: {cur: 0xd0, idx: 0x0},
	206: {cur: 0xd6, idx: 0x0},
	207: {cur: 0xdc, idx: 0x0},
	208: {cur: 0xe2, idx: 0x0},
	209: {cur: 0xe4, idx: 0x0},
	210: {cur: 0xf4, idx: 0x0},
	211: {cur: 0xf5, idx: 0x0},
	212: {cur: 0xf6, idx: 0x0},
	213: {cur: 0xf8, idx: 0x0},
	214: {cur: 0x101, idx: 0x0},
	215: {cur: 0x105, idx: 0x0},
	216: {cur: 0xf6, idx: 0xc7},
	217: {cur: 0x58, idx: 0x2a8},
	218: {cur: 0x92, idx: 0x2b8},
	219: {cur: 0xf1, idx: 0x2c1},
	220: {cur: 0xf6, idx: 0xc7},
	221: {cur: 0x104, idx: 0x0},
	222: {cur: 0xf6, idx: 0xc7},
	223: {cur: 0xd0, idx: 0x2ed},
	224: {cur: 0xd0, idx: 0x4f},
	225: {cur: 0xf6, idx: 0xc7},
	226: {cur: 0x1b, idx: 0x301},
	227: {cur: 0x35, idx: 0x0},
	228: {cur: 0x72, idx: 0x4b},
	229: {cur: 0xf6, idx: 0xc7},
	230: {cur: 0x125, idx: 0x0},
	231: {cur: 0x127, idx: 0x0},
	232: {cur: 0x52, idx: 0x304},
	233: {cur: 0x81, idx: 0x304},
	234: {cur: 0xbe, idx: 0x304},
	235: {cur: 0xd0, idx: 0x4f},
	236: {cur: 0xdb, idx: 0x304},
	237: {cur: 0xf6, idx: 0xc7},
	238: {cur: 0x4a, idx: 0x318},
	239: {cur: 0x61, idx: 0x320},
	240: {cur: 0x6a, idx: 0x325},
	241: {cur: 0x89, idx: 0x32a},
	242: {cur: 0xd0, idx: 0x4f},
	243: {cur: 0xd4, idx: 0x32d},
	244: {cur: 0xe9, idx: 0x0},
	245: {cur: 0xf6, idx: 0xc7},
	246: {cur: 0x127, idx: 0x8a},
	247: {cur: 0x5e, idx: 0x0},
	248: {cur: 0x1b, idx: 0x349},
	249: {cur: 0x27, idx: 0x34c},
	250: {cur: 0x4b, idx: 0xa2},
	251: {cur: 0x58, idx: 0x3f},
	252: {cur: 0x81, idx: 0x34f},
	253: {cur: 0xcc, idx: 0x352},
	254: {cur: 0xdb, idx: 0x34f},
	255: {cur: 0x101, idx: 0x291},
	256: {cur: 0x58, idx: 0x0},
	257: {cur: 0xd0, idx: 0x4f},
	258: {cur: 0xf6, idx: 0xc7},
	259: {cur: 0x58, idx: 0x33},
	260: {cur: 0x61, idx: 0x268},
	261: {cur: 0xe4, idx: 0x37b},
	262: {cur: 0xe9, idx: 0x248},
	263: {cur: 0x104, idx: 0x380},
	264: {cur: 0x37, idx: 0x384},
	265: {cur: 0x61, idx: 0x3f},
	266: {cur: 0xd0, idx: 0xae},
	267: {cur: 0xe4, idx: 0x3f},
	268: {cur: 0xe9, idx: 0x3f},
	269: {cur: 0x61, idx: 0x3f},
	270: {cur: 0xd0, idx: 0xae},
	271: {cur: 0xe4, idx: 0x3f},
	272: {cur: 0xe9, idx: 0x3f},
	273: {cur: 0x104, idx: 0x392},
	274: {cur: 0xf6, idx: 0xc7},
	275: {cur: 0xf6, idx: 0xc7},
	276: {cur: 0x9, idx: 0x0},
	277: {cur: 0x11, idx: 0x0},
	278: {cur: 0x13, idx: 0x0},
	279: {cur: 0x18, idx: 0x0},
	280: {cur: 0x1a, idx: 0x0},
	281: {cur: 0x1b, idx: 0x0},
	282: {cur: 0x25, idx: 0x0},
	283: {cur: 0x26, idx: 0x0},
	284: {cur: 0x27, idx: 0x0},
	285: {cur: 0x2e, idx: 0x0},
	286: {cur: 0x32, idx: 0x0},
	287: {cur: 0x35, idx: 0x0},
	288: {cur: 0x37, idx: 0x0},
	289: {cur: 0x39, idx: 0x0},
	290: {cur: 0x3a, idx: 0x0},
	291: {cur: 0x41, idx: 0x0},
	292: {cur: 0x44, idx: 0x0},
	293: {cur: 0x45, idx: 0x0},
	294: {cur: 0x47, idx: 0x0},
	295: {cur: 0x4a, idx: 0x0},
	296: {cur: 0x4b, idx: 0x0},
	297: {cur: 0x4e, idx: 0x0},
	298: {cur: 0x52, idx: 0x0},
	299: {cur: 0x53, idx: 0x0},
	300: {cur: 0x58, idx: 0x0},
	301: {cur: 0x5c, idx: 0x0},
	302: {cur: 0x60, idx: 0x0},
	303: {cur: 0x61, idx: 0x0},
	304: {cur: 0x65, idx: 0x0},
	305: {cur: 0x68, idx: 0x0},
	306: {cur: 0x6a, idx: 0x0},
	307: {cur: 0x6e, idx: 0x0},
	308: {cur: 0x71, idx: 0x0},
	309: {cur: 0x72, idx: 0x0},
	310: {cur: 0x73, idx: 0x0},
	311: {cur: 0x75, idx: 0x0},
	312: {cur: 0x77, idx: 0x0},
	313: {cur: 0x78, idx: 0x0},
	314: {cur: 0x7c, idx: 0x0},
	315: {cur: 0x7d, idx: 0x0},
	316: {cur: 0x81, idx: 0x0},
	317: {cur: 0x83, idx: 0x0},
	318: {cur: 0x88, idx: 0x0},
	319: {cur: 0x89, idx: 0x0},
	320: {cur: 0x8a, idx: 0x0},
	321: {cur: 0x8d, idx: 0x0},
	322: {cur: 0x8f, idx: 0x0},
	323: {cur: 0x90, idx: 0x0},
	324: {cur: 0x91, idx: 0x0},
	325: {cur: 0x92, idx: 0x0},
	326: {cur: 0x93, idx: 0x0},
	327: {cur: 0x94, idx: 0x0},
	328: {cur: 0x96, idx: 0x0},
	329: {cur: 0x9b, idx: 0x0},
	330: {cur: 0xa3, idx: 0x0},
	331: {cur: 0xa8, idx: 0x0},
	332: {cur: 0xa9, idx: 0x0},
	333: {cur: 0xae, idx: 0x0},
	334: {cur: 0xb2, idx: 0x0},
	335: {cur: 0xb5, idx: 0x0},
	336: {cur: 0xb9, idx: 0x0},
	337: {cur: 0xba, idx: 0x0},
	338: {cur: 0xbc, idx: 0x0},
	339: {cur: 0xbe, idx: 0x0},
	340: {cur: 0xbf, idx: 0x0},
	341: {cur: 0xc0, idx: 0x0},
	342: {cur: 0xc7, idx: 0x0},
	343: {cur: 0xc8, idx: 0x0},
	344: {cur: 0xc9, idx: 0x0},
	345: {cur: 0xcc, idx: 0x0},
	346: {cur: 0xd0, idx: 0x0},
	347: {cur: 0xd3, idx: 0x0},
	348: {cur: 0xd4, idx: 0x0},
	349: {cur: 0xd6, idx: 0x0},
	350: {cur: 0xdb, idx: 0x0},
	351: {cur: 0xdc, idx: 0x0},
	352: {cur: 0xdd, idx: 0x0},
	353: {cur: 0xe2, idx: 0x0},
	354: {cur: 0xe4, idx: 0x0},
	355: {cur: 0xe5, idx: 0x0},
	356: {cur: 0xe9, idx: 0x0},
	357: {cur: 0xeb, idx: 0x0},
	358: {cur: 0xf1, idx: 0x0},
	359: {cur: 0xf4, idx: 0x0},
	360: {cur: 0xf5, idx: 0x0},
	361: {cur: 0xf6, idx: 0x0},
	362: {cur: 0xf8, idx: 0x0},
	363: {cur: 0x101, idx: 0x0},
	364: {cur: 0x104, idx: 0x0},
	365: {cur: 0x105, idx: 0x0},
	366: {cur: 0x110, idx: 0x0},
	367: {cur: 0x125, idx: 0x0},
	368: {cur: 0x127, idx: 0x0},
	369: {cur: 0xf6, idx: 0xc7},
	370: {cur: 0x58, idx: 0x3e5},
	371: {cur: 0x89, idx: 0x32a},
	372: {cur: 0x92, idx: 0x2b8},
	373: {cur: 0xbc, idx: 0x41a},
	374: {cur: 0xd0, idx: 0x4f},
	375: {cur: 0xd4, idx: 0x421},
	376: {cur: 0xf6, idx: 0xc7},
	377: {cur: 0x127, idx: 0x441},
	378: {cur: 0x37, idx: 0x258},
	379: {cur: 0x65, idx: 0x0},
	380: {cur: 0x89, idx: 0x6b},
	381: {cur: 0xbc, idx: 0x9b},
	382: {cur: 0x127, idx: 0xeb},
	383: {cur: 0xf6, idx: 0xc7},
	384: {cur: 0xd0, idx: 0xee},
	385: {cur: 0xf6, idx: 0xc7},
	386: {cur: 0x89, idx: 0x32a},
	387: {cur: 0xd2, idx: 0x46d},
	388: {cur: 0xf6, idx: 0xc7},
	389: {cur: 0xae, idx: 0x474},
	390: {cur: 0xf6, idx: 0xc7},
	391: {cur: 0xf6, idx: 0xc7},
	392: {cur: 0xd0, idx: 0x48e},
	393: {cur: 0xf6, idx: 0xc7},
	394: {cur: 0xf6, idx: 0xc7},
	395: {cur: 0xf6, idx: 0xc7},
	396: {cur: 0xf6, idx: 0xc7},
	397: {cur: 0xf6, idx: 0xc7},
	398: {cur: 0xf6, idx: 0xc7},
	399: {cur: 0x37, idx: 0x258},
	400: {cur: 0x58, idx: 0x3e5},
	401: {cur: 0xbe, idx: 0x49b},
	402: {cur: 0xf6, idx: 0xc7},
	403: {cur: 0x44, idx: 0x4a3},
	404: {cur: 0x85, idx: 0x4a3},
	405: {cur: 0xd0, idx: 0x4a7},
	406: {cur: 0xf6, idx: 0xc7},
	407: {cur: 0xf6, idx: 0xc7},
	408: {cur: 0xf6, idx: 0xc7},
	409: {cur: 0xd0, idx: 0x4b2},
	410: {cur: 0xf6, idx: 0xc7},
	411: {cur: 0xd0, idx: 0x4f},
	412: {cur: 0xf6, idx: 0xc7},
	413: {cur: 0x25, idx: 0x251},
	414: {cur: 0x32, idx: 0x255},
	415: {cur: 0x39, idx: 0x146},
	416: {cur: 0x3a, idx: 0x9b},
	417: {cur: 0x53, idx: 0x264},
	418: {cur: 0x58, idx: 0x4b9},
	419: {cur: 0x72, idx: 0x4b},
	420: {cur: 0x75, idx: 0x4bc},
	421: {cur: 0x83, idx: 0x275},
	422: {cur: 0xf5, idx: 0x21b},
	423: {cur: 0xf6, idx: 0xc7},
	424: {cur: 0xf6, idx: 0xc7},
	425: {cur: 0xf6, idx: 0xc7},
	426: {cur: 0x1b, idx: 0x0},
	427: {cur: 0x37, idx: 0x258},
	428: {cur: 0x7c, idx: 0x0},
	429: {cur: 0x7d, idx: 0x0},
	430: {cur: 0x88, idx: 0x0},
	431: {cur: 0x91, idx: 0x0},
	432: {cur: 0xa9, idx: 0x0},
	433: {cur: 0xc9, idx: 0x4c6},
	434: {cur: 0xcc, idx: 0x352},
	435: {cur: 0xd2, idx: 0x4c9},
	436: {cur: 0x105, idx: 0x0},
	437: {cur: 0xf6, idx: 0xc7},
	438: {cur: 0xf6, idx: 0xc7},
	439: {cur: 0xf6, idx: 0xc7},
	440: {cur: 0xdb, idx: 0x4d7},
	441: {cur: 0xf6, idx: 0xc7},
	442: {cur: 0xf6, idx: 0xc7},
	443: {cur: 0xf6, idx: 0xc7},
	444: {cur: 0x1a, idx: 0x24c},
	445: {cur: 0x32, idx: 0x255},
	446: {cur: 0xd0, idx: 0x4f},
	447: {cur: 0xf6, idx: 0xc7},
	448: {cur: 0xbf, idx: 0x4f1},
	449: {cur: 0xf6, idx: 0xc7},
	450: {cur: 0xf6, idx: 0xc7},
	451: {cur: 0xd0, idx: 0x500},
	452: {cur: 0xf6, idx: 0xc7},
	453: {cur: 0xd0, idx: 0x4f},
	454: {cur: 0xf6, idx: 0xc7},
	455: {cur: 0xf6, idx: 0xc7},
	456: {cur: 0x65, idx: 0x515},
	457: {cur: 0xd0, idx: 0x4f},
	458: {cur: 0xf6, idx: 0xc7},
	459: {cur: 0x37, idx: 0x258},
	460: {cur: 0x93, idx: 0x52c},
	461: {cur: 0xf6, idx: 0xc7},
	462: {cur: 0xf6, idx: 0xc7},
	463: {cur: 0xf6, idx: 0xc7},
	464: {cur: 0x65, idx: 0x515},
	465: {cur: 0xf6, idx: 0xc7},
	466: {cur: 0x37, idx: 0x552},
	467: {cur: 0x65, idx: 0x515},
	468: {cur: 0xf6, idx: 0xc7},
	469: {cur: 0x5c, idx: 0x0},
	470: {cur: 0xd0, idx: 0x4f},
	471: {cur: 0xf6, idx: 0xc7},
	472: {cur: 0xf6, idx: 0xc7},
	473: {cur: 0xf6, idx: 0xc7},
	474: {cur: 0xf6, idx: 0xc7},
	475: {cur: 0xf6, idx: 0xc7},
	476: {cur: 0xd0, idx: 0x4f},
	477: {cur: 0xf6, idx: 0xc7},
	478: {cur: 0xf6, idx: 0xc7},
	479: {cur: 0xf6, idx: 0xc7},
	480: {cur: 0xf6, idx: 0xc7},
	481: {cur: 0xf6, idx: 0xc7},
	482: {cur: 0xd0, idx: 0x4f},
	483: {cur: 0x37, idx: 0x59e},
	484: {cur: 0x52, idx: 0x34f},
	485: {cur: 0x75, idx: 0x4bc},
	486: {cur: 0x81, idx: 0x34f},
	487: {cur: 0xbe, idx: 0x34f},
	488: {cur: 0xc9, idx: 0x5a1},
	489: {cur: 0xdb, idx: 0x34f},
	490: {cur: 0xf6, idx: 0xc7},
} // Size: 1988 bytes

// Total table size 18885 bytes (18KiB); checksum: 323F41F3
