package resourcegraph

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/resourcegraph/mgmt/2021-03-01-preview/resourcegraph"

// Column query result column descriptor.
type Column struct {
	// Name - Column name.
	Name *string `json:"name,omitempty"`
	// Type - Column data type. Possible values include: 'ColumnDataTypeString', 'ColumnDataTypeInteger', 'ColumnDataTypeNumber', 'ColumnDataTypeBoolean', 'ColumnDataTypeObject'
	Type ColumnDataType `json:"type,omitempty"`
}

// DateTimeInterval an interval in time specifying the date and time for the inclusive start and exclusive
// end, i.e. `[start, end)`.
type DateTimeInterval struct {
	// Start - A datetime indicating the inclusive/closed start of the time interval, i.e. `[`**`start`**`, end)`. Specifying a `start` that occurs chronologically after `end` will result in an error.
	Start *date.Time `json:"start,omitempty"`
	// End - A datetime indicating the exclusive/open end of the time interval, i.e. `[start, `**`end`**`)`. Specifying an `end` that occurs chronologically before `start` will result in an error.
	End *date.Time `json:"end,omitempty"`
}

// Error error details.
type Error struct {
	// Code - Error code identifying the specific error.
	Code *string `json:"code,omitempty"`
	// Message - A human readable error message.
	Message *string `json:"message,omitempty"`
	// Details - Error details
	Details *[]ErrorDetails `json:"details,omitempty"`
}

// ErrorDetails ...
type ErrorDetails struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Code - Error code identifying the specific error.
	Code *string `json:"code,omitempty"`
	// Message - A human readable error message.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetails.
func (ed ErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ed.Code != nil {
		objectMap["code"] = ed.Code
	}
	if ed.Message != nil {
		objectMap["message"] = ed.Message
	}
	for k, v := range ed.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ErrorDetails struct.
func (ed *ErrorDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ed.AdditionalProperties == nil {
					ed.AdditionalProperties = make(map[string]interface{})
				}
				ed.AdditionalProperties[k] = additionalProperties
			}
		case "code":
			if v != nil {
				var code string
				err = json.Unmarshal(*v, &code)
				if err != nil {
					return err
				}
				ed.Code = &code
			}
		case "message":
			if v != nil {
				var message string
				err = json.Unmarshal(*v, &message)
				if err != nil {
					return err
				}
				ed.Message = &message
			}
		}
	}

	return nil
}

// ErrorResponse an error response from the API.
type ErrorResponse struct {
	// Error - Error information.
	Error *Error `json:"error,omitempty"`
}

// BasicFacet a facet containing additional statistics on the response of a query. Can be either FacetResult or
// FacetError.
type BasicFacet interface {
	AsFacetResult() (*FacetResult, bool)
	AsFacetError() (*FacetError, bool)
	AsFacet() (*Facet, bool)
}

// Facet a facet containing additional statistics on the response of a query. Can be either FacetResult or
// FacetError.
type Facet struct {
	// Expression - Facet expression, same as in the corresponding facet request.
	Expression *string `json:"expression,omitempty"`
	// ResultType - Possible values include: 'ResultTypeResultTypeFacet', 'ResultTypeResultTypeFacetResult', 'ResultTypeResultTypeFacetError'
	ResultType ResultType `json:"resultType,omitempty"`
}

func unmarshalBasicFacet(body []byte) (BasicFacet, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeResultTypeFacetResult):
		var fr FacetResult
		err := json.Unmarshal(body, &fr)
		return fr, err
	case string(ResultTypeResultTypeFacetError):
		var fe FacetError
		err := json.Unmarshal(body, &fe)
		return fe, err
	default:
		var f Facet
		err := json.Unmarshal(body, &f)
		return f, err
	}
}
func unmarshalBasicFacetArray(body []byte) ([]BasicFacet, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fArray := make([]BasicFacet, len(rawMessages))

	for index, rawMessage := range rawMessages {
		f, err := unmarshalBasicFacet(*rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

// MarshalJSON is the custom marshaler for Facet.
func (f Facet) MarshalJSON() ([]byte, error) {
	f.ResultType = ResultTypeResultTypeFacet
	objectMap := make(map[string]interface{})
	if f.Expression != nil {
		objectMap["expression"] = f.Expression
	}
	if f.ResultType != "" {
		objectMap["resultType"] = f.ResultType
	}
	return json.Marshal(objectMap)
}

// AsFacetResult is the BasicFacet implementation for Facet.
func (f Facet) AsFacetResult() (*FacetResult, bool) {
	return nil, false
}

// AsFacetError is the BasicFacet implementation for Facet.
func (f Facet) AsFacetError() (*FacetError, bool) {
	return nil, false
}

// AsFacet is the BasicFacet implementation for Facet.
func (f Facet) AsFacet() (*Facet, bool) {
	return &f, true
}

// AsBasicFacet is the BasicFacet implementation for Facet.
func (f Facet) AsBasicFacet() (BasicFacet, bool) {
	return &f, true
}

// FacetError a facet whose execution resulted in an error.
type FacetError struct {
	// Errors - An array containing detected facet errors with details.
	Errors *[]ErrorDetails `json:"errors,omitempty"`
	// Expression - Facet expression, same as in the corresponding facet request.
	Expression *string `json:"expression,omitempty"`
	// ResultType - Possible values include: 'ResultTypeResultTypeFacet', 'ResultTypeResultTypeFacetResult', 'ResultTypeResultTypeFacetError'
	ResultType ResultType `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for FacetError.
func (fe FacetError) MarshalJSON() ([]byte, error) {
	fe.ResultType = ResultTypeResultTypeFacetError
	objectMap := make(map[string]interface{})
	if fe.Errors != nil {
		objectMap["errors"] = fe.Errors
	}
	if fe.Expression != nil {
		objectMap["expression"] = fe.Expression
	}
	if fe.ResultType != "" {
		objectMap["resultType"] = fe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsFacetResult is the BasicFacet implementation for FacetError.
func (fe FacetError) AsFacetResult() (*FacetResult, bool) {
	return nil, false
}

// AsFacetError is the BasicFacet implementation for FacetError.
func (fe FacetError) AsFacetError() (*FacetError, bool) {
	return &fe, true
}

// AsFacet is the BasicFacet implementation for FacetError.
func (fe FacetError) AsFacet() (*Facet, bool) {
	return nil, false
}

// AsBasicFacet is the BasicFacet implementation for FacetError.
func (fe FacetError) AsBasicFacet() (BasicFacet, bool) {
	return &fe, true
}

// FacetRequest a request to compute additional statistics (facets) over the query results.
type FacetRequest struct {
	// Expression - The column or list of columns to summarize by
	Expression *string `json:"expression,omitempty"`
	// Options - The options for facet evaluation
	Options *FacetRequestOptions `json:"options,omitempty"`
}

// FacetRequestOptions the options for facet evaluation
type FacetRequestOptions struct {
	// SortBy - The column name or query expression to sort on. Defaults to count if not present.
	SortBy *string `json:"sortBy,omitempty"`
	// SortOrder - The sorting order by the selected column (count by default). Possible values include: 'FacetSortOrderAsc', 'FacetSortOrderDesc'
	SortOrder FacetSortOrder `json:"sortOrder,omitempty"`
	// Filter - Specifies the filter condition for the 'where' clause which will be run on main query's result, just before the actual faceting.
	Filter *string `json:"filter,omitempty"`
	// Top - The maximum number of facet rows that should be returned.
	Top *int32 `json:"$top,omitempty"`
}

// FacetResult successfully executed facet containing additional statistics on the response of a query.
type FacetResult struct {
	// TotalRecords - Number of total records in the facet results.
	TotalRecords *int64 `json:"totalRecords,omitempty"`
	// Count - Number of records returned in the facet response.
	Count *int32 `json:"count,omitempty"`
	// Data - A JObject array or Table containing the desired facets. Only present if the facet is valid.
	Data interface{} `json:"data,omitempty"`
	// Expression - Facet expression, same as in the corresponding facet request.
	Expression *string `json:"expression,omitempty"`
	// ResultType - Possible values include: 'ResultTypeResultTypeFacet', 'ResultTypeResultTypeFacetResult', 'ResultTypeResultTypeFacetError'
	ResultType ResultType `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for FacetResult.
func (fr FacetResult) MarshalJSON() ([]byte, error) {
	fr.ResultType = ResultTypeResultTypeFacetResult
	objectMap := make(map[string]interface{})
	if fr.TotalRecords != nil {
		objectMap["totalRecords"] = fr.TotalRecords
	}
	if fr.Count != nil {
		objectMap["count"] = fr.Count
	}
	if fr.Data != nil {
		objectMap["data"] = fr.Data
	}
	if fr.Expression != nil {
		objectMap["expression"] = fr.Expression
	}
	if fr.ResultType != "" {
		objectMap["resultType"] = fr.ResultType
	}
	return json.Marshal(objectMap)
}

// AsFacetResult is the BasicFacet implementation for FacetResult.
func (fr FacetResult) AsFacetResult() (*FacetResult, bool) {
	return &fr, true
}

// AsFacetError is the BasicFacet implementation for FacetResult.
func (fr FacetResult) AsFacetError() (*FacetError, bool) {
	return nil, false
}

// AsFacet is the BasicFacet implementation for FacetResult.
func (fr FacetResult) AsFacet() (*Facet, bool) {
	return nil, false
}

// AsBasicFacet is the BasicFacet implementation for FacetResult.
func (fr FacetResult) AsBasicFacet() (BasicFacet, bool) {
	return &fr, true
}

// ListResourceChangeData ...
type ListResourceChangeData struct {
	autorest.Response `json:"-"`
	Value             *[]ResourceChangeData `json:"value,omitempty"`
}

// Operation resource Graph REST API operation definition.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - The origin of operations.
	Origin *string `json:"origin,omitempty"`
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft Resource Graph.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description for the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list Resource Graph operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Resource Graph operations supported by the Resource Graph resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// QueryRequest describes a query to be executed.
type QueryRequest struct {
	// Subscriptions - Azure subscriptions against which to execute the query.
	Subscriptions *[]string `json:"subscriptions,omitempty"`
	// ManagementGroups - Azure management groups against which to execute the query. Example: [ 'mg1', 'mg2' ]
	ManagementGroups *[]string `json:"managementGroups,omitempty"`
	// Query - The resources query.
	Query *string `json:"query,omitempty"`
	// Options - The query evaluation options
	Options *QueryRequestOptions `json:"options,omitempty"`
	// Facets - An array of facet requests to be computed against the query result.
	Facets *[]FacetRequest `json:"facets,omitempty"`
}

// QueryRequestOptions the options for query evaluation
type QueryRequestOptions struct {
	// SkipToken - Continuation token for pagination, capturing the next page size and offset, as well as the context of the query.
	SkipToken *string `json:"$skipToken,omitempty"`
	// Top - The maximum number of rows that the query should return. Overrides the page size when ```$skipToken``` property is present.
	Top *int32 `json:"$top,omitempty"`
	// Skip - The number of rows to skip from the beginning of the results. Overrides the next page offset when ```$skipToken``` property is present.
	Skip *int32 `json:"$skip,omitempty"`
	// ResultFormat - Defines in which format query result returned. Possible values include: 'ResultFormatTable', 'ResultFormatObjectArray'
	ResultFormat ResultFormat `json:"resultFormat,omitempty"`
	// AllowPartialScopes - Only applicable for tenant and management group level queries to decide whether to allow partial scopes for result in case the number of subscriptions exceed allowed limits.
	AllowPartialScopes *bool `json:"allowPartialScopes,omitempty"`
}

// QueryResponse query result.
type QueryResponse struct {
	autorest.Response `json:"-"`
	// TotalRecords - Number of total records matching the query.
	TotalRecords *int64 `json:"totalRecords,omitempty"`
	// Count - Number of records returned in the current response. In the case of paging, this is the number of records in the current page.
	Count *int64 `json:"count,omitempty"`
	// ResultTruncated - Indicates whether the query results are truncated. Possible values include: 'ResultTruncatedTrue', 'ResultTruncatedFalse'
	ResultTruncated ResultTruncated `json:"resultTruncated,omitempty"`
	// SkipToken - When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
	SkipToken *string `json:"$skipToken,omitempty"`
	// Data - Query output in JObject array or Table format.
	Data interface{} `json:"data,omitempty"`
	// Facets - Query facets.
	Facets *[]BasicFacet `json:"facets,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for QueryResponse struct.
func (qr *QueryResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "totalRecords":
			if v != nil {
				var totalRecords int64
				err = json.Unmarshal(*v, &totalRecords)
				if err != nil {
					return err
				}
				qr.TotalRecords = &totalRecords
			}
		case "count":
			if v != nil {
				var count int64
				err = json.Unmarshal(*v, &count)
				if err != nil {
					return err
				}
				qr.Count = &count
			}
		case "resultTruncated":
			if v != nil {
				var resultTruncated ResultTruncated
				err = json.Unmarshal(*v, &resultTruncated)
				if err != nil {
					return err
				}
				qr.ResultTruncated = resultTruncated
			}
		case "$skipToken":
			if v != nil {
				var skipToken string
				err = json.Unmarshal(*v, &skipToken)
				if err != nil {
					return err
				}
				qr.SkipToken = &skipToken
			}
		case "data":
			if v != nil {
				var data interface{}
				err = json.Unmarshal(*v, &data)
				if err != nil {
					return err
				}
				qr.Data = data
			}
		case "facets":
			if v != nil {
				facets, err := unmarshalBasicFacetArray(*v)
				if err != nil {
					return err
				}
				qr.Facets = &facets
			}
		}
	}

	return nil
}

// ResourceChangeData data on a specific change, represented by a pair of before and after resource
// snapshots.
type ResourceChangeData struct {
	// ResourceID - The resource for a change.
	ResourceID *string `json:"resourceId,omitempty"`
	// ChangeID - The change ID. Valid and unique within the specified resource only.
	ChangeID *string `json:"changeId,omitempty"`
	// BeforeSnapshot - The snapshot before the change.
	BeforeSnapshot *ResourceChangeDataBeforeSnapshot `json:"beforeSnapshot,omitempty"`
	// AfterSnapshot - The snapshot after the change.
	AfterSnapshot *ResourceChangeDataAfterSnapshot `json:"afterSnapshot,omitempty"`
	// ChangeType - The change type for snapshot. PropertyChanges will be provided in case of Update change type. Possible values include: 'ChangeTypeCreate', 'ChangeTypeUpdate', 'ChangeTypeDelete'
	ChangeType ChangeType `json:"changeType,omitempty"`
	// PropertyChanges - An array of resource property change
	PropertyChanges *[]ResourcePropertyChange `json:"propertyChanges,omitempty"`
}

// ResourceChangeDataAfterSnapshot the snapshot after the change.
type ResourceChangeDataAfterSnapshot struct {
	// SnapshotID - The ID of the snapshot.
	SnapshotID *string `json:"snapshotId,omitempty"`
	// Timestamp - The time when the snapshot was created.
	// The snapshot timestamp provides an approximation as to when a modification to a resource was detected.  There can be a difference between the actual modification time and the detection time.  This is due to differences in how operations that modify a resource are processed, versus how operation that record resource snapshots are processed.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Content - The resource snapshot content (in resourceChangeDetails response only).
	Content interface{} `json:"content,omitempty"`
}

// ResourceChangeDataBeforeSnapshot the snapshot before the change.
type ResourceChangeDataBeforeSnapshot struct {
	// SnapshotID - The ID of the snapshot.
	SnapshotID *string `json:"snapshotId,omitempty"`
	// Timestamp - The time when the snapshot was created.
	// The snapshot timestamp provides an approximation as to when a modification to a resource was detected.  There can be a difference between the actual modification time and the detection time.  This is due to differences in how operations that modify a resource are processed, versus how operation that record resource snapshots are processed.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Content - The resource snapshot content (in resourceChangeDetails response only).
	Content interface{} `json:"content,omitempty"`
}

// ResourceChangeDetailsRequestParameters the parameters for a specific change details request.
type ResourceChangeDetailsRequestParameters struct {
	// ResourceIds - Specifies the list of resources for a change details request.
	ResourceIds *[]string `json:"resourceIds,omitempty"`
	// ChangeIds - Specifies the list of change IDs for a change details request.
	ChangeIds *[]string `json:"changeIds,omitempty"`
}

// ResourceChangeList a list of changes associated with a resource over a specific time interval.
type ResourceChangeList struct {
	autorest.Response `json:"-"`
	// Changes - The pageable value returned by the operation, i.e. a list of changes to the resource.
	// - The list is ordered from the most recent changes to the least recent changes.
	// - This list will be empty if there were no changes during the requested interval.
	// - The `Before` snapshot timestamp value of the oldest change can be outside of the specified time interval.
	Changes *[]ResourceChangeData `json:"changes,omitempty"`
	// SkipToken - Skip token that encodes the skip information while executing the current request
	SkipToken interface{} `json:"$skipToken,omitempty"`
}

// ResourceChangesRequestParameters the parameters for a specific changes request.
type ResourceChangesRequestParameters struct {
	// ResourceIds - Specifies the list of resources for a changes request.
	ResourceIds *[]string `json:"resourceIds,omitempty"`
	// SubscriptionID - The subscription id of resources to query the changes from.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// Interval - Specifies the date and time interval for a changes request.
	Interval *ResourceChangesRequestParametersInterval `json:"interval,omitempty"`
	// SkipToken - Acts as the continuation token for paged responses.
	SkipToken *string `json:"$skipToken,omitempty"`
	// Top - The maximum number of changes the client can accept in a paged response.
	Top *int32 `json:"$top,omitempty"`
	// Table - The table name to query resources from.
	Table *string `json:"table,omitempty"`
	// FetchPropertyChanges - The flag if set to true will fetch property changes
	FetchPropertyChanges *bool `json:"fetchPropertyChanges,omitempty"`
	// FetchSnapshots - The flag if set to true will fetch change snapshots
	FetchSnapshots *bool `json:"fetchSnapshots,omitempty"`
}

// ResourceChangesRequestParametersInterval specifies the date and time interval for a changes request.
type ResourceChangesRequestParametersInterval struct {
	// Start - A datetime indicating the inclusive/closed start of the time interval, i.e. `[`**`start`**`, end)`. Specifying a `start` that occurs chronologically after `end` will result in an error.
	Start *date.Time `json:"start,omitempty"`
	// End - A datetime indicating the exclusive/open end of the time interval, i.e. `[start, `**`end`**`)`. Specifying an `end` that occurs chronologically before `start` will result in an error.
	End *date.Time `json:"end,omitempty"`
}

// ResourcePropertyChange the resource property change
type ResourcePropertyChange struct {
	// PropertyName - The property name
	PropertyName *string `json:"propertyName,omitempty"`
	// BeforeValue - The property value in before snapshot
	BeforeValue *string `json:"beforeValue,omitempty"`
	// AfterValue - The property value in after snapshot
	AfterValue *string `json:"afterValue,omitempty"`
	// ChangeCategory - The change category. Possible values include: 'ChangeCategoryUser', 'ChangeCategorySystem'
	ChangeCategory ChangeCategory `json:"changeCategory,omitempty"`
	// PropertyChangeType - The property change Type. Possible values include: 'PropertyChangeTypeInsert', 'PropertyChangeTypeUpdate', 'PropertyChangeTypeRemove'
	PropertyChangeType PropertyChangeType `json:"propertyChangeType,omitempty"`
}

// ResourcesHistoryRequest ...
type ResourcesHistoryRequest struct {
	Subscriptions     *[]string                       `json:"subscriptions,omitempty"`
	Query             *string                         `json:"query,omitempty"`
	Options           *ResourcesHistoryRequestOptions `json:"options,omitempty"`
	ManagementGroupID *string                         `json:"managementGroupId,omitempty"`
}

// ResourcesHistoryRequestOptions ...
type ResourcesHistoryRequestOptions struct {
	Interval  *DateTimeInterval `json:"interval,omitempty"`
	Top       *int32            `json:"$top,omitempty"`
	Skip      *int32            `json:"$skip,omitempty"`
	SkipToken *string           `json:"$skipToken,omitempty"`
	// ResultFormat - Possible values include: 'ResultFormat1Table', 'ResultFormat1ObjectArray'
	ResultFormat ResultFormat1 `json:"resultFormat,omitempty"`
}

// ResourceSnapshotData data on a specific resource snapshot.
type ResourceSnapshotData struct {
	// SnapshotID - The ID of the snapshot.
	SnapshotID *string `json:"snapshotId,omitempty"`
	// Timestamp - The time when the snapshot was created.
	// The snapshot timestamp provides an approximation as to when a modification to a resource was detected.  There can be a difference between the actual modification time and the detection time.  This is due to differences in how operations that modify a resource are processed, versus how operation that record resource snapshots are processed.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Content - The resource snapshot content (in resourceChangeDetails response only).
	Content interface{} `json:"content,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// Table query output in tabular format.
type Table struct {
	// Columns - Query result column descriptors.
	Columns *[]Column `json:"columns,omitempty"`
	// Rows - Query result rows.
	Rows *[][]interface{} `json:"rows,omitempty"`
}
