package resourcegraph

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ChangeCategory enumerates the values for change category.
type ChangeCategory string

const (
	// ChangeCategorySystem ...
	ChangeCategorySystem ChangeCategory = "System"
	// ChangeCategoryUser ...
	ChangeCategoryUser ChangeCategory = "User"
)

// PossibleChangeCategoryValues returns an array of possible values for the ChangeCategory const type.
func PossibleChangeCategoryValues() []ChangeCategory {
	return []ChangeCategory{ChangeCategorySystem, ChangeCategoryUser}
}

// ChangeType enumerates the values for change type.
type ChangeType string

const (
	// ChangeTypeCreate ...
	ChangeTypeCreate ChangeType = "Create"
	// ChangeTypeDelete ...
	ChangeTypeDelete ChangeType = "Delete"
	// ChangeTypeUpdate ...
	ChangeTypeUpdate ChangeType = "Update"
)

// PossibleChangeTypeValues returns an array of possible values for the ChangeType const type.
func PossibleChangeTypeValues() []ChangeType {
	return []ChangeType{ChangeTypeCreate, ChangeTypeDelete, ChangeTypeUpdate}
}

// ColumnDataType enumerates the values for column data type.
type ColumnDataType string

const (
	// ColumnDataTypeBoolean ...
	ColumnDataTypeBoolean ColumnDataType = "boolean"
	// ColumnDataTypeInteger ...
	ColumnDataTypeInteger ColumnDataType = "integer"
	// ColumnDataTypeNumber ...
	ColumnDataTypeNumber ColumnDataType = "number"
	// ColumnDataTypeObject ...
	ColumnDataTypeObject ColumnDataType = "object"
	// ColumnDataTypeString ...
	ColumnDataTypeString ColumnDataType = "string"
)

// PossibleColumnDataTypeValues returns an array of possible values for the ColumnDataType const type.
func PossibleColumnDataTypeValues() []ColumnDataType {
	return []ColumnDataType{ColumnDataTypeBoolean, ColumnDataTypeInteger, ColumnDataTypeNumber, ColumnDataTypeObject, ColumnDataTypeString}
}

// FacetSortOrder enumerates the values for facet sort order.
type FacetSortOrder string

const (
	// FacetSortOrderAsc ...
	FacetSortOrderAsc FacetSortOrder = "asc"
	// FacetSortOrderDesc ...
	FacetSortOrderDesc FacetSortOrder = "desc"
)

// PossibleFacetSortOrderValues returns an array of possible values for the FacetSortOrder const type.
func PossibleFacetSortOrderValues() []FacetSortOrder {
	return []FacetSortOrder{FacetSortOrderAsc, FacetSortOrderDesc}
}

// PropertyChangeType enumerates the values for property change type.
type PropertyChangeType string

const (
	// PropertyChangeTypeInsert ...
	PropertyChangeTypeInsert PropertyChangeType = "Insert"
	// PropertyChangeTypeRemove ...
	PropertyChangeTypeRemove PropertyChangeType = "Remove"
	// PropertyChangeTypeUpdate ...
	PropertyChangeTypeUpdate PropertyChangeType = "Update"
)

// PossiblePropertyChangeTypeValues returns an array of possible values for the PropertyChangeType const type.
func PossiblePropertyChangeTypeValues() []PropertyChangeType {
	return []PropertyChangeType{PropertyChangeTypeInsert, PropertyChangeTypeRemove, PropertyChangeTypeUpdate}
}

// ResultFormat enumerates the values for result format.
type ResultFormat string

const (
	// ResultFormatObjectArray ...
	ResultFormatObjectArray ResultFormat = "objectArray"
	// ResultFormatTable ...
	ResultFormatTable ResultFormat = "table"
)

// PossibleResultFormatValues returns an array of possible values for the ResultFormat const type.
func PossibleResultFormatValues() []ResultFormat {
	return []ResultFormat{ResultFormatObjectArray, ResultFormatTable}
}

// ResultFormat1 enumerates the values for result format 1.
type ResultFormat1 string

const (
	// ResultFormat1ObjectArray ...
	ResultFormat1ObjectArray ResultFormat1 = "objectArray"
	// ResultFormat1Table ...
	ResultFormat1Table ResultFormat1 = "table"
)

// PossibleResultFormat1Values returns an array of possible values for the ResultFormat1 const type.
func PossibleResultFormat1Values() []ResultFormat1 {
	return []ResultFormat1{ResultFormat1ObjectArray, ResultFormat1Table}
}

// ResultTruncated enumerates the values for result truncated.
type ResultTruncated string

const (
	// ResultTruncatedFalse ...
	ResultTruncatedFalse ResultTruncated = "false"
	// ResultTruncatedTrue ...
	ResultTruncatedTrue ResultTruncated = "true"
)

// PossibleResultTruncatedValues returns an array of possible values for the ResultTruncated const type.
func PossibleResultTruncatedValues() []ResultTruncated {
	return []ResultTruncated{ResultTruncatedFalse, ResultTruncatedTrue}
}

// ResultType enumerates the values for result type.
type ResultType string

const (
	// ResultTypeResultTypeFacet ...
	ResultTypeResultTypeFacet ResultType = "Facet"
	// ResultTypeResultTypeFacetError ...
	ResultTypeResultTypeFacetError ResultType = "FacetError"
	// ResultTypeResultTypeFacetResult ...
	ResultTypeResultTypeFacetResult ResultType = "FacetResult"
)

// PossibleResultTypeValues returns an array of possible values for the ResultType const type.
func PossibleResultTypeValues() []ResultType {
	return []ResultType{ResultTypeResultTypeFacet, ResultTypeResultTypeFacetError, ResultTypeResultTypeFacetResult}
}
