package reservations

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/reservations/mgmt/2020-10-25/reservations"

// AppliedReservationList ...
type AppliedReservationList struct {
	Value *[]string `json:"value,omitempty"`
	// NextLink - Url to get the next page of reservations
	NextLink *string `json:"nextLink,omitempty"`
}

// AppliedReservations ...
type AppliedReservations struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Identifier of the applied reservations
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of resource. "Microsoft.Capacity/AppliedReservations"
	Type                           *string `json:"type,omitempty"`
	*AppliedReservationsProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AppliedReservations.
func (ar AppliedReservations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.AppliedReservationsProperties != nil {
		objectMap["properties"] = ar.AppliedReservationsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppliedReservations struct.
func (ar *AppliedReservations) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var appliedReservationsProperties AppliedReservationsProperties
				err = json.Unmarshal(*v, &appliedReservationsProperties)
				if err != nil {
					return err
				}
				ar.AppliedReservationsProperties = &appliedReservationsProperties
			}
		}
	}

	return nil
}

// AppliedReservationsProperties ...
type AppliedReservationsProperties struct {
	ReservationOrderIds *AppliedReservationList `json:"reservationOrderIds,omitempty"`
}

// AvailableScopeProperties ...
type AvailableScopeProperties struct {
	autorest.Response `json:"-"`
	Properties        *SubscriptionScopeProperties `json:"properties,omitempty"`
}

// AvailableScopeRequest available scope
type AvailableScopeRequest struct {
	Properties *AvailableScopeRequestProperties `json:"properties,omitempty"`
}

// AvailableScopeRequestProperties available scope request properties
type AvailableScopeRequestProperties struct {
	Scopes *[]string `json:"scopes,omitempty"`
}

// BillingInformation billing information
type BillingInformation struct {
	BillingCurrencyTotalPaidAmount           *Price `json:"billingCurrencyTotalPaidAmount,omitempty"`
	BillingCurrencyProratedAmount            *Price `json:"billingCurrencyProratedAmount,omitempty"`
	BillingCurrencyRemainingCommitmentAmount *Price `json:"billingCurrencyRemainingCommitmentAmount,omitempty"`
}

// CalculateExchangeOperationResultResponse calculateExchange operation result
type CalculateExchangeOperationResultResponse struct {
	autorest.Response `json:"-"`
	// ID - It should match what is used to GET the operation result.
	ID *string `json:"id,omitempty"`
	// Name - It must match the last segment of the id field, and will typically be a GUID / system generated value.
	Name *string `json:"name,omitempty"`
	// Status - Status of the operation. Possible values include: 'Succeeded', 'Failed', 'Cancelled', 'Pending'
	Status     CalculateExchangeOperationResultStatus `json:"status,omitempty"`
	Properties *CalculateExchangeResponseProperties   `json:"properties,omitempty"`
	Error      *OperationResultError                  `json:"error,omitempty"`
}

// CalculateExchangePostFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CalculateExchangePostFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CalculateExchangeClient) (CalculateExchangeOperationResultResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CalculateExchangePostFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CalculateExchangePostFuture.Result.
func (future *CalculateExchangePostFuture) result(client CalculateExchangeClient) (ceorr CalculateExchangeOperationResultResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.CalculateExchangePostFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ceorr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("reservations.CalculateExchangePostFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ceorr.Response.Response, err = future.GetResult(sender); err == nil && ceorr.Response.Response.StatusCode != http.StatusNoContent {
		ceorr, err = client.PostResponder(ceorr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "reservations.CalculateExchangePostFuture", "Result", ceorr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CalculateExchangeRequest calculate exchange request
type CalculateExchangeRequest struct {
	Properties *CalculateExchangeRequestProperties `json:"properties,omitempty"`
}

// CalculateExchangeRequestProperties calculate exchange request properties
type CalculateExchangeRequestProperties struct {
	// ReservationsToPurchase - List of reservations that are being purchased in this exchange.
	ReservationsToPurchase *[]PurchaseRequest `json:"reservationsToPurchase,omitempty"`
	// ReservationsToExchange - List of reservations that are being returned in this exchange.
	ReservationsToExchange *[]ToReturn `json:"reservationsToExchange,omitempty"`
}

// CalculateExchangeResponseProperties calculateExchange response properties
type CalculateExchangeResponseProperties struct {
	// SessionID - Exchange session identifier
	SessionID      *string `json:"sessionId,omitempty"`
	NetPayable     *Price  `json:"netPayable,omitempty"`
	RefundsTotal   *Price  `json:"refundsTotal,omitempty"`
	PurchasesTotal *Price  `json:"purchasesTotal,omitempty"`
	// ReservationsToPurchase - Details of the reservations being purchased
	ReservationsToPurchase *[]ToPurchaseCalculateExchange `json:"reservationsToPurchase,omitempty"`
	// ReservationsToExchange - Details of the reservations being returned
	ReservationsToExchange *[]ToExchange         `json:"reservationsToExchange,omitempty"`
	PolicyResult           *ExchangePolicyErrors `json:"policyResult,omitempty"`
}

// CalculatePriceResponse ...
type CalculatePriceResponse struct {
	autorest.Response `json:"-"`
	Properties        *CalculatePriceResponseProperties `json:"properties,omitempty"`
}

// CalculatePriceResponseProperties ...
type CalculatePriceResponseProperties struct {
	// BillingCurrencyTotal - Currency and amount that customer will be charged in customer's local currency. Tax is not included.
	BillingCurrencyTotal *CalculatePriceResponsePropertiesBillingCurrencyTotal `json:"billingCurrencyTotal,omitempty"`
	// IsBillingPartnerManaged - True if billing is managed by Microsoft Partner. Used only for CSP accounts.
	IsBillingPartnerManaged *bool `json:"isBillingPartnerManaged,omitempty"`
	// ReservationOrderID - GUID that represents reservation order that can be placed after calculating price.
	ReservationOrderID *string `json:"reservationOrderId,omitempty"`
	// SkuTitle - Title of SKU that is being purchased.
	SkuTitle *string `json:"skuTitle,omitempty"`
	// SkuDescription - Description of SKU that is being purchased.
	SkuDescription *string `json:"skuDescription,omitempty"`
	// PricingCurrencyTotal - Amount that Microsoft uses for record. Used during refund for calculating refund limit. Tax is not included.
	PricingCurrencyTotal *CalculatePriceResponsePropertiesPricingCurrencyTotal `json:"pricingCurrencyTotal,omitempty"`
	PaymentSchedule      *[]PaymentDetail                                      `json:"paymentSchedule,omitempty"`
}

// CalculatePriceResponsePropertiesBillingCurrencyTotal currency and amount that customer will be charged
// in customer's local currency. Tax is not included.
type CalculatePriceResponsePropertiesBillingCurrencyTotal struct {
	CurrencyCode *string  `json:"currencyCode,omitempty"`
	Amount       *float64 `json:"amount,omitempty"`
}

// CalculatePriceResponsePropertiesPricingCurrencyTotal amount that Microsoft uses for record. Used during
// refund for calculating refund limit. Tax is not included.
type CalculatePriceResponsePropertiesPricingCurrencyTotal struct {
	CurrencyCode *string  `json:"currencyCode,omitempty"`
	Amount       *float64 `json:"amount,omitempty"`
}

// Catalog ...
type Catalog struct {
	// ResourceType - READ-ONLY; The type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`
	// Name - READ-ONLY; The name of SKU
	Name *string `json:"name,omitempty"`
	// BillingPlans - The billing plan options available for this SKU.
	BillingPlans map[string][]ReservationBillingPlan `json:"billingPlans"`
	// Terms - READ-ONLY; Available reservation terms for this resource
	Terms *[]ReservationTerm `json:"terms,omitempty"`
	// Locations - READ-ONLY
	Locations *[]string `json:"locations,omitempty"`
	// SkuProperties - READ-ONLY
	SkuProperties *[]SkuProperty `json:"skuProperties,omitempty"`
	// Restrictions - READ-ONLY
	Restrictions *[]SkuRestriction `json:"restrictions,omitempty"`
}

// MarshalJSON is the custom marshaler for Catalog.
func (c Catalog) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.BillingPlans != nil {
		objectMap["billingPlans"] = c.BillingPlans
	}
	return json.Marshal(objectMap)
}

// CreateGenericQuotaRequestParameters quota change requests information.
type CreateGenericQuotaRequestParameters struct {
	// Value - Quota change requests.
	Value *[]CurrentQuotaLimitBase `json:"value,omitempty"`
}

// CurrentQuotaLimit current quota limits.
type CurrentQuotaLimit struct {
	// CurrentQuotaLimitBase - Quota details.
	*CurrentQuotaLimitBase `json:"quotaInformation,omitempty"`
	// QuotaRequestStatusDetails - Additional properties for the quota status for the resource.
	*QuotaRequestStatusDetails `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CurrentQuotaLimit.
func (cql CurrentQuotaLimit) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cql.CurrentQuotaLimitBase != nil {
		objectMap["quotaInformation"] = cql.CurrentQuotaLimitBase
	}
	if cql.QuotaRequestStatusDetails != nil {
		objectMap["properties"] = cql.QuotaRequestStatusDetails
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CurrentQuotaLimit struct.
func (cql *CurrentQuotaLimit) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "quotaInformation":
			if v != nil {
				var currentQuotaLimitBase CurrentQuotaLimitBase
				err = json.Unmarshal(*v, &currentQuotaLimitBase)
				if err != nil {
					return err
				}
				cql.CurrentQuotaLimitBase = &currentQuotaLimitBase
			}
		case "properties":
			if v != nil {
				var quotaRequestStatusDetails QuotaRequestStatusDetails
				err = json.Unmarshal(*v, &quotaRequestStatusDetails)
				if err != nil {
					return err
				}
				cql.QuotaRequestStatusDetails = &quotaRequestStatusDetails
			}
		}
	}

	return nil
}

// CurrentQuotaLimitBase quota properties.
type CurrentQuotaLimitBase struct {
	autorest.Response `json:"-"`
	// Properties - Quota properties for the resource.
	Properties *QuotaProperties `json:"properties,omitempty"`
}

// Error ...
type Error struct {
	Error *ExtendedErrorInfo `json:"error,omitempty"`
}

// ExceptionResponse the API error.
type ExceptionResponse struct {
	// Error - The API error details.
	Error *ServiceError `json:"error,omitempty"`
}

// ExchangeOperationResultResponse exchange operation result
type ExchangeOperationResultResponse struct {
	autorest.Response `json:"-"`
	// ID - It should match what is used to GET the operation result.
	ID *string `json:"id,omitempty"`
	// Name - It must match the last segment of the id field, and will typically be a GUID / system generated value.
	Name *string `json:"name,omitempty"`
	// Status - Status of the operation. Possible values include: 'ExchangeOperationResultStatusSucceeded', 'ExchangeOperationResultStatusFailed', 'ExchangeOperationResultStatusCancelled', 'ExchangeOperationResultStatusPendingRefunds', 'ExchangeOperationResultStatusPendingPurchases'
	Status     ExchangeOperationResultStatus `json:"status,omitempty"`
	Properties *ExchangeResponseProperties   `json:"properties,omitempty"`
	Error      *OperationResultError         `json:"error,omitempty"`
}

// ExchangePolicyError error details
type ExchangePolicyError struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// ExchangePolicyErrors exchange policy errors
type ExchangePolicyErrors struct {
	// PolicyErrors - Exchange Policy errors
	PolicyErrors *[]ExchangePolicyError `json:"policyErrors,omitempty"`
}

// ExchangePostFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ExchangePostFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExchangeClient) (ExchangeOperationResultResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExchangePostFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExchangePostFuture.Result.
func (future *ExchangePostFuture) result(client ExchangeClient) (eorr ExchangeOperationResultResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.ExchangePostFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		eorr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("reservations.ExchangePostFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if eorr.Response.Response, err = future.GetResult(sender); err == nil && eorr.Response.Response.StatusCode != http.StatusNoContent {
		eorr, err = client.PostResponder(eorr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "reservations.ExchangePostFuture", "Result", eorr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExchangeRequest exchange request
type ExchangeRequest struct {
	Properties *ExchangeRequestProperties `json:"properties,omitempty"`
}

// ExchangeRequestProperties exchange request properties
type ExchangeRequestProperties struct {
	// SessionID - SessionId that was returned by CalculateExchange API.
	SessionID *string `json:"sessionId,omitempty"`
}

// ExchangeResponseProperties exchange response properties
type ExchangeResponseProperties struct {
	// SessionID - Exchange session identifier
	SessionID      *string `json:"sessionId,omitempty"`
	NetPayable     *Price  `json:"netPayable,omitempty"`
	RefundsTotal   *Price  `json:"refundsTotal,omitempty"`
	PurchasesTotal *Price  `json:"purchasesTotal,omitempty"`
	// ReservationsToPurchase - Details of the reservations being purchased
	ReservationsToPurchase *[]ToPurchaseExchange `json:"reservationsToPurchase,omitempty"`
	// ReservationsToExchange - Details of the reservations being returned
	ReservationsToExchange *[]ToReturnForExchange `json:"reservationsToExchange,omitempty"`
	PolicyResult           *ExchangePolicyErrors  `json:"policyResult,omitempty"`
}

// ExtendedErrorInfo ...
type ExtendedErrorInfo struct {
	// Code - Possible values include: 'NotSpecified', 'InternalServerError', 'ServerTimeout', 'AuthorizationFailed', 'BadRequest', 'ClientCertificateThumbprintNotSet', 'InvalidRequestContent', 'OperationFailed', 'HTTPMethodNotSupported', 'InvalidRequestURI', 'MissingTenantID', 'InvalidTenantID', 'InvalidReservationOrderID', 'InvalidReservationID', 'ReservationIDNotInReservationOrder', 'ReservationOrderNotFound', 'InvalidSubscriptionID', 'InvalidAccessToken', 'InvalidLocationID', 'UnauthenticatedRequestsThrottled', 'InvalidHealthCheckType', 'Forbidden', 'BillingScopeIDCannotBeChanged', 'AppliedScopesNotAssociatedWithCommerceAccount', 'PatchValuesSameAsExisting', 'RoleAssignmentCreationFailed', 'ReservationOrderCreationFailed', 'ReservationOrderNotEnabled', 'CapacityUpdateScopesFailed', 'UnsupportedReservationTerm', 'ReservationOrderIDAlreadyExists', 'RiskCheckFailed', 'CreateQuoteFailed', 'ActivateQuoteFailed', 'NonsupportedAccountID', 'PaymentInstrumentNotFound', 'MissingAppliedScopesForSingle', 'NoValidReservationsToReRate', 'ReRateOnlyAllowedForEA', 'OperationCannotBePerformedInCurrentState', 'InvalidSingleAppliedScopesCount', 'InvalidFulfillmentRequestParameters', 'NotSupportedCountry', 'InvalidRefundQuantity', 'PurchaseError', 'BillingCustomerInputError', 'BillingPaymentInstrumentSoftError', 'BillingPaymentInstrumentHardError', 'BillingTransientError', 'BillingError', 'FulfillmentConfigurationError', 'FulfillmentOutOfStockError', 'FulfillmentTransientError', 'FulfillmentError', 'CalculatePriceFailed'
	Code    ErrorResponseCode `json:"code,omitempty"`
	Message *string           `json:"message,omitempty"`
}

// ExtendedStatusInfo ...
type ExtendedStatusInfo struct {
	// StatusCode - Possible values include: 'StatusCodeNone', 'StatusCodePending', 'StatusCodeActive', 'StatusCodePurchaseError', 'StatusCodePaymentInstrumentError', 'StatusCodeSplit', 'StatusCodeMerged', 'StatusCodeExpired', 'StatusCodeSucceeded'
	StatusCode StatusCode `json:"statusCode,omitempty"`
	// Message - The message giving detailed information about the status code.
	Message *string `json:"message,omitempty"`
}

// List ...
type List struct {
	autorest.Response `json:"-"`
	Value             *[]Response `json:"value,omitempty"`
	// NextLink - Url to get the next page of reservations.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListCatalog ...
type ListCatalog struct {
	autorest.Response `json:"-"`
	Value             *[]Catalog `json:"value,omitempty"`
}

// ListIterator provides access to a complete listing of Response values.
type ListIterator struct {
	i    int
	page ListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListIterator) Response() List {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListIterator) Value() Response {
	if !iter.page.NotDone() {
		return Response{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListIterator type.
func NewListIterator(page ListPage) ListIterator {
	return ListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (l List) IsEmpty() bool {
	return l.Value == nil || len(*l.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (l List) hasNextLink() bool {
	return l.NextLink != nil && len(*l.NextLink) != 0
}

// listPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (l List) listPreparer(ctx context.Context) (*http.Request, error) {
	if !l.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(l.NextLink)))
}

// ListPage contains a page of Response values.
type ListPage struct {
	fn func(context.Context, List) (List, error)
	l  List
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.l)
		if err != nil {
			return err
		}
		page.l = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListPage) NotDone() bool {
	return !page.l.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListPage) Response() List {
	return page.l
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListPage) Values() []Response {
	if page.l.IsEmpty() {
		return nil
	}
	return *page.l.Value
}

// Creates a new instance of the ListPage type.
func NewListPage(cur List, getNextPage func(context.Context, List) (List, error)) ListPage {
	return ListPage{
		fn: getNextPage,
		l:  cur,
	}
}

// ListResponse ...
type ListResponse struct {
	autorest.Response `json:"-"`
	Value             *[]Response `json:"value,omitempty"`
}

// MergeProperties ...
type MergeProperties struct {
	// Sources - Format of the resource id should be /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	Sources *[]string `json:"sources,omitempty"`
}

// MergePropertiesType ...
type MergePropertiesType struct {
	// MergeDestination - Reservation Resource Id Created due to the merge. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	MergeDestination *string `json:"mergeDestination,omitempty"`
	// MergeSources - Resource Ids of the Source Reservation's merged to form this Reservation. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	MergeSources *[]string `json:"mergeSources,omitempty"`
}

// MergeRequest ...
type MergeRequest struct {
	*MergeProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MergeRequest.
func (mr MergeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mr.MergeProperties != nil {
		objectMap["properties"] = mr.MergeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MergeRequest struct.
func (mr *MergeRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mergeProperties MergeProperties
				err = json.Unmarshal(*v, &mergeProperties)
				if err != nil {
					return err
				}
				mr.MergeProperties = &mergeProperties
			}
		}
	}

	return nil
}

// OperationDisplay ...
type OperationDisplay struct {
	Provider    *string `json:"provider,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Description *string `json:"description,omitempty"`
}

// OperationList ...
type OperationList struct {
	autorest.Response `json:"-"`
	Value             *[]OperationResponse `json:"value,omitempty"`
	// NextLink - Url to get the next page of items.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListIterator provides access to a complete listing of OperationResponse values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() OperationResponse {
	if !iter.page.NotDone() {
		return OperationResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of OperationResponse values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []OperationResponse {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// OperationResponse ...
type OperationResponse struct {
	Name    *string           `json:"name,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
	Origin  *string           `json:"origin,omitempty"`
}

// OperationResultError required if status == failed or status == canceled.
type OperationResultError struct {
	// Code - Required if status == failed or status == cancelled. If status == failed, provide an invariant error code used for error troubleshooting, aggregation, and analysis.
	Code *string `json:"code,omitempty"`
	// Message - Required if status == failed. Localized. If status == failed, provide an actionable error message indicating what error occurred, and what the user can do to address the issue.
	Message *string `json:"message,omitempty"`
}

// OrderBillingPlanInformation information describing the type of billing plan for this reservation.
type OrderBillingPlanInformation struct {
	// PricingCurrencyTotal - Amount of money to be paid for the Order. Tax is not included.
	PricingCurrencyTotal *Price `json:"pricingCurrencyTotal,omitempty"`
	// StartDate - Date when the billing plan has started.
	StartDate *date.Date `json:"startDate,omitempty"`
	// NextPaymentDueDate - For recurring billing plans, indicates the date when next payment will be processed. Null when total is paid off.
	NextPaymentDueDate *date.Date       `json:"nextPaymentDueDate,omitempty"`
	Transactions       *[]PaymentDetail `json:"transactions,omitempty"`
}

// OrderList ...
type OrderList struct {
	autorest.Response `json:"-"`
	Value             *[]OrderResponse `json:"value,omitempty"`
	// NextLink - Url to get the next page of reservationOrders.
	NextLink *string `json:"nextLink,omitempty"`
}

// OrderListIterator provides access to a complete listing of OrderResponse values.
type OrderListIterator struct {
	i    int
	page OrderListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OrderListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OrderListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OrderListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OrderListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OrderListIterator) Response() OrderList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OrderListIterator) Value() OrderResponse {
	if !iter.page.NotDone() {
		return OrderResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OrderListIterator type.
func NewOrderListIterator(page OrderListPage) OrderListIterator {
	return OrderListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OrderList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OrderList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// orderListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OrderList) orderListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OrderListPage contains a page of OrderResponse values.
type OrderListPage struct {
	fn func(context.Context, OrderList) (OrderList, error)
	ol OrderList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OrderListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OrderListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OrderListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OrderListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OrderListPage) Response() OrderList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OrderListPage) Values() []OrderResponse {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OrderListPage type.
func NewOrderListPage(cur OrderList, getNextPage func(context.Context, OrderList) (OrderList, error)) OrderListPage {
	return OrderListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// OrderProperties ...
type OrderProperties struct {
	// DisplayName - Friendly name for user to easily identified the reservation.
	DisplayName *string `json:"displayName,omitempty"`
	// RequestDateTime - This is the DateTime when the reservation was initially requested for purchase.
	RequestDateTime *date.Time `json:"requestDateTime,omitempty"`
	// CreatedDateTime - This is the DateTime when the reservation was created.
	CreatedDateTime *date.Time `json:"createdDateTime,omitempty"`
	// ExpiryDate - This is the date when the Reservation will expire.
	ExpiryDate       *date.Date `json:"expiryDate,omitempty"`
	OriginalQuantity *int32     `json:"originalQuantity,omitempty"`
	// Term - Possible values include: 'P1Y', 'P3Y'
	Term ReservationTerm `json:"term,omitempty"`
	// ProvisioningState - Current state of the reservation.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// BillingPlan - Possible values include: 'Upfront', 'Monthly'
	BillingPlan          ReservationBillingPlan       `json:"billingPlan,omitempty"`
	PlanInformation      *OrderBillingPlanInformation `json:"planInformation,omitempty"`
	ReservationsProperty *[]Response                  `json:"reservations,omitempty"`
}

// OrderPurchaseFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type OrderPurchaseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(OrderClient) (OrderResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *OrderPurchaseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for OrderPurchaseFuture.Result.
func (future *OrderPurchaseFuture) result(client OrderClient) (or OrderResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.OrderPurchaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		or.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("reservations.OrderPurchaseFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if or.Response.Response, err = future.GetResult(sender); err == nil && or.Response.Response.StatusCode != http.StatusNoContent {
		or, err = client.PurchaseResponder(or.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "reservations.OrderPurchaseFuture", "Result", or.Response.Response, "Failure responding to request")
		}
	}
	return
}

// OrderResponse ...
type OrderResponse struct {
	autorest.Response `json:"-"`
	Etag              *int32 `json:"etag,omitempty"`
	// ID - READ-ONLY; Identifier of the reservation
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the reservation
	Name             *string `json:"name,omitempty"`
	*OrderProperties `json:"properties,omitempty"`
	// Type - READ-ONLY; Type of resource. "Microsoft.Capacity/reservations"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for OrderResponse.
func (or OrderResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if or.Etag != nil {
		objectMap["etag"] = or.Etag
	}
	if or.OrderProperties != nil {
		objectMap["properties"] = or.OrderProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OrderResponse struct.
func (or *OrderResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag int32
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				or.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				or.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				or.Name = &name
			}
		case "properties":
			if v != nil {
				var orderProperties OrderProperties
				err = json.Unmarshal(*v, &orderProperties)
				if err != nil {
					return err
				}
				or.OrderProperties = &orderProperties
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				or.Type = &typeVar
			}
		}
	}

	return nil
}

// Patch ...
type Patch struct {
	*PatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Patch.
func (p Patch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PatchProperties != nil {
		objectMap["properties"] = p.PatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Patch struct.
func (p *Patch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var patchProperties PatchProperties
				err = json.Unmarshal(*v, &patchProperties)
				if err != nil {
					return err
				}
				p.PatchProperties = &patchProperties
			}
		}
	}

	return nil
}

// PatchProperties ...
type PatchProperties struct {
	// AppliedScopeType - Possible values include: 'Single', 'Shared'
	AppliedScopeType AppliedScopeType `json:"appliedScopeType,omitempty"`
	AppliedScopes    *[]string        `json:"appliedScopes,omitempty"`
	// InstanceFlexibility - Possible values include: 'On', 'Off'
	InstanceFlexibility InstanceFlexibility `json:"instanceFlexibility,omitempty"`
	// Name - Name of the Reservation
	Name            *string                         `json:"name,omitempty"`
	Renew           *bool                           `json:"renew,omitempty"`
	RenewProperties *PatchPropertiesRenewProperties `json:"renewProperties,omitempty"`
}

// PatchPropertiesRenewProperties ...
type PatchPropertiesRenewProperties struct {
	PurchaseProperties *PurchaseRequest `json:"purchaseProperties,omitempty"`
}

// PaymentDetail information about payment related to a reservation order.
type PaymentDetail struct {
	// DueDate - Date when the payment needs to be done.
	DueDate *date.Date `json:"dueDate,omitempty"`
	// PaymentDate - Date when the transaction is completed. Is null when it is scheduled.
	PaymentDate *date.Date `json:"paymentDate,omitempty"`
	// PricingCurrencyTotal - Amount in pricing currency. Tax not included.
	PricingCurrencyTotal *Price `json:"pricingCurrencyTotal,omitempty"`
	// BillingCurrencyTotal - Amount charged in Billing currency. Tax not included. Is null for future payments
	BillingCurrencyTotal *Price `json:"billingCurrencyTotal,omitempty"`
	// BillingAccount - Shows the Account that is charged for this payment.
	BillingAccount *string `json:"billingAccount,omitempty"`
	// Status - Possible values include: 'PaymentStatusSucceeded', 'PaymentStatusFailed', 'PaymentStatusScheduled', 'PaymentStatusCancelled'
	Status             PaymentStatus       `json:"status,omitempty"`
	ExtendedStatusInfo *ExtendedStatusInfo `json:"extendedStatusInfo,omitempty"`
}

// Price ...
type Price struct {
	// CurrencyCode - The ISO 4217 3-letter currency code for the currency used by this purchase record.
	CurrencyCode *string  `json:"currencyCode,omitempty"`
	Amount       *float64 `json:"amount,omitempty"`
}

// Properties ...
type Properties struct {
	// ReservedResourceType - Possible values include: 'VirtualMachines', 'SQLDatabases', 'SuseLinux', 'CosmosDb', 'RedHat', 'SQLDataWarehouse', 'VMwareCloudSimple', 'RedHatOsa', 'Databricks', 'AppService', 'ManagedDisk', 'BlockBlob', 'RedisCache', 'AzureDataExplorer', 'MySQL', 'MariaDb', 'PostgreSQL', 'DedicatedHost', 'SapHana', 'SQLAzureHybridBenefit'
	ReservedResourceType ReservedResourceType `json:"reservedResourceType,omitempty"`
	// InstanceFlexibility - Possible values include: 'On', 'Off'
	InstanceFlexibility InstanceFlexibility `json:"instanceFlexibility,omitempty"`
	// DisplayName - Friendly name for user to easily identify the reservation
	DisplayName   *string   `json:"displayName,omitempty"`
	AppliedScopes *[]string `json:"appliedScopes,omitempty"`
	// AppliedScopeType - Possible values include: 'Single', 'Shared'
	AppliedScopeType AppliedScopeType `json:"appliedScopeType,omitempty"`
	Quantity         *int32           `json:"quantity,omitempty"`
	// ProvisioningState - Current state of the reservation.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// EffectiveDateTime - DateTime of the Reservation starting when this version is effective from.
	EffectiveDateTime *date.Time `json:"effectiveDateTime,omitempty"`
	// LastUpdatedDateTime - READ-ONLY; DateTime of the last time the Reservation was updated.
	LastUpdatedDateTime *date.Time `json:"lastUpdatedDateTime,omitempty"`
	// ExpiryDate - This is the date when the Reservation will expire.
	ExpiryDate *date.Date `json:"expiryDate,omitempty"`
	// SkuDescription - Description of the SKU in english.
	SkuDescription     *string             `json:"skuDescription,omitempty"`
	ExtendedStatusInfo *ExtendedStatusInfo `json:"extendedStatusInfo,omitempty"`
	// BillingPlan - Possible values include: 'Upfront', 'Monthly'
	BillingPlan     ReservationBillingPlan `json:"billingPlan,omitempty"`
	SplitProperties *SplitPropertiesType   `json:"splitProperties,omitempty"`
	MergeProperties *MergePropertiesType   `json:"mergeProperties,omitempty"`
	BillingScopeID  *string                `json:"billingScopeId,omitempty"`
	Renew           *bool                  `json:"renew,omitempty"`
	// RenewSource - Reservation Id of the reservation from which this reservation is renewed. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
	RenewSource *string `json:"renewSource,omitempty"`
	// RenewDestination - Reservation Id of the reservation which is purchased because of renew. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
	RenewDestination *string                  `json:"renewDestination,omitempty"`
	RenewProperties  *RenewPropertiesResponse `json:"renewProperties,omitempty"`
	// Term - Possible values include: 'P1Y', 'P3Y'
	Term ReservationTerm `json:"term,omitempty"`
}

// MarshalJSON is the custom marshaler for Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ReservedResourceType != "" {
		objectMap["reservedResourceType"] = p.ReservedResourceType
	}
	if p.InstanceFlexibility != "" {
		objectMap["instanceFlexibility"] = p.InstanceFlexibility
	}
	if p.DisplayName != nil {
		objectMap["displayName"] = p.DisplayName
	}
	if p.AppliedScopes != nil {
		objectMap["appliedScopes"] = p.AppliedScopes
	}
	if p.AppliedScopeType != "" {
		objectMap["appliedScopeType"] = p.AppliedScopeType
	}
	if p.Quantity != nil {
		objectMap["quantity"] = p.Quantity
	}
	if p.ProvisioningState != nil {
		objectMap["provisioningState"] = p.ProvisioningState
	}
	if p.EffectiveDateTime != nil {
		objectMap["effectiveDateTime"] = p.EffectiveDateTime
	}
	if p.ExpiryDate != nil {
		objectMap["expiryDate"] = p.ExpiryDate
	}
	if p.SkuDescription != nil {
		objectMap["skuDescription"] = p.SkuDescription
	}
	if p.ExtendedStatusInfo != nil {
		objectMap["extendedStatusInfo"] = p.ExtendedStatusInfo
	}
	if p.BillingPlan != "" {
		objectMap["billingPlan"] = p.BillingPlan
	}
	if p.SplitProperties != nil {
		objectMap["splitProperties"] = p.SplitProperties
	}
	if p.MergeProperties != nil {
		objectMap["mergeProperties"] = p.MergeProperties
	}
	if p.BillingScopeID != nil {
		objectMap["billingScopeId"] = p.BillingScopeID
	}
	if p.Renew != nil {
		objectMap["renew"] = p.Renew
	}
	if p.RenewSource != nil {
		objectMap["renewSource"] = p.RenewSource
	}
	if p.RenewDestination != nil {
		objectMap["renewDestination"] = p.RenewDestination
	}
	if p.RenewProperties != nil {
		objectMap["renewProperties"] = p.RenewProperties
	}
	if p.Term != "" {
		objectMap["term"] = p.Term
	}
	return json.Marshal(objectMap)
}

// PurchaseRequest ...
type PurchaseRequest struct {
	Sku *SkuName `json:"sku,omitempty"`
	// Location - The Azure Region where the reserved resource lives.
	Location                   *string `json:"location,omitempty"`
	*PurchaseRequestProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PurchaseRequest.
func (pr PurchaseRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pr.Sku != nil {
		objectMap["sku"] = pr.Sku
	}
	if pr.Location != nil {
		objectMap["location"] = pr.Location
	}
	if pr.PurchaseRequestProperties != nil {
		objectMap["properties"] = pr.PurchaseRequestProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PurchaseRequest struct.
func (pr *PurchaseRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku SkuName
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				pr.Sku = &sku
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pr.Location = &location
			}
		case "properties":
			if v != nil {
				var purchaseRequestProperties PurchaseRequestProperties
				err = json.Unmarshal(*v, &purchaseRequestProperties)
				if err != nil {
					return err
				}
				pr.PurchaseRequestProperties = &purchaseRequestProperties
			}
		}
	}

	return nil
}

// PurchaseRequestProperties ...
type PurchaseRequestProperties struct {
	// ReservedResourceType - Possible values include: 'VirtualMachines', 'SQLDatabases', 'SuseLinux', 'CosmosDb', 'RedHat', 'SQLDataWarehouse', 'VMwareCloudSimple', 'RedHatOsa', 'Databricks', 'AppService', 'ManagedDisk', 'BlockBlob', 'RedisCache', 'AzureDataExplorer', 'MySQL', 'MariaDb', 'PostgreSQL', 'DedicatedHost', 'SapHana', 'SQLAzureHybridBenefit'
	ReservedResourceType ReservedResourceType `json:"reservedResourceType,omitempty"`
	BillingScopeID       *string              `json:"billingScopeId,omitempty"`
	// Term - Possible values include: 'P1Y', 'P3Y'
	Term ReservationTerm `json:"term,omitempty"`
	// BillingPlan - Possible values include: 'Upfront', 'Monthly'
	BillingPlan ReservationBillingPlan `json:"billingPlan,omitempty"`
	Quantity    *int32                 `json:"quantity,omitempty"`
	// DisplayName - Friendly name of the Reservation
	DisplayName *string `json:"displayName,omitempty"`
	// AppliedScopeType - Possible values include: 'Single', 'Shared'
	AppliedScopeType AppliedScopeType `json:"appliedScopeType,omitempty"`
	AppliedScopes    *[]string        `json:"appliedScopes,omitempty"`
	Renew            *bool            `json:"renew,omitempty"`
	// ReservedResourceProperties - Properties specific to each reserved resource type. Not required if not applicable.
	ReservedResourceProperties *PurchaseRequestPropertiesReservedResourceProperties `json:"reservedResourceProperties,omitempty"`
}

// PurchaseRequestPropertiesReservedResourceProperties properties specific to each reserved resource type.
// Not required if not applicable.
type PurchaseRequestPropertiesReservedResourceProperties struct {
	// InstanceFlexibility - Possible values include: 'On', 'Off'
	InstanceFlexibility InstanceFlexibility `json:"instanceFlexibility,omitempty"`
}

// QuotaCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type QuotaCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(QuotaClient) (SetObject, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *QuotaCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for QuotaCreateOrUpdateFuture.Result.
func (future *QuotaCreateOrUpdateFuture) result(client QuotaClient) (so SetObject, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.QuotaCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		so.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("reservations.QuotaCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if so.Response.Response, err = future.GetResult(sender); err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
		so, err = client.CreateOrUpdateResponder(so.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "reservations.QuotaCreateOrUpdateFuture", "Result", so.Response.Response, "Failure responding to request")
		}
	}
	return
}

// QuotaLimits quota limits.
type QuotaLimits struct {
	autorest.Response `json:"-"`
	// Value - List of quotas (service limits).
	Value *[]CurrentQuotaLimitBase `json:"value,omitempty"`
	// NextLink - The URI for fetching the next page of quotas (service limits). When no more pages exist, the value is null.
	NextLink *string `json:"nextLink,omitempty"`
}

// QuotaLimitsIterator provides access to a complete listing of CurrentQuotaLimitBase values.
type QuotaLimitsIterator struct {
	i    int
	page QuotaLimitsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *QuotaLimitsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QuotaLimitsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *QuotaLimitsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter QuotaLimitsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter QuotaLimitsIterator) Response() QuotaLimits {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter QuotaLimitsIterator) Value() CurrentQuotaLimitBase {
	if !iter.page.NotDone() {
		return CurrentQuotaLimitBase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the QuotaLimitsIterator type.
func NewQuotaLimitsIterator(page QuotaLimitsPage) QuotaLimitsIterator {
	return QuotaLimitsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ql QuotaLimits) IsEmpty() bool {
	return ql.Value == nil || len(*ql.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ql QuotaLimits) hasNextLink() bool {
	return ql.NextLink != nil && len(*ql.NextLink) != 0
}

// quotaLimitsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ql QuotaLimits) quotaLimitsPreparer(ctx context.Context) (*http.Request, error) {
	if !ql.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ql.NextLink)))
}

// QuotaLimitsPage contains a page of CurrentQuotaLimitBase values.
type QuotaLimitsPage struct {
	fn func(context.Context, QuotaLimits) (QuotaLimits, error)
	ql QuotaLimits
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *QuotaLimitsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QuotaLimitsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ql)
		if err != nil {
			return err
		}
		page.ql = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *QuotaLimitsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page QuotaLimitsPage) NotDone() bool {
	return !page.ql.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page QuotaLimitsPage) Response() QuotaLimits {
	return page.ql
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page QuotaLimitsPage) Values() []CurrentQuotaLimitBase {
	if page.ql.IsEmpty() {
		return nil
	}
	return *page.ql.Value
}

// Creates a new instance of the QuotaLimitsPage type.
func NewQuotaLimitsPage(cur QuotaLimits, getNextPage func(context.Context, QuotaLimits) (QuotaLimits, error)) QuotaLimitsPage {
	return QuotaLimitsPage{
		fn: getNextPage,
		ql: cur,
	}
}

// QuotaLimitsResponse quotas (service limits) in the request response.
type QuotaLimitsResponse struct {
	// Value - List of quotas with the quota request status.
	Value *[]CurrentQuotaLimit `json:"value,omitempty"`
	// NextLink - The URI for fetching the next page of quota limits. When no more pages exist, the value is null.
	NextLink *string `json:"nextLink,omitempty"`
}

// QuotaProperties quota properties for the resource.
type QuotaProperties struct {
	// Limit - Quota properties.
	Limit *int32 `json:"limit,omitempty"`
	// CurrentValue - READ-ONLY; Current usage value for the resource.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Unit -  The limit units, such as **count** and **bytes**. Use the unit field provided in the response of the GET quota operation.
	Unit *string `json:"unit,omitempty"`
	// Name - Name of the resource provide by the resource provider. Use this property for quotaRequests resource operations.
	Name *ResourceName `json:"name,omitempty"`
	// ResourceType - The name of the resource type.
	ResourceType interface{} `json:"resourceType,omitempty"`
	// QuotaPeriod - READ-ONLY; The time period over which the quota usage values are summarized. For example, P1D (per one day), PT1M (per one minute), and PT1S (per one second). This parameter is optional because, for some resources such as compute, the time period is irrelevant.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
	// Properties - Additional properties for the specified resource provider.
	Properties interface{} `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for QuotaProperties.
func (qp QuotaProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qp.Limit != nil {
		objectMap["limit"] = qp.Limit
	}
	if qp.Unit != nil {
		objectMap["unit"] = qp.Unit
	}
	if qp.Name != nil {
		objectMap["name"] = qp.Name
	}
	if qp.ResourceType != nil {
		objectMap["resourceType"] = qp.ResourceType
	}
	if qp.Properties != nil {
		objectMap["properties"] = qp.Properties
	}
	return json.Marshal(objectMap)
}

// QuotaRequestDetails quota request details.
type QuotaRequestDetails struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Quota request ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Quota request name.
	Name *string `json:"name,omitempty"`
	// QuotaRequestProperties - Quota request details.
	*QuotaRequestProperties `json:"properties,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for QuotaRequestDetails.
func (qrd QuotaRequestDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qrd.QuotaRequestProperties != nil {
		objectMap["properties"] = qrd.QuotaRequestProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for QuotaRequestDetails struct.
func (qrd *QuotaRequestDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				qrd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				qrd.Name = &name
			}
		case "properties":
			if v != nil {
				var quotaRequestProperties QuotaRequestProperties
				err = json.Unmarshal(*v, &quotaRequestProperties)
				if err != nil {
					return err
				}
				qrd.QuotaRequestProperties = &quotaRequestProperties
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				qrd.Type = &typeVar
			}
		}
	}

	return nil
}

// QuotaRequestDetailsList quota request details.
type QuotaRequestDetailsList struct {
	autorest.Response `json:"-"`
	// Value - The quota requests.
	Value *[]QuotaRequestDetails `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of quota limits. When there are no more pages, this is null.
	NextLink *string `json:"nextLink,omitempty"`
}

// QuotaRequestDetailsListIterator provides access to a complete listing of QuotaRequestDetails values.
type QuotaRequestDetailsListIterator struct {
	i    int
	page QuotaRequestDetailsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *QuotaRequestDetailsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QuotaRequestDetailsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *QuotaRequestDetailsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter QuotaRequestDetailsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter QuotaRequestDetailsListIterator) Response() QuotaRequestDetailsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter QuotaRequestDetailsListIterator) Value() QuotaRequestDetails {
	if !iter.page.NotDone() {
		return QuotaRequestDetails{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the QuotaRequestDetailsListIterator type.
func NewQuotaRequestDetailsListIterator(page QuotaRequestDetailsListPage) QuotaRequestDetailsListIterator {
	return QuotaRequestDetailsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (qrdl QuotaRequestDetailsList) IsEmpty() bool {
	return qrdl.Value == nil || len(*qrdl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (qrdl QuotaRequestDetailsList) hasNextLink() bool {
	return qrdl.NextLink != nil && len(*qrdl.NextLink) != 0
}

// quotaRequestDetailsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (qrdl QuotaRequestDetailsList) quotaRequestDetailsListPreparer(ctx context.Context) (*http.Request, error) {
	if !qrdl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(qrdl.NextLink)))
}

// QuotaRequestDetailsListPage contains a page of QuotaRequestDetails values.
type QuotaRequestDetailsListPage struct {
	fn   func(context.Context, QuotaRequestDetailsList) (QuotaRequestDetailsList, error)
	qrdl QuotaRequestDetailsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *QuotaRequestDetailsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QuotaRequestDetailsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.qrdl)
		if err != nil {
			return err
		}
		page.qrdl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *QuotaRequestDetailsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page QuotaRequestDetailsListPage) NotDone() bool {
	return !page.qrdl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page QuotaRequestDetailsListPage) Response() QuotaRequestDetailsList {
	return page.qrdl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page QuotaRequestDetailsListPage) Values() []QuotaRequestDetails {
	if page.qrdl.IsEmpty() {
		return nil
	}
	return *page.qrdl.Value
}

// Creates a new instance of the QuotaRequestDetailsListPage type.
func NewQuotaRequestDetailsListPage(cur QuotaRequestDetailsList, getNextPage func(context.Context, QuotaRequestDetailsList) (QuotaRequestDetailsList, error)) QuotaRequestDetailsListPage {
	return QuotaRequestDetailsListPage{
		fn:   getNextPage,
		qrdl: cur,
	}
}

// QuotaRequestOneResourceProperties the details of quota request.
type QuotaRequestOneResourceProperties struct {
	// ProvisioningState - READ-ONLY; The quota request status.
	ProvisioningState interface{} `json:"provisioningState,omitempty"`
	// Message - READ-ONLY; User friendly status message.
	Message *string `json:"message,omitempty"`
	// RequestSubmitTime - READ-ONLY; The time when the quota request was submitted using format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	RequestSubmitTime *date.Time `json:"requestSubmitTime,omitempty"`
	// CurrentQuotaLimitBase - The quota request addition properties.
	*CurrentQuotaLimitBase `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for QuotaRequestOneResourceProperties.
func (qrorp QuotaRequestOneResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qrorp.CurrentQuotaLimitBase != nil {
		objectMap["properties"] = qrorp.CurrentQuotaLimitBase
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for QuotaRequestOneResourceProperties struct.
func (qrorp *QuotaRequestOneResourceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "provisioningState":
			if v != nil {
				var provisioningState interface{}
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				qrorp.ProvisioningState = provisioningState
			}
		case "message":
			if v != nil {
				var message string
				err = json.Unmarshal(*v, &message)
				if err != nil {
					return err
				}
				qrorp.Message = &message
			}
		case "requestSubmitTime":
			if v != nil {
				var requestSubmitTime date.Time
				err = json.Unmarshal(*v, &requestSubmitTime)
				if err != nil {
					return err
				}
				qrorp.RequestSubmitTime = &requestSubmitTime
			}
		case "properties":
			if v != nil {
				var currentQuotaLimitBase CurrentQuotaLimitBase
				err = json.Unmarshal(*v, &currentQuotaLimitBase)
				if err != nil {
					return err
				}
				qrorp.CurrentQuotaLimitBase = &currentQuotaLimitBase
			}
		}
	}

	return nil
}

// QuotaRequestOneResourceSubmitResponse response for the quota submission request.
type QuotaRequestOneResourceSubmitResponse struct {
	// ID - READ-ONLY; The quota request ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the quota request.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of resource. "Microsoft.Capacity/ServiceLimits"
	Type *string `json:"type,omitempty"`
	// QuotaRequestOneResourceProperties - The details for quota request.
	*QuotaRequestOneResourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for QuotaRequestOneResourceSubmitResponse.
func (qrorsr QuotaRequestOneResourceSubmitResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qrorsr.QuotaRequestOneResourceProperties != nil {
		objectMap["properties"] = qrorsr.QuotaRequestOneResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for QuotaRequestOneResourceSubmitResponse struct.
func (qrorsr *QuotaRequestOneResourceSubmitResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				qrorsr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				qrorsr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				qrorsr.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var quotaRequestOneResourceProperties QuotaRequestOneResourceProperties
				err = json.Unmarshal(*v, &quotaRequestOneResourceProperties)
				if err != nil {
					return err
				}
				qrorsr.QuotaRequestOneResourceProperties = &quotaRequestOneResourceProperties
			}
		}
	}

	return nil
}

// QuotaRequestProperties the details of quota request.
type QuotaRequestProperties struct {
	// ProvisioningState - The quota request status.
	ProvisioningState interface{} `json:"provisioningState,omitempty"`
	// Message - READ-ONLY; User friendly status message.
	Message *string `json:"message,omitempty"`
	// RequestSubmitTime - READ-ONLY; The time when the quota request was submitted using format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	RequestSubmitTime *date.Time `json:"requestSubmitTime,omitempty"`
	// Value - The quotaRequests.
	Value *[]SubRequest `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for QuotaRequestProperties.
func (qrp QuotaRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qrp.ProvisioningState != nil {
		objectMap["provisioningState"] = qrp.ProvisioningState
	}
	if qrp.Value != nil {
		objectMap["value"] = qrp.Value
	}
	return json.Marshal(objectMap)
}

// QuotaRequestStatusDetails quota request status details.
type QuotaRequestStatusDetails struct {
	// ProvisioningState - READ-ONLY; The details of the quota request status.
	ProvisioningState interface{} `json:"provisioningState,omitempty"`
	// Message - READ-ONLY; A user friendly message.
	Message *string `json:"message,omitempty"`
}

// QuotaRequestSubmitResponse response for the quota submission request.
type QuotaRequestSubmitResponse struct {
	// ID - READ-ONLY; The quota request ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the quota request.
	Name *string `json:"name,omitempty"`
	// Properties - The quota request details.
	Properties *QuotaRequestProperties `json:"properties,omitempty"`
	// Type - READ-ONLY; Type of resource. "Microsoft.Capacity/serviceLimits"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for QuotaRequestSubmitResponse.
func (qrsr QuotaRequestSubmitResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qrsr.Properties != nil {
		objectMap["properties"] = qrsr.Properties
	}
	return json.Marshal(objectMap)
}

// QuotaRequestSubmitResponse201 response with request ID that the quota request was accepted.
type QuotaRequestSubmitResponse201 struct {
	// ID - READ-ONLY; The quota request ID. Use the requestId parameter to check the request status.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Operation ID
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// QuotaRequestStatusDetails - Quota request status.
	*QuotaRequestStatusDetails `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for QuotaRequestSubmitResponse201.
func (qrsr2 QuotaRequestSubmitResponse201) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qrsr2.QuotaRequestStatusDetails != nil {
		objectMap["properties"] = qrsr2.QuotaRequestStatusDetails
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for QuotaRequestSubmitResponse201 struct.
func (qrsr2 *QuotaRequestSubmitResponse201) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				qrsr2.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				qrsr2.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				qrsr2.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var quotaRequestStatusDetails QuotaRequestStatusDetails
				err = json.Unmarshal(*v, &quotaRequestStatusDetails)
				if err != nil {
					return err
				}
				qrsr2.QuotaRequestStatusDetails = &quotaRequestStatusDetails
			}
		}
	}

	return nil
}

// QuotaUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type QuotaUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(QuotaClient) (SetObject, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *QuotaUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for QuotaUpdateFuture.Result.
func (future *QuotaUpdateFuture) result(client QuotaClient) (so SetObject, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.QuotaUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		so.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("reservations.QuotaUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if so.Response.Response, err = future.GetResult(sender); err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
		so, err = client.UpdateResponder(so.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "reservations.QuotaUpdateFuture", "Result", so.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RenewPropertiesResponse ...
type RenewPropertiesResponse struct {
	PurchaseProperties *PurchaseRequest `json:"purchaseProperties,omitempty"`
	// PricingCurrencyTotal - Amount that Microsoft uses for record. Used during refund for calculating refund limit. Tax is not included. This is locked price 30 days before expiry.
	PricingCurrencyTotal *RenewPropertiesResponsePricingCurrencyTotal `json:"pricingCurrencyTotal,omitempty"`
	// BillingCurrencyTotal - Currency and amount that customer will be charged in customer's local currency for renewal purchase. Tax is not included.
	BillingCurrencyTotal *RenewPropertiesResponseBillingCurrencyTotal `json:"billingCurrencyTotal,omitempty"`
}

// RenewPropertiesResponseBillingCurrencyTotal currency and amount that customer will be charged in
// customer's local currency for renewal purchase. Tax is not included.
type RenewPropertiesResponseBillingCurrencyTotal struct {
	CurrencyCode *string  `json:"currencyCode,omitempty"`
	Amount       *float64 `json:"amount,omitempty"`
}

// RenewPropertiesResponsePricingCurrencyTotal amount that Microsoft uses for record. Used during refund
// for calculating refund limit. Tax is not included. This is locked price 30 days before expiry.
type RenewPropertiesResponsePricingCurrencyTotal struct {
	CurrencyCode *string  `json:"currencyCode,omitempty"`
	Amount       *float64 `json:"amount,omitempty"`
}

// ReservationAvailableScopesFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReservationAvailableScopesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (AvailableScopeProperties, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReservationAvailableScopesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReservationAvailableScopesFuture.Result.
func (future *ReservationAvailableScopesFuture) result(client Client) (asp AvailableScopeProperties, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.ReservationAvailableScopesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		asp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("reservations.ReservationAvailableScopesFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if asp.Response.Response, err = future.GetResult(sender); err == nil && asp.Response.Response.StatusCode != http.StatusNoContent {
		asp, err = client.AvailableScopesResponder(asp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "reservations.ReservationAvailableScopesFuture", "Result", asp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReservationMergeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReservationMergeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (ListResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReservationMergeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReservationMergeFuture.Result.
func (future *ReservationMergeFuture) result(client Client) (lr ListResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.ReservationMergeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		lr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("reservations.ReservationMergeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if lr.Response.Response, err = future.GetResult(sender); err == nil && lr.Response.Response.StatusCode != http.StatusNoContent {
		lr, err = client.MergeResponder(lr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "reservations.ReservationMergeFuture", "Result", lr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReservationUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReservationUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReservationUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReservationUpdateFuture.Result.
func (future *ReservationUpdateFuture) result(client Client) (r Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.ReservationUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		r.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("reservations.ReservationUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.UpdateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "reservations.ReservationUpdateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ResourceName resource name provided by the resource provider. Use this property for quotaRequest
// parameter.
type ResourceName struct {
	// Value - Resource name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; Resource display localized name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceName.
func (rn ResourceName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rn.Value != nil {
		objectMap["value"] = rn.Value
	}
	return json.Marshal(objectMap)
}

// Response ...
type Response struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; The Azure Region where the reserved resource lives.
	Location *string `json:"location,omitempty"`
	Etag     *int32  `json:"etag,omitempty"`
	// ID - READ-ONLY; Identifier of the reservation
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the reservation
	Name       *string     `json:"name,omitempty"`
	Sku        *SkuName    `json:"sku,omitempty"`
	Properties *Properties `json:"properties,omitempty"`
	// Type - READ-ONLY; Type of resource. "Microsoft.Capacity/reservationOrders/reservations"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Response.
func (r Response) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Etag != nil {
		objectMap["etag"] = r.Etag
	}
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	if r.Properties != nil {
		objectMap["properties"] = r.Properties
	}
	return json.Marshal(objectMap)
}

// ScopeProperties ...
type ScopeProperties struct {
	Scope *string `json:"scope,omitempty"`
	Valid *bool   `json:"valid,omitempty"`
}

// ServiceError the API error details.
type ServiceError struct {
	// Code - The error code.
	Code *string `json:"code,omitempty"`
	// Message - The error message text.
	Message *string `json:"message,omitempty"`
	// Details - READ-ONLY; The list of error details.
	Details *[]ServiceErrorDetail `json:"details,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceError.
func (se ServiceError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if se.Code != nil {
		objectMap["code"] = se.Code
	}
	if se.Message != nil {
		objectMap["message"] = se.Message
	}
	return json.Marshal(objectMap)
}

// ServiceErrorDetail the error details.
type ServiceErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// SkuName ...
type SkuName struct {
	Name *string `json:"name,omitempty"`
}

// SkuProperty ...
type SkuProperty struct {
	// Name - An invariant to describe the feature.
	Name *string `json:"name,omitempty"`
	// Value - An invariant if the feature is measured by quantity.
	Value *string `json:"value,omitempty"`
}

// SkuRestriction ...
type SkuRestriction struct {
	// Type - The type of restrictions.
	Type *string `json:"type,omitempty"`
	// Values - The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
	Values *[]string `json:"values,omitempty"`
	// ReasonCode - The reason for restriction.
	ReasonCode *string `json:"reasonCode,omitempty"`
}

// SplitFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type SplitFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (ListResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SplitFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SplitFuture.Result.
func (future *SplitFuture) result(client Client) (lr ListResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "reservations.SplitFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		lr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("reservations.SplitFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if lr.Response.Response, err = future.GetResult(sender); err == nil && lr.Response.Response.StatusCode != http.StatusNoContent {
		lr, err = client.SplitResponder(lr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "reservations.SplitFuture", "Result", lr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SplitProperties ...
type SplitProperties struct {
	// Quantities - List of the quantities in the new reservations to create.
	Quantities *[]int32 `json:"quantities,omitempty"`
	// ReservationID - Resource id of the reservation to be split. Format of the resource id should be /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	ReservationID *string `json:"reservationId,omitempty"`
}

// SplitPropertiesType ...
type SplitPropertiesType struct {
	// SplitDestinations - List of destination Resource Id that are created due to split. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	SplitDestinations *[]string `json:"splitDestinations,omitempty"`
	// SplitSource - Resource Id of the Reservation from which this is split. Format of the resource Id is /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
	SplitSource *string `json:"splitSource,omitempty"`
}

// SplitRequest ...
type SplitRequest struct {
	*SplitProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SplitRequest.
func (sr SplitRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.SplitProperties != nil {
		objectMap["properties"] = sr.SplitProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SplitRequest struct.
func (sr *SplitRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var splitProperties SplitProperties
				err = json.Unmarshal(*v, &splitProperties)
				if err != nil {
					return err
				}
				sr.SplitProperties = &splitProperties
			}
		}
	}

	return nil
}

// SubRequest the sub-request submitted with the quota request.
type SubRequest struct {
	// Limit - READ-ONLY; Quota (resource limit).
	Limit *int32 `json:"limit,omitempty"`
	// Name - The resource name.
	Name *ResourceName `json:"name,omitempty"`
	// ResourceType - READ-ONLY; Resource type for which the quota check was made.
	ResourceType *string `json:"resourceType,omitempty"`
	// Unit -  The limit units, such as **count** and **bytes**. Use the unit field provided in the response of the GET quota operation.
	Unit *string `json:"unit,omitempty"`
	// ProvisioningState - The quota request status.
	ProvisioningState interface{} `json:"provisioningState,omitempty"`
	// Message - READ-ONLY; User-friendly status message.
	Message *string `json:"message,omitempty"`
	// SubRequestID - READ-ONLY; Sub request ID for individual request.
	SubRequestID *string `json:"subRequestId,omitempty"`
}

// MarshalJSON is the custom marshaler for SubRequest.
func (sr SubRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Name != nil {
		objectMap["name"] = sr.Name
	}
	if sr.Unit != nil {
		objectMap["unit"] = sr.Unit
	}
	if sr.ProvisioningState != nil {
		objectMap["provisioningState"] = sr.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// SubscriptionScopeProperties ...
type SubscriptionScopeProperties struct {
	Scopes *[]ScopeProperties `json:"scopes,omitempty"`
}

// ToExchange reservation refund details
type ToExchange struct {
	// ReservationID - Fully qualified id of the Reservation being returned.
	ReservationID *string `json:"reservationId,omitempty"`
	// Quantity - Quantity to be returned
	Quantity            *int32              `json:"quantity,omitempty"`
	BillingRefundAmount *Price              `json:"billingRefundAmount,omitempty"`
	BillingInformation  *BillingInformation `json:"billingInformation,omitempty"`
}

// ToPurchaseCalculateExchange reservation purchase details
type ToPurchaseCalculateExchange struct {
	Properties           *PurchaseRequest `json:"properties,omitempty"`
	BillingCurrencyTotal *Price           `json:"billingCurrencyTotal,omitempty"`
}

// ToPurchaseExchange reservation purchase details
type ToPurchaseExchange struct {
	// ReservationOrderID - Fully qualified id of the ReservationOrder being purchased
	ReservationOrderID *string `json:"reservationOrderId,omitempty"`
	// ReservationID - Fully qualified id of the Reservation being purchased. This value is only guaranteed to be non-null if the purchase is successful.
	ReservationID        *string          `json:"reservationId,omitempty"`
	Properties           *PurchaseRequest `json:"properties,omitempty"`
	BillingCurrencyTotal *Price           `json:"billingCurrencyTotal,omitempty"`
	// Status - Possible values include: 'OperationStatusSucceeded', 'OperationStatusFailed', 'OperationStatusCancelled', 'OperationStatusPending'
	Status OperationStatus `json:"status,omitempty"`
}

// ToReturn reservation to return
type ToReturn struct {
	// ReservationID - Fully qualified identifier of the Reservation being returned
	ReservationID *string `json:"reservationId,omitempty"`
	// Quantity - Quantity to be returned. Must be greater than zero.
	Quantity *int32 `json:"quantity,omitempty"`
}

// ToReturnForExchange reservation refund details
type ToReturnForExchange struct {
	// ReservationID - Fully qualified id of the Reservation being returned.
	ReservationID *string `json:"reservationId,omitempty"`
	// Quantity - Quantity to be returned
	Quantity            *int32              `json:"quantity,omitempty"`
	BillingRefundAmount *Price              `json:"billingRefundAmount,omitempty"`
	BillingInformation  *BillingInformation `json:"billingInformation,omitempty"`
	// Status - Possible values include: 'OperationStatusSucceeded', 'OperationStatusFailed', 'OperationStatusCancelled', 'OperationStatusPending'
	Status OperationStatus `json:"status,omitempty"`
}
