package avs

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/avs/mgmt/2020-07-17-preview/avs"

// AdminCredentials administrative credentials for accessing vCenter and NSX-T
type AdminCredentials struct {
	autorest.Response `json:"-"`
	// NsxtUsername - READ-ONLY; NSX-T Manager username
	NsxtUsername *string `json:"nsxtUsername,omitempty"`
	// NsxtPassword - READ-ONLY; NSX-T Manager password
	NsxtPassword *string `json:"nsxtPassword,omitempty"`
	// VcenterUsername - READ-ONLY; vCenter admin username
	VcenterUsername *string `json:"vcenterUsername,omitempty"`
	// VcenterPassword - READ-ONLY; vCenter admin password
	VcenterPassword *string `json:"vcenterPassword,omitempty"`
}

// AuthorizationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AuthorizationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AuthorizationsClient) (ExpressRouteAuthorization, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AuthorizationsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AuthorizationsCreateOrUpdateFuture.Result.
func (future *AuthorizationsCreateOrUpdateFuture) result(client AuthorizationsClient) (era ExpressRouteAuthorization, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.AuthorizationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		era.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.AuthorizationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if era.Response.Response, err = future.GetResult(sender); err == nil && era.Response.Response.StatusCode != http.StatusNoContent {
		era, err = client.CreateOrUpdateResponder(era.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.AuthorizationsCreateOrUpdateFuture", "Result", era.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AuthorizationsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AuthorizationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AuthorizationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AuthorizationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AuthorizationsDeleteFuture.Result.
func (future *AuthorizationsDeleteFuture) result(client AuthorizationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.AuthorizationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.AuthorizationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Circuit an ExpressRoute Circuit
type Circuit struct {
	// PrimarySubnet - READ-ONLY; CIDR of primary subnet
	PrimarySubnet *string `json:"primarySubnet,omitempty"`
	// SecondarySubnet - READ-ONLY; CIDR of secondary subnet
	SecondarySubnet *string `json:"secondarySubnet,omitempty"`
	// ExpressRouteID - READ-ONLY; Identifier of the ExpressRoute Circuit (Microsoft Colo only)
	ExpressRouteID *string `json:"expressRouteID,omitempty"`
	// ExpressRoutePrivatePeeringID - READ-ONLY; ExpressRoute Circuit private peering identifier
	ExpressRoutePrivatePeeringID *string `json:"expressRoutePrivatePeeringID,omitempty"`
}

// CloudError API error response
type CloudError struct {
	// Error - An error returned by the API
	Error *ErrorResponse `json:"error,omitempty"`
}

// Cluster a cluster resource
type Cluster struct {
	autorest.Response `json:"-"`
	// Sku - The cluster SKU
	Sku *Sku `json:"sku,omitempty"`
	// ClusterProperties - The properties of a cluster resource
	*ClusterProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Sku != nil {
		objectMap["sku"] = c.Sku
	}
	if c.ClusterProperties != nil {
		objectMap["properties"] = c.ClusterProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cluster struct.
func (c *Cluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				c.Sku = &sku
			}
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				c.ClusterProperties = &clusterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ClusterList a paged list of clusters
type ClusterList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on a page
	Value *[]Cluster `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterListIterator provides access to a complete listing of Cluster values.
type ClusterListIterator struct {
	i    int
	page ClusterListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClusterListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterListIterator) Response() ClusterList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterListIterator) Value() Cluster {
	if !iter.page.NotDone() {
		return Cluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClusterListIterator type.
func NewClusterListIterator(page ClusterListPage) ClusterListIterator {
	return ClusterListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl ClusterList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cl ClusterList) hasNextLink() bool {
	return cl.NextLink != nil && len(*cl.NextLink) != 0
}

// clusterListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl ClusterList) clusterListPreparer(ctx context.Context) (*http.Request, error) {
	if !cl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// ClusterListPage contains a page of Cluster values.
type ClusterListPage struct {
	fn func(context.Context, ClusterList) (ClusterList, error)
	cl ClusterList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cl)
		if err != nil {
			return err
		}
		page.cl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClusterListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterListPage) Response() ClusterList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterListPage) Values() []Cluster {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the ClusterListPage type.
func NewClusterListPage(cur ClusterList, getNextPage func(context.Context, ClusterList) (ClusterList, error)) ClusterListPage {
	return ClusterListPage{
		fn: getNextPage,
		cl: cur,
	}
}

// ClusterProperties the properties of a cluster
type ClusterProperties struct {
	// ProvisioningState - READ-ONLY; The state of the cluster provisioning. Possible values include: 'Succeeded', 'Failed', 'Cancelled', 'Deleting', 'Updating'
	ProvisioningState ClusterProvisioningState `json:"provisioningState,omitempty"`
	// ClusterSize - The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`
	// ClusterID - READ-ONLY; The identity
	ClusterID *int32 `json:"clusterId,omitempty"`
	// Hosts - READ-ONLY; The hosts
	Hosts *[]string `json:"hosts,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterProperties.
func (cp ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.ClusterSize != nil {
		objectMap["clusterSize"] = cp.ClusterSize
	}
	return json.Marshal(objectMap)
}

// ClustersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersCreateOrUpdateFuture.Result.
func (future *ClustersCreateOrUpdateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.ClustersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.ClustersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateOrUpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.ClustersCreateOrUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersDeleteFuture.Result.
func (future *ClustersDeleteFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.ClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.ClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersUpdateFuture.Result.
func (future *ClustersUpdateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.ClustersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.ClustersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.UpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.ClustersUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClusterUpdate an update of a cluster resource
type ClusterUpdate struct {
	// ClusterUpdateProperties - The properties of a cluster resource that may be updated
	*ClusterUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpdate.
func (cu ClusterUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cu.ClusterUpdateProperties != nil {
		objectMap["properties"] = cu.ClusterUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterUpdate struct.
func (cu *ClusterUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterUpdateProperties ClusterUpdateProperties
				err = json.Unmarshal(*v, &clusterUpdateProperties)
				if err != nil {
					return err
				}
				cu.ClusterUpdateProperties = &clusterUpdateProperties
			}
		}
	}

	return nil
}

// ClusterUpdateProperties the properties of a cluster that may be updated
type ClusterUpdateProperties struct {
	// ClusterSize - The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`
}

// CommonClusterProperties the common properties of a cluster
type CommonClusterProperties struct {
	// ProvisioningState - READ-ONLY; The state of the cluster provisioning. Possible values include: 'Succeeded', 'Failed', 'Cancelled', 'Deleting', 'Updating'
	ProvisioningState ClusterProvisioningState `json:"provisioningState,omitempty"`
	// ClusterSize - The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`
	// ClusterID - READ-ONLY; The identity
	ClusterID *int32 `json:"clusterId,omitempty"`
	// Hosts - READ-ONLY; The hosts
	Hosts *[]string `json:"hosts,omitempty"`
}

// MarshalJSON is the custom marshaler for CommonClusterProperties.
func (ccp CommonClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccp.ClusterSize != nil {
		objectMap["clusterSize"] = ccp.ClusterSize
	}
	return json.Marshal(objectMap)
}

// Endpoints endpoint addresses
type Endpoints struct {
	// NsxtManager - READ-ONLY; Endpoint for the NSX-T Data Center manager
	NsxtManager *string `json:"nsxtManager,omitempty"`
	// Vcsa - READ-ONLY; Endpoint for Virtual Center Server Appliance
	Vcsa *string `json:"vcsa,omitempty"`
	// HcxCloudManager - READ-ONLY; Endpoint for the HCX Cloud Manager
	HcxCloudManager *string `json:"hcxCloudManager,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.)
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponse `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// ExpressRouteAuthorization expressRoute Circuit Authorization
type ExpressRouteAuthorization struct {
	autorest.Response `json:"-"`
	// ExpressRouteAuthorizationProperties - READ-ONLY; The properties of an ExpressRoute Circuit Authorization resource
	*ExpressRouteAuthorizationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteAuthorization.
func (era ExpressRouteAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteAuthorization struct.
func (era *ExpressRouteAuthorization) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteAuthorizationProperties ExpressRouteAuthorizationProperties
				err = json.Unmarshal(*v, &expressRouteAuthorizationProperties)
				if err != nil {
					return err
				}
				era.ExpressRouteAuthorizationProperties = &expressRouteAuthorizationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				era.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				era.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				era.Type = &typeVar
			}
		}
	}

	return nil
}

// ExpressRouteAuthorizationList a paged list of ExpressRoute Circuit Authorizations
type ExpressRouteAuthorizationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on a page
	Value *[]ExpressRouteAuthorization `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteAuthorizationListIterator provides access to a complete listing of ExpressRouteAuthorization
// values.
type ExpressRouteAuthorizationListIterator struct {
	i    int
	page ExpressRouteAuthorizationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteAuthorizationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteAuthorizationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteAuthorizationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteAuthorizationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteAuthorizationListIterator) Response() ExpressRouteAuthorizationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteAuthorizationListIterator) Value() ExpressRouteAuthorization {
	if !iter.page.NotDone() {
		return ExpressRouteAuthorization{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteAuthorizationListIterator type.
func NewExpressRouteAuthorizationListIterator(page ExpressRouteAuthorizationListPage) ExpressRouteAuthorizationListIterator {
	return ExpressRouteAuthorizationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eral ExpressRouteAuthorizationList) IsEmpty() bool {
	return eral.Value == nil || len(*eral.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eral ExpressRouteAuthorizationList) hasNextLink() bool {
	return eral.NextLink != nil && len(*eral.NextLink) != 0
}

// expressRouteAuthorizationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eral ExpressRouteAuthorizationList) expressRouteAuthorizationListPreparer(ctx context.Context) (*http.Request, error) {
	if !eral.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eral.NextLink)))
}

// ExpressRouteAuthorizationListPage contains a page of ExpressRouteAuthorization values.
type ExpressRouteAuthorizationListPage struct {
	fn   func(context.Context, ExpressRouteAuthorizationList) (ExpressRouteAuthorizationList, error)
	eral ExpressRouteAuthorizationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteAuthorizationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteAuthorizationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eral)
		if err != nil {
			return err
		}
		page.eral = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteAuthorizationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteAuthorizationListPage) NotDone() bool {
	return !page.eral.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteAuthorizationListPage) Response() ExpressRouteAuthorizationList {
	return page.eral
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteAuthorizationListPage) Values() []ExpressRouteAuthorization {
	if page.eral.IsEmpty() {
		return nil
	}
	return *page.eral.Value
}

// Creates a new instance of the ExpressRouteAuthorizationListPage type.
func NewExpressRouteAuthorizationListPage(cur ExpressRouteAuthorizationList, getNextPage func(context.Context, ExpressRouteAuthorizationList) (ExpressRouteAuthorizationList, error)) ExpressRouteAuthorizationListPage {
	return ExpressRouteAuthorizationListPage{
		fn:   getNextPage,
		eral: cur,
	}
}

// ExpressRouteAuthorizationProperties the properties of an ExpressRoute Circuit Authorization resource
type ExpressRouteAuthorizationProperties struct {
	// ProvisioningState - READ-ONLY; The state of the  ExpressRoute Circuit Authorization provisioning. Possible values include: 'ExpressRouteAuthorizationProvisioningStateSucceeded', 'ExpressRouteAuthorizationProvisioningStateFailed', 'ExpressRouteAuthorizationProvisioningStateUpdating'
	ProvisioningState ExpressRouteAuthorizationProvisioningState `json:"provisioningState,omitempty"`
	// ExpressRouteAuthorizationID - READ-ONLY; The ID of the ExpressRoute Circuit Authorization
	ExpressRouteAuthorizationID *string `json:"expressRouteAuthorizationId,omitempty"`
	// ExpressRouteAuthorizationKey - READ-ONLY; The key of the ExpressRoute Circuit Authorization
	ExpressRouteAuthorizationKey *string `json:"expressRouteAuthorizationKey,omitempty"`
}

// GlobalReachConnection a global reach connection resource
type GlobalReachConnection struct {
	autorest.Response `json:"-"`
	// GlobalReachConnectionProperties - The properties of a global reach connection resource
	*GlobalReachConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for GlobalReachConnection.
func (grc GlobalReachConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if grc.GlobalReachConnectionProperties != nil {
		objectMap["properties"] = grc.GlobalReachConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GlobalReachConnection struct.
func (grc *GlobalReachConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var globalReachConnectionProperties GlobalReachConnectionProperties
				err = json.Unmarshal(*v, &globalReachConnectionProperties)
				if err != nil {
					return err
				}
				grc.GlobalReachConnectionProperties = &globalReachConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				grc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				grc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				grc.Type = &typeVar
			}
		}
	}

	return nil
}

// GlobalReachConnectionList a paged list of global reach connections
type GlobalReachConnectionList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on a page
	Value *[]GlobalReachConnection `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// GlobalReachConnectionListIterator provides access to a complete listing of GlobalReachConnection values.
type GlobalReachConnectionListIterator struct {
	i    int
	page GlobalReachConnectionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GlobalReachConnectionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalReachConnectionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GlobalReachConnectionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GlobalReachConnectionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GlobalReachConnectionListIterator) Response() GlobalReachConnectionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GlobalReachConnectionListIterator) Value() GlobalReachConnection {
	if !iter.page.NotDone() {
		return GlobalReachConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GlobalReachConnectionListIterator type.
func NewGlobalReachConnectionListIterator(page GlobalReachConnectionListPage) GlobalReachConnectionListIterator {
	return GlobalReachConnectionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (grcl GlobalReachConnectionList) IsEmpty() bool {
	return grcl.Value == nil || len(*grcl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (grcl GlobalReachConnectionList) hasNextLink() bool {
	return grcl.NextLink != nil && len(*grcl.NextLink) != 0
}

// globalReachConnectionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (grcl GlobalReachConnectionList) globalReachConnectionListPreparer(ctx context.Context) (*http.Request, error) {
	if !grcl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(grcl.NextLink)))
}

// GlobalReachConnectionListPage contains a page of GlobalReachConnection values.
type GlobalReachConnectionListPage struct {
	fn   func(context.Context, GlobalReachConnectionList) (GlobalReachConnectionList, error)
	grcl GlobalReachConnectionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GlobalReachConnectionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GlobalReachConnectionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.grcl)
		if err != nil {
			return err
		}
		page.grcl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GlobalReachConnectionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GlobalReachConnectionListPage) NotDone() bool {
	return !page.grcl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GlobalReachConnectionListPage) Response() GlobalReachConnectionList {
	return page.grcl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GlobalReachConnectionListPage) Values() []GlobalReachConnection {
	if page.grcl.IsEmpty() {
		return nil
	}
	return *page.grcl.Value
}

// Creates a new instance of the GlobalReachConnectionListPage type.
func NewGlobalReachConnectionListPage(cur GlobalReachConnectionList, getNextPage func(context.Context, GlobalReachConnectionList) (GlobalReachConnectionList, error)) GlobalReachConnectionListPage {
	return GlobalReachConnectionListPage{
		fn:   getNextPage,
		grcl: cur,
	}
}

// GlobalReachConnectionProperties the properties of a global reach connection
type GlobalReachConnectionProperties struct {
	// ProvisioningState - READ-ONLY; The state of the  ExpressRoute Circuit Authorization provisioning. Possible values include: 'GlobalReachConnectionProvisioningStateSucceeded', 'GlobalReachConnectionProvisioningStateFailed', 'GlobalReachConnectionProvisioningStateUpdating'
	ProvisioningState GlobalReachConnectionProvisioningState `json:"provisioningState,omitempty"`
	// AddressPrefix - READ-ONLY; The network used for global reach carved out from the original network block provided for the private cloud
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// AuthorizationKey - Authorization key from the peer express route used for the global reach connection
	AuthorizationKey *string `json:"authorizationKey,omitempty"`
	// CircuitConnectionStatus - READ-ONLY; The connection status of the global reach connection. Possible values include: 'Connected', 'Connecting', 'Disconnected'
	CircuitConnectionStatus GlobalReachConnectionStatus `json:"circuitConnectionStatus,omitempty"`
	// PeerExpressRouteCircuit - Identifier of the ExpressRoute Circuit to peer with in the global reach connection
	PeerExpressRouteCircuit *string `json:"peerExpressRouteCircuit,omitempty"`
}

// MarshalJSON is the custom marshaler for GlobalReachConnectionProperties.
func (grcp GlobalReachConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if grcp.AuthorizationKey != nil {
		objectMap["authorizationKey"] = grcp.AuthorizationKey
	}
	if grcp.PeerExpressRouteCircuit != nil {
		objectMap["peerExpressRouteCircuit"] = grcp.PeerExpressRouteCircuit
	}
	return json.Marshal(objectMap)
}

// GlobalReachConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GlobalReachConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GlobalReachConnectionsClient) (GlobalReachConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GlobalReachConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GlobalReachConnectionsCreateOrUpdateFuture.Result.
func (future *GlobalReachConnectionsCreateOrUpdateFuture) result(client GlobalReachConnectionsClient) (grc GlobalReachConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.GlobalReachConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		grc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.GlobalReachConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if grc.Response.Response, err = future.GetResult(sender); err == nil && grc.Response.Response.StatusCode != http.StatusNoContent {
		grc, err = client.CreateOrUpdateResponder(grc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.GlobalReachConnectionsCreateOrUpdateFuture", "Result", grc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GlobalReachConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GlobalReachConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GlobalReachConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GlobalReachConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GlobalReachConnectionsDeleteFuture.Result.
func (future *GlobalReachConnectionsDeleteFuture) result(client GlobalReachConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.GlobalReachConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.GlobalReachConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// HcxEnterpriseSite an HCX Enterprise Site resource
type HcxEnterpriseSite struct {
	autorest.Response `json:"-"`
	// HcxEnterpriseSiteProperties - READ-ONLY; The properties of an HCX Enterprise Site resource
	*HcxEnterpriseSiteProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for HcxEnterpriseSite.
func (hes HcxEnterpriseSite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HcxEnterpriseSite struct.
func (hes *HcxEnterpriseSite) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hcxEnterpriseSiteProperties HcxEnterpriseSiteProperties
				err = json.Unmarshal(*v, &hcxEnterpriseSiteProperties)
				if err != nil {
					return err
				}
				hes.HcxEnterpriseSiteProperties = &hcxEnterpriseSiteProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hes.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hes.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hes.Type = &typeVar
			}
		}
	}

	return nil
}

// HcxEnterpriseSiteList a paged list of HCX Enterprise Sites
type HcxEnterpriseSiteList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on a page
	Value *[]HcxEnterpriseSite `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// HcxEnterpriseSiteListIterator provides access to a complete listing of HcxEnterpriseSite values.
type HcxEnterpriseSiteListIterator struct {
	i    int
	page HcxEnterpriseSiteListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HcxEnterpriseSiteListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HcxEnterpriseSiteListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HcxEnterpriseSiteListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HcxEnterpriseSiteListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HcxEnterpriseSiteListIterator) Response() HcxEnterpriseSiteList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HcxEnterpriseSiteListIterator) Value() HcxEnterpriseSite {
	if !iter.page.NotDone() {
		return HcxEnterpriseSite{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HcxEnterpriseSiteListIterator type.
func NewHcxEnterpriseSiteListIterator(page HcxEnterpriseSiteListPage) HcxEnterpriseSiteListIterator {
	return HcxEnterpriseSiteListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hesl HcxEnterpriseSiteList) IsEmpty() bool {
	return hesl.Value == nil || len(*hesl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hesl HcxEnterpriseSiteList) hasNextLink() bool {
	return hesl.NextLink != nil && len(*hesl.NextLink) != 0
}

// hcxEnterpriseSiteListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hesl HcxEnterpriseSiteList) hcxEnterpriseSiteListPreparer(ctx context.Context) (*http.Request, error) {
	if !hesl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hesl.NextLink)))
}

// HcxEnterpriseSiteListPage contains a page of HcxEnterpriseSite values.
type HcxEnterpriseSiteListPage struct {
	fn   func(context.Context, HcxEnterpriseSiteList) (HcxEnterpriseSiteList, error)
	hesl HcxEnterpriseSiteList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HcxEnterpriseSiteListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HcxEnterpriseSiteListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hesl)
		if err != nil {
			return err
		}
		page.hesl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HcxEnterpriseSiteListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HcxEnterpriseSiteListPage) NotDone() bool {
	return !page.hesl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HcxEnterpriseSiteListPage) Response() HcxEnterpriseSiteList {
	return page.hesl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HcxEnterpriseSiteListPage) Values() []HcxEnterpriseSite {
	if page.hesl.IsEmpty() {
		return nil
	}
	return *page.hesl.Value
}

// Creates a new instance of the HcxEnterpriseSiteListPage type.
func NewHcxEnterpriseSiteListPage(cur HcxEnterpriseSiteList, getNextPage func(context.Context, HcxEnterpriseSiteList) (HcxEnterpriseSiteList, error)) HcxEnterpriseSiteListPage {
	return HcxEnterpriseSiteListPage{
		fn:   getNextPage,
		hesl: cur,
	}
}

// HcxEnterpriseSiteProperties the properties of an HCX Enterprise Site
type HcxEnterpriseSiteProperties struct {
	// ActivationKey - READ-ONLY; The activation key
	ActivationKey *string `json:"activationKey,omitempty"`
	// Status - READ-ONLY; The status of the HCX Enterprise Site. Possible values include: 'Available', 'Consumed', 'Deactivated', 'Deleted'
	Status HcxEnterpriseSiteStatus `json:"status,omitempty"`
}

// IdentitySource vCenter Single Sign On Identity Source
type IdentitySource struct {
	// Name - The name of the identity source
	Name *string `json:"name,omitempty"`
	// Alias - The domain's NetBIOS name
	Alias *string `json:"alias,omitempty"`
	// Domain - The domain's dns name
	Domain *string `json:"domain,omitempty"`
	// BaseUserDN - The base distinguished name for users
	BaseUserDN *string `json:"baseUserDN,omitempty"`
	// BaseGroupDN - The base distinguished name for groups
	BaseGroupDN *string `json:"baseGroupDN,omitempty"`
	// PrimaryServer - Primary server URL
	PrimaryServer *string `json:"primaryServer,omitempty"`
	// SecondaryServer - Secondary server URL
	SecondaryServer *string `json:"secondaryServer,omitempty"`
	// Ssl - Protect LDAP communication using SSL certificate (LDAPS). Possible values include: 'SslEnumEnabled', 'SslEnumDisabled'
	Ssl SslEnum `json:"ssl,omitempty"`
	// Username - The ID of an Active Directory user with a minimum of read-only access to Base DN for users and group
	Username *string `json:"username,omitempty"`
	// Password - The password of the Active Directory user with a minimum of read-only access to Base DN for users and groups.
	Password *string `json:"password,omitempty"`
}

// LogSpecification specifications of the Log for Azure Monitoring
type LogSpecification struct {
	// Name - Name of the log
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the log
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - Blob duration of the log
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// ManagementCluster the properties of a management cluster
type ManagementCluster struct {
	// ProvisioningState - READ-ONLY; The state of the cluster provisioning. Possible values include: 'Succeeded', 'Failed', 'Cancelled', 'Deleting', 'Updating'
	ProvisioningState ClusterProvisioningState `json:"provisioningState,omitempty"`
	// ClusterSize - The cluster size
	ClusterSize *int32 `json:"clusterSize,omitempty"`
	// ClusterID - READ-ONLY; The identity
	ClusterID *int32 `json:"clusterId,omitempty"`
	// Hosts - READ-ONLY; The hosts
	Hosts *[]string `json:"hosts,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementCluster.
func (mc ManagementCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mc.ClusterSize != nil {
		objectMap["clusterSize"] = mc.ClusterSize
	}
	return json.Marshal(objectMap)
}

// MetricDimension specifications of the Dimension of metrics
type MetricDimension struct {
	// Name - Name of the dimension
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the dimension
	DisplayName *string `json:"displayName,omitempty"`
}

// MetricSpecification specifications of the Metrics for Azure Monitoring
type MetricSpecification struct {
	// Name - Name of the metric
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the metric
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Localized friendly description of the metric
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Unit that makes sense for the metric
	Unit *string `json:"unit,omitempty"`
	// Category - Name of the metric category that the metric belongs to. A metric can only belong to a single category.
	Category *string `json:"category,omitempty"`
	// AggregationType - Only provide one value for this field. Valid values: Average, Minimum, Maximum, Total, Count.
	AggregationType *string `json:"aggregationType,omitempty"`
	// SupportedAggregationTypes - Supported aggregation types
	SupportedAggregationTypes *[]string `json:"supportedAggregationTypes,omitempty"`
	// SupportedTimeGrainTypes - Supported time grain types
	SupportedTimeGrainTypes *[]string `json:"supportedTimeGrainTypes,omitempty"`
	// FillGapWithZero - Optional. If set to true, then zero will be returned for time duration where no metric is emitted/published.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// Dimensions - Dimensions of the metric
	Dimensions *[]MetricDimension `json:"dimensions,omitempty"`
	// EnableRegionalMdmAccount - Whether or not the service is using regional MDM accounts.
	EnableRegionalMdmAccount *string `json:"enableRegionalMdmAccount,omitempty"`
	// SourceMdmAccount - The name of the MDM account.
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty"`
	// SourceMdmNamespace - The name of the MDM namespace.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`
}

// Operation a REST API operation
type Operation struct {
	// Name - READ-ONLY; Name of the operation being performed on this object
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; Contains the localized display information for this operation
	Display *OperationDisplay `json:"display,omitempty"`
	// IsDataAction - Gets or sets a value indicating whether the operation is a data action or not
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Origin - Origin of the operation
	Origin *string `json:"origin,omitempty"`
	// Properties - Properties of the operation
	Properties *OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.IsDataAction != nil {
		objectMap["isDataAction"] = o.IsDataAction
	}
	if o.Origin != nil {
		objectMap["origin"] = o.Origin
	}
	if o.Properties != nil {
		objectMap["properties"] = o.Properties
	}
	return json.Marshal(objectMap)
}

// OperationDisplay contains the localized display information for this operation
type OperationDisplay struct {
	// Provider - READ-ONLY; Localized friendly form of the resource provider name
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Localized friendly form of the resource type related to this operation
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Localized friendly name for the operation
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; Localized friendly description for the operation
	Description *string `json:"description,omitempty"`
}

// OperationList pageable list of operations
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// OperationProperties extra Operation properties
type OperationProperties struct {
	// ServiceSpecification - Service specifications of the operation
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// PrivateCloud a private cloud resource
type PrivateCloud struct {
	autorest.Response `json:"-"`
	// Sku - The private cloud SKU
	Sku *Sku `json:"sku,omitempty"`
	// PrivateCloudProperties - The properties of a private cloud resource
	*PrivateCloudProperties `json:"properties,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateCloud.
func (pc PrivateCloud) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.Sku != nil {
		objectMap["sku"] = pc.Sku
	}
	if pc.PrivateCloudProperties != nil {
		objectMap["properties"] = pc.PrivateCloudProperties
	}
	if pc.Location != nil {
		objectMap["location"] = pc.Location
	}
	if pc.Tags != nil {
		objectMap["tags"] = pc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateCloud struct.
func (pc *PrivateCloud) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				pc.Sku = &sku
			}
		case "properties":
			if v != nil {
				var privateCloudProperties PrivateCloudProperties
				err = json.Unmarshal(*v, &privateCloudProperties)
				if err != nil {
					return err
				}
				pc.PrivateCloudProperties = &privateCloudProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pc.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pc.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateCloudList a paged list of private clouds
type PrivateCloudList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]PrivateCloud `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateCloudListIterator provides access to a complete listing of PrivateCloud values.
type PrivateCloudListIterator struct {
	i    int
	page PrivateCloudListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateCloudListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateCloudListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateCloudListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateCloudListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateCloudListIterator) Response() PrivateCloudList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateCloudListIterator) Value() PrivateCloud {
	if !iter.page.NotDone() {
		return PrivateCloud{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateCloudListIterator type.
func NewPrivateCloudListIterator(page PrivateCloudListPage) PrivateCloudListIterator {
	return PrivateCloudListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcl PrivateCloudList) IsEmpty() bool {
	return pcl.Value == nil || len(*pcl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pcl PrivateCloudList) hasNextLink() bool {
	return pcl.NextLink != nil && len(*pcl.NextLink) != 0
}

// privateCloudListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcl PrivateCloudList) privateCloudListPreparer(ctx context.Context) (*http.Request, error) {
	if !pcl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcl.NextLink)))
}

// PrivateCloudListPage contains a page of PrivateCloud values.
type PrivateCloudListPage struct {
	fn  func(context.Context, PrivateCloudList) (PrivateCloudList, error)
	pcl PrivateCloudList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateCloudListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateCloudListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pcl)
		if err != nil {
			return err
		}
		page.pcl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateCloudListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateCloudListPage) NotDone() bool {
	return !page.pcl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateCloudListPage) Response() PrivateCloudList {
	return page.pcl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateCloudListPage) Values() []PrivateCloud {
	if page.pcl.IsEmpty() {
		return nil
	}
	return *page.pcl.Value
}

// Creates a new instance of the PrivateCloudListPage type.
func NewPrivateCloudListPage(cur PrivateCloudList, getNextPage func(context.Context, PrivateCloudList) (PrivateCloudList, error)) PrivateCloudListPage {
	return PrivateCloudListPage{
		fn:  getNextPage,
		pcl: cur,
	}
}

// PrivateCloudProperties the properties of a private cloud resource
type PrivateCloudProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'PrivateCloudProvisioningStateSucceeded', 'PrivateCloudProvisioningStateFailed', 'PrivateCloudProvisioningStateCancelled', 'PrivateCloudProvisioningStatePending', 'PrivateCloudProvisioningStateBuilding', 'PrivateCloudProvisioningStateDeleting', 'PrivateCloudProvisioningStateUpdating'
	ProvisioningState PrivateCloudProvisioningState `json:"provisioningState,omitempty"`
	// Circuit - An ExpressRoute Circuit
	Circuit *Circuit `json:"circuit,omitempty"`
	// Endpoints - READ-ONLY; The endpoints
	Endpoints *Endpoints `json:"endpoints,omitempty"`
	// NetworkBlock - The block of addresses should be unique across VNet in your subscription as well as on-premise. Make sure the CIDR format is conformed to (A.B.C.D/X) where A,B,C,D are between 0 and 255, and X is between 0 and 22
	NetworkBlock *string `json:"networkBlock,omitempty"`
	// ManagementNetwork - READ-ONLY; Network used to access vCenter Server and NSX-T Manager
	ManagementNetwork *string `json:"managementNetwork,omitempty"`
	// ProvisioningNetwork - READ-ONLY; Used for virtual machine cold migration, cloning, and snapshot migration
	ProvisioningNetwork *string `json:"provisioningNetwork,omitempty"`
	// VmotionNetwork - READ-ONLY; Used for live migration of virtual machines
	VmotionNetwork *string `json:"vmotionNetwork,omitempty"`
	// VcenterCertificateThumbprint - READ-ONLY; Thumbprint of the vCenter Server SSL certificate
	VcenterCertificateThumbprint *string `json:"vcenterCertificateThumbprint,omitempty"`
	// NsxtCertificateThumbprint - READ-ONLY; Thumbprint of the NSX-T Manager SSL certificate
	NsxtCertificateThumbprint *string `json:"nsxtCertificateThumbprint,omitempty"`
	// ManagementCluster - The default cluster used for management
	ManagementCluster *ManagementCluster `json:"managementCluster,omitempty"`
	// Internet - Connectivity to internet is enabled or disabled. Possible values include: 'Enabled', 'Disabled'
	Internet InternetEnum `json:"internet,omitempty"`
	// IdentitySources - vCenter Single Sign On Identity Sources
	IdentitySources *[]IdentitySource `json:"identitySources,omitempty"`
	// VcenterPassword - Indicate to rotate the vCenter admin password for the private cloud. Possible values include: 'VcsaAdminRotateEnumOnetimeRotate'
	VcenterPassword VcsaAdminRotateEnum `json:"vcenterPassword,omitempty"`
	// NsxtPassword - Indicate to rotate the NSX-T Manager password for the private cloud. Possible values include: 'OnetimeRotate'
	NsxtPassword NsxtAdminRotateEnum `json:"nsxtPassword,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateCloudProperties.
func (pcp PrivateCloudProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pcp.Circuit != nil {
		objectMap["circuit"] = pcp.Circuit
	}
	if pcp.NetworkBlock != nil {
		objectMap["networkBlock"] = pcp.NetworkBlock
	}
	if pcp.ManagementCluster != nil {
		objectMap["managementCluster"] = pcp.ManagementCluster
	}
	if pcp.Internet != "" {
		objectMap["internet"] = pcp.Internet
	}
	if pcp.IdentitySources != nil {
		objectMap["identitySources"] = pcp.IdentitySources
	}
	if pcp.VcenterPassword != "" {
		objectMap["vcenterPassword"] = pcp.VcenterPassword
	}
	if pcp.NsxtPassword != "" {
		objectMap["nsxtPassword"] = pcp.NsxtPassword
	}
	return json.Marshal(objectMap)
}

// PrivateCloudsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateCloudsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateCloudsClient) (PrivateCloud, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateCloudsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateCloudsCreateOrUpdateFuture.Result.
func (future *PrivateCloudsCreateOrUpdateFuture) result(client PrivateCloudsClient) (pc PrivateCloud, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.PrivateCloudsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.PrivateCloudsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pc.Response.Response, err = future.GetResult(sender); err == nil && pc.Response.Response.StatusCode != http.StatusNoContent {
		pc, err = client.CreateOrUpdateResponder(pc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.PrivateCloudsCreateOrUpdateFuture", "Result", pc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateCloudsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PrivateCloudsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateCloudsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateCloudsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateCloudsDeleteFuture.Result.
func (future *PrivateCloudsDeleteFuture) result(client PrivateCloudsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.PrivateCloudsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.PrivateCloudsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateCloudsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PrivateCloudsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateCloudsClient) (PrivateCloud, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateCloudsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateCloudsUpdateFuture.Result.
func (future *PrivateCloudsUpdateFuture) result(client PrivateCloudsClient) (pc PrivateCloud, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.PrivateCloudsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.PrivateCloudsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pc.Response.Response, err = future.GetResult(sender); err == nil && pc.Response.Response.StatusCode != http.StatusNoContent {
		pc, err = client.UpdateResponder(pc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.PrivateCloudsUpdateFuture", "Result", pc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateCloudUpdate an update to a private cloud resource
type PrivateCloudUpdate struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// PrivateCloudUpdateProperties - The updatable properties of a private cloud resource
	*PrivateCloudUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateCloudUpdate.
func (pcu PrivateCloudUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pcu.Tags != nil {
		objectMap["tags"] = pcu.Tags
	}
	if pcu.PrivateCloudUpdateProperties != nil {
		objectMap["properties"] = pcu.PrivateCloudUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateCloudUpdate struct.
func (pcu *PrivateCloudUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pcu.Tags = tags
			}
		case "properties":
			if v != nil {
				var privateCloudUpdateProperties PrivateCloudUpdateProperties
				err = json.Unmarshal(*v, &privateCloudUpdateProperties)
				if err != nil {
					return err
				}
				pcu.PrivateCloudUpdateProperties = &privateCloudUpdateProperties
			}
		}
	}

	return nil
}

// PrivateCloudUpdateProperties the properties of a private cloud resource that may be updated
type PrivateCloudUpdateProperties struct {
	// ManagementCluster - The default cluster used for management
	ManagementCluster *ManagementCluster `json:"managementCluster,omitempty"`
	// Internet - Connectivity to internet is enabled or disabled. Possible values include: 'Enabled', 'Disabled'
	Internet InternetEnum `json:"internet,omitempty"`
	// IdentitySources - vCenter Single Sign On Identity Sources
	IdentitySources *[]IdentitySource `json:"identitySources,omitempty"`
	// VcenterPassword - Indicate to rotate the vCenter admin password for the private cloud. Possible values include: 'VcsaAdminRotateEnumOnetimeRotate'
	VcenterPassword VcsaAdminRotateEnum `json:"vcenterPassword,omitempty"`
	// NsxtPassword - Indicate to rotate the NSX-T Manager password for the private cloud. Possible values include: 'OnetimeRotate'
	NsxtPassword NsxtAdminRotateEnum `json:"nsxtPassword,omitempty"`
}

// ProxyResource the resource model definition for a ARM proxy resource
type ProxyResource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// Quota subscription quotas
type Quota struct {
	autorest.Response `json:"-"`
	// HostsRemaining - READ-ONLY; Remaining hosts quota by sku type
	HostsRemaining map[string]*int32 `json:"hostsRemaining"`
	// QuotaEnabled - READ-ONLY; Host quota is active for current subscription. Possible values include: 'QuotaEnabledEnabled', 'QuotaEnabledDisabled'
	QuotaEnabled QuotaEnabled `json:"quotaEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for Quota.
func (q Quota) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource the core properties of ARM resources
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// ServiceSpecification service specification payload
type ServiceSpecification struct {
	// LogSpecifications - Specifications of the Log for Azure Monitoring
	LogSpecifications *[]LogSpecification `json:"logSpecifications,omitempty"`
	// MetricSpecifications - Specifications of the Metrics for Azure Monitoring
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// Sku the resource model definition representing SKU
type Sku struct {
	// Name - The name of the SKU.
	Name *string `json:"name,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// Trial subscription trial availability
type Trial struct {
	autorest.Response `json:"-"`
	// Status - READ-ONLY; Trial status. Possible values include: 'TrialAvailable', 'TrialUsed', 'TrialDisabled'
	Status TrialStatus `json:"status,omitempty"`
	// AvailableHosts - READ-ONLY; Number of trial hosts available
	AvailableHosts *int32 `json:"availableHosts,omitempty"`
}

// WorkloadNetworkDhcp NSX DHCP
type WorkloadNetworkDhcp struct {
	autorest.Response `json:"-"`
	// BasicWorkloadNetworkDhcpEntity - DHCP properties.
	BasicWorkloadNetworkDhcpEntity `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkDhcp.
func (wnd WorkloadNetworkDhcp) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = wnd.BasicWorkloadNetworkDhcpEntity
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadNetworkDhcp struct.
func (wnd *WorkloadNetworkDhcp) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				basicWorkloadNetworkDhcpEntity, err := unmarshalBasicWorkloadNetworkDhcpEntity(*v)
				if err != nil {
					return err
				}
				wnd.BasicWorkloadNetworkDhcpEntity = basicWorkloadNetworkDhcpEntity
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wnd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wnd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wnd.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicWorkloadNetworkDhcpEntity base class for WorkloadNetworkDhcpServer and WorkloadNetworkDhcpRelay to inherit from
type BasicWorkloadNetworkDhcpEntity interface {
	AsWorkloadNetworkDhcpServer() (*WorkloadNetworkDhcpServer, bool)
	AsWorkloadNetworkDhcpRelay() (*WorkloadNetworkDhcpRelay, bool)
	AsWorkloadNetworkDhcpEntity() (*WorkloadNetworkDhcpEntity, bool)
}

// WorkloadNetworkDhcpEntity base class for WorkloadNetworkDhcpServer and WorkloadNetworkDhcpRelay to inherit
// from
type WorkloadNetworkDhcpEntity struct {
	// DisplayName - Display name of the DHCP entity.
	DisplayName *string `json:"displayName,omitempty"`
	// Segments - READ-ONLY; NSX Segments consuming DHCP.
	Segments *[]string `json:"segments,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'WorkloadNetworkDhcpProvisioningStateSucceeded', 'WorkloadNetworkDhcpProvisioningStateFailed', 'WorkloadNetworkDhcpProvisioningStateBuilding', 'WorkloadNetworkDhcpProvisioningStateDeleting', 'WorkloadNetworkDhcpProvisioningStateUpdating'
	ProvisioningState WorkloadNetworkDhcpProvisioningState `json:"provisioningState,omitempty"`
	// Revision - NSX revision number.
	Revision *int64 `json:"revision,omitempty"`
	// DhcpType - Possible values include: 'DhcpTypeWorkloadNetworkDhcpEntity', 'DhcpTypeSERVER', 'DhcpTypeRELAY'
	DhcpType DhcpType `json:"dhcpType,omitempty"`
}

func unmarshalBasicWorkloadNetworkDhcpEntity(body []byte) (BasicWorkloadNetworkDhcpEntity, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["dhcpType"] {
	case string(DhcpTypeSERVER):
		var wnds WorkloadNetworkDhcpServer
		err := json.Unmarshal(body, &wnds)
		return wnds, err
	case string(DhcpTypeRELAY):
		var wndr WorkloadNetworkDhcpRelay
		err := json.Unmarshal(body, &wndr)
		return wndr, err
	default:
		var wnde WorkloadNetworkDhcpEntity
		err := json.Unmarshal(body, &wnde)
		return wnde, err
	}
}
func unmarshalBasicWorkloadNetworkDhcpEntityArray(body []byte) ([]BasicWorkloadNetworkDhcpEntity, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	wndeArray := make([]BasicWorkloadNetworkDhcpEntity, len(rawMessages))

	for index, rawMessage := range rawMessages {
		wnde, err := unmarshalBasicWorkloadNetworkDhcpEntity(*rawMessage)
		if err != nil {
			return nil, err
		}
		wndeArray[index] = wnde
	}
	return wndeArray, nil
}

// MarshalJSON is the custom marshaler for WorkloadNetworkDhcpEntity.
func (wnde WorkloadNetworkDhcpEntity) MarshalJSON() ([]byte, error) {
	wnde.DhcpType = DhcpTypeWorkloadNetworkDhcpEntity
	objectMap := make(map[string]interface{})
	if wnde.DisplayName != nil {
		objectMap["displayName"] = wnde.DisplayName
	}
	if wnde.Revision != nil {
		objectMap["revision"] = wnde.Revision
	}
	if wnde.DhcpType != "" {
		objectMap["dhcpType"] = wnde.DhcpType
	}
	return json.Marshal(objectMap)
}

// AsWorkloadNetworkDhcpServer is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpEntity.
func (wnde WorkloadNetworkDhcpEntity) AsWorkloadNetworkDhcpServer() (*WorkloadNetworkDhcpServer, bool) {
	return nil, false
}

// AsWorkloadNetworkDhcpRelay is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpEntity.
func (wnde WorkloadNetworkDhcpEntity) AsWorkloadNetworkDhcpRelay() (*WorkloadNetworkDhcpRelay, bool) {
	return nil, false
}

// AsWorkloadNetworkDhcpEntity is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpEntity.
func (wnde WorkloadNetworkDhcpEntity) AsWorkloadNetworkDhcpEntity() (*WorkloadNetworkDhcpEntity, bool) {
	return &wnde, true
}

// AsBasicWorkloadNetworkDhcpEntity is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpEntity.
func (wnde WorkloadNetworkDhcpEntity) AsBasicWorkloadNetworkDhcpEntity() (BasicWorkloadNetworkDhcpEntity, bool) {
	return &wnde, true
}

// WorkloadNetworkDhcpList a list of NSX dhcp entities
type WorkloadNetworkDhcpList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]WorkloadNetworkDhcp `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkloadNetworkDhcpListIterator provides access to a complete listing of WorkloadNetworkDhcp values.
type WorkloadNetworkDhcpListIterator struct {
	i    int
	page WorkloadNetworkDhcpListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadNetworkDhcpListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkDhcpListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadNetworkDhcpListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadNetworkDhcpListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadNetworkDhcpListIterator) Response() WorkloadNetworkDhcpList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadNetworkDhcpListIterator) Value() WorkloadNetworkDhcp {
	if !iter.page.NotDone() {
		return WorkloadNetworkDhcp{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadNetworkDhcpListIterator type.
func NewWorkloadNetworkDhcpListIterator(page WorkloadNetworkDhcpListPage) WorkloadNetworkDhcpListIterator {
	return WorkloadNetworkDhcpListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wndl WorkloadNetworkDhcpList) IsEmpty() bool {
	return wndl.Value == nil || len(*wndl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wndl WorkloadNetworkDhcpList) hasNextLink() bool {
	return wndl.NextLink != nil && len(*wndl.NextLink) != 0
}

// workloadNetworkDhcpListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wndl WorkloadNetworkDhcpList) workloadNetworkDhcpListPreparer(ctx context.Context) (*http.Request, error) {
	if !wndl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wndl.NextLink)))
}

// WorkloadNetworkDhcpListPage contains a page of WorkloadNetworkDhcp values.
type WorkloadNetworkDhcpListPage struct {
	fn   func(context.Context, WorkloadNetworkDhcpList) (WorkloadNetworkDhcpList, error)
	wndl WorkloadNetworkDhcpList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadNetworkDhcpListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkDhcpListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wndl)
		if err != nil {
			return err
		}
		page.wndl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadNetworkDhcpListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadNetworkDhcpListPage) NotDone() bool {
	return !page.wndl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadNetworkDhcpListPage) Response() WorkloadNetworkDhcpList {
	return page.wndl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadNetworkDhcpListPage) Values() []WorkloadNetworkDhcp {
	if page.wndl.IsEmpty() {
		return nil
	}
	return *page.wndl.Value
}

// Creates a new instance of the WorkloadNetworkDhcpListPage type.
func NewWorkloadNetworkDhcpListPage(cur WorkloadNetworkDhcpList, getNextPage func(context.Context, WorkloadNetworkDhcpList) (WorkloadNetworkDhcpList, error)) WorkloadNetworkDhcpListPage {
	return WorkloadNetworkDhcpListPage{
		fn:   getNextPage,
		wndl: cur,
	}
}

// WorkloadNetworkDhcpRelay NSX DHCP Relay
type WorkloadNetworkDhcpRelay struct {
	// ServerAddresses - DHCP Relay Addresses. Max 3.
	ServerAddresses *[]string `json:"serverAddresses,omitempty"`
	// DisplayName - Display name of the DHCP entity.
	DisplayName *string `json:"displayName,omitempty"`
	// Segments - READ-ONLY; NSX Segments consuming DHCP.
	Segments *[]string `json:"segments,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'WorkloadNetworkDhcpProvisioningStateSucceeded', 'WorkloadNetworkDhcpProvisioningStateFailed', 'WorkloadNetworkDhcpProvisioningStateBuilding', 'WorkloadNetworkDhcpProvisioningStateDeleting', 'WorkloadNetworkDhcpProvisioningStateUpdating'
	ProvisioningState WorkloadNetworkDhcpProvisioningState `json:"provisioningState,omitempty"`
	// Revision - NSX revision number.
	Revision *int64 `json:"revision,omitempty"`
	// DhcpType - Possible values include: 'DhcpTypeWorkloadNetworkDhcpEntity', 'DhcpTypeSERVER', 'DhcpTypeRELAY'
	DhcpType DhcpType `json:"dhcpType,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkDhcpRelay.
func (wndr WorkloadNetworkDhcpRelay) MarshalJSON() ([]byte, error) {
	wndr.DhcpType = DhcpTypeRELAY
	objectMap := make(map[string]interface{})
	if wndr.ServerAddresses != nil {
		objectMap["serverAddresses"] = wndr.ServerAddresses
	}
	if wndr.DisplayName != nil {
		objectMap["displayName"] = wndr.DisplayName
	}
	if wndr.Revision != nil {
		objectMap["revision"] = wndr.Revision
	}
	if wndr.DhcpType != "" {
		objectMap["dhcpType"] = wndr.DhcpType
	}
	return json.Marshal(objectMap)
}

// AsWorkloadNetworkDhcpServer is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpRelay.
func (wndr WorkloadNetworkDhcpRelay) AsWorkloadNetworkDhcpServer() (*WorkloadNetworkDhcpServer, bool) {
	return nil, false
}

// AsWorkloadNetworkDhcpRelay is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpRelay.
func (wndr WorkloadNetworkDhcpRelay) AsWorkloadNetworkDhcpRelay() (*WorkloadNetworkDhcpRelay, bool) {
	return &wndr, true
}

// AsWorkloadNetworkDhcpEntity is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpRelay.
func (wndr WorkloadNetworkDhcpRelay) AsWorkloadNetworkDhcpEntity() (*WorkloadNetworkDhcpEntity, bool) {
	return nil, false
}

// AsBasicWorkloadNetworkDhcpEntity is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpRelay.
func (wndr WorkloadNetworkDhcpRelay) AsBasicWorkloadNetworkDhcpEntity() (BasicWorkloadNetworkDhcpEntity, bool) {
	return &wndr, true
}

// WorkloadNetworkDhcpServer NSX DHCP Server
type WorkloadNetworkDhcpServer struct {
	// ServerAddress - DHCP Server Address.
	ServerAddress *string `json:"serverAddress,omitempty"`
	// LeaseTime - DHCP Server Lease Time.
	LeaseTime *int64 `json:"leaseTime,omitempty"`
	// DisplayName - Display name of the DHCP entity.
	DisplayName *string `json:"displayName,omitempty"`
	// Segments - READ-ONLY; NSX Segments consuming DHCP.
	Segments *[]string `json:"segments,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'WorkloadNetworkDhcpProvisioningStateSucceeded', 'WorkloadNetworkDhcpProvisioningStateFailed', 'WorkloadNetworkDhcpProvisioningStateBuilding', 'WorkloadNetworkDhcpProvisioningStateDeleting', 'WorkloadNetworkDhcpProvisioningStateUpdating'
	ProvisioningState WorkloadNetworkDhcpProvisioningState `json:"provisioningState,omitempty"`
	// Revision - NSX revision number.
	Revision *int64 `json:"revision,omitempty"`
	// DhcpType - Possible values include: 'DhcpTypeWorkloadNetworkDhcpEntity', 'DhcpTypeSERVER', 'DhcpTypeRELAY'
	DhcpType DhcpType `json:"dhcpType,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkDhcpServer.
func (wnds WorkloadNetworkDhcpServer) MarshalJSON() ([]byte, error) {
	wnds.DhcpType = DhcpTypeSERVER
	objectMap := make(map[string]interface{})
	if wnds.ServerAddress != nil {
		objectMap["serverAddress"] = wnds.ServerAddress
	}
	if wnds.LeaseTime != nil {
		objectMap["leaseTime"] = wnds.LeaseTime
	}
	if wnds.DisplayName != nil {
		objectMap["displayName"] = wnds.DisplayName
	}
	if wnds.Revision != nil {
		objectMap["revision"] = wnds.Revision
	}
	if wnds.DhcpType != "" {
		objectMap["dhcpType"] = wnds.DhcpType
	}
	return json.Marshal(objectMap)
}

// AsWorkloadNetworkDhcpServer is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpServer.
func (wnds WorkloadNetworkDhcpServer) AsWorkloadNetworkDhcpServer() (*WorkloadNetworkDhcpServer, bool) {
	return &wnds, true
}

// AsWorkloadNetworkDhcpRelay is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpServer.
func (wnds WorkloadNetworkDhcpServer) AsWorkloadNetworkDhcpRelay() (*WorkloadNetworkDhcpRelay, bool) {
	return nil, false
}

// AsWorkloadNetworkDhcpEntity is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpServer.
func (wnds WorkloadNetworkDhcpServer) AsWorkloadNetworkDhcpEntity() (*WorkloadNetworkDhcpEntity, bool) {
	return nil, false
}

// AsBasicWorkloadNetworkDhcpEntity is the BasicWorkloadNetworkDhcpEntity implementation for WorkloadNetworkDhcpServer.
func (wnds WorkloadNetworkDhcpServer) AsBasicWorkloadNetworkDhcpEntity() (BasicWorkloadNetworkDhcpEntity, bool) {
	return &wnds, true
}

// WorkloadNetworkGateway NSX Gateway.
type WorkloadNetworkGateway struct {
	autorest.Response `json:"-"`
	// WorkloadNetworkGatewayProperties - Gateway properties.
	*WorkloadNetworkGatewayProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkGateway.
func (wng WorkloadNetworkGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wng.WorkloadNetworkGatewayProperties != nil {
		objectMap["properties"] = wng.WorkloadNetworkGatewayProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadNetworkGateway struct.
func (wng *WorkloadNetworkGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadNetworkGatewayProperties WorkloadNetworkGatewayProperties
				err = json.Unmarshal(*v, &workloadNetworkGatewayProperties)
				if err != nil {
					return err
				}
				wng.WorkloadNetworkGatewayProperties = &workloadNetworkGatewayProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wng.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wng.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wng.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadNetworkGatewayList a list of NSX Gateways
type WorkloadNetworkGatewayList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]WorkloadNetworkGateway `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkloadNetworkGatewayListIterator provides access to a complete listing of WorkloadNetworkGateway
// values.
type WorkloadNetworkGatewayListIterator struct {
	i    int
	page WorkloadNetworkGatewayListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadNetworkGatewayListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkGatewayListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadNetworkGatewayListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadNetworkGatewayListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadNetworkGatewayListIterator) Response() WorkloadNetworkGatewayList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadNetworkGatewayListIterator) Value() WorkloadNetworkGateway {
	if !iter.page.NotDone() {
		return WorkloadNetworkGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadNetworkGatewayListIterator type.
func NewWorkloadNetworkGatewayListIterator(page WorkloadNetworkGatewayListPage) WorkloadNetworkGatewayListIterator {
	return WorkloadNetworkGatewayListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wngl WorkloadNetworkGatewayList) IsEmpty() bool {
	return wngl.Value == nil || len(*wngl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wngl WorkloadNetworkGatewayList) hasNextLink() bool {
	return wngl.NextLink != nil && len(*wngl.NextLink) != 0
}

// workloadNetworkGatewayListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wngl WorkloadNetworkGatewayList) workloadNetworkGatewayListPreparer(ctx context.Context) (*http.Request, error) {
	if !wngl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wngl.NextLink)))
}

// WorkloadNetworkGatewayListPage contains a page of WorkloadNetworkGateway values.
type WorkloadNetworkGatewayListPage struct {
	fn   func(context.Context, WorkloadNetworkGatewayList) (WorkloadNetworkGatewayList, error)
	wngl WorkloadNetworkGatewayList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadNetworkGatewayListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkGatewayListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wngl)
		if err != nil {
			return err
		}
		page.wngl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadNetworkGatewayListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadNetworkGatewayListPage) NotDone() bool {
	return !page.wngl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadNetworkGatewayListPage) Response() WorkloadNetworkGatewayList {
	return page.wngl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadNetworkGatewayListPage) Values() []WorkloadNetworkGateway {
	if page.wngl.IsEmpty() {
		return nil
	}
	return *page.wngl.Value
}

// Creates a new instance of the WorkloadNetworkGatewayListPage type.
func NewWorkloadNetworkGatewayListPage(cur WorkloadNetworkGatewayList, getNextPage func(context.Context, WorkloadNetworkGatewayList) (WorkloadNetworkGatewayList, error)) WorkloadNetworkGatewayListPage {
	return WorkloadNetworkGatewayListPage{
		fn:   getNextPage,
		wngl: cur,
	}
}

// WorkloadNetworkGatewayProperties properties of a NSX Gateway.
type WorkloadNetworkGatewayProperties struct {
	// DisplayName - Display name of the DHCP entity.
	DisplayName *string `json:"displayName,omitempty"`
	// Path - READ-ONLY; NSX Gateway Path.
	Path *string `json:"path,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkGatewayProperties.
func (wngp WorkloadNetworkGatewayProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wngp.DisplayName != nil {
		objectMap["displayName"] = wngp.DisplayName
	}
	return json.Marshal(objectMap)
}

// WorkloadNetworkPortMirroring NSX Port Mirroring
type WorkloadNetworkPortMirroring struct {
	autorest.Response `json:"-"`
	// WorkloadNetworkPortMirroringProperties - Port Mirroring Properties.
	*WorkloadNetworkPortMirroringProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkPortMirroring.
func (wnpm WorkloadNetworkPortMirroring) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnpm.WorkloadNetworkPortMirroringProperties != nil {
		objectMap["properties"] = wnpm.WorkloadNetworkPortMirroringProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadNetworkPortMirroring struct.
func (wnpm *WorkloadNetworkPortMirroring) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadNetworkPortMirroringProperties WorkloadNetworkPortMirroringProperties
				err = json.Unmarshal(*v, &workloadNetworkPortMirroringProperties)
				if err != nil {
					return err
				}
				wnpm.WorkloadNetworkPortMirroringProperties = &workloadNetworkPortMirroringProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wnpm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wnpm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wnpm.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadNetworkPortMirroringList a list of NSX Port Mirroring
type WorkloadNetworkPortMirroringList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]WorkloadNetworkPortMirroring `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkloadNetworkPortMirroringListIterator provides access to a complete listing of
// WorkloadNetworkPortMirroring values.
type WorkloadNetworkPortMirroringListIterator struct {
	i    int
	page WorkloadNetworkPortMirroringListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadNetworkPortMirroringListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkPortMirroringListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadNetworkPortMirroringListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadNetworkPortMirroringListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadNetworkPortMirroringListIterator) Response() WorkloadNetworkPortMirroringList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadNetworkPortMirroringListIterator) Value() WorkloadNetworkPortMirroring {
	if !iter.page.NotDone() {
		return WorkloadNetworkPortMirroring{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadNetworkPortMirroringListIterator type.
func NewWorkloadNetworkPortMirroringListIterator(page WorkloadNetworkPortMirroringListPage) WorkloadNetworkPortMirroringListIterator {
	return WorkloadNetworkPortMirroringListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wnpml WorkloadNetworkPortMirroringList) IsEmpty() bool {
	return wnpml.Value == nil || len(*wnpml.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wnpml WorkloadNetworkPortMirroringList) hasNextLink() bool {
	return wnpml.NextLink != nil && len(*wnpml.NextLink) != 0
}

// workloadNetworkPortMirroringListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wnpml WorkloadNetworkPortMirroringList) workloadNetworkPortMirroringListPreparer(ctx context.Context) (*http.Request, error) {
	if !wnpml.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wnpml.NextLink)))
}

// WorkloadNetworkPortMirroringListPage contains a page of WorkloadNetworkPortMirroring values.
type WorkloadNetworkPortMirroringListPage struct {
	fn    func(context.Context, WorkloadNetworkPortMirroringList) (WorkloadNetworkPortMirroringList, error)
	wnpml WorkloadNetworkPortMirroringList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadNetworkPortMirroringListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkPortMirroringListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wnpml)
		if err != nil {
			return err
		}
		page.wnpml = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadNetworkPortMirroringListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadNetworkPortMirroringListPage) NotDone() bool {
	return !page.wnpml.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadNetworkPortMirroringListPage) Response() WorkloadNetworkPortMirroringList {
	return page.wnpml
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadNetworkPortMirroringListPage) Values() []WorkloadNetworkPortMirroring {
	if page.wnpml.IsEmpty() {
		return nil
	}
	return *page.wnpml.Value
}

// Creates a new instance of the WorkloadNetworkPortMirroringListPage type.
func NewWorkloadNetworkPortMirroringListPage(cur WorkloadNetworkPortMirroringList, getNextPage func(context.Context, WorkloadNetworkPortMirroringList) (WorkloadNetworkPortMirroringList, error)) WorkloadNetworkPortMirroringListPage {
	return WorkloadNetworkPortMirroringListPage{
		fn:    getNextPage,
		wnpml: cur,
	}
}

// WorkloadNetworkPortMirroringProperties NSX Port Mirroring Properties
type WorkloadNetworkPortMirroringProperties struct {
	// DisplayName - Display name of the port mirroring profile.
	DisplayName *string `json:"displayName,omitempty"`
	// Direction - Direction of port mirroring profile. Possible values include: 'INGRESSEGRESSBIDIRECTIONAL'
	Direction PortMirroringDirectionEnum `json:"direction,omitempty"`
	// Source - Source VM Group.
	Source *string `json:"source,omitempty"`
	// Destination - Destination VM Group.
	Destination *string `json:"destination,omitempty"`
	// Status - READ-ONLY; Port Mirroring Status. Possible values include: 'SUCCESSFAILURE'
	Status PortMirroringStatusEnum `json:"status,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'WorkloadNetworkPortMirroringProvisioningStateSucceeded', 'WorkloadNetworkPortMirroringProvisioningStateFailed', 'WorkloadNetworkPortMirroringProvisioningStateBuilding', 'WorkloadNetworkPortMirroringProvisioningStateDeleting', 'WorkloadNetworkPortMirroringProvisioningStateUpdating'
	ProvisioningState WorkloadNetworkPortMirroringProvisioningState `json:"provisioningState,omitempty"`
	// Revision - NSX revision number.
	Revision *int64 `json:"revision,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkPortMirroringProperties.
func (wnpmp WorkloadNetworkPortMirroringProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnpmp.DisplayName != nil {
		objectMap["displayName"] = wnpmp.DisplayName
	}
	if wnpmp.Direction != "" {
		objectMap["direction"] = wnpmp.Direction
	}
	if wnpmp.Source != nil {
		objectMap["source"] = wnpmp.Source
	}
	if wnpmp.Destination != nil {
		objectMap["destination"] = wnpmp.Destination
	}
	if wnpmp.Revision != nil {
		objectMap["revision"] = wnpmp.Revision
	}
	return json.Marshal(objectMap)
}

// WorkloadNetworksCreateDhcpFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksCreateDhcpFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkDhcp, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksCreateDhcpFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksCreateDhcpFuture.Result.
func (future *WorkloadNetworksCreateDhcpFuture) result(client WorkloadNetworksClient) (wnd WorkloadNetworkDhcp, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreateDhcpFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wnd.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksCreateDhcpFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wnd.Response.Response, err = future.GetResult(sender); err == nil && wnd.Response.Response.StatusCode != http.StatusNoContent {
		wnd, err = client.CreateDhcpResponder(wnd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreateDhcpFuture", "Result", wnd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksCreatePortMirroringFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksCreatePortMirroringFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkPortMirroring, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksCreatePortMirroringFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksCreatePortMirroringFuture.Result.
func (future *WorkloadNetworksCreatePortMirroringFuture) result(client WorkloadNetworksClient) (wnpm WorkloadNetworkPortMirroring, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreatePortMirroringFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wnpm.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksCreatePortMirroringFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wnpm.Response.Response, err = future.GetResult(sender); err == nil && wnpm.Response.Response.StatusCode != http.StatusNoContent {
		wnpm, err = client.CreatePortMirroringResponder(wnpm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreatePortMirroringFuture", "Result", wnpm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksCreateSegmentsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksCreateSegmentsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkSegment, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksCreateSegmentsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksCreateSegmentsFuture.Result.
func (future *WorkloadNetworksCreateSegmentsFuture) result(client WorkloadNetworksClient) (wns WorkloadNetworkSegment, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreateSegmentsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wns.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksCreateSegmentsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wns.Response.Response, err = future.GetResult(sender); err == nil && wns.Response.Response.StatusCode != http.StatusNoContent {
		wns, err = client.CreateSegmentsResponder(wns.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreateSegmentsFuture", "Result", wns.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksCreateVMGroupFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksCreateVMGroupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkVMGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksCreateVMGroupFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksCreateVMGroupFuture.Result.
func (future *WorkloadNetworksCreateVMGroupFuture) result(client WorkloadNetworksClient) (wnvg WorkloadNetworkVMGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreateVMGroupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wnvg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksCreateVMGroupFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wnvg.Response.Response, err = future.GetResult(sender); err == nil && wnvg.Response.Response.StatusCode != http.StatusNoContent {
		wnvg, err = client.CreateVMGroupResponder(wnvg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksCreateVMGroupFuture", "Result", wnvg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksDeleteDhcpFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksDeleteDhcpFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksDeleteDhcpFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksDeleteDhcpFuture.Result.
func (future *WorkloadNetworksDeleteDhcpFuture) result(client WorkloadNetworksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksDeleteDhcpFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksDeleteDhcpFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkloadNetworksDeletePortMirroringFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksDeletePortMirroringFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksDeletePortMirroringFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksDeletePortMirroringFuture.Result.
func (future *WorkloadNetworksDeletePortMirroringFuture) result(client WorkloadNetworksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksDeletePortMirroringFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksDeletePortMirroringFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkloadNetworksDeleteSegmentFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksDeleteSegmentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksDeleteSegmentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksDeleteSegmentFuture.Result.
func (future *WorkloadNetworksDeleteSegmentFuture) result(client WorkloadNetworksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksDeleteSegmentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksDeleteSegmentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkloadNetworksDeleteVMGroupFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksDeleteVMGroupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksDeleteVMGroupFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksDeleteVMGroupFuture.Result.
func (future *WorkloadNetworksDeleteVMGroupFuture) result(client WorkloadNetworksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksDeleteVMGroupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksDeleteVMGroupFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkloadNetworkSegment NSX Segment
type WorkloadNetworkSegment struct {
	autorest.Response `json:"-"`
	// WorkloadNetworkSegmentProperties - The properties of a Workload Segment proxy resource.
	*WorkloadNetworkSegmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkSegment.
func (wns WorkloadNetworkSegment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wns.WorkloadNetworkSegmentProperties != nil {
		objectMap["properties"] = wns.WorkloadNetworkSegmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadNetworkSegment struct.
func (wns *WorkloadNetworkSegment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadNetworkSegmentProperties WorkloadNetworkSegmentProperties
				err = json.Unmarshal(*v, &workloadNetworkSegmentProperties)
				if err != nil {
					return err
				}
				wns.WorkloadNetworkSegmentProperties = &workloadNetworkSegmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wns.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wns.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wns.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadNetworkSegmentPortVif ports and any VIF attached to segment.
type WorkloadNetworkSegmentPortVif struct {
	// PortName - Name of port or VIF attached to segment.
	PortName *string `json:"portName,omitempty"`
}

// WorkloadNetworkSegmentProperties NSX Segment Properties
type WorkloadNetworkSegmentProperties struct {
	// DisplayName - Display name of the segment.
	DisplayName *string `json:"displayName,omitempty"`
	// ConnectedGateway - Gateway which to connect segment to.
	ConnectedGateway *string `json:"connectedGateway,omitempty"`
	// Subnet - Subnet which to connect segment to.
	Subnet *WorkloadNetworkSegmentSubnet `json:"subnet,omitempty"`
	// PortVif - READ-ONLY; Port Vif which segment is associated with.
	PortVif *[]WorkloadNetworkSegmentPortVif `json:"portVif,omitempty"`
	// Status - READ-ONLY; Segment status. Possible values include: 'SegmentStatusEnumSUCCESSFAILURE'
	Status SegmentStatusEnum `json:"status,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'WorkloadNetworkSegmentProvisioningStateSucceeded', 'WorkloadNetworkSegmentProvisioningStateFailed', 'WorkloadNetworkSegmentProvisioningStateBuilding', 'WorkloadNetworkSegmentProvisioningStateDeleting', 'WorkloadNetworkSegmentProvisioningStateUpdating'
	ProvisioningState WorkloadNetworkSegmentProvisioningState `json:"provisioningState,omitempty"`
	// Revision - NSX revision number.
	Revision *int64 `json:"revision,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkSegmentProperties.
func (wnsp WorkloadNetworkSegmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnsp.DisplayName != nil {
		objectMap["displayName"] = wnsp.DisplayName
	}
	if wnsp.ConnectedGateway != nil {
		objectMap["connectedGateway"] = wnsp.ConnectedGateway
	}
	if wnsp.Subnet != nil {
		objectMap["subnet"] = wnsp.Subnet
	}
	if wnsp.Revision != nil {
		objectMap["revision"] = wnsp.Revision
	}
	return json.Marshal(objectMap)
}

// WorkloadNetworkSegmentsList a list of NSX Segments
type WorkloadNetworkSegmentsList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]WorkloadNetworkSegment `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkloadNetworkSegmentsListIterator provides access to a complete listing of WorkloadNetworkSegment
// values.
type WorkloadNetworkSegmentsListIterator struct {
	i    int
	page WorkloadNetworkSegmentsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadNetworkSegmentsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkSegmentsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadNetworkSegmentsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadNetworkSegmentsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadNetworkSegmentsListIterator) Response() WorkloadNetworkSegmentsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadNetworkSegmentsListIterator) Value() WorkloadNetworkSegment {
	if !iter.page.NotDone() {
		return WorkloadNetworkSegment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadNetworkSegmentsListIterator type.
func NewWorkloadNetworkSegmentsListIterator(page WorkloadNetworkSegmentsListPage) WorkloadNetworkSegmentsListIterator {
	return WorkloadNetworkSegmentsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wnsl WorkloadNetworkSegmentsList) IsEmpty() bool {
	return wnsl.Value == nil || len(*wnsl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wnsl WorkloadNetworkSegmentsList) hasNextLink() bool {
	return wnsl.NextLink != nil && len(*wnsl.NextLink) != 0
}

// workloadNetworkSegmentsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wnsl WorkloadNetworkSegmentsList) workloadNetworkSegmentsListPreparer(ctx context.Context) (*http.Request, error) {
	if !wnsl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wnsl.NextLink)))
}

// WorkloadNetworkSegmentsListPage contains a page of WorkloadNetworkSegment values.
type WorkloadNetworkSegmentsListPage struct {
	fn   func(context.Context, WorkloadNetworkSegmentsList) (WorkloadNetworkSegmentsList, error)
	wnsl WorkloadNetworkSegmentsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadNetworkSegmentsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkSegmentsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wnsl)
		if err != nil {
			return err
		}
		page.wnsl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadNetworkSegmentsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadNetworkSegmentsListPage) NotDone() bool {
	return !page.wnsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadNetworkSegmentsListPage) Response() WorkloadNetworkSegmentsList {
	return page.wnsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadNetworkSegmentsListPage) Values() []WorkloadNetworkSegment {
	if page.wnsl.IsEmpty() {
		return nil
	}
	return *page.wnsl.Value
}

// Creates a new instance of the WorkloadNetworkSegmentsListPage type.
func NewWorkloadNetworkSegmentsListPage(cur WorkloadNetworkSegmentsList, getNextPage func(context.Context, WorkloadNetworkSegmentsList) (WorkloadNetworkSegmentsList, error)) WorkloadNetworkSegmentsListPage {
	return WorkloadNetworkSegmentsListPage{
		fn:   getNextPage,
		wnsl: cur,
	}
}

// WorkloadNetworkSegmentSubnet subnet configuration for segment
type WorkloadNetworkSegmentSubnet struct {
	// DhcpRanges - DHCP Range assigned for subnet.
	DhcpRanges *[]string `json:"dhcpRanges,omitempty"`
	// GatewayAddress - Gateway address.
	GatewayAddress *string `json:"gatewayAddress,omitempty"`
}

// WorkloadNetworksUpdateDhcpFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksUpdateDhcpFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkDhcp, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksUpdateDhcpFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksUpdateDhcpFuture.Result.
func (future *WorkloadNetworksUpdateDhcpFuture) result(client WorkloadNetworksClient) (wnd WorkloadNetworkDhcp, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdateDhcpFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wnd.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksUpdateDhcpFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wnd.Response.Response, err = future.GetResult(sender); err == nil && wnd.Response.Response.StatusCode != http.StatusNoContent {
		wnd, err = client.UpdateDhcpResponder(wnd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdateDhcpFuture", "Result", wnd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksUpdatePortMirroringFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksUpdatePortMirroringFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkPortMirroring, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksUpdatePortMirroringFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksUpdatePortMirroringFuture.Result.
func (future *WorkloadNetworksUpdatePortMirroringFuture) result(client WorkloadNetworksClient) (wnpm WorkloadNetworkPortMirroring, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdatePortMirroringFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wnpm.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksUpdatePortMirroringFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wnpm.Response.Response, err = future.GetResult(sender); err == nil && wnpm.Response.Response.StatusCode != http.StatusNoContent {
		wnpm, err = client.UpdatePortMirroringResponder(wnpm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdatePortMirroringFuture", "Result", wnpm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksUpdateSegmentsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksUpdateSegmentsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkSegment, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksUpdateSegmentsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksUpdateSegmentsFuture.Result.
func (future *WorkloadNetworksUpdateSegmentsFuture) result(client WorkloadNetworksClient) (wns WorkloadNetworkSegment, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdateSegmentsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wns.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksUpdateSegmentsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wns.Response.Response, err = future.GetResult(sender); err == nil && wns.Response.Response.StatusCode != http.StatusNoContent {
		wns, err = client.UpdateSegmentsResponder(wns.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdateSegmentsFuture", "Result", wns.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworksUpdateVMGroupFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkloadNetworksUpdateVMGroupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkloadNetworksClient) (WorkloadNetworkVMGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkloadNetworksUpdateVMGroupFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkloadNetworksUpdateVMGroupFuture.Result.
func (future *WorkloadNetworksUpdateVMGroupFuture) result(client WorkloadNetworksClient) (wnvg WorkloadNetworkVMGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdateVMGroupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wnvg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("avs.WorkloadNetworksUpdateVMGroupFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wnvg.Response.Response, err = future.GetResult(sender); err == nil && wnvg.Response.Response.StatusCode != http.StatusNoContent {
		wnvg, err = client.UpdateVMGroupResponder(wnvg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "avs.WorkloadNetworksUpdateVMGroupFuture", "Result", wnvg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkloadNetworkVirtualMachine NSX Virtual Machine
type WorkloadNetworkVirtualMachine struct {
	autorest.Response `json:"-"`
	// WorkloadNetworkVirtualMachineProperties - Virtual machine properties.
	*WorkloadNetworkVirtualMachineProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkVirtualMachine.
func (wnvm WorkloadNetworkVirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnvm.WorkloadNetworkVirtualMachineProperties != nil {
		objectMap["properties"] = wnvm.WorkloadNetworkVirtualMachineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadNetworkVirtualMachine struct.
func (wnvm *WorkloadNetworkVirtualMachine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadNetworkVirtualMachineProperties WorkloadNetworkVirtualMachineProperties
				err = json.Unmarshal(*v, &workloadNetworkVirtualMachineProperties)
				if err != nil {
					return err
				}
				wnvm.WorkloadNetworkVirtualMachineProperties = &workloadNetworkVirtualMachineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wnvm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wnvm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wnvm.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadNetworkVirtualMachineProperties NSX Virtual Machine Properties
type WorkloadNetworkVirtualMachineProperties struct {
	// DisplayName - Display name of the VM.
	DisplayName *string `json:"displayName,omitempty"`
	// VMType - READ-ONLY; Virtual machine type. Possible values include: 'REGULAREDGESERVICE'
	VMType VMTypeEnum `json:"vmType,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkVirtualMachineProperties.
func (wnvmp WorkloadNetworkVirtualMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnvmp.DisplayName != nil {
		objectMap["displayName"] = wnvmp.DisplayName
	}
	return json.Marshal(objectMap)
}

// WorkloadNetworkVirtualMachinesList a list of NSX Virtual Machines
type WorkloadNetworkVirtualMachinesList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]WorkloadNetworkVirtualMachine `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkloadNetworkVirtualMachinesListIterator provides access to a complete listing of
// WorkloadNetworkVirtualMachine values.
type WorkloadNetworkVirtualMachinesListIterator struct {
	i    int
	page WorkloadNetworkVirtualMachinesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadNetworkVirtualMachinesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkVirtualMachinesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadNetworkVirtualMachinesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadNetworkVirtualMachinesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadNetworkVirtualMachinesListIterator) Response() WorkloadNetworkVirtualMachinesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadNetworkVirtualMachinesListIterator) Value() WorkloadNetworkVirtualMachine {
	if !iter.page.NotDone() {
		return WorkloadNetworkVirtualMachine{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadNetworkVirtualMachinesListIterator type.
func NewWorkloadNetworkVirtualMachinesListIterator(page WorkloadNetworkVirtualMachinesListPage) WorkloadNetworkVirtualMachinesListIterator {
	return WorkloadNetworkVirtualMachinesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wnvml WorkloadNetworkVirtualMachinesList) IsEmpty() bool {
	return wnvml.Value == nil || len(*wnvml.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wnvml WorkloadNetworkVirtualMachinesList) hasNextLink() bool {
	return wnvml.NextLink != nil && len(*wnvml.NextLink) != 0
}

// workloadNetworkVirtualMachinesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wnvml WorkloadNetworkVirtualMachinesList) workloadNetworkVirtualMachinesListPreparer(ctx context.Context) (*http.Request, error) {
	if !wnvml.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wnvml.NextLink)))
}

// WorkloadNetworkVirtualMachinesListPage contains a page of WorkloadNetworkVirtualMachine values.
type WorkloadNetworkVirtualMachinesListPage struct {
	fn    func(context.Context, WorkloadNetworkVirtualMachinesList) (WorkloadNetworkVirtualMachinesList, error)
	wnvml WorkloadNetworkVirtualMachinesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadNetworkVirtualMachinesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkVirtualMachinesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wnvml)
		if err != nil {
			return err
		}
		page.wnvml = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadNetworkVirtualMachinesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadNetworkVirtualMachinesListPage) NotDone() bool {
	return !page.wnvml.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadNetworkVirtualMachinesListPage) Response() WorkloadNetworkVirtualMachinesList {
	return page.wnvml
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadNetworkVirtualMachinesListPage) Values() []WorkloadNetworkVirtualMachine {
	if page.wnvml.IsEmpty() {
		return nil
	}
	return *page.wnvml.Value
}

// Creates a new instance of the WorkloadNetworkVirtualMachinesListPage type.
func NewWorkloadNetworkVirtualMachinesListPage(cur WorkloadNetworkVirtualMachinesList, getNextPage func(context.Context, WorkloadNetworkVirtualMachinesList) (WorkloadNetworkVirtualMachinesList, error)) WorkloadNetworkVirtualMachinesListPage {
	return WorkloadNetworkVirtualMachinesListPage{
		fn:    getNextPage,
		wnvml: cur,
	}
}

// WorkloadNetworkVMGroup NSX VM Group
type WorkloadNetworkVMGroup struct {
	autorest.Response `json:"-"`
	// WorkloadNetworkVMGroupProperties - VM Group properties.
	*WorkloadNetworkVMGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkVMGroup.
func (wnvg WorkloadNetworkVMGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnvg.WorkloadNetworkVMGroupProperties != nil {
		objectMap["properties"] = wnvg.WorkloadNetworkVMGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadNetworkVMGroup struct.
func (wnvg *WorkloadNetworkVMGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workloadNetworkVMGroupProperties WorkloadNetworkVMGroupProperties
				err = json.Unmarshal(*v, &workloadNetworkVMGroupProperties)
				if err != nil {
					return err
				}
				wnvg.WorkloadNetworkVMGroupProperties = &workloadNetworkVMGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wnvg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wnvg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wnvg.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkloadNetworkVMGroupProperties NSX VM Group Properties
type WorkloadNetworkVMGroupProperties struct {
	// DisplayName - Display name of the VM group.
	DisplayName *string `json:"displayName,omitempty"`
	// Members - Virtual machine members of this group.
	Members *[]string `json:"members,omitempty"`
	// Status - READ-ONLY; VM Group status. Possible values include: 'VMGroupStatusEnumSUCCESSFAILURE'
	Status VMGroupStatusEnum `json:"status,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'WorkloadNetworkVMGroupProvisioningStateSucceeded', 'WorkloadNetworkVMGroupProvisioningStateFailed', 'WorkloadNetworkVMGroupProvisioningStateBuilding', 'WorkloadNetworkVMGroupProvisioningStateDeleting', 'WorkloadNetworkVMGroupProvisioningStateUpdating'
	ProvisioningState WorkloadNetworkVMGroupProvisioningState `json:"provisioningState,omitempty"`
	// Revision - NSX revision number.
	Revision *int64 `json:"revision,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadNetworkVMGroupProperties.
func (wnvgp WorkloadNetworkVMGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wnvgp.DisplayName != nil {
		objectMap["displayName"] = wnvgp.DisplayName
	}
	if wnvgp.Members != nil {
		objectMap["members"] = wnvgp.Members
	}
	if wnvgp.Revision != nil {
		objectMap["revision"] = wnvgp.Revision
	}
	return json.Marshal(objectMap)
}

// WorkloadNetworkVMGroupsList a list of NSX VM Groups
type WorkloadNetworkVMGroupsList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The items on the page
	Value *[]WorkloadNetworkVMGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next page if any
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkloadNetworkVMGroupsListIterator provides access to a complete listing of WorkloadNetworkVMGroup
// values.
type WorkloadNetworkVMGroupsListIterator struct {
	i    int
	page WorkloadNetworkVMGroupsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadNetworkVMGroupsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkVMGroupsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadNetworkVMGroupsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadNetworkVMGroupsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadNetworkVMGroupsListIterator) Response() WorkloadNetworkVMGroupsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadNetworkVMGroupsListIterator) Value() WorkloadNetworkVMGroup {
	if !iter.page.NotDone() {
		return WorkloadNetworkVMGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadNetworkVMGroupsListIterator type.
func NewWorkloadNetworkVMGroupsListIterator(page WorkloadNetworkVMGroupsListPage) WorkloadNetworkVMGroupsListIterator {
	return WorkloadNetworkVMGroupsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wnvgl WorkloadNetworkVMGroupsList) IsEmpty() bool {
	return wnvgl.Value == nil || len(*wnvgl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wnvgl WorkloadNetworkVMGroupsList) hasNextLink() bool {
	return wnvgl.NextLink != nil && len(*wnvgl.NextLink) != 0
}

// workloadNetworkVMGroupsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wnvgl WorkloadNetworkVMGroupsList) workloadNetworkVMGroupsListPreparer(ctx context.Context) (*http.Request, error) {
	if !wnvgl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wnvgl.NextLink)))
}

// WorkloadNetworkVMGroupsListPage contains a page of WorkloadNetworkVMGroup values.
type WorkloadNetworkVMGroupsListPage struct {
	fn    func(context.Context, WorkloadNetworkVMGroupsList) (WorkloadNetworkVMGroupsList, error)
	wnvgl WorkloadNetworkVMGroupsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadNetworkVMGroupsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadNetworkVMGroupsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wnvgl)
		if err != nil {
			return err
		}
		page.wnvgl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadNetworkVMGroupsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadNetworkVMGroupsListPage) NotDone() bool {
	return !page.wnvgl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadNetworkVMGroupsListPage) Response() WorkloadNetworkVMGroupsList {
	return page.wnvgl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadNetworkVMGroupsListPage) Values() []WorkloadNetworkVMGroup {
	if page.wnvgl.IsEmpty() {
		return nil
	}
	return *page.wnvgl.Value
}

// Creates a new instance of the WorkloadNetworkVMGroupsListPage type.
func NewWorkloadNetworkVMGroupsListPage(cur WorkloadNetworkVMGroupsList, getNextPage func(context.Context, WorkloadNetworkVMGroupsList) (WorkloadNetworkVMGroupsList, error)) WorkloadNetworkVMGroupsListPage {
	return WorkloadNetworkVMGroupsListPage{
		fn:    getNextPage,
		wnvgl: cur,
	}
}
