package automanage

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/automanage/mgmt/2020-06-30-preview/automanage"

// Account definition of the Automanage account.
type Account struct {
	autorest.Response `json:"-"`
	// Identity - The identity of the Automanage account.
	Identity *AccountIdentity `json:"identity,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Identity != nil {
		objectMap["identity"] = a.Identity
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	return json.Marshal(objectMap)
}

// AccountIdentity identity for the Automanage account.
type AccountIdentity struct {
	// PrincipalID - READ-ONLY; The principal id of Automanage account identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id associated with the Automanage account.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of identity used for the Automanage account. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity. Possible values include: 'SystemAssigned', 'None'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountIdentity.
func (ai AccountIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ai.Type != "" {
		objectMap["type"] = ai.Type
	}
	return json.Marshal(objectMap)
}

// AccountList the response of the list Account operation.
type AccountList struct {
	autorest.Response `json:"-"`
	// Value - Result of the list Account operation.
	Value *[]Account `json:"value,omitempty"`
}

// AccountUpdate definition of the Automanage account.
type AccountUpdate struct {
	// Identity - The identity of the Automanage account.
	Identity *AccountIdentity `json:"identity,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AccountUpdate.
func (au AccountUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if au.Identity != nil {
		objectMap["identity"] = au.Identity
	}
	if au.Tags != nil {
		objectMap["tags"] = au.Tags
	}
	return json.Marshal(objectMap)
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// ConfigurationProfileAssignment configuration profile assignment is an association between a VM and
// automanage profile configuration.
type ConfigurationProfileAssignment struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the configuration profile assignment.
	Properties *ConfigurationProfileAssignmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationProfileAssignment.
func (cpa ConfigurationProfileAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpa.Properties != nil {
		objectMap["properties"] = cpa.Properties
	}
	return json.Marshal(objectMap)
}

// ConfigurationProfileAssignmentCompliance the compliance status for the configuration profile assignment.
type ConfigurationProfileAssignmentCompliance struct {
	// UpdateStatus - READ-ONLY; The state of compliance, which only appears in the response. Possible values include: 'UpdateStatusSucceeded', 'UpdateStatusFailed', 'UpdateStatusCreated'
	UpdateStatus UpdateStatus `json:"updateStatus,omitempty"`
}

// ConfigurationProfileAssignmentList the response of the list configuration profile assignment operation.
type ConfigurationProfileAssignmentList struct {
	autorest.Response `json:"-"`
	// Value - Result of the list configuration profile assignment operation.
	Value *[]ConfigurationProfileAssignment `json:"value,omitempty"`
}

// ConfigurationProfileAssignmentProperties automanage configuration profile assignment properties.
type ConfigurationProfileAssignmentProperties struct {
	// ConfigurationProfile - A value indicating configuration profile. Possible values include: 'AzurevirtualmachinebestpracticesDevTest', 'AzurevirtualmachinebestpracticesProduction'
	ConfigurationProfile ConfigurationProfile `json:"configurationProfile,omitempty"`
	// TargetID - The target VM resource URI
	TargetID *string `json:"targetId,omitempty"`
	// AccountID - The Automanage account ARM Resource URI
	AccountID *string `json:"accountId,omitempty"`
	// ConfigurationProfilePreferenceID - The configuration profile custom preferences ARM resource URI
	ConfigurationProfilePreferenceID *string `json:"configurationProfilePreferenceId,omitempty"`
	// ProvisioningState - READ-ONLY; The state of onboarding, which only appears in the response. Possible values include: 'Succeeded', 'Failed', 'Created'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Compliance - The configuration setting for the configuration profile.
	Compliance *ConfigurationProfileAssignmentCompliance `json:"compliance,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationProfileAssignmentProperties.
func (cpap ConfigurationProfileAssignmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpap.ConfigurationProfile != "" {
		objectMap["configurationProfile"] = cpap.ConfigurationProfile
	}
	if cpap.TargetID != nil {
		objectMap["targetId"] = cpap.TargetID
	}
	if cpap.AccountID != nil {
		objectMap["accountId"] = cpap.AccountID
	}
	if cpap.ConfigurationProfilePreferenceID != nil {
		objectMap["configurationProfilePreferenceId"] = cpap.ConfigurationProfilePreferenceID
	}
	if cpap.Compliance != nil {
		objectMap["compliance"] = cpap.Compliance
	}
	return json.Marshal(objectMap)
}

// ConfigurationProfileAssignmentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ConfigurationProfileAssignmentsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConfigurationProfileAssignmentsClient) (ConfigurationProfileAssignment, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConfigurationProfileAssignmentsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConfigurationProfileAssignmentsCreateOrUpdateFuture.Result.
func (future *ConfigurationProfileAssignmentsCreateOrUpdateFuture) result(client ConfigurationProfileAssignmentsClient) (cpa ConfigurationProfileAssignment, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "automanage.ConfigurationProfileAssignmentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cpa.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("automanage.ConfigurationProfileAssignmentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cpa.Response.Response, err = future.GetResult(sender); err == nil && cpa.Response.Response.StatusCode != http.StatusNoContent {
		cpa, err = client.CreateOrUpdateResponder(cpa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "automanage.ConfigurationProfileAssignmentsCreateOrUpdateFuture", "Result", cpa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ConfigurationProfilePreference definition of the configuration profile preference.
type ConfigurationProfilePreference struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the configuration profile preference.
	Properties *ConfigurationProfilePreferenceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationProfilePreference.
func (cpp ConfigurationProfilePreference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpp.Properties != nil {
		objectMap["properties"] = cpp.Properties
	}
	if cpp.Tags != nil {
		objectMap["tags"] = cpp.Tags
	}
	if cpp.Location != nil {
		objectMap["location"] = cpp.Location
	}
	return json.Marshal(objectMap)
}

// ConfigurationProfilePreferenceAntiMalware automanage configuration profile Antimalware preferences.
type ConfigurationProfilePreferenceAntiMalware struct {
	// EnableRealTimeProtection - Enables or disables Real Time Protection. Possible values include: 'True', 'False'
	EnableRealTimeProtection EnableRealTimeProtection `json:"enableRealTimeProtection,omitempty"`
	// Exclusions - Extensions, Paths and Processes that must be excluded from scan
	Exclusions interface{} `json:"exclusions,omitempty"`
	// RunScheduledScan - Enables or disables a periodic scan for antimalware. Possible values include: 'RunScheduledScanTrue', 'RunScheduledScanFalse'
	RunScheduledScan RunScheduledScan `json:"runScheduledScan,omitempty"`
	// ScanType - Type of scheduled scan. Possible values include: 'Quick', 'Full'
	ScanType ScanType `json:"scanType,omitempty"`
	// ScanDay - Schedule scan settings day
	ScanDay *string `json:"scanDay,omitempty"`
	// ScanTimeInMinutes - Schedule scan settings time
	ScanTimeInMinutes *string `json:"scanTimeInMinutes,omitempty"`
}

// ConfigurationProfilePreferenceList the response of the list ConfigurationProfilePreference operation.
type ConfigurationProfilePreferenceList struct {
	autorest.Response `json:"-"`
	// Value - Result of the list ConfigurationProfilePreference operation.
	Value *[]ConfigurationProfilePreference `json:"value,omitempty"`
}

// ConfigurationProfilePreferenceProperties automanage configuration profile preference properties.
type ConfigurationProfilePreferenceProperties struct {
	// VMBackup - The custom preferences for Azure VM Backup.
	VMBackup *ConfigurationProfilePreferenceVMBackup `json:"vmBackup,omitempty"`
	// AntiMalware - The custom preferences for Azure Antimalware.
	AntiMalware *ConfigurationProfilePreferenceAntiMalware `json:"antiMalware,omitempty"`
}

// ConfigurationProfilePreferenceUpdate definition of the configuration profile preference.
type ConfigurationProfilePreferenceUpdate struct {
	// Properties - Properties of the configuration profile preference.
	Properties *ConfigurationProfilePreferenceProperties `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ConfigurationProfilePreferenceUpdate.
func (cppu ConfigurationProfilePreferenceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cppu.Properties != nil {
		objectMap["properties"] = cppu.Properties
	}
	if cppu.Tags != nil {
		objectMap["tags"] = cppu.Tags
	}
	return json.Marshal(objectMap)
}

// ConfigurationProfilePreferenceVMBackup automanage configuration profile VM Backup preferences.
type ConfigurationProfilePreferenceVMBackup struct {
	// TimeZone - TimeZone optional input as string. For example: Pacific Standard Time
	TimeZone *string `json:"timeZone,omitempty"`
	// InstantRpRetentionRangeInDays - Instant RP retention policy range in days
	InstantRpRetentionRangeInDays *int32 `json:"instantRpRetentionRangeInDays,omitempty"`
	// RetentionPolicy - Retention policy with the details on backup copy retention ranges.
	RetentionPolicy *string `json:"retentionPolicy,omitempty"`
	// SchedulePolicy - Backup schedule specified as part of backup policy.
	SchedulePolicy *string `json:"schedulePolicy,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// Operation automanage REST API operation
type Operation struct {
	// Name - Operation name: For ex. providers/Microsoft.Automanage/configurationProfileAssignments/write or read
	Name *string `json:"name,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *string `json:"isDataAction,omitempty"`
	// Display - Provider, Resource, Operation and description values.
	Display *OperationDisplay `json:"display,omitempty"`
	// OperationProperties - Provider, Resource, Operation and description values.
	*OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.IsDataAction != nil {
		objectMap["isDataAction"] = o.IsDataAction
	}
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.OperationProperties != nil {
		objectMap["properties"] = o.OperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Operation struct.
func (o *Operation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "isDataAction":
			if v != nil {
				var isDataAction string
				err = json.Unmarshal(*v, &isDataAction)
				if err != nil {
					return err
				}
				o.IsDataAction = &isDataAction
			}
		case "display":
			if v != nil {
				var display OperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				o.Display = &display
			}
		case "properties":
			if v != nil {
				var operationProperties OperationProperties
				err = json.Unmarshal(*v, &operationProperties)
				if err != nil {
					return err
				}
				o.OperationProperties = &operationProperties
			}
		}
	}

	return nil
}

// OperationDisplay provider, Resource, Operation and description values.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Automanage
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed:  For ex.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description about operation.
	Description *string `json:"description,omitempty"`
}

// OperationList the response model for the list of Automanage operations
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - List of Automanage operations supported by the Automanage resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// OperationProperties provider, Resource, Operation and description values.
type OperationProperties struct {
	// StatusCode - Service provider: Microsoft.Automanage
	StatusCode *string `json:"statusCode,omitempty"`
}

// ProxyResource the resource model definition for an Azure Resource Manager proxy resource. It will have
// everything other than required location and tags
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UpdateResource represents an update resource
type UpdateResource struct {
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for UpdateResource.
func (ur UpdateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ur.Tags != nil {
		objectMap["tags"] = ur.Tags
	}
	return json.Marshal(objectMap)
}
