package mariadb

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/mariadb/mgmt/2018-06-01/mariadb"

// Advisor represents a recommendation action advisor.
type Advisor struct {
	autorest.Response `json:"-"`
	// Properties - The properties of a recommendation action advisor.
	Properties interface{} `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Advisor.
func (a Advisor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Properties != nil {
		objectMap["properties"] = a.Properties
	}
	return json.Marshal(objectMap)
}

// AdvisorsResultList a list of query statistics.
type AdvisorsResultList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of recommendation action advisors.
	Value *[]Advisor `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AdvisorsResultListIterator provides access to a complete listing of Advisor values.
type AdvisorsResultListIterator struct {
	i    int
	page AdvisorsResultListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AdvisorsResultListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AdvisorsResultListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AdvisorsResultListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AdvisorsResultListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AdvisorsResultListIterator) Response() AdvisorsResultList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AdvisorsResultListIterator) Value() Advisor {
	if !iter.page.NotDone() {
		return Advisor{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AdvisorsResultListIterator type.
func NewAdvisorsResultListIterator(page AdvisorsResultListPage) AdvisorsResultListIterator {
	return AdvisorsResultListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arl AdvisorsResultList) IsEmpty() bool {
	return arl.Value == nil || len(*arl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (arl AdvisorsResultList) hasNextLink() bool {
	return arl.NextLink != nil && len(*arl.NextLink) != 0
}

// advisorsResultListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arl AdvisorsResultList) advisorsResultListPreparer(ctx context.Context) (*http.Request, error) {
	if !arl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arl.NextLink)))
}

// AdvisorsResultListPage contains a page of Advisor values.
type AdvisorsResultListPage struct {
	fn  func(context.Context, AdvisorsResultList) (AdvisorsResultList, error)
	arl AdvisorsResultList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AdvisorsResultListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AdvisorsResultListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.arl)
		if err != nil {
			return err
		}
		page.arl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AdvisorsResultListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AdvisorsResultListPage) NotDone() bool {
	return !page.arl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AdvisorsResultListPage) Response() AdvisorsResultList {
	return page.arl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AdvisorsResultListPage) Values() []Advisor {
	if page.arl.IsEmpty() {
		return nil
	}
	return *page.arl.Value
}

// Creates a new instance of the AdvisorsResultListPage type.
func NewAdvisorsResultListPage(cur AdvisorsResultList, getNextPage func(context.Context, AdvisorsResultList) (AdvisorsResultList, error)) AdvisorsResultListPage {
	return AdvisorsResultListPage{
		fn:  getNextPage,
		arl: cur,
	}
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// CloudError an error response from the Batch service.
type CloudError struct {
	Error *ErrorResponse `json:"error,omitempty"`
}

// Configuration represents a Configuration.
type Configuration struct {
	autorest.Response `json:"-"`
	// ConfigurationProperties - The properties of a configuration.
	*ConfigurationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Configuration.
func (c Configuration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ConfigurationProperties != nil {
		objectMap["properties"] = c.ConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Configuration struct.
func (c *Configuration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var configurationProperties ConfigurationProperties
				err = json.Unmarshal(*v, &configurationProperties)
				if err != nil {
					return err
				}
				c.ConfigurationProperties = &configurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ConfigurationListResult a list of server configurations.
type ConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server configurations.
	Value *[]Configuration `json:"value,omitempty"`
}

// ConfigurationProperties the properties of a configuration.
type ConfigurationProperties struct {
	// Value - Value of the configuration.
	Value *string `json:"value,omitempty"`
	// Description - READ-ONLY; Description of the configuration.
	Description *string `json:"description,omitempty"`
	// DefaultValue - READ-ONLY; Default value of the configuration.
	DefaultValue *string `json:"defaultValue,omitempty"`
	// DataType - READ-ONLY; Data type of the configuration.
	DataType *string `json:"dataType,omitempty"`
	// AllowedValues - READ-ONLY; Allowed values of the configuration.
	AllowedValues *string `json:"allowedValues,omitempty"`
	// Source - Source of the configuration.
	Source *string `json:"source,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationProperties.
func (cp ConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.Value != nil {
		objectMap["value"] = cp.Value
	}
	if cp.Source != nil {
		objectMap["source"] = cp.Source
	}
	return json.Marshal(objectMap)
}

// ConfigurationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConfigurationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConfigurationsClient) (Configuration, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConfigurationsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConfigurationsCreateOrUpdateFuture.Result.
func (future *ConfigurationsCreateOrUpdateFuture) result(client ConfigurationsClient) (c Configuration, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mariadb.ConfigurationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("mariadb.ConfigurationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateOrUpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "mariadb.ConfigurationsCreateOrUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CreateRecommendedActionSessionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CreateRecommendedActionSessionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BaseClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CreateRecommendedActionSessionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CreateRecommendedActionSessionFuture.Result.
func (future *CreateRecommendedActionSessionFuture) result(client BaseClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mariadb.CreateRecommendedActionSessionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("mariadb.CreateRecommendedActionSessionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Database represents a Database.
type Database struct {
	autorest.Response `json:"-"`
	// DatabaseProperties - The properties of a database.
	*DatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Database.
func (d Database) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DatabaseProperties != nil {
		objectMap["properties"] = d.DatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Database struct.
func (d *Database) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				d.DatabaseProperties = &databaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseListResult a List of databases.
type DatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of databases housed in a server
	Value *[]Database `json:"value,omitempty"`
}

// DatabaseProperties the properties of a database.
type DatabaseProperties struct {
	// Charset - The charset of the database.
	Charset *string `json:"charset,omitempty"`
	// Collation - The collation of the database.
	Collation *string `json:"collation,omitempty"`
}

// DatabasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesCreateOrUpdateFuture.Result.
func (future *DatabasesCreateOrUpdateFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mariadb.DatabasesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("mariadb.DatabasesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "mariadb.DatabasesCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesDeleteFuture.Result.
func (future *DatabasesDeleteFuture) result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mariadb.DatabasesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("mariadb.DatabasesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.)
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponse `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// FirewallRule represents a server firewall rule.
type FirewallRule struct {
	autorest.Response `json:"-"`
	// FirewallRuleProperties - The properties of a firewall rule.
	*FirewallRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallRule.
func (fr FirewallRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fr.FirewallRuleProperties != nil {
		objectMap["properties"] = fr.FirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallRule struct.
func (fr *FirewallRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var firewallRuleProperties FirewallRuleProperties
				err = json.Unmarshal(*v, &firewallRuleProperties)
				if err != nil {
					return err
				}
				fr.FirewallRuleProperties = &firewallRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fr.Type = &typeVar
			}
		}
	}

	return nil
}

// FirewallRuleListResult a list of firewall rules.
type FirewallRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of firewall rules in a server.
	Value *[]FirewallRule `json:"value,omitempty"`
}

// FirewallRuleProperties the properties of a server firewall rule.
type FirewallRuleProperties struct {
	// StartIPAddress - The start IP address of the server firewall rule. Must be IPv4 format.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - The end IP address of the server firewall rule. Must be IPv4 format.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
}

// FirewallRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FirewallRulesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FirewallRulesClient) (FirewallRule, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FirewallRulesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FirewallRulesCreateOrUpdateFuture.Result.
func (future *FirewallRulesCreateOrUpdateFuture) result(client FirewallRulesClient) (fr FirewallRule, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mariadb.FirewallRulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		fr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("mariadb.FirewallRulesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fr.Response.Response, err = future.GetResult(sender); err == nil && fr.Response.Response.StatusCode != http.StatusNoContent {
		fr, err = client.CreateOrUpdateResponder(fr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "mariadb.FirewallRulesCreateOrUpdateFuture", "Result", fr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FirewallRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FirewallRulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FirewallRulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FirewallRulesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FirewallRulesDeleteFuture.Result.
func (future *FirewallRulesDeleteFuture) result(client FirewallRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mariadb.FirewallRulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("mariadb.FirewallRulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LogFile represents a log file.
type LogFile struct {
	// LogFileProperties - The properties of the log file.
	*LogFileProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LogFile.
func (lf LogFile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lf.LogFileProperties != nil {
		objectMap["properties"] = lf.LogFileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LogFile struct.
func (lf *LogFile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var logFileProperties LogFileProperties
				err = json.Unmarshal(*v, &logFileProperties)
				if err != nil {
					return err
				}
				lf.LogFileProperties = &logFileProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lf.Type = &typeVar
			}
		}
	}

	return nil
}

// LogFileListResult a list of log files.
type LogFileListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of log files.
	Value *[]LogFile `json:"value,omitempty"`
}

// LogFileProperties the properties of a log file.
type LogFileProperties struct {
	// SizeInKB - Size of the log file.
	SizeInKB *int64 `json:"sizeInKB,omitempty"`
	// CreatedTime - READ-ONLY; Creation timestamp of the log file.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// LastModifiedTime - READ-ONLY; Last modified timestamp of the log file.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// Type - Type of the log file.
	Type *string `json:"type,omitempty"`
	// URL - READ-ONLY; The url to download the log file from.
	URL *string `json:"url,omitempty"`
}

// MarshalJSON is the custom marshaler for LogFileProperties.
func (lfp LogFileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lfp.SizeInKB != nil {
		objectMap["sizeInKB"] = lfp.SizeInKB
	}
	if lfp.Type != nil {
		objectMap["type"] = lfp.Type
	}
	return json.Marshal(objectMap)
}

// NameAvailability represents a resource name availability.
type NameAvailability struct {
	autorest.Response `json:"-"`
	// Message - Error Message.
	Message *string `json:"message,omitempty"`
	// NameAvailable - Indicates whether the resource name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - Reason for name being unavailable.
	Reason *string `json:"reason,omitempty"`
}

// NameAvailabilityRequest request from client to check resource name availability.
type NameAvailabilityRequest struct {
	// Name - Resource name to verify.
	Name *string `json:"name,omitempty"`
	// Type - Resource type used for verification.
	Type *string `json:"type,omitempty"`
}

// Operation REST API operation definition.
type Operation struct {
	// Name - READ-ONLY; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; The localized display information for this particular operation or action.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation. Possible values include: 'NotSpecified', 'User', 'System'
	Origin OperationOrigin `json:"origin,omitempty"`
	// Properties - READ-ONLY; Additional descriptions for the operation.
	Properties map[string]interface{} `json:"properties"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Operation resource provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Localized friendly name for the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; Operation description.
	Description *string `json:"description,omitempty"`
}

// OperationListResult a list of resource provider operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of resource provider operations.
	Value *[]Operation `json:"value,omitempty"`
}

// PerformanceTierListResult a list of performance tiers.
type PerformanceTierListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of performance tiers
	Value *[]PerformanceTierProperties `json:"value,omitempty"`
}

// PerformanceTierProperties performance tier properties
type PerformanceTierProperties struct {
	// ID - ID of the performance tier.
	ID *string `json:"id,omitempty"`
	// ServiceLevelObjectives - Service level objectives associated with the performance tier
	ServiceLevelObjectives *[]PerformanceTierServiceLevelObjectives `json:"serviceLevelObjectives,omitempty"`
}

// PerformanceTierServiceLevelObjectives service level objectives for performance tier.
type PerformanceTierServiceLevelObjectives struct {
	// ID - ID for the service level objective.
	ID *string `json:"id,omitempty"`
	// Edition - Edition of the performance tier.
	Edition *string `json:"edition,omitempty"`
	// VCore - vCore associated with the service level objective
	VCore *int32 `json:"vCore,omitempty"`
	// HardwareGeneration - Hardware generation associated with the service level objective
	HardwareGeneration *string `json:"hardwareGeneration,omitempty"`
	// MaxBackupRetentionDays - Maximum Backup retention in days for the performance tier edition
	MaxBackupRetentionDays *int32 `json:"maxBackupRetentionDays,omitempty"`
	// MinBackupRetentionDays - Minimum Backup retention in days for the performance tier edition
	MinBackupRetentionDays *int32 `json:"minBackupRetentionDays,omitempty"`
	// MaxStorageMB - Max storage allowed for a server.
	MaxStorageMB *int32 `json:"maxStorageMB,omitempty"`
	// MinStorageMB - Max storage allowed for a server.
	MinStorageMB *int32 `json:"minStorageMB,omitempty"`
}

// PrivateEndpointConnection a private endpoint connection
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult a list of private endpoint connections.
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateEndpointConnectionListResultIterator provides access to a complete listing of
// PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultIterator struct {
	i    int
	page PrivateEndpointConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateEndpointConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateEndpointConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateEndpointConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateEndpointConnectionListResultIterator) Response() PrivateEndpointConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateEndpointConnectionListResultIterator) Value() PrivateEndpointConnection {
	if !iter.page.NotDone() {
		return PrivateEndpointConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateEndpointConnectionListResultIterator type.
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return PrivateEndpointConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (peclr PrivateEndpointConnectionListResult) IsEmpty() bool {
	return peclr.Value == nil || len(*peclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (peclr PrivateEndpointConnectionListResult) hasNextLink() bool {
	return peclr.NextLink != nil && len(*peclr.NextLink) != 0
}

// privateEndpointConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (peclr PrivateEndpointConnectionListResult) privateEndpointConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !peclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(peclr.NextLink)))
}

// PrivateEndpointConnectionListResultPage contains a page of PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultPage struct {
	fn    func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)
	peclr PrivateEndpointConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateEndpointConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.peclr)
		if err != nil {
			return err
		}
		page.peclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateEndpointConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateEndpointConnectionListResultPage) NotDone() bool {
	return !page.peclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateEndpointConnectionListResultPage) Response() PrivateEndpointConnectionListResult {
	return page.peclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateEndpointConnectionListResultPage) Values() []PrivateEndpointConnection {
	if page.peclr.IsEmpty() {
		return nil
	}
	return *page.peclr.Value
}

// Creates a new instance of the PrivateEndpointConnectionListResultPage type.
func NewPrivateEndpointConnectionListResultPage(cur PrivateEndpointConnectionListResult, getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return PrivateEndpointConnectionListResultPage{
		fn:    getNextPage,
		peclr: cur,
	}
}

// PrivateEndpointConnectionProperties properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - READ-ONLY; State of the private endpoint connection.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionProperties.
func (pecp PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecp.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = pecp.PrivateEndpoint
	}
	if pecp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = pecp.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type PrivateEndpointConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsCreateOrUpdateFuture.Result.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mariadb.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("mariadb.PrivateEndpointConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.CreateOrUpdateResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "mariadb.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mariadb.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("mariadb.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateEndpointConnectionsUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsUpdateTagsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsUpdateTagsFuture.Result.
func (future *PrivateEndpointConnectionsUpdateTagsFuture) result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mariadb.PrivateEndpointConnectionsUpdateTagsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("mariadb.PrivateEndpointConnectionsUpdateTagsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.UpdateTagsResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "mariadb.PrivateEndpointConnectionsUpdateTagsFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateEndpointProperty ...
type PrivateEndpointProperty struct {
	// ID - Resource id of the private endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// Properties - READ-ONLY; The private link resource group id.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]PrivateLinkResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateLinkResourceListResultIterator provides access to a complete listing of PrivateLinkResource
// values.
type PrivateLinkResourceListResultIterator struct {
	i    int
	page PrivateLinkResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateLinkResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateLinkResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateLinkResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateLinkResourceListResultIterator) Response() PrivateLinkResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateLinkResourceListResultIterator) Value() PrivateLinkResource {
	if !iter.page.NotDone() {
		return PrivateLinkResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateLinkResourceListResultIterator type.
func NewPrivateLinkResourceListResultIterator(page PrivateLinkResourceListResultPage) PrivateLinkResourceListResultIterator {
	return PrivateLinkResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plrlr PrivateLinkResourceListResult) IsEmpty() bool {
	return plrlr.Value == nil || len(*plrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plrlr PrivateLinkResourceListResult) hasNextLink() bool {
	return plrlr.NextLink != nil && len(*plrlr.NextLink) != 0
}

// privateLinkResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plrlr PrivateLinkResourceListResult) privateLinkResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plrlr.NextLink)))
}

// PrivateLinkResourceListResultPage contains a page of PrivateLinkResource values.
type PrivateLinkResourceListResultPage struct {
	fn    func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)
	plrlr PrivateLinkResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateLinkResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plrlr)
		if err != nil {
			return err
		}
		page.plrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateLinkResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateLinkResourceListResultPage) NotDone() bool {
	return !page.plrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateLinkResourceListResultPage) Response() PrivateLinkResourceListResult {
	return page.plrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateLinkResourceListResultPage) Values() []PrivateLinkResource {
	if page.plrlr.IsEmpty() {
		return nil
	}
	return *page.plrlr.Value
}

// Creates a new instance of the PrivateLinkResourceListResultPage type.
func NewPrivateLinkResourceListResultPage(cur PrivateLinkResourceListResult, getNextPage func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)) PrivateLinkResourceListResultPage {
	return PrivateLinkResourceListResultPage{
		fn:    getNextPage,
		plrlr: cur,
	}
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
}

// PrivateLinkServiceConnectionStateProperty ...
type PrivateLinkServiceConnectionStateProperty struct {
	// Status - The private link service connection status.
	Status *string `json:"status,omitempty"`
	// Description - The private link service connection description.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - READ-ONLY; The actions required for private link service connection.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkServiceConnectionStateProperty.
func (plscsp PrivateLinkServiceConnectionStateProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plscsp.Status != nil {
		objectMap["status"] = plscsp.Status
	}
	if plscsp.Description != nil {
		objectMap["description"] = plscsp.Description
	}
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// QueryStatistic represents a Query Statistic.
type QueryStatistic struct {
	autorest.Response `json:"-"`
	// QueryStatisticProperties - The properties of a query statistic.
	*QueryStatisticProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for QueryStatistic.
func (qs QueryStatistic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qs.QueryStatisticProperties != nil {
		objectMap["properties"] = qs.QueryStatisticProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for QueryStatistic struct.
func (qs *QueryStatistic) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var queryStatisticProperties QueryStatisticProperties
				err = json.Unmarshal(*v, &queryStatisticProperties)
				if err != nil {
					return err
				}
				qs.QueryStatisticProperties = &queryStatisticProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				qs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				qs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				qs.Type = &typeVar
			}
		}
	}

	return nil
}

// QueryStatisticProperties the properties of a query statistic.
type QueryStatisticProperties struct {
	// QueryID - Database query identifier.
	QueryID *string `json:"queryId,omitempty"`
	// StartTime - Observation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Observation end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// AggregationFunction - Aggregation function name.
	AggregationFunction *string `json:"aggregationFunction,omitempty"`
	// DatabaseNames - The list of database names.
	DatabaseNames *[]string `json:"databaseNames,omitempty"`
	// QueryExecutionCount - Number of query executions in this time interval.
	QueryExecutionCount *int64 `json:"queryExecutionCount,omitempty"`
	// MetricName - Metric name.
	MetricName *string `json:"metricName,omitempty"`
	// MetricDisplayName - Metric display name.
	MetricDisplayName *string `json:"metricDisplayName,omitempty"`
	// MetricValue - Metric value.
	MetricValue *float64 `json:"metricValue,omitempty"`
	// MetricValueUnit - Metric value unit.
	MetricValueUnit *string `json:"metricValueUnit,omitempty"`
}

// QueryText represents a Query Text.
type QueryText struct {
	autorest.Response `json:"-"`
	// QueryTextProperties - The properties of a query text.
	*QueryTextProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for QueryText.
func (qt QueryText) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qt.QueryTextProperties != nil {
		objectMap["properties"] = qt.QueryTextProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for QueryText struct.
func (qt *QueryText) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var queryTextProperties QueryTextProperties
				err = json.Unmarshal(*v, &queryTextProperties)
				if err != nil {
					return err
				}
				qt.QueryTextProperties = &queryTextProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				qt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				qt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				qt.Type = &typeVar
			}
		}
	}

	return nil
}

// QueryTextProperties the properties of a query text.
type QueryTextProperties struct {
	// QueryID - Query identifier unique to the server.
	QueryID *string `json:"queryId,omitempty"`
	// QueryText - Query text.
	QueryText *string `json:"queryText,omitempty"`
}

// QueryTextsResultList a list of query texts.
type QueryTextsResultList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of query texts.
	Value *[]QueryText `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// QueryTextsResultListIterator provides access to a complete listing of QueryText values.
type QueryTextsResultListIterator struct {
	i    int
	page QueryTextsResultListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *QueryTextsResultListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QueryTextsResultListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *QueryTextsResultListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter QueryTextsResultListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter QueryTextsResultListIterator) Response() QueryTextsResultList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter QueryTextsResultListIterator) Value() QueryText {
	if !iter.page.NotDone() {
		return QueryText{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the QueryTextsResultListIterator type.
func NewQueryTextsResultListIterator(page QueryTextsResultListPage) QueryTextsResultListIterator {
	return QueryTextsResultListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (qtrl QueryTextsResultList) IsEmpty() bool {
	return qtrl.Value == nil || len(*qtrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (qtrl QueryTextsResultList) hasNextLink() bool {
	return qtrl.NextLink != nil && len(*qtrl.NextLink) != 0
}

// queryTextsResultListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (qtrl QueryTextsResultList) queryTextsResultListPreparer(ctx context.Context) (*http.Request, error) {
	if !qtrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(qtrl.NextLink)))
}

// QueryTextsResultListPage contains a page of QueryText values.
type QueryTextsResultListPage struct {
	fn   func(context.Context, QueryTextsResultList) (QueryTextsResultList, error)
	qtrl QueryTextsResultList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *QueryTextsResultListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QueryTextsResultListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.qtrl)
		if err != nil {
			return err
		}
		page.qtrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *QueryTextsResultListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page QueryTextsResultListPage) NotDone() bool {
	return !page.qtrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page QueryTextsResultListPage) Response() QueryTextsResultList {
	return page.qtrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page QueryTextsResultListPage) Values() []QueryText {
	if page.qtrl.IsEmpty() {
		return nil
	}
	return *page.qtrl.Value
}

// Creates a new instance of the QueryTextsResultListPage type.
func NewQueryTextsResultListPage(cur QueryTextsResultList, getNextPage func(context.Context, QueryTextsResultList) (QueryTextsResultList, error)) QueryTextsResultListPage {
	return QueryTextsResultListPage{
		fn:   getNextPage,
		qtrl: cur,
	}
}

// RecommendationAction represents a Recommendation Action.
type RecommendationAction struct {
	autorest.Response `json:"-"`
	// RecommendationActionProperties - The properties of a recommendation action.
	*RecommendationActionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendationAction.
func (ra RecommendationAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ra.RecommendationActionProperties != nil {
		objectMap["properties"] = ra.RecommendationActionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecommendationAction struct.
func (ra *RecommendationAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recommendationActionProperties RecommendationActionProperties
				err = json.Unmarshal(*v, &recommendationActionProperties)
				if err != nil {
					return err
				}
				ra.RecommendationActionProperties = &recommendationActionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ra.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ra.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ra.Type = &typeVar
			}
		}
	}

	return nil
}

// RecommendationActionProperties the properties of a recommendation action.
type RecommendationActionProperties struct {
	// AdvisorName - Advisor name.
	AdvisorName *string `json:"advisorName,omitempty"`
	// SessionID - Recommendation action session identifier.
	SessionID *string `json:"sessionId,omitempty"`
	// ActionID - Recommendation action identifier.
	ActionID *int32 `json:"actionId,omitempty"`
	// CreatedTime - Recommendation action creation time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ExpirationTime - Recommendation action expiration time.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// Reason - Recommendation action reason.
	Reason *string `json:"reason,omitempty"`
	// RecommendationType - Recommendation action type.
	RecommendationType *string `json:"recommendationType,omitempty"`
	// Details - Recommendation action details.
	Details map[string]*string `json:"details"`
}

// MarshalJSON is the custom marshaler for RecommendationActionProperties.
func (rap RecommendationActionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rap.AdvisorName != nil {
		objectMap["advisorName"] = rap.AdvisorName
	}
	if rap.SessionID != nil {
		objectMap["sessionId"] = rap.SessionID
	}
	if rap.ActionID != nil {
		objectMap["actionId"] = rap.ActionID
	}
	if rap.CreatedTime != nil {
		objectMap["createdTime"] = rap.CreatedTime
	}
	if rap.ExpirationTime != nil {
		objectMap["expirationTime"] = rap.ExpirationTime
	}
	if rap.Reason != nil {
		objectMap["reason"] = rap.Reason
	}
	if rap.RecommendationType != nil {
		objectMap["recommendationType"] = rap.RecommendationType
	}
	if rap.Details != nil {
		objectMap["details"] = rap.Details
	}
	return json.Marshal(objectMap)
}

// RecommendationActionsResultList a list of recommendation actions.
type RecommendationActionsResultList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of recommendation action advisors.
	Value *[]RecommendationAction `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RecommendationActionsResultListIterator provides access to a complete listing of RecommendationAction
// values.
type RecommendationActionsResultListIterator struct {
	i    int
	page RecommendationActionsResultListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RecommendationActionsResultListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecommendationActionsResultListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RecommendationActionsResultListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RecommendationActionsResultListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RecommendationActionsResultListIterator) Response() RecommendationActionsResultList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RecommendationActionsResultListIterator) Value() RecommendationAction {
	if !iter.page.NotDone() {
		return RecommendationAction{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RecommendationActionsResultListIterator type.
func NewRecommendationActionsResultListIterator(page RecommendationActionsResultListPage) RecommendationActionsResultListIterator {
	return RecommendationActionsResultListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rarl RecommendationActionsResultList) IsEmpty() bool {
	return rarl.Value == nil || len(*rarl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rarl RecommendationActionsResultList) hasNextLink() bool {
	return rarl.NextLink != nil && len(*rarl.NextLink) != 0
}

// recommendationActionsResultListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rarl RecommendationActionsResultList) recommendationActionsResultListPreparer(ctx context.Context) (*http.Request, error) {
	if !rarl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rarl.NextLink)))
}

// RecommendationActionsResultListPage contains a page of RecommendationAction values.
type RecommendationActionsResultListPage struct {
	fn   func(context.Context, RecommendationActionsResultList) (RecommendationActionsResultList, error)
	rarl RecommendationActionsResultList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RecommendationActionsResultListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecommendationActionsResultListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rarl)
		if err != nil {
			return err
		}
		page.rarl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RecommendationActionsResultListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RecommendationActionsResultListPage) NotDone() bool {
	return !page.rarl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RecommendationActionsResultListPage) Response() RecommendationActionsResultList {
	return page.rarl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RecommendationActionsResultListPage) Values() []RecommendationAction {
	if page.rarl.IsEmpty() {
		return nil
	}
	return *page.rarl.Value
}

// Creates a new instance of the RecommendationActionsResultListPage type.
func NewRecommendationActionsResultListPage(cur RecommendationActionsResultList, getNextPage func(context.Context, RecommendationActionsResultList) (RecommendationActionsResultList, error)) RecommendationActionsResultListPage {
	return RecommendationActionsResultListPage{
		fn:   getNextPage,
		rarl: cur,
	}
}

// RecommendedActionSessionsOperationStatus recommendation action session operation status.
type RecommendedActionSessionsOperationStatus struct {
	autorest.Response `json:"-"`
	// Name - Operation identifier.
	Name *string `json:"name,omitempty"`
	// StartTime - Operation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// Status - Operation status.
	Status *string `json:"status,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// SecurityAlertPolicyProperties properties of a security alert policy.
type SecurityAlertPolicyProperties struct {
	// State - Specifies the state of the policy, whether it is enabled or disabled. Possible values include: 'ServerSecurityAlertPolicyStateEnabled', 'ServerSecurityAlertPolicyStateDisabled'
	State ServerSecurityAlertPolicyState `json:"state,omitempty"`
	// DisabledAlerts - Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly
	DisabledAlerts *[]string `json:"disabledAlerts,omitempty"`
	// EmailAddresses - Specifies an array of e-mail addresses to which the alert is sent.
	EmailAddresses *[]string `json:"emailAddresses,omitempty"`
	// EmailAccountAdmins - Specifies that the alert is sent to the account administrators.
	EmailAccountAdmins *bool `json:"emailAccountAdmins,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the Threat Detection audit storage account.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
}

// Server represents a server.
type Server struct {
	autorest.Response `json:"-"`
	// Sku - The SKU (pricing tier) of the server.
	Sku *Sku `json:"sku,omitempty"`
	// ServerProperties - Properties of the server.
	*ServerProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Server.
func (s Server) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Sku != nil {
		objectMap["sku"] = s.Sku
	}
	if s.ServerProperties != nil {
		objectMap["properties"] = s.ServerProperties
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Server struct.
func (s *Server) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				s.Sku = &sku
			}
		case "properties":
			if v != nil {
				var serverProperties ServerProperties
				err = json.Unmarshal(*v, &serverProperties)
				if err != nil {
					return err
				}
				s.ServerProperties = &serverProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerForCreate represents a server to be created.
type ServerForCreate struct {
	// Sku - The SKU (pricing tier) of the server.
	Sku *Sku `json:"sku,omitempty"`
	// Properties - Properties of the server.
	Properties BasicServerPropertiesForCreate `json:"properties,omitempty"`
	// Location - The location the resource resides in.
	Location *string `json:"location,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServerForCreate.
func (sfc ServerForCreate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sfc.Sku != nil {
		objectMap["sku"] = sfc.Sku
	}
	objectMap["properties"] = sfc.Properties
	if sfc.Location != nil {
		objectMap["location"] = sfc.Location
	}
	if sfc.Tags != nil {
		objectMap["tags"] = sfc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerForCreate struct.
func (sfc *ServerForCreate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sfc.Sku = &sku
			}
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicServerPropertiesForCreate(*v)
				if err != nil {
					return err
				}
				sfc.Properties = properties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sfc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sfc.Tags = tags
			}
		}
	}

	return nil
}

// ServerListResult a list of servers.
type ServerListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of servers
	Value *[]Server `json:"value,omitempty"`
}

// ServerPrivateEndpointConnection a private endpoint connection under a server
type ServerPrivateEndpointConnection struct {
	// ID - READ-ONLY; Resource Id of the private endpoint connection.
	ID *string `json:"id,omitempty"`
	// Properties - READ-ONLY; Private endpoint connection properties
	Properties *ServerPrivateEndpointConnectionProperties `json:"properties,omitempty"`
}

// ServerPrivateEndpointConnectionProperties properties of a private endpoint connection.
type ServerPrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *ServerPrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - READ-ONLY; State of the private endpoint connection. Possible values include: 'Approving', 'Ready', 'Dropping', 'Failed', 'Rejecting'
	ProvisioningState PrivateEndpointProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerPrivateEndpointConnectionProperties.
func (specp ServerPrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if specp.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = specp.PrivateEndpoint
	}
	if specp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = specp.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// ServerPrivateLinkServiceConnectionStateProperty ...
type ServerPrivateLinkServiceConnectionStateProperty struct {
	// Status - The private link service connection status. Possible values include: 'Approved', 'Pending', 'Rejected', 'Disconnected'
	Status PrivateLinkServiceConnectionStateStatus `json:"status,omitempty"`
	// Description - The private link service connection description.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - READ-ONLY; The actions required for private link service connection. Possible values include: 'None'
	ActionsRequired PrivateLinkServiceConnectionStateActionsRequire `json:"actionsRequired,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerPrivateLinkServiceConnectionStateProperty.
func (splscsp ServerPrivateLinkServiceConnectionStateProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if splscsp.Status != "" {
		objectMap["status"] = splscsp.Status
	}
	if splscsp.Description != nil {
		objectMap["description"] = splscsp.Description
	}
	return json.Marshal(objectMap)
}

// ServerProperties the properties of a server.
type ServerProperties struct {
	// AdministratorLogin - The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// Version - Server version. Possible values include: 'FiveFullStopSix', 'FiveFullStopSeven'
	Version ServerVersion `json:"version,omitempty"`
	// SslEnforcement - Enable ssl enforcement or not when connect to server. Possible values include: 'SslEnforcementEnumEnabled', 'SslEnforcementEnumDisabled'
	SslEnforcement SslEnforcementEnum `json:"sslEnforcement,omitempty"`
	// UserVisibleState - A state of a server that is visible to user. Possible values include: 'ServerStateReady', 'ServerStateDropping', 'ServerStateDisabled'
	UserVisibleState ServerState `json:"userVisibleState,omitempty"`
	// FullyQualifiedDomainName - The fully qualified domain name of a server.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty"`
	// EarliestRestoreDate - Earliest restore point creation time (ISO8601 format)
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
	// StorageProfile - Storage profile of a server.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
	// ReplicationRole - The replication role of the server.
	ReplicationRole *string `json:"replicationRole,omitempty"`
	// MasterServerID - The master server id of a replica server.
	MasterServerID *string `json:"masterServerId,omitempty"`
	// ReplicaCapacity - The maximum number of replicas that a master server can have.
	ReplicaCapacity *int32 `json:"replicaCapacity,omitempty"`
	// PublicNetworkAccess - Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include: 'PublicNetworkAccessEnumEnabled', 'PublicNetworkAccessEnumDisabled'
	PublicNetworkAccess PublicNetworkAccessEnum `json:"publicNetworkAccess,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; List of private endpoint connections on a server
	PrivateEndpointConnections *[]ServerPrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerProperties.
func (sp ServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.AdministratorLogin != nil {
		objectMap["administratorLogin"] = sp.AdministratorLogin
	}
	if sp.Version != "" {
		objectMap["version"] = sp.Version
	}
	if sp.SslEnforcement != "" {
		objectMap["sslEnforcement"] = sp.SslEnforcement
	}
	if sp.UserVisibleState != "" {
		objectMap["userVisibleState"] = sp.UserVisibleState
	}
	if sp.FullyQualifiedDomainName != nil {
		objectMap["fullyQualifiedDomainName"] = sp.FullyQualifiedDomainName
	}
	if sp.EarliestRestoreDate != nil {
		objectMap["earliestRestoreDate"] = sp.EarliestRestoreDate
	}
	if sp.StorageProfile != nil {
		objectMap["storageProfile"] = sp.StorageProfile
	}
	if sp.ReplicationRole != nil {
		objectMap["replicationRole"] = sp.ReplicationRole
	}
	if sp.MasterServerID != nil {
		objectMap["masterServerId"] = sp.MasterServerID
	}
	if sp.ReplicaCapacity != nil {
		objectMap["replicaCapacity"] = sp.ReplicaCapacity
	}
	if sp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = sp.PublicNetworkAccess
	}
	return json.Marshal(objectMap)
}

// BasicServerPropertiesForCreate the properties used to create a new server.
type BasicServerPropertiesForCreate interface {
	AsServerPropertiesForDefaultCreate() (*ServerPropertiesForDefaultCreate, bool)
	AsServerPropertiesForRestore() (*ServerPropertiesForRestore, bool)
	AsServerPropertiesForGeoRestore() (*ServerPropertiesForGeoRestore, bool)
	AsServerPropertiesForReplica() (*ServerPropertiesForReplica, bool)
	AsServerPropertiesForCreate() (*ServerPropertiesForCreate, bool)
}

// ServerPropertiesForCreate the properties used to create a new server.
type ServerPropertiesForCreate struct {
	// Version - Server version. Possible values include: 'FiveFullStopSix', 'FiveFullStopSeven'
	Version ServerVersion `json:"version,omitempty"`
	// SslEnforcement - Enable ssl enforcement or not when connect to server. Possible values include: 'SslEnforcementEnumEnabled', 'SslEnforcementEnumDisabled'
	SslEnforcement SslEnforcementEnum `json:"sslEnforcement,omitempty"`
	// PublicNetworkAccess - Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include: 'PublicNetworkAccessEnumEnabled', 'PublicNetworkAccessEnumDisabled'
	PublicNetworkAccess PublicNetworkAccessEnum `json:"publicNetworkAccess,omitempty"`
	// StorageProfile - Storage profile of a server.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
	// CreateMode - Possible values include: 'CreateModeServerPropertiesForCreate', 'CreateModeDefault', 'CreateModePointInTimeRestore', 'CreateModeGeoRestore', 'CreateModeReplica'
	CreateMode CreateMode `json:"createMode,omitempty"`
}

func unmarshalBasicServerPropertiesForCreate(body []byte) (BasicServerPropertiesForCreate, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["createMode"] {
	case string(CreateModeDefault):
		var spfdc ServerPropertiesForDefaultCreate
		err := json.Unmarshal(body, &spfdc)
		return spfdc, err
	case string(CreateModePointInTimeRestore):
		var spfr ServerPropertiesForRestore
		err := json.Unmarshal(body, &spfr)
		return spfr, err
	case string(CreateModeGeoRestore):
		var spfgr ServerPropertiesForGeoRestore
		err := json.Unmarshal(body, &spfgr)
		return spfgr, err
	case string(CreateModeReplica):
		var spfr ServerPropertiesForReplica
		err := json.Unmarshal(body, &spfr)
		return spfr, err
	default:
		var spfc ServerPropertiesForCreate
		err := json.Unmarshal(body, &spfc)
		return spfc, err
	}
}
func unmarshalBasicServerPropertiesForCreateArray(body []byte) ([]BasicServerPropertiesForCreate, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	spfcArray := make([]BasicServerPropertiesForCreate, len(rawMessages))

	for index, rawMessage := range rawMessages {
		spfc, err := unmarshalBasicServerPropertiesForCreate(*rawMessage)
		if err != nil {
			return nil, err
		}
		spfcArray[index] = spfc
	}
	return spfcArray, nil
}

// MarshalJSON is the custom marshaler for ServerPropertiesForCreate.
func (spfc ServerPropertiesForCreate) MarshalJSON() ([]byte, error) {
	spfc.CreateMode = CreateModeServerPropertiesForCreate
	objectMap := make(map[string]interface{})
	if spfc.Version != "" {
		objectMap["version"] = spfc.Version
	}
	if spfc.SslEnforcement != "" {
		objectMap["sslEnforcement"] = spfc.SslEnforcement
	}
	if spfc.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = spfc.PublicNetworkAccess
	}
	if spfc.StorageProfile != nil {
		objectMap["storageProfile"] = spfc.StorageProfile
	}
	if spfc.CreateMode != "" {
		objectMap["createMode"] = spfc.CreateMode
	}
	return json.Marshal(objectMap)
}

// AsServerPropertiesForDefaultCreate is the BasicServerPropertiesForCreate implementation for ServerPropertiesForCreate.
func (spfc ServerPropertiesForCreate) AsServerPropertiesForDefaultCreate() (*ServerPropertiesForDefaultCreate, bool) {
	return nil, false
}

// AsServerPropertiesForRestore is the BasicServerPropertiesForCreate implementation for ServerPropertiesForCreate.
func (spfc ServerPropertiesForCreate) AsServerPropertiesForRestore() (*ServerPropertiesForRestore, bool) {
	return nil, false
}

// AsServerPropertiesForGeoRestore is the BasicServerPropertiesForCreate implementation for ServerPropertiesForCreate.
func (spfc ServerPropertiesForCreate) AsServerPropertiesForGeoRestore() (*ServerPropertiesForGeoRestore, bool) {
	return nil, false
}

// AsServerPropertiesForReplica is the BasicServerPropertiesForCreate implementation for ServerPropertiesForCreate.
func (spfc ServerPropertiesForCreate) AsServerPropertiesForReplica() (*ServerPropertiesForReplica, bool) {
	return nil, false
}

// AsServerPropertiesForCreate is the BasicServerPropertiesForCreate implementation for ServerPropertiesForCreate.
func (spfc ServerPropertiesForCreate) AsServerPropertiesForCreate() (*ServerPropertiesForCreate, bool) {
	return &spfc, true
}

// AsBasicServerPropertiesForCreate is the BasicServerPropertiesForCreate implementation for ServerPropertiesForCreate.
func (spfc ServerPropertiesForCreate) AsBasicServerPropertiesForCreate() (BasicServerPropertiesForCreate, bool) {
	return &spfc, true
}

// ServerPropertiesForDefaultCreate the properties used to create a new server.
type ServerPropertiesForDefaultCreate struct {
	// AdministratorLogin - The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The password of the administrator login.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// Version - Server version. Possible values include: 'FiveFullStopSix', 'FiveFullStopSeven'
	Version ServerVersion `json:"version,omitempty"`
	// SslEnforcement - Enable ssl enforcement or not when connect to server. Possible values include: 'SslEnforcementEnumEnabled', 'SslEnforcementEnumDisabled'
	SslEnforcement SslEnforcementEnum `json:"sslEnforcement,omitempty"`
	// PublicNetworkAccess - Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include: 'PublicNetworkAccessEnumEnabled', 'PublicNetworkAccessEnumDisabled'
	PublicNetworkAccess PublicNetworkAccessEnum `json:"publicNetworkAccess,omitempty"`
	// StorageProfile - Storage profile of a server.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
	// CreateMode - Possible values include: 'CreateModeServerPropertiesForCreate', 'CreateModeDefault', 'CreateModePointInTimeRestore', 'CreateModeGeoRestore', 'CreateModeReplica'
	CreateMode CreateMode `json:"createMode,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerPropertiesForDefaultCreate.
func (spfdc ServerPropertiesForDefaultCreate) MarshalJSON() ([]byte, error) {
	spfdc.CreateMode = CreateModeDefault
	objectMap := make(map[string]interface{})
	if spfdc.AdministratorLogin != nil {
		objectMap["administratorLogin"] = spfdc.AdministratorLogin
	}
	if spfdc.AdministratorLoginPassword != nil {
		objectMap["administratorLoginPassword"] = spfdc.AdministratorLoginPassword
	}
	if spfdc.Version != "" {
		objectMap["version"] = spfdc.Version
	}
	if spfdc.SslEnforcement != "" {
		objectMap["sslEnforcement"] = spfdc.SslEnforcement
	}
	if spfdc.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = spfdc.PublicNetworkAccess
	}
	if spfdc.StorageProfile != nil {
		objectMap["storageProfile"] = spfdc.StorageProfile
	}
	if spfdc.CreateMode != "" {
		objectMap["createMode"] = spfdc.CreateMode
	}
	return json.Marshal(objectMap)
}

// AsServerPropertiesForDefaultCreate is the BasicServerPropertiesForCreate implementation for ServerPropertiesForDefaultCreate.
func (spfdc ServerPropertiesForDefaultCreate) AsServerPropertiesForDefaultCreate() (*ServerPropertiesForDefaultCreate, bool) {
	return &spfdc, true
}

// AsServerPropertiesForRestore is the BasicServerPropertiesForCreate implementation for ServerPropertiesForDefaultCreate.
func (spfdc ServerPropertiesForDefaultCreate) AsServerPropertiesForRestore() (*ServerPropertiesForRestore, bool) {
	return nil, false
}

// AsServerPropertiesForGeoRestore is the BasicServerPropertiesForCreate implementation for ServerPropertiesForDefaultCreate.
func (spfdc ServerPropertiesForDefaultCreate) AsServerPropertiesForGeoRestore() (*ServerPropertiesForGeoRestore, bool) {
	return nil, false
}

// AsServerPropertiesForReplica is the BasicServerPropertiesForCreate implementation for ServerPropertiesForDefaultCreate.
func (spfdc ServerPropertiesForDefaultCreate) AsServerPropertiesForReplica() (*ServerPropertiesForReplica, bool) {
	return nil, false
}

// AsServerPropertiesForCreate is the BasicServerPropertiesForCreate implementation for ServerPropertiesForDefaultCreate.
func (spfdc ServerPropertiesForDefaultCreate) AsServerPropertiesForCreate() (*ServerPropertiesForCreate, bool) {
	return nil, false
}

// AsBasicServerPropertiesForCreate is the BasicServerPropertiesForCreate implementation for ServerPropertiesForDefaultCreate.
func (spfdc ServerPropertiesForDefaultCreate) AsBasicServerPropertiesForCreate() (BasicServerPropertiesForCreate, bool) {
	return &spfdc, true
}

// ServerPropertiesForGeoRestore the properties used to create a new server by restoring to a different
// region from a geo replicated backup.
type ServerPropertiesForGeoRestore struct {
	// SourceServerID - The source server id to restore from.
	SourceServerID *string `json:"sourceServerId,omitempty"`
	// Version - Server version. Possible values include: 'FiveFullStopSix', 'FiveFullStopSeven'
	Version ServerVersion `json:"version,omitempty"`
	// SslEnforcement - Enable ssl enforcement or not when connect to server. Possible values include: 'SslEnforcementEnumEnabled', 'SslEnforcementEnumDisabled'
	SslEnforcement SslEnforcementEnum `json:"sslEnforcement,omitempty"`
	// PublicNetworkAccess - Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include: 'PublicNetworkAccessEnumEnabled', 'PublicNetworkAccessEnumDisabled'
	PublicNetworkAccess PublicNetworkAccessEnum `json:"publicNetworkAccess,omitempty"`
	// StorageProfile - Storage profile of a server.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
	// CreateMode - Possible values include: 'CreateModeServerPropertiesForCreate', 'CreateModeDefault', 'CreateModePointInTimeRestore', 'CreateModeGeoRestore', 'CreateModeReplica'
	CreateMode CreateMode `json:"createMode,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerPropertiesForGeoRestore.
func (spfgr ServerPropertiesForGeoRestore) MarshalJSON() ([]byte, error) {
	spfgr.CreateMode = CreateModeGeoRestore
	objectMap := make(map[string]interface{})
	if spfgr.SourceServerID != nil {
		objectMap["sourceServerId"] = spfgr.SourceServerID
	}
	if spfgr.Version != "" {
		objectMap["version"] = spfgr.Version
	}
	if spfgr.SslEnforcement != "" {
		objectMap["sslEnforcement"] = spfgr.SslEnforcement
	}
	if spfgr.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = spfgr.PublicNetworkAccess
	}
	if spfgr.StorageProfile != nil {
		objectMap["storageProfile"] = spfgr.StorageProfile
	}
	if spfgr.CreateMode != "" {
		objectMap["createMode"] = spfgr.CreateMode
	}
	return json.Marshal(objectMap)
}

// AsServerPropertiesForDefaultCreate is the BasicServerPropertiesForCreate implementation for ServerPropertiesForGeoRestore.
func (spfgr ServerPropertiesForGeoRestore) AsServerPropertiesForDefaultCreate() (*ServerPropertiesForDefaultCreate, bool) {
	return nil, false
}

// AsServerPropertiesForRestore is the BasicServerPropertiesForCreate implementation for ServerPropertiesForGeoRestore.
func (spfgr ServerPropertiesForGeoRestore) AsServerPropertiesForRestore() (*ServerPropertiesForRestore, bool) {
	return nil, false
}

// AsServerPropertiesForGeoRestore is the BasicServerPropertiesForCreate implementation for ServerPropertiesForGeoRestore.
func (spfgr ServerPropertiesForGeoRestore) AsServerPropertiesForGeoRestore() (*ServerPropertiesForGeoRestore, bool) {
	return &spfgr, true
}

// AsServerPropertiesForReplica is the BasicServerPropertiesForCreate implementation for ServerPropertiesForGeoRestore.
func (spfgr ServerPropertiesForGeoRestore) AsServerPropertiesForReplica() (*ServerPropertiesForReplica, bool) {
	return nil, false
}

// AsServerPropertiesForCreate is the BasicServerPropertiesForCreate implementation for ServerPropertiesForGeoRestore.
func (spfgr ServerPropertiesForGeoRestore) AsServerPropertiesForCreate() (*ServerPropertiesForCreate, bool) {
	return nil, false
}

// AsBasicServerPropertiesForCreate is the BasicServerPropertiesForCreate implementation for ServerPropertiesForGeoRestore.
func (spfgr ServerPropertiesForGeoRestore) AsBasicServerPropertiesForCreate() (BasicServerPropertiesForCreate, bool) {
	return &spfgr, true
}

// ServerPropertiesForReplica the properties to create a new replica.
type ServerPropertiesForReplica struct {
	// SourceServerID - The master server id to create replica from.
	SourceServerID *string `json:"sourceServerId,omitempty"`
	// Version - Server version. Possible values include: 'FiveFullStopSix', 'FiveFullStopSeven'
	Version ServerVersion `json:"version,omitempty"`
	// SslEnforcement - Enable ssl enforcement or not when connect to server. Possible values include: 'SslEnforcementEnumEnabled', 'SslEnforcementEnumDisabled'
	SslEnforcement SslEnforcementEnum `json:"sslEnforcement,omitempty"`
	// PublicNetworkAccess - Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include: 'PublicNetworkAccessEnumEnabled', 'PublicNetworkAccessEnumDisabled'
	PublicNetworkAccess PublicNetworkAccessEnum `json:"publicNetworkAccess,omitempty"`
	// StorageProfile - Storage profile of a server.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
	// CreateMode - Possible values include: 'CreateModeServerPropertiesForCreate', 'CreateModeDefault', 'CreateModePointInTimeRestore', 'CreateModeGeoRestore', 'CreateModeReplica'
	CreateMode CreateMode `json:"createMode,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerPropertiesForReplica.
func (spfr ServerPropertiesForReplica) MarshalJSON() ([]byte, error) {
	spfr.CreateMode = CreateModeReplica
	objectMap := make(map[string]interface{})
	if spfr.SourceServerID != nil {
		objectMap["sourceServerId"] = spfr.SourceServerID
	}
	if spfr.Version != "" {
		objectMap["version"] = spfr.Version
	}
	if spfr.SslEnforcement != "" {
		objectMap["sslEnforcement"] = spfr.SslEnforcement
	}
	if spfr.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = spfr.PublicNetworkAccess
	}
	if spfr.StorageProfile != nil {
		objectMap["storageProfile"] = spfr.StorageProfile
	}
	if spfr.CreateMode != "" {
		objectMap["createMode"] = spfr.CreateMode
	}
	return json.Marshal(objectMap)
}

// AsServerPropertiesForDefaultCreate is the BasicServerPropertiesForCreate implementation for ServerPropertiesForReplica.
func (spfr ServerPropertiesForReplica) AsServerPropertiesForDefaultCreate() (*ServerPropertiesForDefaultCreate, bool) {
	return nil, false
}

// AsServerPropertiesForRestore is the BasicServerPropertiesForCreate implementation for ServerPropertiesForReplica.
func (spfr ServerPropertiesForReplica) AsServerPropertiesForRestore() (*ServerPropertiesForRestore, bool) {
	return nil, false
}

// AsServerPropertiesForGeoRestore is the BasicServerPropertiesForCreate implementation for ServerPropertiesForReplica.
func (spfr ServerPropertiesForReplica) AsServerPropertiesForGeoRestore() (*ServerPropertiesForGeoRestore, bool) {
	return nil, false
}

// AsServerPropertiesForReplica is the BasicServerPropertiesForCreate implementation for ServerPropertiesForReplica.
func (spfr ServerPropertiesForReplica) AsServerPropertiesForReplica() (*ServerPropertiesForReplica, bool) {
	return &spfr, true
}

// AsServerPropertiesForCreate is the BasicServerPropertiesForCreate implementation for ServerPropertiesForReplica.
func (spfr ServerPropertiesForReplica) AsServerPropertiesForCreate() (*ServerPropertiesForCreate, bool) {
	return nil, false
}

// AsBasicServerPropertiesForCreate is the BasicServerPropertiesForCreate implementation for ServerPropertiesForReplica.
func (spfr ServerPropertiesForReplica) AsBasicServerPropertiesForCreate() (BasicServerPropertiesForCreate, bool) {
	return &spfr, true
}

// ServerPropertiesForRestore the properties used to create a new server by restoring from a backup.
type ServerPropertiesForRestore struct {
	// SourceServerID - The source server id to restore from.
	SourceServerID *string `json:"sourceServerId,omitempty"`
	// RestorePointInTime - Restore point creation time (ISO8601 format), specifying the time to restore from.
	RestorePointInTime *date.Time `json:"restorePointInTime,omitempty"`
	// Version - Server version. Possible values include: 'FiveFullStopSix', 'FiveFullStopSeven'
	Version ServerVersion `json:"version,omitempty"`
	// SslEnforcement - Enable ssl enforcement or not when connect to server. Possible values include: 'SslEnforcementEnumEnabled', 'SslEnforcementEnumDisabled'
	SslEnforcement SslEnforcementEnum `json:"sslEnforcement,omitempty"`
	// PublicNetworkAccess - Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include: 'PublicNetworkAccessEnumEnabled', 'PublicNetworkAccessEnumDisabled'
	PublicNetworkAccess PublicNetworkAccessEnum `json:"publicNetworkAccess,omitempty"`
	// StorageProfile - Storage profile of a server.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
	// CreateMode - Possible values include: 'CreateModeServerPropertiesForCreate', 'CreateModeDefault', 'CreateModePointInTimeRestore', 'CreateModeGeoRestore', 'CreateModeReplica'
	CreateMode CreateMode `json:"createMode,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerPropertiesForRestore.
func (spfr ServerPropertiesForRestore) MarshalJSON() ([]byte, error) {
	spfr.CreateMode = CreateModePointInTimeRestore
	objectMap := make(map[string]interface{})
	if spfr.SourceServerID != nil {
		objectMap["sourceServerId"] = spfr.SourceServerID
	}
	if spfr.RestorePointInTime != nil {
		objectMap["restorePointInTime"] = spfr.RestorePointInTime
	}
	if spfr.Version != "" {
		objectMap["version"] = spfr.Version
	}
	if spfr.SslEnforcement != "" {
		objectMap["sslEnforcement"] = spfr.SslEnforcement
	}
	if spfr.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = spfr.PublicNetworkAccess
	}
	if spfr.StorageProfile != nil {
		objectMap["storageProfile"] = spfr.StorageProfile
	}
	if spfr.CreateMode != "" {
		objectMap["createMode"] = spfr.CreateMode
	}
	return json.Marshal(objectMap)
}

// AsServerPropertiesForDefaultCreate is the BasicServerPropertiesForCreate implementation for ServerPropertiesForRestore.
func (spfr ServerPropertiesForRestore) AsServerPropertiesForDefaultCreate() (*ServerPropertiesForDefaultCreate, bool) {
	return nil, false
}

// AsServerPropertiesForRestore is the BasicServerPropertiesForCreate implementation for ServerPropertiesForRestore.
func (spfr ServerPropertiesForRestore) AsServerPropertiesForRestore() (*ServerPropertiesForRestore, bool) {
	return &spfr, true
}

// AsServerPropertiesForGeoRestore is the BasicServerPropertiesForCreate implementation for ServerPropertiesForRestore.
func (spfr ServerPropertiesForRestore) AsServerPropertiesForGeoRestore() (*ServerPropertiesForGeoRestore, bool) {
	return nil, false
}

// AsServerPropertiesForReplica is the BasicServerPropertiesForCreate implementation for ServerPropertiesForRestore.
func (spfr ServerPropertiesForRestore) AsServerPropertiesForReplica() (*ServerPropertiesForReplica, bool) {
	return nil, false
}

// AsServerPropertiesForCreate is the BasicServerPropertiesForCreate implementation for ServerPropertiesForRestore.
func (spfr ServerPropertiesForRestore) AsServerPropertiesForCreate() (*ServerPropertiesForCreate, bool) {
	return nil, false
}

// AsBasicServerPropertiesForCreate is the BasicServerPropertiesForCreate implementation for ServerPropertiesForRestore.
func (spfr ServerPropertiesForRestore) AsBasicServerPropertiesForCreate() (BasicServerPropertiesForCreate, bool) {
	return &spfr, true
}

// ServersCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (Server, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServersCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServersCreateFuture.Result.
func (future *ServersCreateFuture) result(client ServersClient) (s Server, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mariadb.ServersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		s.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("mariadb.ServersCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "mariadb.ServersCreateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServersDeleteFuture.Result.
func (future *ServersDeleteFuture) result(client ServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mariadb.ServersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("mariadb.ServersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServerSecurityAlertPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ServerSecurityAlertPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerSecurityAlertPoliciesClient) (ServerSecurityAlertPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServerSecurityAlertPoliciesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServerSecurityAlertPoliciesCreateOrUpdateFuture.Result.
func (future *ServerSecurityAlertPoliciesCreateOrUpdateFuture) result(client ServerSecurityAlertPoliciesClient) (ssap ServerSecurityAlertPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mariadb.ServerSecurityAlertPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ssap.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("mariadb.ServerSecurityAlertPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ssap.Response.Response, err = future.GetResult(sender); err == nil && ssap.Response.Response.StatusCode != http.StatusNoContent {
		ssap, err = client.CreateOrUpdateResponder(ssap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "mariadb.ServerSecurityAlertPoliciesCreateOrUpdateFuture", "Result", ssap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerSecurityAlertPolicy a server security alert policy.
type ServerSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	// SecurityAlertPolicyProperties - Resource properties.
	*SecurityAlertPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerSecurityAlertPolicy.
func (ssap ServerSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssap.SecurityAlertPolicyProperties != nil {
		objectMap["properties"] = ssap.SecurityAlertPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerSecurityAlertPolicy struct.
func (ssap *ServerSecurityAlertPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityAlertPolicyProperties SecurityAlertPolicyProperties
				err = json.Unmarshal(*v, &securityAlertPolicyProperties)
				if err != nil {
					return err
				}
				ssap.SecurityAlertPolicyProperties = &securityAlertPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssap.Type = &typeVar
			}
		}
	}

	return nil
}

// ServersRestartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersRestartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServersRestartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServersRestartFuture.Result.
func (future *ServersRestartFuture) result(client ServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mariadb.ServersRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("mariadb.ServersRestartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (Server, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServersUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServersUpdateFuture.Result.
func (future *ServersUpdateFuture) result(client ServersClient) (s Server, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mariadb.ServersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		s.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("mariadb.ServersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.UpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "mariadb.ServersUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerUpdateParameters parameters allowed to update for a server.
type ServerUpdateParameters struct {
	// Sku - The SKU (pricing tier) of the server.
	Sku *Sku `json:"sku,omitempty"`
	// ServerUpdateParametersProperties - The properties that can be updated for a server.
	*ServerUpdateParametersProperties `json:"properties,omitempty"`
	// Tags - Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServerUpdateParameters.
func (sup ServerUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sup.Sku != nil {
		objectMap["sku"] = sup.Sku
	}
	if sup.ServerUpdateParametersProperties != nil {
		objectMap["properties"] = sup.ServerUpdateParametersProperties
	}
	if sup.Tags != nil {
		objectMap["tags"] = sup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerUpdateParameters struct.
func (sup *ServerUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sup.Sku = &sku
			}
		case "properties":
			if v != nil {
				var serverUpdateParametersProperties ServerUpdateParametersProperties
				err = json.Unmarshal(*v, &serverUpdateParametersProperties)
				if err != nil {
					return err
				}
				sup.ServerUpdateParametersProperties = &serverUpdateParametersProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sup.Tags = tags
			}
		}
	}

	return nil
}

// ServerUpdateParametersProperties the properties that can be updated for a server.
type ServerUpdateParametersProperties struct {
	// StorageProfile - Storage profile of a server.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
	// AdministratorLoginPassword - The password of the administrator login.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// Version - The version of a server. Possible values include: 'FiveFullStopSix', 'FiveFullStopSeven'
	Version ServerVersion `json:"version,omitempty"`
	// SslEnforcement - Enable ssl enforcement or not when connect to server. Possible values include: 'SslEnforcementEnumEnabled', 'SslEnforcementEnumDisabled'
	SslEnforcement SslEnforcementEnum `json:"sslEnforcement,omitempty"`
	// PublicNetworkAccess - Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Possible values include: 'PublicNetworkAccessEnumEnabled', 'PublicNetworkAccessEnumDisabled'
	PublicNetworkAccess PublicNetworkAccessEnum `json:"publicNetworkAccess,omitempty"`
	// ReplicationRole - The replication role of the server.
	ReplicationRole *string `json:"replicationRole,omitempty"`
}

// Sku billing information related properties of a server.
type Sku struct {
	// Name - The name of the sku, typically, tier + family + cores, e.g. B_Gen4_1, GP_Gen5_8.
	Name *string `json:"name,omitempty"`
	// Tier - The tier of the particular SKU, e.g. Basic. Possible values include: 'Basic', 'GeneralPurpose', 'MemoryOptimized'
	Tier SkuTier `json:"tier,omitempty"`
	// Capacity - The scale up/out capacity, representing server's compute units.
	Capacity *int32 `json:"capacity,omitempty"`
	// Size - The size code, to be interpreted by resource as appropriate.
	Size *string `json:"size,omitempty"`
	// Family - The family of hardware.
	Family *string `json:"family,omitempty"`
}

// StorageProfile storage Profile properties of a server
type StorageProfile struct {
	// BackupRetentionDays - Backup retention days for the server.
	BackupRetentionDays *int32 `json:"backupRetentionDays,omitempty"`
	// GeoRedundantBackup - Enable Geo-redundant or not for server backup. Possible values include: 'Enabled', 'Disabled'
	GeoRedundantBackup GeoRedundantBackup `json:"geoRedundantBackup,omitempty"`
	// StorageMB - Max storage allowed for a server.
	StorageMB *int32 `json:"storageMB,omitempty"`
	// StorageAutogrow - Enable Storage Auto Grow. Possible values include: 'StorageAutogrowEnabled', 'StorageAutogrowDisabled'
	StorageAutogrow StorageAutogrow `json:"storageAutogrow,omitempty"`
}

// TagsObject tags object for patch operations.
type TagsObject struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsObject.
func (toVar TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if toVar.Tags != nil {
		objectMap["tags"] = toVar.Tags
	}
	return json.Marshal(objectMap)
}

// TopQueryStatisticsInput input to get top query statistics
type TopQueryStatisticsInput struct {
	// TopQueryStatisticsInputProperties - The properties of a wait statistics input.
	*TopQueryStatisticsInputProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TopQueryStatisticsInput.
func (tqsi TopQueryStatisticsInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tqsi.TopQueryStatisticsInputProperties != nil {
		objectMap["properties"] = tqsi.TopQueryStatisticsInputProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TopQueryStatisticsInput struct.
func (tqsi *TopQueryStatisticsInput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var topQueryStatisticsInputProperties TopQueryStatisticsInputProperties
				err = json.Unmarshal(*v, &topQueryStatisticsInputProperties)
				if err != nil {
					return err
				}
				tqsi.TopQueryStatisticsInputProperties = &topQueryStatisticsInputProperties
			}
		}
	}

	return nil
}

// TopQueryStatisticsInputProperties the properties for input to get top query statistics
type TopQueryStatisticsInputProperties struct {
	// NumberOfTopQueries - Max number of top queries to return.
	NumberOfTopQueries *int32 `json:"numberOfTopQueries,omitempty"`
	// AggregationFunction - Aggregation function name.
	AggregationFunction *string `json:"aggregationFunction,omitempty"`
	// ObservedMetric - Observed metric name.
	ObservedMetric *string `json:"observedMetric,omitempty"`
	// ObservationStartTime - Observation start time.
	ObservationStartTime *date.Time `json:"observationStartTime,omitempty"`
	// ObservationEndTime - Observation end time.
	ObservationEndTime *date.Time `json:"observationEndTime,omitempty"`
	// AggregationWindow - Aggregation interval type in ISO 8601 format.
	AggregationWindow *string `json:"aggregationWindow,omitempty"`
}

// TopQueryStatisticsResultList a list of query statistics.
type TopQueryStatisticsResultList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of top query statistics.
	Value *[]QueryStatistic `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// TopQueryStatisticsResultListIterator provides access to a complete listing of QueryStatistic values.
type TopQueryStatisticsResultListIterator struct {
	i    int
	page TopQueryStatisticsResultListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TopQueryStatisticsResultListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopQueryStatisticsResultListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TopQueryStatisticsResultListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TopQueryStatisticsResultListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TopQueryStatisticsResultListIterator) Response() TopQueryStatisticsResultList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TopQueryStatisticsResultListIterator) Value() QueryStatistic {
	if !iter.page.NotDone() {
		return QueryStatistic{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TopQueryStatisticsResultListIterator type.
func NewTopQueryStatisticsResultListIterator(page TopQueryStatisticsResultListPage) TopQueryStatisticsResultListIterator {
	return TopQueryStatisticsResultListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tqsrl TopQueryStatisticsResultList) IsEmpty() bool {
	return tqsrl.Value == nil || len(*tqsrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tqsrl TopQueryStatisticsResultList) hasNextLink() bool {
	return tqsrl.NextLink != nil && len(*tqsrl.NextLink) != 0
}

// topQueryStatisticsResultListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tqsrl TopQueryStatisticsResultList) topQueryStatisticsResultListPreparer(ctx context.Context) (*http.Request, error) {
	if !tqsrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tqsrl.NextLink)))
}

// TopQueryStatisticsResultListPage contains a page of QueryStatistic values.
type TopQueryStatisticsResultListPage struct {
	fn    func(context.Context, TopQueryStatisticsResultList) (TopQueryStatisticsResultList, error)
	tqsrl TopQueryStatisticsResultList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TopQueryStatisticsResultListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopQueryStatisticsResultListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tqsrl)
		if err != nil {
			return err
		}
		page.tqsrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TopQueryStatisticsResultListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TopQueryStatisticsResultListPage) NotDone() bool {
	return !page.tqsrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TopQueryStatisticsResultListPage) Response() TopQueryStatisticsResultList {
	return page.tqsrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TopQueryStatisticsResultListPage) Values() []QueryStatistic {
	if page.tqsrl.IsEmpty() {
		return nil
	}
	return *page.tqsrl.Value
}

// Creates a new instance of the TopQueryStatisticsResultListPage type.
func NewTopQueryStatisticsResultListPage(cur TopQueryStatisticsResultList, getNextPage func(context.Context, TopQueryStatisticsResultList) (TopQueryStatisticsResultList, error)) TopQueryStatisticsResultListPage {
	return TopQueryStatisticsResultListPage{
		fn:    getNextPage,
		tqsrl: cur,
	}
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// VirtualNetworkRule a virtual network rule.
type VirtualNetworkRule struct {
	autorest.Response `json:"-"`
	// VirtualNetworkRuleProperties - Resource properties.
	*VirtualNetworkRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkRule.
func (vnr VirtualNetworkRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnr.VirtualNetworkRuleProperties != nil {
		objectMap["properties"] = vnr.VirtualNetworkRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkRule struct.
func (vnr *VirtualNetworkRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkRuleProperties VirtualNetworkRuleProperties
				err = json.Unmarshal(*v, &virtualNetworkRuleProperties)
				if err != nil {
					return err
				}
				vnr.VirtualNetworkRuleProperties = &virtualNetworkRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vnr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vnr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vnr.Type = &typeVar
			}
		}
	}

	return nil
}

// VirtualNetworkRuleListResult a list of virtual network rules.
type VirtualNetworkRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]VirtualNetworkRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkRuleListResultIterator provides access to a complete listing of VirtualNetworkRule values.
type VirtualNetworkRuleListResultIterator struct {
	i    int
	page VirtualNetworkRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkRuleListResultIterator) Response() VirtualNetworkRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkRuleListResultIterator) Value() VirtualNetworkRule {
	if !iter.page.NotDone() {
		return VirtualNetworkRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkRuleListResultIterator type.
func NewVirtualNetworkRuleListResultIterator(page VirtualNetworkRuleListResultPage) VirtualNetworkRuleListResultIterator {
	return VirtualNetworkRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnrlr VirtualNetworkRuleListResult) IsEmpty() bool {
	return vnrlr.Value == nil || len(*vnrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vnrlr VirtualNetworkRuleListResult) hasNextLink() bool {
	return vnrlr.NextLink != nil && len(*vnrlr.NextLink) != 0
}

// virtualNetworkRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnrlr VirtualNetworkRuleListResult) virtualNetworkRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vnrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnrlr.NextLink)))
}

// VirtualNetworkRuleListResultPage contains a page of VirtualNetworkRule values.
type VirtualNetworkRuleListResultPage struct {
	fn    func(context.Context, VirtualNetworkRuleListResult) (VirtualNetworkRuleListResult, error)
	vnrlr VirtualNetworkRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vnrlr)
		if err != nil {
			return err
		}
		page.vnrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkRuleListResultPage) NotDone() bool {
	return !page.vnrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkRuleListResultPage) Response() VirtualNetworkRuleListResult {
	return page.vnrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkRuleListResultPage) Values() []VirtualNetworkRule {
	if page.vnrlr.IsEmpty() {
		return nil
	}
	return *page.vnrlr.Value
}

// Creates a new instance of the VirtualNetworkRuleListResultPage type.
func NewVirtualNetworkRuleListResultPage(cur VirtualNetworkRuleListResult, getNextPage func(context.Context, VirtualNetworkRuleListResult) (VirtualNetworkRuleListResult, error)) VirtualNetworkRuleListResultPage {
	return VirtualNetworkRuleListResultPage{
		fn:    getNextPage,
		vnrlr: cur,
	}
}

// VirtualNetworkRuleProperties properties of a virtual network rule.
type VirtualNetworkRuleProperties struct {
	// VirtualNetworkSubnetID - The ARM resource id of the virtual network subnet.
	VirtualNetworkSubnetID *string `json:"virtualNetworkSubnetId,omitempty"`
	// IgnoreMissingVnetServiceEndpoint - Create firewall rule before the virtual network has vnet service endpoint enabled.
	IgnoreMissingVnetServiceEndpoint *bool `json:"ignoreMissingVnetServiceEndpoint,omitempty"`
	// State - READ-ONLY; Virtual Network Rule State. Possible values include: 'VirtualNetworkRuleStateInitializing', 'VirtualNetworkRuleStateInProgress', 'VirtualNetworkRuleStateReady', 'VirtualNetworkRuleStateDeleting', 'VirtualNetworkRuleStateUnknown'
	State VirtualNetworkRuleState `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkRuleProperties.
func (vnrp VirtualNetworkRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnrp.VirtualNetworkSubnetID != nil {
		objectMap["virtualNetworkSubnetId"] = vnrp.VirtualNetworkSubnetID
	}
	if vnrp.IgnoreMissingVnetServiceEndpoint != nil {
		objectMap["ignoreMissingVnetServiceEndpoint"] = vnrp.IgnoreMissingVnetServiceEndpoint
	}
	return json.Marshal(objectMap)
}

// VirtualNetworkRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkRulesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworkRulesClient) (VirtualNetworkRule, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualNetworkRulesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualNetworkRulesCreateOrUpdateFuture.Result.
func (future *VirtualNetworkRulesCreateOrUpdateFuture) result(client VirtualNetworkRulesClient) (vnr VirtualNetworkRule, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mariadb.VirtualNetworkRulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vnr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("mariadb.VirtualNetworkRulesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vnr.Response.Response, err = future.GetResult(sender); err == nil && vnr.Response.Response.StatusCode != http.StatusNoContent {
		vnr, err = client.CreateOrUpdateResponder(vnr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "mariadb.VirtualNetworkRulesCreateOrUpdateFuture", "Result", vnr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualNetworkRulesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkRulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworkRulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualNetworkRulesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualNetworkRulesDeleteFuture.Result.
func (future *VirtualNetworkRulesDeleteFuture) result(client VirtualNetworkRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mariadb.VirtualNetworkRulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("mariadb.VirtualNetworkRulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WaitStatistic represents a Wait Statistic.
type WaitStatistic struct {
	autorest.Response `json:"-"`
	// WaitStatisticProperties - The properties of a wait statistic.
	*WaitStatisticProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WaitStatistic.
func (ws WaitStatistic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ws.WaitStatisticProperties != nil {
		objectMap["properties"] = ws.WaitStatisticProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WaitStatistic struct.
func (ws *WaitStatistic) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var waitStatisticProperties WaitStatisticProperties
				err = json.Unmarshal(*v, &waitStatisticProperties)
				if err != nil {
					return err
				}
				ws.WaitStatisticProperties = &waitStatisticProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ws.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ws.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ws.Type = &typeVar
			}
		}
	}

	return nil
}

// WaitStatisticProperties the properties of a wait statistic.
type WaitStatisticProperties struct {
	// StartTime - Observation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Observation end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// EventName - Wait event name.
	EventName *string `json:"eventName,omitempty"`
	// EventTypeName - Wait event type name.
	EventTypeName *string `json:"eventTypeName,omitempty"`
	// QueryID - Database query identifier.
	QueryID *int64 `json:"queryId,omitempty"`
	// DatabaseName - Database Name.
	DatabaseName *string `json:"databaseName,omitempty"`
	// UserID - Database user identifier.
	UserID *int64 `json:"userId,omitempty"`
	// Count - Wait event count observed in this time interval.
	Count *int64 `json:"count,omitempty"`
	// TotalTimeInMs - Total time of wait in milliseconds in this time interval.
	TotalTimeInMs *float64 `json:"totalTimeInMs,omitempty"`
}

// WaitStatisticsInput input to get wait statistics
type WaitStatisticsInput struct {
	// WaitStatisticsInputProperties - The properties of a wait statistics input.
	*WaitStatisticsInputProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WaitStatisticsInput.
func (wsi WaitStatisticsInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wsi.WaitStatisticsInputProperties != nil {
		objectMap["properties"] = wsi.WaitStatisticsInputProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WaitStatisticsInput struct.
func (wsi *WaitStatisticsInput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var waitStatisticsInputProperties WaitStatisticsInputProperties
				err = json.Unmarshal(*v, &waitStatisticsInputProperties)
				if err != nil {
					return err
				}
				wsi.WaitStatisticsInputProperties = &waitStatisticsInputProperties
			}
		}
	}

	return nil
}

// WaitStatisticsInputProperties the properties for input to get wait statistics
type WaitStatisticsInputProperties struct {
	// ObservationStartTime - Observation start time.
	ObservationStartTime *date.Time `json:"observationStartTime,omitempty"`
	// ObservationEndTime - Observation end time.
	ObservationEndTime *date.Time `json:"observationEndTime,omitempty"`
	// AggregationWindow - Aggregation interval type in ISO 8601 format.
	AggregationWindow *string `json:"aggregationWindow,omitempty"`
}

// WaitStatisticsResultList a list of wait statistics.
type WaitStatisticsResultList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of wait statistics.
	Value *[]WaitStatistic `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// WaitStatisticsResultListIterator provides access to a complete listing of WaitStatistic values.
type WaitStatisticsResultListIterator struct {
	i    int
	page WaitStatisticsResultListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WaitStatisticsResultListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WaitStatisticsResultListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WaitStatisticsResultListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WaitStatisticsResultListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WaitStatisticsResultListIterator) Response() WaitStatisticsResultList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WaitStatisticsResultListIterator) Value() WaitStatistic {
	if !iter.page.NotDone() {
		return WaitStatistic{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WaitStatisticsResultListIterator type.
func NewWaitStatisticsResultListIterator(page WaitStatisticsResultListPage) WaitStatisticsResultListIterator {
	return WaitStatisticsResultListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wsrl WaitStatisticsResultList) IsEmpty() bool {
	return wsrl.Value == nil || len(*wsrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wsrl WaitStatisticsResultList) hasNextLink() bool {
	return wsrl.NextLink != nil && len(*wsrl.NextLink) != 0
}

// waitStatisticsResultListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wsrl WaitStatisticsResultList) waitStatisticsResultListPreparer(ctx context.Context) (*http.Request, error) {
	if !wsrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wsrl.NextLink)))
}

// WaitStatisticsResultListPage contains a page of WaitStatistic values.
type WaitStatisticsResultListPage struct {
	fn   func(context.Context, WaitStatisticsResultList) (WaitStatisticsResultList, error)
	wsrl WaitStatisticsResultList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WaitStatisticsResultListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WaitStatisticsResultListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wsrl)
		if err != nil {
			return err
		}
		page.wsrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WaitStatisticsResultListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WaitStatisticsResultListPage) NotDone() bool {
	return !page.wsrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WaitStatisticsResultListPage) Response() WaitStatisticsResultList {
	return page.wsrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WaitStatisticsResultListPage) Values() []WaitStatistic {
	if page.wsrl.IsEmpty() {
		return nil
	}
	return *page.wsrl.Value
}

// Creates a new instance of the WaitStatisticsResultListPage type.
func NewWaitStatisticsResultListPage(cur WaitStatisticsResultList, getNextPage func(context.Context, WaitStatisticsResultList) (WaitStatisticsResultList, error)) WaitStatisticsResultListPage {
	return WaitStatisticsResultListPage{
		fn:   getNextPage,
		wsrl: cur,
	}
}
