package logic

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic"

// AccessKeyRegenerateActionDefinition ...
type AccessKeyRegenerateActionDefinition struct {
	// KeyType - Possible values include: 'NotSpecified', 'Primary', 'Secondary'
	KeyType AccessKeyType `json:"keyType,omitempty"`
}

// AgreementContent the integration account agreement content.
type AgreementContent struct {
	// AS2 - The AS2 agreement content.
	AS2 *AS2AgreementContent `json:"aS2,omitempty"`
	// X12 - The X12 agreement content.
	X12 *X12AgreementContent `json:"x12,omitempty"`
	// Edifact - The EDIFACT agreement content.
	Edifact *EdifactAgreementContent `json:"edifact,omitempty"`
}

// ArtifactContentPropertiesDefinition the artifact content properties definition.
type ArtifactContentPropertiesDefinition struct {
	Content interface{} `json:"content,omitempty"`
	// ContentType - The content type.
	ContentType *string `json:"contentType,omitempty"`
	// ContentLink - The content link.
	ContentLink *ContentLink `json:"contentLink,omitempty"`
	// CreatedTime - The artifact creation time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - The artifact changed time.
	ChangedTime *date.Time  `json:"changedTime,omitempty"`
	Metadata    interface{} `json:"metadata,omitempty"`
}

// ArtifactProperties the artifact properties definition.
type ArtifactProperties struct {
	// CreatedTime - The artifact creation time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - The artifact changed time.
	ChangedTime *date.Time  `json:"changedTime,omitempty"`
	Metadata    interface{} `json:"metadata,omitempty"`
}

// AS2AcknowledgementConnectionSettings the AS2 agreement acknowledgement connection settings.
type AS2AcknowledgementConnectionSettings struct {
	// IgnoreCertificateNameMismatch - The value indicating whether to ignore mismatch in certificate name.
	IgnoreCertificateNameMismatch *bool `json:"ignoreCertificateNameMismatch,omitempty"`
	// SupportHTTPStatusCodeContinue - The value indicating whether to support HTTP status code 'CONTINUE'.
	SupportHTTPStatusCodeContinue *bool `json:"supportHttpStatusCodeContinue,omitempty"`
	// KeepHTTPConnectionAlive - The value indicating whether to keep the connection alive.
	KeepHTTPConnectionAlive *bool `json:"keepHttpConnectionAlive,omitempty"`
	// UnfoldHTTPHeaders - The value indicating whether to unfold the HTTP headers.
	UnfoldHTTPHeaders *bool `json:"unfoldHttpHeaders,omitempty"`
}

// AS2AgreementContent the integration account AS2 agreement content.
type AS2AgreementContent struct {
	// ReceiveAgreement - The AS2 one-way receive agreement.
	ReceiveAgreement *AS2OneWayAgreement `json:"receiveAgreement,omitempty"`
	// SendAgreement - The AS2 one-way send agreement.
	SendAgreement *AS2OneWayAgreement `json:"sendAgreement,omitempty"`
}

// AS2EnvelopeSettings the AS2 agreement envelope settings.
type AS2EnvelopeSettings struct {
	// MessageContentType - The message content type.
	MessageContentType *string `json:"messageContentType,omitempty"`
	// TransmitFileNameInMimeHeader - The value indicating whether to transmit file name in mime header.
	TransmitFileNameInMimeHeader *bool `json:"transmitFileNameInMimeHeader,omitempty"`
	// FileNameTemplate - The template for file name.
	FileNameTemplate *string `json:"fileNameTemplate,omitempty"`
	// SuspendMessageOnFileNameGenerationError - The value indicating whether to suspend message on file name generation error.
	SuspendMessageOnFileNameGenerationError *bool `json:"suspendMessageOnFileNameGenerationError,omitempty"`
	// AutogenerateFileName - The value indicating whether to auto generate file name.
	AutogenerateFileName *bool `json:"autogenerateFileName,omitempty"`
}

// AS2ErrorSettings the AS2 agreement error settings.
type AS2ErrorSettings struct {
	// SuspendDuplicateMessage - The value indicating whether to suspend duplicate message.
	SuspendDuplicateMessage *bool `json:"suspendDuplicateMessage,omitempty"`
	// ResendIfMdnNotReceived - The value indicating whether to resend message If MDN is not received.
	ResendIfMdnNotReceived *bool `json:"resendIfMdnNotReceived,omitempty"`
}

// AS2MdnSettings the AS2 agreement mdn settings.
type AS2MdnSettings struct {
	// NeedMdn - The value indicating whether to send or request a MDN.
	NeedMdn *bool `json:"needMdn,omitempty"`
	// SignMdn - The value indicating whether the MDN needs to be signed or not.
	SignMdn *bool `json:"signMdn,omitempty"`
	// SendMdnAsynchronously - The value indicating whether to send the asynchronous MDN.
	SendMdnAsynchronously *bool `json:"sendMdnAsynchronously,omitempty"`
	// ReceiptDeliveryURL - The receipt delivery URL.
	ReceiptDeliveryURL *string `json:"receiptDeliveryUrl,omitempty"`
	// DispositionNotificationTo - The disposition notification to header value.
	DispositionNotificationTo *string `json:"dispositionNotificationTo,omitempty"`
	// SignOutboundMdnIfOptional - The value indicating whether to sign the outbound MDN if optional.
	SignOutboundMdnIfOptional *bool `json:"signOutboundMdnIfOptional,omitempty"`
	// MdnText - The MDN text.
	MdnText *string `json:"mdnText,omitempty"`
	// SendInboundMdnToMessageBox - The value indicating whether to send inbound MDN to message box.
	SendInboundMdnToMessageBox *bool `json:"sendInboundMdnToMessageBox,omitempty"`
	// MicHashingAlgorithm - The signing or hashing algorithm. Possible values include: 'HashingAlgorithmNotSpecified', 'HashingAlgorithmNone', 'HashingAlgorithmMD5', 'HashingAlgorithmSHA1', 'HashingAlgorithmSHA2256', 'HashingAlgorithmSHA2384', 'HashingAlgorithmSHA2512'
	MicHashingAlgorithm HashingAlgorithm `json:"micHashingAlgorithm,omitempty"`
}

// AS2MessageConnectionSettings the AS2 agreement message connection settings.
type AS2MessageConnectionSettings struct {
	// IgnoreCertificateNameMismatch - The value indicating whether to ignore mismatch in certificate name.
	IgnoreCertificateNameMismatch *bool `json:"ignoreCertificateNameMismatch,omitempty"`
	// SupportHTTPStatusCodeContinue - The value indicating whether to support HTTP status code 'CONTINUE'.
	SupportHTTPStatusCodeContinue *bool `json:"supportHttpStatusCodeContinue,omitempty"`
	// KeepHTTPConnectionAlive - The value indicating whether to keep the connection alive.
	KeepHTTPConnectionAlive *bool `json:"keepHttpConnectionAlive,omitempty"`
	// UnfoldHTTPHeaders - The value indicating whether to unfold the HTTP headers.
	UnfoldHTTPHeaders *bool `json:"unfoldHttpHeaders,omitempty"`
}

// AS2OneWayAgreement the integration account AS2 one-way agreement.
type AS2OneWayAgreement struct {
	// SenderBusinessIdentity - The sender business identity
	SenderBusinessIdentity *BusinessIdentity `json:"senderBusinessIdentity,omitempty"`
	// ReceiverBusinessIdentity - The receiver business identity
	ReceiverBusinessIdentity *BusinessIdentity `json:"receiverBusinessIdentity,omitempty"`
	// ProtocolSettings - The AS2 protocol settings.
	ProtocolSettings *AS2ProtocolSettings `json:"protocolSettings,omitempty"`
}

// AS2ProtocolSettings the AS2 agreement protocol settings.
type AS2ProtocolSettings struct {
	// MessageConnectionSettings - The message connection settings.
	MessageConnectionSettings *AS2MessageConnectionSettings `json:"messageConnectionSettings,omitempty"`
	// AcknowledgementConnectionSettings - The acknowledgement connection settings.
	AcknowledgementConnectionSettings *AS2AcknowledgementConnectionSettings `json:"acknowledgementConnectionSettings,omitempty"`
	// MdnSettings - The MDN settings.
	MdnSettings *AS2MdnSettings `json:"mdnSettings,omitempty"`
	// SecuritySettings - The security settings.
	SecuritySettings *AS2SecuritySettings `json:"securitySettings,omitempty"`
	// ValidationSettings - The validation settings.
	ValidationSettings *AS2ValidationSettings `json:"validationSettings,omitempty"`
	// EnvelopeSettings - The envelope settings.
	EnvelopeSettings *AS2EnvelopeSettings `json:"envelopeSettings,omitempty"`
	// ErrorSettings - The error settings.
	ErrorSettings *AS2ErrorSettings `json:"errorSettings,omitempty"`
}

// AS2SecuritySettings the AS2 agreement security settings.
type AS2SecuritySettings struct {
	// OverrideGroupSigningCertificate - The value indicating whether to send or request a MDN.
	OverrideGroupSigningCertificate *bool `json:"overrideGroupSigningCertificate,omitempty"`
	// SigningCertificateName - The name of the signing certificate.
	SigningCertificateName *string `json:"signingCertificateName,omitempty"`
	// EncryptionCertificateName - The name of the encryption certificate.
	EncryptionCertificateName *string `json:"encryptionCertificateName,omitempty"`
	// EnableNrrForInboundEncodedMessages - The value indicating whether to enable NRR for inbound encoded messages.
	EnableNrrForInboundEncodedMessages *bool `json:"enableNrrForInboundEncodedMessages,omitempty"`
	// EnableNrrForInboundDecodedMessages - The value indicating whether to enable NRR for inbound decoded messages.
	EnableNrrForInboundDecodedMessages *bool `json:"enableNrrForInboundDecodedMessages,omitempty"`
	// EnableNrrForOutboundMdn - The value indicating whether to enable NRR for outbound MDN.
	EnableNrrForOutboundMdn *bool `json:"enableNrrForOutboundMdn,omitempty"`
	// EnableNrrForOutboundEncodedMessages - The value indicating whether to enable NRR for outbound encoded messages.
	EnableNrrForOutboundEncodedMessages *bool `json:"enableNrrForOutboundEncodedMessages,omitempty"`
	// EnableNrrForOutboundDecodedMessages - The value indicating whether to enable NRR for outbound decoded messages.
	EnableNrrForOutboundDecodedMessages *bool `json:"enableNrrForOutboundDecodedMessages,omitempty"`
	// EnableNrrForInboundMdn - The value indicating whether to enable NRR for inbound MDN.
	EnableNrrForInboundMdn *bool `json:"enableNrrForInboundMdn,omitempty"`
	// Sha2AlgorithmFormat - The Sha2 algorithm format. Valid values are Sha2, ShaHashSize, ShaHyphenHashSize, Sha2UnderscoreHashSize.
	Sha2AlgorithmFormat *string `json:"sha2AlgorithmFormat,omitempty"`
}

// AS2ValidationSettings the AS2 agreement validation settings.
type AS2ValidationSettings struct {
	// OverrideMessageProperties - The value indicating whether to override incoming message properties with those in agreement.
	OverrideMessageProperties *bool `json:"overrideMessageProperties,omitempty"`
	// EncryptMessage - The value indicating whether the message has to be encrypted.
	EncryptMessage *bool `json:"encryptMessage,omitempty"`
	// SignMessage - The value indicating whether the message has to be signed.
	SignMessage *bool `json:"signMessage,omitempty"`
	// CompressMessage - The value indicating whether the message has to be compressed.
	CompressMessage *bool `json:"compressMessage,omitempty"`
	// CheckDuplicateMessage - The value indicating whether to check for duplicate message.
	CheckDuplicateMessage *bool `json:"checkDuplicateMessage,omitempty"`
	// InterchangeDuplicatesValidityDays - The number of days to look back for duplicate interchange.
	InterchangeDuplicatesValidityDays *int32 `json:"interchangeDuplicatesValidityDays,omitempty"`
	// CheckCertificateRevocationListOnSend - The value indicating whether to check for certificate revocation list on send.
	CheckCertificateRevocationListOnSend *bool `json:"checkCertificateRevocationListOnSend,omitempty"`
	// CheckCertificateRevocationListOnReceive - The value indicating whether to check for certificate revocation list on receive.
	CheckCertificateRevocationListOnReceive *bool `json:"checkCertificateRevocationListOnReceive,omitempty"`
	// EncryptionAlgorithm - The encryption algorithm. Possible values include: 'EncryptionAlgorithmNotSpecified', 'EncryptionAlgorithmNone', 'EncryptionAlgorithmDES3', 'EncryptionAlgorithmRC2', 'EncryptionAlgorithmAES128', 'EncryptionAlgorithmAES192', 'EncryptionAlgorithmAES256'
	EncryptionAlgorithm EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`
	// SigningAlgorithm - The signing algorithm. Possible values include: 'SigningAlgorithmNotSpecified', 'SigningAlgorithmDefault', 'SigningAlgorithmSHA1', 'SigningAlgorithmSHA2256', 'SigningAlgorithmSHA2384', 'SigningAlgorithmSHA2512'
	SigningAlgorithm SigningAlgorithm `json:"signingAlgorithm,omitempty"`
}

// AssemblyCollection a collection of assembly definitions.
type AssemblyCollection struct {
	autorest.Response `json:"-"`
	Value             *[]AssemblyDefinition `json:"value,omitempty"`
}

// AssemblyDefinition the assembly definition.
type AssemblyDefinition struct {
	autorest.Response `json:"-"`
	// Properties - The assembly properties.
	Properties *AssemblyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AssemblyDefinition.
func (ad AssemblyDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ad.Properties != nil {
		objectMap["properties"] = ad.Properties
	}
	if ad.Location != nil {
		objectMap["location"] = ad.Location
	}
	if ad.Tags != nil {
		objectMap["tags"] = ad.Tags
	}
	return json.Marshal(objectMap)
}

// AssemblyProperties the assembly properties definition.
type AssemblyProperties struct {
	// AssemblyName - The assembly name.
	AssemblyName *string `json:"assemblyName,omitempty"`
	// AssemblyVersion - The assembly version.
	AssemblyVersion *string `json:"assemblyVersion,omitempty"`
	// AssemblyCulture - The assembly culture.
	AssemblyCulture *string `json:"assemblyCulture,omitempty"`
	// AssemblyPublicKeyToken - The assembly public key token.
	AssemblyPublicKeyToken *string     `json:"assemblyPublicKeyToken,omitempty"`
	Content                interface{} `json:"content,omitempty"`
	// ContentType - The content type.
	ContentType *string `json:"contentType,omitempty"`
	// ContentLink - The content link.
	ContentLink *ContentLink `json:"contentLink,omitempty"`
	// CreatedTime - The artifact creation time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - The artifact changed time.
	ChangedTime *date.Time  `json:"changedTime,omitempty"`
	Metadata    interface{} `json:"metadata,omitempty"`
}

// AzureResourceErrorInfo the azure resource error info.
type AzureResourceErrorInfo struct {
	// Message - The error message.
	Message *string `json:"message,omitempty"`
	// Details - The error details.
	Details *[]AzureResourceErrorInfo `json:"details,omitempty"`
	// Code - The error code.
	Code *string `json:"code,omitempty"`
}

// B2BPartnerContent the B2B partner content.
type B2BPartnerContent struct {
	// BusinessIdentities - The list of partner business identities.
	BusinessIdentities *[]BusinessIdentity `json:"businessIdentities,omitempty"`
}

// BatchConfiguration the batch configuration resource definition.
type BatchConfiguration struct {
	autorest.Response `json:"-"`
	// Properties - The batch configuration properties.
	Properties *BatchConfigurationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BatchConfiguration.
func (bc BatchConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bc.Properties != nil {
		objectMap["properties"] = bc.Properties
	}
	if bc.Location != nil {
		objectMap["location"] = bc.Location
	}
	if bc.Tags != nil {
		objectMap["tags"] = bc.Tags
	}
	return json.Marshal(objectMap)
}

// BatchConfigurationCollection a collection of batch configurations.
type BatchConfigurationCollection struct {
	autorest.Response `json:"-"`
	Value             *[]BatchConfiguration `json:"value,omitempty"`
}

// BatchConfigurationProperties the batch configuration properties definition.
type BatchConfigurationProperties struct {
	// BatchGroupName - The name of the batch group.
	BatchGroupName *string `json:"batchGroupName,omitempty"`
	// ReleaseCriteria - The batch release criteria.
	ReleaseCriteria *BatchReleaseCriteria `json:"releaseCriteria,omitempty"`
	// CreatedTime - The artifact creation time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - The artifact changed time.
	ChangedTime *date.Time  `json:"changedTime,omitempty"`
	Metadata    interface{} `json:"metadata,omitempty"`
}

// BatchReleaseCriteria the batch release criteria.
type BatchReleaseCriteria struct {
	// MessageCount - The message count.
	MessageCount *int32 `json:"messageCount,omitempty"`
	// BatchSize - The batch size in bytes.
	BatchSize *int32 `json:"batchSize,omitempty"`
	// Recurrence - The recurrence.
	Recurrence *WorkflowTriggerRecurrence `json:"recurrence,omitempty"`
}

// BusinessIdentity the integration account partner's business identity.
type BusinessIdentity struct {
	// Qualifier - The business identity qualifier e.g. as2identity, ZZ, ZZZ, 31, 32
	Qualifier *string `json:"qualifier,omitempty"`
	// Value - The user defined business identity value.
	Value *string `json:"value,omitempty"`
}

// CallbackURL the callback url.
type CallbackURL struct {
	autorest.Response `json:"-"`
	// Value - The URL value.
	Value *string `json:"value,omitempty"`
}

// ContentHash the content hash.
type ContentHash struct {
	// Algorithm - The algorithm of the content hash.
	Algorithm *string `json:"algorithm,omitempty"`
	// Value - The value of the content hash.
	Value *string `json:"value,omitempty"`
}

// ContentLink the content link.
type ContentLink struct {
	// URI - The content link URI.
	URI *string `json:"uri,omitempty"`
	// ContentVersion - The content version.
	ContentVersion *string `json:"contentVersion,omitempty"`
	// ContentSize - The content size.
	ContentSize *int64 `json:"contentSize,omitempty"`
	// ContentHash - The content hash.
	ContentHash *ContentHash `json:"contentHash,omitempty"`
	// Metadata - The metadata.
	Metadata interface{} `json:"metadata,omitempty"`
}

// Correlation the correlation property.
type Correlation struct {
	// ClientTrackingID - The client tracking id.
	ClientTrackingID *string `json:"clientTrackingId,omitempty"`
}

// EdifactAcknowledgementSettings the Edifact agreement acknowledgement settings.
type EdifactAcknowledgementSettings struct {
	// NeedTechnicalAcknowledgement - The value indicating whether technical acknowledgement is needed.
	NeedTechnicalAcknowledgement *bool `json:"needTechnicalAcknowledgement,omitempty"`
	// BatchTechnicalAcknowledgements - The value indicating whether to batch the technical acknowledgements.
	BatchTechnicalAcknowledgements *bool `json:"batchTechnicalAcknowledgements,omitempty"`
	// NeedFunctionalAcknowledgement - The value indicating whether functional acknowledgement is needed.
	NeedFunctionalAcknowledgement *bool `json:"needFunctionalAcknowledgement,omitempty"`
	// BatchFunctionalAcknowledgements - The value indicating whether to batch functional acknowledgements.
	BatchFunctionalAcknowledgements *bool `json:"batchFunctionalAcknowledgements,omitempty"`
	// NeedLoopForValidMessages - The value indicating whether a loop is needed for valid messages.
	NeedLoopForValidMessages *bool `json:"needLoopForValidMessages,omitempty"`
	// SendSynchronousAcknowledgement - The value indicating whether to send synchronous acknowledgement.
	SendSynchronousAcknowledgement *bool `json:"sendSynchronousAcknowledgement,omitempty"`
	// AcknowledgementControlNumberPrefix - The acknowledgement control number prefix.
	AcknowledgementControlNumberPrefix *string `json:"acknowledgementControlNumberPrefix,omitempty"`
	// AcknowledgementControlNumberSuffix - The acknowledgement control number suffix.
	AcknowledgementControlNumberSuffix *string `json:"acknowledgementControlNumberSuffix,omitempty"`
	// AcknowledgementControlNumberLowerBound - The acknowledgement control number lower bound.
	AcknowledgementControlNumberLowerBound *int32 `json:"acknowledgementControlNumberLowerBound,omitempty"`
	// AcknowledgementControlNumberUpperBound - The acknowledgement control number upper bound.
	AcknowledgementControlNumberUpperBound *int32 `json:"acknowledgementControlNumberUpperBound,omitempty"`
	// RolloverAcknowledgementControlNumber - The value indicating whether to rollover acknowledgement control number.
	RolloverAcknowledgementControlNumber *bool `json:"rolloverAcknowledgementControlNumber,omitempty"`
}

// EdifactAgreementContent the Edifact agreement content.
type EdifactAgreementContent struct {
	// ReceiveAgreement - The EDIFACT one-way receive agreement.
	ReceiveAgreement *EdifactOneWayAgreement `json:"receiveAgreement,omitempty"`
	// SendAgreement - The EDIFACT one-way send agreement.
	SendAgreement *EdifactOneWayAgreement `json:"sendAgreement,omitempty"`
}

// EdifactDelimiterOverride the Edifact delimiter override settings.
type EdifactDelimiterOverride struct {
	// MessageID - The message id.
	MessageID *string `json:"messageId,omitempty"`
	// MessageVersion - The message version.
	MessageVersion *string `json:"messageVersion,omitempty"`
	// MessageRelease - The message release.
	MessageRelease *string `json:"messageRelease,omitempty"`
	// DataElementSeparator - The data element separator.
	DataElementSeparator *int32 `json:"dataElementSeparator,omitempty"`
	// ComponentSeparator - The component separator.
	ComponentSeparator *int32 `json:"componentSeparator,omitempty"`
	// SegmentTerminator - The segment terminator.
	SegmentTerminator *int32 `json:"segmentTerminator,omitempty"`
	// RepetitionSeparator - The repetition separator.
	RepetitionSeparator *int32 `json:"repetitionSeparator,omitempty"`
	// SegmentTerminatorSuffix - The segment terminator suffix. Possible values include: 'SegmentTerminatorSuffixNotSpecified', 'SegmentTerminatorSuffixNone', 'SegmentTerminatorSuffixCR', 'SegmentTerminatorSuffixLF', 'SegmentTerminatorSuffixCRLF'
	SegmentTerminatorSuffix SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
	// DecimalPointIndicator - The decimal point indicator. Possible values include: 'EdifactDecimalIndicatorNotSpecified', 'EdifactDecimalIndicatorComma', 'EdifactDecimalIndicatorDecimal'
	DecimalPointIndicator EdifactDecimalIndicator `json:"decimalPointIndicator,omitempty"`
	// ReleaseIndicator - The release indicator.
	ReleaseIndicator *int32 `json:"releaseIndicator,omitempty"`
	// MessageAssociationAssignedCode - The message association assigned code.
	MessageAssociationAssignedCode *string `json:"messageAssociationAssignedCode,omitempty"`
	// TargetNamespace - The target namespace on which this delimiter settings has to be applied.
	TargetNamespace *string `json:"targetNamespace,omitempty"`
}

// EdifactEnvelopeOverride the Edifact envelope override settings.
type EdifactEnvelopeOverride struct {
	// MessageID - The message id on which this envelope settings has to be applied.
	MessageID *string `json:"messageId,omitempty"`
	// MessageVersion - The message version on which this envelope settings has to be applied.
	MessageVersion *string `json:"messageVersion,omitempty"`
	// MessageRelease - The message release version on which this envelope settings has to be applied.
	MessageRelease *string `json:"messageRelease,omitempty"`
	// MessageAssociationAssignedCode - The message association assigned code.
	MessageAssociationAssignedCode *string `json:"messageAssociationAssignedCode,omitempty"`
	// TargetNamespace - The target namespace on which this envelope settings has to be applied.
	TargetNamespace *string `json:"targetNamespace,omitempty"`
	// FunctionalGroupID - The functional group id.
	FunctionalGroupID *string `json:"functionalGroupId,omitempty"`
	// SenderApplicationQualifier - The sender application qualifier.
	SenderApplicationQualifier *string `json:"senderApplicationQualifier,omitempty"`
	// SenderApplicationID - The sender application id.
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`
	// ReceiverApplicationQualifier - The receiver application qualifier.
	ReceiverApplicationQualifier *string `json:"receiverApplicationQualifier,omitempty"`
	// ReceiverApplicationID - The receiver application id.
	ReceiverApplicationID *string `json:"receiverApplicationId,omitempty"`
	// ControllingAgencyCode - The controlling agency code.
	ControllingAgencyCode *string `json:"controllingAgencyCode,omitempty"`
	// GroupHeaderMessageVersion - The group header message version.
	GroupHeaderMessageVersion *string `json:"groupHeaderMessageVersion,omitempty"`
	// GroupHeaderMessageRelease - The group header message release.
	GroupHeaderMessageRelease *string `json:"groupHeaderMessageRelease,omitempty"`
	// AssociationAssignedCode - The association assigned code.
	AssociationAssignedCode *string `json:"associationAssignedCode,omitempty"`
	// ApplicationPassword - The application password.
	ApplicationPassword *string `json:"applicationPassword,omitempty"`
}

// EdifactEnvelopeSettings the Edifact agreement envelope settings.
type EdifactEnvelopeSettings struct {
	// GroupAssociationAssignedCode - The group association assigned code.
	GroupAssociationAssignedCode *string `json:"groupAssociationAssignedCode,omitempty"`
	// CommunicationAgreementID - The communication agreement id.
	CommunicationAgreementID *string `json:"communicationAgreementId,omitempty"`
	// ApplyDelimiterStringAdvice - The value indicating whether to apply delimiter string advice.
	ApplyDelimiterStringAdvice *bool `json:"applyDelimiterStringAdvice,omitempty"`
	// CreateGroupingSegments - The value indicating whether to create grouping segments.
	CreateGroupingSegments *bool `json:"createGroupingSegments,omitempty"`
	// EnableDefaultGroupHeaders - The value indicating whether to enable default group headers.
	EnableDefaultGroupHeaders *bool `json:"enableDefaultGroupHeaders,omitempty"`
	// RecipientReferencePasswordValue - The recipient reference password value.
	RecipientReferencePasswordValue *string `json:"recipientReferencePasswordValue,omitempty"`
	// RecipientReferencePasswordQualifier - The recipient reference password qualifier.
	RecipientReferencePasswordQualifier *string `json:"recipientReferencePasswordQualifier,omitempty"`
	// ApplicationReferenceID - The application reference id.
	ApplicationReferenceID *string `json:"applicationReferenceId,omitempty"`
	// ProcessingPriorityCode - The processing priority code.
	ProcessingPriorityCode *string `json:"processingPriorityCode,omitempty"`
	// InterchangeControlNumberLowerBound - The interchange control number lower bound.
	InterchangeControlNumberLowerBound *int64 `json:"interchangeControlNumberLowerBound,omitempty"`
	// InterchangeControlNumberUpperBound - The interchange control number upper bound.
	InterchangeControlNumberUpperBound *int64 `json:"interchangeControlNumberUpperBound,omitempty"`
	// RolloverInterchangeControlNumber - The value indicating whether to rollover interchange control number.
	RolloverInterchangeControlNumber *bool `json:"rolloverInterchangeControlNumber,omitempty"`
	// InterchangeControlNumberPrefix - The interchange control number prefix.
	InterchangeControlNumberPrefix *string `json:"interchangeControlNumberPrefix,omitempty"`
	// InterchangeControlNumberSuffix - The interchange control number suffix.
	InterchangeControlNumberSuffix *string `json:"interchangeControlNumberSuffix,omitempty"`
	// SenderReverseRoutingAddress - The sender reverse routing address.
	SenderReverseRoutingAddress *string `json:"senderReverseRoutingAddress,omitempty"`
	// ReceiverReverseRoutingAddress - The receiver reverse routing address.
	ReceiverReverseRoutingAddress *string `json:"receiverReverseRoutingAddress,omitempty"`
	// FunctionalGroupID - The functional group id.
	FunctionalGroupID *string `json:"functionalGroupId,omitempty"`
	// GroupControllingAgencyCode - The group controlling agency code.
	GroupControllingAgencyCode *string `json:"groupControllingAgencyCode,omitempty"`
	// GroupMessageVersion - The group message version.
	GroupMessageVersion *string `json:"groupMessageVersion,omitempty"`
	// GroupMessageRelease - The group message release.
	GroupMessageRelease *string `json:"groupMessageRelease,omitempty"`
	// GroupControlNumberLowerBound - The group control number lower bound.
	GroupControlNumberLowerBound *int64 `json:"groupControlNumberLowerBound,omitempty"`
	// GroupControlNumberUpperBound - The group control number upper bound.
	GroupControlNumberUpperBound *int64 `json:"groupControlNumberUpperBound,omitempty"`
	// RolloverGroupControlNumber - The value indicating whether to rollover group control number.
	RolloverGroupControlNumber *bool `json:"rolloverGroupControlNumber,omitempty"`
	// GroupControlNumberPrefix - The group control number prefix.
	GroupControlNumberPrefix *string `json:"groupControlNumberPrefix,omitempty"`
	// GroupControlNumberSuffix - The group control number suffix.
	GroupControlNumberSuffix *string `json:"groupControlNumberSuffix,omitempty"`
	// GroupApplicationReceiverQualifier - The group application receiver qualifier.
	GroupApplicationReceiverQualifier *string `json:"groupApplicationReceiverQualifier,omitempty"`
	// GroupApplicationReceiverID - The group application receiver id.
	GroupApplicationReceiverID *string `json:"groupApplicationReceiverId,omitempty"`
	// GroupApplicationSenderQualifier - The group application sender qualifier.
	GroupApplicationSenderQualifier *string `json:"groupApplicationSenderQualifier,omitempty"`
	// GroupApplicationSenderID - The group application sender id.
	GroupApplicationSenderID *string `json:"groupApplicationSenderId,omitempty"`
	// GroupApplicationPassword - The group application password.
	GroupApplicationPassword *string `json:"groupApplicationPassword,omitempty"`
	// OverwriteExistingTransactionSetControlNumber - The value indicating whether to overwrite existing transaction set control number.
	OverwriteExistingTransactionSetControlNumber *bool `json:"overwriteExistingTransactionSetControlNumber,omitempty"`
	// TransactionSetControlNumberPrefix - The transaction set control number prefix.
	TransactionSetControlNumberPrefix *string `json:"transactionSetControlNumberPrefix,omitempty"`
	// TransactionSetControlNumberSuffix - The transaction set control number suffix.
	TransactionSetControlNumberSuffix *string `json:"transactionSetControlNumberSuffix,omitempty"`
	// TransactionSetControlNumberLowerBound - The transaction set control number lower bound.
	TransactionSetControlNumberLowerBound *int64 `json:"transactionSetControlNumberLowerBound,omitempty"`
	// TransactionSetControlNumberUpperBound - The transaction set control number upper bound.
	TransactionSetControlNumberUpperBound *int64 `json:"transactionSetControlNumberUpperBound,omitempty"`
	// RolloverTransactionSetControlNumber - The value indicating whether to rollover transaction set control number.
	RolloverTransactionSetControlNumber *bool `json:"rolloverTransactionSetControlNumber,omitempty"`
	// IsTestInterchange - The value indicating whether the message is a test interchange.
	IsTestInterchange *bool `json:"isTestInterchange,omitempty"`
	// SenderInternalIdentification - The sender internal identification.
	SenderInternalIdentification *string `json:"senderInternalIdentification,omitempty"`
	// SenderInternalSubIdentification - The sender internal sub identification.
	SenderInternalSubIdentification *string `json:"senderInternalSubIdentification,omitempty"`
	// ReceiverInternalIdentification - The receiver internal identification.
	ReceiverInternalIdentification *string `json:"receiverInternalIdentification,omitempty"`
	// ReceiverInternalSubIdentification - The receiver internal sub identification.
	ReceiverInternalSubIdentification *string `json:"receiverInternalSubIdentification,omitempty"`
}

// EdifactFramingSettings the Edifact agreement framing settings.
type EdifactFramingSettings struct {
	// ServiceCodeListDirectoryVersion - The service code list directory version.
	ServiceCodeListDirectoryVersion *string `json:"serviceCodeListDirectoryVersion,omitempty"`
	// CharacterEncoding - The character encoding.
	CharacterEncoding *string `json:"characterEncoding,omitempty"`
	// ProtocolVersion - The protocol version.
	ProtocolVersion *int32 `json:"protocolVersion,omitempty"`
	// DataElementSeparator - The data element separator.
	DataElementSeparator *int32 `json:"dataElementSeparator,omitempty"`
	// ComponentSeparator - The component separator.
	ComponentSeparator *int32 `json:"componentSeparator,omitempty"`
	// SegmentTerminator - The segment terminator.
	SegmentTerminator *int32 `json:"segmentTerminator,omitempty"`
	// ReleaseIndicator - The release indicator.
	ReleaseIndicator *int32 `json:"releaseIndicator,omitempty"`
	// RepetitionSeparator - The repetition separator.
	RepetitionSeparator *int32 `json:"repetitionSeparator,omitempty"`
	// CharacterSet - The EDIFACT frame setting characterSet. Possible values include: 'EdifactCharacterSetNotSpecified', 'EdifactCharacterSetUNOB', 'EdifactCharacterSetUNOA', 'EdifactCharacterSetUNOC', 'EdifactCharacterSetUNOD', 'EdifactCharacterSetUNOE', 'EdifactCharacterSetUNOF', 'EdifactCharacterSetUNOG', 'EdifactCharacterSetUNOH', 'EdifactCharacterSetUNOI', 'EdifactCharacterSetUNOJ', 'EdifactCharacterSetUNOK', 'EdifactCharacterSetUNOX', 'EdifactCharacterSetUNOY', 'EdifactCharacterSetKECA'
	CharacterSet EdifactCharacterSet `json:"characterSet,omitempty"`
	// DecimalPointIndicator - The EDIFACT frame setting decimal indicator. Possible values include: 'EdifactDecimalIndicatorNotSpecified', 'EdifactDecimalIndicatorComma', 'EdifactDecimalIndicatorDecimal'
	DecimalPointIndicator EdifactDecimalIndicator `json:"decimalPointIndicator,omitempty"`
	// SegmentTerminatorSuffix - The EDIFACT frame setting segment terminator suffix. Possible values include: 'SegmentTerminatorSuffixNotSpecified', 'SegmentTerminatorSuffixNone', 'SegmentTerminatorSuffixCR', 'SegmentTerminatorSuffixLF', 'SegmentTerminatorSuffixCRLF'
	SegmentTerminatorSuffix SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
}

// EdifactMessageFilter the Edifact message filter for odata query.
type EdifactMessageFilter struct {
	// MessageFilterType - The message filter type. Possible values include: 'MessageFilterTypeNotSpecified', 'MessageFilterTypeInclude', 'MessageFilterTypeExclude'
	MessageFilterType MessageFilterType `json:"messageFilterType,omitempty"`
}

// EdifactMessageIdentifier the Edifact message identifier.
type EdifactMessageIdentifier struct {
	// MessageID - The message id on which this envelope settings has to be applied.
	MessageID *string `json:"messageId,omitempty"`
}

// EdifactOneWayAgreement the Edifact one way agreement.
type EdifactOneWayAgreement struct {
	// SenderBusinessIdentity - The sender business identity
	SenderBusinessIdentity *BusinessIdentity `json:"senderBusinessIdentity,omitempty"`
	// ReceiverBusinessIdentity - The receiver business identity
	ReceiverBusinessIdentity *BusinessIdentity `json:"receiverBusinessIdentity,omitempty"`
	// ProtocolSettings - The EDIFACT protocol settings.
	ProtocolSettings *EdifactProtocolSettings `json:"protocolSettings,omitempty"`
}

// EdifactProcessingSettings the Edifact agreement protocol settings.
type EdifactProcessingSettings struct {
	// MaskSecurityInfo - The value indicating whether to mask security information.
	MaskSecurityInfo *bool `json:"maskSecurityInfo,omitempty"`
	// PreserveInterchange - The value indicating whether to preserve interchange.
	PreserveInterchange *bool `json:"preserveInterchange,omitempty"`
	// SuspendInterchangeOnError - The value indicating whether to suspend interchange on error.
	SuspendInterchangeOnError *bool `json:"suspendInterchangeOnError,omitempty"`
	// CreateEmptyXMLTagsForTrailingSeparators - The value indicating whether to create empty xml tags for trailing separators.
	CreateEmptyXMLTagsForTrailingSeparators *bool `json:"createEmptyXmlTagsForTrailingSeparators,omitempty"`
	// UseDotAsDecimalSeparator - The value indicating whether to use dot as decimal separator.
	UseDotAsDecimalSeparator *bool `json:"useDotAsDecimalSeparator,omitempty"`
}

// EdifactProtocolSettings the Edifact agreement protocol settings.
type EdifactProtocolSettings struct {
	// ValidationSettings - The EDIFACT validation settings.
	ValidationSettings *EdifactValidationSettings `json:"validationSettings,omitempty"`
	// FramingSettings - The EDIFACT framing settings.
	FramingSettings *EdifactFramingSettings `json:"framingSettings,omitempty"`
	// EnvelopeSettings - The EDIFACT envelope settings.
	EnvelopeSettings *EdifactEnvelopeSettings `json:"envelopeSettings,omitempty"`
	// AcknowledgementSettings - The EDIFACT acknowledgement settings.
	AcknowledgementSettings *EdifactAcknowledgementSettings `json:"acknowledgementSettings,omitempty"`
	// MessageFilter - The EDIFACT message filter.
	MessageFilter *EdifactMessageFilter `json:"messageFilter,omitempty"`
	// ProcessingSettings - The EDIFACT processing Settings.
	ProcessingSettings *EdifactProcessingSettings `json:"processingSettings,omitempty"`
	// EnvelopeOverrides - The EDIFACT envelope override settings.
	EnvelopeOverrides *[]EdifactEnvelopeOverride `json:"envelopeOverrides,omitempty"`
	// MessageFilterList - The EDIFACT message filter list.
	MessageFilterList *[]EdifactMessageIdentifier `json:"messageFilterList,omitempty"`
	// SchemaReferences - The EDIFACT schema references.
	SchemaReferences *[]EdifactSchemaReference `json:"schemaReferences,omitempty"`
	// ValidationOverrides - The EDIFACT validation override settings.
	ValidationOverrides *[]EdifactValidationOverride `json:"validationOverrides,omitempty"`
	// EdifactDelimiterOverrides - The EDIFACT delimiter override settings.
	EdifactDelimiterOverrides *[]EdifactDelimiterOverride `json:"edifactDelimiterOverrides,omitempty"`
}

// EdifactSchemaReference the Edifact schema reference.
type EdifactSchemaReference struct {
	// MessageID - The message id.
	MessageID *string `json:"messageId,omitempty"`
	// MessageVersion - The message version.
	MessageVersion *string `json:"messageVersion,omitempty"`
	// MessageRelease - The message release version.
	MessageRelease *string `json:"messageRelease,omitempty"`
	// SenderApplicationID - The sender application id.
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`
	// SenderApplicationQualifier - The sender application qualifier.
	SenderApplicationQualifier *string `json:"senderApplicationQualifier,omitempty"`
	// AssociationAssignedCode - The association assigned code.
	AssociationAssignedCode *string `json:"associationAssignedCode,omitempty"`
	// SchemaName - The schema name.
	SchemaName *string `json:"schemaName,omitempty"`
}

// EdifactValidationOverride the Edifact validation override settings.
type EdifactValidationOverride struct {
	// MessageID - The message id on which the validation settings has to be applied.
	MessageID *string `json:"messageId,omitempty"`
	// EnforceCharacterSet - The value indicating whether to validate character Set.
	EnforceCharacterSet *bool `json:"enforceCharacterSet,omitempty"`
	// ValidateEdiTypes - The value indicating whether to validate EDI types.
	ValidateEdiTypes *bool `json:"validateEdiTypes,omitempty"`
	// ValidateXsdTypes - The value indicating whether to validate XSD types.
	ValidateXsdTypes *bool `json:"validateXsdTypes,omitempty"`
	// AllowLeadingAndTrailingSpacesAndZeroes - The value indicating whether to allow leading and trailing spaces and zeroes.
	AllowLeadingAndTrailingSpacesAndZeroes *bool `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`
	// TrailingSeparatorPolicy - The trailing separator policy. Possible values include: 'TrailingSeparatorPolicyNotSpecified', 'TrailingSeparatorPolicyNotAllowed', 'TrailingSeparatorPolicyOptional', 'TrailingSeparatorPolicyMandatory'
	TrailingSeparatorPolicy TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`
	// TrimLeadingAndTrailingSpacesAndZeroes - The value indicating whether to trim leading and trailing spaces and zeroes.
	TrimLeadingAndTrailingSpacesAndZeroes *bool `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`
}

// EdifactValidationSettings the Edifact agreement validation settings.
type EdifactValidationSettings struct {
	// ValidateCharacterSet - The value indicating whether to validate character set in the message.
	ValidateCharacterSet *bool `json:"validateCharacterSet,omitempty"`
	// CheckDuplicateInterchangeControlNumber - The value indicating whether to check for duplicate interchange control number.
	CheckDuplicateInterchangeControlNumber *bool `json:"checkDuplicateInterchangeControlNumber,omitempty"`
	// InterchangeControlNumberValidityDays - The validity period of interchange control number.
	InterchangeControlNumberValidityDays *int32 `json:"interchangeControlNumberValidityDays,omitempty"`
	// CheckDuplicateGroupControlNumber - The value indicating whether to check for duplicate group control number.
	CheckDuplicateGroupControlNumber *bool `json:"checkDuplicateGroupControlNumber,omitempty"`
	// CheckDuplicateTransactionSetControlNumber - The value indicating whether to check for duplicate transaction set control number.
	CheckDuplicateTransactionSetControlNumber *bool `json:"checkDuplicateTransactionSetControlNumber,omitempty"`
	// ValidateEdiTypes - The value indicating whether to Whether to validate EDI types.
	ValidateEdiTypes *bool `json:"validateEdiTypes,omitempty"`
	// ValidateXsdTypes - The value indicating whether to Whether to validate XSD types.
	ValidateXsdTypes *bool `json:"validateXsdTypes,omitempty"`
	// AllowLeadingAndTrailingSpacesAndZeroes - The value indicating whether to allow leading and trailing spaces and zeroes.
	AllowLeadingAndTrailingSpacesAndZeroes *bool `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`
	// TrimLeadingAndTrailingSpacesAndZeroes - The value indicating whether to trim leading and trailing spaces and zeroes.
	TrimLeadingAndTrailingSpacesAndZeroes *bool `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`
	// TrailingSeparatorPolicy - The trailing separator policy. Possible values include: 'TrailingSeparatorPolicyNotSpecified', 'TrailingSeparatorPolicyNotAllowed', 'TrailingSeparatorPolicyOptional', 'TrailingSeparatorPolicyMandatory'
	TrailingSeparatorPolicy TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`
}

// ErrorInfo the error info.
type ErrorInfo struct {
	// Code - The error code.
	Code *string `json:"code,omitempty"`
}

// ErrorProperties error properties indicate why the Logic service was not able to process the incoming
// request. The reason is provided in the error message.
type ErrorProperties struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse error response indicates Logic service is not able to process the incoming request. The
// error property contains the error details.
type ErrorResponse struct {
	// Error - The error properties.
	Error *ErrorProperties `json:"error,omitempty"`
}

// Expression ...
type Expression struct {
	Text           *string                 `json:"text,omitempty"`
	Value          interface{}             `json:"value,omitempty"`
	Subexpressions *[]Expression           `json:"subexpressions,omitempty"`
	Error          *AzureResourceErrorInfo `json:"error,omitempty"`
}

// ExpressionRoot ...
type ExpressionRoot struct {
	// Path - The path.
	Path           *string                 `json:"path,omitempty"`
	Text           *string                 `json:"text,omitempty"`
	Value          interface{}             `json:"value,omitempty"`
	Subexpressions *[]Expression           `json:"subexpressions,omitempty"`
	Error          *AzureResourceErrorInfo `json:"error,omitempty"`
}

// ExpressionTraces ...
type ExpressionTraces struct {
	autorest.Response `json:"-"`
	Inputs            *[]ExpressionRoot `json:"inputs,omitempty"`
}

// GenerateUpgradedDefinitionParameters the parameters to generate upgraded definition.
type GenerateUpgradedDefinitionParameters struct {
	// TargetSchemaVersion - The target schema version.
	TargetSchemaVersion *string `json:"targetSchemaVersion,omitempty"`
}

// GetCallbackURLParameters the callback url parameters.
type GetCallbackURLParameters struct {
	// NotAfter - The expiry time.
	NotAfter *date.Time `json:"notAfter,omitempty"`
	// KeyType - The key type. Possible values include: 'KeyTypeNotSpecified', 'KeyTypePrimary', 'KeyTypeSecondary'
	KeyType KeyType `json:"keyType,omitempty"`
}

// IntegrationAccount the integration account.
type IntegrationAccount struct {
	autorest.Response `json:"-"`
	// Properties - The integration account properties.
	Properties interface{} `json:"properties,omitempty"`
	// Sku - The sku.
	Sku *IntegrationAccountSku `json:"sku,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntegrationAccount.
func (ia IntegrationAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ia.Properties != nil {
		objectMap["properties"] = ia.Properties
	}
	if ia.Sku != nil {
		objectMap["sku"] = ia.Sku
	}
	if ia.Location != nil {
		objectMap["location"] = ia.Location
	}
	if ia.Tags != nil {
		objectMap["tags"] = ia.Tags
	}
	return json.Marshal(objectMap)
}

// IntegrationAccountAgreement the integration account agreement.
type IntegrationAccountAgreement struct {
	autorest.Response `json:"-"`
	// IntegrationAccountAgreementProperties - The integration account agreement properties.
	*IntegrationAccountAgreementProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountAgreement.
func (iaa IntegrationAccountAgreement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iaa.IntegrationAccountAgreementProperties != nil {
		objectMap["properties"] = iaa.IntegrationAccountAgreementProperties
	}
	if iaa.Location != nil {
		objectMap["location"] = iaa.Location
	}
	if iaa.Tags != nil {
		objectMap["tags"] = iaa.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationAccountAgreement struct.
func (iaa *IntegrationAccountAgreement) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var integrationAccountAgreementProperties IntegrationAccountAgreementProperties
				err = json.Unmarshal(*v, &integrationAccountAgreementProperties)
				if err != nil {
					return err
				}
				iaa.IntegrationAccountAgreementProperties = &integrationAccountAgreementProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iaa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iaa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				iaa.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				iaa.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				iaa.Tags = tags
			}
		}
	}

	return nil
}

// IntegrationAccountAgreementFilter the integration account agreement filter for odata query.
type IntegrationAccountAgreementFilter struct {
	// AgreementType - The agreement type of integration account agreement. Possible values include: 'AgreementTypeNotSpecified', 'AgreementTypeAS2', 'AgreementTypeX12', 'AgreementTypeEdifact'
	AgreementType AgreementType `json:"agreementType,omitempty"`
}

// IntegrationAccountAgreementListResult the list of integration account agreements.
type IntegrationAccountAgreementListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of integration account agreements.
	Value *[]IntegrationAccountAgreement `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationAccountAgreementListResultIterator provides access to a complete listing of
// IntegrationAccountAgreement values.
type IntegrationAccountAgreementListResultIterator struct {
	i    int
	page IntegrationAccountAgreementListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IntegrationAccountAgreementListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountAgreementListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IntegrationAccountAgreementListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IntegrationAccountAgreementListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IntegrationAccountAgreementListResultIterator) Response() IntegrationAccountAgreementListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IntegrationAccountAgreementListResultIterator) Value() IntegrationAccountAgreement {
	if !iter.page.NotDone() {
		return IntegrationAccountAgreement{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IntegrationAccountAgreementListResultIterator type.
func NewIntegrationAccountAgreementListResultIterator(page IntegrationAccountAgreementListResultPage) IntegrationAccountAgreementListResultIterator {
	return IntegrationAccountAgreementListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iaalr IntegrationAccountAgreementListResult) IsEmpty() bool {
	return iaalr.Value == nil || len(*iaalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (iaalr IntegrationAccountAgreementListResult) hasNextLink() bool {
	return iaalr.NextLink != nil && len(*iaalr.NextLink) != 0
}

// integrationAccountAgreementListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iaalr IntegrationAccountAgreementListResult) integrationAccountAgreementListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !iaalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iaalr.NextLink)))
}

// IntegrationAccountAgreementListResultPage contains a page of IntegrationAccountAgreement values.
type IntegrationAccountAgreementListResultPage struct {
	fn    func(context.Context, IntegrationAccountAgreementListResult) (IntegrationAccountAgreementListResult, error)
	iaalr IntegrationAccountAgreementListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IntegrationAccountAgreementListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountAgreementListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.iaalr)
		if err != nil {
			return err
		}
		page.iaalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IntegrationAccountAgreementListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IntegrationAccountAgreementListResultPage) NotDone() bool {
	return !page.iaalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IntegrationAccountAgreementListResultPage) Response() IntegrationAccountAgreementListResult {
	return page.iaalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IntegrationAccountAgreementListResultPage) Values() []IntegrationAccountAgreement {
	if page.iaalr.IsEmpty() {
		return nil
	}
	return *page.iaalr.Value
}

// Creates a new instance of the IntegrationAccountAgreementListResultPage type.
func NewIntegrationAccountAgreementListResultPage(cur IntegrationAccountAgreementListResult, getNextPage func(context.Context, IntegrationAccountAgreementListResult) (IntegrationAccountAgreementListResult, error)) IntegrationAccountAgreementListResultPage {
	return IntegrationAccountAgreementListResultPage{
		fn:    getNextPage,
		iaalr: cur,
	}
}

// IntegrationAccountAgreementProperties the integration account agreement properties.
type IntegrationAccountAgreementProperties struct {
	// CreatedTime - READ-ONLY; The created time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - READ-ONLY; The changed time.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// Metadata - The metadata.
	Metadata interface{} `json:"metadata,omitempty"`
	// AgreementType - The agreement type. Possible values include: 'AgreementTypeNotSpecified', 'AgreementTypeAS2', 'AgreementTypeX12', 'AgreementTypeEdifact'
	AgreementType AgreementType `json:"agreementType,omitempty"`
	// HostPartner - The integration account partner that is set as host partner for this agreement.
	HostPartner *string `json:"hostPartner,omitempty"`
	// GuestPartner - The integration account partner that is set as guest partner for this agreement.
	GuestPartner *string `json:"guestPartner,omitempty"`
	// HostIdentity - The business identity of the host partner.
	HostIdentity *BusinessIdentity `json:"hostIdentity,omitempty"`
	// GuestIdentity - The business identity of the guest partner.
	GuestIdentity *BusinessIdentity `json:"guestIdentity,omitempty"`
	// Content - The agreement content.
	Content *AgreementContent `json:"content,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountAgreementProperties.
func (iaap IntegrationAccountAgreementProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iaap.Metadata != nil {
		objectMap["metadata"] = iaap.Metadata
	}
	if iaap.AgreementType != "" {
		objectMap["agreementType"] = iaap.AgreementType
	}
	if iaap.HostPartner != nil {
		objectMap["hostPartner"] = iaap.HostPartner
	}
	if iaap.GuestPartner != nil {
		objectMap["guestPartner"] = iaap.GuestPartner
	}
	if iaap.HostIdentity != nil {
		objectMap["hostIdentity"] = iaap.HostIdentity
	}
	if iaap.GuestIdentity != nil {
		objectMap["guestIdentity"] = iaap.GuestIdentity
	}
	if iaap.Content != nil {
		objectMap["content"] = iaap.Content
	}
	return json.Marshal(objectMap)
}

// IntegrationAccountCertificate the integration account certificate.
type IntegrationAccountCertificate struct {
	autorest.Response `json:"-"`
	// IntegrationAccountCertificateProperties - The integration account certificate properties.
	*IntegrationAccountCertificateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountCertificate.
func (iac IntegrationAccountCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iac.IntegrationAccountCertificateProperties != nil {
		objectMap["properties"] = iac.IntegrationAccountCertificateProperties
	}
	if iac.Location != nil {
		objectMap["location"] = iac.Location
	}
	if iac.Tags != nil {
		objectMap["tags"] = iac.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationAccountCertificate struct.
func (iac *IntegrationAccountCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var integrationAccountCertificateProperties IntegrationAccountCertificateProperties
				err = json.Unmarshal(*v, &integrationAccountCertificateProperties)
				if err != nil {
					return err
				}
				iac.IntegrationAccountCertificateProperties = &integrationAccountCertificateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iac.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iac.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				iac.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				iac.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				iac.Tags = tags
			}
		}
	}

	return nil
}

// IntegrationAccountCertificateListResult the list of integration account certificates.
type IntegrationAccountCertificateListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of integration account certificates.
	Value *[]IntegrationAccountCertificate `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationAccountCertificateListResultIterator provides access to a complete listing of
// IntegrationAccountCertificate values.
type IntegrationAccountCertificateListResultIterator struct {
	i    int
	page IntegrationAccountCertificateListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IntegrationAccountCertificateListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountCertificateListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IntegrationAccountCertificateListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IntegrationAccountCertificateListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IntegrationAccountCertificateListResultIterator) Response() IntegrationAccountCertificateListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IntegrationAccountCertificateListResultIterator) Value() IntegrationAccountCertificate {
	if !iter.page.NotDone() {
		return IntegrationAccountCertificate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IntegrationAccountCertificateListResultIterator type.
func NewIntegrationAccountCertificateListResultIterator(page IntegrationAccountCertificateListResultPage) IntegrationAccountCertificateListResultIterator {
	return IntegrationAccountCertificateListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iaclr IntegrationAccountCertificateListResult) IsEmpty() bool {
	return iaclr.Value == nil || len(*iaclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (iaclr IntegrationAccountCertificateListResult) hasNextLink() bool {
	return iaclr.NextLink != nil && len(*iaclr.NextLink) != 0
}

// integrationAccountCertificateListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iaclr IntegrationAccountCertificateListResult) integrationAccountCertificateListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !iaclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iaclr.NextLink)))
}

// IntegrationAccountCertificateListResultPage contains a page of IntegrationAccountCertificate values.
type IntegrationAccountCertificateListResultPage struct {
	fn    func(context.Context, IntegrationAccountCertificateListResult) (IntegrationAccountCertificateListResult, error)
	iaclr IntegrationAccountCertificateListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IntegrationAccountCertificateListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountCertificateListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.iaclr)
		if err != nil {
			return err
		}
		page.iaclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IntegrationAccountCertificateListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IntegrationAccountCertificateListResultPage) NotDone() bool {
	return !page.iaclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IntegrationAccountCertificateListResultPage) Response() IntegrationAccountCertificateListResult {
	return page.iaclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IntegrationAccountCertificateListResultPage) Values() []IntegrationAccountCertificate {
	if page.iaclr.IsEmpty() {
		return nil
	}
	return *page.iaclr.Value
}

// Creates a new instance of the IntegrationAccountCertificateListResultPage type.
func NewIntegrationAccountCertificateListResultPage(cur IntegrationAccountCertificateListResult, getNextPage func(context.Context, IntegrationAccountCertificateListResult) (IntegrationAccountCertificateListResult, error)) IntegrationAccountCertificateListResultPage {
	return IntegrationAccountCertificateListResultPage{
		fn:    getNextPage,
		iaclr: cur,
	}
}

// IntegrationAccountCertificateProperties the integration account certificate properties.
type IntegrationAccountCertificateProperties struct {
	// CreatedTime - READ-ONLY; The created time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - READ-ONLY; The changed time.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// Metadata - The metadata.
	Metadata interface{} `json:"metadata,omitempty"`
	// Key - The key details in the key vault.
	Key *KeyVaultKeyReference `json:"key,omitempty"`
	// PublicCertificate - The public certificate.
	PublicCertificate *string `json:"publicCertificate,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountCertificateProperties.
func (iacp IntegrationAccountCertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iacp.Metadata != nil {
		objectMap["metadata"] = iacp.Metadata
	}
	if iacp.Key != nil {
		objectMap["key"] = iacp.Key
	}
	if iacp.PublicCertificate != nil {
		objectMap["publicCertificate"] = iacp.PublicCertificate
	}
	return json.Marshal(objectMap)
}

// IntegrationAccountListResult the list of integration accounts.
type IntegrationAccountListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of integration accounts.
	Value *[]IntegrationAccount `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationAccountListResultIterator provides access to a complete listing of IntegrationAccount values.
type IntegrationAccountListResultIterator struct {
	i    int
	page IntegrationAccountListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IntegrationAccountListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IntegrationAccountListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IntegrationAccountListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IntegrationAccountListResultIterator) Response() IntegrationAccountListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IntegrationAccountListResultIterator) Value() IntegrationAccount {
	if !iter.page.NotDone() {
		return IntegrationAccount{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IntegrationAccountListResultIterator type.
func NewIntegrationAccountListResultIterator(page IntegrationAccountListResultPage) IntegrationAccountListResultIterator {
	return IntegrationAccountListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ialr IntegrationAccountListResult) IsEmpty() bool {
	return ialr.Value == nil || len(*ialr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ialr IntegrationAccountListResult) hasNextLink() bool {
	return ialr.NextLink != nil && len(*ialr.NextLink) != 0
}

// integrationAccountListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ialr IntegrationAccountListResult) integrationAccountListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ialr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ialr.NextLink)))
}

// IntegrationAccountListResultPage contains a page of IntegrationAccount values.
type IntegrationAccountListResultPage struct {
	fn   func(context.Context, IntegrationAccountListResult) (IntegrationAccountListResult, error)
	ialr IntegrationAccountListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IntegrationAccountListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ialr)
		if err != nil {
			return err
		}
		page.ialr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IntegrationAccountListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IntegrationAccountListResultPage) NotDone() bool {
	return !page.ialr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IntegrationAccountListResultPage) Response() IntegrationAccountListResult {
	return page.ialr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IntegrationAccountListResultPage) Values() []IntegrationAccount {
	if page.ialr.IsEmpty() {
		return nil
	}
	return *page.ialr.Value
}

// Creates a new instance of the IntegrationAccountListResultPage type.
func NewIntegrationAccountListResultPage(cur IntegrationAccountListResult, getNextPage func(context.Context, IntegrationAccountListResult) (IntegrationAccountListResult, error)) IntegrationAccountListResultPage {
	return IntegrationAccountListResultPage{
		fn:   getNextPage,
		ialr: cur,
	}
}

// IntegrationAccountMap the integration account map.
type IntegrationAccountMap struct {
	autorest.Response `json:"-"`
	// IntegrationAccountMapProperties - The integration account map properties.
	*IntegrationAccountMapProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountMap.
func (iam IntegrationAccountMap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iam.IntegrationAccountMapProperties != nil {
		objectMap["properties"] = iam.IntegrationAccountMapProperties
	}
	if iam.Location != nil {
		objectMap["location"] = iam.Location
	}
	if iam.Tags != nil {
		objectMap["tags"] = iam.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationAccountMap struct.
func (iam *IntegrationAccountMap) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var integrationAccountMapProperties IntegrationAccountMapProperties
				err = json.Unmarshal(*v, &integrationAccountMapProperties)
				if err != nil {
					return err
				}
				iam.IntegrationAccountMapProperties = &integrationAccountMapProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iam.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iam.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				iam.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				iam.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				iam.Tags = tags
			}
		}
	}

	return nil
}

// IntegrationAccountMapFilter the integration account map filter for odata query.
type IntegrationAccountMapFilter struct {
	// MapType - The map type of integration account map. Possible values include: 'MapTypeNotSpecified', 'MapTypeXslt'
	MapType MapType `json:"mapType,omitempty"`
}

// IntegrationAccountMapListResult the list of integration account maps.
type IntegrationAccountMapListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of integration account maps.
	Value *[]IntegrationAccountMap `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationAccountMapListResultIterator provides access to a complete listing of IntegrationAccountMap
// values.
type IntegrationAccountMapListResultIterator struct {
	i    int
	page IntegrationAccountMapListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IntegrationAccountMapListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountMapListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IntegrationAccountMapListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IntegrationAccountMapListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IntegrationAccountMapListResultIterator) Response() IntegrationAccountMapListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IntegrationAccountMapListResultIterator) Value() IntegrationAccountMap {
	if !iter.page.NotDone() {
		return IntegrationAccountMap{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IntegrationAccountMapListResultIterator type.
func NewIntegrationAccountMapListResultIterator(page IntegrationAccountMapListResultPage) IntegrationAccountMapListResultIterator {
	return IntegrationAccountMapListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iamlr IntegrationAccountMapListResult) IsEmpty() bool {
	return iamlr.Value == nil || len(*iamlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (iamlr IntegrationAccountMapListResult) hasNextLink() bool {
	return iamlr.NextLink != nil && len(*iamlr.NextLink) != 0
}

// integrationAccountMapListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iamlr IntegrationAccountMapListResult) integrationAccountMapListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !iamlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iamlr.NextLink)))
}

// IntegrationAccountMapListResultPage contains a page of IntegrationAccountMap values.
type IntegrationAccountMapListResultPage struct {
	fn    func(context.Context, IntegrationAccountMapListResult) (IntegrationAccountMapListResult, error)
	iamlr IntegrationAccountMapListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IntegrationAccountMapListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountMapListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.iamlr)
		if err != nil {
			return err
		}
		page.iamlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IntegrationAccountMapListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IntegrationAccountMapListResultPage) NotDone() bool {
	return !page.iamlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IntegrationAccountMapListResultPage) Response() IntegrationAccountMapListResult {
	return page.iamlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IntegrationAccountMapListResultPage) Values() []IntegrationAccountMap {
	if page.iamlr.IsEmpty() {
		return nil
	}
	return *page.iamlr.Value
}

// Creates a new instance of the IntegrationAccountMapListResultPage type.
func NewIntegrationAccountMapListResultPage(cur IntegrationAccountMapListResult, getNextPage func(context.Context, IntegrationAccountMapListResult) (IntegrationAccountMapListResult, error)) IntegrationAccountMapListResultPage {
	return IntegrationAccountMapListResultPage{
		fn:    getNextPage,
		iamlr: cur,
	}
}

// IntegrationAccountMapProperties the integration account map.
type IntegrationAccountMapProperties struct {
	// MapType - The map type. Possible values include: 'MapTypeNotSpecified', 'MapTypeXslt'
	MapType MapType `json:"mapType,omitempty"`
	// ParametersSchema - The parameters schema of integration account map.
	ParametersSchema *IntegrationAccountMapPropertiesParametersSchema `json:"parametersSchema,omitempty"`
	// CreatedTime - READ-ONLY; The created time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - READ-ONLY; The changed time.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// Content - The content.
	Content *string `json:"content,omitempty"`
	// ContentType - The content type.
	ContentType *string `json:"contentType,omitempty"`
	// ContentLink - READ-ONLY; The content link.
	ContentLink *ContentLink `json:"contentLink,omitempty"`
	// Metadata - The metadata.
	Metadata interface{} `json:"metadata,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountMapProperties.
func (iamp IntegrationAccountMapProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iamp.MapType != "" {
		objectMap["mapType"] = iamp.MapType
	}
	if iamp.ParametersSchema != nil {
		objectMap["parametersSchema"] = iamp.ParametersSchema
	}
	if iamp.Content != nil {
		objectMap["content"] = iamp.Content
	}
	if iamp.ContentType != nil {
		objectMap["contentType"] = iamp.ContentType
	}
	if iamp.Metadata != nil {
		objectMap["metadata"] = iamp.Metadata
	}
	return json.Marshal(objectMap)
}

// IntegrationAccountMapPropertiesParametersSchema the parameters schema of integration account map.
type IntegrationAccountMapPropertiesParametersSchema struct {
	// Ref - The reference name.
	Ref *string `json:"ref,omitempty"`
}

// IntegrationAccountPartner the integration account partner.
type IntegrationAccountPartner struct {
	autorest.Response `json:"-"`
	// IntegrationAccountPartnerProperties - The integration account partner properties.
	*IntegrationAccountPartnerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountPartner.
func (iap IntegrationAccountPartner) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iap.IntegrationAccountPartnerProperties != nil {
		objectMap["properties"] = iap.IntegrationAccountPartnerProperties
	}
	if iap.Location != nil {
		objectMap["location"] = iap.Location
	}
	if iap.Tags != nil {
		objectMap["tags"] = iap.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationAccountPartner struct.
func (iap *IntegrationAccountPartner) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var integrationAccountPartnerProperties IntegrationAccountPartnerProperties
				err = json.Unmarshal(*v, &integrationAccountPartnerProperties)
				if err != nil {
					return err
				}
				iap.IntegrationAccountPartnerProperties = &integrationAccountPartnerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				iap.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				iap.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				iap.Tags = tags
			}
		}
	}

	return nil
}

// IntegrationAccountPartnerFilter the integration account partner filter for odata query.
type IntegrationAccountPartnerFilter struct {
	// PartnerType - The partner type of integration account partner. Possible values include: 'PartnerTypeNotSpecified', 'PartnerTypeB2B'
	PartnerType PartnerType `json:"partnerType,omitempty"`
}

// IntegrationAccountPartnerListResult the list of integration account partners.
type IntegrationAccountPartnerListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of integration account partners.
	Value *[]IntegrationAccountPartner `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationAccountPartnerListResultIterator provides access to a complete listing of
// IntegrationAccountPartner values.
type IntegrationAccountPartnerListResultIterator struct {
	i    int
	page IntegrationAccountPartnerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IntegrationAccountPartnerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountPartnerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IntegrationAccountPartnerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IntegrationAccountPartnerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IntegrationAccountPartnerListResultIterator) Response() IntegrationAccountPartnerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IntegrationAccountPartnerListResultIterator) Value() IntegrationAccountPartner {
	if !iter.page.NotDone() {
		return IntegrationAccountPartner{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IntegrationAccountPartnerListResultIterator type.
func NewIntegrationAccountPartnerListResultIterator(page IntegrationAccountPartnerListResultPage) IntegrationAccountPartnerListResultIterator {
	return IntegrationAccountPartnerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iaplr IntegrationAccountPartnerListResult) IsEmpty() bool {
	return iaplr.Value == nil || len(*iaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (iaplr IntegrationAccountPartnerListResult) hasNextLink() bool {
	return iaplr.NextLink != nil && len(*iaplr.NextLink) != 0
}

// integrationAccountPartnerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iaplr IntegrationAccountPartnerListResult) integrationAccountPartnerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !iaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iaplr.NextLink)))
}

// IntegrationAccountPartnerListResultPage contains a page of IntegrationAccountPartner values.
type IntegrationAccountPartnerListResultPage struct {
	fn    func(context.Context, IntegrationAccountPartnerListResult) (IntegrationAccountPartnerListResult, error)
	iaplr IntegrationAccountPartnerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IntegrationAccountPartnerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountPartnerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.iaplr)
		if err != nil {
			return err
		}
		page.iaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IntegrationAccountPartnerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IntegrationAccountPartnerListResultPage) NotDone() bool {
	return !page.iaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IntegrationAccountPartnerListResultPage) Response() IntegrationAccountPartnerListResult {
	return page.iaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IntegrationAccountPartnerListResultPage) Values() []IntegrationAccountPartner {
	if page.iaplr.IsEmpty() {
		return nil
	}
	return *page.iaplr.Value
}

// Creates a new instance of the IntegrationAccountPartnerListResultPage type.
func NewIntegrationAccountPartnerListResultPage(cur IntegrationAccountPartnerListResult, getNextPage func(context.Context, IntegrationAccountPartnerListResult) (IntegrationAccountPartnerListResult, error)) IntegrationAccountPartnerListResultPage {
	return IntegrationAccountPartnerListResultPage{
		fn:    getNextPage,
		iaplr: cur,
	}
}

// IntegrationAccountPartnerProperties the integration account partner properties.
type IntegrationAccountPartnerProperties struct {
	// PartnerType - The partner type. Possible values include: 'PartnerTypeNotSpecified', 'PartnerTypeB2B'
	PartnerType PartnerType `json:"partnerType,omitempty"`
	// CreatedTime - READ-ONLY; The created time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - READ-ONLY; The changed time.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// Metadata - The metadata.
	Metadata interface{} `json:"metadata,omitempty"`
	// Content - The partner content.
	Content *PartnerContent `json:"content,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountPartnerProperties.
func (iapp IntegrationAccountPartnerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iapp.PartnerType != "" {
		objectMap["partnerType"] = iapp.PartnerType
	}
	if iapp.Metadata != nil {
		objectMap["metadata"] = iapp.Metadata
	}
	if iapp.Content != nil {
		objectMap["content"] = iapp.Content
	}
	return json.Marshal(objectMap)
}

// IntegrationAccountRosettaNetProcessConfiguration the integration account RosettaNet process
// configuration.
type IntegrationAccountRosettaNetProcessConfiguration struct {
	autorest.Response `json:"-"`
	// IntegrationAccountRosettaNetProcessConfigurationProperties - The integration account RosettaNet process configuration properties.
	*IntegrationAccountRosettaNetProcessConfigurationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountRosettaNetProcessConfiguration.
func (iarnpc IntegrationAccountRosettaNetProcessConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iarnpc.IntegrationAccountRosettaNetProcessConfigurationProperties != nil {
		objectMap["properties"] = iarnpc.IntegrationAccountRosettaNetProcessConfigurationProperties
	}
	if iarnpc.Location != nil {
		objectMap["location"] = iarnpc.Location
	}
	if iarnpc.Tags != nil {
		objectMap["tags"] = iarnpc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationAccountRosettaNetProcessConfiguration struct.
func (iarnpc *IntegrationAccountRosettaNetProcessConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var integrationAccountRosettaNetProcessConfigurationProperties IntegrationAccountRosettaNetProcessConfigurationProperties
				err = json.Unmarshal(*v, &integrationAccountRosettaNetProcessConfigurationProperties)
				if err != nil {
					return err
				}
				iarnpc.IntegrationAccountRosettaNetProcessConfigurationProperties = &integrationAccountRosettaNetProcessConfigurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iarnpc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iarnpc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				iarnpc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				iarnpc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				iarnpc.Tags = tags
			}
		}
	}

	return nil
}

// IntegrationAccountRosettaNetProcessConfigurationListResult the list of integration account RosettaNet
// process configuration.
type IntegrationAccountRosettaNetProcessConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of integration account RosettaNet PIP configuration.
	Value *[]IntegrationAccountRosettaNetProcessConfiguration `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationAccountRosettaNetProcessConfigurationListResultIterator provides access to a complete listing
// of IntegrationAccountRosettaNetProcessConfiguration values.
type IntegrationAccountRosettaNetProcessConfigurationListResultIterator struct {
	i    int
	page IntegrationAccountRosettaNetProcessConfigurationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IntegrationAccountRosettaNetProcessConfigurationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountRosettaNetProcessConfigurationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IntegrationAccountRosettaNetProcessConfigurationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IntegrationAccountRosettaNetProcessConfigurationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IntegrationAccountRosettaNetProcessConfigurationListResultIterator) Response() IntegrationAccountRosettaNetProcessConfigurationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IntegrationAccountRosettaNetProcessConfigurationListResultIterator) Value() IntegrationAccountRosettaNetProcessConfiguration {
	if !iter.page.NotDone() {
		return IntegrationAccountRosettaNetProcessConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IntegrationAccountRosettaNetProcessConfigurationListResultIterator type.
func NewIntegrationAccountRosettaNetProcessConfigurationListResultIterator(page IntegrationAccountRosettaNetProcessConfigurationListResultPage) IntegrationAccountRosettaNetProcessConfigurationListResultIterator {
	return IntegrationAccountRosettaNetProcessConfigurationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iarnpclr IntegrationAccountRosettaNetProcessConfigurationListResult) IsEmpty() bool {
	return iarnpclr.Value == nil || len(*iarnpclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (iarnpclr IntegrationAccountRosettaNetProcessConfigurationListResult) hasNextLink() bool {
	return iarnpclr.NextLink != nil && len(*iarnpclr.NextLink) != 0
}

// integrationAccountRosettaNetProcessConfigurationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iarnpclr IntegrationAccountRosettaNetProcessConfigurationListResult) integrationAccountRosettaNetProcessConfigurationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !iarnpclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iarnpclr.NextLink)))
}

// IntegrationAccountRosettaNetProcessConfigurationListResultPage contains a page of
// IntegrationAccountRosettaNetProcessConfiguration values.
type IntegrationAccountRosettaNetProcessConfigurationListResultPage struct {
	fn       func(context.Context, IntegrationAccountRosettaNetProcessConfigurationListResult) (IntegrationAccountRosettaNetProcessConfigurationListResult, error)
	iarnpclr IntegrationAccountRosettaNetProcessConfigurationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IntegrationAccountRosettaNetProcessConfigurationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountRosettaNetProcessConfigurationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.iarnpclr)
		if err != nil {
			return err
		}
		page.iarnpclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IntegrationAccountRosettaNetProcessConfigurationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IntegrationAccountRosettaNetProcessConfigurationListResultPage) NotDone() bool {
	return !page.iarnpclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IntegrationAccountRosettaNetProcessConfigurationListResultPage) Response() IntegrationAccountRosettaNetProcessConfigurationListResult {
	return page.iarnpclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IntegrationAccountRosettaNetProcessConfigurationListResultPage) Values() []IntegrationAccountRosettaNetProcessConfiguration {
	if page.iarnpclr.IsEmpty() {
		return nil
	}
	return *page.iarnpclr.Value
}

// Creates a new instance of the IntegrationAccountRosettaNetProcessConfigurationListResultPage type.
func NewIntegrationAccountRosettaNetProcessConfigurationListResultPage(cur IntegrationAccountRosettaNetProcessConfigurationListResult, getNextPage func(context.Context, IntegrationAccountRosettaNetProcessConfigurationListResult) (IntegrationAccountRosettaNetProcessConfigurationListResult, error)) IntegrationAccountRosettaNetProcessConfigurationListResultPage {
	return IntegrationAccountRosettaNetProcessConfigurationListResultPage{
		fn:       getNextPage,
		iarnpclr: cur,
	}
}

// IntegrationAccountRosettaNetProcessConfigurationProperties the integration account RosettaNet process
// configuration properties.
type IntegrationAccountRosettaNetProcessConfigurationProperties struct {
	// CreatedTime - READ-ONLY; The created time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - READ-ONLY; The changed time.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// Metadata - The metadata.
	Metadata map[string]*string `json:"metadata"`
	// ActivitySettings - The RosettaNet process configuration activity settings.
	ActivitySettings *RosettaNetPipActivitySettings `json:"activitySettings,omitempty"`
	// ProcessCode - The integration account RosettaNet process code.
	ProcessCode *string `json:"processCode,omitempty"`
	// ProcessVersion - The integration account RosettaNet process version.
	ProcessVersion *string `json:"processVersion,omitempty"`
	// ProcessName - The integration account RosettaNet process name.
	ProcessName *string `json:"processName,omitempty"`
	// InitiatorRoleSettings - The RosettaNet initiator role settings.
	InitiatorRoleSettings *RosettaNetPipRoleSettings `json:"initiatorRoleSettings,omitempty"`
	// ResponderRoleSettings - The RosettaNet responder role settings.
	ResponderRoleSettings *RosettaNetPipRoleSettings `json:"responderRoleSettings,omitempty"`
	// Description - The integration account RosettaNet ProcessConfiguration properties.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountRosettaNetProcessConfigurationProperties.
func (iarnpcp IntegrationAccountRosettaNetProcessConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iarnpcp.Metadata != nil {
		objectMap["metadata"] = iarnpcp.Metadata
	}
	if iarnpcp.ActivitySettings != nil {
		objectMap["activitySettings"] = iarnpcp.ActivitySettings
	}
	if iarnpcp.ProcessCode != nil {
		objectMap["processCode"] = iarnpcp.ProcessCode
	}
	if iarnpcp.ProcessVersion != nil {
		objectMap["processVersion"] = iarnpcp.ProcessVersion
	}
	if iarnpcp.ProcessName != nil {
		objectMap["processName"] = iarnpcp.ProcessName
	}
	if iarnpcp.InitiatorRoleSettings != nil {
		objectMap["initiatorRoleSettings"] = iarnpcp.InitiatorRoleSettings
	}
	if iarnpcp.ResponderRoleSettings != nil {
		objectMap["responderRoleSettings"] = iarnpcp.ResponderRoleSettings
	}
	if iarnpcp.Description != nil {
		objectMap["description"] = iarnpcp.Description
	}
	return json.Marshal(objectMap)
}

// IntegrationAccountSchema the integration account schema.
type IntegrationAccountSchema struct {
	autorest.Response `json:"-"`
	// IntegrationAccountSchemaProperties - The integration account schema properties.
	*IntegrationAccountSchemaProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountSchema.
func (ias IntegrationAccountSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ias.IntegrationAccountSchemaProperties != nil {
		objectMap["properties"] = ias.IntegrationAccountSchemaProperties
	}
	if ias.Location != nil {
		objectMap["location"] = ias.Location
	}
	if ias.Tags != nil {
		objectMap["tags"] = ias.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationAccountSchema struct.
func (ias *IntegrationAccountSchema) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var integrationAccountSchemaProperties IntegrationAccountSchemaProperties
				err = json.Unmarshal(*v, &integrationAccountSchemaProperties)
				if err != nil {
					return err
				}
				ias.IntegrationAccountSchemaProperties = &integrationAccountSchemaProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ias.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ias.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ias.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ias.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ias.Tags = tags
			}
		}
	}

	return nil
}

// IntegrationAccountSchemaFilter the integration account schema filter for odata query.
type IntegrationAccountSchemaFilter struct {
	// SchemaType - The schema type of integration account schema. Possible values include: 'SchemaTypeNotSpecified', 'SchemaTypeXML'
	SchemaType SchemaType `json:"schemaType,omitempty"`
}

// IntegrationAccountSchemaListResult the list of integration account schemas.
type IntegrationAccountSchemaListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of integration account schemas.
	Value *[]IntegrationAccountSchema `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationAccountSchemaListResultIterator provides access to a complete listing of
// IntegrationAccountSchema values.
type IntegrationAccountSchemaListResultIterator struct {
	i    int
	page IntegrationAccountSchemaListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IntegrationAccountSchemaListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountSchemaListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IntegrationAccountSchemaListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IntegrationAccountSchemaListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IntegrationAccountSchemaListResultIterator) Response() IntegrationAccountSchemaListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IntegrationAccountSchemaListResultIterator) Value() IntegrationAccountSchema {
	if !iter.page.NotDone() {
		return IntegrationAccountSchema{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IntegrationAccountSchemaListResultIterator type.
func NewIntegrationAccountSchemaListResultIterator(page IntegrationAccountSchemaListResultPage) IntegrationAccountSchemaListResultIterator {
	return IntegrationAccountSchemaListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iaslr IntegrationAccountSchemaListResult) IsEmpty() bool {
	return iaslr.Value == nil || len(*iaslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (iaslr IntegrationAccountSchemaListResult) hasNextLink() bool {
	return iaslr.NextLink != nil && len(*iaslr.NextLink) != 0
}

// integrationAccountSchemaListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iaslr IntegrationAccountSchemaListResult) integrationAccountSchemaListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !iaslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iaslr.NextLink)))
}

// IntegrationAccountSchemaListResultPage contains a page of IntegrationAccountSchema values.
type IntegrationAccountSchemaListResultPage struct {
	fn    func(context.Context, IntegrationAccountSchemaListResult) (IntegrationAccountSchemaListResult, error)
	iaslr IntegrationAccountSchemaListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IntegrationAccountSchemaListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountSchemaListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.iaslr)
		if err != nil {
			return err
		}
		page.iaslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IntegrationAccountSchemaListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IntegrationAccountSchemaListResultPage) NotDone() bool {
	return !page.iaslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IntegrationAccountSchemaListResultPage) Response() IntegrationAccountSchemaListResult {
	return page.iaslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IntegrationAccountSchemaListResultPage) Values() []IntegrationAccountSchema {
	if page.iaslr.IsEmpty() {
		return nil
	}
	return *page.iaslr.Value
}

// Creates a new instance of the IntegrationAccountSchemaListResultPage type.
func NewIntegrationAccountSchemaListResultPage(cur IntegrationAccountSchemaListResult, getNextPage func(context.Context, IntegrationAccountSchemaListResult) (IntegrationAccountSchemaListResult, error)) IntegrationAccountSchemaListResultPage {
	return IntegrationAccountSchemaListResultPage{
		fn:    getNextPage,
		iaslr: cur,
	}
}

// IntegrationAccountSchemaProperties the integration account schema properties.
type IntegrationAccountSchemaProperties struct {
	// SchemaType - The schema type. Possible values include: 'SchemaTypeNotSpecified', 'SchemaTypeXML'
	SchemaType SchemaType `json:"schemaType,omitempty"`
	// TargetNamespace - The target namespace of the schema.
	TargetNamespace *string `json:"targetNamespace,omitempty"`
	// DocumentName - The document name.
	DocumentName *string `json:"documentName,omitempty"`
	// FileName - The file name.
	FileName *string `json:"fileName,omitempty"`
	// CreatedTime - READ-ONLY; The created time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - READ-ONLY; The changed time.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// Metadata - The metadata.
	Metadata interface{} `json:"metadata,omitempty"`
	// Content - The content.
	Content *string `json:"content,omitempty"`
	// ContentType - The content type.
	ContentType *string `json:"contentType,omitempty"`
	// ContentLink - READ-ONLY; The content link.
	ContentLink *ContentLink `json:"contentLink,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountSchemaProperties.
func (iasp IntegrationAccountSchemaProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iasp.SchemaType != "" {
		objectMap["schemaType"] = iasp.SchemaType
	}
	if iasp.TargetNamespace != nil {
		objectMap["targetNamespace"] = iasp.TargetNamespace
	}
	if iasp.DocumentName != nil {
		objectMap["documentName"] = iasp.DocumentName
	}
	if iasp.FileName != nil {
		objectMap["fileName"] = iasp.FileName
	}
	if iasp.Metadata != nil {
		objectMap["metadata"] = iasp.Metadata
	}
	if iasp.Content != nil {
		objectMap["content"] = iasp.Content
	}
	if iasp.ContentType != nil {
		objectMap["contentType"] = iasp.ContentType
	}
	return json.Marshal(objectMap)
}

// IntegrationAccountSession the integration account session.
type IntegrationAccountSession struct {
	autorest.Response `json:"-"`
	// IntegrationAccountSessionProperties - The integration account session properties.
	*IntegrationAccountSessionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountSession.
func (ias IntegrationAccountSession) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ias.IntegrationAccountSessionProperties != nil {
		objectMap["properties"] = ias.IntegrationAccountSessionProperties
	}
	if ias.Location != nil {
		objectMap["location"] = ias.Location
	}
	if ias.Tags != nil {
		objectMap["tags"] = ias.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IntegrationAccountSession struct.
func (ias *IntegrationAccountSession) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var integrationAccountSessionProperties IntegrationAccountSessionProperties
				err = json.Unmarshal(*v, &integrationAccountSessionProperties)
				if err != nil {
					return err
				}
				ias.IntegrationAccountSessionProperties = &integrationAccountSessionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ias.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ias.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ias.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ias.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ias.Tags = tags
			}
		}
	}

	return nil
}

// IntegrationAccountSessionFilter the integration account session filter.
type IntegrationAccountSessionFilter struct {
	// ChangedTime - The changed time of integration account sessions.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
}

// IntegrationAccountSessionListResult the list of integration account sessions.
type IntegrationAccountSessionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of integration account sessions.
	Value *[]IntegrationAccountSession `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationAccountSessionListResultIterator provides access to a complete listing of
// IntegrationAccountSession values.
type IntegrationAccountSessionListResultIterator struct {
	i    int
	page IntegrationAccountSessionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IntegrationAccountSessionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountSessionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IntegrationAccountSessionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IntegrationAccountSessionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IntegrationAccountSessionListResultIterator) Response() IntegrationAccountSessionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IntegrationAccountSessionListResultIterator) Value() IntegrationAccountSession {
	if !iter.page.NotDone() {
		return IntegrationAccountSession{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IntegrationAccountSessionListResultIterator type.
func NewIntegrationAccountSessionListResultIterator(page IntegrationAccountSessionListResultPage) IntegrationAccountSessionListResultIterator {
	return IntegrationAccountSessionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iaslr IntegrationAccountSessionListResult) IsEmpty() bool {
	return iaslr.Value == nil || len(*iaslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (iaslr IntegrationAccountSessionListResult) hasNextLink() bool {
	return iaslr.NextLink != nil && len(*iaslr.NextLink) != 0
}

// integrationAccountSessionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iaslr IntegrationAccountSessionListResult) integrationAccountSessionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !iaslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iaslr.NextLink)))
}

// IntegrationAccountSessionListResultPage contains a page of IntegrationAccountSession values.
type IntegrationAccountSessionListResultPage struct {
	fn    func(context.Context, IntegrationAccountSessionListResult) (IntegrationAccountSessionListResult, error)
	iaslr IntegrationAccountSessionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IntegrationAccountSessionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountSessionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.iaslr)
		if err != nil {
			return err
		}
		page.iaslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IntegrationAccountSessionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IntegrationAccountSessionListResultPage) NotDone() bool {
	return !page.iaslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IntegrationAccountSessionListResultPage) Response() IntegrationAccountSessionListResult {
	return page.iaslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IntegrationAccountSessionListResultPage) Values() []IntegrationAccountSession {
	if page.iaslr.IsEmpty() {
		return nil
	}
	return *page.iaslr.Value
}

// Creates a new instance of the IntegrationAccountSessionListResultPage type.
func NewIntegrationAccountSessionListResultPage(cur IntegrationAccountSessionListResult, getNextPage func(context.Context, IntegrationAccountSessionListResult) (IntegrationAccountSessionListResult, error)) IntegrationAccountSessionListResultPage {
	return IntegrationAccountSessionListResultPage{
		fn:    getNextPage,
		iaslr: cur,
	}
}

// IntegrationAccountSessionProperties the integration account session properties.
type IntegrationAccountSessionProperties struct {
	// CreatedTime - READ-ONLY; The created time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - READ-ONLY; The changed time.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// Content - The session content.
	Content interface{} `json:"content,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegrationAccountSessionProperties.
func (iasp IntegrationAccountSessionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iasp.Content != nil {
		objectMap["content"] = iasp.Content
	}
	return json.Marshal(objectMap)
}

// IntegrationAccountSku the integration account sku.
type IntegrationAccountSku struct {
	// Name - The sku name. Possible values include: 'IntegrationAccountSkuNameNotSpecified', 'IntegrationAccountSkuNameFree', 'IntegrationAccountSkuNameStandard'
	Name IntegrationAccountSkuName `json:"name,omitempty"`
}

// JSONSchema the JSON schema.
type JSONSchema struct {
	autorest.Response `json:"-"`
	// Title - The JSON title.
	Title *string `json:"title,omitempty"`
	// Content - The JSON content.
	Content *string `json:"content,omitempty"`
}

// KeyVaultKey the key vault key.
type KeyVaultKey struct {
	// Kid - The key id.
	Kid *string `json:"kid,omitempty"`
	// Attributes - The key attributes.
	Attributes *KeyVaultKeyAttributes `json:"attributes,omitempty"`
}

// KeyVaultKeyAttributes the key attributes.
type KeyVaultKeyAttributes struct {
	// Enabled - Whether the key is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// Created - When the key was created.
	Created *int64 `json:"created,omitempty"`
	// Updated - When the key was updated.
	Updated *int64 `json:"updated,omitempty"`
}

// KeyVaultKeyCollection collection of key vault keys.
type KeyVaultKeyCollection struct {
	autorest.Response `json:"-"`
	// Value - The key vault keys.
	Value *[]KeyVaultKey `json:"value,omitempty"`
	// SkipToken - The skip token.
	SkipToken *string `json:"skipToken,omitempty"`
}

// KeyVaultKeyReference the reference to the key vault key.
type KeyVaultKeyReference struct {
	// KeyVault - The key vault reference.
	KeyVault *KeyVaultKeyReferenceKeyVault `json:"keyVault,omitempty"`
	// KeyName - The private key name in key vault.
	KeyName *string `json:"keyName,omitempty"`
	// KeyVersion - The private key version in key vault.
	KeyVersion *string `json:"keyVersion,omitempty"`
}

// KeyVaultKeyReferenceKeyVault the key vault reference.
type KeyVaultKeyReferenceKeyVault struct {
	// ID - The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyVaultKeyReferenceKeyVault.
func (kvkrV KeyVaultKeyReferenceKeyVault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kvkrV.ID != nil {
		objectMap["id"] = kvkrV.ID
	}
	return json.Marshal(objectMap)
}

// KeyVaultReference the key vault reference.
type KeyVaultReference struct {
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
}

// ListKeyVaultKeysDefinition the list key vault keys definition.
type ListKeyVaultKeysDefinition struct {
	// KeyVault - The key vault reference.
	KeyVault *KeyVaultReference `json:"keyVault,omitempty"`
	// SkipToken - The skip token.
	SkipToken *string `json:"skipToken,omitempty"`
}

// Operation logic REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Logic
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list Logic operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Logic operations supported by the Logic resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationResult the operation result definition.
type OperationResult struct {
	// TrackingID - READ-ONLY; Gets the tracking id.
	TrackingID *string `json:"trackingId,omitempty"`
	// Inputs - READ-ONLY; Gets the inputs.
	Inputs interface{} `json:"inputs,omitempty"`
	// InputsLink - READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink `json:"inputsLink,omitempty"`
	// Outputs - READ-ONLY; Gets the outputs.
	Outputs interface{} `json:"outputs,omitempty"`
	// OutputsLink - READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink `json:"outputsLink,omitempty"`
	// TrackedProperties - READ-ONLY; Gets the tracked properties.
	TrackedProperties interface{} `json:"trackedProperties,omitempty"`
	// RetryHistory - Gets the retry histories.
	RetryHistory   *[]RetryHistory `json:"retryHistory,omitempty"`
	IterationCount *int32          `json:"iterationCount,omitempty"`
	// StartTime - The start time of the workflow scope repetition.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time of the workflow scope repetition.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Correlation - The correlation properties.
	Correlation *RunActionCorrelation `json:"correlation,omitempty"`
	// Status - The status of the workflow scope repetition. Possible values include: 'WorkflowStatusNotSpecified', 'WorkflowStatusPaused', 'WorkflowStatusRunning', 'WorkflowStatusWaiting', 'WorkflowStatusSucceeded', 'WorkflowStatusSkipped', 'WorkflowStatusSuspended', 'WorkflowStatusCancelled', 'WorkflowStatusFailed', 'WorkflowStatusFaulted', 'WorkflowStatusTimedOut', 'WorkflowStatusAborted', 'WorkflowStatusIgnored'
	Status WorkflowStatus `json:"status,omitempty"`
	// Code - The workflow scope repetition code.
	Code  *string     `json:"code,omitempty"`
	Error interface{} `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationResult.
func (or OperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if or.RetryHistory != nil {
		objectMap["retryHistory"] = or.RetryHistory
	}
	if or.IterationCount != nil {
		objectMap["iterationCount"] = or.IterationCount
	}
	if or.StartTime != nil {
		objectMap["startTime"] = or.StartTime
	}
	if or.EndTime != nil {
		objectMap["endTime"] = or.EndTime
	}
	if or.Correlation != nil {
		objectMap["correlation"] = or.Correlation
	}
	if or.Status != "" {
		objectMap["status"] = or.Status
	}
	if or.Code != nil {
		objectMap["code"] = or.Code
	}
	if or.Error != nil {
		objectMap["error"] = or.Error
	}
	return json.Marshal(objectMap)
}

// OperationResultProperties the run operation result properties.
type OperationResultProperties struct {
	// StartTime - The start time of the workflow scope repetition.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time of the workflow scope repetition.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Correlation - The correlation properties.
	Correlation *RunActionCorrelation `json:"correlation,omitempty"`
	// Status - The status of the workflow scope repetition. Possible values include: 'WorkflowStatusNotSpecified', 'WorkflowStatusPaused', 'WorkflowStatusRunning', 'WorkflowStatusWaiting', 'WorkflowStatusSucceeded', 'WorkflowStatusSkipped', 'WorkflowStatusSuspended', 'WorkflowStatusCancelled', 'WorkflowStatusFailed', 'WorkflowStatusFaulted', 'WorkflowStatusTimedOut', 'WorkflowStatusAborted', 'WorkflowStatusIgnored'
	Status WorkflowStatus `json:"status,omitempty"`
	// Code - The workflow scope repetition code.
	Code  *string     `json:"code,omitempty"`
	Error interface{} `json:"error,omitempty"`
}

// PartnerContent the integration account partner content.
type PartnerContent struct {
	// B2b - The B2B partner content.
	B2b *B2BPartnerContent `json:"b2b,omitempty"`
}

// RecurrenceSchedule the recurrence schedule.
type RecurrenceSchedule struct {
	// Minutes - The minutes.
	Minutes *[]int32 `json:"minutes,omitempty"`
	// Hours - The hours.
	Hours *[]int32 `json:"hours,omitempty"`
	// WeekDays - The days of the week.
	WeekDays *[]DaysOfWeek `json:"weekDays,omitempty"`
	// MonthDays - The month days.
	MonthDays *[]int32 `json:"monthDays,omitempty"`
	// MonthlyOccurrences - The monthly occurrences.
	MonthlyOccurrences *[]RecurrenceScheduleOccurrence `json:"monthlyOccurrences,omitempty"`
}

// RecurrenceScheduleOccurrence the recurrence schedule occurrence.
type RecurrenceScheduleOccurrence struct {
	// Day - The day of the week. Possible values include: 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'
	Day DayOfWeek `json:"day,omitempty"`
	// Occurrence - The occurrence.
	Occurrence *int32 `json:"occurrence,omitempty"`
}

// RegenerateActionParameter the access key regenerate action content.
type RegenerateActionParameter struct {
	// KeyType - The key type. Possible values include: 'KeyTypeNotSpecified', 'KeyTypePrimary', 'KeyTypeSecondary'
	KeyType KeyType `json:"keyType,omitempty"`
}

// RepetitionIndex the workflow run action repetition index.
type RepetitionIndex struct {
	// ScopeName - The scope.
	ScopeName *string `json:"scopeName,omitempty"`
	// ItemIndex - The index.
	ItemIndex *int32 `json:"itemIndex,omitempty"`
}

// Request a request.
type Request struct {
	// Headers - A list of all the headers attached to the request.
	Headers interface{} `json:"headers,omitempty"`
	// URI - The destination for the request.
	URI *string `json:"uri,omitempty"`
	// Method - The HTTP method used for the request.
	Method *string `json:"method,omitempty"`
}

// RequestHistory the request history.
type RequestHistory struct {
	autorest.Response `json:"-"`
	// Properties - The request history properties.
	Properties *RequestHistoryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RequestHistory.
func (rh RequestHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rh.Properties != nil {
		objectMap["properties"] = rh.Properties
	}
	if rh.Location != nil {
		objectMap["location"] = rh.Location
	}
	if rh.Tags != nil {
		objectMap["tags"] = rh.Tags
	}
	return json.Marshal(objectMap)
}

// RequestHistoryListResult the list of workflow request histories.
type RequestHistoryListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of workflow request histories.
	Value *[]RequestHistory `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RequestHistoryListResultIterator provides access to a complete listing of RequestHistory values.
type RequestHistoryListResultIterator struct {
	i    int
	page RequestHistoryListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RequestHistoryListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RequestHistoryListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RequestHistoryListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RequestHistoryListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RequestHistoryListResultIterator) Response() RequestHistoryListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RequestHistoryListResultIterator) Value() RequestHistory {
	if !iter.page.NotDone() {
		return RequestHistory{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RequestHistoryListResultIterator type.
func NewRequestHistoryListResultIterator(page RequestHistoryListResultPage) RequestHistoryListResultIterator {
	return RequestHistoryListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rhlr RequestHistoryListResult) IsEmpty() bool {
	return rhlr.Value == nil || len(*rhlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rhlr RequestHistoryListResult) hasNextLink() bool {
	return rhlr.NextLink != nil && len(*rhlr.NextLink) != 0
}

// requestHistoryListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rhlr RequestHistoryListResult) requestHistoryListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rhlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rhlr.NextLink)))
}

// RequestHistoryListResultPage contains a page of RequestHistory values.
type RequestHistoryListResultPage struct {
	fn   func(context.Context, RequestHistoryListResult) (RequestHistoryListResult, error)
	rhlr RequestHistoryListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RequestHistoryListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RequestHistoryListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rhlr)
		if err != nil {
			return err
		}
		page.rhlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RequestHistoryListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RequestHistoryListResultPage) NotDone() bool {
	return !page.rhlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RequestHistoryListResultPage) Response() RequestHistoryListResult {
	return page.rhlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RequestHistoryListResultPage) Values() []RequestHistory {
	if page.rhlr.IsEmpty() {
		return nil
	}
	return *page.rhlr.Value
}

// Creates a new instance of the RequestHistoryListResultPage type.
func NewRequestHistoryListResultPage(cur RequestHistoryListResult, getNextPage func(context.Context, RequestHistoryListResult) (RequestHistoryListResult, error)) RequestHistoryListResultPage {
	return RequestHistoryListResultPage{
		fn:   getNextPage,
		rhlr: cur,
	}
}

// RequestHistoryProperties the request history.
type RequestHistoryProperties struct {
	// StartTime - The time the request started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The time the request ended.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Request - The request.
	Request *Request `json:"request,omitempty"`
	// Response - The response.
	Response *Response `json:"response,omitempty"`
}

// Resource the base resource type.
type Resource struct {
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceReference the resource reference.
type ResourceReference struct {
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
}

// Response a response.
type Response struct {
	// Headers - A list of all the headers attached to the response.
	Headers interface{} `json:"headers,omitempty"`
	// StatusCode - The status code of the response.
	StatusCode *int32 `json:"statusCode,omitempty"`
	// BodyLink - Details on the location of the body content.
	BodyLink *ContentLink `json:"bodyLink,omitempty"`
}

// RetryHistory the retry history.
type RetryHistory struct {
	// StartTime - Gets the start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Gets the end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Code - Gets the status code.
	Code *string `json:"code,omitempty"`
	// ClientRequestID - Gets the client request Id.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// ServiceRequestID - Gets the service request Id.
	ServiceRequestID *string `json:"serviceRequestId,omitempty"`
	// Error - Gets the error response.
	Error *ErrorResponse `json:"error,omitempty"`
}

// RosettaNetPipAcknowledgmentOfReceiptSettings the integration account RosettaNet ProcessConfiguration
// Acknowledgement settings.
type RosettaNetPipAcknowledgmentOfReceiptSettings struct {
	// IsNonRepudiationRequired - The non-repudiation is required or not.
	IsNonRepudiationRequired *bool `json:"isNonRepudiationRequired,omitempty"`
	// TimeToAcknowledgeInSeconds - The time to acknowledge in seconds.
	TimeToAcknowledgeInSeconds *int32 `json:"timeToAcknowledgeInSeconds,omitempty"`
}

// RosettaNetPipActivityBehavior the integration account RosettaNet ProcessConfiguration activity behavior.
type RosettaNetPipActivityBehavior struct {
	// IsAuthorizationRequired - The value indicating whether authorization is required.
	IsAuthorizationRequired *bool `json:"isAuthorizationRequired,omitempty"`
	// PersistentConfidentialityScope - The persistent confidentiality encryption scope. Possible values include: 'RosettaNetPipConfidentialityScopeNotSpecified', 'RosettaNetPipConfidentialityScopeNone', 'RosettaNetPipConfidentialityScopePayload', 'RosettaNetPipConfidentialityScopePayloadContainer'
	PersistentConfidentialityScope RosettaNetPipConfidentialityScope `json:"persistentConfidentialityScope,omitempty"`
	// IsSecuredTransportRequired - The value indicating whether secured transport is required.
	IsSecuredTransportRequired *bool `json:"isSecuredTransportRequired,omitempty"`
	// ActionType - The value indicating whether the RosettaNet PIP is used for a single action. Possible values include: 'RosettaNetActionTypeNotSpecified', 'RosettaNetActionTypeSingleAction', 'RosettaNetActionTypeDoubleAction'
	ActionType RosettaNetActionType `json:"actionType,omitempty"`
	// ResponseType - The value indicating whether the RosettaNet PIP communication is synchronous. Possible values include: 'RosettaNetResponseTypeNotSpecified', 'RosettaNetResponseTypeSync', 'RosettaNetResponseTypeAsync'
	ResponseType RosettaNetResponseType `json:"responseType,omitempty"`
	// NonRepudiationOfOriginAndContent - The value indicating whether non-repudiation is for origin and content.
	NonRepudiationOfOriginAndContent *bool `json:"nonRepudiationOfOriginAndContent,omitempty"`
	// RetryCount - The value indicating retry count.
	RetryCount *int32 `json:"retryCount,omitempty"`
	// TimeToPerformInSeconds - The time to perform in seconds.
	TimeToPerformInSeconds *int32 `json:"timeToPerformInSeconds,omitempty"`
}

// RosettaNetPipActivitySettings the integration account RosettaNet ProcessConfiguration activity settings.
type RosettaNetPipActivitySettings struct {
	// ActivityType - The RosettaNet ProcessConfiguration activity type. Possible values include: 'RosettaNetPipActivityTypeNotSpecified', 'RosettaNetPipActivityTypeInformationDistribution', 'RosettaNetPipActivityTypeBusinessTransaction', 'RosettaNetPipActivityTypeNotification', 'RosettaNetPipActivityTypeQueryResponse', 'RosettaNetPipActivityTypeRequestConfirm', 'RosettaNetPipActivityTypeRequestResponse'
	ActivityType RosettaNetPipActivityType `json:"activityType,omitempty"`
	// ActivityBehavior - The RosettaNet ProcessConfiguration activity behavior.
	ActivityBehavior *RosettaNetPipActivityBehavior `json:"activityBehavior,omitempty"`
	// AcknowledgmentOfReceiptSettings - The RosettaNet ProcessConfiguration acknowledgement settings.
	AcknowledgmentOfReceiptSettings *RosettaNetPipAcknowledgmentOfReceiptSettings `json:"acknowledgmentOfReceiptSettings,omitempty"`
}

// RosettaNetPipBusinessDocument the RosettaNet ProcessConfiguration business document settings.
type RosettaNetPipBusinessDocument struct {
	// Name - The business document name.
	Name *string `json:"name,omitempty"`
	// Version - The business document version.
	Version *string `json:"version,omitempty"`
	// Description - The business document description.
	Description *string `json:"description,omitempty"`
}

// RosettaNetPipRoleSettings the integration account RosettaNet ProcessConfiguration role settings.
type RosettaNetPipRoleSettings struct {
	// Action - The action name.
	Action *string `json:"action,omitempty"`
	// Role - The role name.
	Role *string `json:"role,omitempty"`
	// RoleType - The RosettaNet ProcessConfiguration role type. Possible values include: 'RosettaNetPipRoleTypeNotSpecified', 'RosettaNetPipRoleTypeFunctional', 'RosettaNetPipRoleTypeOrganizational', 'RosettaNetPipRoleTypeEmployee'
	RoleType RosettaNetPipRoleType `json:"roleType,omitempty"`
	// Service - The service name.
	Service *string `json:"service,omitempty"`
	// ServiceClassification - The service classification name.
	ServiceClassification *string `json:"serviceClassification,omitempty"`
	// BusinessDocument - The RosettaNet ProcessConfiguration business document.
	BusinessDocument *RosettaNetPipBusinessDocument `json:"businessDocument,omitempty"`
	// Description - The description.
	Description *string `json:"description,omitempty"`
}

// RunActionCorrelation the workflow run action correlation properties.
type RunActionCorrelation struct {
	// ActionTrackingID - The action tracking identifier.
	ActionTrackingID *string `json:"actionTrackingId,omitempty"`
	// ClientTrackingID - The client tracking identifier.
	ClientTrackingID *string `json:"clientTrackingId,omitempty"`
	// ClientKeywords - The client keywords.
	ClientKeywords *[]string `json:"clientKeywords,omitempty"`
}

// RunCorrelation the correlation properties.
type RunCorrelation struct {
	// ClientTrackingID - The client tracking identifier.
	ClientTrackingID *string `json:"clientTrackingId,omitempty"`
	// ClientKeywords - The client keywords.
	ClientKeywords *[]string `json:"clientKeywords,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// SetTriggerStateActionDefinition ...
type SetTriggerStateActionDefinition struct {
	Source *WorkflowTrigger `json:"source,omitempty"`
}

// Sku the sku type.
type Sku struct {
	// Name - The name. Possible values include: 'SkuNameNotSpecified', 'SkuNameFree', 'SkuNameShared', 'SkuNameBasic', 'SkuNameStandard', 'SkuNamePremium'
	Name SkuName `json:"name,omitempty"`
	// Plan - The reference to plan.
	Plan *ResourceReference `json:"plan,omitempty"`
}

// SubResource the sub resource type.
type SubResource struct {
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
}

// TrackingEvent ...
type TrackingEvent struct {
	// EventLevel - Possible values include: 'LogAlways', 'Critical', 'Error', 'Warning', 'Informational', 'Verbose'
	EventLevel EventLevel `json:"eventLevel,omitempty"`
	EventTime  *date.Time `json:"eventTime,omitempty"`
	// RecordType - Possible values include: 'TrackingRecordTypeNotSpecified', 'TrackingRecordTypeCustom', 'TrackingRecordTypeAS2Message', 'TrackingRecordTypeAS2MDN', 'TrackingRecordTypeX12Interchange', 'TrackingRecordTypeX12FunctionalGroup', 'TrackingRecordTypeX12TransactionSet', 'TrackingRecordTypeX12InterchangeAcknowledgment', 'TrackingRecordTypeX12FunctionalGroupAcknowledgment', 'TrackingRecordTypeX12TransactionSetAcknowledgment', 'TrackingRecordTypeEdifactInterchange', 'TrackingRecordTypeEdifactFunctionalGroup', 'TrackingRecordTypeEdifactTransactionSet', 'TrackingRecordTypeEdifactInterchangeAcknowledgment', 'TrackingRecordTypeEdifactFunctionalGroupAcknowledgment', 'TrackingRecordTypeEdifactTransactionSetAcknowledgment'
	RecordType TrackingRecordType      `json:"recordType,omitempty"`
	Error      *TrackingEventErrorInfo `json:"error,omitempty"`
}

// TrackingEventErrorInfo ...
type TrackingEventErrorInfo struct {
	Message *string `json:"message,omitempty"`
	Code    *string `json:"code,omitempty"`
}

// TrackingEventsDefinition ...
type TrackingEventsDefinition struct {
	SourceType *string `json:"sourceType,omitempty"`
	// TrackEventsOptions - Possible values include: 'None', 'DisableSourceInfoEnrich'
	TrackEventsOptions TrackEventsOperationOptions `json:"trackEventsOptions,omitempty"`
	Events             *[]TrackingEvent            `json:"events,omitempty"`
}

// Workflow the workflow type.
type Workflow struct {
	autorest.Response `json:"-"`
	// WorkflowProperties - The workflow properties.
	*WorkflowProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Workflow.
func (w Workflow) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WorkflowProperties != nil {
		objectMap["properties"] = w.WorkflowProperties
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workflow struct.
func (w *Workflow) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workflowProperties WorkflowProperties
				err = json.Unmarshal(*v, &workflowProperties)
				if err != nil {
					return err
				}
				w.WorkflowProperties = &workflowProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		}
	}

	return nil
}

// WorkflowFilter the workflow filter.
type WorkflowFilter struct {
	// State - The state of workflows. Possible values include: 'WorkflowStateNotSpecified', 'WorkflowStateCompleted', 'WorkflowStateEnabled', 'WorkflowStateDisabled', 'WorkflowStateDeleted', 'WorkflowStateSuspended'
	State WorkflowState `json:"state,omitempty"`
}

// WorkflowListResult the list of workflows.
type WorkflowListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of workflows.
	Value *[]Workflow `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkflowListResultIterator provides access to a complete listing of Workflow values.
type WorkflowListResultIterator struct {
	i    int
	page WorkflowListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkflowListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkflowListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkflowListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkflowListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkflowListResultIterator) Response() WorkflowListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkflowListResultIterator) Value() Workflow {
	if !iter.page.NotDone() {
		return Workflow{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkflowListResultIterator type.
func NewWorkflowListResultIterator(page WorkflowListResultPage) WorkflowListResultIterator {
	return WorkflowListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wlr WorkflowListResult) IsEmpty() bool {
	return wlr.Value == nil || len(*wlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wlr WorkflowListResult) hasNextLink() bool {
	return wlr.NextLink != nil && len(*wlr.NextLink) != 0
}

// workflowListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wlr WorkflowListResult) workflowListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wlr.NextLink)))
}

// WorkflowListResultPage contains a page of Workflow values.
type WorkflowListResultPage struct {
	fn  func(context.Context, WorkflowListResult) (WorkflowListResult, error)
	wlr WorkflowListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkflowListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkflowListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wlr)
		if err != nil {
			return err
		}
		page.wlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkflowListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkflowListResultPage) NotDone() bool {
	return !page.wlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkflowListResultPage) Response() WorkflowListResult {
	return page.wlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkflowListResultPage) Values() []Workflow {
	if page.wlr.IsEmpty() {
		return nil
	}
	return *page.wlr.Value
}

// Creates a new instance of the WorkflowListResultPage type.
func NewWorkflowListResultPage(cur WorkflowListResult, getNextPage func(context.Context, WorkflowListResult) (WorkflowListResult, error)) WorkflowListResultPage {
	return WorkflowListResultPage{
		fn:  getNextPage,
		wlr: cur,
	}
}

// WorkflowOutputParameter the workflow output parameter.
type WorkflowOutputParameter struct {
	// Error - READ-ONLY; Gets the error.
	Error interface{} `json:"error,omitempty"`
	// Type - The type. Possible values include: 'ParameterTypeNotSpecified', 'ParameterTypeString', 'ParameterTypeSecureString', 'ParameterTypeInt', 'ParameterTypeFloat', 'ParameterTypeBool', 'ParameterTypeArray', 'ParameterTypeObject', 'ParameterTypeSecureObject'
	Type ParameterType `json:"type,omitempty"`
	// Value - The value.
	Value interface{} `json:"value,omitempty"`
	// Metadata - The metadata.
	Metadata interface{} `json:"metadata,omitempty"`
	// Description - The description.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkflowOutputParameter.
func (wop WorkflowOutputParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wop.Type != "" {
		objectMap["type"] = wop.Type
	}
	if wop.Value != nil {
		objectMap["value"] = wop.Value
	}
	if wop.Metadata != nil {
		objectMap["metadata"] = wop.Metadata
	}
	if wop.Description != nil {
		objectMap["description"] = wop.Description
	}
	return json.Marshal(objectMap)
}

// WorkflowParameter the workflow parameters.
type WorkflowParameter struct {
	// Type - The type. Possible values include: 'ParameterTypeNotSpecified', 'ParameterTypeString', 'ParameterTypeSecureString', 'ParameterTypeInt', 'ParameterTypeFloat', 'ParameterTypeBool', 'ParameterTypeArray', 'ParameterTypeObject', 'ParameterTypeSecureObject'
	Type ParameterType `json:"type,omitempty"`
	// Value - The value.
	Value interface{} `json:"value,omitempty"`
	// Metadata - The metadata.
	Metadata interface{} `json:"metadata,omitempty"`
	// Description - The description.
	Description *string `json:"description,omitempty"`
}

// WorkflowProperties the workflow properties.
type WorkflowProperties struct {
	// ProvisioningState - READ-ONLY; Gets the provisioning state. Possible values include: 'WorkflowProvisioningStateNotSpecified', 'WorkflowProvisioningStateAccepted', 'WorkflowProvisioningStateRunning', 'WorkflowProvisioningStateReady', 'WorkflowProvisioningStateCreating', 'WorkflowProvisioningStateCreated', 'WorkflowProvisioningStateDeleting', 'WorkflowProvisioningStateDeleted', 'WorkflowProvisioningStateCanceled', 'WorkflowProvisioningStateFailed', 'WorkflowProvisioningStateSucceeded', 'WorkflowProvisioningStateMoving', 'WorkflowProvisioningStateUpdating', 'WorkflowProvisioningStateRegistering', 'WorkflowProvisioningStateRegistered', 'WorkflowProvisioningStateUnregistering', 'WorkflowProvisioningStateUnregistered', 'WorkflowProvisioningStateCompleted'
	ProvisioningState WorkflowProvisioningState `json:"provisioningState,omitempty"`
	// CreatedTime - READ-ONLY; Gets the created time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - READ-ONLY; Gets the changed time.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// State - The state. Possible values include: 'WorkflowStateNotSpecified', 'WorkflowStateCompleted', 'WorkflowStateEnabled', 'WorkflowStateDisabled', 'WorkflowStateDeleted', 'WorkflowStateSuspended'
	State WorkflowState `json:"state,omitempty"`
	// Version - READ-ONLY; Gets the version.
	Version *string `json:"version,omitempty"`
	// AccessEndpoint - READ-ONLY; Gets the access endpoint.
	AccessEndpoint *string `json:"accessEndpoint,omitempty"`
	// Sku - The sku.
	Sku *Sku `json:"sku,omitempty"`
	// IntegrationAccount - The integration account.
	IntegrationAccount *ResourceReference `json:"integrationAccount,omitempty"`
	// Definition - The definition. See [Schema reference for Workflow Definition Language in Azure Logic Apps](https://aka.ms/logic-apps-workflow-definition-language).
	Definition interface{} `json:"definition,omitempty"`
	// Parameters - The parameters.
	Parameters map[string]*WorkflowParameter `json:"parameters"`
}

// MarshalJSON is the custom marshaler for WorkflowProperties.
func (wp WorkflowProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.State != "" {
		objectMap["state"] = wp.State
	}
	if wp.Sku != nil {
		objectMap["sku"] = wp.Sku
	}
	if wp.IntegrationAccount != nil {
		objectMap["integrationAccount"] = wp.IntegrationAccount
	}
	if wp.Definition != nil {
		objectMap["definition"] = wp.Definition
	}
	if wp.Parameters != nil {
		objectMap["parameters"] = wp.Parameters
	}
	return json.Marshal(objectMap)
}

// WorkflowRun the workflow run.
type WorkflowRun struct {
	autorest.Response `json:"-"`
	// WorkflowRunProperties - The workflow run properties.
	*WorkflowRunProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; Gets the workflow run name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the workflow run type.
	Type *string `json:"type,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkflowRun.
func (wr WorkflowRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wr.WorkflowRunProperties != nil {
		objectMap["properties"] = wr.WorkflowRunProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkflowRun struct.
func (wr *WorkflowRun) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workflowRunProperties WorkflowRunProperties
				err = json.Unmarshal(*v, &workflowRunProperties)
				if err != nil {
					return err
				}
				wr.WorkflowRunProperties = &workflowRunProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wr.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wr.ID = &ID
			}
		}
	}

	return nil
}

// WorkflowRunAction the workflow run action.
type WorkflowRunAction struct {
	autorest.Response `json:"-"`
	// WorkflowRunActionProperties - The workflow run action properties.
	*WorkflowRunActionProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; Gets the workflow run action name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the workflow run action type.
	Type *string `json:"type,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkflowRunAction.
func (wra WorkflowRunAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wra.WorkflowRunActionProperties != nil {
		objectMap["properties"] = wra.WorkflowRunActionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkflowRunAction struct.
func (wra *WorkflowRunAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workflowRunActionProperties WorkflowRunActionProperties
				err = json.Unmarshal(*v, &workflowRunActionProperties)
				if err != nil {
					return err
				}
				wra.WorkflowRunActionProperties = &workflowRunActionProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wra.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wra.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wra.ID = &ID
			}
		}
	}

	return nil
}

// WorkflowRunActionFilter the workflow run action filter.
type WorkflowRunActionFilter struct {
	// Status - The status of workflow run action. Possible values include: 'WorkflowStatusNotSpecified', 'WorkflowStatusPaused', 'WorkflowStatusRunning', 'WorkflowStatusWaiting', 'WorkflowStatusSucceeded', 'WorkflowStatusSkipped', 'WorkflowStatusSuspended', 'WorkflowStatusCancelled', 'WorkflowStatusFailed', 'WorkflowStatusFaulted', 'WorkflowStatusTimedOut', 'WorkflowStatusAborted', 'WorkflowStatusIgnored'
	Status WorkflowStatus `json:"status,omitempty"`
}

// WorkflowRunActionListResult the list of workflow run actions.
type WorkflowRunActionListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of workflow run actions.
	Value *[]WorkflowRunAction `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkflowRunActionListResultIterator provides access to a complete listing of WorkflowRunAction values.
type WorkflowRunActionListResultIterator struct {
	i    int
	page WorkflowRunActionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkflowRunActionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkflowRunActionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkflowRunActionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkflowRunActionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkflowRunActionListResultIterator) Response() WorkflowRunActionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkflowRunActionListResultIterator) Value() WorkflowRunAction {
	if !iter.page.NotDone() {
		return WorkflowRunAction{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkflowRunActionListResultIterator type.
func NewWorkflowRunActionListResultIterator(page WorkflowRunActionListResultPage) WorkflowRunActionListResultIterator {
	return WorkflowRunActionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wralr WorkflowRunActionListResult) IsEmpty() bool {
	return wralr.Value == nil || len(*wralr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wralr WorkflowRunActionListResult) hasNextLink() bool {
	return wralr.NextLink != nil && len(*wralr.NextLink) != 0
}

// workflowRunActionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wralr WorkflowRunActionListResult) workflowRunActionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wralr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wralr.NextLink)))
}

// WorkflowRunActionListResultPage contains a page of WorkflowRunAction values.
type WorkflowRunActionListResultPage struct {
	fn    func(context.Context, WorkflowRunActionListResult) (WorkflowRunActionListResult, error)
	wralr WorkflowRunActionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkflowRunActionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkflowRunActionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wralr)
		if err != nil {
			return err
		}
		page.wralr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkflowRunActionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkflowRunActionListResultPage) NotDone() bool {
	return !page.wralr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkflowRunActionListResultPage) Response() WorkflowRunActionListResult {
	return page.wralr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkflowRunActionListResultPage) Values() []WorkflowRunAction {
	if page.wralr.IsEmpty() {
		return nil
	}
	return *page.wralr.Value
}

// Creates a new instance of the WorkflowRunActionListResultPage type.
func NewWorkflowRunActionListResultPage(cur WorkflowRunActionListResult, getNextPage func(context.Context, WorkflowRunActionListResult) (WorkflowRunActionListResult, error)) WorkflowRunActionListResultPage {
	return WorkflowRunActionListResultPage{
		fn:    getNextPage,
		wralr: cur,
	}
}

// WorkflowRunActionProperties the workflow run action properties.
type WorkflowRunActionProperties struct {
	// StartTime - READ-ONLY; Gets the start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; Gets the end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Status - READ-ONLY; Gets the status. Possible values include: 'WorkflowStatusNotSpecified', 'WorkflowStatusPaused', 'WorkflowStatusRunning', 'WorkflowStatusWaiting', 'WorkflowStatusSucceeded', 'WorkflowStatusSkipped', 'WorkflowStatusSuspended', 'WorkflowStatusCancelled', 'WorkflowStatusFailed', 'WorkflowStatusFaulted', 'WorkflowStatusTimedOut', 'WorkflowStatusAborted', 'WorkflowStatusIgnored'
	Status WorkflowStatus `json:"status,omitempty"`
	// Code - READ-ONLY; Gets the code.
	Code *string `json:"code,omitempty"`
	// Error - READ-ONLY; Gets the error.
	Error interface{} `json:"error,omitempty"`
	// TrackingID - READ-ONLY; Gets the tracking id.
	TrackingID *string `json:"trackingId,omitempty"`
	// Correlation - The correlation properties.
	Correlation *Correlation `json:"correlation,omitempty"`
	// InputsLink - READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink `json:"inputsLink,omitempty"`
	// OutputsLink - READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink `json:"outputsLink,omitempty"`
	// TrackedProperties - READ-ONLY; Gets the tracked properties.
	TrackedProperties interface{} `json:"trackedProperties,omitempty"`
	// RetryHistory - Gets the retry histories.
	RetryHistory *[]RetryHistory `json:"retryHistory,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkflowRunActionProperties.
func (wrap WorkflowRunActionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wrap.Correlation != nil {
		objectMap["correlation"] = wrap.Correlation
	}
	if wrap.RetryHistory != nil {
		objectMap["retryHistory"] = wrap.RetryHistory
	}
	return json.Marshal(objectMap)
}

// WorkflowRunActionRepetitionDefinition the workflow run action repetition definition.
type WorkflowRunActionRepetitionDefinition struct {
	autorest.Response `json:"-"`
	// WorkflowRunActionRepetitionProperties - The workflow run action repetition properties definition.
	*WorkflowRunActionRepetitionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for WorkflowRunActionRepetitionDefinition.
func (wrard WorkflowRunActionRepetitionDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wrard.WorkflowRunActionRepetitionProperties != nil {
		objectMap["properties"] = wrard.WorkflowRunActionRepetitionProperties
	}
	if wrard.Location != nil {
		objectMap["location"] = wrard.Location
	}
	if wrard.Tags != nil {
		objectMap["tags"] = wrard.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkflowRunActionRepetitionDefinition struct.
func (wrard *WorkflowRunActionRepetitionDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workflowRunActionRepetitionProperties WorkflowRunActionRepetitionProperties
				err = json.Unmarshal(*v, &workflowRunActionRepetitionProperties)
				if err != nil {
					return err
				}
				wrard.WorkflowRunActionRepetitionProperties = &workflowRunActionRepetitionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wrard.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wrard.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wrard.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wrard.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wrard.Tags = tags
			}
		}
	}

	return nil
}

// WorkflowRunActionRepetitionDefinitionCollection a collection of workflow run action repetitions.
type WorkflowRunActionRepetitionDefinitionCollection struct {
	autorest.Response `json:"-"`
	Value             *[]WorkflowRunActionRepetitionDefinition `json:"value,omitempty"`
}

// WorkflowRunActionRepetitionProperties the workflow run action repetition properties definition.
type WorkflowRunActionRepetitionProperties struct {
	// RepetitionIndexes - The repetition indexes.
	RepetitionIndexes *[]RepetitionIndex `json:"repetitionIndexes,omitempty"`
	// TrackingID - READ-ONLY; Gets the tracking id.
	TrackingID *string `json:"trackingId,omitempty"`
	// Inputs - READ-ONLY; Gets the inputs.
	Inputs interface{} `json:"inputs,omitempty"`
	// InputsLink - READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink `json:"inputsLink,omitempty"`
	// Outputs - READ-ONLY; Gets the outputs.
	Outputs interface{} `json:"outputs,omitempty"`
	// OutputsLink - READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink `json:"outputsLink,omitempty"`
	// TrackedProperties - READ-ONLY; Gets the tracked properties.
	TrackedProperties interface{} `json:"trackedProperties,omitempty"`
	// RetryHistory - Gets the retry histories.
	RetryHistory   *[]RetryHistory `json:"retryHistory,omitempty"`
	IterationCount *int32          `json:"iterationCount,omitempty"`
	// StartTime - The start time of the workflow scope repetition.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time of the workflow scope repetition.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Correlation - The correlation properties.
	Correlation *RunActionCorrelation `json:"correlation,omitempty"`
	// Status - The status of the workflow scope repetition. Possible values include: 'WorkflowStatusNotSpecified', 'WorkflowStatusPaused', 'WorkflowStatusRunning', 'WorkflowStatusWaiting', 'WorkflowStatusSucceeded', 'WorkflowStatusSkipped', 'WorkflowStatusSuspended', 'WorkflowStatusCancelled', 'WorkflowStatusFailed', 'WorkflowStatusFaulted', 'WorkflowStatusTimedOut', 'WorkflowStatusAborted', 'WorkflowStatusIgnored'
	Status WorkflowStatus `json:"status,omitempty"`
	// Code - The workflow scope repetition code.
	Code  *string     `json:"code,omitempty"`
	Error interface{} `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkflowRunActionRepetitionProperties.
func (wrarp WorkflowRunActionRepetitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wrarp.RepetitionIndexes != nil {
		objectMap["repetitionIndexes"] = wrarp.RepetitionIndexes
	}
	if wrarp.RetryHistory != nil {
		objectMap["retryHistory"] = wrarp.RetryHistory
	}
	if wrarp.IterationCount != nil {
		objectMap["iterationCount"] = wrarp.IterationCount
	}
	if wrarp.StartTime != nil {
		objectMap["startTime"] = wrarp.StartTime
	}
	if wrarp.EndTime != nil {
		objectMap["endTime"] = wrarp.EndTime
	}
	if wrarp.Correlation != nil {
		objectMap["correlation"] = wrarp.Correlation
	}
	if wrarp.Status != "" {
		objectMap["status"] = wrarp.Status
	}
	if wrarp.Code != nil {
		objectMap["code"] = wrarp.Code
	}
	if wrarp.Error != nil {
		objectMap["error"] = wrarp.Error
	}
	return json.Marshal(objectMap)
}

// WorkflowRunFilter the workflow run filter.
type WorkflowRunFilter struct {
	// Status - The status of workflow run. Possible values include: 'WorkflowStatusNotSpecified', 'WorkflowStatusPaused', 'WorkflowStatusRunning', 'WorkflowStatusWaiting', 'WorkflowStatusSucceeded', 'WorkflowStatusSkipped', 'WorkflowStatusSuspended', 'WorkflowStatusCancelled', 'WorkflowStatusFailed', 'WorkflowStatusFaulted', 'WorkflowStatusTimedOut', 'WorkflowStatusAborted', 'WorkflowStatusIgnored'
	Status WorkflowStatus `json:"status,omitempty"`
}

// WorkflowRunListResult the list of workflow runs.
type WorkflowRunListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of workflow runs.
	Value *[]WorkflowRun `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkflowRunListResultIterator provides access to a complete listing of WorkflowRun values.
type WorkflowRunListResultIterator struct {
	i    int
	page WorkflowRunListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkflowRunListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkflowRunListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkflowRunListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkflowRunListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkflowRunListResultIterator) Response() WorkflowRunListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkflowRunListResultIterator) Value() WorkflowRun {
	if !iter.page.NotDone() {
		return WorkflowRun{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkflowRunListResultIterator type.
func NewWorkflowRunListResultIterator(page WorkflowRunListResultPage) WorkflowRunListResultIterator {
	return WorkflowRunListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wrlr WorkflowRunListResult) IsEmpty() bool {
	return wrlr.Value == nil || len(*wrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wrlr WorkflowRunListResult) hasNextLink() bool {
	return wrlr.NextLink != nil && len(*wrlr.NextLink) != 0
}

// workflowRunListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wrlr WorkflowRunListResult) workflowRunListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wrlr.NextLink)))
}

// WorkflowRunListResultPage contains a page of WorkflowRun values.
type WorkflowRunListResultPage struct {
	fn   func(context.Context, WorkflowRunListResult) (WorkflowRunListResult, error)
	wrlr WorkflowRunListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkflowRunListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkflowRunListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wrlr)
		if err != nil {
			return err
		}
		page.wrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkflowRunListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkflowRunListResultPage) NotDone() bool {
	return !page.wrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkflowRunListResultPage) Response() WorkflowRunListResult {
	return page.wrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkflowRunListResultPage) Values() []WorkflowRun {
	if page.wrlr.IsEmpty() {
		return nil
	}
	return *page.wrlr.Value
}

// Creates a new instance of the WorkflowRunListResultPage type.
func NewWorkflowRunListResultPage(cur WorkflowRunListResult, getNextPage func(context.Context, WorkflowRunListResult) (WorkflowRunListResult, error)) WorkflowRunListResultPage {
	return WorkflowRunListResultPage{
		fn:   getNextPage,
		wrlr: cur,
	}
}

// WorkflowRunProperties the workflow run properties.
type WorkflowRunProperties struct {
	// WaitEndTime - READ-ONLY; Gets the wait end time.
	WaitEndTime *date.Time `json:"waitEndTime,omitempty"`
	// StartTime - READ-ONLY; Gets the start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; Gets the end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Status - READ-ONLY; Gets the status. Possible values include: 'WorkflowStatusNotSpecified', 'WorkflowStatusPaused', 'WorkflowStatusRunning', 'WorkflowStatusWaiting', 'WorkflowStatusSucceeded', 'WorkflowStatusSkipped', 'WorkflowStatusSuspended', 'WorkflowStatusCancelled', 'WorkflowStatusFailed', 'WorkflowStatusFaulted', 'WorkflowStatusTimedOut', 'WorkflowStatusAborted', 'WorkflowStatusIgnored'
	Status WorkflowStatus `json:"status,omitempty"`
	// Code - READ-ONLY; Gets the code.
	Code *string `json:"code,omitempty"`
	// Error - READ-ONLY; Gets the error.
	Error interface{} `json:"error,omitempty"`
	// CorrelationID - READ-ONLY; Gets the correlation id.
	CorrelationID *string `json:"correlationId,omitempty"`
	// Correlation - The run correlation.
	Correlation *Correlation `json:"correlation,omitempty"`
	// Workflow - READ-ONLY; Gets the reference to workflow version.
	Workflow *ResourceReference `json:"workflow,omitempty"`
	// Trigger - READ-ONLY; Gets the fired trigger.
	Trigger *WorkflowRunTrigger `json:"trigger,omitempty"`
	// Outputs - READ-ONLY; Gets the outputs.
	Outputs map[string]*WorkflowOutputParameter `json:"outputs"`
	// Response - READ-ONLY; Gets the response of the flow run.
	Response *WorkflowRunTrigger `json:"response,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkflowRunProperties.
func (wrp WorkflowRunProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wrp.Correlation != nil {
		objectMap["correlation"] = wrp.Correlation
	}
	return json.Marshal(objectMap)
}

// WorkflowRunTrigger the workflow run trigger.
type WorkflowRunTrigger struct {
	// Name - READ-ONLY; Gets the name.
	Name *string `json:"name,omitempty"`
	// Inputs - READ-ONLY; Gets the inputs.
	Inputs interface{} `json:"inputs,omitempty"`
	// InputsLink - READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink `json:"inputsLink,omitempty"`
	// Outputs - READ-ONLY; Gets the outputs.
	Outputs interface{} `json:"outputs,omitempty"`
	// OutputsLink - READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink `json:"outputsLink,omitempty"`
	// ScheduledTime - READ-ONLY; Gets the scheduled time.
	ScheduledTime *date.Time `json:"scheduledTime,omitempty"`
	// StartTime - READ-ONLY; Gets the start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; Gets the end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// TrackingID - READ-ONLY; Gets the tracking id.
	TrackingID *string `json:"trackingId,omitempty"`
	// Correlation - The run correlation.
	Correlation *Correlation `json:"correlation,omitempty"`
	// Code - READ-ONLY; Gets the code.
	Code *string `json:"code,omitempty"`
	// Status - READ-ONLY; Gets the status. Possible values include: 'WorkflowStatusNotSpecified', 'WorkflowStatusPaused', 'WorkflowStatusRunning', 'WorkflowStatusWaiting', 'WorkflowStatusSucceeded', 'WorkflowStatusSkipped', 'WorkflowStatusSuspended', 'WorkflowStatusCancelled', 'WorkflowStatusFailed', 'WorkflowStatusFaulted', 'WorkflowStatusTimedOut', 'WorkflowStatusAborted', 'WorkflowStatusIgnored'
	Status WorkflowStatus `json:"status,omitempty"`
	// Error - READ-ONLY; Gets the error.
	Error interface{} `json:"error,omitempty"`
	// TrackedProperties - READ-ONLY; Gets the tracked properties.
	TrackedProperties interface{} `json:"trackedProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkflowRunTrigger.
func (wrt WorkflowRunTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wrt.Correlation != nil {
		objectMap["correlation"] = wrt.Correlation
	}
	return json.Marshal(objectMap)
}

// WorkflowTrigger the workflow trigger.
type WorkflowTrigger struct {
	autorest.Response `json:"-"`
	// WorkflowTriggerProperties - The workflow trigger properties.
	*WorkflowTriggerProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; Gets the workflow trigger name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the workflow trigger type.
	Type *string `json:"type,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkflowTrigger.
func (wt WorkflowTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wt.WorkflowTriggerProperties != nil {
		objectMap["properties"] = wt.WorkflowTriggerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkflowTrigger struct.
func (wt *WorkflowTrigger) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workflowTriggerProperties WorkflowTriggerProperties
				err = json.Unmarshal(*v, &workflowTriggerProperties)
				if err != nil {
					return err
				}
				wt.WorkflowTriggerProperties = &workflowTriggerProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wt.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wt.ID = &ID
			}
		}
	}

	return nil
}

// WorkflowTriggerCallbackURL the workflow trigger callback URL.
type WorkflowTriggerCallbackURL struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Gets the workflow trigger callback URL.
	Value *string `json:"value,omitempty"`
	// Method - READ-ONLY; Gets the workflow trigger callback URL HTTP method.
	Method *string `json:"method,omitempty"`
	// BasePath - READ-ONLY; Gets the workflow trigger callback URL base path.
	BasePath *string `json:"basePath,omitempty"`
	// RelativePath - READ-ONLY; Gets the workflow trigger callback URL relative path.
	RelativePath *string `json:"relativePath,omitempty"`
	// RelativePathParameters - Gets the workflow trigger callback URL relative path parameters.
	RelativePathParameters *[]string `json:"relativePathParameters,omitempty"`
	// Queries - Gets the workflow trigger callback URL query parameters.
	Queries *WorkflowTriggerListCallbackURLQueries `json:"queries,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkflowTriggerCallbackURL.
func (wtcu WorkflowTriggerCallbackURL) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wtcu.RelativePathParameters != nil {
		objectMap["relativePathParameters"] = wtcu.RelativePathParameters
	}
	if wtcu.Queries != nil {
		objectMap["queries"] = wtcu.Queries
	}
	return json.Marshal(objectMap)
}

// WorkflowTriggerFilter the workflow trigger filter.
type WorkflowTriggerFilter struct {
	// State - The state of workflow trigger. Possible values include: 'WorkflowStateNotSpecified', 'WorkflowStateCompleted', 'WorkflowStateEnabled', 'WorkflowStateDisabled', 'WorkflowStateDeleted', 'WorkflowStateSuspended'
	State WorkflowState `json:"state,omitempty"`
}

// WorkflowTriggerHistory the workflow trigger history.
type WorkflowTriggerHistory struct {
	autorest.Response `json:"-"`
	// WorkflowTriggerHistoryProperties - Gets the workflow trigger history properties.
	*WorkflowTriggerHistoryProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; Gets the workflow trigger history name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the workflow trigger history type.
	Type *string `json:"type,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkflowTriggerHistory.
func (wth WorkflowTriggerHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wth.WorkflowTriggerHistoryProperties != nil {
		objectMap["properties"] = wth.WorkflowTriggerHistoryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkflowTriggerHistory struct.
func (wth *WorkflowTriggerHistory) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workflowTriggerHistoryProperties WorkflowTriggerHistoryProperties
				err = json.Unmarshal(*v, &workflowTriggerHistoryProperties)
				if err != nil {
					return err
				}
				wth.WorkflowTriggerHistoryProperties = &workflowTriggerHistoryProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wth.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wth.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wth.ID = &ID
			}
		}
	}

	return nil
}

// WorkflowTriggerHistoryFilter the workflow trigger history filter.
type WorkflowTriggerHistoryFilter struct {
	// Status - The status of workflow trigger history. Possible values include: 'WorkflowStatusNotSpecified', 'WorkflowStatusPaused', 'WorkflowStatusRunning', 'WorkflowStatusWaiting', 'WorkflowStatusSucceeded', 'WorkflowStatusSkipped', 'WorkflowStatusSuspended', 'WorkflowStatusCancelled', 'WorkflowStatusFailed', 'WorkflowStatusFaulted', 'WorkflowStatusTimedOut', 'WorkflowStatusAborted', 'WorkflowStatusIgnored'
	Status WorkflowStatus `json:"status,omitempty"`
}

// WorkflowTriggerHistoryListResult the list of workflow trigger histories.
type WorkflowTriggerHistoryListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of workflow trigger histories.
	Value *[]WorkflowTriggerHistory `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkflowTriggerHistoryListResultIterator provides access to a complete listing of WorkflowTriggerHistory
// values.
type WorkflowTriggerHistoryListResultIterator struct {
	i    int
	page WorkflowTriggerHistoryListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkflowTriggerHistoryListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkflowTriggerHistoryListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkflowTriggerHistoryListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkflowTriggerHistoryListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkflowTriggerHistoryListResultIterator) Response() WorkflowTriggerHistoryListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkflowTriggerHistoryListResultIterator) Value() WorkflowTriggerHistory {
	if !iter.page.NotDone() {
		return WorkflowTriggerHistory{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkflowTriggerHistoryListResultIterator type.
func NewWorkflowTriggerHistoryListResultIterator(page WorkflowTriggerHistoryListResultPage) WorkflowTriggerHistoryListResultIterator {
	return WorkflowTriggerHistoryListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wthlr WorkflowTriggerHistoryListResult) IsEmpty() bool {
	return wthlr.Value == nil || len(*wthlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wthlr WorkflowTriggerHistoryListResult) hasNextLink() bool {
	return wthlr.NextLink != nil && len(*wthlr.NextLink) != 0
}

// workflowTriggerHistoryListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wthlr WorkflowTriggerHistoryListResult) workflowTriggerHistoryListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wthlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wthlr.NextLink)))
}

// WorkflowTriggerHistoryListResultPage contains a page of WorkflowTriggerHistory values.
type WorkflowTriggerHistoryListResultPage struct {
	fn    func(context.Context, WorkflowTriggerHistoryListResult) (WorkflowTriggerHistoryListResult, error)
	wthlr WorkflowTriggerHistoryListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkflowTriggerHistoryListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkflowTriggerHistoryListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wthlr)
		if err != nil {
			return err
		}
		page.wthlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkflowTriggerHistoryListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkflowTriggerHistoryListResultPage) NotDone() bool {
	return !page.wthlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkflowTriggerHistoryListResultPage) Response() WorkflowTriggerHistoryListResult {
	return page.wthlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkflowTriggerHistoryListResultPage) Values() []WorkflowTriggerHistory {
	if page.wthlr.IsEmpty() {
		return nil
	}
	return *page.wthlr.Value
}

// Creates a new instance of the WorkflowTriggerHistoryListResultPage type.
func NewWorkflowTriggerHistoryListResultPage(cur WorkflowTriggerHistoryListResult, getNextPage func(context.Context, WorkflowTriggerHistoryListResult) (WorkflowTriggerHistoryListResult, error)) WorkflowTriggerHistoryListResultPage {
	return WorkflowTriggerHistoryListResultPage{
		fn:    getNextPage,
		wthlr: cur,
	}
}

// WorkflowTriggerHistoryProperties the workflow trigger history properties.
type WorkflowTriggerHistoryProperties struct {
	// StartTime - READ-ONLY; Gets the start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; Gets the end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Status - READ-ONLY; Gets the status. Possible values include: 'WorkflowStatusNotSpecified', 'WorkflowStatusPaused', 'WorkflowStatusRunning', 'WorkflowStatusWaiting', 'WorkflowStatusSucceeded', 'WorkflowStatusSkipped', 'WorkflowStatusSuspended', 'WorkflowStatusCancelled', 'WorkflowStatusFailed', 'WorkflowStatusFaulted', 'WorkflowStatusTimedOut', 'WorkflowStatusAborted', 'WorkflowStatusIgnored'
	Status WorkflowStatus `json:"status,omitempty"`
	// Code - READ-ONLY; Gets the code.
	Code *string `json:"code,omitempty"`
	// Error - READ-ONLY; Gets the error.
	Error interface{} `json:"error,omitempty"`
	// TrackingID - READ-ONLY; Gets the tracking id.
	TrackingID *string `json:"trackingId,omitempty"`
	// Correlation - The run correlation.
	Correlation *Correlation `json:"correlation,omitempty"`
	// InputsLink - READ-ONLY; Gets the link to input parameters.
	InputsLink *ContentLink `json:"inputsLink,omitempty"`
	// OutputsLink - READ-ONLY; Gets the link to output parameters.
	OutputsLink *ContentLink `json:"outputsLink,omitempty"`
	// Fired - READ-ONLY; Gets a value indicating whether trigger was fired.
	Fired *bool `json:"fired,omitempty"`
	// Run - READ-ONLY; Gets the reference to workflow run.
	Run *ResourceReference `json:"run,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkflowTriggerHistoryProperties.
func (wthp WorkflowTriggerHistoryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wthp.Correlation != nil {
		objectMap["correlation"] = wthp.Correlation
	}
	return json.Marshal(objectMap)
}

// WorkflowTriggerListCallbackURLQueries gets the workflow trigger callback URL query parameters.
type WorkflowTriggerListCallbackURLQueries struct {
	// APIVersion - The api version.
	APIVersion *string `json:"api-version,omitempty"`
	// Sp - The SAS permissions.
	Sp *string `json:"sp,omitempty"`
	// Sv - The SAS version.
	Sv *string `json:"sv,omitempty"`
	// Sig - The SAS signature.
	Sig *string `json:"sig,omitempty"`
	// Se - The SAS timestamp.
	Se *string `json:"se,omitempty"`
}

// WorkflowTriggerListResult the list of workflow triggers.
type WorkflowTriggerListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of workflow triggers.
	Value *[]WorkflowTrigger `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkflowTriggerListResultIterator provides access to a complete listing of WorkflowTrigger values.
type WorkflowTriggerListResultIterator struct {
	i    int
	page WorkflowTriggerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkflowTriggerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkflowTriggerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkflowTriggerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkflowTriggerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkflowTriggerListResultIterator) Response() WorkflowTriggerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkflowTriggerListResultIterator) Value() WorkflowTrigger {
	if !iter.page.NotDone() {
		return WorkflowTrigger{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkflowTriggerListResultIterator type.
func NewWorkflowTriggerListResultIterator(page WorkflowTriggerListResultPage) WorkflowTriggerListResultIterator {
	return WorkflowTriggerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wtlr WorkflowTriggerListResult) IsEmpty() bool {
	return wtlr.Value == nil || len(*wtlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wtlr WorkflowTriggerListResult) hasNextLink() bool {
	return wtlr.NextLink != nil && len(*wtlr.NextLink) != 0
}

// workflowTriggerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wtlr WorkflowTriggerListResult) workflowTriggerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wtlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wtlr.NextLink)))
}

// WorkflowTriggerListResultPage contains a page of WorkflowTrigger values.
type WorkflowTriggerListResultPage struct {
	fn   func(context.Context, WorkflowTriggerListResult) (WorkflowTriggerListResult, error)
	wtlr WorkflowTriggerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkflowTriggerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkflowTriggerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wtlr)
		if err != nil {
			return err
		}
		page.wtlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkflowTriggerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkflowTriggerListResultPage) NotDone() bool {
	return !page.wtlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkflowTriggerListResultPage) Response() WorkflowTriggerListResult {
	return page.wtlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkflowTriggerListResultPage) Values() []WorkflowTrigger {
	if page.wtlr.IsEmpty() {
		return nil
	}
	return *page.wtlr.Value
}

// Creates a new instance of the WorkflowTriggerListResultPage type.
func NewWorkflowTriggerListResultPage(cur WorkflowTriggerListResult, getNextPage func(context.Context, WorkflowTriggerListResult) (WorkflowTriggerListResult, error)) WorkflowTriggerListResultPage {
	return WorkflowTriggerListResultPage{
		fn:   getNextPage,
		wtlr: cur,
	}
}

// WorkflowTriggerProperties the workflow trigger properties.
type WorkflowTriggerProperties struct {
	// ProvisioningState - READ-ONLY; Gets the provisioning state. Possible values include: 'WorkflowTriggerProvisioningStateNotSpecified', 'WorkflowTriggerProvisioningStateAccepted', 'WorkflowTriggerProvisioningStateRunning', 'WorkflowTriggerProvisioningStateReady', 'WorkflowTriggerProvisioningStateCreating', 'WorkflowTriggerProvisioningStateCreated', 'WorkflowTriggerProvisioningStateDeleting', 'WorkflowTriggerProvisioningStateDeleted', 'WorkflowTriggerProvisioningStateCanceled', 'WorkflowTriggerProvisioningStateFailed', 'WorkflowTriggerProvisioningStateSucceeded', 'WorkflowTriggerProvisioningStateMoving', 'WorkflowTriggerProvisioningStateUpdating', 'WorkflowTriggerProvisioningStateRegistering', 'WorkflowTriggerProvisioningStateRegistered', 'WorkflowTriggerProvisioningStateUnregistering', 'WorkflowTriggerProvisioningStateUnregistered', 'WorkflowTriggerProvisioningStateCompleted'
	ProvisioningState WorkflowTriggerProvisioningState `json:"provisioningState,omitempty"`
	// CreatedTime - READ-ONLY; Gets the created time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - READ-ONLY; Gets the changed time.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// State - READ-ONLY; Gets the state. Possible values include: 'WorkflowStateNotSpecified', 'WorkflowStateCompleted', 'WorkflowStateEnabled', 'WorkflowStateDisabled', 'WorkflowStateDeleted', 'WorkflowStateSuspended'
	State WorkflowState `json:"state,omitempty"`
	// Status - READ-ONLY; Gets the status. Possible values include: 'WorkflowStatusNotSpecified', 'WorkflowStatusPaused', 'WorkflowStatusRunning', 'WorkflowStatusWaiting', 'WorkflowStatusSucceeded', 'WorkflowStatusSkipped', 'WorkflowStatusSuspended', 'WorkflowStatusCancelled', 'WorkflowStatusFailed', 'WorkflowStatusFaulted', 'WorkflowStatusTimedOut', 'WorkflowStatusAborted', 'WorkflowStatusIgnored'
	Status WorkflowStatus `json:"status,omitempty"`
	// LastExecutionTime - READ-ONLY; Gets the last execution time.
	LastExecutionTime *date.Time `json:"lastExecutionTime,omitempty"`
	// NextExecutionTime - READ-ONLY; Gets the next execution time.
	NextExecutionTime *date.Time `json:"nextExecutionTime,omitempty"`
	// Recurrence - READ-ONLY; Gets the workflow trigger recurrence.
	Recurrence *WorkflowTriggerRecurrence `json:"recurrence,omitempty"`
	// Workflow - READ-ONLY; Gets the reference to workflow.
	Workflow *ResourceReference `json:"workflow,omitempty"`
}

// WorkflowTriggerRecurrence the workflow trigger recurrence.
type WorkflowTriggerRecurrence struct {
	// Frequency - The frequency. Possible values include: 'RecurrenceFrequencyNotSpecified', 'RecurrenceFrequencySecond', 'RecurrenceFrequencyMinute', 'RecurrenceFrequencyHour', 'RecurrenceFrequencyDay', 'RecurrenceFrequencyWeek', 'RecurrenceFrequencyMonth', 'RecurrenceFrequencyYear'
	Frequency RecurrenceFrequency `json:"frequency,omitempty"`
	// Interval - The interval.
	Interval *int32 `json:"interval,omitempty"`
	// StartTime - The start time.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *string `json:"endTime,omitempty"`
	// TimeZone - The time zone.
	TimeZone *string `json:"timeZone,omitempty"`
	// Schedule - The recurrence schedule.
	Schedule *RecurrenceSchedule `json:"schedule,omitempty"`
}

// WorkflowVersion the workflow version.
type WorkflowVersion struct {
	autorest.Response `json:"-"`
	// WorkflowVersionProperties - The workflow version properties.
	*WorkflowVersionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for WorkflowVersion.
func (wv WorkflowVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wv.WorkflowVersionProperties != nil {
		objectMap["properties"] = wv.WorkflowVersionProperties
	}
	if wv.Location != nil {
		objectMap["location"] = wv.Location
	}
	if wv.Tags != nil {
		objectMap["tags"] = wv.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkflowVersion struct.
func (wv *WorkflowVersion) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workflowVersionProperties WorkflowVersionProperties
				err = json.Unmarshal(*v, &workflowVersionProperties)
				if err != nil {
					return err
				}
				wv.WorkflowVersionProperties = &workflowVersionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wv.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wv.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wv.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wv.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wv.Tags = tags
			}
		}
	}

	return nil
}

// WorkflowVersionListResult the list of workflow versions.
type WorkflowVersionListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of workflow versions.
	Value *[]WorkflowVersion `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkflowVersionListResultIterator provides access to a complete listing of WorkflowVersion values.
type WorkflowVersionListResultIterator struct {
	i    int
	page WorkflowVersionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkflowVersionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkflowVersionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkflowVersionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkflowVersionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkflowVersionListResultIterator) Response() WorkflowVersionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkflowVersionListResultIterator) Value() WorkflowVersion {
	if !iter.page.NotDone() {
		return WorkflowVersion{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkflowVersionListResultIterator type.
func NewWorkflowVersionListResultIterator(page WorkflowVersionListResultPage) WorkflowVersionListResultIterator {
	return WorkflowVersionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wvlr WorkflowVersionListResult) IsEmpty() bool {
	return wvlr.Value == nil || len(*wvlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wvlr WorkflowVersionListResult) hasNextLink() bool {
	return wvlr.NextLink != nil && len(*wvlr.NextLink) != 0
}

// workflowVersionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wvlr WorkflowVersionListResult) workflowVersionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wvlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wvlr.NextLink)))
}

// WorkflowVersionListResultPage contains a page of WorkflowVersion values.
type WorkflowVersionListResultPage struct {
	fn   func(context.Context, WorkflowVersionListResult) (WorkflowVersionListResult, error)
	wvlr WorkflowVersionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkflowVersionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkflowVersionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wvlr)
		if err != nil {
			return err
		}
		page.wvlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkflowVersionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkflowVersionListResultPage) NotDone() bool {
	return !page.wvlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkflowVersionListResultPage) Response() WorkflowVersionListResult {
	return page.wvlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkflowVersionListResultPage) Values() []WorkflowVersion {
	if page.wvlr.IsEmpty() {
		return nil
	}
	return *page.wvlr.Value
}

// Creates a new instance of the WorkflowVersionListResultPage type.
func NewWorkflowVersionListResultPage(cur WorkflowVersionListResult, getNextPage func(context.Context, WorkflowVersionListResult) (WorkflowVersionListResult, error)) WorkflowVersionListResultPage {
	return WorkflowVersionListResultPage{
		fn:   getNextPage,
		wvlr: cur,
	}
}

// WorkflowVersionProperties the workflow version properties.
type WorkflowVersionProperties struct {
	// CreatedTime - READ-ONLY; Gets the created time.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - READ-ONLY; Gets the changed time.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// State - The state. Possible values include: 'WorkflowStateNotSpecified', 'WorkflowStateCompleted', 'WorkflowStateEnabled', 'WorkflowStateDisabled', 'WorkflowStateDeleted', 'WorkflowStateSuspended'
	State WorkflowState `json:"state,omitempty"`
	// Version - READ-ONLY; Gets the version.
	Version *string `json:"version,omitempty"`
	// AccessEndpoint - READ-ONLY; Gets the access endpoint.
	AccessEndpoint *string `json:"accessEndpoint,omitempty"`
	// Sku - The sku.
	Sku *Sku `json:"sku,omitempty"`
	// IntegrationAccount - The integration account.
	IntegrationAccount *ResourceReference `json:"integrationAccount,omitempty"`
	// Definition - The definition.
	Definition interface{} `json:"definition,omitempty"`
	// Parameters - The parameters.
	Parameters map[string]*WorkflowParameter `json:"parameters"`
}

// MarshalJSON is the custom marshaler for WorkflowVersionProperties.
func (wvp WorkflowVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wvp.State != "" {
		objectMap["state"] = wvp.State
	}
	if wvp.Sku != nil {
		objectMap["sku"] = wvp.Sku
	}
	if wvp.IntegrationAccount != nil {
		objectMap["integrationAccount"] = wvp.IntegrationAccount
	}
	if wvp.Definition != nil {
		objectMap["definition"] = wvp.Definition
	}
	if wvp.Parameters != nil {
		objectMap["parameters"] = wvp.Parameters
	}
	return json.Marshal(objectMap)
}

// X12AcknowledgementSettings the X12 agreement acknowledgement settings.
type X12AcknowledgementSettings struct {
	// NeedTechnicalAcknowledgement - The value indicating whether technical acknowledgement is needed.
	NeedTechnicalAcknowledgement *bool `json:"needTechnicalAcknowledgement,omitempty"`
	// BatchTechnicalAcknowledgements - The value indicating whether to batch the technical acknowledgements.
	BatchTechnicalAcknowledgements *bool `json:"batchTechnicalAcknowledgements,omitempty"`
	// NeedFunctionalAcknowledgement - The value indicating whether functional acknowledgement is needed.
	NeedFunctionalAcknowledgement *bool `json:"needFunctionalAcknowledgement,omitempty"`
	// FunctionalAcknowledgementVersion - The functional acknowledgement version.
	FunctionalAcknowledgementVersion *string `json:"functionalAcknowledgementVersion,omitempty"`
	// BatchFunctionalAcknowledgements - The value indicating whether to batch functional acknowledgements.
	BatchFunctionalAcknowledgements *bool `json:"batchFunctionalAcknowledgements,omitempty"`
	// NeedImplementationAcknowledgement - The value indicating whether implementation acknowledgement is needed.
	NeedImplementationAcknowledgement *bool `json:"needImplementationAcknowledgement,omitempty"`
	// ImplementationAcknowledgementVersion - The implementation acknowledgement version.
	ImplementationAcknowledgementVersion *string `json:"implementationAcknowledgementVersion,omitempty"`
	// BatchImplementationAcknowledgements - The value indicating whether to batch implementation acknowledgements.
	BatchImplementationAcknowledgements *bool `json:"batchImplementationAcknowledgements,omitempty"`
	// NeedLoopForValidMessages - The value indicating whether a loop is needed for valid messages.
	NeedLoopForValidMessages *bool `json:"needLoopForValidMessages,omitempty"`
	// SendSynchronousAcknowledgement - The value indicating whether to send synchronous acknowledgement.
	SendSynchronousAcknowledgement *bool `json:"sendSynchronousAcknowledgement,omitempty"`
	// AcknowledgementControlNumberPrefix - The acknowledgement control number prefix.
	AcknowledgementControlNumberPrefix *string `json:"acknowledgementControlNumberPrefix,omitempty"`
	// AcknowledgementControlNumberSuffix - The acknowledgement control number suffix.
	AcknowledgementControlNumberSuffix *string `json:"acknowledgementControlNumberSuffix,omitempty"`
	// AcknowledgementControlNumberLowerBound - The acknowledgement control number lower bound.
	AcknowledgementControlNumberLowerBound *int32 `json:"acknowledgementControlNumberLowerBound,omitempty"`
	// AcknowledgementControlNumberUpperBound - The acknowledgement control number upper bound.
	AcknowledgementControlNumberUpperBound *int32 `json:"acknowledgementControlNumberUpperBound,omitempty"`
	// RolloverAcknowledgementControlNumber - The value indicating whether to rollover acknowledgement control number.
	RolloverAcknowledgementControlNumber *bool `json:"rolloverAcknowledgementControlNumber,omitempty"`
}

// X12AgreementContent the X12 agreement content.
type X12AgreementContent struct {
	// ReceiveAgreement - The X12 one-way receive agreement.
	ReceiveAgreement *X12OneWayAgreement `json:"receiveAgreement,omitempty"`
	// SendAgreement - The X12 one-way send agreement.
	SendAgreement *X12OneWayAgreement `json:"sendAgreement,omitempty"`
}

// X12DelimiterOverrides the X12 delimiter override settings.
type X12DelimiterOverrides struct {
	// ProtocolVersion - The protocol version.
	ProtocolVersion *string `json:"protocolVersion,omitempty"`
	// MessageID - The message id.
	MessageID *string `json:"messageId,omitempty"`
	// DataElementSeparator - The data element separator.
	DataElementSeparator *int32 `json:"dataElementSeparator,omitempty"`
	// ComponentSeparator - The component separator.
	ComponentSeparator *int32 `json:"componentSeparator,omitempty"`
	// SegmentTerminator - The segment terminator.
	SegmentTerminator *int32 `json:"segmentTerminator,omitempty"`
	// SegmentTerminatorSuffix - The segment terminator suffix. Possible values include: 'SegmentTerminatorSuffixNotSpecified', 'SegmentTerminatorSuffixNone', 'SegmentTerminatorSuffixCR', 'SegmentTerminatorSuffixLF', 'SegmentTerminatorSuffixCRLF'
	SegmentTerminatorSuffix SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
	// ReplaceCharacter - The replacement character.
	ReplaceCharacter *int32 `json:"replaceCharacter,omitempty"`
	// ReplaceSeparatorsInPayload - The value indicating whether to replace separators in payload.
	ReplaceSeparatorsInPayload *bool `json:"replaceSeparatorsInPayload,omitempty"`
	// TargetNamespace - The target namespace on which this delimiter settings has to be applied.
	TargetNamespace *string `json:"targetNamespace,omitempty"`
}

// X12EnvelopeOverride the X12 envelope override settings.
type X12EnvelopeOverride struct {
	// TargetNamespace - The target namespace on which this envelope settings has to be applied.
	TargetNamespace *string `json:"targetNamespace,omitempty"`
	// ProtocolVersion - The protocol version on which this envelope settings has to be applied.
	ProtocolVersion *string `json:"protocolVersion,omitempty"`
	// MessageID - The message id on which this envelope settings has to be applied.
	MessageID *string `json:"messageId,omitempty"`
	// ResponsibleAgencyCode - The responsible agency code.
	ResponsibleAgencyCode *string `json:"responsibleAgencyCode,omitempty"`
	// HeaderVersion - The header version.
	HeaderVersion *string `json:"headerVersion,omitempty"`
	// SenderApplicationID - The sender application id.
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`
	// ReceiverApplicationID - The receiver application id.
	ReceiverApplicationID *string `json:"receiverApplicationId,omitempty"`
	// FunctionalIdentifierCode - The functional identifier code.
	FunctionalIdentifierCode *string `json:"functionalIdentifierCode,omitempty"`
	// DateFormat - The date format. Possible values include: 'X12DateFormatNotSpecified', 'X12DateFormatCCYYMMDD', 'X12DateFormatYYMMDD'
	DateFormat X12DateFormat `json:"dateFormat,omitempty"`
	// TimeFormat - The time format. Possible values include: 'X12TimeFormatNotSpecified', 'X12TimeFormatHHMM', 'X12TimeFormatHHMMSS', 'X12TimeFormatHHMMSSdd', 'X12TimeFormatHHMMSSd'
	TimeFormat X12TimeFormat `json:"timeFormat,omitempty"`
}

// X12EnvelopeSettings the X12 agreement envelope settings.
type X12EnvelopeSettings struct {
	// ControlStandardsID - The controls standards id.
	ControlStandardsID *int32 `json:"controlStandardsId,omitempty"`
	// UseControlStandardsIDAsRepetitionCharacter - The value indicating whether to use control standards id as repetition character.
	UseControlStandardsIDAsRepetitionCharacter *bool `json:"useControlStandardsIdAsRepetitionCharacter,omitempty"`
	// SenderApplicationID - The sender application id.
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`
	// ReceiverApplicationID - The receiver application id.
	ReceiverApplicationID *string `json:"receiverApplicationId,omitempty"`
	// ControlVersionNumber - The control version number.
	ControlVersionNumber *string `json:"controlVersionNumber,omitempty"`
	// InterchangeControlNumberLowerBound - The interchange  control number lower bound.
	InterchangeControlNumberLowerBound *int32 `json:"interchangeControlNumberLowerBound,omitempty"`
	// InterchangeControlNumberUpperBound - The interchange  control number upper bound.
	InterchangeControlNumberUpperBound *int32 `json:"interchangeControlNumberUpperBound,omitempty"`
	// RolloverInterchangeControlNumber - The value indicating whether to rollover interchange control number.
	RolloverInterchangeControlNumber *bool `json:"rolloverInterchangeControlNumber,omitempty"`
	// EnableDefaultGroupHeaders - The value indicating whether to enable default group headers.
	EnableDefaultGroupHeaders *bool `json:"enableDefaultGroupHeaders,omitempty"`
	// FunctionalGroupID - The functional group id.
	FunctionalGroupID *string `json:"functionalGroupId,omitempty"`
	// GroupControlNumberLowerBound - The group control number lower bound.
	GroupControlNumberLowerBound *int32 `json:"groupControlNumberLowerBound,omitempty"`
	// GroupControlNumberUpperBound - The group control number upper bound.
	GroupControlNumberUpperBound *int32 `json:"groupControlNumberUpperBound,omitempty"`
	// RolloverGroupControlNumber - The value indicating whether to rollover group control number.
	RolloverGroupControlNumber *bool `json:"rolloverGroupControlNumber,omitempty"`
	// GroupHeaderAgencyCode - The group header agency code.
	GroupHeaderAgencyCode *string `json:"groupHeaderAgencyCode,omitempty"`
	// GroupHeaderVersion - The group header version.
	GroupHeaderVersion *string `json:"groupHeaderVersion,omitempty"`
	// TransactionSetControlNumberLowerBound - The transaction set control number lower bound.
	TransactionSetControlNumberLowerBound *int32 `json:"transactionSetControlNumberLowerBound,omitempty"`
	// TransactionSetControlNumberUpperBound - The transaction set control number upper bound.
	TransactionSetControlNumberUpperBound *int32 `json:"transactionSetControlNumberUpperBound,omitempty"`
	// RolloverTransactionSetControlNumber - The value indicating whether to rollover transaction set control number.
	RolloverTransactionSetControlNumber *bool `json:"rolloverTransactionSetControlNumber,omitempty"`
	// TransactionSetControlNumberPrefix - The transaction set control number prefix.
	TransactionSetControlNumberPrefix *string `json:"transactionSetControlNumberPrefix,omitempty"`
	// TransactionSetControlNumberSuffix - The transaction set control number suffix.
	TransactionSetControlNumberSuffix *string `json:"transactionSetControlNumberSuffix,omitempty"`
	// OverwriteExistingTransactionSetControlNumber - The value indicating whether to overwrite existing transaction set control number.
	OverwriteExistingTransactionSetControlNumber *bool `json:"overwriteExistingTransactionSetControlNumber,omitempty"`
	// GroupHeaderDateFormat - The group header date format. Possible values include: 'X12DateFormatNotSpecified', 'X12DateFormatCCYYMMDD', 'X12DateFormatYYMMDD'
	GroupHeaderDateFormat X12DateFormat `json:"groupHeaderDateFormat,omitempty"`
	// GroupHeaderTimeFormat - The group header time format. Possible values include: 'X12TimeFormatNotSpecified', 'X12TimeFormatHHMM', 'X12TimeFormatHHMMSS', 'X12TimeFormatHHMMSSdd', 'X12TimeFormatHHMMSSd'
	GroupHeaderTimeFormat X12TimeFormat `json:"groupHeaderTimeFormat,omitempty"`
	// UsageIndicator - The usage indicator. Possible values include: 'UsageIndicatorNotSpecified', 'UsageIndicatorTest', 'UsageIndicatorInformation', 'UsageIndicatorProduction'
	UsageIndicator UsageIndicator `json:"usageIndicator,omitempty"`
}

// X12FramingSettings the X12 agreement framing settings.
type X12FramingSettings struct {
	// DataElementSeparator - The data element separator.
	DataElementSeparator *int32 `json:"dataElementSeparator,omitempty"`
	// ComponentSeparator - The component separator.
	ComponentSeparator *int32 `json:"componentSeparator,omitempty"`
	// ReplaceSeparatorsInPayload - The value indicating whether to replace separators in payload.
	ReplaceSeparatorsInPayload *bool `json:"replaceSeparatorsInPayload,omitempty"`
	// ReplaceCharacter - The replacement character.
	ReplaceCharacter *int32 `json:"replaceCharacter,omitempty"`
	// SegmentTerminator - The segment terminator.
	SegmentTerminator *int32 `json:"segmentTerminator,omitempty"`
	// CharacterSet - The X12 character set. Possible values include: 'X12CharacterSetNotSpecified', 'X12CharacterSetBasic', 'X12CharacterSetExtended', 'X12CharacterSetUTF8'
	CharacterSet X12CharacterSet `json:"characterSet,omitempty"`
	// SegmentTerminatorSuffix - The segment terminator suffix. Possible values include: 'SegmentTerminatorSuffixNotSpecified', 'SegmentTerminatorSuffixNone', 'SegmentTerminatorSuffixCR', 'SegmentTerminatorSuffixLF', 'SegmentTerminatorSuffixCRLF'
	SegmentTerminatorSuffix SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
}

// X12MessageFilter the X12 message filter for odata query.
type X12MessageFilter struct {
	// MessageFilterType - The message filter type. Possible values include: 'MessageFilterTypeNotSpecified', 'MessageFilterTypeInclude', 'MessageFilterTypeExclude'
	MessageFilterType MessageFilterType `json:"messageFilterType,omitempty"`
}

// X12MessageIdentifier the X12 message identifier.
type X12MessageIdentifier struct {
	// MessageID - The message id.
	MessageID *string `json:"messageId,omitempty"`
}

// X12OneWayAgreement the X12 one-way agreement.
type X12OneWayAgreement struct {
	// SenderBusinessIdentity - The sender business identity
	SenderBusinessIdentity *BusinessIdentity `json:"senderBusinessIdentity,omitempty"`
	// ReceiverBusinessIdentity - The receiver business identity
	ReceiverBusinessIdentity *BusinessIdentity `json:"receiverBusinessIdentity,omitempty"`
	// ProtocolSettings - The X12 protocol settings.
	ProtocolSettings *X12ProtocolSettings `json:"protocolSettings,omitempty"`
}

// X12ProcessingSettings the X12 processing settings.
type X12ProcessingSettings struct {
	// MaskSecurityInfo - The value indicating whether to mask security information.
	MaskSecurityInfo *bool `json:"maskSecurityInfo,omitempty"`
	// ConvertImpliedDecimal - The value indicating whether to convert numerical type to implied decimal.
	ConvertImpliedDecimal *bool `json:"convertImpliedDecimal,omitempty"`
	// PreserveInterchange - The value indicating whether to preserve interchange.
	PreserveInterchange *bool `json:"preserveInterchange,omitempty"`
	// SuspendInterchangeOnError - The value indicating whether to suspend interchange on error.
	SuspendInterchangeOnError *bool `json:"suspendInterchangeOnError,omitempty"`
	// CreateEmptyXMLTagsForTrailingSeparators - The value indicating whether to create empty xml tags for trailing separators.
	CreateEmptyXMLTagsForTrailingSeparators *bool `json:"createEmptyXmlTagsForTrailingSeparators,omitempty"`
	// UseDotAsDecimalSeparator - The value indicating whether to use dot as decimal separator.
	UseDotAsDecimalSeparator *bool `json:"useDotAsDecimalSeparator,omitempty"`
}

// X12ProtocolSettings the X12 agreement protocol settings.
type X12ProtocolSettings struct {
	// ValidationSettings - The X12 validation settings.
	ValidationSettings *X12ValidationSettings `json:"validationSettings,omitempty"`
	// FramingSettings - The X12 framing settings.
	FramingSettings *X12FramingSettings `json:"framingSettings,omitempty"`
	// EnvelopeSettings - The X12 envelope settings.
	EnvelopeSettings *X12EnvelopeSettings `json:"envelopeSettings,omitempty"`
	// AcknowledgementSettings - The X12 acknowledgment settings.
	AcknowledgementSettings *X12AcknowledgementSettings `json:"acknowledgementSettings,omitempty"`
	// MessageFilter - The X12 message filter.
	MessageFilter *X12MessageFilter `json:"messageFilter,omitempty"`
	// SecuritySettings - The X12 security settings.
	SecuritySettings *X12SecuritySettings `json:"securitySettings,omitempty"`
	// ProcessingSettings - The X12 processing settings.
	ProcessingSettings *X12ProcessingSettings `json:"processingSettings,omitempty"`
	// EnvelopeOverrides - The X12 envelope override settings.
	EnvelopeOverrides *[]X12EnvelopeOverride `json:"envelopeOverrides,omitempty"`
	// ValidationOverrides - The X12 validation override settings.
	ValidationOverrides *[]X12ValidationOverride `json:"validationOverrides,omitempty"`
	// MessageFilterList - The X12 message filter list.
	MessageFilterList *[]X12MessageIdentifier `json:"messageFilterList,omitempty"`
	// SchemaReferences - The X12 schema references.
	SchemaReferences *[]X12SchemaReference `json:"schemaReferences,omitempty"`
	// X12DelimiterOverrides - The X12 delimiter override settings.
	X12DelimiterOverrides *[]X12DelimiterOverrides `json:"x12DelimiterOverrides,omitempty"`
}

// X12SchemaReference the X12 schema reference.
type X12SchemaReference struct {
	// MessageID - The message id.
	MessageID *string `json:"messageId,omitempty"`
	// SenderApplicationID - The sender application id.
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`
	// SchemaVersion - The schema version.
	SchemaVersion *string `json:"schemaVersion,omitempty"`
	// SchemaName - The schema name.
	SchemaName *string `json:"schemaName,omitempty"`
}

// X12SecuritySettings the X12 agreement security settings.
type X12SecuritySettings struct {
	// AuthorizationQualifier - The authorization qualifier.
	AuthorizationQualifier *string `json:"authorizationQualifier,omitempty"`
	// AuthorizationValue - The authorization value.
	AuthorizationValue *string `json:"authorizationValue,omitempty"`
	// SecurityQualifier - The security qualifier.
	SecurityQualifier *string `json:"securityQualifier,omitempty"`
	// PasswordValue - The password value.
	PasswordValue *string `json:"passwordValue,omitempty"`
}

// X12ValidationOverride the X12 validation override settings.
type X12ValidationOverride struct {
	// MessageID - The message id on which the validation settings has to be applied.
	MessageID *string `json:"messageId,omitempty"`
	// ValidateEdiTypes - The value indicating whether to validate EDI types.
	ValidateEdiTypes *bool `json:"validateEdiTypes,omitempty"`
	// ValidateXsdTypes - The value indicating whether to validate XSD types.
	ValidateXsdTypes *bool `json:"validateXsdTypes,omitempty"`
	// AllowLeadingAndTrailingSpacesAndZeroes - The value indicating whether to allow leading and trailing spaces and zeroes.
	AllowLeadingAndTrailingSpacesAndZeroes *bool `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`
	// ValidateCharacterSet - The value indicating whether to validate character Set.
	ValidateCharacterSet *bool `json:"validateCharacterSet,omitempty"`
	// TrimLeadingAndTrailingSpacesAndZeroes - The value indicating whether to trim leading and trailing spaces and zeroes.
	TrimLeadingAndTrailingSpacesAndZeroes *bool `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`
	// TrailingSeparatorPolicy - The trailing separator policy. Possible values include: 'TrailingSeparatorPolicyNotSpecified', 'TrailingSeparatorPolicyNotAllowed', 'TrailingSeparatorPolicyOptional', 'TrailingSeparatorPolicyMandatory'
	TrailingSeparatorPolicy TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`
}

// X12ValidationSettings the X12 agreement validation settings.
type X12ValidationSettings struct {
	// ValidateCharacterSet - The value indicating whether to validate character set in the message.
	ValidateCharacterSet *bool `json:"validateCharacterSet,omitempty"`
	// CheckDuplicateInterchangeControlNumber - The value indicating whether to check for duplicate interchange control number.
	CheckDuplicateInterchangeControlNumber *bool `json:"checkDuplicateInterchangeControlNumber,omitempty"`
	// InterchangeControlNumberValidityDays - The validity period of interchange control number.
	InterchangeControlNumberValidityDays *int32 `json:"interchangeControlNumberValidityDays,omitempty"`
	// CheckDuplicateGroupControlNumber - The value indicating whether to check for duplicate group control number.
	CheckDuplicateGroupControlNumber *bool `json:"checkDuplicateGroupControlNumber,omitempty"`
	// CheckDuplicateTransactionSetControlNumber - The value indicating whether to check for duplicate transaction set control number.
	CheckDuplicateTransactionSetControlNumber *bool `json:"checkDuplicateTransactionSetControlNumber,omitempty"`
	// ValidateEdiTypes - The value indicating whether to Whether to validate EDI types.
	ValidateEdiTypes *bool `json:"validateEdiTypes,omitempty"`
	// ValidateXsdTypes - The value indicating whether to Whether to validate XSD types.
	ValidateXsdTypes *bool `json:"validateXsdTypes,omitempty"`
	// AllowLeadingAndTrailingSpacesAndZeroes - The value indicating whether to allow leading and trailing spaces and zeroes.
	AllowLeadingAndTrailingSpacesAndZeroes *bool `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`
	// TrimLeadingAndTrailingSpacesAndZeroes - The value indicating whether to trim leading and trailing spaces and zeroes.
	TrimLeadingAndTrailingSpacesAndZeroes *bool `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`
	// TrailingSeparatorPolicy - The trailing separator policy. Possible values include: 'TrailingSeparatorPolicyNotSpecified', 'TrailingSeparatorPolicyNotAllowed', 'TrailingSeparatorPolicyOptional', 'TrailingSeparatorPolicyMandatory'
	TrailingSeparatorPolicy TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`
}
