package kusto

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/kusto/mgmt/2021-01-01/kusto"

// AttachedDatabaseConfiguration class representing an attached database configuration.
type AttachedDatabaseConfiguration struct {
	autorest.Response `json:"-"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// AttachedDatabaseConfigurationProperties - The properties of the attached database configuration.
	*AttachedDatabaseConfigurationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AttachedDatabaseConfiguration.
func (adc AttachedDatabaseConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adc.Location != nil {
		objectMap["location"] = adc.Location
	}
	if adc.AttachedDatabaseConfigurationProperties != nil {
		objectMap["properties"] = adc.AttachedDatabaseConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AttachedDatabaseConfiguration struct.
func (adc *AttachedDatabaseConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				adc.Location = &location
			}
		case "properties":
			if v != nil {
				var attachedDatabaseConfigurationProperties AttachedDatabaseConfigurationProperties
				err = json.Unmarshal(*v, &attachedDatabaseConfigurationProperties)
				if err != nil {
					return err
				}
				adc.AttachedDatabaseConfigurationProperties = &attachedDatabaseConfigurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				adc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adc.Type = &typeVar
			}
		}
	}

	return nil
}

// AttachedDatabaseConfigurationListResult the list attached database configurations operation response.
type AttachedDatabaseConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of attached database configurations.
	Value *[]AttachedDatabaseConfiguration `json:"value,omitempty"`
}

// AttachedDatabaseConfigurationProperties class representing the an attached database configuration
// properties of kind specific.
type AttachedDatabaseConfigurationProperties struct {
	// ProvisioningState - The provisioned state of the resource. Possible values include: 'ProvisioningStateRunning', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateMoving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// DatabaseName - The name of the database which you would like to attach, use * if you want to follow all current and future databases.
	DatabaseName *string `json:"databaseName,omitempty"`
	// ClusterResourceID - The resource id of the cluster where the databases you would like to attach reside.
	ClusterResourceID *string `json:"clusterResourceId,omitempty"`
	// AttachedDatabaseNames - READ-ONLY; The list of databases from the clusterResourceId which are currently attached to the cluster.
	AttachedDatabaseNames *[]string `json:"attachedDatabaseNames,omitempty"`
	// DefaultPrincipalsModificationKind - The default principals modification kind. Possible values include: 'DefaultPrincipalsModificationKindUnion', 'DefaultPrincipalsModificationKindReplace', 'DefaultPrincipalsModificationKindNone'
	DefaultPrincipalsModificationKind DefaultPrincipalsModificationKind `json:"defaultPrincipalsModificationKind,omitempty"`
	// TableLevelSharingProperties - Table level sharing specifications
	TableLevelSharingProperties *TableLevelSharingProperties `json:"tableLevelSharingProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AttachedDatabaseConfigurationProperties.
func (adcp AttachedDatabaseConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adcp.ProvisioningState != "" {
		objectMap["provisioningState"] = adcp.ProvisioningState
	}
	if adcp.DatabaseName != nil {
		objectMap["databaseName"] = adcp.DatabaseName
	}
	if adcp.ClusterResourceID != nil {
		objectMap["clusterResourceId"] = adcp.ClusterResourceID
	}
	if adcp.DefaultPrincipalsModificationKind != "" {
		objectMap["defaultPrincipalsModificationKind"] = adcp.DefaultPrincipalsModificationKind
	}
	if adcp.TableLevelSharingProperties != nil {
		objectMap["tableLevelSharingProperties"] = adcp.TableLevelSharingProperties
	}
	return json.Marshal(objectMap)
}

// AttachedDatabaseConfigurationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type AttachedDatabaseConfigurationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AttachedDatabaseConfigurationsClient) (AttachedDatabaseConfiguration, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AttachedDatabaseConfigurationsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AttachedDatabaseConfigurationsCreateOrUpdateFuture.Result.
func (future *AttachedDatabaseConfigurationsCreateOrUpdateFuture) result(client AttachedDatabaseConfigurationsClient) (adc AttachedDatabaseConfiguration, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.AttachedDatabaseConfigurationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		adc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.AttachedDatabaseConfigurationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if adc.Response.Response, err = future.GetResult(sender); err == nil && adc.Response.Response.StatusCode != http.StatusNoContent {
		adc, err = client.CreateOrUpdateResponder(adc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.AttachedDatabaseConfigurationsCreateOrUpdateFuture", "Result", adc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AttachedDatabaseConfigurationsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AttachedDatabaseConfigurationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AttachedDatabaseConfigurationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AttachedDatabaseConfigurationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AttachedDatabaseConfigurationsDeleteFuture.Result.
func (future *AttachedDatabaseConfigurationsDeleteFuture) result(client AttachedDatabaseConfigurationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.AttachedDatabaseConfigurationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.AttachedDatabaseConfigurationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AzureCapacity azure capacity definition.
type AzureCapacity struct {
	// ScaleType - Scale type. Possible values include: 'AzureScaleTypeAutomatic', 'AzureScaleTypeManual', 'AzureScaleTypeNone'
	ScaleType AzureScaleType `json:"scaleType,omitempty"`
	// Minimum - Minimum allowed capacity.
	Minimum *int32 `json:"minimum,omitempty"`
	// Maximum - Maximum allowed capacity.
	Maximum *int32 `json:"maximum,omitempty"`
	// Default - The default capacity that would be used.
	Default *int32 `json:"default,omitempty"`
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// AzureResourceSku azure resource SKU definition.
type AzureResourceSku struct {
	// ResourceType - Resource Namespace and Type.
	ResourceType *string `json:"resourceType,omitempty"`
	// Sku - The SKU details.
	Sku *AzureSku `json:"sku,omitempty"`
	// Capacity - The number of instances of the cluster.
	Capacity *AzureCapacity `json:"capacity,omitempty"`
}

// AzureSku azure SKU definition.
type AzureSku struct {
	// Name - SKU name. Possible values include: 'AzureSkuNameStandardDS13V21TBPS', 'AzureSkuNameStandardDS13V22TBPS', 'AzureSkuNameStandardDS14V23TBPS', 'AzureSkuNameStandardDS14V24TBPS', 'AzureSkuNameStandardD13V2', 'AzureSkuNameStandardD14V2', 'AzureSkuNameStandardL8s', 'AzureSkuNameStandardL16s', 'AzureSkuNameStandardL8sV2', 'AzureSkuNameStandardL16sV2', 'AzureSkuNameStandardD11V2', 'AzureSkuNameStandardD12V2', 'AzureSkuNameStandardL4s', 'AzureSkuNameDevNoSLAStandardD11V2', 'AzureSkuNameStandardE64iV3', 'AzureSkuNameStandardE80idsV4', 'AzureSkuNameStandardE2aV4', 'AzureSkuNameStandardE4aV4', 'AzureSkuNameStandardE8aV4', 'AzureSkuNameStandardE16aV4', 'AzureSkuNameStandardE8asV41TBPS', 'AzureSkuNameStandardE8asV42TBPS', 'AzureSkuNameStandardE16asV43TBPS', 'AzureSkuNameStandardE16asV44TBPS', 'AzureSkuNameDevNoSLAStandardE2aV4'
	Name AzureSkuName `json:"name,omitempty"`
	// Capacity - The number of instances of the cluster.
	Capacity *int32 `json:"capacity,omitempty"`
	// Tier - SKU tier. Possible values include: 'AzureSkuTierBasic', 'AzureSkuTierStandard'
	Tier AzureSkuTier `json:"tier,omitempty"`
}

// CheckNameRequest the result returned from a database check name availability request.
type CheckNameRequest struct {
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, for instance Microsoft.Kusto/clusters/databases. Possible values include: 'TypeMicrosoftKustoclustersdatabases', 'TypeMicrosoftKustoclustersattachedDatabaseConfigurations'
	Type Type `json:"type,omitempty"`
}

// CheckNameResult the result returned from a check name availability request.
type CheckNameResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - Specifies a Boolean value that indicates if the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Name - The name that was checked.
	Name *string `json:"name,omitempty"`
	// Message - Message indicating an unavailable name due to a conflict, or a description of the naming rules that are violated.
	Message *string `json:"message,omitempty"`
	// Reason - Message providing the reason why the given name is invalid. Possible values include: 'ReasonInvalid', 'ReasonAlreadyExists'
	Reason Reason `json:"reason,omitempty"`
}

// CloudError an error response from Kusto.
type CloudError struct {
	// Error - An error response from Kusto.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from Kusto.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for displaying in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// Cluster class representing a Kusto cluster.
type Cluster struct {
	autorest.Response `json:"-"`
	// Sku - The SKU of the cluster.
	Sku *AzureSku `json:"sku,omitempty"`
	// Zones - The availability zones of the cluster.
	Zones *[]string `json:"zones,omitempty"`
	// Identity - The identity of the cluster, if configured.
	Identity *Identity `json:"identity,omitempty"`
	// ClusterProperties - The cluster properties.
	*ClusterProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Sku != nil {
		objectMap["sku"] = c.Sku
	}
	if c.Zones != nil {
		objectMap["zones"] = c.Zones
	}
	if c.Identity != nil {
		objectMap["identity"] = c.Identity
	}
	if c.ClusterProperties != nil {
		objectMap["properties"] = c.ClusterProperties
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cluster struct.
func (c *Cluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku AzureSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				c.Sku = &sku
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				c.Zones = &zones
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				c.Identity = &identity
			}
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				c.ClusterProperties = &clusterProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				c.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ClusterCheckNameRequest the result returned from a cluster check name availability request.
type ClusterCheckNameRequest struct {
	// Name - Cluster name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, Microsoft.Kusto/clusters.
	Type *string `json:"type,omitempty"`
}

// ClusterListResult the list Kusto clusters operation response.
type ClusterListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto clusters.
	Value *[]Cluster `json:"value,omitempty"`
}

// ClusterPrincipalAssignment class representing a cluster principal assignment.
type ClusterPrincipalAssignment struct {
	autorest.Response `json:"-"`
	// ClusterPrincipalProperties - The cluster principal.
	*ClusterPrincipalProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterPrincipalAssignment.
func (cpa ClusterPrincipalAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpa.ClusterPrincipalProperties != nil {
		objectMap["properties"] = cpa.ClusterPrincipalProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterPrincipalAssignment struct.
func (cpa *ClusterPrincipalAssignment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterPrincipalProperties ClusterPrincipalProperties
				err = json.Unmarshal(*v, &clusterPrincipalProperties)
				if err != nil {
					return err
				}
				cpa.ClusterPrincipalProperties = &clusterPrincipalProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cpa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cpa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cpa.Type = &typeVar
			}
		}
	}

	return nil
}

// ClusterPrincipalAssignmentCheckNameRequest a principal assignment check name availability request.
type ClusterPrincipalAssignmentCheckNameRequest struct {
	// Name - Principal Assignment resource name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, Microsoft.Kusto/clusters/principalAssignments.
	Type *string `json:"type,omitempty"`
}

// ClusterPrincipalAssignmentListResult the list Kusto cluster principal assignments operation response.
type ClusterPrincipalAssignmentListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto cluster principal assignments.
	Value *[]ClusterPrincipalAssignment `json:"value,omitempty"`
}

// ClusterPrincipalAssignmentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ClusterPrincipalAssignmentsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClusterPrincipalAssignmentsClient) (ClusterPrincipalAssignment, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClusterPrincipalAssignmentsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClusterPrincipalAssignmentsCreateOrUpdateFuture.Result.
func (future *ClusterPrincipalAssignmentsCreateOrUpdateFuture) result(client ClusterPrincipalAssignmentsClient) (cpa ClusterPrincipalAssignment, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClusterPrincipalAssignmentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cpa.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.ClusterPrincipalAssignmentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cpa.Response.Response, err = future.GetResult(sender); err == nil && cpa.Response.Response.StatusCode != http.StatusNoContent {
		cpa, err = client.CreateOrUpdateResponder(cpa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.ClusterPrincipalAssignmentsCreateOrUpdateFuture", "Result", cpa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClusterPrincipalAssignmentsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ClusterPrincipalAssignmentsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClusterPrincipalAssignmentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClusterPrincipalAssignmentsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClusterPrincipalAssignmentsDeleteFuture.Result.
func (future *ClusterPrincipalAssignmentsDeleteFuture) result(client ClusterPrincipalAssignmentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClusterPrincipalAssignmentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.ClusterPrincipalAssignmentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClusterPrincipalProperties a class representing cluster principal property.
type ClusterPrincipalProperties struct {
	// PrincipalID - The principal ID assigned to the cluster principal. It can be a user email, application ID, or security group name.
	PrincipalID *string `json:"principalId,omitempty"`
	// Role - Cluster principal role. Possible values include: 'ClusterPrincipalRoleAllDatabasesAdmin', 'ClusterPrincipalRoleAllDatabasesViewer'
	Role ClusterPrincipalRole `json:"role,omitempty"`
	// TenantID - The tenant id of the principal
	TenantID *string `json:"tenantId,omitempty"`
	// PrincipalType - Principal type. Possible values include: 'PrincipalTypeApp', 'PrincipalTypeGroup', 'PrincipalTypeUser'
	PrincipalType PrincipalType `json:"principalType,omitempty"`
	// TenantName - READ-ONLY; The tenant name of the principal
	TenantName *string `json:"tenantName,omitempty"`
	// PrincipalName - READ-ONLY; The principal name
	PrincipalName *string `json:"principalName,omitempty"`
	// ProvisioningState - The provisioned state of the resource. Possible values include: 'ProvisioningStateRunning', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateMoving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterPrincipalProperties.
func (cpp ClusterPrincipalProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpp.PrincipalID != nil {
		objectMap["principalId"] = cpp.PrincipalID
	}
	if cpp.Role != "" {
		objectMap["role"] = cpp.Role
	}
	if cpp.TenantID != nil {
		objectMap["tenantId"] = cpp.TenantID
	}
	if cpp.PrincipalType != "" {
		objectMap["principalType"] = cpp.PrincipalType
	}
	if cpp.ProvisioningState != "" {
		objectMap["provisioningState"] = cpp.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// ClusterProperties class representing the Kusto cluster properties.
type ClusterProperties struct {
	// State - READ-ONLY; The state of the resource. Possible values include: 'StateCreating', 'StateUnavailable', 'StateRunning', 'StateDeleting', 'StateDeleted', 'StateStopping', 'StateStopped', 'StateStarting', 'StateUpdating'
	State State `json:"state,omitempty"`
	// ProvisioningState - The provisioned state of the resource. Possible values include: 'ProvisioningStateRunning', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateMoving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// URI - READ-ONLY; The cluster URI.
	URI *string `json:"uri,omitempty"`
	// DataIngestionURI - READ-ONLY; The cluster data ingestion URI.
	DataIngestionURI *string `json:"dataIngestionUri,omitempty"`
	// StateReason - READ-ONLY; The reason for the cluster's current state.
	StateReason *string `json:"stateReason,omitempty"`
	// TrustedExternalTenants - The cluster's external tenants.
	TrustedExternalTenants *[]TrustedExternalTenant `json:"trustedExternalTenants,omitempty"`
	// OptimizedAutoscale - Optimized auto scale definition.
	OptimizedAutoscale *OptimizedAutoscale `json:"optimizedAutoscale,omitempty"`
	// EnableDiskEncryption - A boolean value that indicates if the cluster's disks are encrypted.
	EnableDiskEncryption *bool `json:"enableDiskEncryption,omitempty"`
	// EnableStreamingIngest - A boolean value that indicates if the streaming ingest is enabled.
	EnableStreamingIngest *bool `json:"enableStreamingIngest,omitempty"`
	// VirtualNetworkConfiguration - Virtual network definition.
	VirtualNetworkConfiguration *VirtualNetworkConfiguration `json:"virtualNetworkConfiguration,omitempty"`
	// KeyVaultProperties - KeyVault properties for the cluster encryption.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
	// EnablePurge - A boolean value that indicates if the purge operations are enabled.
	EnablePurge *bool `json:"enablePurge,omitempty"`
	// LanguageExtensions - READ-ONLY; List of the cluster's language extensions.
	LanguageExtensions *LanguageExtensionsList `json:"languageExtensions,omitempty"`
	// EnableDoubleEncryption - A boolean value that indicates if double encryption is enabled.
	EnableDoubleEncryption *bool `json:"enableDoubleEncryption,omitempty"`
	// EngineType - The engine type. Possible values include: 'EngineTypeV2', 'EngineTypeV3'
	EngineType EngineType `json:"engineType,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterProperties.
func (cp ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.ProvisioningState != "" {
		objectMap["provisioningState"] = cp.ProvisioningState
	}
	if cp.TrustedExternalTenants != nil {
		objectMap["trustedExternalTenants"] = cp.TrustedExternalTenants
	}
	if cp.OptimizedAutoscale != nil {
		objectMap["optimizedAutoscale"] = cp.OptimizedAutoscale
	}
	if cp.EnableDiskEncryption != nil {
		objectMap["enableDiskEncryption"] = cp.EnableDiskEncryption
	}
	if cp.EnableStreamingIngest != nil {
		objectMap["enableStreamingIngest"] = cp.EnableStreamingIngest
	}
	if cp.VirtualNetworkConfiguration != nil {
		objectMap["virtualNetworkConfiguration"] = cp.VirtualNetworkConfiguration
	}
	if cp.KeyVaultProperties != nil {
		objectMap["keyVaultProperties"] = cp.KeyVaultProperties
	}
	if cp.EnablePurge != nil {
		objectMap["enablePurge"] = cp.EnablePurge
	}
	if cp.EnableDoubleEncryption != nil {
		objectMap["enableDoubleEncryption"] = cp.EnableDoubleEncryption
	}
	if cp.EngineType != "" {
		objectMap["engineType"] = cp.EngineType
	}
	return json.Marshal(objectMap)
}

// ClustersAddLanguageExtensionsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ClustersAddLanguageExtensionsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersAddLanguageExtensionsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersAddLanguageExtensionsFuture.Result.
func (future *ClustersAddLanguageExtensionsFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersAddLanguageExtensionsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersAddLanguageExtensionsFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersCreateOrUpdateFuture.Result.
func (future *ClustersCreateOrUpdateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateOrUpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.ClustersCreateOrUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersDeleteFuture.Result.
func (future *ClustersDeleteFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersDetachFollowerDatabasesFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ClustersDetachFollowerDatabasesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersDetachFollowerDatabasesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersDetachFollowerDatabasesFuture.Result.
func (future *ClustersDetachFollowerDatabasesFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersDetachFollowerDatabasesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersDetachFollowerDatabasesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersDiagnoseVirtualNetworkFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ClustersDiagnoseVirtualNetworkFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (DiagnoseVirtualNetworkResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersDiagnoseVirtualNetworkFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersDiagnoseVirtualNetworkFuture.Result.
func (future *ClustersDiagnoseVirtualNetworkFuture) result(client ClustersClient) (dvnr DiagnoseVirtualNetworkResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersDiagnoseVirtualNetworkFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dvnr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersDiagnoseVirtualNetworkFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dvnr.Response.Response, err = future.GetResult(sender); err == nil && dvnr.Response.Response.StatusCode != http.StatusNoContent {
		dvnr, err = client.DiagnoseVirtualNetworkResponder(dvnr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.ClustersDiagnoseVirtualNetworkFuture", "Result", dvnr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersRemoveLanguageExtensionsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ClustersRemoveLanguageExtensionsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersRemoveLanguageExtensionsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersRemoveLanguageExtensionsFuture.Result.
func (future *ClustersRemoveLanguageExtensionsFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersRemoveLanguageExtensionsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersRemoveLanguageExtensionsFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersStartFuture.Result.
func (future *ClustersStartFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ClustersStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersStopFuture.Result.
func (future *ClustersStopFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersUpdateFuture.Result.
func (future *ClustersUpdateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ClustersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.ClustersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.UpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.ClustersUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClusterUpdate class representing an update to a Kusto cluster.
type ClusterUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Sku - The SKU of the cluster.
	Sku *AzureSku `json:"sku,omitempty"`
	// Identity - The identity of the cluster, if configured.
	Identity *Identity `json:"identity,omitempty"`
	// ClusterProperties - The cluster properties.
	*ClusterProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpdate.
func (cu ClusterUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cu.Tags != nil {
		objectMap["tags"] = cu.Tags
	}
	if cu.Location != nil {
		objectMap["location"] = cu.Location
	}
	if cu.Sku != nil {
		objectMap["sku"] = cu.Sku
	}
	if cu.Identity != nil {
		objectMap["identity"] = cu.Identity
	}
	if cu.ClusterProperties != nil {
		objectMap["properties"] = cu.ClusterProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterUpdate struct.
func (cu *ClusterUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cu.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cu.Location = &location
			}
		case "sku":
			if v != nil {
				var sku AzureSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				cu.Sku = &sku
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				cu.Identity = &identity
			}
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				cu.ClusterProperties = &clusterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cu.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cu.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicDatabase class representing a Kusto database.
type BasicDatabase interface {
	AsReadWriteDatabase() (*ReadWriteDatabase, bool)
	AsReadOnlyFollowingDatabase() (*ReadOnlyFollowingDatabase, bool)
	AsDatabase() (*Database, bool)
}

// Database class representing a Kusto database.
type Database struct {
	autorest.Response `json:"-"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindKindDatabase', 'KindKindReadWrite', 'KindKindReadOnlyFollowing'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

func unmarshalBasicDatabase(body []byte) (BasicDatabase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindKindReadWrite):
		var rwd ReadWriteDatabase
		err := json.Unmarshal(body, &rwd)
		return rwd, err
	case string(KindKindReadOnlyFollowing):
		var rofd ReadOnlyFollowingDatabase
		err := json.Unmarshal(body, &rofd)
		return rofd, err
	default:
		var d Database
		err := json.Unmarshal(body, &d)
		return d, err
	}
}
func unmarshalBasicDatabaseArray(body []byte) ([]BasicDatabase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dArray := make([]BasicDatabase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		d, err := unmarshalBasicDatabase(*rawMessage)
		if err != nil {
			return nil, err
		}
		dArray[index] = d
	}
	return dArray, nil
}

// MarshalJSON is the custom marshaler for Database.
func (d Database) MarshalJSON() ([]byte, error) {
	d.Kind = KindKindDatabase
	objectMap := make(map[string]interface{})
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Kind != "" {
		objectMap["kind"] = d.Kind
	}
	return json.Marshal(objectMap)
}

// AsReadWriteDatabase is the BasicDatabase implementation for Database.
func (d Database) AsReadWriteDatabase() (*ReadWriteDatabase, bool) {
	return nil, false
}

// AsReadOnlyFollowingDatabase is the BasicDatabase implementation for Database.
func (d Database) AsReadOnlyFollowingDatabase() (*ReadOnlyFollowingDatabase, bool) {
	return nil, false
}

// AsDatabase is the BasicDatabase implementation for Database.
func (d Database) AsDatabase() (*Database, bool) {
	return &d, true
}

// AsBasicDatabase is the BasicDatabase implementation for Database.
func (d Database) AsBasicDatabase() (BasicDatabase, bool) {
	return &d, true
}

// DatabaseListResult the list Kusto databases operation response.
type DatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto databases.
	Value *[]BasicDatabase `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DatabaseListResult struct.
func (dlr *DatabaseListResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicDatabaseArray(*v)
				if err != nil {
					return err
				}
				dlr.Value = &value
			}
		}
	}

	return nil
}

// DatabaseModel ...
type DatabaseModel struct {
	autorest.Response `json:"-"`
	Value             BasicDatabase `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DatabaseModel struct.
func (dm *DatabaseModel) UnmarshalJSON(body []byte) error {
	d, err := unmarshalBasicDatabase(body)
	if err != nil {
		return err
	}
	dm.Value = d

	return nil
}

// DatabasePrincipal a class representing database principal entity.
type DatabasePrincipal struct {
	// Role - Database principal role. Possible values include: 'DatabasePrincipalRoleAdmin', 'DatabasePrincipalRoleIngestor', 'DatabasePrincipalRoleMonitor', 'DatabasePrincipalRoleUser', 'DatabasePrincipalRoleUnrestrictedViewer', 'DatabasePrincipalRoleViewer'
	Role DatabasePrincipalRole `json:"role,omitempty"`
	// Name - Database principal name.
	Name *string `json:"name,omitempty"`
	// Type - Database principal type. Possible values include: 'DatabasePrincipalTypeApp', 'DatabasePrincipalTypeGroup', 'DatabasePrincipalTypeUser'
	Type DatabasePrincipalType `json:"type,omitempty"`
	// Fqn - Database principal fully qualified name.
	Fqn *string `json:"fqn,omitempty"`
	// Email - Database principal email if exists.
	Email *string `json:"email,omitempty"`
	// AppID - Application id - relevant only for application principal type.
	AppID *string `json:"appId,omitempty"`
	// TenantName - READ-ONLY; The tenant name of the principal
	TenantName *string `json:"tenantName,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabasePrincipal.
func (dp DatabasePrincipal) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.Role != "" {
		objectMap["role"] = dp.Role
	}
	if dp.Name != nil {
		objectMap["name"] = dp.Name
	}
	if dp.Type != "" {
		objectMap["type"] = dp.Type
	}
	if dp.Fqn != nil {
		objectMap["fqn"] = dp.Fqn
	}
	if dp.Email != nil {
		objectMap["email"] = dp.Email
	}
	if dp.AppID != nil {
		objectMap["appId"] = dp.AppID
	}
	return json.Marshal(objectMap)
}

// DatabasePrincipalAssignment class representing a database principal assignment.
type DatabasePrincipalAssignment struct {
	autorest.Response `json:"-"`
	// DatabasePrincipalProperties - The database principal.
	*DatabasePrincipalProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabasePrincipalAssignment.
func (dpa DatabasePrincipalAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dpa.DatabasePrincipalProperties != nil {
		objectMap["properties"] = dpa.DatabasePrincipalProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabasePrincipalAssignment struct.
func (dpa *DatabasePrincipalAssignment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databasePrincipalProperties DatabasePrincipalProperties
				err = json.Unmarshal(*v, &databasePrincipalProperties)
				if err != nil {
					return err
				}
				dpa.DatabasePrincipalProperties = &databasePrincipalProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dpa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dpa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dpa.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabasePrincipalAssignmentCheckNameRequest a principal assignment check name availability request.
type DatabasePrincipalAssignmentCheckNameRequest struct {
	// Name - Principal Assignment resource name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, Microsoft.Kusto/clusters/databases/principalAssignments.
	Type *string `json:"type,omitempty"`
}

// DatabasePrincipalAssignmentListResult the list Kusto database principal assignments operation response.
type DatabasePrincipalAssignmentListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto database principal assignments.
	Value *[]DatabasePrincipalAssignment `json:"value,omitempty"`
}

// DatabasePrincipalAssignmentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabasePrincipalAssignmentsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasePrincipalAssignmentsClient) (DatabasePrincipalAssignment, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasePrincipalAssignmentsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasePrincipalAssignmentsCreateOrUpdateFuture.Result.
func (future *DatabasePrincipalAssignmentsCreateOrUpdateFuture) result(client DatabasePrincipalAssignmentsClient) (dpa DatabasePrincipalAssignment, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DatabasePrincipalAssignmentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dpa.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.DatabasePrincipalAssignmentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dpa.Response.Response, err = future.GetResult(sender); err == nil && dpa.Response.Response.StatusCode != http.StatusNoContent {
		dpa, err = client.CreateOrUpdateResponder(dpa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.DatabasePrincipalAssignmentsCreateOrUpdateFuture", "Result", dpa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasePrincipalAssignmentsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabasePrincipalAssignmentsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasePrincipalAssignmentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasePrincipalAssignmentsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasePrincipalAssignmentsDeleteFuture.Result.
func (future *DatabasePrincipalAssignmentsDeleteFuture) result(client DatabasePrincipalAssignmentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DatabasePrincipalAssignmentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.DatabasePrincipalAssignmentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabasePrincipalListRequest the list Kusto database principals operation request.
type DatabasePrincipalListRequest struct {
	// Value - The list of Kusto database principals.
	Value *[]DatabasePrincipal `json:"value,omitempty"`
}

// DatabasePrincipalListResult the list Kusto database principals operation response.
type DatabasePrincipalListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto database principals.
	Value *[]DatabasePrincipal `json:"value,omitempty"`
}

// DatabasePrincipalProperties a class representing database principal property.
type DatabasePrincipalProperties struct {
	// PrincipalID - The principal ID assigned to the database principal. It can be a user email, application ID, or security group name.
	PrincipalID *string `json:"principalId,omitempty"`
	// Role - Database principal role. Possible values include: 'DatabasePrincipalRoleAdmin', 'DatabasePrincipalRoleIngestor', 'DatabasePrincipalRoleMonitor', 'DatabasePrincipalRoleUser', 'DatabasePrincipalRoleUnrestrictedViewer', 'DatabasePrincipalRoleViewer'
	Role DatabasePrincipalRole `json:"role,omitempty"`
	// TenantID - The tenant id of the principal
	TenantID *string `json:"tenantId,omitempty"`
	// PrincipalType - Principal type. Possible values include: 'PrincipalTypeApp', 'PrincipalTypeGroup', 'PrincipalTypeUser'
	PrincipalType PrincipalType `json:"principalType,omitempty"`
	// TenantName - READ-ONLY; The tenant name of the principal
	TenantName *string `json:"tenantName,omitempty"`
	// PrincipalName - READ-ONLY; The principal name
	PrincipalName *string `json:"principalName,omitempty"`
	// ProvisioningState - The provisioned state of the resource. Possible values include: 'ProvisioningStateRunning', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateMoving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabasePrincipalProperties.
func (dpp DatabasePrincipalProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dpp.PrincipalID != nil {
		objectMap["principalId"] = dpp.PrincipalID
	}
	if dpp.Role != "" {
		objectMap["role"] = dpp.Role
	}
	if dpp.TenantID != nil {
		objectMap["tenantId"] = dpp.TenantID
	}
	if dpp.PrincipalType != "" {
		objectMap["principalType"] = dpp.PrincipalType
	}
	if dpp.ProvisioningState != "" {
		objectMap["provisioningState"] = dpp.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// DatabasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (DatabaseModel, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesCreateOrUpdateFuture.Result.
func (future *DatabasesCreateOrUpdateFuture) result(client DatabasesClient) (dm DatabaseModel, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DatabasesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dm.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.DatabasesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dm.Response.Response, err = future.GetResult(sender); err == nil && dm.Response.Response.StatusCode != http.StatusNoContent {
		dm, err = client.CreateOrUpdateResponder(dm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.DatabasesCreateOrUpdateFuture", "Result", dm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesDeleteFuture.Result.
func (future *DatabasesDeleteFuture) result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DatabasesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.DatabasesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseStatistics a class that contains database statistics information.
type DatabaseStatistics struct {
	// Size - The database size - the total size of compressed data and index in bytes.
	Size *float64 `json:"size,omitempty"`
}

// DatabasesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (DatabaseModel, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesUpdateFuture.Result.
func (future *DatabasesUpdateFuture) result(client DatabasesClient) (dm DatabaseModel, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DatabasesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dm.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.DatabasesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dm.Response.Response, err = future.GetResult(sender); err == nil && dm.Response.Response.StatusCode != http.StatusNoContent {
		dm, err = client.UpdateResponder(dm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.DatabasesUpdateFuture", "Result", dm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BasicDataConnection class representing an data connection.
type BasicDataConnection interface {
	AsEventHubDataConnection() (*EventHubDataConnection, bool)
	AsIotHubDataConnection() (*IotHubDataConnection, bool)
	AsEventGridDataConnection() (*EventGridDataConnection, bool)
	AsDataConnection() (*DataConnection, bool)
}

// DataConnection class representing an data connection.
type DataConnection struct {
	autorest.Response `json:"-"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectionKindDataConnection', 'KindBasicDataConnectionKindEventHub', 'KindBasicDataConnectionKindIotHub', 'KindBasicDataConnectionKindEventGrid'
	Kind KindBasicDataConnection `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

func unmarshalBasicDataConnection(body []byte) (BasicDataConnection, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicDataConnectionKindEventHub):
		var ehdc EventHubDataConnection
		err := json.Unmarshal(body, &ehdc)
		return ehdc, err
	case string(KindBasicDataConnectionKindIotHub):
		var ihdc IotHubDataConnection
		err := json.Unmarshal(body, &ihdc)
		return ihdc, err
	case string(KindBasicDataConnectionKindEventGrid):
		var egdc EventGridDataConnection
		err := json.Unmarshal(body, &egdc)
		return egdc, err
	default:
		var dc DataConnection
		err := json.Unmarshal(body, &dc)
		return dc, err
	}
}
func unmarshalBasicDataConnectionArray(body []byte) ([]BasicDataConnection, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dcArray := make([]BasicDataConnection, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dc, err := unmarshalBasicDataConnection(*rawMessage)
		if err != nil {
			return nil, err
		}
		dcArray[index] = dc
	}
	return dcArray, nil
}

// MarshalJSON is the custom marshaler for DataConnection.
func (dc DataConnection) MarshalJSON() ([]byte, error) {
	dc.Kind = KindBasicDataConnectionKindDataConnection
	objectMap := make(map[string]interface{})
	if dc.Location != nil {
		objectMap["location"] = dc.Location
	}
	if dc.Kind != "" {
		objectMap["kind"] = dc.Kind
	}
	return json.Marshal(objectMap)
}

// AsEventHubDataConnection is the BasicDataConnection implementation for DataConnection.
func (dc DataConnection) AsEventHubDataConnection() (*EventHubDataConnection, bool) {
	return nil, false
}

// AsIotHubDataConnection is the BasicDataConnection implementation for DataConnection.
func (dc DataConnection) AsIotHubDataConnection() (*IotHubDataConnection, bool) {
	return nil, false
}

// AsEventGridDataConnection is the BasicDataConnection implementation for DataConnection.
func (dc DataConnection) AsEventGridDataConnection() (*EventGridDataConnection, bool) {
	return nil, false
}

// AsDataConnection is the BasicDataConnection implementation for DataConnection.
func (dc DataConnection) AsDataConnection() (*DataConnection, bool) {
	return &dc, true
}

// AsBasicDataConnection is the BasicDataConnection implementation for DataConnection.
func (dc DataConnection) AsBasicDataConnection() (BasicDataConnection, bool) {
	return &dc, true
}

// DataConnectionCheckNameRequest a data connection check name availability request.
type DataConnectionCheckNameRequest struct {
	// Name - Data Connection name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, Microsoft.Kusto/clusters/databases/dataConnections.
	Type *string `json:"type,omitempty"`
}

// DataConnectionListResult the list Kusto data connections operation response.
type DataConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto data connections.
	Value *[]BasicDataConnection `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataConnectionListResult struct.
func (dclr *DataConnectionListResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicDataConnectionArray(*v)
				if err != nil {
					return err
				}
				dclr.Value = &value
			}
		}
	}

	return nil
}

// DataConnectionModel ...
type DataConnectionModel struct {
	autorest.Response `json:"-"`
	Value             BasicDataConnection `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataConnectionModel struct.
func (dcm *DataConnectionModel) UnmarshalJSON(body []byte) error {
	dc, err := unmarshalBasicDataConnection(body)
	if err != nil {
		return err
	}
	dcm.Value = dc

	return nil
}

// DataConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DataConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DataConnectionsClient) (DataConnectionModel, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DataConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DataConnectionsCreateOrUpdateFuture.Result.
func (future *DataConnectionsCreateOrUpdateFuture) result(client DataConnectionsClient) (dcm DataConnectionModel, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DataConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dcm.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.DataConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dcm.Response.Response, err = future.GetResult(sender); err == nil && dcm.Response.Response.StatusCode != http.StatusNoContent {
		dcm, err = client.CreateOrUpdateResponder(dcm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.DataConnectionsCreateOrUpdateFuture", "Result", dcm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DataConnectionsDataConnectionValidationMethodFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DataConnectionsDataConnectionValidationMethodFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DataConnectionsClient) (DataConnectionValidationListResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DataConnectionsDataConnectionValidationMethodFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DataConnectionsDataConnectionValidationMethodFuture.Result.
func (future *DataConnectionsDataConnectionValidationMethodFuture) result(client DataConnectionsClient) (dcvlr DataConnectionValidationListResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DataConnectionsDataConnectionValidationMethodFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dcvlr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.DataConnectionsDataConnectionValidationMethodFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dcvlr.Response.Response, err = future.GetResult(sender); err == nil && dcvlr.Response.Response.StatusCode != http.StatusNoContent {
		dcvlr, err = client.DataConnectionValidationMethodResponder(dcvlr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.DataConnectionsDataConnectionValidationMethodFuture", "Result", dcvlr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DataConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DataConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DataConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DataConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DataConnectionsDeleteFuture.Result.
func (future *DataConnectionsDeleteFuture) result(client DataConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DataConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.DataConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DataConnectionsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DataConnectionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DataConnectionsClient) (DataConnectionModel, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DataConnectionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DataConnectionsUpdateFuture.Result.
func (future *DataConnectionsUpdateFuture) result(client DataConnectionsClient) (dcm DataConnectionModel, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.DataConnectionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dcm.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.DataConnectionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dcm.Response.Response, err = future.GetResult(sender); err == nil && dcm.Response.Response.StatusCode != http.StatusNoContent {
		dcm, err = client.UpdateResponder(dcm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.DataConnectionsUpdateFuture", "Result", dcm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DataConnectionValidation class representing an data connection validation.
type DataConnectionValidation struct {
	// DataConnectionName - The name of the data connection.
	DataConnectionName *string `json:"dataConnectionName,omitempty"`
	// Properties - The data connection properties to validate.
	Properties BasicDataConnection `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataConnectionValidation struct.
func (dcv *DataConnectionValidation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "dataConnectionName":
			if v != nil {
				var dataConnectionName string
				err = json.Unmarshal(*v, &dataConnectionName)
				if err != nil {
					return err
				}
				dcv.DataConnectionName = &dataConnectionName
			}
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicDataConnection(*v)
				if err != nil {
					return err
				}
				dcv.Properties = properties
			}
		}
	}

	return nil
}

// DataConnectionValidationListResult the list Kusto data connection validation result.
type DataConnectionValidationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto data connection validation errors.
	Value *[]DataConnectionValidationResult `json:"value,omitempty"`
}

// DataConnectionValidationResult the result returned from a data connection validation request.
type DataConnectionValidationResult struct {
	// ErrorMessage - A message which indicates a problem in data connection validation.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// DiagnoseVirtualNetworkResult ...
type DiagnoseVirtualNetworkResult struct {
	autorest.Response `json:"-"`
	// Findings - The list of network connectivity diagnostic finding
	Findings *[]string `json:"findings,omitempty"`
}

// EventGridConnectionProperties class representing the Kusto event grid connection properties.
type EventGridConnectionProperties struct {
	// StorageAccountResourceID - The resource ID of the storage account where the data resides.
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`
	// EventHubResourceID - The resource ID where the event grid is configured to send events.
	EventHubResourceID *string `json:"eventHubResourceId,omitempty"`
	// ConsumerGroup - The event hub consumer group.
	ConsumerGroup *string `json:"consumerGroup,omitempty"`
	// TableName - The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string `json:"tableName,omitempty"`
	// MappingRuleName - The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string `json:"mappingRuleName,omitempty"`
	// DataFormat - The data format of the message. Optionally the data format can be added to each message. Possible values include: 'EventGridDataFormatMULTIJSON', 'EventGridDataFormatJSON', 'EventGridDataFormatCSV', 'EventGridDataFormatTSV', 'EventGridDataFormatSCSV', 'EventGridDataFormatSOHSV', 'EventGridDataFormatPSV', 'EventGridDataFormatTXT', 'EventGridDataFormatRAW', 'EventGridDataFormatSINGLEJSON', 'EventGridDataFormatAVRO', 'EventGridDataFormatTSVE', 'EventGridDataFormatPARQUET', 'EventGridDataFormatORC', 'EventGridDataFormatAPACHEAVRO', 'EventGridDataFormatW3CLOGFILE'
	DataFormat EventGridDataFormat `json:"dataFormat,omitempty"`
	// IgnoreFirstRecord - A Boolean value that, if set to true, indicates that ingestion should ignore the first record of every file
	IgnoreFirstRecord *bool `json:"ignoreFirstRecord,omitempty"`
	// BlobStorageEventType - The name of blob storage event type to process. Possible values include: 'BlobStorageEventTypeMicrosoftStorageBlobCreated', 'BlobStorageEventTypeMicrosoftStorageBlobRenamed'
	BlobStorageEventType BlobStorageEventType `json:"blobStorageEventType,omitempty"`
	// ProvisioningState - The provisioned state of the resource. Possible values include: 'ProvisioningStateRunning', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateMoving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// EventGridDataConnection class representing an Event Grid data connection.
type EventGridDataConnection struct {
	// EventGridConnectionProperties - The properties of the Event Grid data connection.
	*EventGridConnectionProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectionKindDataConnection', 'KindBasicDataConnectionKindEventHub', 'KindBasicDataConnectionKindIotHub', 'KindBasicDataConnectionKindEventGrid'
	Kind KindBasicDataConnection `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventGridDataConnection.
func (egdc EventGridDataConnection) MarshalJSON() ([]byte, error) {
	egdc.Kind = KindBasicDataConnectionKindEventGrid
	objectMap := make(map[string]interface{})
	if egdc.EventGridConnectionProperties != nil {
		objectMap["properties"] = egdc.EventGridConnectionProperties
	}
	if egdc.Location != nil {
		objectMap["location"] = egdc.Location
	}
	if egdc.Kind != "" {
		objectMap["kind"] = egdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsEventHubDataConnection is the BasicDataConnection implementation for EventGridDataConnection.
func (egdc EventGridDataConnection) AsEventHubDataConnection() (*EventHubDataConnection, bool) {
	return nil, false
}

// AsIotHubDataConnection is the BasicDataConnection implementation for EventGridDataConnection.
func (egdc EventGridDataConnection) AsIotHubDataConnection() (*IotHubDataConnection, bool) {
	return nil, false
}

// AsEventGridDataConnection is the BasicDataConnection implementation for EventGridDataConnection.
func (egdc EventGridDataConnection) AsEventGridDataConnection() (*EventGridDataConnection, bool) {
	return &egdc, true
}

// AsDataConnection is the BasicDataConnection implementation for EventGridDataConnection.
func (egdc EventGridDataConnection) AsDataConnection() (*DataConnection, bool) {
	return nil, false
}

// AsBasicDataConnection is the BasicDataConnection implementation for EventGridDataConnection.
func (egdc EventGridDataConnection) AsBasicDataConnection() (BasicDataConnection, bool) {
	return &egdc, true
}

// UnmarshalJSON is the custom unmarshaler for EventGridDataConnection struct.
func (egdc *EventGridDataConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventGridConnectionProperties EventGridConnectionProperties
				err = json.Unmarshal(*v, &eventGridConnectionProperties)
				if err != nil {
					return err
				}
				egdc.EventGridConnectionProperties = &eventGridConnectionProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				egdc.Location = &location
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnection
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				egdc.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				egdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				egdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				egdc.Type = &typeVar
			}
		}
	}

	return nil
}

// EventHubConnectionProperties class representing the Kusto event hub connection properties.
type EventHubConnectionProperties struct {
	// EventHubResourceID - The resource ID of the event hub to be used to create a data connection.
	EventHubResourceID *string `json:"eventHubResourceId,omitempty"`
	// ConsumerGroup - The event hub consumer group.
	ConsumerGroup *string `json:"consumerGroup,omitempty"`
	// TableName - The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string `json:"tableName,omitempty"`
	// MappingRuleName - The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string `json:"mappingRuleName,omitempty"`
	// DataFormat - The data format of the message. Optionally the data format can be added to each message. Possible values include: 'EventHubDataFormatMULTIJSON', 'EventHubDataFormatJSON', 'EventHubDataFormatCSV', 'EventHubDataFormatTSV', 'EventHubDataFormatSCSV', 'EventHubDataFormatSOHSV', 'EventHubDataFormatPSV', 'EventHubDataFormatTXT', 'EventHubDataFormatRAW', 'EventHubDataFormatSINGLEJSON', 'EventHubDataFormatAVRO', 'EventHubDataFormatTSVE', 'EventHubDataFormatPARQUET', 'EventHubDataFormatORC', 'EventHubDataFormatAPACHEAVRO', 'EventHubDataFormatW3CLOGFILE'
	DataFormat EventHubDataFormat `json:"dataFormat,omitempty"`
	// EventSystemProperties - System properties of the event hub
	EventSystemProperties *[]string `json:"eventSystemProperties,omitempty"`
	// Compression - The event hub messages compression type. Possible values include: 'CompressionNone', 'CompressionGZip'
	Compression Compression `json:"compression,omitempty"`
	// ProvisioningState - The provisioned state of the resource. Possible values include: 'ProvisioningStateRunning', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateMoving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ManagedIdentityResourceID - The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub.
	ManagedIdentityResourceID *string `json:"managedIdentityResourceId,omitempty"`
}

// EventHubDataConnection class representing an event hub data connection.
type EventHubDataConnection struct {
	// EventHubConnectionProperties - The Event Hub data connection properties to validate.
	*EventHubConnectionProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectionKindDataConnection', 'KindBasicDataConnectionKindEventHub', 'KindBasicDataConnectionKindIotHub', 'KindBasicDataConnectionKindEventGrid'
	Kind KindBasicDataConnection `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubDataConnection.
func (ehdc EventHubDataConnection) MarshalJSON() ([]byte, error) {
	ehdc.Kind = KindBasicDataConnectionKindEventHub
	objectMap := make(map[string]interface{})
	if ehdc.EventHubConnectionProperties != nil {
		objectMap["properties"] = ehdc.EventHubConnectionProperties
	}
	if ehdc.Location != nil {
		objectMap["location"] = ehdc.Location
	}
	if ehdc.Kind != "" {
		objectMap["kind"] = ehdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsEventHubDataConnection is the BasicDataConnection implementation for EventHubDataConnection.
func (ehdc EventHubDataConnection) AsEventHubDataConnection() (*EventHubDataConnection, bool) {
	return &ehdc, true
}

// AsIotHubDataConnection is the BasicDataConnection implementation for EventHubDataConnection.
func (ehdc EventHubDataConnection) AsIotHubDataConnection() (*IotHubDataConnection, bool) {
	return nil, false
}

// AsEventGridDataConnection is the BasicDataConnection implementation for EventHubDataConnection.
func (ehdc EventHubDataConnection) AsEventGridDataConnection() (*EventGridDataConnection, bool) {
	return nil, false
}

// AsDataConnection is the BasicDataConnection implementation for EventHubDataConnection.
func (ehdc EventHubDataConnection) AsDataConnection() (*DataConnection, bool) {
	return nil, false
}

// AsBasicDataConnection is the BasicDataConnection implementation for EventHubDataConnection.
func (ehdc EventHubDataConnection) AsBasicDataConnection() (BasicDataConnection, bool) {
	return &ehdc, true
}

// UnmarshalJSON is the custom unmarshaler for EventHubDataConnection struct.
func (ehdc *EventHubDataConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventHubConnectionProperties EventHubConnectionProperties
				err = json.Unmarshal(*v, &eventHubConnectionProperties)
				if err != nil {
					return err
				}
				ehdc.EventHubConnectionProperties = &eventHubConnectionProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ehdc.Location = &location
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnection
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ehdc.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ehdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ehdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ehdc.Type = &typeVar
			}
		}
	}

	return nil
}

// FollowerDatabaseDefinition a class representing follower database request.
type FollowerDatabaseDefinition struct {
	// ClusterResourceID - Resource id of the cluster that follows a database owned by this cluster.
	ClusterResourceID *string `json:"clusterResourceId,omitempty"`
	// AttachedDatabaseConfigurationName - Resource name of the attached database configuration in the follower cluster.
	AttachedDatabaseConfigurationName *string `json:"attachedDatabaseConfigurationName,omitempty"`
	// DatabaseName - READ-ONLY; The database name owned by this cluster that was followed. * in case following all databases.
	DatabaseName *string `json:"databaseName,omitempty"`
}

// MarshalJSON is the custom marshaler for FollowerDatabaseDefinition.
func (fdd FollowerDatabaseDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fdd.ClusterResourceID != nil {
		objectMap["clusterResourceId"] = fdd.ClusterResourceID
	}
	if fdd.AttachedDatabaseConfigurationName != nil {
		objectMap["attachedDatabaseConfigurationName"] = fdd.AttachedDatabaseConfigurationName
	}
	return json.Marshal(objectMap)
}

// FollowerDatabaseListResult the list Kusto database principals operation response.
type FollowerDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of follower database result.
	Value *[]FollowerDatabaseDefinition `json:"value,omitempty"`
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove all identities. Possible values include: 'IdentityTypeNone', 'IdentityTypeSystemAssigned', 'IdentityTypeUserAssigned', 'IdentityTypeSystemAssignedUserAssigned'
	Type IdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with the Kusto cluster. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*IdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	if i.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = i.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// IdentityUserAssignedIdentitiesValue ...
type IdentityUserAssignedIdentitiesValue struct {
	// PrincipalID - READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// IotHubConnectionProperties class representing the Kusto Iot hub connection properties.
type IotHubConnectionProperties struct {
	// IotHubResourceID - The resource ID of the Iot hub to be used to create a data connection.
	IotHubResourceID *string `json:"iotHubResourceId,omitempty"`
	// ConsumerGroup - The iot hub consumer group.
	ConsumerGroup *string `json:"consumerGroup,omitempty"`
	// TableName - The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string `json:"tableName,omitempty"`
	// MappingRuleName - The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string `json:"mappingRuleName,omitempty"`
	// DataFormat - The data format of the message. Optionally the data format can be added to each message. Possible values include: 'IotHubDataFormatMULTIJSON', 'IotHubDataFormatJSON', 'IotHubDataFormatCSV', 'IotHubDataFormatTSV', 'IotHubDataFormatSCSV', 'IotHubDataFormatSOHSV', 'IotHubDataFormatPSV', 'IotHubDataFormatTXT', 'IotHubDataFormatRAW', 'IotHubDataFormatSINGLEJSON', 'IotHubDataFormatAVRO', 'IotHubDataFormatTSVE', 'IotHubDataFormatPARQUET', 'IotHubDataFormatORC', 'IotHubDataFormatAPACHEAVRO', 'IotHubDataFormatW3CLOGFILE'
	DataFormat IotHubDataFormat `json:"dataFormat,omitempty"`
	// EventSystemProperties - System properties of the iot hub
	EventSystemProperties *[]string `json:"eventSystemProperties,omitempty"`
	// SharedAccessPolicyName - The name of the share access policy
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	// ProvisioningState - The provisioned state of the resource. Possible values include: 'ProvisioningStateRunning', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateMoving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// IotHubDataConnection class representing an iot hub data connection.
type IotHubDataConnection struct {
	// IotHubConnectionProperties - The Iot Hub data connection properties.
	*IotHubConnectionProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectionKindDataConnection', 'KindBasicDataConnectionKindEventHub', 'KindBasicDataConnectionKindIotHub', 'KindBasicDataConnectionKindEventGrid'
	Kind KindBasicDataConnection `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IotHubDataConnection.
func (ihdc IotHubDataConnection) MarshalJSON() ([]byte, error) {
	ihdc.Kind = KindBasicDataConnectionKindIotHub
	objectMap := make(map[string]interface{})
	if ihdc.IotHubConnectionProperties != nil {
		objectMap["properties"] = ihdc.IotHubConnectionProperties
	}
	if ihdc.Location != nil {
		objectMap["location"] = ihdc.Location
	}
	if ihdc.Kind != "" {
		objectMap["kind"] = ihdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsEventHubDataConnection is the BasicDataConnection implementation for IotHubDataConnection.
func (ihdc IotHubDataConnection) AsEventHubDataConnection() (*EventHubDataConnection, bool) {
	return nil, false
}

// AsIotHubDataConnection is the BasicDataConnection implementation for IotHubDataConnection.
func (ihdc IotHubDataConnection) AsIotHubDataConnection() (*IotHubDataConnection, bool) {
	return &ihdc, true
}

// AsEventGridDataConnection is the BasicDataConnection implementation for IotHubDataConnection.
func (ihdc IotHubDataConnection) AsEventGridDataConnection() (*EventGridDataConnection, bool) {
	return nil, false
}

// AsDataConnection is the BasicDataConnection implementation for IotHubDataConnection.
func (ihdc IotHubDataConnection) AsDataConnection() (*DataConnection, bool) {
	return nil, false
}

// AsBasicDataConnection is the BasicDataConnection implementation for IotHubDataConnection.
func (ihdc IotHubDataConnection) AsBasicDataConnection() (BasicDataConnection, bool) {
	return &ihdc, true
}

// UnmarshalJSON is the custom unmarshaler for IotHubDataConnection struct.
func (ihdc *IotHubDataConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var iotHubConnectionProperties IotHubConnectionProperties
				err = json.Unmarshal(*v, &iotHubConnectionProperties)
				if err != nil {
					return err
				}
				ihdc.IotHubConnectionProperties = &iotHubConnectionProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ihdc.Location = &location
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnection
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ihdc.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ihdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ihdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ihdc.Type = &typeVar
			}
		}
	}

	return nil
}

// KeyVaultProperties properties of the key vault.
type KeyVaultProperties struct {
	// KeyName - The name of the key vault key.
	KeyName *string `json:"keyName,omitempty"`
	// KeyVersion - The version of the key vault key.
	KeyVersion *string `json:"keyVersion,omitempty"`
	// KeyVaultURI - The Uri of the key vault.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`
	// UserIdentity - The user assigned identity (ARM resource id) that has access to the key.
	UserIdentity *string `json:"userIdentity,omitempty"`
}

// LanguageExtension the language extension object.
type LanguageExtension struct {
	// LanguageExtensionName - The language extension name. Possible values include: 'LanguageExtensionNamePYTHON', 'LanguageExtensionNameR'
	LanguageExtensionName LanguageExtensionName `json:"languageExtensionName,omitempty"`
}

// LanguageExtensionsList the list of language extension objects.
type LanguageExtensionsList struct {
	autorest.Response `json:"-"`
	// Value - The list of language extensions.
	Value *[]LanguageExtension `json:"value,omitempty"`
}

// ListResourceSkusResult list of available SKUs for a Kusto Cluster.
type ListResourceSkusResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of available SKUs for an existing resource.
	Value *[]AzureResourceSku `json:"value,omitempty"`
}

// Operation ...
type Operation struct {
	// Name - This is of the format {provider}/{resource}/{operation}.
	Name       *string           `json:"name,omitempty"`
	Display    *OperationDisplay `json:"display,omitempty"`
	Origin     *string           `json:"origin,omitempty"`
	Properties interface{}       `json:"properties,omitempty"`
}

// OperationDisplay ...
type OperationDisplay struct {
	Provider *string `json:"provider,omitempty"`
	// Operation - For example: read, write, delete.
	Operation   *string `json:"operation,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Description *string `json:"description,omitempty"`
}

// OperationListResult ...
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationResult operation Result Entity.
type OperationResult struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty"`
	// Status - status of the Operation result. Possible values include: 'StatusSucceeded', 'StatusCanceled', 'StatusFailed', 'StatusRunning'
	Status Status `json:"status,omitempty"`
	// StartTime - The operation start time
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The operation end time
	EndTime *date.Time `json:"endTime,omitempty"`
	// PercentComplete - Percentage completed.
	PercentComplete *float64 `json:"percentComplete,omitempty"`
	// OperationResultProperties - Properties of the operation results
	*OperationResultProperties `json:"properties,omitempty"`
	// OperationResultErrorProperties - Object that contains the error code and message if the operation failed.
	*OperationResultErrorProperties `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationResult.
func (or OperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if or.Status != "" {
		objectMap["status"] = or.Status
	}
	if or.StartTime != nil {
		objectMap["startTime"] = or.StartTime
	}
	if or.EndTime != nil {
		objectMap["endTime"] = or.EndTime
	}
	if or.PercentComplete != nil {
		objectMap["percentComplete"] = or.PercentComplete
	}
	if or.OperationResultProperties != nil {
		objectMap["properties"] = or.OperationResultProperties
	}
	if or.OperationResultErrorProperties != nil {
		objectMap["error"] = or.OperationResultErrorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OperationResult struct.
func (or *OperationResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				or.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				or.Name = &name
			}
		case "status":
			if v != nil {
				var status Status
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				or.Status = status
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				or.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				or.EndTime = &endTime
			}
		case "percentComplete":
			if v != nil {
				var percentComplete float64
				err = json.Unmarshal(*v, &percentComplete)
				if err != nil {
					return err
				}
				or.PercentComplete = &percentComplete
			}
		case "properties":
			if v != nil {
				var operationResultProperties OperationResultProperties
				err = json.Unmarshal(*v, &operationResultProperties)
				if err != nil {
					return err
				}
				or.OperationResultProperties = &operationResultProperties
			}
		case "error":
			if v != nil {
				var operationResultErrorProperties OperationResultErrorProperties
				err = json.Unmarshal(*v, &operationResultErrorProperties)
				if err != nil {
					return err
				}
				or.OperationResultErrorProperties = &operationResultErrorProperties
			}
		}
	}

	return nil
}

// OperationResultErrorProperties operation result error properties
type OperationResultErrorProperties struct {
	// Code - The code of the error.
	Code *string `json:"code,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
}

// OperationResultProperties operation result properties
type OperationResultProperties struct {
	// OperationKind - The kind of the operation.
	OperationKind *string `json:"operationKind,omitempty"`
	// OperationState - The state of the operation.
	OperationState *string `json:"operationState,omitempty"`
}

// OptimizedAutoscale a class that contains the optimized auto scale definition.
type OptimizedAutoscale struct {
	// Version - The version of the template defined, for instance 1.
	Version *int32 `json:"version,omitempty"`
	// IsEnabled - A boolean value that indicate if the optimized autoscale feature is enabled or not.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// Minimum - Minimum allowed instances count.
	Minimum *int32 `json:"minimum,omitempty"`
	// Maximum - Maximum allowed instances count.
	Maximum *int32 `json:"maximum,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// ReadOnlyFollowingDatabase class representing a read only following database.
type ReadOnlyFollowingDatabase struct {
	// ReadOnlyFollowingDatabaseProperties - The database properties.
	*ReadOnlyFollowingDatabaseProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindKindDatabase', 'KindKindReadWrite', 'KindKindReadOnlyFollowing'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ReadOnlyFollowingDatabase.
func (rofd ReadOnlyFollowingDatabase) MarshalJSON() ([]byte, error) {
	rofd.Kind = KindKindReadOnlyFollowing
	objectMap := make(map[string]interface{})
	if rofd.ReadOnlyFollowingDatabaseProperties != nil {
		objectMap["properties"] = rofd.ReadOnlyFollowingDatabaseProperties
	}
	if rofd.Location != nil {
		objectMap["location"] = rofd.Location
	}
	if rofd.Kind != "" {
		objectMap["kind"] = rofd.Kind
	}
	return json.Marshal(objectMap)
}

// AsReadWriteDatabase is the BasicDatabase implementation for ReadOnlyFollowingDatabase.
func (rofd ReadOnlyFollowingDatabase) AsReadWriteDatabase() (*ReadWriteDatabase, bool) {
	return nil, false
}

// AsReadOnlyFollowingDatabase is the BasicDatabase implementation for ReadOnlyFollowingDatabase.
func (rofd ReadOnlyFollowingDatabase) AsReadOnlyFollowingDatabase() (*ReadOnlyFollowingDatabase, bool) {
	return &rofd, true
}

// AsDatabase is the BasicDatabase implementation for ReadOnlyFollowingDatabase.
func (rofd ReadOnlyFollowingDatabase) AsDatabase() (*Database, bool) {
	return nil, false
}

// AsBasicDatabase is the BasicDatabase implementation for ReadOnlyFollowingDatabase.
func (rofd ReadOnlyFollowingDatabase) AsBasicDatabase() (BasicDatabase, bool) {
	return &rofd, true
}

// UnmarshalJSON is the custom unmarshaler for ReadOnlyFollowingDatabase struct.
func (rofd *ReadOnlyFollowingDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var readOnlyFollowingDatabaseProperties ReadOnlyFollowingDatabaseProperties
				err = json.Unmarshal(*v, &readOnlyFollowingDatabaseProperties)
				if err != nil {
					return err
				}
				rofd.ReadOnlyFollowingDatabaseProperties = &readOnlyFollowingDatabaseProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rofd.Location = &location
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rofd.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rofd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rofd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rofd.Type = &typeVar
			}
		}
	}

	return nil
}

// ReadOnlyFollowingDatabaseProperties class representing the Kusto database properties.
type ReadOnlyFollowingDatabaseProperties struct {
	// ProvisioningState - The provisioned state of the resource. Possible values include: 'ProvisioningStateRunning', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateMoving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// SoftDeletePeriod - READ-ONLY; The time the data should be kept before it stops being accessible to queries in TimeSpan.
	SoftDeletePeriod *string `json:"softDeletePeriod,omitempty"`
	// HotCachePeriod - The time the data should be kept in cache for fast queries in TimeSpan.
	HotCachePeriod *string `json:"hotCachePeriod,omitempty"`
	// Statistics - The statistics of the database.
	Statistics *DatabaseStatistics `json:"statistics,omitempty"`
	// LeaderClusterResourceID - READ-ONLY; The name of the leader cluster
	LeaderClusterResourceID *string `json:"leaderClusterResourceId,omitempty"`
	// AttachedDatabaseConfigurationName - READ-ONLY; The name of the attached database configuration cluster
	AttachedDatabaseConfigurationName *string `json:"attachedDatabaseConfigurationName,omitempty"`
	// PrincipalsModificationKind - READ-ONLY; The principals modification kind of the database. Possible values include: 'PrincipalsModificationKindUnion', 'PrincipalsModificationKindReplace', 'PrincipalsModificationKindNone'
	PrincipalsModificationKind PrincipalsModificationKind `json:"principalsModificationKind,omitempty"`
}

// MarshalJSON is the custom marshaler for ReadOnlyFollowingDatabaseProperties.
func (rofdp ReadOnlyFollowingDatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rofdp.ProvisioningState != "" {
		objectMap["provisioningState"] = rofdp.ProvisioningState
	}
	if rofdp.HotCachePeriod != nil {
		objectMap["hotCachePeriod"] = rofdp.HotCachePeriod
	}
	if rofdp.Statistics != nil {
		objectMap["statistics"] = rofdp.Statistics
	}
	return json.Marshal(objectMap)
}

// ReadWriteDatabase class representing a read write database.
type ReadWriteDatabase struct {
	// ReadWriteDatabaseProperties - The database properties.
	*ReadWriteDatabaseProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindKindDatabase', 'KindKindReadWrite', 'KindKindReadOnlyFollowing'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ReadWriteDatabase.
func (rwd ReadWriteDatabase) MarshalJSON() ([]byte, error) {
	rwd.Kind = KindKindReadWrite
	objectMap := make(map[string]interface{})
	if rwd.ReadWriteDatabaseProperties != nil {
		objectMap["properties"] = rwd.ReadWriteDatabaseProperties
	}
	if rwd.Location != nil {
		objectMap["location"] = rwd.Location
	}
	if rwd.Kind != "" {
		objectMap["kind"] = rwd.Kind
	}
	return json.Marshal(objectMap)
}

// AsReadWriteDatabase is the BasicDatabase implementation for ReadWriteDatabase.
func (rwd ReadWriteDatabase) AsReadWriteDatabase() (*ReadWriteDatabase, bool) {
	return &rwd, true
}

// AsReadOnlyFollowingDatabase is the BasicDatabase implementation for ReadWriteDatabase.
func (rwd ReadWriteDatabase) AsReadOnlyFollowingDatabase() (*ReadOnlyFollowingDatabase, bool) {
	return nil, false
}

// AsDatabase is the BasicDatabase implementation for ReadWriteDatabase.
func (rwd ReadWriteDatabase) AsDatabase() (*Database, bool) {
	return nil, false
}

// AsBasicDatabase is the BasicDatabase implementation for ReadWriteDatabase.
func (rwd ReadWriteDatabase) AsBasicDatabase() (BasicDatabase, bool) {
	return &rwd, true
}

// UnmarshalJSON is the custom unmarshaler for ReadWriteDatabase struct.
func (rwd *ReadWriteDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var readWriteDatabaseProperties ReadWriteDatabaseProperties
				err = json.Unmarshal(*v, &readWriteDatabaseProperties)
				if err != nil {
					return err
				}
				rwd.ReadWriteDatabaseProperties = &readWriteDatabaseProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rwd.Location = &location
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rwd.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rwd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rwd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rwd.Type = &typeVar
			}
		}
	}

	return nil
}

// ReadWriteDatabaseProperties class representing the Kusto database properties.
type ReadWriteDatabaseProperties struct {
	// ProvisioningState - The provisioned state of the resource. Possible values include: 'ProvisioningStateRunning', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateMoving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// SoftDeletePeriod - The time the data should be kept before it stops being accessible to queries in TimeSpan.
	SoftDeletePeriod *string `json:"softDeletePeriod,omitempty"`
	// HotCachePeriod - The time the data should be kept in cache for fast queries in TimeSpan.
	HotCachePeriod *string `json:"hotCachePeriod,omitempty"`
	// Statistics - The statistics of the database.
	Statistics *DatabaseStatistics `json:"statistics,omitempty"`
	// IsFollowed - READ-ONLY; Indicates whether the database is followed.
	IsFollowed *bool `json:"isFollowed,omitempty"`
}

// MarshalJSON is the custom marshaler for ReadWriteDatabaseProperties.
func (rwdp ReadWriteDatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rwdp.ProvisioningState != "" {
		objectMap["provisioningState"] = rwdp.ProvisioningState
	}
	if rwdp.SoftDeletePeriod != nil {
		objectMap["softDeletePeriod"] = rwdp.SoftDeletePeriod
	}
	if rwdp.HotCachePeriod != nil {
		objectMap["hotCachePeriod"] = rwdp.HotCachePeriod
	}
	if rwdp.Statistics != nil {
		objectMap["statistics"] = rwdp.Statistics
	}
	return json.Marshal(objectMap)
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// Script class representing a database script.
type Script struct {
	autorest.Response `json:"-"`
	// ScriptProperties - The database script.
	*ScriptProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Script.
func (s Script) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.ScriptProperties != nil {
		objectMap["properties"] = s.ScriptProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Script struct.
func (s *Script) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scriptProperties ScriptProperties
				err = json.Unmarshal(*v, &scriptProperties)
				if err != nil {
					return err
				}
				s.ScriptProperties = &scriptProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				s.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ScriptCheckNameRequest a script name availability request.
type ScriptCheckNameRequest struct {
	// Name - Script name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, Microsoft.Kusto/clusters/databases/scripts.
	Type *string `json:"type,omitempty"`
}

// ScriptListResult the list Kusto database script operation response.
type ScriptListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Kusto scripts.
	Value *[]Script `json:"value,omitempty"`
}

// ScriptProperties a class representing database script property.
type ScriptProperties struct {
	// ScriptURL - The url to the KQL script blob file.
	ScriptURL *string `json:"scriptUrl,omitempty"`
	// ScriptURLSasToken - The SaS token.
	ScriptURLSasToken *string `json:"scriptUrlSasToken,omitempty"`
	// ForceUpdateTag - A unique string. If changed the script will be applied again.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`
	// ContinueOnErrors - Flag that indicates whether to continue if one of the command fails.
	ContinueOnErrors *bool `json:"continueOnErrors,omitempty"`
	// ProvisioningState - The provisioned state of the resource. Possible values include: 'ProvisioningStateRunning', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateMoving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ScriptsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ScriptsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ScriptsClient) (Script, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ScriptsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ScriptsCreateOrUpdateFuture.Result.
func (future *ScriptsCreateOrUpdateFuture) result(client ScriptsClient) (s Script, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ScriptsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		s.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.ScriptsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.ScriptsCreateOrUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ScriptsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ScriptsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ScriptsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ScriptsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ScriptsDeleteFuture.Result.
func (future *ScriptsDeleteFuture) result(client ScriptsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ScriptsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.ScriptsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ScriptsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ScriptsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ScriptsClient) (Script, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ScriptsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ScriptsUpdateFuture.Result.
func (future *ScriptsUpdateFuture) result(client ScriptsClient) (s Script, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "kusto.ScriptsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		s.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("kusto.ScriptsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.UpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "kusto.ScriptsUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SkuDescription the Kusto SKU description of given resource type
type SkuDescription struct {
	// ResourceType - READ-ONLY; The resource type
	ResourceType *string `json:"resourceType,omitempty"`
	// Name - READ-ONLY; The name of the SKU
	Name *string `json:"name,omitempty"`
	// Tier - READ-ONLY; The tier of the SKU
	Tier *string `json:"tier,omitempty"`
	// Locations - READ-ONLY; The set of locations that the SKU is available
	Locations *[]string `json:"locations,omitempty"`
	// LocationInfo - READ-ONLY; Locations and zones
	LocationInfo *[]SkuLocationInfoItem `json:"locationInfo,omitempty"`
	// Restrictions - READ-ONLY; The restrictions because of which SKU cannot be used
	Restrictions *[]interface{} `json:"restrictions,omitempty"`
}

// SkuDescriptionList the list of the EngagementFabric SKU descriptions
type SkuDescriptionList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; SKU descriptions
	Value *[]SkuDescription `json:"value,omitempty"`
}

// SkuLocationInfoItem the locations and zones info for SKU.
type SkuLocationInfoItem struct {
	// Location - The available location of the SKU.
	Location *string `json:"location,omitempty"`
	// Zones - The available zone of the SKU.
	Zones *[]string `json:"zones,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TableLevelSharingProperties tables that will be included and excluded in the follower database
type TableLevelSharingProperties struct {
	// TablesToInclude - List of tables to include in the follower database
	TablesToInclude *[]string `json:"tablesToInclude,omitempty"`
	// TablesToExclude - List of tables to exclude from the follower database
	TablesToExclude *[]string `json:"tablesToExclude,omitempty"`
	// ExternalTablesToInclude - List of external tables to include in the follower database
	ExternalTablesToInclude *[]string `json:"externalTablesToInclude,omitempty"`
	// ExternalTablesToExclude - List of external tables exclude from the follower database
	ExternalTablesToExclude *[]string `json:"externalTablesToExclude,omitempty"`
	// MaterializedViewsToInclude - List of materialized views to include in the follower database
	MaterializedViewsToInclude *[]string `json:"materializedViewsToInclude,omitempty"`
	// MaterializedViewsToExclude - List of materialized views exclude from the follower database
	MaterializedViewsToExclude *[]string `json:"materializedViewsToExclude,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// TrustedExternalTenant represents a tenant ID that is trusted by the cluster.
type TrustedExternalTenant struct {
	// Value - GUID representing an external tenant.
	Value *string `json:"value,omitempty"`
}

// VirtualNetworkConfiguration a class that contains virtual network definition.
type VirtualNetworkConfiguration struct {
	// SubnetID - The subnet resource id.
	SubnetID *string `json:"subnetId,omitempty"`
	// EnginePublicIPID - Engine service's public IP address resource id.
	EnginePublicIPID *string `json:"enginePublicIpId,omitempty"`
	// DataManagementPublicIPID - Data management's service public IP address resource id.
	DataManagementPublicIPID *string `json:"dataManagementPublicIpId,omitempty"`
}
