package kusto

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AzureScaleType enumerates the values for azure scale type.
type AzureScaleType string

const (
	// AzureScaleTypeAutomatic ...
	AzureScaleTypeAutomatic AzureScaleType = "automatic"
	// AzureScaleTypeManual ...
	AzureScaleTypeManual AzureScaleType = "manual"
	// AzureScaleTypeNone ...
	AzureScaleTypeNone AzureScaleType = "none"
)

// PossibleAzureScaleTypeValues returns an array of possible values for the AzureScaleType const type.
func PossibleAzureScaleTypeValues() []AzureScaleType {
	return []AzureScaleType{AzureScaleTypeAutomatic, AzureScaleTypeManual, AzureScaleTypeNone}
}

// AzureSkuName enumerates the values for azure sku name.
type AzureSkuName string

const (
	// AzureSkuNameDevNoSLAStandardD11V2 ...
	AzureSkuNameDevNoSLAStandardD11V2 AzureSkuName = "Dev(No SLA)_Standard_D11_v2"
	// AzureSkuNameDevNoSLAStandardE2aV4 ...
	AzureSkuNameDevNoSLAStandardE2aV4 AzureSkuName = "Dev(No SLA)_Standard_E2a_v4"
	// AzureSkuNameStandardD11V2 ...
	AzureSkuNameStandardD11V2 AzureSkuName = "Standard_D11_v2"
	// AzureSkuNameStandardD12V2 ...
	AzureSkuNameStandardD12V2 AzureSkuName = "Standard_D12_v2"
	// AzureSkuNameStandardD13V2 ...
	AzureSkuNameStandardD13V2 AzureSkuName = "Standard_D13_v2"
	// AzureSkuNameStandardD14V2 ...
	AzureSkuNameStandardD14V2 AzureSkuName = "Standard_D14_v2"
	// AzureSkuNameStandardDS13V21TBPS ...
	AzureSkuNameStandardDS13V21TBPS AzureSkuName = "Standard_DS13_v2+1TB_PS"
	// AzureSkuNameStandardDS13V22TBPS ...
	AzureSkuNameStandardDS13V22TBPS AzureSkuName = "Standard_DS13_v2+2TB_PS"
	// AzureSkuNameStandardDS14V23TBPS ...
	AzureSkuNameStandardDS14V23TBPS AzureSkuName = "Standard_DS14_v2+3TB_PS"
	// AzureSkuNameStandardDS14V24TBPS ...
	AzureSkuNameStandardDS14V24TBPS AzureSkuName = "Standard_DS14_v2+4TB_PS"
	// AzureSkuNameStandardE16asV43TBPS ...
	AzureSkuNameStandardE16asV43TBPS AzureSkuName = "Standard_E16as_v4+3TB_PS"
	// AzureSkuNameStandardE16asV44TBPS ...
	AzureSkuNameStandardE16asV44TBPS AzureSkuName = "Standard_E16as_v4+4TB_PS"
	// AzureSkuNameStandardE16aV4 ...
	AzureSkuNameStandardE16aV4 AzureSkuName = "Standard_E16a_v4"
	// AzureSkuNameStandardE2aV4 ...
	AzureSkuNameStandardE2aV4 AzureSkuName = "Standard_E2a_v4"
	// AzureSkuNameStandardE4aV4 ...
	AzureSkuNameStandardE4aV4 AzureSkuName = "Standard_E4a_v4"
	// AzureSkuNameStandardE64iV3 ...
	AzureSkuNameStandardE64iV3 AzureSkuName = "Standard_E64i_v3"
	// AzureSkuNameStandardE80idsV4 ...
	AzureSkuNameStandardE80idsV4 AzureSkuName = "Standard_E80ids_v4"
	// AzureSkuNameStandardE8asV41TBPS ...
	AzureSkuNameStandardE8asV41TBPS AzureSkuName = "Standard_E8as_v4+1TB_PS"
	// AzureSkuNameStandardE8asV42TBPS ...
	AzureSkuNameStandardE8asV42TBPS AzureSkuName = "Standard_E8as_v4+2TB_PS"
	// AzureSkuNameStandardE8aV4 ...
	AzureSkuNameStandardE8aV4 AzureSkuName = "Standard_E8a_v4"
	// AzureSkuNameStandardL16s ...
	AzureSkuNameStandardL16s AzureSkuName = "Standard_L16s"
	// AzureSkuNameStandardL16sV2 ...
	AzureSkuNameStandardL16sV2 AzureSkuName = "Standard_L16s_v2"
	// AzureSkuNameStandardL4s ...
	AzureSkuNameStandardL4s AzureSkuName = "Standard_L4s"
	// AzureSkuNameStandardL8s ...
	AzureSkuNameStandardL8s AzureSkuName = "Standard_L8s"
	// AzureSkuNameStandardL8sV2 ...
	AzureSkuNameStandardL8sV2 AzureSkuName = "Standard_L8s_v2"
)

// PossibleAzureSkuNameValues returns an array of possible values for the AzureSkuName const type.
func PossibleAzureSkuNameValues() []AzureSkuName {
	return []AzureSkuName{AzureSkuNameDevNoSLAStandardD11V2, AzureSkuNameDevNoSLAStandardE2aV4, AzureSkuNameStandardD11V2, AzureSkuNameStandardD12V2, AzureSkuNameStandardD13V2, AzureSkuNameStandardD14V2, AzureSkuNameStandardDS13V21TBPS, AzureSkuNameStandardDS13V22TBPS, AzureSkuNameStandardDS14V23TBPS, AzureSkuNameStandardDS14V24TBPS, AzureSkuNameStandardE16asV43TBPS, AzureSkuNameStandardE16asV44TBPS, AzureSkuNameStandardE16aV4, AzureSkuNameStandardE2aV4, AzureSkuNameStandardE4aV4, AzureSkuNameStandardE64iV3, AzureSkuNameStandardE80idsV4, AzureSkuNameStandardE8asV41TBPS, AzureSkuNameStandardE8asV42TBPS, AzureSkuNameStandardE8aV4, AzureSkuNameStandardL16s, AzureSkuNameStandardL16sV2, AzureSkuNameStandardL4s, AzureSkuNameStandardL8s, AzureSkuNameStandardL8sV2}
}

// AzureSkuTier enumerates the values for azure sku tier.
type AzureSkuTier string

const (
	// AzureSkuTierBasic ...
	AzureSkuTierBasic AzureSkuTier = "Basic"
	// AzureSkuTierStandard ...
	AzureSkuTierStandard AzureSkuTier = "Standard"
)

// PossibleAzureSkuTierValues returns an array of possible values for the AzureSkuTier const type.
func PossibleAzureSkuTierValues() []AzureSkuTier {
	return []AzureSkuTier{AzureSkuTierBasic, AzureSkuTierStandard}
}

// BlobStorageEventType enumerates the values for blob storage event type.
type BlobStorageEventType string

const (
	// BlobStorageEventTypeMicrosoftStorageBlobCreated ...
	BlobStorageEventTypeMicrosoftStorageBlobCreated BlobStorageEventType = "Microsoft.Storage.BlobCreated"
	// BlobStorageEventTypeMicrosoftStorageBlobRenamed ...
	BlobStorageEventTypeMicrosoftStorageBlobRenamed BlobStorageEventType = "Microsoft.Storage.BlobRenamed"
)

// PossibleBlobStorageEventTypeValues returns an array of possible values for the BlobStorageEventType const type.
func PossibleBlobStorageEventTypeValues() []BlobStorageEventType {
	return []BlobStorageEventType{BlobStorageEventTypeMicrosoftStorageBlobCreated, BlobStorageEventTypeMicrosoftStorageBlobRenamed}
}

// ClusterPrincipalRole enumerates the values for cluster principal role.
type ClusterPrincipalRole string

const (
	// ClusterPrincipalRoleAllDatabasesAdmin ...
	ClusterPrincipalRoleAllDatabasesAdmin ClusterPrincipalRole = "AllDatabasesAdmin"
	// ClusterPrincipalRoleAllDatabasesViewer ...
	ClusterPrincipalRoleAllDatabasesViewer ClusterPrincipalRole = "AllDatabasesViewer"
)

// PossibleClusterPrincipalRoleValues returns an array of possible values for the ClusterPrincipalRole const type.
func PossibleClusterPrincipalRoleValues() []ClusterPrincipalRole {
	return []ClusterPrincipalRole{ClusterPrincipalRoleAllDatabasesAdmin, ClusterPrincipalRoleAllDatabasesViewer}
}

// Compression enumerates the values for compression.
type Compression string

const (
	// CompressionGZip ...
	CompressionGZip Compression = "GZip"
	// CompressionNone ...
	CompressionNone Compression = "None"
)

// PossibleCompressionValues returns an array of possible values for the Compression const type.
func PossibleCompressionValues() []Compression {
	return []Compression{CompressionGZip, CompressionNone}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// DatabasePrincipalRole enumerates the values for database principal role.
type DatabasePrincipalRole string

const (
	// DatabasePrincipalRoleAdmin ...
	DatabasePrincipalRoleAdmin DatabasePrincipalRole = "Admin"
	// DatabasePrincipalRoleIngestor ...
	DatabasePrincipalRoleIngestor DatabasePrincipalRole = "Ingestor"
	// DatabasePrincipalRoleMonitor ...
	DatabasePrincipalRoleMonitor DatabasePrincipalRole = "Monitor"
	// DatabasePrincipalRoleUnrestrictedViewer ...
	DatabasePrincipalRoleUnrestrictedViewer DatabasePrincipalRole = "UnrestrictedViewer"
	// DatabasePrincipalRoleUser ...
	DatabasePrincipalRoleUser DatabasePrincipalRole = "User"
	// DatabasePrincipalRoleViewer ...
	DatabasePrincipalRoleViewer DatabasePrincipalRole = "Viewer"
)

// PossibleDatabasePrincipalRoleValues returns an array of possible values for the DatabasePrincipalRole const type.
func PossibleDatabasePrincipalRoleValues() []DatabasePrincipalRole {
	return []DatabasePrincipalRole{DatabasePrincipalRoleAdmin, DatabasePrincipalRoleIngestor, DatabasePrincipalRoleMonitor, DatabasePrincipalRoleUnrestrictedViewer, DatabasePrincipalRoleUser, DatabasePrincipalRoleViewer}
}

// DatabasePrincipalType enumerates the values for database principal type.
type DatabasePrincipalType string

const (
	// DatabasePrincipalTypeApp ...
	DatabasePrincipalTypeApp DatabasePrincipalType = "App"
	// DatabasePrincipalTypeGroup ...
	DatabasePrincipalTypeGroup DatabasePrincipalType = "Group"
	// DatabasePrincipalTypeUser ...
	DatabasePrincipalTypeUser DatabasePrincipalType = "User"
)

// PossibleDatabasePrincipalTypeValues returns an array of possible values for the DatabasePrincipalType const type.
func PossibleDatabasePrincipalTypeValues() []DatabasePrincipalType {
	return []DatabasePrincipalType{DatabasePrincipalTypeApp, DatabasePrincipalTypeGroup, DatabasePrincipalTypeUser}
}

// DefaultPrincipalsModificationKind enumerates the values for default principals modification kind.
type DefaultPrincipalsModificationKind string

const (
	// DefaultPrincipalsModificationKindNone ...
	DefaultPrincipalsModificationKindNone DefaultPrincipalsModificationKind = "None"
	// DefaultPrincipalsModificationKindReplace ...
	DefaultPrincipalsModificationKindReplace DefaultPrincipalsModificationKind = "Replace"
	// DefaultPrincipalsModificationKindUnion ...
	DefaultPrincipalsModificationKindUnion DefaultPrincipalsModificationKind = "Union"
)

// PossibleDefaultPrincipalsModificationKindValues returns an array of possible values for the DefaultPrincipalsModificationKind const type.
func PossibleDefaultPrincipalsModificationKindValues() []DefaultPrincipalsModificationKind {
	return []DefaultPrincipalsModificationKind{DefaultPrincipalsModificationKindNone, DefaultPrincipalsModificationKindReplace, DefaultPrincipalsModificationKindUnion}
}

// EngineType enumerates the values for engine type.
type EngineType string

const (
	// EngineTypeV2 ...
	EngineTypeV2 EngineType = "V2"
	// EngineTypeV3 ...
	EngineTypeV3 EngineType = "V3"
)

// PossibleEngineTypeValues returns an array of possible values for the EngineType const type.
func PossibleEngineTypeValues() []EngineType {
	return []EngineType{EngineTypeV2, EngineTypeV3}
}

// EventGridDataFormat enumerates the values for event grid data format.
type EventGridDataFormat string

const (
	// EventGridDataFormatAPACHEAVRO ...
	EventGridDataFormatAPACHEAVRO EventGridDataFormat = "APACHEAVRO"
	// EventGridDataFormatAVRO ...
	EventGridDataFormatAVRO EventGridDataFormat = "AVRO"
	// EventGridDataFormatCSV ...
	EventGridDataFormatCSV EventGridDataFormat = "CSV"
	// EventGridDataFormatJSON ...
	EventGridDataFormatJSON EventGridDataFormat = "JSON"
	// EventGridDataFormatMULTIJSON ...
	EventGridDataFormatMULTIJSON EventGridDataFormat = "MULTIJSON"
	// EventGridDataFormatORC ...
	EventGridDataFormatORC EventGridDataFormat = "ORC"
	// EventGridDataFormatPARQUET ...
	EventGridDataFormatPARQUET EventGridDataFormat = "PARQUET"
	// EventGridDataFormatPSV ...
	EventGridDataFormatPSV EventGridDataFormat = "PSV"
	// EventGridDataFormatRAW ...
	EventGridDataFormatRAW EventGridDataFormat = "RAW"
	// EventGridDataFormatSCSV ...
	EventGridDataFormatSCSV EventGridDataFormat = "SCSV"
	// EventGridDataFormatSINGLEJSON ...
	EventGridDataFormatSINGLEJSON EventGridDataFormat = "SINGLEJSON"
	// EventGridDataFormatSOHSV ...
	EventGridDataFormatSOHSV EventGridDataFormat = "SOHSV"
	// EventGridDataFormatTSV ...
	EventGridDataFormatTSV EventGridDataFormat = "TSV"
	// EventGridDataFormatTSVE ...
	EventGridDataFormatTSVE EventGridDataFormat = "TSVE"
	// EventGridDataFormatTXT ...
	EventGridDataFormatTXT EventGridDataFormat = "TXT"
	// EventGridDataFormatW3CLOGFILE ...
	EventGridDataFormatW3CLOGFILE EventGridDataFormat = "W3CLOGFILE"
)

// PossibleEventGridDataFormatValues returns an array of possible values for the EventGridDataFormat const type.
func PossibleEventGridDataFormatValues() []EventGridDataFormat {
	return []EventGridDataFormat{EventGridDataFormatAPACHEAVRO, EventGridDataFormatAVRO, EventGridDataFormatCSV, EventGridDataFormatJSON, EventGridDataFormatMULTIJSON, EventGridDataFormatORC, EventGridDataFormatPARQUET, EventGridDataFormatPSV, EventGridDataFormatRAW, EventGridDataFormatSCSV, EventGridDataFormatSINGLEJSON, EventGridDataFormatSOHSV, EventGridDataFormatTSV, EventGridDataFormatTSVE, EventGridDataFormatTXT, EventGridDataFormatW3CLOGFILE}
}

// EventHubDataFormat enumerates the values for event hub data format.
type EventHubDataFormat string

const (
	// EventHubDataFormatAPACHEAVRO ...
	EventHubDataFormatAPACHEAVRO EventHubDataFormat = "APACHEAVRO"
	// EventHubDataFormatAVRO ...
	EventHubDataFormatAVRO EventHubDataFormat = "AVRO"
	// EventHubDataFormatCSV ...
	EventHubDataFormatCSV EventHubDataFormat = "CSV"
	// EventHubDataFormatJSON ...
	EventHubDataFormatJSON EventHubDataFormat = "JSON"
	// EventHubDataFormatMULTIJSON ...
	EventHubDataFormatMULTIJSON EventHubDataFormat = "MULTIJSON"
	// EventHubDataFormatORC ...
	EventHubDataFormatORC EventHubDataFormat = "ORC"
	// EventHubDataFormatPARQUET ...
	EventHubDataFormatPARQUET EventHubDataFormat = "PARQUET"
	// EventHubDataFormatPSV ...
	EventHubDataFormatPSV EventHubDataFormat = "PSV"
	// EventHubDataFormatRAW ...
	EventHubDataFormatRAW EventHubDataFormat = "RAW"
	// EventHubDataFormatSCSV ...
	EventHubDataFormatSCSV EventHubDataFormat = "SCSV"
	// EventHubDataFormatSINGLEJSON ...
	EventHubDataFormatSINGLEJSON EventHubDataFormat = "SINGLEJSON"
	// EventHubDataFormatSOHSV ...
	EventHubDataFormatSOHSV EventHubDataFormat = "SOHSV"
	// EventHubDataFormatTSV ...
	EventHubDataFormatTSV EventHubDataFormat = "TSV"
	// EventHubDataFormatTSVE ...
	EventHubDataFormatTSVE EventHubDataFormat = "TSVE"
	// EventHubDataFormatTXT ...
	EventHubDataFormatTXT EventHubDataFormat = "TXT"
	// EventHubDataFormatW3CLOGFILE ...
	EventHubDataFormatW3CLOGFILE EventHubDataFormat = "W3CLOGFILE"
)

// PossibleEventHubDataFormatValues returns an array of possible values for the EventHubDataFormat const type.
func PossibleEventHubDataFormatValues() []EventHubDataFormat {
	return []EventHubDataFormat{EventHubDataFormatAPACHEAVRO, EventHubDataFormatAVRO, EventHubDataFormatCSV, EventHubDataFormatJSON, EventHubDataFormatMULTIJSON, EventHubDataFormatORC, EventHubDataFormatPARQUET, EventHubDataFormatPSV, EventHubDataFormatRAW, EventHubDataFormatSCSV, EventHubDataFormatSINGLEJSON, EventHubDataFormatSOHSV, EventHubDataFormatTSV, EventHubDataFormatTSVE, EventHubDataFormatTXT, EventHubDataFormatW3CLOGFILE}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// IdentityTypeNone ...
	IdentityTypeNone IdentityType = "None"
	// IdentityTypeSystemAssigned ...
	IdentityTypeSystemAssigned IdentityType = "SystemAssigned"
	// IdentityTypeSystemAssignedUserAssigned ...
	IdentityTypeSystemAssignedUserAssigned IdentityType = "SystemAssigned, UserAssigned"
	// IdentityTypeUserAssigned ...
	IdentityTypeUserAssigned IdentityType = "UserAssigned"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{IdentityTypeNone, IdentityTypeSystemAssigned, IdentityTypeSystemAssignedUserAssigned, IdentityTypeUserAssigned}
}

// IotHubDataFormat enumerates the values for iot hub data format.
type IotHubDataFormat string

const (
	// IotHubDataFormatAPACHEAVRO ...
	IotHubDataFormatAPACHEAVRO IotHubDataFormat = "APACHEAVRO"
	// IotHubDataFormatAVRO ...
	IotHubDataFormatAVRO IotHubDataFormat = "AVRO"
	// IotHubDataFormatCSV ...
	IotHubDataFormatCSV IotHubDataFormat = "CSV"
	// IotHubDataFormatJSON ...
	IotHubDataFormatJSON IotHubDataFormat = "JSON"
	// IotHubDataFormatMULTIJSON ...
	IotHubDataFormatMULTIJSON IotHubDataFormat = "MULTIJSON"
	// IotHubDataFormatORC ...
	IotHubDataFormatORC IotHubDataFormat = "ORC"
	// IotHubDataFormatPARQUET ...
	IotHubDataFormatPARQUET IotHubDataFormat = "PARQUET"
	// IotHubDataFormatPSV ...
	IotHubDataFormatPSV IotHubDataFormat = "PSV"
	// IotHubDataFormatRAW ...
	IotHubDataFormatRAW IotHubDataFormat = "RAW"
	// IotHubDataFormatSCSV ...
	IotHubDataFormatSCSV IotHubDataFormat = "SCSV"
	// IotHubDataFormatSINGLEJSON ...
	IotHubDataFormatSINGLEJSON IotHubDataFormat = "SINGLEJSON"
	// IotHubDataFormatSOHSV ...
	IotHubDataFormatSOHSV IotHubDataFormat = "SOHSV"
	// IotHubDataFormatTSV ...
	IotHubDataFormatTSV IotHubDataFormat = "TSV"
	// IotHubDataFormatTSVE ...
	IotHubDataFormatTSVE IotHubDataFormat = "TSVE"
	// IotHubDataFormatTXT ...
	IotHubDataFormatTXT IotHubDataFormat = "TXT"
	// IotHubDataFormatW3CLOGFILE ...
	IotHubDataFormatW3CLOGFILE IotHubDataFormat = "W3CLOGFILE"
)

// PossibleIotHubDataFormatValues returns an array of possible values for the IotHubDataFormat const type.
func PossibleIotHubDataFormatValues() []IotHubDataFormat {
	return []IotHubDataFormat{IotHubDataFormatAPACHEAVRO, IotHubDataFormatAVRO, IotHubDataFormatCSV, IotHubDataFormatJSON, IotHubDataFormatMULTIJSON, IotHubDataFormatORC, IotHubDataFormatPARQUET, IotHubDataFormatPSV, IotHubDataFormatRAW, IotHubDataFormatSCSV, IotHubDataFormatSINGLEJSON, IotHubDataFormatSOHSV, IotHubDataFormatTSV, IotHubDataFormatTSVE, IotHubDataFormatTXT, IotHubDataFormatW3CLOGFILE}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindKindDatabase ...
	KindKindDatabase Kind = "Database"
	// KindKindReadOnlyFollowing ...
	KindKindReadOnlyFollowing Kind = "ReadOnlyFollowing"
	// KindKindReadWrite ...
	KindKindReadWrite Kind = "ReadWrite"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindKindDatabase, KindKindReadOnlyFollowing, KindKindReadWrite}
}

// KindBasicDataConnection enumerates the values for kind basic data connection.
type KindBasicDataConnection string

const (
	// KindBasicDataConnectionKindDataConnection ...
	KindBasicDataConnectionKindDataConnection KindBasicDataConnection = "DataConnection"
	// KindBasicDataConnectionKindEventGrid ...
	KindBasicDataConnectionKindEventGrid KindBasicDataConnection = "EventGrid"
	// KindBasicDataConnectionKindEventHub ...
	KindBasicDataConnectionKindEventHub KindBasicDataConnection = "EventHub"
	// KindBasicDataConnectionKindIotHub ...
	KindBasicDataConnectionKindIotHub KindBasicDataConnection = "IotHub"
)

// PossibleKindBasicDataConnectionValues returns an array of possible values for the KindBasicDataConnection const type.
func PossibleKindBasicDataConnectionValues() []KindBasicDataConnection {
	return []KindBasicDataConnection{KindBasicDataConnectionKindDataConnection, KindBasicDataConnectionKindEventGrid, KindBasicDataConnectionKindEventHub, KindBasicDataConnectionKindIotHub}
}

// LanguageExtensionName enumerates the values for language extension name.
type LanguageExtensionName string

const (
	// LanguageExtensionNamePYTHON ...
	LanguageExtensionNamePYTHON LanguageExtensionName = "PYTHON"
	// LanguageExtensionNameR ...
	LanguageExtensionNameR LanguageExtensionName = "R"
)

// PossibleLanguageExtensionNameValues returns an array of possible values for the LanguageExtensionName const type.
func PossibleLanguageExtensionNameValues() []LanguageExtensionName {
	return []LanguageExtensionName{LanguageExtensionNamePYTHON, LanguageExtensionNameR}
}

// PrincipalsModificationKind enumerates the values for principals modification kind.
type PrincipalsModificationKind string

const (
	// PrincipalsModificationKindNone ...
	PrincipalsModificationKindNone PrincipalsModificationKind = "None"
	// PrincipalsModificationKindReplace ...
	PrincipalsModificationKindReplace PrincipalsModificationKind = "Replace"
	// PrincipalsModificationKindUnion ...
	PrincipalsModificationKindUnion PrincipalsModificationKind = "Union"
)

// PossiblePrincipalsModificationKindValues returns an array of possible values for the PrincipalsModificationKind const type.
func PossiblePrincipalsModificationKindValues() []PrincipalsModificationKind {
	return []PrincipalsModificationKind{PrincipalsModificationKindNone, PrincipalsModificationKindReplace, PrincipalsModificationKindUnion}
}

// PrincipalType enumerates the values for principal type.
type PrincipalType string

const (
	// PrincipalTypeApp ...
	PrincipalTypeApp PrincipalType = "App"
	// PrincipalTypeGroup ...
	PrincipalTypeGroup PrincipalType = "Group"
	// PrincipalTypeUser ...
	PrincipalTypeUser PrincipalType = "User"
)

// PossiblePrincipalTypeValues returns an array of possible values for the PrincipalType const type.
func PossiblePrincipalTypeValues() []PrincipalType {
	return []PrincipalType{PrincipalTypeApp, PrincipalTypeGroup, PrincipalTypeUser}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateMoving ...
	ProvisioningStateMoving ProvisioningState = "Moving"
	// ProvisioningStateRunning ...
	ProvisioningStateRunning ProvisioningState = "Running"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateMoving, ProvisioningStateRunning, ProvisioningStateSucceeded}
}

// Reason enumerates the values for reason.
type Reason string

const (
	// ReasonAlreadyExists ...
	ReasonAlreadyExists Reason = "AlreadyExists"
	// ReasonInvalid ...
	ReasonInvalid Reason = "Invalid"
)

// PossibleReasonValues returns an array of possible values for the Reason const type.
func PossibleReasonValues() []Reason {
	return []Reason{ReasonAlreadyExists, ReasonInvalid}
}

// State enumerates the values for state.
type State string

const (
	// StateCreating ...
	StateCreating State = "Creating"
	// StateDeleted ...
	StateDeleted State = "Deleted"
	// StateDeleting ...
	StateDeleting State = "Deleting"
	// StateRunning ...
	StateRunning State = "Running"
	// StateStarting ...
	StateStarting State = "Starting"
	// StateStopped ...
	StateStopped State = "Stopped"
	// StateStopping ...
	StateStopping State = "Stopping"
	// StateUnavailable ...
	StateUnavailable State = "Unavailable"
	// StateUpdating ...
	StateUpdating State = "Updating"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateCreating, StateDeleted, StateDeleting, StateRunning, StateStarting, StateStopped, StateStopping, StateUnavailable, StateUpdating}
}

// Status enumerates the values for status.
type Status string

const (
	// StatusCanceled ...
	StatusCanceled Status = "Canceled"
	// StatusFailed ...
	StatusFailed Status = "Failed"
	// StatusRunning ...
	StatusRunning Status = "Running"
	// StatusSucceeded ...
	StatusSucceeded Status = "Succeeded"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{StatusCanceled, StatusFailed, StatusRunning, StatusSucceeded}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeMicrosoftKustoclustersattachedDatabaseConfigurations ...
	TypeMicrosoftKustoclustersattachedDatabaseConfigurations Type = "Microsoft.Kusto/clusters/attachedDatabaseConfigurations"
	// TypeMicrosoftKustoclustersdatabases ...
	TypeMicrosoftKustoclustersdatabases Type = "Microsoft.Kusto/clusters/databases"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeMicrosoftKustoclustersattachedDatabaseConfigurations, TypeMicrosoftKustoclustersdatabases}
}
