package dataprotection

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/dataprotection/mgmt/2021-01-01/dataprotection"

// AbsoluteDeleteOption delete option with duration
type AbsoluteDeleteOption struct {
	// Duration - Duration of deletion after given timespan
	Duration *string `json:"duration,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeDeleteOption', 'ObjectTypeAbsoluteDeleteOption'
	ObjectType ObjectTypeBasicDeleteOption `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AbsoluteDeleteOption.
func (ado AbsoluteDeleteOption) MarshalJSON() ([]byte, error) {
	ado.ObjectType = ObjectTypeAbsoluteDeleteOption
	objectMap := make(map[string]interface{})
	if ado.Duration != nil {
		objectMap["duration"] = ado.Duration
	}
	if ado.ObjectType != "" {
		objectMap["objectType"] = ado.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAbsoluteDeleteOption is the BasicDeleteOption implementation for AbsoluteDeleteOption.
func (ado AbsoluteDeleteOption) AsAbsoluteDeleteOption() (*AbsoluteDeleteOption, bool) {
	return &ado, true
}

// AsDeleteOption is the BasicDeleteOption implementation for AbsoluteDeleteOption.
func (ado AbsoluteDeleteOption) AsDeleteOption() (*DeleteOption, bool) {
	return nil, false
}

// AsBasicDeleteOption is the BasicDeleteOption implementation for AbsoluteDeleteOption.
func (ado AbsoluteDeleteOption) AsBasicDeleteOption() (BasicDeleteOption, bool) {
	return &ado, true
}

// AdHocBackupRuleOptions adhoc backup rules
type AdHocBackupRuleOptions struct {
	RuleName      *string                   `json:"ruleName,omitempty"`
	TriggerOption *AdhocBackupTriggerOption `json:"triggerOption,omitempty"`
}

// AdhocBackupTriggerOption adhoc backup trigger option
type AdhocBackupTriggerOption struct {
	RetentionTagOverride *string `json:"retentionTagOverride,omitempty"`
}

// AdhocBasedTaggingCriteria adhoc backup tagging criteria
type AdhocBasedTaggingCriteria struct {
	// TagInfo - Retention tag information
	TagInfo *RetentionTag `json:"tagInfo,omitempty"`
}

// AdhocBasedTriggerContext adhoc trigger context
type AdhocBasedTriggerContext struct {
	// TaggingCriteria - Tagging Criteria containing retention tag for adhoc backup.
	TaggingCriteria *AdhocBasedTaggingCriteria `json:"taggingCriteria,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeTriggerContext', 'ObjectTypeAdhocBasedTriggerContext', 'ObjectTypeScheduleBasedTriggerContext'
	ObjectType ObjectTypeBasicTriggerContext `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AdhocBasedTriggerContext.
func (abtc AdhocBasedTriggerContext) MarshalJSON() ([]byte, error) {
	abtc.ObjectType = ObjectTypeAdhocBasedTriggerContext
	objectMap := make(map[string]interface{})
	if abtc.TaggingCriteria != nil {
		objectMap["taggingCriteria"] = abtc.TaggingCriteria
	}
	if abtc.ObjectType != "" {
		objectMap["objectType"] = abtc.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAdhocBasedTriggerContext is the BasicTriggerContext implementation for AdhocBasedTriggerContext.
func (abtc AdhocBasedTriggerContext) AsAdhocBasedTriggerContext() (*AdhocBasedTriggerContext, bool) {
	return &abtc, true
}

// AsScheduleBasedTriggerContext is the BasicTriggerContext implementation for AdhocBasedTriggerContext.
func (abtc AdhocBasedTriggerContext) AsScheduleBasedTriggerContext() (*ScheduleBasedTriggerContext, bool) {
	return nil, false
}

// AsTriggerContext is the BasicTriggerContext implementation for AdhocBasedTriggerContext.
func (abtc AdhocBasedTriggerContext) AsTriggerContext() (*TriggerContext, bool) {
	return nil, false
}

// AsBasicTriggerContext is the BasicTriggerContext implementation for AdhocBasedTriggerContext.
func (abtc AdhocBasedTriggerContext) AsBasicTriggerContext() (BasicTriggerContext, bool) {
	return &abtc, true
}

// AzureBackupDiscreteRecoveryPoint azure backup discrete RecoveryPoint
type AzureBackupDiscreteRecoveryPoint struct {
	FriendlyName                   *string                          `json:"friendlyName,omitempty"`
	RecoveryPointDataStoresDetails *[]RecoveryPointDataStoreDetails `json:"recoveryPointDataStoresDetails,omitempty"`
	RecoveryPointTime              *date.Time                       `json:"recoveryPointTime,omitempty"`
	PolicyName                     *string                          `json:"policyName,omitempty"`
	PolicyVersion                  *string                          `json:"policyVersion,omitempty"`
	RecoveryPointID                *string                          `json:"recoveryPointId,omitempty"`
	RecoveryPointType              *string                          `json:"recoveryPointType,omitempty"`
	RetentionTagName               *string                          `json:"retentionTagName,omitempty"`
	RetentionTagVersion            *string                          `json:"retentionTagVersion,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeAzureBackupRecoveryPoint', 'ObjectTypeAzureBackupDiscreteRecoveryPoint'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBackupDiscreteRecoveryPoint.
func (abdrp AzureBackupDiscreteRecoveryPoint) MarshalJSON() ([]byte, error) {
	abdrp.ObjectType = ObjectTypeAzureBackupDiscreteRecoveryPoint
	objectMap := make(map[string]interface{})
	if abdrp.FriendlyName != nil {
		objectMap["friendlyName"] = abdrp.FriendlyName
	}
	if abdrp.RecoveryPointDataStoresDetails != nil {
		objectMap["recoveryPointDataStoresDetails"] = abdrp.RecoveryPointDataStoresDetails
	}
	if abdrp.RecoveryPointTime != nil {
		objectMap["recoveryPointTime"] = abdrp.RecoveryPointTime
	}
	if abdrp.PolicyName != nil {
		objectMap["policyName"] = abdrp.PolicyName
	}
	if abdrp.PolicyVersion != nil {
		objectMap["policyVersion"] = abdrp.PolicyVersion
	}
	if abdrp.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = abdrp.RecoveryPointID
	}
	if abdrp.RecoveryPointType != nil {
		objectMap["recoveryPointType"] = abdrp.RecoveryPointType
	}
	if abdrp.RetentionTagName != nil {
		objectMap["retentionTagName"] = abdrp.RetentionTagName
	}
	if abdrp.RetentionTagVersion != nil {
		objectMap["retentionTagVersion"] = abdrp.RetentionTagVersion
	}
	if abdrp.ObjectType != "" {
		objectMap["objectType"] = abdrp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupDiscreteRecoveryPoint is the BasicAzureBackupRecoveryPoint implementation for AzureBackupDiscreteRecoveryPoint.
func (abdrp AzureBackupDiscreteRecoveryPoint) AsAzureBackupDiscreteRecoveryPoint() (*AzureBackupDiscreteRecoveryPoint, bool) {
	return &abdrp, true
}

// AsAzureBackupRecoveryPoint is the BasicAzureBackupRecoveryPoint implementation for AzureBackupDiscreteRecoveryPoint.
func (abdrp AzureBackupDiscreteRecoveryPoint) AsAzureBackupRecoveryPoint() (*AzureBackupRecoveryPoint, bool) {
	return nil, false
}

// AsBasicAzureBackupRecoveryPoint is the BasicAzureBackupRecoveryPoint implementation for AzureBackupDiscreteRecoveryPoint.
func (abdrp AzureBackupDiscreteRecoveryPoint) AsBasicAzureBackupRecoveryPoint() (BasicAzureBackupRecoveryPoint, bool) {
	return &abdrp, true
}

// AzureBackupFindRestorableTimeRangesRequest list Restore Ranges Request
type AzureBackupFindRestorableTimeRangesRequest struct {
	// SourceDataStoreType - Gets or sets the type of the source data store. Possible values include: 'RestoreSourceDataStoreTypeOperationalStore', 'RestoreSourceDataStoreTypeVaultStore', 'RestoreSourceDataStoreTypeArchiveStore'
	SourceDataStoreType RestoreSourceDataStoreType `json:"sourceDataStoreType,omitempty"`
	// StartTime - Start time for the List Restore Ranges request
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - End time for the List Restore Ranges request
	EndTime *string `json:"endTime,omitempty"`
}

// AzureBackupFindRestorableTimeRangesRequestResource list Restore Ranges Request
type AzureBackupFindRestorableTimeRangesRequestResource struct {
	// Content - AzureBackupFindRestorableTimeRangesRequestResource content
	Content                *AzureBackupFindRestorableTimeRangesRequest `json:"content,omitempty"`
	SubscriptionID         *string                                     `json:"subscriptionId,omitempty"`
	URI                    *string                                     `json:"uri,omitempty"`
	Headers                map[string][]string                         `json:"headers"`
	SupportedGroupVersions *[]string                                   `json:"supportedGroupVersions,omitempty"`
	CultureInfo            *string                                     `json:"cultureInfo,omitempty"`
	Parameters             map[string]*string                          `json:"parameters"`
	HTTPMethod             *string                                     `json:"httpMethod,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBackupFindRestorableTimeRangesRequestResource.
func (abfrtrrr AzureBackupFindRestorableTimeRangesRequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if abfrtrrr.Content != nil {
		objectMap["content"] = abfrtrrr.Content
	}
	if abfrtrrr.SubscriptionID != nil {
		objectMap["subscriptionId"] = abfrtrrr.SubscriptionID
	}
	if abfrtrrr.URI != nil {
		objectMap["uri"] = abfrtrrr.URI
	}
	if abfrtrrr.Headers != nil {
		objectMap["headers"] = abfrtrrr.Headers
	}
	if abfrtrrr.SupportedGroupVersions != nil {
		objectMap["supportedGroupVersions"] = abfrtrrr.SupportedGroupVersions
	}
	if abfrtrrr.CultureInfo != nil {
		objectMap["cultureInfo"] = abfrtrrr.CultureInfo
	}
	if abfrtrrr.Parameters != nil {
		objectMap["parameters"] = abfrtrrr.Parameters
	}
	if abfrtrrr.HTTPMethod != nil {
		objectMap["httpMethod"] = abfrtrrr.HTTPMethod
	}
	return json.Marshal(objectMap)
}

// AzureBackupFindRestorableTimeRangesResponse list Restore Ranges Response
type AzureBackupFindRestorableTimeRangesResponse struct {
	// RestorableTimeRanges - Returns the Restore Ranges available on the Backup Instance.
	RestorableTimeRanges *[]RestorableTimeRange `json:"restorableTimeRanges,omitempty"`
	ObjectType           *string                `json:"objectType,omitempty"`
}

// AzureBackupFindRestorableTimeRangesResponseResource list Restore Ranges Response
type AzureBackupFindRestorableTimeRangesResponseResource struct {
	autorest.Response `json:"-"`
	// Properties - AzureBackupFindRestorableTimeRangesResponseResource properties
	Properties *AzureBackupFindRestorableTimeRangesResponse `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBackupFindRestorableTimeRangesResponseResource.
func (abfrtrrr AzureBackupFindRestorableTimeRangesResponseResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if abfrtrrr.Properties != nil {
		objectMap["properties"] = abfrtrrr.Properties
	}
	if abfrtrrr.SystemData != nil {
		objectMap["systemData"] = abfrtrrr.SystemData
	}
	return json.Marshal(objectMap)
}

// AzureBackupJob azureBackup Job Class
type AzureBackupJob struct {
	// ActivityID - Job Activity Id
	ActivityID *string `json:"activityID,omitempty"`
	// BackupInstanceFriendlyName - Name of the Backup Instance
	BackupInstanceFriendlyName *string `json:"backupInstanceFriendlyName,omitempty"`
	// BackupInstanceID - READ-ONLY; ARM ID of the Backup Instance
	BackupInstanceID *string `json:"backupInstanceId,omitempty"`
	// DataSourceID - ARM ID of the DataSource
	DataSourceID *string `json:"dataSourceId,omitempty"`
	// DataSourceLocation - Location of the DataSource
	DataSourceLocation *string `json:"dataSourceLocation,omitempty"`
	// DataSourceName - User Friendly Name of the DataSource
	DataSourceName *string `json:"dataSourceName,omitempty"`
	// DataSourceSetName - Data Source Set Name of the DataSource
	DataSourceSetName *string `json:"dataSourceSetName,omitempty"`
	// DataSourceType - Type of DataSource
	DataSourceType *string `json:"dataSourceType,omitempty"`
	// Duration - Total run time of the job. ISO 8601 format.
	Duration *string `json:"duration,omitempty"`
	// EndTime - READ-ONLY; EndTime of the job(in UTC)
	EndTime *date.Time `json:"endTime,omitempty"`
	// ErrorDetails - READ-ONLY; A List, detailing the errors related to the job
	ErrorDetails *[]UserFacingError `json:"errorDetails,omitempty"`
	// ExtendedInfo - READ-ONLY; Extended Information about the job
	ExtendedInfo *JobExtendedInfo `json:"extendedInfo,omitempty"`
	// IsUserTriggered - Indicated that whether the job is adhoc(true) or scheduled(false)
	IsUserTriggered *bool `json:"isUserTriggered,omitempty"`
	// Operation - It indicates the type of Job i.e. Backup:full/log/diff ;Restore:ALR/OLR; Tiering:Backup/Archive ; Management:ConfigureProtection/UnConfigure
	Operation *string `json:"operation,omitempty"`
	// OperationCategory - It indicates the type of Job i.e. Backup/Restore/Tiering/Management
	OperationCategory *string `json:"operationCategory,omitempty"`
	// PolicyID - READ-ONLY; ARM ID of the policy
	PolicyID *string `json:"policyId,omitempty"`
	// PolicyName - READ-ONLY; Name of the policy
	PolicyName *string `json:"policyName,omitempty"`
	// ProgressEnabled - Indicated whether progress is enabled for the job
	ProgressEnabled *bool `json:"progressEnabled,omitempty"`
	// ProgressURL - READ-ONLY; Url which contains job's progress
	ProgressURL *string `json:"progressUrl,omitempty"`
	// RestoreType - READ-ONLY; It indicates the sub type of operation i.e. in case of Restore it can be ALR/OLR
	RestoreType *string `json:"restoreType,omitempty"`
	// SourceResourceGroup - Resource Group Name of the Datasource
	SourceResourceGroup *string `json:"sourceResourceGroup,omitempty"`
	// SourceSubscriptionID - SubscriptionId corresponding to the DataSource
	SourceSubscriptionID *string `json:"sourceSubscriptionID,omitempty"`
	// StartTime - StartTime of the job(in UTC)
	StartTime *date.Time `json:"startTime,omitempty"`
	// Status - Status of the job like InProgress/Success/Failed/Cancelled/SuccessWithWarning
	Status *string `json:"status,omitempty"`
	// SubscriptionID - Subscription Id of the corresponding backup vault
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// SupportedActions - List of supported actions
	SupportedActions *[]string `json:"supportedActions,omitempty"`
	// VaultName - Name of the vault
	VaultName                *string `json:"vaultName,omitempty"`
	Etag                     *string `json:"etag,omitempty"`
	SourceDataStoreName      *string `json:"sourceDataStoreName,omitempty"`
	DestinationDataStoreName *string `json:"destinationDataStoreName,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBackupJob.
func (abj AzureBackupJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if abj.ActivityID != nil {
		objectMap["activityID"] = abj.ActivityID
	}
	if abj.BackupInstanceFriendlyName != nil {
		objectMap["backupInstanceFriendlyName"] = abj.BackupInstanceFriendlyName
	}
	if abj.DataSourceID != nil {
		objectMap["dataSourceId"] = abj.DataSourceID
	}
	if abj.DataSourceLocation != nil {
		objectMap["dataSourceLocation"] = abj.DataSourceLocation
	}
	if abj.DataSourceName != nil {
		objectMap["dataSourceName"] = abj.DataSourceName
	}
	if abj.DataSourceSetName != nil {
		objectMap["dataSourceSetName"] = abj.DataSourceSetName
	}
	if abj.DataSourceType != nil {
		objectMap["dataSourceType"] = abj.DataSourceType
	}
	if abj.Duration != nil {
		objectMap["duration"] = abj.Duration
	}
	if abj.IsUserTriggered != nil {
		objectMap["isUserTriggered"] = abj.IsUserTriggered
	}
	if abj.Operation != nil {
		objectMap["operation"] = abj.Operation
	}
	if abj.OperationCategory != nil {
		objectMap["operationCategory"] = abj.OperationCategory
	}
	if abj.ProgressEnabled != nil {
		objectMap["progressEnabled"] = abj.ProgressEnabled
	}
	if abj.SourceResourceGroup != nil {
		objectMap["sourceResourceGroup"] = abj.SourceResourceGroup
	}
	if abj.SourceSubscriptionID != nil {
		objectMap["sourceSubscriptionID"] = abj.SourceSubscriptionID
	}
	if abj.StartTime != nil {
		objectMap["startTime"] = abj.StartTime
	}
	if abj.Status != nil {
		objectMap["status"] = abj.Status
	}
	if abj.SubscriptionID != nil {
		objectMap["subscriptionId"] = abj.SubscriptionID
	}
	if abj.SupportedActions != nil {
		objectMap["supportedActions"] = abj.SupportedActions
	}
	if abj.VaultName != nil {
		objectMap["vaultName"] = abj.VaultName
	}
	if abj.Etag != nil {
		objectMap["etag"] = abj.Etag
	}
	if abj.SourceDataStoreName != nil {
		objectMap["sourceDataStoreName"] = abj.SourceDataStoreName
	}
	if abj.DestinationDataStoreName != nil {
		objectMap["destinationDataStoreName"] = abj.DestinationDataStoreName
	}
	return json.Marshal(objectMap)
}

// AzureBackupJobResource azureBackup Job Resource Class
type AzureBackupJobResource struct {
	autorest.Response `json:"-"`
	// Properties - AzureBackupJobResource properties
	Properties *AzureBackupJob `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBackupJobResource.
func (abjr AzureBackupJobResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if abjr.Properties != nil {
		objectMap["properties"] = abjr.Properties
	}
	if abjr.SystemData != nil {
		objectMap["systemData"] = abjr.SystemData
	}
	return json.Marshal(objectMap)
}

// AzureBackupJobResourceList list of AzureBackup Job resources
type AzureBackupJobResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]AzureBackupJobResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// AzureBackupJobResourceListIterator provides access to a complete listing of AzureBackupJobResource
// values.
type AzureBackupJobResourceListIterator struct {
	i    int
	page AzureBackupJobResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AzureBackupJobResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureBackupJobResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AzureBackupJobResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AzureBackupJobResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AzureBackupJobResourceListIterator) Response() AzureBackupJobResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AzureBackupJobResourceListIterator) Value() AzureBackupJobResource {
	if !iter.page.NotDone() {
		return AzureBackupJobResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AzureBackupJobResourceListIterator type.
func NewAzureBackupJobResourceListIterator(page AzureBackupJobResourceListPage) AzureBackupJobResourceListIterator {
	return AzureBackupJobResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (abjrl AzureBackupJobResourceList) IsEmpty() bool {
	return abjrl.Value == nil || len(*abjrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (abjrl AzureBackupJobResourceList) hasNextLink() bool {
	return abjrl.NextLink != nil && len(*abjrl.NextLink) != 0
}

// azureBackupJobResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (abjrl AzureBackupJobResourceList) azureBackupJobResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !abjrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(abjrl.NextLink)))
}

// AzureBackupJobResourceListPage contains a page of AzureBackupJobResource values.
type AzureBackupJobResourceListPage struct {
	fn    func(context.Context, AzureBackupJobResourceList) (AzureBackupJobResourceList, error)
	abjrl AzureBackupJobResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AzureBackupJobResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureBackupJobResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.abjrl)
		if err != nil {
			return err
		}
		page.abjrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AzureBackupJobResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AzureBackupJobResourceListPage) NotDone() bool {
	return !page.abjrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AzureBackupJobResourceListPage) Response() AzureBackupJobResourceList {
	return page.abjrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AzureBackupJobResourceListPage) Values() []AzureBackupJobResource {
	if page.abjrl.IsEmpty() {
		return nil
	}
	return *page.abjrl.Value
}

// Creates a new instance of the AzureBackupJobResourceListPage type.
func NewAzureBackupJobResourceListPage(cur AzureBackupJobResourceList, getNextPage func(context.Context, AzureBackupJobResourceList) (AzureBackupJobResourceList, error)) AzureBackupJobResourceListPage {
	return AzureBackupJobResourceListPage{
		fn:    getNextPage,
		abjrl: cur,
	}
}

// AzureBackupParams azure backup parameters
type AzureBackupParams struct {
	// BackupType - BackupType ; Full/Incremental etc
	BackupType *string `json:"backupType,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeBackupParameters', 'ObjectTypeAzureBackupParams'
	ObjectType ObjectTypeBasicBackupParameters `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBackupParams.
func (abp AzureBackupParams) MarshalJSON() ([]byte, error) {
	abp.ObjectType = ObjectTypeAzureBackupParams
	objectMap := make(map[string]interface{})
	if abp.BackupType != nil {
		objectMap["backupType"] = abp.BackupType
	}
	if abp.ObjectType != "" {
		objectMap["objectType"] = abp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupParams is the BasicBackupParameters implementation for AzureBackupParams.
func (abp AzureBackupParams) AsAzureBackupParams() (*AzureBackupParams, bool) {
	return &abp, true
}

// AsBackupParameters is the BasicBackupParameters implementation for AzureBackupParams.
func (abp AzureBackupParams) AsBackupParameters() (*BackupParameters, bool) {
	return nil, false
}

// AsBasicBackupParameters is the BasicBackupParameters implementation for AzureBackupParams.
func (abp AzureBackupParams) AsBasicBackupParameters() (BasicBackupParameters, bool) {
	return &abp, true
}

// BasicAzureBackupRecoveryPoint azure backup recoveryPoint
type BasicAzureBackupRecoveryPoint interface {
	AsAzureBackupDiscreteRecoveryPoint() (*AzureBackupDiscreteRecoveryPoint, bool)
	AsAzureBackupRecoveryPoint() (*AzureBackupRecoveryPoint, bool)
}

// AzureBackupRecoveryPoint azure backup recoveryPoint
type AzureBackupRecoveryPoint struct {
	// ObjectType - Possible values include: 'ObjectTypeAzureBackupRecoveryPoint', 'ObjectTypeAzureBackupDiscreteRecoveryPoint'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

func unmarshalBasicAzureBackupRecoveryPoint(body []byte) (BasicAzureBackupRecoveryPoint, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureBackupDiscreteRecoveryPoint):
		var abdrp AzureBackupDiscreteRecoveryPoint
		err := json.Unmarshal(body, &abdrp)
		return abdrp, err
	default:
		var abrp AzureBackupRecoveryPoint
		err := json.Unmarshal(body, &abrp)
		return abrp, err
	}
}
func unmarshalBasicAzureBackupRecoveryPointArray(body []byte) ([]BasicAzureBackupRecoveryPoint, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	abrpArray := make([]BasicAzureBackupRecoveryPoint, len(rawMessages))

	for index, rawMessage := range rawMessages {
		abrp, err := unmarshalBasicAzureBackupRecoveryPoint(*rawMessage)
		if err != nil {
			return nil, err
		}
		abrpArray[index] = abrp
	}
	return abrpArray, nil
}

// MarshalJSON is the custom marshaler for AzureBackupRecoveryPoint.
func (abrp AzureBackupRecoveryPoint) MarshalJSON() ([]byte, error) {
	abrp.ObjectType = ObjectTypeAzureBackupRecoveryPoint
	objectMap := make(map[string]interface{})
	if abrp.ObjectType != "" {
		objectMap["objectType"] = abrp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupDiscreteRecoveryPoint is the BasicAzureBackupRecoveryPoint implementation for AzureBackupRecoveryPoint.
func (abrp AzureBackupRecoveryPoint) AsAzureBackupDiscreteRecoveryPoint() (*AzureBackupDiscreteRecoveryPoint, bool) {
	return nil, false
}

// AsAzureBackupRecoveryPoint is the BasicAzureBackupRecoveryPoint implementation for AzureBackupRecoveryPoint.
func (abrp AzureBackupRecoveryPoint) AsAzureBackupRecoveryPoint() (*AzureBackupRecoveryPoint, bool) {
	return &abrp, true
}

// AsBasicAzureBackupRecoveryPoint is the BasicAzureBackupRecoveryPoint implementation for AzureBackupRecoveryPoint.
func (abrp AzureBackupRecoveryPoint) AsBasicAzureBackupRecoveryPoint() (BasicAzureBackupRecoveryPoint, bool) {
	return &abrp, true
}

// BasicAzureBackupRecoveryPointBasedRestoreRequest azure backup recoveryPoint based restore request
type BasicAzureBackupRecoveryPointBasedRestoreRequest interface {
	AsAzureBackupRestoreWithRehydrationRequest() (*AzureBackupRestoreWithRehydrationRequest, bool)
	AsAzureBackupRecoveryPointBasedRestoreRequest() (*AzureBackupRecoveryPointBasedRestoreRequest, bool)
}

// AzureBackupRecoveryPointBasedRestoreRequest azure backup recoveryPoint based restore request
type AzureBackupRecoveryPointBasedRestoreRequest struct {
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// RestoreTargetInfo - Gets or sets the restore target information.
	RestoreTargetInfo BasicRestoreTargetInfoBase `json:"restoreTargetInfo,omitempty"`
	// SourceDataStoreType - Gets or sets the type of the source data store. Possible values include: 'SourceDataStoreTypeArchiveStore', 'SourceDataStoreTypeSnapshotStore', 'SourceDataStoreTypeVaultStore'
	SourceDataStoreType SourceDataStoreType `json:"sourceDataStoreType,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeAzureBackupRestoreRequest', 'ObjectTypeAzureBackupRecoveryPointBasedRestoreRequest', 'ObjectTypeAzureBackupRestoreWithRehydrationRequest', 'ObjectTypeAzureBackupRecoveryTimeBasedRestoreRequest'
	ObjectType ObjectTypeBasicAzureBackupRestoreRequest `json:"objectType,omitempty"`
}

func unmarshalBasicAzureBackupRecoveryPointBasedRestoreRequest(body []byte) (BasicAzureBackupRecoveryPointBasedRestoreRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureBackupRestoreWithRehydrationRequest):
		var abrwrr AzureBackupRestoreWithRehydrationRequest
		err := json.Unmarshal(body, &abrwrr)
		return abrwrr, err
	default:
		var abrpbrr AzureBackupRecoveryPointBasedRestoreRequest
		err := json.Unmarshal(body, &abrpbrr)
		return abrpbrr, err
	}
}
func unmarshalBasicAzureBackupRecoveryPointBasedRestoreRequestArray(body []byte) ([]BasicAzureBackupRecoveryPointBasedRestoreRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	abrpbrrArray := make([]BasicAzureBackupRecoveryPointBasedRestoreRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		abrpbrr, err := unmarshalBasicAzureBackupRecoveryPointBasedRestoreRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		abrpbrrArray[index] = abrpbrr
	}
	return abrpbrrArray, nil
}

// MarshalJSON is the custom marshaler for AzureBackupRecoveryPointBasedRestoreRequest.
func (abrpbrr AzureBackupRecoveryPointBasedRestoreRequest) MarshalJSON() ([]byte, error) {
	abrpbrr.ObjectType = ObjectTypeAzureBackupRecoveryPointBasedRestoreRequest
	objectMap := make(map[string]interface{})
	if abrpbrr.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = abrpbrr.RecoveryPointID
	}
	objectMap["restoreTargetInfo"] = abrpbrr.RestoreTargetInfo
	if abrpbrr.SourceDataStoreType != "" {
		objectMap["sourceDataStoreType"] = abrpbrr.SourceDataStoreType
	}
	if abrpbrr.ObjectType != "" {
		objectMap["objectType"] = abrpbrr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupRecoveryPointBasedRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRecoveryPointBasedRestoreRequest.
func (abrpbrr AzureBackupRecoveryPointBasedRestoreRequest) AsAzureBackupRecoveryPointBasedRestoreRequest() (*AzureBackupRecoveryPointBasedRestoreRequest, bool) {
	return &abrpbrr, true
}

// AsBasicAzureBackupRecoveryPointBasedRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRecoveryPointBasedRestoreRequest.
func (abrpbrr AzureBackupRecoveryPointBasedRestoreRequest) AsBasicAzureBackupRecoveryPointBasedRestoreRequest() (BasicAzureBackupRecoveryPointBasedRestoreRequest, bool) {
	return &abrpbrr, true
}

// AsAzureBackupRestoreWithRehydrationRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRecoveryPointBasedRestoreRequest.
func (abrpbrr AzureBackupRecoveryPointBasedRestoreRequest) AsAzureBackupRestoreWithRehydrationRequest() (*AzureBackupRestoreWithRehydrationRequest, bool) {
	return nil, false
}

// AsAzureBackupRecoveryTimeBasedRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRecoveryPointBasedRestoreRequest.
func (abrpbrr AzureBackupRecoveryPointBasedRestoreRequest) AsAzureBackupRecoveryTimeBasedRestoreRequest() (*AzureBackupRecoveryTimeBasedRestoreRequest, bool) {
	return nil, false
}

// AsAzureBackupRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRecoveryPointBasedRestoreRequest.
func (abrpbrr AzureBackupRecoveryPointBasedRestoreRequest) AsAzureBackupRestoreRequest() (*AzureBackupRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureBackupRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRecoveryPointBasedRestoreRequest.
func (abrpbrr AzureBackupRecoveryPointBasedRestoreRequest) AsBasicAzureBackupRestoreRequest() (BasicAzureBackupRestoreRequest, bool) {
	return &abrpbrr, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBackupRecoveryPointBasedRestoreRequest struct.
func (abrpbrr *AzureBackupRecoveryPointBasedRestoreRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recoveryPointId":
			if v != nil {
				var recoveryPointID string
				err = json.Unmarshal(*v, &recoveryPointID)
				if err != nil {
					return err
				}
				abrpbrr.RecoveryPointID = &recoveryPointID
			}
		case "restoreTargetInfo":
			if v != nil {
				restoreTargetInfo, err := unmarshalBasicRestoreTargetInfoBase(*v)
				if err != nil {
					return err
				}
				abrpbrr.RestoreTargetInfo = restoreTargetInfo
			}
		case "sourceDataStoreType":
			if v != nil {
				var sourceDataStoreType SourceDataStoreType
				err = json.Unmarshal(*v, &sourceDataStoreType)
				if err != nil {
					return err
				}
				abrpbrr.SourceDataStoreType = sourceDataStoreType
			}
		case "objectType":
			if v != nil {
				var objectType ObjectTypeBasicAzureBackupRestoreRequest
				err = json.Unmarshal(*v, &objectType)
				if err != nil {
					return err
				}
				abrpbrr.ObjectType = objectType
			}
		}
	}

	return nil
}

// AzureBackupRecoveryPointResource azure backup recoveryPoint resource
type AzureBackupRecoveryPointResource struct {
	autorest.Response `json:"-"`
	// Properties - AzureBackupRecoveryPointResource properties
	Properties BasicAzureBackupRecoveryPoint `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBackupRecoveryPointResource.
func (abrpr AzureBackupRecoveryPointResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = abrpr.Properties
	if abrpr.SystemData != nil {
		objectMap["systemData"] = abrpr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureBackupRecoveryPointResource struct.
func (abrpr *AzureBackupRecoveryPointResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicAzureBackupRecoveryPoint(*v)
				if err != nil {
					return err
				}
				abrpr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				abrpr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				abrpr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				abrpr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				abrpr.SystemData = &systemData
			}
		}
	}

	return nil
}

// AzureBackupRecoveryPointResourceList azure backup recoveryPoint resource list
type AzureBackupRecoveryPointResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]AzureBackupRecoveryPointResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// AzureBackupRecoveryPointResourceListIterator provides access to a complete listing of
// AzureBackupRecoveryPointResource values.
type AzureBackupRecoveryPointResourceListIterator struct {
	i    int
	page AzureBackupRecoveryPointResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AzureBackupRecoveryPointResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureBackupRecoveryPointResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AzureBackupRecoveryPointResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AzureBackupRecoveryPointResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AzureBackupRecoveryPointResourceListIterator) Response() AzureBackupRecoveryPointResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AzureBackupRecoveryPointResourceListIterator) Value() AzureBackupRecoveryPointResource {
	if !iter.page.NotDone() {
		return AzureBackupRecoveryPointResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AzureBackupRecoveryPointResourceListIterator type.
func NewAzureBackupRecoveryPointResourceListIterator(page AzureBackupRecoveryPointResourceListPage) AzureBackupRecoveryPointResourceListIterator {
	return AzureBackupRecoveryPointResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (abrprl AzureBackupRecoveryPointResourceList) IsEmpty() bool {
	return abrprl.Value == nil || len(*abrprl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (abrprl AzureBackupRecoveryPointResourceList) hasNextLink() bool {
	return abrprl.NextLink != nil && len(*abrprl.NextLink) != 0
}

// azureBackupRecoveryPointResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (abrprl AzureBackupRecoveryPointResourceList) azureBackupRecoveryPointResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !abrprl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(abrprl.NextLink)))
}

// AzureBackupRecoveryPointResourceListPage contains a page of AzureBackupRecoveryPointResource values.
type AzureBackupRecoveryPointResourceListPage struct {
	fn     func(context.Context, AzureBackupRecoveryPointResourceList) (AzureBackupRecoveryPointResourceList, error)
	abrprl AzureBackupRecoveryPointResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AzureBackupRecoveryPointResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureBackupRecoveryPointResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.abrprl)
		if err != nil {
			return err
		}
		page.abrprl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AzureBackupRecoveryPointResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AzureBackupRecoveryPointResourceListPage) NotDone() bool {
	return !page.abrprl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AzureBackupRecoveryPointResourceListPage) Response() AzureBackupRecoveryPointResourceList {
	return page.abrprl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AzureBackupRecoveryPointResourceListPage) Values() []AzureBackupRecoveryPointResource {
	if page.abrprl.IsEmpty() {
		return nil
	}
	return *page.abrprl.Value
}

// Creates a new instance of the AzureBackupRecoveryPointResourceListPage type.
func NewAzureBackupRecoveryPointResourceListPage(cur AzureBackupRecoveryPointResourceList, getNextPage func(context.Context, AzureBackupRecoveryPointResourceList) (AzureBackupRecoveryPointResourceList, error)) AzureBackupRecoveryPointResourceListPage {
	return AzureBackupRecoveryPointResourceListPage{
		fn:     getNextPage,
		abrprl: cur,
	}
}

// AzureBackupRecoveryTimeBasedRestoreRequest azureBackup RecoveryPointTime Based Restore Request
type AzureBackupRecoveryTimeBasedRestoreRequest struct {
	// RecoveryPointTime - The recovery time in ISO 8601 format example - 2020-08-14T17:30:00.0000000Z.
	RecoveryPointTime *string `json:"recoveryPointTime,omitempty"`
	// RestoreTargetInfo - Gets or sets the restore target information.
	RestoreTargetInfo BasicRestoreTargetInfoBase `json:"restoreTargetInfo,omitempty"`
	// SourceDataStoreType - Gets or sets the type of the source data store. Possible values include: 'SourceDataStoreTypeArchiveStore', 'SourceDataStoreTypeSnapshotStore', 'SourceDataStoreTypeVaultStore'
	SourceDataStoreType SourceDataStoreType `json:"sourceDataStoreType,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeAzureBackupRestoreRequest', 'ObjectTypeAzureBackupRecoveryPointBasedRestoreRequest', 'ObjectTypeAzureBackupRestoreWithRehydrationRequest', 'ObjectTypeAzureBackupRecoveryTimeBasedRestoreRequest'
	ObjectType ObjectTypeBasicAzureBackupRestoreRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBackupRecoveryTimeBasedRestoreRequest.
func (abrtbrr AzureBackupRecoveryTimeBasedRestoreRequest) MarshalJSON() ([]byte, error) {
	abrtbrr.ObjectType = ObjectTypeAzureBackupRecoveryTimeBasedRestoreRequest
	objectMap := make(map[string]interface{})
	if abrtbrr.RecoveryPointTime != nil {
		objectMap["recoveryPointTime"] = abrtbrr.RecoveryPointTime
	}
	objectMap["restoreTargetInfo"] = abrtbrr.RestoreTargetInfo
	if abrtbrr.SourceDataStoreType != "" {
		objectMap["sourceDataStoreType"] = abrtbrr.SourceDataStoreType
	}
	if abrtbrr.ObjectType != "" {
		objectMap["objectType"] = abrtbrr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupRecoveryPointBasedRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRecoveryTimeBasedRestoreRequest.
func (abrtbrr AzureBackupRecoveryTimeBasedRestoreRequest) AsAzureBackupRecoveryPointBasedRestoreRequest() (*AzureBackupRecoveryPointBasedRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureBackupRecoveryPointBasedRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRecoveryTimeBasedRestoreRequest.
func (abrtbrr AzureBackupRecoveryTimeBasedRestoreRequest) AsBasicAzureBackupRecoveryPointBasedRestoreRequest() (BasicAzureBackupRecoveryPointBasedRestoreRequest, bool) {
	return nil, false
}

// AsAzureBackupRestoreWithRehydrationRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRecoveryTimeBasedRestoreRequest.
func (abrtbrr AzureBackupRecoveryTimeBasedRestoreRequest) AsAzureBackupRestoreWithRehydrationRequest() (*AzureBackupRestoreWithRehydrationRequest, bool) {
	return nil, false
}

// AsAzureBackupRecoveryTimeBasedRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRecoveryTimeBasedRestoreRequest.
func (abrtbrr AzureBackupRecoveryTimeBasedRestoreRequest) AsAzureBackupRecoveryTimeBasedRestoreRequest() (*AzureBackupRecoveryTimeBasedRestoreRequest, bool) {
	return &abrtbrr, true
}

// AsAzureBackupRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRecoveryTimeBasedRestoreRequest.
func (abrtbrr AzureBackupRecoveryTimeBasedRestoreRequest) AsAzureBackupRestoreRequest() (*AzureBackupRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureBackupRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRecoveryTimeBasedRestoreRequest.
func (abrtbrr AzureBackupRecoveryTimeBasedRestoreRequest) AsBasicAzureBackupRestoreRequest() (BasicAzureBackupRestoreRequest, bool) {
	return &abrtbrr, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBackupRecoveryTimeBasedRestoreRequest struct.
func (abrtbrr *AzureBackupRecoveryTimeBasedRestoreRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recoveryPointTime":
			if v != nil {
				var recoveryPointTime string
				err = json.Unmarshal(*v, &recoveryPointTime)
				if err != nil {
					return err
				}
				abrtbrr.RecoveryPointTime = &recoveryPointTime
			}
		case "restoreTargetInfo":
			if v != nil {
				restoreTargetInfo, err := unmarshalBasicRestoreTargetInfoBase(*v)
				if err != nil {
					return err
				}
				abrtbrr.RestoreTargetInfo = restoreTargetInfo
			}
		case "sourceDataStoreType":
			if v != nil {
				var sourceDataStoreType SourceDataStoreType
				err = json.Unmarshal(*v, &sourceDataStoreType)
				if err != nil {
					return err
				}
				abrtbrr.SourceDataStoreType = sourceDataStoreType
			}
		case "objectType":
			if v != nil {
				var objectType ObjectTypeBasicAzureBackupRestoreRequest
				err = json.Unmarshal(*v, &objectType)
				if err != nil {
					return err
				}
				abrtbrr.ObjectType = objectType
			}
		}
	}

	return nil
}

// AzureBackupRehydrationRequest azure Backup Rehydrate Request
type AzureBackupRehydrationRequest struct {
	// RecoveryPointID - Id of the recovery point to be recovered
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// RehydrationPriority - Priority to be used for rehydration. Values High or Standard. Possible values include: 'RehydrationPriorityInvalid', 'RehydrationPriorityHigh', 'RehydrationPriorityStandard'
	RehydrationPriority RehydrationPriority `json:"rehydrationPriority,omitempty"`
	// RehydrationRetentionDuration - Retention duration in ISO 8601 format i.e P10D .
	RehydrationRetentionDuration *string `json:"rehydrationRetentionDuration,omitempty"`
}

// BasicAzureBackupRestoreRequest azure backup restore request
type BasicAzureBackupRestoreRequest interface {
	AsAzureBackupRecoveryPointBasedRestoreRequest() (*AzureBackupRecoveryPointBasedRestoreRequest, bool)
	AsBasicAzureBackupRecoveryPointBasedRestoreRequest() (BasicAzureBackupRecoveryPointBasedRestoreRequest, bool)
	AsAzureBackupRestoreWithRehydrationRequest() (*AzureBackupRestoreWithRehydrationRequest, bool)
	AsAzureBackupRecoveryTimeBasedRestoreRequest() (*AzureBackupRecoveryTimeBasedRestoreRequest, bool)
	AsAzureBackupRestoreRequest() (*AzureBackupRestoreRequest, bool)
}

// AzureBackupRestoreRequest azure backup restore request
type AzureBackupRestoreRequest struct {
	// RestoreTargetInfo - Gets or sets the restore target information.
	RestoreTargetInfo BasicRestoreTargetInfoBase `json:"restoreTargetInfo,omitempty"`
	// SourceDataStoreType - Gets or sets the type of the source data store. Possible values include: 'SourceDataStoreTypeArchiveStore', 'SourceDataStoreTypeSnapshotStore', 'SourceDataStoreTypeVaultStore'
	SourceDataStoreType SourceDataStoreType `json:"sourceDataStoreType,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeAzureBackupRestoreRequest', 'ObjectTypeAzureBackupRecoveryPointBasedRestoreRequest', 'ObjectTypeAzureBackupRestoreWithRehydrationRequest', 'ObjectTypeAzureBackupRecoveryTimeBasedRestoreRequest'
	ObjectType ObjectTypeBasicAzureBackupRestoreRequest `json:"objectType,omitempty"`
}

func unmarshalBasicAzureBackupRestoreRequest(body []byte) (BasicAzureBackupRestoreRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureBackupRecoveryPointBasedRestoreRequest):
		var abrpbrr AzureBackupRecoveryPointBasedRestoreRequest
		err := json.Unmarshal(body, &abrpbrr)
		return abrpbrr, err
	case string(ObjectTypeAzureBackupRestoreWithRehydrationRequest):
		var abrwrr AzureBackupRestoreWithRehydrationRequest
		err := json.Unmarshal(body, &abrwrr)
		return abrwrr, err
	case string(ObjectTypeAzureBackupRecoveryTimeBasedRestoreRequest):
		var abrtbrr AzureBackupRecoveryTimeBasedRestoreRequest
		err := json.Unmarshal(body, &abrtbrr)
		return abrtbrr, err
	default:
		var abrr AzureBackupRestoreRequest
		err := json.Unmarshal(body, &abrr)
		return abrr, err
	}
}
func unmarshalBasicAzureBackupRestoreRequestArray(body []byte) ([]BasicAzureBackupRestoreRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	abrrArray := make([]BasicAzureBackupRestoreRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		abrr, err := unmarshalBasicAzureBackupRestoreRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		abrrArray[index] = abrr
	}
	return abrrArray, nil
}

// MarshalJSON is the custom marshaler for AzureBackupRestoreRequest.
func (abrr AzureBackupRestoreRequest) MarshalJSON() ([]byte, error) {
	abrr.ObjectType = ObjectTypeAzureBackupRestoreRequest
	objectMap := make(map[string]interface{})
	objectMap["restoreTargetInfo"] = abrr.RestoreTargetInfo
	if abrr.SourceDataStoreType != "" {
		objectMap["sourceDataStoreType"] = abrr.SourceDataStoreType
	}
	if abrr.ObjectType != "" {
		objectMap["objectType"] = abrr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupRecoveryPointBasedRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRestoreRequest.
func (abrr AzureBackupRestoreRequest) AsAzureBackupRecoveryPointBasedRestoreRequest() (*AzureBackupRecoveryPointBasedRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureBackupRecoveryPointBasedRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRestoreRequest.
func (abrr AzureBackupRestoreRequest) AsBasicAzureBackupRecoveryPointBasedRestoreRequest() (BasicAzureBackupRecoveryPointBasedRestoreRequest, bool) {
	return nil, false
}

// AsAzureBackupRestoreWithRehydrationRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRestoreRequest.
func (abrr AzureBackupRestoreRequest) AsAzureBackupRestoreWithRehydrationRequest() (*AzureBackupRestoreWithRehydrationRequest, bool) {
	return nil, false
}

// AsAzureBackupRecoveryTimeBasedRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRestoreRequest.
func (abrr AzureBackupRestoreRequest) AsAzureBackupRecoveryTimeBasedRestoreRequest() (*AzureBackupRecoveryTimeBasedRestoreRequest, bool) {
	return nil, false
}

// AsAzureBackupRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRestoreRequest.
func (abrr AzureBackupRestoreRequest) AsAzureBackupRestoreRequest() (*AzureBackupRestoreRequest, bool) {
	return &abrr, true
}

// AsBasicAzureBackupRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRestoreRequest.
func (abrr AzureBackupRestoreRequest) AsBasicAzureBackupRestoreRequest() (BasicAzureBackupRestoreRequest, bool) {
	return &abrr, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBackupRestoreRequest struct.
func (abrr *AzureBackupRestoreRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "restoreTargetInfo":
			if v != nil {
				restoreTargetInfo, err := unmarshalBasicRestoreTargetInfoBase(*v)
				if err != nil {
					return err
				}
				abrr.RestoreTargetInfo = restoreTargetInfo
			}
		case "sourceDataStoreType":
			if v != nil {
				var sourceDataStoreType SourceDataStoreType
				err = json.Unmarshal(*v, &sourceDataStoreType)
				if err != nil {
					return err
				}
				abrr.SourceDataStoreType = sourceDataStoreType
			}
		case "objectType":
			if v != nil {
				var objectType ObjectTypeBasicAzureBackupRestoreRequest
				err = json.Unmarshal(*v, &objectType)
				if err != nil {
					return err
				}
				abrr.ObjectType = objectType
			}
		}
	}

	return nil
}

// AzureBackupRestoreWithRehydrationRequest azureBackup Restore with Rehydration Request
type AzureBackupRestoreWithRehydrationRequest struct {
	// RehydrationPriority - Priority to be used for rehydration. Values High or Standard. Possible values include: 'RehydrationPriorityInvalid', 'RehydrationPriorityHigh', 'RehydrationPriorityStandard'
	RehydrationPriority RehydrationPriority `json:"rehydrationPriority,omitempty"`
	// RehydrationRetentionDuration - Retention duration in ISO 8601 format i.e P10D .
	RehydrationRetentionDuration *string `json:"rehydrationRetentionDuration,omitempty"`
	RecoveryPointID              *string `json:"recoveryPointId,omitempty"`
	// RestoreTargetInfo - Gets or sets the restore target information.
	RestoreTargetInfo BasicRestoreTargetInfoBase `json:"restoreTargetInfo,omitempty"`
	// SourceDataStoreType - Gets or sets the type of the source data store. Possible values include: 'SourceDataStoreTypeArchiveStore', 'SourceDataStoreTypeSnapshotStore', 'SourceDataStoreTypeVaultStore'
	SourceDataStoreType SourceDataStoreType `json:"sourceDataStoreType,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeAzureBackupRestoreRequest', 'ObjectTypeAzureBackupRecoveryPointBasedRestoreRequest', 'ObjectTypeAzureBackupRestoreWithRehydrationRequest', 'ObjectTypeAzureBackupRecoveryTimeBasedRestoreRequest'
	ObjectType ObjectTypeBasicAzureBackupRestoreRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBackupRestoreWithRehydrationRequest.
func (abrwrr AzureBackupRestoreWithRehydrationRequest) MarshalJSON() ([]byte, error) {
	abrwrr.ObjectType = ObjectTypeAzureBackupRestoreWithRehydrationRequest
	objectMap := make(map[string]interface{})
	if abrwrr.RehydrationPriority != "" {
		objectMap["rehydrationPriority"] = abrwrr.RehydrationPriority
	}
	if abrwrr.RehydrationRetentionDuration != nil {
		objectMap["rehydrationRetentionDuration"] = abrwrr.RehydrationRetentionDuration
	}
	if abrwrr.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = abrwrr.RecoveryPointID
	}
	objectMap["restoreTargetInfo"] = abrwrr.RestoreTargetInfo
	if abrwrr.SourceDataStoreType != "" {
		objectMap["sourceDataStoreType"] = abrwrr.SourceDataStoreType
	}
	if abrwrr.ObjectType != "" {
		objectMap["objectType"] = abrwrr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupRecoveryPointBasedRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRestoreWithRehydrationRequest.
func (abrwrr AzureBackupRestoreWithRehydrationRequest) AsAzureBackupRecoveryPointBasedRestoreRequest() (*AzureBackupRecoveryPointBasedRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureBackupRecoveryPointBasedRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRestoreWithRehydrationRequest.
func (abrwrr AzureBackupRestoreWithRehydrationRequest) AsBasicAzureBackupRecoveryPointBasedRestoreRequest() (BasicAzureBackupRecoveryPointBasedRestoreRequest, bool) {
	return &abrwrr, true
}

// AsAzureBackupRestoreWithRehydrationRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRestoreWithRehydrationRequest.
func (abrwrr AzureBackupRestoreWithRehydrationRequest) AsAzureBackupRestoreWithRehydrationRequest() (*AzureBackupRestoreWithRehydrationRequest, bool) {
	return &abrwrr, true
}

// AsAzureBackupRecoveryTimeBasedRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRestoreWithRehydrationRequest.
func (abrwrr AzureBackupRestoreWithRehydrationRequest) AsAzureBackupRecoveryTimeBasedRestoreRequest() (*AzureBackupRecoveryTimeBasedRestoreRequest, bool) {
	return nil, false
}

// AsAzureBackupRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRestoreWithRehydrationRequest.
func (abrwrr AzureBackupRestoreWithRehydrationRequest) AsAzureBackupRestoreRequest() (*AzureBackupRestoreRequest, bool) {
	return nil, false
}

// AsBasicAzureBackupRestoreRequest is the BasicAzureBackupRestoreRequest implementation for AzureBackupRestoreWithRehydrationRequest.
func (abrwrr AzureBackupRestoreWithRehydrationRequest) AsBasicAzureBackupRestoreRequest() (BasicAzureBackupRestoreRequest, bool) {
	return &abrwrr, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBackupRestoreWithRehydrationRequest struct.
func (abrwrr *AzureBackupRestoreWithRehydrationRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "rehydrationPriority":
			if v != nil {
				var rehydrationPriority RehydrationPriority
				err = json.Unmarshal(*v, &rehydrationPriority)
				if err != nil {
					return err
				}
				abrwrr.RehydrationPriority = rehydrationPriority
			}
		case "rehydrationRetentionDuration":
			if v != nil {
				var rehydrationRetentionDuration string
				err = json.Unmarshal(*v, &rehydrationRetentionDuration)
				if err != nil {
					return err
				}
				abrwrr.RehydrationRetentionDuration = &rehydrationRetentionDuration
			}
		case "recoveryPointId":
			if v != nil {
				var recoveryPointID string
				err = json.Unmarshal(*v, &recoveryPointID)
				if err != nil {
					return err
				}
				abrwrr.RecoveryPointID = &recoveryPointID
			}
		case "restoreTargetInfo":
			if v != nil {
				restoreTargetInfo, err := unmarshalBasicRestoreTargetInfoBase(*v)
				if err != nil {
					return err
				}
				abrwrr.RestoreTargetInfo = restoreTargetInfo
			}
		case "sourceDataStoreType":
			if v != nil {
				var sourceDataStoreType SourceDataStoreType
				err = json.Unmarshal(*v, &sourceDataStoreType)
				if err != nil {
					return err
				}
				abrwrr.SourceDataStoreType = sourceDataStoreType
			}
		case "objectType":
			if v != nil {
				var objectType ObjectTypeBasicAzureBackupRestoreRequest
				err = json.Unmarshal(*v, &objectType)
				if err != nil {
					return err
				}
				abrwrr.ObjectType = objectType
			}
		}
	}

	return nil
}

// AzureBackupRule azure backup rule
type AzureBackupRule struct {
	BackupParameters BasicBackupParameters `json:"backupParameters,omitempty"`
	DataStore        *DataStoreInfoBase    `json:"dataStore,omitempty"`
	Trigger          BasicTriggerContext   `json:"trigger,omitempty"`
	Name             *string               `json:"name,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeBasePolicyRule', 'ObjectTypeAzureBackupRule', 'ObjectTypeAzureRetentionRule'
	ObjectType ObjectTypeBasicBasePolicyRule `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBackupRule.
func (abr AzureBackupRule) MarshalJSON() ([]byte, error) {
	abr.ObjectType = ObjectTypeAzureBackupRule
	objectMap := make(map[string]interface{})
	objectMap["backupParameters"] = abr.BackupParameters
	if abr.DataStore != nil {
		objectMap["dataStore"] = abr.DataStore
	}
	objectMap["trigger"] = abr.Trigger
	if abr.Name != nil {
		objectMap["name"] = abr.Name
	}
	if abr.ObjectType != "" {
		objectMap["objectType"] = abr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupRule is the BasicBasePolicyRule implementation for AzureBackupRule.
func (abr AzureBackupRule) AsAzureBackupRule() (*AzureBackupRule, bool) {
	return &abr, true
}

// AsAzureRetentionRule is the BasicBasePolicyRule implementation for AzureBackupRule.
func (abr AzureBackupRule) AsAzureRetentionRule() (*AzureRetentionRule, bool) {
	return nil, false
}

// AsBasePolicyRule is the BasicBasePolicyRule implementation for AzureBackupRule.
func (abr AzureBackupRule) AsBasePolicyRule() (*BasePolicyRule, bool) {
	return nil, false
}

// AsBasicBasePolicyRule is the BasicBasePolicyRule implementation for AzureBackupRule.
func (abr AzureBackupRule) AsBasicBasePolicyRule() (BasicBasePolicyRule, bool) {
	return &abr, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBackupRule struct.
func (abr *AzureBackupRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "backupParameters":
			if v != nil {
				backupParameters, err := unmarshalBasicBackupParameters(*v)
				if err != nil {
					return err
				}
				abr.BackupParameters = backupParameters
			}
		case "dataStore":
			if v != nil {
				var dataStore DataStoreInfoBase
				err = json.Unmarshal(*v, &dataStore)
				if err != nil {
					return err
				}
				abr.DataStore = &dataStore
			}
		case "trigger":
			if v != nil {
				trigger, err := unmarshalBasicTriggerContext(*v)
				if err != nil {
					return err
				}
				abr.Trigger = trigger
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				abr.Name = &name
			}
		case "objectType":
			if v != nil {
				var objectType ObjectTypeBasicBasePolicyRule
				err = json.Unmarshal(*v, &objectType)
				if err != nil {
					return err
				}
				abr.ObjectType = objectType
			}
		}
	}

	return nil
}

// AzureOperationalStoreParameters parameters for Operational-Tier DataStore
type AzureOperationalStoreParameters struct {
	// ResourceGroupID - Gets or sets the Snapshot Resource Group Uri.
	ResourceGroupID *string `json:"resourceGroupId,omitempty"`
	// DataStoreType - type of datastore; Operational/Vault/Archive. Possible values include: 'OperationalStore', 'VaultStore', 'ArchiveStore'
	DataStoreType DataStoreTypes `json:"dataStoreType,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeDataStoreParameters', 'ObjectTypeAzureOperationalStoreParameters'
	ObjectType ObjectTypeBasicDataStoreParameters `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureOperationalStoreParameters.
func (aosp AzureOperationalStoreParameters) MarshalJSON() ([]byte, error) {
	aosp.ObjectType = ObjectTypeAzureOperationalStoreParameters
	objectMap := make(map[string]interface{})
	if aosp.ResourceGroupID != nil {
		objectMap["resourceGroupId"] = aosp.ResourceGroupID
	}
	if aosp.DataStoreType != "" {
		objectMap["dataStoreType"] = aosp.DataStoreType
	}
	if aosp.ObjectType != "" {
		objectMap["objectType"] = aosp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureOperationalStoreParameters is the BasicDataStoreParameters implementation for AzureOperationalStoreParameters.
func (aosp AzureOperationalStoreParameters) AsAzureOperationalStoreParameters() (*AzureOperationalStoreParameters, bool) {
	return &aosp, true
}

// AsDataStoreParameters is the BasicDataStoreParameters implementation for AzureOperationalStoreParameters.
func (aosp AzureOperationalStoreParameters) AsDataStoreParameters() (*DataStoreParameters, bool) {
	return nil, false
}

// AsBasicDataStoreParameters is the BasicDataStoreParameters implementation for AzureOperationalStoreParameters.
func (aosp AzureOperationalStoreParameters) AsBasicDataStoreParameters() (BasicDataStoreParameters, bool) {
	return &aosp, true
}

// AzureRetentionRule azure retention rule
type AzureRetentionRule struct {
	IsDefault  *bool              `json:"isDefault,omitempty"`
	Lifecycles *[]SourceLifeCycle `json:"lifecycles,omitempty"`
	Name       *string            `json:"name,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeBasePolicyRule', 'ObjectTypeAzureBackupRule', 'ObjectTypeAzureRetentionRule'
	ObjectType ObjectTypeBasicBasePolicyRule `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureRetentionRule.
func (arr AzureRetentionRule) MarshalJSON() ([]byte, error) {
	arr.ObjectType = ObjectTypeAzureRetentionRule
	objectMap := make(map[string]interface{})
	if arr.IsDefault != nil {
		objectMap["isDefault"] = arr.IsDefault
	}
	if arr.Lifecycles != nil {
		objectMap["lifecycles"] = arr.Lifecycles
	}
	if arr.Name != nil {
		objectMap["name"] = arr.Name
	}
	if arr.ObjectType != "" {
		objectMap["objectType"] = arr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupRule is the BasicBasePolicyRule implementation for AzureRetentionRule.
func (arr AzureRetentionRule) AsAzureBackupRule() (*AzureBackupRule, bool) {
	return nil, false
}

// AsAzureRetentionRule is the BasicBasePolicyRule implementation for AzureRetentionRule.
func (arr AzureRetentionRule) AsAzureRetentionRule() (*AzureRetentionRule, bool) {
	return &arr, true
}

// AsBasePolicyRule is the BasicBasePolicyRule implementation for AzureRetentionRule.
func (arr AzureRetentionRule) AsBasePolicyRule() (*BasePolicyRule, bool) {
	return nil, false
}

// AsBasicBasePolicyRule is the BasicBasePolicyRule implementation for AzureRetentionRule.
func (arr AzureRetentionRule) AsBasicBasePolicyRule() (BasicBasePolicyRule, bool) {
	return &arr, true
}

// BasicBackupCriteria backupCriteria base class
type BasicBackupCriteria interface {
	AsScheduleBasedBackupCriteria() (*ScheduleBasedBackupCriteria, bool)
	AsBackupCriteria() (*BackupCriteria, bool)
}

// BackupCriteria backupCriteria base class
type BackupCriteria struct {
	// ObjectType - Possible values include: 'ObjectTypeBackupCriteria', 'ObjectTypeScheduleBasedBackupCriteria'
	ObjectType ObjectTypeBasicBackupCriteria `json:"objectType,omitempty"`
}

func unmarshalBasicBackupCriteria(body []byte) (BasicBackupCriteria, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeScheduleBasedBackupCriteria):
		var sbbc ScheduleBasedBackupCriteria
		err := json.Unmarshal(body, &sbbc)
		return sbbc, err
	default:
		var bc BackupCriteria
		err := json.Unmarshal(body, &bc)
		return bc, err
	}
}
func unmarshalBasicBackupCriteriaArray(body []byte) ([]BasicBackupCriteria, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	bcArray := make([]BasicBackupCriteria, len(rawMessages))

	for index, rawMessage := range rawMessages {
		bc, err := unmarshalBasicBackupCriteria(*rawMessage)
		if err != nil {
			return nil, err
		}
		bcArray[index] = bc
	}
	return bcArray, nil
}

// MarshalJSON is the custom marshaler for BackupCriteria.
func (bc BackupCriteria) MarshalJSON() ([]byte, error) {
	bc.ObjectType = ObjectTypeBackupCriteria
	objectMap := make(map[string]interface{})
	if bc.ObjectType != "" {
		objectMap["objectType"] = bc.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsScheduleBasedBackupCriteria is the BasicBackupCriteria implementation for BackupCriteria.
func (bc BackupCriteria) AsScheduleBasedBackupCriteria() (*ScheduleBasedBackupCriteria, bool) {
	return nil, false
}

// AsBackupCriteria is the BasicBackupCriteria implementation for BackupCriteria.
func (bc BackupCriteria) AsBackupCriteria() (*BackupCriteria, bool) {
	return &bc, true
}

// AsBasicBackupCriteria is the BasicBackupCriteria implementation for BackupCriteria.
func (bc BackupCriteria) AsBasicBackupCriteria() (BasicBackupCriteria, bool) {
	return &bc, true
}

// BackupInstance backup Instance
type BackupInstance struct {
	// FriendlyName - Gets or sets the Backup Instance friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// DataSourceInfo - Gets or sets the data source information.
	DataSourceInfo *Datasource `json:"dataSourceInfo,omitempty"`
	// DataSourceSetInfo - Gets or sets the data source set information.
	DataSourceSetInfo *DatasourceSet `json:"dataSourceSetInfo,omitempty"`
	// PolicyInfo - Gets or sets the policy information.
	PolicyInfo *PolicyInfo `json:"policyInfo,omitempty"`
	// ProtectionStatus - READ-ONLY; Specifies the protection status of the resource
	ProtectionStatus *ProtectionStatusDetails `json:"protectionStatus,omitempty"`
	// CurrentProtectionState - READ-ONLY; Specifies the current protection state of the resource. Possible values include: 'Invalid', 'NotProtected', 'ConfiguringProtection', 'ProtectionConfigured', 'BackupSchedulesSuspended', 'RetentionSchedulesSuspended', 'ProtectionStopped', 'ProtectionError', 'ConfiguringProtectionFailed', 'SoftDeleting', 'SoftDeleted', 'UpdatingProtection'
	CurrentProtectionState CurrentProtectionState `json:"currentProtectionState,omitempty"`
	// ProtectionErrorDetails - READ-ONLY; Specifies the protection error of the resource
	ProtectionErrorDetails *UserFacingError `json:"protectionErrorDetails,omitempty"`
	// ProvisioningState - READ-ONLY; Specifies the provisioning state of the resource i.e. provisioning/updating/Succeeded/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
	ObjectType        *string `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupInstance.
func (bi BackupInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bi.FriendlyName != nil {
		objectMap["friendlyName"] = bi.FriendlyName
	}
	if bi.DataSourceInfo != nil {
		objectMap["dataSourceInfo"] = bi.DataSourceInfo
	}
	if bi.DataSourceSetInfo != nil {
		objectMap["dataSourceSetInfo"] = bi.DataSourceSetInfo
	}
	if bi.PolicyInfo != nil {
		objectMap["policyInfo"] = bi.PolicyInfo
	}
	if bi.ObjectType != nil {
		objectMap["objectType"] = bi.ObjectType
	}
	return json.Marshal(objectMap)
}

// BackupInstanceResource backupInstance Resource
type BackupInstanceResource struct {
	autorest.Response `json:"-"`
	// Properties - BackupInstanceResource properties
	Properties *BackupInstance `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupInstanceResource.
func (bir BackupInstanceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bir.Properties != nil {
		objectMap["properties"] = bir.Properties
	}
	if bir.SystemData != nil {
		objectMap["systemData"] = bir.SystemData
	}
	return json.Marshal(objectMap)
}

// BackupInstanceResourceList backupInstance Resource list response
type BackupInstanceResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]BackupInstanceResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// BackupInstanceResourceListIterator provides access to a complete listing of BackupInstanceResource
// values.
type BackupInstanceResourceListIterator struct {
	i    int
	page BackupInstanceResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BackupInstanceResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupInstanceResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BackupInstanceResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BackupInstanceResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BackupInstanceResourceListIterator) Response() BackupInstanceResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BackupInstanceResourceListIterator) Value() BackupInstanceResource {
	if !iter.page.NotDone() {
		return BackupInstanceResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BackupInstanceResourceListIterator type.
func NewBackupInstanceResourceListIterator(page BackupInstanceResourceListPage) BackupInstanceResourceListIterator {
	return BackupInstanceResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (birl BackupInstanceResourceList) IsEmpty() bool {
	return birl.Value == nil || len(*birl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (birl BackupInstanceResourceList) hasNextLink() bool {
	return birl.NextLink != nil && len(*birl.NextLink) != 0
}

// backupInstanceResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (birl BackupInstanceResourceList) backupInstanceResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !birl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(birl.NextLink)))
}

// BackupInstanceResourceListPage contains a page of BackupInstanceResource values.
type BackupInstanceResourceListPage struct {
	fn   func(context.Context, BackupInstanceResourceList) (BackupInstanceResourceList, error)
	birl BackupInstanceResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BackupInstanceResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupInstanceResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.birl)
		if err != nil {
			return err
		}
		page.birl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BackupInstanceResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BackupInstanceResourceListPage) NotDone() bool {
	return !page.birl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BackupInstanceResourceListPage) Response() BackupInstanceResourceList {
	return page.birl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BackupInstanceResourceListPage) Values() []BackupInstanceResource {
	if page.birl.IsEmpty() {
		return nil
	}
	return *page.birl.Value
}

// Creates a new instance of the BackupInstanceResourceListPage type.
func NewBackupInstanceResourceListPage(cur BackupInstanceResourceList, getNextPage func(context.Context, BackupInstanceResourceList) (BackupInstanceResourceList, error)) BackupInstanceResourceListPage {
	return BackupInstanceResourceListPage{
		fn:   getNextPage,
		birl: cur,
	}
}

// BackupInstancesAdhocBackupFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BackupInstancesAdhocBackupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupInstancesClient) (OperationJobExtendedInfo, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupInstancesAdhocBackupFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupInstancesAdhocBackupFuture.Result.
func (future *BackupInstancesAdhocBackupFuture) result(client BackupInstancesClient) (ojei OperationJobExtendedInfo, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.BackupInstancesAdhocBackupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ojei.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dataprotection.BackupInstancesAdhocBackupFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ojei.Response.Response, err = future.GetResult(sender); err == nil && ojei.Response.Response.StatusCode != http.StatusNoContent {
		ojei, err = client.AdhocBackupResponder(ojei.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dataprotection.BackupInstancesAdhocBackupFuture", "Result", ojei.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackupInstancesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BackupInstancesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupInstancesClient) (BackupInstanceResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupInstancesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupInstancesCreateOrUpdateFuture.Result.
func (future *BackupInstancesCreateOrUpdateFuture) result(client BackupInstancesClient) (bir BackupInstanceResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.BackupInstancesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bir.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dataprotection.BackupInstancesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bir.Response.Response, err = future.GetResult(sender); err == nil && bir.Response.Response.StatusCode != http.StatusNoContent {
		bir, err = client.CreateOrUpdateResponder(bir.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dataprotection.BackupInstancesCreateOrUpdateFuture", "Result", bir.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackupInstancesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BackupInstancesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupInstancesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupInstancesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupInstancesDeleteFuture.Result.
func (future *BackupInstancesDeleteFuture) result(client BackupInstancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.BackupInstancesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dataprotection.BackupInstancesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BackupInstancesTriggerRehydrateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BackupInstancesTriggerRehydrateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupInstancesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupInstancesTriggerRehydrateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupInstancesTriggerRehydrateFuture.Result.
func (future *BackupInstancesTriggerRehydrateFuture) result(client BackupInstancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.BackupInstancesTriggerRehydrateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dataprotection.BackupInstancesTriggerRehydrateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BackupInstancesTriggerRestoreFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BackupInstancesTriggerRestoreFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupInstancesClient) (OperationJobExtendedInfo, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupInstancesTriggerRestoreFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupInstancesTriggerRestoreFuture.Result.
func (future *BackupInstancesTriggerRestoreFuture) result(client BackupInstancesClient) (ojei OperationJobExtendedInfo, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.BackupInstancesTriggerRestoreFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ojei.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dataprotection.BackupInstancesTriggerRestoreFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ojei.Response.Response, err = future.GetResult(sender); err == nil && ojei.Response.Response.StatusCode != http.StatusNoContent {
		ojei, err = client.TriggerRestoreResponder(ojei.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dataprotection.BackupInstancesTriggerRestoreFuture", "Result", ojei.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackupInstancesValidateForBackupFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BackupInstancesValidateForBackupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupInstancesClient) (OperationJobExtendedInfo, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupInstancesValidateForBackupFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupInstancesValidateForBackupFuture.Result.
func (future *BackupInstancesValidateForBackupFuture) result(client BackupInstancesClient) (ojei OperationJobExtendedInfo, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.BackupInstancesValidateForBackupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ojei.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dataprotection.BackupInstancesValidateForBackupFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ojei.Response.Response, err = future.GetResult(sender); err == nil && ojei.Response.Response.StatusCode != http.StatusNoContent {
		ojei, err = client.ValidateForBackupResponder(ojei.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dataprotection.BackupInstancesValidateForBackupFuture", "Result", ojei.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackupInstancesValidateRestoreFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BackupInstancesValidateRestoreFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupInstancesClient) (OperationJobExtendedInfo, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupInstancesValidateRestoreFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupInstancesValidateRestoreFuture.Result.
func (future *BackupInstancesValidateRestoreFuture) result(client BackupInstancesClient) (ojei OperationJobExtendedInfo, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.BackupInstancesValidateRestoreFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ojei.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dataprotection.BackupInstancesValidateRestoreFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ojei.Response.Response, err = future.GetResult(sender); err == nil && ojei.Response.Response.StatusCode != http.StatusNoContent {
		ojei, err = client.ValidateRestoreResponder(ojei.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dataprotection.BackupInstancesValidateRestoreFuture", "Result", ojei.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BasicBackupParameters backupParameters base
type BasicBackupParameters interface {
	AsAzureBackupParams() (*AzureBackupParams, bool)
	AsBackupParameters() (*BackupParameters, bool)
}

// BackupParameters backupParameters base
type BackupParameters struct {
	// ObjectType - Possible values include: 'ObjectTypeBackupParameters', 'ObjectTypeAzureBackupParams'
	ObjectType ObjectTypeBasicBackupParameters `json:"objectType,omitempty"`
}

func unmarshalBasicBackupParameters(body []byte) (BasicBackupParameters, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureBackupParams):
		var abp AzureBackupParams
		err := json.Unmarshal(body, &abp)
		return abp, err
	default:
		var bp BackupParameters
		err := json.Unmarshal(body, &bp)
		return bp, err
	}
}
func unmarshalBasicBackupParametersArray(body []byte) ([]BasicBackupParameters, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	bpArray := make([]BasicBackupParameters, len(rawMessages))

	for index, rawMessage := range rawMessages {
		bp, err := unmarshalBasicBackupParameters(*rawMessage)
		if err != nil {
			return nil, err
		}
		bpArray[index] = bp
	}
	return bpArray, nil
}

// MarshalJSON is the custom marshaler for BackupParameters.
func (bp BackupParameters) MarshalJSON() ([]byte, error) {
	bp.ObjectType = ObjectTypeBackupParameters
	objectMap := make(map[string]interface{})
	if bp.ObjectType != "" {
		objectMap["objectType"] = bp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupParams is the BasicBackupParameters implementation for BackupParameters.
func (bp BackupParameters) AsAzureBackupParams() (*AzureBackupParams, bool) {
	return nil, false
}

// AsBackupParameters is the BasicBackupParameters implementation for BackupParameters.
func (bp BackupParameters) AsBackupParameters() (*BackupParameters, bool) {
	return &bp, true
}

// AsBasicBackupParameters is the BasicBackupParameters implementation for BackupParameters.
func (bp BackupParameters) AsBasicBackupParameters() (BasicBackupParameters, bool) {
	return &bp, true
}

// BackupPolicy rule based backup policy
type BackupPolicy struct {
	// PolicyRules - Policy rule dictionary that contains rules for each backuptype i.e Full/Incremental/Logs etc
	PolicyRules *[]BasicBasePolicyRule `json:"policyRules,omitempty"`
	// DatasourceTypes - Type of datasource for the backup management
	DatasourceTypes *[]string `json:"datasourceTypes,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeBaseBackupPolicy', 'ObjectTypeBackupPolicy'
	ObjectType ObjectTypeBasicBaseBackupPolicy `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupPolicy.
func (bp BackupPolicy) MarshalJSON() ([]byte, error) {
	bp.ObjectType = ObjectTypeBackupPolicy
	objectMap := make(map[string]interface{})
	if bp.PolicyRules != nil {
		objectMap["policyRules"] = bp.PolicyRules
	}
	if bp.DatasourceTypes != nil {
		objectMap["datasourceTypes"] = bp.DatasourceTypes
	}
	if bp.ObjectType != "" {
		objectMap["objectType"] = bp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsBackupPolicy is the BasicBaseBackupPolicy implementation for BackupPolicy.
func (bp BackupPolicy) AsBackupPolicy() (*BackupPolicy, bool) {
	return &bp, true
}

// AsBaseBackupPolicy is the BasicBaseBackupPolicy implementation for BackupPolicy.
func (bp BackupPolicy) AsBaseBackupPolicy() (*BaseBackupPolicy, bool) {
	return nil, false
}

// AsBasicBaseBackupPolicy is the BasicBaseBackupPolicy implementation for BackupPolicy.
func (bp BackupPolicy) AsBasicBaseBackupPolicy() (BasicBaseBackupPolicy, bool) {
	return &bp, true
}

// UnmarshalJSON is the custom unmarshaler for BackupPolicy struct.
func (bp *BackupPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "policyRules":
			if v != nil {
				policyRules, err := unmarshalBasicBasePolicyRuleArray(*v)
				if err != nil {
					return err
				}
				bp.PolicyRules = &policyRules
			}
		case "datasourceTypes":
			if v != nil {
				var datasourceTypes []string
				err = json.Unmarshal(*v, &datasourceTypes)
				if err != nil {
					return err
				}
				bp.DatasourceTypes = &datasourceTypes
			}
		case "objectType":
			if v != nil {
				var objectType ObjectTypeBasicBaseBackupPolicy
				err = json.Unmarshal(*v, &objectType)
				if err != nil {
					return err
				}
				bp.ObjectType = objectType
			}
		}
	}

	return nil
}

// BackupSchedule schedule for backup
type BackupSchedule struct {
	// RepeatingTimeIntervals - ISO 8601 repeating time interval format
	RepeatingTimeIntervals *[]string `json:"repeatingTimeIntervals,omitempty"`
}

// BackupVault backup Vault
type BackupVault struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the BackupVault resource. Possible values include: 'Failed', 'Provisioning', 'Succeeded', 'Unknown', 'Updating'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// StorageSettings - Storage Settings
	StorageSettings *[]StorageSetting `json:"storageSettings,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupVault.
func (bv BackupVault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bv.StorageSettings != nil {
		objectMap["storageSettings"] = bv.StorageSettings
	}
	return json.Marshal(objectMap)
}

// BackupVaultResource backup Vault Resource
type BackupVaultResource struct {
	autorest.Response `json:"-"`
	// Properties - BackupVaultResource properties
	Properties *BackupVault `json:"properties,omitempty"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Identity - Input Managed Identity Details
	Identity *DppIdentityDetails `json:"identity,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupVaultResource.
func (bvr BackupVaultResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bvr.Properties != nil {
		objectMap["properties"] = bvr.Properties
	}
	if bvr.ETag != nil {
		objectMap["eTag"] = bvr.ETag
	}
	if bvr.Identity != nil {
		objectMap["identity"] = bvr.Identity
	}
	if bvr.Location != nil {
		objectMap["location"] = bvr.Location
	}
	if bvr.Tags != nil {
		objectMap["tags"] = bvr.Tags
	}
	if bvr.SystemData != nil {
		objectMap["systemData"] = bvr.SystemData
	}
	return json.Marshal(objectMap)
}

// BackupVaultResourceList list of BackupVault resources
type BackupVaultResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]BackupVaultResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// BackupVaultResourceListIterator provides access to a complete listing of BackupVaultResource values.
type BackupVaultResourceListIterator struct {
	i    int
	page BackupVaultResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BackupVaultResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupVaultResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BackupVaultResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BackupVaultResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BackupVaultResourceListIterator) Response() BackupVaultResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BackupVaultResourceListIterator) Value() BackupVaultResource {
	if !iter.page.NotDone() {
		return BackupVaultResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BackupVaultResourceListIterator type.
func NewBackupVaultResourceListIterator(page BackupVaultResourceListPage) BackupVaultResourceListIterator {
	return BackupVaultResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bvrl BackupVaultResourceList) IsEmpty() bool {
	return bvrl.Value == nil || len(*bvrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bvrl BackupVaultResourceList) hasNextLink() bool {
	return bvrl.NextLink != nil && len(*bvrl.NextLink) != 0
}

// backupVaultResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bvrl BackupVaultResourceList) backupVaultResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !bvrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bvrl.NextLink)))
}

// BackupVaultResourceListPage contains a page of BackupVaultResource values.
type BackupVaultResourceListPage struct {
	fn   func(context.Context, BackupVaultResourceList) (BackupVaultResourceList, error)
	bvrl BackupVaultResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BackupVaultResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupVaultResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bvrl)
		if err != nil {
			return err
		}
		page.bvrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BackupVaultResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BackupVaultResourceListPage) NotDone() bool {
	return !page.bvrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BackupVaultResourceListPage) Response() BackupVaultResourceList {
	return page.bvrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BackupVaultResourceListPage) Values() []BackupVaultResource {
	if page.bvrl.IsEmpty() {
		return nil
	}
	return *page.bvrl.Value
}

// Creates a new instance of the BackupVaultResourceListPage type.
func NewBackupVaultResourceListPage(cur BackupVaultResourceList, getNextPage func(context.Context, BackupVaultResourceList) (BackupVaultResourceList, error)) BackupVaultResourceListPage {
	return BackupVaultResourceListPage{
		fn:   getNextPage,
		bvrl: cur,
	}
}

// BackupVaultsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BackupVaultsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupVaultsClient) (BackupVaultResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupVaultsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupVaultsCreateOrUpdateFuture.Result.
func (future *BackupVaultsCreateOrUpdateFuture) result(client BackupVaultsClient) (bvr BackupVaultResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.BackupVaultsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bvr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dataprotection.BackupVaultsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bvr.Response.Response, err = future.GetResult(sender); err == nil && bvr.Response.Response.StatusCode != http.StatusNoContent {
		bvr, err = client.CreateOrUpdateResponder(bvr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dataprotection.BackupVaultsCreateOrUpdateFuture", "Result", bvr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackupVaultsPatchFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BackupVaultsPatchFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupVaultsClient) (BackupVaultResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupVaultsPatchFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupVaultsPatchFuture.Result.
func (future *BackupVaultsPatchFuture) result(client BackupVaultsClient) (bvr BackupVaultResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.BackupVaultsPatchFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bvr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dataprotection.BackupVaultsPatchFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bvr.Response.Response, err = future.GetResult(sender); err == nil && bvr.Response.Response.StatusCode != http.StatusNoContent {
		bvr, err = client.PatchResponder(bvr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dataprotection.BackupVaultsPatchFuture", "Result", bvr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BasicBaseBackupPolicy backupPolicy base
type BasicBaseBackupPolicy interface {
	AsBackupPolicy() (*BackupPolicy, bool)
	AsBaseBackupPolicy() (*BaseBackupPolicy, bool)
}

// BaseBackupPolicy backupPolicy base
type BaseBackupPolicy struct {
	// DatasourceTypes - Type of datasource for the backup management
	DatasourceTypes *[]string `json:"datasourceTypes,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeBaseBackupPolicy', 'ObjectTypeBackupPolicy'
	ObjectType ObjectTypeBasicBaseBackupPolicy `json:"objectType,omitempty"`
}

func unmarshalBasicBaseBackupPolicy(body []byte) (BasicBaseBackupPolicy, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeBackupPolicy):
		var bp BackupPolicy
		err := json.Unmarshal(body, &bp)
		return bp, err
	default:
		var bbp BaseBackupPolicy
		err := json.Unmarshal(body, &bbp)
		return bbp, err
	}
}
func unmarshalBasicBaseBackupPolicyArray(body []byte) ([]BasicBaseBackupPolicy, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	bbpArray := make([]BasicBaseBackupPolicy, len(rawMessages))

	for index, rawMessage := range rawMessages {
		bbp, err := unmarshalBasicBaseBackupPolicy(*rawMessage)
		if err != nil {
			return nil, err
		}
		bbpArray[index] = bbp
	}
	return bbpArray, nil
}

// MarshalJSON is the custom marshaler for BaseBackupPolicy.
func (bbp BaseBackupPolicy) MarshalJSON() ([]byte, error) {
	bbp.ObjectType = ObjectTypeBaseBackupPolicy
	objectMap := make(map[string]interface{})
	if bbp.DatasourceTypes != nil {
		objectMap["datasourceTypes"] = bbp.DatasourceTypes
	}
	if bbp.ObjectType != "" {
		objectMap["objectType"] = bbp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsBackupPolicy is the BasicBaseBackupPolicy implementation for BaseBackupPolicy.
func (bbp BaseBackupPolicy) AsBackupPolicy() (*BackupPolicy, bool) {
	return nil, false
}

// AsBaseBackupPolicy is the BasicBaseBackupPolicy implementation for BaseBackupPolicy.
func (bbp BaseBackupPolicy) AsBaseBackupPolicy() (*BaseBackupPolicy, bool) {
	return &bbp, true
}

// AsBasicBaseBackupPolicy is the BasicBaseBackupPolicy implementation for BaseBackupPolicy.
func (bbp BaseBackupPolicy) AsBasicBaseBackupPolicy() (BasicBaseBackupPolicy, bool) {
	return &bbp, true
}

// BaseBackupPolicyResource baseBackupPolicy resource
type BaseBackupPolicyResource struct {
	autorest.Response `json:"-"`
	// Properties - BaseBackupPolicyResource properties
	Properties BasicBaseBackupPolicy `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for BaseBackupPolicyResource.
func (bbpr BaseBackupPolicyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = bbpr.Properties
	if bbpr.SystemData != nil {
		objectMap["systemData"] = bbpr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BaseBackupPolicyResource struct.
func (bbpr *BaseBackupPolicyResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicBaseBackupPolicy(*v)
				if err != nil {
					return err
				}
				bbpr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bbpr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bbpr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bbpr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				bbpr.SystemData = &systemData
			}
		}
	}

	return nil
}

// BaseBackupPolicyResourceList list of BaseBackupPolicy resources
type BaseBackupPolicyResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]BaseBackupPolicyResource `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// BaseBackupPolicyResourceListIterator provides access to a complete listing of BaseBackupPolicyResource
// values.
type BaseBackupPolicyResourceListIterator struct {
	i    int
	page BaseBackupPolicyResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BaseBackupPolicyResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseBackupPolicyResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BaseBackupPolicyResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BaseBackupPolicyResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BaseBackupPolicyResourceListIterator) Response() BaseBackupPolicyResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BaseBackupPolicyResourceListIterator) Value() BaseBackupPolicyResource {
	if !iter.page.NotDone() {
		return BaseBackupPolicyResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BaseBackupPolicyResourceListIterator type.
func NewBaseBackupPolicyResourceListIterator(page BaseBackupPolicyResourceListPage) BaseBackupPolicyResourceListIterator {
	return BaseBackupPolicyResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bbprl BaseBackupPolicyResourceList) IsEmpty() bool {
	return bbprl.Value == nil || len(*bbprl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bbprl BaseBackupPolicyResourceList) hasNextLink() bool {
	return bbprl.NextLink != nil && len(*bbprl.NextLink) != 0
}

// baseBackupPolicyResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bbprl BaseBackupPolicyResourceList) baseBackupPolicyResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !bbprl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bbprl.NextLink)))
}

// BaseBackupPolicyResourceListPage contains a page of BaseBackupPolicyResource values.
type BaseBackupPolicyResourceListPage struct {
	fn    func(context.Context, BaseBackupPolicyResourceList) (BaseBackupPolicyResourceList, error)
	bbprl BaseBackupPolicyResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BaseBackupPolicyResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseBackupPolicyResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bbprl)
		if err != nil {
			return err
		}
		page.bbprl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BaseBackupPolicyResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BaseBackupPolicyResourceListPage) NotDone() bool {
	return !page.bbprl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BaseBackupPolicyResourceListPage) Response() BaseBackupPolicyResourceList {
	return page.bbprl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BaseBackupPolicyResourceListPage) Values() []BaseBackupPolicyResource {
	if page.bbprl.IsEmpty() {
		return nil
	}
	return *page.bbprl.Value
}

// Creates a new instance of the BaseBackupPolicyResourceListPage type.
func NewBaseBackupPolicyResourceListPage(cur BaseBackupPolicyResourceList, getNextPage func(context.Context, BaseBackupPolicyResourceList) (BaseBackupPolicyResourceList, error)) BaseBackupPolicyResourceListPage {
	return BaseBackupPolicyResourceListPage{
		fn:    getNextPage,
		bbprl: cur,
	}
}

// BasicBasePolicyRule basePolicy Rule
type BasicBasePolicyRule interface {
	AsAzureBackupRule() (*AzureBackupRule, bool)
	AsAzureRetentionRule() (*AzureRetentionRule, bool)
	AsBasePolicyRule() (*BasePolicyRule, bool)
}

// BasePolicyRule basePolicy Rule
type BasePolicyRule struct {
	Name *string `json:"name,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeBasePolicyRule', 'ObjectTypeAzureBackupRule', 'ObjectTypeAzureRetentionRule'
	ObjectType ObjectTypeBasicBasePolicyRule `json:"objectType,omitempty"`
}

func unmarshalBasicBasePolicyRule(body []byte) (BasicBasePolicyRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureBackupRule):
		var abr AzureBackupRule
		err := json.Unmarshal(body, &abr)
		return abr, err
	case string(ObjectTypeAzureRetentionRule):
		var arr AzureRetentionRule
		err := json.Unmarshal(body, &arr)
		return arr, err
	default:
		var bpr BasePolicyRule
		err := json.Unmarshal(body, &bpr)
		return bpr, err
	}
}
func unmarshalBasicBasePolicyRuleArray(body []byte) ([]BasicBasePolicyRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	bprArray := make([]BasicBasePolicyRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		bpr, err := unmarshalBasicBasePolicyRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		bprArray[index] = bpr
	}
	return bprArray, nil
}

// MarshalJSON is the custom marshaler for BasePolicyRule.
func (bpr BasePolicyRule) MarshalJSON() ([]byte, error) {
	bpr.ObjectType = ObjectTypeBasePolicyRule
	objectMap := make(map[string]interface{})
	if bpr.Name != nil {
		objectMap["name"] = bpr.Name
	}
	if bpr.ObjectType != "" {
		objectMap["objectType"] = bpr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupRule is the BasicBasePolicyRule implementation for BasePolicyRule.
func (bpr BasePolicyRule) AsAzureBackupRule() (*AzureBackupRule, bool) {
	return nil, false
}

// AsAzureRetentionRule is the BasicBasePolicyRule implementation for BasePolicyRule.
func (bpr BasePolicyRule) AsAzureRetentionRule() (*AzureRetentionRule, bool) {
	return nil, false
}

// AsBasePolicyRule is the BasicBasePolicyRule implementation for BasePolicyRule.
func (bpr BasePolicyRule) AsBasePolicyRule() (*BasePolicyRule, bool) {
	return &bpr, true
}

// AsBasicBasePolicyRule is the BasicBasePolicyRule implementation for BasePolicyRule.
func (bpr BasePolicyRule) AsBasicBasePolicyRule() (BasicBasePolicyRule, bool) {
	return &bpr, true
}

// CheckNameAvailabilityRequest checkNameAvailability Request
type CheckNameAvailabilityRequest struct {
	// Name - Resource name for which availability needs to be checked
	Name *string `json:"name,omitempty"`
	// Type - Describes the Resource type: Microsoft.DataProtection/BackupVaults
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResult checkNameAvailability Result
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// Message - Gets or sets the message.
	Message *string `json:"message,omitempty"`
	// NameAvailable - Gets or sets a value indicating whether [name available].
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - Gets or sets the reason.
	Reason *string `json:"reason,omitempty"`
}

// ClientDiscoveryDisplay localized display information of an operation.
type ClientDiscoveryDisplay struct {
	// Description - Description of the operation having details of what operation is about.
	Description *string `json:"description,omitempty"`
	// Operation - Operations Name itself.
	Operation *string `json:"operation,omitempty"`
	// Provider - Name of the provider for display purposes
	Provider *string `json:"provider,omitempty"`
	// Resource - ResourceType for which this Operation can be performed.
	Resource *string `json:"resource,omitempty"`
}

// ClientDiscoveryForLogSpecification class to represent shoebox log specification in json client
// discovery.
type ClientDiscoveryForLogSpecification struct {
	// BlobDuration - blob duration of shoebox log specification
	BlobDuration *string `json:"blobDuration,omitempty"`
	// DisplayName - Localized display name
	DisplayName *string `json:"displayName,omitempty"`
	// Name - Name for shoebox log specification.
	Name *string `json:"name,omitempty"`
}

// ClientDiscoveryForProperties class to represent shoebox properties in json client discovery.
type ClientDiscoveryForProperties struct {
	// ServiceSpecification - Operation properties.
	ServiceSpecification *ClientDiscoveryForServiceSpecification `json:"serviceSpecification,omitempty"`
}

// ClientDiscoveryForServiceSpecification class to represent shoebox service specification in json client
// discovery.
type ClientDiscoveryForServiceSpecification struct {
	// LogSpecifications - List of log specifications of this operation.
	LogSpecifications *[]ClientDiscoveryForLogSpecification `json:"logSpecifications,omitempty"`
}

// ClientDiscoveryResponse operations List response which contains list of available APIs.
type ClientDiscoveryResponse struct {
	autorest.Response `json:"-"`
	// NextLink - Link to the next chunk of Response.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - List of available operations.
	Value *[]ClientDiscoveryValueForSingleAPI `json:"value,omitempty"`
}

// ClientDiscoveryResponseIterator provides access to a complete listing of
// ClientDiscoveryValueForSingleAPI values.
type ClientDiscoveryResponseIterator struct {
	i    int
	page ClientDiscoveryResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClientDiscoveryResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClientDiscoveryResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClientDiscoveryResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClientDiscoveryResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClientDiscoveryResponseIterator) Response() ClientDiscoveryResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClientDiscoveryResponseIterator) Value() ClientDiscoveryValueForSingleAPI {
	if !iter.page.NotDone() {
		return ClientDiscoveryValueForSingleAPI{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClientDiscoveryResponseIterator type.
func NewClientDiscoveryResponseIterator(page ClientDiscoveryResponsePage) ClientDiscoveryResponseIterator {
	return ClientDiscoveryResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cdr ClientDiscoveryResponse) IsEmpty() bool {
	return cdr.Value == nil || len(*cdr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cdr ClientDiscoveryResponse) hasNextLink() bool {
	return cdr.NextLink != nil && len(*cdr.NextLink) != 0
}

// clientDiscoveryResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cdr ClientDiscoveryResponse) clientDiscoveryResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !cdr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cdr.NextLink)))
}

// ClientDiscoveryResponsePage contains a page of ClientDiscoveryValueForSingleAPI values.
type ClientDiscoveryResponsePage struct {
	fn  func(context.Context, ClientDiscoveryResponse) (ClientDiscoveryResponse, error)
	cdr ClientDiscoveryResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClientDiscoveryResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClientDiscoveryResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cdr)
		if err != nil {
			return err
		}
		page.cdr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClientDiscoveryResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClientDiscoveryResponsePage) NotDone() bool {
	return !page.cdr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClientDiscoveryResponsePage) Response() ClientDiscoveryResponse {
	return page.cdr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClientDiscoveryResponsePage) Values() []ClientDiscoveryValueForSingleAPI {
	if page.cdr.IsEmpty() {
		return nil
	}
	return *page.cdr.Value
}

// Creates a new instance of the ClientDiscoveryResponsePage type.
func NewClientDiscoveryResponsePage(cur ClientDiscoveryResponse, getNextPage func(context.Context, ClientDiscoveryResponse) (ClientDiscoveryResponse, error)) ClientDiscoveryResponsePage {
	return ClientDiscoveryResponsePage{
		fn:  getNextPage,
		cdr: cur,
	}
}

// ClientDiscoveryValueForSingleAPI available operation details.
type ClientDiscoveryValueForSingleAPI struct {
	// Display - Contains the localized display information for this particular operation
	Display *ClientDiscoveryDisplay `json:"display,omitempty"`
	// Name - Name of the Operation.
	Name *string `json:"name,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Origin - The intended executor of the operation;governs the display of the operation in the RBAC UX and the audit logs UX
	Origin *string `json:"origin,omitempty"`
	// Properties - Properties for the given operation.
	Properties *ClientDiscoveryForProperties `json:"properties,omitempty"`
}

// CloudError an error response from Azure Backup.
type CloudError struct {
	Error *Error `json:"error,omitempty"`
}

// CopyOnExpiryOption copy on Expiry Option
type CopyOnExpiryOption struct {
	// ObjectType - Possible values include: 'ObjectTypeCopyOption', 'ObjectTypeCopyOnExpiryOption', 'ObjectTypeCustomCopyOption', 'ObjectTypeImmediateCopyOption'
	ObjectType ObjectTypeBasicCopyOption `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for CopyOnExpiryOption.
func (coeo CopyOnExpiryOption) MarshalJSON() ([]byte, error) {
	coeo.ObjectType = ObjectTypeCopyOnExpiryOption
	objectMap := make(map[string]interface{})
	if coeo.ObjectType != "" {
		objectMap["objectType"] = coeo.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsCopyOnExpiryOption is the BasicCopyOption implementation for CopyOnExpiryOption.
func (coeo CopyOnExpiryOption) AsCopyOnExpiryOption() (*CopyOnExpiryOption, bool) {
	return &coeo, true
}

// AsCustomCopyOption is the BasicCopyOption implementation for CopyOnExpiryOption.
func (coeo CopyOnExpiryOption) AsCustomCopyOption() (*CustomCopyOption, bool) {
	return nil, false
}

// AsImmediateCopyOption is the BasicCopyOption implementation for CopyOnExpiryOption.
func (coeo CopyOnExpiryOption) AsImmediateCopyOption() (*ImmediateCopyOption, bool) {
	return nil, false
}

// AsCopyOption is the BasicCopyOption implementation for CopyOnExpiryOption.
func (coeo CopyOnExpiryOption) AsCopyOption() (*CopyOption, bool) {
	return nil, false
}

// AsBasicCopyOption is the BasicCopyOption implementation for CopyOnExpiryOption.
func (coeo CopyOnExpiryOption) AsBasicCopyOption() (BasicCopyOption, bool) {
	return &coeo, true
}

// BasicCopyOption options to copy
type BasicCopyOption interface {
	AsCopyOnExpiryOption() (*CopyOnExpiryOption, bool)
	AsCustomCopyOption() (*CustomCopyOption, bool)
	AsImmediateCopyOption() (*ImmediateCopyOption, bool)
	AsCopyOption() (*CopyOption, bool)
}

// CopyOption options to copy
type CopyOption struct {
	// ObjectType - Possible values include: 'ObjectTypeCopyOption', 'ObjectTypeCopyOnExpiryOption', 'ObjectTypeCustomCopyOption', 'ObjectTypeImmediateCopyOption'
	ObjectType ObjectTypeBasicCopyOption `json:"objectType,omitempty"`
}

func unmarshalBasicCopyOption(body []byte) (BasicCopyOption, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeCopyOnExpiryOption):
		var coeo CopyOnExpiryOption
		err := json.Unmarshal(body, &coeo)
		return coeo, err
	case string(ObjectTypeCustomCopyOption):
		var cco CustomCopyOption
		err := json.Unmarshal(body, &cco)
		return cco, err
	case string(ObjectTypeImmediateCopyOption):
		var ico ImmediateCopyOption
		err := json.Unmarshal(body, &ico)
		return ico, err
	default:
		var co CopyOption
		err := json.Unmarshal(body, &co)
		return co, err
	}
}
func unmarshalBasicCopyOptionArray(body []byte) ([]BasicCopyOption, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	coArray := make([]BasicCopyOption, len(rawMessages))

	for index, rawMessage := range rawMessages {
		co, err := unmarshalBasicCopyOption(*rawMessage)
		if err != nil {
			return nil, err
		}
		coArray[index] = co
	}
	return coArray, nil
}

// MarshalJSON is the custom marshaler for CopyOption.
func (co CopyOption) MarshalJSON() ([]byte, error) {
	co.ObjectType = ObjectTypeCopyOption
	objectMap := make(map[string]interface{})
	if co.ObjectType != "" {
		objectMap["objectType"] = co.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsCopyOnExpiryOption is the BasicCopyOption implementation for CopyOption.
func (co CopyOption) AsCopyOnExpiryOption() (*CopyOnExpiryOption, bool) {
	return nil, false
}

// AsCustomCopyOption is the BasicCopyOption implementation for CopyOption.
func (co CopyOption) AsCustomCopyOption() (*CustomCopyOption, bool) {
	return nil, false
}

// AsImmediateCopyOption is the BasicCopyOption implementation for CopyOption.
func (co CopyOption) AsImmediateCopyOption() (*ImmediateCopyOption, bool) {
	return nil, false
}

// AsCopyOption is the BasicCopyOption implementation for CopyOption.
func (co CopyOption) AsCopyOption() (*CopyOption, bool) {
	return &co, true
}

// AsBasicCopyOption is the BasicCopyOption implementation for CopyOption.
func (co CopyOption) AsBasicCopyOption() (BasicCopyOption, bool) {
	return &co, true
}

// CustomCopyOption duration based custom options to copy
type CustomCopyOption struct {
	// Duration - Data copied after given timespan
	Duration *string `json:"duration,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeCopyOption', 'ObjectTypeCopyOnExpiryOption', 'ObjectTypeCustomCopyOption', 'ObjectTypeImmediateCopyOption'
	ObjectType ObjectTypeBasicCopyOption `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomCopyOption.
func (cco CustomCopyOption) MarshalJSON() ([]byte, error) {
	cco.ObjectType = ObjectTypeCustomCopyOption
	objectMap := make(map[string]interface{})
	if cco.Duration != nil {
		objectMap["duration"] = cco.Duration
	}
	if cco.ObjectType != "" {
		objectMap["objectType"] = cco.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsCopyOnExpiryOption is the BasicCopyOption implementation for CustomCopyOption.
func (cco CustomCopyOption) AsCopyOnExpiryOption() (*CopyOnExpiryOption, bool) {
	return nil, false
}

// AsCustomCopyOption is the BasicCopyOption implementation for CustomCopyOption.
func (cco CustomCopyOption) AsCustomCopyOption() (*CustomCopyOption, bool) {
	return &cco, true
}

// AsImmediateCopyOption is the BasicCopyOption implementation for CustomCopyOption.
func (cco CustomCopyOption) AsImmediateCopyOption() (*ImmediateCopyOption, bool) {
	return nil, false
}

// AsCopyOption is the BasicCopyOption implementation for CustomCopyOption.
func (cco CustomCopyOption) AsCopyOption() (*CopyOption, bool) {
	return nil, false
}

// AsBasicCopyOption is the BasicCopyOption implementation for CustomCopyOption.
func (cco CustomCopyOption) AsBasicCopyOption() (BasicCopyOption, bool) {
	return &cco, true
}

// Datasource datasource to be backed up
type Datasource struct {
	// DatasourceType - DatasourceType of the resource.
	DatasourceType *string `json:"datasourceType,omitempty"`
	// ObjectType - Type of Datasource object, used to initialize the right inherited type
	ObjectType *string `json:"objectType,omitempty"`
	// ResourceID - Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID created by backup service via Fabric/Vault.
	ResourceID *string `json:"resourceID,omitempty"`
	// ResourceLocation - Location of datasource.
	ResourceLocation *string `json:"resourceLocation,omitempty"`
	// ResourceName - Unique identifier of the resource in the context of parent.
	ResourceName *string `json:"resourceName,omitempty"`
	// ResourceType - Resource Type of Datasource.
	ResourceType *string `json:"resourceType,omitempty"`
	// ResourceURI - Uri of the resource.
	ResourceURI *string `json:"resourceUri,omitempty"`
}

// DatasourceSet datasourceSet details of datasource to be backed up
type DatasourceSet struct {
	// DatasourceType - DatasourceType of the resource.
	DatasourceType *string `json:"datasourceType,omitempty"`
	// ObjectType - Type of Datasource object, used to initialize the right inherited type
	ObjectType *string `json:"objectType,omitempty"`
	// ResourceID - Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID created by backup service via Fabric/Vault.
	ResourceID *string `json:"resourceID,omitempty"`
	// ResourceLocation - Location of datasource.
	ResourceLocation *string `json:"resourceLocation,omitempty"`
	// ResourceName - Unique identifier of the resource in the context of parent.
	ResourceName *string `json:"resourceName,omitempty"`
	// ResourceType - Resource Type of Datasource.
	ResourceType *string `json:"resourceType,omitempty"`
	// ResourceURI - Uri of the resource.
	ResourceURI *string `json:"resourceUri,omitempty"`
}

// DataStoreInfoBase dataStoreInfo base
type DataStoreInfoBase struct {
	// DataStoreType - type of datastore; Operational/Vault/Archive. Possible values include: 'OperationalStore', 'VaultStore', 'ArchiveStore'
	DataStoreType DataStoreTypes `json:"dataStoreType,omitempty"`
	// ObjectType - Type of Datasource object, used to initialize the right inherited type
	ObjectType *string `json:"objectType,omitempty"`
}

// BasicDataStoreParameters parameters for DataStore
type BasicDataStoreParameters interface {
	AsAzureOperationalStoreParameters() (*AzureOperationalStoreParameters, bool)
	AsDataStoreParameters() (*DataStoreParameters, bool)
}

// DataStoreParameters parameters for DataStore
type DataStoreParameters struct {
	// DataStoreType - type of datastore; Operational/Vault/Archive. Possible values include: 'OperationalStore', 'VaultStore', 'ArchiveStore'
	DataStoreType DataStoreTypes `json:"dataStoreType,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeDataStoreParameters', 'ObjectTypeAzureOperationalStoreParameters'
	ObjectType ObjectTypeBasicDataStoreParameters `json:"objectType,omitempty"`
}

func unmarshalBasicDataStoreParameters(body []byte) (BasicDataStoreParameters, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAzureOperationalStoreParameters):
		var aosp AzureOperationalStoreParameters
		err := json.Unmarshal(body, &aosp)
		return aosp, err
	default:
		var dsp DataStoreParameters
		err := json.Unmarshal(body, &dsp)
		return dsp, err
	}
}
func unmarshalBasicDataStoreParametersArray(body []byte) ([]BasicDataStoreParameters, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dspArray := make([]BasicDataStoreParameters, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dsp, err := unmarshalBasicDataStoreParameters(*rawMessage)
		if err != nil {
			return nil, err
		}
		dspArray[index] = dsp
	}
	return dspArray, nil
}

// MarshalJSON is the custom marshaler for DataStoreParameters.
func (dsp DataStoreParameters) MarshalJSON() ([]byte, error) {
	dsp.ObjectType = ObjectTypeDataStoreParameters
	objectMap := make(map[string]interface{})
	if dsp.DataStoreType != "" {
		objectMap["dataStoreType"] = dsp.DataStoreType
	}
	if dsp.ObjectType != "" {
		objectMap["objectType"] = dsp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureOperationalStoreParameters is the BasicDataStoreParameters implementation for DataStoreParameters.
func (dsp DataStoreParameters) AsAzureOperationalStoreParameters() (*AzureOperationalStoreParameters, bool) {
	return nil, false
}

// AsDataStoreParameters is the BasicDataStoreParameters implementation for DataStoreParameters.
func (dsp DataStoreParameters) AsDataStoreParameters() (*DataStoreParameters, bool) {
	return &dsp, true
}

// AsBasicDataStoreParameters is the BasicDataStoreParameters implementation for DataStoreParameters.
func (dsp DataStoreParameters) AsBasicDataStoreParameters() (BasicDataStoreParameters, bool) {
	return &dsp, true
}

// Day day of the week
type Day struct {
	// Date - Date of the month
	Date *int32 `json:"date,omitempty"`
	// IsLast - Whether Date is last date of month
	IsLast *bool `json:"isLast,omitempty"`
}

// BasicDeleteOption delete Option
type BasicDeleteOption interface {
	AsAbsoluteDeleteOption() (*AbsoluteDeleteOption, bool)
	AsDeleteOption() (*DeleteOption, bool)
}

// DeleteOption delete Option
type DeleteOption struct {
	// Duration - Duration of deletion after given timespan
	Duration *string `json:"duration,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeDeleteOption', 'ObjectTypeAbsoluteDeleteOption'
	ObjectType ObjectTypeBasicDeleteOption `json:"objectType,omitempty"`
}

func unmarshalBasicDeleteOption(body []byte) (BasicDeleteOption, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAbsoluteDeleteOption):
		var ado AbsoluteDeleteOption
		err := json.Unmarshal(body, &ado)
		return ado, err
	default:
		var do DeleteOption
		err := json.Unmarshal(body, &do)
		return do, err
	}
}
func unmarshalBasicDeleteOptionArray(body []byte) ([]BasicDeleteOption, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	doArray := make([]BasicDeleteOption, len(rawMessages))

	for index, rawMessage := range rawMessages {
		do, err := unmarshalBasicDeleteOption(*rawMessage)
		if err != nil {
			return nil, err
		}
		doArray[index] = do
	}
	return doArray, nil
}

// MarshalJSON is the custom marshaler for DeleteOption.
func (do DeleteOption) MarshalJSON() ([]byte, error) {
	do.ObjectType = ObjectTypeDeleteOption
	objectMap := make(map[string]interface{})
	if do.Duration != nil {
		objectMap["duration"] = do.Duration
	}
	if do.ObjectType != "" {
		objectMap["objectType"] = do.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAbsoluteDeleteOption is the BasicDeleteOption implementation for DeleteOption.
func (do DeleteOption) AsAbsoluteDeleteOption() (*AbsoluteDeleteOption, bool) {
	return nil, false
}

// AsDeleteOption is the BasicDeleteOption implementation for DeleteOption.
func (do DeleteOption) AsDeleteOption() (*DeleteOption, bool) {
	return &do, true
}

// AsBasicDeleteOption is the BasicDeleteOption implementation for DeleteOption.
func (do DeleteOption) AsBasicDeleteOption() (BasicDeleteOption, bool) {
	return &do, true
}

// DppIdentityDetails identity details
type DppIdentityDetails struct {
	// PrincipalID - READ-ONLY; The object ID of the service principal object for the managed identity that is used to grant role-based access to an Azure resource.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; A Globally Unique Identifier (GUID) that represents the Azure AD tenant where the resource is now a member.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identityType which can be either SystemAssigned or None
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DppIdentityDetails.
func (did DppIdentityDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if did.Type != nil {
		objectMap["type"] = did.Type
	}
	return json.Marshal(objectMap)
}

// DppResource resource class
type DppResource struct {
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for DppResource.
func (dr DppResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dr.SystemData != nil {
		objectMap["systemData"] = dr.SystemData
	}
	return json.Marshal(objectMap)
}

// DppResourceList listResource
type DppResourceList struct {
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// DppTrackedResource ...
type DppTrackedResource struct {
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
	// ID - READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Identity - Input Managed Identity Details
	Identity *DppIdentityDetails `json:"identity,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Name - READ-ONLY; Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Type - READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type       *string     `json:"type,omitempty"`
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for DppTrackedResource.
func (dtr DppTrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dtr.ETag != nil {
		objectMap["eTag"] = dtr.ETag
	}
	if dtr.Identity != nil {
		objectMap["identity"] = dtr.Identity
	}
	if dtr.Location != nil {
		objectMap["location"] = dtr.Location
	}
	if dtr.Tags != nil {
		objectMap["tags"] = dtr.Tags
	}
	if dtr.SystemData != nil {
		objectMap["systemData"] = dtr.SystemData
	}
	return json.Marshal(objectMap)
}

// DppTrackedResourceList ...
type DppTrackedResourceList struct {
	// NextLink - The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// DppWorkerRequest ...
type DppWorkerRequest struct {
	SubscriptionID         *string             `json:"subscriptionId,omitempty"`
	URI                    *string             `json:"uri,omitempty"`
	Headers                map[string][]string `json:"headers"`
	SupportedGroupVersions *[]string           `json:"supportedGroupVersions,omitempty"`
	CultureInfo            *string             `json:"cultureInfo,omitempty"`
	Parameters             map[string]*string  `json:"parameters"`
	HTTPMethod             *string             `json:"httpMethod,omitempty"`
}

// MarshalJSON is the custom marshaler for DppWorkerRequest.
func (dwr DppWorkerRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dwr.SubscriptionID != nil {
		objectMap["subscriptionId"] = dwr.SubscriptionID
	}
	if dwr.URI != nil {
		objectMap["uri"] = dwr.URI
	}
	if dwr.Headers != nil {
		objectMap["headers"] = dwr.Headers
	}
	if dwr.SupportedGroupVersions != nil {
		objectMap["supportedGroupVersions"] = dwr.SupportedGroupVersions
	}
	if dwr.CultureInfo != nil {
		objectMap["cultureInfo"] = dwr.CultureInfo
	}
	if dwr.Parameters != nil {
		objectMap["parameters"] = dwr.Parameters
	}
	if dwr.HTTPMethod != nil {
		objectMap["httpMethod"] = dwr.HTTPMethod
	}
	return json.Marshal(objectMap)
}

// Error the resource management error response.
type Error struct {
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]Error `json:"details,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
}

// ExportJobsResult the result for export jobs containing blob details.
type ExportJobsResult struct {
	autorest.Response `json:"-"`
	// BlobURL - READ-ONLY; URL of the blob into which the serialized string of list of jobs is exported.
	BlobURL *string `json:"blobUrl,omitempty"`
	// BlobSasKey - READ-ONLY; SAS key to access the blob.
	BlobSasKey *string `json:"blobSasKey,omitempty"`
	// ExcelFileBlobURL - READ-ONLY; URL of the blob into which the ExcelFile is uploaded.
	ExcelFileBlobURL *string `json:"excelFileBlobUrl,omitempty"`
	// ExcelFileBlobSasKey - READ-ONLY; SAS key to access the ExcelFile blob.
	ExcelFileBlobSasKey *string `json:"excelFileBlobSasKey,omitempty"`
}

// ExportJobsTriggerFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExportJobsTriggerFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExportJobsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExportJobsTriggerFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExportJobsTriggerFuture.Result.
func (future *ExportJobsTriggerFuture) result(client ExportJobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ExportJobsTriggerFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("dataprotection.ExportJobsTriggerFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FeatureValidationRequest base class for feature object
type FeatureValidationRequest struct {
	// FeatureType - backup support feature type. Possible values include: 'FeatureTypeInvalid', 'FeatureTypeDataSourceType'
	FeatureType FeatureType `json:"featureType,omitempty"`
	// FeatureName - backup support feature name.
	FeatureName *string `json:"featureName,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeFeatureValidationRequestBase', 'ObjectTypeFeatureValidationRequest'
	ObjectType ObjectTypeBasicFeatureValidationRequestBase `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for FeatureValidationRequest.
func (fvr FeatureValidationRequest) MarshalJSON() ([]byte, error) {
	fvr.ObjectType = ObjectTypeFeatureValidationRequest
	objectMap := make(map[string]interface{})
	if fvr.FeatureType != "" {
		objectMap["featureType"] = fvr.FeatureType
	}
	if fvr.FeatureName != nil {
		objectMap["featureName"] = fvr.FeatureName
	}
	if fvr.ObjectType != "" {
		objectMap["objectType"] = fvr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsFeatureValidationRequest is the BasicFeatureValidationRequestBase implementation for FeatureValidationRequest.
func (fvr FeatureValidationRequest) AsFeatureValidationRequest() (*FeatureValidationRequest, bool) {
	return &fvr, true
}

// AsFeatureValidationRequestBase is the BasicFeatureValidationRequestBase implementation for FeatureValidationRequest.
func (fvr FeatureValidationRequest) AsFeatureValidationRequestBase() (*FeatureValidationRequestBase, bool) {
	return nil, false
}

// AsBasicFeatureValidationRequestBase is the BasicFeatureValidationRequestBase implementation for FeatureValidationRequest.
func (fvr FeatureValidationRequest) AsBasicFeatureValidationRequestBase() (BasicFeatureValidationRequestBase, bool) {
	return &fvr, true
}

// BasicFeatureValidationRequestBase base class for Backup Feature support
type BasicFeatureValidationRequestBase interface {
	AsFeatureValidationRequest() (*FeatureValidationRequest, bool)
	AsFeatureValidationRequestBase() (*FeatureValidationRequestBase, bool)
}

// FeatureValidationRequestBase base class for Backup Feature support
type FeatureValidationRequestBase struct {
	// ObjectType - Possible values include: 'ObjectTypeFeatureValidationRequestBase', 'ObjectTypeFeatureValidationRequest'
	ObjectType ObjectTypeBasicFeatureValidationRequestBase `json:"objectType,omitempty"`
}

func unmarshalBasicFeatureValidationRequestBase(body []byte) (BasicFeatureValidationRequestBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeFeatureValidationRequest):
		var fvr FeatureValidationRequest
		err := json.Unmarshal(body, &fvr)
		return fvr, err
	default:
		var fvrb FeatureValidationRequestBase
		err := json.Unmarshal(body, &fvrb)
		return fvrb, err
	}
}
func unmarshalBasicFeatureValidationRequestBaseArray(body []byte) ([]BasicFeatureValidationRequestBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fvrbArray := make([]BasicFeatureValidationRequestBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fvrb, err := unmarshalBasicFeatureValidationRequestBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		fvrbArray[index] = fvrb
	}
	return fvrbArray, nil
}

// MarshalJSON is the custom marshaler for FeatureValidationRequestBase.
func (fvrb FeatureValidationRequestBase) MarshalJSON() ([]byte, error) {
	fvrb.ObjectType = ObjectTypeFeatureValidationRequestBase
	objectMap := make(map[string]interface{})
	if fvrb.ObjectType != "" {
		objectMap["objectType"] = fvrb.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsFeatureValidationRequest is the BasicFeatureValidationRequestBase implementation for FeatureValidationRequestBase.
func (fvrb FeatureValidationRequestBase) AsFeatureValidationRequest() (*FeatureValidationRequest, bool) {
	return nil, false
}

// AsFeatureValidationRequestBase is the BasicFeatureValidationRequestBase implementation for FeatureValidationRequestBase.
func (fvrb FeatureValidationRequestBase) AsFeatureValidationRequestBase() (*FeatureValidationRequestBase, bool) {
	return &fvrb, true
}

// AsBasicFeatureValidationRequestBase is the BasicFeatureValidationRequestBase implementation for FeatureValidationRequestBase.
func (fvrb FeatureValidationRequestBase) AsBasicFeatureValidationRequestBase() (BasicFeatureValidationRequestBase, bool) {
	return &fvrb, true
}

// FeatureValidationResponse feature Validation Response
type FeatureValidationResponse struct {
	// FeatureType - backup support feature type. Possible values include: 'FeatureTypeInvalid', 'FeatureTypeDataSourceType'
	FeatureType FeatureType `json:"featureType,omitempty"`
	// Features - Response features
	Features *[]SupportedFeature `json:"features,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeFeatureValidationResponseBase', 'ObjectTypeFeatureValidationResponse'
	ObjectType ObjectTypeBasicFeatureValidationResponseBase `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for FeatureValidationResponse.
func (fvr FeatureValidationResponse) MarshalJSON() ([]byte, error) {
	fvr.ObjectType = ObjectTypeFeatureValidationResponse
	objectMap := make(map[string]interface{})
	if fvr.FeatureType != "" {
		objectMap["featureType"] = fvr.FeatureType
	}
	if fvr.Features != nil {
		objectMap["features"] = fvr.Features
	}
	if fvr.ObjectType != "" {
		objectMap["objectType"] = fvr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsFeatureValidationResponse is the BasicFeatureValidationResponseBase implementation for FeatureValidationResponse.
func (fvr FeatureValidationResponse) AsFeatureValidationResponse() (*FeatureValidationResponse, bool) {
	return &fvr, true
}

// AsFeatureValidationResponseBase is the BasicFeatureValidationResponseBase implementation for FeatureValidationResponse.
func (fvr FeatureValidationResponse) AsFeatureValidationResponseBase() (*FeatureValidationResponseBase, bool) {
	return nil, false
}

// AsBasicFeatureValidationResponseBase is the BasicFeatureValidationResponseBase implementation for FeatureValidationResponse.
func (fvr FeatureValidationResponse) AsBasicFeatureValidationResponseBase() (BasicFeatureValidationResponseBase, bool) {
	return &fvr, true
}

// BasicFeatureValidationResponseBase base class for Backup Feature support
type BasicFeatureValidationResponseBase interface {
	AsFeatureValidationResponse() (*FeatureValidationResponse, bool)
	AsFeatureValidationResponseBase() (*FeatureValidationResponseBase, bool)
}

// FeatureValidationResponseBase base class for Backup Feature support
type FeatureValidationResponseBase struct {
	autorest.Response `json:"-"`
	// ObjectType - Possible values include: 'ObjectTypeFeatureValidationResponseBase', 'ObjectTypeFeatureValidationResponse'
	ObjectType ObjectTypeBasicFeatureValidationResponseBase `json:"objectType,omitempty"`
}

func unmarshalBasicFeatureValidationResponseBase(body []byte) (BasicFeatureValidationResponseBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeFeatureValidationResponse):
		var fvr FeatureValidationResponse
		err := json.Unmarshal(body, &fvr)
		return fvr, err
	default:
		var fvrb FeatureValidationResponseBase
		err := json.Unmarshal(body, &fvrb)
		return fvrb, err
	}
}
func unmarshalBasicFeatureValidationResponseBaseArray(body []byte) ([]BasicFeatureValidationResponseBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fvrbArray := make([]BasicFeatureValidationResponseBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fvrb, err := unmarshalBasicFeatureValidationResponseBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		fvrbArray[index] = fvrb
	}
	return fvrbArray, nil
}

// MarshalJSON is the custom marshaler for FeatureValidationResponseBase.
func (fvrb FeatureValidationResponseBase) MarshalJSON() ([]byte, error) {
	fvrb.ObjectType = ObjectTypeFeatureValidationResponseBase
	objectMap := make(map[string]interface{})
	if fvrb.ObjectType != "" {
		objectMap["objectType"] = fvrb.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsFeatureValidationResponse is the BasicFeatureValidationResponseBase implementation for FeatureValidationResponseBase.
func (fvrb FeatureValidationResponseBase) AsFeatureValidationResponse() (*FeatureValidationResponse, bool) {
	return nil, false
}

// AsFeatureValidationResponseBase is the BasicFeatureValidationResponseBase implementation for FeatureValidationResponseBase.
func (fvrb FeatureValidationResponseBase) AsFeatureValidationResponseBase() (*FeatureValidationResponseBase, bool) {
	return &fvrb, true
}

// AsBasicFeatureValidationResponseBase is the BasicFeatureValidationResponseBase implementation for FeatureValidationResponseBase.
func (fvrb FeatureValidationResponseBase) AsBasicFeatureValidationResponseBase() (BasicFeatureValidationResponseBase, bool) {
	return &fvrb, true
}

// FeatureValidationResponseBaseModel ...
type FeatureValidationResponseBaseModel struct {
	autorest.Response `json:"-"`
	Value             BasicFeatureValidationResponseBase `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for FeatureValidationResponseBaseModel struct.
func (fvrbm *FeatureValidationResponseBaseModel) UnmarshalJSON(body []byte) error {
	fvrb, err := unmarshalBasicFeatureValidationResponseBase(body)
	if err != nil {
		return err
	}
	fvrbm.Value = fvrb

	return nil
}

// ImmediateCopyOption immediate copy Option
type ImmediateCopyOption struct {
	// ObjectType - Possible values include: 'ObjectTypeCopyOption', 'ObjectTypeCopyOnExpiryOption', 'ObjectTypeCustomCopyOption', 'ObjectTypeImmediateCopyOption'
	ObjectType ObjectTypeBasicCopyOption `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for ImmediateCopyOption.
func (ico ImmediateCopyOption) MarshalJSON() ([]byte, error) {
	ico.ObjectType = ObjectTypeImmediateCopyOption
	objectMap := make(map[string]interface{})
	if ico.ObjectType != "" {
		objectMap["objectType"] = ico.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsCopyOnExpiryOption is the BasicCopyOption implementation for ImmediateCopyOption.
func (ico ImmediateCopyOption) AsCopyOnExpiryOption() (*CopyOnExpiryOption, bool) {
	return nil, false
}

// AsCustomCopyOption is the BasicCopyOption implementation for ImmediateCopyOption.
func (ico ImmediateCopyOption) AsCustomCopyOption() (*CustomCopyOption, bool) {
	return nil, false
}

// AsImmediateCopyOption is the BasicCopyOption implementation for ImmediateCopyOption.
func (ico ImmediateCopyOption) AsImmediateCopyOption() (*ImmediateCopyOption, bool) {
	return &ico, true
}

// AsCopyOption is the BasicCopyOption implementation for ImmediateCopyOption.
func (ico ImmediateCopyOption) AsCopyOption() (*CopyOption, bool) {
	return nil, false
}

// AsBasicCopyOption is the BasicCopyOption implementation for ImmediateCopyOption.
func (ico ImmediateCopyOption) AsBasicCopyOption() (BasicCopyOption, bool) {
	return &ico, true
}

// InnerError inner Error
type InnerError struct {
	// AdditionalInfo - Any Key value pairs that can be provided to the client for additional  verbose information.
	AdditionalInfo map[string]*string `json:"additionalInfo"`
	// Code - Unique code for this error
	Code *string `json:"code,omitempty"`
	// EmbeddedInnerError - Child Inner Error, to allow Nesting.
	EmbeddedInnerError *InnerError `json:"embeddedInnerError,omitempty"`
}

// MarshalJSON is the custom marshaler for InnerError.
func (ie InnerError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ie.AdditionalInfo != nil {
		objectMap["additionalInfo"] = ie.AdditionalInfo
	}
	if ie.Code != nil {
		objectMap["code"] = ie.Code
	}
	if ie.EmbeddedInnerError != nil {
		objectMap["embeddedInnerError"] = ie.EmbeddedInnerError
	}
	return json.Marshal(objectMap)
}

// BasicItemLevelRestoreCriteria class to contain criteria for item level restore
type BasicItemLevelRestoreCriteria interface {
	AsRangeBasedItemLevelRestoreCriteria() (*RangeBasedItemLevelRestoreCriteria, bool)
	AsItemLevelRestoreCriteria() (*ItemLevelRestoreCriteria, bool)
}

// ItemLevelRestoreCriteria class to contain criteria for item level restore
type ItemLevelRestoreCriteria struct {
	// ObjectType - Possible values include: 'ObjectTypeItemLevelRestoreCriteria', 'ObjectTypeRangeBasedItemLevelRestoreCriteria'
	ObjectType ObjectTypeBasicItemLevelRestoreCriteria `json:"objectType,omitempty"`
}

func unmarshalBasicItemLevelRestoreCriteria(body []byte) (BasicItemLevelRestoreCriteria, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeRangeBasedItemLevelRestoreCriteria):
		var rbilrc RangeBasedItemLevelRestoreCriteria
		err := json.Unmarshal(body, &rbilrc)
		return rbilrc, err
	default:
		var ilrc ItemLevelRestoreCriteria
		err := json.Unmarshal(body, &ilrc)
		return ilrc, err
	}
}
func unmarshalBasicItemLevelRestoreCriteriaArray(body []byte) ([]BasicItemLevelRestoreCriteria, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ilrcArray := make([]BasicItemLevelRestoreCriteria, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ilrc, err := unmarshalBasicItemLevelRestoreCriteria(*rawMessage)
		if err != nil {
			return nil, err
		}
		ilrcArray[index] = ilrc
	}
	return ilrcArray, nil
}

// MarshalJSON is the custom marshaler for ItemLevelRestoreCriteria.
func (ilrc ItemLevelRestoreCriteria) MarshalJSON() ([]byte, error) {
	ilrc.ObjectType = ObjectTypeItemLevelRestoreCriteria
	objectMap := make(map[string]interface{})
	if ilrc.ObjectType != "" {
		objectMap["objectType"] = ilrc.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsRangeBasedItemLevelRestoreCriteria is the BasicItemLevelRestoreCriteria implementation for ItemLevelRestoreCriteria.
func (ilrc ItemLevelRestoreCriteria) AsRangeBasedItemLevelRestoreCriteria() (*RangeBasedItemLevelRestoreCriteria, bool) {
	return nil, false
}

// AsItemLevelRestoreCriteria is the BasicItemLevelRestoreCriteria implementation for ItemLevelRestoreCriteria.
func (ilrc ItemLevelRestoreCriteria) AsItemLevelRestoreCriteria() (*ItemLevelRestoreCriteria, bool) {
	return &ilrc, true
}

// AsBasicItemLevelRestoreCriteria is the BasicItemLevelRestoreCriteria implementation for ItemLevelRestoreCriteria.
func (ilrc ItemLevelRestoreCriteria) AsBasicItemLevelRestoreCriteria() (BasicItemLevelRestoreCriteria, bool) {
	return &ilrc, true
}

// ItemLevelRestoreTargetInfo restore target info for Item level restore operation
type ItemLevelRestoreTargetInfo struct {
	// RestoreCriteria - Restore Criteria
	RestoreCriteria *[]BasicItemLevelRestoreCriteria `json:"restoreCriteria,omitempty"`
	// DatasourceInfo - Information of target DS
	DatasourceInfo *Datasource `json:"datasourceInfo,omitempty"`
	// DatasourceSetInfo - Information of target DS Set
	DatasourceSetInfo *DatasourceSet `json:"datasourceSetInfo,omitempty"`
	// RecoveryOption - Recovery Option
	RecoveryOption *string `json:"recoveryOption,omitempty"`
	// RestoreLocation - Target Restore region
	RestoreLocation *string `json:"restoreLocation,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRestoreTargetInfoBase', 'ObjectTypeItemLevelRestoreTargetInfo', 'ObjectTypeRestoreFilesTargetInfo', 'ObjectTypeRestoreTargetInfo'
	ObjectType ObjectTypeBasicRestoreTargetInfoBase `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for ItemLevelRestoreTargetInfo.
func (ilrti ItemLevelRestoreTargetInfo) MarshalJSON() ([]byte, error) {
	ilrti.ObjectType = ObjectTypeItemLevelRestoreTargetInfo
	objectMap := make(map[string]interface{})
	if ilrti.RestoreCriteria != nil {
		objectMap["restoreCriteria"] = ilrti.RestoreCriteria
	}
	if ilrti.DatasourceInfo != nil {
		objectMap["datasourceInfo"] = ilrti.DatasourceInfo
	}
	if ilrti.DatasourceSetInfo != nil {
		objectMap["datasourceSetInfo"] = ilrti.DatasourceSetInfo
	}
	if ilrti.RecoveryOption != nil {
		objectMap["recoveryOption"] = ilrti.RecoveryOption
	}
	if ilrti.RestoreLocation != nil {
		objectMap["restoreLocation"] = ilrti.RestoreLocation
	}
	if ilrti.ObjectType != "" {
		objectMap["objectType"] = ilrti.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsItemLevelRestoreTargetInfo is the BasicRestoreTargetInfoBase implementation for ItemLevelRestoreTargetInfo.
func (ilrti ItemLevelRestoreTargetInfo) AsItemLevelRestoreTargetInfo() (*ItemLevelRestoreTargetInfo, bool) {
	return &ilrti, true
}

// AsRestoreFilesTargetInfo is the BasicRestoreTargetInfoBase implementation for ItemLevelRestoreTargetInfo.
func (ilrti ItemLevelRestoreTargetInfo) AsRestoreFilesTargetInfo() (*RestoreFilesTargetInfo, bool) {
	return nil, false
}

// AsRestoreTargetInfo is the BasicRestoreTargetInfoBase implementation for ItemLevelRestoreTargetInfo.
func (ilrti ItemLevelRestoreTargetInfo) AsRestoreTargetInfo() (*RestoreTargetInfo, bool) {
	return nil, false
}

// AsRestoreTargetInfoBase is the BasicRestoreTargetInfoBase implementation for ItemLevelRestoreTargetInfo.
func (ilrti ItemLevelRestoreTargetInfo) AsRestoreTargetInfoBase() (*RestoreTargetInfoBase, bool) {
	return nil, false
}

// AsBasicRestoreTargetInfoBase is the BasicRestoreTargetInfoBase implementation for ItemLevelRestoreTargetInfo.
func (ilrti ItemLevelRestoreTargetInfo) AsBasicRestoreTargetInfoBase() (BasicRestoreTargetInfoBase, bool) {
	return &ilrti, true
}

// UnmarshalJSON is the custom unmarshaler for ItemLevelRestoreTargetInfo struct.
func (ilrti *ItemLevelRestoreTargetInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "restoreCriteria":
			if v != nil {
				restoreCriteria, err := unmarshalBasicItemLevelRestoreCriteriaArray(*v)
				if err != nil {
					return err
				}
				ilrti.RestoreCriteria = &restoreCriteria
			}
		case "datasourceInfo":
			if v != nil {
				var datasourceInfo Datasource
				err = json.Unmarshal(*v, &datasourceInfo)
				if err != nil {
					return err
				}
				ilrti.DatasourceInfo = &datasourceInfo
			}
		case "datasourceSetInfo":
			if v != nil {
				var datasourceSetInfo DatasourceSet
				err = json.Unmarshal(*v, &datasourceSetInfo)
				if err != nil {
					return err
				}
				ilrti.DatasourceSetInfo = &datasourceSetInfo
			}
		case "recoveryOption":
			if v != nil {
				var recoveryOption string
				err = json.Unmarshal(*v, &recoveryOption)
				if err != nil {
					return err
				}
				ilrti.RecoveryOption = &recoveryOption
			}
		case "restoreLocation":
			if v != nil {
				var restoreLocation string
				err = json.Unmarshal(*v, &restoreLocation)
				if err != nil {
					return err
				}
				ilrti.RestoreLocation = &restoreLocation
			}
		case "objectType":
			if v != nil {
				var objectType ObjectTypeBasicRestoreTargetInfoBase
				err = json.Unmarshal(*v, &objectType)
				if err != nil {
					return err
				}
				ilrti.ObjectType = objectType
			}
		}
	}

	return nil
}

// JobExtendedInfo extended Information about the job
type JobExtendedInfo struct {
	// AdditionalDetails - Job's Additional Details
	AdditionalDetails map[string]*string `json:"additionalDetails"`
	// BackupInstanceState - READ-ONLY; State of the Backup Instance
	BackupInstanceState *string `json:"backupInstanceState,omitempty"`
	// DataTransferredInBytes - READ-ONLY; Number of bytes transferred
	DataTransferredInBytes *float64 `json:"dataTransferredInBytes,omitempty"`
	// RecoveryDestination - READ-ONLY; Destination where restore is done
	RecoveryDestination *string `json:"recoveryDestination,omitempty"`
	// SourceRecoverPoint - READ-ONLY; Details of the Source Recovery Point
	SourceRecoverPoint *RestoreJobRecoveryPointDetails `json:"sourceRecoverPoint,omitempty"`
	// SubTasks - READ-ONLY; List of Sub Tasks of the job
	SubTasks *[]JobSubTask `json:"subTasks,omitempty"`
	// TargetRecoverPoint - READ-ONLY; Details of the Target Recovery Point
	TargetRecoverPoint *RestoreJobRecoveryPointDetails `json:"targetRecoverPoint,omitempty"`
}

// MarshalJSON is the custom marshaler for JobExtendedInfo.
func (jei JobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jei.AdditionalDetails != nil {
		objectMap["additionalDetails"] = jei.AdditionalDetails
	}
	return json.Marshal(objectMap)
}

// JobSubTask details of Job's Sub Task
type JobSubTask struct {
	// AdditionalDetails - Additional details of Sub Tasks
	AdditionalDetails map[string]*string `json:"additionalDetails"`
	// TaskID - Task Id of the Sub Task
	TaskID *int32 `json:"taskId,omitempty"`
	// TaskName - Name of the Sub Task
	TaskName *string `json:"taskName,omitempty"`
	// TaskProgress - READ-ONLY; Progress of the Sub Task
	TaskProgress *string `json:"taskProgress,omitempty"`
	// TaskStatus - Status of the Sub Task
	TaskStatus *string `json:"taskStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for JobSubTask.
func (jst JobSubTask) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jst.AdditionalDetails != nil {
		objectMap["additionalDetails"] = jst.AdditionalDetails
	}
	if jst.TaskID != nil {
		objectMap["taskId"] = jst.TaskID
	}
	if jst.TaskName != nil {
		objectMap["taskName"] = jst.TaskName
	}
	if jst.TaskStatus != nil {
		objectMap["taskStatus"] = jst.TaskStatus
	}
	return json.Marshal(objectMap)
}

// OperationExtendedInfo operation Extended Info
type OperationExtendedInfo struct {
	// ObjectType - This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`
}

// OperationJobExtendedInfo operation Job Extended Info
type OperationJobExtendedInfo struct {
	autorest.Response `json:"-"`
	// JobID - Arm Id of the job created for this operation.
	JobID *string `json:"jobId,omitempty"`
	// ObjectType - This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string `json:"objectType,omitempty"`
}

// OperationResource operation Resource
type OperationResource struct {
	autorest.Response `json:"-"`
	// EndTime - End time of the operation
	EndTime *date.Time `json:"endTime,omitempty"`
	// Error - Required if status == failed or status == canceled. This is the OData v4 error format, used by the RPC and will go into the v2.2 Azure REST API guidelines.
	// The full set of optional properties (e.g. inner errors / details) can be found in the "Error Response" section.
	Error *Error `json:"error,omitempty"`
	// ID - It should match what is used to GET the operation result
	ID *string `json:"id,omitempty"`
	// Name - It must match the last segment of the "id" field, and will typically be a GUID / system generated value
	Name *string `json:"name,omitempty"`
	// Properties - End time of the operation
	Properties *OperationExtendedInfo `json:"properties,omitempty"`
	// StartTime - Start time of the operation
	StartTime *date.Time `json:"startTime,omitempty"`
	Status    *string    `json:"status,omitempty"`
}

// PatchResourceRequestInput patch Request content for Microsoft.DataProtection resources
type PatchResourceRequestInput struct {
	// Identity - Input Managed Identity Details
	Identity *DppIdentityDetails `json:"identity,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PatchResourceRequestInput.
func (prri PatchResourceRequestInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prri.Identity != nil {
		objectMap["identity"] = prri.Identity
	}
	if prri.Tags != nil {
		objectMap["tags"] = prri.Tags
	}
	return json.Marshal(objectMap)
}

// PolicyInfo policy Info in backupInstance
type PolicyInfo struct {
	PolicyID *string `json:"policyId,omitempty"`
	// PolicyVersion - READ-ONLY
	PolicyVersion *string `json:"policyVersion,omitempty"`
	// PolicyParameters - Policy parameters for the backup instance
	PolicyParameters *PolicyParameters `json:"policyParameters,omitempty"`
}

// MarshalJSON is the custom marshaler for PolicyInfo.
func (pi PolicyInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pi.PolicyID != nil {
		objectMap["policyId"] = pi.PolicyID
	}
	if pi.PolicyParameters != nil {
		objectMap["policyParameters"] = pi.PolicyParameters
	}
	return json.Marshal(objectMap)
}

// PolicyParameters parameters in Policy
type PolicyParameters struct {
	// DataStoreParametersList - Gets or sets the DataStore Parameters
	DataStoreParametersList *[]BasicDataStoreParameters `json:"dataStoreParametersList,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for PolicyParameters struct.
func (pp *PolicyParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "dataStoreParametersList":
			if v != nil {
				dataStoreParametersList, err := unmarshalBasicDataStoreParametersArray(*v)
				if err != nil {
					return err
				}
				pp.DataStoreParametersList = &dataStoreParametersList
			}
		}
	}

	return nil
}

// ProtectionStatusDetails protection status details
type ProtectionStatusDetails struct {
	// ErrorDetails - Specifies the protection status error of the resource
	ErrorDetails *UserFacingError `json:"errorDetails,omitempty"`
	// Status - Specifies the protection status of the resource. Possible values include: 'StatusConfiguringProtection', 'StatusConfiguringProtectionFailed', 'StatusProtectionConfigured', 'StatusProtectionStopped', 'StatusSoftDeleted', 'StatusSoftDeleting'
	Status Status `json:"status,omitempty"`
}

// RangeBasedItemLevelRestoreCriteria item Level target info for restore operation
type RangeBasedItemLevelRestoreCriteria struct {
	// MinMatchingValue - minimum value for range prefix match
	MinMatchingValue *string `json:"minMatchingValue,omitempty"`
	// MaxMatchingValue - maximum value for range prefix match
	MaxMatchingValue *string `json:"maxMatchingValue,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeItemLevelRestoreCriteria', 'ObjectTypeRangeBasedItemLevelRestoreCriteria'
	ObjectType ObjectTypeBasicItemLevelRestoreCriteria `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for RangeBasedItemLevelRestoreCriteria.
func (rbilrc RangeBasedItemLevelRestoreCriteria) MarshalJSON() ([]byte, error) {
	rbilrc.ObjectType = ObjectTypeRangeBasedItemLevelRestoreCriteria
	objectMap := make(map[string]interface{})
	if rbilrc.MinMatchingValue != nil {
		objectMap["minMatchingValue"] = rbilrc.MinMatchingValue
	}
	if rbilrc.MaxMatchingValue != nil {
		objectMap["maxMatchingValue"] = rbilrc.MaxMatchingValue
	}
	if rbilrc.ObjectType != "" {
		objectMap["objectType"] = rbilrc.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsRangeBasedItemLevelRestoreCriteria is the BasicItemLevelRestoreCriteria implementation for RangeBasedItemLevelRestoreCriteria.
func (rbilrc RangeBasedItemLevelRestoreCriteria) AsRangeBasedItemLevelRestoreCriteria() (*RangeBasedItemLevelRestoreCriteria, bool) {
	return &rbilrc, true
}

// AsItemLevelRestoreCriteria is the BasicItemLevelRestoreCriteria implementation for RangeBasedItemLevelRestoreCriteria.
func (rbilrc RangeBasedItemLevelRestoreCriteria) AsItemLevelRestoreCriteria() (*ItemLevelRestoreCriteria, bool) {
	return nil, false
}

// AsBasicItemLevelRestoreCriteria is the BasicItemLevelRestoreCriteria implementation for RangeBasedItemLevelRestoreCriteria.
func (rbilrc RangeBasedItemLevelRestoreCriteria) AsBasicItemLevelRestoreCriteria() (BasicItemLevelRestoreCriteria, bool) {
	return &rbilrc, true
}

// RecoveryPointDataStoreDetails recoveryPoint datastore details
type RecoveryPointDataStoreDetails struct {
	CreationTime *date.Time `json:"creationTime,omitempty"`
	ExpiryTime   *date.Time `json:"expiryTime,omitempty"`
	ID           *string    `json:"id,omitempty"`
	MetaData     *string    `json:"metaData,omitempty"`
	State        *string    `json:"state,omitempty"`
	Type         *string    `json:"type,omitempty"`
	Visible      *bool      `json:"visible,omitempty"`
	// RehydrationExpiryTime - READ-ONLY
	RehydrationExpiryTime *date.Time `json:"rehydrationExpiryTime,omitempty"`
	// RehydrationStatus - READ-ONLY; Possible values include: 'CREATEINPROGRESS', 'COMPLETED', 'DELETEINPROGRESS', 'DELETED', 'FAILED'
	RehydrationStatus RehydrationStatus `json:"rehydrationStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPointDataStoreDetails.
func (rpdsd RecoveryPointDataStoreDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpdsd.CreationTime != nil {
		objectMap["creationTime"] = rpdsd.CreationTime
	}
	if rpdsd.ExpiryTime != nil {
		objectMap["expiryTime"] = rpdsd.ExpiryTime
	}
	if rpdsd.ID != nil {
		objectMap["id"] = rpdsd.ID
	}
	if rpdsd.MetaData != nil {
		objectMap["metaData"] = rpdsd.MetaData
	}
	if rpdsd.State != nil {
		objectMap["state"] = rpdsd.State
	}
	if rpdsd.Type != nil {
		objectMap["type"] = rpdsd.Type
	}
	if rpdsd.Visible != nil {
		objectMap["visible"] = rpdsd.Visible
	}
	return json.Marshal(objectMap)
}

// RecoveryPointsFilters ...
type RecoveryPointsFilters struct {
	RestorePointDataStoreID *string `json:"restorePointDataStoreId,omitempty"`
	IsVisible               *bool   `json:"isVisible,omitempty"`
	StartDate               *string `json:"startDate,omitempty"`
	EndDate                 *string `json:"endDate,omitempty"`
	ExtendedInfo            *bool   `json:"extendedInfo,omitempty"`
	RestorePointState       *string `json:"restorePointState,omitempty"`
}

// RestorableTimeRange ...
type RestorableTimeRange struct {
	// StartTime - Start time for the available restore range
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - End time for the available restore range
	EndTime    *string `json:"endTime,omitempty"`
	ObjectType *string `json:"objectType,omitempty"`
}

// RestoreFilesTargetInfo class encapsulating restore as files target parameters
type RestoreFilesTargetInfo struct {
	// TargetDetails - Destination of RestoreAsFiles operation, when destination is not a datasource
	TargetDetails *TargetDetails `json:"targetDetails,omitempty"`
	// RecoveryOption - Recovery Option
	RecoveryOption *string `json:"recoveryOption,omitempty"`
	// RestoreLocation - Target Restore region
	RestoreLocation *string `json:"restoreLocation,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRestoreTargetInfoBase', 'ObjectTypeItemLevelRestoreTargetInfo', 'ObjectTypeRestoreFilesTargetInfo', 'ObjectTypeRestoreTargetInfo'
	ObjectType ObjectTypeBasicRestoreTargetInfoBase `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for RestoreFilesTargetInfo.
func (rfti RestoreFilesTargetInfo) MarshalJSON() ([]byte, error) {
	rfti.ObjectType = ObjectTypeRestoreFilesTargetInfo
	objectMap := make(map[string]interface{})
	if rfti.TargetDetails != nil {
		objectMap["targetDetails"] = rfti.TargetDetails
	}
	if rfti.RecoveryOption != nil {
		objectMap["recoveryOption"] = rfti.RecoveryOption
	}
	if rfti.RestoreLocation != nil {
		objectMap["restoreLocation"] = rfti.RestoreLocation
	}
	if rfti.ObjectType != "" {
		objectMap["objectType"] = rfti.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsItemLevelRestoreTargetInfo is the BasicRestoreTargetInfoBase implementation for RestoreFilesTargetInfo.
func (rfti RestoreFilesTargetInfo) AsItemLevelRestoreTargetInfo() (*ItemLevelRestoreTargetInfo, bool) {
	return nil, false
}

// AsRestoreFilesTargetInfo is the BasicRestoreTargetInfoBase implementation for RestoreFilesTargetInfo.
func (rfti RestoreFilesTargetInfo) AsRestoreFilesTargetInfo() (*RestoreFilesTargetInfo, bool) {
	return &rfti, true
}

// AsRestoreTargetInfo is the BasicRestoreTargetInfoBase implementation for RestoreFilesTargetInfo.
func (rfti RestoreFilesTargetInfo) AsRestoreTargetInfo() (*RestoreTargetInfo, bool) {
	return nil, false
}

// AsRestoreTargetInfoBase is the BasicRestoreTargetInfoBase implementation for RestoreFilesTargetInfo.
func (rfti RestoreFilesTargetInfo) AsRestoreTargetInfoBase() (*RestoreTargetInfoBase, bool) {
	return nil, false
}

// AsBasicRestoreTargetInfoBase is the BasicRestoreTargetInfoBase implementation for RestoreFilesTargetInfo.
func (rfti RestoreFilesTargetInfo) AsBasicRestoreTargetInfoBase() (BasicRestoreTargetInfoBase, bool) {
	return &rfti, true
}

// RestoreJobRecoveryPointDetails ...
type RestoreJobRecoveryPointDetails struct {
	RecoveryPointID   *string    `json:"recoveryPointID,omitempty"`
	RecoveryPointTime *date.Time `json:"recoveryPointTime,omitempty"`
}

// RestoreTargetInfo class encapsulating restore target parameters
type RestoreTargetInfo struct {
	// DatasourceInfo - Information of target DS
	DatasourceInfo *Datasource `json:"datasourceInfo,omitempty"`
	// DatasourceSetInfo - Information of target DS Set
	DatasourceSetInfo *DatasourceSet `json:"datasourceSetInfo,omitempty"`
	// RecoveryOption - Recovery Option
	RecoveryOption *string `json:"recoveryOption,omitempty"`
	// RestoreLocation - Target Restore region
	RestoreLocation *string `json:"restoreLocation,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRestoreTargetInfoBase', 'ObjectTypeItemLevelRestoreTargetInfo', 'ObjectTypeRestoreFilesTargetInfo', 'ObjectTypeRestoreTargetInfo'
	ObjectType ObjectTypeBasicRestoreTargetInfoBase `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for RestoreTargetInfo.
func (rti RestoreTargetInfo) MarshalJSON() ([]byte, error) {
	rti.ObjectType = ObjectTypeRestoreTargetInfo
	objectMap := make(map[string]interface{})
	if rti.DatasourceInfo != nil {
		objectMap["datasourceInfo"] = rti.DatasourceInfo
	}
	if rti.DatasourceSetInfo != nil {
		objectMap["datasourceSetInfo"] = rti.DatasourceSetInfo
	}
	if rti.RecoveryOption != nil {
		objectMap["recoveryOption"] = rti.RecoveryOption
	}
	if rti.RestoreLocation != nil {
		objectMap["restoreLocation"] = rti.RestoreLocation
	}
	if rti.ObjectType != "" {
		objectMap["objectType"] = rti.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsItemLevelRestoreTargetInfo is the BasicRestoreTargetInfoBase implementation for RestoreTargetInfo.
func (rti RestoreTargetInfo) AsItemLevelRestoreTargetInfo() (*ItemLevelRestoreTargetInfo, bool) {
	return nil, false
}

// AsRestoreFilesTargetInfo is the BasicRestoreTargetInfoBase implementation for RestoreTargetInfo.
func (rti RestoreTargetInfo) AsRestoreFilesTargetInfo() (*RestoreFilesTargetInfo, bool) {
	return nil, false
}

// AsRestoreTargetInfo is the BasicRestoreTargetInfoBase implementation for RestoreTargetInfo.
func (rti RestoreTargetInfo) AsRestoreTargetInfo() (*RestoreTargetInfo, bool) {
	return &rti, true
}

// AsRestoreTargetInfoBase is the BasicRestoreTargetInfoBase implementation for RestoreTargetInfo.
func (rti RestoreTargetInfo) AsRestoreTargetInfoBase() (*RestoreTargetInfoBase, bool) {
	return nil, false
}

// AsBasicRestoreTargetInfoBase is the BasicRestoreTargetInfoBase implementation for RestoreTargetInfo.
func (rti RestoreTargetInfo) AsBasicRestoreTargetInfoBase() (BasicRestoreTargetInfoBase, bool) {
	return &rti, true
}

// BasicRestoreTargetInfoBase base class common to RestoreTargetInfo and RestoreFilesTargetInfo
type BasicRestoreTargetInfoBase interface {
	AsItemLevelRestoreTargetInfo() (*ItemLevelRestoreTargetInfo, bool)
	AsRestoreFilesTargetInfo() (*RestoreFilesTargetInfo, bool)
	AsRestoreTargetInfo() (*RestoreTargetInfo, bool)
	AsRestoreTargetInfoBase() (*RestoreTargetInfoBase, bool)
}

// RestoreTargetInfoBase base class common to RestoreTargetInfo and RestoreFilesTargetInfo
type RestoreTargetInfoBase struct {
	// RecoveryOption - Recovery Option
	RecoveryOption *string `json:"recoveryOption,omitempty"`
	// RestoreLocation - Target Restore region
	RestoreLocation *string `json:"restoreLocation,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRestoreTargetInfoBase', 'ObjectTypeItemLevelRestoreTargetInfo', 'ObjectTypeRestoreFilesTargetInfo', 'ObjectTypeRestoreTargetInfo'
	ObjectType ObjectTypeBasicRestoreTargetInfoBase `json:"objectType,omitempty"`
}

func unmarshalBasicRestoreTargetInfoBase(body []byte) (BasicRestoreTargetInfoBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeItemLevelRestoreTargetInfo):
		var ilrti ItemLevelRestoreTargetInfo
		err := json.Unmarshal(body, &ilrti)
		return ilrti, err
	case string(ObjectTypeRestoreFilesTargetInfo):
		var rfti RestoreFilesTargetInfo
		err := json.Unmarshal(body, &rfti)
		return rfti, err
	case string(ObjectTypeRestoreTargetInfo):
		var rti RestoreTargetInfo
		err := json.Unmarshal(body, &rti)
		return rti, err
	default:
		var rtib RestoreTargetInfoBase
		err := json.Unmarshal(body, &rtib)
		return rtib, err
	}
}
func unmarshalBasicRestoreTargetInfoBaseArray(body []byte) ([]BasicRestoreTargetInfoBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rtibArray := make([]BasicRestoreTargetInfoBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rtib, err := unmarshalBasicRestoreTargetInfoBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		rtibArray[index] = rtib
	}
	return rtibArray, nil
}

// MarshalJSON is the custom marshaler for RestoreTargetInfoBase.
func (rtib RestoreTargetInfoBase) MarshalJSON() ([]byte, error) {
	rtib.ObjectType = ObjectTypeRestoreTargetInfoBase
	objectMap := make(map[string]interface{})
	if rtib.RecoveryOption != nil {
		objectMap["recoveryOption"] = rtib.RecoveryOption
	}
	if rtib.RestoreLocation != nil {
		objectMap["restoreLocation"] = rtib.RestoreLocation
	}
	if rtib.ObjectType != "" {
		objectMap["objectType"] = rtib.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsItemLevelRestoreTargetInfo is the BasicRestoreTargetInfoBase implementation for RestoreTargetInfoBase.
func (rtib RestoreTargetInfoBase) AsItemLevelRestoreTargetInfo() (*ItemLevelRestoreTargetInfo, bool) {
	return nil, false
}

// AsRestoreFilesTargetInfo is the BasicRestoreTargetInfoBase implementation for RestoreTargetInfoBase.
func (rtib RestoreTargetInfoBase) AsRestoreFilesTargetInfo() (*RestoreFilesTargetInfo, bool) {
	return nil, false
}

// AsRestoreTargetInfo is the BasicRestoreTargetInfoBase implementation for RestoreTargetInfoBase.
func (rtib RestoreTargetInfoBase) AsRestoreTargetInfo() (*RestoreTargetInfo, bool) {
	return nil, false
}

// AsRestoreTargetInfoBase is the BasicRestoreTargetInfoBase implementation for RestoreTargetInfoBase.
func (rtib RestoreTargetInfoBase) AsRestoreTargetInfoBase() (*RestoreTargetInfoBase, bool) {
	return &rtib, true
}

// AsBasicRestoreTargetInfoBase is the BasicRestoreTargetInfoBase implementation for RestoreTargetInfoBase.
func (rtib RestoreTargetInfoBase) AsBasicRestoreTargetInfoBase() (BasicRestoreTargetInfoBase, bool) {
	return &rtib, true
}

// RetentionTag retention tag
type RetentionTag struct {
	// ETag - READ-ONLY; Retention Tag version.
	ETag *string `json:"eTag,omitempty"`
	// ID - READ-ONLY; Retention Tag version.
	ID *string `json:"id,omitempty"`
	// TagName - Retention Tag Name to relate it to retention rule.
	TagName *string `json:"tagName,omitempty"`
}

// MarshalJSON is the custom marshaler for RetentionTag.
func (rt RetentionTag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rt.TagName != nil {
		objectMap["tagName"] = rt.TagName
	}
	return json.Marshal(objectMap)
}

// ScheduleBasedBackupCriteria schedule based backup criteria
type ScheduleBasedBackupCriteria struct {
	// AbsoluteCriteria - it contains absolute values like "AllBackup" / "FirstOfDay" / "FirstOfWeek" / "FirstOfMonth"
	// and should be part of AbsoluteMarker enum
	AbsoluteCriteria *[]AbsoluteMarker `json:"absoluteCriteria,omitempty"`
	// DaysOfMonth - This is day of the month from 1 to 28 other wise last of month
	DaysOfMonth *[]Day `json:"daysOfMonth,omitempty"`
	// DaysOfTheWeek - It should be Sunday/Monday/T..../Saturday
	DaysOfTheWeek *[]DayOfWeek `json:"daysOfTheWeek,omitempty"`
	// MonthsOfYear - It should be January/February/....../December
	MonthsOfYear *[]Month `json:"monthsOfYear,omitempty"`
	// ScheduleTimes - List of schedule times for backup
	ScheduleTimes *[]date.Time `json:"scheduleTimes,omitempty"`
	// WeeksOfTheMonth - It should be First/Second/Third/Fourth/Last
	WeeksOfTheMonth *[]WeekNumber `json:"weeksOfTheMonth,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeBackupCriteria', 'ObjectTypeScheduleBasedBackupCriteria'
	ObjectType ObjectTypeBasicBackupCriteria `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduleBasedBackupCriteria.
func (sbbc ScheduleBasedBackupCriteria) MarshalJSON() ([]byte, error) {
	sbbc.ObjectType = ObjectTypeScheduleBasedBackupCriteria
	objectMap := make(map[string]interface{})
	if sbbc.AbsoluteCriteria != nil {
		objectMap["absoluteCriteria"] = sbbc.AbsoluteCriteria
	}
	if sbbc.DaysOfMonth != nil {
		objectMap["daysOfMonth"] = sbbc.DaysOfMonth
	}
	if sbbc.DaysOfTheWeek != nil {
		objectMap["daysOfTheWeek"] = sbbc.DaysOfTheWeek
	}
	if sbbc.MonthsOfYear != nil {
		objectMap["monthsOfYear"] = sbbc.MonthsOfYear
	}
	if sbbc.ScheduleTimes != nil {
		objectMap["scheduleTimes"] = sbbc.ScheduleTimes
	}
	if sbbc.WeeksOfTheMonth != nil {
		objectMap["weeksOfTheMonth"] = sbbc.WeeksOfTheMonth
	}
	if sbbc.ObjectType != "" {
		objectMap["objectType"] = sbbc.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsScheduleBasedBackupCriteria is the BasicBackupCriteria implementation for ScheduleBasedBackupCriteria.
func (sbbc ScheduleBasedBackupCriteria) AsScheduleBasedBackupCriteria() (*ScheduleBasedBackupCriteria, bool) {
	return &sbbc, true
}

// AsBackupCriteria is the BasicBackupCriteria implementation for ScheduleBasedBackupCriteria.
func (sbbc ScheduleBasedBackupCriteria) AsBackupCriteria() (*BackupCriteria, bool) {
	return nil, false
}

// AsBasicBackupCriteria is the BasicBackupCriteria implementation for ScheduleBasedBackupCriteria.
func (sbbc ScheduleBasedBackupCriteria) AsBasicBackupCriteria() (BasicBackupCriteria, bool) {
	return &sbbc, true
}

// ScheduleBasedTriggerContext schedule based trigger context
type ScheduleBasedTriggerContext struct {
	// Schedule - Schedule for this backup
	Schedule *BackupSchedule `json:"schedule,omitempty"`
	// TaggingCriteria - List of tags that can be applicable for given schedule.
	TaggingCriteria *[]TaggingCriteria `json:"taggingCriteria,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeTriggerContext', 'ObjectTypeAdhocBasedTriggerContext', 'ObjectTypeScheduleBasedTriggerContext'
	ObjectType ObjectTypeBasicTriggerContext `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduleBasedTriggerContext.
func (sbtc ScheduleBasedTriggerContext) MarshalJSON() ([]byte, error) {
	sbtc.ObjectType = ObjectTypeScheduleBasedTriggerContext
	objectMap := make(map[string]interface{})
	if sbtc.Schedule != nil {
		objectMap["schedule"] = sbtc.Schedule
	}
	if sbtc.TaggingCriteria != nil {
		objectMap["taggingCriteria"] = sbtc.TaggingCriteria
	}
	if sbtc.ObjectType != "" {
		objectMap["objectType"] = sbtc.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAdhocBasedTriggerContext is the BasicTriggerContext implementation for ScheduleBasedTriggerContext.
func (sbtc ScheduleBasedTriggerContext) AsAdhocBasedTriggerContext() (*AdhocBasedTriggerContext, bool) {
	return nil, false
}

// AsScheduleBasedTriggerContext is the BasicTriggerContext implementation for ScheduleBasedTriggerContext.
func (sbtc ScheduleBasedTriggerContext) AsScheduleBasedTriggerContext() (*ScheduleBasedTriggerContext, bool) {
	return &sbtc, true
}

// AsTriggerContext is the BasicTriggerContext implementation for ScheduleBasedTriggerContext.
func (sbtc ScheduleBasedTriggerContext) AsTriggerContext() (*TriggerContext, bool) {
	return nil, false
}

// AsBasicTriggerContext is the BasicTriggerContext implementation for ScheduleBasedTriggerContext.
func (sbtc ScheduleBasedTriggerContext) AsBasicTriggerContext() (BasicTriggerContext, bool) {
	return &sbtc, true
}

// SourceLifeCycle source LifeCycle
type SourceLifeCycle struct {
	DeleteAfter                 BasicDeleteOption    `json:"deleteAfter,omitempty"`
	SourceDataStore             *DataStoreInfoBase   `json:"sourceDataStore,omitempty"`
	TargetDataStoreCopySettings *[]TargetCopySetting `json:"targetDataStoreCopySettings,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SourceLifeCycle struct.
func (slc *SourceLifeCycle) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "deleteAfter":
			if v != nil {
				deleteAfter, err := unmarshalBasicDeleteOption(*v)
				if err != nil {
					return err
				}
				slc.DeleteAfter = deleteAfter
			}
		case "sourceDataStore":
			if v != nil {
				var sourceDataStore DataStoreInfoBase
				err = json.Unmarshal(*v, &sourceDataStore)
				if err != nil {
					return err
				}
				slc.SourceDataStore = &sourceDataStore
			}
		case "targetDataStoreCopySettings":
			if v != nil {
				var targetDataStoreCopySettings []TargetCopySetting
				err = json.Unmarshal(*v, &targetDataStoreCopySettings)
				if err != nil {
					return err
				}
				slc.TargetDataStoreCopySettings = &targetDataStoreCopySettings
			}
		}
	}

	return nil
}

// StorageSetting storage setting
type StorageSetting struct {
	// DatastoreType - Gets or sets the type of the datastore. Possible values include: 'StorageSettingStoreTypesArchiveStore', 'StorageSettingStoreTypesSnapshotStore', 'StorageSettingStoreTypesVaultStore'
	DatastoreType StorageSettingStoreTypes `json:"datastoreType,omitempty"`
	// Type - Gets or sets the type. Possible values include: 'GeoRedundant', 'LocallyRedundant'
	Type StorageSettingTypes `json:"type,omitempty"`
}

// SupportedFeature elements class for feature request
type SupportedFeature struct {
	// FeatureName - support feature type.
	FeatureName *string `json:"featureName,omitempty"`
	// SupportStatus - feature support status. Possible values include: 'FeatureSupportStatusInvalid', 'FeatureSupportStatusNotSupported', 'FeatureSupportStatusAlphaPreview', 'FeatureSupportStatusPrivatePreview', 'FeatureSupportStatusPublicPreview', 'FeatureSupportStatusGenerallyAvailable'
	SupportStatus FeatureSupportStatus `json:"supportStatus,omitempty"`
	// ExposureControlledFeatures - support feature type.
	ExposureControlledFeatures *[]string `json:"exposureControlledFeatures,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The type of identity that last modified the resource.
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TaggingCriteria tagging criteria
type TaggingCriteria struct {
	// Criteria - Criteria which decides whether the tag can be applied to a triggered backup.
	Criteria *[]BasicBackupCriteria `json:"criteria,omitempty"`
	// IsDefault - Specifies if tag is default.
	IsDefault *bool `json:"isDefault,omitempty"`
	// TaggingPriority - Retention Tag priority.
	TaggingPriority *int64 `json:"taggingPriority,omitempty"`
	// TagInfo - Retention tag information
	TagInfo *RetentionTag `json:"tagInfo,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for TaggingCriteria struct.
func (tc *TaggingCriteria) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "criteria":
			if v != nil {
				criteria, err := unmarshalBasicBackupCriteriaArray(*v)
				if err != nil {
					return err
				}
				tc.Criteria = &criteria
			}
		case "isDefault":
			if v != nil {
				var isDefault bool
				err = json.Unmarshal(*v, &isDefault)
				if err != nil {
					return err
				}
				tc.IsDefault = &isDefault
			}
		case "taggingPriority":
			if v != nil {
				var taggingPriority int64
				err = json.Unmarshal(*v, &taggingPriority)
				if err != nil {
					return err
				}
				tc.TaggingPriority = &taggingPriority
			}
		case "tagInfo":
			if v != nil {
				var tagInfo RetentionTag
				err = json.Unmarshal(*v, &tagInfo)
				if err != nil {
					return err
				}
				tc.TagInfo = &tagInfo
			}
		}
	}

	return nil
}

// TargetCopySetting target copy settings
type TargetCopySetting struct {
	// CopyAfter - It can be CustomCopyOption or ImmediateCopyOption.
	CopyAfter BasicCopyOption `json:"copyAfter,omitempty"`
	// DataStore - Info of target datastore
	DataStore *DataStoreInfoBase `json:"dataStore,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for TargetCopySetting struct.
func (tcs *TargetCopySetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "copyAfter":
			if v != nil {
				copyAfter, err := unmarshalBasicCopyOption(*v)
				if err != nil {
					return err
				}
				tcs.CopyAfter = copyAfter
			}
		case "dataStore":
			if v != nil {
				var dataStore DataStoreInfoBase
				err = json.Unmarshal(*v, &dataStore)
				if err != nil {
					return err
				}
				tcs.DataStore = &dataStore
			}
		}
	}

	return nil
}

// TargetDetails class encapsulating target details, used where the destination is not a datasource
type TargetDetails struct {
	// FilePrefix - Restore operation may create multiple files inside location pointed by Url
	// Below will be the common prefix for all of them
	FilePrefix *string `json:"filePrefix,omitempty"`
	// RestoreTargetLocationType - Denotes the target location where the data will be restored,
	// string value for the enum {Microsoft.Internal.AzureBackup.DataProtection.Common.Interface.RestoreTargetLocationType}. Possible values include: 'RestoreTargetLocationTypeInvalid', 'RestoreTargetLocationTypeAzureBlobs', 'RestoreTargetLocationTypeAzureFiles'
	RestoreTargetLocationType RestoreTargetLocationType `json:"restoreTargetLocationType,omitempty"`
	// URL - Url denoting the restore destination. It can point to container / file share etc
	URL *string `json:"url,omitempty"`
}

// TriggerBackupRequest trigger backup request
type TriggerBackupRequest struct {
	// BackupRuleOptions - Name for the Rule of the Policy which needs to be applied for this backup
	BackupRuleOptions *AdHocBackupRuleOptions `json:"backupRuleOptions,omitempty"`
}

// BasicTriggerContext trigger context
type BasicTriggerContext interface {
	AsAdhocBasedTriggerContext() (*AdhocBasedTriggerContext, bool)
	AsScheduleBasedTriggerContext() (*ScheduleBasedTriggerContext, bool)
	AsTriggerContext() (*TriggerContext, bool)
}

// TriggerContext trigger context
type TriggerContext struct {
	// ObjectType - Possible values include: 'ObjectTypeTriggerContext', 'ObjectTypeAdhocBasedTriggerContext', 'ObjectTypeScheduleBasedTriggerContext'
	ObjectType ObjectTypeBasicTriggerContext `json:"objectType,omitempty"`
}

func unmarshalBasicTriggerContext(body []byte) (BasicTriggerContext, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeAdhocBasedTriggerContext):
		var abtc AdhocBasedTriggerContext
		err := json.Unmarshal(body, &abtc)
		return abtc, err
	case string(ObjectTypeScheduleBasedTriggerContext):
		var sbtc ScheduleBasedTriggerContext
		err := json.Unmarshal(body, &sbtc)
		return sbtc, err
	default:
		var tc TriggerContext
		err := json.Unmarshal(body, &tc)
		return tc, err
	}
}
func unmarshalBasicTriggerContextArray(body []byte) ([]BasicTriggerContext, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tcArray := make([]BasicTriggerContext, len(rawMessages))

	for index, rawMessage := range rawMessages {
		tc, err := unmarshalBasicTriggerContext(*rawMessage)
		if err != nil {
			return nil, err
		}
		tcArray[index] = tc
	}
	return tcArray, nil
}

// MarshalJSON is the custom marshaler for TriggerContext.
func (tc TriggerContext) MarshalJSON() ([]byte, error) {
	tc.ObjectType = ObjectTypeTriggerContext
	objectMap := make(map[string]interface{})
	if tc.ObjectType != "" {
		objectMap["objectType"] = tc.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsAdhocBasedTriggerContext is the BasicTriggerContext implementation for TriggerContext.
func (tc TriggerContext) AsAdhocBasedTriggerContext() (*AdhocBasedTriggerContext, bool) {
	return nil, false
}

// AsScheduleBasedTriggerContext is the BasicTriggerContext implementation for TriggerContext.
func (tc TriggerContext) AsScheduleBasedTriggerContext() (*ScheduleBasedTriggerContext, bool) {
	return nil, false
}

// AsTriggerContext is the BasicTriggerContext implementation for TriggerContext.
func (tc TriggerContext) AsTriggerContext() (*TriggerContext, bool) {
	return &tc, true
}

// AsBasicTriggerContext is the BasicTriggerContext implementation for TriggerContext.
func (tc TriggerContext) AsBasicTriggerContext() (BasicTriggerContext, bool) {
	return &tc, true
}

// UserFacingError error object used by layers that have access to localized content, and propagate that to
// user
type UserFacingError struct {
	// Code - Unique code for this error
	Code *string `json:"code,omitempty"`
	// Details - Additional related Errors
	Details *[]UserFacingError `json:"details,omitempty"`
	// InnerError - Inner Error
	InnerError *InnerError `json:"innerError,omitempty"`
	// IsRetryable - Whether the operation will be retryable or not
	IsRetryable *bool `json:"isRetryable,omitempty"`
	// IsUserError - Whether the operation is due to a user error or service error
	IsUserError *bool `json:"isUserError,omitempty"`
	// Properties - Any key value pairs that can be injected inside error object
	Properties map[string]*string `json:"properties"`
	Message    *string            `json:"message,omitempty"`
	// RecommendedAction - RecommendedAction � localized.
	RecommendedAction *[]string `json:"recommendedAction,omitempty"`
	// Target - Target of the error.
	Target *string `json:"target,omitempty"`
}

// MarshalJSON is the custom marshaler for UserFacingError.
func (ufe UserFacingError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ufe.Code != nil {
		objectMap["code"] = ufe.Code
	}
	if ufe.Details != nil {
		objectMap["details"] = ufe.Details
	}
	if ufe.InnerError != nil {
		objectMap["innerError"] = ufe.InnerError
	}
	if ufe.IsRetryable != nil {
		objectMap["isRetryable"] = ufe.IsRetryable
	}
	if ufe.IsUserError != nil {
		objectMap["isUserError"] = ufe.IsUserError
	}
	if ufe.Properties != nil {
		objectMap["properties"] = ufe.Properties
	}
	if ufe.Message != nil {
		objectMap["message"] = ufe.Message
	}
	if ufe.RecommendedAction != nil {
		objectMap["recommendedAction"] = ufe.RecommendedAction
	}
	if ufe.Target != nil {
		objectMap["target"] = ufe.Target
	}
	return json.Marshal(objectMap)
}

// ValidateForBackupRequest validate for backup request
type ValidateForBackupRequest struct {
	BackupInstance *BackupInstance `json:"backupInstance,omitempty"`
}

// ValidateRestoreRequestObject validate restore request object
type ValidateRestoreRequestObject struct {
	// RestoreRequestObject - Gets or sets the restore request object.
	RestoreRequestObject BasicAzureBackupRestoreRequest `json:"restoreRequestObject,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ValidateRestoreRequestObject struct.
func (vrro *ValidateRestoreRequestObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "restoreRequestObject":
			if v != nil {
				restoreRequestObject, err := unmarshalBasicAzureBackupRestoreRequest(*v)
				if err != nil {
					return err
				}
				vrro.RestoreRequestObject = restoreRequestObject
			}
		}
	}

	return nil
}
